require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_TOPOLOGY_H)) {
    eval 'sub _ASM_POWERPC_TOPOLOGY_H () {1;}' unless defined(&_ASM_POWERPC_TOPOLOGY_H);
    if(defined(&__KERNEL__)) {
	if(defined(&CONFIG_NUMA)) {
	    require 'asm/mmzone.ph';
	    eval 'sub cpu_to_node {
	        my($cpu) = @_;
    		eval q({  $numa_cpu_lookup_table[$cpu]; });
	    }' unless defined(&cpu_to_node);
	    eval 'sub parent_node {
	        my($node) = @_;
    		eval q(($node));
	    }' unless defined(&parent_node);
	    eval 'sub node_to_cpumask {
	        my($node) = @_;
    		eval q({  $numa_cpumask_lookup_table[$node]; });
	    }' unless defined(&node_to_cpumask);
	    eval 'sub node_to_first_cpu {
	        my($node) = @_;
    		eval q({  &cpumask_t  &tmp;  &tmp =  &node_to_cpumask($node);  &first_cpu( &tmp); });
	    }' unless defined(&node_to_first_cpu);
	    eval 'sub pcibus_to_cpumask {
	        my($bus) = @_;
    		eval q(( &pcibus_to_node($bus) == -1?  &CPU_MASK_ALL :  &node_to_cpumask( &pcibus_to_node($bus)) ));
	    }' unless defined(&pcibus_to_cpumask);
	    eval 'sub SD_NODE_INIT () { { . &span =  &CPU_MASK_NONE, . &parent =  &NULL, . &groups =  &NULL, . &min_interval = 8, . &max_interval = 32, . &busy_factor = 32, . &imbalance_pct = 125, . &cache_nice_tries = 1, . &per_cpu_gain = 100, . &busy_idx = 3, . &idle_idx = 1, . &newidle_idx = 2, . &wake_idx = 1, . &flags =  &SD_LOAD_BALANCE |  &SD_BALANCE_EXEC |  &SD_BALANCE_NEWIDLE |  &SD_WAKE_IDLE |  &SD_WAKE_BALANCE, . &last_balance =  &jiffies, . &balance_interval = 1, . &nr_balance_failed = 0, };}' unless defined(&SD_NODE_INIT);
	} else {
	    eval 'sub of_node_to_nid {
	        my($device) = @_;
    		eval q({ 0; });
	    }' unless defined(&of_node_to_nid);
	    eval 'sub sysfs_add_device_to_node {
	        my($dev,$nid) = @_;
    		eval q({ 0; });
	    }' unless defined(&sysfs_add_device_to_node);
	    eval 'sub sysfs_remove_device_from_node {
	        my($dev,$nid) = @_;
    		eval q({ });
	    }' unless defined(&sysfs_remove_device_from_node);
	    require 'asm-generic/topology.ph';
	}
	if(defined(&CONFIG_SMP)) {
	    require 'asm/cputable.ph';
	    eval 'sub smt_capable () {
	        eval q(( &cpu_has_feature( &CPU_FTR_SMT)));
	    }' unless defined(&smt_capable);
	}
    }
}
1;
