require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_SMP_H)) {
    eval 'sub __LINUX_SMP_H () {1;}' unless defined(&__LINUX_SMP_H);
    if(defined(&CONFIG_SMP)) {
	require 'linux/preempt.ph';
	require 'linux/kernel.ph';
	require 'linux/compiler.ph';
	require 'linux/thread_info.ph';
	require 'asm/smp.ph';
	eval 'sub MSG_ALL_BUT_SELF () {0x8000;}' unless defined(&MSG_ALL_BUT_SELF);
	eval 'sub MSG_ALL () {0x8001;}' unless defined(&MSG_ALL);
	eval 'sub MSG_INVALIDATE_TLB () {0x1;}' unless defined(&MSG_INVALIDATE_TLB);
	eval 'sub MSG_STOP_CPU () {0x2;}' unless defined(&MSG_STOP_CPU);
	eval 'sub MSG_RESCHEDULE () {0x3;}' unless defined(&MSG_RESCHEDULE);
	eval 'sub MSG_CALL_FUNCTION () {0x4;}' unless defined(&MSG_CALL_FUNCTION);
    } else {
	eval 'sub raw_smp_processor_id () {
	    eval q(0);
	}' unless defined(&raw_smp_processor_id);
	eval 'sub hard_smp_processor_id () {
	    eval q(0);
	}' unless defined(&hard_smp_processor_id);
	eval 'sub up_smp_call_function {
	    my($void) = @_;
    	    eval q({ 0; });
	}' unless defined(&up_smp_call_function);
	eval 'sub smp_call_function {
	    my($func,$info,$retry,$wait) = @_;
    	    eval q(( &up_smp_call_function()));
	}' unless defined(&smp_call_function);
	eval 'sub on_each_cpu {
	    my($func,$info,$retry,$wait) = @_;
    	    eval q(({  &local_irq_disable(); $func($info);  &local_irq_enable(); 0; }));
	}' unless defined(&on_each_cpu);
	eval 'sub num_booting_cpus () {
	    eval q(1);
	}' unless defined(&num_booting_cpus);
	eval 'sub smp_prepare_boot_cpu () {
	    eval q( &do {}  &while (0));
	}' unless defined(&smp_prepare_boot_cpu);
    }
    if(defined(&CONFIG_DEBUG_PREEMPT)) {
	eval 'sub smp_processor_id () {
	    eval q( &debug_smp_processor_id());
	}' unless defined(&smp_processor_id);
    } else {
	eval 'sub smp_processor_id () {
	    eval q( &raw_smp_processor_id());
	}' unless defined(&smp_processor_id);
    }
    eval 'sub get_cpu () {
        eval q(({  &preempt_disable();  &smp_processor_id(); }));
    }' unless defined(&get_cpu);
    eval 'sub put_cpu () {
        eval q( &preempt_enable());
    }' unless defined(&put_cpu);
    eval 'sub put_cpu_no_resched () {
        eval q( &preempt_enable_no_resched());
    }' unless defined(&put_cpu_no_resched);
}
1;
