require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__POWERPC_CPUTIME_H)) {
    eval 'sub __POWERPC_CPUTIME_H () {1;}' unless defined(&__POWERPC_CPUTIME_H);
    unless(defined(&CONFIG_VIRT_CPU_ACCOUNTING)) {
	require 'asm-generic/cputime.ph';
    } else {
	require 'linux/types.ph';
	require 'linux/time.ph';
	require 'asm/div64.ph';
	require 'asm/time.ph';
	require 'asm/param.ph';
	eval 'sub cputime_zero () {(( &cputime_t)0);}' unless defined(&cputime_zero);
	eval 'sub cputime_max () {((~(( &cputime_t)0) >> 1) - 1);}' unless defined(&cputime_max);
	eval 'sub cputime_add {
	    my($__a, $__b) = @_;
    	    eval q((($__a) + ($__b)));
	}' unless defined(&cputime_add);
	eval 'sub cputime_sub {
	    my($__a, $__b) = @_;
    	    eval q((($__a) - ($__b)));
	}' unless defined(&cputime_sub);
	eval 'sub cputime_div {
	    my($__a, $__n) = @_;
    	    eval q((($__a) / ($__n)));
	}' unless defined(&cputime_div);
	eval 'sub cputime_halve {
	    my($__a) = @_;
    	    eval q((($__a) >> 1));
	}' unless defined(&cputime_halve);
	eval 'sub cputime_eq {
	    my($__a, $__b) = @_;
    	    eval q((($__a) == ($__b)));
	}' unless defined(&cputime_eq);
	eval 'sub cputime_gt {
	    my($__a, $__b) = @_;
    	    eval q((($__a) > ($__b)));
	}' unless defined(&cputime_gt);
	eval 'sub cputime_ge {
	    my($__a, $__b) = @_;
    	    eval q((($__a) >= ($__b)));
	}' unless defined(&cputime_ge);
	eval 'sub cputime_lt {
	    my($__a, $__b) = @_;
    	    eval q((($__a) < ($__b)));
	}' unless defined(&cputime_lt);
	eval 'sub cputime_le {
	    my($__a, $__b) = @_;
    	    eval q((($__a) <= ($__b)));
	}' unless defined(&cputime_le);
	eval 'sub cputime64_zero () {(( &cputime64_t)0);}' unless defined(&cputime64_zero);
	eval 'sub cputime64_add {
	    my($__a, $__b) = @_;
    	    eval q((($__a) + ($__b)));
	}' unless defined(&cputime64_add);
	eval 'sub cputime64_sub {
	    my($__a, $__b) = @_;
    	    eval q((($__a) - ($__b)));
	}' unless defined(&cputime64_sub);
	eval 'sub cputime_to_cputime64 {
	    my($__ct) = @_;
    	    eval q(($__ct));
	}' unless defined(&cputime_to_cputime64);
	if(defined(&__KERNEL__)) {
	    eval 'sub cputime_to_jiffies {
	        my($ct) = @_;
    		eval q({  &mulhdu($ct,  &__cputime_jiffies_factor); });
	    }' unless defined(&cputime_to_jiffies);
	    eval 'sub jiffies_to_cputime {
	        my($jif) = @_;
    		eval q({  &cputime_t  &ct; my $sec;  &ct = $jif %  &HZ;  $sec = $jif /  &HZ;  &if ( &ct) {  &ct *=  &tb_ticks_per_sec;  &do_div( &ct,  &HZ); }  &if ( $sec)  &ct += ( &cputime_t)  $sec *  &tb_ticks_per_sec;  &ct; });
	    }' unless defined(&jiffies_to_cputime);
	    eval 'sub jiffies64_to_cputime64 {
	        my($jif) = @_;
    		eval q({  &cputime_t  &ct;  &u64  &sec;  &ct = $jif %  &HZ;  &sec = $jif /  &HZ;  &if ( &ct) {  &ct *=  &tb_ticks_per_sec;  &do_div( &ct,  &HZ); }  &if ( &sec)  &ct += ( &cputime_t)  &sec *  &tb_ticks_per_sec;  &ct; });
	    }' unless defined(&jiffies64_to_cputime64);
	    eval 'sub cputime64_to_jiffies64 {
	        my($ct) = @_;
    		eval q({  &mulhdu($ct,  &__cputime_jiffies_factor); });
	    }' unless defined(&cputime64_to_jiffies64);
	    eval 'sub cputime_to_msecs {
	        my($ct) = @_;
    		eval q({  &mulhdu($ct,  &__cputime_msec_factor); });
	    }' unless defined(&cputime_to_msecs);
	    eval 'sub msecs_to_cputime {
	        my($ms) = @_;
    		eval q({  &cputime_t  &ct; my $sec;  &ct = $ms % 1000;  $sec = $ms / 1000;  &if ( &ct) {  &ct *=  &tb_ticks_per_sec;  &do_div( &ct, 1000); }  &if ( $sec)  &ct += ( &cputime_t)  $sec *  &tb_ticks_per_sec;  &ct; });
	    }' unless defined(&msecs_to_cputime);
	    eval 'sub cputime_to_secs {
	        my($ct) = @_;
    		eval q({  &mulhdu($ct,  &__cputime_sec_factor); });
	    }' unless defined(&cputime_to_secs);
	    eval 'sub secs_to_cputime {
	        my($sec) = @_;
    		eval q({ ( &cputime_t) $sec *  &tb_ticks_per_sec; });
	    }' unless defined(&secs_to_cputime);
	    eval 'sub timespec_to_cputime {
	        my($p) = @_;
    		eval q({  &cputime_t  &ct;  &ct = ( &u64)  ($p->{tv_nsec}) *  &tb_ticks_per_sec;  &do_div( &ct, 1000000000);  &ct + ( &u64)  ($p->{tv_sec}) *  &tb_ticks_per_sec; });
	    }' unless defined(&timespec_to_cputime);
	    eval 'sub timeval_to_cputime {
	        my($p) = @_;
    		eval q({  &cputime_t  &ct;  &ct = ( &u64)  ($p->{tv_usec}) *  &tb_ticks_per_sec;  &do_div( &ct, 1000000);  &ct + ( &u64)  ($p->{tv_sec}) *  &tb_ticks_per_sec; });
	    }' unless defined(&timeval_to_cputime);
	    eval 'sub cputime_to_clock_t {
	        my($ct) = @_;
    		eval q({  &mulhdu($ct,  &__cputime_clockt_factor); });
	    }' unless defined(&cputime_to_clock_t);
	    eval 'sub clock_t_to_cputime {
	        my($clk) = @_;
    		eval q({  &cputime_t  &ct; my $sec;  &ct = $clk %  &USER_HZ;  $sec = $clk /  &USER_HZ;  &if ( &ct) {  &ct *=  &tb_ticks_per_sec;  &do_div( &ct,  &USER_HZ); }  &if ( $sec)  &ct += ( &cputime_t)  $sec *  &tb_ticks_per_sec;  &ct; });
	    }' unless defined(&clock_t_to_cputime);
	    eval 'sub cputime64_to_clock_t {
	        my($ct) = @_;
    		eval q( &cputime_to_clock_t(( &cputime_t)($ct)));
	    }' unless defined(&cputime64_to_clock_t);
	}
    }
}
1;
