
sub dc_debconf_select (){
  my $class    = shift;
  my $priority = shift;
  my $question = "shared/packages-$class";
  my $debug    = "yes" if exists $ENV{'DICT_COMMON_DEBUG'};
  my @newchoices = ();
  my @oldchoices = ();
  
  $priority = "critical" if not $priority;
  
  if ( $class eq "ispell" ){
    $title = "Dictionaries-common: Ispell dictionary"; 
  } else {
    $title = "Dictionaries-common: Wordlist dictionary"; 
  }
  
  my ($errorcode,$pkgowners) = metaget ($question, "owners");
  return if $errorcode;
  
  foreach (split (/\s*,\s*/, $pkgowners)){
    my $entry = metaget ("$_/languages", "default");
    for ( $entry ){ # trim leading/trailing whitespaces the perlfaq way
	    s/^\s+//;
	    s/\s+$//;
	  }
    push (@newchoices, split(/\s*,\s*/, $entry));
  }
  my $choices = join (', ', sort {lc $a cmp lc $b} @newchoices);
  
  $question = "dictionaries-common/default-$class";
  @oldchoices = split(/\s*,\s*/,metaget ($question, "choices"));
  pop @oldchoices;
  my $oldchoices = join (', ', @oldchoices);
  print STDERR "** dictionaries-common: $class, $priority, $question\n" .
      "new:[$choices]\nold:[$oldchoices]\n" if $debug;
  unless ( scalar @newchoices == 0 ) { 
    if ( $choices ne $oldchoices ) {
      subst ($question, "choices", $choices);
      fset ($question, "seen", "false");
    }   
    input ($priority, $question);
    title ($title);
    go ();
    }
}

#Local Variables:
#perl-indent-level: 2
#End:

1;

