require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ARCH_POWERPC_UACCESS_H)) {
    eval 'sub _ARCH_POWERPC_UACCESS_H () {1;}' unless defined(&_ARCH_POWERPC_UACCESS_H);
    if(defined(&__KERNEL__)) {
	unless(defined(&__ASSEMBLY__)) {
	    require 'linux/sched.ph';
	    require 'linux/errno.ph';
	    require 'asm/processor.ph';
	    require 'asm/page.ph';
	    eval 'sub VERIFY_READ () {0;}' unless defined(&VERIFY_READ);
	    eval 'sub VERIFY_WRITE () {1;}' unless defined(&VERIFY_WRITE);
	    eval 'sub MAKE_MM_SEG {
	        my($s) = @_;
    		eval q((( &mm_segment_t) { ($s) }));
	    }' unless defined(&MAKE_MM_SEG);
	    eval 'sub KERNEL_DS () { &MAKE_MM_SEG(~0);}' unless defined(&KERNEL_DS);
	    if(defined(&__powerpc64__)) {
		eval 'sub USER_DS () { &MAKE_MM_SEG( &TASK_SIZE_USER64 - 1);}' unless defined(&USER_DS);
	    } else {
		eval 'sub USER_DS () { &MAKE_MM_SEG( &TASK_SIZE - 1);}' unless defined(&USER_DS);
	    }
	    eval 'sub get_ds () {
	        eval q(( &KERNEL_DS));
	    }' unless defined(&get_ds);
	    eval 'sub get_fs () {
	        eval q(( ($current->{thread}->{fs})));
	    }' unless defined(&get_fs);
	    eval 'sub set_fs {
	        my($val) = @_;
    		eval q(( ($current->{thread}->{fs}) = ($val)));
	    }' unless defined(&set_fs);
	    eval 'sub segment_eq {
	        my($a, $b) = @_;
    		eval q((($a). &seg == ($b). &seg));
	    }' unless defined(&segment_eq);
	    if(defined(&__powerpc64__)) {
		eval 'sub __access_ok {
		    my($addr, $size, $segment) = @_;
    		    eval q(((($addr) <= ($segment). &seg)  && (($size) <= ($segment). &seg)));
		}' unless defined(&__access_ok);
	    } else {
		eval 'sub __access_ok {
		    my($addr, $size, $segment) = @_;
    		    eval q(((($addr) <= ($segment). &seg)  && ((($size) == 0) || ((($size) - 1) <= (($segment). &seg - ($addr))))));
		}' unless defined(&__access_ok);
	    }
	    eval 'sub access_ok {
	        my($type, $addr, $size) = @_;
    		eval q(( &__chk_user_ptr($addr),  &__access_ok(( &__force \'unsigned long\')($addr), ($size),  &get_fs())));
	    }' unless defined(&access_ok);
	    eval 'sub get_user {
	        my($x, $ptr) = @_;
    		eval q( &__get_user_check(($x), ($ptr), $sizeof{($ptr)}));
	    }' unless defined(&get_user);
	    eval 'sub put_user {
	        my($x, $ptr) = @_;
    		eval q( &__put_user_check(( &__typeof__(*($ptr)))($x), ($ptr), $sizeof{($ptr)}));
	    }' unless defined(&put_user);
	    eval 'sub __get_user {
	        my($x, $ptr) = @_;
    		eval q( &__get_user_nocheck(($x), ($ptr), $sizeof{($ptr)}));
	    }' unless defined(&__get_user);
	    eval 'sub __put_user {
	        my($x, $ptr) = @_;
    		eval q( &__put_user_nocheck(( &__typeof__(*($ptr)))($x), ($ptr), $sizeof{($ptr)}));
	    }' unless defined(&__put_user);
	    unless(defined(&__powerpc64__)) {
		eval 'sub __get_user64 {
		    my($x, $ptr) = @_;
    		    eval q( &__get_user64_nocheck(($x), ($ptr), $sizeof{($ptr)}));
		}' unless defined(&__get_user64);
		eval 'sub __put_user64 {
		    my($x, $ptr) = @_;
    		    eval q( &__put_user($x, $ptr));
		}' unless defined(&__put_user64);
	    }
	    eval 'sub __get_user_unaligned () { &__get_user;}' unless defined(&__get_user_unaligned);
	    eval 'sub __put_user_unaligned () { &__put_user;}' unless defined(&__put_user_unaligned);
	    eval 'sub __put_user_asm {
	        my($x, $addr, $err, $op) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&__put_user_asm);
	    if(defined(&__powerpc64__)) {
		eval 'sub __put_user_asm2 {
		    my($x, $ptr, $retval) = @_;
    		    eval q( &__put_user_asm($x, $ptr, $retval, \\"std\\"));
		}' unless defined(&__put_user_asm2);
	    } else {
		eval 'sub __put_user_asm2 {
		    my($x, $addr, $err) = @_;
    		    eval q(\\"(assembly code)\\");
		}' unless defined(&__put_user_asm2);
	    }
	    eval 'sub __put_user_size {
	        my($x, $ptr, $size, $retval) = @_;
    		eval q( &do { $retval = 0;  &switch ($size) {  &case 1:  &__put_user_asm($x, $ptr, $retval, \\"stb\\");  &break;  &case 2:  &__put_user_asm($x, $ptr, $retval, \\"sth\\");  &break;  &case 4:  &__put_user_asm($x, $ptr, $retval, \\"stw\\");  &break;  &case 8:  &__put_user_asm2($x, $ptr, $retval);  &break;  &default:  &__put_user_bad(); } }  &while (0));
	    }' unless defined(&__put_user_size);
	    eval 'sub __put_user_nocheck {
	        my($x, $ptr, $size) = @_;
    		eval q(({ \'long __pu_err\';  &__typeof__(*($ptr))  &__user * &__pu_addr = ($ptr);  &if (! &is_kernel_addr( &__pu_addr))  &might_sleep();  &__chk_user_ptr($ptr);  &__put_user_size(($x),  &__pu_addr, ($size),  &__pu_err);  &__pu_err; }));
	    }' unless defined(&__put_user_nocheck);
	    eval 'sub __put_user_check {
	        my($x, $ptr, $size) = @_;
    		eval q(({ \'long __pu_err\' = - &EFAULT;  &__typeof__(*($ptr))  &__user * &__pu_addr = ($ptr);  &might_sleep();  &if ( &access_ok( &VERIFY_WRITE,  &__pu_addr, $size))  &__put_user_size(($x),  &__pu_addr, ($size),  &__pu_err);  &__pu_err; }));
	    }' unless defined(&__put_user_check);
	    eval 'sub __get_user_asm {
	        my($x, $addr, $err, $op) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&__get_user_asm);
	    if(defined(&__powerpc64__)) {
		eval 'sub __get_user_asm2 {
		    my($x, $addr, $err) = @_;
    		    eval q( &__get_user_asm($x, $addr, $err, \\"ld\\"));
		}' unless defined(&__get_user_asm2);
	    } else {
		eval 'sub __get_user_asm2 {
		    my($x, $addr, $err) = @_;
    		    eval q(\\"(assembly code)\\");
		}' unless defined(&__get_user_asm2);
	    }
	    eval 'sub __get_user_size {
	        my($x, $ptr, $size, $retval) = @_;
    		eval q( &do { $retval = 0;  &__chk_user_ptr($ptr);  &if ($size > $sizeof{$x}) ($x) =  &__get_user_bad();  &switch ($size) {  &case 1:  &__get_user_asm($x, $ptr, $retval, \\"lbz\\");  &break;  &case 2:  &__get_user_asm($x, $ptr, $retval, \\"lhz\\");  &break;  &case 4:  &__get_user_asm($x, $ptr, $retval, \\"lwz\\");  &break;  &case 8:  &__get_user_asm2($x, $ptr, $retval);  &break;  &default: ($x) =  &__get_user_bad(); } }  &while (0));
	    }' unless defined(&__get_user_size);
	    eval 'sub __get_user_nocheck {
	        my($x, $ptr, $size) = @_;
    		eval q(({ \'long __gu_err\'; \'unsigned long __gu_val\';  &const  &__typeof__(*($ptr))  &__user * &__gu_addr = ($ptr);  &__chk_user_ptr($ptr);  &if (! &is_kernel_addr( &__gu_addr))  &might_sleep();  &__get_user_size( &__gu_val,  &__gu_addr, ($size),  &__gu_err); ($x) = ( &__typeof__(*($ptr))) &__gu_val;  &__gu_err; }));
	    }' unless defined(&__get_user_nocheck);
	    unless(defined(&__powerpc64__)) {
		eval 'sub __get_user64_nocheck {
		    my($x, $ptr, $size) = @_;
    		    eval q(({ \'long __gu_err\'; \'long long __gu_val\';  &const  &__typeof__(*($ptr))  &__user * &__gu_addr = ($ptr);  &__chk_user_ptr($ptr);  &if (! &is_kernel_addr( &__gu_addr))  &might_sleep();  &__get_user_size( &__gu_val,  &__gu_addr, ($size),  &__gu_err); ($x) = ( &__typeof__(*($ptr))) &__gu_val;  &__gu_err; }));
		}' unless defined(&__get_user64_nocheck);
	    }
	    eval 'sub __get_user_check {
	        my($x, $ptr, $size) = @_;
    		eval q(({ \'long __gu_err\' = - &EFAULT; \'unsigned long __gu_val\' = 0;  &const  &__typeof__(*($ptr))  &__user * &__gu_addr = ($ptr);  &might_sleep();  &if ( &access_ok( &VERIFY_READ,  &__gu_addr, ($size)))  &__get_user_size( &__gu_val,  &__gu_addr, ($size),  &__gu_err); ($x) = ( &__typeof__(*($ptr))) &__gu_val;  &__gu_err; }));
	    }' unless defined(&__get_user_check);
	    unless(defined(&__powerpc64__)) {
	    } else {
		eval 'sub __copy_in_user {
		    my($to, $from, $size) = @_;
    		    eval q( &__copy_tofrom_user(($to), ($from), ($size)));
		}' unless defined(&__copy_in_user);
	    }
	    eval 'sub __copy_from_user_inatomic {
	        my($to,$from,$n) = @_;
    		eval q({  &if ( &__builtin_constant_p($n)  && ($n <= 8)) { my $ret;  &switch ($n) {  &case 1:  &__get_user_size(*( &u8 *)$to, $from, 1,  $ret);  &break;  &case 2:  &__get_user_size(*( &u16 *)$to, $from, 2,  $ret);  &break;  &case 4:  &__get_user_size(*( &u32 *)$to, $from, 4,  $ret);  &break;  &case 8:  &__get_user_size(*( &u64 *)$to, $from, 8,  $ret);  &break; }  &if ( $ret == 0) 0; }  &__copy_tofrom_user(( &__force  &void  &__user *)$to, $from, $n); });
	    }' unless defined(&__copy_from_user_inatomic);
	    eval 'sub __copy_to_user_inatomic {
	        my($to,$from,$n) = @_;
    		eval q({  &if ( &__builtin_constant_p($n)  && ($n <= 8)) { my $ret;  &switch ($n) {  &case 1:  &__put_user_size(*( &u8 *)$from, ( &u8  &__user *)$to, 1,  $ret);  &break;  &case 2:  &__put_user_size(*( &u16 *)$from, ( &u16  &__user *)$to, 2,  $ret);  &break;  &case 4:  &__put_user_size(*( &u32 *)$from, ( &u32  &__user *)$to, 4,  $ret);  &break;  &case 8:  &__put_user_size(*( &u64 *)$from, ( &u64  &__user *)$to, 8,  $ret);  &break; }  &if ( $ret == 0) 0; }  &__copy_tofrom_user($to, ( &__force  &const  &void  &__user *)$from, $n); });
	    }' unless defined(&__copy_to_user_inatomic);
	    eval 'sub __copy_from_user {
	        my($to,$from,$size) = @_;
    		eval q({  &might_sleep();  &__copy_from_user_inatomic($to, $from, $size); });
	    }' unless defined(&__copy_from_user);
	    eval 'sub __copy_to_user {
	        my($to,$from,$size) = @_;
    		eval q({  &might_sleep();  &__copy_to_user_inatomic($to, $from, $size); });
	    }' unless defined(&__copy_to_user);
	    eval 'sub clear_user {
	        my($addr,$size) = @_;
    		eval q({  &might_sleep();  &if ( &likely( &access_ok( &VERIFY_WRITE, $addr, $size)))  &__clear_user($addr, $size);  &if ($addr <  &TASK_SIZE) { my $over = $addr + $size -  &TASK_SIZE;  &__clear_user($addr, $size -  $over) +  $over; } $size; });
	    }' unless defined(&clear_user);
	    eval 'sub strncpy_from_user {
	        my($dst,$src,$count) = @_;
    		eval q({  &might_sleep();  &if ( &likely( &access_ok( &VERIFY_READ, $src, 1)))  &__strncpy_from_user($dst, $src, $count); - &EFAULT; });
	    }' unless defined(&strncpy_from_user);
	    eval 'sub strlen_user {
	        my($str) = @_;
    		eval q( &strnlen_user(($str), 0x7ffffffe));
	    }' unless defined(&strlen_user);
	}
    }
}
1;
