require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_REG_H)) {
    eval 'sub _ASM_POWERPC_REG_H () {1;}' unless defined(&_ASM_POWERPC_REG_H);
    if(defined(&__KERNEL__)) {
	require 'linux/stringify.ph';
	require 'asm/cputable.ph';
	if(defined( &CONFIG_BOOKE) || defined( &CONFIG_40x)) {
	    require 'asm/reg_booke.ph';
	}
	if(defined(&CONFIG_8xx)) {
	    require 'asm/reg_8xx.ph';
	}
	eval 'sub MSR_SF_LG () {63;}' unless defined(&MSR_SF_LG);
	eval 'sub MSR_ISF_LG () {61;}' unless defined(&MSR_ISF_LG);
	eval 'sub MSR_HV_LG () {60;}' unless defined(&MSR_HV_LG);
	eval 'sub MSR_VEC_LG () {25;}' unless defined(&MSR_VEC_LG);
	eval 'sub MSR_POW_LG () {18;}' unless defined(&MSR_POW_LG);
	eval 'sub MSR_WE_LG () {18;}' unless defined(&MSR_WE_LG);
	eval 'sub MSR_TGPR_LG () {17;}' unless defined(&MSR_TGPR_LG);
	eval 'sub MSR_CE_LG () {17;}' unless defined(&MSR_CE_LG);
	eval 'sub MSR_ILE_LG () {16;}' unless defined(&MSR_ILE_LG);
	eval 'sub MSR_EE_LG () {15;}' unless defined(&MSR_EE_LG);
	eval 'sub MSR_PR_LG () {14;}' unless defined(&MSR_PR_LG);
	eval 'sub MSR_FP_LG () {13;}' unless defined(&MSR_FP_LG);
	eval 'sub MSR_ME_LG () {12;}' unless defined(&MSR_ME_LG);
	eval 'sub MSR_FE0_LG () {11;}' unless defined(&MSR_FE0_LG);
	eval 'sub MSR_SE_LG () {10;}' unless defined(&MSR_SE_LG);
	eval 'sub MSR_BE_LG () {9;}' unless defined(&MSR_BE_LG);
	eval 'sub MSR_DE_LG () {9;}' unless defined(&MSR_DE_LG);
	eval 'sub MSR_FE1_LG () {8;}' unless defined(&MSR_FE1_LG);
	eval 'sub MSR_IP_LG () {6;}' unless defined(&MSR_IP_LG);
	eval 'sub MSR_IR_LG () {5;}' unless defined(&MSR_IR_LG);
	eval 'sub MSR_DR_LG () {4;}' unless defined(&MSR_DR_LG);
	eval 'sub MSR_PE_LG () {3;}' unless defined(&MSR_PE_LG);
	eval 'sub MSR_PX_LG () {2;}' unless defined(&MSR_PX_LG);
	eval 'sub MSR_PMM_LG () {2;}' unless defined(&MSR_PMM_LG);
	eval 'sub MSR_RI_LG () {1;}' unless defined(&MSR_RI_LG);
	eval 'sub MSR_LE_LG () {0;}' unless defined(&MSR_LE_LG);
	if(defined(&__ASSEMBLY__)) {
	    eval 'sub __MASK {
	        my($X) = @_;
    		eval q((1<<($X)));
	    }' unless defined(&__MASK);
	} else {
	    eval 'sub __MASK {
	        my($X) = @_;
    		eval q((1<<($X)));
	    }' unless defined(&__MASK);
	}
	if(defined(&CONFIG_PPC64)) {
	    eval 'sub MSR_SF () { &__MASK( &MSR_SF_LG);}' unless defined(&MSR_SF);
	    eval 'sub MSR_ISF () { &__MASK( &MSR_ISF_LG);}' unless defined(&MSR_ISF);
	    eval 'sub MSR_HV () { &__MASK( &MSR_HV_LG);}' unless defined(&MSR_HV);
	} else {
	    eval 'sub MSR_SF () {0;}' unless defined(&MSR_SF);
	    eval 'sub MSR_ISF () {0;}' unless defined(&MSR_ISF);
	    eval 'sub MSR_HV () {0;}' unless defined(&MSR_HV);
	}
	eval 'sub MSR_VEC () { &__MASK( &MSR_VEC_LG);}' unless defined(&MSR_VEC);
	eval 'sub MSR_POW () { &__MASK( &MSR_POW_LG);}' unless defined(&MSR_POW);
	eval 'sub MSR_WE () { &__MASK( &MSR_WE_LG);}' unless defined(&MSR_WE);
	eval 'sub MSR_TGPR () { &__MASK( &MSR_TGPR_LG);}' unless defined(&MSR_TGPR);
	eval 'sub MSR_CE () { &__MASK( &MSR_CE_LG);}' unless defined(&MSR_CE);
	eval 'sub MSR_ILE () { &__MASK( &MSR_ILE_LG);}' unless defined(&MSR_ILE);
	eval 'sub MSR_EE () { &__MASK( &MSR_EE_LG);}' unless defined(&MSR_EE);
	eval 'sub MSR_PR () { &__MASK( &MSR_PR_LG);}' unless defined(&MSR_PR);
	eval 'sub MSR_FP () { &__MASK( &MSR_FP_LG);}' unless defined(&MSR_FP);
	eval 'sub MSR_ME () { &__MASK( &MSR_ME_LG);}' unless defined(&MSR_ME);
	eval 'sub MSR_FE0 () { &__MASK( &MSR_FE0_LG);}' unless defined(&MSR_FE0);
	eval 'sub MSR_SE () { &__MASK( &MSR_SE_LG);}' unless defined(&MSR_SE);
	eval 'sub MSR_BE () { &__MASK( &MSR_BE_LG);}' unless defined(&MSR_BE);
	eval 'sub MSR_DE () { &__MASK( &MSR_DE_LG);}' unless defined(&MSR_DE);
	eval 'sub MSR_FE1 () { &__MASK( &MSR_FE1_LG);}' unless defined(&MSR_FE1);
	eval 'sub MSR_IP () { &__MASK( &MSR_IP_LG);}' unless defined(&MSR_IP);
	eval 'sub MSR_IR () { &__MASK( &MSR_IR_LG);}' unless defined(&MSR_IR);
	eval 'sub MSR_DR () { &__MASK( &MSR_DR_LG);}' unless defined(&MSR_DR);
	eval 'sub MSR_PE () { &__MASK( &MSR_PE_LG);}' unless defined(&MSR_PE);
	eval 'sub MSR_PX () { &__MASK( &MSR_PX_LG);}' unless defined(&MSR_PX);
	unless(defined(&MSR_PMM)) {
	    eval 'sub MSR_PMM () { &__MASK( &MSR_PMM_LG);}' unless defined(&MSR_PMM);
	}
	eval 'sub MSR_RI () { &__MASK( &MSR_RI_LG);}' unless defined(&MSR_RI);
	eval 'sub MSR_LE () { &__MASK( &MSR_LE_LG);}' unless defined(&MSR_LE);
	if(defined(&CONFIG_PPC64)) {
	    eval 'sub MSR_ () { &MSR_ME |  &MSR_RI |  &MSR_IR |  &MSR_DR |  &MSR_ISF | &MSR_HV;}' unless defined(&MSR_);
	    eval 'sub MSR_KERNEL () { &MSR_ |  &MSR_SF;}' unless defined(&MSR_KERNEL);
	    eval 'sub MSR_USER32 () { &MSR_ |  &MSR_PR |  &MSR_EE;}' unless defined(&MSR_USER32);
	    eval 'sub MSR_USER64 () { &MSR_USER32 |  &MSR_SF;}' unless defined(&MSR_USER64);
	} else {
	    unless(defined(&MSR_KERNEL)) {
		if(defined(&CONFIG_APUS_FAST_EXCEPT)) {
		    eval 'sub MSR_KERNEL () {( &MSR_ME| &MSR_IP| &MSR_RI| &MSR_IR| &MSR_DR);}' unless defined(&MSR_KERNEL);
		} else {
		    eval 'sub MSR_KERNEL () {( &MSR_ME| &MSR_RI| &MSR_IR| &MSR_DR);}' unless defined(&MSR_KERNEL);
		}
	    }
	    eval 'sub MSR_USER () {( &MSR_KERNEL| &MSR_PR| &MSR_EE);}' unless defined(&MSR_USER);
	}
	eval 'sub FPSCR_FX () {0x80000000;}' unless defined(&FPSCR_FX);
	eval 'sub FPSCR_FEX () {0x40000000;}' unless defined(&FPSCR_FEX);
	eval 'sub FPSCR_VX () {0x20000000;}' unless defined(&FPSCR_VX);
	eval 'sub FPSCR_OX () {0x10000000;}' unless defined(&FPSCR_OX);
	eval 'sub FPSCR_UX () {0x8000000;}' unless defined(&FPSCR_UX);
	eval 'sub FPSCR_ZX () {0x4000000;}' unless defined(&FPSCR_ZX);
	eval 'sub FPSCR_XX () {0x2000000;}' unless defined(&FPSCR_XX);
	eval 'sub FPSCR_VXSNAN () {0x1000000;}' unless defined(&FPSCR_VXSNAN);
	eval 'sub FPSCR_VXISI () {0x800000;}' unless defined(&FPSCR_VXISI);
	eval 'sub FPSCR_VXIDI () {0x400000;}' unless defined(&FPSCR_VXIDI);
	eval 'sub FPSCR_VXZDZ () {0x200000;}' unless defined(&FPSCR_VXZDZ);
	eval 'sub FPSCR_VXIMZ () {0x100000;}' unless defined(&FPSCR_VXIMZ);
	eval 'sub FPSCR_VXVC () {0x80000;}' unless defined(&FPSCR_VXVC);
	eval 'sub FPSCR_FR () {0x40000;}' unless defined(&FPSCR_FR);
	eval 'sub FPSCR_FI () {0x20000;}' unless defined(&FPSCR_FI);
	eval 'sub FPSCR_FPRF () {0x1f000;}' unless defined(&FPSCR_FPRF);
	eval 'sub FPSCR_FPCC () {0xf000;}' unless defined(&FPSCR_FPCC);
	eval 'sub FPSCR_VXSOFT () {0x400;}' unless defined(&FPSCR_VXSOFT);
	eval 'sub FPSCR_VXSQRT () {0x200;}' unless defined(&FPSCR_VXSQRT);
	eval 'sub FPSCR_VXCVI () {0x100;}' unless defined(&FPSCR_VXCVI);
	eval 'sub FPSCR_VE () {0x80;}' unless defined(&FPSCR_VE);
	eval 'sub FPSCR_OE () {0x40;}' unless defined(&FPSCR_OE);
	eval 'sub FPSCR_UE () {0x20;}' unless defined(&FPSCR_UE);
	eval 'sub FPSCR_ZE () {0x10;}' unless defined(&FPSCR_ZE);
	eval 'sub FPSCR_XE () {0x8;}' unless defined(&FPSCR_XE);
	eval 'sub FPSCR_NI () {0x4;}' unless defined(&FPSCR_NI);
	eval 'sub FPSCR_RN () {0x3;}' unless defined(&FPSCR_RN);
	eval 'sub SPRN_CTR () {0x9;}' unless defined(&SPRN_CTR);
	eval 'sub SPRN_CTRLF () {0x88;}' unless defined(&SPRN_CTRLF);
	eval 'sub SPRN_CTRLT () {0x98;}' unless defined(&SPRN_CTRLT);
	eval 'sub CTRL_CT () {0xc0000000;}' unless defined(&CTRL_CT);
	eval 'sub CTRL_CT0 () {0x80000000;}' unless defined(&CTRL_CT0);
	eval 'sub CTRL_CT1 () {0x40000000;}' unless defined(&CTRL_CT1);
	eval 'sub CTRL_TE () {0xc00000;}' unless defined(&CTRL_TE);
	eval 'sub CTRL_RUNLATCH () {0x1;}' unless defined(&CTRL_RUNLATCH);
	eval 'sub SPRN_DABR () {0x3f5;}' unless defined(&SPRN_DABR);
	eval 'sub DABR_TRANSLATION () {(1 << 2);}' unless defined(&DABR_TRANSLATION);
	eval 'sub SPRN_DAR () {0x13;}' unless defined(&SPRN_DAR);
	eval 'sub SPRN_DSISR () {0x12;}' unless defined(&SPRN_DSISR);
	eval 'sub DSISR_NOHPTE () {0x40000000;}' unless defined(&DSISR_NOHPTE);
	eval 'sub DSISR_PROTFAULT () {0x8000000;}' unless defined(&DSISR_PROTFAULT);
	eval 'sub DSISR_ISSTORE () {0x2000000;}' unless defined(&DSISR_ISSTORE);
	eval 'sub DSISR_DABRMATCH () {0x400000;}' unless defined(&DSISR_DABRMATCH);
	eval 'sub DSISR_NOSEGMENT () {0x200000;}' unless defined(&DSISR_NOSEGMENT);
	eval 'sub SPRN_TBRL () {0x10c;}' unless defined(&SPRN_TBRL);
	eval 'sub SPRN_TBRU () {0x10d;}' unless defined(&SPRN_TBRU);
	eval 'sub SPRN_TBWL () {0x11c;}' unless defined(&SPRN_TBWL);
	eval 'sub SPRN_TBWU () {0x11d;}' unless defined(&SPRN_TBWU);
	eval 'sub SPRN_HIOR () {0x137;}' unless defined(&SPRN_HIOR);
	eval 'sub SPRN_DBAT0L () {0x219;}' unless defined(&SPRN_DBAT0L);
	eval 'sub SPRN_DBAT0U () {0x218;}' unless defined(&SPRN_DBAT0U);
	eval 'sub SPRN_DBAT1L () {0x21b;}' unless defined(&SPRN_DBAT1L);
	eval 'sub SPRN_DBAT1U () {0x21a;}' unless defined(&SPRN_DBAT1U);
	eval 'sub SPRN_DBAT2L () {0x21d;}' unless defined(&SPRN_DBAT2L);
	eval 'sub SPRN_DBAT2U () {0x21c;}' unless defined(&SPRN_DBAT2U);
	eval 'sub SPRN_DBAT3L () {0x21f;}' unless defined(&SPRN_DBAT3L);
	eval 'sub SPRN_DBAT3U () {0x21e;}' unless defined(&SPRN_DBAT3U);
	eval 'sub SPRN_DBAT4L () {0x239;}' unless defined(&SPRN_DBAT4L);
	eval 'sub SPRN_DBAT4U () {0x238;}' unless defined(&SPRN_DBAT4U);
	eval 'sub SPRN_DBAT5L () {0x23b;}' unless defined(&SPRN_DBAT5L);
	eval 'sub SPRN_DBAT5U () {0x23a;}' unless defined(&SPRN_DBAT5U);
	eval 'sub SPRN_DBAT6L () {0x23d;}' unless defined(&SPRN_DBAT6L);
	eval 'sub SPRN_DBAT6U () {0x23c;}' unless defined(&SPRN_DBAT6U);
	eval 'sub SPRN_DBAT7L () {0x23f;}' unless defined(&SPRN_DBAT7L);
	eval 'sub SPRN_DBAT7U () {0x23e;}' unless defined(&SPRN_DBAT7U);
	eval 'sub SPRN_DEC () {0x16;}' unless defined(&SPRN_DEC);
	eval 'sub SPRN_DER () {0x95;}' unless defined(&SPRN_DER);
	eval 'sub DER_RSTE () {0x40000000;}' unless defined(&DER_RSTE);
	eval 'sub DER_CHSTPE () {0x20000000;}' unless defined(&DER_CHSTPE);
	eval 'sub DER_MCIE () {0x10000000;}' unless defined(&DER_MCIE);
	eval 'sub DER_EXTIE () {0x2000000;}' unless defined(&DER_EXTIE);
	eval 'sub DER_ALIE () {0x1000000;}' unless defined(&DER_ALIE);
	eval 'sub DER_PRIE () {0x800000;}' unless defined(&DER_PRIE);
	eval 'sub DER_FPUVIE () {0x400000;}' unless defined(&DER_FPUVIE);
	eval 'sub DER_DECIE () {0x200000;}' unless defined(&DER_DECIE);
	eval 'sub DER_SYSIE () {0x40000;}' unless defined(&DER_SYSIE);
	eval 'sub DER_TRE () {0x20000;}' unless defined(&DER_TRE);
	eval 'sub DER_SEIE () {0x4000;}' unless defined(&DER_SEIE);
	eval 'sub DER_ITLBMSE () {0x2000;}' unless defined(&DER_ITLBMSE);
	eval 'sub DER_ITLBERE () {0x1000;}' unless defined(&DER_ITLBERE);
	eval 'sub DER_DTLBMSE () {0x800;}' unless defined(&DER_DTLBMSE);
	eval 'sub DER_DTLBERE () {0x400;}' unless defined(&DER_DTLBERE);
	eval 'sub DER_LBRKE () {0x8;}' unless defined(&DER_LBRKE);
	eval 'sub DER_IBRKE () {0x4;}' unless defined(&DER_IBRKE);
	eval 'sub DER_EBRKE () {0x2;}' unless defined(&DER_EBRKE);
	eval 'sub DER_DPIE () {0x1;}' unless defined(&DER_DPIE);
	eval 'sub SPRN_DMISS () {0x3d0;}' unless defined(&SPRN_DMISS);
	eval 'sub SPRN_EAR () {0x11a;}' unless defined(&SPRN_EAR);
	eval 'sub SPRN_HASH1 () {0x3d2;}' unless defined(&SPRN_HASH1);
	eval 'sub SPRN_HASH2 () {0x3d3;}' unless defined(&SPRN_HASH2);
	eval 'sub SPRN_HID0 () {0x3f0;}' unless defined(&SPRN_HID0);
	eval 'sub HID0_EMCP () {(1<<31);}' unless defined(&HID0_EMCP);
	eval 'sub HID0_EBA () {(1<<29);}' unless defined(&HID0_EBA);
	eval 'sub HID0_EBD () {(1<<28);}' unless defined(&HID0_EBD);
	eval 'sub HID0_SBCLK () {(1<<27);}' unless defined(&HID0_SBCLK);
	eval 'sub HID0_EICE () {(1<<26);}' unless defined(&HID0_EICE);
	eval 'sub HID0_TBEN () {(1<<26);}' unless defined(&HID0_TBEN);
	eval 'sub HID0_ECLK () {(1<<25);}' unless defined(&HID0_ECLK);
	eval 'sub HID0_PAR () {(1<<24);}' unless defined(&HID0_PAR);
	eval 'sub HID0_STEN () {(1<<24);}' unless defined(&HID0_STEN);
	eval 'sub HID0_HIGH_BAT () {(1<<23);}' unless defined(&HID0_HIGH_BAT);
	eval 'sub HID0_DOZE () {(1<<23);}' unless defined(&HID0_DOZE);
	eval 'sub HID0_NAP () {(1<<22);}' unless defined(&HID0_NAP);
	eval 'sub HID0_SLEEP () {(1<<21);}' unless defined(&HID0_SLEEP);
	eval 'sub HID0_DPM () {(1<<20);}' unless defined(&HID0_DPM);
	eval 'sub HID0_BHTCLR () {(1<<18);}' unless defined(&HID0_BHTCLR);
	eval 'sub HID0_XAEN () {(1<<17);}' unless defined(&HID0_XAEN);
	eval 'sub HID0_NHR () {(1<<16);}' unless defined(&HID0_NHR);
	eval 'sub HID0_ICE () {(1<<15);}' unless defined(&HID0_ICE);
	eval 'sub HID0_DCE () {(1<<14);}' unless defined(&HID0_DCE);
	eval 'sub HID0_ILOCK () {(1<<13);}' unless defined(&HID0_ILOCK);
	eval 'sub HID0_DLOCK () {(1<<12);}' unless defined(&HID0_DLOCK);
	eval 'sub HID0_ICFI () {(1<<11);}' unless defined(&HID0_ICFI);
	eval 'sub HID0_DCI () {(1<<10);}' unless defined(&HID0_DCI);
	eval 'sub HID0_SPD () {(1<<9);}' unless defined(&HID0_SPD);
	eval 'sub HID0_DAPUEN () {(1<<8);}' unless defined(&HID0_DAPUEN);
	eval 'sub HID0_SGE () {(1<<7);}' unless defined(&HID0_SGE);
	eval 'sub HID0_SIED () {(1<<7);}' unless defined(&HID0_SIED);
	eval 'sub HID0_DFCA () {(1<<6);}' unless defined(&HID0_DFCA);
	eval 'sub HID0_LRSTK () {(1<<4);}' unless defined(&HID0_LRSTK);
	eval 'sub HID0_BTIC () {(1<<5);}' unless defined(&HID0_BTIC);
	eval 'sub HID0_ABE () {(1<<3);}' unless defined(&HID0_ABE);
	eval 'sub HID0_FOLD () {(1<<3);}' unless defined(&HID0_FOLD);
	eval 'sub HID0_BHTE () {(1<<2);}' unless defined(&HID0_BHTE);
	eval 'sub HID0_BTCD () {(1<<1);}' unless defined(&HID0_BTCD);
	eval 'sub HID0_NOPDST () {(1<<1);}' unless defined(&HID0_NOPDST);
	eval 'sub HID0_NOPTI () {(1<<0);}' unless defined(&HID0_NOPTI);
	eval 'sub SPRN_HID1 () {0x3f1;}' unless defined(&SPRN_HID1);
	eval 'sub HID1_EMCP () {(1<<31);}' unless defined(&HID1_EMCP);
	eval 'sub HID1_DFS () {(1<<22);}' unless defined(&HID1_DFS);
	eval 'sub HID1_PC0 () {(1<<16);}' unless defined(&HID1_PC0);
	eval 'sub HID1_PC1 () {(1<<15);}' unless defined(&HID1_PC1);
	eval 'sub HID1_PC2 () {(1<<14);}' unless defined(&HID1_PC2);
	eval 'sub HID1_PC3 () {(1<<13);}' unless defined(&HID1_PC3);
	eval 'sub HID1_SYNCBE () {(1<<11);}' unless defined(&HID1_SYNCBE);
	eval 'sub HID1_ABE () {(1<<10);}' unless defined(&HID1_ABE);
	eval 'sub HID1_PS () {(1<<16);}' unless defined(&HID1_PS);
	eval 'sub SPRN_HID2 () {0x3f8;}' unless defined(&SPRN_HID2);
	eval 'sub SPRN_IABR () {0x3f2;}' unless defined(&SPRN_IABR);
	eval 'sub SPRN_HID4 () {0x3f4;}' unless defined(&SPRN_HID4);
	eval 'sub SPRN_HID5 () {0x3f6;}' unless defined(&SPRN_HID5);
	eval 'sub SPRN_HID6 () {0x3f9;}' unless defined(&SPRN_HID6);
	eval 'sub HID6_LB () {(0xf<<12);}' unless defined(&HID6_LB);
	eval 'sub HID6_DLP () {(1<<20);}' unless defined(&HID6_DLP);
	eval 'sub SPRN_TSC_CELL () {0x399;}' unless defined(&SPRN_TSC_CELL);
	eval 'sub TSC_CELL_DEC_ENABLE_0 () {0x400000;}' unless defined(&TSC_CELL_DEC_ENABLE_0);
	eval 'sub TSC_CELL_DEC_ENABLE_1 () {0x200000;}' unless defined(&TSC_CELL_DEC_ENABLE_1);
	eval 'sub TSC_CELL_EE_ENABLE () {0x100000;}' unless defined(&TSC_CELL_EE_ENABLE);
	eval 'sub TSC_CELL_EE_BOOST () {0x80000;}' unless defined(&TSC_CELL_EE_BOOST);
	eval 'sub SPRN_TSC () {0x3fd;}' unless defined(&SPRN_TSC);
	eval 'sub SPRN_TST () {0x3fc;}' unless defined(&SPRN_TST);
	if(!defined( &SPRN_IAC1)  && !defined( &SPRN_IAC2)) {
	    eval 'sub SPRN_IAC1 () {0x3f4;}' unless defined(&SPRN_IAC1);
	    eval 'sub SPRN_IAC2 () {0x3f5;}' unless defined(&SPRN_IAC2);
	}
	eval 'sub SPRN_IBAT0L () {0x211;}' unless defined(&SPRN_IBAT0L);
	eval 'sub SPRN_IBAT0U () {0x210;}' unless defined(&SPRN_IBAT0U);
	eval 'sub SPRN_IBAT1L () {0x213;}' unless defined(&SPRN_IBAT1L);
	eval 'sub SPRN_IBAT1U () {0x212;}' unless defined(&SPRN_IBAT1U);
	eval 'sub SPRN_IBAT2L () {0x215;}' unless defined(&SPRN_IBAT2L);
	eval 'sub SPRN_IBAT2U () {0x214;}' unless defined(&SPRN_IBAT2U);
	eval 'sub SPRN_IBAT3L () {0x217;}' unless defined(&SPRN_IBAT3L);
	eval 'sub SPRN_IBAT3U () {0x216;}' unless defined(&SPRN_IBAT3U);
	eval 'sub SPRN_IBAT4L () {0x231;}' unless defined(&SPRN_IBAT4L);
	eval 'sub SPRN_IBAT4U () {0x230;}' unless defined(&SPRN_IBAT4U);
	eval 'sub SPRN_IBAT5L () {0x233;}' unless defined(&SPRN_IBAT5L);
	eval 'sub SPRN_IBAT5U () {0x232;}' unless defined(&SPRN_IBAT5U);
	eval 'sub SPRN_IBAT6L () {0x235;}' unless defined(&SPRN_IBAT6L);
	eval 'sub SPRN_IBAT6U () {0x234;}' unless defined(&SPRN_IBAT6U);
	eval 'sub SPRN_IBAT7L () {0x237;}' unless defined(&SPRN_IBAT7L);
	eval 'sub SPRN_IBAT7U () {0x236;}' unless defined(&SPRN_IBAT7U);
	eval 'sub SPRN_ICMP () {0x3d5;}' unless defined(&SPRN_ICMP);
	eval 'sub SPRN_ICTC () {0x3fb;}' unless defined(&SPRN_ICTC);
	eval 'sub SPRN_ICTRL () {0x3f3;}' unless defined(&SPRN_ICTRL);
	eval 'sub ICTRL_EICE () {0x8000000;}' unless defined(&ICTRL_EICE);
	eval 'sub ICTRL_EDC () {0x4000000;}' unless defined(&ICTRL_EDC);
	eval 'sub ICTRL_EICP () {0x100;}' unless defined(&ICTRL_EICP);
	eval 'sub SPRN_IMISS () {0x3d4;}' unless defined(&SPRN_IMISS);
	eval 'sub SPRN_IMMR () {0x27e;}' unless defined(&SPRN_IMMR);
	eval 'sub SPRN_L2CR () {0x3f9;}' unless defined(&SPRN_L2CR);
	eval 'sub SPRN_L2CR2 () {0x3f8;}' unless defined(&SPRN_L2CR2);
	eval 'sub L2CR_L2E () {0x80000000;}' unless defined(&L2CR_L2E);
	eval 'sub L2CR_L2PE () {0x40000000;}' unless defined(&L2CR_L2PE);
	eval 'sub L2CR_L2SIZ_MASK () {0x30000000;}' unless defined(&L2CR_L2SIZ_MASK);
	eval 'sub L2CR_L2SIZ_256KB () {0x10000000;}' unless defined(&L2CR_L2SIZ_256KB);
	eval 'sub L2CR_L2SIZ_512KB () {0x20000000;}' unless defined(&L2CR_L2SIZ_512KB);
	eval 'sub L2CR_L2SIZ_1MB () {0x30000000;}' unless defined(&L2CR_L2SIZ_1MB);
	eval 'sub L2CR_L2CLK_MASK () {0xe000000;}' unless defined(&L2CR_L2CLK_MASK);
	eval 'sub L2CR_L2CLK_DISABLED () {0x;}' unless defined(&L2CR_L2CLK_DISABLED);
	eval 'sub L2CR_L2CLK_DIV1 () {0x2000000;}' unless defined(&L2CR_L2CLK_DIV1);
	eval 'sub L2CR_L2CLK_DIV1_5 () {0x4000000;}' unless defined(&L2CR_L2CLK_DIV1_5);
	eval 'sub L2CR_L2CLK_DIV2 () {0x8000000;}' unless defined(&L2CR_L2CLK_DIV2);
	eval 'sub L2CR_L2CLK_DIV2_5 () {0xa000000;}' unless defined(&L2CR_L2CLK_DIV2_5);
	eval 'sub L2CR_L2CLK_DIV3 () {0xc000000;}' unless defined(&L2CR_L2CLK_DIV3);
	eval 'sub L2CR_L2RAM_MASK () {0x1800000;}' unless defined(&L2CR_L2RAM_MASK);
	eval 'sub L2CR_L2RAM_FLOW () {0x;}' unless defined(&L2CR_L2RAM_FLOW);
	eval 'sub L2CR_L2RAM_PIPE () {0x1000000;}' unless defined(&L2CR_L2RAM_PIPE);
	eval 'sub L2CR_L2RAM_PIPE_LW () {0x1800000;}' unless defined(&L2CR_L2RAM_PIPE_LW);
	eval 'sub L2CR_L2DO () {0x400000;}' unless defined(&L2CR_L2DO);
	eval 'sub L2CR_L2I () {0x200000;}' unless defined(&L2CR_L2I);
	eval 'sub L2CR_L2CTL () {0x100000;}' unless defined(&L2CR_L2CTL);
	eval 'sub L2CR_L2WT () {0x80000;}' unless defined(&L2CR_L2WT);
	eval 'sub L2CR_L2TS () {0x40000;}' unless defined(&L2CR_L2TS);
	eval 'sub L2CR_L2OH_MASK () {0x30000;}' unless defined(&L2CR_L2OH_MASK);
	eval 'sub L2CR_L2OH_0_5 () {0x;}' unless defined(&L2CR_L2OH_0_5);
	eval 'sub L2CR_L2OH_1_0 () {0x10000;}' unless defined(&L2CR_L2OH_1_0);
	eval 'sub L2CR_L2SL () {0x8000;}' unless defined(&L2CR_L2SL);
	eval 'sub L2CR_L2DF () {0x4000;}' unless defined(&L2CR_L2DF);
	eval 'sub L2CR_L2BYP () {0x2000;}' unless defined(&L2CR_L2BYP);
	eval 'sub L2CR_L2IP () {0x1;}' unless defined(&L2CR_L2IP);
	eval 'sub L2CR_L2IO_745x () {0x100000;}' unless defined(&L2CR_L2IO_745x);
	eval 'sub L2CR_L2DO_745x () {0x10000;}' unless defined(&L2CR_L2DO_745x);
	eval 'sub L2CR_L2REP_745x () {0x1000;}' unless defined(&L2CR_L2REP_745x);
	eval 'sub L2CR_L2HWF_745x () {0x800;}' unless defined(&L2CR_L2HWF_745x);
	eval 'sub SPRN_L3CR () {0x3fa;}' unless defined(&SPRN_L3CR);
	eval 'sub L3CR_L3E () {0x80000000;}' unless defined(&L3CR_L3E);
	eval 'sub L3CR_L3PE () {0x40000000;}' unless defined(&L3CR_L3PE);
	eval 'sub L3CR_L3APE () {0x20000000;}' unless defined(&L3CR_L3APE);
	eval 'sub L3CR_L3SIZ () {0x10000000;}' unless defined(&L3CR_L3SIZ);
	eval 'sub L3CR_L3CLKEN () {0x8000000;}' unless defined(&L3CR_L3CLKEN);
	eval 'sub L3CR_L3RES () {0x4000000;}' unless defined(&L3CR_L3RES);
	eval 'sub L3CR_L3CLKDIV () {0x3800000;}' unless defined(&L3CR_L3CLKDIV);
	eval 'sub L3CR_L3IO () {0x400000;}' unless defined(&L3CR_L3IO);
	eval 'sub L3CR_L3SPO () {0x40000;}' unless defined(&L3CR_L3SPO);
	eval 'sub L3CR_L3CKSP () {0x30000;}' unless defined(&L3CR_L3CKSP);
	eval 'sub L3CR_L3PSP () {0xe000;}' unless defined(&L3CR_L3PSP);
	eval 'sub L3CR_L3REP () {0x1000;}' unless defined(&L3CR_L3REP);
	eval 'sub L3CR_L3HWF () {0x800;}' unless defined(&L3CR_L3HWF);
	eval 'sub L3CR_L3I () {0x400;}' unless defined(&L3CR_L3I);
	eval 'sub L3CR_L3RT () {0x300;}' unless defined(&L3CR_L3RT);
	eval 'sub L3CR_L3NIRCA () {0x80;}' unless defined(&L3CR_L3NIRCA);
	eval 'sub L3CR_L3DO () {0x40;}' unless defined(&L3CR_L3DO);
	eval 'sub L3CR_PMEN () {0x4;}' unless defined(&L3CR_PMEN);
	eval 'sub L3CR_PMSIZ () {0x1;}' unless defined(&L3CR_PMSIZ);
	eval 'sub SPRN_MSSCR0 () {0x3f6;}' unless defined(&SPRN_MSSCR0);
	eval 'sub SPRN_MSSSR0 () {0x3f7;}' unless defined(&SPRN_MSSSR0);
	eval 'sub SPRN_LDSTCR () {0x3f8;}' unless defined(&SPRN_LDSTCR);
	eval 'sub SPRN_LDSTDB () {0x3f4;}' unless defined(&SPRN_LDSTDB);
	eval 'sub SPRN_LR () {0x8;}' unless defined(&SPRN_LR);
	unless(defined(&SPRN_PIR)) {
	    eval 'sub SPRN_PIR () {0x3ff;}' unless defined(&SPRN_PIR);
	}
	eval 'sub SPRN_PTEHI () {0x3d5;}' unless defined(&SPRN_PTEHI);
	eval 'sub SPRN_PTELO () {0x3d6;}' unless defined(&SPRN_PTELO);
	eval 'sub SPRN_PURR () {0x135;}' unless defined(&SPRN_PURR);
	eval 'sub SPRN_PVR () {0x11f;}' unless defined(&SPRN_PVR);
	eval 'sub SPRN_RPA () {0x3d6;}' unless defined(&SPRN_RPA);
	eval 'sub SPRN_SDA () {0x3bf;}' unless defined(&SPRN_SDA);
	eval 'sub SPRN_SDR1 () {0x19;}' unless defined(&SPRN_SDR1);
	eval 'sub SPRN_ASR () {0x118;}' unless defined(&SPRN_ASR);
	eval 'sub SPRN_SIA () {0x3bb;}' unless defined(&SPRN_SIA);
	eval 'sub SPRN_SPRG0 () {0x110;}' unless defined(&SPRN_SPRG0);
	eval 'sub SPRN_SPRG1 () {0x111;}' unless defined(&SPRN_SPRG1);
	eval 'sub SPRN_SPRG2 () {0x112;}' unless defined(&SPRN_SPRG2);
	eval 'sub SPRN_SPRG3 () {0x113;}' unless defined(&SPRN_SPRG3);
	eval 'sub SPRN_SPRG4 () {0x114;}' unless defined(&SPRN_SPRG4);
	eval 'sub SPRN_SPRG5 () {0x115;}' unless defined(&SPRN_SPRG5);
	eval 'sub SPRN_SPRG6 () {0x116;}' unless defined(&SPRN_SPRG6);
	eval 'sub SPRN_SPRG7 () {0x117;}' unless defined(&SPRN_SPRG7);
	eval 'sub SPRN_SRR0 () {0x1a;}' unless defined(&SPRN_SRR0);
	eval 'sub SPRN_SRR1 () {0x1b;}' unless defined(&SPRN_SRR1);
	eval 'sub SRR1_WAKEMASK () {0x380000;}' unless defined(&SRR1_WAKEMASK);
	eval 'sub SRR1_WAKERESET () {0x380000;}' unless defined(&SRR1_WAKERESET);
	eval 'sub SRR1_WAKESYSERR () {0x300000;}' unless defined(&SRR1_WAKESYSERR);
	eval 'sub SRR1_WAKEEE () {0x200000;}' unless defined(&SRR1_WAKEEE);
	eval 'sub SRR1_WAKEMT () {0x280000;}' unless defined(&SRR1_WAKEMT);
	eval 'sub SRR1_WAKEDEC () {0x180000;}' unless defined(&SRR1_WAKEDEC);
	eval 'sub SRR1_WAKETHERM () {0x100000;}' unless defined(&SRR1_WAKETHERM);
	eval 'sub SPRN_HSRR0 () {0x13a;}' unless defined(&SPRN_HSRR0);
	eval 'sub SPRN_HSRR1 () {0x13b;}' unless defined(&SPRN_HSRR1);
	unless(defined(&SPRN_SVR)) {
	    eval 'sub SPRN_SVR () {0x11e;}' unless defined(&SPRN_SVR);
	}
	eval 'sub SPRN_THRM1 () {0x3fc;}' unless defined(&SPRN_THRM1);
	eval 'sub THRM1_TIN () {(1<< 31);}' unless defined(&THRM1_TIN);
	eval 'sub THRM1_TIV () {(1<< 30);}' unless defined(&THRM1_TIV);
	eval 'sub THRM1_THRES {
	    my($x) = @_;
    	    eval q((($x&0x7f)<<23));
	}' unless defined(&THRM1_THRES);
	eval 'sub THRM3_SITV {
	    my($x) = @_;
    	    eval q((($x&0x3fff)<<1));
	}' unless defined(&THRM3_SITV);
	eval 'sub THRM1_TID () {(1<<2);}' unless defined(&THRM1_TID);
	eval 'sub THRM1_TIE () {(1<<1);}' unless defined(&THRM1_TIE);
	eval 'sub THRM1_V () {(1<<0);}' unless defined(&THRM1_V);
	eval 'sub SPRN_THRM2 () {0x3fd;}' unless defined(&SPRN_THRM2);
	eval 'sub SPRN_THRM3 () {0x3fe;}' unless defined(&SPRN_THRM3);
	eval 'sub THRM3_E () {(1<<0);}' unless defined(&THRM3_E);
	eval 'sub SPRN_TLBMISS () {0x3d4;}' unless defined(&SPRN_TLBMISS);
	eval 'sub SPRN_UMMCR0 () {0x3a8;}' unless defined(&SPRN_UMMCR0);
	eval 'sub SPRN_UMMCR1 () {0x3ac;}' unless defined(&SPRN_UMMCR1);
	eval 'sub SPRN_UPMC1 () {0x3a9;}' unless defined(&SPRN_UPMC1);
	eval 'sub SPRN_UPMC2 () {0x3aa;}' unless defined(&SPRN_UPMC2);
	eval 'sub SPRN_UPMC3 () {0x3ad;}' unless defined(&SPRN_UPMC3);
	eval 'sub SPRN_UPMC4 () {0x3ae;}' unless defined(&SPRN_UPMC4);
	eval 'sub SPRN_USIA () {0x3ab;}' unless defined(&SPRN_USIA);
	eval 'sub SPRN_VRSAVE () {0x100;}' unless defined(&SPRN_VRSAVE);
	eval 'sub SPRN_XER () {0x1;}' unless defined(&SPRN_XER);
	eval 'sub SPRN_SCOMC () {0x114;}' unless defined(&SPRN_SCOMC);
	eval 'sub SPRN_SCOMD () {0x115;}' unless defined(&SPRN_SCOMD);
	if(defined(&CONFIG_PPC64)) {
	    eval 'sub SPRN_MMCR0 () {795;}' unless defined(&SPRN_MMCR0);
	    eval 'sub MMCR0_FC () {0x80000000;}' unless defined(&MMCR0_FC);
	    eval 'sub MMCR0_FCS () {0x40000000;}' unless defined(&MMCR0_FCS);
	    eval 'sub MMCR0_KERNEL_DISABLE () { &MMCR0_FCS;}' unless defined(&MMCR0_KERNEL_DISABLE);
	    eval 'sub MMCR0_FCP () {0x20000000;}' unless defined(&MMCR0_FCP);
	    eval 'sub MMCR0_PROBLEM_DISABLE () { &MMCR0_FCP;}' unless defined(&MMCR0_PROBLEM_DISABLE);
	    eval 'sub MMCR0_FCM1 () {0x10000000;}' unless defined(&MMCR0_FCM1);
	    eval 'sub MMCR0_FCM0 () {0x8000000;}' unless defined(&MMCR0_FCM0);
	    eval 'sub MMCR0_PMXE () {0x4000000;}' unless defined(&MMCR0_PMXE);
	    eval 'sub MMCR0_FCECE () {0x2000000;}' unless defined(&MMCR0_FCECE);
	    eval 'sub MMCR0_TBEE () {0x400000;}' unless defined(&MMCR0_TBEE);
	    eval 'sub MMCR0_PMC1CE () {0x8000;}' unless defined(&MMCR0_PMC1CE);
	    eval 'sub MMCR0_PMCjCE () {0x4000;}' unless defined(&MMCR0_PMCjCE);
	    eval 'sub MMCR0_TRIGGER () {0x2000;}' unless defined(&MMCR0_TRIGGER);
	    eval 'sub MMCR0_PMAO () {0x80;}' unless defined(&MMCR0_PMAO);
	    eval 'sub MMCR0_SHRFC () {0x40;}' unless defined(&MMCR0_SHRFC);
	    eval 'sub MMCR0_FCTI () {0x8;}' unless defined(&MMCR0_FCTI);
	    eval 'sub MMCR0_FCTA () {0x4;}' unless defined(&MMCR0_FCTA);
	    eval 'sub MMCR0_FCWAIT () {0x2;}' unless defined(&MMCR0_FCWAIT);
	    eval 'sub MMCR0_FCHV () {0x1;}' unless defined(&MMCR0_FCHV);
	    eval 'sub SPRN_MMCR1 () {798;}' unless defined(&SPRN_MMCR1);
	    eval 'sub SPRN_MMCRA () {0x312;}' unless defined(&SPRN_MMCRA);
	    eval 'sub MMCRA_SIHV () {0x10000000;}' unless defined(&MMCRA_SIHV);
	    eval 'sub MMCRA_SIPR () {0x8000000;}' unless defined(&MMCRA_SIPR);
	    eval 'sub MMCRA_SAMPLE_ENABLE () {0x1;}' unless defined(&MMCRA_SAMPLE_ENABLE);
	    eval 'sub POWER6_MMCRA_SIHV () {4398046511104;}' unless defined(&POWER6_MMCRA_SIHV);
	    eval 'sub POWER6_MMCRA_SIPR () {2199023255552;}' unless defined(&POWER6_MMCRA_SIPR);
	    eval 'sub POWER6_MMCRA_THRM () {0x20;}' unless defined(&POWER6_MMCRA_THRM);
	    eval 'sub POWER6_MMCRA_OTHER () {0xe;}' unless defined(&POWER6_MMCRA_OTHER);
	    eval 'sub SPRN_PMC1 () {787;}' unless defined(&SPRN_PMC1);
	    eval 'sub SPRN_PMC2 () {788;}' unless defined(&SPRN_PMC2);
	    eval 'sub SPRN_PMC3 () {789;}' unless defined(&SPRN_PMC3);
	    eval 'sub SPRN_PMC4 () {790;}' unless defined(&SPRN_PMC4);
	    eval 'sub SPRN_PMC5 () {791;}' unless defined(&SPRN_PMC5);
	    eval 'sub SPRN_PMC6 () {792;}' unless defined(&SPRN_PMC6);
	    eval 'sub SPRN_PMC7 () {793;}' unless defined(&SPRN_PMC7);
	    eval 'sub SPRN_PMC8 () {794;}' unless defined(&SPRN_PMC8);
	    eval 'sub SPRN_SIAR () {780;}' unless defined(&SPRN_SIAR);
	    eval 'sub SPRN_SDAR () {781;}' unless defined(&SPRN_SDAR);
	} else {
	    eval 'sub SPRN_MMCR0 () {952;}' unless defined(&SPRN_MMCR0);
	    eval 'sub MMCR0_FC () {0x80000000;}' unless defined(&MMCR0_FC);
	    eval 'sub MMCR0_FCS () {0x40000000;}' unless defined(&MMCR0_FCS);
	    eval 'sub MMCR0_FCP () {0x20000000;}' unless defined(&MMCR0_FCP);
	    eval 'sub MMCR0_FCM1 () {0x10000000;}' unless defined(&MMCR0_FCM1);
	    eval 'sub MMCR0_FCM0 () {0x8000000;}' unless defined(&MMCR0_FCM0);
	    eval 'sub MMCR0_PMXE () {0x4000000;}' unless defined(&MMCR0_PMXE);
	    eval 'sub MMCR0_FCECE () {0x2000000;}' unless defined(&MMCR0_FCECE);
	    eval 'sub MMCR0_TBEE () {0x400000;}' unless defined(&MMCR0_TBEE);
	    eval 'sub MMCR0_PMC1CE () {0x8000;}' unless defined(&MMCR0_PMC1CE);
	    eval 'sub MMCR0_PMCnCE () {0x4000;}' unless defined(&MMCR0_PMCnCE);
	    eval 'sub MMCR0_TRIGGER () {0x2000;}' unless defined(&MMCR0_TRIGGER);
	    eval 'sub MMCR0_PMC1SEL () {0x1fc0;}' unless defined(&MMCR0_PMC1SEL);
	    eval 'sub MMCR0_PMC2SEL () {0x3f;}' unless defined(&MMCR0_PMC2SEL);
	    eval 'sub SPRN_MMCR1 () {956;}' unless defined(&SPRN_MMCR1);
	    eval 'sub MMCR1_PMC3SEL () {0xf8000000;}' unless defined(&MMCR1_PMC3SEL);
	    eval 'sub MMCR1_PMC4SEL () {0x7c00000;}' unless defined(&MMCR1_PMC4SEL);
	    eval 'sub MMCR1_PMC5SEL () {0x3e0000;}' unless defined(&MMCR1_PMC5SEL);
	    eval 'sub MMCR1_PMC6SEL () {0x1f800;}' unless defined(&MMCR1_PMC6SEL);
	    eval 'sub SPRN_MMCR2 () {944;}' unless defined(&SPRN_MMCR2);
	    eval 'sub SPRN_PMC1 () {953;}' unless defined(&SPRN_PMC1);
	    eval 'sub SPRN_PMC2 () {954;}' unless defined(&SPRN_PMC2);
	    eval 'sub SPRN_PMC3 () {957;}' unless defined(&SPRN_PMC3);
	    eval 'sub SPRN_PMC4 () {958;}' unless defined(&SPRN_PMC4);
	    eval 'sub SPRN_PMC5 () {945;}' unless defined(&SPRN_PMC5);
	    eval 'sub SPRN_PMC6 () {946;}' unless defined(&SPRN_PMC6);
	    eval 'sub SPRN_SIAR () {955;}' unless defined(&SPRN_SIAR);
	    eval 'sub MMCR0_PMC1_CYCLES () {(1<< 7);}' unless defined(&MMCR0_PMC1_CYCLES);
	    eval 'sub MMCR0_PMC1_ICACHEMISS () {(5<< 7);}' unless defined(&MMCR0_PMC1_ICACHEMISS);
	    eval 'sub MMCR0_PMC1_DTLB () {(6<< 7);}' unless defined(&MMCR0_PMC1_DTLB);
	    eval 'sub MMCR0_PMC2_DCACHEMISS () {0x6;}' unless defined(&MMCR0_PMC2_DCACHEMISS);
	    eval 'sub MMCR0_PMC2_CYCLES () {0x1;}' unless defined(&MMCR0_PMC2_CYCLES);
	    eval 'sub MMCR0_PMC2_ITLB () {0x7;}' unless defined(&MMCR0_PMC2_ITLB);
	    eval 'sub MMCR0_PMC2_LOADMISSTIME () {0x5;}' unless defined(&MMCR0_PMC2_LOADMISSTIME);
	}
	if(defined(&CONFIG_PPC64)) {
	    eval 'sub MTFSF_L {
	        my($REG) = @_;
    		eval q(. &long (0xfc00058e | ((0xff) << 17) | (($REG) << 11) | (1<< 25)));
	    }' unless defined(&MTFSF_L);
	} else {
	    eval 'sub MTFSF_L {
	        my($REG) = @_;
    		eval q( &mtfsf 0xff, ($REG));
	    }' unless defined(&MTFSF_L);
	}
	eval 'sub PVR_VER {
	    my($pvr) = @_;
    	    eval q(((($pvr) >> 16) & 0xffff));
	}' unless defined(&PVR_VER);
	eval 'sub PVR_REV {
	    my($pvr) = @_;
    	    eval q(((($pvr) >> 0) & 0xffff));
	}' unless defined(&PVR_REV);
	eval 'sub __is_processor {
	    my($pv) = @_;
    	    eval q(( &PVR_VER( &mfspr( &SPRN_PVR)) == ($pv)));
	}' unless defined(&__is_processor);
	eval 'sub PVR_FAM {
	    my($pvr) = @_;
    	    eval q(((($pvr) >> 20) & 0xfff));
	}' unless defined(&PVR_FAM);
	eval 'sub PVR_MEM {
	    my($pvr) = @_;
    	    eval q(((($pvr) >> 16) & 0xf));
	}' unless defined(&PVR_MEM);
	eval 'sub PVR_CORE {
	    my($pvr) = @_;
    	    eval q(((($pvr) >> 12) & 0xf));
	}' unless defined(&PVR_CORE);
	eval 'sub PVR_CFG {
	    my($pvr) = @_;
    	    eval q(((($pvr) >> 8) & 0xf));
	}' unless defined(&PVR_CFG);
	eval 'sub PVR_MAJ {
	    my($pvr) = @_;
    	    eval q(((($pvr) >> 4) & 0xf));
	}' unless defined(&PVR_MAJ);
	eval 'sub PVR_MIN {
	    my($pvr) = @_;
    	    eval q(((($pvr) >> 0) & 0xf));
	}' unless defined(&PVR_MIN);
	eval 'sub PVR_403GA () {0x200000;}' unless defined(&PVR_403GA);
	eval 'sub PVR_403GB () {0x200100;}' unless defined(&PVR_403GB);
	eval 'sub PVR_403GC () {0x200200;}' unless defined(&PVR_403GC);
	eval 'sub PVR_403GCX () {0x201400;}' unless defined(&PVR_403GCX);
	eval 'sub PVR_405GP () {0x40110000;}' unless defined(&PVR_405GP);
	eval 'sub PVR_STB03XXX () {0x40310000;}' unless defined(&PVR_STB03XXX);
	eval 'sub PVR_NP405H () {0x41410000;}' unless defined(&PVR_NP405H);
	eval 'sub PVR_NP405L () {0x41610000;}' unless defined(&PVR_NP405L);
	eval 'sub PVR_601 () {0x10000;}' unless defined(&PVR_601);
	eval 'sub PVR_602 () {0x50000;}' unless defined(&PVR_602);
	eval 'sub PVR_603 () {0x30000;}' unless defined(&PVR_603);
	eval 'sub PVR_603e () {0x60000;}' unless defined(&PVR_603e);
	eval 'sub PVR_603ev () {0x70000;}' unless defined(&PVR_603ev);
	eval 'sub PVR_603r () {0x71000;}' unless defined(&PVR_603r);
	eval 'sub PVR_604 () {0x40000;}' unless defined(&PVR_604);
	eval 'sub PVR_604e () {0x90000;}' unless defined(&PVR_604e);
	eval 'sub PVR_604r () {0xa0000;}' unless defined(&PVR_604r);
	eval 'sub PVR_620 () {0x140000;}' unless defined(&PVR_620);
	eval 'sub PVR_740 () {0x80000;}' unless defined(&PVR_740);
	eval 'sub PVR_750 () { &PVR_740;}' unless defined(&PVR_750);
	eval 'sub PVR_740P () {0x10080000;}' unless defined(&PVR_740P);
	eval 'sub PVR_750P () { &PVR_740P;}' unless defined(&PVR_750P);
	eval 'sub PVR_7400 () {0xc0000;}' unless defined(&PVR_7400);
	eval 'sub PVR_7410 () {0x800c0000;}' unless defined(&PVR_7410);
	eval 'sub PVR_7450 () {0x80000000;}' unless defined(&PVR_7450);
	eval 'sub PVR_8540 () {0x80200000;}' unless defined(&PVR_8540);
	eval 'sub PVR_8560 () {0x80200000;}' unless defined(&PVR_8560);
	eval 'sub PVR_821 () {0x500000;}' unless defined(&PVR_821);
	eval 'sub PVR_823 () { &PVR_821;}' unless defined(&PVR_823);
	eval 'sub PVR_850 () { &PVR_821;}' unless defined(&PVR_850);
	eval 'sub PVR_860 () { &PVR_821;}' unless defined(&PVR_860);
	eval 'sub PVR_8240 () {0x810100;}' unless defined(&PVR_8240);
	eval 'sub PVR_8245 () {0x80811014;}' unless defined(&PVR_8245);
	eval 'sub PVR_8260 () { &PVR_8240;}' unless defined(&PVR_8260);
	eval 'sub PV_NORTHSTAR () {0x33;}' unless defined(&PV_NORTHSTAR);
	eval 'sub PV_PULSAR () {0x34;}' unless defined(&PV_PULSAR);
	eval 'sub PV_POWER4 () {0x35;}' unless defined(&PV_POWER4);
	eval 'sub PV_ICESTAR () {0x36;}' unless defined(&PV_ICESTAR);
	eval 'sub PV_SSTAR () {0x37;}' unless defined(&PV_SSTAR);
	eval 'sub PV_POWER4p () {0x38;}' unless defined(&PV_POWER4p);
	eval 'sub PV_970 () {0x39;}' unless defined(&PV_970);
	eval 'sub PV_POWER5 () {0x3a;}' unless defined(&PV_POWER5);
	eval 'sub PV_POWER5p () {0x3b;}' unless defined(&PV_POWER5p);
	eval 'sub PV_970FX () {0x3c;}' unless defined(&PV_970FX);
	eval 'sub PV_630 () {0x40;}' unless defined(&PV_630);
	eval 'sub PV_630p () {0x41;}' unless defined(&PV_630p);
	eval 'sub PV_970MP () {0x44;}' unless defined(&PV_970MP);
	eval 'sub PV_BE () {0x70;}' unless defined(&PV_BE);
	eval 'sub SLB_NUM_ENTRIES () {64;}' unless defined(&SLB_NUM_ENTRIES);
	unless(defined(&__ASSEMBLY__)) {
	    eval 'sub mfmsr () {
	        eval q(({\'unsigned long rval\';  &asm  &volatile(\\"mfmsr %0\\" : \\"=r\\" ( &rval));  &rval;}));
	    }' unless defined(&mfmsr);
	    if(defined(&CONFIG_PPC64)) {
		eval 'sub __mtmsrd {
		    my($v, $l) = @_;
    		    eval q( &asm  &volatile(\\"mtmsrd %0,\\"  &__stringify($l) : : \\"r\\" ($v)));
		}' unless defined(&__mtmsrd);
		eval 'sub mtmsrd {
		    my($v) = @_;
    		    eval q( &__mtmsrd(($v), 0));
		}' unless defined(&mtmsrd);
		eval 'sub mtmsr {
		    my($v) = @_;
    		    eval q( &mtmsrd($v));
		}' unless defined(&mtmsr);
	    } else {
		eval 'sub mtmsr {
		    my($v) = @_;
    		    eval q( &asm  &volatile(\\"mtmsr %0\\" : : \\"r\\" ($v)));
		}' unless defined(&mtmsr);
	    }
	    eval 'sub mfspr {
	        my($rn) = @_;
    		eval q(({\'unsigned long rval\';  &asm  &volatile(\\"mfspr %0,\\"  &__stringify($rn) : \\"=r\\" ( &rval));  &rval;}));
	    }' unless defined(&mfspr);
	    eval 'sub mtspr {
	        my($rn, $v) = @_;
    		eval q( &asm  &volatile(\\"mtspr \\"  &__stringify($rn) \\",%0\\" : : \\"r\\" ($v)));
	    }' unless defined(&mtspr);
	    eval 'sub mftb () {
	        eval q(({\'unsigned long rval\';  &asm  &volatile(\\"mftb %0\\" : \\"=r\\" ( &rval));  &rval;}));
	    }' unless defined(&mftb);
	    eval 'sub mftbl () {
	        eval q(({\'unsigned long rval\';  &asm  &volatile(\\"mftbl %0\\" : \\"=r\\" ( &rval));  &rval;}));
	    }' unless defined(&mftbl);
	    eval 'sub mttbl {
	        my($v) = @_;
    		eval q( &asm  &volatile(\\"mttbl %0\\":: \\"r\\"($v)));
	    }' unless defined(&mttbl);
	    eval 'sub mttbu {
	        my($v) = @_;
    		eval q( &asm  &volatile(\\"mttbu %0\\":: \\"r\\"($v)));
	    }' unless defined(&mttbu);
	    if(defined(&CONFIG_PPC32)) {
		eval 'sub mfsrin {
		    my($v) = @_;
    		    eval q(({\'unsigned int rval\';  &asm  &volatile(\\"mfsrin %0,%1\\" : \\"=r\\" ( &rval) : \\"r\\" ($v));  &rval;}));
		}' unless defined(&mfsrin);
	    }
	    eval 'sub proc_trap () {
	        eval q( &asm  &volatile(\\"trap\\"));
	    }' unless defined(&proc_trap);
	    if(defined(&CONFIG_PPC64)) {
	    } else {
		eval 'sub ppc64_runlatch_on () {
		    eval q();
		}' unless defined(&ppc64_runlatch_on);
		eval 'sub ppc64_runlatch_off () {
		    eval q();
		}' unless defined(&ppc64_runlatch_off);
	    }
	    eval 'sub __get_SP () {
	        eval q(({\'unsigned long sp\';  &asm  &volatile(\\"mr %0,1\\": \\"=r\\" ( &sp));  &sp;}));
	    }' unless defined(&__get_SP);
	}
    }
}
1;
