require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_POWERPC_ATOMIC_H_)) {
    eval 'sub _ASM_POWERPC_ATOMIC_H_ () {1;}' unless defined(&_ASM_POWERPC_ATOMIC_H_);
    if(defined(&__KERNEL__)) {
	require 'linux/compiler.ph';
	require 'asm/synch.ph';
	require 'asm/asm-compat.ph';
	eval 'sub ATOMIC_INIT {
	    my($i) = @_;
    	    eval q({ ($i) });
	}' unless defined(&ATOMIC_INIT);
	eval 'sub atomic_read {
	    my($v) = @_;
    	    eval q((($v)-> &counter));
	}' unless defined(&atomic_read);
	eval 'sub atomic_set {
	    my($v,$i) = @_;
    	    eval q(((($v)-> &counter) = ($i)));
	}' unless defined(&atomic_set);
	eval 'sub atomic_add {
	    my($a,$v) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&atomic_add);
	eval 'sub atomic_add_return {
	    my($a,$v) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&atomic_add_return);
	eval 'sub atomic_add_negative {
	    my($a, $v) = @_;
    	    eval q(( &atomic_add_return(($a), ($v)) < 0));
	}' unless defined(&atomic_add_negative);
	eval 'sub atomic_sub {
	    my($a,$v) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&atomic_sub);
	eval 'sub atomic_sub_return {
	    my($a,$v) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&atomic_sub_return);
	eval 'sub atomic_inc {
	    my($v) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&atomic_inc);
	eval 'sub atomic_inc_return {
	    my($v) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&atomic_inc_return);
	eval 'sub atomic_inc_and_test {
	    my($v) = @_;
    	    eval q(( &atomic_inc_return($v) == 0));
	}' unless defined(&atomic_inc_and_test);
	eval 'sub atomic_dec {
	    my($v) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&atomic_dec);
	eval 'sub atomic_dec_return {
	    my($v) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&atomic_dec_return);
	eval 'sub atomic_cmpxchg {
	    my($v, $o, $n) = @_;
    	    eval q(( &cmpxchg((($v)-> &counter), ($o), ($n))));
	}' unless defined(&atomic_cmpxchg);
	eval 'sub atomic_xchg {
	    my($v, $new) = @_;
    	    eval q(( &xchg((($v)-> &counter), $new)));
	}' unless defined(&atomic_xchg);
	eval 'sub atomic_inc_not_zero {
	    my($v) = @_;
    	    eval q( &atomic_add_unless(($v), 1, 0));
	}' unless defined(&atomic_inc_not_zero);
	eval 'sub atomic_sub_and_test {
	    my($a, $v) = @_;
    	    eval q(( &atomic_sub_return(($a), ($v)) == 0));
	}' unless defined(&atomic_sub_and_test);
	eval 'sub atomic_dec_and_test {
	    my($v) = @_;
    	    eval q(( &atomic_dec_return(($v)) == 0));
	}' unless defined(&atomic_dec_and_test);
	eval 'sub smp_mb__before_atomic_dec () {
	    eval q( &smp_mb());
	}' unless defined(&smp_mb__before_atomic_dec);
	eval 'sub smp_mb__after_atomic_dec () {
	    eval q( &smp_mb());
	}' unless defined(&smp_mb__after_atomic_dec);
	eval 'sub smp_mb__before_atomic_inc () {
	    eval q( &smp_mb());
	}' unless defined(&smp_mb__before_atomic_inc);
	eval 'sub smp_mb__after_atomic_inc () {
	    eval q( &smp_mb());
	}' unless defined(&smp_mb__after_atomic_inc);
	if(defined(&__powerpc64__)) {
	    eval 'sub ATOMIC64_INIT {
	        my($i) = @_;
    		eval q({ ($i) });
	    }' unless defined(&ATOMIC64_INIT);
	    eval 'sub atomic64_read {
	        my($v) = @_;
    		eval q((($v)-> &counter));
	    }' unless defined(&atomic64_read);
	    eval 'sub atomic64_set {
	        my($v,$i) = @_;
    		eval q(((($v)-> &counter) = ($i)));
	    }' unless defined(&atomic64_set);
	    eval 'sub atomic64_add {
	        my($a,$v) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&atomic64_add);
	    eval 'sub atomic64_add_return {
	        my($a,$v) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&atomic64_add_return);
	    eval 'sub atomic64_add_negative {
	        my($a, $v) = @_;
    		eval q(( &atomic64_add_return(($a), ($v)) < 0));
	    }' unless defined(&atomic64_add_negative);
	    eval 'sub atomic64_sub {
	        my($a,$v) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&atomic64_sub);
	    eval 'sub atomic64_sub_return {
	        my($a,$v) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&atomic64_sub_return);
	    eval 'sub atomic64_inc {
	        my($v) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&atomic64_inc);
	    eval 'sub atomic64_inc_return {
	        my($v) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&atomic64_inc_return);
	    eval 'sub atomic64_inc_and_test {
	        my($v) = @_;
    		eval q(( &atomic64_inc_return($v) == 0));
	    }' unless defined(&atomic64_inc_and_test);
	    eval 'sub atomic64_dec {
	        my($v) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&atomic64_dec);
	    eval 'sub atomic64_dec_return {
	        my($v) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&atomic64_dec_return);
	    eval 'sub atomic64_sub_and_test {
	        my($a, $v) = @_;
    		eval q(( &atomic64_sub_return(($a), ($v)) == 0));
	    }' unless defined(&atomic64_sub_and_test);
	    eval 'sub atomic64_dec_and_test {
	        my($v) = @_;
    		eval q(( &atomic64_dec_return(($v)) == 0));
	    }' unless defined(&atomic64_dec_and_test);
	}
	require 'asm-generic/atomic.ph';
    }
}
1;
