                  |             '            z      
  4  :     
o               x                   -  [       %                     N  Z  	    G         x       ^     <    "1     #H     $      $     %j    &     '     (     )U  Q  *     +e     +     ,     -v     .)      
                       
                                                           	       @FUNCTION=BIN2DEC
@SYNTAX=BIN2DEC(x)
@DESCRIPTION=BIN2DEC function converts a binary number in string or number to its decimal equivalent.

* This function is Excel compatible.

@EXAMPLES=
BIN2DEC(101) equals 5.

@SEEALSO=DEC2BIN, BIN2OCT, BIN2HEX @FUNCTION=DATE
@SYNTAX=DATE (year,month,day)
@DESCRIPTION=DATE returns the number of days since the 1st of January of 1900(the date serial number) for the given year, month and day.

* If @month < 1 or @month > 12, the year will be corrected.  A similar correction takes place for days.
* The @years should be at least 1900.  If @years < 1900, it is assumed to be 1900 + @years.
* If the given date is not valid, DATE returns #NUM! error.
* This function is Excel compatible.

@EXAMPLES=
DATE(2001, 3, 30) returns 'Mar 30, 2001'.
 
@SEEALSO=TODAY, NOW @FUNCTION=DATEVALUE
@SYNTAX=DATEVALUE(date_str)
@DESCRIPTION=DATEVALUE returns the serial number of the date.  @date_str is the string that contains the date. The value depends on the date convention.  The MS Excel 1900 convention dates things from Jan 1 1900 while the 1904 convention uses Jan 1 1904.

* This function is Excel compatible.

@EXAMPLES=
DATEVALUE("1/1/1999") equals 36161 (in the 1900 convention).
@SEEALSO=DATE @FUNCTION=EDATE
@SYNTAX=EDATE(date,months)
@DESCRIPTION=EDATE returns the serial number of the date that is the specified number of months before or after a given date.  @date is the serial number of the initial date and @months is the number of months before (negative number) or after (positive number) the initial date.

* If @months is not an integer, it is truncated.
* This function is Excel compatible.

@EXAMPLES=
EDATE(DATE(2001,12,30),2) returns 'Feb 28, 2002'.

@SEEALSO=DATE @FUNCTION=EOMONTH
@SYNTAX=EOMONTH (start_date,months)
@DESCRIPTION=EOMONTH returns the last day of the month which is @months from the @start_date.

* EOMONTH returns #NUM! if @start_date or @months are invalid.
* This function is Excel compatible.

@EXAMPLES=
If A1 contains 12/21/00 then EOMONTH(A1,0)=12/31/00, EOMONTH(A1,5)=5/31/01, and EOMONTH(A1,2)=2/28/01

@SEEALSO=MONTH @FUNCTION=EURO
@SYNTAX=EURO(currency)
@DESCRIPTION=EURO converts one Euro to a given national currency in the European monetary union.

@currency is one of the following:

    ATS	(Austria)
    BEF	(Belgium)
    DEM	(Germany)
    ESP	(Spain)
    EUR	(Euro)
    FIM	(Finland)
    FRF	(France)
    GRD	(Greek)
    IEP	(Ireland)
    ITL	(Italy)
    LUF	(Luxembourg)
    NLG	(Netherlands)
    PTE	(Portugal)

* If the given @currency is other than one of the above, EURO returns #NUM! error.

@EXAMPLES=
EURO("DEM") returns 1.95583.
@SEEALSO= @FUNCTION=EXPRESSION
@SYNTAX=EXPRESSION(cell)
@DESCRIPTION=EXPRESSION returns expression in @cell as a string, or empty if the cell is not an expression.
@EXAMPLES=
entering '=EXPRESSION(A3)' in A2 = empty (assuming there is nothing in A3).
entering '=EXPRESSION(A2)' in A1 = 'EXPRESSION(A3)'.

@SEEALSO=TEXT @FUNCTION=FALSE
@SYNTAX=FALSE()
@DESCRIPTION=FALSE returns boolean value false.

* This function is Excel compatible.

@EXAMPLES=
FALSE() equals FALSE.

@SEEALSO=TRUE @FUNCTION=ISPRIME
@SYNTAX=ISPRIME(i)
@DESCRIPTION=ISPRIME function returns TRUE if @i is prime and FALSE otherwise.

@EXAMPLES=
@SEEALSO=ITHPRIME, NT_D, NT_SIGMA @FUNCTION=ISTEXT
@SYNTAX=ISTEXT(value)
@DESCRIPTION=ISTEXT returns TRUE if the value is text.

* This function is Excel compatible.

@EXAMPLES=
ISTEXT("text") equals TRUE.

@SEEALSO=ISNONTEXT @FUNCTION=ITHPRIME
@SYNTAX=ITHPRIME(i)
@DESCRIPTION=ITHPRIME function returns the @ith prime.

@EXAMPLES=
@SEEALSO=NT_D, NT_SIGMA @FUNCTION=NOW
@SYNTAX=NOW ()
@DESCRIPTION=NOW returns the serial number for the date and time at the time it is evaluated.

Serial Numbers in Gnumeric are represented as follows:The integral part is the number of days since the 1st of January of 1900.  The decimal part represent the fraction of the day and is mapped into hour, minutes and seconds.

For example: .0 represents the beginning of the day, and 0.5 represents noon.

* This function is Excel compatible.

@EXAMPLES=
NOW().

@SEEALSO=TODAY @FUNCTION=NT_D
@SYNTAX=NT_D(n)
@DESCRIPTION=NT_D function calculates the number of divisors of @n.

@EXAMPLES=
@SEEALSO=ITHPRIME, NT_PHI, NT_SIGMA @FUNCTION=NT_PI
@SYNTAX=NT_PI(n)
@DESCRIPTION=NT_PI function returns the number of primes less than or equal to @n.

@EXAMPLES=
@SEEALSO=ITHPRIME, NT_PHI, NT_D, NT_SIGMA @FUNCTION=NT_SIGMA
@SYNTAX=NT_SIGMA(n)
@DESCRIPTION=NT_SIGMA function calculates the sum of the divisors of @n.

@EXAMPLES=
@SEEALSO=NT_D, ITHPRIME, NT_PHI @FUNCTION=SUBSTITUTE
@SYNTAX=SUBSTITUTE(text, old, new [,num])
@DESCRIPTION=SUBSTITUTE replaces @old with @new in @text.  Substitutions are only applied to instance @num of @old in @text, otherwise every one is changed.

* This function is Excel compatible.

@EXAMPLES=
SUBSTITUTE("testing","test","wait") equals "waiting".

@SEEALSO=REPLACE, TRIM @FUNCTION=TIME
@SYNTAX=TIME (hours,minutes,seconds)
@DESCRIPTION=TIME returns a fraction representing the time of day.

* This function is Excel compatible.

@EXAMPLES=
TIME(3, 5, 23) equals 3:05AM.

@SEEALSO=HOUR @FUNCTION=TODAY
@SYNTAX=TODAY()
@DESCRIPTION=TODAY returns the serial number for today (the number of days elapsed since the 1st of January of 1900).

* This function is Excel compatible.

@EXAMPLES=
TODAY() returns 'Nov 6, 2001' on that particular day.
 
@SEEALSO=NOW @FUNCTION=TRIM
@SYNTAX=TRIM(text)
@DESCRIPTION=TRIM returns @text with only single spaces between words.

* This function is Excel compatible.

@EXAMPLES=
TRIM("  a bbb  cc") equals "a bbb cc".

@SEEALSO=CLEAN, MID, REPLACE, SUBSTITUTE @FUNCTION=TRUE
@SYNTAX=TRUE()
@DESCRIPTION=TRUE returns boolean value true.

* This function is Excel compatible.

@EXAMPLES=
TRUE() equals TRUE.

@SEEALSO=FALSE @FUNCTION=VALUE
@SYNTAX=VALUE(text)
@DESCRIPTION=VALUE returns numeric value of @text.

* This function is Excel compatible.

@EXAMPLES=
VALUE("$1,000") equals 1000.

@SEEALSO=DOLLAR, FIXED, TEXT Project-Id-Version: gnumeric
Report-Msgid-Bugs-To: 
POT-Creation-Date: 2005-02-12 11:12-0500
PO-Revision-Date: 2000-05-16 23:20+0200
Last-Translator: Jesús Bravo Álvarez <jba@pobox.com>
Language-Team: Galician <gpul-traduccion@ceu.fi.udc.es>
MIME-Version: 1.0
Content-Type: text/plain; charset=UTF-8
Content-Transfer-Encoding: 8bit
 @FUNCTION=BIN2DEC
@SYNTAX=BIN2DEC(x)
@DESCRIPTION=A función BIN2DEC converte un número binario nunha cadea ou nun número ó seu equivalente decimal. Esta función é compatible con Excel. 
@EXAMPLES=
BIN2DEC(101) é igual a 5.

@SEEALSO=DEC2BIN, BIN2OCT, BIN2HEX @FUNCTION=DATE
@SYNTAX=DATE (ano,mes,día)
@DESCRIPTION=Calcula o número de días dende o 1 de xaneiro de 1900 (o número de serie da data) para o ano, mes e día indicados.
O @día pode ser negativo (para contar cara atrás) e é relativo ó @mes anterior.  O @ano ten que ser polo menos 1900.
@EXAMPLES=

@SEEALSO=TODAY, NOW @FUNCTION=DATEVALUE
@SYNTAX=DATEVALUE(cadea_data)
@DESCRIPTION=DATEVALUE devolve o número de serie da data.  @cadea_data é a cadea que contén a data.  Por exemplo, DATEVALUE("1/1/1999") é igual a 36160. 
@EXAMPLES=

@SEEALSO=DATE @FUNCTION=EDATE
@SYNTAX=EDATE(data,meses)
@DESCRIPTION=EDATE devolve o número serie da data correspondente ó número de meses antes ou despois da indicada.  @data é o número de serie da data inicial e @meses é o número de meses antes (número negativo) ou despois (número positivo) da data inicial.
Se @meses non é un enteiro, será truncado.
@EXAMPLES=

@SEEALSO=DATE @FUNCTION=EOMONTH
@SYNTAX=EOMONTH (data_inicial,meses)
@DESCRIPTION=Devolve o último día do mes que vai @meses despois da @data_inicial.
Devolve #NÚM! se data_inicial ou meses son inválidos.
@EXAMPLES=

@SEEALSO=MONTH @FUNCTION=EURO
@SYNTAX=EURO(divisa)
@DESCRIPTION=EURO converte un Euro a unha divisa nacional da unión monetaria europa.  A @divisa é unha das seguintes:
    ATS	(Austria)
    BEF	(Bélxica)
    DEM	(Alemaña)
    ESP	(España)
    FIM	(Finlandia)
    FRF	(Francia)
    GRD	(Greek)
    IEP	(Irlanda)
    ITL	(Italia)
    LUF	(Luxemburgo)
    NLG	(Holanda)
    PTE	(Portugal)

Se a @divisa indicada non é ningunha delas, EURO devolve o erro #NUM!. 
@EXAMPLES=
EURO("DEM") devolve 1.95583.
@SEEALSO= @FUNCTION=EXPRESSION
@SYNTAX=EXPRESSION(cela)
@DESCRIPTION=EXPRESSION devolve a expresión en @cela como unha cadea, ou baleiro se a cela non é unha expresión.
@EXAMPLES=
en A1 EXPRESSION(A2) é igual a 'EXPRESSION(A3)'.
en A2 EXPRESSION(A3) é igual a baleiro.

@SEEALSO=TEXT @FUNCTION=FALSE
@SYNTAX=FALSE()
@DESCRIPTION=FALSE devolve o valor booleano false (falso).  Esta función é compatible con Excel. 
@EXAMPLES=
FALSE() é igual a FALSE.

@SEEALSO=TRUE @FUNCTION=ISPRIME
@SYNTAX=ISPRIME(i)
@DESCRIPTION=A función ISPRIME devolve TRUE se @i é primo e FALSE doutro xeito.
Esta función só admite un argumento.
@EXAMPLES=
@SEEALSO=ITHPRIME, NT_D, NT_SIGMA @FUNCTION=ISTEXT
@SYNTAX=ISTEXT()
@DESCRIPTION=ISTEXT devolve TRUE se o valor é texto. Esta función é compatible con Excel. 
@EXAMPLES=

@SEEALSO=ISNONTEXT @FUNCTION=ITHPRIME
@SYNTAX=ITHPRIME(i)
@DESCRIPTION=A función ITHPRIME devolve o primo @i-ésimo.
Esta función só admite un argumento.
@EXAMPLES=
@SEEALSO=NT_D, NT_SIGMA @FUNCTION=NOW
@SYNTAX=NOW ()
@DESCRIPTION=Devolve o número de serie da data e hora no momento en que se evalúa.
Os Números de Serie en Gnumeric se representan deste xeito: A parte enteira é o número de días dende o 1 de xaneiro de 1900.  A parte decimal representa a fracción do día e se asocia ás horas, minutos e segundos.
For example: .0 representa o comezo do día, e 0.5 representa o medio día.
@EXAMPLES=

@SEEALSO=TODAY, NOW @FUNCTION=NT_D
@SYNTAX=NT_D(n)
@DESCRIPTION=A función NT_D calcula o número de divisores de @n
Esta función só admite un argumento.
@EXAMPLES=
@SEEALSO=ITHPRIME, NT_PHI, NT_SIGMA @FUNCTION=NT_PI
@SYNTAX=NT_PI(n)
@DESCRIPTION=A función NT_PI devolve o número de primos menor o igual que @n.
Esta función só admite un argumento.
@EXAMPLES=
@SEEALSO=ITHPRIME, NT_PHI, NT_D, NT_SIGMA @FUNCTION=NT_SIGMA
@SYNTAX=NT_SIGMA(n)
@DESCRIPTION=A función NT_SIGMA calcula a suma dos divisores de @n.
Esta función só admite un argumento.
@EXAMPLES=
@SEEALSO=NT_D, ITHPRIME, NT_PHI @FUNCTION=SUBSITUTE
@SYNTAX=SUBSTITUTE(texto, vello, novo [,núm])
@DESCRIPTION=SUBSTITUTE rempraza @vello por @novo en @texto.  As substitucións aplícanse só a aparición @num de @vello no @texto, se non se indica substitúense todos.
@EXAMPLES=
SUBSTITUTE("probando","proba","espera") é igual a "esperando".

@SEEALSO=REPLACE, TRIM @FUNCTION=TIME
@SYNTAX=TIME (horas,minutos,segundos)
@DESCRIPTION=Devolve unha fracción representando a hora do día.
@EXAMPLES=

@SEEALSO=HOUR @FUNCTION=TODAY
@SYNTAX=TODAY ()
@DESCRIPTION=Devolve o número de serie para hoxe (o número de días transcorridos dende o 1 de xaneiro de 1900).
@EXAMPLES=

@SEEALSO=TODAY, NOW @FUNCTION=TRIM
@SYNTAX=TRIM(texto)
@DESCRIPTION=TRIM devolve @texto con espacios simples entre as palabras.
@EXAMPLES=
TRIM("  a bbb  cc") é igual a "a bbb cc".

@SEEALSO=CLEAN, MID, REPLACE, SUBSTITUTE @FUNCTION=TRUE
@SYNTAX=TRUE()
@DESCRIPTION=TRUE devolve o valor booleano true (certo).  Esta función é compatible con Excel. 
@EXAMPLES=
TRUE() é igual a TRUE.

@SEEALSO=FALSE @FUNCTION=VALUE
@SYNTAX=VALUE(texto)
@DESCRIPTION=VALUE devolve o valor numérico de @texto.
@EXAMPLES=
VALUE("%1,000") é igual a 1000.

@SEEALSO=DOLLAR, FIXED, TEXT 