require '_h2ph_pre.ph';

no warnings 'redefine';

if(defined(&__KERNEL__)) {
    die("=======================================================");
    die("You should not include /usr/include/{linux,asm}/ header");
    die("files directly for the compilation of kernel modules.");
    die("");
    die("glibc now uses kernel header files from a well-defined");
    die("working kernel version (as recommended by Linus Torvalds)");
    die("These files are glibc internal and may not match the");
    die("currently running kernel. They should only be");
    die("included via other system header files - user space");
    die("programs should not directly include <linux/*.h> or");
    die("<asm/*.h> as well.");
    die("");
    die("To build kernel modules please do the following:");
    die("");
    die(" o Have the kernel sources installed");
    die("");
    die(" o Make sure that the symbolic link");
    die("   /lib/modules/`uname -r`/build exists and points to");
    die("   the matching kernel source directory");
    die("");
    die(" o Configure kernel sources:");
    die("   - cd /usr/src/linux");
    die("   - make mrproper");
    die("   - make cloneconfig");
    die("   - make prepare");
    die("");
    die(" o When compiling, make sure to use the following");
    die("   compiler option to use the correct include files:");
    die("");
    die("   -I/lib/modules/`uname -r`/build/include");
    die("");
    die("   instead of");
    die("");
    die("   -I/usr/include/linux");
    die("");
    die("   Please adjust the Makefile accordingly.");
    die("=======================================================");
} else {
    eval 'sub UTS_RELEASE {"2.6.22";}' unless defined(&UTS_RELEASE);
    eval 'sub LINUX_VERSION_CODE {132630;}' unless defined(&LINUX_VERSION_CODE);
    eval 'sub KERNEL_VERSION {
        my($a,$b,$c) = @_;
	    eval q(((($a) << 16) + (($b) << 8) + ($c)));
    }' unless defined(&KERNEL_VERSION);
}
1;
