require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_REISER_FS_H)) {
    eval 'sub _LINUX_REISER_FS_H {1;}' unless defined(&_LINUX_REISER_FS_H);
    require 'linux/types.ph';
    require 'linux/magic.ph';
    eval 'sub USE_INODE_GENERATION_COUNTER {1;}' unless defined(&USE_INODE_GENERATION_COUNTER);
    eval 'sub REISERFS_PREALLOCATE {1;}' unless defined(&REISERFS_PREALLOCATE);
    eval 'sub DISPLACE_NEW_PACKING_LOCALITIES {1;}' unless defined(&DISPLACE_NEW_PACKING_LOCALITIES);
    eval 'sub PREALLOCATION_SIZE {9;}' unless defined(&PREALLOCATION_SIZE);
    eval 'sub _ROUND_UP {
        my($x,$n) = @_;
	    eval q(((($x)+($n)-1) & ~(($n)-1)));
    }' unless defined(&_ROUND_UP);
    eval 'sub ROUND_UP {
        my($x) = @_;
	    eval q( &_ROUND_UP($x,8));
    }' unless defined(&ROUND_UP);
    eval 'sub REISERFS_DEBUG_CODE {5;}' unless defined(&REISERFS_DEBUG_CODE);
    eval 'sub RASSERT {(  &cond,  &format,  &args... )  &if( !(  &cond ) )  &reiserfs_panic(  &NULL, "reiserfs[%i]: assertion "  &cond " failed at "  &__FILE__ ":%i:%s: "  &format "\\n",  &in_interrupt() ? -1:  &current ->  &pid,  &__LINE__ ,  &__FUNCTION__ ,  &args );}' unless defined(&RASSERT);
    if(defined( (defined(&CONFIG_REISERFS_CHECK) ? &CONFIG_REISERFS_CHECK : 0) )) {
	eval 'sub RFALSE {(  &cond,  &format,  &args... )  &RASSERT( !(  &cond ),  &format,  &args );}' unless defined(&RFALSE);
    } else {
	eval 'sub RFALSE {(  &cond,  &format,  &args... )  &do {;}  &while( 0);}' unless defined(&RFALSE);
    }
    eval 'sub CONSTF {1;}' unless defined(&CONSTF);
    eval 'sub UNSET_HASH {0;}' unless defined(&UNSET_HASH);
    eval 'sub TEA_HASH {1;}' unless defined(&TEA_HASH);
    eval 'sub YURA_HASH {2;}' unless defined(&YURA_HASH);
    eval 'sub R5_HASH {3;}' unless defined(&R5_HASH);
    eval 'sub DEFAULT_HASH { &R5_HASH;}' unless defined(&DEFAULT_HASH);
    eval 'sub SB_SIZE_V1 {($sizeof{\'struct reiserfs_super_block_v1\'});}' unless defined(&SB_SIZE_V1);
    eval 'sub SB_SIZE {($sizeof{\'struct reiserfs_super_block\'});}' unless defined(&SB_SIZE);
    eval 'sub REISERFS_VERSION_1 {0;}' unless defined(&REISERFS_VERSION_1);
    eval 'sub REISERFS_VERSION_2 {2;}' unless defined(&REISERFS_VERSION_2);
    eval 'sub SB_DISK_SUPER_BLOCK {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_rs));
    }' unless defined(&SB_DISK_SUPER_BLOCK);
    eval 'sub SB_V1_DISK_SUPER_BLOCK {
        my($s) = @_;
	    eval q((( &SB_DISK_SUPER_BLOCK($s)-> &s_v1)));
    }' unless defined(&SB_V1_DISK_SUPER_BLOCK);
    eval 'sub SB_BLOCKSIZE {
        my($s) = @_;
	    eval q( &le32_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_blocksize)));
    }' unless defined(&SB_BLOCKSIZE);
    eval 'sub SB_BLOCK_COUNT {
        my($s) = @_;
	    eval q( &le32_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_block_count)));
    }' unless defined(&SB_BLOCK_COUNT);
    eval 'sub SB_FREE_BLOCKS {
        my($s) = @_;
	    eval q( &le32_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_free_blocks)));
    }' unless defined(&SB_FREE_BLOCKS);
    eval 'sub SB_REISERFS_MAGIC {
        my($s) = @_;
	    eval q(( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_magic));
    }' unless defined(&SB_REISERFS_MAGIC);
    eval 'sub SB_ROOT_BLOCK {
        my($s) = @_;
	    eval q( &le32_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_root_block)));
    }' unless defined(&SB_ROOT_BLOCK);
    eval 'sub SB_TREE_HEIGHT {
        my($s) = @_;
	    eval q( &le16_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_tree_height)));
    }' unless defined(&SB_TREE_HEIGHT);
    eval 'sub SB_REISERFS_STATE {
        my($s) = @_;
	    eval q( &le16_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_umount_state)));
    }' unless defined(&SB_REISERFS_STATE);
    eval 'sub SB_VERSION {
        my($s) = @_;
	    eval q( &le16_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_version)));
    }' unless defined(&SB_VERSION);
    eval 'sub SB_BMAP_NR {
        my($s) = @_;
	    eval q( &le16_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_bmap_nr)));
    }' unless defined(&SB_BMAP_NR);
    eval 'sub PUT_SB_BLOCK_COUNT {
        my($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_block_count =  &cpu_to_le32($val); }  &while (0));
    }' unless defined(&PUT_SB_BLOCK_COUNT);
    eval 'sub PUT_SB_FREE_BLOCKS {
        my($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_free_blocks =  &cpu_to_le32($val); }  &while (0));
    }' unless defined(&PUT_SB_FREE_BLOCKS);
    eval 'sub PUT_SB_ROOT_BLOCK {
        my($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_root_block =  &cpu_to_le32($val); }  &while (0));
    }' unless defined(&PUT_SB_ROOT_BLOCK);
    eval 'sub PUT_SB_TREE_HEIGHT {
        my($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_tree_height =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&PUT_SB_TREE_HEIGHT);
    eval 'sub PUT_SB_REISERFS_STATE {
        my($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_umount_state =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&PUT_SB_REISERFS_STATE);
    eval 'sub PUT_SB_VERSION {
        my($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_version =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&PUT_SB_VERSION);
    eval 'sub PUT_SB_BMAP_NR {
        my($s, $val) = @_;
	    eval q( &do {  &SB_V1_DISK_SUPER_BLOCK($s)-> &s_bmap_nr =  &cpu_to_le16 ($val); }  &while (0));
    }' unless defined(&PUT_SB_BMAP_NR);
    eval 'sub SB_ONDISK_JP {
        my($s) = @_;
	    eval q(( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_journal));
    }' unless defined(&SB_ONDISK_JP);
    eval 'sub SB_ONDISK_JOURNAL_SIZE {
        my($s) = @_;
	    eval q( &le32_to_cpu (( &SB_ONDISK_JP($s)-> &jp_journal_size)));
    }' unless defined(&SB_ONDISK_JOURNAL_SIZE);
    eval 'sub SB_ONDISK_JOURNAL_1st_BLOCK {
        my($s) = @_;
	    eval q( &le32_to_cpu (( &SB_ONDISK_JP($s)-> &jp_journal_1st_block)));
    }' unless defined(&SB_ONDISK_JOURNAL_1st_BLOCK);
    eval 'sub SB_ONDISK_JOURNAL_DEVICE {
        my($s) = @_;
	    eval q( &le32_to_cpu (( &SB_ONDISK_JP($s)-> &jp_journal_dev)));
    }' unless defined(&SB_ONDISK_JOURNAL_DEVICE);
    eval 'sub SB_ONDISK_RESERVED_FOR_JOURNAL {
        my($s) = @_;
	    eval q( &le16_to_cpu (( &SB_V1_DISK_SUPER_BLOCK($s)-> &s_reserved_for_journal)));
    }' unless defined(&SB_ONDISK_RESERVED_FOR_JOURNAL);
    eval 'sub is_block_in_log_or_reserved_area {
        my($s, $block) = @_;
	    eval q($block >=  &SB_JOURNAL_1st_RESERVED_BLOCK($s)  && $block <  &SB_JOURNAL_1st_RESERVED_BLOCK($s) + ((! &is_reiserfs_jr( &SB_DISK_SUPER_BLOCK($s)) ?  &SB_ONDISK_JOURNAL_SIZE($s) + 1:  &SB_ONDISK_RESERVED_FOR_JOURNAL($s))));
    }' unless defined(&is_block_in_log_or_reserved_area);
    eval 'sub REISERFS_DISK_OFFSET_IN_BYTES {(64* 1024);}' unless defined(&REISERFS_DISK_OFFSET_IN_BYTES);
    eval 'sub REISERFS_FIRST_BLOCK { &unused_define;}' unless defined(&REISERFS_FIRST_BLOCK);
    eval 'sub REISERFS_JOURNAL_OFFSET_IN_BYTES { &REISERFS_DISK_OFFSET_IN_BYTES;}' unless defined(&REISERFS_JOURNAL_OFFSET_IN_BYTES);
    eval 'sub REISERFS_OLD_DISK_OFFSET_IN_BYTES {(8* 1024);}' unless defined(&REISERFS_OLD_DISK_OFFSET_IN_BYTES);
    eval 'sub CARRY_ON {0;}' unless defined(&CARRY_ON);
    eval 'sub REPEAT_SEARCH {-1;}' unless defined(&REPEAT_SEARCH);
    eval 'sub IO_ERROR {-2;}' unless defined(&IO_ERROR);
    eval 'sub NO_DISK_SPACE {-3;}' unless defined(&NO_DISK_SPACE);
    eval 'sub NO_BALANCING_NEEDED {(-4);}' unless defined(&NO_BALANCING_NEEDED);
    eval 'sub NO_MORE_UNUSED_CONTIGUOUS_BLOCKS {(-5);}' unless defined(&NO_MORE_UNUSED_CONTIGUOUS_BLOCKS);
    eval 'sub QUOTA_EXCEEDED {-6;}' unless defined(&QUOTA_EXCEEDED);
    eval 'sub KEY_FORMAT_3_5 {0;}' unless defined(&KEY_FORMAT_3_5);
    eval 'sub KEY_FORMAT_3_6 {1;}' unless defined(&KEY_FORMAT_3_6);
    eval 'sub STAT_DATA_V1 {0;}' unless defined(&STAT_DATA_V1);
    eval 'sub STAT_DATA_V2 {1;}' unless defined(&STAT_DATA_V2);
    eval 'sub reiserfs_inode_info {
        eval q(* &REISERFS_I( &const \'struct inode\' * &inode) {  &container_of( &inode, \'struct reiserfs_inode_info\',  &vfs_inode); });
    }' unless defined(&reiserfs_inode_info);
    eval 'sub reiserfs_sb_info {
        eval q(* &REISERFS_SB( &const \'struct super_block\' * &sb) {  ($sb->{s_fs_info}); });
    }' unless defined(&reiserfs_sb_info);
    eval 'sub get_inode_item_key_version {
        my( $inode ) = @_;
	    eval q((( &REISERFS_I($inode)-> &i_flags &  &i_item_key_version_mask) ?  &KEY_FORMAT_3_6 :  &KEY_FORMAT_3_5));
    }' unless defined(&get_inode_item_key_version);
    eval 'sub set_inode_item_key_version {
        my( $inode, $version ) = @_;
	    eval q(({  &if(($version)== &KEY_FORMAT_3_6)  &REISERFS_I($inode)-> &i_flags |=  &i_item_key_version_mask;  &else  &REISERFS_I($inode)-> &i_flags &= ~ &i_item_key_version_mask; }));
    }' unless defined(&set_inode_item_key_version);
    eval 'sub get_inode_sd_version {
        my($inode) = @_;
	    eval q((( &REISERFS_I($inode)-> &i_flags &  &i_stat_data_version_mask) ?  &STAT_DATA_V2 :  &STAT_DATA_V1));
    }' unless defined(&get_inode_sd_version);
    eval 'sub set_inode_sd_version {
        my($inode, $version) = @_;
	    eval q(({  &if(($version)== &STAT_DATA_V2)  &REISERFS_I($inode)-> &i_flags |=  &i_stat_data_version_mask;  &else  &REISERFS_I($inode)-> &i_flags &= ~ &i_stat_data_version_mask; }));
    }' unless defined(&set_inode_sd_version);
    eval 'sub STORE_TAIL_IN_UNFM_S1 {
        my($n_file_size,$n_tail_size,$n_block_size) = @_;
	    eval q(( (!($n_tail_size)) || ((($n_tail_size) >  &MAX_DIRECT_ITEM_LEN($n_block_size)) || ( ($n_file_size) >= ($n_block_size) * 4) || ( ( ($n_file_size) >= ($n_block_size) * 3)  && ( ($n_tail_size) >= ( &MAX_DIRECT_ITEM_LEN($n_block_size))/4) ) || ( ( ($n_file_size) >= ($n_block_size) * 2)  && ( ($n_tail_size) >= ( &MAX_DIRECT_ITEM_LEN($n_block_size))/2) ) || ( ( ($n_file_size) >= ($n_block_size) )  && ( ($n_tail_size) >= ( &MAX_DIRECT_ITEM_LEN($n_block_size) * 3)/4) ) ) ));
    }' unless defined(&STORE_TAIL_IN_UNFM_S1);
    eval 'sub STORE_TAIL_IN_UNFM_S2 {
        my($n_file_size,$n_tail_size,$n_block_size) = @_;
	    eval q(( (!($n_tail_size)) || ((($n_file_size) >  &MAX_DIRECT_ITEM_LEN($n_block_size)) ) ));
    }' unless defined(&STORE_TAIL_IN_UNFM_S2);
    eval 'sub REISERFS_VALID_FS {1;}' unless defined(&REISERFS_VALID_FS);
    eval 'sub REISERFS_ERROR_FS {2;}' unless defined(&REISERFS_ERROR_FS);
    eval 'sub TYPE_STAT_DATA {0;}' unless defined(&TYPE_STAT_DATA);
    eval 'sub TYPE_INDIRECT {1;}' unless defined(&TYPE_INDIRECT);
    eval 'sub TYPE_DIRECT {2;}' unless defined(&TYPE_DIRECT);
    eval 'sub TYPE_DIRENTRY {3;}' unless defined(&TYPE_DIRENTRY);
    eval 'sub TYPE_MAXTYPE {3;}' unless defined(&TYPE_MAXTYPE);
    eval 'sub TYPE_ANY {15;}' unless defined(&TYPE_ANY);
    eval 'sub offset_v2_k_type {
        my($v2) = @_;
	    eval q({  &__u8  &type =  &le64_to_cpu( ($v2->{v})) >> 60; ( &type <=  &TYPE_MAXTYPE) ?  &type :  &TYPE_ANY; });
    }' unless defined(&offset_v2_k_type);
    eval 'sub set_offset_v2_k_type {
        my($v2,$type) = @_;
	    eval q({  ($v2->{v}) = ( ($v2->{v}) &  &cpu_to_le64(~0 >> 4)) |  &cpu_to_le64(( &__u64) $type << 60); });
    }' unless defined(&set_offset_v2_k_type);
    eval 'sub offset_v2_k_offset {
        my($v2) = @_;
	    eval q({  &le64_to_cpu( ($v2->{v})) & (~0 >> 4); });
    }' unless defined(&offset_v2_k_offset);
    eval 'sub set_offset_v2_k_offset {
        my($v2,$offset) = @_;
	    eval q({ $offset &= (~0 >> 4);  ($v2->{v}) = ( ($v2->{v}) &  &cpu_to_le64(15 << 60)) |  &cpu_to_le64($offset); });
    }' unless defined(&set_offset_v2_k_offset);
    eval 'sub REISERFS_FULL_KEY_LEN {4;}' unless defined(&REISERFS_FULL_KEY_LEN);
    eval 'sub REISERFS_SHORT_KEY_LEN {2;}' unless defined(&REISERFS_SHORT_KEY_LEN);
    eval 'sub FIRST_GREATER {1;}' unless defined(&FIRST_GREATER);
    eval 'sub SECOND_GREATER {-1;}' unless defined(&SECOND_GREATER);
    eval 'sub KEYS_IDENTICAL {0;}' unless defined(&KEYS_IDENTICAL);
    eval 'sub KEY_FOUND {1;}' unless defined(&KEY_FOUND);
    eval 'sub KEY_NOT_FOUND {0;}' unless defined(&KEY_NOT_FOUND);
    eval 'sub KEY_SIZE {($sizeof{\'struct reiserfs_key\'});}' unless defined(&KEY_SIZE);
    eval 'sub SHORT_KEY_SIZE {($sizeof{ &__u32} + $sizeof{ &__u32});}' unless defined(&SHORT_KEY_SIZE);
    eval 'sub ITEM_FOUND {1;}' unless defined(&ITEM_FOUND);
    eval 'sub ITEM_NOT_FOUND {0;}' unless defined(&ITEM_NOT_FOUND);
    eval 'sub ENTRY_FOUND {1;}' unless defined(&ENTRY_FOUND);
    eval 'sub ENTRY_NOT_FOUND {0;}' unless defined(&ENTRY_NOT_FOUND);
    eval 'sub DIRECTORY_NOT_FOUND {-1;}' unless defined(&DIRECTORY_NOT_FOUND);
    eval 'sub REGULAR_FILE_FOUND {-2;}' unless defined(&REGULAR_FILE_FOUND);
    eval 'sub DIRECTORY_FOUND {-3;}' unless defined(&DIRECTORY_FOUND);
    eval 'sub BYTE_FOUND {1;}' unless defined(&BYTE_FOUND);
    eval 'sub BYTE_NOT_FOUND {0;}' unless defined(&BYTE_NOT_FOUND);
    eval 'sub FILE_NOT_FOUND {-1;}' unless defined(&FILE_NOT_FOUND);
    eval 'sub POSITION_FOUND {1;}' unless defined(&POSITION_FOUND);
    eval 'sub POSITION_NOT_FOUND {0;}' unless defined(&POSITION_NOT_FOUND);
    eval 'sub NAME_FOUND {1;}' unless defined(&NAME_FOUND);
    eval 'sub NAME_NOT_FOUND {0;}' unless defined(&NAME_NOT_FOUND);
    eval 'sub GOTO_PREVIOUS_ITEM {2;}' unless defined(&GOTO_PREVIOUS_ITEM);
    eval 'sub NAME_FOUND_INVISIBLE {3;}' unless defined(&NAME_FOUND_INVISIBLE);
    eval 'sub IH_SIZE {($sizeof{\'struct item_head\'});}' unless defined(&IH_SIZE);
    eval 'sub ih_free_space {
        my($ih) = @_;
	    eval q( &le16_to_cpu(($ih)-> ($u->{ih_free_space_reserved})));
    }' unless defined(&ih_free_space);
    eval 'sub ih_version {
        my($ih) = @_;
	    eval q( &le16_to_cpu(($ih)-> &ih_version));
    }' unless defined(&ih_version);
    eval 'sub ih_entry_count {
        my($ih) = @_;
	    eval q( &le16_to_cpu(($ih)-> ($u->{ih_entry_count})));
    }' unless defined(&ih_entry_count);
    eval 'sub ih_location {
        my($ih) = @_;
	    eval q( &le16_to_cpu(($ih)-> &ih_item_location));
    }' unless defined(&ih_location);
    eval 'sub ih_item_len {
        my($ih) = @_;
	    eval q( &le16_to_cpu(($ih)-> &ih_item_len));
    }' unless defined(&ih_item_len);
    eval 'sub put_ih_free_space {
        my($ih, $val) = @_;
	    eval q( &do { ($ih)-> ($u->{ih_free_space_reserved}) =  &cpu_to_le16($val); }  &while(0));
    }' unless defined(&put_ih_free_space);
    eval 'sub put_ih_version {
        my($ih, $val) = @_;
	    eval q( &do { ($ih)-> &ih_version =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&put_ih_version);
    eval 'sub put_ih_entry_count {
        my($ih, $val) = @_;
	    eval q( &do { ($ih)-> ($u->{ih_entry_count}) =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&put_ih_entry_count);
    eval 'sub put_ih_location {
        my($ih, $val) = @_;
	    eval q( &do { ($ih)-> &ih_item_location =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&put_ih_location);
    eval 'sub put_ih_item_len {
        my($ih, $val) = @_;
	    eval q( &do { ($ih)-> &ih_item_len =  &cpu_to_le16($val); }  &while (0));
    }' unless defined(&put_ih_item_len);
    eval 'sub unreachable_item {
        my($ih) = @_;
	    eval q(( &ih_version($ih) & (1<< 15)));
    }' unless defined(&unreachable_item);
    eval 'sub get_ih_free_space {
        my($ih) = @_;
	    eval q(( &ih_version ($ih) ==  &KEY_FORMAT_3_6 ? 0:  &ih_free_space ($ih)));
    }' unless defined(&get_ih_free_space);
    eval 'sub set_ih_free_space {
        my($ih,$val) = @_;
	    eval q( &put_ih_free_space(($ih), (( &ih_version($ih) ==  &KEY_FORMAT_3_6) ? 0: ($val))));
    }' unless defined(&set_ih_free_space);
    eval 'sub get_block_num {
        my($p, $i) = @_;
	    eval q( &le32_to_cpu( &get_unaligned(($p) + ($i))));
    }' unless defined(&get_block_num);
    eval 'sub put_block_num {
        my($p, $i, $v) = @_;
	    eval q( &put_unaligned( &cpu_to_le32($v), ($p) + ($i)));
    }' unless defined(&put_block_num);
    eval 'sub V1_SD_UNIQUENESS {0;}' unless defined(&V1_SD_UNIQUENESS);
    eval 'sub V1_INDIRECT_UNIQUENESS {0xfffffffe;}' unless defined(&V1_INDIRECT_UNIQUENESS);
    eval 'sub V1_DIRECT_UNIQUENESS {0xffffffff;}' unless defined(&V1_DIRECT_UNIQUENESS);
    eval 'sub V1_DIRENTRY_UNIQUENESS {500;}' unless defined(&V1_DIRENTRY_UNIQUENESS);
    eval 'sub V1_ANY_UNIQUENESS {555;}' unless defined(&V1_ANY_UNIQUENESS);
    eval 'sub uniqueness2type {
        my($uniqueness) = @_;
	    eval q({  &switch ($uniqueness) {  &case  &V1_SD_UNIQUENESS:  &TYPE_STAT_DATA;  &case  &V1_INDIRECT_UNIQUENESS:  &TYPE_INDIRECT;  &case  &V1_DIRECT_UNIQUENESS:  &TYPE_DIRECT;  &case  &V1_DIRENTRY_UNIQUENESS:  &TYPE_DIRENTRY;  &default:  &reiserfs_warning( &NULL, \\"vs-500: unknown uniqueness %d\\", $uniqueness);  &case  &V1_ANY_UNIQUENESS:  &TYPE_ANY; } });
    }' unless defined(&uniqueness2type);
    eval 'sub type2uniqueness {
        my($type) = @_;
	    eval q({  &switch ($type) {  &case  &TYPE_STAT_DATA:  &V1_SD_UNIQUENESS;  &case  &TYPE_INDIRECT:  &V1_INDIRECT_UNIQUENESS;  &case  &TYPE_DIRECT:  &V1_DIRECT_UNIQUENESS;  &case  &TYPE_DIRENTRY:  &V1_DIRENTRY_UNIQUENESS;  &default:  &reiserfs_warning( &NULL, \\"vs-501: unknown type %d\\", $type);  &case  &TYPE_ANY:  &V1_ANY_UNIQUENESS; } });
    }' unless defined(&type2uniqueness);
    eval 'sub le_key_k_offset {
        my($version,$key) = @_;
	    eval q({ ($version ==  &KEY_FORMAT_3_5) ?  &le32_to_cpu( ($key->{u}->{k_offset_v1}->{k_offset})) :  &offset_v2_k_offset(( ($key->{u}->{k_offset_v2}))); });
    }' unless defined(&le_key_k_offset);
    eval 'sub le_ih_k_offset {
        my($ih) = @_;
	    eval q({  &le_key_k_offset( &ih_version($ih), ( ($ih->{ih_key}))); });
    }' unless defined(&le_ih_k_offset);
    eval 'sub le_key_k_type {
        my($version,$key) = @_;
	    eval q({ ($version ==  &KEY_FORMAT_3_5) ?  &uniqueness2type( &le32_to_cpu( ($key->{u}->{k_offset_v1}->{k_uniqueness}))) :  &offset_v2_k_type(( ($key->{u}->{k_offset_v2}))); });
    }' unless defined(&le_key_k_type);
    eval 'sub le_ih_k_type {
        my($ih) = @_;
	    eval q({  &le_key_k_type( &ih_version($ih), ( ($ih->{ih_key}))); });
    }' unless defined(&le_ih_k_type);
    eval 'sub set_le_key_k_offset {
        my($version,$key,$offset) = @_;
	    eval q({ ($version ==  &KEY_FORMAT_3_5) ? ( &void)( ($key->{u}->{k_offset_v1}->{k_offset}) =  &cpu_to_le32($offset)) : ( &void)( &set_offset_v2_k_offset(( ($key->{u}->{k_offset_v2})), $offset)); });
    }' unless defined(&set_le_key_k_offset);
    eval 'sub set_le_ih_k_offset {
        my($ih,$offset) = @_;
	    eval q({  &set_le_key_k_offset( &ih_version($ih), ( ($ih->{ih_key})), $offset); });
    }' unless defined(&set_le_ih_k_offset);
    eval 'sub set_le_key_k_type {
        my($version,$key,$type) = @_;
	    eval q({ ($version ==  &KEY_FORMAT_3_5) ? ( &void)( ($key->{u}->{k_offset_v1}->{k_uniqueness}) =  &cpu_to_le32( &type2uniqueness($type))) : ( &void)( &set_offset_v2_k_type(( ($key->{u}->{k_offset_v2})), $type)); });
    }' unless defined(&set_le_key_k_type);
    eval 'sub set_le_ih_k_type {
        my($ih,$type) = @_;
	    eval q({  &set_le_key_k_type( &ih_version($ih), ( ($ih->{ih_key})), $type); });
    }' unless defined(&set_le_ih_k_type);
    eval 'sub is_direntry_le_key {
        my($version,$key) = @_;
	    eval q(( &le_key_k_type ($version, $key) ==  &TYPE_DIRENTRY));
    }' unless defined(&is_direntry_le_key);
    eval 'sub is_direct_le_key {
        my($version,$key) = @_;
	    eval q(( &le_key_k_type ($version, $key) ==  &TYPE_DIRECT));
    }' unless defined(&is_direct_le_key);
    eval 'sub is_indirect_le_key {
        my($version,$key) = @_;
	    eval q(( &le_key_k_type ($version, $key) ==  &TYPE_INDIRECT));
    }' unless defined(&is_indirect_le_key);
    eval 'sub is_statdata_le_key {
        my($version,$key) = @_;
	    eval q(( &le_key_k_type ($version, $key) ==  &TYPE_STAT_DATA));
    }' unless defined(&is_statdata_le_key);
    eval 'sub is_direntry_le_ih {
        my($ih) = @_;
	    eval q( &is_direntry_le_key ( &ih_version ($ih), (($ih)-> &ih_key)));
    }' unless defined(&is_direntry_le_ih);
    eval 'sub is_direct_le_ih {
        my($ih) = @_;
	    eval q( &is_direct_le_key ( &ih_version ($ih), (($ih)-> &ih_key)));
    }' unless defined(&is_direct_le_ih);
    eval 'sub is_indirect_le_ih {
        my($ih) = @_;
	    eval q( &is_indirect_le_key ( &ih_version($ih), (($ih)-> &ih_key)));
    }' unless defined(&is_indirect_le_ih);
    eval 'sub is_statdata_le_ih {
        my($ih) = @_;
	    eval q( &is_statdata_le_key ( &ih_version ($ih), (($ih)-> &ih_key)));
    }' unless defined(&is_statdata_le_ih);
    eval 'sub cpu_key_k_offset {
        my($key) = @_;
	    eval q({  ($key->{on_disk_key}->{k_offset}); });
    }' unless defined(&cpu_key_k_offset);
    eval 'sub cpu_key_k_type {
        my($key) = @_;
	    eval q({  ($key->{on_disk_key}->{k_type}); });
    }' unless defined(&cpu_key_k_type);
    eval 'sub set_cpu_key_k_offset {
        my($key,$offset) = @_;
	    eval q({  ($key->{on_disk_key}->{k_offset}) = $offset; });
    }' unless defined(&set_cpu_key_k_offset);
    eval 'sub set_cpu_key_k_type {
        my($key,$type) = @_;
	    eval q({  ($key->{on_disk_key}->{k_type}) = $type; });
    }' unless defined(&set_cpu_key_k_type);
    eval 'sub cpu_key_k_offset_dec {
        my($key) = @_;
	    eval q({  ($key->{on_disk_key}->{k_offset})--; });
    }' unless defined(&cpu_key_k_offset_dec);
    eval 'sub is_direntry_cpu_key {
        my($key) = @_;
	    eval q(( &cpu_key_k_type ($key) ==  &TYPE_DIRENTRY));
    }' unless defined(&is_direntry_cpu_key);
    eval 'sub is_direct_cpu_key {
        my($key) = @_;
	    eval q(( &cpu_key_k_type ($key) ==  &TYPE_DIRECT));
    }' unless defined(&is_direct_cpu_key);
    eval 'sub is_indirect_cpu_key {
        my($key) = @_;
	    eval q(( &cpu_key_k_type ($key) ==  &TYPE_INDIRECT));
    }' unless defined(&is_indirect_cpu_key);
    eval 'sub is_statdata_cpu_key {
        my($key) = @_;
	    eval q(( &cpu_key_k_type ($key) ==  &TYPE_STAT_DATA));
    }' unless defined(&is_statdata_cpu_key);
    eval 'sub is_direntry_cpu_ih {
        my($ih) = @_;
	    eval q(( &is_direntry_cpu_key ((($ih)-> &ih_key))));
    }' unless defined(&is_direntry_cpu_ih);
    eval 'sub is_direct_cpu_ih {
        my($ih) = @_;
	    eval q(( &is_direct_cpu_key ((($ih)-> &ih_key))));
    }' unless defined(&is_direct_cpu_ih);
    eval 'sub is_indirect_cpu_ih {
        my($ih) = @_;
	    eval q(( &is_indirect_cpu_key ((($ih)-> &ih_key))));
    }' unless defined(&is_indirect_cpu_ih);
    eval 'sub is_statdata_cpu_ih {
        my($ih) = @_;
	    eval q(( &is_statdata_cpu_key ((($ih)-> &ih_key))));
    }' unless defined(&is_statdata_cpu_ih);
    eval 'sub I_K_KEY_IN_ITEM {
        my($p_s_ih, $p_s_key, $n_blocksize) = @_;
	    eval q(( !  &COMP_SHORT_KEYS($p_s_ih, $p_s_key)  &&  &I_OFF_BYTE_IN_ITEM($p_s_ih,  &k_offset ($p_s_key), $n_blocksize) ));
    }' unless defined(&I_K_KEY_IN_ITEM);
    eval 'sub MAX_ITEM_LEN {
        my($block_size) = @_;
	    eval q(($block_size -  &BLKH_SIZE -  &IH_SIZE));
    }' unless defined(&MAX_ITEM_LEN);
    eval 'sub MIN_ITEM_LEN {1;}' unless defined(&MIN_ITEM_LEN);
    eval 'sub REISERFS_ROOT_OBJECTID {2;}' unless defined(&REISERFS_ROOT_OBJECTID);
    eval 'sub REISERFS_ROOT_PARENT_OBJECTID {1;}' unless defined(&REISERFS_ROOT_PARENT_OBJECTID);
    eval 'sub BLKH_SIZE {($sizeof{\'struct block_head\'});}' unless defined(&BLKH_SIZE);
    eval 'sub blkh_level {
        my($p_blkh) = @_;
	    eval q(( &le16_to_cpu(($p_blkh)-> &blk_level)));
    }' unless defined(&blkh_level);
    eval 'sub blkh_nr_item {
        my($p_blkh) = @_;
	    eval q(( &le16_to_cpu(($p_blkh)-> &blk_nr_item)));
    }' unless defined(&blkh_nr_item);
    eval 'sub blkh_free_space {
        my($p_blkh) = @_;
	    eval q(( &le16_to_cpu(($p_blkh)-> &blk_free_space)));
    }' unless defined(&blkh_free_space);
    eval 'sub blkh_reserved {
        my($p_blkh) = @_;
	    eval q(( &le16_to_cpu(($p_blkh)-> &blk_reserved)));
    }' unless defined(&blkh_reserved);
    eval 'sub set_blkh_level {
        my($p_blkh,$val) = @_;
	    eval q((($p_blkh)-> &blk_level =  &cpu_to_le16($val)));
    }' unless defined(&set_blkh_level);
    eval 'sub set_blkh_nr_item {
        my($p_blkh,$val) = @_;
	    eval q((($p_blkh)-> &blk_nr_item =  &cpu_to_le16($val)));
    }' unless defined(&set_blkh_nr_item);
    eval 'sub set_blkh_free_space {
        my($p_blkh,$val) = @_;
	    eval q((($p_blkh)-> &blk_free_space =  &cpu_to_le16($val)));
    }' unless defined(&set_blkh_free_space);
    eval 'sub set_blkh_reserved {
        my($p_blkh,$val) = @_;
	    eval q((($p_blkh)-> &blk_reserved =  &cpu_to_le16($val)));
    }' unless defined(&set_blkh_reserved);
    eval 'sub blkh_right_delim_key {
        my($p_blkh) = @_;
	    eval q((($p_blkh)-> &blk_right_delim_key));
    }' unless defined(&blkh_right_delim_key);
    eval 'sub set_blkh_right_delim_key {
        my($p_blkh,$val) = @_;
	    eval q((($p_blkh)-> &blk_right_delim_key = $val));
    }' unless defined(&set_blkh_right_delim_key);
    eval 'sub FREE_LEVEL {0;}' unless defined(&FREE_LEVEL);
    eval 'sub DISK_LEAF_NODE_LEVEL {1;}' unless defined(&DISK_LEAF_NODE_LEVEL);
    eval 'sub B_BLK_HEAD {
        my($p_s_bh) = @_;
	    eval q(((($p_s_bh)-> &b_data)));
    }' unless defined(&B_BLK_HEAD);
    eval 'sub B_NR_ITEMS {
        my($p_s_bh) = @_;
	    eval q(( &blkh_nr_item( &B_BLK_HEAD($p_s_bh))));
    }' unless defined(&B_NR_ITEMS);
    eval 'sub B_LEVEL {
        my($p_s_bh) = @_;
	    eval q(( &blkh_level( &B_BLK_HEAD($p_s_bh))));
    }' unless defined(&B_LEVEL);
    eval 'sub B_FREE_SPACE {
        my($p_s_bh) = @_;
	    eval q(( &blkh_free_space( &B_BLK_HEAD($p_s_bh))));
    }' unless defined(&B_FREE_SPACE);
    eval 'sub PUT_B_NR_ITEMS {
        my($p_s_bh,$val) = @_;
	    eval q( &do {  &set_blkh_nr_item( &B_BLK_HEAD($p_s_bh),$val); }  &while (0));
    }' unless defined(&PUT_B_NR_ITEMS);
    eval 'sub PUT_B_LEVEL {
        my($p_s_bh,$val) = @_;
	    eval q( &do {  &set_blkh_level( &B_BLK_HEAD($p_s_bh),$val); }  &while (0));
    }' unless defined(&PUT_B_LEVEL);
    eval 'sub PUT_B_FREE_SPACE {
        my($p_s_bh,$val) = @_;
	    eval q( &do {  &set_blkh_free_space( &B_BLK_HEAD($p_s_bh),$val); }  &while (0));
    }' unless defined(&PUT_B_FREE_SPACE);
    eval 'sub B_PRIGHT_DELIM_KEY {
        my($p_s_bh) = @_;
	    eval q((( &blk_right_delim_key( &B_BLK_HEAD($p_s_bh)))));
    }' unless defined(&B_PRIGHT_DELIM_KEY);
    eval 'sub B_IS_ITEMS_LEVEL {
        my($p_s_bh) = @_;
	    eval q(( &B_LEVEL($p_s_bh) ==  &DISK_LEAF_NODE_LEVEL));
    }' unless defined(&B_IS_ITEMS_LEVEL);
    eval 'sub B_IS_KEYS_LEVEL {
        my($p_s_bh) = @_;
	    eval q(( &B_LEVEL($p_s_bh) >  &DISK_LEAF_NODE_LEVEL  &&  &B_LEVEL($p_s_bh) <=  &MAX_HEIGHT));
    }' unless defined(&B_IS_KEYS_LEVEL);
    eval 'sub SD_V1_SIZE {($sizeof{\'struct stat_data_v1\'});}' unless defined(&SD_V1_SIZE);
    eval 'sub stat_data_v1 {
        my($ih) = @_;
	    eval q(( &ih_version ($ih) ==  &KEY_FORMAT_3_5));
    }' unless defined(&stat_data_v1);
    eval 'sub sd_v1_mode {
        my($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_mode)));
    }' unless defined(&sd_v1_mode);
    eval 'sub set_sd_v1_mode {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_mode =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v1_mode);
    eval 'sub sd_v1_nlink {
        my($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_nlink)));
    }' unless defined(&sd_v1_nlink);
    eval 'sub set_sd_v1_nlink {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_nlink =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v1_nlink);
    eval 'sub sd_v1_uid {
        my($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_uid)));
    }' unless defined(&sd_v1_uid);
    eval 'sub set_sd_v1_uid {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_uid =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v1_uid);
    eval 'sub sd_v1_gid {
        my($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_gid)));
    }' unless defined(&sd_v1_gid);
    eval 'sub set_sd_v1_gid {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_gid =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v1_gid);
    eval 'sub sd_v1_size {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_size)));
    }' unless defined(&sd_v1_size);
    eval 'sub set_sd_v1_size {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_size =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_size);
    eval 'sub sd_v1_atime {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_atime)));
    }' unless defined(&sd_v1_atime);
    eval 'sub set_sd_v1_atime {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_atime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_atime);
    eval 'sub sd_v1_mtime {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_mtime)));
    }' unless defined(&sd_v1_mtime);
    eval 'sub set_sd_v1_mtime {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_mtime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_mtime);
    eval 'sub sd_v1_ctime {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_ctime)));
    }' unless defined(&sd_v1_ctime);
    eval 'sub set_sd_v1_ctime {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_ctime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_ctime);
    eval 'sub sd_v1_rdev {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> ($u->{sd_rdev}))));
    }' unless defined(&sd_v1_rdev);
    eval 'sub set_sd_v1_rdev {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> ($u->{sd_rdev}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_rdev);
    eval 'sub sd_v1_blocks {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> ($u->{sd_blocks}))));
    }' unless defined(&sd_v1_blocks);
    eval 'sub set_sd_v1_blocks {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> ($u->{sd_blocks}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_blocks);
    eval 'sub sd_v1_first_direct_byte {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_first_direct_byte)));
    }' unless defined(&sd_v1_first_direct_byte);
    eval 'sub set_sd_v1_first_direct_byte {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_first_direct_byte =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v1_first_direct_byte);
    eval 'sub REISERFS_IMMUTABLE_FL { &FS_IMMUTABLE_FL;}' unless defined(&REISERFS_IMMUTABLE_FL);
    eval 'sub REISERFS_APPEND_FL { &FS_APPEND_FL;}' unless defined(&REISERFS_APPEND_FL);
    eval 'sub REISERFS_SYNC_FL { &FS_SYNC_FL;}' unless defined(&REISERFS_SYNC_FL);
    eval 'sub REISERFS_NOATIME_FL { &FS_NOATIME_FL;}' unless defined(&REISERFS_NOATIME_FL);
    eval 'sub REISERFS_NODUMP_FL { &FS_NODUMP_FL;}' unless defined(&REISERFS_NODUMP_FL);
    eval 'sub REISERFS_SECRM_FL { &FS_SECRM_FL;}' unless defined(&REISERFS_SECRM_FL);
    eval 'sub REISERFS_UNRM_FL { &FS_UNRM_FL;}' unless defined(&REISERFS_UNRM_FL);
    eval 'sub REISERFS_COMPR_FL { &FS_COMPR_FL;}' unless defined(&REISERFS_COMPR_FL);
    eval 'sub REISERFS_NOTAIL_FL { &FS_NOTAIL_FL;}' unless defined(&REISERFS_NOTAIL_FL);
    eval 'sub REISERFS_INHERIT_MASK {(  &REISERFS_IMMUTABLE_FL |  &REISERFS_SYNC_FL |  &REISERFS_NOATIME_FL |  &REISERFS_NODUMP_FL |  &REISERFS_SECRM_FL |  &REISERFS_COMPR_FL |  &REISERFS_NOTAIL_FL );}' unless defined(&REISERFS_INHERIT_MASK);
    eval 'sub SD_SIZE {($sizeof{\'struct stat_data\'});}' unless defined(&SD_SIZE);
    eval 'sub SD_V2_SIZE { &SD_SIZE;}' unless defined(&SD_V2_SIZE);
    eval 'sub stat_data_v2 {
        my($ih) = @_;
	    eval q(( &ih_version ($ih) ==  &KEY_FORMAT_3_6));
    }' unless defined(&stat_data_v2);
    eval 'sub sd_v2_mode {
        my($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_mode)));
    }' unless defined(&sd_v2_mode);
    eval 'sub set_sd_v2_mode {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_mode =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v2_mode);
    eval 'sub sd_v2_nlink {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_nlink)));
    }' unless defined(&sd_v2_nlink);
    eval 'sub set_sd_v2_nlink {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_nlink =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_nlink);
    eval 'sub sd_v2_size {
        my($sdp) = @_;
	    eval q(( &le64_to_cpu(($sdp)-> &sd_size)));
    }' unless defined(&sd_v2_size);
    eval 'sub set_sd_v2_size {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_size =  &cpu_to_le64($v)));
    }' unless defined(&set_sd_v2_size);
    eval 'sub sd_v2_uid {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_uid)));
    }' unless defined(&sd_v2_uid);
    eval 'sub set_sd_v2_uid {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_uid =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_uid);
    eval 'sub sd_v2_gid {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_gid)));
    }' unless defined(&sd_v2_gid);
    eval 'sub set_sd_v2_gid {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_gid =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_gid);
    eval 'sub sd_v2_atime {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_atime)));
    }' unless defined(&sd_v2_atime);
    eval 'sub set_sd_v2_atime {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_atime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_atime);
    eval 'sub sd_v2_mtime {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_mtime)));
    }' unless defined(&sd_v2_mtime);
    eval 'sub set_sd_v2_mtime {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_mtime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_mtime);
    eval 'sub sd_v2_ctime {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_ctime)));
    }' unless defined(&sd_v2_ctime);
    eval 'sub set_sd_v2_ctime {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_ctime =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_ctime);
    eval 'sub sd_v2_blocks {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> &sd_blocks)));
    }' unless defined(&sd_v2_blocks);
    eval 'sub set_sd_v2_blocks {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_blocks =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_blocks);
    eval 'sub sd_v2_rdev {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> ($u->{sd_rdev}))));
    }' unless defined(&sd_v2_rdev);
    eval 'sub set_sd_v2_rdev {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> ($u->{sd_rdev}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_rdev);
    eval 'sub sd_v2_generation {
        my($sdp) = @_;
	    eval q(( &le32_to_cpu(($sdp)-> ($u->{sd_generation}))));
    }' unless defined(&sd_v2_generation);
    eval 'sub set_sd_v2_generation {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> ($u->{sd_generation}) =  &cpu_to_le32($v)));
    }' unless defined(&set_sd_v2_generation);
    eval 'sub sd_v2_attrs {
        my($sdp) = @_;
	    eval q(( &le16_to_cpu(($sdp)-> &sd_attrs)));
    }' unless defined(&sd_v2_attrs);
    eval 'sub set_sd_v2_attrs {
        my($sdp,$v) = @_;
	    eval q((($sdp)-> &sd_attrs =  &cpu_to_le16($v)));
    }' unless defined(&set_sd_v2_attrs);
    eval 'sub SD_OFFSET {0;}' unless defined(&SD_OFFSET);
    eval 'sub SD_UNIQUENESS {0;}' unless defined(&SD_UNIQUENESS);
    eval 'sub DOT_OFFSET {1;}' unless defined(&DOT_OFFSET);
    eval 'sub DOT_DOT_OFFSET {2;}' unless defined(&DOT_DOT_OFFSET);
    eval 'sub DIRENTRY_UNIQUENESS {500;}' unless defined(&DIRENTRY_UNIQUENESS);
    eval 'sub FIRST_ITEM_OFFSET {1;}' unless defined(&FIRST_ITEM_OFFSET);
    eval 'sub DEH_SIZE {$sizeof{\'struct reiserfs_de_head\'};}' unless defined(&DEH_SIZE);
    eval 'sub deh_offset {
        my($p_deh) = @_;
	    eval q(( &le32_to_cpu(($p_deh)-> &deh_offset)));
    }' unless defined(&deh_offset);
    eval 'sub deh_dir_id {
        my($p_deh) = @_;
	    eval q(( &le32_to_cpu(($p_deh)-> &deh_dir_id)));
    }' unless defined(&deh_dir_id);
    eval 'sub deh_objectid {
        my($p_deh) = @_;
	    eval q(( &le32_to_cpu(($p_deh)-> &deh_objectid)));
    }' unless defined(&deh_objectid);
    eval 'sub deh_location {
        my($p_deh) = @_;
	    eval q(( &le16_to_cpu(($p_deh)-> &deh_location)));
    }' unless defined(&deh_location);
    eval 'sub deh_state {
        my($p_deh) = @_;
	    eval q(( &le16_to_cpu(($p_deh)-> &deh_state)));
    }' unless defined(&deh_state);
    eval 'sub put_deh_offset {
        my($p_deh,$v) = @_;
	    eval q((($p_deh)-> &deh_offset =  &cpu_to_le32(($v))));
    }' unless defined(&put_deh_offset);
    eval 'sub put_deh_dir_id {
        my($p_deh,$v) = @_;
	    eval q((($p_deh)-> &deh_dir_id =  &cpu_to_le32(($v))));
    }' unless defined(&put_deh_dir_id);
    eval 'sub put_deh_objectid {
        my($p_deh,$v) = @_;
	    eval q((($p_deh)-> &deh_objectid =  &cpu_to_le32(($v))));
    }' unless defined(&put_deh_objectid);
    eval 'sub put_deh_location {
        my($p_deh,$v) = @_;
	    eval q((($p_deh)-> &deh_location =  &cpu_to_le16(($v))));
    }' unless defined(&put_deh_location);
    eval 'sub put_deh_state {
        my($p_deh,$v) = @_;
	    eval q((($p_deh)-> &deh_state =  &cpu_to_le16(($v))));
    }' unless defined(&put_deh_state);
    eval 'sub EMPTY_DIR_SIZE {( &DEH_SIZE * 2+  &ROUND_UP ( &strlen (".")) +  &ROUND_UP ( &strlen ("..")));}' unless defined(&EMPTY_DIR_SIZE);
    eval 'sub EMPTY_DIR_SIZE_V1 {( &DEH_SIZE * 2+ 3);}' unless defined(&EMPTY_DIR_SIZE_V1);
    eval 'sub DEH_Statdata {0;}' unless defined(&DEH_Statdata);
    eval 'sub DEH_Visible {2;}' unless defined(&DEH_Visible);
    if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 64|| defined( &__s390__) || defined( &__hppa__)) {
	eval 'sub ADDR_UNALIGNED_BITS {(3);}' unless defined(&ADDR_UNALIGNED_BITS);
    }
    if(defined(&ADDR_UNALIGNED_BITS)) {
	eval 'sub aligned_address {
	    my($addr) = @_;
    	    eval q((( &void *)(($addr) & ~((1 <<  &ADDR_UNALIGNED_BITS) - 1))));
	}' unless defined(&aligned_address);
	eval 'sub unaligned_offset {
	    my($addr) = @_;
    	    eval q((((($addr) & ((1<<  &ADDR_UNALIGNED_BITS) - 1))) << 3));
	}' unless defined(&unaligned_offset);
	eval 'sub set_bit_unaligned {
	    my($nr, $addr) = @_;
    	    eval q( &ext2_set_bit(($nr) +  &unaligned_offset($addr),  &aligned_address($addr)));
	}' unless defined(&set_bit_unaligned);
	eval 'sub clear_bit_unaligned {
	    my($nr, $addr) = @_;
    	    eval q( &ext2_clear_bit(($nr) +  &unaligned_offset($addr),  &aligned_address($addr)));
	}' unless defined(&clear_bit_unaligned);
	eval 'sub test_bit_unaligned {
	    my($nr, $addr) = @_;
    	    eval q( &ext2_test_bit(($nr) +  &unaligned_offset($addr),  &aligned_address($addr)));
	}' unless defined(&test_bit_unaligned);
    } else {
	eval 'sub set_bit_unaligned {
	    my($nr, $addr) = @_;
    	    eval q( &ext2_set_bit($nr, $addr));
	}' unless defined(&set_bit_unaligned);
	eval 'sub clear_bit_unaligned {
	    my($nr, $addr) = @_;
    	    eval q( &ext2_clear_bit($nr, $addr));
	}' unless defined(&clear_bit_unaligned);
	eval 'sub test_bit_unaligned {
	    my($nr, $addr) = @_;
    	    eval q( &ext2_test_bit($nr, $addr));
	}' unless defined(&test_bit_unaligned);
    }
    eval 'sub mark_de_with_sd {
        my($deh) = @_;
	    eval q( &set_bit_unaligned ( &DEH_Statdata, (($deh)-> &deh_state)));
    }' unless defined(&mark_de_with_sd);
    eval 'sub mark_de_without_sd {
        my($deh) = @_;
	    eval q( &clear_bit_unaligned ( &DEH_Statdata, (($deh)-> &deh_state)));
    }' unless defined(&mark_de_without_sd);
    eval 'sub mark_de_visible {
        my($deh) = @_;
	    eval q( &set_bit_unaligned ( &DEH_Visible, (($deh)-> &deh_state)));
    }' unless defined(&mark_de_visible);
    eval 'sub mark_de_hidden {
        my($deh) = @_;
	    eval q( &clear_bit_unaligned ( &DEH_Visible, (($deh)-> &deh_state)));
    }' unless defined(&mark_de_hidden);
    eval 'sub de_with_sd {
        my($deh) = @_;
	    eval q( &test_bit_unaligned ( &DEH_Statdata, (($deh)-> &deh_state)));
    }' unless defined(&de_with_sd);
    eval 'sub de_visible {
        my($deh) = @_;
	    eval q( &test_bit_unaligned ( &DEH_Visible, (($deh)-> &deh_state)));
    }' unless defined(&de_visible);
    eval 'sub de_hidden {
        my($deh) = @_;
	    eval q(! &test_bit_unaligned ( &DEH_Visible, (($deh)-> &deh_state)));
    }' unless defined(&de_hidden);
    eval 'sub B_I_PITEM {
        my($bh,$ih) = @_;
	    eval q(( ($bh)-> &b_data +  &ih_location($ih) ));
    }' unless defined(&B_I_PITEM);
    eval 'sub B_I_DEH {
        my($bh,$ih) = @_;
	    eval q((( &B_I_PITEM($bh,$ih))));
    }' unless defined(&B_I_DEH);
    eval 'sub I_ENTRY_COUNT {
        my($ih) = @_;
	    eval q(( &ih_entry_count(($ih))));
    }' unless defined(&I_ENTRY_COUNT);
    eval 'sub B_I_E_NAME {
        my($bh,$ih,$entry_num) = @_;
	    eval q((( ($bh->{b_data}) +  &ih_location($ih) +  &deh_location( &B_I_DEH($bh,$ih)+($entry_num)))));
    }' unless defined(&B_I_E_NAME);
    eval 'sub REISERFS_MAX_NAME {
        my($block_size) = @_;
	    eval q(255);
    }' unless defined(&REISERFS_MAX_NAME);
    eval 'sub B_I_DEH_ENTRY_FILE_NAME {
        my($bh,$ih,$deh) = @_;
	    eval q(( &B_I_PITEM ($bh, $ih) +  &deh_location($deh)));
    }' unless defined(&B_I_DEH_ENTRY_FILE_NAME);
    eval 'sub I_DEH_N_ENTRY_FILE_NAME_LENGTH {
        my($ih,$deh,$entry_num) = @_;
	    eval q(( &I_DEH_N_ENTRY_LENGTH ($ih, $deh, $entry_num) - ( &de_with_sd ($deh) ?  &SD_SIZE : 0)));
    }' unless defined(&I_DEH_N_ENTRY_FILE_NAME_LENGTH);
    eval 'sub GET_HASH_VALUE {
        my($offset) = @_;
	    eval q((($offset) & 0x7fffff80));
    }' unless defined(&GET_HASH_VALUE);
    eval 'sub GET_GENERATION_NUMBER {
        my($offset) = @_;
	    eval q((($offset) & 0x7f));
    }' unless defined(&GET_GENERATION_NUMBER);
    eval 'sub MAX_GENERATION_NUMBER {127;}' unless defined(&MAX_GENERATION_NUMBER);
    eval 'sub SET_GENERATION_NUMBER {
        my($offset,$gen_number) = @_;
	    eval q(( &GET_HASH_VALUE($offset)|($gen_number)));
    }' unless defined(&SET_GENERATION_NUMBER);
    eval 'sub DC_SIZE {($sizeof{\'struct disk_child\'});}' unless defined(&DC_SIZE);
    eval 'sub dc_block_number {
        my($dc_p) = @_;
	    eval q(( &le32_to_cpu(($dc_p)-> &dc_block_number)));
    }' unless defined(&dc_block_number);
    eval 'sub dc_size {
        my($dc_p) = @_;
	    eval q(( &le16_to_cpu(($dc_p)-> &dc_size)));
    }' unless defined(&dc_size);
    eval 'sub put_dc_block_number {
        my($dc_p, $val) = @_;
	    eval q( &do { ($dc_p)-> &dc_block_number =  &cpu_to_le32($val); }  &while(0));
    }' unless defined(&put_dc_block_number);
    eval 'sub put_dc_size {
        my($dc_p, $val) = @_;
	    eval q( &do { ($dc_p)-> &dc_size =  &cpu_to_le16($val); }  &while(0));
    }' unless defined(&put_dc_size);
    eval 'sub B_N_CHILD {
        my($p_s_bh,$n_pos) = @_;
	    eval q(((($p_s_bh)-> &b_data+ &BLKH_SIZE+ &B_NR_ITEMS($p_s_bh)* &KEY_SIZE+ &DC_SIZE*($n_pos))));
    }' unless defined(&B_N_CHILD);
    eval 'sub B_N_CHILD_NUM {
        my($p_s_bh,$n_pos) = @_;
	    eval q(( &dc_block_number( &B_N_CHILD($p_s_bh,$n_pos))));
    }' unless defined(&B_N_CHILD_NUM);
    eval 'sub PUT_B_N_CHILD_NUM {
        my($p_s_bh,$n_pos, $val) = @_;
	    eval q(( &put_dc_block_number( &B_N_CHILD($p_s_bh,$n_pos), $val )));
    }' unless defined(&PUT_B_N_CHILD_NUM);
    eval 'sub MAX_CHILD_SIZE {
        my($bh) = @_;
	    eval q((( ($bh)-> &b_size -  &BLKH_SIZE )));
    }' unless defined(&MAX_CHILD_SIZE);
    eval 'sub B_CHILD_SIZE {
        my($cur) = @_;
	    eval q(( &MAX_CHILD_SIZE($cur)-( &B_FREE_SPACE($cur))));
    }' unless defined(&B_CHILD_SIZE);
    eval 'sub MAX_NR_KEY {
        my($bh) = @_;
	    eval q(( ( &MAX_CHILD_SIZE($bh)- &DC_SIZE)/( &KEY_SIZE+ &DC_SIZE) ));
    }' unless defined(&MAX_NR_KEY);
    eval 'sub MIN_NR_KEY {
        my($bh) = @_;
	    eval q(( &MAX_NR_KEY($bh)/2));
    }' unless defined(&MIN_NR_KEY);
    eval 'sub MAX_HEIGHT {5;}' unless defined(&MAX_HEIGHT);
    eval 'sub EXTENDED_MAX_HEIGHT {7;}' unless defined(&EXTENDED_MAX_HEIGHT);
    eval 'sub FIRST_PATH_ELEMENT_OFFSET {2;}' unless defined(&FIRST_PATH_ELEMENT_OFFSET);
    eval 'sub ILLEGAL_PATH_ELEMENT_OFFSET {1;}' unless defined(&ILLEGAL_PATH_ELEMENT_OFFSET);
    eval 'sub MAX_FEB_SIZE {6;}' unless defined(&MAX_FEB_SIZE);
    eval 'sub PATH_READA {0x1;}' unless defined(&PATH_READA);
    eval 'sub PATH_READA_BACK {0x2;}' unless defined(&PATH_READA_BACK);
    eval 'sub pos_in_item {
        my($path) = @_;
	    eval q((($path)-> &pos_in_item));
    }' unless defined(&pos_in_item);
    eval 'sub INITIALIZE_PATH {
        my($var) = @_;
	    eval q(\'struct treepath\' $var = {. &path_length =  &ILLEGAL_PATH_ELEMENT_OFFSET, . &reada = 0,});
    }' unless defined(&INITIALIZE_PATH);
    eval 'sub PATH_OFFSET_PELEMENT {
        my($p_s_path,$n_offset) = @_;
	    eval q((($p_s_path)-> &path_elements +($n_offset)));
    }' unless defined(&PATH_OFFSET_PELEMENT);
    eval 'sub PATH_OFFSET_PBUFFER {
        my($p_s_path,$n_offset) = @_;
	    eval q(( &PATH_OFFSET_PELEMENT($p_s_path,$n_offset)-> &pe_buffer));
    }' unless defined(&PATH_OFFSET_PBUFFER);
    eval 'sub PATH_OFFSET_POSITION {
        my($p_s_path,$n_offset) = @_;
	    eval q(( &PATH_OFFSET_PELEMENT($p_s_path,$n_offset)-> &pe_position));
    }' unless defined(&PATH_OFFSET_POSITION);
    eval 'sub PATH_PLAST_BUFFER {
        my($p_s_path) = @_;
	    eval q(( &PATH_OFFSET_PBUFFER(($p_s_path), ($p_s_path)-> &path_length)));
    }' unless defined(&PATH_PLAST_BUFFER);
    eval 'sub PATH_LAST_POSITION {
        my($p_s_path) = @_;
	    eval q(( &PATH_OFFSET_POSITION(($p_s_path), ($p_s_path)-> &path_length)));
    }' unless defined(&PATH_LAST_POSITION);
    eval 'sub PATH_PITEM_HEAD {
        my($p_s_path) = @_;
	    eval q( &B_N_PITEM_HEAD( &PATH_PLAST_BUFFER($p_s_path), &PATH_LAST_POSITION($p_s_path)));
    }' unless defined(&PATH_PITEM_HEAD);
    eval 'sub PATH_H_PBUFFER {
        my($p_s_path, $h) = @_;
	    eval q( &PATH_OFFSET_PBUFFER ($p_s_path,  ($p_s_path->{path_length}) - ($h)));
    }' unless defined(&PATH_H_PBUFFER);
    eval 'sub PATH_H_PPARENT {
        my($path, $h) = @_;
	    eval q( &PATH_H_PBUFFER ($path, ($h) + 1));
    }' unless defined(&PATH_H_PPARENT);
    eval 'sub PATH_H_POSITION {
        my($path, $h) = @_;
	    eval q( &PATH_OFFSET_POSITION ($path,  ($path->{path_length}) - ($h)));
    }' unless defined(&PATH_H_POSITION);
    eval 'sub PATH_H_B_ITEM_ORDER {
        my($path, $h) = @_;
	    eval q( &PATH_H_POSITION($path, $h + 1));
    }' unless defined(&PATH_H_B_ITEM_ORDER);
    eval 'sub PATH_H_PATH_OFFSET {
        my($p_s_path, $n_h) = @_;
	    eval q((($p_s_path)-> &path_length - ($n_h)));
    }' unless defined(&PATH_H_PATH_OFFSET);
    eval 'sub get_last_bh {
        my($path) = @_;
	    eval q( &PATH_PLAST_BUFFER($path));
    }' unless defined(&get_last_bh);
    eval 'sub get_ih {
        my($path) = @_;
	    eval q( &PATH_PITEM_HEAD($path));
    }' unless defined(&get_ih);
    eval 'sub get_item_pos {
        my($path) = @_;
	    eval q( &PATH_LAST_POSITION($path));
    }' unless defined(&get_item_pos);
    eval 'sub get_item {
        my($path) = @_;
	    eval q((( &void *) &B_N_PITEM( &PATH_PLAST_BUFFER($path),  &PATH_LAST_POSITION ($path))));
    }' unless defined(&get_item);
    eval 'sub item_moved {
        my($ih,$path) = @_;
	    eval q( &comp_items($ih, $path));
    }' unless defined(&item_moved);
    eval 'sub path_changed {
        my($ih,$path) = @_;
	    eval q( &comp_items ($ih, $path));
    }' unless defined(&path_changed);
    eval 'sub UNFM_P_SIZE {($sizeof{ &unp_t});}' unless defined(&UNFM_P_SIZE);
    eval 'sub UNFM_P_SHIFT {2;}' unless defined(&UNFM_P_SHIFT);
    eval 'sub INODE_PKEY {
        my($inode) = @_;
	    eval q((( &REISERFS_I($inode)-> &i_key)));
    }' unless defined(&INODE_PKEY);
    eval 'sub MAX_UL_INT {0xffffffff;}' unless defined(&MAX_UL_INT);
    eval 'sub MAX_INT {0x7ffffff;}' unless defined(&MAX_INT);
    eval 'sub MAX_US_INT {0xffff;}' unless defined(&MAX_US_INT);
    eval 'sub U32_MAX {(~( &__u32)0);}' unless defined(&U32_MAX);
    eval 'sub max_reiserfs_offset {
        my($inode) = @_;
	    eval q({  &if ( &get_inode_item_key_version($inode) ==  &KEY_FORMAT_3_5) ( &loff_t)  &U32_MAX; ( &loff_t) ((~( &__u64) 0) >> 4); });
    }' unless defined(&max_reiserfs_offset);
    eval 'sub MAX_KEY_OBJECTID { &MAX_UL_INT;}' unless defined(&MAX_KEY_OBJECTID);
    eval 'sub MAX_B_NUM { &MAX_UL_INT;}' unless defined(&MAX_B_NUM);
    eval 'sub MAX_FC_NUM { &MAX_US_INT;}' unless defined(&MAX_FC_NUM);
    eval 'sub REISERFS_LINK_MAX {( &MAX_US_INT - 1000);}' unless defined(&REISERFS_LINK_MAX);
    eval 'sub REISERFS_KERNEL_MEM {0;}' unless defined(&REISERFS_KERNEL_MEM);
    eval 'sub REISERFS_USER_MEM {1;}' unless defined(&REISERFS_USER_MEM);
    eval 'sub fs_generation {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &s_generation_counter));
    }' unless defined(&fs_generation);
    eval 'sub get_generation {
        my($s) = @_;
	    eval q( &atomic_read ( &fs_generation($s)));
    }' unless defined(&get_generation);
    eval 'sub FILESYSTEM_CHANGED_TB {
        my($tb) = @_;
	    eval q(( &get_generation(($tb)-> &tb_sb) != ($tb)-> &fs_gen));
    }' unless defined(&FILESYSTEM_CHANGED_TB);
    eval 'sub __fs_changed {
        my($gen,$s) = @_;
	    eval q(($gen !=  &get_generation ($s)));
    }' unless defined(&__fs_changed);
    eval 'sub fs_changed {
        my($gen,$s) = @_;
	    eval q(({ &cond_resched();  &__fs_changed($gen, $s);}));
    }' unless defined(&fs_changed);
    eval 'sub VI_TYPE_LEFT_MERGEABLE {1;}' unless defined(&VI_TYPE_LEFT_MERGEABLE);
    eval 'sub VI_TYPE_RIGHT_MERGEABLE {2;}' unless defined(&VI_TYPE_RIGHT_MERGEABLE);
    eval 'sub MAX_FREE_BLOCK {7;}' unless defined(&MAX_FREE_BLOCK);
    eval 'sub MAX_AMOUNT_NEEDED {2;}' unless defined(&MAX_AMOUNT_NEEDED);
    if(defined(&DISPLACE_NEW_PACKING_LOCALITIES)) {
    }
    eval 'sub M_INSERT {ord(\'i\');}' unless defined(&M_INSERT);
    eval 'sub M_PASTE {ord(\'p\');}' unless defined(&M_PASTE);
    eval 'sub M_DELETE {ord(\'d\');}' unless defined(&M_DELETE);
    eval 'sub M_CUT {ord(\'c\');}' unless defined(&M_CUT);
    eval 'sub M_INTERNAL {ord(\'n\');}' unless defined(&M_INTERNAL);
    eval 'sub M_SKIP_BALANCING {ord(\'s\');}' unless defined(&M_SKIP_BALANCING);
    eval 'sub M_CONVERT {ord(\'v\');}' unless defined(&M_CONVERT);
    eval 'sub LEAF_FROM_S_TO_L {0;}' unless defined(&LEAF_FROM_S_TO_L);
    eval 'sub LEAF_FROM_S_TO_R {1;}' unless defined(&LEAF_FROM_S_TO_R);
    eval 'sub LEAF_FROM_R_TO_L {2;}' unless defined(&LEAF_FROM_R_TO_L);
    eval 'sub LEAF_FROM_L_TO_R {3;}' unless defined(&LEAF_FROM_L_TO_R);
    eval 'sub LEAF_FROM_S_TO_SNEW {4;}' unless defined(&LEAF_FROM_S_TO_SNEW);
    eval 'sub FIRST_TO_LAST {0;}' unless defined(&FIRST_TO_LAST);
    eval 'sub LAST_TO_FIRST {1;}' unless defined(&LAST_TO_FIRST);
    eval 'sub op_bytes_number {
        my($ih,$bsize) = @_;
	    eval q( ($item_ops[&le_ih_k_type(ih)]->{bytes_number}) ($ih, $bsize));
    }' unless defined(&op_bytes_number);
    eval 'sub op_is_left_mergeable {
        my($key,$bsize) = @_;
	    eval q( ($item_ops[&le_key_k_type(le_key_version(key),key)]->{is_left_mergeable}) ($key, $bsize));
    }' unless defined(&op_is_left_mergeable);
    eval 'sub op_print_item {
        my($ih,$item) = @_;
	    eval q( ($item_ops[&le_ih_k_type(ih)]->{print_item}) ($ih, $item));
    }' unless defined(&op_print_item);
    eval 'sub op_check_item {
        my($ih,$item) = @_;
	    eval q( ($item_ops[&le_ih_k_type(ih)]->{check_item}) ($ih, $item));
    }' unless defined(&op_check_item);
    eval 'sub op_create_vi {
        my($vn,$vi,$is_affected,$insert_size) = @_;
	    eval q( ($item_ops[&le_ih_k_type((vi)->{vi_ih)]}->{create_vi}) ($vn,$vi,$is_affected,$insert_size));
    }' unless defined(&op_create_vi);
    eval 'sub op_check_left {
        my($vi,$free,$start_skip,$end_skip) = @_;
	    eval q( ($item_ops[&(vi)->{vi_index]}->{check_left}) ($vi, $free, $start_skip, $end_skip));
    }' unless defined(&op_check_left);
    eval 'sub op_check_right {
        my($vi,$free) = @_;
	    eval q( ($item_ops[&(vi)->{vi_index]}->{check_right}) ($vi, $free));
    }' unless defined(&op_check_right);
    eval 'sub op_part_size {
        my($vi,$from,$to) = @_;
	    eval q( ($item_ops[&(vi)->{vi_index]}->{part_size}) ($vi, $from, $to));
    }' unless defined(&op_part_size);
    eval 'sub op_unit_num {
        my($vi) = @_;
	    eval q( ($item_ops[&(vi)->{vi_index]}->{unit_num}) ($vi));
    }' unless defined(&op_unit_num);
    eval 'sub op_print_vi {
        my($vi) = @_;
	    eval q( ($item_ops[&(vi)->{vi_index]}->{print_vi}) ($vi));
    }' unless defined(&op_print_vi);
    eval 'sub COMP_SHORT_KEYS { &comp_short_keys;}' unless defined(&COMP_SHORT_KEYS);
    eval 'sub I_UNFM_NUM {
        my($p_s_ih) = @_;
	    eval q((  &ih_item_len($p_s_ih) /  &UNFM_P_SIZE ));
    }' unless defined(&I_UNFM_NUM);
    eval 'sub I_POS_UNFM_SIZE {
        my($ih,$pos,$size) = @_;
	    eval q(((($pos) ==  &I_UNFM_NUM($ih) - 1) ? ($size) -  &ih_free_space($ih) : ($size)));
    }' unless defined(&I_POS_UNFM_SIZE);
    eval 'sub B_N_PITEM_HEAD {
        my($bh,$item_num) = @_;
	    eval q(( (($bh)-> &b_data +  &BLKH_SIZE) + ($item_num) ));
    }' unless defined(&B_N_PITEM_HEAD);
    eval 'sub B_N_PDELIM_KEY {
        my($bh,$item_num) = @_;
	    eval q(( (($bh)-> &b_data +  &BLKH_SIZE) + ($item_num) ));
    }' unless defined(&B_N_PDELIM_KEY);
    eval 'sub B_N_PKEY {
        my($bh,$item_num) = @_;
	    eval q(( ( &B_N_PITEM_HEAD($bh,$item_num)-> &ih_key) ));
    }' unless defined(&B_N_PKEY);
    eval 'sub B_N_PITEM {
        my($bh,$item_num) = @_;
	    eval q(( ($bh)-> &b_data +  &ih_location( &B_N_PITEM_HEAD(($bh),($item_num)))));
    }' unless defined(&B_N_PITEM);
    eval 'sub B_N_STAT_DATA {
        my($bh,$nr) = @_;
	    eval q(( (($bh)-> &b_data +  &ih_location( &B_N_PITEM_HEAD(($bh),($nr))) ) ));
    }' unless defined(&B_N_STAT_DATA);
    eval 'sub B_I_STAT_DATA {
        my($bh, $ih) = @_;
	    eval q(( (($bh)-> &b_data +  &ih_location($ih)) ));
    }' unless defined(&B_I_STAT_DATA);
    eval 'sub MAX_DIRECT_ITEM_LEN {
        my($size) = @_;
	    eval q((($size) -  &BLKH_SIZE - 2* &IH_SIZE -  &SD_SIZE -  &UNFM_P_SIZE));
    }' unless defined(&MAX_DIRECT_ITEM_LEN);
    eval 'sub B_I_POS_UNFM_POINTER {
        my($bh,$ih,$pos) = @_;
	    eval q( &le32_to_cpu(*((( &unp_t *) &B_I_PITEM($bh,$ih)) + ($pos))));
    }' unless defined(&B_I_POS_UNFM_POINTER);
    eval 'sub PUT_B_I_POS_UNFM_POINTER {
        my($bh,$ih,$pos, $val) = @_;
	    eval q( &do {*((( &unp_t *) &B_I_PITEM($bh,$ih)) + ($pos)) =  &cpu_to_le32($val); }  &while (0));
    }' unless defined(&PUT_B_I_POS_UNFM_POINTER);
    eval 'sub get_journal_desc_magic {
        my($bh) = @_;
	    eval q(( ($bh->{b_data}) +  ($bh->{b_size}) - 12));
    }' unless defined(&get_journal_desc_magic);
    eval 'sub journal_trans_half {
        my($blocksize) = @_;
	    eval q((($blocksize - $sizeof{\'struct reiserfs_journal_desc\'} + $sizeof{ &__u32} - 12) / $sizeof{ &__u32}));
    }' unless defined(&journal_trans_half);
    eval 'sub get_desc_trans_id {
        my($d) = @_;
	    eval q( &le32_to_cpu(($d)-> &j_trans_id));
    }' unless defined(&get_desc_trans_id);
    eval 'sub get_desc_trans_len {
        my($d) = @_;
	    eval q( &le32_to_cpu(($d)-> &j_len));
    }' unless defined(&get_desc_trans_len);
    eval 'sub get_desc_mount_id {
        my($d) = @_;
	    eval q( &le32_to_cpu(($d)-> &j_mount_id));
    }' unless defined(&get_desc_mount_id);
    eval 'sub set_desc_trans_id {
        my($d,$val) = @_;
	    eval q( &do { ($d)-> &j_trans_id =  &cpu_to_le32 ($val); }  &while (0));
    }' unless defined(&set_desc_trans_id);
    eval 'sub set_desc_trans_len {
        my($d,$val) = @_;
	    eval q( &do { ($d)-> &j_len =  &cpu_to_le32 ($val); }  &while (0));
    }' unless defined(&set_desc_trans_len);
    eval 'sub set_desc_mount_id {
        my($d,$val) = @_;
	    eval q( &do { ($d)-> &j_mount_id =  &cpu_to_le32 ($val); }  &while (0));
    }' unless defined(&set_desc_mount_id);
    eval 'sub get_commit_trans_id {
        my($c) = @_;
	    eval q( &le32_to_cpu(($c)-> &j_trans_id));
    }' unless defined(&get_commit_trans_id);
    eval 'sub get_commit_trans_len {
        my($c) = @_;
	    eval q( &le32_to_cpu(($c)-> &j_len));
    }' unless defined(&get_commit_trans_len);
    eval 'sub get_commit_mount_id {
        my($c) = @_;
	    eval q( &le32_to_cpu(($c)-> &j_mount_id));
    }' unless defined(&get_commit_mount_id);
    eval 'sub set_commit_trans_id {
        my($c,$val) = @_;
	    eval q( &do { ($c)-> &j_trans_id =  &cpu_to_le32 ($val); }  &while (0));
    }' unless defined(&set_commit_trans_id);
    eval 'sub set_commit_trans_len {
        my($c,$val) = @_;
	    eval q( &do { ($c)-> &j_len =  &cpu_to_le32 ($val); }  &while (0));
    }' unless defined(&set_commit_trans_len);
    eval 'sub JOURNAL_BLOCK_COUNT {8192;}' unless defined(&JOURNAL_BLOCK_COUNT);
    eval 'sub JOURNAL_TRANS_MAX_DEFAULT {1024;}' unless defined(&JOURNAL_TRANS_MAX_DEFAULT);
    eval 'sub JOURNAL_TRANS_MIN_DEFAULT {256;}' unless defined(&JOURNAL_TRANS_MIN_DEFAULT);
    eval 'sub JOURNAL_MAX_BATCH_DEFAULT {900;}' unless defined(&JOURNAL_MAX_BATCH_DEFAULT);
    eval 'sub JOURNAL_MIN_RATIO {2;}' unless defined(&JOURNAL_MIN_RATIO);
    eval 'sub JOURNAL_MAX_COMMIT_AGE {30;}' unless defined(&JOURNAL_MAX_COMMIT_AGE);
    eval 'sub JOURNAL_MAX_TRANS_AGE {30;}' unless defined(&JOURNAL_MAX_TRANS_AGE);
    eval 'sub JOURNAL_PER_BALANCE_CNT {(3* ( &MAX_HEIGHT-2) + 9);}' unless defined(&JOURNAL_PER_BALANCE_CNT);
    if(defined(&CONFIG_QUOTA)) {
	eval 'sub REISERFS_QUOTA_TRANS_BLOCKS {
	    my($s) = @_;
    	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<< &REISERFS_QUOTA) ? 2: 0));
	}' unless defined(&REISERFS_QUOTA_TRANS_BLOCKS);
	eval 'sub REISERFS_QUOTA_INIT_BLOCKS {
	    my($s) = @_;
    	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<< &REISERFS_QUOTA) ? ( &DQUOT_INIT_ALLOC*( &JOURNAL_PER_BALANCE_CNT+2)+ &DQUOT_INIT_REWRITE+1) : 0));
	}' unless defined(&REISERFS_QUOTA_INIT_BLOCKS);
	eval 'sub REISERFS_QUOTA_DEL_BLOCKS {
	    my($s) = @_;
    	    eval q(( &REISERFS_SB($s)-> &s_mount_opt & (1<< &REISERFS_QUOTA) ? ( &DQUOT_DEL_ALLOC*( &JOURNAL_PER_BALANCE_CNT+2)+ &DQUOT_DEL_REWRITE+1) : 0));
	}' unless defined(&REISERFS_QUOTA_DEL_BLOCKS);
    } else {
	eval 'sub REISERFS_QUOTA_TRANS_BLOCKS {
	    my($s) = @_;
    	    eval q(0);
	}' unless defined(&REISERFS_QUOTA_TRANS_BLOCKS);
	eval 'sub REISERFS_QUOTA_INIT_BLOCKS {
	    my($s) = @_;
    	    eval q(0);
	}' unless defined(&REISERFS_QUOTA_INIT_BLOCKS);
	eval 'sub REISERFS_QUOTA_DEL_BLOCKS {
	    my($s) = @_;
    	    eval q(0);
	}' unless defined(&REISERFS_QUOTA_DEL_BLOCKS);
    }
    eval 'sub REISERFS_MIN_BITMAP_NODES {10;}' unless defined(&REISERFS_MIN_BITMAP_NODES);
    eval 'sub REISERFS_MAX_BITMAP_NODES {100;}' unless defined(&REISERFS_MAX_BITMAP_NODES);
    eval 'sub JBH_HASH_SHIFT {13;}' unless defined(&JBH_HASH_SHIFT);
    eval 'sub JBH_HASH_MASK {8191;}' unless defined(&JBH_HASH_MASK);
    eval 'sub _jhashfn {
        my($sb,$block) = @_;
	    eval q((($sb>> &L1_CACHE_SHIFT) ^ ((($block)<<( &JBH_HASH_SHIFT - 6)) ^ (($block) >> 13) ^ (($block) << ( &JBH_HASH_SHIFT - 12)))));
    }' unless defined(&_jhashfn);
    eval 'sub journal_hash {
        my($t,$sb,$block) = @_;
	    eval q((($t)[ &_jhashfn(($sb),($block)) &  &JBH_HASH_MASK]));
    }' unless defined(&journal_hash);
    eval 'sub journal_find_get_block {
        my($s, $block) = @_;
	    eval q( &__find_get_block( &SB_JOURNAL($s)-> &j_dev_bd, $block,  ($s->{s_blocksize})));
    }' unless defined(&journal_find_get_block);
    eval 'sub journal_getblk {
        my($s, $block) = @_;
	    eval q( &__getblk( &SB_JOURNAL($s)-> &j_dev_bd, $block,  ($s->{s_blocksize})));
    }' unless defined(&journal_getblk);
    eval 'sub journal_bread {
        my($s, $block) = @_;
	    eval q( &__bread( &SB_JOURNAL($s)-> &j_dev_bd, $block,  ($s->{s_blocksize})));
    }' unless defined(&journal_bread);
    eval("sub BH_JDirty () { BH_PrivateStart; }") unless defined(&BH_JDirty);
    eval("sub BH_JDirty_wait () { 1; }") unless defined(&BH_JDirty_wait);
    eval("sub BH_JNew () { 2; }") unless defined(&BH_JNew);
    eval("sub BH_JPrepared () { 3; }") unless defined(&BH_JPrepared);
    eval("sub BH_JRestore_dirty () { 4; }") unless defined(&BH_JRestore_dirty);
    eval("sub BH_JTest () { 5; }") unless defined(&BH_JTest);
    eval 'sub reiserfs_file_data_log {
        my($inode) = @_;
	    eval q({  &if ( &reiserfs_data_log( ($inode->{i_sb})) || ( &REISERFS_I($inode)-> &i_flags &  &i_data_log)) 1; 0; });
    }' unless defined(&reiserfs_file_data_log);
    eval 'sub reiserfs_transaction_running {
        my($s) = @_;
	    eval q({ \'struct reiserfs_transaction_handle\' * &th =  ($current->{journal_info});  &if ( &th  &&  ($th->{t_super}) == $s) 1;  &if ( &th  &&  ($th->{t_super}) ==  &NULL)  &BUG(); 0; });
    }' unless defined(&reiserfs_transaction_running);
    eval 'sub reiserfs_transaction_free_space {
        my($th) = @_;
	    eval q({  ($th->{t_blocks_allocated}) -  ($th->{t_blocks_logged}); });
    }' unless defined(&reiserfs_transaction_free_space);
    eval 'sub le_key_version {
        my($key) = @_;
	    eval q({ \'int\'  &type;  &type =  &offset_v2_k_type(( ($key->{u}->{k_offset_v2})));  &if ( &type !=  &TYPE_DIRECT  &&  &type !=  &TYPE_INDIRECT  &&  &type !=  &TYPE_DIRENTRY)  &KEY_FORMAT_3_5;  &KEY_FORMAT_3_6; });
    }' unless defined(&le_key_version);
    eval 'sub copy_key {
        my($to,$from) = @_;
	    eval q({  &memcpy($to, $from,  &KEY_SIZE); });
    }' unless defined(&copy_key);
    eval 'sub search_item {
        my($s,$key,$path) = @_;
	    eval q( &search_by_key ($s, $key, $path,  &DISK_LEAF_NODE_LEVEL));
    }' unless defined(&search_item);
    eval 'sub i_block_size {
        my($inode) = @_;
	    eval q((($inode)-> ($i_sb->{s_blocksize})));
    }' unless defined(&i_block_size);
    eval 'sub file_size {
        my($inode) = @_;
	    eval q((($inode)-> &i_size));
    }' unless defined(&file_size);
    eval 'sub tail_size {
        my($inode) = @_;
	    eval q(( &file_size ($inode) & ( &i_block_size ($inode) - 1)));
    }' unless defined(&tail_size);
    eval 'sub tail_has_to_be_packed {
        my($inode) = @_;
	    eval q(( &have_large_tails (($inode)-> &i_sb)?! &STORE_TAIL_IN_UNFM_S1( &file_size ($inode),  &tail_size($inode),  ($inode->{i_sb}->{s_blocksize})): &have_small_tails (($inode)-> &i_sb)?! &STORE_TAIL_IN_UNFM_S2( &file_size ($inode),  &tail_size($inode),  ($inode->{i_sb}->{s_blocksize})):0));
    }' unless defined(&tail_has_to_be_packed);
    eval 'sub GET_BLOCK_NO_CREATE {0;}' unless defined(&GET_BLOCK_NO_CREATE);
    eval 'sub GET_BLOCK_CREATE {1;}' unless defined(&GET_BLOCK_CREATE);
    eval 'sub GET_BLOCK_NO_HOLE {2;}' unless defined(&GET_BLOCK_NO_HOLE);
    eval 'sub GET_BLOCK_READ_DIRECT {4;}' unless defined(&GET_BLOCK_READ_DIRECT);
    eval 'sub GET_BLOCK_NO_IMUX {8;}' unless defined(&GET_BLOCK_NO_IMUX);
    eval 'sub GET_BLOCK_NO_DANGLE {16;}' unless defined(&GET_BLOCK_NO_DANGLE);
    eval 'sub reiserfs_update_sd {
        my($th,$inode) = @_;
	    eval q({  &reiserfs_update_sd_size($th, $inode,  ($inode->{i_size})); });
    }' unless defined(&reiserfs_update_sd);
    if(defined( (defined(&CONFIG_PROC_FS) ? &CONFIG_PROC_FS : 0) )  && defined( (defined(&CONFIG_REISERFS_PROC_INFO) ? &CONFIG_REISERFS_PROC_INFO : 0) )) {
	eval 'sub REISERFS_PROC_INFO {1;}' unless defined(&REISERFS_PROC_INFO);
    } else {
	undef(&REISERFS_PROC_INFO) if defined(&REISERFS_PROC_INFO);
    }
    if(defined( (defined(&REISERFS_PROC_INFO) ? &REISERFS_PROC_INFO : 0) )) {
	eval 'sub PROC_EXP {
	    my( $e ) = @_;
    	    eval q( &e);
	}' unless defined(&PROC_EXP);
	eval 'sub __PINFO {
	    my( $sb ) = @_;
    	    eval q( &REISERFS_SB($sb) ->  &s_proc_info_data);
	}' unless defined(&__PINFO);
	eval 'sub PROC_INFO_MAX {
	    my( $sb, $field, $value ) = @_;
    	    eval q( &__PINFO( $sb ).$field =  &max(  &REISERFS_SB( $sb ) ->  ($s_proc_info_data->{field}), $value ));
	}' unless defined(&PROC_INFO_MAX);
	eval 'sub PROC_INFO_INC {
	    my( $sb, $field ) = @_;
    	    eval q(( ++ (  &__PINFO( $sb ).$field ) ));
	}' unless defined(&PROC_INFO_INC);
	eval 'sub PROC_INFO_ADD {
	    my( $sb, $field, $val ) = @_;
    	    eval q((  &__PINFO( $sb ).$field += ( $val ) ));
	}' unless defined(&PROC_INFO_ADD);
	eval 'sub PROC_INFO_BH_STAT {
	    my( $sb, $bh, $level ) = @_;
    	    eval q( &PROC_INFO_INC( $sb,  $sbk_read_at[ ( $level ) ] );  &PROC_INFO_ADD( $sb,  $free_at[ ( $level ) ],  &B_FREE_SPACE( $bh ) );  &PROC_INFO_ADD( $sb,  $items_at[ ( $level ) ],  &B_NR_ITEMS( $bh ) ));
	}' unless defined(&PROC_INFO_BH_STAT);
    } else {
	eval 'sub PROC_EXP {
	    my( $e ) = @_;
    	    eval q();
	}' unless defined(&PROC_EXP);
	eval 'sub VOID_V {( (  &void ) 0);}' unless defined(&VOID_V);
	eval 'sub PROC_INFO_MAX {
	    my( $sb, $field, $value ) = @_;
    	    eval q( &VOID_V);
	}' unless defined(&PROC_INFO_MAX);
	eval 'sub PROC_INFO_INC {
	    my( $sb, $field ) = @_;
    	    eval q( &VOID_V);
	}' unless defined(&PROC_INFO_INC);
	eval 'sub PROC_INFO_ADD {
	    my( $sb, $field, $val ) = @_;
    	    eval q( &VOID_V);
	}' unless defined(&PROC_INFO_ADD);
	eval 'sub PROC_INFO_BH_STAT {
	    my( $p_s_sb, $p_s_bh, $n_node_level ) = @_;
    	    eval q( &VOID_V);
	}' unless defined(&PROC_INFO_BH_STAT);
    }
    eval 'sub PRINT_LEAF_ITEMS {1;}' unless defined(&PRINT_LEAF_ITEMS);
    eval 'sub PRINT_DIRECTORY_ITEMS {2;}' unless defined(&PRINT_DIRECTORY_ITEMS);
    eval 'sub PRINT_DIRECT_ITEMS {4;}' unless defined(&PRINT_DIRECT_ITEMS);
    eval 'sub do_balance_mark_internal_dirty { &do_balance_mark_leaf_dirty;}' unless defined(&do_balance_mark_internal_dirty);
    eval 'sub do_balance_mark_sb_dirty { &do_balance_mark_leaf_dirty;}' unless defined(&do_balance_mark_sb_dirty);
    eval 'sub reiserfs_new_form_blocknrs {
        my($tb,$new_blocknrs,$amount_needed) = @_;
	    eval q({  &reiserfs_blocknr_hint_t  &hint = { . &th =  ($tb->{transaction_handle}), . &path =  ($tb->{tb_path}), . &inode =  &NULL, . &key =  ($tb->{key}), . &block = 0, . &formatted_node = 1};  &reiserfs_allocate_blocknrs( &hint, $new_blocknrs, $amount_needed, 0); });
    }' unless defined(&reiserfs_new_form_blocknrs);
    eval 'sub reiserfs_new_unf_blocknrs {
        my($th,$inode,$new_blocknrs,$path,$block) = @_;
	    eval q({  &reiserfs_blocknr_hint_t  &hint = { .$th = $th, .$path = $path, .$inode = $inode, .$block = $block, . &formatted_node = 0, . &preallocate = 0};  &reiserfs_allocate_blocknrs( &hint, $new_blocknrs, 1, 0); });
    }' unless defined(&reiserfs_new_unf_blocknrs);
    if(defined(&REISERFS_PREALLOCATE)) {
	eval 'sub reiserfs_new_unf_blocknrs2 {
	    my($th,$inode,$new_blocknrs,$path,$block) = @_;
    	    eval q({  &reiserfs_blocknr_hint_t  &hint = { .$th = $th, .$path = $path, .$inode = $inode, .$block = $block, . &formatted_node = 0, . &preallocate = 1};  &reiserfs_allocate_blocknrs( &hint, $new_blocknrs, 1, 0); });
	}' unless defined(&reiserfs_new_unf_blocknrs2);
    }
    eval 'sub reiserfs_test_and_set_le_bit { &ext2_set_bit;}' unless defined(&reiserfs_test_and_set_le_bit);
    eval 'sub reiserfs_test_and_clear_le_bit { &ext2_clear_bit;}' unless defined(&reiserfs_test_and_clear_le_bit);
    eval 'sub reiserfs_test_le_bit { &ext2_test_bit;}' unless defined(&reiserfs_test_le_bit);
    eval 'sub reiserfs_find_next_zero_le_bit { &ext2_find_next_zero_bit;}' unless defined(&reiserfs_find_next_zero_le_bit);
    eval 'sub SPARE_SPACE {500;}' unless defined(&SPARE_SPACE);
    eval 'sub REISERFS_IOC_UNPACK { &_IOW(0xcd,1,\'long\');}' unless defined(&REISERFS_IOC_UNPACK);
    eval 'sub REISERFS_IOC_GETFLAGS { &FS_IOC_GETFLAGS;}' unless defined(&REISERFS_IOC_GETFLAGS);
    eval 'sub REISERFS_IOC_SETFLAGS { &FS_IOC_SETFLAGS;}' unless defined(&REISERFS_IOC_SETFLAGS);
    eval 'sub REISERFS_IOC_GETVERSION { &FS_IOC_GETVERSION;}' unless defined(&REISERFS_IOC_GETVERSION);
    eval 'sub REISERFS_IOC_SETVERSION { &FS_IOC_SETVERSION;}' unless defined(&REISERFS_IOC_SETVERSION);
    eval 'sub REISERFS_IOC32_UNPACK { &_IOW(0xcd, 1, \'int\');}' unless defined(&REISERFS_IOC32_UNPACK);
    eval 'sub REISERFS_IOC32_GETFLAGS { &FS_IOC32_GETFLAGS;}' unless defined(&REISERFS_IOC32_GETFLAGS);
    eval 'sub REISERFS_IOC32_SETFLAGS { &FS_IOC32_SETFLAGS;}' unless defined(&REISERFS_IOC32_SETFLAGS);
    eval 'sub REISERFS_IOC32_GETVERSION { &FS_IOC32_GETVERSION;}' unless defined(&REISERFS_IOC32_GETVERSION);
    eval 'sub REISERFS_IOC32_SETVERSION { &FS_IOC32_SETVERSION;}' unless defined(&REISERFS_IOC32_SETVERSION);
    eval 'sub reiserfs_write_lock {
        my( $sb ) = @_;
	    eval q( &lock_kernel());
    }' unless defined(&reiserfs_write_lock);
    eval 'sub reiserfs_write_unlock {
        my( $sb ) = @_;
	    eval q( &unlock_kernel());
    }' unless defined(&reiserfs_write_unlock);
    eval 'sub REISERFS_XATTR_DIR_SEM {
        my($s) = @_;
	    eval q(( &REISERFS_SB($s)-> &xattr_dir_sem));
    }' unless defined(&REISERFS_XATTR_DIR_SEM);
}
1;
