require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_IA64_INTEL_INTRIN_H)) {
    eval 'sub _ASM_IA64_INTEL_INTRIN_H {1;}' unless defined(&_ASM_IA64_INTEL_INTRIN_H);
    require 'ia64intrin.ph';
    eval 'sub ia64_barrier () {
        eval q( &__memory_barrier());
    }' unless defined(&ia64_barrier);
    eval 'sub ia64_stop () {
        eval q();
    }' unless defined(&ia64_stop);
    eval 'sub ia64_getreg { &__getReg;}' unless defined(&ia64_getreg);
    eval 'sub ia64_setreg { &__setReg;}' unless defined(&ia64_setreg);
    eval 'sub ia64_hint { &__hint;}' unless defined(&ia64_hint);
    eval 'sub ia64_hint_pause { &__hint_pause;}' unless defined(&ia64_hint_pause);
    eval 'sub ia64_mux1_brcst { &_m64_mux1_brcst;}' unless defined(&ia64_mux1_brcst);
    eval 'sub ia64_mux1_mix { &_m64_mux1_mix;}' unless defined(&ia64_mux1_mix);
    eval 'sub ia64_mux1_shuf { &_m64_mux1_shuf;}' unless defined(&ia64_mux1_shuf);
    eval 'sub ia64_mux1_alt { &_m64_mux1_alt;}' unless defined(&ia64_mux1_alt);
    eval 'sub ia64_mux1_rev { &_m64_mux1_rev;}' unless defined(&ia64_mux1_rev);
    eval 'sub ia64_mux1 {
        my($x,$v) = @_;
	    eval q( &_m_to_int64( &_m64_mux1( &_m_from_int64($x), ($v))));
    }' unless defined(&ia64_mux1);
    eval 'sub ia64_popcnt { &_m64_popcnt;}' unless defined(&ia64_popcnt);
    eval 'sub ia64_getf_exp { &__getf_exp;}' unless defined(&ia64_getf_exp);
    eval 'sub ia64_shrp { &_m64_shrp;}' unless defined(&ia64_shrp);
    eval 'sub ia64_tpa { &__tpa;}' unless defined(&ia64_tpa);
    eval 'sub ia64_invala { &__invala;}' unless defined(&ia64_invala);
    eval 'sub ia64_invala_gr { &__invala_gr;}' unless defined(&ia64_invala_gr);
    eval 'sub ia64_invala_fr { &__invala_fr;}' unless defined(&ia64_invala_fr);
    eval 'sub ia64_nop { &__nop;}' unless defined(&ia64_nop);
    eval 'sub ia64_sum { &__sum;}' unless defined(&ia64_sum);
    eval 'sub ia64_ssm { &__ssm;}' unless defined(&ia64_ssm);
    eval 'sub ia64_rum { &__rum;}' unless defined(&ia64_rum);
    eval 'sub ia64_rsm { &__rsm;}' unless defined(&ia64_rsm);
    eval 'sub ia64_fc { &__fc;}' unless defined(&ia64_fc);
    eval 'sub ia64_ldfs { &__ldfs;}' unless defined(&ia64_ldfs);
    eval 'sub ia64_ldfd { &__ldfd;}' unless defined(&ia64_ldfd);
    eval 'sub ia64_ldfe { &__ldfe;}' unless defined(&ia64_ldfe);
    eval 'sub ia64_ldf8 { &__ldf8;}' unless defined(&ia64_ldf8);
    eval 'sub ia64_ldf_fill { &__ldf_fill;}' unless defined(&ia64_ldf_fill);
    eval 'sub ia64_stfs { &__stfs;}' unless defined(&ia64_stfs);
    eval 'sub ia64_stfd { &__stfd;}' unless defined(&ia64_stfd);
    eval 'sub ia64_stfe { &__stfe;}' unless defined(&ia64_stfe);
    eval 'sub ia64_stf8 { &__stf8;}' unless defined(&ia64_stf8);
    eval 'sub ia64_stf_spill { &__stf_spill;}' unless defined(&ia64_stf_spill);
    eval 'sub ia64_mf { &__mf;}' unless defined(&ia64_mf);
    eval 'sub ia64_mfa { &__mfa;}' unless defined(&ia64_mfa);
    eval 'sub ia64_fetchadd4_acq { &__fetchadd4_acq;}' unless defined(&ia64_fetchadd4_acq);
    eval 'sub ia64_fetchadd4_rel { &__fetchadd4_rel;}' unless defined(&ia64_fetchadd4_rel);
    eval 'sub ia64_fetchadd8_acq { &__fetchadd8_acq;}' unless defined(&ia64_fetchadd8_acq);
    eval 'sub ia64_fetchadd8_rel { &__fetchadd8_rel;}' unless defined(&ia64_fetchadd8_rel);
    eval 'sub ia64_xchg1 { &_InterlockedExchange8;}' unless defined(&ia64_xchg1);
    eval 'sub ia64_xchg2 { &_InterlockedExchange16;}' unless defined(&ia64_xchg2);
    eval 'sub ia64_xchg4 { &_InterlockedExchange;}' unless defined(&ia64_xchg4);
    eval 'sub ia64_xchg8 { &_InterlockedExchange64;}' unless defined(&ia64_xchg8);
    eval 'sub ia64_cmpxchg1_rel { &_InterlockedCompareExchange8_rel;}' unless defined(&ia64_cmpxchg1_rel);
    eval 'sub ia64_cmpxchg1_acq { &_InterlockedCompareExchange8_acq;}' unless defined(&ia64_cmpxchg1_acq);
    eval 'sub ia64_cmpxchg2_rel { &_InterlockedCompareExchange16_rel;}' unless defined(&ia64_cmpxchg2_rel);
    eval 'sub ia64_cmpxchg2_acq { &_InterlockedCompareExchange16_acq;}' unless defined(&ia64_cmpxchg2_acq);
    eval 'sub ia64_cmpxchg4_rel { &_InterlockedCompareExchange_rel;}' unless defined(&ia64_cmpxchg4_rel);
    eval 'sub ia64_cmpxchg4_acq { &_InterlockedCompareExchange_acq;}' unless defined(&ia64_cmpxchg4_acq);
    eval 'sub ia64_cmpxchg8_rel { &_InterlockedCompareExchange64_rel;}' unless defined(&ia64_cmpxchg8_rel);
    eval 'sub ia64_cmpxchg8_acq { &_InterlockedCompareExchange64_acq;}' unless defined(&ia64_cmpxchg8_acq);
    eval 'sub __ia64_set_dbr {
        my($index, $val) = @_;
	    eval q( &__setIndReg( &_IA64_REG_INDR_DBR, $index, $val));
    }' unless defined(&__ia64_set_dbr);
    eval 'sub ia64_set_ibr {
        my($index, $val) = @_;
	    eval q( &__setIndReg( &_IA64_REG_INDR_IBR, $index, $val));
    }' unless defined(&ia64_set_ibr);
    eval 'sub ia64_set_pkr {
        my($index, $val) = @_;
	    eval q( &__setIndReg( &_IA64_REG_INDR_PKR, $index, $val));
    }' unless defined(&ia64_set_pkr);
    eval 'sub ia64_set_pmc {
        my($index, $val) = @_;
	    eval q( &__setIndReg( &_IA64_REG_INDR_PMC, $index, $val));
    }' unless defined(&ia64_set_pmc);
    eval 'sub ia64_set_pmd {
        my($index, $val) = @_;
	    eval q( &__setIndReg( &_IA64_REG_INDR_PMD, $index, $val));
    }' unless defined(&ia64_set_pmd);
    eval 'sub ia64_set_rr {
        my($index, $val) = @_;
	    eval q( &__setIndReg( &_IA64_REG_INDR_RR, $index, $val));
    }' unless defined(&ia64_set_rr);
    eval 'sub ia64_get_cpuid {
        my($index) = @_;
	    eval q( &__getIndReg( &_IA64_REG_INDR_CPUID, $index));
    }' unless defined(&ia64_get_cpuid);
    eval 'sub __ia64_get_dbr {
        my($index) = @_;
	    eval q( &__getIndReg( &_IA64_REG_INDR_DBR, $index));
    }' unless defined(&__ia64_get_dbr);
    eval 'sub ia64_get_ibr {
        my($index) = @_;
	    eval q( &__getIndReg( &_IA64_REG_INDR_IBR, $index));
    }' unless defined(&ia64_get_ibr);
    eval 'sub ia64_get_pkr {
        my($index) = @_;
	    eval q( &__getIndReg( &_IA64_REG_INDR_PKR, $index));
    }' unless defined(&ia64_get_pkr);
    eval 'sub ia64_get_pmc {
        my($index) = @_;
	    eval q( &__getIndReg( &_IA64_REG_INDR_PMC, $index));
    }' unless defined(&ia64_get_pmc);
    eval 'sub ia64_get_pmd {
        my($index) = @_;
	    eval q( &__getIndReg( &_IA64_REG_INDR_PMD, $index));
    }' unless defined(&ia64_get_pmd);
    eval 'sub ia64_get_rr {
        my($index) = @_;
	    eval q( &__getIndReg( &_IA64_REG_INDR_RR, $index));
    }' unless defined(&ia64_get_rr);
    eval 'sub ia64_srlz_d { &__dsrlz;}' unless defined(&ia64_srlz_d);
    eval 'sub ia64_srlz_i { &__isrlz;}' unless defined(&ia64_srlz_i);
    eval 'sub ia64_dv_serialize_data () {
        eval q();
    }' unless defined(&ia64_dv_serialize_data);
    eval 'sub ia64_dv_serialize_instruction () {
        eval q();
    }' unless defined(&ia64_dv_serialize_instruction);
    eval 'sub ia64_st1_rel { &__st1_rel;}' unless defined(&ia64_st1_rel);
    eval 'sub ia64_st2_rel { &__st2_rel;}' unless defined(&ia64_st2_rel);
    eval 'sub ia64_st4_rel { &__st4_rel;}' unless defined(&ia64_st4_rel);
    eval 'sub ia64_st8_rel { &__st8_rel;}' unless defined(&ia64_st8_rel);
    eval 'sub ia64_ld1_acq { &__ld1_acq;}' unless defined(&ia64_ld1_acq);
    eval 'sub ia64_ld2_acq { &__ld2_acq;}' unless defined(&ia64_ld2_acq);
    eval 'sub ia64_ld4_acq { &__ld4_acq;}' unless defined(&ia64_ld4_acq);
    eval 'sub ia64_ld8_acq { &__ld8_acq;}' unless defined(&ia64_ld8_acq);
    eval 'sub ia64_sync_i { &__synci;}' unless defined(&ia64_sync_i);
    eval 'sub ia64_thash { &__thash;}' unless defined(&ia64_thash);
    eval 'sub ia64_ttag { &__ttag;}' unless defined(&ia64_ttag);
    eval 'sub ia64_itcd { &__itcd;}' unless defined(&ia64_itcd);
    eval 'sub ia64_itci { &__itci;}' unless defined(&ia64_itci);
    eval 'sub ia64_itrd { &__itrd;}' unless defined(&ia64_itrd);
    eval 'sub ia64_itri { &__itri;}' unless defined(&ia64_itri);
    eval 'sub ia64_ptce { &__ptce;}' unless defined(&ia64_ptce);
    eval 'sub ia64_ptcl { &__ptcl;}' unless defined(&ia64_ptcl);
    eval 'sub ia64_ptcg { &__ptcg;}' unless defined(&ia64_ptcg);
    eval 'sub ia64_ptcga { &__ptcga;}' unless defined(&ia64_ptcga);
    eval 'sub ia64_ptri { &__ptri;}' unless defined(&ia64_ptri);
    eval 'sub ia64_ptrd { &__ptrd;}' unless defined(&ia64_ptrd);
    eval 'sub ia64_dep_mi { &_m64_dep_mi;}' unless defined(&ia64_dep_mi);
    eval 'sub ia64_lfhint_none { &__lfhint_none;}' unless defined(&ia64_lfhint_none);
    eval 'sub ia64_lfhint_nt1 { &__lfhint_nt1;}' unless defined(&ia64_lfhint_nt1);
    eval 'sub ia64_lfhint_nt2 { &__lfhint_nt2;}' unless defined(&ia64_lfhint_nt2);
    eval 'sub ia64_lfhint_nta { &__lfhint_nta;}' unless defined(&ia64_lfhint_nta);
    eval 'sub ia64_lfetch { &__lfetch;}' unless defined(&ia64_lfetch);
    eval 'sub ia64_lfetch_excl { &__lfetch_excl;}' unless defined(&ia64_lfetch_excl);
    eval 'sub ia64_lfetch_fault { &__lfetch_fault;}' unless defined(&ia64_lfetch_fault);
    eval 'sub ia64_lfetch_fault_excl { &__lfetch_fault_excl;}' unless defined(&ia64_lfetch_fault_excl);
    eval 'sub ia64_intrin_local_irq_restore {
        my($x) = @_;
	    eval q( &do {  &if (($x) != 0) {  &ia64_ssm( &IA64_PSR_I);  &ia64_srlz_d(); }  &else {  &ia64_rsm( &IA64_PSR_I); } }  &while (0));
    }' unless defined(&ia64_intrin_local_irq_restore);
    eval 'sub __builtin_trap () {
        eval q( &__break(0););
    }' unless defined(&__builtin_trap);
}
1;
