#! /usr/bin/perl -w

use strict;

if( ! -e "/etc/krb5.conf.heimdal") {
    # nothing to do
    exit 0;
}

open(KRB5_H, "< /etc/krb5.conf.heimdal")
  or die "Can not open /etc/krb5.conf.heimdal: $!";

my @krb5_h = <KRB5_H>;

close KRB5_H;

open(KRB5, "> /etc/krb5.conf")
  or die "Can not open /etc/krb5.conf: $!";

print KRB5 "# WARNING: this configuration file was automatically converted from Heimdal to MIT kerberos.\n";
print KRB5 "#          It is possible that this configuration file does not work\n";
print KRB5 "#          Please check the values.\n";

my $loggingSect = 0;

# replace kpasswd_server with admin_server
foreach my $line (@krb5_h) {

    $line =~ s/kpasswd_server/admin_server/;
    $line =~ s/^\s+#/#/;
    
    if($line =~ /^\s*\[logging\]/) {
        $loggingSect = 1;
        print KRB5 $line;
        next;
    }
    if($loggingSect == 1 && $line =~ /^\s*\[/) {
        $loggingSect = 0;
    }
    if($loggingSect == 1 && $line =~ /^\s*kdc\s*=\s*/) {
        $line = "        kdc = FILE:/var/log/krb5/krb5kdc.log\n";
    } 
    if($loggingSect == 1 && $line =~ /^\s*kadmind\s*=\s*/) {
        $line = "        admin_server = FILE:/var/log/krb5/kadmind.log\n";
    }
    if($loggingSect == 1 && $line =~ /^\s*default\s*=\s*/) {
        $line = "        default = SYSLOG:NOTICE:DAEMON\n";
    }
 
    print KRB5 $line;
}

close KRB5;
