#!/bin/sh
#
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is mozilla.org Code.
#
# The Initial Developer of the Original Code is
# Netscape Communications Corporation.
# Portions created by the Initial Developer are Copyright (C) 1998
# the Initial Developer. All Rights Reserved.
#
# Contributor(s): 
#    Wolfgang Rosenauer <wolfgang.rosenauer@suse.de>
#                       <wr@rosenauer.org>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

## 
## Usage:
##
## $ mozilla [args]
##
## This script is meant to run a mozilla program from the mozilla
## rpm installation.
##
## The script will setup all the environment voodoo needed to make
## mozilla work.

cmdname=`basename $0`

##
## Variables
##
MOZ_DIST_BIN="/usr"
MOZ_DIST_LIB="/usr/lib/firefox"
MOZ_APPNAME="firefox"
MOZ_PROFILE=".mozilla/firefox"
MOZ_PROGRAM="$MOZ_DIST_LIB/$MOZ_APPNAME-bin"

mozilla_lib=`file $MOZ_PROGRAM`
LIB=lib
echo $mozilla_lib | grep -q -E 'x86-64|s390x|ppc64' && LIB=lib64

BROWSER_PLUGIN_DIR=/usr/$LIB/browser-plugins
if [ ! -d $BROWSER_PLUGIN_DIR ]; then
  BROWSER_PLUGIN_DIR=/opt/netscape/plugins
fi

# Force use of GTK+ 2.0 for Flash player to get better performance
# (no impact when using mozilla gtk1 build
#
export FLASH_GTK_LIBRARY=libgtk-x11-2.0.so.0

# ignore composite extension (needed for Flash)
export XLIB_SKIP_ARGB_VISUALS=1

# needed for SUN Java under Xorg >= 7.2
export LIBXCB_ALLOW_SLOPPY_LOCK=1

# Pango support
if [ -z "$MOZ_ENABLE_PANGO" -a -z "$MOZ_DISABLE_PANGO" ]; then
  case "${LC_ALL-${LC_CTYPE-${LANG-en_US}}}" in
    bn*|gu*|hi*|ja*|km*|kn*|ml*|mr*|pa*|ta*|te*)  # list of languages which need pango
	;;
    *)
        export MOZ_DISABLE_PANGO=1 # disable by default
        ;;
  esac
fi

##
## Set MOZILLA_FIVE_HOME
##
MOZILLA_FIVE_HOME="$MOZ_DIST_LIB"
export MOZILLA_FIVE_HOME

##
## Set LD_LIBRARY_PATH
##
if [ "$LD_LIBRARY_PATH" ]
then
  LD_LIBRARY_PATH=$MOZ_DIST_LIB/plugins:$MOZ_DIST_LIB:$LD_LIBRARY_PATH
else
  LD_LIBRARY_PATH=$MOZ_DIST_LIB/plugins:$MOZ_DIST_LIB
fi
export LD_LIBRARY_PATH

## Make sure that we set the plugin path for backwards compatibility
## Set MOZ_PLUGIN_PATH to $HOME/.mozilla/plugins if not set
##
if [ -z "$MOZ_PLUGIN_PATH" ]; then
  export MOZ_PLUGIN_PATH=$MOZILLA_FIVE_HOME/plugins:$BROWSER_PLUGIN_DIR
  if [ "$HOME" ] ; then
    export MOZ_PLUGIN_PATH=$HOME/$MOZ_PROFILE/plugins:$MOZ_PLUGIN_PATH
  fi
else
  # make sure that BROWSER_PLUGIN_DIR is in MOZ_PLUGIN_PATH
  echo "$MOZ_PLUGIN_PATH" | grep "$BROWSER_PLUGIN_DIR" 2>&1 >/dev/null
  _retval=$?
  if [ ${_retval} -ne 0 ]; then
    export MOZ_PLUGIN_PATH=$MOZ_PLUGIN_PATH:$BROWSER_PLUGIN_DIR
  fi
fi

moz_pis_startstop_scripts()
{
  MOZ_USER_DIR="$MOZ_PROFILE"
  # MOZ_PIS_ is the name space for "Mozilla Plugable Init Scripts"
  # These variables and there meaning are specified in
  # mozilla/xpfe/bootstrap/init.d/README
  MOZ_PIS_API=2
  MOZ_PIS_MOZBINDIR="$MOZ_DIST_LIB"
  MOZ_PIS_SESSION_PID="$$"
  MOZ_PIS_USER_DIR="${MOZ_USER_DIR}"
  export MOZ_PIS_API MOZ_PIS_MOZBINDIR MOZ_PIS_SESSION_PID MOZ_PIS_USER_DIR
  
  case "${1}" in
    "start")
      for curr_pis in "$MOZ_DIST_LIB/init.d"/S* "${HOME}/${MOZ_USER_DIR}/init.d"/S* ; do
        if [ -x "${curr_pis}" ] ; then
          case "${curr_pis}" in
            *.sh) .  "${curr_pis}"         ;;
            *)       "${curr_pis}" "start" ;;
          esac
        fi
      done
      ;;
    "stop")
      for curr_pis in "${HOME}/${MOZ_USER_DIR}/init.d"/K* "$MOZ_DIST_LIB/init.d"/K* ; do
        if [ -x "${curr_pis}" ] ; then
          case "${curr_pis}" in
            *.sh) . "${curr_pis}"        ;;
            *)      "${curr_pis}" "stop" ;;
          esac
        fi
      done
      ;;
    *)
      echo 1>&2 "$0: Internal error in moz_pis_startstop_scripts."
      exit 1
      ;;
  esac
}

moz_debug=0
script_args=""
pass_arg_count=0
while [ $# -gt $pass_arg_count ]
do
  case "$1" in
    -d | --debugger)
      moz_debugger=$2;
      if [ "${moz_debugger}" != "" ]; then
        shift 2
        moz_debug=1
      else
        echo "-d requires an argument"
        exit 1
      fi
      ;;
    *)
      # Move the unrecognized argument to the end of the list.
      arg="$1"
      shift
      set -- "$@" "$arg"
      pass_arg_count=`expr $pass_arg_count + 1`
      ;;
  esac
done

## Start addon scripts
moz_pis_startstop_scripts "start"

if [ $moz_debug -eq 1 ]; then
  tmpfile=`mktemp /tmp/mozargs.XXXXXX` || { echo "Cannot create temporary file" >&2; exit 1; }
  trap " [ -f \"$tmpfile\" ] && /bin/rm -f -- \"$tmpfile\"" 0 1 2 3 13 15
  echo -e "set args ${1+"$@"}\nrun" > $tmpfile
  echo "$moz_debugger $MOZ_PROGRAM -x $tmpfile"
  $moz_debugger "$MOZ_PROGRAM" -x $tmpfile
else
  if [ -d /proc/asound ]; then
    export LD_PRELOAD=/usr/$LIB/libaoss.so${LD_PRELOAD:+:$LD_PRELOAD}
  fi
  $MOZ_PROGRAM "$@"
fi
exitcode=$?
unset LD_PRELOAD

## Stop addon scripts
moz_pis_startstop_scripts "stop"

exit $exitcode
