#! /bin/bash
#
# Copyright (c) 1996 S.u.S.E. Gmbh Fuerth, Germany.  All rights reserved.
#
# Author: Burchard Steinbild <bs@suse.de>, 1996
#         Martin Scherbaum <maddin@suse.de>, 5/1997         
#         Ruediger Oertel <ro@suse.de>, 7/1998

#
# Variables in /etc/sysconfig/suseconfig used by this script are: 
#   CREATE_PERLLOCAL_POD
#
# This script calls the scripts:
#   /usr/sbin/perllocal.suse which comes from the package perl
#

#
# check if we are started as root
# only one of UID and USER must be set correctly
#
if test "$UID" != 0 -a "$USER" != root; then
    echo "You must be root to start $0."
    exit 1
fi

#
# SuSEconfig sometimes sets the variable CHECK_NEWPACKAGE. If it is set
# to false, we don't have to do anything.
# 
test "$CHECK_NEWPACKAGE" = false && exit 0

test -f /etc/sysconfig/suseconfig || { echo "No /etc/sysconfig/suseconfig found." && exit 1 ; }
. /etc/sysconfig/suseconfig

# this skript only works in a running system.

test -n "$ROOT" && exit 0

perl -e 'exit 0' 2>/dev/null || { echo "Perl not found." && exit 0 ; }

#
# see if we may do any work
#
test -n "$CREATE_PERLLOCAL_POD" -a "$CREATE_PERLLOCAL_POD" = "yes" \
	|| { echo "disabled in sysconfig/suseconfig" && exit 1 ; }
	
#
# check if anything to add
#
PERLLOCAL_PATH=`perl -V:installarchlib | sed -e "s/.*='\(.*\)'.*/\1/"`

NEEDED="false"

if test -d /var/adm/perl-modules ; then 
	if test /var/adm/perl-modules -nt $PERLLOCAL_PATH/perllocal.pod ; then
		NEEDED="true"
	elif test ! -f $PERLLOCAL_PATH/perllocal.pod ; then
		NEEDED="true"
	fi
fi

#
# now call the working script
#
if "$NEEDED" = "true" ; then
	if test -x /usr/lib/perl5/perllocal.SuSE ; then
		/usr/lib/perl5/perllocal.SuSE
		pod2man $PERLLOCAL_PATH/perllocal.pod | gzip > /usr/share/man/man3/perllocal.3pm.gz
	else
		echo "SuSEconfig.perl: /usr/lib/perl5/perllocal.SuSE not found!"
	fi
fi

#
# end of file SuSEconfig.perl
#
