#!/bin/bash
# $Id: make_zimage_chrp.sh 1024 2007-09-14 08:12:50Z olh $
set -e
# set -x

obj_dir=/lib/lilo

vmlinux=
initrd=
tmp=
outputfile=
no_addnote=false
until [ "$#" = "0" ] ; do
	case "$1" in
		--help|-h|--version)
		echo "create a 'zImage' for new pSeries"
		echo "Usage: ${0##*/} --vmlinux <ELF binary> --initrd <ramdisk.image.gz> --output <zImage> [--tmp <tempdir>] [--no-addnote]"
		echo "additional options: [--objdir <dir>]"
		exit 1
		;;
		--no-addnote)
		no_addnote=true
		shift
		;;
		--vmlinux)
		shift
		if [ "$#" = "0" -o "$1" = ""  ] ; then
			echo "option --vmlinux requires a filename"
			exit 1
		fi
		vmlinux=$1
		shift
		;;
		--initrd)
		shift
		if [ "$#" = "0"  -o "$1" = "" ] ; then
			echo "option --initrd requires a filename"
			exit 1
		fi
		initrd=$1
		shift
		;;
		--output)
		shift
		if [ "$#" = "0" -o "$1" = "" ] ; then
			echo "option --output requires a filename"
			exit 1
		fi
		output=$1
		shift
		;;
		--objdir)
		shift
		if [ "$#" = "0" -o "$1" = ""  ] ; then
			echo "option --objdir requires a diretory"
			exit 1
		fi
		obj_dir=$1
		shift
		;;
		--tmp)
		shift
		if [ "$#" = "0" -o "$1" = ""  ] ; then
			echo "option --tmp requires a diretory"
			exit 1
		fi
		tmp=$1
		shift
		;;
		*)
		echo "ERROR: unknown option $1"
		exec $0 --help
		exit 1
	esac
done
if [ -z "$vmlinux" ] ; then
	echo "ERROR: no input file"
	exec $0 --help
	exit 1
fi
if [ -z "$output" ] ; then
	echo "ERROR: no output file"
	exec $0 --help
	exit 1
fi
if [ -z "$tmp" ] ; then
	tmp=`mktemp -d ${TMPDIR:-/tmp}/mkzimage_chrp.$$.XXXXXX`
else
	tmp=`mktemp -d $tmp/mkzimage_chrp.$$.XXXXXX`
fi
#
strip -o $tmp/vmlinux $vmlinux
gzip -c9 $tmp/vmlinux > $tmp/vmlinux.gz
#
#
strings $tmp/vmlinux | grep -E 'Linux version .* .gcc' > $tmp/uts_string.txt
echo -ne "\000" >> $tmp/uts_string.txt
cp $obj_dir/common/empty.o $tmp/empty.o
objcopy $tmp/empty.o \
	--add-section=.uts_string=$tmp/uts_string.txt \
	--set-section-flags=.uts_string=contents,alloc,load,readonly,data
#
objcopy $tmp/empty.o \
	--add-section=.kernel:vmlinux.strip=$tmp/vmlinux.gz \
	--set-section-flags=.kernel:vmlinux.strip=contents,alloc,load,readonly,data
#
if [ ! -z "$initrd" ] ; then
objcopy $tmp/empty.o \
	--add-section=.kernel:initrd=$initrd \
	--set-section-flags=.kernel:initrd=contents,alloc,load,readonly,data
fi
#
rm -f $tmp/output
#
link_addr=`printf '0x%08x\n' $(( ( 4 * 64 * 1024 )  ))`
ld \
	-m elf32ppc \
	-Ttext $link_addr \
	-e _start \
	-T $obj_dir/chrp/ld.script \
	-o $tmp/output \
	$obj_dir/chrp/crt0.o \
	$tmp/empty.o \
	$obj_dir/chrp/chrp.a \
	$obj_dir/common/common.a \
	$obj_dir/chrp/prom.a \
	$obj_dir/common/zlib.a
#
if [ "$no_addnote" = "false" ] ; then
echo add note section for RS6K
$obj_dir/utils/addnote $tmp/output
fi
#
rm -f "$output"
cp "$tmp/output" "$output"
rm -rf $tmp

