require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_IA64_GCC_INTRIN_H)) {
    eval 'sub _ASM_IA64_GCC_INTRIN_H {1;}' unless defined(&_ASM_IA64_GCC_INTRIN_H);
    eval 'sub ASM_SUPPORTED {1;}' unless defined(&ASM_SUPPORTED);
    eval 'sub ia64_barrier () {
        eval q( &asm  &volatile (\\"\\":::\\"memory\\"));
    }' unless defined(&ia64_barrier);
    eval 'sub ia64_stop () {
        eval q( &asm  &volatile (\\";;\\"::));
    }' unless defined(&ia64_stop);
    eval 'sub ia64_invala_gr {
        my($regnum) = @_;
	    eval q( &asm  &volatile (\\"invala.e r%0\\" :: \\"i\\"($regnum)));
    }' unless defined(&ia64_invala_gr);
    eval 'sub ia64_invala_fr {
        my($regnum) = @_;
	    eval q( &asm  &volatile (\\"invala.e f%0\\" :: \\"i\\"($regnum)));
    }' unless defined(&ia64_invala_fr);
    eval 'sub ia64_setreg {
        my($regnum, $val) = @_;
	    eval q(({  &switch ($regnum) {  &case  &_IA64_REG_PSR_L:  &asm  &volatile (\\"mov psr.l=%0\\" :: \\"r\\"($val) : \\"memory\\");  &break;  &case  &_IA64_REG_AR_KR0 ...  &_IA64_REG_AR_EC:  &asm  &volatile (\\"mov ar%0=%1\\" :: \\"i\\" ($regnum -  &_IA64_REG_AR_KR0), \\"r\\"($val): \\"memory\\");  &break;  &case  &_IA64_REG_CR_DCR ...  &_IA64_REG_CR_LRR1:  &asm  &volatile (\\"mov cr%0=%1\\" :: \\"i\\" ($regnum -  &_IA64_REG_CR_DCR), \\"r\\"($val): \\"memory\\" );  &break;  &case  &_IA64_REG_SP:  &asm  &volatile (\\"mov r12=%0\\" :: \\"r\\"($val): \\"memory\\");  &break;  &case  &_IA64_REG_GP:  &asm  &volatile (\\"mov gp=%0\\" :: \\"r\\"($val) : \\"memory\\");  &break;  &default:  &ia64_bad_param_for_setreg();  &break; } }));
    }' unless defined(&ia64_setreg);
    eval 'sub ia64_getreg {
        my($regnum) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &switch ($regnum) {  &case  &_IA64_REG_GP:  &asm  &volatile (\\"mov %0=gp\\" : \\"=r\\"( &ia64_intri_res));  &break;  &case  &_IA64_REG_IP:  &asm  &volatile (\\"mov %0=ip\\" : \\"=r\\"( &ia64_intri_res));  &break;  &case  &_IA64_REG_PSR:  &asm  &volatile (\\"mov %0=psr\\" : \\"=r\\"( &ia64_intri_res));  &break;  &case  &_IA64_REG_TP:  &ia64_intri_res =  &ia64_r13;  &break;  &case  &_IA64_REG_AR_KR0 ...  &_IA64_REG_AR_EC:  &asm  &volatile (\\"mov %0=ar%1\\" : \\"=r\\" ( &ia64_intri_res) : \\"i\\"($regnum -  &_IA64_REG_AR_KR0));  &break;  &case  &_IA64_REG_CR_DCR ...  &_IA64_REG_CR_LRR1:  &asm  &volatile (\\"mov %0=cr%1\\" : \\"=r\\" ( &ia64_intri_res) : \\"i\\" ($regnum -  &_IA64_REG_CR_DCR));  &break;  &case  &_IA64_REG_SP:  &asm  &volatile (\\"mov %0=sp\\" : \\"=r\\" ( &ia64_intri_res));  &break;  &default:  &ia64_bad_param_for_getreg();  &break; }  &ia64_intri_res; }));
    }' unless defined(&ia64_getreg);
    eval 'sub ia64_hint_pause {0;}' unless defined(&ia64_hint_pause);
    eval 'sub ia64_hint {
        my($mode) = @_;
	    eval q(({  &switch ($mode) {  &case  &ia64_hint_pause:  &asm  &volatile (\\"hint @pause\\" ::: \\"memory\\");  &break; } }));
    }' unless defined(&ia64_hint);
    eval 'sub ia64_mux1_brcst {0;}' unless defined(&ia64_mux1_brcst);
    eval 'sub ia64_mux1_mix {8;}' unless defined(&ia64_mux1_mix);
    eval 'sub ia64_mux1_shuf {9;}' unless defined(&ia64_mux1_shuf);
    eval 'sub ia64_mux1_alt {10;}' unless defined(&ia64_mux1_alt);
    eval 'sub ia64_mux1_rev {11;}' unless defined(&ia64_mux1_rev);
    eval 'sub ia64_mux1 {
        my($x, $mode) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &switch ($mode) {  &case  &ia64_mux1_brcst:  &asm (\\"mux1 %0=%1,@brcst\\" : \\"=r\\" ( &ia64_intri_res) : \\"r\\" ($x));  &break;  &case  &ia64_mux1_mix:  &asm (\\"mux1 %0=%1,@mix\\" : \\"=r\\" ( &ia64_intri_res) : \\"r\\" ($x));  &break;  &case  &ia64_mux1_shuf:  &asm (\\"mux1 %0=%1,@shuf\\" : \\"=r\\" ( &ia64_intri_res) : \\"r\\" ($x));  &break;  &case  &ia64_mux1_alt:  &asm (\\"mux1 %0=%1,@alt\\" : \\"=r\\" ( &ia64_intri_res) : \\"r\\" ($x));  &break;  &case  &ia64_mux1_rev:  &asm (\\"mux1 %0=%1,@rev\\" : \\"=r\\" ( &ia64_intri_res) : \\"r\\" ($x));  &break; }  &ia64_intri_res; }));
    }' unless defined(&ia64_mux1);
    if((defined(&__GNUC__) ? &__GNUC__ : 0) >= 4|| ((defined(&__GNUC__) ? &__GNUC__ : 0) == 3 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 4)) {
	eval 'sub ia64_popcnt {
	    my($x) = @_;
    	    eval q( &__builtin_popcountl($x));
	}' unless defined(&ia64_popcnt);
    } else {
	eval 'sub ia64_popcnt {
	    my($x) = @_;
    	    eval q(({  &__u64  &ia64_intri_res;  &asm (\\"popcnt %0=%1\\" : \\"=r\\" ( &ia64_intri_res) : \\"r\\" ($x));  &ia64_intri_res; }));
	}' unless defined(&ia64_popcnt);
    }
    eval 'sub ia64_getf_exp {
        my($x) = @_;
	    eval q(({ \'long ia64_intri_res\';  &asm (\\"getf.exp %0=%1\\" : \\"=r\\"( &ia64_intri_res) : \\"f\\"($x));  &ia64_intri_res; }));
    }' unless defined(&ia64_getf_exp);
    eval 'sub ia64_shrp {
        my($a, $b, $count) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm (\\"shrp %0=%1,%2,%3\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\"($a), \\"r\\"($b), \\"i\\"($count));  &ia64_intri_res; }));
    }' unless defined(&ia64_shrp);
    eval 'sub ia64_ldfs {
        my($regnum, $x) = @_;
	    eval q(({  &register \'double\'  &__f__  &asm (\\"f\\"$regnum);  &asm  &volatile (\\"ldfs %0=[%1]\\" :\\"=f\\"( &__f__): \\"r\\"($x)); }));
    }' unless defined(&ia64_ldfs);
    eval 'sub ia64_ldfd {
        my($regnum, $x) = @_;
	    eval q(({  &register \'double\'  &__f__  &asm (\\"f\\"$regnum);  &asm  &volatile (\\"ldfd %0=[%1]\\" :\\"=f\\"( &__f__): \\"r\\"($x)); }));
    }' unless defined(&ia64_ldfd);
    eval 'sub ia64_ldfe {
        my($regnum, $x) = @_;
	    eval q(({  &register \'double\'  &__f__  &asm (\\"f\\"$regnum);  &asm  &volatile (\\"ldfe %0=[%1]\\" :\\"=f\\"( &__f__): \\"r\\"($x)); }));
    }' unless defined(&ia64_ldfe);
    eval 'sub ia64_ldf8 {
        my($regnum, $x) = @_;
	    eval q(({  &register \'double\'  &__f__  &asm (\\"f\\"$regnum);  &asm  &volatile (\\"ldf8 %0=[%1]\\" :\\"=f\\"( &__f__): \\"r\\"($x)); }));
    }' unless defined(&ia64_ldf8);
    eval 'sub ia64_ldf_fill {
        my($regnum, $x) = @_;
	    eval q(({  &register \'double\'  &__f__  &asm (\\"f\\"$regnum);  &asm  &volatile (\\"ldf.fill %0=[%1]\\" :\\"=f\\"( &__f__): \\"r\\"($x)); }));
    }' unless defined(&ia64_ldf_fill);
    eval 'sub ia64_stfs {
        my($x, $regnum) = @_;
	    eval q(({  &register \'double\'  &__f__  &asm (\\"f\\"$regnum);  &asm  &volatile (\\"stfs [%0]=%1\\" :: \\"r\\"($x), \\"f\\"( &__f__) : \\"memory\\"); }));
    }' unless defined(&ia64_stfs);
    eval 'sub ia64_stfd {
        my($x, $regnum) = @_;
	    eval q(({  &register \'double\'  &__f__  &asm (\\"f\\"$regnum);  &asm  &volatile (\\"stfd [%0]=%1\\" :: \\"r\\"($x), \\"f\\"( &__f__) : \\"memory\\"); }));
    }' unless defined(&ia64_stfd);
    eval 'sub ia64_stfe {
        my($x, $regnum) = @_;
	    eval q(({  &register \'double\'  &__f__  &asm (\\"f\\"$regnum);  &asm  &volatile (\\"stfe [%0]=%1\\" :: \\"r\\"($x), \\"f\\"( &__f__) : \\"memory\\"); }));
    }' unless defined(&ia64_stfe);
    eval 'sub ia64_stf8 {
        my($x, $regnum) = @_;
	    eval q(({  &register \'double\'  &__f__  &asm (\\"f\\"$regnum);  &asm  &volatile (\\"stf8 [%0]=%1\\" :: \\"r\\"($x), \\"f\\"( &__f__) : \\"memory\\"); }));
    }' unless defined(&ia64_stf8);
    eval 'sub ia64_stf_spill {
        my($x, $regnum) = @_;
	    eval q(({  &register \'double\'  &__f__  &asm (\\"f\\"$regnum);  &asm  &volatile (\\"stf.spill [%0]=%1\\" :: \\"r\\"($x), \\"f\\"( &__f__) : \\"memory\\"); }));
    }' unless defined(&ia64_stf_spill);
    eval 'sub ia64_fetchadd4_acq {
        my($p, $inc) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"fetchadd4.acq %0=[%1],%2\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\"($p), \\"i\\" ($inc) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_fetchadd4_acq);
    eval 'sub ia64_fetchadd4_rel {
        my($p, $inc) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"fetchadd4.rel %0=[%1],%2\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\"($p), \\"i\\" ($inc) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_fetchadd4_rel);
    eval 'sub ia64_fetchadd8_acq {
        my($p, $inc) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"fetchadd8.acq %0=[%1],%2\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\"($p), \\"i\\" ($inc) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_fetchadd8_acq);
    eval 'sub ia64_fetchadd8_rel {
        my($p, $inc) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"fetchadd8.rel %0=[%1],%2\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\"($p), \\"i\\" ($inc) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_fetchadd8_rel);
    eval 'sub ia64_xchg1 {
        my($ptr,$x) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"xchg1 %0=[%1],%2\\" : \\"=r\\" ( &ia64_intri_res) : \\"r\\" ($ptr), \\"r\\" ($x) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_xchg1);
    eval 'sub ia64_xchg2 {
        my($ptr,$x) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"xchg2 %0=[%1],%2\\" : \\"=r\\" ( &ia64_intri_res) : \\"r\\" ($ptr), \\"r\\" ($x) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_xchg2);
    eval 'sub ia64_xchg4 {
        my($ptr,$x) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"xchg4 %0=[%1],%2\\" : \\"=r\\" ( &ia64_intri_res) : \\"r\\" ($ptr), \\"r\\" ($x) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_xchg4);
    eval 'sub ia64_xchg8 {
        my($ptr,$x) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"xchg8 %0=[%1],%2\\" : \\"=r\\" ( &ia64_intri_res) : \\"r\\" ($ptr), \\"r\\" ($x) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_xchg8);
    eval 'sub ia64_cmpxchg1_acq {
        my($ptr, $new, $old) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov ar.ccv=%0;;\\" :: \\"rO\\"($old));  &asm  &volatile (\\"cmpxchg1.acq %0=[%1],%2,ar.ccv\\": \\"=r\\"( &ia64_intri_res) : \\"r\\"($ptr), \\"r\\"($new) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_cmpxchg1_acq);
    eval 'sub ia64_cmpxchg1_rel {
        my($ptr, $new, $old) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov ar.ccv=%0;;\\" :: \\"rO\\"($old));  &asm  &volatile (\\"cmpxchg1.rel %0=[%1],%2,ar.ccv\\": \\"=r\\"( &ia64_intri_res) : \\"r\\"($ptr), \\"r\\"($new) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_cmpxchg1_rel);
    eval 'sub ia64_cmpxchg2_acq {
        my($ptr, $new, $old) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov ar.ccv=%0;;\\" :: \\"rO\\"($old));  &asm  &volatile (\\"cmpxchg2.acq %0=[%1],%2,ar.ccv\\": \\"=r\\"( &ia64_intri_res) : \\"r\\"($ptr), \\"r\\"($new) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_cmpxchg2_acq);
    eval 'sub ia64_cmpxchg2_rel {
        my($ptr, $new, $old) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov ar.ccv=%0;;\\" :: \\"rO\\"($old));  &asm  &volatile (\\"cmpxchg2.rel %0=[%1],%2,ar.ccv\\": \\"=r\\"( &ia64_intri_res) : \\"r\\"($ptr), \\"r\\"($new) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_cmpxchg2_rel);
    eval 'sub ia64_cmpxchg4_acq {
        my($ptr, $new, $old) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov ar.ccv=%0;;\\" :: \\"rO\\"($old));  &asm  &volatile (\\"cmpxchg4.acq %0=[%1],%2,ar.ccv\\": \\"=r\\"( &ia64_intri_res) : \\"r\\"($ptr), \\"r\\"($new) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_cmpxchg4_acq);
    eval 'sub ia64_cmpxchg4_rel {
        my($ptr, $new, $old) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov ar.ccv=%0;;\\" :: \\"rO\\"($old));  &asm  &volatile (\\"cmpxchg4.rel %0=[%1],%2,ar.ccv\\": \\"=r\\"( &ia64_intri_res) : \\"r\\"($ptr), \\"r\\"($new) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_cmpxchg4_rel);
    eval 'sub ia64_cmpxchg8_acq {
        my($ptr, $new, $old) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov ar.ccv=%0;;\\" :: \\"rO\\"($old));  &asm  &volatile (\\"cmpxchg8.acq %0=[%1],%2,ar.ccv\\": \\"=r\\"( &ia64_intri_res) : \\"r\\"($ptr), \\"r\\"($new) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_cmpxchg8_acq);
    eval 'sub ia64_cmpxchg8_rel {
        my($ptr, $new, $old) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov ar.ccv=%0;;\\" :: \\"rO\\"($old));  &asm  &volatile (\\"cmpxchg8.rel %0=[%1],%2,ar.ccv\\": \\"=r\\"( &ia64_intri_res) : \\"r\\"($ptr), \\"r\\"($new) : \\"memory\\");  &ia64_intri_res; }));
    }' unless defined(&ia64_cmpxchg8_rel);
    eval 'sub ia64_mf () {
        eval q( &asm  &volatile (\\"mf\\" ::: \\"memory\\"));
    }' unless defined(&ia64_mf);
    eval 'sub ia64_mfa () {
        eval q( &asm  &volatile (\\"mf.a\\" ::: \\"memory\\"));
    }' unless defined(&ia64_mfa);
    eval 'sub ia64_invala () {
        eval q( &asm  &volatile (\\"invala\\" ::: \\"memory\\"));
    }' unless defined(&ia64_invala);
    eval 'sub ia64_thash {
        my($addr) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"thash %0=%1\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\" ($addr));  &ia64_intri_res; }));
    }' unless defined(&ia64_thash);
    eval 'sub ia64_srlz_i () {
        eval q( &asm  &volatile (\\";; srlz.i ;;\\" ::: \\"memory\\"));
    }' unless defined(&ia64_srlz_i);
    eval 'sub ia64_srlz_d () {
        eval q( &asm  &volatile (\\";; srlz.d\\" ::: \\"memory\\"););
    }' unless defined(&ia64_srlz_d);
    if(defined(&HAVE_SERIALIZE_DIRECTIVE)) {
	eval 'sub ia64_dv_serialize_data () {
	    eval q( &asm  &volatile (\\".serialize.data\\"););
	}' unless defined(&ia64_dv_serialize_data);
	eval 'sub ia64_dv_serialize_instruction () {
	    eval q( &asm  &volatile (\\".serialize.instruction\\"););
	}' unless defined(&ia64_dv_serialize_instruction);
    } else {
	eval 'sub ia64_dv_serialize_data () {
	    eval q();
	}' unless defined(&ia64_dv_serialize_data);
	eval 'sub ia64_dv_serialize_instruction () {
	    eval q();
	}' unless defined(&ia64_dv_serialize_instruction);
    }
    eval 'sub ia64_nop {
        my($x) = @_;
	    eval q( &asm  &volatile (\\"nop %0\\"::\\"i\\"($x)););
    }' unless defined(&ia64_nop);
    eval 'sub ia64_itci {
        my($addr) = @_;
	    eval q( &asm  &volatile (\\"itc.i %0;;\\" :: \\"r\\"($addr) : \\"memory\\"));
    }' unless defined(&ia64_itci);
    eval 'sub ia64_itcd {
        my($addr) = @_;
	    eval q( &asm  &volatile (\\"itc.d %0;;\\" :: \\"r\\"($addr) : \\"memory\\"));
    }' unless defined(&ia64_itcd);
    eval 'sub ia64_itri {
        my($trnum, $addr) = @_;
	    eval q( &asm  &volatile (\\"itr.i itr[%0]=%1\\" :: \\"r\\"($trnum), \\"r\\"($addr) : \\"memory\\"));
    }' unless defined(&ia64_itri);
    eval 'sub ia64_itrd {
        my($trnum, $addr) = @_;
	    eval q( &asm  &volatile (\\"itr.d dtr[%0]=%1\\" :: \\"r\\"($trnum), \\"r\\"($addr) : \\"memory\\"));
    }' unless defined(&ia64_itrd);
    eval 'sub ia64_tpa {
        my($addr) = @_;
	    eval q(({  &__u64  &ia64_pa;  &asm  &volatile (\\"tpa %0 = %1\\" : \\"=r\\"( &ia64_pa) : \\"r\\"($addr) : \\"memory\\");  &ia64_pa; }));
    }' unless defined(&ia64_tpa);
    eval 'sub __ia64_set_dbr {
        my($index, $val) = @_;
	    eval q( &asm  &volatile (\\"mov dbr[%0]=%1\\" :: \\"r\\"($index), \\"r\\"($val) : \\"memory\\"));
    }' unless defined(&__ia64_set_dbr);
    eval 'sub ia64_set_ibr {
        my($index, $val) = @_;
	    eval q( &asm  &volatile (\\"mov ibr[%0]=%1\\" :: \\"r\\"($index), \\"r\\"($val) : \\"memory\\"));
    }' unless defined(&ia64_set_ibr);
    eval 'sub ia64_set_pkr {
        my($index, $val) = @_;
	    eval q( &asm  &volatile (\\"mov pkr[%0]=%1\\" :: \\"r\\"($index), \\"r\\"($val) : \\"memory\\"));
    }' unless defined(&ia64_set_pkr);
    eval 'sub ia64_set_pmc {
        my($index, $val) = @_;
	    eval q( &asm  &volatile (\\"mov pmc[%0]=%1\\" :: \\"r\\"($index), \\"r\\"($val) : \\"memory\\"));
    }' unless defined(&ia64_set_pmc);
    eval 'sub ia64_set_pmd {
        my($index, $val) = @_;
	    eval q( &asm  &volatile (\\"mov pmd[%0]=%1\\" :: \\"r\\"($index), \\"r\\"($val) : \\"memory\\"));
    }' unless defined(&ia64_set_pmd);
    eval 'sub ia64_set_rr {
        my($index, $val) = @_;
	    eval q( &asm  &volatile (\\"mov rr[%0]=%1\\" :: \\"r\\"($index), \\"r\\"($val) : \\"memory\\"););
    }' unless defined(&ia64_set_rr);
    eval 'sub ia64_get_cpuid {
        my($index) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov %0=cpuid[%r1]\\" : \\"=r\\"( &ia64_intri_res) : \\"rO\\"($index));  &ia64_intri_res; }));
    }' unless defined(&ia64_get_cpuid);
    eval 'sub __ia64_get_dbr {
        my($index) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov %0=dbr[%1]\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\"($index));  &ia64_intri_res; }));
    }' unless defined(&__ia64_get_dbr);
    eval 'sub ia64_get_ibr {
        my($index) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov %0=ibr[%1]\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\"($index));  &ia64_intri_res; }));
    }' unless defined(&ia64_get_ibr);
    eval 'sub ia64_get_pkr {
        my($index) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov %0=pkr[%1]\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\"($index));  &ia64_intri_res; }));
    }' unless defined(&ia64_get_pkr);
    eval 'sub ia64_get_pmc {
        my($index) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov %0=pmc[%1]\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\"($index));  &ia64_intri_res; }));
    }' unless defined(&ia64_get_pmc);
    eval 'sub ia64_get_pmd {
        my($index) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov %0=pmd[%1]\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\"($index));  &ia64_intri_res; }));
    }' unless defined(&ia64_get_pmd);
    eval 'sub ia64_get_rr {
        my($index) = @_;
	    eval q(({  &__u64  &ia64_intri_res;  &asm  &volatile (\\"mov %0=rr[%1]\\" : \\"=r\\"( &ia64_intri_res) : \\"r\\" ($index));  &ia64_intri_res; }));
    }' unless defined(&ia64_get_rr);
    eval 'sub ia64_fc {
        my($addr) = @_;
	    eval q( &asm  &volatile (\\"fc %0\\" :: \\"r\\"($addr) : \\"memory\\"));
    }' unless defined(&ia64_fc);
    eval 'sub ia64_sync_i () {
        eval q( &asm  &volatile (\\";; sync.i\\" ::: \\"memory\\"));
    }' unless defined(&ia64_sync_i);
    eval 'sub ia64_ssm {
        my($mask) = @_;
	    eval q( &asm  &volatile (\\"ssm %0\\":: \\"i\\"(($mask)) : \\"memory\\"));
    }' unless defined(&ia64_ssm);
    eval 'sub ia64_rsm {
        my($mask) = @_;
	    eval q( &asm  &volatile (\\"rsm %0\\":: \\"i\\"(($mask)) : \\"memory\\"));
    }' unless defined(&ia64_rsm);
    eval 'sub ia64_sum {
        my($mask) = @_;
	    eval q( &asm  &volatile (\\"sum %0\\":: \\"i\\"(($mask)) : \\"memory\\"));
    }' unless defined(&ia64_sum);
    eval 'sub ia64_rum {
        my($mask) = @_;
	    eval q( &asm  &volatile (\\"rum %0\\":: \\"i\\"(($mask)) : \\"memory\\"));
    }' unless defined(&ia64_rum);
    eval 'sub ia64_ptce {
        my($addr) = @_;
	    eval q( &asm  &volatile (\\"ptc.e %0\\" :: \\"r\\"($addr)));
    }' unless defined(&ia64_ptce);
    eval 'sub ia64_ptcga {
        my($addr, $size) = @_;
	    eval q( &do {  &asm  &volatile (\\"ptc.ga %0,%1\\" :: \\"r\\"($addr), \\"r\\"($size) : \\"memory\\");  &ia64_dv_serialize_data(); }  &while (0));
    }' unless defined(&ia64_ptcga);
    eval 'sub ia64_ptcl {
        my($addr, $size) = @_;
	    eval q( &do {  &asm  &volatile (\\"ptc.l %0,%1\\" :: \\"r\\"($addr), \\"r\\"($size) : \\"memory\\");  &ia64_dv_serialize_data(); }  &while (0));
    }' unless defined(&ia64_ptcl);
    eval 'sub ia64_ptri {
        my($addr, $size) = @_;
	    eval q( &asm  &volatile (\\"ptr.i %0,%1\\" :: \\"r\\"($addr), \\"r\\"($size) : \\"memory\\"));
    }' unless defined(&ia64_ptri);
    eval 'sub ia64_ptrd {
        my($addr, $size) = @_;
	    eval q( &asm  &volatile (\\"ptr.d %0,%1\\" :: \\"r\\"($addr), \\"r\\"($size) : \\"memory\\"));
    }' unless defined(&ia64_ptrd);
    eval 'sub ia64_lfhint_none {0;}' unless defined(&ia64_lfhint_none);
    eval 'sub ia64_lfhint_nt1 {1;}' unless defined(&ia64_lfhint_nt1);
    eval 'sub ia64_lfhint_nt2 {2;}' unless defined(&ia64_lfhint_nt2);
    eval 'sub ia64_lfhint_nta {3;}' unless defined(&ia64_lfhint_nta);
    eval 'sub ia64_lfetch {
        my($lfhint, $y) = @_;
	    eval q(({  &switch ($lfhint) {  &case  &ia64_lfhint_none:  &asm  &volatile (\\"lfetch [%0]\\" : : \\"r\\"($y));  &break;  &case  &ia64_lfhint_nt1:  &asm  &volatile (\\"lfetch.nt1 [%0]\\" : : \\"r\\"($y));  &break;  &case  &ia64_lfhint_nt2:  &asm  &volatile (\\"lfetch.nt2 [%0]\\" : : \\"r\\"($y));  &break;  &case  &ia64_lfhint_nta:  &asm  &volatile (\\"lfetch.nta [%0]\\" : : \\"r\\"($y));  &break; } }));
    }' unless defined(&ia64_lfetch);
    eval 'sub ia64_lfetch_excl {
        my($lfhint, $y) = @_;
	    eval q(({  &switch ($lfhint) {  &case  &ia64_lfhint_none:  &asm  &volatile (\\"lfetch.excl [%0]\\" :: \\"r\\"($y));  &break;  &case  &ia64_lfhint_nt1:  &asm  &volatile (\\"lfetch.excl.nt1 [%0]\\" :: \\"r\\"($y));  &break;  &case  &ia64_lfhint_nt2:  &asm  &volatile (\\"lfetch.excl.nt2 [%0]\\" :: \\"r\\"($y));  &break;  &case  &ia64_lfhint_nta:  &asm  &volatile (\\"lfetch.excl.nta [%0]\\" :: \\"r\\"($y));  &break; } }));
    }' unless defined(&ia64_lfetch_excl);
    eval 'sub ia64_lfetch_fault {
        my($lfhint, $y) = @_;
	    eval q(({  &switch ($lfhint) {  &case  &ia64_lfhint_none:  &asm  &volatile (\\"lfetch.fault [%0]\\" : : \\"r\\"($y));  &break;  &case  &ia64_lfhint_nt1:  &asm  &volatile (\\"lfetch.fault.nt1 [%0]\\" : : \\"r\\"($y));  &break;  &case  &ia64_lfhint_nt2:  &asm  &volatile (\\"lfetch.fault.nt2 [%0]\\" : : \\"r\\"($y));  &break;  &case  &ia64_lfhint_nta:  &asm  &volatile (\\"lfetch.fault.nta [%0]\\" : : \\"r\\"($y));  &break; } }));
    }' unless defined(&ia64_lfetch_fault);
    eval 'sub ia64_lfetch_fault_excl {
        my($lfhint, $y) = @_;
	    eval q(({  &switch ($lfhint) {  &case  &ia64_lfhint_none:  &asm  &volatile (\\"lfetch.fault.excl [%0]\\" :: \\"r\\"($y));  &break;  &case  &ia64_lfhint_nt1:  &asm  &volatile (\\"lfetch.fault.excl.nt1 [%0]\\" :: \\"r\\"($y));  &break;  &case  &ia64_lfhint_nt2:  &asm  &volatile (\\"lfetch.fault.excl.nt2 [%0]\\" :: \\"r\\"($y));  &break;  &case  &ia64_lfhint_nta:  &asm  &volatile (\\"lfetch.fault.excl.nta [%0]\\" :: \\"r\\"($y));  &break; } }));
    }' unless defined(&ia64_lfetch_fault_excl);
    eval 'sub ia64_intrin_local_irq_restore {
        my($x) = @_;
	    eval q( &do {  &asm  &volatile (\\";;   cmp.ne p6,p7=%0,r0;;\\" \\"(p6) ssm psr.i;\\" \\"(p7) rsm psr.i;;\\" \\"(p6) srlz.d\\" :: \\"r\\"(($x)) : \\"p6\\", \\"p7\\", \\"memory\\"); }  &while (0));
    }' unless defined(&ia64_intrin_local_irq_restore);
}
1;
