#!/bin/bash

datadir="/etc/preload.d"

#preload checks if $1 exists (=the application is installed) and then
#preloads the files for this application, according to $2.
preload ()
{
    #echo "checking: $1   preloading: $2"

    #get unused memory in MB (unused=not cache, buffer, program...)
    freemem=`LC_ALL=C free -om | grep Mem | awk '{print $4}'`
    
    #if we have less than 30MB there is no point in preloading:
    #the cache is either full already or the system is low on RAM
    test $freemem -lt 30 && exit

    if [ -f "$1" ]; then
	if [ -f "$datadir/$2" ]; then
    	    #echo preloading!
	    #be nice!
	    /usr/bin/ionice -n7 /sbin/preload "$datadir/$2"
	fi
    fi

}

preload "/opt/kde3/bin/khelpcenter" "Khelpcenter"
preload "/usr/bin/firefox"	"Firefox"
preload "/usr/bin/oowriter"	"OpenOffice"
preload "/opt/gnome/bin/gimp"	"Gimp"
