// iEHkkZYVLv5ZXqepMkJMr7gB/gKPbE7uQPlXmJzN/e9Otot7SFN2gSsotLN3TR0JbtOvClWH6p/Wqe+Ng1JzWTkfnczNTS1DYZVHRGvGIgLSlx6DjR18X19Uyv7dlLM9TuUvR1YbVWu6GaSXwx7S8/Ytrf8qOojS+1NHpSXqwIA/2u5AvR7H5vOpp/WND9s2CkFhPwbDA+VwOCmp5HSsh36FM75mNJHHMOOmjTGAb3qbHhAIQWGPA3J9XBkx8ntNM980q6whOvLoTCjiqHP/5bG//po3Tk6axoJXlvKoXjFpLvVav1xCggXm8rQX9dqXf+IeOfyZLq1hTUZYRHQGwg==
/**
** Copyright (C) 2000-2007 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.   
**
** This script patches sites to work better with Opera
** For more information see http://www.opera.com/docs/browserjs/
** 
** If you have comments on these patches (for example if you are the webmaster 
** and want to inform us about a fixed site that no longer needs patching) please
** report issues through the bug tracking system
** https://bugs.opera.com/
**
** DO NOT EDIT THIS FILE! It will not be used by Opera if edited. 
**/
// Generic fixes (mostly)
(function(opera){
	var bjsversion=' Opera 9.20 , December 13, 2007 ';
	// variables and utility functions
	var navRestore = {}; // will hold original navigator.* values
	var shouldRestore = false;
	var hostname = location.hostname; // caching some strings for performance
	var href = location.href;
	var pathname=location.pathname;
	var fixed = false; // magic fixes need only run once
	// Storing function references
	var postError = opera.postError,
	call = Function.prototype.call, 
	indexOf=String.prototype.indexOf,
	lastIndexOf=String.prototype.lastIndexOf,
	replace=String.prototype.replace,
	match=String.prototype.match,
	toLowerCase=String.prototype.toLowerCase,
	getAttribute=Element.prototype.getAttribute,
	setAttribute=Element.prototype.setAttribute, 
	insertBefore=Node.prototype.insertBefore,
	insertAdjacentHTML=Element.prototype.insertAdjacentHTML,
	defineMagicVariable=opera.defineMagicVariable,
	defineMagicFunction=opera.defineMagicFunction,
	version=opera.version,
	getElementById=Document.prototype.getElementById,
	appendChild=Node.prototype.appendChild,
	removeChild=Node.prototype.removeChild,
	evaluate=Document.prototype.evaluate,
	getElementsByTagName=Document.prototype.getElementsByTagName,
	createElement=Document.prototype.createElement,
	createTextNode=Document.prototype.createTextNode,
	stopPropagation=Event.prototype.stopPropagation,
	preventDefault=Event.prototype.preventDefault,
	getComputedStyle=window.getComputedStyle,
	slice=Array.prototype.slice,
	setTimeout=window.setTimeout,
	removeAttribute=Element.prototype.removeAttribute,
	addEventListener=Document.prototype.addEventListener,
	isNaN=window.isNaN,
	RegExp=window.RegExp,
	unescape=window.unescape,
	func_toString=Function.prototype.toString;


	// Utility functions
	function addCssToDocument(cssText, doc, mediaType){
		getElementsByTagName.call=addEventListener.call=createElement.call=createTextNode.call=insertBefore.call=setAttribute.call=appendChild.call=version.call=call;
		doc = doc||document;
		mediaType = mediaType||'';
		addCssToDocument.styleObj=addCssToDocument.styleObj||{};
		var styles = addCssToDocument.styleObj[mediaType];
		if(!styles){
			var head = getElementsByTagName.call(doc, "head")[0];
			if( !head ){
				var docEl = getElementsByTagName.call(doc, "html")[0];
				if(!docEl){
					// :S this shouldn't happen - see if document hasn't loaded
					addEventListener.call(doc, opera&&version.call(opera)>=9?'DOMContentLoaded':'load',
					function(){ addCssToDocument(cssText, doc); },false);
					return;
				}
				head = createElement.call(doc, "head");
				if(head) insertBefore.call(docEl, head,docEl.firstChild);
				else head = docEl;
			}
			addCssToDocument.styleObj[mediaType] = styles = createElement.call(doc, "style");
			setAttribute.call(styles, "type","text/css");
			if(mediaType)setAttribute.call(styles, "media", mediaType);
			appendChild.call(styles, createTextNode.call(doc,' '));
			appendChild.call(head, styles)
		}
		styles.firstChild.nodeValue += cssText+"\n";
		return true;
	}
	function addPreprocessHandler( search, replacement, onceonly, conditional ){
		// adding event handler for script pre-processing if required
		opera.addEventListener('BeforeScript', 
			function(e){ 
				indexOf.call=replace.call=removeEventListener.call=call; /* also needs anything used inside conditional! */
				if( conditional && ! conditional(e.element) ){return;}
				e.element.text=replace.call( e.element.text, search, replacement );
				if(onceonly){
					removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
				}
			}
		, false);
	}
	function fakeCSSFilters(){ // faking support for some of the common filters so that using them won't stop the script
		var filterObj={apply:function(){}, play:function(){}, Apply:function(){}, Play:function(){}}; // some of the common functions
		HTMLElement.prototype.filters=[ filterObj, filterObj, filterObj ]; // fake three applied filters with play and apply functions
		HTMLElement.prototype.filters['blendTrans']=filterObj; // we also fake a named blendTrans filter
	}
function fakeOncontextmenu( useAltClick, clickAndHold ){

	if ( 'oncontextmenu' in document.createElement('foo') )
		//contextmenu supported - nothing to do
		return;
		
	function cloneObject(src,dest){
		dest=dest||{};
		for(var prop in src)
			dest[prop]=src[prop];
		return dest;
	};
	function prepareContextMenuEvent(e,node){
		var ev = cloneObject(e);
		ev.currentTarget=node;
		ev.type='contextmenu';
		ev.returnValue=true;
		ev.cancelBubble=false;
		ev.preventDefault=function(ev){this.returnValue=false;}
		ev.stopPropagation=function(ev){this.cancelBubble=false;}
		return ev;
	}
	function ctxClickHandler(e){
		var node = e.target, foundAnything = false;
		do{
			if( typeof node.oncontextmenu == 'function' ){
				var ev = prepareContextMenuEvent(e,node)
				try{
					node.oncontextmenu(ev);
					if(!ev.returnValue)
						e.preventDefault();
					if(ev.cancelBubble){
						e.stopPropagation();
						return true;
					}
				}catch(ex){
					setTimeout(function(){throw ex;},1);
				}
				foundAnything = true;
			}else if( node.getAttribute && (js = node.getAttribute('oncontextmenu')) ){
				var ev = prepareContextMenuEvent(e,node)
				try{
					var retVal = eval('(function(){'+js+';}).call(node,ev);')||ev.returnValue ;
					if(!retVal && (retVal!==undefined))
						e.preventDefault();
					if(ev.cancelBubble){
						e.stopPropagation();
						return true;
					}
				}catch(ex){
					setTimeout(function(){throw ex;},1);
				}
				foundAnything = true;
			}
		}while(node=node.parentNode);
		return foundAnything;
	}
	function dispatchCtxMenuEvent(e){
		var doc = e.target.ownerDocument||(e.view?e.view.document:null)||e.target;
		var newEv = doc.createEvent('MouseEvent');
		newEv.initMouseEvent('contextmenu', true, true, doc.defaultView, e.detail,
			e.screenX, e.screenY, e.clientX, e.clientY, e.ctrlKey, e.altKey,
			e.shiftKey, e.metaKey, 2, e.relatedTarget);
		e.target.dispatchEvent(newEv);
	};
	
	var isRightClick = false;
	addEventListener('mousedown',function(e){
		if( e && e.button == 2 ){
			isRightClick = true;
			setTimeout(function(){isRightClick=false;},1000);
		}
	},true);
	addEventListener('mouseup',function(e){
		//right-click doesn't fire click event. Only mouseup
		if( e && e.button == 2 && isRightClick){
			dispatchCtxMenuEvent(e);
		}
		clearCtxTimeout();
	},true);
	addEventListener('contextmenu',function(e){
		ctxClickHandler(e);
	},true);
	if(useAltClick)
		addEventListener('click',function(e){
			if( e && e.button == 0 && e.altKey ){
				dispatchCtxMenuEvent(e);
			}
		},true);

			
	var eventCopy, ctxMenuTimeout;
	var pixelThreshold = 3;
	var msecCtxValue = clickAndHold;
	
	function clearCtxTimeout(){
		clearTimeout(ctxMenuTimeout);
		ctxMenuTimeout = eventCopy = null;
	}
	
	if( clickAndHold && typeof clickAndHold == 'number' ){
		addEventListener('mousedown',function(e){
			if(e && e.button!=2){
				eventCopy = cloneObject(e);
				eventCopy.preventDefault = function(){};
				eventCopy.stopPropagation = function(){};
				ctxMenuTimeout = setTimeout(function(){if(eventCopy)dispatchCtxMenuEvent(eventCopy);},msecCtxValue);
			}
		},true);
		
		addEventListener('mousemove',function(e){
			if( ctxMenuTimeout && eventCopy && e )
				if( Math.abs(e.clientX-eventCopy.clientX) > pixelThreshold ||
					Math.abs(e.clientY-eventCopy.clientY) > pixelThreshold ){
					clearCtxTimeout();
				}
		},true);
	}
	
};
	function fixCoolmenus(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
		// Version 4 is Opera 7 - compatible and does user agent sniffing
		navRestore['userAgent'] = navigator.userAgent;
		navigator.userAgent +=' msie 6';
		shouldRestore = true;
		defineMagicVariable.call(opera, 'bw', function(o){
			// we need to override yet some more browser detection, and disable CSS filters
			// usedom must be 0 to make frameset menus work
			o.filter=o.op7=o.op=o.usedom=o.ns6=0;
			o.ie=o.ie6=1;
			return o}, function(o){return o});
		addPreprocessHandler(  'this.win.document.body.appendChild(oNS)',  'try{this.win.document.body.appendChild(oNS)}catch(e){oNS=this.win.document.body.appendChild(this.win.document.importNode(oNS, true))}' );
		addPreprocessHandler(  'oNS.appendChild(oNS2)',  'try{oNS.appendChild(oNS2);}catch(e){oNS2=oNS.appendChild(oNS.document.importNode(oNS2, true));}' );
	}
	function fixHVMenu(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=match.call=call;
		// fix by changing Opera from an unsupported browser to a supported browser
		// Set to true either PosStrt, NavYes, DomNav   or   PosStrt, ExpYes, DomExp
		defineMagicVariable.call(opera, 'PosStrt', function(){ return true }, null);
		defineMagicVariable.call(opera, 'NavYes', function(){ return true }, null);
		defineMagicVariable.call(opera, 'DomNav', function(){ return true }, null);
		// if Opera >= 9.5, load events are sent to document and not to body - make sure script doesn't set body.onload
		defineMagicVariable.call(opera, 'Trigger', function(){ return document; }, null);
		// Tell the script that CSS filters are not supported.
		defineMagicVariable.call(opera, 'Fltr', function(){ return false; }, function(){ return });
		// More recent versions look for 'opera 7' in navigator.userAgent and some do not use the variable names above
		if(  match.call(name, /var\.js$/) || match.call(name, /compact\.js$/) ){
			navRestore['userAgent'] = navigator.userAgent;
			navigator.userAgent+=' opera 7'; 
			shouldRestore = true;
		}
	}	function fixHierMenus(){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
	      // HM_IsMenu must be true to make the menu appear
	      // HM_BrowserString should be DOM to make the right library load
		defineMagicVariable.call(opera, 'HM_IsMenu', function(){ return true}, function(){ return true });
		defineMagicVariable.call(opera, 'HM_BrowserString', function(){ return 'DOM'}, function(){ return 'DOM' });
	}
	function fixMilonicMenu(name){ 	// IMPORTANT gotcha: the fixOpenCube and fixHVMenu functions must be called with an appropriate string argument
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=defineMagicFunction.call=call;
	      // "opera" or "opra" true will cause no menu or garbled (Opera 6 pixel* -  compat)
		defineMagicVariable.call(opera, 'opera', function(){ return false }, function(){});
		defineMagicVariable.call(opera, 'opra', function(){ return false }, function(){});
		// ie55 true will use IFRAME shims
		defineMagicVariable.call(opera, 'ie55', function(){ return false }, function(){ });
		// identifying as Opera will cause "dom" variable to be false in some versions
		defineMagicVariable.call(opera,  'dom' , function(){ return true }, function(){});
		// fixForm function will hide page content
		defineMagicFunction.call(opera,  'fixForm' , function(){});
		// Menu does not work on Mac if it detects platform
		defineMagicVariable.call(opera, 'mac', function(){ return false }, function(){ });
	}
	function fixOpenCube(name){// IMPORTANT gotcha: the fixOpenCube and fixHVMenu functions must be called with an appropriate string argument
		match.call=addEventListener.call=defineMagicVariable.call=indexOf.call=call;
		// OpenCube menu
		window.vxml = window.vxml||{}; // to fix semi-opera-detection
		//Some versions try to call a function q99 which is only defined in the Opera library
		addEventListener.call(document, 'load', function(){ if(typeof q99=='undefined')window.q99=function(){}  }, false);
		// fake some support for the menu version that tries to use CSS filters in spite of magic var below 
		fakeCSSFilters();
		// We'll overrule their sniffing and find the correct library for Opera
		if(match.call(name, /dqm_script\d*\.js$/)){
			defineMagicVariable.call(opera, 'brn', function(val){ return 'ie' }, function(val){ return 'ie' });
			defineMagicVariable.call(opera, 'ie6', function(val){ return true }, function(val){ return true });
			// prevent the menu from trying to use CSS filters
			defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);
			if(document.evaluate){ // we have an event transparency problem on some sites, see for example bug 239622
				addEventListener.call(document, 'load', function(){
					var nodes=document.evaluate( '//a/child::img[substring(@id, 0, 4)=\'qmim\']', document.body,null,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null ),node;
					while( node=nodes.iterateNext()){
						node.parentElement.parentElement.replaceChild(node, node.parentElement );
					};
				}, false);
			}
			fixed=true;
			return true;
		}else if(indexOf.call(name, 'dqm_loader.js')>-1){
			defineMagicVariable.call(opera, 'brn', function(val){ return 'opera7' }, function(val){return 'opera7'});
			// prevent the menu from trying to use CSS filters
			defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);
			fixed=true;
			return true;
		}
	}
	function fixSoThinkMenus(){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
		defineMagicVariable.call(opera, 'nOP',function(){return false;},null);
		defineMagicVariable.call(opera, 'nIE',function(){return false;},null);
		defineMagicVariable.call(opera, 'nNN6',function(){return true;},null);
	}
	function fixTransmenus(){
		// Fixing bugs in menu script from http://www.youngpup.net/2004/transmenus/ 
		// Credits xErath and Andrew Gregory
		opera.addEventListener('BeforeScript', function(ev) {
			indexOf.call=replace.call=removeEventListener.call=call;
			var js = ev.element.text;
			if (indexOf.call(js, "TransMenu")!=-1) {
				js = replace.call(js, /return\s+r(\b)/,"return true$1");
				js = replace.call(js, /mac/g,"xpto");
				js = replace.call(js, "el.scrollLeft", "0");
				js = replace.call(js, "el.scrollTop", "0");
				ev.element.text = js;
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}
		}, false);
	}
	function fixUDM(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
		// Some versions are Opera 7 - compatible and do user agent sniffing
		navRestore['userAgent'] = navigator.userAgent;
		navigator.userAgent +=' opera 7.5';
		shouldRestore = true;
		// If the menu is a 3.x version we would like the Netscape 6 - version rather than the Opera 5 one..
		defineMagicVariable.call(opera, 'op5',function () { return 0; },null);
		defineMagicVariable.call(opera, 'ns6',function () { return 1; },null);
	}
	function preventEventCapture(object,eventName){ // Opera supports capturing events but many sites do it by mistake
		var ael=object.addEventListener;
		object.addEventListener=function(type, func, cap){
			if(type==eventName)cap=false;
			ael.call( this, type, func, cap);
		}
	}
function removeClosingHTMLComments(){
    opera.addEventListener( 'BeforeScript', function(e){ replace.call=call; e.element.text=replace.call( e.element.text, /\r\n\s*-->\s*\r\n/, '' ); }, false );
}function scriptForEventFix(){ // neutralising IE's <script for.. event.. > syntax
	opera.addEventListener('BeforeScript', 
		function(ev){
			getAttribute.call=setAttribute.call=preventDefault.call=call;
			if(getAttribute.call(ev.element, 'event')){
				setAttribute.call(ev.element, 'declare', 'declare');
				preventDefault.call(ev);
			}
		}
	, false);
}


	// Generic JS library patches
// AllWebMenus and FoldOutMenu fixes
// Router configuration SCRIPT in OPTION tag fix
// PDF security patch
// working around incompatibility with prototype
			// 0, Generic JS library patches
		// Use an event listener to detect specific scripts
		opera.addEventListener( 'BeforeExternalScript', function(ev){
			match.call=replace.call=indexOf.call=toLowerCase.call=postError.call=addEventListener.call=removeEventListener.call=call;
			
			var name=ev.element.src; 
			if( !name ){ return; } // no fixes required for SCRIPT xlink:href so far..
			name=toLowerCase.call(name );// toLowerCase fixes sangjatten.se
		      if ( indexOf.call(name, 'dqm_')>-1 || indexOf.call(name, 'cbrowser_opera.js')>-1 ){ 
				// OpenCube menu
				if(fixOpenCube(name)){
					postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (OpenCube fix). See browser.js for details.');
				}
				return;
		      }else if(  indexOf.call(name, 'hm_loader')>-1  ){ 
				// HierMenus menu
				// If we apply this fix to version 6.x the menu breaks.
				// HM support recommends checking that HM_BrowserVersion is not defined
				addEventListener.call(opera, 'BeforeScript', function(ev){ 
					if( ev.element.text && ! match.call(ev.element.text, /hm_browserversion/i) ){
						fixHierMenus(name);
					}
					removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
				}, false);
				return;
		      }else if(  indexOf.call(name, 'mmenu.js')>-1  ){ 
				// Milonic menu
				fixMilonicMenu(name);
				return;
			
		      }else if(  match.call(name, /menu\d*_(com|build|var|program|compact)\.js$/)   ){ 
				// HV menu
				fixHVMenu(name);
				return;
		      }else if(  match.call(name, /coolmenus\d?.js$/)   ){ 
				// coolmenus menu
				fixCoolmenus(name);
				return;
		      }else if(  match.call(name, /udm[_-]/)  || (  match.call(name, /(sniffer|control)\.js$/)   )    ){ 
				// UDM menu
				addEventListener.call(opera, 'BeforeScript', function(ev){
					if( match.call(name, /udm[_-]/)  || indexOf.call(ev.element.text, 'UDM')>-1 || indexOf.call(ev.element.text, 'um.ov=um.ov.split(/opera[\\/ ]7./);um.ov=um.pi(um.ov[1].charAt(0));')>-1 ){
						fixUDM(name);
					}
				}, false);
				return;
		      }else if(  indexOf.call(name, 'dynapi/api/browser.js')>-1  || indexOf.call(name, 'dynlayer.js')>-1  ){
				navRestore['appName'] = navigator.appName;
				navigator.appName = 'Microsoft Internet Explorer';
				shouldRestore = true;
				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (DynAPI fix). See browser.js for details.');
			}else if(  match.call(name, /stm(\d+|_menu).js$/)  ){
				fixSoThinkMenus();
				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (SoThink fix). See browser.js for details.');
			}else if( indexOf.call(name, 's_code.js')>-1 ){ // Bug 217419, bug 234876, bug 262961 and more: omniture click tracking overwrites page
				addEventListener.call( document, 'load', function(){ document.write=function(){postError.call(opera,'Warning: scripts on this page were changed by the s_code patch. See browser.js for details.')}; }, false );
			}else if( indexOf.call(name, 'transmenu')>-1 ){
				fixTransmenus();
			}else if( indexOf.call(name, 'xaramenu')>-1 ){
				addPreprocessHandler( new RegExp('if\\(navigator.userAgent.indexOf\\(\'Opera\'\\)!=-1\\)\\s*NS4=1;', ''), 'if(navigator.userAgent.indexOf(\'Opera\')!=-1) IE5=1;' );
				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Xaramenu fix). See browser.js for details.');
			}else if(  indexOf.call(name, '/richtext.js')>-1  ){ // Bug 230549, bug 208097
				// Rich text editor checks for "On" where Opera and FireFox return "on". sigh. 
				addPreprocessHandler( 'designMode != "On"', 'designMode != "on"', true, function(t){indexOf.call=call;return indexOf.call(t.text, 'kevinroth.com')>-1;} );
				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Rich text editor submit fix). See browser.js for details');
			}else if(indexOf.call(name, '/novell/webaccess/images/msglist.js')>-1){ // Bug 92454, workaround for NWA
				defineMagicFunction.call(opera, 'fixContentHeight',
					function(oF, oT){
						document.documentElement.clientHeight=window.innerHeight;
						oF.apply(oT, slice.call(arguments, 2));
				});
				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Height function fix). See browser.js for details');
			}
			// Creating event handler to restore any changed navigator properties
			if( shouldRestore ){
				addEventListener.call(opera, 'AfterExternalScript', 
					function(ev){
						removeEventListener.call=call;
						var prop;
						for(prop in navRestore) navigator[prop]=navRestore[prop];
						removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);
					}
				, false);
			}
		}, false);
			// 67843, AllWebMenus and FoldOutMenu fixes
		opera.addEventListener( 'AfterScript', function(ev){
			addEventListener.call=indexOf.call=match.call=defineMagicVariable.call=postError.call=removeEventListener.call=replace.call=isNaN.call=call;
		      // AllWebMenus fix
		      // If version number is outdated, force it to use IE-compatible library
			if(  typeof ( awmBN ) != 'undefined' && ! isNaN.call(window,  awmBN  ) ){
				if( awmBN <498 ){
					if(fixed){return;}fixed=true;
					// we have a version number and the menu seems too old
					addEventListener.call(opera,  'BeforeScript', function(e){indexOf.call=match.call=defineMagicVariable.call=postError.call=removeEventListener.call=call;
						if( indexOf.call(e.element.text, 'var awmSupported=' )>-1 ){
							// AWM loads different libraries based on numbers - number 1 is IE-compat
							if( ! match.call(e.element.text, /var awmSupported=[^;]*Opera/) ){
								defineMagicVariable.call(opera,   'scriptNo', function(){return 1}, function(){return 1} );
								defineMagicVariable.call(opera,   'awmBefore7', function(){return false}, function(){return false} );
								postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AllWebMenus fix). See browser.js for details.');
							}
							removeEventListener.call(opera, 'BeforeScript', arguments.callee, false );
						}
					}, false);
					return;
				}
			}else if( typeof(lib_bwcheck)=='function' && typeof(bw) !='undefined'){
				// this looks like a FoldOutMenu
				bw.opera5=false;
				bw.ie=true; // fixes menu on site from bug 67843
				navigator.userAgent=replace.call(navigator.userAgent, 'Opera', '0pera');  // OBS! no restore.. :-(
				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (FoldOutMenu fix). See browser.js for details.');
			}
			
		}, false);
			// 129998, Router configuration SCRIPT in OPTION tag fix
	/* OPTION elements are not allowed to contain scripts, but Linksys and some old Belkin routers use
	scripts to write the contents of OPTION elements */
	
	document.addEventListener('DOMContentLoaded', function () {
		/* so many configurations, the only common things are the function names:
		   Capture for Linksys, dw for Belkin (untested) - no reliable way to isolate devices */
		if( typeof window != 'undefined' && ( ( window.Capture && typeof(Capture) == 'function' && window.share && share.firmwarever ) || ( window.dw && typeof(dw) == 'function' ) ) ) {
			// find all options whose values seem to start with relevant function calls
			var oQry = ( window.Capture ? "//option[starts-with(normalize-space(text()),'Capture(')]" : '' ) +
			           ( ( window.Capture && window.dw ) ? '|' : '' ) +
			           ( window.dw ? "//option[starts-with(normalize-space(text()),'dw(')]" : '' );
			var j, oStr, optionlist = document.evaluate( oQry, document, null, XPathResult.UNORDERED_NODE_ITERATOR_TYPE, null );
			try {
				while( j = optionlist.iterateNext() ) {
					oStr = j.text.replace(/^\s*Capture\(|^\s*dw\(|\);?\s*$/g,'');
					eval( 'j.text = '+oStr );
				}
			} catch(e) {
				opera.postError('Attempted to patch broken router firmware\nbut failed to correctly apply the fix.\nFix aborted.\n\n'+href);
			}
		}
	}, false);
			// 246299, PDF security patch
	opera.addEventListener('BeforeJavaScriptURL', function( e ){
		unescape.call=toLowerCase.call=indexOf.call=preventDefault.call=call;
		var pathname=unescape.call(self, toLowerCase.call(self.location.pathname));
		var hash=unescape.call(self, toLowerCase.call(self.location.hash));
		if( /*indexOf.call(pathname, '.pdf')>-1 &&*/ hash  &&  indexOf.call(hash, 'javascript:')>-1   ) preventDefault.call(e);
	}, false);
			// 241832, working around incompatibility with prototype
	Array.prototype.concat = function(){  // working around incompatibility with prototype, bug 241832
	    var array = [];
	    for(var i = 0, length = this.length; i < length; i++) array.push(this[i]);
	    for(var i = 0, length = arguments.length; i < length; i++) {
	      if(arguments[i].constructor == Array) {
		for(var j = 0, arrayLength = arguments[i].length; j < arrayLength; j++)
		  array.push(arguments[i][j]);
	      } else {
		array.push(arguments[i]);
	      }
	    }
	    return array;
	}


	if( hostname.indexOf('.saab.')>-1 ){			// 145261,  sniffing on saab.com and saab.de excludes Opera
		opera.defineMagicVariable('isNAV6', function(){return true;}, null);
		opera.defineMagicVariable('isOPERA', function(){return false;}, null);
		opera.defineMagicVariable('isMAC', function(){return false;}, null);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( sniffing on saab.com and saab.de excludes Opera). See browser.js for details');
	} else if((hostname=='www.opera.com' || hostname=='jp.opera.com') && pathname.indexOf('/docs/browserjs/')==0){			// 0, Browser.js status and version reported on browser.js documentation page
		document.addEventListener('load',function(){
			if(document.getElementById('browserjs_active')){
				document.getElementById('browserjs_active').style.display='';
				document.getElementById('browserjs_active').getElementsByTagName('span')[0].appendChild(document.createTextNode(bjsversion));
				document.getElementById('browserjs_status_message').style.display='none';
			}else if(document.getElementById('browserjs_status_message')){
				document.getElementById('browserjs_status_message').firstChild.data='Browser.js is enabled! '+bjsversion;
			}
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Browser.js status and version reported on browser.js documentation page). See browser.js for details');
	} else if(hostname.indexOf(  'music.download.com'  )>-1){			// 178744, Fixing audio samples, old overlibwms library only detects Opera7
		navigator.userAgent += ' Opera 7';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fixing audio samples, old overlibwms library only detects Opera7). See browser.js for details');
	} else if(hostname.indexOf( 'fileplanet.com' ) >-1 && href.indexOf('/sp_downloadmanager.aspx')>-1){			// 219257, Fileplanet.com sniffing blocks Opera
		opera.defineMagicVariable('agt',function(){return "win";},null);
		addPreprocessHandler( /(\b)window\s*.\s*opera(\b)/g,'$1undefined$2');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fileplanet.com sniffing blocks Opera). See browser.js for details');
	} else if(hostname.indexOf( 'jobkorea.co.kr')>-1){			// 201259, jobkorea.co.kr table line-height
		if(href.indexOf('www.jobkorea.co.kr/Jobtimes/')>-1){
		    addCssToDocument('table table td  { line-height:10pt !important }');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (jobkorea.co.kr table line-height). See browser.js for details');
	} else if(hostname.indexOf( 'joins.com')>-1){			// 212585, joins.com IE quirks fix: stockbanner position
		addCssToDocument('#stockbanner { position: absolute !important }'); // bug 212585 and 210161
				// 201410, joins.com IE quirks fix: transparent EMBED and positioning
		document.addEventListener( 'load', function( ev)  { 
			  var  elm;
		    if ( hostname.indexOf( 'blog.joins.com') > -1 )  {
		      // bug 201410
		      elm = document.getElementById( 'btnVisitor');
		      if ( elm && elm.parentNode && elm.parentNode.parentNode)  {
			elm.parentNode.parentNode.style.position = 'relative';
			elm.parentNode.parentNode.style.top = '-16px';
		      }
		      // bug 201421
		      elm = document.getElementById( 'id_show1_friend_sub');
		      if ( elm && elm.nextSibling)  {
			elm=elm.nextSibling.getElementsByTagName( 'embed')[ 0];
			if(elm){elm.wmode = 'transparent';}
		      }
		    }
		
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (joins.com IE quirks fix: stockbanner position\njoins.com IE quirks fix: transparent EMBED and positi...). See browser.js for details');
	} else if(hostname.indexOf( 'moneta.co.kr')!=-1){			// 219041,  moneta.co.kr relies on IE quirks for CSS positioning
		document.addEventListener( 'load', function( ev)  { 
				var  elm;
			       // Bug 219041
			       elm = document.getElementById( 'stock');
				if (elm && elm.style.position=='')  { elm.style.position = 'relative'} 
			       elm = document.getElementById( 'news');
			       if (elm  && elm.style.position=='')  { elm.style.position = 'relative'} 
		}, false);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( moneta.co.kr relies on IE quirks for CSS positioning). See browser.js for details');
	} else if(hostname.indexOf("epa.qld.gov.au")>-1){			// 212375, epa.qld.gov.au site uses capturing load events. 
		preventEventCapture(window, 'load');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (epa.qld.gov.au site uses capturing load events. ). See browser.js for details');
	} else if(hostname.indexOf("rec.feeds.yahoo.")==0){			// 194334, Make "add feeds" dialog work in Y!Mail beta
		if( location.href.indexOf("bjs_getXMLMarkup")>=0 )location.href = location.href.replace("bjs_getXMLMarkup()","xml");
		navigator.product='Gecko';
		addCssToDocument('#FeedTabs div.panel{overflow:auto!important}body{overflow:hidden!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Make "add feeds" dialog work in Y!Mail beta). See browser.js for details');
	} else if(hostname.indexOf('.dell.')>-1){			// 209482, Dell.com: login frame disappears too quickly
		opera.addEventListener( 'BeforeEventListener.mouseover' , function(){
				getElementById.call=getElementsByTagName.call=removeEventListener.call=call;
				var el,ifr; if(el=getElementById.call(document, 'pbarcontent')){if(ifr=getElementsByTagName.call(el, 'iframe')[ 0 ]){
				el.onmouseover=ifr.onmouseover; el.onmouseout=ifr.onmouseout; 
				removeEventListener.call(opera, 'BeforeEventListener.mouseover', arguments.callee, false )
			}}} , false  );
			// prevent more than one "hide me" timeout thread at once
			defineMagicFunction.call(opera,   'flyoutmin', function( oF, oThis, id ){ if(typeof flyoutminclear=='function'){flyoutminclear();}  oF.call(oThis, id); }  );
			// don't hide if entering IFRAME
			opera.addEventListener( 'BeforeEventListener.mouseout' , function(e){if(e.event.target.id=='pbarcontent' && e.event.relatedTarget==document.body)preventDefault.call(e);} , false  );
		
				// 209468, Dell.com: broken menus
			defineMagicFunction.call(opera, 'ParseDivObjects', function(oF,oThis,name) {
			  var divs = document.getElementsByTagName('div'), namedDivs = [];
			  for( var i = 0, div; div = divs[i]; i++ ) {
			    if( div.getAttribute('name') == name ) { namedDivs[namedDivs.length]=div; }
			  }
			  return namedDivs;
			});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Dell.com: login frame disappears too quickly\nDell.com: broken menus). See browser.js for details');
	} else if(hostname.indexOf('.ebay.')>-1){			// 226144, eBay: IFRAME expands forever
		document.addEventListener( (opera.version()>9?'DOMContentLoaded':'load'), function(){ try{
			if( ! window.frameElement)return; 
			document.onresize=null;document.body.onresize=null;
		}catch(e){}}, false );
		
				// 228707, eBay: speed up back+forward navigation
		opera.setOverrideHistoryNavigationMode('fast');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (eBay: IFRAME expands forever\neBay: speed up back+forward navigation). See browser.js for details');
	} else if(hostname.indexOf('.google.')>-1&&href.indexOf('/calendar/')>-1){			// 229475, Google calendar date selection fails due to order of blur and mousedown events
		opera.addEventListener('BeforeEvent.blur',function(e){ 
			indexOf.call=preventDefault.call=call;
			if(! (e.event.target instanceof Node) ) return;
			if( indexOf.call(e.event.target.id, 'when')==0 )
				preventDefault.call(e);
		},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Google calendar date selection fails due to order of blur and mousedown events). See browser.js for details');
	} else if(hostname.indexOf('.ibm.com')>-1){			// 206984, IBM driver download has HTML comments inside SCRIPT tag, breaks parsing
		removeClosingHTMLComments();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (IBM driver download has HTML comments inside SCRIPT tag, breaks parsing). See browser.js for details');
	} else if(hostname.indexOf('.live.com')>-1&&hostname.indexOf('search.live.com')==-1){			// 262961, Live.com properties overwrite page from click tracking script
		opera.defineMagicFunction( 'RegisterOmnitureAction', function(){} );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Live.com properties overwrite page from click tracking script). See browser.js for details');
	} else if(hostname.indexOf('.mail.yahoo.')>-1&&(href.indexOf( '/dc/system_requirements?browser=blocked' )>-1||href.indexOf( '/dc/system_requirements?browser=unsupported' )>-1)){			// 194334, Y!Mail work around browser blocking
		location.href='/dc/launch?sysreq=ignore';
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Y!Mail work around browser blocking). See browser.js for details');
	} else if(hostname.indexOf('.mail.yahoo.')>-1&&href.indexOf( '&y5beta=yes' )>-1){			// 0, server-side browser sniffing prevents "try beta" link from appearing in old mail
		document.addEventListener('DOMContentLoaded', function(){  if(document.getElementById('optionsheader'))document.getElementById('optionsheader').insertAdjacentHTML('BeforeBegin', '<div class="switchbox rounded"> <b>Yahoo! Mail Beta has arrived! <a href="/dc/landing" target="_top">Try it now!</a></b></div>'); /* with apologies to users of localized Y!Mail versions.. */  }, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (server-side browser sniffing prevents "try beta" link from appearing in old mail). See browser.js for details');
	} else if(hostname.indexOf('.mail.yahoo.')>=0 && pathname.indexOf('/dc/')==0){			// 194334, Y!Mail uses XMLDocument without detecting it
		window.XMLDocument = window.XMLDocument||Document;
		
				// 194334, Y!Mail faking getters and setters
		// --- workaround for defineGetter and defineSetter used in Gecko library ---
		//this must be defined to get the showModalDialog implementation
		/*if( !window.Window ){ window.Window=function(){}; window.Window.prototype=window; }*/
		//faking getters and setters
		var ifaces = ['Node','CSSStyleDeclaration','CSSStyleSheet','Event'/*,'Window'*/];
		for(var idx=0, iface; (iface = ifaces[idx]) && (iface = window[iface]) && (iface = iface.prototype); idx++)
			iface.__defineGetter__ = iface.__defineSetter__ = function(){};
		
				// 194334, Y!Mail faking IE's loadXML method
		HTMLElement.prototype.loadXML = function (xml) {
			if (this.tagName != "XML") {return;}
			if ( !xml ) {
				var doc = document.implementation.createDocument("", "", null);
				doc.appendChild(doc.createElement(this.id));
			} else {
				try{
					var doc = (new DOMParser()).parseFromString(xml.replace(/\n/g, "&#10;"), "text/xml");
				}catch(e){
					//DOMParser could not parse fragment, probably because of missing single root element. Workaround time..
					var doc=document.implementation.createDocument('', this.tagName, null);
					var el=doc.createElement('el');
					el.innerHTML=xml;
					for(var i=0, child; child = el.childNodes[i] ;i++)
						doc.appendChild(child.cloneNode(true));
				}
			}
			this.XMLDocument = doc;
			this.XMLDocument.parseError={errorCode:0};
			if( typeof this.documentElement=='undefined' ){
				this.documentElement = doc.documentElement||doc.firstChild;
			}else if( this.__defineGetter__ ){
				this.__defineGetter__( 'documentElement', function(){ return doc.documentElement||doc.firstChild; } )
			}
		
			return doc;
		};
		
				// 194334, Y!Mail faking isSameNode
		if(!Node.prototype.isSameNode)
			Node.prototype.isSameNode = function(n){
				return n===this;
			}
		
				// 194334, Y!Mail making sure addRule doesn't throw x-doc security errors
		if(!CSSStyleSheet.prototype.addRule )
			CSSStyleSheet.prototype.addRule = function( selector, css ){
				try{
					this.insertRule(selector+" { "+css+" }",this.cssRules.length);
				}catch(ex){}
			};
		
				// 194334, Y!Mail DOCTYPE in serialized XML causes 500 response
		var XMLHttpSend = XMLHttpRequest.prototype.send;
		XMLHttpRequest.prototype.send = function(postData){
			return XMLHttpSend.call(this, postData&&postData.documentElement?postData.documentElement:postData);
		};
		
				// 194334, Y!Mail workaround for reading Node.xml property
		var serializer=document.implementation.createLSSerializer();
		var writeToString=serializer.writeToString;
		Node.prototype.bjs_getXMLMarkup = function(){ writeToString.call=call; return writeToString.call(serializer,this); };
		opera.addEventListener('BeforeScript', function(e){
			replace.call=call;
			// workaround for getting the documentElement.xml  markup and
			// contact information not shown. caused by if(elm.xml) clause in function that reads attribute values
			e.element.text=replace.call(e.element.text, /documentElement\.xml/g, "documentElement.bjs_getXMLMarkup()" );
			e.element.text=replace.call(e.element.text, /if\((\w{1,3})\.xml\)/g, "if($1.bjs_getXMLMarkup())" );
		}, false);
				// 194334, Y!Mail button attribute "action" is a URL in WF2
		opera.addEventListener('BeforeScript', function(e){
			replace.call=call;	e.element.text=replace.call(e.element.text, /\.(action\b)/g, ".js$1" );
		}, false);
		
				// 194334, Y!Mail To: / CC: autocomplete fails because boundingLeft is not supported
		HTMLInputElement.prototype.createTextRange=HTMLTextAreaElement.prototype.createTextRange=null;
		
		
				// 194334, Y!Mail preventing drag from selecting text
		if( self==top )
			opera.addEventListener('BeforeEventListener.mousedown',function(e){
					try{
						indexOf.call = preventDefault.call = call;
						if( indexOf.call(e.event.target.parentNode.parentNode.className, 'messageRow')>-1)
							preventDefault.call(e.event);
					}catch(e){}
			},false);
		
		document.addEventListener('mousemove',function(e){
			if( e.target.getAttribute('unselectable')=='on' )
				e.target.ownerDocument.defaultView.getSelection().removeAllRanges();
		},false);
		
				// 194334, Y!Mail various display errors
		addCssToDocument(
			//remove uneeded vertical scrooling
			'html{height:100%!important}'+
			// add event dialog is borked
			'td.content>div.calendarEventEditor{width:370px!important}'+
			'td.content>div.calendarEventEditor div.accordianPaneHeader {width:380px!important}'+
			'td.content>div.calendarEventEditor div.accordianPaneBody {width:380px!important}'+
			//block child of button misplace text
			'button *{display:inline!important}'+
			//table header resizer is a white square
			'div.contTableResizerHotspot,div.msgTableResizerHotspot{background-color:transparent!important}'+
			'#msgMsgTableResizer.paneDivider.horizGrabbie{margin-left:-1px!important}'+
			//ellipsis misused
			'span.accordianPaneHeaderSummary[id="paneheader:evtReminder_Span"]{content:"Send 1 remainder to email.";}'
		);
				// 194334, Y!Mail faking oncontextmenu support
		// context menu "support"
		// click and hold make it appear
		
		fakeOncontextmenu(false, 500)
				// 244992, Y!Mail beta attachment form .action
		opera.addEventListener( 'BeforeEvent.change', function(e){
			var elm=e.event.target;
			if(elm && elm.form && elm.form.jsaction){elm.form.action=elm.form.jsaction;elm.form.jsaction=null;}
		 }, false );
				// 246021, Y!Mail: ensure cloneNode copies clip styling
		Node.prototype.cloneNode=(function(c){
			return function(deep){var n=c.call(this, deep);if(this.style&&this.style.clip)n.style.clip=this.style.clip; return n;} 
		})(Node.prototype.cloneNode);
		
				// 194334, Y!Mail remove selectSingleNode and selectNodes
		/* because Yahoo mail is better at emulating proprietary IE functions than we are.. */
		Node.prototype.selectSingleNode=undefined;
		Node.prototype.selectNodes=undefined;
				// 247940, Node interface constants not inherited by individual nodes
		Node.prototype.ELEMENT_NODE=1;
		Node.prototype.ATTRIBUTE_NODE=2;
		Node.prototype.TEXT_NODE=3;
		Node.prototype.CDATA_SECTION_NODE=4;
		Node.prototype.ENTITY_REFERENCE_NODE=5;
		Node.prototype.ENTITY_NODE=6;
		Node.prototype.PROCESSING_INSTRUCTION_NODE=7;
		Node.prototype.COMMENT_NODE=8;
		Node.prototype.DOCUMENT_NODE=9;
		Node.prototype.DOCUMENT_TYPE_NODE=10;
		Node.prototype.DOCUMENT_FRAGMENT_NODE=11;
		Node.prototype.NOTATION_NODE=12;
				// 234353, too small TEXTEARAs in compose form, shrink to fit containers and descendants with percentage width
		//compose table
		
		addCssToDocument( 'table.messageHeaderTable.compHeaderTable>tbody>tr>td:first-child+td{width:1000px!important}');
				// 241691, Y!Mail doesn't load if identifying as IE
		navigator.userAgent = navigator.userAgent.replace( /MSIE/, '' );
				// 229475, YMail: make autocomplete menus work in compose screen
		opera.addEventListener('BeforeEvent.blur',function(e){
			evaluate.call=preventDefault.call=call;
			if(! (e.event.target instanceof Node) ) return;
			if( evaluate.call(document, 'ancestor::table[contains(@class,"messageHeaderTable") and contains(@class,"compHeaderTable")]',  e.event.target, null, XPathResult.BOOLEAN_TYPE ,null).booleanValue )
				preventDefault.call(e);
		},false);
				// 257475, Curly quotes must be escaped in RegExp input
		window.RegExp = (function( original ){ return function(s,o){ if(typeof s=='string')s=s.replace(/\{(?!\d)/, '\\{'); return original.call( window, s, o ); }; })(window.RegExp)
				// 290495, can't get past "new features" screen due to redirect
		document.addEventListener( 'DOMContentLoaded', function(){
			for( var link_count=0,element;element=document.links[ link_count ]; link_count++ ){
				if( element.getAttribute('href')=='/dc/launch?consentLW=1' )element.setAttribute('href', '/dc/launch?consentLW=1&sysreq=ignore');
			}
		} ,false );
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Y!Mail uses XMLDocument without detecting it\nY!Mail faking getters and setters\nY!Mail faking IE\'s ...). See browser.js for details');
	} else if(hostname.indexOf('.t-online.de')>-1){			// 225374,  video problems on T-online.de
		if(hostname.indexOf('onunterhaltung')>-1){
					//Fix browser detection
					opera.defineMagicFunction( 'allResultsOK', function(){return true;} );
					// Fix plugin detection
					opera.defineMagicVariable( 'fHasWMP64', function(){ return navigator.mimeTypes['application/x-mplayer2'].enabledPlugin?true:false }, null )
					opera.defineMagicVariable( 'fHasWMP7', function(){ return navigator.mimeTypes['application/x-mplayer2'].enabledPlugin?true:false }, null )
					opera.defineMagicVariable( 'WMPVer', function(){ try{return fHasWMP64?'6.4':'unknown'}catch(e){return '6.4'} }, null )
			opera.addEventListener( 'BeforeScript',function(e){
				replace.call=call;
				e.element.text=replace.call(e.element.text,  'playerframe.Player.url=url;', 'playerframe.Player.url=url;nplayerframe.Player.Open(url);' );
			},false );
					// use TYPE as well as CLASSID on OBJECT tags in markup
					var objId='Player';
					var objref=null;
					document.addEventListener('DOMContentLoaded', function(e){ 
						if( ! (objref=document.getElementById(objId) ) ) return;
						if(objref.getAttribute('classid')=="CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6")objref.type='application/x-mplayer2';
					}, false);
					// Remove UI that depends on ActiveX scripting. Built-in WMP UI will do..
					document.addEventListener('DOMContentLoaded', function(e){ 
						var pb=document.getElementById('playBtn');
						var wmp=document.getElementById('playerframe');
						if( pb&&wmp ){
							pb.parentNode.style.visibility='hidden';	wmp.style.visibility='visible';
							try{ document.images.tonaus.height=0;document.images.tonaus.width=0;}catch(e){}
						}
					}, false);
		}
				// 231082,  video problems on T-online.de, VOD section
				if( hostname.indexOf('vod')>-1 ){ // 231082
					navigator.userAgent+=' Firefox';
				}
		
				// 231082,  video problems on T-online.de, WMP license installation
		if(href.indexOf('__license=delivered')>-1){
			location.replace( location.href.replace( /__license=delivered/, '?license=delivered' ) );
		}
		
				// 226414,  video problems on T-online.de, no window.external detection
		window.external=window.external||{};
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( video problems on T-online.de\n video problems on T-online.de, VOD section\n video problems on T-on...). See browser.js for details');
	} else if(hostname.indexOf('.ulead.') >-1){			// 142757, Ulead.com old Milonic menu
		 fixMilonicMenu();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Ulead.com old Milonic menu). See browser.js for details');
	} else if(hostname.indexOf('.yahoo.')>-1&&hostname.indexOf('mail')==-1){			// 101146, Yahoo ISP portal blocks Opera users
		addPreprocessHandler( /d\.location\.href = ".*?\/browser_upgrade\.html";/g, '');
				// 180917, fix for eternal JS loop on My Yahoo caused by bug in their JS
		opera.defineMagicFunction( 'yg_getPageX', function(a,b,o){ var x=0;while(o){x+=o.offsetLeft;o=o.offsetParent;} return x; } );
		opera.defineMagicFunction( 'yg_getPageY', function(a,b,o){var x=0;while(o){x+=o.offsetTop;o=o.offsetParent;}return x; } );
		
				// 292460, Personalize this page in My Yahoo broken by document.all sniffing
		document.all=null;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yahoo ISP portal blocks Opera users\nfix for eternal JS loop on My Yahoo caused by bug in their JS\n...). See browser.js for details');
	} else if(hostname.indexOf('able.co.jp')>-1){			// 253081,  able.co.jp uses capturing event listeners
		preventEventCapture( HTMLAnchorElement.prototype, 'click' );
		preventEventCapture( HTMLSelectElement.prototype, 'change' );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( able.co.jp uses capturing event listeners). See browser.js for details');
	} else if(hostname.indexOf('airfrance.')>-1){			// 160378, AirFrance use getYear when they should use getFullYear
		Date.prototype.getYear = Date.prototype.getFullYear;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AirFrance use getYear when they should use getFullYear). See browser.js for details');
	} else if(hostname.indexOf('aol.com') >-1){			// 179219, AOL miscalculated widths cause overlaps at top
		opera.addEventListener('BeforeEvent.'+(opera.version()>9?'DOMContentLoaded':'load'), function(ev){ if(ev.event.target!=document)return;
		var i;
		i = getElementById.call(document, 'static'); if(i){ i.style.width = (i.offsetWidth-2)+'px';}
		}, false);
				// 226390, AOL browser sniffing blocks opera  
		opera.defineMagicVariable( 'is_supported', function(){return 1;}, null);
		
				// 214747, AOL: when IFRAME invisible GIF is served over https, script can not update location
		if(location.protocol=='http:'){addPreprocessHandler( new RegExp('https://sns-static.aolcdn.com/', 'g'), 'http://sns-static.aolcdn.com/', false );}
		
				// 262693, AOL browser sniffing causes missing styling
		document.addEventListener('DOMContentLoaded', function(){document.documentElement.className='IE7';}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AOL miscalculated widths cause overlaps at top\nAOL browser sniffing blocks opera  \nAOL: when IFRAM...). See browser.js for details');
	} else if(hostname.indexOf('barnesandnoble.com')>-1){			// 195961, Barnes&Noble uses "required" attributes on elements that aren't required
		document.addEventListener('load', function(){var nodes=document.evaluate('//input[@required]', document.body,null,null,null),node=null; while(node=nodes.iterateNext()){ node.removeAttribute('required'); }},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Barnes&Noble uses "required" attributes on elements that aren\'t required). See browser.js for details');
	} else if(hostname.indexOf('bioware.com')>-1){			// 239590, bioware.com uses outdated HierMenus
		fixHierMenus();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (bioware.com uses outdated HierMenus). See browser.js for details');
	} else if(hostname.indexOf('blogger.com')>-1){			// 177059, Blogger: browser detection prevents WYSIWYG editing
			opera.defineMagicVariable(
					'Detect',
					function( obj ){return obj;},
					function( obj ){
						obj.OPERA = function(){return false;}
						obj.MOZILLA = function(){return true;}
						obj.IE=function(){return false;}
						obj.IE_5_5_newer=function(){return false;}
						return obj;
					}
				);
		
				// 187226, Blogger: Should distinguish AltGr and Ctrl
		opera.defineMagicFunction('isCtrlKeyPressed', function(f, t, e){ return e.ctrlKey&&!e.altKey;  });
		opera.defineMagicVariable( 'IE_KEYSET', function(){ return true; },null );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Blogger: browser detection prevents WYSIWYG editing\nBlogger: Should distinguish AltGr and Ctrl). See browser.js for details');
	} else if(hostname.indexOf('bloglines.com')>-1){			// 248295, Bloglines, designMode case sensitivity issue
		addPreprocessHandler( 'designMode != "On"', 'designMode != "on"', true, function(t){indexOf.call=call;return indexOf.call(t.text, 'kevinroth.com/rte/demo.htm')>-1;} );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Bloglines, designMode case sensitivity issue). See browser.js for details');
	} else if(hostname.indexOf('bnz.co.nz')>-1){			// 142015, bnz.co.nz use getYear when they should use getFullYear
		Date.prototype.getYear = Date.prototype.getFullYear;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (bnz.co.nz use getYear when they should use getFullYear). See browser.js for details');
	} else if(hostname.indexOf('britishairways.')!=-1){			// 206810, Prevent britishairways.com from reloading the page on resize
		opera.defineMagicFunction('resizeHandler', function(){});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent britishairways.com from reloading the page on resize). See browser.js for details');
	} else if(hostname.indexOf('bugs.co.kr')>-1){			// 279133, bugs.co.kr reloads due to SCRIPT with for and event attributes
		scriptForEventFix();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (bugs.co.kr reloads due to SCRIPT with for and event attributes). See browser.js for details');
	} else if(hostname.indexOf('cheaptickets.com')>-1){			// 222065, Cheaptickets new Function() issue workaround
		(function(){
		  var Function = window.Function;
		  window.Function = function(str){
		    return Function.call(this,str.replace(/function\s*\(/g,'function anonymous('));
		  }
		})();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Cheaptickets new Function() issue workaround). See browser.js for details');
	} else if(hostname.indexOf('chosun.com')>-1){			// 209929, chosun.com scrollarea fix
		addCssToDocument('#nscrollarea, #nscrolltxt{display: inline !important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (chosun.com scrollarea fix). See browser.js for details');
	} else if(hostname.indexOf('comedycentral.com')>-1 ){			// 272237, ComedyCentral does not finish loading
		if(document.designMode=='off')document.execCommand=function(){};
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ComedyCentral does not finish loading). See browser.js for details');
	} else if(hostname.indexOf('continental.com')>-1){			// 263594, Continental.com document.activeElement fix enables airport choice popup
		opera.addEventListener('BeforeEventListener.click', function(e){if(e.event.target && e.event.target.tagName=='A')document.activeElement=e.event.target; }, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Continental.com document.activeElement fix enables airport choice popup). See browser.js for details');
	} else if(hostname.indexOf('dancenter.com')>-1){			// 166698, Dancenter use getYear when they should use getFullYear
		Date.prototype.getYear = Date.prototype.getFullYear;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Dancenter use getYear when they should use getFullYear). See browser.js for details');
	} else if(hostname.indexOf('dcf-access.dcf.state.fl.us')>-1){			// 254544, Access Florida invalid markup problem
		document.addEventListener('DOMContentLoaded', function(){
			var a = document.getElementsByTagName('a');
			for(var i = 0,el;el=a[i];i++)
			if(el.getAttribute('href') == null && el.nextSibling.tagName == 'DIV' && el.getAttribute('id') != null)
				{
					el.appendChild( el.nextSibling.firstChild);
					el.parentNode.removeChild(el.nextSibling);
				}
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Access Florida invalid markup problem). See browser.js for details');
	} else if(hostname.indexOf('deviantart.com')>-1){			// 282065,  deviantart.com prevents mousedown on file inputs, making it impossible to select files
		opera.addEventListener('BeforeEventListener.mousedown', function(e){
		func_toString.call=preventDefault.call=call;
				if( func_toString.call(e.listener)=='function () { return false; }' && e.event.target.tagName=='INPUT' ){
					preventDefault.call(e);
				}
			}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( deviantart.com prevents mousedown on file inputs, making it impossible to select files). See browser.js for details');
	} else if(hostname.indexOf('eurosport.')>-1){			// 221548, Eurosport hides content with negative z-index unintentionally
		document.addEventListener( 'DOMContentLoaded', 
			function(){
				for(var els=document.getElementsByTagName('div'),el,i=0;el=els[i];i++)
					if(getComputedStyle(el, '').zIndex<0){ 
						el.style.zIndex='1';
					}
			}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Eurosport hides content with negative z-index unintentionally). See browser.js for details');
	} else if(hostname.indexOf('fotocenter.aol.de')>-1){			// 202045, AOL: browser warnings for various features of aol.de
		document.cookie='NewportUnsupportedBrowserAccepted=true;';
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AOL: browser warnings for various features of aol.de). See browser.js for details');
	} else if(hostname.indexOf('hangame.com')>-1){			// 229130, hangame.com SPANs should be inline-block
		addCssToDocument('#mlogin .login01 span {display:inline-block !important;} #rlogin .login01 span {display:inline-block !important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (hangame.com SPANs should be inline-block). See browser.js for details');
	} else if(hostname.indexOf('icicidirect.com')>-1){			// 204803, styling INPUT with text-transform can confuse users
		addCssToDocument('input{text-transform: none !important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (styling INPUT with text-transform can confuse users). See browser.js for details');
	} else if(hostname.indexOf('idg.se')>-1){			// 231214, speed up back/forward navigation, ensure ads do not re-appear
		opera.setOverrideHistoryNavigationMode('fast');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (speed up back/forward navigation, ensure ads do not re-appear). See browser.js for details');
	} else if(hostname.indexOf('ingdirect.com.au')>-1){			// 259040, ING Direct login issues
		opera.addEventListener( 'AfterEvent.click',
		function(e){match.call=preventDefault.call=call; if(e.event.target && match.call(e.event.target.id, /^objKeypad/))preventDefault.call(e.event); },
		false );
		
		HTMLInputElement.prototype.getAttribute=(function(ga){
			return function(n){ 
				if( n=='Required'){ 
					return ga.call(this,n)=='Required' ? 'true':'false';
				}; 
				return ga.call(this, n);
			}
		})(HTMLInputElement.prototype.getAttribute);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ING Direct login issues). See browser.js for details');
	} else if(hostname.indexOf('ipop.co.kr')>-1){			// 224076, ipop.co.kr SPAN should be inline-block
		addCssToDocument('span { display: inline-block !important }');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ipop.co.kr SPAN should be inline-block). See browser.js for details');
	} else if(hostname.indexOf('irishferries.com')>-1){			// 290482, Unexpected text nodes in document.all breaks booking
		Text.prototype.style={};
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Unexpected text nodes in document.all breaks booking). See browser.js for details');
	} else if(hostname.indexOf('isbank.com.tr')>-1){			// 265077,  fixing navigation menu on isbank.com.tr
		opera.addEventListener('BeforeScript', function(e){ replace.call=call; e.element.text=replace.call(e.element.text, 'SaklaGoster(sFrameAdi, 0, i.sMenuAd);};else if', 'SaklaGoster(sFrameAdi, 0, i.sMenuAd);}else if') },false);
		
				// 265077, Preventing CSS filter errors on isbank.com.tr
		document.all=undefined;
				// 265077, fixing keypress handler on isbank.com.tr
		var ignoreKeypressCodes = {8:'',9:'',16:'',17:'',35:'',36:'',37:'',38:'',39:'', 40:'',45:'',46:''};
		opera.addEventListener('BeforeEventListener.keypress', function( e ){ preventDefault.call=call; if( e.event.keyCode in ignoreKeypressCodes) preventDefault.call(e); }, false)
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( fixing navigation menu on isbank.com.tr\nPreventing CSS filter errors on isbank.com.tr\nfixing keyp...). See browser.js for details');
	} else if(hostname.indexOf('klm.com')>-1){			// 213449, KLM uses Gecko-specific originalTarget
		addPreprocessHandler( /if \(e\) if \(e\.originalTarget\./g, 'if (e && e.originalTarget) if (e.originalTarget.' );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (KLM uses Gecko-specific originalTarget). See browser.js for details');
	} else if(hostname.indexOf('mail.google.')>-1){			// 196536, GMail: browser blocking prevents chat feature from appearing
		if(top.location.search.indexOf('auth')>-1){
		    addPreprocessHandler( 'disablechatbrowsercheck', 'auth' );
		}else if(top==self&&!window.opener&&location.search.indexOf('disablechatbrowsercheck')==-1&&location.search.indexOf('ui=html')==-1&&pathname.indexOf('.html')==-1){
		    location.search+=(location.search)?'&disablechatbrowsercheck=1':'?disablechatbrowsercheck=1';
		}
				// 214487, GMail: prevent navigation menu on the left in RTL interface
		document.addEventListener( 'DOMContentLoaded', function(){ 
		if(document.body.dir=='rtl' && document.getElementById('nav')){
		document.getElementById('nav').style.right=0; 
		}
		}, false )
				// 244011, GMail deletes messages on End key presses
		opera.addEventListener( 'BeforeEventListener.keypress', function(e){
			preventDefault.call=call;
			if(e.event.keyCode==35){
				preventDefault.call(e);
			}
		}, false );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (GMail: browser blocking prevents chat feature from appearing\nGMail: prevent navigation menu on the ...). See browser.js for details');
	} else if(hostname.indexOf('makemytrip.com')>-1){			// 206463, MakeMyTrip search fails
		document.all=null;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (MakeMyTrip search fails). See browser.js for details');
	} else if(hostname.indexOf('mapquest.com')>-1){			// 240094, MapQuest uses .all collection with text nodes in
		opera.addEventListener('BeforeEvent.load', function(e){ 
		    if(document.body){
		        removeEventListener.call=call;
		        document.body.all=null;
		        removeEventListener.call(opera,'BeforeEvent.load', arguments.callee, false);
		    } 
		}, false)
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (MapQuest uses .all collection with text nodes in). See browser.js for details');
	} else if(hostname.indexOf('maps.ubiest.com')>-1){			// 256721, Ubiest.com uses CSS filters if document.all exists
		document.all=null;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Ubiest.com uses CSS filters if document.all exists). See browser.js for details');
	} else if(hostname.indexOf('msnbc.com')>-1){			// 207178, MSNBC sniffing hides Flash content
		opera.defineMagicVariable('oSniff', function(o){return o;},function(){ window['oSniff'].nn=5; });
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (MSNBC sniffing hides Flash content). See browser.js for details');
	} else if(hostname.indexOf('music.mu-mo.net')>-1){			// 256041, mu-mo.net uses SCRIPT for..event.. syntax
		scriptForEventFix();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (mu-mo.net uses SCRIPT for..event.. syntax). See browser.js for details');
	} else if(hostname.indexOf('n-gage.com') >-1 && navigator.userAgent.indexOf('Mac')>-1){			// 181451, N-Gage plugin sniffing does not give Flash to Mac Opera
		opera.defineMagicVariable('g_plugin', function(){return navigator.mimeTypes['application/x-shockwave-flash'].enabledPlugin},null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (N-Gage plugin sniffing does not give Flash to Mac Opera). See browser.js for details');
	} else if(hostname.indexOf('namooya.com')>-1){			// 241286, Namooya.com main flash does not appear
		document.attachEvent=null;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Namooya.com main flash does not appear). See browser.js for details');
	} else if(hostname.indexOf('nbc4.tv')>-1){			// 215526, NBC4.tv uses capturing load events
		preventEventCapture(window, 'load');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (NBC4.tv uses capturing load events). See browser.js for details');
	} else if(hostname.indexOf('nbcolympics.com')>-1){			// 197145, NBC Olympics site uses capturing load events
		preventEventCapture(window, 'load');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (NBC Olympics site uses capturing load events). See browser.js for details');
	} else if(hostname.indexOf('nectar.com')>-1){			// 240950, Nectar uses getYear where they should use getFullYear
		Date.prototype.getYear=Date.prototype.getFullYear;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Nectar uses getYear where they should use getFullYear). See browser.js for details');
	} else if(hostname.indexOf('nick.com')>-1||hostname.indexOf('nickjr.com')>-1){			// 82209, Nick.com flash detection fix
		document.all=null;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Nick.com flash detection fix). See browser.js for details');
	} else if(hostname.indexOf('nokia.')>-1 && hostname.match( /(.no|.dk|.se)$/ )){			// 205280, Broken Flash detection on some Nokia sites
		opera.defineMagicVariable('browserName', function(){return 'Netscape'}, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Broken Flash detection on some Nokia sites). See browser.js for details');
	} else if(hostname.indexOf('nrg.co.il')>-1){			// 244416,  NRG.co.il saving articles does not work
		addPreprocessHandler('document.getElementById("launcher").innerHTML="";', '');
				// 247883, NRG.co.il slideshow depends on CSS filters
		fakeCSSFilters();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( NRG.co.il saving articles does not work\nNRG.co.il slideshow depends on CSS filters). See browser.js for details');
	} else if(hostname.indexOf('orbitz.com')>-1){			// 240577, Orbitz new Function() issue workaround
		(function(){
		  var Function = window.Function;
		  window.Function = function(str){
		    return Function.call(this,str.replace(/function\s*\(/g,'function anonymous('));
		  }
		})();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Orbitz new Function() issue workaround). See browser.js for details');
	} else if(hostname.indexOf('peugeot.no')>-1){			// 264826, Peugeot.no defines function inside conditional
		var origXHR=XMLHttpRequest;
		opera.addEventListener( 'AfterScript', function(){XMLHttpRequest=origXHR;}, false );
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Peugeot.no defines function inside conditional). See browser.js for details');
	} else if(hostname.indexOf('pogo.com')>-1){			// 222328, Loading problems on pogo.com because of document.load in frameset event handler scope
		opera.addEventListener( 'BeforeEventListener.load', 
			function(e){ document.load=self.load;
		},false );
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Loading problems on pogo.com because of document.load in frameset event handler scope). See browser.js for details');
	} else if(hostname.indexOf('prisjakt.nu')>-1){			// 242474,  prisjakt.nu capturing load events on back navigation
		preventEventCapture(window, 'load');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( prisjakt.nu capturing load events on back navigation). See browser.js for details');
	} else if(hostname.indexOf('reviews.cnet.com') >-1){			// 179484, CNet videos: document.write adds a script that depends on variables defined later
		opera.addEventListener('BeforeScript',
		function(ev){ 
				indexOf.call=replace.call=call;
				var js=ev.element.text, problemstr='document.write(\'<script type="text/javascript" src="\'+skin+\'"></script>\');';
				if(indexOf.call(js, problemstr ) > -1 ){
					ev.element.text = replace.call(ev.element.text,  problemstr,'' )+';\n'+problemstr;
			}
		}
		,false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (CNet videos: document.write adds a script that depends on variables defined later). See browser.js for details');
	} else if(hostname.indexOf('search.live.com')>-1){			// 241546, Live.com search disappearing menu fix
		addCssToDocument('#sch_scopeChartDiv{overflow:hidden!important;margin-top:-4px!important}');
			opera.addEventListener('BeforeEventListener.mouseout',function(e){
				preventDefault.call=call;
				if( e.event.target.nodeType==3||e.event.relatedTarget.nodeType==3 )
					preventDefault.call(e);
			},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Live.com search disappearing menu fix). See browser.js for details');
	} else if(hostname.indexOf('spreadsheets')==0&&hostname.indexOf('.google.')>-1){			// 215770, Faking support for event object properties layerX and layerY
		opera.addEventListener( 'BeforeEventListener', function( e ){
			if(e.event.offsetX){
				e.event.layerX=e.event.offsetX;
				e.event.layerY=e.event.offsetY;
			}
		}, false );
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Faking support for event object properties layerX and layerY). See browser.js for details');
	} else if(hostname.indexOf('synaptics.com')>-1||href.indexOf('shareholder.com/synaptics')>-1){			// 191364, Synaptics.com outdated HVMenu
		fixHVMenu('var.js');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Synaptics.com outdated HVMenu). See browser.js for details');
	} else if(hostname.indexOf('teletekst.nos.nl')>-1){			// 126136, Teletext focus fix
		window.focus = function () {event.preventDefault();};
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Teletext focus fix). See browser.js for details');
	} else if(hostname.indexOf('united.com')>-1 || hostname.indexOf('flyted.com')>-1 || hostname.indexOf('itn.net')>-1){			// 193907,  United.com flight search problem: hidden images do not load, so no onload event
				document.addEventListener('load', function(){
					var i,img;
					var isHidden = function(el){
						if(!el){ return false;}
						var elmIsHidden=((el.style && el.style.display=='none') || window.getComputedStyle(el).display=='none');
						return (elmIsHidden || isHidden( el.parentNode ));
					}
					for(i=document.images.length-1;img=document.images[i];i--){
						if(img.onload){
							if( isHidden( img ) ){
								img.onload();
								return;
							}
						}
					}
				}, false);	
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( United.com flight search problem: hidden images do not load, so no onload event). See browser.js for details');
	} else if(hostname.indexOf('video.ivillage.com')>-1){			// 210951, ivillage video does not appear
		document.all=null;
		addCssToDocument( 'html, body, div, embed{height: 100% !important; width: 100% !important}' );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ivillage video does not appear). See browser.js for details');
	} else if(hostname.indexOf('video.nbc.com')>-1||href.indexOf('nbc.com/Video')>-1){			// 243428, NBC.com video problems
		document['all']=null;
		addCssToDocument('#flashcontent{height:550px!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (NBC.com video problems). See browser.js for details');
	} else if(hostname.indexOf('wachovia.com')>-1){			// 128405, Viewing checks calls createElement with markup strings if document.all exists
		document.all=null;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Viewing checks calls createElement with markup strings if document.all exists). See browser.js for details');
	} else if(hostname.indexOf('walla.co.il') >-1){			// 184398,  Walla.co.il odd CSS styling causes display problems. Bugs 184398, 184399, 206793
		addCssToDocument(' .btn-t,.btn-r, .btn{display:inline !important;} .wp-0-b{width:auto !important}table {table-layout: auto !important}.w2b + table { width: 100%;}');
		
				// 209477,  vod.walla.co.il custom videoplayer does not work
			if(hostname.match(/(^vod\.|^video\.|^news\.)/)){
				opera.defineMagicFunction( 'showPlayerObject', function( origfunc, origthis, id, url ){
					document.getElementById(id).innerHTML='<object type="video/x-ms-asf" data="'+url+'"  width="100%" height="282" autostart="true"> failed to render object </object>';
					
				});
				document.addEventListener('load', function(){
					var play=document.getElementById('td_play');if(play && play.tagName=='TD'){play.parentNode.parentNode.parentNode.parentNode.style.display='none';}
				}, false);
			}
				// 205887, Walla workaround for white-space issue
		addCssToDocument('button.w2 {white-space: nowrap;}');
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( Walla.co.il odd CSS styling causes display problems. Bugs 184398, 184399, 206793\n vod.walla.co.il ...). See browser.js for details');
	} else if(hostname.indexOf('washingtonpost.com')>-1  ){			// 154980, Washington Post picks wrong script branch because site thinks Opera is IE
		opera.defineMagicVariable('browserVersion', function(){ return 3 }, null);
			
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Washington Post picks wrong script branch because site thinks Opera is IE). See browser.js for details');
	} else if(hostname.indexOf('westjet.com')>-1 ){			// 270752,  Westjet browser sniffing causes reload loop
		opera.defineMagicVariable('browser', function(o){ o.isSupported=true; }, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( Westjet browser sniffing causes reload loop). See browser.js for details');
	} else if(hostname.indexOf('worldofwarcraft.com')>-1){			// 237552, Mouseover popups do not appear due to document.all sniffing
		document.all=null;
		fakeOncontextmenu(true, 500);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Mouseover popups do not appear due to document.all sniffing). See browser.js for details');
	} else if(hostname.indexOf('yellowpages.com.au')>-1 ){			// 231853, Yellow pages event capture fix
		preventEventCapture(window, 'load');
			
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yellow pages event capture fix). See browser.js for details');
	} else if(hostname.indexOf('ynet.co.il')>-1||hostname.indexOf('ynetnews.com')>-1){			// 224708, YNet article comments display fix
		addCssToDocument('table {display:table !important}');
		
		opera.defineMagicFunction( 'showTb', function( oFunc, oThis, tbId,isShow ){ 
					oFunc.apply(oThis, arguments.slice(2));
					oTitle.style.display= '';
					oTitle.style.display= ( isShow ) ? 'none !important': '';
					oText.style.display= '';
					oText.style.display= ( isShow ) ? '' : 'none !important' ;
				} );
		opera.defineMagicFunction( 'loadTbData', function(oFunc, oThis, tbld, tbDataText){
					var i1=tbDataText.indexOf('window.open('); 
					var i2=tbDataText.indexOf(')', i1); 
					var probl=tbDataText.substring(i1, i2);
					probl=probl.replace(/\"/g, '\'');
					tbDataText=tbDataText.substring(0, i1 )+probl+tbDataText.substring(i2); 
					oFunc.call(oThis, tbld, tbDataText);
				} );	
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (YNet article comments display fix). See browser.js for details');
	} else if(hostname.indexOf('zdnet.com.com')>-1 ){			// 146580, ZDnet video site plays non-existing files if browser is Opera
		navigator.userAgent=navigator.userAgent.replace(/Opera/, 'MSIE 6.0');	
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (ZDnet video site plays non-existing files if browser is Opera). See browser.js for details');
	} else if(pathname.indexOf('wp-admin')>-1){			// 261699, Wordpress Admin prev/next link styling makes them unclickable
		addCssToDocument('.navigation{display:inline !important;} .navigation div{display:block !important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Wordpress Admin prev/next link styling makes them unclickable). See browser.js for details');
	}
})(opera);
