       
      l   
                        N     F  
         	       	  &  
  D      
              {           !         )              
                 	              @FUNCTION=ATAN2
@SYNTAX=ATAN2(b1,b2)
@DESCRIPTION=ATAN2 function calculates the arc tangent of the two variables @b1 and @b2.  It is similar to calculating the arc tangent of @b2 / @b1, except that the signs of both arguments are used to determine the quadrant of the result.

* The result is in radians.
* This function is Excel compatible.

@EXAMPLES=
ATAN2(0.5,1.0) equals 1.107149.
ATAN2(-0.5,2.0) equals 1.815775.

@SEEALSO=ATAN, ATANH, COS, SIN, DEGREES, RADIANS @FUNCTION=ATANH
@SYNTAX=ATANH(x)
@DESCRIPTION=ATANH function calculates the inverse hyperbolic tangent of @x; that is the value whose hyperbolic tangent is @x.

* If the absolute value of @x is greater than 1.0, ATANH returns #NUM! error.
* This function is Excel compatible.

@EXAMPLES=
ATANH(0.5) equals 0.549306.
ATANH(0.8) equals 1.098612.

@SEEALSO=ATAN, TAN, SIN, COS, DEGREES, RADIANS @FUNCTION=BIN2DEC
@SYNTAX=BIN2DEC(x)
@DESCRIPTION=BIN2DEC function converts a binary number in string or number to its decimal equivalent.

* This function is Excel compatible.

@EXAMPLES=
BIN2DEC(101) equals 5.

@SEEALSO=DEC2BIN, BIN2OCT, BIN2HEX @FUNCTION=ERROR
@SYNTAX=ERROR(text)
@DESCRIPTION=ERROR return the specified error.

@EXAMPLES=
ERROR("#OWN ERROR").

@SEEALSO=ISERROR @FUNCTION=EXECSQL
@SYNTAX=EXECSQL(dsn,username,password,sql)
@DESCRIPTION=The EXECSQL function lets you execute a command in a database server, and show the results returned in current sheet. It uses libgda as the means for accessing the databases.
For using it, you need first to set up a libgda data source.
@EXAMPLES=
To get all the data from the table "Customers" present in the "mydatasource" GDA data source, you would use:
EXECSQL("mydatasource","username","password","SELECT * FROM customers")
@SEEALSO=READDBTABLE @FUNCTION=INT
@SYNTAX=INT(a)
@DESCRIPTION=INT function returns the largest integer that is not bigger than its argument.

* This function is Excel compatible.

@EXAMPLES=
INT(7.2) equals 7.
INT(-5.5) equals -6.

@SEEALSO=CEIL, CEILING, FLOOR, ABS, MOD @FUNCTION=LEFT
@SYNTAX=LEFT(text[,num_chars])
@DESCRIPTION=LEFT returns the leftmost @num_chars characters or the left character if @num_chars is not specified.

* This function is Excel compatible.

@EXAMPLES=
LEFT("Directory",3) equals "Dir".

@SEEALSO=MID, RIGHT @FUNCTION=TIME
@SYNTAX=TIME (hours,minutes,seconds)
@DESCRIPTION=TIME returns a fraction representing the time of day.

* This function is Excel compatible.

@EXAMPLES=
TIME(3, 5, 23) equals 3:05AM.

@SEEALSO=HOUR @FUNCTION=TIMEVALUE
@SYNTAX=TIMEVALUE (timetext)
@DESCRIPTION=TIMEVALUE returns a fraction representing the time of day, a number between 0 and 1.

* This function is Excel compatible.

@EXAMPLES=
TIMEVALUE("3:05") equals 0.128472.
TIMEVALUE("2:24:53 PM") equals 0.600613.

@SEEALSO=HOUR,MINUTE Project-Id-Version: gnumeric 0.99.0
Report-Msgid-Bugs-To: 
POT-Creation-Date: 2005-02-12 11:12-0500
PO-Revision-Date: 2005-01-19 18:06+0100
Last-Translator: Roy-Magne Mo <rmo@sunnmore.net>
Language-Team: Norwegian/Nynorsk <no@li.org>
MIME-Version: 1.0
Content-Type: text/plain; charset=UTF-8
Content-Transfer-Encoding: 8bit
 @FUNCTION=ATAN2
@SYNTAX=ATAN2(b1,b2)
@DESCRIPTION=ATAN2 funksjonen reknar ut arcustangens av dei to variablane @b2 / @b1. Dette tilsvarar å rekna ut arcustangens til @b2 / @b1, men forteikna til begge argumenta vert brukte til å avgjera kvadranten til resultatet. Resultatet er i radianar. Denne funksjonen er kompatibel med Excel
@EXAMPLES=
ATAN2(0.5,1.0) er lik 1.107149.
ATAN2(-0.5,2.0) er lik 1.815775.

@SEEALSO=ATAN, ATANH, COS, SIN, DEGREES, RADIANS @FUNCTION=ATANH
@SYNTAX=ATANH(x)
@DESCRIPTION=ATANH()-funksjonen reknar ut den inverse tangens hyperbolikus til @x, altså den verdien som har @x til tangens hyperbolikus. Dersom absoluttverdien av @x er større enn 1,0, returnerer atanh() NUM! -feil. Denne funksjonen er Excel-kompatibel.
@EXAMPLES=
ATANH(0.5)  er lik 0.549306.
ATANH(0.8)  er lik 1.098612.

@SEEALSO=ATAN, TAN, SIN, COS, DEGREES, RADIANS @FUNCTION=BIN2DEC
@SYNTAX=BIN2DEC(x)
@DESCRIPTION=BIN2DEC konverterar ein binærstreng eller tal til desimalrepresentasjonen av same streng.
Denne funksjonen er Excel kompatibel. 
@EXAMPLES=
BIN2DEC(101) er lik 5.

@SEEALSO=DEC2BIN, BIN2OCT, BIN2HEX @FUNCTION=ERROR
@SYNTAX=ERROR(tekst)
@DESCRIPTION=ERROR returnerar den spesifiserte feilmeldinga.
@EXAMPLES=
ERROR("#OWN ERROR").

@SEEALSO=ISERROR @FUNCTION=EXECSQL
@SYNTAX=EXECSQL(i)
@DESCRIPTION=EXECSQL-funksjonen let deg køyre ein kommando på ein
databasetenar, og returnerar resultatet i reknearket

@EXAMPLES=
@SEEALSO= @FUNCTION=INT
@SYNTAX=INT(a)
@DESCRIPTION=INT returnerar det største heiltalet som ikkje er høgare talet gitt som argument. Denne funksjonen er Excel kompatibel. 
@EXAMPLES=

INT(7,2) er lik 7.

INT(-5,5) er lik -6.

@SEEALSO=CEIL, CEILING, FLOOR, ABS, MOD @FUNCTION=LEFT
@SYNTAX=LEFT(tekst[,tal_på_teikn])
@DESCRIPTION=LEFT returnerar dei @num_chars teikn til venstre, eller teiknet lenggt til venstre dersom @num_chars ikkje er spesifisert.
Denne funksjonen er Excel-kompatibel. 
@EXAMPLES=
LEFT("Katalog";3) er lik "Kat".

@SEEALSO=MID, RIGHT @FUNCTION=TIME
@SYNTAX=TIME (timar;minutt;sekund)
@DESCRIPTION=TIME returnerar ein brøk som representerar tid på dagen.
Denne funksjonen er Excel-kompatibel. 
@EXAMPLES=
TIME(3; 5; 23) er lik 3:05.

@SEEALSO=HOUR @FUNCTION=TIMEVALUE
@SYNTAX=TIMEVALUE (tidstekst)
@DESCRIPTION=TIMEVALUE returnerar ein brøk som representerar tid på dagen, eit tal mellom 0 og 1.
Denne funksjonen er Excel kompatibel. 
@EXAMPLES=
TIMEVALUE("3:05") er lik 0,128472.
TIMEVALUE("2:24:53 PM") er lik 0,600613.

@SEEALSO=HOUR,MINUTE 