require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_UFS_FS_H)) {
    eval 'sub __LINUX_UFS_FS_H {1;}' unless defined(&__LINUX_UFS_FS_H);
    require 'linux/types.ph';
    require 'linux/kernel.ph';
    require 'linux/stat.ph';
    require 'linux/fs.ph';
    eval 'sub UFS_BBLOCK {0;}' unless defined(&UFS_BBLOCK);
    eval 'sub UFS_BBSIZE {8192;}' unless defined(&UFS_BBSIZE);
    eval 'sub UFS_SBLOCK {8192;}' unless defined(&UFS_SBLOCK);
    eval 'sub UFS_SBSIZE {8192;}' unless defined(&UFS_SBSIZE);
    eval 'sub UFS_SECTOR_SIZE {512;}' unless defined(&UFS_SECTOR_SIZE);
    eval 'sub UFS_SECTOR_BITS {9;}' unless defined(&UFS_SECTOR_BITS);
    eval 'sub UFS_MAGIC {0x11954;}' unless defined(&UFS_MAGIC);
    eval 'sub UFS2_MAGIC {0x19540119;}' unless defined(&UFS2_MAGIC);
    eval 'sub UFS_CIGAM {0x54190100;}' unless defined(&UFS_CIGAM);
    eval 'sub SBLOCK_FLOPPY {0;}' unless defined(&SBLOCK_FLOPPY);
    eval 'sub SBLOCK_UFS1 {8192;}' unless defined(&SBLOCK_UFS1);
    eval 'sub SBLOCK_UFS2 {65536;}' unless defined(&SBLOCK_UFS2);
    eval 'sub SBLOCK_PIGGY {262144;}' unless defined(&SBLOCK_PIGGY);
    eval 'sub SBLOCKSIZE {8192;}' unless defined(&SBLOCKSIZE);
    eval 'sub SBLOCKSEARCH {{  &SBLOCK_UFS2,  &SBLOCK_UFS1,  &SBLOCK_FLOPPY,  &SBLOCK_PIGGY, -1};}' unless defined(&SBLOCKSEARCH);
    eval 'sub UFS_MAGIC_LFN {0x95014;}' unless defined(&UFS_MAGIC_LFN);
    eval 'sub UFS_CIGAM_LFN {0x14500900;}' unless defined(&UFS_CIGAM_LFN);
    eval 'sub UFS_MAGIC_SEC {0x612195;}' unless defined(&UFS_MAGIC_SEC);
    eval 'sub UFS_CIGAM_SEC {0x95216100;}' unless defined(&UFS_CIGAM_SEC);
    eval 'sub UFS_MAGIC_FEA {0x195612;}' unless defined(&UFS_MAGIC_FEA);
    eval 'sub UFS_CIGAM_FEA {0x12561900;}' unless defined(&UFS_CIGAM_FEA);
    eval 'sub UFS_MAGIC_4GB {0x5231994;}' unless defined(&UFS_MAGIC_4GB);
    eval 'sub UFS_CIGAM_4GB {0x94192305;}' unless defined(&UFS_CIGAM_4GB);
    eval 'sub UFS_FSF_LFN {0x1;}' unless defined(&UFS_FSF_LFN);
    eval 'sub UFS_FSF_B1 {0x2;}' unless defined(&UFS_FSF_B1);
    eval 'sub UFS_FSF_LFS {0x2;}' unless defined(&UFS_FSF_LFS);
    eval 'sub UFS_FSF_LUID {0x4;}' unless defined(&UFS_FSF_LUID);
    eval 'sub UFS_BSIZE {8192;}' unless defined(&UFS_BSIZE);
    eval 'sub UFS_MINBSIZE {4096;}' unless defined(&UFS_MINBSIZE);
    eval 'sub UFS_FSIZE {1024;}' unless defined(&UFS_FSIZE);
    eval 'sub UFS_MAXFRAG {( &UFS_BSIZE /  &UFS_FSIZE);}' unless defined(&UFS_MAXFRAG);
    eval 'sub UFS_NDADDR {12;}' unless defined(&UFS_NDADDR);
    eval 'sub UFS_NINDIR {3;}' unless defined(&UFS_NINDIR);
    eval 'sub UFS_IND_BLOCK {( &UFS_NDADDR + 0);}' unless defined(&UFS_IND_BLOCK);
    eval 'sub UFS_DIND_BLOCK {( &UFS_NDADDR + 1);}' unless defined(&UFS_DIND_BLOCK);
    eval 'sub UFS_TIND_BLOCK {( &UFS_NDADDR + 2);}' unless defined(&UFS_TIND_BLOCK);
    eval 'sub UFS_NDIR_FRAGMENT {( &UFS_NDADDR <<  ($uspi->{s_fpbshift}));}' unless defined(&UFS_NDIR_FRAGMENT);
    eval 'sub UFS_IND_FRAGMENT {( &UFS_IND_BLOCK <<  ($uspi->{s_fpbshift}));}' unless defined(&UFS_IND_FRAGMENT);
    eval 'sub UFS_DIND_FRAGMENT {( &UFS_DIND_BLOCK <<  ($uspi->{s_fpbshift}));}' unless defined(&UFS_DIND_FRAGMENT);
    eval 'sub UFS_TIND_FRAGMENT {( &UFS_TIND_BLOCK <<  ($uspi->{s_fpbshift}));}' unless defined(&UFS_TIND_FRAGMENT);
    eval 'sub UFS_ROOTINO {2;}' unless defined(&UFS_ROOTINO);
    eval 'sub UFS_FIRST_INO {( &UFS_ROOTINO + 1);}' unless defined(&UFS_FIRST_INO);
    eval 'sub UFS_USEEFT {(( &__u16)65535);}' unless defined(&UFS_USEEFT);
    eval 'sub UFS_FSOK {0x7c269d38;}' unless defined(&UFS_FSOK);
    eval 'sub UFS_FSACTIVE {(( &__s8)0x);}' unless defined(&UFS_FSACTIVE);
    eval 'sub UFS_FSCLEAN {(( &__s8)0x1);}' unless defined(&UFS_FSCLEAN);
    eval 'sub UFS_FSSTABLE {(( &__s8)0x2);}' unless defined(&UFS_FSSTABLE);
    eval 'sub UFS_FSOSF1 {(( &__s8)0x3);}' unless defined(&UFS_FSOSF1);
    eval 'sub UFS_FSBAD {(( &__s8)0xff);}' unless defined(&UFS_FSBAD);
    eval 'sub UFS_DE_MASK {0x10;}' unless defined(&UFS_DE_MASK);
    eval 'sub UFS_DE_OLD {0x;}' unless defined(&UFS_DE_OLD);
    eval 'sub UFS_DE_44BSD {0x10;}' unless defined(&UFS_DE_44BSD);
    eval 'sub UFS_UID_MASK {0x60;}' unless defined(&UFS_UID_MASK);
    eval 'sub UFS_UID_OLD {0x;}' unless defined(&UFS_UID_OLD);
    eval 'sub UFS_UID_44BSD {0x20;}' unless defined(&UFS_UID_44BSD);
    eval 'sub UFS_UID_EFT {0x40;}' unless defined(&UFS_UID_EFT);
    eval 'sub UFS_ST_MASK {0x700;}' unless defined(&UFS_ST_MASK);
    eval 'sub UFS_ST_OLD {0x;}' unless defined(&UFS_ST_OLD);
    eval 'sub UFS_ST_44BSD {0x100;}' unless defined(&UFS_ST_44BSD);
    eval 'sub UFS_ST_SUN {0x200;}' unless defined(&UFS_ST_SUN);
    eval 'sub UFS_ST_SUNx86 {0x400;}' unless defined(&UFS_ST_SUNx86);
    eval 'sub UFS_CG_MASK {0x3000;}' unless defined(&UFS_CG_MASK);
    eval 'sub UFS_CG_OLD {0x;}' unless defined(&UFS_CG_OLD);
    eval 'sub UFS_CG_44BSD {0x2000;}' unless defined(&UFS_CG_44BSD);
    eval 'sub UFS_CG_SUN {0x1000;}' unless defined(&UFS_CG_SUN);
    eval 'sub UFS_TYPE_MASK {0x10000;}' unless defined(&UFS_TYPE_MASK);
    eval 'sub UFS_TYPE_UFS1 {0x;}' unless defined(&UFS_TYPE_UFS1);
    eval 'sub UFS_TYPE_UFS2 {0x10000;}' unless defined(&UFS_TYPE_UFS2);
    eval 'sub UFS_42INODEFMT {-1;}' unless defined(&UFS_42INODEFMT);
    eval 'sub UFS_44INODEFMT {2;}' unless defined(&UFS_44INODEFMT);
    eval 'sub UFS_MOUNT_ONERROR {0xf;}' unless defined(&UFS_MOUNT_ONERROR);
    eval 'sub UFS_MOUNT_ONERROR_PANIC {0x1;}' unless defined(&UFS_MOUNT_ONERROR_PANIC);
    eval 'sub UFS_MOUNT_ONERROR_LOCK {0x2;}' unless defined(&UFS_MOUNT_ONERROR_LOCK);
    eval 'sub UFS_MOUNT_ONERROR_UMOUNT {0x4;}' unless defined(&UFS_MOUNT_ONERROR_UMOUNT);
    eval 'sub UFS_MOUNT_ONERROR_REPAIR {0x8;}' unless defined(&UFS_MOUNT_ONERROR_REPAIR);
    eval 'sub UFS_MOUNT_UFSTYPE {0xfff0;}' unless defined(&UFS_MOUNT_UFSTYPE);
    eval 'sub UFS_MOUNT_UFSTYPE_OLD {0x10;}' unless defined(&UFS_MOUNT_UFSTYPE_OLD);
    eval 'sub UFS_MOUNT_UFSTYPE_44BSD {0x20;}' unless defined(&UFS_MOUNT_UFSTYPE_44BSD);
    eval 'sub UFS_MOUNT_UFSTYPE_SUN {0x40;}' unless defined(&UFS_MOUNT_UFSTYPE_SUN);
    eval 'sub UFS_MOUNT_UFSTYPE_NEXTSTEP {0x80;}' unless defined(&UFS_MOUNT_UFSTYPE_NEXTSTEP);
    eval 'sub UFS_MOUNT_UFSTYPE_NEXTSTEP_CD {0x100;}' unless defined(&UFS_MOUNT_UFSTYPE_NEXTSTEP_CD);
    eval 'sub UFS_MOUNT_UFSTYPE_OPENSTEP {0x200;}' unless defined(&UFS_MOUNT_UFSTYPE_OPENSTEP);
    eval 'sub UFS_MOUNT_UFSTYPE_SUNx86 {0x400;}' unless defined(&UFS_MOUNT_UFSTYPE_SUNx86);
    eval 'sub UFS_MOUNT_UFSTYPE_HP {0x800;}' unless defined(&UFS_MOUNT_UFSTYPE_HP);
    eval 'sub UFS_MOUNT_UFSTYPE_UFS2 {0x1000;}' unless defined(&UFS_MOUNT_UFSTYPE_UFS2);
    eval 'sub ufs_clear_opt {
        my($o,$opt) = @_;
	    eval q($o &= ~ &UFS_MOUNT_$opt);
    }' unless defined(&ufs_clear_opt);
    eval 'sub ufs_set_opt {
        my($o,$opt) = @_;
	    eval q($o |=  &UFS_MOUNT_$opt);
    }' unless defined(&ufs_set_opt);
    eval 'sub ufs_test_opt {
        my($o,$opt) = @_;
	    eval q((($o) &  &UFS_MOUNT_$opt));
    }' unless defined(&ufs_test_opt);
    eval 'sub UFS_MINFREE {5;}' unless defined(&UFS_MINFREE);
    eval 'sub UFS_DEFAULTOPT { &UFS_OPTTIME;}' unless defined(&UFS_DEFAULTOPT);
    if(defined(&CONFIG_UFS_DEBUG)) {
	eval 'sub UFSD {( &f,  &a...) {  &printk ("UFSD (%s, %d): %s:",  &__FILE__,  &__LINE__,  &__FUNCTION__);  &printk ( &f,   &a); };}' unless defined(&UFSD);
    } else {
	eval 'sub UFSD {( &f,  &a...);}' unless defined(&UFSD);
    }
    eval 'sub ufs_fsbtodb {
        my($uspi, $b) = @_;
	    eval q((($b) << ($uspi)-> &s_fsbtodb));
    }' unless defined(&ufs_fsbtodb);
    eval 'sub ufs_dbtofsb {
        my($uspi, $b) = @_;
	    eval q((($b) >> ($uspi)-> &s_fsbtodb));
    }' unless defined(&ufs_dbtofsb);
    eval 'sub ufs_cgbase {
        my($c) = @_;
	    eval q(( ($uspi->{s_fpg}) * ($c)));
    }' unless defined(&ufs_cgbase);
    eval 'sub ufs_cgstart {
        my($c) = @_;
	    eval q((( &uspi)-> &fs_magic ==  &UFS2_MAGIC ?  &ufs_cgbase($c) : ( &ufs_cgbase($c) +  ($uspi->{s_cgoffset}) * (($c) & ~ ($uspi->{s_cgmask})))));
    }' unless defined(&ufs_cgstart);
    eval 'sub ufs_cgsblock {
        my($c) = @_;
	    eval q(( &ufs_cgstart($c) +  ($uspi->{s_sblkno})));
    }' unless defined(&ufs_cgsblock);
    eval 'sub ufs_cgcmin {
        my($c) = @_;
	    eval q(( &ufs_cgstart($c) +  ($uspi->{s_cblkno})));
    }' unless defined(&ufs_cgcmin);
    eval 'sub ufs_cgimin {
        my($c) = @_;
	    eval q(( &ufs_cgstart($c) +  ($uspi->{s_iblkno})));
    }' unless defined(&ufs_cgimin);
    eval 'sub ufs_cgdmin {
        my($c) = @_;
	    eval q(( &ufs_cgstart($c) +  ($uspi->{s_dblkno})));
    }' unless defined(&ufs_cgdmin);
    eval 'sub ufs_inotocg {
        my($x) = @_;
	    eval q((($x) /  ($uspi->{s_ipg})));
    }' unless defined(&ufs_inotocg);
    eval 'sub ufs_inotocgoff {
        my($x) = @_;
	    eval q((($x) %  ($uspi->{s_ipg})));
    }' unless defined(&ufs_inotocgoff);
    eval 'sub ufs_inotofsba {
        my($x) = @_;
	    eval q(((( &u64) &ufs_cgimin( &ufs_inotocg($x))) +  &ufs_inotocgoff($x) /  ($uspi->{s_inopf})));
    }' unless defined(&ufs_inotofsba);
    eval 'sub ufs_inotofsbo {
        my($x) = @_;
	    eval q((($x) %  ($uspi->{s_inopf})));
    }' unless defined(&ufs_inotofsbo);
    eval 'sub ufs_cbtocylno {
        my($bno) = @_;
	    eval q((($bno) *  ($uspi->{s_nspf}) /  ($uspi->{s_spc})));
    }' unless defined(&ufs_cbtocylno);
    eval 'sub ufs_cbtorpos {
        my($bno) = @_;
	    eval q((((($bno) *  ($uspi->{s_nspf}) %  ($uspi->{s_spc}) /  ($uspi->{s_nsect})  *  ($uspi->{s_trackskew}) + ($bno) *  ($uspi->{s_nspf}) %  ($uspi->{s_spc})  %  ($uspi->{s_nsect}) *  ($uspi->{s_interleave})) %  ($uspi->{s_nsect})  *  ($uspi->{s_nrpos})) /  ($uspi->{s_npsect})));
    }' unless defined(&ufs_cbtorpos);
    eval 'sub ufs_blkoff {
        my($loc) = @_;
	    eval q((($loc) &  ($uspi->{s_qbmask})));
    }' unless defined(&ufs_blkoff);
    eval 'sub ufs_fragoff {
        my($loc) = @_;
	    eval q((($loc) &  ($uspi->{s_qfmask})));
    }' unless defined(&ufs_fragoff);
    eval 'sub ufs_lblktosize {
        my($blk) = @_;
	    eval q((($blk) <<  ($uspi->{s_bshift})));
    }' unless defined(&ufs_lblktosize);
    eval 'sub ufs_lblkno {
        my($loc) = @_;
	    eval q((($loc) >>  ($uspi->{s_bshift})));
    }' unless defined(&ufs_lblkno);
    eval 'sub ufs_numfrags {
        my($loc) = @_;
	    eval q((($loc) >>  ($uspi->{s_fshift})));
    }' unless defined(&ufs_numfrags);
    eval 'sub ufs_blkroundup {
        my($size) = @_;
	    eval q(((($size) +  ($uspi->{s_qbmask})) &  ($uspi->{s_bmask})));
    }' unless defined(&ufs_blkroundup);
    eval 'sub ufs_fragroundup {
        my($size) = @_;
	    eval q(((($size) +  ($uspi->{s_qfmask})) &  ($uspi->{s_fmask})));
    }' unless defined(&ufs_fragroundup);
    eval 'sub ufs_fragstoblks {
        my($frags) = @_;
	    eval q((($frags) >>  ($uspi->{s_fpbshift})));
    }' unless defined(&ufs_fragstoblks);
    eval 'sub ufs_blkstofrags {
        my($blks) = @_;
	    eval q((($blks) <<  ($uspi->{s_fpbshift})));
    }' unless defined(&ufs_blkstofrags);
    eval 'sub ufs_fragnum {
        my($fsb) = @_;
	    eval q((($fsb) &  ($uspi->{s_fpbmask})));
    }' unless defined(&ufs_fragnum);
    eval 'sub ufs_blknum {
        my($fsb) = @_;
	    eval q((($fsb) & ~ ($uspi->{s_fpbmask})));
    }' unless defined(&ufs_blknum);
    eval 'sub UFS_MAXNAMLEN {255;}' unless defined(&UFS_MAXNAMLEN);
    eval 'sub UFS_MAXMNTLEN {512;}' unless defined(&UFS_MAXMNTLEN);
    eval 'sub UFS2_MAXMNTLEN {468;}' unless defined(&UFS2_MAXMNTLEN);
    eval 'sub UFS2_MAXVOLLEN {32;}' unless defined(&UFS2_MAXVOLLEN);
    eval 'sub UFS_MAXCSBUFS {31;}' unless defined(&UFS_MAXCSBUFS);
    eval 'sub UFS_LINK_MAX {32000;}' unless defined(&UFS_LINK_MAX);
    eval 'sub UFS2_NOCSPTRS {28;}' unless defined(&UFS2_NOCSPTRS);
    eval 'sub UFS_DIR_PAD {4;}' unless defined(&UFS_DIR_PAD);
    eval 'sub UFS_DIR_ROUND {( &UFS_DIR_PAD - 1);}' unless defined(&UFS_DIR_ROUND);
    eval 'sub UFS_DIR_REC_LEN {
        my($name_len) = @_;
	    eval q(((($name_len) + 1+ 8+  &UFS_DIR_ROUND) & ~ &UFS_DIR_ROUND));
    }' unless defined(&UFS_DIR_REC_LEN);
    eval 'sub UFS_UNCLEAN {0x1;}' unless defined(&UFS_UNCLEAN);
    eval 'sub UFS_DOSOFTDEP {0x2;}' unless defined(&UFS_DOSOFTDEP);
    eval 'sub UFS_NEEDSFSCK {0x4;}' unless defined(&UFS_NEEDSFSCK);
    eval 'sub UFS_INDEXDIRS {0x8;}' unless defined(&UFS_INDEXDIRS);
    eval 'sub UFS_ACLS {0x10;}' unless defined(&UFS_ACLS);
    eval 'sub UFS_MULTILABEL {0x20;}' unless defined(&UFS_MULTILABEL);
    eval 'sub UFS_FLAGS_UPDATED {0x80;}' unless defined(&UFS_FLAGS_UPDATED);
    if(0) {
    }
    eval 'sub UFS_OPTTIME {0;}' unless defined(&UFS_OPTTIME);
    eval 'sub UFS_OPTSPACE {1;}' unless defined(&UFS_OPTSPACE);
    eval 'sub UFS_42POSTBLFMT {-1;}' unless defined(&UFS_42POSTBLFMT);
    eval 'sub UFS_DYNAMICPOSTBLFMT {1;}' unless defined(&UFS_DYNAMICPOSTBLFMT);
    eval 'sub fs_cs {
        my($indx) = @_;
	    eval q( $s_csp[($indx)]);
    }' unless defined(&fs_cs);
    eval 'sub CG_MAGIC {0x90255;}' unless defined(&CG_MAGIC);
    eval 'sub ufs_cg_chkmagic {
        my($sb, $ucg) = @_;
	    eval q(( &fs32_to_cpu(($sb), ($ucg)-> &cg_magic) ==  &CG_MAGIC));
    }' unless defined(&ufs_cg_chkmagic);
    eval 'sub UFS_NXADDR {2;}' unless defined(&UFS_NXADDR);
    eval 'sub UFS_UF_SETTABLE {0xffff;}' unless defined(&UFS_UF_SETTABLE);
    eval 'sub UFS_UF_NODUMP {0x1;}' unless defined(&UFS_UF_NODUMP);
    eval 'sub UFS_UF_IMMUTABLE {0x2;}' unless defined(&UFS_UF_IMMUTABLE);
    eval 'sub UFS_UF_APPEND {0x4;}' unless defined(&UFS_UF_APPEND);
    eval 'sub UFS_UF_OPAQUE {0x8;}' unless defined(&UFS_UF_OPAQUE);
    eval 'sub UFS_UF_NOUNLINK {0x10;}' unless defined(&UFS_UF_NOUNLINK);
    eval 'sub UFS_SF_SETTABLE {0xffff0000;}' unless defined(&UFS_SF_SETTABLE);
    eval 'sub UFS_SF_ARCHIVED {0x10000;}' unless defined(&UFS_SF_ARCHIVED);
    eval 'sub UFS_SF_IMMUTABLE {0x20000;}' unless defined(&UFS_SF_IMMUTABLE);
    eval 'sub UFS_SF_APPEND {0x40000;}' unless defined(&UFS_SF_APPEND);
    eval 'sub UFS_SF_NOUNLINK {0x100000;}' unless defined(&UFS_SF_NOUNLINK);
}
1;
