require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_ATM_H)) {
    eval 'sub _LINUX_ATM_H {1;}' unless defined(&_LINUX_ATM_H);
    require 'linux/atmapi.ph';
    require 'linux/atmsap.ph';
    require 'linux/atmioc.ph';
    eval 'sub ATM_CELL_SIZE {53;}' unless defined(&ATM_CELL_SIZE);
    eval 'sub ATM_CELL_PAYLOAD {48;}' unless defined(&ATM_CELL_PAYLOAD);
    eval 'sub ATM_AAL0_SDU {52;}' unless defined(&ATM_AAL0_SDU);
    eval 'sub ATM_MAX_AAL34_PDU {65535;}' unless defined(&ATM_MAX_AAL34_PDU);
    eval 'sub ATM_AAL5_TRAILER {8;}' unless defined(&ATM_AAL5_TRAILER);
    eval 'sub ATM_MAX_AAL5_PDU {65535;}' unless defined(&ATM_MAX_AAL5_PDU);
    eval 'sub ATM_MAX_CDV {9999;}' unless defined(&ATM_MAX_CDV);
    eval 'sub ATM_NOT_RSV_VCI {32;}' unless defined(&ATM_NOT_RSV_VCI);
    eval 'sub ATM_MAX_VPI {255;}' unless defined(&ATM_MAX_VPI);
    eval 'sub ATM_MAX_VPI_NNI {4096;}' unless defined(&ATM_MAX_VPI_NNI);
    eval 'sub ATM_MAX_VCI {65535;}' unless defined(&ATM_MAX_VCI);
    eval 'sub ATM_NO_AAL {0;}' unless defined(&ATM_NO_AAL);
    eval 'sub ATM_AAL0 {13;}' unless defined(&ATM_AAL0);
    eval 'sub ATM_AAL1 {1;}' unless defined(&ATM_AAL1);
    eval 'sub ATM_AAL2 {2;}' unless defined(&ATM_AAL2);
    eval 'sub ATM_AAL34 {3;}' unless defined(&ATM_AAL34);
    eval 'sub ATM_AAL5 {5;}' unless defined(&ATM_AAL5);
    eval 'sub __SO_ENCODE {
        my($l,$n,$t) = @_;
	    eval q((((($l) & 0x1ff) << 22) | (($n) << 16) | $sizeof{$t}));
    }' unless defined(&__SO_ENCODE);
    eval 'sub __SO_LEVEL_MATCH {
        my($c,$m) = @_;
	    eval q(((($c) >> 22) == (($m) & 0x1ff)));
    }' unless defined(&__SO_LEVEL_MATCH);
    eval 'sub __SO_NUMBER {
        my($c) = @_;
	    eval q(((($c) >> 16) & 0x3f));
    }' unless defined(&__SO_NUMBER);
    eval 'sub __SO_SIZE {
        my($c) = @_;
	    eval q((($c) & 0x3fff));
    }' unless defined(&__SO_SIZE);
    eval 'sub SO_SETCLP { &__SO_ENCODE( &SOL_ATM,0,\'int\');}' unless defined(&SO_SETCLP);
    eval 'sub SO_CIRANGE { &__SO_ENCODE( &SOL_ATM,1,\'struct atm_cirange\');}' unless defined(&SO_CIRANGE);
    eval 'sub SO_ATMQOS { &__SO_ENCODE( &SOL_ATM,2,\'struct atm_qos\');}' unless defined(&SO_ATMQOS);
    eval 'sub SO_ATMSAP { &__SO_ENCODE( &SOL_ATM,3,\'struct atm_sap\');}' unless defined(&SO_ATMSAP);
    eval 'sub SO_ATMPVC { &__SO_ENCODE( &SOL_ATM,4,\'struct sockaddr_atmpvc\');}' unless defined(&SO_ATMPVC);
    eval 'sub SO_MULTIPOINT { &__SO_ENCODE( &SOL_ATM, 5, \'int\');}' unless defined(&SO_MULTIPOINT);
    eval 'sub ATM_HDR_GFC_MASK {0xf0000000;}' unless defined(&ATM_HDR_GFC_MASK);
    eval 'sub ATM_HDR_GFC_SHIFT {28;}' unless defined(&ATM_HDR_GFC_SHIFT);
    eval 'sub ATM_HDR_VPI_MASK {0xff00000;}' unless defined(&ATM_HDR_VPI_MASK);
    eval 'sub ATM_HDR_VPI_SHIFT {20;}' unless defined(&ATM_HDR_VPI_SHIFT);
    eval 'sub ATM_HDR_VCI_MASK {0xffff0;}' unless defined(&ATM_HDR_VCI_MASK);
    eval 'sub ATM_HDR_VCI_SHIFT {4;}' unless defined(&ATM_HDR_VCI_SHIFT);
    eval 'sub ATM_HDR_PTI_MASK {0xe;}' unless defined(&ATM_HDR_PTI_MASK);
    eval 'sub ATM_HDR_PTI_SHIFT {1;}' unless defined(&ATM_HDR_PTI_SHIFT);
    eval 'sub ATM_HDR_CLP {0x1;}' unless defined(&ATM_HDR_CLP);
    eval 'sub ATM_PTI_US0 {0;}' unless defined(&ATM_PTI_US0);
    eval 'sub ATM_PTI_US1 {1;}' unless defined(&ATM_PTI_US1);
    eval 'sub ATM_PTI_UCES0 {2;}' unless defined(&ATM_PTI_UCES0);
    eval 'sub ATM_PTI_UCES1 {3;}' unless defined(&ATM_PTI_UCES1);
    eval 'sub ATM_PTI_SEGF5 {4;}' unless defined(&ATM_PTI_SEGF5);
    eval 'sub ATM_PTI_E2EF5 {5;}' unless defined(&ATM_PTI_E2EF5);
    eval 'sub ATM_PTI_RSV_RM {6;}' unless defined(&ATM_PTI_RSV_RM);
    eval 'sub ATM_PTI_RSV {7;}' unless defined(&ATM_PTI_RSV);
    eval 'sub ATM_NONE {0;}' unless defined(&ATM_NONE);
    eval 'sub ATM_UBR {1;}' unless defined(&ATM_UBR);
    eval 'sub ATM_CBR {2;}' unless defined(&ATM_CBR);
    eval 'sub ATM_VBR {3;}' unless defined(&ATM_VBR);
    eval 'sub ATM_ABR {4;}' unless defined(&ATM_ABR);
    eval 'sub ATM_ANYCLASS {5;}' unless defined(&ATM_ANYCLASS);
    eval 'sub ATM_MAX_PCR {-1;}' unless defined(&ATM_MAX_PCR);
    eval 'sub ATM_ITF_ANY {-1;}' unless defined(&ATM_ITF_ANY);
    eval 'sub ATM_VPI_ANY {-1;}' unless defined(&ATM_VPI_ANY);
    eval 'sub ATM_VCI_ANY {-1;}' unless defined(&ATM_VCI_ANY);
    eval 'sub ATM_VPI_UNSPEC {-2;}' unless defined(&ATM_VPI_UNSPEC);
    eval 'sub ATM_VCI_UNSPEC {-2;}' unless defined(&ATM_VCI_UNSPEC);
    eval 'sub ATM_ESA_LEN {20;}' unless defined(&ATM_ESA_LEN);
    eval 'sub ATM_E164_LEN {12;}' unless defined(&ATM_E164_LEN);
    eval 'sub ATM_AFI_DCC {0x39;}' unless defined(&ATM_AFI_DCC);
    eval 'sub ATM_AFI_ICD {0x47;}' unless defined(&ATM_AFI_ICD);
    eval 'sub ATM_AFI_E164 {0x45;}' unless defined(&ATM_AFI_E164);
    eval 'sub ATM_AFI_LOCAL {0x49;}' unless defined(&ATM_AFI_LOCAL);
    eval 'sub ATM_AFI_DCC_GROUP {0xbd;}' unless defined(&ATM_AFI_DCC_GROUP);
    eval 'sub ATM_AFI_ICD_GROUP {0xc5;}' unless defined(&ATM_AFI_ICD_GROUP);
    eval 'sub ATM_AFI_E164_GROUP {0xc3;}' unless defined(&ATM_AFI_E164_GROUP);
    eval 'sub ATM_AFI_LOCAL_GROUP {0xc7;}' unless defined(&ATM_AFI_LOCAL_GROUP);
    eval 'sub ATM_LIJ_NONE {0;}' unless defined(&ATM_LIJ_NONE);
    eval 'sub ATM_LIJ {1;}' unless defined(&ATM_LIJ);
    eval 'sub ATM_LIJ_RPJ {2;}' unless defined(&ATM_LIJ_RPJ);
    eval 'sub ATM_LIJ_NJ {3;}' unless defined(&ATM_LIJ_NJ);
    eval 'sub atmsvc_addr_in_use {
        my($addr) = @_;
	    eval q({ * ($addr->{sas_addr}->{prv}) || * ($addr->{sas_addr}->{pub}); });
    }' unless defined(&atmsvc_addr_in_use);
    eval 'sub atmpvc_addr_in_use {
        my($addr) = @_;
	    eval q({  ($addr->{sap_addr}->{itf}) ||  ($addr->{sap_addr}->{vpi}) ||  ($addr->{sap_addr}->{vci}); });
    }' unless defined(&atmpvc_addr_in_use);
}
1;
