require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_IA64_INTRINSICS_H)) {
    eval 'sub _ASM_IA64_INTRINSICS_H {1;}' unless defined(&_ASM_IA64_INTRINSICS_H);
    unless(defined(&__ASSEMBLY__)) {
	require 'asm/ia64regs.ph';
	if(defined(&__INTEL_COMPILER)) {
	    require 'asm/intel_intrin.ph';
	} else {
	    require 'asm/gcc_intrin.ph';
	}
	eval 'sub IA64_FETCHADD {
	    my($tmp,$v,$n,$sz,$sem) = @_;
    	    eval q(({  &switch ($sz) {  &case 4: $tmp =  &ia64_fetchadd4_$sem( $v, $n);  &break;  &case 8: $tmp =  &ia64_fetchadd8_$sem( $v, $n);  &break;  &default:  &__bad_size_for_ia64_fetch_and_add(); } }));
	}' unless defined(&IA64_FETCHADD);
	eval 'sub ia64_fetchadd {
	    my($i,$v,$sem) = @_;
    	    eval q(({  &__u64  &_tmp;  &volatile  &__typeof__(*($v)) * &_v = ($v);  &if (($i) == -16)  &IA64_FETCHADD( &_tmp,  &_v, -16, $sizeof{($v)}, $sem);  &else  &if (($i) == -8)  &IA64_FETCHADD( &_tmp,  &_v, -8, $sizeof{($v)}, $sem);  &else  &if (($i) == -4)  &IA64_FETCHADD( &_tmp,  &_v, -4, $sizeof{($v)}, $sem);  &else  &if (($i) == -1)  &IA64_FETCHADD( &_tmp,  &_v, -1, $sizeof{($v)}, $sem);  &else  &if (($i) == 1)  &IA64_FETCHADD( &_tmp,  &_v, 1, $sizeof{($v)}, $sem);  &else  &if (($i) == 4)  &IA64_FETCHADD( &_tmp,  &_v, 4, $sizeof{($v)}, $sem);  &else  &if (($i) == 8)  &IA64_FETCHADD( &_tmp,  &_v, 8, $sizeof{($v)}, $sem);  &else  &if (($i) == 16)  &IA64_FETCHADD( &_tmp,  &_v, 16, $sizeof{($v)}, $sem);  &else  &_tmp =  &__bad_increment_for_ia64_fetch_and_add(); ( &__typeof__(*($v))) ( &_tmp); }));
	}' unless defined(&ia64_fetchadd);
	eval 'sub ia64_fetch_and_add {
	    my($i,$v) = @_;
    	    eval q(( &ia64_fetchadd($i, $v,  &rel) + ($i)));
	}' unless defined(&ia64_fetch_and_add);
	eval 'sub __xchg {
	    my($x,$ptr,$size) = @_;
    	    eval q(({ \'unsigned long __xchg_result\';  &switch ($size) {  &case 1:  &__xchg_result =  &ia64_xchg1(( &__u8 *)$ptr, $x);  &break;  &case 2:  &__xchg_result =  &ia64_xchg2(( &__u16 *)$ptr, $x);  &break;  &case 4:  &__xchg_result =  &ia64_xchg4(( &__u32 *)$ptr, $x);  &break;  &case 8:  &__xchg_result =  &ia64_xchg8(( &__u64 *)$ptr, $x);  &break;  &default:  &ia64_xchg_called_with_bad_pointer(); }  &__xchg_result; }));
	}' unless defined(&__xchg);
	eval 'sub xchg {
	    my($ptr,$x) = @_;
    	    eval q((( &__typeof__(*($ptr)))  &__xchg ( ($x), ($ptr), $sizeof{($ptr)})));
	}' unless defined(&xchg);
	eval 'sub __HAVE_ARCH_CMPXCHG {1;}' unless defined(&__HAVE_ARCH_CMPXCHG);
	eval 'sub ia64_cmpxchg {
	    my($sem,$ptr,$old,$new,$size) = @_;
    	    eval q(({  &__u64  &_o_,  &_r_;  &switch ($size) {  &case 1:  &_o_ = ( &__u8 ) ($old);  &break;  &case 2:  &_o_ = ( &__u16) ($old);  &break;  &case 4:  &_o_ = ( &__u32) ($old);  &break;  &case 8:  &_o_ = ( &__u64) ($old);  &break;  &default:  &break; }  &switch ($size) {  &case 1:  &_r_ =  &ia64_cmpxchg1_$sem(( &__u8 *) $ptr, $new,  &_o_);  &break;  &case 2:  &_r_ =  &ia64_cmpxchg2_$sem(( &__u16 *) $ptr, $new,  &_o_);  &break;  &case 4:  &_r_ =  &ia64_cmpxchg4_$sem(( &__u32 *) $ptr, $new,  &_o_);  &break;  &case 8:  &_r_ =  &ia64_cmpxchg8_$sem(( &__u64 *) $ptr, $new,  &_o_);  &break;  &default:  &_r_ =  &ia64_cmpxchg_called_with_bad_pointer();  &break; } ( &__typeof__($old))  &_r_; }));
	}' unless defined(&ia64_cmpxchg);
	eval 'sub cmpxchg_acq {
	    my($ptr,$o,$n) = @_;
    	    eval q( &ia64_cmpxchg( &acq, ($ptr), ($o), ($n), $sizeof{($ptr)}));
	}' unless defined(&cmpxchg_acq);
	eval 'sub cmpxchg_rel {
	    my($ptr,$o,$n) = @_;
    	    eval q( &ia64_cmpxchg( &rel, ($ptr), ($o), ($n), $sizeof{($ptr)}));
	}' unless defined(&cmpxchg_rel);
	eval 'sub cmpxchg {
	    my($ptr,$o,$n) = @_;
    	    eval q( &cmpxchg_acq($ptr,$o,$n));
	}' unless defined(&cmpxchg);
	if(defined(&CONFIG_IA64_DEBUG_CMPXCHG)) {
	    eval 'sub CMPXCHG_BUGCHECK_DECL {\'int\'  &_cmpxchg_bugcheck_count = 128;;}' unless defined(&CMPXCHG_BUGCHECK_DECL);
	    eval 'sub CMPXCHG_BUGCHECK {
	        my($v) = @_;
    		eval q( &do {  &if ( &_cmpxchg_bugcheck_count-- <= 0) {  &void * &ip;  &extern \'int\'  &printk( &const \'char\' * &fmt, ...);  &ip = ( &void *)  &ia64_getreg( &_IA64_REG_IP);  &printk(\\"CMPXCHG_BUGCHECK: stuck at %p on word %p\\\\n\\",  &ip, ($v));  &break; } }  &while (0));
	    }' unless defined(&CMPXCHG_BUGCHECK);
	} else {
	    eval 'sub CMPXCHG_BUGCHECK_DECL {1;}' unless defined(&CMPXCHG_BUGCHECK_DECL);
	    eval 'sub CMPXCHG_BUGCHECK {
	        my($v) = @_;
    		eval q();
	    }' unless defined(&CMPXCHG_BUGCHECK);
	}
    }
}
1;
