/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.OperaURLConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Hashtable;

class OperaInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 32768;
    private int protocolResponse = -1;
    private byte[] buffer = new byte[32768];
    private int nextRead = 0;
    private int lastAvail = -1;
    private int available = 0;
    private int totalInput = 0;
    private int contentLen = -1;
    private int streamId = -1;
    private boolean headerLoaded = false;
    private boolean eofState = false;
    protected Hashtable headerFields = new Hashtable();
    private OperaURLConnection connection;

    protected OperaInputStream(OperaURLConnection operaURLConnection) {
        this.connection = operaURLConnection;
    }

    public int getResponse() {
        return this.protocolResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            return this.available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            while (this.available == 0 && !this.eofState) {
                try {
                    this.starving();
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.eofState = true;
                    this.available = 0;
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            if (this.available == 0 && this.eofState) {
                this.buffer = null;
                return -1;
            }
            --this.available;
            if (this.nextRead == 32768) {
                this.nextRead = 0;
            }
            return 0xFF & this.buffer[this.nextRead++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void headerLoaded(int n, int n2) {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            if (n == 0) {
                n = -1;
            }
            this.contentLen = n;
            this.protocolResponse = n2;
            this.headerLoaded = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getContentLength() {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            while (!this.headerLoaded) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.contentLen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEOF() {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            this.eofState = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalStream() {
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addInput(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        OperaInputStream operaInputStream = this;
        synchronized (operaInputStream) {
            try {
                if (this.eofState) {
                    this.notifyAll();
                    return -1;
                }
                if (byArray.length > 0 && this.available < 32768) {
                    int n3 = 32768 - this.available;
                    if (this.lastAvail < Short.MAX_VALUE) {
                        n = byArray.length < 32768 - this.lastAvail ? byArray.length : 32768 - this.lastAvail - 1;
                        if (n > n3) {
                            n = n3;
                        }
                        System.arraycopy(byArray, 0, this.buffer, this.lastAvail + 1, n);
                    }
                    if ((n3 -= n) > 0) {
                        n2 = byArray.length - n > n3 ? n3 : byArray.length - n;
                        System.arraycopy(byArray, n, this.buffer, 0, n2);
                    }
                    this.lastAvail = (this.lastAvail + n + n2) % 32768;
                }
                this.notifyAll();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace(System.err);
            }
            this.available += n + n2;
            this.totalInput += n + n2;
            return n + n2;
        }
    }

    private native void starving();

    private void addHeader(String string, String string2) {
        this.headerFields.put(string.toLowerCase(), string2);
    }

    protected boolean isHeaderLoaded() {
        return this.headerLoaded;
    }

    protected native void stopLoading();

    private int writeReady() {
        return 32768 - this.available;
    }

    private void redirect(String string) {
        this.connection.redirect(string);
    }
}

