/*
 * libspe2 - A wrapper library to adapt the JSRE SPU usage model to SPUFS
 * Copyright (C) 2005 IBM Corp.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "elf_loader.h"
#include "spebase.h"

int _base_spe_program_load(spe_context_ptr_t spe, spe_program_handle_t *program)
{
	int rc,objfd;
	struct spe_ld_info ld_info;

	rc = load_spe_elf (program, spe->base_private->mem_mmap_base, &ld_info);
	if (rc != 0) {
		DEBUG_PRINTF ("Load SPE ELF failed..\n");
		return -1;
	}
	
	/* Register SPE image start address as "object-id" for oprofile.  */
	objfd = openat (spe->base_private->fd_spe_dir,"object-id", O_RDWR);
	if (objfd >= 0) {
		char buf[100];
		sprintf (buf, "%p", program->elf_image);
		write (objfd, buf, strlen (buf) + 1);
		close (objfd);
	}
	
	__spe_context_update_event();	

	spe->base_private->entry=ld_info.entry;
	
	return 0;
}
