%define release be0647.3.20061130
Name: libspe2
Version: 2.0.1
Release: %{release}
License: LGPL
Group: System Environment/Base
URL: http://www.bsc.es/projects/deepcomputing/linuxoncell
Source: http://www.bsc.es/projects/deepcomputing/linuxoncell/development/release2.0/libspe/%{name}-%{version}.tar.gz
Buildroot: %{_tmppath}/libspe
Exclusivearch: ppc ppc64 noarch
Summary: SPE Runtime Management Library

Patch1: initevent.diff
Patch2: event-public.diff
Patch3: make_speevent_thread-safe.diff

#
# List the packages used during the build
#
BuildPreReq: quilt

%ifarch noarch
%define sysroot %{nil}
%define set_optflags %{nil}
%else
%define sysroot %{nil}
%define set_optflags OPTFLAGS="%{optflags}"
%endif

%ifarch ppc
%define _libdir /usr/lib
%endif
%ifarch ppc64
%define _libdir /usr/lib64
%endif
%define _includedir2 /usr/spu/include

%define _initdir /etc/init.d
%define _unpackaged_files_terminate_build 0

%package devel
Summary: SPE Runtime Management Library
Group: Development/Libraries
Requires: %{name} = %{version}

%ifarch ppc
%package -n elfspe2
Summary: Helper for standalong SPE applications
Group: Applications/System
Requires: %{name} = %{version}
%endif

%description
SPE Runtime Management Library for the
Cell Broadband Engine Architecture.

%description devel
Header and object files for SPE Runtime
Management Library.

%ifarch ppc
%description -n elfspe2
This tool acts as a standalone loader for spe binaries.
%endif

%prep

%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
make SYSROOT=%{sysroot} %{set_optflags} prefix=%{_prefix} libdir=%{_libdir}
%ifarch ppc
make elfspe2-all SYSROOT=%{sysroot} %{set_optflags} prefix=%{_prefix} libdir=%{_libdir}
%endif

%install
rm -rf $RPM_BUILD_ROOT%{sysroot}

make install DESTDIR=$RPM_BUILD_ROOT SYSROOT=%{sysroot} prefix=%{_prefix} libdir=%{_libdir} speinclude=%{_includedir2}
%ifarch ppc
make elfspe2-install DESTDIR=$RPM_BUILD_ROOT SYSROOT=%{sysroot} prefix=%{_prefix} libdir=%{_libdir} speinclude=%{_includedir2}
%endif

mkdir -p $RPM_BUILD_ROOT%{sysroot}%{_initdir}
cat > $RPM_BUILD_ROOT%{sysroot}%{_initdir}/elfspe2 <<"EOF"
#!/bin/bash
#
#	/etc/rc.d/init.d/elfspe2
#
#	registers elfspe2 handler
#
# chkconfig: 345 1 1 
# description: executes elfspe2-register

# Source function library.
. /etc/init.d/functions


start() {
	echo -n "Starting elfspe2: "
	sh /usr/bin/elfspe2-register
	return 0
}	

stop() {
	echo -n "Shutting down elfspe2: "
	sh /usr/bin/elfspe2-unregister
	return 0
}

case "$1" in
    start)
	start
	;;
    stop)
	stop
	;;
    status)
	;;
    restart)
    	stop
	start
	;;
    reload)
	;;
    condrestart)
	[ -f /var/lock/subsys/elspe ] && restart || :
	;;
    *)
	echo "Usage: elfspe2 {start|stop|status|reload|restart"
	exit 1
	;;
esac
exit $?
EOF
chmod +x $RPM_BUILD_ROOT%{sysroot}%{_initdir}/elfspe2
				
%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%ifarch ppc_fixme
%preun -n elfspe2
[ -f %{_initdir}/elfspe2 ] && /sbin/chkconfig --del elfspe2

%post -n elfspe2
[ -f %{_initdir}/elfspe2 ] && /sbin/chkconfig --add elfspe2
[ -f %{_bindir}/elfspe2-register ] && %{_bindir}/elfspe2-register
%endif

%files
%defattr(-,root,root)
%{sysroot}%{_libdir}/*.so.*

%files devel
%defattr(-,root,root)
%{sysroot}%{_libdir}/*.so
%{sysroot}%{_libdir}/*.a
%{sysroot}%{_includedir}/*.h
%{sysroot}%{_includedir2}/*.h

%ifarch ppc
%files -n elfspe2
%defattr(-,root,root)
%{sysroot}%{_bindir}/elfspe2-register
%{sysroot}%{_bindir}/elfspe2-unregister
%{sysroot}%{_bindir}/elfspe2
%{sysroot}/etc/init.d/elfspe2
%endif

%changelog
* Thu Nov 24 2005 - Arnd Bergmann <arnd@arndb.de> 1.0.1-3
- initial spec file for fc5

