/*
 * libspe2 - A wrapper library to adapt the JSRE SPU usage model to SPUFS
 * Copyright (C) 2005 IBM Corp.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <errno.h>
#include <fcntl.h>
#include <unistd.h>

#include "create.h"
#include "mbox.h"

/**
 * SPE Mailbox Communication
 * -------------------------
 */


int _base_spe_out_mbox_read(spe_context_ptr_t spectx, 
                        unsigned int mbox_data[], 
                        int count)
{
	int rc;

	if (mbox_data == NULL || count < 1){
		errno = EINVAL;
		return -1;
	}

	rc = read(open_if_closed(spectx,FD_MBOX), mbox_data, count*4);
	if (rc != -1)
		rc /= 4;

	return rc;
}

int _base_spe_in_mbox_write(spe_context_ptr_t spectx, 
                        unsigned int mbox_data[], 
                        int count, 
                        int behavior_flag)
{
	int rc;
	
	rc = write(open_if_closed(spectx,FD_WBOX), mbox_data, 4);
	if (rc != -1)
		rc /= 4;

	return rc;
}

int _base_spe_in_mbox_status(spe_context_ptr_t spectx)
{
	int rc, ret;

	rc = read(open_if_closed(spectx,FD_WBOX_STAT), &ret, 4);
	if (rc != 4)
		ret = -1;

	return ret;
	
}

int _base_spe_out_mbox_status(spe_context_ptr_t spectx)
{
        int rc, ret;

        rc = read(open_if_closed(spectx,FD_MBOX_STAT), &ret, 4);
        if (rc != 4)
                ret = -1;

        return ret;
	
}

int _base_spe_out_intr_mbox_status(spe_context_ptr_t spectx)
{
        int rc, ret;

        rc = read(open_if_closed(spectx,FD_IBOX_STAT), &ret, 4);
        if (rc != 4)
                ret = -1;

        return ret;
}

int _base_spe_out_intr_mbox_read(spe_context_ptr_t spectx, 
                        unsigned int mbox_data[], 
                        int count, 
                        int behavior_flag)
{
	int rc;

	if (mbox_data == NULL || count < 1){
		errno = EINVAL;
		return -1;
	}

	rc = read(open_if_closed(spectx,FD_IBOX), mbox_data, count*4);
	if (rc != -1)
		rc /= 4;

	return rc;
}

 int _base_spe_signal_write(spe_context_ptr_t spectx, 
                        unsigned int signal_reg, 
                        unsigned int data )
{
	int rc;
		
	if (signal_reg == SPE_SIG_NOTIFY_REG_1)
		rc = write(open_if_closed(spectx,FD_SIG1), &data, 4);
	else if (signal_reg == SPE_SIG_NOTIFY_REG_2)
		rc = write(open_if_closed(spectx,FD_SIG2), &data, 4);
	else
		return -1;
	
	if (rc == 4)
		rc = 0;

	if (signal_reg == SPE_SIG_NOTIFY_REG_1)
		close_if_open(spectx,FD_SIG1);
	else if (signal_reg == SPE_SIG_NOTIFY_REG_2)
		close_if_open(spectx,FD_SIG2);

	return rc;
}


