/*
 *  Copyright 2006 Sony Corp.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <spu_mfcio.h>

#include "spe.h"

int
main (unsigned long long spe_id, unsigned long long argp)
{
	struct dma_packet dma_packet;
	enum {tag = 1};

	mfc_get(&dma_packet, argp, sizeof(struct dma_packet), tag, 0 ,0);
	mfc_write_tag_mask(1 << tag);
	mfc_read_tag_status_all();

	printf("spu_%llx: got value %llu, text '%s' \n", spe_id, dma_packet.value,
		dma_packet.text);

	return 0;
}

