/*
 *  Copyright 2006 Sony Corp.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <libspe.h>

extern spe_program_handle_t spe_entry;

enum {ctx_count = 35};

speid_t ids[ctx_count];

int
main (void)
{
	unsigned int i;
	unsigned int result = 0;


	fprintf(stderr, "creating %u spe contexts\n", ctx_count);
	fflush(stderr);

	for(i = 0; i < ctx_count; i++) {
		ids[i] = spe_create_thread(0, &spe_entry, NULL, NULL, -1, 0);

		if(ids[i]) {
			fprintf(stderr, "create spe_%lx success\n",
				(unsigned long)ids[i]);
			fflush(stderr);
		} else {
			result++;
			fprintf(stderr, "create failed: %s (%d)\n",
				strerror(errno), errno);
			fflush(stderr);
		}
	}

	for(i = 0; i < ctx_count; i++) {
		int status;

		if(!ids[i])
			continue;

		spe_wait(ids[i], &status, 0);

		result += status;

		fprintf(stderr, "wait spe_%lx: %s\n",
			(unsigned long)ids[i],
			(status ? "failed" : "success"));
		fflush(stderr);
	}

	fprintf(stderr, "done (%u contexts) %s\n", ctx_count,
		(result ? "failed" : "success"));

	return 0;
}
