/*
 *  Copyright 2006 Sony Corp.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <libspe.h>

#include "spe/spe.h"

int
main (void)
{
	extern spe_program_handle_t spe_entry;
	int status;
	speid_t spe_id;
	struct dma_packet dma_packet;

	dma_packet.value = 155;
	strcpy(dma_packet.text, "msg from ppe");

	spe_id = spe_create_thread(0, &spe_entry,
		(unsigned long long *)&dma_packet, NULL, -1, 0);

	if(spe_id) {
		fprintf(stderr, "create spe_%lx success\n",
			(unsigned long)spe_id);
		fflush(stderr);
	} else {
		fprintf(stderr, "create failed: %s (%d)\n",
			strerror(errno), errno);
		return -1;
	}

	spe_wait(spe_id, &status, 0);

	fprintf(stderr, "wait spe_%lx: %s\n", (unsigned long)spe_id,
		(status ? "failed" : "success"));

	return 0;
}
