// ------------------------------------------------------------------
// Copyright (c) 2004-2007 Atheros Corporation.  All rights reserved.
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation;
//
// Software distributed under the License is distributed on an "AS
// IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
// implied. See the License for the specific language governing
// rights and limitations under the License.
//
//
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Atheros"
//===================================================================


#ifndef _MAC_PCU_REG_H_
#define _MAC_PCU_REG_H_

#define MAC_PCU_STA_ADDR_L32_ADDRESS             0x00008000
#define MAC_PCU_STA_ADDR_L32_OFFSET              0x00000000
#define MAC_PCU_STA_ADDR_L32_ADDR_31_0_MSB       31
#define MAC_PCU_STA_ADDR_L32_ADDR_31_0_LSB       0
#define MAC_PCU_STA_ADDR_L32_ADDR_31_0_MASK      0xffffffff
#define MAC_PCU_STA_ADDR_L32_ADDR_31_0_GET(x)    (((x) & MAC_PCU_STA_ADDR_L32_ADDR_31_0_MASK) >> MAC_PCU_STA_ADDR_L32_ADDR_31_0_LSB)
#define MAC_PCU_STA_ADDR_L32_ADDR_31_0_SET(x)    (((x) << MAC_PCU_STA_ADDR_L32_ADDR_31_0_LSB) & MAC_PCU_STA_ADDR_L32_ADDR_31_0_MASK)

#define MAC_PCU_STA_ADDR_U16_ADDRESS             0x00008004
#define MAC_PCU_STA_ADDR_U16_OFFSET              0x00000004
#define MAC_PCU_STA_ADDR_U16_ADHOC_MCAST_SEARCH_MSB 31
#define MAC_PCU_STA_ADDR_U16_ADHOC_MCAST_SEARCH_LSB 31
#define MAC_PCU_STA_ADDR_U16_ADHOC_MCAST_SEARCH_MASK 0x80000000
#define MAC_PCU_STA_ADDR_U16_ADHOC_MCAST_SEARCH_GET(x) (((x) & MAC_PCU_STA_ADDR_U16_ADHOC_MCAST_SEARCH_MASK) >> MAC_PCU_STA_ADDR_U16_ADHOC_MCAST_SEARCH_LSB)
#define MAC_PCU_STA_ADDR_U16_ADHOC_MCAST_SEARCH_SET(x) (((x) << MAC_PCU_STA_ADDR_U16_ADHOC_MCAST_SEARCH_LSB) & MAC_PCU_STA_ADDR_U16_ADHOC_MCAST_SEARCH_MASK)
#define MAC_PCU_STA_ADDR_U16_CBCIV_ENDIAN_MSB    30
#define MAC_PCU_STA_ADDR_U16_CBCIV_ENDIAN_LSB    30
#define MAC_PCU_STA_ADDR_U16_CBCIV_ENDIAN_MASK   0x40000000
#define MAC_PCU_STA_ADDR_U16_CBCIV_ENDIAN_GET(x) (((x) & MAC_PCU_STA_ADDR_U16_CBCIV_ENDIAN_MASK) >> MAC_PCU_STA_ADDR_U16_CBCIV_ENDIAN_LSB)
#define MAC_PCU_STA_ADDR_U16_CBCIV_ENDIAN_SET(x) (((x) << MAC_PCU_STA_ADDR_U16_CBCIV_ENDIAN_LSB) & MAC_PCU_STA_ADDR_U16_CBCIV_ENDIAN_MASK)
#define MAC_PCU_STA_ADDR_U16_PRESERVE_SEQNUM_MSB 29
#define MAC_PCU_STA_ADDR_U16_PRESERVE_SEQNUM_LSB 29
#define MAC_PCU_STA_ADDR_U16_PRESERVE_SEQNUM_MASK 0x20000000
#define MAC_PCU_STA_ADDR_U16_PRESERVE_SEQNUM_GET(x) (((x) & MAC_PCU_STA_ADDR_U16_PRESERVE_SEQNUM_MASK) >> MAC_PCU_STA_ADDR_U16_PRESERVE_SEQNUM_LSB)
#define MAC_PCU_STA_ADDR_U16_PRESERVE_SEQNUM_SET(x) (((x) << MAC_PCU_STA_ADDR_U16_PRESERVE_SEQNUM_LSB) & MAC_PCU_STA_ADDR_U16_PRESERVE_SEQNUM_MASK)
#define MAC_PCU_STA_ADDR_U16_KSRCH_MODE_MSB      28
#define MAC_PCU_STA_ADDR_U16_KSRCH_MODE_LSB      28
#define MAC_PCU_STA_ADDR_U16_KSRCH_MODE_MASK     0x10000000
#define MAC_PCU_STA_ADDR_U16_KSRCH_MODE_GET(x)   (((x) & MAC_PCU_STA_ADDR_U16_KSRCH_MODE_MASK) >> MAC_PCU_STA_ADDR_U16_KSRCH_MODE_LSB)
#define MAC_PCU_STA_ADDR_U16_KSRCH_MODE_SET(x)   (((x) << MAC_PCU_STA_ADDR_U16_KSRCH_MODE_LSB) & MAC_PCU_STA_ADDR_U16_KSRCH_MODE_MASK)
#define MAC_PCU_STA_ADDR_U16_CRPT_MIC_ENABLE_MSB 27
#define MAC_PCU_STA_ADDR_U16_CRPT_MIC_ENABLE_LSB 27
#define MAC_PCU_STA_ADDR_U16_CRPT_MIC_ENABLE_MASK 0x08000000
#define MAC_PCU_STA_ADDR_U16_CRPT_MIC_ENABLE_GET(x) (((x) & MAC_PCU_STA_ADDR_U16_CRPT_MIC_ENABLE_MASK) >> MAC_PCU_STA_ADDR_U16_CRPT_MIC_ENABLE_LSB)
#define MAC_PCU_STA_ADDR_U16_CRPT_MIC_ENABLE_SET(x) (((x) << MAC_PCU_STA_ADDR_U16_CRPT_MIC_ENABLE_LSB) & MAC_PCU_STA_ADDR_U16_CRPT_MIC_ENABLE_MASK)
#define MAC_PCU_STA_ADDR_U16_SECTOR_SELF_GEN_MSB 26
#define MAC_PCU_STA_ADDR_U16_SECTOR_SELF_GEN_LSB 26
#define MAC_PCU_STA_ADDR_U16_SECTOR_SELF_GEN_MASK 0x04000000
#define MAC_PCU_STA_ADDR_U16_SECTOR_SELF_GEN_GET(x) (((x) & MAC_PCU_STA_ADDR_U16_SECTOR_SELF_GEN_MASK) >> MAC_PCU_STA_ADDR_U16_SECTOR_SELF_GEN_LSB)
#define MAC_PCU_STA_ADDR_U16_SECTOR_SELF_GEN_SET(x) (((x) << MAC_PCU_STA_ADDR_U16_SECTOR_SELF_GEN_LSB) & MAC_PCU_STA_ADDR_U16_SECTOR_SELF_GEN_MASK)
#define MAC_PCU_STA_ADDR_U16_BASE_RATE_11B_MSB   25
#define MAC_PCU_STA_ADDR_U16_BASE_RATE_11B_LSB   25
#define MAC_PCU_STA_ADDR_U16_BASE_RATE_11B_MASK  0x02000000
#define MAC_PCU_STA_ADDR_U16_BASE_RATE_11B_GET(x) (((x) & MAC_PCU_STA_ADDR_U16_BASE_RATE_11B_MASK) >> MAC_PCU_STA_ADDR_U16_BASE_RATE_11B_LSB)
#define MAC_PCU_STA_ADDR_U16_BASE_RATE_11B_SET(x) (((x) << MAC_PCU_STA_ADDR_U16_BASE_RATE_11B_LSB) & MAC_PCU_STA_ADDR_U16_BASE_RATE_11B_MASK)
#define MAC_PCU_STA_ADDR_U16_ACKCTS_6MB_MSB      24
#define MAC_PCU_STA_ADDR_U16_ACKCTS_6MB_LSB      24
#define MAC_PCU_STA_ADDR_U16_ACKCTS_6MB_MASK     0x01000000
#define MAC_PCU_STA_ADDR_U16_ACKCTS_6MB_GET(x)   (((x) & MAC_PCU_STA_ADDR_U16_ACKCTS_6MB_MASK) >> MAC_PCU_STA_ADDR_U16_ACKCTS_6MB_LSB)
#define MAC_PCU_STA_ADDR_U16_ACKCTS_6MB_SET(x)   (((x) << MAC_PCU_STA_ADDR_U16_ACKCTS_6MB_LSB) & MAC_PCU_STA_ADDR_U16_ACKCTS_6MB_MASK)
#define MAC_PCU_STA_ADDR_U16_RTS_USE_DEF_MSB     23
#define MAC_PCU_STA_ADDR_U16_RTS_USE_DEF_LSB     23
#define MAC_PCU_STA_ADDR_U16_RTS_USE_DEF_MASK    0x00800000
#define MAC_PCU_STA_ADDR_U16_RTS_USE_DEF_GET(x)  (((x) & MAC_PCU_STA_ADDR_U16_RTS_USE_DEF_MASK) >> MAC_PCU_STA_ADDR_U16_RTS_USE_DEF_LSB)
#define MAC_PCU_STA_ADDR_U16_RTS_USE_DEF_SET(x)  (((x) << MAC_PCU_STA_ADDR_U16_RTS_USE_DEF_LSB) & MAC_PCU_STA_ADDR_U16_RTS_USE_DEF_MASK)
#define MAC_PCU_STA_ADDR_U16_DEFANT_UPDATE_MSB   22
#define MAC_PCU_STA_ADDR_U16_DEFANT_UPDATE_LSB   22
#define MAC_PCU_STA_ADDR_U16_DEFANT_UPDATE_MASK  0x00400000
#define MAC_PCU_STA_ADDR_U16_DEFANT_UPDATE_GET(x) (((x) & MAC_PCU_STA_ADDR_U16_DEFANT_UPDATE_MASK) >> MAC_PCU_STA_ADDR_U16_DEFANT_UPDATE_LSB)
#define MAC_PCU_STA_ADDR_U16_DEFANT_UPDATE_SET(x) (((x) << MAC_PCU_STA_ADDR_U16_DEFANT_UPDATE_LSB) & MAC_PCU_STA_ADDR_U16_DEFANT_UPDATE_MASK)
#define MAC_PCU_STA_ADDR_U16_USE_DEFANT_MSB      21
#define MAC_PCU_STA_ADDR_U16_USE_DEFANT_LSB      21
#define MAC_PCU_STA_ADDR_U16_USE_DEFANT_MASK     0x00200000
#define MAC_PCU_STA_ADDR_U16_USE_DEFANT_GET(x)   (((x) & MAC_PCU_STA_ADDR_U16_USE_DEFANT_MASK) >> MAC_PCU_STA_ADDR_U16_USE_DEFANT_LSB)
#define MAC_PCU_STA_ADDR_U16_USE_DEFANT_SET(x)   (((x) << MAC_PCU_STA_ADDR_U16_USE_DEFANT_LSB) & MAC_PCU_STA_ADDR_U16_USE_DEFANT_MASK)
#define MAC_PCU_STA_ADDR_U16_PCF_MSB             20
#define MAC_PCU_STA_ADDR_U16_PCF_LSB             20
#define MAC_PCU_STA_ADDR_U16_PCF_MASK            0x00100000
#define MAC_PCU_STA_ADDR_U16_PCF_GET(x)          (((x) & MAC_PCU_STA_ADDR_U16_PCF_MASK) >> MAC_PCU_STA_ADDR_U16_PCF_LSB)
#define MAC_PCU_STA_ADDR_U16_PCF_SET(x)          (((x) << MAC_PCU_STA_ADDR_U16_PCF_LSB) & MAC_PCU_STA_ADDR_U16_PCF_MASK)
#define MAC_PCU_STA_ADDR_U16_KEYSRCH_DIS_MSB     19
#define MAC_PCU_STA_ADDR_U16_KEYSRCH_DIS_LSB     19
#define MAC_PCU_STA_ADDR_U16_KEYSRCH_DIS_MASK    0x00080000
#define MAC_PCU_STA_ADDR_U16_KEYSRCH_DIS_GET(x)  (((x) & MAC_PCU_STA_ADDR_U16_KEYSRCH_DIS_MASK) >> MAC_PCU_STA_ADDR_U16_KEYSRCH_DIS_LSB)
#define MAC_PCU_STA_ADDR_U16_KEYSRCH_DIS_SET(x)  (((x) << MAC_PCU_STA_ADDR_U16_KEYSRCH_DIS_LSB) & MAC_PCU_STA_ADDR_U16_KEYSRCH_DIS_MASK)
#define MAC_PCU_STA_ADDR_U16_PW_SAVE_MSB         18
#define MAC_PCU_STA_ADDR_U16_PW_SAVE_LSB         18
#define MAC_PCU_STA_ADDR_U16_PW_SAVE_MASK        0x00040000
#define MAC_PCU_STA_ADDR_U16_PW_SAVE_GET(x)      (((x) & MAC_PCU_STA_ADDR_U16_PW_SAVE_MASK) >> MAC_PCU_STA_ADDR_U16_PW_SAVE_LSB)
#define MAC_PCU_STA_ADDR_U16_PW_SAVE_SET(x)      (((x) << MAC_PCU_STA_ADDR_U16_PW_SAVE_LSB) & MAC_PCU_STA_ADDR_U16_PW_SAVE_MASK)
#define MAC_PCU_STA_ADDR_U16_ADHOC_MSB           17
#define MAC_PCU_STA_ADDR_U16_ADHOC_LSB           17
#define MAC_PCU_STA_ADDR_U16_ADHOC_MASK          0x00020000
#define MAC_PCU_STA_ADDR_U16_ADHOC_GET(x)        (((x) & MAC_PCU_STA_ADDR_U16_ADHOC_MASK) >> MAC_PCU_STA_ADDR_U16_ADHOC_LSB)
#define MAC_PCU_STA_ADDR_U16_ADHOC_SET(x)        (((x) << MAC_PCU_STA_ADDR_U16_ADHOC_LSB) & MAC_PCU_STA_ADDR_U16_ADHOC_MASK)
#define MAC_PCU_STA_ADDR_U16_STA_AP_MSB          16
#define MAC_PCU_STA_ADDR_U16_STA_AP_LSB          16
#define MAC_PCU_STA_ADDR_U16_STA_AP_MASK         0x00010000
#define MAC_PCU_STA_ADDR_U16_STA_AP_GET(x)       (((x) & MAC_PCU_STA_ADDR_U16_STA_AP_MASK) >> MAC_PCU_STA_ADDR_U16_STA_AP_LSB)
#define MAC_PCU_STA_ADDR_U16_STA_AP_SET(x)       (((x) << MAC_PCU_STA_ADDR_U16_STA_AP_LSB) & MAC_PCU_STA_ADDR_U16_STA_AP_MASK)
#define MAC_PCU_STA_ADDR_U16_ADDR_47_32_MSB      15
#define MAC_PCU_STA_ADDR_U16_ADDR_47_32_LSB      0
#define MAC_PCU_STA_ADDR_U16_ADDR_47_32_MASK     0x0000ffff
#define MAC_PCU_STA_ADDR_U16_ADDR_47_32_GET(x)   (((x) & MAC_PCU_STA_ADDR_U16_ADDR_47_32_MASK) >> MAC_PCU_STA_ADDR_U16_ADDR_47_32_LSB)
#define MAC_PCU_STA_ADDR_U16_ADDR_47_32_SET(x)   (((x) << MAC_PCU_STA_ADDR_U16_ADDR_47_32_LSB) & MAC_PCU_STA_ADDR_U16_ADDR_47_32_MASK)

#define MAC_PCU_BSSID_L32_ADDRESS                0x00008008
#define MAC_PCU_BSSID_L32_OFFSET                 0x00000008
#define MAC_PCU_BSSID_L32_ADDR_MSB               31
#define MAC_PCU_BSSID_L32_ADDR_LSB               0
#define MAC_PCU_BSSID_L32_ADDR_MASK              0xffffffff
#define MAC_PCU_BSSID_L32_ADDR_GET(x)            (((x) & MAC_PCU_BSSID_L32_ADDR_MASK) >> MAC_PCU_BSSID_L32_ADDR_LSB)
#define MAC_PCU_BSSID_L32_ADDR_SET(x)            (((x) << MAC_PCU_BSSID_L32_ADDR_LSB) & MAC_PCU_BSSID_L32_ADDR_MASK)

#define MAC_PCU_BSSID_U16_ADDRESS                0x0000800c
#define MAC_PCU_BSSID_U16_OFFSET                 0x0000000c
#define MAC_PCU_BSSID_U16_AID_MSB                26
#define MAC_PCU_BSSID_U16_AID_LSB                16
#define MAC_PCU_BSSID_U16_AID_MASK               0x07ff0000
#define MAC_PCU_BSSID_U16_AID_GET(x)             (((x) & MAC_PCU_BSSID_U16_AID_MASK) >> MAC_PCU_BSSID_U16_AID_LSB)
#define MAC_PCU_BSSID_U16_AID_SET(x)             (((x) << MAC_PCU_BSSID_U16_AID_LSB) & MAC_PCU_BSSID_U16_AID_MASK)
#define MAC_PCU_BSSID_U16_ADDR_MSB               15
#define MAC_PCU_BSSID_U16_ADDR_LSB               0
#define MAC_PCU_BSSID_U16_ADDR_MASK              0x0000ffff
#define MAC_PCU_BSSID_U16_ADDR_GET(x)            (((x) & MAC_PCU_BSSID_U16_ADDR_MASK) >> MAC_PCU_BSSID_U16_ADDR_LSB)
#define MAC_PCU_BSSID_U16_ADDR_SET(x)            (((x) << MAC_PCU_BSSID_U16_ADDR_LSB) & MAC_PCU_BSSID_U16_ADDR_MASK)

#define MAC_PCU_BCN_RSSI_AVE_ADDRESS             0x00008010
#define MAC_PCU_BCN_RSSI_AVE_OFFSET              0x00000010
#define MAC_PCU_BCN_RSSI_AVE_VALUE_MSB           11
#define MAC_PCU_BCN_RSSI_AVE_VALUE_LSB           0
#define MAC_PCU_BCN_RSSI_AVE_VALUE_MASK          0x00000fff
#define MAC_PCU_BCN_RSSI_AVE_VALUE_GET(x)        (((x) & MAC_PCU_BCN_RSSI_AVE_VALUE_MASK) >> MAC_PCU_BCN_RSSI_AVE_VALUE_LSB)
#define MAC_PCU_BCN_RSSI_AVE_VALUE_SET(x)        (((x) << MAC_PCU_BCN_RSSI_AVE_VALUE_LSB) & MAC_PCU_BCN_RSSI_AVE_VALUE_MASK)

#define MAC_PCU_ACK_CTS_TIMEOUT_ADDRESS          0x00008014
#define MAC_PCU_ACK_CTS_TIMEOUT_OFFSET           0x00000014
#define MAC_PCU_ACK_CTS_TIMEOUT_CTS_TIMEOUT_MSB  29
#define MAC_PCU_ACK_CTS_TIMEOUT_CTS_TIMEOUT_LSB  16
#define MAC_PCU_ACK_CTS_TIMEOUT_CTS_TIMEOUT_MASK 0x3fff0000
#define MAC_PCU_ACK_CTS_TIMEOUT_CTS_TIMEOUT_GET(x) (((x) & MAC_PCU_ACK_CTS_TIMEOUT_CTS_TIMEOUT_MASK) >> MAC_PCU_ACK_CTS_TIMEOUT_CTS_TIMEOUT_LSB)
#define MAC_PCU_ACK_CTS_TIMEOUT_CTS_TIMEOUT_SET(x) (((x) << MAC_PCU_ACK_CTS_TIMEOUT_CTS_TIMEOUT_LSB) & MAC_PCU_ACK_CTS_TIMEOUT_CTS_TIMEOUT_MASK)
#define MAC_PCU_ACK_CTS_TIMEOUT_ACK_TIMEOUT_MSB  13
#define MAC_PCU_ACK_CTS_TIMEOUT_ACK_TIMEOUT_LSB  0
#define MAC_PCU_ACK_CTS_TIMEOUT_ACK_TIMEOUT_MASK 0x00003fff
#define MAC_PCU_ACK_CTS_TIMEOUT_ACK_TIMEOUT_GET(x) (((x) & MAC_PCU_ACK_CTS_TIMEOUT_ACK_TIMEOUT_MASK) >> MAC_PCU_ACK_CTS_TIMEOUT_ACK_TIMEOUT_LSB)
#define MAC_PCU_ACK_CTS_TIMEOUT_ACK_TIMEOUT_SET(x) (((x) << MAC_PCU_ACK_CTS_TIMEOUT_ACK_TIMEOUT_LSB) & MAC_PCU_ACK_CTS_TIMEOUT_ACK_TIMEOUT_MASK)

#define MAC_PCU_BCN_RSSI_CTL_ADDRESS             0x00008018
#define MAC_PCU_BCN_RSSI_CTL_OFFSET              0x00000018
#define MAC_PCU_BCN_RSSI_CTL_RESET_MSB           29
#define MAC_PCU_BCN_RSSI_CTL_RESET_LSB           29
#define MAC_PCU_BCN_RSSI_CTL_RESET_MASK          0x20000000
#define MAC_PCU_BCN_RSSI_CTL_RESET_GET(x)        (((x) & MAC_PCU_BCN_RSSI_CTL_RESET_MASK) >> MAC_PCU_BCN_RSSI_CTL_RESET_LSB)
#define MAC_PCU_BCN_RSSI_CTL_RESET_SET(x)        (((x) << MAC_PCU_BCN_RSSI_CTL_RESET_LSB) & MAC_PCU_BCN_RSSI_CTL_RESET_MASK)
#define MAC_PCU_BCN_RSSI_CTL_WEIGHT_MSB          28
#define MAC_PCU_BCN_RSSI_CTL_WEIGHT_LSB          24
#define MAC_PCU_BCN_RSSI_CTL_WEIGHT_MASK         0x1f000000
#define MAC_PCU_BCN_RSSI_CTL_WEIGHT_GET(x)       (((x) & MAC_PCU_BCN_RSSI_CTL_WEIGHT_MASK) >> MAC_PCU_BCN_RSSI_CTL_WEIGHT_LSB)
#define MAC_PCU_BCN_RSSI_CTL_WEIGHT_SET(x)       (((x) << MAC_PCU_BCN_RSSI_CTL_WEIGHT_LSB) & MAC_PCU_BCN_RSSI_CTL_WEIGHT_MASK)
#define MAC_PCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_MSB 23
#define MAC_PCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_LSB 16
#define MAC_PCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_MASK 0x00ff0000
#define MAC_PCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_GET(x) (((x) & MAC_PCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_MASK) >> MAC_PCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_LSB)
#define MAC_PCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_SET(x) (((x) << MAC_PCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_LSB) & MAC_PCU_BCN_RSSI_CTL_RSSI_HIGH_THRESH_MASK)
#define MAC_PCU_BCN_RSSI_CTL_MISS_THRESH_MSB     15
#define MAC_PCU_BCN_RSSI_CTL_MISS_THRESH_LSB     8
#define MAC_PCU_BCN_RSSI_CTL_MISS_THRESH_MASK    0x0000ff00
#define MAC_PCU_BCN_RSSI_CTL_MISS_THRESH_GET(x)  (((x) & MAC_PCU_BCN_RSSI_CTL_MISS_THRESH_MASK) >> MAC_PCU_BCN_RSSI_CTL_MISS_THRESH_LSB)
#define MAC_PCU_BCN_RSSI_CTL_MISS_THRESH_SET(x)  (((x) << MAC_PCU_BCN_RSSI_CTL_MISS_THRESH_LSB) & MAC_PCU_BCN_RSSI_CTL_MISS_THRESH_MASK)
#define MAC_PCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_MSB 7
#define MAC_PCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_LSB 0
#define MAC_PCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_MASK 0x000000ff
#define MAC_PCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_GET(x) (((x) & MAC_PCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_MASK) >> MAC_PCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_LSB)
#define MAC_PCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_SET(x) (((x) << MAC_PCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_LSB) & MAC_PCU_BCN_RSSI_CTL_RSSI_LOW_THRESH_MASK)

#define MAC_PCU_USEC_LATENCY_ADDRESS             0x0000801c
#define MAC_PCU_USEC_LATENCY_OFFSET              0x0000001c
#define MAC_PCU_USEC_LATENCY_RX_LATENCY_MSB      28
#define MAC_PCU_USEC_LATENCY_RX_LATENCY_LSB      23
#define MAC_PCU_USEC_LATENCY_RX_LATENCY_MASK     0x1f800000
#define MAC_PCU_USEC_LATENCY_RX_LATENCY_GET(x)   (((x) & MAC_PCU_USEC_LATENCY_RX_LATENCY_MASK) >> MAC_PCU_USEC_LATENCY_RX_LATENCY_LSB)
#define MAC_PCU_USEC_LATENCY_RX_LATENCY_SET(x)   (((x) << MAC_PCU_USEC_LATENCY_RX_LATENCY_LSB) & MAC_PCU_USEC_LATENCY_RX_LATENCY_MASK)
#define MAC_PCU_USEC_LATENCY_TX_LATENCY_MSB      22
#define MAC_PCU_USEC_LATENCY_TX_LATENCY_LSB      14
#define MAC_PCU_USEC_LATENCY_TX_LATENCY_MASK     0x007fc000
#define MAC_PCU_USEC_LATENCY_TX_LATENCY_GET(x)   (((x) & MAC_PCU_USEC_LATENCY_TX_LATENCY_MASK) >> MAC_PCU_USEC_LATENCY_TX_LATENCY_LSB)
#define MAC_PCU_USEC_LATENCY_TX_LATENCY_SET(x)   (((x) << MAC_PCU_USEC_LATENCY_TX_LATENCY_LSB) & MAC_PCU_USEC_LATENCY_TX_LATENCY_MASK)
#define MAC_PCU_USEC_LATENCY_USEC_MSB            7
#define MAC_PCU_USEC_LATENCY_USEC_LSB            0
#define MAC_PCU_USEC_LATENCY_USEC_MASK           0x000000ff
#define MAC_PCU_USEC_LATENCY_USEC_GET(x)         (((x) & MAC_PCU_USEC_LATENCY_USEC_MASK) >> MAC_PCU_USEC_LATENCY_USEC_LSB)
#define MAC_PCU_USEC_LATENCY_USEC_SET(x)         (((x) << MAC_PCU_USEC_LATENCY_USEC_LSB) & MAC_PCU_USEC_LATENCY_USEC_MASK)

#define PCU_MAX_CFP_DUR_ADDRESS                  0x00008020
#define PCU_MAX_CFP_DUR_OFFSET                   0x00000020
#define PCU_MAX_CFP_DUR_VALUE_MSB                15
#define PCU_MAX_CFP_DUR_VALUE_LSB                0
#define PCU_MAX_CFP_DUR_VALUE_MASK               0x0000ffff
#define PCU_MAX_CFP_DUR_VALUE_GET(x)             (((x) & PCU_MAX_CFP_DUR_VALUE_MASK) >> PCU_MAX_CFP_DUR_VALUE_LSB)
#define PCU_MAX_CFP_DUR_VALUE_SET(x)             (((x) << PCU_MAX_CFP_DUR_VALUE_LSB) & PCU_MAX_CFP_DUR_VALUE_MASK)

#define MAC_PCU_RX_FILTER_ADDRESS                0x00008024
#define MAC_PCU_RX_FILTER_OFFSET                 0x00000024
#define MAC_PCU_RX_FILTER_GENERIC_FILTER_MSB     25
#define MAC_PCU_RX_FILTER_GENERIC_FILTER_LSB     24
#define MAC_PCU_RX_FILTER_GENERIC_FILTER_MASK    0x03000000
#define MAC_PCU_RX_FILTER_GENERIC_FILTER_GET(x)  (((x) & MAC_PCU_RX_FILTER_GENERIC_FILTER_MASK) >> MAC_PCU_RX_FILTER_GENERIC_FILTER_LSB)
#define MAC_PCU_RX_FILTER_GENERIC_FILTER_SET(x)  (((x) << MAC_PCU_RX_FILTER_GENERIC_FILTER_LSB) & MAC_PCU_RX_FILTER_GENERIC_FILTER_MASK)
#define MAC_PCU_RX_FILTER_GENERIC_FTYPE_MSB      23
#define MAC_PCU_RX_FILTER_GENERIC_FTYPE_LSB      18
#define MAC_PCU_RX_FILTER_GENERIC_FTYPE_MASK     0x00fc0000
#define MAC_PCU_RX_FILTER_GENERIC_FTYPE_GET(x)   (((x) & MAC_PCU_RX_FILTER_GENERIC_FTYPE_MASK) >> MAC_PCU_RX_FILTER_GENERIC_FTYPE_LSB)
#define MAC_PCU_RX_FILTER_GENERIC_FTYPE_SET(x)   (((x) << MAC_PCU_RX_FILTER_GENERIC_FTYPE_LSB) & MAC_PCU_RX_FILTER_GENERIC_FTYPE_MASK)
#define MAC_PCU_RX_FILTER_FROM_TO_DS_MSB         17
#define MAC_PCU_RX_FILTER_FROM_TO_DS_LSB         17
#define MAC_PCU_RX_FILTER_FROM_TO_DS_MASK        0x00020000
#define MAC_PCU_RX_FILTER_FROM_TO_DS_GET(x)      (((x) & MAC_PCU_RX_FILTER_FROM_TO_DS_MASK) >> MAC_PCU_RX_FILTER_FROM_TO_DS_LSB)
#define MAC_PCU_RX_FILTER_FROM_TO_DS_SET(x)      (((x) << MAC_PCU_RX_FILTER_FROM_TO_DS_LSB) & MAC_PCU_RX_FILTER_FROM_TO_DS_MASK)
#define MAC_PCU_RX_FILTER_RST_DLMTR_CNT_DISABLE_MSB 16
#define MAC_PCU_RX_FILTER_RST_DLMTR_CNT_DISABLE_LSB 16
#define MAC_PCU_RX_FILTER_RST_DLMTR_CNT_DISABLE_MASK 0x00010000
#define MAC_PCU_RX_FILTER_RST_DLMTR_CNT_DISABLE_GET(x) (((x) & MAC_PCU_RX_FILTER_RST_DLMTR_CNT_DISABLE_MASK) >> MAC_PCU_RX_FILTER_RST_DLMTR_CNT_DISABLE_LSB)
#define MAC_PCU_RX_FILTER_RST_DLMTR_CNT_DISABLE_SET(x) (((x) << MAC_PCU_RX_FILTER_RST_DLMTR_CNT_DISABLE_LSB) & MAC_PCU_RX_FILTER_RST_DLMTR_CNT_DISABLE_MASK)
#define MAC_PCU_RX_FILTER_MCAST_BCAST_ALL_MSB    15
#define MAC_PCU_RX_FILTER_MCAST_BCAST_ALL_LSB    15
#define MAC_PCU_RX_FILTER_MCAST_BCAST_ALL_MASK   0x00008000
#define MAC_PCU_RX_FILTER_MCAST_BCAST_ALL_GET(x) (((x) & MAC_PCU_RX_FILTER_MCAST_BCAST_ALL_MASK) >> MAC_PCU_RX_FILTER_MCAST_BCAST_ALL_LSB)
#define MAC_PCU_RX_FILTER_MCAST_BCAST_ALL_SET(x) (((x) << MAC_PCU_RX_FILTER_MCAST_BCAST_ALL_LSB) & MAC_PCU_RX_FILTER_MCAST_BCAST_ALL_MASK)
#define MAC_PCU_RX_FILTER_PS_POLL_MSB            14
#define MAC_PCU_RX_FILTER_PS_POLL_LSB            14
#define MAC_PCU_RX_FILTER_PS_POLL_MASK           0x00004000
#define MAC_PCU_RX_FILTER_PS_POLL_GET(x)         (((x) & MAC_PCU_RX_FILTER_PS_POLL_MASK) >> MAC_PCU_RX_FILTER_PS_POLL_LSB)
#define MAC_PCU_RX_FILTER_PS_POLL_SET(x)         (((x) << MAC_PCU_RX_FILTER_PS_POLL_LSB) & MAC_PCU_RX_FILTER_PS_POLL_MASK)
#define MAC_PCU_RX_FILTER_ASSUME_RADAR_MSB       13
#define MAC_PCU_RX_FILTER_ASSUME_RADAR_LSB       13
#define MAC_PCU_RX_FILTER_ASSUME_RADAR_MASK      0x00002000
#define MAC_PCU_RX_FILTER_ASSUME_RADAR_GET(x)    (((x) & MAC_PCU_RX_FILTER_ASSUME_RADAR_MASK) >> MAC_PCU_RX_FILTER_ASSUME_RADAR_LSB)
#define MAC_PCU_RX_FILTER_ASSUME_RADAR_SET(x)    (((x) << MAC_PCU_RX_FILTER_ASSUME_RADAR_LSB) & MAC_PCU_RX_FILTER_ASSUME_RADAR_MASK)
#define MAC_PCU_RX_FILTER_UNCOMPRESSED_BA_BAR_MSB 12
#define MAC_PCU_RX_FILTER_UNCOMPRESSED_BA_BAR_LSB 12
#define MAC_PCU_RX_FILTER_UNCOMPRESSED_BA_BAR_MASK 0x00001000
#define MAC_PCU_RX_FILTER_UNCOMPRESSED_BA_BAR_GET(x) (((x) & MAC_PCU_RX_FILTER_UNCOMPRESSED_BA_BAR_MASK) >> MAC_PCU_RX_FILTER_UNCOMPRESSED_BA_BAR_LSB)
#define MAC_PCU_RX_FILTER_UNCOMPRESSED_BA_BAR_SET(x) (((x) << MAC_PCU_RX_FILTER_UNCOMPRESSED_BA_BAR_LSB) & MAC_PCU_RX_FILTER_UNCOMPRESSED_BA_BAR_MASK)
#define MAC_PCU_RX_FILTER_COMPRESSED_BA_MSB      11
#define MAC_PCU_RX_FILTER_COMPRESSED_BA_LSB      11
#define MAC_PCU_RX_FILTER_COMPRESSED_BA_MASK     0x00000800
#define MAC_PCU_RX_FILTER_COMPRESSED_BA_GET(x)   (((x) & MAC_PCU_RX_FILTER_COMPRESSED_BA_MASK) >> MAC_PCU_RX_FILTER_COMPRESSED_BA_LSB)
#define MAC_PCU_RX_FILTER_COMPRESSED_BA_SET(x)   (((x) << MAC_PCU_RX_FILTER_COMPRESSED_BA_LSB) & MAC_PCU_RX_FILTER_COMPRESSED_BA_MASK)
#define MAC_PCU_RX_FILTER_COMPRESSED_BAR_MSB     10
#define MAC_PCU_RX_FILTER_COMPRESSED_BAR_LSB     10
#define MAC_PCU_RX_FILTER_COMPRESSED_BAR_MASK    0x00000400
#define MAC_PCU_RX_FILTER_COMPRESSED_BAR_GET(x)  (((x) & MAC_PCU_RX_FILTER_COMPRESSED_BAR_MASK) >> MAC_PCU_RX_FILTER_COMPRESSED_BAR_LSB)
#define MAC_PCU_RX_FILTER_COMPRESSED_BAR_SET(x)  (((x) << MAC_PCU_RX_FILTER_COMPRESSED_BAR_LSB) & MAC_PCU_RX_FILTER_COMPRESSED_BAR_MASK)
#define MAC_PCU_RX_FILTER_MY_BEACON_MSB          9
#define MAC_PCU_RX_FILTER_MY_BEACON_LSB          9
#define MAC_PCU_RX_FILTER_MY_BEACON_MASK         0x00000200
#define MAC_PCU_RX_FILTER_MY_BEACON_GET(x)       (((x) & MAC_PCU_RX_FILTER_MY_BEACON_MASK) >> MAC_PCU_RX_FILTER_MY_BEACON_LSB)
#define MAC_PCU_RX_FILTER_MY_BEACON_SET(x)       (((x) << MAC_PCU_RX_FILTER_MY_BEACON_LSB) & MAC_PCU_RX_FILTER_MY_BEACON_MASK)
#define MAC_PCU_RX_FILTER_SYNC_FRAME_MSB         8
#define MAC_PCU_RX_FILTER_SYNC_FRAME_LSB         8
#define MAC_PCU_RX_FILTER_SYNC_FRAME_MASK        0x00000100
#define MAC_PCU_RX_FILTER_SYNC_FRAME_GET(x)      (((x) & MAC_PCU_RX_FILTER_SYNC_FRAME_MASK) >> MAC_PCU_RX_FILTER_SYNC_FRAME_LSB)
#define MAC_PCU_RX_FILTER_SYNC_FRAME_SET(x)      (((x) << MAC_PCU_RX_FILTER_SYNC_FRAME_LSB) & MAC_PCU_RX_FILTER_SYNC_FRAME_MASK)
#define MAC_PCU_RX_FILTER_PROBE_REQ_MSB          7
#define MAC_PCU_RX_FILTER_PROBE_REQ_LSB          7
#define MAC_PCU_RX_FILTER_PROBE_REQ_MASK         0x00000080
#define MAC_PCU_RX_FILTER_PROBE_REQ_GET(x)       (((x) & MAC_PCU_RX_FILTER_PROBE_REQ_MASK) >> MAC_PCU_RX_FILTER_PROBE_REQ_LSB)
#define MAC_PCU_RX_FILTER_PROBE_REQ_SET(x)       (((x) << MAC_PCU_RX_FILTER_PROBE_REQ_LSB) & MAC_PCU_RX_FILTER_PROBE_REQ_MASK)
#define MAC_PCU_RX_FILTER_XR_POLL_MSB            6
#define MAC_PCU_RX_FILTER_XR_POLL_LSB            6
#define MAC_PCU_RX_FILTER_XR_POLL_MASK           0x00000040
#define MAC_PCU_RX_FILTER_XR_POLL_GET(x)         (((x) & MAC_PCU_RX_FILTER_XR_POLL_MASK) >> MAC_PCU_RX_FILTER_XR_POLL_LSB)
#define MAC_PCU_RX_FILTER_XR_POLL_SET(x)         (((x) << MAC_PCU_RX_FILTER_XR_POLL_LSB) & MAC_PCU_RX_FILTER_XR_POLL_MASK)
#define MAC_PCU_RX_FILTER_PROMISCUOUS_MSB        5
#define MAC_PCU_RX_FILTER_PROMISCUOUS_LSB        5
#define MAC_PCU_RX_FILTER_PROMISCUOUS_MASK       0x00000020
#define MAC_PCU_RX_FILTER_PROMISCUOUS_GET(x)     (((x) & MAC_PCU_RX_FILTER_PROMISCUOUS_MASK) >> MAC_PCU_RX_FILTER_PROMISCUOUS_LSB)
#define MAC_PCU_RX_FILTER_PROMISCUOUS_SET(x)     (((x) << MAC_PCU_RX_FILTER_PROMISCUOUS_LSB) & MAC_PCU_RX_FILTER_PROMISCUOUS_MASK)
#define MAC_PCU_RX_FILTER_BEACON_MSB             4
#define MAC_PCU_RX_FILTER_BEACON_LSB             4
#define MAC_PCU_RX_FILTER_BEACON_MASK            0x00000010
#define MAC_PCU_RX_FILTER_BEACON_GET(x)          (((x) & MAC_PCU_RX_FILTER_BEACON_MASK) >> MAC_PCU_RX_FILTER_BEACON_LSB)
#define MAC_PCU_RX_FILTER_BEACON_SET(x)          (((x) << MAC_PCU_RX_FILTER_BEACON_LSB) & MAC_PCU_RX_FILTER_BEACON_MASK)
#define MAC_PCU_RX_FILTER_CONTROL_MSB            3
#define MAC_PCU_RX_FILTER_CONTROL_LSB            3
#define MAC_PCU_RX_FILTER_CONTROL_MASK           0x00000008
#define MAC_PCU_RX_FILTER_CONTROL_GET(x)         (((x) & MAC_PCU_RX_FILTER_CONTROL_MASK) >> MAC_PCU_RX_FILTER_CONTROL_LSB)
#define MAC_PCU_RX_FILTER_CONTROL_SET(x)         (((x) << MAC_PCU_RX_FILTER_CONTROL_LSB) & MAC_PCU_RX_FILTER_CONTROL_MASK)
#define MAC_PCU_RX_FILTER_BROADCAST_MSB          2
#define MAC_PCU_RX_FILTER_BROADCAST_LSB          2
#define MAC_PCU_RX_FILTER_BROADCAST_MASK         0x00000004
#define MAC_PCU_RX_FILTER_BROADCAST_GET(x)       (((x) & MAC_PCU_RX_FILTER_BROADCAST_MASK) >> MAC_PCU_RX_FILTER_BROADCAST_LSB)
#define MAC_PCU_RX_FILTER_BROADCAST_SET(x)       (((x) << MAC_PCU_RX_FILTER_BROADCAST_LSB) & MAC_PCU_RX_FILTER_BROADCAST_MASK)
#define MAC_PCU_RX_FILTER_MULTICAST_MSB          1
#define MAC_PCU_RX_FILTER_MULTICAST_LSB          1
#define MAC_PCU_RX_FILTER_MULTICAST_MASK         0x00000002
#define MAC_PCU_RX_FILTER_MULTICAST_GET(x)       (((x) & MAC_PCU_RX_FILTER_MULTICAST_MASK) >> MAC_PCU_RX_FILTER_MULTICAST_LSB)
#define MAC_PCU_RX_FILTER_MULTICAST_SET(x)       (((x) << MAC_PCU_RX_FILTER_MULTICAST_LSB) & MAC_PCU_RX_FILTER_MULTICAST_MASK)
#define MAC_PCU_RX_FILTER_UNICAST_MSB            0
#define MAC_PCU_RX_FILTER_UNICAST_LSB            0
#define MAC_PCU_RX_FILTER_UNICAST_MASK           0x00000001
#define MAC_PCU_RX_FILTER_UNICAST_GET(x)         (((x) & MAC_PCU_RX_FILTER_UNICAST_MASK) >> MAC_PCU_RX_FILTER_UNICAST_LSB)
#define MAC_PCU_RX_FILTER_UNICAST_SET(x)         (((x) << MAC_PCU_RX_FILTER_UNICAST_LSB) & MAC_PCU_RX_FILTER_UNICAST_MASK)

#define MAC_PCU_MCAST_FILTER_L32_ADDRESS         0x00008028
#define MAC_PCU_MCAST_FILTER_L32_OFFSET          0x00000028
#define MAC_PCU_MCAST_FILTER_L32_VALUE_MSB       31
#define MAC_PCU_MCAST_FILTER_L32_VALUE_LSB       0
#define MAC_PCU_MCAST_FILTER_L32_VALUE_MASK      0xffffffff
#define MAC_PCU_MCAST_FILTER_L32_VALUE_GET(x)    (((x) & MAC_PCU_MCAST_FILTER_L32_VALUE_MASK) >> MAC_PCU_MCAST_FILTER_L32_VALUE_LSB)
#define MAC_PCU_MCAST_FILTER_L32_VALUE_SET(x)    (((x) << MAC_PCU_MCAST_FILTER_L32_VALUE_LSB) & MAC_PCU_MCAST_FILTER_L32_VALUE_MASK)

#define MAC_PCU_MCAST_FILTER_U32_ADDRESS         0x0000802c
#define MAC_PCU_MCAST_FILTER_U32_OFFSET          0x0000002c
#define MAC_PCU_MCAST_FILTER_U32_VALUE_MSB       31
#define MAC_PCU_MCAST_FILTER_U32_VALUE_LSB       0
#define MAC_PCU_MCAST_FILTER_U32_VALUE_MASK      0xffffffff
#define MAC_PCU_MCAST_FILTER_U32_VALUE_GET(x)    (((x) & MAC_PCU_MCAST_FILTER_U32_VALUE_MASK) >> MAC_PCU_MCAST_FILTER_U32_VALUE_LSB)
#define MAC_PCU_MCAST_FILTER_U32_VALUE_SET(x)    (((x) << MAC_PCU_MCAST_FILTER_U32_VALUE_LSB) & MAC_PCU_MCAST_FILTER_U32_VALUE_MASK)

#define MAC_PCU_DIAG_SW_ADDRESS                  0x00008030
#define MAC_PCU_DIAG_SW_OFFSET                   0x00000030
#define MAC_PCU_DIAG_SW_DEBUG_MODE_MSB           31
#define MAC_PCU_DIAG_SW_DEBUG_MODE_LSB           30
#define MAC_PCU_DIAG_SW_DEBUG_MODE_MASK          0xc0000000
#define MAC_PCU_DIAG_SW_DEBUG_MODE_GET(x)        (((x) & MAC_PCU_DIAG_SW_DEBUG_MODE_MASK) >> MAC_PCU_DIAG_SW_DEBUG_MODE_LSB)
#define MAC_PCU_DIAG_SW_DEBUG_MODE_SET(x)        (((x) << MAC_PCU_DIAG_SW_DEBUG_MODE_LSB) & MAC_PCU_DIAG_SW_DEBUG_MODE_MASK)
#define MAC_PCU_DIAG_SW_RX_CLEAR_EXT_LOW_MSB     29
#define MAC_PCU_DIAG_SW_RX_CLEAR_EXT_LOW_LSB     29
#define MAC_PCU_DIAG_SW_RX_CLEAR_EXT_LOW_MASK    0x20000000
#define MAC_PCU_DIAG_SW_RX_CLEAR_EXT_LOW_GET(x)  (((x) & MAC_PCU_DIAG_SW_RX_CLEAR_EXT_LOW_MASK) >> MAC_PCU_DIAG_SW_RX_CLEAR_EXT_LOW_LSB)
#define MAC_PCU_DIAG_SW_RX_CLEAR_EXT_LOW_SET(x)  (((x) << MAC_PCU_DIAG_SW_RX_CLEAR_EXT_LOW_LSB) & MAC_PCU_DIAG_SW_RX_CLEAR_EXT_LOW_MASK)
#define MAC_PCU_DIAG_SW_RX_CLEAR_CTL_LOW_MSB     28
#define MAC_PCU_DIAG_SW_RX_CLEAR_CTL_LOW_LSB     28
#define MAC_PCU_DIAG_SW_RX_CLEAR_CTL_LOW_MASK    0x10000000
#define MAC_PCU_DIAG_SW_RX_CLEAR_CTL_LOW_GET(x)  (((x) & MAC_PCU_DIAG_SW_RX_CLEAR_CTL_LOW_MASK) >> MAC_PCU_DIAG_SW_RX_CLEAR_CTL_LOW_LSB)
#define MAC_PCU_DIAG_SW_RX_CLEAR_CTL_LOW_SET(x)  (((x) << MAC_PCU_DIAG_SW_RX_CLEAR_CTL_LOW_LSB) & MAC_PCU_DIAG_SW_RX_CLEAR_CTL_LOW_MASK)
#define MAC_PCU_DIAG_SW_OBS_SEL_2_MSB            27
#define MAC_PCU_DIAG_SW_OBS_SEL_2_LSB            27
#define MAC_PCU_DIAG_SW_OBS_SEL_2_MASK           0x08000000
#define MAC_PCU_DIAG_SW_OBS_SEL_2_GET(x)         (((x) & MAC_PCU_DIAG_SW_OBS_SEL_2_MASK) >> MAC_PCU_DIAG_SW_OBS_SEL_2_LSB)
#define MAC_PCU_DIAG_SW_OBS_SEL_2_SET(x)         (((x) << MAC_PCU_DIAG_SW_OBS_SEL_2_LSB) & MAC_PCU_DIAG_SW_OBS_SEL_2_MASK)
#define MAC_PCU_DIAG_SW_SATURATE_CYCLE_CNT_MSB   26
#define MAC_PCU_DIAG_SW_SATURATE_CYCLE_CNT_LSB   26
#define MAC_PCU_DIAG_SW_SATURATE_CYCLE_CNT_MASK  0x04000000
#define MAC_PCU_DIAG_SW_SATURATE_CYCLE_CNT_GET(x) (((x) & MAC_PCU_DIAG_SW_SATURATE_CYCLE_CNT_MASK) >> MAC_PCU_DIAG_SW_SATURATE_CYCLE_CNT_LSB)
#define MAC_PCU_DIAG_SW_SATURATE_CYCLE_CNT_SET(x) (((x) << MAC_PCU_DIAG_SW_SATURATE_CYCLE_CNT_LSB) & MAC_PCU_DIAG_SW_SATURATE_CYCLE_CNT_MASK)
#define MAC_PCU_DIAG_SW_FORCE_RX_ABORT_MSB       25
#define MAC_PCU_DIAG_SW_FORCE_RX_ABORT_LSB       25
#define MAC_PCU_DIAG_SW_FORCE_RX_ABORT_MASK      0x02000000
#define MAC_PCU_DIAG_SW_FORCE_RX_ABORT_GET(x)    (((x) & MAC_PCU_DIAG_SW_FORCE_RX_ABORT_MASK) >> MAC_PCU_DIAG_SW_FORCE_RX_ABORT_LSB)
#define MAC_PCU_DIAG_SW_FORCE_RX_ABORT_SET(x)    (((x) << MAC_PCU_DIAG_SW_FORCE_RX_ABORT_LSB) & MAC_PCU_DIAG_SW_FORCE_RX_ABORT_MASK)
#define MAC_PCU_DIAG_SW_DUAL_CHAIN_CHAN_INFO_MSB 24
#define MAC_PCU_DIAG_SW_DUAL_CHAIN_CHAN_INFO_LSB 24
#define MAC_PCU_DIAG_SW_DUAL_CHAIN_CHAN_INFO_MASK 0x01000000
#define MAC_PCU_DIAG_SW_DUAL_CHAIN_CHAN_INFO_GET(x) (((x) & MAC_PCU_DIAG_SW_DUAL_CHAIN_CHAN_INFO_MASK) >> MAC_PCU_DIAG_SW_DUAL_CHAIN_CHAN_INFO_LSB)
#define MAC_PCU_DIAG_SW_DUAL_CHAIN_CHAN_INFO_SET(x) (((x) << MAC_PCU_DIAG_SW_DUAL_CHAIN_CHAN_INFO_LSB) & MAC_PCU_DIAG_SW_DUAL_CHAIN_CHAN_INFO_MASK)
#define MAC_PCU_DIAG_SW_PHYERR_ENABLE_EIFS_CTL_MSB 23
#define MAC_PCU_DIAG_SW_PHYERR_ENABLE_EIFS_CTL_LSB 23
#define MAC_PCU_DIAG_SW_PHYERR_ENABLE_EIFS_CTL_MASK 0x00800000
#define MAC_PCU_DIAG_SW_PHYERR_ENABLE_EIFS_CTL_GET(x) (((x) & MAC_PCU_DIAG_SW_PHYERR_ENABLE_EIFS_CTL_MASK) >> MAC_PCU_DIAG_SW_PHYERR_ENABLE_EIFS_CTL_LSB)
#define MAC_PCU_DIAG_SW_PHYERR_ENABLE_EIFS_CTL_SET(x) (((x) << MAC_PCU_DIAG_SW_PHYERR_ENABLE_EIFS_CTL_LSB) & MAC_PCU_DIAG_SW_PHYERR_ENABLE_EIFS_CTL_MASK)
#define MAC_PCU_DIAG_SW_CHAN_IDLE_HIGH_MSB       22
#define MAC_PCU_DIAG_SW_CHAN_IDLE_HIGH_LSB       22
#define MAC_PCU_DIAG_SW_CHAN_IDLE_HIGH_MASK      0x00400000
#define MAC_PCU_DIAG_SW_CHAN_IDLE_HIGH_GET(x)    (((x) & MAC_PCU_DIAG_SW_CHAN_IDLE_HIGH_MASK) >> MAC_PCU_DIAG_SW_CHAN_IDLE_HIGH_LSB)
#define MAC_PCU_DIAG_SW_CHAN_IDLE_HIGH_SET(x)    (((x) << MAC_PCU_DIAG_SW_CHAN_IDLE_HIGH_LSB) & MAC_PCU_DIAG_SW_CHAN_IDLE_HIGH_MASK)
#define MAC_PCU_DIAG_SW_IGNORE_NAV_MSB           21
#define MAC_PCU_DIAG_SW_IGNORE_NAV_LSB           21
#define MAC_PCU_DIAG_SW_IGNORE_NAV_MASK          0x00200000
#define MAC_PCU_DIAG_SW_IGNORE_NAV_GET(x)        (((x) & MAC_PCU_DIAG_SW_IGNORE_NAV_MASK) >> MAC_PCU_DIAG_SW_IGNORE_NAV_LSB)
#define MAC_PCU_DIAG_SW_IGNORE_NAV_SET(x)        (((x) << MAC_PCU_DIAG_SW_IGNORE_NAV_LSB) & MAC_PCU_DIAG_SW_IGNORE_NAV_MASK)
#define MAC_PCU_DIAG_SW_RX_CLEAR_HIGH_MSB        20
#define MAC_PCU_DIAG_SW_RX_CLEAR_HIGH_LSB        20
#define MAC_PCU_DIAG_SW_RX_CLEAR_HIGH_MASK       0x00100000
#define MAC_PCU_DIAG_SW_RX_CLEAR_HIGH_GET(x)     (((x) & MAC_PCU_DIAG_SW_RX_CLEAR_HIGH_MASK) >> MAC_PCU_DIAG_SW_RX_CLEAR_HIGH_LSB)
#define MAC_PCU_DIAG_SW_RX_CLEAR_HIGH_SET(x)     (((x) << MAC_PCU_DIAG_SW_RX_CLEAR_HIGH_LSB) & MAC_PCU_DIAG_SW_RX_CLEAR_HIGH_MASK)
#define MAC_PCU_DIAG_SW_OBS_SEL_1_0_MSB          19
#define MAC_PCU_DIAG_SW_OBS_SEL_1_0_LSB          18
#define MAC_PCU_DIAG_SW_OBS_SEL_1_0_MASK         0x000c0000
#define MAC_PCU_DIAG_SW_OBS_SEL_1_0_GET(x)       (((x) & MAC_PCU_DIAG_SW_OBS_SEL_1_0_MASK) >> MAC_PCU_DIAG_SW_OBS_SEL_1_0_LSB)
#define MAC_PCU_DIAG_SW_OBS_SEL_1_0_SET(x)       (((x) << MAC_PCU_DIAG_SW_OBS_SEL_1_0_LSB) & MAC_PCU_DIAG_SW_OBS_SEL_1_0_MASK)
#define MAC_PCU_DIAG_SW_ACCEPT_NON_V0_MSB        17
#define MAC_PCU_DIAG_SW_ACCEPT_NON_V0_LSB        17
#define MAC_PCU_DIAG_SW_ACCEPT_NON_V0_MASK       0x00020000
#define MAC_PCU_DIAG_SW_ACCEPT_NON_V0_GET(x)     (((x) & MAC_PCU_DIAG_SW_ACCEPT_NON_V0_MASK) >> MAC_PCU_DIAG_SW_ACCEPT_NON_V0_LSB)
#define MAC_PCU_DIAG_SW_ACCEPT_NON_V0_SET(x)     (((x) << MAC_PCU_DIAG_SW_ACCEPT_NON_V0_LSB) & MAC_PCU_DIAG_SW_ACCEPT_NON_V0_MASK)
#define MAC_PCU_DIAG_SW_DUMP_CHAN_INFO_MSB       8
#define MAC_PCU_DIAG_SW_DUMP_CHAN_INFO_LSB       8
#define MAC_PCU_DIAG_SW_DUMP_CHAN_INFO_MASK      0x00000100
#define MAC_PCU_DIAG_SW_DUMP_CHAN_INFO_GET(x)    (((x) & MAC_PCU_DIAG_SW_DUMP_CHAN_INFO_MASK) >> MAC_PCU_DIAG_SW_DUMP_CHAN_INFO_LSB)
#define MAC_PCU_DIAG_SW_DUMP_CHAN_INFO_SET(x)    (((x) << MAC_PCU_DIAG_SW_DUMP_CHAN_INFO_LSB) & MAC_PCU_DIAG_SW_DUMP_CHAN_INFO_MASK)
#define MAC_PCU_DIAG_SW_CORRUPT_FCS_MSB          7
#define MAC_PCU_DIAG_SW_CORRUPT_FCS_LSB          7
#define MAC_PCU_DIAG_SW_CORRUPT_FCS_MASK         0x00000080
#define MAC_PCU_DIAG_SW_CORRUPT_FCS_GET(x)       (((x) & MAC_PCU_DIAG_SW_CORRUPT_FCS_MASK) >> MAC_PCU_DIAG_SW_CORRUPT_FCS_LSB)
#define MAC_PCU_DIAG_SW_CORRUPT_FCS_SET(x)       (((x) << MAC_PCU_DIAG_SW_CORRUPT_FCS_LSB) & MAC_PCU_DIAG_SW_CORRUPT_FCS_MASK)
#define MAC_PCU_DIAG_SW_LOOP_BACK_MSB            6
#define MAC_PCU_DIAG_SW_LOOP_BACK_LSB            6
#define MAC_PCU_DIAG_SW_LOOP_BACK_MASK           0x00000040
#define MAC_PCU_DIAG_SW_LOOP_BACK_GET(x)         (((x) & MAC_PCU_DIAG_SW_LOOP_BACK_MASK) >> MAC_PCU_DIAG_SW_LOOP_BACK_LSB)
#define MAC_PCU_DIAG_SW_LOOP_BACK_SET(x)         (((x) << MAC_PCU_DIAG_SW_LOOP_BACK_LSB) & MAC_PCU_DIAG_SW_LOOP_BACK_MASK)
#define MAC_PCU_DIAG_SW_HALT_RX_MSB              5
#define MAC_PCU_DIAG_SW_HALT_RX_LSB              5
#define MAC_PCU_DIAG_SW_HALT_RX_MASK             0x00000020
#define MAC_PCU_DIAG_SW_HALT_RX_GET(x)           (((x) & MAC_PCU_DIAG_SW_HALT_RX_MASK) >> MAC_PCU_DIAG_SW_HALT_RX_LSB)
#define MAC_PCU_DIAG_SW_HALT_RX_SET(x)           (((x) << MAC_PCU_DIAG_SW_HALT_RX_LSB) & MAC_PCU_DIAG_SW_HALT_RX_MASK)
#define MAC_PCU_DIAG_SW_NO_DECRYPT_MSB           4
#define MAC_PCU_DIAG_SW_NO_DECRYPT_LSB           4
#define MAC_PCU_DIAG_SW_NO_DECRYPT_MASK          0x00000010
#define MAC_PCU_DIAG_SW_NO_DECRYPT_GET(x)        (((x) & MAC_PCU_DIAG_SW_NO_DECRYPT_MASK) >> MAC_PCU_DIAG_SW_NO_DECRYPT_LSB)
#define MAC_PCU_DIAG_SW_NO_DECRYPT_SET(x)        (((x) << MAC_PCU_DIAG_SW_NO_DECRYPT_LSB) & MAC_PCU_DIAG_SW_NO_DECRYPT_MASK)
#define MAC_PCU_DIAG_SW_NO_ENCRYPT_MSB           3
#define MAC_PCU_DIAG_SW_NO_ENCRYPT_LSB           3
#define MAC_PCU_DIAG_SW_NO_ENCRYPT_MASK          0x00000008
#define MAC_PCU_DIAG_SW_NO_ENCRYPT_GET(x)        (((x) & MAC_PCU_DIAG_SW_NO_ENCRYPT_MASK) >> MAC_PCU_DIAG_SW_NO_ENCRYPT_LSB)
#define MAC_PCU_DIAG_SW_NO_ENCRYPT_SET(x)        (((x) << MAC_PCU_DIAG_SW_NO_ENCRYPT_LSB) & MAC_PCU_DIAG_SW_NO_ENCRYPT_MASK)
#define MAC_PCU_DIAG_SW_NO_CTS_MSB               2
#define MAC_PCU_DIAG_SW_NO_CTS_LSB               2
#define MAC_PCU_DIAG_SW_NO_CTS_MASK              0x00000004
#define MAC_PCU_DIAG_SW_NO_CTS_GET(x)            (((x) & MAC_PCU_DIAG_SW_NO_CTS_MASK) >> MAC_PCU_DIAG_SW_NO_CTS_LSB)
#define MAC_PCU_DIAG_SW_NO_CTS_SET(x)            (((x) << MAC_PCU_DIAG_SW_NO_CTS_LSB) & MAC_PCU_DIAG_SW_NO_CTS_MASK)
#define MAC_PCU_DIAG_SW_NO_ACK_MSB               1
#define MAC_PCU_DIAG_SW_NO_ACK_LSB               1
#define MAC_PCU_DIAG_SW_NO_ACK_MASK              0x00000002
#define MAC_PCU_DIAG_SW_NO_ACK_GET(x)            (((x) & MAC_PCU_DIAG_SW_NO_ACK_MASK) >> MAC_PCU_DIAG_SW_NO_ACK_LSB)
#define MAC_PCU_DIAG_SW_NO_ACK_SET(x)            (((x) << MAC_PCU_DIAG_SW_NO_ACK_LSB) & MAC_PCU_DIAG_SW_NO_ACK_MASK)
#define MAC_PCU_DIAG_SW_INVALID_KEY_NO_ACK_MSB   0
#define MAC_PCU_DIAG_SW_INVALID_KEY_NO_ACK_LSB   0
#define MAC_PCU_DIAG_SW_INVALID_KEY_NO_ACK_MASK  0x00000001
#define MAC_PCU_DIAG_SW_INVALID_KEY_NO_ACK_GET(x) (((x) & MAC_PCU_DIAG_SW_INVALID_KEY_NO_ACK_MASK) >> MAC_PCU_DIAG_SW_INVALID_KEY_NO_ACK_LSB)
#define MAC_PCU_DIAG_SW_INVALID_KEY_NO_ACK_SET(x) (((x) << MAC_PCU_DIAG_SW_INVALID_KEY_NO_ACK_LSB) & MAC_PCU_DIAG_SW_INVALID_KEY_NO_ACK_MASK)

#define MAC_PCU_TST_ADDAC_ADDRESS                0x00008034
#define MAC_PCU_TST_ADDAC_OFFSET                 0x00000034
#define MAC_PCU_TST_ADDAC_TEST_ARM_MSB           20
#define MAC_PCU_TST_ADDAC_TEST_ARM_LSB           20
#define MAC_PCU_TST_ADDAC_TEST_ARM_MASK          0x00100000
#define MAC_PCU_TST_ADDAC_TEST_ARM_GET(x)        (((x) & MAC_PCU_TST_ADDAC_TEST_ARM_MASK) >> MAC_PCU_TST_ADDAC_TEST_ARM_LSB)
#define MAC_PCU_TST_ADDAC_TEST_ARM_SET(x)        (((x) << MAC_PCU_TST_ADDAC_TEST_ARM_LSB) & MAC_PCU_TST_ADDAC_TEST_ARM_MASK)
#define MAC_PCU_TST_ADDAC_TEST_CAPTURE_MSB       19
#define MAC_PCU_TST_ADDAC_TEST_CAPTURE_LSB       19
#define MAC_PCU_TST_ADDAC_TEST_CAPTURE_MASK      0x00080000
#define MAC_PCU_TST_ADDAC_TEST_CAPTURE_GET(x)    (((x) & MAC_PCU_TST_ADDAC_TEST_CAPTURE_MASK) >> MAC_PCU_TST_ADDAC_TEST_CAPTURE_LSB)
#define MAC_PCU_TST_ADDAC_TEST_CAPTURE_SET(x)    (((x) << MAC_PCU_TST_ADDAC_TEST_CAPTURE_LSB) & MAC_PCU_TST_ADDAC_TEST_CAPTURE_MASK)
#define MAC_PCU_TST_ADDAC_CONT_TEST_MSB          18
#define MAC_PCU_TST_ADDAC_CONT_TEST_LSB          18
#define MAC_PCU_TST_ADDAC_CONT_TEST_MASK         0x00040000
#define MAC_PCU_TST_ADDAC_CONT_TEST_GET(x)       (((x) & MAC_PCU_TST_ADDAC_CONT_TEST_MASK) >> MAC_PCU_TST_ADDAC_CONT_TEST_LSB)
#define MAC_PCU_TST_ADDAC_CONT_TEST_SET(x)       (((x) << MAC_PCU_TST_ADDAC_CONT_TEST_LSB) & MAC_PCU_TST_ADDAC_CONT_TEST_MASK)
#define MAC_PCU_TST_ADDAC_TRIG_POLARITY_MSB      17
#define MAC_PCU_TST_ADDAC_TRIG_POLARITY_LSB      17
#define MAC_PCU_TST_ADDAC_TRIG_POLARITY_MASK     0x00020000
#define MAC_PCU_TST_ADDAC_TRIG_POLARITY_GET(x)   (((x) & MAC_PCU_TST_ADDAC_TRIG_POLARITY_MASK) >> MAC_PCU_TST_ADDAC_TRIG_POLARITY_LSB)
#define MAC_PCU_TST_ADDAC_TRIG_POLARITY_SET(x)   (((x) << MAC_PCU_TST_ADDAC_TRIG_POLARITY_LSB) & MAC_PCU_TST_ADDAC_TRIG_POLARITY_MASK)
#define MAC_PCU_TST_ADDAC_TRIG_SEL_MSB           16
#define MAC_PCU_TST_ADDAC_TRIG_SEL_LSB           16
#define MAC_PCU_TST_ADDAC_TRIG_SEL_MASK          0x00010000
#define MAC_PCU_TST_ADDAC_TRIG_SEL_GET(x)        (((x) & MAC_PCU_TST_ADDAC_TRIG_SEL_MASK) >> MAC_PCU_TST_ADDAC_TRIG_SEL_LSB)
#define MAC_PCU_TST_ADDAC_TRIG_SEL_SET(x)        (((x) << MAC_PCU_TST_ADDAC_TRIG_SEL_LSB) & MAC_PCU_TST_ADDAC_TRIG_SEL_MASK)
#define MAC_PCU_TST_ADDAC_UPPER_8B_MSB           14
#define MAC_PCU_TST_ADDAC_UPPER_8B_LSB           14
#define MAC_PCU_TST_ADDAC_UPPER_8B_MASK          0x00004000
#define MAC_PCU_TST_ADDAC_UPPER_8B_GET(x)        (((x) & MAC_PCU_TST_ADDAC_UPPER_8B_MASK) >> MAC_PCU_TST_ADDAC_UPPER_8B_LSB)
#define MAC_PCU_TST_ADDAC_UPPER_8B_SET(x)        (((x) << MAC_PCU_TST_ADDAC_UPPER_8B_LSB) & MAC_PCU_TST_ADDAC_UPPER_8B_MASK)
#define MAC_PCU_TST_ADDAC_LOOP_LEN_MSB           13
#define MAC_PCU_TST_ADDAC_LOOP_LEN_LSB           3
#define MAC_PCU_TST_ADDAC_LOOP_LEN_MASK          0x00003ff8
#define MAC_PCU_TST_ADDAC_LOOP_LEN_GET(x)        (((x) & MAC_PCU_TST_ADDAC_LOOP_LEN_MASK) >> MAC_PCU_TST_ADDAC_LOOP_LEN_LSB)
#define MAC_PCU_TST_ADDAC_LOOP_LEN_SET(x)        (((x) << MAC_PCU_TST_ADDAC_LOOP_LEN_LSB) & MAC_PCU_TST_ADDAC_LOOP_LEN_MASK)
#define MAC_PCU_TST_ADDAC_LOOP_MSB               2
#define MAC_PCU_TST_ADDAC_LOOP_LSB               2
#define MAC_PCU_TST_ADDAC_LOOP_MASK              0x00000004
#define MAC_PCU_TST_ADDAC_LOOP_GET(x)            (((x) & MAC_PCU_TST_ADDAC_LOOP_MASK) >> MAC_PCU_TST_ADDAC_LOOP_LSB)
#define MAC_PCU_TST_ADDAC_LOOP_SET(x)            (((x) << MAC_PCU_TST_ADDAC_LOOP_LSB) & MAC_PCU_TST_ADDAC_LOOP_MASK)
#define MAC_PCU_TST_ADDAC_TESTMODE_MSB           1
#define MAC_PCU_TST_ADDAC_TESTMODE_LSB           1
#define MAC_PCU_TST_ADDAC_TESTMODE_MASK          0x00000002
#define MAC_PCU_TST_ADDAC_TESTMODE_GET(x)        (((x) & MAC_PCU_TST_ADDAC_TESTMODE_MASK) >> MAC_PCU_TST_ADDAC_TESTMODE_LSB)
#define MAC_PCU_TST_ADDAC_TESTMODE_SET(x)        (((x) << MAC_PCU_TST_ADDAC_TESTMODE_LSB) & MAC_PCU_TST_ADDAC_TESTMODE_MASK)
#define MAC_PCU_TST_ADDAC_CONT_TX_MSB            0
#define MAC_PCU_TST_ADDAC_CONT_TX_LSB            0
#define MAC_PCU_TST_ADDAC_CONT_TX_MASK           0x00000001
#define MAC_PCU_TST_ADDAC_CONT_TX_GET(x)         (((x) & MAC_PCU_TST_ADDAC_CONT_TX_MASK) >> MAC_PCU_TST_ADDAC_CONT_TX_LSB)
#define MAC_PCU_TST_ADDAC_CONT_TX_SET(x)         (((x) << MAC_PCU_TST_ADDAC_CONT_TX_LSB) & MAC_PCU_TST_ADDAC_CONT_TX_MASK)

#define MAC_PCU_DEF_ANTENNA_ADDRESS              0x00008038
#define MAC_PCU_DEF_ANTENNA_OFFSET               0x00000038
#define MAC_PCU_DEF_ANTENNA_RX_LNA_CONFIG_SEL_MSB 28
#define MAC_PCU_DEF_ANTENNA_RX_LNA_CONFIG_SEL_LSB 28
#define MAC_PCU_DEF_ANTENNA_RX_LNA_CONFIG_SEL_MASK 0x10000000
#define MAC_PCU_DEF_ANTENNA_RX_LNA_CONFIG_SEL_GET(x) (((x) & MAC_PCU_DEF_ANTENNA_RX_LNA_CONFIG_SEL_MASK) >> MAC_PCU_DEF_ANTENNA_RX_LNA_CONFIG_SEL_LSB)
#define MAC_PCU_DEF_ANTENNA_RX_LNA_CONFIG_SEL_SET(x) (((x) << MAC_PCU_DEF_ANTENNA_RX_LNA_CONFIG_SEL_LSB) & MAC_PCU_DEF_ANTENNA_RX_LNA_CONFIG_SEL_MASK)
#define MAC_PCU_DEF_ANTENNA_TX_DEF_ANT_SEL_MSB   24
#define MAC_PCU_DEF_ANTENNA_TX_DEF_ANT_SEL_LSB   24
#define MAC_PCU_DEF_ANTENNA_TX_DEF_ANT_SEL_MASK  0x01000000
#define MAC_PCU_DEF_ANTENNA_TX_DEF_ANT_SEL_GET(x) (((x) & MAC_PCU_DEF_ANTENNA_TX_DEF_ANT_SEL_MASK) >> MAC_PCU_DEF_ANTENNA_TX_DEF_ANT_SEL_LSB)
#define MAC_PCU_DEF_ANTENNA_TX_DEF_ANT_SEL_SET(x) (((x) << MAC_PCU_DEF_ANTENNA_TX_DEF_ANT_SEL_LSB) & MAC_PCU_DEF_ANTENNA_TX_DEF_ANT_SEL_MASK)
#define MAC_PCU_DEF_ANTENNA_VALUE_MSB            23
#define MAC_PCU_DEF_ANTENNA_VALUE_LSB            0
#define MAC_PCU_DEF_ANTENNA_VALUE_MASK           0x00ffffff
#define MAC_PCU_DEF_ANTENNA_VALUE_GET(x)         (((x) & MAC_PCU_DEF_ANTENNA_VALUE_MASK) >> MAC_PCU_DEF_ANTENNA_VALUE_LSB)
#define MAC_PCU_DEF_ANTENNA_VALUE_SET(x)         (((x) << MAC_PCU_DEF_ANTENNA_VALUE_LSB) & MAC_PCU_DEF_ANTENNA_VALUE_MASK)

#define MAC_PCU_AES_MUTE_MASK_0_ADDRESS          0x0000803c
#define MAC_PCU_AES_MUTE_MASK_0_OFFSET           0x0000003c
#define MAC_PCU_AES_MUTE_MASK_0_QOS_MSB          31
#define MAC_PCU_AES_MUTE_MASK_0_QOS_LSB          16
#define MAC_PCU_AES_MUTE_MASK_0_QOS_MASK         0xffff0000
#define MAC_PCU_AES_MUTE_MASK_0_QOS_GET(x)       (((x) & MAC_PCU_AES_MUTE_MASK_0_QOS_MASK) >> MAC_PCU_AES_MUTE_MASK_0_QOS_LSB)
#define MAC_PCU_AES_MUTE_MASK_0_QOS_SET(x)       (((x) << MAC_PCU_AES_MUTE_MASK_0_QOS_LSB) & MAC_PCU_AES_MUTE_MASK_0_QOS_MASK)
#define MAC_PCU_AES_MUTE_MASK_0_FC_MSB           15
#define MAC_PCU_AES_MUTE_MASK_0_FC_LSB           0
#define MAC_PCU_AES_MUTE_MASK_0_FC_MASK          0x0000ffff
#define MAC_PCU_AES_MUTE_MASK_0_FC_GET(x)        (((x) & MAC_PCU_AES_MUTE_MASK_0_FC_MASK) >> MAC_PCU_AES_MUTE_MASK_0_FC_LSB)
#define MAC_PCU_AES_MUTE_MASK_0_FC_SET(x)        (((x) << MAC_PCU_AES_MUTE_MASK_0_FC_LSB) & MAC_PCU_AES_MUTE_MASK_0_FC_MASK)

#define MAC_PCU_AES_MUTE_MASK_1_ADDRESS          0x00008040
#define MAC_PCU_AES_MUTE_MASK_1_OFFSET           0x00000040
#define MAC_PCU_AES_MUTE_MASK_1_FC_MGMT_MSB      31
#define MAC_PCU_AES_MUTE_MASK_1_FC_MGMT_LSB      16
#define MAC_PCU_AES_MUTE_MASK_1_FC_MGMT_MASK     0xffff0000
#define MAC_PCU_AES_MUTE_MASK_1_FC_MGMT_GET(x)   (((x) & MAC_PCU_AES_MUTE_MASK_1_FC_MGMT_MASK) >> MAC_PCU_AES_MUTE_MASK_1_FC_MGMT_LSB)
#define MAC_PCU_AES_MUTE_MASK_1_FC_MGMT_SET(x)   (((x) << MAC_PCU_AES_MUTE_MASK_1_FC_MGMT_LSB) & MAC_PCU_AES_MUTE_MASK_1_FC_MGMT_MASK)
#define MAC_PCU_AES_MUTE_MASK_1_SEQ_MSB          15
#define MAC_PCU_AES_MUTE_MASK_1_SEQ_LSB          0
#define MAC_PCU_AES_MUTE_MASK_1_SEQ_MASK         0x0000ffff
#define MAC_PCU_AES_MUTE_MASK_1_SEQ_GET(x)       (((x) & MAC_PCU_AES_MUTE_MASK_1_SEQ_MASK) >> MAC_PCU_AES_MUTE_MASK_1_SEQ_LSB)
#define MAC_PCU_AES_MUTE_MASK_1_SEQ_SET(x)       (((x) << MAC_PCU_AES_MUTE_MASK_1_SEQ_LSB) & MAC_PCU_AES_MUTE_MASK_1_SEQ_MASK)

#define MAC_PCU_GATED_CLKS_ADDRESS               0x00008044
#define MAC_PCU_GATED_CLKS_OFFSET                0x00000044
#define MAC_PCU_GATED_CLKS_GATED_REG_MSB         3
#define MAC_PCU_GATED_CLKS_GATED_REG_LSB         3
#define MAC_PCU_GATED_CLKS_GATED_REG_MASK        0x00000008
#define MAC_PCU_GATED_CLKS_GATED_REG_GET(x)      (((x) & MAC_PCU_GATED_CLKS_GATED_REG_MASK) >> MAC_PCU_GATED_CLKS_GATED_REG_LSB)
#define MAC_PCU_GATED_CLKS_GATED_REG_SET(x)      (((x) << MAC_PCU_GATED_CLKS_GATED_REG_LSB) & MAC_PCU_GATED_CLKS_GATED_REG_MASK)
#define MAC_PCU_GATED_CLKS_GATED_RX_MSB          2
#define MAC_PCU_GATED_CLKS_GATED_RX_LSB          2
#define MAC_PCU_GATED_CLKS_GATED_RX_MASK         0x00000004
#define MAC_PCU_GATED_CLKS_GATED_RX_GET(x)       (((x) & MAC_PCU_GATED_CLKS_GATED_RX_MASK) >> MAC_PCU_GATED_CLKS_GATED_RX_LSB)
#define MAC_PCU_GATED_CLKS_GATED_RX_SET(x)       (((x) << MAC_PCU_GATED_CLKS_GATED_RX_LSB) & MAC_PCU_GATED_CLKS_GATED_RX_MASK)
#define MAC_PCU_GATED_CLKS_GATED_TX_MSB          1
#define MAC_PCU_GATED_CLKS_GATED_TX_LSB          1
#define MAC_PCU_GATED_CLKS_GATED_TX_MASK         0x00000002
#define MAC_PCU_GATED_CLKS_GATED_TX_GET(x)       (((x) & MAC_PCU_GATED_CLKS_GATED_TX_MASK) >> MAC_PCU_GATED_CLKS_GATED_TX_LSB)
#define MAC_PCU_GATED_CLKS_GATED_TX_SET(x)       (((x) << MAC_PCU_GATED_CLKS_GATED_TX_LSB) & MAC_PCU_GATED_CLKS_GATED_TX_MASK)

#define MAC_PCU_OBS_BUS_2_ADDRESS                0x00008048
#define MAC_PCU_OBS_BUS_2_OFFSET                 0x00000048
#define MAC_PCU_OBS_BUS_2_VALUE_MSB              17
#define MAC_PCU_OBS_BUS_2_VALUE_LSB              0
#define MAC_PCU_OBS_BUS_2_VALUE_MASK             0x0003ffff
#define MAC_PCU_OBS_BUS_2_VALUE_GET(x)           (((x) & MAC_PCU_OBS_BUS_2_VALUE_MASK) >> MAC_PCU_OBS_BUS_2_VALUE_LSB)
#define MAC_PCU_OBS_BUS_2_VALUE_SET(x)           (((x) << MAC_PCU_OBS_BUS_2_VALUE_LSB) & MAC_PCU_OBS_BUS_2_VALUE_MASK)

#define MAC_PCU_OBS_BUS_1_ADDRESS                0x0000804c
#define MAC_PCU_OBS_BUS_1_OFFSET                 0x0000004c
#define MAC_PCU_OBS_BUS_1_TX_STATE_MSB           30
#define MAC_PCU_OBS_BUS_1_TX_STATE_LSB           25
#define MAC_PCU_OBS_BUS_1_TX_STATE_MASK          0x7e000000
#define MAC_PCU_OBS_BUS_1_TX_STATE_GET(x)        (((x) & MAC_PCU_OBS_BUS_1_TX_STATE_MASK) >> MAC_PCU_OBS_BUS_1_TX_STATE_LSB)
#define MAC_PCU_OBS_BUS_1_TX_STATE_SET(x)        (((x) << MAC_PCU_OBS_BUS_1_TX_STATE_LSB) & MAC_PCU_OBS_BUS_1_TX_STATE_MASK)
#define MAC_PCU_OBS_BUS_1_RX_STATE_MSB           24
#define MAC_PCU_OBS_BUS_1_RX_STATE_LSB           20
#define MAC_PCU_OBS_BUS_1_RX_STATE_MASK          0x01f00000
#define MAC_PCU_OBS_BUS_1_RX_STATE_GET(x)        (((x) & MAC_PCU_OBS_BUS_1_RX_STATE_MASK) >> MAC_PCU_OBS_BUS_1_RX_STATE_LSB)
#define MAC_PCU_OBS_BUS_1_RX_STATE_SET(x)        (((x) << MAC_PCU_OBS_BUS_1_RX_STATE_LSB) & MAC_PCU_OBS_BUS_1_RX_STATE_MASK)
#define MAC_PCU_OBS_BUS_1_WEP_STATE_MSB          17
#define MAC_PCU_OBS_BUS_1_WEP_STATE_LSB          12
#define MAC_PCU_OBS_BUS_1_WEP_STATE_MASK         0x0003f000
#define MAC_PCU_OBS_BUS_1_WEP_STATE_GET(x)       (((x) & MAC_PCU_OBS_BUS_1_WEP_STATE_MASK) >> MAC_PCU_OBS_BUS_1_WEP_STATE_LSB)
#define MAC_PCU_OBS_BUS_1_WEP_STATE_SET(x)       (((x) << MAC_PCU_OBS_BUS_1_WEP_STATE_LSB) & MAC_PCU_OBS_BUS_1_WEP_STATE_MASK)
#define MAC_PCU_OBS_BUS_1_RX_CLEAR_MSB           11
#define MAC_PCU_OBS_BUS_1_RX_CLEAR_LSB           11
#define MAC_PCU_OBS_BUS_1_RX_CLEAR_MASK          0x00000800
#define MAC_PCU_OBS_BUS_1_RX_CLEAR_GET(x)        (((x) & MAC_PCU_OBS_BUS_1_RX_CLEAR_MASK) >> MAC_PCU_OBS_BUS_1_RX_CLEAR_LSB)
#define MAC_PCU_OBS_BUS_1_RX_CLEAR_SET(x)        (((x) << MAC_PCU_OBS_BUS_1_RX_CLEAR_LSB) & MAC_PCU_OBS_BUS_1_RX_CLEAR_MASK)
#define MAC_PCU_OBS_BUS_1_RX_FRAME_MSB           10
#define MAC_PCU_OBS_BUS_1_RX_FRAME_LSB           10
#define MAC_PCU_OBS_BUS_1_RX_FRAME_MASK          0x00000400
#define MAC_PCU_OBS_BUS_1_RX_FRAME_GET(x)        (((x) & MAC_PCU_OBS_BUS_1_RX_FRAME_MASK) >> MAC_PCU_OBS_BUS_1_RX_FRAME_LSB)
#define MAC_PCU_OBS_BUS_1_RX_FRAME_SET(x)        (((x) << MAC_PCU_OBS_BUS_1_RX_FRAME_LSB) & MAC_PCU_OBS_BUS_1_RX_FRAME_MASK)
#define MAC_PCU_OBS_BUS_1_TX_FRAME_MSB           9
#define MAC_PCU_OBS_BUS_1_TX_FRAME_LSB           9
#define MAC_PCU_OBS_BUS_1_TX_FRAME_MASK          0x00000200
#define MAC_PCU_OBS_BUS_1_TX_FRAME_GET(x)        (((x) & MAC_PCU_OBS_BUS_1_TX_FRAME_MASK) >> MAC_PCU_OBS_BUS_1_TX_FRAME_LSB)
#define MAC_PCU_OBS_BUS_1_TX_FRAME_SET(x)        (((x) << MAC_PCU_OBS_BUS_1_TX_FRAME_LSB) & MAC_PCU_OBS_BUS_1_TX_FRAME_MASK)
#define MAC_PCU_OBS_BUS_1_TX_HOLD_MSB            8
#define MAC_PCU_OBS_BUS_1_TX_HOLD_LSB            8
#define MAC_PCU_OBS_BUS_1_TX_HOLD_MASK           0x00000100
#define MAC_PCU_OBS_BUS_1_TX_HOLD_GET(x)         (((x) & MAC_PCU_OBS_BUS_1_TX_HOLD_MASK) >> MAC_PCU_OBS_BUS_1_TX_HOLD_LSB)
#define MAC_PCU_OBS_BUS_1_TX_HOLD_SET(x)         (((x) << MAC_PCU_OBS_BUS_1_TX_HOLD_LSB) & MAC_PCU_OBS_BUS_1_TX_HOLD_MASK)
#define MAC_PCU_OBS_BUS_1_PCU_CHANNEL_IDLE_MSB   7
#define MAC_PCU_OBS_BUS_1_PCU_CHANNEL_IDLE_LSB   7
#define MAC_PCU_OBS_BUS_1_PCU_CHANNEL_IDLE_MASK  0x00000080
#define MAC_PCU_OBS_BUS_1_PCU_CHANNEL_IDLE_GET(x) (((x) & MAC_PCU_OBS_BUS_1_PCU_CHANNEL_IDLE_MASK) >> MAC_PCU_OBS_BUS_1_PCU_CHANNEL_IDLE_LSB)
#define MAC_PCU_OBS_BUS_1_PCU_CHANNEL_IDLE_SET(x) (((x) << MAC_PCU_OBS_BUS_1_PCU_CHANNEL_IDLE_LSB) & MAC_PCU_OBS_BUS_1_PCU_CHANNEL_IDLE_MASK)
#define MAC_PCU_OBS_BUS_1_TM_QUIET_TIME_MSB      6
#define MAC_PCU_OBS_BUS_1_TM_QUIET_TIME_LSB      6
#define MAC_PCU_OBS_BUS_1_TM_QUIET_TIME_MASK     0x00000040
#define MAC_PCU_OBS_BUS_1_TM_QUIET_TIME_GET(x)   (((x) & MAC_PCU_OBS_BUS_1_TM_QUIET_TIME_MASK) >> MAC_PCU_OBS_BUS_1_TM_QUIET_TIME_LSB)
#define MAC_PCU_OBS_BUS_1_TM_QUIET_TIME_SET(x)   (((x) << MAC_PCU_OBS_BUS_1_TM_QUIET_TIME_LSB) & MAC_PCU_OBS_BUS_1_TM_QUIET_TIME_MASK)
#define MAC_PCU_OBS_BUS_1_TX_HCF_MSB             5
#define MAC_PCU_OBS_BUS_1_TX_HCF_LSB             5
#define MAC_PCU_OBS_BUS_1_TX_HCF_MASK            0x00000020
#define MAC_PCU_OBS_BUS_1_TX_HCF_GET(x)          (((x) & MAC_PCU_OBS_BUS_1_TX_HCF_MASK) >> MAC_PCU_OBS_BUS_1_TX_HCF_LSB)
#define MAC_PCU_OBS_BUS_1_TX_HCF_SET(x)          (((x) << MAC_PCU_OBS_BUS_1_TX_HCF_LSB) & MAC_PCU_OBS_BUS_1_TX_HCF_MASK)
#define MAC_PCU_OBS_BUS_1_FILTER_PASS_MSB        4
#define MAC_PCU_OBS_BUS_1_FILTER_PASS_LSB        4
#define MAC_PCU_OBS_BUS_1_FILTER_PASS_MASK       0x00000010
#define MAC_PCU_OBS_BUS_1_FILTER_PASS_GET(x)     (((x) & MAC_PCU_OBS_BUS_1_FILTER_PASS_MASK) >> MAC_PCU_OBS_BUS_1_FILTER_PASS_LSB)
#define MAC_PCU_OBS_BUS_1_FILTER_PASS_SET(x)     (((x) << MAC_PCU_OBS_BUS_1_FILTER_PASS_LSB) & MAC_PCU_OBS_BUS_1_FILTER_PASS_MASK)
#define MAC_PCU_OBS_BUS_1_RX_MY_BEACON_MSB       3
#define MAC_PCU_OBS_BUS_1_RX_MY_BEACON_LSB       3
#define MAC_PCU_OBS_BUS_1_RX_MY_BEACON_MASK      0x00000008
#define MAC_PCU_OBS_BUS_1_RX_MY_BEACON_GET(x)    (((x) & MAC_PCU_OBS_BUS_1_RX_MY_BEACON_MASK) >> MAC_PCU_OBS_BUS_1_RX_MY_BEACON_LSB)
#define MAC_PCU_OBS_BUS_1_RX_MY_BEACON_SET(x)    (((x) << MAC_PCU_OBS_BUS_1_RX_MY_BEACON_LSB) & MAC_PCU_OBS_BUS_1_RX_MY_BEACON_MASK)
#define MAC_PCU_OBS_BUS_1_RX_WEP_MSB             2
#define MAC_PCU_OBS_BUS_1_RX_WEP_LSB             2
#define MAC_PCU_OBS_BUS_1_RX_WEP_MASK            0x00000004
#define MAC_PCU_OBS_BUS_1_RX_WEP_GET(x)          (((x) & MAC_PCU_OBS_BUS_1_RX_WEP_MASK) >> MAC_PCU_OBS_BUS_1_RX_WEP_LSB)
#define MAC_PCU_OBS_BUS_1_RX_WEP_SET(x)          (((x) << MAC_PCU_OBS_BUS_1_RX_WEP_LSB) & MAC_PCU_OBS_BUS_1_RX_WEP_MASK)
#define MAC_PCU_OBS_BUS_1_PCU_RX_END_MSB         1
#define MAC_PCU_OBS_BUS_1_PCU_RX_END_LSB         1
#define MAC_PCU_OBS_BUS_1_PCU_RX_END_MASK        0x00000002
#define MAC_PCU_OBS_BUS_1_PCU_RX_END_GET(x)      (((x) & MAC_PCU_OBS_BUS_1_PCU_RX_END_MASK) >> MAC_PCU_OBS_BUS_1_PCU_RX_END_LSB)
#define MAC_PCU_OBS_BUS_1_PCU_RX_END_SET(x)      (((x) << MAC_PCU_OBS_BUS_1_PCU_RX_END_LSB) & MAC_PCU_OBS_BUS_1_PCU_RX_END_MASK)
#define MAC_PCU_OBS_BUS_1_PCU_DIRECTED_MSB       0
#define MAC_PCU_OBS_BUS_1_PCU_DIRECTED_LSB       0
#define MAC_PCU_OBS_BUS_1_PCU_DIRECTED_MASK      0x00000001
#define MAC_PCU_OBS_BUS_1_PCU_DIRECTED_GET(x)    (((x) & MAC_PCU_OBS_BUS_1_PCU_DIRECTED_MASK) >> MAC_PCU_OBS_BUS_1_PCU_DIRECTED_LSB)
#define MAC_PCU_OBS_BUS_1_PCU_DIRECTED_SET(x)    (((x) << MAC_PCU_OBS_BUS_1_PCU_DIRECTED_LSB) & MAC_PCU_OBS_BUS_1_PCU_DIRECTED_MASK)

#define MAC_PCU_DYM_MIMO_PWR_SAVE_ADDRESS        0x00008050
#define MAC_PCU_DYM_MIMO_PWR_SAVE_OFFSET         0x00000050
#define MAC_PCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_MSB 10
#define MAC_PCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_LSB 8
#define MAC_PCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_MASK 0x00000700
#define MAC_PCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_GET(x) (((x) & MAC_PCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_MASK) >> MAC_PCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_LSB)
#define MAC_PCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_SET(x) (((x) << MAC_PCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_LSB) & MAC_PCU_DYM_MIMO_PWR_SAVE_HI_PWR_CHAIN_MASK_MASK)
#define MAC_PCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_MSB 6
#define MAC_PCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_LSB 4
#define MAC_PCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_MASK 0x00000070
#define MAC_PCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_GET(x) (((x) & MAC_PCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_MASK) >> MAC_PCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_LSB)
#define MAC_PCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_SET(x) (((x) << MAC_PCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_LSB) & MAC_PCU_DYM_MIMO_PWR_SAVE_LOW_PWR_CHAIN_MASK_MASK)
#define MAC_PCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_MSB 2
#define MAC_PCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_LSB 2
#define MAC_PCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_MASK 0x00000004
#define MAC_PCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_GET(x) (((x) & MAC_PCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_MASK) >> MAC_PCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_LSB)
#define MAC_PCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_SET(x) (((x) << MAC_PCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_LSB) & MAC_PCU_DYM_MIMO_PWR_SAVE_SW_CHAIN_MASK_SEL_MASK)
#define MAC_PCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_MSB 1
#define MAC_PCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_LSB 1
#define MAC_PCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_MASK 0x00000002
#define MAC_PCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_GET(x) (((x) & MAC_PCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_MASK) >> MAC_PCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_LSB)
#define MAC_PCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_SET(x) (((x) << MAC_PCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_LSB) & MAC_PCU_DYM_MIMO_PWR_SAVE_HW_CTRL_EN_MASK)
#define MAC_PCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_MSB 0
#define MAC_PCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_LSB 0
#define MAC_PCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_MASK 0x00000001
#define MAC_PCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_GET(x) (((x) & MAC_PCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_MASK) >> MAC_PCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_LSB)
#define MAC_PCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_SET(x) (((x) << MAC_PCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_LSB) & MAC_PCU_DYM_MIMO_PWR_SAVE_USE_MAC_CTRL_MASK)

#define MAC_PCU_LAST_BEACON_TSF_ADDRESS          0x00008054
#define MAC_PCU_LAST_BEACON_TSF_OFFSET           0x00000054
#define MAC_PCU_LAST_BEACON_TSF_VALUE_MSB        31
#define MAC_PCU_LAST_BEACON_TSF_VALUE_LSB        0
#define MAC_PCU_LAST_BEACON_TSF_VALUE_MASK       0xffffffff
#define MAC_PCU_LAST_BEACON_TSF_VALUE_GET(x)     (((x) & MAC_PCU_LAST_BEACON_TSF_VALUE_MASK) >> MAC_PCU_LAST_BEACON_TSF_VALUE_LSB)
#define MAC_PCU_LAST_BEACON_TSF_VALUE_SET(x)     (((x) << MAC_PCU_LAST_BEACON_TSF_VALUE_LSB) & MAC_PCU_LAST_BEACON_TSF_VALUE_MASK)

#define MAC_PCU_NAV_ADDRESS                      0x00008058
#define MAC_PCU_NAV_OFFSET                       0x00000058
#define MAC_PCU_NAV_VALUE_MSB                    25
#define MAC_PCU_NAV_VALUE_LSB                    0
#define MAC_PCU_NAV_VALUE_MASK                   0x03ffffff
#define MAC_PCU_NAV_VALUE_GET(x)                 (((x) & MAC_PCU_NAV_VALUE_MASK) >> MAC_PCU_NAV_VALUE_LSB)
#define MAC_PCU_NAV_VALUE_SET(x)                 (((x) << MAC_PCU_NAV_VALUE_LSB) & MAC_PCU_NAV_VALUE_MASK)

#define MAC_PCU_RTS_SUCCESS_CNT_ADDRESS          0x0000805c
#define MAC_PCU_RTS_SUCCESS_CNT_OFFSET           0x0000005c
#define MAC_PCU_RTS_SUCCESS_CNT_VALUE_MSB        15
#define MAC_PCU_RTS_SUCCESS_CNT_VALUE_LSB        0
#define MAC_PCU_RTS_SUCCESS_CNT_VALUE_MASK       0x0000ffff
#define MAC_PCU_RTS_SUCCESS_CNT_VALUE_GET(x)     (((x) & MAC_PCU_RTS_SUCCESS_CNT_VALUE_MASK) >> MAC_PCU_RTS_SUCCESS_CNT_VALUE_LSB)
#define MAC_PCU_RTS_SUCCESS_CNT_VALUE_SET(x)     (((x) << MAC_PCU_RTS_SUCCESS_CNT_VALUE_LSB) & MAC_PCU_RTS_SUCCESS_CNT_VALUE_MASK)

#define MAC_PCU_RTS_FAIL_CNT_ADDRESS             0x00008060
#define MAC_PCU_RTS_FAIL_CNT_OFFSET              0x00000060
#define MAC_PCU_RTS_FAIL_CNT_VALUE_MSB           15
#define MAC_PCU_RTS_FAIL_CNT_VALUE_LSB           0
#define MAC_PCU_RTS_FAIL_CNT_VALUE_MASK          0x0000ffff
#define MAC_PCU_RTS_FAIL_CNT_VALUE_GET(x)        (((x) & MAC_PCU_RTS_FAIL_CNT_VALUE_MASK) >> MAC_PCU_RTS_FAIL_CNT_VALUE_LSB)
#define MAC_PCU_RTS_FAIL_CNT_VALUE_SET(x)        (((x) << MAC_PCU_RTS_FAIL_CNT_VALUE_LSB) & MAC_PCU_RTS_FAIL_CNT_VALUE_MASK)

#define MAC_PCU_ACK_FAIL_CNT_ADDRESS             0x00008064
#define MAC_PCU_ACK_FAIL_CNT_OFFSET              0x00000064
#define MAC_PCU_ACK_FAIL_CNT_VALUE_MSB           15
#define MAC_PCU_ACK_FAIL_CNT_VALUE_LSB           0
#define MAC_PCU_ACK_FAIL_CNT_VALUE_MASK          0x0000ffff
#define MAC_PCU_ACK_FAIL_CNT_VALUE_GET(x)        (((x) & MAC_PCU_ACK_FAIL_CNT_VALUE_MASK) >> MAC_PCU_ACK_FAIL_CNT_VALUE_LSB)
#define MAC_PCU_ACK_FAIL_CNT_VALUE_SET(x)        (((x) << MAC_PCU_ACK_FAIL_CNT_VALUE_LSB) & MAC_PCU_ACK_FAIL_CNT_VALUE_MASK)

#define MAC_PCU_FCS_FAIL_CNT_ADDRESS             0x00008068
#define MAC_PCU_FCS_FAIL_CNT_OFFSET              0x00000068
#define MAC_PCU_FCS_FAIL_CNT_VALUE_MSB           15
#define MAC_PCU_FCS_FAIL_CNT_VALUE_LSB           0
#define MAC_PCU_FCS_FAIL_CNT_VALUE_MASK          0x0000ffff
#define MAC_PCU_FCS_FAIL_CNT_VALUE_GET(x)        (((x) & MAC_PCU_FCS_FAIL_CNT_VALUE_MASK) >> MAC_PCU_FCS_FAIL_CNT_VALUE_LSB)
#define MAC_PCU_FCS_FAIL_CNT_VALUE_SET(x)        (((x) << MAC_PCU_FCS_FAIL_CNT_VALUE_LSB) & MAC_PCU_FCS_FAIL_CNT_VALUE_MASK)

#define MAC_PCU_BEACON_CNT_ADDRESS               0x0000806c
#define MAC_PCU_BEACON_CNT_OFFSET                0x0000006c
#define MAC_PCU_BEACON_CNT_VALUE_MSB             15
#define MAC_PCU_BEACON_CNT_VALUE_LSB             0
#define MAC_PCU_BEACON_CNT_VALUE_MASK            0x0000ffff
#define MAC_PCU_BEACON_CNT_VALUE_GET(x)          (((x) & MAC_PCU_BEACON_CNT_VALUE_MASK) >> MAC_PCU_BEACON_CNT_VALUE_LSB)
#define MAC_PCU_BEACON_CNT_VALUE_SET(x)          (((x) << MAC_PCU_BEACON_CNT_VALUE_LSB) & MAC_PCU_BEACON_CNT_VALUE_MASK)

#define MAC_PCU_XRMODE_ADDRESS                   0x00008070
#define MAC_PCU_XRMODE_OFFSET                    0x00000070
#define MAC_PCU_XRMODE_FRAME_HOLD_MSB            31
#define MAC_PCU_XRMODE_FRAME_HOLD_LSB            20
#define MAC_PCU_XRMODE_FRAME_HOLD_MASK           0xfff00000
#define MAC_PCU_XRMODE_FRAME_HOLD_GET(x)         (((x) & MAC_PCU_XRMODE_FRAME_HOLD_MASK) >> MAC_PCU_XRMODE_FRAME_HOLD_LSB)
#define MAC_PCU_XRMODE_FRAME_HOLD_SET(x)         (((x) << MAC_PCU_XRMODE_FRAME_HOLD_LSB) & MAC_PCU_XRMODE_FRAME_HOLD_MASK)
#define MAC_PCU_XRMODE_WAIT_FOR_POLL_MSB         7
#define MAC_PCU_XRMODE_WAIT_FOR_POLL_LSB         7
#define MAC_PCU_XRMODE_WAIT_FOR_POLL_MASK        0x00000080
#define MAC_PCU_XRMODE_WAIT_FOR_POLL_GET(x)      (((x) & MAC_PCU_XRMODE_WAIT_FOR_POLL_MASK) >> MAC_PCU_XRMODE_WAIT_FOR_POLL_LSB)
#define MAC_PCU_XRMODE_WAIT_FOR_POLL_SET(x)      (((x) << MAC_PCU_XRMODE_WAIT_FOR_POLL_LSB) & MAC_PCU_XRMODE_WAIT_FOR_POLL_MASK)
#define MAC_PCU_XRMODE_POLL_TYPE_MSB             5
#define MAC_PCU_XRMODE_POLL_TYPE_LSB             0
#define MAC_PCU_XRMODE_POLL_TYPE_MASK            0x0000003f
#define MAC_PCU_XRMODE_POLL_TYPE_GET(x)          (((x) & MAC_PCU_XRMODE_POLL_TYPE_MASK) >> MAC_PCU_XRMODE_POLL_TYPE_LSB)
#define MAC_PCU_XRMODE_POLL_TYPE_SET(x)          (((x) << MAC_PCU_XRMODE_POLL_TYPE_LSB) & MAC_PCU_XRMODE_POLL_TYPE_MASK)

#define MAC_PCU_XRDEL_ADDRESS                    0x00008074
#define MAC_PCU_XRDEL_OFFSET                     0x00000074
#define MAC_PCU_XRDEL_CHIRP_DATA_DELAY_MSB       31
#define MAC_PCU_XRDEL_CHIRP_DATA_DELAY_LSB       16
#define MAC_PCU_XRDEL_CHIRP_DATA_DELAY_MASK      0xffff0000
#define MAC_PCU_XRDEL_CHIRP_DATA_DELAY_GET(x)    (((x) & MAC_PCU_XRDEL_CHIRP_DATA_DELAY_MASK) >> MAC_PCU_XRDEL_CHIRP_DATA_DELAY_LSB)
#define MAC_PCU_XRDEL_CHIRP_DATA_DELAY_SET(x)    (((x) << MAC_PCU_XRDEL_CHIRP_DATA_DELAY_LSB) & MAC_PCU_XRDEL_CHIRP_DATA_DELAY_MASK)
#define MAC_PCU_XRDEL_SLOT_DELAY_MSB             15
#define MAC_PCU_XRDEL_SLOT_DELAY_LSB             0
#define MAC_PCU_XRDEL_SLOT_DELAY_MASK            0x0000ffff
#define MAC_PCU_XRDEL_SLOT_DELAY_GET(x)          (((x) & MAC_PCU_XRDEL_SLOT_DELAY_MASK) >> MAC_PCU_XRDEL_SLOT_DELAY_LSB)
#define MAC_PCU_XRDEL_SLOT_DELAY_SET(x)          (((x) << MAC_PCU_XRDEL_SLOT_DELAY_LSB) & MAC_PCU_XRDEL_SLOT_DELAY_MASK)

#define MAC_PCU_XRTO_ADDRESS                     0x00008078
#define MAC_PCU_XRTO_OFFSET                      0x00000078
#define MAC_PCU_XRTO_POLL_TIMEOUT_MSB            31
#define MAC_PCU_XRTO_POLL_TIMEOUT_LSB            16
#define MAC_PCU_XRTO_POLL_TIMEOUT_MASK           0xffff0000
#define MAC_PCU_XRTO_POLL_TIMEOUT_GET(x)         (((x) & MAC_PCU_XRTO_POLL_TIMEOUT_MASK) >> MAC_PCU_XRTO_POLL_TIMEOUT_LSB)
#define MAC_PCU_XRTO_POLL_TIMEOUT_SET(x)         (((x) << MAC_PCU_XRTO_POLL_TIMEOUT_LSB) & MAC_PCU_XRTO_POLL_TIMEOUT_MASK)
#define MAC_PCU_XRTO_CHIRP_TIMEOUT_MSB           15
#define MAC_PCU_XRTO_CHIRP_TIMEOUT_LSB           0
#define MAC_PCU_XRTO_CHIRP_TIMEOUT_MASK          0x0000ffff
#define MAC_PCU_XRTO_CHIRP_TIMEOUT_GET(x)        (((x) & MAC_PCU_XRTO_CHIRP_TIMEOUT_MASK) >> MAC_PCU_XRTO_CHIRP_TIMEOUT_LSB)
#define MAC_PCU_XRTO_CHIRP_TIMEOUT_SET(x)        (((x) << MAC_PCU_XRTO_CHIRP_TIMEOUT_LSB) & MAC_PCU_XRTO_CHIRP_TIMEOUT_MASK)

#define MAC_PCU_XRCRP_ADDRESS                    0x0000807c
#define MAC_PCU_XRCRP_OFFSET                     0x0000007c
#define MAC_PCU_XRCRP_CHIRP_GAP_MSB              31
#define MAC_PCU_XRCRP_CHIRP_GAP_LSB              16
#define MAC_PCU_XRCRP_CHIRP_GAP_MASK             0xffff0000
#define MAC_PCU_XRCRP_CHIRP_GAP_GET(x)           (((x) & MAC_PCU_XRCRP_CHIRP_GAP_MASK) >> MAC_PCU_XRCRP_CHIRP_GAP_LSB)
#define MAC_PCU_XRCRP_CHIRP_GAP_SET(x)           (((x) << MAC_PCU_XRCRP_CHIRP_GAP_LSB) & MAC_PCU_XRCRP_CHIRP_GAP_MASK)
#define MAC_PCU_XRCRP_SEND_CHIRP_MSB             0
#define MAC_PCU_XRCRP_SEND_CHIRP_LSB             0
#define MAC_PCU_XRCRP_SEND_CHIRP_MASK            0x00000001
#define MAC_PCU_XRCRP_SEND_CHIRP_GET(x)          (((x) & MAC_PCU_XRCRP_SEND_CHIRP_MASK) >> MAC_PCU_XRCRP_SEND_CHIRP_LSB)
#define MAC_PCU_XRCRP_SEND_CHIRP_SET(x)          (((x) << MAC_PCU_XRCRP_SEND_CHIRP_LSB) & MAC_PCU_XRCRP_SEND_CHIRP_MASK)

#define MAC_PCU_XRSTMP_ADDRESS                   0x00008080
#define MAC_PCU_XRSTMP_OFFSET                    0x00000080
#define MAC_PCU_XRSTMP_RX_ABORT_RSSI_THRESH_MSB  23
#define MAC_PCU_XRSTMP_RX_ABORT_RSSI_THRESH_LSB  16
#define MAC_PCU_XRSTMP_RX_ABORT_RSSI_THRESH_MASK 0x00ff0000
#define MAC_PCU_XRSTMP_RX_ABORT_RSSI_THRESH_GET(x) (((x) & MAC_PCU_XRSTMP_RX_ABORT_RSSI_THRESH_MASK) >> MAC_PCU_XRSTMP_RX_ABORT_RSSI_THRESH_LSB)
#define MAC_PCU_XRSTMP_RX_ABORT_RSSI_THRESH_SET(x) (((x) << MAC_PCU_XRSTMP_RX_ABORT_RSSI_THRESH_LSB) & MAC_PCU_XRSTMP_RX_ABORT_RSSI_THRESH_MASK)
#define MAC_PCU_XRSTMP_TX_STOMP_RSSI_THRESH_MSB  15
#define MAC_PCU_XRSTMP_TX_STOMP_RSSI_THRESH_LSB  8
#define MAC_PCU_XRSTMP_TX_STOMP_RSSI_THRESH_MASK 0x0000ff00
#define MAC_PCU_XRSTMP_TX_STOMP_RSSI_THRESH_GET(x) (((x) & MAC_PCU_XRSTMP_TX_STOMP_RSSI_THRESH_MASK) >> MAC_PCU_XRSTMP_TX_STOMP_RSSI_THRESH_LSB)
#define MAC_PCU_XRSTMP_TX_STOMP_RSSI_THRESH_SET(x) (((x) << MAC_PCU_XRSTMP_TX_STOMP_RSSI_THRESH_LSB) & MAC_PCU_XRSTMP_TX_STOMP_RSSI_THRESH_MASK)
#define MAC_PCU_XRSTMP_RX_ABORT_DATA_MSB         5
#define MAC_PCU_XRSTMP_RX_ABORT_DATA_LSB         5
#define MAC_PCU_XRSTMP_RX_ABORT_DATA_MASK        0x00000020
#define MAC_PCU_XRSTMP_RX_ABORT_DATA_GET(x)      (((x) & MAC_PCU_XRSTMP_RX_ABORT_DATA_MASK) >> MAC_PCU_XRSTMP_RX_ABORT_DATA_LSB)
#define MAC_PCU_XRSTMP_RX_ABORT_DATA_SET(x)      (((x) << MAC_PCU_XRSTMP_RX_ABORT_DATA_LSB) & MAC_PCU_XRSTMP_RX_ABORT_DATA_MASK)
#define MAC_PCU_XRSTMP_TX_STOMP_DATA_MSB         4
#define MAC_PCU_XRSTMP_TX_STOMP_DATA_LSB         4
#define MAC_PCU_XRSTMP_TX_STOMP_DATA_MASK        0x00000010
#define MAC_PCU_XRSTMP_TX_STOMP_DATA_GET(x)      (((x) & MAC_PCU_XRSTMP_TX_STOMP_DATA_MASK) >> MAC_PCU_XRSTMP_TX_STOMP_DATA_LSB)
#define MAC_PCU_XRSTMP_TX_STOMP_DATA_SET(x)      (((x) << MAC_PCU_XRSTMP_TX_STOMP_DATA_LSB) & MAC_PCU_XRSTMP_TX_STOMP_DATA_MASK)
#define MAC_PCU_XRSTMP_TX_STOMP_BSSID_MSB        3
#define MAC_PCU_XRSTMP_TX_STOMP_BSSID_LSB        3
#define MAC_PCU_XRSTMP_TX_STOMP_BSSID_MASK       0x00000008
#define MAC_PCU_XRSTMP_TX_STOMP_BSSID_GET(x)     (((x) & MAC_PCU_XRSTMP_TX_STOMP_BSSID_MASK) >> MAC_PCU_XRSTMP_TX_STOMP_BSSID_LSB)
#define MAC_PCU_XRSTMP_TX_STOMP_BSSID_SET(x)     (((x) << MAC_PCU_XRSTMP_TX_STOMP_BSSID_LSB) & MAC_PCU_XRSTMP_TX_STOMP_BSSID_MASK)
#define MAC_PCU_XRSTMP_TX_STOMP_RSSI_MSB         2
#define MAC_PCU_XRSTMP_TX_STOMP_RSSI_LSB         2
#define MAC_PCU_XRSTMP_TX_STOMP_RSSI_MASK        0x00000004
#define MAC_PCU_XRSTMP_TX_STOMP_RSSI_GET(x)      (((x) & MAC_PCU_XRSTMP_TX_STOMP_RSSI_MASK) >> MAC_PCU_XRSTMP_TX_STOMP_RSSI_LSB)
#define MAC_PCU_XRSTMP_TX_STOMP_RSSI_SET(x)      (((x) << MAC_PCU_XRSTMP_TX_STOMP_RSSI_LSB) & MAC_PCU_XRSTMP_TX_STOMP_RSSI_MASK)
#define MAC_PCU_XRSTMP_RX_ABORT_BSSID_MSB        1
#define MAC_PCU_XRSTMP_RX_ABORT_BSSID_LSB        1
#define MAC_PCU_XRSTMP_RX_ABORT_BSSID_MASK       0x00000002
#define MAC_PCU_XRSTMP_RX_ABORT_BSSID_GET(x)     (((x) & MAC_PCU_XRSTMP_RX_ABORT_BSSID_MASK) >> MAC_PCU_XRSTMP_RX_ABORT_BSSID_LSB)
#define MAC_PCU_XRSTMP_RX_ABORT_BSSID_SET(x)     (((x) << MAC_PCU_XRSTMP_RX_ABORT_BSSID_LSB) & MAC_PCU_XRSTMP_RX_ABORT_BSSID_MASK)
#define MAC_PCU_XRSTMP_RX_ABORT_RSSI_MSB         0
#define MAC_PCU_XRSTMP_RX_ABORT_RSSI_LSB         0
#define MAC_PCU_XRSTMP_RX_ABORT_RSSI_MASK        0x00000001
#define MAC_PCU_XRSTMP_RX_ABORT_RSSI_GET(x)      (((x) & MAC_PCU_XRSTMP_RX_ABORT_RSSI_MASK) >> MAC_PCU_XRSTMP_RX_ABORT_RSSI_LSB)
#define MAC_PCU_XRSTMP_RX_ABORT_RSSI_SET(x)      (((x) << MAC_PCU_XRSTMP_RX_ABORT_RSSI_LSB) & MAC_PCU_XRSTMP_RX_ABORT_RSSI_MASK)

#define MAC_PCU_ADDR1_MASK_L32_ADDRESS           0x00008084
#define MAC_PCU_ADDR1_MASK_L32_OFFSET            0x00000084
#define MAC_PCU_ADDR1_MASK_L32_VALUE_MSB         31
#define MAC_PCU_ADDR1_MASK_L32_VALUE_LSB         0
#define MAC_PCU_ADDR1_MASK_L32_VALUE_MASK        0xffffffff
#define MAC_PCU_ADDR1_MASK_L32_VALUE_GET(x)      (((x) & MAC_PCU_ADDR1_MASK_L32_VALUE_MASK) >> MAC_PCU_ADDR1_MASK_L32_VALUE_LSB)
#define MAC_PCU_ADDR1_MASK_L32_VALUE_SET(x)      (((x) << MAC_PCU_ADDR1_MASK_L32_VALUE_LSB) & MAC_PCU_ADDR1_MASK_L32_VALUE_MASK)

#define MAC_PCU_ADDR1_MASK_U16_ADDRESS           0x00008088
#define MAC_PCU_ADDR1_MASK_U16_OFFSET            0x00000088
#define MAC_PCU_ADDR1_MASK_U16_VALUE_MSB         15
#define MAC_PCU_ADDR1_MASK_U16_VALUE_LSB         0
#define MAC_PCU_ADDR1_MASK_U16_VALUE_MASK        0x0000ffff
#define MAC_PCU_ADDR1_MASK_U16_VALUE_GET(x)      (((x) & MAC_PCU_ADDR1_MASK_U16_VALUE_MASK) >> MAC_PCU_ADDR1_MASK_U16_VALUE_LSB)
#define MAC_PCU_ADDR1_MASK_U16_VALUE_SET(x)      (((x) << MAC_PCU_ADDR1_MASK_U16_VALUE_LSB) & MAC_PCU_ADDR1_MASK_U16_VALUE_MASK)

#define MAC_PCU_TPC_ADDRESS                      0x0000808c
#define MAC_PCU_TPC_OFFSET                       0x0000008c
#define MAC_PCU_TPC_CHIRP_PWR_MSB                21
#define MAC_PCU_TPC_CHIRP_PWR_LSB                16
#define MAC_PCU_TPC_CHIRP_PWR_MASK               0x003f0000
#define MAC_PCU_TPC_CHIRP_PWR_GET(x)             (((x) & MAC_PCU_TPC_CHIRP_PWR_MASK) >> MAC_PCU_TPC_CHIRP_PWR_LSB)
#define MAC_PCU_TPC_CHIRP_PWR_SET(x)             (((x) << MAC_PCU_TPC_CHIRP_PWR_LSB) & MAC_PCU_TPC_CHIRP_PWR_MASK)
#define MAC_PCU_TPC_CTS_PWR_MSB                  13
#define MAC_PCU_TPC_CTS_PWR_LSB                  8
#define MAC_PCU_TPC_CTS_PWR_MASK                 0x00003f00
#define MAC_PCU_TPC_CTS_PWR_GET(x)               (((x) & MAC_PCU_TPC_CTS_PWR_MASK) >> MAC_PCU_TPC_CTS_PWR_LSB)
#define MAC_PCU_TPC_CTS_PWR_SET(x)               (((x) << MAC_PCU_TPC_CTS_PWR_LSB) & MAC_PCU_TPC_CTS_PWR_MASK)
#define MAC_PCU_TPC_ACK_PWR_MSB                  5
#define MAC_PCU_TPC_ACK_PWR_LSB                  0
#define MAC_PCU_TPC_ACK_PWR_MASK                 0x0000003f
#define MAC_PCU_TPC_ACK_PWR_GET(x)               (((x) & MAC_PCU_TPC_ACK_PWR_MASK) >> MAC_PCU_TPC_ACK_PWR_LSB)
#define MAC_PCU_TPC_ACK_PWR_SET(x)               (((x) << MAC_PCU_TPC_ACK_PWR_LSB) & MAC_PCU_TPC_ACK_PWR_MASK)

#define MAC_PCU_TX_FRAME_CNT_ADDRESS             0x00008090
#define MAC_PCU_TX_FRAME_CNT_OFFSET              0x00000090
#define MAC_PCU_TX_FRAME_CNT_VALUE_MSB           31
#define MAC_PCU_TX_FRAME_CNT_VALUE_LSB           0
#define MAC_PCU_TX_FRAME_CNT_VALUE_MASK          0xffffffff
#define MAC_PCU_TX_FRAME_CNT_VALUE_GET(x)        (((x) & MAC_PCU_TX_FRAME_CNT_VALUE_MASK) >> MAC_PCU_TX_FRAME_CNT_VALUE_LSB)
#define MAC_PCU_TX_FRAME_CNT_VALUE_SET(x)        (((x) << MAC_PCU_TX_FRAME_CNT_VALUE_LSB) & MAC_PCU_TX_FRAME_CNT_VALUE_MASK)

#define MAC_PCU_RX_FRAME_CNT_ADDRESS             0x00008094
#define MAC_PCU_RX_FRAME_CNT_OFFSET              0x00000094
#define MAC_PCU_RX_FRAME_CNT_VALUE_MSB           31
#define MAC_PCU_RX_FRAME_CNT_VALUE_LSB           0
#define MAC_PCU_RX_FRAME_CNT_VALUE_MASK          0xffffffff
#define MAC_PCU_RX_FRAME_CNT_VALUE_GET(x)        (((x) & MAC_PCU_RX_FRAME_CNT_VALUE_MASK) >> MAC_PCU_RX_FRAME_CNT_VALUE_LSB)
#define MAC_PCU_RX_FRAME_CNT_VALUE_SET(x)        (((x) << MAC_PCU_RX_FRAME_CNT_VALUE_LSB) & MAC_PCU_RX_FRAME_CNT_VALUE_MASK)

#define MAC_PCU_RX_CLEAR_CNT_ADDRESS             0x00008098
#define MAC_PCU_RX_CLEAR_CNT_OFFSET              0x00000098
#define MAC_PCU_RX_CLEAR_CNT_VALUE_MSB           31
#define MAC_PCU_RX_CLEAR_CNT_VALUE_LSB           0
#define MAC_PCU_RX_CLEAR_CNT_VALUE_MASK          0xffffffff
#define MAC_PCU_RX_CLEAR_CNT_VALUE_GET(x)        (((x) & MAC_PCU_RX_CLEAR_CNT_VALUE_MASK) >> MAC_PCU_RX_CLEAR_CNT_VALUE_LSB)
#define MAC_PCU_RX_CLEAR_CNT_VALUE_SET(x)        (((x) << MAC_PCU_RX_CLEAR_CNT_VALUE_LSB) & MAC_PCU_RX_CLEAR_CNT_VALUE_MASK)

#define MAC_PCU_CYCLE_CNT_ADDRESS                0x0000809c
#define MAC_PCU_CYCLE_CNT_OFFSET                 0x0000009c
#define MAC_PCU_CYCLE_CNT_VALUE_MSB              31
#define MAC_PCU_CYCLE_CNT_VALUE_LSB              0
#define MAC_PCU_CYCLE_CNT_VALUE_MASK             0xffffffff
#define MAC_PCU_CYCLE_CNT_VALUE_GET(x)           (((x) & MAC_PCU_CYCLE_CNT_VALUE_MASK) >> MAC_PCU_CYCLE_CNT_VALUE_LSB)
#define MAC_PCU_CYCLE_CNT_VALUE_SET(x)           (((x) << MAC_PCU_CYCLE_CNT_VALUE_LSB) & MAC_PCU_CYCLE_CNT_VALUE_MASK)

#define MAC_PCU_QUIET_TIME_1_ADDRESS             0x000080a0
#define MAC_PCU_QUIET_TIME_1_OFFSET              0x000000a0
#define MAC_PCU_QUIET_TIME_1_ACK_CTS_ENABLE_MSB  17
#define MAC_PCU_QUIET_TIME_1_ACK_CTS_ENABLE_LSB  17
#define MAC_PCU_QUIET_TIME_1_ACK_CTS_ENABLE_MASK 0x00020000
#define MAC_PCU_QUIET_TIME_1_ACK_CTS_ENABLE_GET(x) (((x) & MAC_PCU_QUIET_TIME_1_ACK_CTS_ENABLE_MASK) >> MAC_PCU_QUIET_TIME_1_ACK_CTS_ENABLE_LSB)
#define MAC_PCU_QUIET_TIME_1_ACK_CTS_ENABLE_SET(x) (((x) << MAC_PCU_QUIET_TIME_1_ACK_CTS_ENABLE_LSB) & MAC_PCU_QUIET_TIME_1_ACK_CTS_ENABLE_MASK)

#define MAC_PCU_QUIET_TIME_2_ADDRESS             0x000080a4
#define MAC_PCU_QUIET_TIME_2_OFFSET              0x000000a4
#define MAC_PCU_QUIET_TIME_2_DURATION_MSB        31
#define MAC_PCU_QUIET_TIME_2_DURATION_LSB        16
#define MAC_PCU_QUIET_TIME_2_DURATION_MASK       0xffff0000
#define MAC_PCU_QUIET_TIME_2_DURATION_GET(x)     (((x) & MAC_PCU_QUIET_TIME_2_DURATION_MASK) >> MAC_PCU_QUIET_TIME_2_DURATION_LSB)
#define MAC_PCU_QUIET_TIME_2_DURATION_SET(x)     (((x) << MAC_PCU_QUIET_TIME_2_DURATION_LSB) & MAC_PCU_QUIET_TIME_2_DURATION_MASK)

#define MAC_PCU_QOS_NO_ACK_ADDRESS               0x000080a8
#define MAC_PCU_QOS_NO_ACK_OFFSET                0x000000a8
#define MAC_PCU_QOS_NO_ACK_BYTE_OFFSET_MSB       8
#define MAC_PCU_QOS_NO_ACK_BYTE_OFFSET_LSB       7
#define MAC_PCU_QOS_NO_ACK_BYTE_OFFSET_MASK      0x00000180
#define MAC_PCU_QOS_NO_ACK_BYTE_OFFSET_GET(x)    (((x) & MAC_PCU_QOS_NO_ACK_BYTE_OFFSET_MASK) >> MAC_PCU_QOS_NO_ACK_BYTE_OFFSET_LSB)
#define MAC_PCU_QOS_NO_ACK_BYTE_OFFSET_SET(x)    (((x) << MAC_PCU_QOS_NO_ACK_BYTE_OFFSET_LSB) & MAC_PCU_QOS_NO_ACK_BYTE_OFFSET_MASK)
#define MAC_PCU_QOS_NO_ACK_BIT_OFFSET_MSB        6
#define MAC_PCU_QOS_NO_ACK_BIT_OFFSET_LSB        4
#define MAC_PCU_QOS_NO_ACK_BIT_OFFSET_MASK       0x00000070
#define MAC_PCU_QOS_NO_ACK_BIT_OFFSET_GET(x)     (((x) & MAC_PCU_QOS_NO_ACK_BIT_OFFSET_MASK) >> MAC_PCU_QOS_NO_ACK_BIT_OFFSET_LSB)
#define MAC_PCU_QOS_NO_ACK_BIT_OFFSET_SET(x)     (((x) << MAC_PCU_QOS_NO_ACK_BIT_OFFSET_LSB) & MAC_PCU_QOS_NO_ACK_BIT_OFFSET_MASK)
#define MAC_PCU_QOS_NO_ACK_TWO_BIT_VALUES_MSB    3
#define MAC_PCU_QOS_NO_ACK_TWO_BIT_VALUES_LSB    0
#define MAC_PCU_QOS_NO_ACK_TWO_BIT_VALUES_MASK   0x0000000f
#define MAC_PCU_QOS_NO_ACK_TWO_BIT_VALUES_GET(x) (((x) & MAC_PCU_QOS_NO_ACK_TWO_BIT_VALUES_MASK) >> MAC_PCU_QOS_NO_ACK_TWO_BIT_VALUES_LSB)
#define MAC_PCU_QOS_NO_ACK_TWO_BIT_VALUES_SET(x) (((x) << MAC_PCU_QOS_NO_ACK_TWO_BIT_VALUES_LSB) & MAC_PCU_QOS_NO_ACK_TWO_BIT_VALUES_MASK)

#define MAC_PCU_PHY_ERROR_MASK_ADDRESS           0x000080ac
#define MAC_PCU_PHY_ERROR_MASK_OFFSET            0x000000ac
#define MAC_PCU_PHY_ERROR_MASK_VALUE_MSB         31
#define MAC_PCU_PHY_ERROR_MASK_VALUE_LSB         0
#define MAC_PCU_PHY_ERROR_MASK_VALUE_MASK        0xffffffff
#define MAC_PCU_PHY_ERROR_MASK_VALUE_GET(x)      (((x) & MAC_PCU_PHY_ERROR_MASK_VALUE_MASK) >> MAC_PCU_PHY_ERROR_MASK_VALUE_LSB)
#define MAC_PCU_PHY_ERROR_MASK_VALUE_SET(x)      (((x) << MAC_PCU_PHY_ERROR_MASK_VALUE_LSB) & MAC_PCU_PHY_ERROR_MASK_VALUE_MASK)

#define MAC_PCU_XRLAT_ADDRESS                    0x000080b0
#define MAC_PCU_XRLAT_OFFSET                     0x000000b0
#define MAC_PCU_XRLAT_VALUE_MSB                  11
#define MAC_PCU_XRLAT_VALUE_LSB                  0
#define MAC_PCU_XRLAT_VALUE_MASK                 0x00000fff
#define MAC_PCU_XRLAT_VALUE_GET(x)               (((x) & MAC_PCU_XRLAT_VALUE_MASK) >> MAC_PCU_XRLAT_VALUE_LSB)
#define MAC_PCU_XRLAT_VALUE_SET(x)               (((x) << MAC_PCU_XRLAT_VALUE_LSB) & MAC_PCU_XRLAT_VALUE_MASK)

#define MAC_PCU_RXBUF_ADDRESS                    0x000080b4
#define MAC_PCU_RXBUF_OFFSET                     0x000000b4
#define MAC_PCU_RXBUF_REG_RD_ENABLE_MSB          11
#define MAC_PCU_RXBUF_REG_RD_ENABLE_LSB          11
#define MAC_PCU_RXBUF_REG_RD_ENABLE_MASK         0x00000800
#define MAC_PCU_RXBUF_REG_RD_ENABLE_GET(x)       (((x) & MAC_PCU_RXBUF_REG_RD_ENABLE_MASK) >> MAC_PCU_RXBUF_REG_RD_ENABLE_LSB)
#define MAC_PCU_RXBUF_REG_RD_ENABLE_SET(x)       (((x) << MAC_PCU_RXBUF_REG_RD_ENABLE_LSB) & MAC_PCU_RXBUF_REG_RD_ENABLE_MASK)
#define MAC_PCU_RXBUF_HIGH_PRIORITY_THRSHD_MSB   10
#define MAC_PCU_RXBUF_HIGH_PRIORITY_THRSHD_LSB   0
#define MAC_PCU_RXBUF_HIGH_PRIORITY_THRSHD_MASK  0x000007ff
#define MAC_PCU_RXBUF_HIGH_PRIORITY_THRSHD_GET(x) (((x) & MAC_PCU_RXBUF_HIGH_PRIORITY_THRSHD_MASK) >> MAC_PCU_RXBUF_HIGH_PRIORITY_THRSHD_LSB)
#define MAC_PCU_RXBUF_HIGH_PRIORITY_THRSHD_SET(x) (((x) << MAC_PCU_RXBUF_HIGH_PRIORITY_THRSHD_LSB) & MAC_PCU_RXBUF_HIGH_PRIORITY_THRSHD_MASK)

#define MAC_PCU_MIC_QOS_CONTROL_ADDRESS          0x000080b8
#define MAC_PCU_MIC_QOS_CONTROL_OFFSET           0x000000b8
#define MAC_PCU_MIC_QOS_CONTROL_ENABLE_MSB       16
#define MAC_PCU_MIC_QOS_CONTROL_ENABLE_LSB       16
#define MAC_PCU_MIC_QOS_CONTROL_ENABLE_MASK      0x00010000
#define MAC_PCU_MIC_QOS_CONTROL_ENABLE_GET(x)    (((x) & MAC_PCU_MIC_QOS_CONTROL_ENABLE_MASK) >> MAC_PCU_MIC_QOS_CONTROL_ENABLE_LSB)
#define MAC_PCU_MIC_QOS_CONTROL_ENABLE_SET(x)    (((x) << MAC_PCU_MIC_QOS_CONTROL_ENABLE_LSB) & MAC_PCU_MIC_QOS_CONTROL_ENABLE_MASK)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_7_MSB      15
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_7_LSB      14
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_7_MASK     0x0000c000
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_7_GET(x)   (((x) & MAC_PCU_MIC_QOS_CONTROL_VALUE_7_MASK) >> MAC_PCU_MIC_QOS_CONTROL_VALUE_7_LSB)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_7_SET(x)   (((x) << MAC_PCU_MIC_QOS_CONTROL_VALUE_7_LSB) & MAC_PCU_MIC_QOS_CONTROL_VALUE_7_MASK)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_6_MSB      13
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_6_LSB      12
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_6_MASK     0x00003000
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_6_GET(x)   (((x) & MAC_PCU_MIC_QOS_CONTROL_VALUE_6_MASK) >> MAC_PCU_MIC_QOS_CONTROL_VALUE_6_LSB)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_6_SET(x)   (((x) << MAC_PCU_MIC_QOS_CONTROL_VALUE_6_LSB) & MAC_PCU_MIC_QOS_CONTROL_VALUE_6_MASK)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_5_MSB      11
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_5_LSB      10
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_5_MASK     0x00000c00
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_5_GET(x)   (((x) & MAC_PCU_MIC_QOS_CONTROL_VALUE_5_MASK) >> MAC_PCU_MIC_QOS_CONTROL_VALUE_5_LSB)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_5_SET(x)   (((x) << MAC_PCU_MIC_QOS_CONTROL_VALUE_5_LSB) & MAC_PCU_MIC_QOS_CONTROL_VALUE_5_MASK)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_4_MSB      9
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_4_LSB      8
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_4_MASK     0x00000300
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_4_GET(x)   (((x) & MAC_PCU_MIC_QOS_CONTROL_VALUE_4_MASK) >> MAC_PCU_MIC_QOS_CONTROL_VALUE_4_LSB)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_4_SET(x)   (((x) << MAC_PCU_MIC_QOS_CONTROL_VALUE_4_LSB) & MAC_PCU_MIC_QOS_CONTROL_VALUE_4_MASK)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_3_MSB      7
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_3_LSB      6
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_3_MASK     0x000000c0
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_3_GET(x)   (((x) & MAC_PCU_MIC_QOS_CONTROL_VALUE_3_MASK) >> MAC_PCU_MIC_QOS_CONTROL_VALUE_3_LSB)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_3_SET(x)   (((x) << MAC_PCU_MIC_QOS_CONTROL_VALUE_3_LSB) & MAC_PCU_MIC_QOS_CONTROL_VALUE_3_MASK)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_2_MSB      5
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_2_LSB      4
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_2_MASK     0x00000030
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_2_GET(x)   (((x) & MAC_PCU_MIC_QOS_CONTROL_VALUE_2_MASK) >> MAC_PCU_MIC_QOS_CONTROL_VALUE_2_LSB)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_2_SET(x)   (((x) << MAC_PCU_MIC_QOS_CONTROL_VALUE_2_LSB) & MAC_PCU_MIC_QOS_CONTROL_VALUE_2_MASK)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_1_MSB      3
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_1_LSB      2
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_1_MASK     0x0000000c
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_1_GET(x)   (((x) & MAC_PCU_MIC_QOS_CONTROL_VALUE_1_MASK) >> MAC_PCU_MIC_QOS_CONTROL_VALUE_1_LSB)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_1_SET(x)   (((x) << MAC_PCU_MIC_QOS_CONTROL_VALUE_1_LSB) & MAC_PCU_MIC_QOS_CONTROL_VALUE_1_MASK)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_0_MSB      1
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_0_LSB      0
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_0_MASK     0x00000003
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_0_GET(x)   (((x) & MAC_PCU_MIC_QOS_CONTROL_VALUE_0_MASK) >> MAC_PCU_MIC_QOS_CONTROL_VALUE_0_LSB)
#define MAC_PCU_MIC_QOS_CONTROL_VALUE_0_SET(x)   (((x) << MAC_PCU_MIC_QOS_CONTROL_VALUE_0_LSB) & MAC_PCU_MIC_QOS_CONTROL_VALUE_0_MASK)

#define MAC_PCU_MIC_QOS_SELECT_ADDRESS           0x000080bc
#define MAC_PCU_MIC_QOS_SELECT_OFFSET            0x000000bc
#define MAC_PCU_MIC_QOS_SELECT_VALUE_7_MSB       31
#define MAC_PCU_MIC_QOS_SELECT_VALUE_7_LSB       28
#define MAC_PCU_MIC_QOS_SELECT_VALUE_7_MASK      0xf0000000
#define MAC_PCU_MIC_QOS_SELECT_VALUE_7_GET(x)    (((x) & MAC_PCU_MIC_QOS_SELECT_VALUE_7_MASK) >> MAC_PCU_MIC_QOS_SELECT_VALUE_7_LSB)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_7_SET(x)    (((x) << MAC_PCU_MIC_QOS_SELECT_VALUE_7_LSB) & MAC_PCU_MIC_QOS_SELECT_VALUE_7_MASK)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_6_MSB       27
#define MAC_PCU_MIC_QOS_SELECT_VALUE_6_LSB       24
#define MAC_PCU_MIC_QOS_SELECT_VALUE_6_MASK      0x0f000000
#define MAC_PCU_MIC_QOS_SELECT_VALUE_6_GET(x)    (((x) & MAC_PCU_MIC_QOS_SELECT_VALUE_6_MASK) >> MAC_PCU_MIC_QOS_SELECT_VALUE_6_LSB)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_6_SET(x)    (((x) << MAC_PCU_MIC_QOS_SELECT_VALUE_6_LSB) & MAC_PCU_MIC_QOS_SELECT_VALUE_6_MASK)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_5_MSB       23
#define MAC_PCU_MIC_QOS_SELECT_VALUE_5_LSB       20
#define MAC_PCU_MIC_QOS_SELECT_VALUE_5_MASK      0x00f00000
#define MAC_PCU_MIC_QOS_SELECT_VALUE_5_GET(x)    (((x) & MAC_PCU_MIC_QOS_SELECT_VALUE_5_MASK) >> MAC_PCU_MIC_QOS_SELECT_VALUE_5_LSB)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_5_SET(x)    (((x) << MAC_PCU_MIC_QOS_SELECT_VALUE_5_LSB) & MAC_PCU_MIC_QOS_SELECT_VALUE_5_MASK)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_4_MSB       19
#define MAC_PCU_MIC_QOS_SELECT_VALUE_4_LSB       16
#define MAC_PCU_MIC_QOS_SELECT_VALUE_4_MASK      0x000f0000
#define MAC_PCU_MIC_QOS_SELECT_VALUE_4_GET(x)    (((x) & MAC_PCU_MIC_QOS_SELECT_VALUE_4_MASK) >> MAC_PCU_MIC_QOS_SELECT_VALUE_4_LSB)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_4_SET(x)    (((x) << MAC_PCU_MIC_QOS_SELECT_VALUE_4_LSB) & MAC_PCU_MIC_QOS_SELECT_VALUE_4_MASK)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_3_MSB       15
#define MAC_PCU_MIC_QOS_SELECT_VALUE_3_LSB       12
#define MAC_PCU_MIC_QOS_SELECT_VALUE_3_MASK      0x0000f000
#define MAC_PCU_MIC_QOS_SELECT_VALUE_3_GET(x)    (((x) & MAC_PCU_MIC_QOS_SELECT_VALUE_3_MASK) >> MAC_PCU_MIC_QOS_SELECT_VALUE_3_LSB)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_3_SET(x)    (((x) << MAC_PCU_MIC_QOS_SELECT_VALUE_3_LSB) & MAC_PCU_MIC_QOS_SELECT_VALUE_3_MASK)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_2_MSB       11
#define MAC_PCU_MIC_QOS_SELECT_VALUE_2_LSB       8
#define MAC_PCU_MIC_QOS_SELECT_VALUE_2_MASK      0x00000f00
#define MAC_PCU_MIC_QOS_SELECT_VALUE_2_GET(x)    (((x) & MAC_PCU_MIC_QOS_SELECT_VALUE_2_MASK) >> MAC_PCU_MIC_QOS_SELECT_VALUE_2_LSB)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_2_SET(x)    (((x) << MAC_PCU_MIC_QOS_SELECT_VALUE_2_LSB) & MAC_PCU_MIC_QOS_SELECT_VALUE_2_MASK)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_1_MSB       7
#define MAC_PCU_MIC_QOS_SELECT_VALUE_1_LSB       4
#define MAC_PCU_MIC_QOS_SELECT_VALUE_1_MASK      0x000000f0
#define MAC_PCU_MIC_QOS_SELECT_VALUE_1_GET(x)    (((x) & MAC_PCU_MIC_QOS_SELECT_VALUE_1_MASK) >> MAC_PCU_MIC_QOS_SELECT_VALUE_1_LSB)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_1_SET(x)    (((x) << MAC_PCU_MIC_QOS_SELECT_VALUE_1_LSB) & MAC_PCU_MIC_QOS_SELECT_VALUE_1_MASK)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_0_MSB       3
#define MAC_PCU_MIC_QOS_SELECT_VALUE_0_LSB       0
#define MAC_PCU_MIC_QOS_SELECT_VALUE_0_MASK      0x0000000f
#define MAC_PCU_MIC_QOS_SELECT_VALUE_0_GET(x)    (((x) & MAC_PCU_MIC_QOS_SELECT_VALUE_0_MASK) >> MAC_PCU_MIC_QOS_SELECT_VALUE_0_LSB)
#define MAC_PCU_MIC_QOS_SELECT_VALUE_0_SET(x)    (((x) << MAC_PCU_MIC_QOS_SELECT_VALUE_0_LSB) & MAC_PCU_MIC_QOS_SELECT_VALUE_0_MASK)

#define MAC_PCU_MISC_MODE_ADDRESS                0x000080c0
#define MAC_PCU_MISC_MODE_OFFSET                 0x000000c0
#define MAC_PCU_MISC_MODE_DEBUG_MODE_MSB         31
#define MAC_PCU_MISC_MODE_DEBUG_MODE_LSB         30
#define MAC_PCU_MISC_MODE_DEBUG_MODE_MASK        0xc0000000
#define MAC_PCU_MISC_MODE_DEBUG_MODE_GET(x)      (((x) & MAC_PCU_MISC_MODE_DEBUG_MODE_MASK) >> MAC_PCU_MISC_MODE_DEBUG_MODE_LSB)
#define MAC_PCU_MISC_MODE_DEBUG_MODE_SET(x)      (((x) << MAC_PCU_MISC_MODE_DEBUG_MODE_LSB) & MAC_PCU_MISC_MODE_DEBUG_MODE_MASK)
#define MAC_PCU_MISC_MODE_USE_EOP_PTR_FOR_DMA_WR_MSB 29
#define MAC_PCU_MISC_MODE_USE_EOP_PTR_FOR_DMA_WR_LSB 29
#define MAC_PCU_MISC_MODE_USE_EOP_PTR_FOR_DMA_WR_MASK 0x20000000
#define MAC_PCU_MISC_MODE_USE_EOP_PTR_FOR_DMA_WR_GET(x) (((x) & MAC_PCU_MISC_MODE_USE_EOP_PTR_FOR_DMA_WR_MASK) >> MAC_PCU_MISC_MODE_USE_EOP_PTR_FOR_DMA_WR_LSB)
#define MAC_PCU_MISC_MODE_USE_EOP_PTR_FOR_DMA_WR_SET(x) (((x) << MAC_PCU_MISC_MODE_USE_EOP_PTR_FOR_DMA_WR_LSB) & MAC_PCU_MISC_MODE_USE_EOP_PTR_FOR_DMA_WR_MASK)
#define MAC_PCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_MSB 28
#define MAC_PCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_LSB 28
#define MAC_PCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_MASK 0x10000000
#define MAC_PCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_GET(x) (((x) & MAC_PCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_MASK) >> MAC_PCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_LSB)
#define MAC_PCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_SET(x) (((x) << MAC_PCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_LSB) & MAC_PCU_MISC_MODE_ALWAYS_PERFORM_KEY_SEARCH_MASK)
#define MAC_PCU_MISC_MODE_SEL_EVM_MSB            27
#define MAC_PCU_MISC_MODE_SEL_EVM_LSB            27
#define MAC_PCU_MISC_MODE_SEL_EVM_MASK           0x08000000
#define MAC_PCU_MISC_MODE_SEL_EVM_GET(x)         (((x) & MAC_PCU_MISC_MODE_SEL_EVM_MASK) >> MAC_PCU_MISC_MODE_SEL_EVM_LSB)
#define MAC_PCU_MISC_MODE_SEL_EVM_SET(x)         (((x) << MAC_PCU_MISC_MODE_SEL_EVM_LSB) & MAC_PCU_MISC_MODE_SEL_EVM_MASK)
#define MAC_PCU_MISC_MODE_CLEAR_BA_VALID_MSB     26
#define MAC_PCU_MISC_MODE_CLEAR_BA_VALID_LSB     26
#define MAC_PCU_MISC_MODE_CLEAR_BA_VALID_MASK    0x04000000
#define MAC_PCU_MISC_MODE_CLEAR_BA_VALID_GET(x)  (((x) & MAC_PCU_MISC_MODE_CLEAR_BA_VALID_MASK) >> MAC_PCU_MISC_MODE_CLEAR_BA_VALID_LSB)
#define MAC_PCU_MISC_MODE_CLEAR_BA_VALID_SET(x)  (((x) << MAC_PCU_MISC_MODE_CLEAR_BA_VALID_LSB) & MAC_PCU_MISC_MODE_CLEAR_BA_VALID_MASK)
#define MAC_PCU_MISC_MODE_CLEAR_FIRST_HCF_MSB    25
#define MAC_PCU_MISC_MODE_CLEAR_FIRST_HCF_LSB    25
#define MAC_PCU_MISC_MODE_CLEAR_FIRST_HCF_MASK   0x02000000
#define MAC_PCU_MISC_MODE_CLEAR_FIRST_HCF_GET(x) (((x) & MAC_PCU_MISC_MODE_CLEAR_FIRST_HCF_MASK) >> MAC_PCU_MISC_MODE_CLEAR_FIRST_HCF_LSB)
#define MAC_PCU_MISC_MODE_CLEAR_FIRST_HCF_SET(x) (((x) << MAC_PCU_MISC_MODE_CLEAR_FIRST_HCF_LSB) & MAC_PCU_MISC_MODE_CLEAR_FIRST_HCF_MASK)
#define MAC_PCU_MISC_MODE_CLEAR_VMF_MSB          24
#define MAC_PCU_MISC_MODE_CLEAR_VMF_LSB          24
#define MAC_PCU_MISC_MODE_CLEAR_VMF_MASK         0x01000000
#define MAC_PCU_MISC_MODE_CLEAR_VMF_GET(x)       (((x) & MAC_PCU_MISC_MODE_CLEAR_VMF_MASK) >> MAC_PCU_MISC_MODE_CLEAR_VMF_LSB)
#define MAC_PCU_MISC_MODE_CLEAR_VMF_SET(x)       (((x) << MAC_PCU_MISC_MODE_CLEAR_VMF_LSB) & MAC_PCU_MISC_MODE_CLEAR_VMF_MASK)
#define MAC_PCU_MISC_MODE_RX_HCF_POLL_ENABLE_MSB 23
#define MAC_PCU_MISC_MODE_RX_HCF_POLL_ENABLE_LSB 23
#define MAC_PCU_MISC_MODE_RX_HCF_POLL_ENABLE_MASK 0x00800000
#define MAC_PCU_MISC_MODE_RX_HCF_POLL_ENABLE_GET(x) (((x) & MAC_PCU_MISC_MODE_RX_HCF_POLL_ENABLE_MASK) >> MAC_PCU_MISC_MODE_RX_HCF_POLL_ENABLE_LSB)
#define MAC_PCU_MISC_MODE_RX_HCF_POLL_ENABLE_SET(x) (((x) << MAC_PCU_MISC_MODE_RX_HCF_POLL_ENABLE_LSB) & MAC_PCU_MISC_MODE_RX_HCF_POLL_ENABLE_MASK)
#define MAC_PCU_MISC_MODE_HCF_POLL_CANCELS_NAV_MSB 22
#define MAC_PCU_MISC_MODE_HCF_POLL_CANCELS_NAV_LSB 22
#define MAC_PCU_MISC_MODE_HCF_POLL_CANCELS_NAV_MASK 0x00400000
#define MAC_PCU_MISC_MODE_HCF_POLL_CANCELS_NAV_GET(x) (((x) & MAC_PCU_MISC_MODE_HCF_POLL_CANCELS_NAV_MASK) >> MAC_PCU_MISC_MODE_HCF_POLL_CANCELS_NAV_LSB)
#define MAC_PCU_MISC_MODE_HCF_POLL_CANCELS_NAV_SET(x) (((x) << MAC_PCU_MISC_MODE_HCF_POLL_CANCELS_NAV_LSB) & MAC_PCU_MISC_MODE_HCF_POLL_CANCELS_NAV_MASK)
#define MAC_PCU_MISC_MODE_TBTT_PROTECT_MSB       21
#define MAC_PCU_MISC_MODE_TBTT_PROTECT_LSB       21
#define MAC_PCU_MISC_MODE_TBTT_PROTECT_MASK      0x00200000
#define MAC_PCU_MISC_MODE_TBTT_PROTECT_GET(x)    (((x) & MAC_PCU_MISC_MODE_TBTT_PROTECT_MASK) >> MAC_PCU_MISC_MODE_TBTT_PROTECT_LSB)
#define MAC_PCU_MISC_MODE_TBTT_PROTECT_SET(x)    (((x) << MAC_PCU_MISC_MODE_TBTT_PROTECT_LSB) & MAC_PCU_MISC_MODE_TBTT_PROTECT_MASK)
#define MAC_PCU_MISC_MODE_BT_ANT_PREVENTS_RX_MSB 20
#define MAC_PCU_MISC_MODE_BT_ANT_PREVENTS_RX_LSB 20
#define MAC_PCU_MISC_MODE_BT_ANT_PREVENTS_RX_MASK 0x00100000
#define MAC_PCU_MISC_MODE_BT_ANT_PREVENTS_RX_GET(x) (((x) & MAC_PCU_MISC_MODE_BT_ANT_PREVENTS_RX_MASK) >> MAC_PCU_MISC_MODE_BT_ANT_PREVENTS_RX_LSB)
#define MAC_PCU_MISC_MODE_BT_ANT_PREVENTS_RX_SET(x) (((x) << MAC_PCU_MISC_MODE_BT_ANT_PREVENTS_RX_LSB) & MAC_PCU_MISC_MODE_BT_ANT_PREVENTS_RX_MASK)
#define MAC_PCU_MISC_MODE_FORCE_QUIET_COLLISION_MSB 18
#define MAC_PCU_MISC_MODE_FORCE_QUIET_COLLISION_LSB 18
#define MAC_PCU_MISC_MODE_FORCE_QUIET_COLLISION_MASK 0x00040000
#define MAC_PCU_MISC_MODE_FORCE_QUIET_COLLISION_GET(x) (((x) & MAC_PCU_MISC_MODE_FORCE_QUIET_COLLISION_MASK) >> MAC_PCU_MISC_MODE_FORCE_QUIET_COLLISION_LSB)
#define MAC_PCU_MISC_MODE_FORCE_QUIET_COLLISION_SET(x) (((x) << MAC_PCU_MISC_MODE_FORCE_QUIET_COLLISION_LSB) & MAC_PCU_MISC_MODE_FORCE_QUIET_COLLISION_MASK)
#define MAC_PCU_MISC_MODE_MISS_BEACON_IN_SLEEP_MSB 14
#define MAC_PCU_MISC_MODE_MISS_BEACON_IN_SLEEP_LSB 14
#define MAC_PCU_MISC_MODE_MISS_BEACON_IN_SLEEP_MASK 0x00004000
#define MAC_PCU_MISC_MODE_MISS_BEACON_IN_SLEEP_GET(x) (((x) & MAC_PCU_MISC_MODE_MISS_BEACON_IN_SLEEP_MASK) >> MAC_PCU_MISC_MODE_MISS_BEACON_IN_SLEEP_LSB)
#define MAC_PCU_MISC_MODE_MISS_BEACON_IN_SLEEP_SET(x) (((x) << MAC_PCU_MISC_MODE_MISS_BEACON_IN_SLEEP_LSB) & MAC_PCU_MISC_MODE_MISS_BEACON_IN_SLEEP_MASK)
#define MAC_PCU_MISC_MODE_TXOP_TBTT_LIMIT_ENABLE_MSB 12
#define MAC_PCU_MISC_MODE_TXOP_TBTT_LIMIT_ENABLE_LSB 12
#define MAC_PCU_MISC_MODE_TXOP_TBTT_LIMIT_ENABLE_MASK 0x00001000
#define MAC_PCU_MISC_MODE_TXOP_TBTT_LIMIT_ENABLE_GET(x) (((x) & MAC_PCU_MISC_MODE_TXOP_TBTT_LIMIT_ENABLE_MASK) >> MAC_PCU_MISC_MODE_TXOP_TBTT_LIMIT_ENABLE_LSB)
#define MAC_PCU_MISC_MODE_TXOP_TBTT_LIMIT_ENABLE_SET(x) (((x) << MAC_PCU_MISC_MODE_TXOP_TBTT_LIMIT_ENABLE_LSB) & MAC_PCU_MISC_MODE_TXOP_TBTT_LIMIT_ENABLE_MASK)
#define MAC_PCU_MISC_MODE_KC_RX_ANT_UPDATE_MSB   11
#define MAC_PCU_MISC_MODE_KC_RX_ANT_UPDATE_LSB   11
#define MAC_PCU_MISC_MODE_KC_RX_ANT_UPDATE_MASK  0x00000800
#define MAC_PCU_MISC_MODE_KC_RX_ANT_UPDATE_GET(x) (((x) & MAC_PCU_MISC_MODE_KC_RX_ANT_UPDATE_MASK) >> MAC_PCU_MISC_MODE_KC_RX_ANT_UPDATE_LSB)
#define MAC_PCU_MISC_MODE_KC_RX_ANT_UPDATE_SET(x) (((x) << MAC_PCU_MISC_MODE_KC_RX_ANT_UPDATE_LSB) & MAC_PCU_MISC_MODE_KC_RX_ANT_UPDATE_MASK)
#define MAC_PCU_MISC_MODE_DEBUG_MODE_SIFS_MSB    10
#define MAC_PCU_MISC_MODE_DEBUG_MODE_SIFS_LSB    10
#define MAC_PCU_MISC_MODE_DEBUG_MODE_SIFS_MASK   0x00000400
#define MAC_PCU_MISC_MODE_DEBUG_MODE_SIFS_GET(x) (((x) & MAC_PCU_MISC_MODE_DEBUG_MODE_SIFS_MASK) >> MAC_PCU_MISC_MODE_DEBUG_MODE_SIFS_LSB)
#define MAC_PCU_MISC_MODE_DEBUG_MODE_SIFS_SET(x) (((x) << MAC_PCU_MISC_MODE_DEBUG_MODE_SIFS_LSB) & MAC_PCU_MISC_MODE_DEBUG_MODE_SIFS_MASK)
#define MAC_PCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_MSB 9
#define MAC_PCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_LSB 9
#define MAC_PCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_MASK 0x00000200
#define MAC_PCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_GET(x) (((x) & MAC_PCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_MASK) >> MAC_PCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_LSB)
#define MAC_PCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_SET(x) (((x) << MAC_PCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_LSB) & MAC_PCU_MISC_MODE_DEBUG_MODE_BA_BITMAP_MASK)
#define MAC_PCU_MISC_MODE_CCK_SIFS_MODE_MSB      4
#define MAC_PCU_MISC_MODE_CCK_SIFS_MODE_LSB      4
#define MAC_PCU_MISC_MODE_CCK_SIFS_MODE_MASK     0x00000010
#define MAC_PCU_MISC_MODE_CCK_SIFS_MODE_GET(x)   (((x) & MAC_PCU_MISC_MODE_CCK_SIFS_MODE_MASK) >> MAC_PCU_MISC_MODE_CCK_SIFS_MODE_LSB)
#define MAC_PCU_MISC_MODE_CCK_SIFS_MODE_SET(x)   (((x) << MAC_PCU_MISC_MODE_CCK_SIFS_MODE_LSB) & MAC_PCU_MISC_MODE_CCK_SIFS_MODE_MASK)
#define MAC_PCU_MISC_MODE_TX_ADD_TSF_MSB         3
#define MAC_PCU_MISC_MODE_TX_ADD_TSF_LSB         3
#define MAC_PCU_MISC_MODE_TX_ADD_TSF_MASK        0x00000008
#define MAC_PCU_MISC_MODE_TX_ADD_TSF_GET(x)      (((x) & MAC_PCU_MISC_MODE_TX_ADD_TSF_MASK) >> MAC_PCU_MISC_MODE_TX_ADD_TSF_LSB)
#define MAC_PCU_MISC_MODE_TX_ADD_TSF_SET(x)      (((x) << MAC_PCU_MISC_MODE_TX_ADD_TSF_LSB) & MAC_PCU_MISC_MODE_TX_ADD_TSF_MASK)
#define MAC_PCU_MISC_MODE_MIC_NEW_LOCATION_ENABLE_MSB 2
#define MAC_PCU_MISC_MODE_MIC_NEW_LOCATION_ENABLE_LSB 2
#define MAC_PCU_MISC_MODE_MIC_NEW_LOCATION_ENABLE_MASK 0x00000004
#define MAC_PCU_MISC_MODE_MIC_NEW_LOCATION_ENABLE_GET(x) (((x) & MAC_PCU_MISC_MODE_MIC_NEW_LOCATION_ENABLE_MASK) >> MAC_PCU_MISC_MODE_MIC_NEW_LOCATION_ENABLE_LSB)
#define MAC_PCU_MISC_MODE_MIC_NEW_LOCATION_ENABLE_SET(x) (((x) << MAC_PCU_MISC_MODE_MIC_NEW_LOCATION_ENABLE_LSB) & MAC_PCU_MISC_MODE_MIC_NEW_LOCATION_ENABLE_MASK)
#define MAC_PCU_MISC_MODE_DEBUG_MODE_AD_MSB      1
#define MAC_PCU_MISC_MODE_DEBUG_MODE_AD_LSB      1
#define MAC_PCU_MISC_MODE_DEBUG_MODE_AD_MASK     0x00000002
#define MAC_PCU_MISC_MODE_DEBUG_MODE_AD_GET(x)   (((x) & MAC_PCU_MISC_MODE_DEBUG_MODE_AD_MASK) >> MAC_PCU_MISC_MODE_DEBUG_MODE_AD_LSB)
#define MAC_PCU_MISC_MODE_DEBUG_MODE_AD_SET(x)   (((x) << MAC_PCU_MISC_MODE_DEBUG_MODE_AD_LSB) & MAC_PCU_MISC_MODE_DEBUG_MODE_AD_MASK)
#define MAC_PCU_MISC_MODE_BSSID_MATCH_FORCE_MSB  0
#define MAC_PCU_MISC_MODE_BSSID_MATCH_FORCE_LSB  0
#define MAC_PCU_MISC_MODE_BSSID_MATCH_FORCE_MASK 0x00000001
#define MAC_PCU_MISC_MODE_BSSID_MATCH_FORCE_GET(x) (((x) & MAC_PCU_MISC_MODE_BSSID_MATCH_FORCE_MASK) >> MAC_PCU_MISC_MODE_BSSID_MATCH_FORCE_LSB)
#define MAC_PCU_MISC_MODE_BSSID_MATCH_FORCE_SET(x) (((x) << MAC_PCU_MISC_MODE_BSSID_MATCH_FORCE_LSB) & MAC_PCU_MISC_MODE_BSSID_MATCH_FORCE_MASK)

#define MAC_PCU_FILTER_OFDM_CNT_ADDRESS          0x000080c4
#define MAC_PCU_FILTER_OFDM_CNT_OFFSET           0x000000c4
#define MAC_PCU_FILTER_OFDM_CNT_VALUE_MSB        23
#define MAC_PCU_FILTER_OFDM_CNT_VALUE_LSB        0
#define MAC_PCU_FILTER_OFDM_CNT_VALUE_MASK       0x00ffffff
#define MAC_PCU_FILTER_OFDM_CNT_VALUE_GET(x)     (((x) & MAC_PCU_FILTER_OFDM_CNT_VALUE_MASK) >> MAC_PCU_FILTER_OFDM_CNT_VALUE_LSB)
#define MAC_PCU_FILTER_OFDM_CNT_VALUE_SET(x)     (((x) << MAC_PCU_FILTER_OFDM_CNT_VALUE_LSB) & MAC_PCU_FILTER_OFDM_CNT_VALUE_MASK)

#define MAC_PCU_FILTER_CCK_CNT_ADDRESS           0x000080c8
#define MAC_PCU_FILTER_CCK_CNT_OFFSET            0x000000c8
#define MAC_PCU_FILTER_CCK_CNT_VALUE_MSB         23
#define MAC_PCU_FILTER_CCK_CNT_VALUE_LSB         0
#define MAC_PCU_FILTER_CCK_CNT_VALUE_MASK        0x00ffffff
#define MAC_PCU_FILTER_CCK_CNT_VALUE_GET(x)      (((x) & MAC_PCU_FILTER_CCK_CNT_VALUE_MASK) >> MAC_PCU_FILTER_CCK_CNT_VALUE_LSB)
#define MAC_PCU_FILTER_CCK_CNT_VALUE_SET(x)      (((x) << MAC_PCU_FILTER_CCK_CNT_VALUE_LSB) & MAC_PCU_FILTER_CCK_CNT_VALUE_MASK)

#define MAC_PCU_PHY_ERR_CNT_1_ADDRESS            0x000080cc
#define MAC_PCU_PHY_ERR_CNT_1_OFFSET             0x000000cc
#define MAC_PCU_PHY_ERR_CNT_1_VALUE_MSB          23
#define MAC_PCU_PHY_ERR_CNT_1_VALUE_LSB          0
#define MAC_PCU_PHY_ERR_CNT_1_VALUE_MASK         0x00ffffff
#define MAC_PCU_PHY_ERR_CNT_1_VALUE_GET(x)       (((x) & MAC_PCU_PHY_ERR_CNT_1_VALUE_MASK) >> MAC_PCU_PHY_ERR_CNT_1_VALUE_LSB)
#define MAC_PCU_PHY_ERR_CNT_1_VALUE_SET(x)       (((x) << MAC_PCU_PHY_ERR_CNT_1_VALUE_LSB) & MAC_PCU_PHY_ERR_CNT_1_VALUE_MASK)

#define MAC_PCU_PHY_ERR_CNT_1_MASK_ADDRESS       0x000080d0
#define MAC_PCU_PHY_ERR_CNT_1_MASK_OFFSET        0x000000d0
#define MAC_PCU_PHY_ERR_CNT_1_MASK_VALUE_MSB     31
#define MAC_PCU_PHY_ERR_CNT_1_MASK_VALUE_LSB     0
#define MAC_PCU_PHY_ERR_CNT_1_MASK_VALUE_MASK    0xffffffff
#define MAC_PCU_PHY_ERR_CNT_1_MASK_VALUE_GET(x)  (((x) & MAC_PCU_PHY_ERR_CNT_1_MASK_VALUE_MASK) >> MAC_PCU_PHY_ERR_CNT_1_MASK_VALUE_LSB)
#define MAC_PCU_PHY_ERR_CNT_1_MASK_VALUE_SET(x)  (((x) << MAC_PCU_PHY_ERR_CNT_1_MASK_VALUE_LSB) & MAC_PCU_PHY_ERR_CNT_1_MASK_VALUE_MASK)

#define MAC_PCU_PHY_ERR_CNT_2_ADDRESS            0x000080d4
#define MAC_PCU_PHY_ERR_CNT_2_OFFSET             0x000000d4
#define MAC_PCU_PHY_ERR_CNT_2_VALUE_MSB          23
#define MAC_PCU_PHY_ERR_CNT_2_VALUE_LSB          0
#define MAC_PCU_PHY_ERR_CNT_2_VALUE_MASK         0x00ffffff
#define MAC_PCU_PHY_ERR_CNT_2_VALUE_GET(x)       (((x) & MAC_PCU_PHY_ERR_CNT_2_VALUE_MASK) >> MAC_PCU_PHY_ERR_CNT_2_VALUE_LSB)
#define MAC_PCU_PHY_ERR_CNT_2_VALUE_SET(x)       (((x) << MAC_PCU_PHY_ERR_CNT_2_VALUE_LSB) & MAC_PCU_PHY_ERR_CNT_2_VALUE_MASK)

#define MAC_PCU_PHY_ERR_CNT_2_MASK_ADDRESS       0x000080d8
#define MAC_PCU_PHY_ERR_CNT_2_MASK_OFFSET        0x000000d8
#define MAC_PCU_PHY_ERR_CNT_2_MASK_VALUE_MSB     31
#define MAC_PCU_PHY_ERR_CNT_2_MASK_VALUE_LSB     0
#define MAC_PCU_PHY_ERR_CNT_2_MASK_VALUE_MASK    0xffffffff
#define MAC_PCU_PHY_ERR_CNT_2_MASK_VALUE_GET(x)  (((x) & MAC_PCU_PHY_ERR_CNT_2_MASK_VALUE_MASK) >> MAC_PCU_PHY_ERR_CNT_2_MASK_VALUE_LSB)
#define MAC_PCU_PHY_ERR_CNT_2_MASK_VALUE_SET(x)  (((x) << MAC_PCU_PHY_ERR_CNT_2_MASK_VALUE_LSB) & MAC_PCU_PHY_ERR_CNT_2_MASK_VALUE_MASK)

#define MAC_PCU_TSF_THRESHOLD_ADDRESS            0x000080dc
#define MAC_PCU_TSF_THRESHOLD_OFFSET             0x000000dc
#define MAC_PCU_TSF_THRESHOLD_VALUE_MSB          15
#define MAC_PCU_TSF_THRESHOLD_VALUE_LSB          0
#define MAC_PCU_TSF_THRESHOLD_VALUE_MASK         0x0000ffff
#define MAC_PCU_TSF_THRESHOLD_VALUE_GET(x)       (((x) & MAC_PCU_TSF_THRESHOLD_VALUE_MASK) >> MAC_PCU_TSF_THRESHOLD_VALUE_LSB)
#define MAC_PCU_TSF_THRESHOLD_VALUE_SET(x)       (((x) << MAC_PCU_TSF_THRESHOLD_VALUE_LSB) & MAC_PCU_TSF_THRESHOLD_VALUE_MASK)

#define MAC_PCU_PHY_ERROR_EIFS_MASK_ADDRESS      0x000080e0
#define MAC_PCU_PHY_ERROR_EIFS_MASK_OFFSET       0x000000e0
#define MAC_PCU_PHY_ERROR_EIFS_MASK_VALUE_MSB    31
#define MAC_PCU_PHY_ERROR_EIFS_MASK_VALUE_LSB    0
#define MAC_PCU_PHY_ERROR_EIFS_MASK_VALUE_MASK   0xffffffff
#define MAC_PCU_PHY_ERROR_EIFS_MASK_VALUE_GET(x) (((x) & MAC_PCU_PHY_ERROR_EIFS_MASK_VALUE_MASK) >> MAC_PCU_PHY_ERROR_EIFS_MASK_VALUE_LSB)
#define MAC_PCU_PHY_ERROR_EIFS_MASK_VALUE_SET(x) (((x) << MAC_PCU_PHY_ERROR_EIFS_MASK_VALUE_LSB) & MAC_PCU_PHY_ERROR_EIFS_MASK_VALUE_MASK)

#define MAC_PCU_PHY_ERR_CNT_3_ADDRESS            0x000080e4
#define MAC_PCU_PHY_ERR_CNT_3_OFFSET             0x000000e4
#define MAC_PCU_PHY_ERR_CNT_3_VALUE_MSB          23
#define MAC_PCU_PHY_ERR_CNT_3_VALUE_LSB          0
#define MAC_PCU_PHY_ERR_CNT_3_VALUE_MASK         0x00ffffff
#define MAC_PCU_PHY_ERR_CNT_3_VALUE_GET(x)       (((x) & MAC_PCU_PHY_ERR_CNT_3_VALUE_MASK) >> MAC_PCU_PHY_ERR_CNT_3_VALUE_LSB)
#define MAC_PCU_PHY_ERR_CNT_3_VALUE_SET(x)       (((x) << MAC_PCU_PHY_ERR_CNT_3_VALUE_LSB) & MAC_PCU_PHY_ERR_CNT_3_VALUE_MASK)

#define MAC_PCU_PHY_ERR_CNT_3_MASK_ADDRESS       0x000080e8
#define MAC_PCU_PHY_ERR_CNT_3_MASK_OFFSET        0x000000e8
#define MAC_PCU_PHY_ERR_CNT_3_MASK_VALUE_MSB     31
#define MAC_PCU_PHY_ERR_CNT_3_MASK_VALUE_LSB     0
#define MAC_PCU_PHY_ERR_CNT_3_MASK_VALUE_MASK    0xffffffff
#define MAC_PCU_PHY_ERR_CNT_3_MASK_VALUE_GET(x)  (((x) & MAC_PCU_PHY_ERR_CNT_3_MASK_VALUE_MASK) >> MAC_PCU_PHY_ERR_CNT_3_MASK_VALUE_LSB)
#define MAC_PCU_PHY_ERR_CNT_3_MASK_VALUE_SET(x)  (((x) << MAC_PCU_PHY_ERR_CNT_3_MASK_VALUE_LSB) & MAC_PCU_PHY_ERR_CNT_3_MASK_VALUE_MASK)

#define MAC_PCU_BLUETOOTH_MODE_ADDRESS           0x000080ec
#define MAC_PCU_BLUETOOTH_MODE_OFFSET            0x000000ec
#define MAC_PCU_BLUETOOTH_MODE_FIRST_SLOT_TIME_MSB 31
#define MAC_PCU_BLUETOOTH_MODE_FIRST_SLOT_TIME_LSB 24
#define MAC_PCU_BLUETOOTH_MODE_FIRST_SLOT_TIME_MASK 0xff000000
#define MAC_PCU_BLUETOOTH_MODE_FIRST_SLOT_TIME_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE_FIRST_SLOT_TIME_MASK) >> MAC_PCU_BLUETOOTH_MODE_FIRST_SLOT_TIME_LSB)
#define MAC_PCU_BLUETOOTH_MODE_FIRST_SLOT_TIME_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE_FIRST_SLOT_TIME_LSB) & MAC_PCU_BLUETOOTH_MODE_FIRST_SLOT_TIME_MASK)
#define MAC_PCU_BLUETOOTH_MODE_PRIORITY_TIME_MSB 23
#define MAC_PCU_BLUETOOTH_MODE_PRIORITY_TIME_LSB 18
#define MAC_PCU_BLUETOOTH_MODE_PRIORITY_TIME_MASK 0x00fc0000
#define MAC_PCU_BLUETOOTH_MODE_PRIORITY_TIME_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE_PRIORITY_TIME_MASK) >> MAC_PCU_BLUETOOTH_MODE_PRIORITY_TIME_LSB)
#define MAC_PCU_BLUETOOTH_MODE_PRIORITY_TIME_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE_PRIORITY_TIME_LSB) & MAC_PCU_BLUETOOTH_MODE_PRIORITY_TIME_MASK)
#define MAC_PCU_BLUETOOTH_MODE_RX_CLEAR_POLARITY_MSB 17
#define MAC_PCU_BLUETOOTH_MODE_RX_CLEAR_POLARITY_LSB 17
#define MAC_PCU_BLUETOOTH_MODE_RX_CLEAR_POLARITY_MASK 0x00020000
#define MAC_PCU_BLUETOOTH_MODE_RX_CLEAR_POLARITY_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE_RX_CLEAR_POLARITY_MASK) >> MAC_PCU_BLUETOOTH_MODE_RX_CLEAR_POLARITY_LSB)
#define MAC_PCU_BLUETOOTH_MODE_RX_CLEAR_POLARITY_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE_RX_CLEAR_POLARITY_LSB) & MAC_PCU_BLUETOOTH_MODE_RX_CLEAR_POLARITY_MASK)
#define MAC_PCU_BLUETOOTH_MODE_QCU_THRESH_MSB    16
#define MAC_PCU_BLUETOOTH_MODE_QCU_THRESH_LSB    13
#define MAC_PCU_BLUETOOTH_MODE_QCU_THRESH_MASK   0x0001e000
#define MAC_PCU_BLUETOOTH_MODE_QCU_THRESH_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE_QCU_THRESH_MASK) >> MAC_PCU_BLUETOOTH_MODE_QCU_THRESH_LSB)
#define MAC_PCU_BLUETOOTH_MODE_QCU_THRESH_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE_QCU_THRESH_LSB) & MAC_PCU_BLUETOOTH_MODE_QCU_THRESH_MASK)
#define MAC_PCU_BLUETOOTH_MODE_QUIET_MSB         12
#define MAC_PCU_BLUETOOTH_MODE_QUIET_LSB         12
#define MAC_PCU_BLUETOOTH_MODE_QUIET_MASK        0x00001000
#define MAC_PCU_BLUETOOTH_MODE_QUIET_GET(x)      (((x) & MAC_PCU_BLUETOOTH_MODE_QUIET_MASK) >> MAC_PCU_BLUETOOTH_MODE_QUIET_LSB)
#define MAC_PCU_BLUETOOTH_MODE_QUIET_SET(x)      (((x) << MAC_PCU_BLUETOOTH_MODE_QUIET_LSB) & MAC_PCU_BLUETOOTH_MODE_QUIET_MASK)
#define MAC_PCU_BLUETOOTH_MODE_MODE_MSB          11
#define MAC_PCU_BLUETOOTH_MODE_MODE_LSB          10
#define MAC_PCU_BLUETOOTH_MODE_MODE_MASK         0x00000c00
#define MAC_PCU_BLUETOOTH_MODE_MODE_GET(x)       (((x) & MAC_PCU_BLUETOOTH_MODE_MODE_MASK) >> MAC_PCU_BLUETOOTH_MODE_MODE_LSB)
#define MAC_PCU_BLUETOOTH_MODE_MODE_SET(x)       (((x) << MAC_PCU_BLUETOOTH_MODE_MODE_LSB) & MAC_PCU_BLUETOOTH_MODE_MODE_MASK)
#define MAC_PCU_BLUETOOTH_MODE_TX_FRAME_EXTEND_MSB 9
#define MAC_PCU_BLUETOOTH_MODE_TX_FRAME_EXTEND_LSB 9
#define MAC_PCU_BLUETOOTH_MODE_TX_FRAME_EXTEND_MASK 0x00000200
#define MAC_PCU_BLUETOOTH_MODE_TX_FRAME_EXTEND_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE_TX_FRAME_EXTEND_MASK) >> MAC_PCU_BLUETOOTH_MODE_TX_FRAME_EXTEND_LSB)
#define MAC_PCU_BLUETOOTH_MODE_TX_FRAME_EXTEND_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE_TX_FRAME_EXTEND_LSB) & MAC_PCU_BLUETOOTH_MODE_TX_FRAME_EXTEND_MASK)
#define MAC_PCU_BLUETOOTH_MODE_TX_STATE_EXTEND_MSB 8
#define MAC_PCU_BLUETOOTH_MODE_TX_STATE_EXTEND_LSB 8
#define MAC_PCU_BLUETOOTH_MODE_TX_STATE_EXTEND_MASK 0x00000100
#define MAC_PCU_BLUETOOTH_MODE_TX_STATE_EXTEND_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE_TX_STATE_EXTEND_MASK) >> MAC_PCU_BLUETOOTH_MODE_TX_STATE_EXTEND_LSB)
#define MAC_PCU_BLUETOOTH_MODE_TX_STATE_EXTEND_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE_TX_STATE_EXTEND_LSB) & MAC_PCU_BLUETOOTH_MODE_TX_STATE_EXTEND_MASK)
#define MAC_PCU_BLUETOOTH_MODE_TIME_EXTEND_MSB   7
#define MAC_PCU_BLUETOOTH_MODE_TIME_EXTEND_LSB   0
#define MAC_PCU_BLUETOOTH_MODE_TIME_EXTEND_MASK  0x000000ff
#define MAC_PCU_BLUETOOTH_MODE_TIME_EXTEND_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE_TIME_EXTEND_MASK) >> MAC_PCU_BLUETOOTH_MODE_TIME_EXTEND_LSB)
#define MAC_PCU_BLUETOOTH_MODE_TIME_EXTEND_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE_TIME_EXTEND_LSB) & MAC_PCU_BLUETOOTH_MODE_TIME_EXTEND_MASK)

#define MAC_PCU_BLUETOOTH_WEIGHTS_ADDRESS        0x000080f0
#define MAC_PCU_BLUETOOTH_WEIGHTS_OFFSET         0x000000f0
#define MAC_PCU_BLUETOOTH_WEIGHTS_WL_WEIGHT_MSB  31
#define MAC_PCU_BLUETOOTH_WEIGHTS_WL_WEIGHT_LSB  16
#define MAC_PCU_BLUETOOTH_WEIGHTS_WL_WEIGHT_MASK 0xffff0000
#define MAC_PCU_BLUETOOTH_WEIGHTS_WL_WEIGHT_GET(x) (((x) & MAC_PCU_BLUETOOTH_WEIGHTS_WL_WEIGHT_MASK) >> MAC_PCU_BLUETOOTH_WEIGHTS_WL_WEIGHT_LSB)
#define MAC_PCU_BLUETOOTH_WEIGHTS_WL_WEIGHT_SET(x) (((x) << MAC_PCU_BLUETOOTH_WEIGHTS_WL_WEIGHT_LSB) & MAC_PCU_BLUETOOTH_WEIGHTS_WL_WEIGHT_MASK)
#define MAC_PCU_BLUETOOTH_WEIGHTS_BT_WEIGHT_MSB  15
#define MAC_PCU_BLUETOOTH_WEIGHTS_BT_WEIGHT_LSB  0
#define MAC_PCU_BLUETOOTH_WEIGHTS_BT_WEIGHT_MASK 0x0000ffff
#define MAC_PCU_BLUETOOTH_WEIGHTS_BT_WEIGHT_GET(x) (((x) & MAC_PCU_BLUETOOTH_WEIGHTS_BT_WEIGHT_MASK) >> MAC_PCU_BLUETOOTH_WEIGHTS_BT_WEIGHT_LSB)
#define MAC_PCU_BLUETOOTH_WEIGHTS_BT_WEIGHT_SET(x) (((x) << MAC_PCU_BLUETOOTH_WEIGHTS_BT_WEIGHT_LSB) & MAC_PCU_BLUETOOTH_WEIGHTS_BT_WEIGHT_MASK)

#define MAC_PCU_BLUETOOTH_MODE2_ADDRESS          0x000080f4
#define MAC_PCU_BLUETOOTH_MODE2_OFFSET           0x000000f4
#define MAC_PCU_BLUETOOTH_MODE2_PHY_ERR_BT_COLL_ENABLE_MSB 31
#define MAC_PCU_BLUETOOTH_MODE2_PHY_ERR_BT_COLL_ENABLE_LSB 31
#define MAC_PCU_BLUETOOTH_MODE2_PHY_ERR_BT_COLL_ENABLE_MASK 0x80000000
#define MAC_PCU_BLUETOOTH_MODE2_PHY_ERR_BT_COLL_ENABLE_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_PHY_ERR_BT_COLL_ENABLE_MASK) >> MAC_PCU_BLUETOOTH_MODE2_PHY_ERR_BT_COLL_ENABLE_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_PHY_ERR_BT_COLL_ENABLE_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_PHY_ERR_BT_COLL_ENABLE_LSB) & MAC_PCU_BLUETOOTH_MODE2_PHY_ERR_BT_COLL_ENABLE_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_INTERRUPT_ENABLE_MSB 30
#define MAC_PCU_BLUETOOTH_MODE2_INTERRUPT_ENABLE_LSB 30
#define MAC_PCU_BLUETOOTH_MODE2_INTERRUPT_ENABLE_MASK 0x40000000
#define MAC_PCU_BLUETOOTH_MODE2_INTERRUPT_ENABLE_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_INTERRUPT_ENABLE_MASK) >> MAC_PCU_BLUETOOTH_MODE2_INTERRUPT_ENABLE_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_INTERRUPT_ENABLE_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_INTERRUPT_ENABLE_LSB) & MAC_PCU_BLUETOOTH_MODE2_INTERRUPT_ENABLE_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_TSF_BT_PRIORITY_CTRL_MSB 29
#define MAC_PCU_BLUETOOTH_MODE2_TSF_BT_PRIORITY_CTRL_LSB 28
#define MAC_PCU_BLUETOOTH_MODE2_TSF_BT_PRIORITY_CTRL_MASK 0x30000000
#define MAC_PCU_BLUETOOTH_MODE2_TSF_BT_PRIORITY_CTRL_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_TSF_BT_PRIORITY_CTRL_MASK) >> MAC_PCU_BLUETOOTH_MODE2_TSF_BT_PRIORITY_CTRL_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_TSF_BT_PRIORITY_CTRL_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_TSF_BT_PRIORITY_CTRL_LSB) & MAC_PCU_BLUETOOTH_MODE2_TSF_BT_PRIORITY_CTRL_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_TSF_BT_ACTIVE_CTRL_MSB 27
#define MAC_PCU_BLUETOOTH_MODE2_TSF_BT_ACTIVE_CTRL_LSB 26
#define MAC_PCU_BLUETOOTH_MODE2_TSF_BT_ACTIVE_CTRL_MASK 0x0c000000
#define MAC_PCU_BLUETOOTH_MODE2_TSF_BT_ACTIVE_CTRL_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_TSF_BT_ACTIVE_CTRL_MASK) >> MAC_PCU_BLUETOOTH_MODE2_TSF_BT_ACTIVE_CTRL_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_TSF_BT_ACTIVE_CTRL_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_TSF_BT_ACTIVE_CTRL_LSB) & MAC_PCU_BLUETOOTH_MODE2_TSF_BT_ACTIVE_CTRL_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_RS_DISCARD_EXTEND_MSB 25
#define MAC_PCU_BLUETOOTH_MODE2_RS_DISCARD_EXTEND_LSB 25
#define MAC_PCU_BLUETOOTH_MODE2_RS_DISCARD_EXTEND_MASK 0x02000000
#define MAC_PCU_BLUETOOTH_MODE2_RS_DISCARD_EXTEND_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_RS_DISCARD_EXTEND_MASK) >> MAC_PCU_BLUETOOTH_MODE2_RS_DISCARD_EXTEND_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_RS_DISCARD_EXTEND_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_RS_DISCARD_EXTEND_LSB) & MAC_PCU_BLUETOOTH_MODE2_RS_DISCARD_EXTEND_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_WL_TXRX_SEPARATE_MSB 24
#define MAC_PCU_BLUETOOTH_MODE2_WL_TXRX_SEPARATE_LSB 24
#define MAC_PCU_BLUETOOTH_MODE2_WL_TXRX_SEPARATE_MASK 0x01000000
#define MAC_PCU_BLUETOOTH_MODE2_WL_TXRX_SEPARATE_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_WL_TXRX_SEPARATE_MASK) >> MAC_PCU_BLUETOOTH_MODE2_WL_TXRX_SEPARATE_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_WL_TXRX_SEPARATE_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_WL_TXRX_SEPARATE_LSB) & MAC_PCU_BLUETOOTH_MODE2_WL_TXRX_SEPARATE_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_WL_ACTIVE_MODE_MSB 23
#define MAC_PCU_BLUETOOTH_MODE2_WL_ACTIVE_MODE_LSB 22
#define MAC_PCU_BLUETOOTH_MODE2_WL_ACTIVE_MODE_MASK 0x00c00000
#define MAC_PCU_BLUETOOTH_MODE2_WL_ACTIVE_MODE_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_WL_ACTIVE_MODE_MASK) >> MAC_PCU_BLUETOOTH_MODE2_WL_ACTIVE_MODE_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_WL_ACTIVE_MODE_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_WL_ACTIVE_MODE_LSB) & MAC_PCU_BLUETOOTH_MODE2_WL_ACTIVE_MODE_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_QUIET_2_WIRE_MSB 21
#define MAC_PCU_BLUETOOTH_MODE2_QUIET_2_WIRE_LSB 21
#define MAC_PCU_BLUETOOTH_MODE2_QUIET_2_WIRE_MASK 0x00200000
#define MAC_PCU_BLUETOOTH_MODE2_QUIET_2_WIRE_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_QUIET_2_WIRE_MASK) >> MAC_PCU_BLUETOOTH_MODE2_QUIET_2_WIRE_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_QUIET_2_WIRE_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_QUIET_2_WIRE_LSB) & MAC_PCU_BLUETOOTH_MODE2_QUIET_2_WIRE_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_DISABLE_BT_ANT_MSB 20
#define MAC_PCU_BLUETOOTH_MODE2_DISABLE_BT_ANT_LSB 20
#define MAC_PCU_BLUETOOTH_MODE2_DISABLE_BT_ANT_MASK 0x00100000
#define MAC_PCU_BLUETOOTH_MODE2_DISABLE_BT_ANT_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_DISABLE_BT_ANT_MASK) >> MAC_PCU_BLUETOOTH_MODE2_DISABLE_BT_ANT_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_DISABLE_BT_ANT_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_DISABLE_BT_ANT_LSB) & MAC_PCU_BLUETOOTH_MODE2_DISABLE_BT_ANT_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_PROTECT_BT_AFTER_WAKEUP_MSB 19
#define MAC_PCU_BLUETOOTH_MODE2_PROTECT_BT_AFTER_WAKEUP_LSB 19
#define MAC_PCU_BLUETOOTH_MODE2_PROTECT_BT_AFTER_WAKEUP_MASK 0x00080000
#define MAC_PCU_BLUETOOTH_MODE2_PROTECT_BT_AFTER_WAKEUP_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_PROTECT_BT_AFTER_WAKEUP_MASK) >> MAC_PCU_BLUETOOTH_MODE2_PROTECT_BT_AFTER_WAKEUP_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_PROTECT_BT_AFTER_WAKEUP_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_PROTECT_BT_AFTER_WAKEUP_LSB) & MAC_PCU_BLUETOOTH_MODE2_PROTECT_BT_AFTER_WAKEUP_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_SLEEP_ALLOW_BT_ACCESS_MSB 17
#define MAC_PCU_BLUETOOTH_MODE2_SLEEP_ALLOW_BT_ACCESS_LSB 17
#define MAC_PCU_BLUETOOTH_MODE2_SLEEP_ALLOW_BT_ACCESS_MASK 0x00020000
#define MAC_PCU_BLUETOOTH_MODE2_SLEEP_ALLOW_BT_ACCESS_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_SLEEP_ALLOW_BT_ACCESS_MASK) >> MAC_PCU_BLUETOOTH_MODE2_SLEEP_ALLOW_BT_ACCESS_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_SLEEP_ALLOW_BT_ACCESS_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_SLEEP_ALLOW_BT_ACCESS_LSB) & MAC_PCU_BLUETOOTH_MODE2_SLEEP_ALLOW_BT_ACCESS_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_HOLD_RX_CLEAR_MSB 16
#define MAC_PCU_BLUETOOTH_MODE2_HOLD_RX_CLEAR_LSB 16
#define MAC_PCU_BLUETOOTH_MODE2_HOLD_RX_CLEAR_MASK 0x00010000
#define MAC_PCU_BLUETOOTH_MODE2_HOLD_RX_CLEAR_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_HOLD_RX_CLEAR_MASK) >> MAC_PCU_BLUETOOTH_MODE2_HOLD_RX_CLEAR_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_HOLD_RX_CLEAR_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_HOLD_RX_CLEAR_LSB) & MAC_PCU_BLUETOOTH_MODE2_HOLD_RX_CLEAR_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_CNT_MSB 15
#define MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_CNT_LSB 8
#define MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_CNT_MASK 0x0000ff00
#define MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_CNT_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_CNT_MASK) >> MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_CNT_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_CNT_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_CNT_LSB) & MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_CNT_MASK)
#define MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_THRESH_MSB 7
#define MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_THRESH_LSB 0
#define MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_THRESH_MASK 0x000000ff
#define MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_THRESH_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_THRESH_MASK) >> MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_THRESH_LSB)
#define MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_THRESH_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_THRESH_LSB) & MAC_PCU_BLUETOOTH_MODE2_BCN_MISS_THRESH_MASK)

#define MAC_PCU_TXSIFS_ADDRESS                   0x000080f8
#define MAC_PCU_TXSIFS_OFFSET                    0x000000f8
#define MAC_PCU_TXSIFS_ACK_SHIFT_MSB             14
#define MAC_PCU_TXSIFS_ACK_SHIFT_LSB             12
#define MAC_PCU_TXSIFS_ACK_SHIFT_MASK            0x00007000
#define MAC_PCU_TXSIFS_ACK_SHIFT_GET(x)          (((x) & MAC_PCU_TXSIFS_ACK_SHIFT_MASK) >> MAC_PCU_TXSIFS_ACK_SHIFT_LSB)
#define MAC_PCU_TXSIFS_ACK_SHIFT_SET(x)          (((x) << MAC_PCU_TXSIFS_ACK_SHIFT_LSB) & MAC_PCU_TXSIFS_ACK_SHIFT_MASK)
#define MAC_PCU_TXSIFS_TX_LATENCY_MSB            11
#define MAC_PCU_TXSIFS_TX_LATENCY_LSB            8
#define MAC_PCU_TXSIFS_TX_LATENCY_MASK           0x00000f00
#define MAC_PCU_TXSIFS_TX_LATENCY_GET(x)         (((x) & MAC_PCU_TXSIFS_TX_LATENCY_MASK) >> MAC_PCU_TXSIFS_TX_LATENCY_LSB)
#define MAC_PCU_TXSIFS_TX_LATENCY_SET(x)         (((x) << MAC_PCU_TXSIFS_TX_LATENCY_LSB) & MAC_PCU_TXSIFS_TX_LATENCY_MASK)
#define MAC_PCU_TXSIFS_SIFS_TIME_MSB             7
#define MAC_PCU_TXSIFS_SIFS_TIME_LSB             0
#define MAC_PCU_TXSIFS_SIFS_TIME_MASK            0x000000ff
#define MAC_PCU_TXSIFS_SIFS_TIME_GET(x)          (((x) & MAC_PCU_TXSIFS_SIFS_TIME_MASK) >> MAC_PCU_TXSIFS_SIFS_TIME_LSB)
#define MAC_PCU_TXSIFS_SIFS_TIME_SET(x)          (((x) << MAC_PCU_TXSIFS_SIFS_TIME_LSB) & MAC_PCU_TXSIFS_SIFS_TIME_MASK)

#define MAC_PCU_TXOP_X_ADDRESS                   0x000080fc
#define MAC_PCU_TXOP_X_OFFSET                    0x000000fc
#define MAC_PCU_TXOP_X_VALUE_MSB                 7
#define MAC_PCU_TXOP_X_VALUE_LSB                 0
#define MAC_PCU_TXOP_X_VALUE_MASK                0x000000ff
#define MAC_PCU_TXOP_X_VALUE_GET(x)              (((x) & MAC_PCU_TXOP_X_VALUE_MASK) >> MAC_PCU_TXOP_X_VALUE_LSB)
#define MAC_PCU_TXOP_X_VALUE_SET(x)              (((x) << MAC_PCU_TXOP_X_VALUE_LSB) & MAC_PCU_TXOP_X_VALUE_MASK)

#define MAC_PCU_TXOP_0_3_ADDRESS                 0x00008100
#define MAC_PCU_TXOP_0_3_OFFSET                  0x00000100
#define MAC_PCU_TXOP_0_3_VALUE_3_MSB             31
#define MAC_PCU_TXOP_0_3_VALUE_3_LSB             24
#define MAC_PCU_TXOP_0_3_VALUE_3_MASK            0xff000000
#define MAC_PCU_TXOP_0_3_VALUE_3_GET(x)          (((x) & MAC_PCU_TXOP_0_3_VALUE_3_MASK) >> MAC_PCU_TXOP_0_3_VALUE_3_LSB)
#define MAC_PCU_TXOP_0_3_VALUE_3_SET(x)          (((x) << MAC_PCU_TXOP_0_3_VALUE_3_LSB) & MAC_PCU_TXOP_0_3_VALUE_3_MASK)
#define MAC_PCU_TXOP_0_3_VALUE_2_MSB             23
#define MAC_PCU_TXOP_0_3_VALUE_2_LSB             16
#define MAC_PCU_TXOP_0_3_VALUE_2_MASK            0x00ff0000
#define MAC_PCU_TXOP_0_3_VALUE_2_GET(x)          (((x) & MAC_PCU_TXOP_0_3_VALUE_2_MASK) >> MAC_PCU_TXOP_0_3_VALUE_2_LSB)
#define MAC_PCU_TXOP_0_3_VALUE_2_SET(x)          (((x) << MAC_PCU_TXOP_0_3_VALUE_2_LSB) & MAC_PCU_TXOP_0_3_VALUE_2_MASK)
#define MAC_PCU_TXOP_0_3_VALUE_1_MSB             15
#define MAC_PCU_TXOP_0_3_VALUE_1_LSB             8
#define MAC_PCU_TXOP_0_3_VALUE_1_MASK            0x0000ff00
#define MAC_PCU_TXOP_0_3_VALUE_1_GET(x)          (((x) & MAC_PCU_TXOP_0_3_VALUE_1_MASK) >> MAC_PCU_TXOP_0_3_VALUE_1_LSB)
#define MAC_PCU_TXOP_0_3_VALUE_1_SET(x)          (((x) << MAC_PCU_TXOP_0_3_VALUE_1_LSB) & MAC_PCU_TXOP_0_3_VALUE_1_MASK)
#define MAC_PCU_TXOP_0_3_VALUE_0_MSB             7
#define MAC_PCU_TXOP_0_3_VALUE_0_LSB             0
#define MAC_PCU_TXOP_0_3_VALUE_0_MASK            0x000000ff
#define MAC_PCU_TXOP_0_3_VALUE_0_GET(x)          (((x) & MAC_PCU_TXOP_0_3_VALUE_0_MASK) >> MAC_PCU_TXOP_0_3_VALUE_0_LSB)
#define MAC_PCU_TXOP_0_3_VALUE_0_SET(x)          (((x) << MAC_PCU_TXOP_0_3_VALUE_0_LSB) & MAC_PCU_TXOP_0_3_VALUE_0_MASK)

#define MAC_PCU_TXOP_4_7_ADDRESS                 0x00008104
#define MAC_PCU_TXOP_4_7_OFFSET                  0x00000104
#define MAC_PCU_TXOP_4_7_VALUE_7_MSB             31
#define MAC_PCU_TXOP_4_7_VALUE_7_LSB             24
#define MAC_PCU_TXOP_4_7_VALUE_7_MASK            0xff000000
#define MAC_PCU_TXOP_4_7_VALUE_7_GET(x)          (((x) & MAC_PCU_TXOP_4_7_VALUE_7_MASK) >> MAC_PCU_TXOP_4_7_VALUE_7_LSB)
#define MAC_PCU_TXOP_4_7_VALUE_7_SET(x)          (((x) << MAC_PCU_TXOP_4_7_VALUE_7_LSB) & MAC_PCU_TXOP_4_7_VALUE_7_MASK)
#define MAC_PCU_TXOP_4_7_VALUE_6_MSB             23
#define MAC_PCU_TXOP_4_7_VALUE_6_LSB             16
#define MAC_PCU_TXOP_4_7_VALUE_6_MASK            0x00ff0000
#define MAC_PCU_TXOP_4_7_VALUE_6_GET(x)          (((x) & MAC_PCU_TXOP_4_7_VALUE_6_MASK) >> MAC_PCU_TXOP_4_7_VALUE_6_LSB)
#define MAC_PCU_TXOP_4_7_VALUE_6_SET(x)          (((x) << MAC_PCU_TXOP_4_7_VALUE_6_LSB) & MAC_PCU_TXOP_4_7_VALUE_6_MASK)
#define MAC_PCU_TXOP_4_7_VALUE_5_MSB             15
#define MAC_PCU_TXOP_4_7_VALUE_5_LSB             8
#define MAC_PCU_TXOP_4_7_VALUE_5_MASK            0x0000ff00
#define MAC_PCU_TXOP_4_7_VALUE_5_GET(x)          (((x) & MAC_PCU_TXOP_4_7_VALUE_5_MASK) >> MAC_PCU_TXOP_4_7_VALUE_5_LSB)
#define MAC_PCU_TXOP_4_7_VALUE_5_SET(x)          (((x) << MAC_PCU_TXOP_4_7_VALUE_5_LSB) & MAC_PCU_TXOP_4_7_VALUE_5_MASK)
#define MAC_PCU_TXOP_4_7_VALUE_4_MSB             7
#define MAC_PCU_TXOP_4_7_VALUE_4_LSB             0
#define MAC_PCU_TXOP_4_7_VALUE_4_MASK            0x000000ff
#define MAC_PCU_TXOP_4_7_VALUE_4_GET(x)          (((x) & MAC_PCU_TXOP_4_7_VALUE_4_MASK) >> MAC_PCU_TXOP_4_7_VALUE_4_LSB)
#define MAC_PCU_TXOP_4_7_VALUE_4_SET(x)          (((x) << MAC_PCU_TXOP_4_7_VALUE_4_LSB) & MAC_PCU_TXOP_4_7_VALUE_4_MASK)

#define MAC_PCU_TXOP_8_11_ADDRESS                0x00008108
#define MAC_PCU_TXOP_8_11_OFFSET                 0x00000108
#define MAC_PCU_TXOP_8_11_VALUE_11_MSB           31
#define MAC_PCU_TXOP_8_11_VALUE_11_LSB           24
#define MAC_PCU_TXOP_8_11_VALUE_11_MASK          0xff000000
#define MAC_PCU_TXOP_8_11_VALUE_11_GET(x)        (((x) & MAC_PCU_TXOP_8_11_VALUE_11_MASK) >> MAC_PCU_TXOP_8_11_VALUE_11_LSB)
#define MAC_PCU_TXOP_8_11_VALUE_11_SET(x)        (((x) << MAC_PCU_TXOP_8_11_VALUE_11_LSB) & MAC_PCU_TXOP_8_11_VALUE_11_MASK)
#define MAC_PCU_TXOP_8_11_VALUE_10_MSB           23
#define MAC_PCU_TXOP_8_11_VALUE_10_LSB           16
#define MAC_PCU_TXOP_8_11_VALUE_10_MASK          0x00ff0000
#define MAC_PCU_TXOP_8_11_VALUE_10_GET(x)        (((x) & MAC_PCU_TXOP_8_11_VALUE_10_MASK) >> MAC_PCU_TXOP_8_11_VALUE_10_LSB)
#define MAC_PCU_TXOP_8_11_VALUE_10_SET(x)        (((x) << MAC_PCU_TXOP_8_11_VALUE_10_LSB) & MAC_PCU_TXOP_8_11_VALUE_10_MASK)
#define MAC_PCU_TXOP_8_11_VALUE_9_MSB            15
#define MAC_PCU_TXOP_8_11_VALUE_9_LSB            8
#define MAC_PCU_TXOP_8_11_VALUE_9_MASK           0x0000ff00
#define MAC_PCU_TXOP_8_11_VALUE_9_GET(x)         (((x) & MAC_PCU_TXOP_8_11_VALUE_9_MASK) >> MAC_PCU_TXOP_8_11_VALUE_9_LSB)
#define MAC_PCU_TXOP_8_11_VALUE_9_SET(x)         (((x) << MAC_PCU_TXOP_8_11_VALUE_9_LSB) & MAC_PCU_TXOP_8_11_VALUE_9_MASK)
#define MAC_PCU_TXOP_8_11_VALUE_8_MSB            7
#define MAC_PCU_TXOP_8_11_VALUE_8_LSB            0
#define MAC_PCU_TXOP_8_11_VALUE_8_MASK           0x000000ff
#define MAC_PCU_TXOP_8_11_VALUE_8_GET(x)         (((x) & MAC_PCU_TXOP_8_11_VALUE_8_MASK) >> MAC_PCU_TXOP_8_11_VALUE_8_LSB)
#define MAC_PCU_TXOP_8_11_VALUE_8_SET(x)         (((x) << MAC_PCU_TXOP_8_11_VALUE_8_LSB) & MAC_PCU_TXOP_8_11_VALUE_8_MASK)

#define MAC_PCU_TXOP_12_15_ADDRESS               0x0000810c
#define MAC_PCU_TXOP_12_15_OFFSET                0x0000010c
#define MAC_PCU_TXOP_12_15_VALUE_15_MSB          31
#define MAC_PCU_TXOP_12_15_VALUE_15_LSB          24
#define MAC_PCU_TXOP_12_15_VALUE_15_MASK         0xff000000
#define MAC_PCU_TXOP_12_15_VALUE_15_GET(x)       (((x) & MAC_PCU_TXOP_12_15_VALUE_15_MASK) >> MAC_PCU_TXOP_12_15_VALUE_15_LSB)
#define MAC_PCU_TXOP_12_15_VALUE_15_SET(x)       (((x) << MAC_PCU_TXOP_12_15_VALUE_15_LSB) & MAC_PCU_TXOP_12_15_VALUE_15_MASK)
#define MAC_PCU_TXOP_12_15_VALUE_14_MSB          23
#define MAC_PCU_TXOP_12_15_VALUE_14_LSB          16
#define MAC_PCU_TXOP_12_15_VALUE_14_MASK         0x00ff0000
#define MAC_PCU_TXOP_12_15_VALUE_14_GET(x)       (((x) & MAC_PCU_TXOP_12_15_VALUE_14_MASK) >> MAC_PCU_TXOP_12_15_VALUE_14_LSB)
#define MAC_PCU_TXOP_12_15_VALUE_14_SET(x)       (((x) << MAC_PCU_TXOP_12_15_VALUE_14_LSB) & MAC_PCU_TXOP_12_15_VALUE_14_MASK)
#define MAC_PCU_TXOP_12_15_VALUE_13_MSB          15
#define MAC_PCU_TXOP_12_15_VALUE_13_LSB          8
#define MAC_PCU_TXOP_12_15_VALUE_13_MASK         0x0000ff00
#define MAC_PCU_TXOP_12_15_VALUE_13_GET(x)       (((x) & MAC_PCU_TXOP_12_15_VALUE_13_MASK) >> MAC_PCU_TXOP_12_15_VALUE_13_LSB)
#define MAC_PCU_TXOP_12_15_VALUE_13_SET(x)       (((x) << MAC_PCU_TXOP_12_15_VALUE_13_LSB) & MAC_PCU_TXOP_12_15_VALUE_13_MASK)
#define MAC_PCU_TXOP_12_15_VALUE_12_MSB          7
#define MAC_PCU_TXOP_12_15_VALUE_12_LSB          0
#define MAC_PCU_TXOP_12_15_VALUE_12_MASK         0x000000ff
#define MAC_PCU_TXOP_12_15_VALUE_12_GET(x)       (((x) & MAC_PCU_TXOP_12_15_VALUE_12_MASK) >> MAC_PCU_TXOP_12_15_VALUE_12_LSB)
#define MAC_PCU_TXOP_12_15_VALUE_12_SET(x)       (((x) << MAC_PCU_TXOP_12_15_VALUE_12_LSB) & MAC_PCU_TXOP_12_15_VALUE_12_MASK)

#define MAC_PCU_LOGIC_ANALYZER_ADDRESS           0x00008110
#define MAC_PCU_LOGIC_ANALYZER_OFFSET            0x00000110
#define MAC_PCU_LOGIC_ANALYZER_DIAG_MODE_MSB     31
#define MAC_PCU_LOGIC_ANALYZER_DIAG_MODE_LSB     18
#define MAC_PCU_LOGIC_ANALYZER_DIAG_MODE_MASK    0xfffc0000
#define MAC_PCU_LOGIC_ANALYZER_DIAG_MODE_GET(x)  (((x) & MAC_PCU_LOGIC_ANALYZER_DIAG_MODE_MASK) >> MAC_PCU_LOGIC_ANALYZER_DIAG_MODE_LSB)
#define MAC_PCU_LOGIC_ANALYZER_DIAG_MODE_SET(x)  (((x) << MAC_PCU_LOGIC_ANALYZER_DIAG_MODE_LSB) & MAC_PCU_LOGIC_ANALYZER_DIAG_MODE_MASK)
#define MAC_PCU_LOGIC_ANALYZER_INT_ADDR_MSB      17
#define MAC_PCU_LOGIC_ANALYZER_INT_ADDR_LSB      8
#define MAC_PCU_LOGIC_ANALYZER_INT_ADDR_MASK     0x0003ff00
#define MAC_PCU_LOGIC_ANALYZER_INT_ADDR_GET(x)   (((x) & MAC_PCU_LOGIC_ANALYZER_INT_ADDR_MASK) >> MAC_PCU_LOGIC_ANALYZER_INT_ADDR_LSB)
#define MAC_PCU_LOGIC_ANALYZER_INT_ADDR_SET(x)   (((x) << MAC_PCU_LOGIC_ANALYZER_INT_ADDR_LSB) & MAC_PCU_LOGIC_ANALYZER_INT_ADDR_MASK)
#define MAC_PCU_LOGIC_ANALYZER_QCU_SEL_MSB       7
#define MAC_PCU_LOGIC_ANALYZER_QCU_SEL_LSB       4
#define MAC_PCU_LOGIC_ANALYZER_QCU_SEL_MASK      0x000000f0
#define MAC_PCU_LOGIC_ANALYZER_QCU_SEL_GET(x)    (((x) & MAC_PCU_LOGIC_ANALYZER_QCU_SEL_MASK) >> MAC_PCU_LOGIC_ANALYZER_QCU_SEL_LSB)
#define MAC_PCU_LOGIC_ANALYZER_QCU_SEL_SET(x)    (((x) << MAC_PCU_LOGIC_ANALYZER_QCU_SEL_LSB) & MAC_PCU_LOGIC_ANALYZER_QCU_SEL_MASK)
#define MAC_PCU_LOGIC_ANALYZER_ENABLE_MSB        3
#define MAC_PCU_LOGIC_ANALYZER_ENABLE_LSB        3
#define MAC_PCU_LOGIC_ANALYZER_ENABLE_MASK       0x00000008
#define MAC_PCU_LOGIC_ANALYZER_ENABLE_GET(x)     (((x) & MAC_PCU_LOGIC_ANALYZER_ENABLE_MASK) >> MAC_PCU_LOGIC_ANALYZER_ENABLE_LSB)
#define MAC_PCU_LOGIC_ANALYZER_ENABLE_SET(x)     (((x) << MAC_PCU_LOGIC_ANALYZER_ENABLE_LSB) & MAC_PCU_LOGIC_ANALYZER_ENABLE_MASK)
#define MAC_PCU_LOGIC_ANALYZER_STATE_MSB         2
#define MAC_PCU_LOGIC_ANALYZER_STATE_LSB         2
#define MAC_PCU_LOGIC_ANALYZER_STATE_MASK        0x00000004
#define MAC_PCU_LOGIC_ANALYZER_STATE_GET(x)      (((x) & MAC_PCU_LOGIC_ANALYZER_STATE_MASK) >> MAC_PCU_LOGIC_ANALYZER_STATE_LSB)
#define MAC_PCU_LOGIC_ANALYZER_STATE_SET(x)      (((x) << MAC_PCU_LOGIC_ANALYZER_STATE_LSB) & MAC_PCU_LOGIC_ANALYZER_STATE_MASK)
#define MAC_PCU_LOGIC_ANALYZER_CLEAR_MSB         1
#define MAC_PCU_LOGIC_ANALYZER_CLEAR_LSB         1
#define MAC_PCU_LOGIC_ANALYZER_CLEAR_MASK        0x00000002
#define MAC_PCU_LOGIC_ANALYZER_CLEAR_GET(x)      (((x) & MAC_PCU_LOGIC_ANALYZER_CLEAR_MASK) >> MAC_PCU_LOGIC_ANALYZER_CLEAR_LSB)
#define MAC_PCU_LOGIC_ANALYZER_CLEAR_SET(x)      (((x) << MAC_PCU_LOGIC_ANALYZER_CLEAR_LSB) & MAC_PCU_LOGIC_ANALYZER_CLEAR_MASK)
#define MAC_PCU_LOGIC_ANALYZER_HOLD_MSB          0
#define MAC_PCU_LOGIC_ANALYZER_HOLD_LSB          0
#define MAC_PCU_LOGIC_ANALYZER_HOLD_MASK         0x00000001
#define MAC_PCU_LOGIC_ANALYZER_HOLD_GET(x)       (((x) & MAC_PCU_LOGIC_ANALYZER_HOLD_MASK) >> MAC_PCU_LOGIC_ANALYZER_HOLD_LSB)
#define MAC_PCU_LOGIC_ANALYZER_HOLD_SET(x)       (((x) << MAC_PCU_LOGIC_ANALYZER_HOLD_LSB) & MAC_PCU_LOGIC_ANALYZER_HOLD_MASK)

#define MAC_PCU_LOGIC_ANALYZER_32L_ADDRESS       0x00008114
#define MAC_PCU_LOGIC_ANALYZER_32L_OFFSET        0x00000114
#define MAC_PCU_LOGIC_ANALYZER_32L_MASK_MSB      31
#define MAC_PCU_LOGIC_ANALYZER_32L_MASK_LSB      0
#define MAC_PCU_LOGIC_ANALYZER_32L_MASK_MASK     0xffffffff
#define MAC_PCU_LOGIC_ANALYZER_32L_MASK_GET(x)   (((x) & MAC_PCU_LOGIC_ANALYZER_32L_MASK_MASK) >> MAC_PCU_LOGIC_ANALYZER_32L_MASK_LSB)
#define MAC_PCU_LOGIC_ANALYZER_32L_MASK_SET(x)   (((x) << MAC_PCU_LOGIC_ANALYZER_32L_MASK_LSB) & MAC_PCU_LOGIC_ANALYZER_32L_MASK_MASK)

#define MAC_PCU_LOGIC_ANALYZER_16U_ADDRESS       0x00008118
#define MAC_PCU_LOGIC_ANALYZER_16U_OFFSET        0x00000118
#define MAC_PCU_LOGIC_ANALYZER_16U_MASK_MSB      15
#define MAC_PCU_LOGIC_ANALYZER_16U_MASK_LSB      0
#define MAC_PCU_LOGIC_ANALYZER_16U_MASK_MASK     0x0000ffff
#define MAC_PCU_LOGIC_ANALYZER_16U_MASK_GET(x)   (((x) & MAC_PCU_LOGIC_ANALYZER_16U_MASK_MASK) >> MAC_PCU_LOGIC_ANALYZER_16U_MASK_LSB)
#define MAC_PCU_LOGIC_ANALYZER_16U_MASK_SET(x)   (((x) << MAC_PCU_LOGIC_ANALYZER_16U_MASK_LSB) & MAC_PCU_LOGIC_ANALYZER_16U_MASK_MASK)

#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_ADDRESS    0x0000811c
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_OFFSET     0x0000011c
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK3_MSB  23
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK3_LSB  16
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK3_MASK 0x00ff0000
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK3_GET(x) (((x) & MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK3_MASK) >> MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK3_LSB)
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK3_SET(x) (((x) << MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK3_LSB) & MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK3_MASK)
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK2_MSB  15
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK2_LSB  8
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK2_MASK 0x0000ff00
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK2_GET(x) (((x) & MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK2_MASK) >> MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK2_LSB)
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK2_SET(x) (((x) << MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK2_LSB) & MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK2_MASK)
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK1_MSB  7
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK1_LSB  0
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK1_MASK 0x000000ff
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK1_GET(x) (((x) & MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK1_MASK) >> MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK1_LSB)
#define MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK1_SET(x) (((x) << MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK1_LSB) & MAC_PCU_PHY_ERR_CNT_MASK_CONT_MASK1_MASK)

#define MAC_PCU_AZIMUTH_MODE_ADDRESS             0x00008120
#define MAC_PCU_AZIMUTH_MODE_OFFSET              0x00000120
#define MAC_PCU_AZIMUTH_MODE_BA_USES_AD1_MSB     7
#define MAC_PCU_AZIMUTH_MODE_BA_USES_AD1_LSB     7
#define MAC_PCU_AZIMUTH_MODE_BA_USES_AD1_MASK    0x00000080
#define MAC_PCU_AZIMUTH_MODE_BA_USES_AD1_GET(x)  (((x) & MAC_PCU_AZIMUTH_MODE_BA_USES_AD1_MASK) >> MAC_PCU_AZIMUTH_MODE_BA_USES_AD1_LSB)
#define MAC_PCU_AZIMUTH_MODE_BA_USES_AD1_SET(x)  (((x) << MAC_PCU_AZIMUTH_MODE_BA_USES_AD1_LSB) & MAC_PCU_AZIMUTH_MODE_BA_USES_AD1_MASK)
#define MAC_PCU_AZIMUTH_MODE_ACK_CTS_MATCH_TX_AD2_MSB 6
#define MAC_PCU_AZIMUTH_MODE_ACK_CTS_MATCH_TX_AD2_LSB 6
#define MAC_PCU_AZIMUTH_MODE_ACK_CTS_MATCH_TX_AD2_MASK 0x00000040
#define MAC_PCU_AZIMUTH_MODE_ACK_CTS_MATCH_TX_AD2_GET(x) (((x) & MAC_PCU_AZIMUTH_MODE_ACK_CTS_MATCH_TX_AD2_MASK) >> MAC_PCU_AZIMUTH_MODE_ACK_CTS_MATCH_TX_AD2_LSB)
#define MAC_PCU_AZIMUTH_MODE_ACK_CTS_MATCH_TX_AD2_SET(x) (((x) << MAC_PCU_AZIMUTH_MODE_ACK_CTS_MATCH_TX_AD2_LSB) & MAC_PCU_AZIMUTH_MODE_ACK_CTS_MATCH_TX_AD2_MASK)
#define MAC_PCU_AZIMUTH_MODE_TX_DESC_EN_MSB      5
#define MAC_PCU_AZIMUTH_MODE_TX_DESC_EN_LSB      5
#define MAC_PCU_AZIMUTH_MODE_TX_DESC_EN_MASK     0x00000020
#define MAC_PCU_AZIMUTH_MODE_TX_DESC_EN_GET(x)   (((x) & MAC_PCU_AZIMUTH_MODE_TX_DESC_EN_MASK) >> MAC_PCU_AZIMUTH_MODE_TX_DESC_EN_LSB)
#define MAC_PCU_AZIMUTH_MODE_TX_DESC_EN_SET(x)   (((x) << MAC_PCU_AZIMUTH_MODE_TX_DESC_EN_LSB) & MAC_PCU_AZIMUTH_MODE_TX_DESC_EN_MASK)
#define MAC_PCU_AZIMUTH_MODE_CLK_EN_MSB          4
#define MAC_PCU_AZIMUTH_MODE_CLK_EN_LSB          4
#define MAC_PCU_AZIMUTH_MODE_CLK_EN_MASK         0x00000010
#define MAC_PCU_AZIMUTH_MODE_CLK_EN_GET(x)       (((x) & MAC_PCU_AZIMUTH_MODE_CLK_EN_MASK) >> MAC_PCU_AZIMUTH_MODE_CLK_EN_LSB)
#define MAC_PCU_AZIMUTH_MODE_CLK_EN_SET(x)       (((x) << MAC_PCU_AZIMUTH_MODE_CLK_EN_LSB) & MAC_PCU_AZIMUTH_MODE_CLK_EN_MASK)
#define MAC_PCU_AZIMUTH_MODE_RX_TSF_STATUS_SEL_MSB 3
#define MAC_PCU_AZIMUTH_MODE_RX_TSF_STATUS_SEL_LSB 3
#define MAC_PCU_AZIMUTH_MODE_RX_TSF_STATUS_SEL_MASK 0x00000008
#define MAC_PCU_AZIMUTH_MODE_RX_TSF_STATUS_SEL_GET(x) (((x) & MAC_PCU_AZIMUTH_MODE_RX_TSF_STATUS_SEL_MASK) >> MAC_PCU_AZIMUTH_MODE_RX_TSF_STATUS_SEL_LSB)
#define MAC_PCU_AZIMUTH_MODE_RX_TSF_STATUS_SEL_SET(x) (((x) << MAC_PCU_AZIMUTH_MODE_RX_TSF_STATUS_SEL_LSB) & MAC_PCU_AZIMUTH_MODE_RX_TSF_STATUS_SEL_MASK)
#define MAC_PCU_AZIMUTH_MODE_TX_TSF_STATUS_SEL_MSB 2
#define MAC_PCU_AZIMUTH_MODE_TX_TSF_STATUS_SEL_LSB 2
#define MAC_PCU_AZIMUTH_MODE_TX_TSF_STATUS_SEL_MASK 0x00000004
#define MAC_PCU_AZIMUTH_MODE_TX_TSF_STATUS_SEL_GET(x) (((x) & MAC_PCU_AZIMUTH_MODE_TX_TSF_STATUS_SEL_MASK) >> MAC_PCU_AZIMUTH_MODE_TX_TSF_STATUS_SEL_LSB)
#define MAC_PCU_AZIMUTH_MODE_TX_TSF_STATUS_SEL_SET(x) (((x) << MAC_PCU_AZIMUTH_MODE_TX_TSF_STATUS_SEL_LSB) & MAC_PCU_AZIMUTH_MODE_TX_TSF_STATUS_SEL_MASK)
#define MAC_PCU_AZIMUTH_MODE_KEY_SEARCH_AD1_MSB  1
#define MAC_PCU_AZIMUTH_MODE_KEY_SEARCH_AD1_LSB  1
#define MAC_PCU_AZIMUTH_MODE_KEY_SEARCH_AD1_MASK 0x00000002
#define MAC_PCU_AZIMUTH_MODE_KEY_SEARCH_AD1_GET(x) (((x) & MAC_PCU_AZIMUTH_MODE_KEY_SEARCH_AD1_MASK) >> MAC_PCU_AZIMUTH_MODE_KEY_SEARCH_AD1_LSB)
#define MAC_PCU_AZIMUTH_MODE_KEY_SEARCH_AD1_SET(x) (((x) << MAC_PCU_AZIMUTH_MODE_KEY_SEARCH_AD1_LSB) & MAC_PCU_AZIMUTH_MODE_KEY_SEARCH_AD1_MASK)
#define MAC_PCU_AZIMUTH_MODE_DISABLE_TSF_UPDATE_MSB 0
#define MAC_PCU_AZIMUTH_MODE_DISABLE_TSF_UPDATE_LSB 0
#define MAC_PCU_AZIMUTH_MODE_DISABLE_TSF_UPDATE_MASK 0x00000001
#define MAC_PCU_AZIMUTH_MODE_DISABLE_TSF_UPDATE_GET(x) (((x) & MAC_PCU_AZIMUTH_MODE_DISABLE_TSF_UPDATE_MASK) >> MAC_PCU_AZIMUTH_MODE_DISABLE_TSF_UPDATE_LSB)
#define MAC_PCU_AZIMUTH_MODE_DISABLE_TSF_UPDATE_SET(x) (((x) << MAC_PCU_AZIMUTH_MODE_DISABLE_TSF_UPDATE_LSB) & MAC_PCU_AZIMUTH_MODE_DISABLE_TSF_UPDATE_MASK)

#define MAC_PCU_20_40_MODE_ADDRESS               0x00008124
#define MAC_PCU_20_40_MODE_OFFSET                0x00000124
#define MAC_PCU_20_40_MODE_PIFS_CYCLES_MSB       15
#define MAC_PCU_20_40_MODE_PIFS_CYCLES_LSB       4
#define MAC_PCU_20_40_MODE_PIFS_CYCLES_MASK      0x0000fff0
#define MAC_PCU_20_40_MODE_PIFS_CYCLES_GET(x)    (((x) & MAC_PCU_20_40_MODE_PIFS_CYCLES_MASK) >> MAC_PCU_20_40_MODE_PIFS_CYCLES_LSB)
#define MAC_PCU_20_40_MODE_PIFS_CYCLES_SET(x)    (((x) << MAC_PCU_20_40_MODE_PIFS_CYCLES_LSB) & MAC_PCU_20_40_MODE_PIFS_CYCLES_MASK)
#define MAC_PCU_20_40_MODE_SWAMPED_FORCES_RX_CLEAR_CTL_IDLE_MSB 3
#define MAC_PCU_20_40_MODE_SWAMPED_FORCES_RX_CLEAR_CTL_IDLE_LSB 3
#define MAC_PCU_20_40_MODE_SWAMPED_FORCES_RX_CLEAR_CTL_IDLE_MASK 0x00000008
#define MAC_PCU_20_40_MODE_SWAMPED_FORCES_RX_CLEAR_CTL_IDLE_GET(x) (((x) & MAC_PCU_20_40_MODE_SWAMPED_FORCES_RX_CLEAR_CTL_IDLE_MASK) >> MAC_PCU_20_40_MODE_SWAMPED_FORCES_RX_CLEAR_CTL_IDLE_LSB)
#define MAC_PCU_20_40_MODE_SWAMPED_FORCES_RX_CLEAR_CTL_IDLE_SET(x) (((x) << MAC_PCU_20_40_MODE_SWAMPED_FORCES_RX_CLEAR_CTL_IDLE_LSB) & MAC_PCU_20_40_MODE_SWAMPED_FORCES_RX_CLEAR_CTL_IDLE_MASK)
#define MAC_PCU_20_40_MODE_TX_HT20_ON_EXT_BUSY_MSB 2
#define MAC_PCU_20_40_MODE_TX_HT20_ON_EXT_BUSY_LSB 2
#define MAC_PCU_20_40_MODE_TX_HT20_ON_EXT_BUSY_MASK 0x00000004
#define MAC_PCU_20_40_MODE_TX_HT20_ON_EXT_BUSY_GET(x) (((x) & MAC_PCU_20_40_MODE_TX_HT20_ON_EXT_BUSY_MASK) >> MAC_PCU_20_40_MODE_TX_HT20_ON_EXT_BUSY_LSB)
#define MAC_PCU_20_40_MODE_TX_HT20_ON_EXT_BUSY_SET(x) (((x) << MAC_PCU_20_40_MODE_TX_HT20_ON_EXT_BUSY_LSB) & MAC_PCU_20_40_MODE_TX_HT20_ON_EXT_BUSY_MASK)
#define MAC_PCU_20_40_MODE_EXT_PIFS_ENABLE_MSB   1
#define MAC_PCU_20_40_MODE_EXT_PIFS_ENABLE_LSB   1
#define MAC_PCU_20_40_MODE_EXT_PIFS_ENABLE_MASK  0x00000002
#define MAC_PCU_20_40_MODE_EXT_PIFS_ENABLE_GET(x) (((x) & MAC_PCU_20_40_MODE_EXT_PIFS_ENABLE_MASK) >> MAC_PCU_20_40_MODE_EXT_PIFS_ENABLE_LSB)
#define MAC_PCU_20_40_MODE_EXT_PIFS_ENABLE_SET(x) (((x) << MAC_PCU_20_40_MODE_EXT_PIFS_ENABLE_LSB) & MAC_PCU_20_40_MODE_EXT_PIFS_ENABLE_MASK)
#define MAC_PCU_20_40_MODE_JOINED_RX_CLEAR_MSB   0
#define MAC_PCU_20_40_MODE_JOINED_RX_CLEAR_LSB   0
#define MAC_PCU_20_40_MODE_JOINED_RX_CLEAR_MASK  0x00000001
#define MAC_PCU_20_40_MODE_JOINED_RX_CLEAR_GET(x) (((x) & MAC_PCU_20_40_MODE_JOINED_RX_CLEAR_MASK) >> MAC_PCU_20_40_MODE_JOINED_RX_CLEAR_LSB)
#define MAC_PCU_20_40_MODE_JOINED_RX_CLEAR_SET(x) (((x) << MAC_PCU_20_40_MODE_JOINED_RX_CLEAR_LSB) & MAC_PCU_20_40_MODE_JOINED_RX_CLEAR_MASK)

#define MAC_PCU_RX_CLEAR_DIFF_CNT_ADDRESS        0x00008128
#define MAC_PCU_RX_CLEAR_DIFF_CNT_OFFSET         0x00000128
#define MAC_PCU_RX_CLEAR_DIFF_CNT_VALUE_MSB      31
#define MAC_PCU_RX_CLEAR_DIFF_CNT_VALUE_LSB      0
#define MAC_PCU_RX_CLEAR_DIFF_CNT_VALUE_MASK     0xffffffff
#define MAC_PCU_RX_CLEAR_DIFF_CNT_VALUE_GET(x)   (((x) & MAC_PCU_RX_CLEAR_DIFF_CNT_VALUE_MASK) >> MAC_PCU_RX_CLEAR_DIFF_CNT_VALUE_LSB)
#define MAC_PCU_RX_CLEAR_DIFF_CNT_VALUE_SET(x)   (((x) << MAC_PCU_RX_CLEAR_DIFF_CNT_VALUE_LSB) & MAC_PCU_RX_CLEAR_DIFF_CNT_VALUE_MASK)

#define MAC_PCU_SELF_GEN_ANTENNA_MASK_ADDRESS    0x0000812c
#define MAC_PCU_SELF_GEN_ANTENNA_MASK_OFFSET     0x0000012c
#define MAC_PCU_SELF_GEN_ANTENNA_MASK_VALUE_MSB  2
#define MAC_PCU_SELF_GEN_ANTENNA_MASK_VALUE_LSB  0
#define MAC_PCU_SELF_GEN_ANTENNA_MASK_VALUE_MASK 0x00000007
#define MAC_PCU_SELF_GEN_ANTENNA_MASK_VALUE_GET(x) (((x) & MAC_PCU_SELF_GEN_ANTENNA_MASK_VALUE_MASK) >> MAC_PCU_SELF_GEN_ANTENNA_MASK_VALUE_LSB)
#define MAC_PCU_SELF_GEN_ANTENNA_MASK_VALUE_SET(x) (((x) << MAC_PCU_SELF_GEN_ANTENNA_MASK_VALUE_LSB) & MAC_PCU_SELF_GEN_ANTENNA_MASK_VALUE_MASK)

#define MAC_PCU_BA_BAR_CONTROL_ADDRESS           0x00008130
#define MAC_PCU_BA_BAR_CONTROL_OFFSET            0x00000130
#define MAC_PCU_BA_BAR_CONTROL_UPDATE_BA_BITMAP_QOS_NULL_MSB 12
#define MAC_PCU_BA_BAR_CONTROL_UPDATE_BA_BITMAP_QOS_NULL_LSB 12
#define MAC_PCU_BA_BAR_CONTROL_UPDATE_BA_BITMAP_QOS_NULL_MASK 0x00001000
#define MAC_PCU_BA_BAR_CONTROL_UPDATE_BA_BITMAP_QOS_NULL_GET(x) (((x) & MAC_PCU_BA_BAR_CONTROL_UPDATE_BA_BITMAP_QOS_NULL_MASK) >> MAC_PCU_BA_BAR_CONTROL_UPDATE_BA_BITMAP_QOS_NULL_LSB)
#define MAC_PCU_BA_BAR_CONTROL_UPDATE_BA_BITMAP_QOS_NULL_SET(x) (((x) << MAC_PCU_BA_BAR_CONTROL_UPDATE_BA_BITMAP_QOS_NULL_LSB) & MAC_PCU_BA_BAR_CONTROL_UPDATE_BA_BITMAP_QOS_NULL_MASK)
#define MAC_PCU_BA_BAR_CONTROL_TX_BA_CLEAR_BA_VALID_MSB 11
#define MAC_PCU_BA_BAR_CONTROL_TX_BA_CLEAR_BA_VALID_LSB 11
#define MAC_PCU_BA_BAR_CONTROL_TX_BA_CLEAR_BA_VALID_MASK 0x00000800
#define MAC_PCU_BA_BAR_CONTROL_TX_BA_CLEAR_BA_VALID_GET(x) (((x) & MAC_PCU_BA_BAR_CONTROL_TX_BA_CLEAR_BA_VALID_MASK) >> MAC_PCU_BA_BAR_CONTROL_TX_BA_CLEAR_BA_VALID_LSB)
#define MAC_PCU_BA_BAR_CONTROL_TX_BA_CLEAR_BA_VALID_SET(x) (((x) << MAC_PCU_BA_BAR_CONTROL_TX_BA_CLEAR_BA_VALID_LSB) & MAC_PCU_BA_BAR_CONTROL_TX_BA_CLEAR_BA_VALID_MASK)
#define MAC_PCU_BA_BAR_CONTROL_FORCE_NO_MATCH_MSB 10
#define MAC_PCU_BA_BAR_CONTROL_FORCE_NO_MATCH_LSB 10
#define MAC_PCU_BA_BAR_CONTROL_FORCE_NO_MATCH_MASK 0x00000400
#define MAC_PCU_BA_BAR_CONTROL_FORCE_NO_MATCH_GET(x) (((x) & MAC_PCU_BA_BAR_CONTROL_FORCE_NO_MATCH_MASK) >> MAC_PCU_BA_BAR_CONTROL_FORCE_NO_MATCH_LSB)
#define MAC_PCU_BA_BAR_CONTROL_FORCE_NO_MATCH_SET(x) (((x) << MAC_PCU_BA_BAR_CONTROL_FORCE_NO_MATCH_LSB) & MAC_PCU_BA_BAR_CONTROL_FORCE_NO_MATCH_MASK)
#define MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_VALUE_MSB 9
#define MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_VALUE_LSB 9
#define MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_VALUE_MASK 0x00000200
#define MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_VALUE_GET(x) (((x) & MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_VALUE_MASK) >> MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_VALUE_LSB)
#define MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_VALUE_SET(x) (((x) << MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_VALUE_LSB) & MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_VALUE_MASK)
#define MAC_PCU_BA_BAR_CONTROL_COMPRESSED_VALUE_MSB 8
#define MAC_PCU_BA_BAR_CONTROL_COMPRESSED_VALUE_LSB 8
#define MAC_PCU_BA_BAR_CONTROL_COMPRESSED_VALUE_MASK 0x00000100
#define MAC_PCU_BA_BAR_CONTROL_COMPRESSED_VALUE_GET(x) (((x) & MAC_PCU_BA_BAR_CONTROL_COMPRESSED_VALUE_MASK) >> MAC_PCU_BA_BAR_CONTROL_COMPRESSED_VALUE_LSB)
#define MAC_PCU_BA_BAR_CONTROL_COMPRESSED_VALUE_SET(x) (((x) << MAC_PCU_BA_BAR_CONTROL_COMPRESSED_VALUE_LSB) & MAC_PCU_BA_BAR_CONTROL_COMPRESSED_VALUE_MASK)
#define MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_OFFSET_MSB 7
#define MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_OFFSET_LSB 4
#define MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_OFFSET_MASK 0x000000f0
#define MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_OFFSET_GET(x) (((x) & MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_OFFSET_MASK) >> MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_OFFSET_LSB)
#define MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_OFFSET_SET(x) (((x) << MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_OFFSET_LSB) & MAC_PCU_BA_BAR_CONTROL_ACK_POLICY_OFFSET_MASK)
#define MAC_PCU_BA_BAR_CONTROL_COMPRESSED_OFFSET_MSB 3
#define MAC_PCU_BA_BAR_CONTROL_COMPRESSED_OFFSET_LSB 0
#define MAC_PCU_BA_BAR_CONTROL_COMPRESSED_OFFSET_MASK 0x0000000f
#define MAC_PCU_BA_BAR_CONTROL_COMPRESSED_OFFSET_GET(x) (((x) & MAC_PCU_BA_BAR_CONTROL_COMPRESSED_OFFSET_MASK) >> MAC_PCU_BA_BAR_CONTROL_COMPRESSED_OFFSET_LSB)
#define MAC_PCU_BA_BAR_CONTROL_COMPRESSED_OFFSET_SET(x) (((x) << MAC_PCU_BA_BAR_CONTROL_COMPRESSED_OFFSET_LSB) & MAC_PCU_BA_BAR_CONTROL_COMPRESSED_OFFSET_MASK)

#define MAC_PCU_LEGACY_PLCP_SPOOF_ADDRESS        0x00008134
#define MAC_PCU_LEGACY_PLCP_SPOOF_OFFSET         0x00000134
#define MAC_PCU_LEGACY_PLCP_SPOOF_MIN_LENGTH_MSB 12
#define MAC_PCU_LEGACY_PLCP_SPOOF_MIN_LENGTH_LSB 8
#define MAC_PCU_LEGACY_PLCP_SPOOF_MIN_LENGTH_MASK 0x00001f00
#define MAC_PCU_LEGACY_PLCP_SPOOF_MIN_LENGTH_GET(x) (((x) & MAC_PCU_LEGACY_PLCP_SPOOF_MIN_LENGTH_MASK) >> MAC_PCU_LEGACY_PLCP_SPOOF_MIN_LENGTH_LSB)
#define MAC_PCU_LEGACY_PLCP_SPOOF_MIN_LENGTH_SET(x) (((x) << MAC_PCU_LEGACY_PLCP_SPOOF_MIN_LENGTH_LSB) & MAC_PCU_LEGACY_PLCP_SPOOF_MIN_LENGTH_MASK)
#define MAC_PCU_LEGACY_PLCP_SPOOF_EIFS_MINUS_DIFS_MSB 7
#define MAC_PCU_LEGACY_PLCP_SPOOF_EIFS_MINUS_DIFS_LSB 0
#define MAC_PCU_LEGACY_PLCP_SPOOF_EIFS_MINUS_DIFS_MASK 0x000000ff
#define MAC_PCU_LEGACY_PLCP_SPOOF_EIFS_MINUS_DIFS_GET(x) (((x) & MAC_PCU_LEGACY_PLCP_SPOOF_EIFS_MINUS_DIFS_MASK) >> MAC_PCU_LEGACY_PLCP_SPOOF_EIFS_MINUS_DIFS_LSB)
#define MAC_PCU_LEGACY_PLCP_SPOOF_EIFS_MINUS_DIFS_SET(x) (((x) << MAC_PCU_LEGACY_PLCP_SPOOF_EIFS_MINUS_DIFS_LSB) & MAC_PCU_LEGACY_PLCP_SPOOF_EIFS_MINUS_DIFS_MASK)

#define MAC_PCU_PHY_ERROR_MASK_CONT_ADDRESS      0x00008138
#define MAC_PCU_PHY_ERROR_MASK_CONT_OFFSET       0x00000138
#define MAC_PCU_PHY_ERROR_MASK_CONT_EIFS_VALUE_MSB 23
#define MAC_PCU_PHY_ERROR_MASK_CONT_EIFS_VALUE_LSB 16
#define MAC_PCU_PHY_ERROR_MASK_CONT_EIFS_VALUE_MASK 0x00ff0000
#define MAC_PCU_PHY_ERROR_MASK_CONT_EIFS_VALUE_GET(x) (((x) & MAC_PCU_PHY_ERROR_MASK_CONT_EIFS_VALUE_MASK) >> MAC_PCU_PHY_ERROR_MASK_CONT_EIFS_VALUE_LSB)
#define MAC_PCU_PHY_ERROR_MASK_CONT_EIFS_VALUE_SET(x) (((x) << MAC_PCU_PHY_ERROR_MASK_CONT_EIFS_VALUE_LSB) & MAC_PCU_PHY_ERROR_MASK_CONT_EIFS_VALUE_MASK)
#define MAC_PCU_PHY_ERROR_MASK_CONT_MASK_VALUE_MSB 7
#define MAC_PCU_PHY_ERROR_MASK_CONT_MASK_VALUE_LSB 0
#define MAC_PCU_PHY_ERROR_MASK_CONT_MASK_VALUE_MASK 0x000000ff
#define MAC_PCU_PHY_ERROR_MASK_CONT_MASK_VALUE_GET(x) (((x) & MAC_PCU_PHY_ERROR_MASK_CONT_MASK_VALUE_MASK) >> MAC_PCU_PHY_ERROR_MASK_CONT_MASK_VALUE_LSB)
#define MAC_PCU_PHY_ERROR_MASK_CONT_MASK_VALUE_SET(x) (((x) << MAC_PCU_PHY_ERROR_MASK_CONT_MASK_VALUE_LSB) & MAC_PCU_PHY_ERROR_MASK_CONT_MASK_VALUE_MASK)

#define MAC_PCU_TX_TIMER_ADDRESS                 0x0000813c
#define MAC_PCU_TX_TIMER_OFFSET                  0x0000013c
#define MAC_PCU_TX_TIMER_QUIET_TIMER_ENABLE_MSB  25
#define MAC_PCU_TX_TIMER_QUIET_TIMER_ENABLE_LSB  25
#define MAC_PCU_TX_TIMER_QUIET_TIMER_ENABLE_MASK 0x02000000
#define MAC_PCU_TX_TIMER_QUIET_TIMER_ENABLE_GET(x) (((x) & MAC_PCU_TX_TIMER_QUIET_TIMER_ENABLE_MASK) >> MAC_PCU_TX_TIMER_QUIET_TIMER_ENABLE_LSB)
#define MAC_PCU_TX_TIMER_QUIET_TIMER_ENABLE_SET(x) (((x) << MAC_PCU_TX_TIMER_QUIET_TIMER_ENABLE_LSB) & MAC_PCU_TX_TIMER_QUIET_TIMER_ENABLE_MASK)
#define MAC_PCU_TX_TIMER_QUIET_TIMER_MSB         24
#define MAC_PCU_TX_TIMER_QUIET_TIMER_LSB         20
#define MAC_PCU_TX_TIMER_QUIET_TIMER_MASK        0x01f00000
#define MAC_PCU_TX_TIMER_QUIET_TIMER_GET(x)      (((x) & MAC_PCU_TX_TIMER_QUIET_TIMER_MASK) >> MAC_PCU_TX_TIMER_QUIET_TIMER_LSB)
#define MAC_PCU_TX_TIMER_QUIET_TIMER_SET(x)      (((x) << MAC_PCU_TX_TIMER_QUIET_TIMER_LSB) & MAC_PCU_TX_TIMER_QUIET_TIMER_MASK)
#define MAC_PCU_TX_TIMER_RIFS_TIMER_MSB          19
#define MAC_PCU_TX_TIMER_RIFS_TIMER_LSB          16
#define MAC_PCU_TX_TIMER_RIFS_TIMER_MASK         0x000f0000
#define MAC_PCU_TX_TIMER_RIFS_TIMER_GET(x)       (((x) & MAC_PCU_TX_TIMER_RIFS_TIMER_MASK) >> MAC_PCU_TX_TIMER_RIFS_TIMER_LSB)
#define MAC_PCU_TX_TIMER_RIFS_TIMER_SET(x)       (((x) << MAC_PCU_TX_TIMER_RIFS_TIMER_LSB) & MAC_PCU_TX_TIMER_RIFS_TIMER_MASK)
#define MAC_PCU_TX_TIMER_TX_TIMER_ENABLE_MSB     15
#define MAC_PCU_TX_TIMER_TX_TIMER_ENABLE_LSB     15
#define MAC_PCU_TX_TIMER_TX_TIMER_ENABLE_MASK    0x00008000
#define MAC_PCU_TX_TIMER_TX_TIMER_ENABLE_GET(x)  (((x) & MAC_PCU_TX_TIMER_TX_TIMER_ENABLE_MASK) >> MAC_PCU_TX_TIMER_TX_TIMER_ENABLE_LSB)
#define MAC_PCU_TX_TIMER_TX_TIMER_ENABLE_SET(x)  (((x) << MAC_PCU_TX_TIMER_TX_TIMER_ENABLE_LSB) & MAC_PCU_TX_TIMER_TX_TIMER_ENABLE_MASK)
#define MAC_PCU_TX_TIMER_TX_TIMER_MSB            14
#define MAC_PCU_TX_TIMER_TX_TIMER_LSB            0
#define MAC_PCU_TX_TIMER_TX_TIMER_MASK           0x00007fff
#define MAC_PCU_TX_TIMER_TX_TIMER_GET(x)         (((x) & MAC_PCU_TX_TIMER_TX_TIMER_MASK) >> MAC_PCU_TX_TIMER_TX_TIMER_LSB)
#define MAC_PCU_TX_TIMER_TX_TIMER_SET(x)         (((x) << MAC_PCU_TX_TIMER_TX_TIMER_LSB) & MAC_PCU_TX_TIMER_TX_TIMER_MASK)

#define MAC_PCU_TXBUF_CTRL_ADDRESS               0x00008140
#define MAC_PCU_TXBUF_CTRL_OFFSET                0x00000140
#define MAC_PCU_TXBUF_CTRL_TX_FIFO_WRAP_ENABLE_MSB 16
#define MAC_PCU_TXBUF_CTRL_TX_FIFO_WRAP_ENABLE_LSB 16
#define MAC_PCU_TXBUF_CTRL_TX_FIFO_WRAP_ENABLE_MASK 0x00010000
#define MAC_PCU_TXBUF_CTRL_TX_FIFO_WRAP_ENABLE_GET(x) (((x) & MAC_PCU_TXBUF_CTRL_TX_FIFO_WRAP_ENABLE_MASK) >> MAC_PCU_TXBUF_CTRL_TX_FIFO_WRAP_ENABLE_LSB)
#define MAC_PCU_TXBUF_CTRL_TX_FIFO_WRAP_ENABLE_SET(x) (((x) << MAC_PCU_TXBUF_CTRL_TX_FIFO_WRAP_ENABLE_LSB) & MAC_PCU_TXBUF_CTRL_TX_FIFO_WRAP_ENABLE_MASK)
#define MAC_PCU_TXBUF_CTRL_USABLE_ENTRIES_MSB    11
#define MAC_PCU_TXBUF_CTRL_USABLE_ENTRIES_LSB    0
#define MAC_PCU_TXBUF_CTRL_USABLE_ENTRIES_MASK   0x00000fff
#define MAC_PCU_TXBUF_CTRL_USABLE_ENTRIES_GET(x) (((x) & MAC_PCU_TXBUF_CTRL_USABLE_ENTRIES_MASK) >> MAC_PCU_TXBUF_CTRL_USABLE_ENTRIES_LSB)
#define MAC_PCU_TXBUF_CTRL_USABLE_ENTRIES_SET(x) (((x) << MAC_PCU_TXBUF_CTRL_USABLE_ENTRIES_LSB) & MAC_PCU_TXBUF_CTRL_USABLE_ENTRIES_MASK)

#define MAC_PCU_MISC_MODE2_ADDRESS               0x00008144
#define MAC_PCU_MISC_MODE2_OFFSET                0x00000144
#define MAC_PCU_MISC_MODE2_RESERVED_1_MSB        31
#define MAC_PCU_MISC_MODE2_RESERVED_1_LSB        28
#define MAC_PCU_MISC_MODE2_RESERVED_1_MASK       0xf0000000
#define MAC_PCU_MISC_MODE2_RESERVED_1_GET(x)     (((x) & MAC_PCU_MISC_MODE2_RESERVED_1_MASK) >> MAC_PCU_MISC_MODE2_RESERVED_1_LSB)
#define MAC_PCU_MISC_MODE2_RESERVED_1_SET(x)     (((x) << MAC_PCU_MISC_MODE2_RESERVED_1_LSB) & MAC_PCU_MISC_MODE2_RESERVED_1_MASK)
#define MAC_PCU_MISC_MODE2_RCV_TIMESTAMP_FIX_MSB 27
#define MAC_PCU_MISC_MODE2_RCV_TIMESTAMP_FIX_LSB 27
#define MAC_PCU_MISC_MODE2_RCV_TIMESTAMP_FIX_MASK 0x08000000
#define MAC_PCU_MISC_MODE2_RCV_TIMESTAMP_FIX_GET(x) (((x) & MAC_PCU_MISC_MODE2_RCV_TIMESTAMP_FIX_MASK) >> MAC_PCU_MISC_MODE2_RCV_TIMESTAMP_FIX_LSB)
#define MAC_PCU_MISC_MODE2_RCV_TIMESTAMP_FIX_SET(x) (((x) << MAC_PCU_MISC_MODE2_RCV_TIMESTAMP_FIX_LSB) & MAC_PCU_MISC_MODE2_RCV_TIMESTAMP_FIX_MASK)
#define MAC_PCU_MISC_MODE2_BEACON_FROM_TO_DS_MSB 26
#define MAC_PCU_MISC_MODE2_BEACON_FROM_TO_DS_LSB 26
#define MAC_PCU_MISC_MODE2_BEACON_FROM_TO_DS_MASK 0x04000000
#define MAC_PCU_MISC_MODE2_BEACON_FROM_TO_DS_GET(x) (((x) & MAC_PCU_MISC_MODE2_BEACON_FROM_TO_DS_MASK) >> MAC_PCU_MISC_MODE2_BEACON_FROM_TO_DS_LSB)
#define MAC_PCU_MISC_MODE2_BEACON_FROM_TO_DS_SET(x) (((x) << MAC_PCU_MISC_MODE2_BEACON_FROM_TO_DS_LSB) & MAC_PCU_MISC_MODE2_BEACON_FROM_TO_DS_MASK)
#define MAC_PCU_MISC_MODE2_PM_FIELD_FOR_MGMT_MSB 25
#define MAC_PCU_MISC_MODE2_PM_FIELD_FOR_MGMT_LSB 25
#define MAC_PCU_MISC_MODE2_PM_FIELD_FOR_MGMT_MASK 0x02000000
#define MAC_PCU_MISC_MODE2_PM_FIELD_FOR_MGMT_GET(x) (((x) & MAC_PCU_MISC_MODE2_PM_FIELD_FOR_MGMT_MASK) >> MAC_PCU_MISC_MODE2_PM_FIELD_FOR_MGMT_LSB)
#define MAC_PCU_MISC_MODE2_PM_FIELD_FOR_MGMT_SET(x) (((x) << MAC_PCU_MISC_MODE2_PM_FIELD_FOR_MGMT_LSB) & MAC_PCU_MISC_MODE2_PM_FIELD_FOR_MGMT_MASK)
#define MAC_PCU_MISC_MODE2_PM_FIELD_FOR_DAT_MSB  24
#define MAC_PCU_MISC_MODE2_PM_FIELD_FOR_DAT_LSB  24
#define MAC_PCU_MISC_MODE2_PM_FIELD_FOR_DAT_MASK 0x01000000
#define MAC_PCU_MISC_MODE2_PM_FIELD_FOR_DAT_GET(x) (((x) & MAC_PCU_MISC_MODE2_PM_FIELD_FOR_DAT_MASK) >> MAC_PCU_MISC_MODE2_PM_FIELD_FOR_DAT_LSB)
#define MAC_PCU_MISC_MODE2_PM_FIELD_FOR_DAT_SET(x) (((x) << MAC_PCU_MISC_MODE2_PM_FIELD_FOR_DAT_LSB) & MAC_PCU_MISC_MODE2_PM_FIELD_FOR_DAT_MASK)
#define MAC_PCU_MISC_MODE2_IGNORE_TXOP_IF_ZERO_MSB 23
#define MAC_PCU_MISC_MODE2_IGNORE_TXOP_IF_ZERO_LSB 23
#define MAC_PCU_MISC_MODE2_IGNORE_TXOP_IF_ZERO_MASK 0x00800000
#define MAC_PCU_MISC_MODE2_IGNORE_TXOP_IF_ZERO_GET(x) (((x) & MAC_PCU_MISC_MODE2_IGNORE_TXOP_IF_ZERO_MASK) >> MAC_PCU_MISC_MODE2_IGNORE_TXOP_IF_ZERO_LSB)
#define MAC_PCU_MISC_MODE2_IGNORE_TXOP_IF_ZERO_SET(x) (((x) << MAC_PCU_MISC_MODE2_IGNORE_TXOP_IF_ZERO_LSB) & MAC_PCU_MISC_MODE2_IGNORE_TXOP_IF_ZERO_MASK)
#define MAC_PCU_MISC_MODE2_IGNORE_TXOP_1ST_PKT_MSB 22
#define MAC_PCU_MISC_MODE2_IGNORE_TXOP_1ST_PKT_LSB 22
#define MAC_PCU_MISC_MODE2_IGNORE_TXOP_1ST_PKT_MASK 0x00400000
#define MAC_PCU_MISC_MODE2_IGNORE_TXOP_1ST_PKT_GET(x) (((x) & MAC_PCU_MISC_MODE2_IGNORE_TXOP_1ST_PKT_MASK) >> MAC_PCU_MISC_MODE2_IGNORE_TXOP_1ST_PKT_LSB)
#define MAC_PCU_MISC_MODE2_IGNORE_TXOP_1ST_PKT_SET(x) (((x) << MAC_PCU_MISC_MODE2_IGNORE_TXOP_1ST_PKT_LSB) & MAC_PCU_MISC_MODE2_IGNORE_TXOP_1ST_PKT_MASK)
#define MAC_PCU_MISC_MODE2_CLEAR_MORE_FRAG_MSB   21
#define MAC_PCU_MISC_MODE2_CLEAR_MORE_FRAG_LSB   21
#define MAC_PCU_MISC_MODE2_CLEAR_MORE_FRAG_MASK  0x00200000
#define MAC_PCU_MISC_MODE2_CLEAR_MORE_FRAG_GET(x) (((x) & MAC_PCU_MISC_MODE2_CLEAR_MORE_FRAG_MASK) >> MAC_PCU_MISC_MODE2_CLEAR_MORE_FRAG_LSB)
#define MAC_PCU_MISC_MODE2_CLEAR_MORE_FRAG_SET(x) (((x) << MAC_PCU_MISC_MODE2_CLEAR_MORE_FRAG_LSB) & MAC_PCU_MISC_MODE2_CLEAR_MORE_FRAG_MASK)
#define MAC_PCU_MISC_MODE2_BUG_28676_MSB         20
#define MAC_PCU_MISC_MODE2_BUG_28676_LSB         20
#define MAC_PCU_MISC_MODE2_BUG_28676_MASK        0x00100000
#define MAC_PCU_MISC_MODE2_BUG_28676_GET(x)      (((x) & MAC_PCU_MISC_MODE2_BUG_28676_MASK) >> MAC_PCU_MISC_MODE2_BUG_28676_LSB)
#define MAC_PCU_MISC_MODE2_BUG_28676_SET(x)      (((x) << MAC_PCU_MISC_MODE2_BUG_28676_LSB) & MAC_PCU_MISC_MODE2_BUG_28676_MASK)
#define MAC_PCU_MISC_MODE2_DUR_ACCOUNT_BY_BA_MSB 19
#define MAC_PCU_MISC_MODE2_DUR_ACCOUNT_BY_BA_LSB 19
#define MAC_PCU_MISC_MODE2_DUR_ACCOUNT_BY_BA_MASK 0x00080000
#define MAC_PCU_MISC_MODE2_DUR_ACCOUNT_BY_BA_GET(x) (((x) & MAC_PCU_MISC_MODE2_DUR_ACCOUNT_BY_BA_MASK) >> MAC_PCU_MISC_MODE2_DUR_ACCOUNT_BY_BA_LSB)
#define MAC_PCU_MISC_MODE2_DUR_ACCOUNT_BY_BA_SET(x) (((x) << MAC_PCU_MISC_MODE2_DUR_ACCOUNT_BY_BA_LSB) & MAC_PCU_MISC_MODE2_DUR_ACCOUNT_BY_BA_MASK)
#define MAC_PCU_MISC_MODE2_BC_MC_WAPI_MODE_MSB   18
#define MAC_PCU_MISC_MODE2_BC_MC_WAPI_MODE_LSB   18
#define MAC_PCU_MISC_MODE2_BC_MC_WAPI_MODE_MASK  0x00040000
#define MAC_PCU_MISC_MODE2_BC_MC_WAPI_MODE_GET(x) (((x) & MAC_PCU_MISC_MODE2_BC_MC_WAPI_MODE_MASK) >> MAC_PCU_MISC_MODE2_BC_MC_WAPI_MODE_LSB)
#define MAC_PCU_MISC_MODE2_BC_MC_WAPI_MODE_SET(x) (((x) << MAC_PCU_MISC_MODE2_BC_MC_WAPI_MODE_LSB) & MAC_PCU_MISC_MODE2_BC_MC_WAPI_MODE_MASK)
#define MAC_PCU_MISC_MODE2_AGG_WEP_MSB           17
#define MAC_PCU_MISC_MODE2_AGG_WEP_LSB           17
#define MAC_PCU_MISC_MODE2_AGG_WEP_MASK          0x00020000
#define MAC_PCU_MISC_MODE2_AGG_WEP_GET(x)        (((x) & MAC_PCU_MISC_MODE2_AGG_WEP_MASK) >> MAC_PCU_MISC_MODE2_AGG_WEP_LSB)
#define MAC_PCU_MISC_MODE2_AGG_WEP_SET(x)        (((x) << MAC_PCU_MISC_MODE2_AGG_WEP_LSB) & MAC_PCU_MISC_MODE2_AGG_WEP_MASK)
#define MAC_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DURATION_MSB 16
#define MAC_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DURATION_LSB 16
#define MAC_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DURATION_MASK 0x00010000
#define MAC_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DURATION_GET(x) (((x) & MAC_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DURATION_MASK) >> MAC_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DURATION_LSB)
#define MAC_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DURATION_SET(x) (((x) << MAC_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DURATION_LSB) & MAC_PCU_MISC_MODE2_ENABLE_LOAD_NAV_BEACON_DURATION_MASK)
#define MAC_PCU_MISC_MODE2_MGMT_QOS_MSB          15
#define MAC_PCU_MISC_MODE2_MGMT_QOS_LSB          8
#define MAC_PCU_MISC_MODE2_MGMT_QOS_MASK         0x0000ff00
#define MAC_PCU_MISC_MODE2_MGMT_QOS_GET(x)       (((x) & MAC_PCU_MISC_MODE2_MGMT_QOS_MASK) >> MAC_PCU_MISC_MODE2_MGMT_QOS_LSB)
#define MAC_PCU_MISC_MODE2_MGMT_QOS_SET(x)       (((x) << MAC_PCU_MISC_MODE2_MGMT_QOS_LSB) & MAC_PCU_MISC_MODE2_MGMT_QOS_MASK)
#define MAC_PCU_MISC_MODE2_CFP_IGNORE_MSB        7
#define MAC_PCU_MISC_MODE2_CFP_IGNORE_LSB        7
#define MAC_PCU_MISC_MODE2_CFP_IGNORE_MASK       0x00000080
#define MAC_PCU_MISC_MODE2_CFP_IGNORE_GET(x)     (((x) & MAC_PCU_MISC_MODE2_CFP_IGNORE_MASK) >> MAC_PCU_MISC_MODE2_CFP_IGNORE_LSB)
#define MAC_PCU_MISC_MODE2_CFP_IGNORE_SET(x)     (((x) << MAC_PCU_MISC_MODE2_CFP_IGNORE_LSB) & MAC_PCU_MISC_MODE2_CFP_IGNORE_MASK)
#define MAC_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE_MSB 6
#define MAC_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE_LSB 6
#define MAC_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE_MASK 0x00000040
#define MAC_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE_GET(x) (((x) & MAC_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE_MASK) >> MAC_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE_LSB)
#define MAC_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE_SET(x) (((x) << MAC_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE_LSB) & MAC_PCU_MISC_MODE2_ADHOC_MCAST_KEYID_ENABLE_MASK)
#define MAC_PCU_MISC_MODE2_RESERVED_2_MSB        5
#define MAC_PCU_MISC_MODE2_RESERVED_2_LSB        5
#define MAC_PCU_MISC_MODE2_RESERVED_2_MASK       0x00000020
#define MAC_PCU_MISC_MODE2_RESERVED_2_GET(x)     (((x) & MAC_PCU_MISC_MODE2_RESERVED_2_MASK) >> MAC_PCU_MISC_MODE2_RESERVED_2_LSB)
#define MAC_PCU_MISC_MODE2_RESERVED_2_SET(x)     (((x) << MAC_PCU_MISC_MODE2_RESERVED_2_LSB) & MAC_PCU_MISC_MODE2_RESERVED_2_MASK)
#define MAC_PCU_MISC_MODE2_BUG_58057_FIX_ENABLE_MSB 4
#define MAC_PCU_MISC_MODE2_BUG_58057_FIX_ENABLE_LSB 4
#define MAC_PCU_MISC_MODE2_BUG_58057_FIX_ENABLE_MASK 0x00000010
#define MAC_PCU_MISC_MODE2_BUG_58057_FIX_ENABLE_GET(x) (((x) & MAC_PCU_MISC_MODE2_BUG_58057_FIX_ENABLE_MASK) >> MAC_PCU_MISC_MODE2_BUG_58057_FIX_ENABLE_LSB)
#define MAC_PCU_MISC_MODE2_BUG_58057_FIX_ENABLE_SET(x) (((x) << MAC_PCU_MISC_MODE2_BUG_58057_FIX_ENABLE_LSB) & MAC_PCU_MISC_MODE2_BUG_58057_FIX_ENABLE_MASK)
#define MAC_PCU_MISC_MODE2_RESERVED_0_MSB        3
#define MAC_PCU_MISC_MODE2_RESERVED_0_LSB        3
#define MAC_PCU_MISC_MODE2_RESERVED_0_MASK       0x00000008
#define MAC_PCU_MISC_MODE2_RESERVED_0_GET(x)     (((x) & MAC_PCU_MISC_MODE2_RESERVED_0_MASK) >> MAC_PCU_MISC_MODE2_RESERVED_0_LSB)
#define MAC_PCU_MISC_MODE2_RESERVED_0_SET(x)     (((x) << MAC_PCU_MISC_MODE2_RESERVED_0_LSB) & MAC_PCU_MISC_MODE2_RESERVED_0_MASK)
#define MAC_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_MSB 2
#define MAC_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_LSB 2
#define MAC_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_MASK 0x00000004
#define MAC_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_GET(x) (((x) & MAC_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_MASK) >> MAC_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_LSB)
#define MAC_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_SET(x) (((x) << MAC_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_LSB) & MAC_PCU_MISC_MODE2_NO_CRYPTO_FOR_NON_DATA_PKT_MASK)
#define MAC_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE_MSB 1
#define MAC_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE_LSB 1
#define MAC_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE_MASK 0x00000002
#define MAC_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE_GET(x) (((x) & MAC_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE_MASK) >> MAC_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE_LSB)
#define MAC_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE_SET(x) (((x) << MAC_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE_LSB) & MAC_PCU_MISC_MODE2_MGMT_CRYPTO_ENABLE_MASK)
#define MAC_PCU_MISC_MODE2_BUG_21532_FIX_ENABLE_MSB 0
#define MAC_PCU_MISC_MODE2_BUG_21532_FIX_ENABLE_LSB 0
#define MAC_PCU_MISC_MODE2_BUG_21532_FIX_ENABLE_MASK 0x00000001
#define MAC_PCU_MISC_MODE2_BUG_21532_FIX_ENABLE_GET(x) (((x) & MAC_PCU_MISC_MODE2_BUG_21532_FIX_ENABLE_MASK) >> MAC_PCU_MISC_MODE2_BUG_21532_FIX_ENABLE_LSB)
#define MAC_PCU_MISC_MODE2_BUG_21532_FIX_ENABLE_SET(x) (((x) << MAC_PCU_MISC_MODE2_BUG_21532_FIX_ENABLE_LSB) & MAC_PCU_MISC_MODE2_BUG_21532_FIX_ENABLE_MASK)

#define MAC_PCU_ALT_AES_MUTE_MASK_ADDRESS        0x00008148
#define MAC_PCU_ALT_AES_MUTE_MASK_OFFSET         0x00000148
#define MAC_PCU_ALT_AES_MUTE_MASK_QOS_MSB        31
#define MAC_PCU_ALT_AES_MUTE_MASK_QOS_LSB        16
#define MAC_PCU_ALT_AES_MUTE_MASK_QOS_MASK       0xffff0000
#define MAC_PCU_ALT_AES_MUTE_MASK_QOS_GET(x)     (((x) & MAC_PCU_ALT_AES_MUTE_MASK_QOS_MASK) >> MAC_PCU_ALT_AES_MUTE_MASK_QOS_LSB)
#define MAC_PCU_ALT_AES_MUTE_MASK_QOS_SET(x)     (((x) << MAC_PCU_ALT_AES_MUTE_MASK_QOS_LSB) & MAC_PCU_ALT_AES_MUTE_MASK_QOS_MASK)

#define MAC_PCU_AZIMUTH_TIME_STAMP_ADDRESS       0x0000814c
#define MAC_PCU_AZIMUTH_TIME_STAMP_OFFSET        0x0000014c
#define MAC_PCU_AZIMUTH_TIME_STAMP_VALUE_MSB     31
#define MAC_PCU_AZIMUTH_TIME_STAMP_VALUE_LSB     0
#define MAC_PCU_AZIMUTH_TIME_STAMP_VALUE_MASK    0xffffffff
#define MAC_PCU_AZIMUTH_TIME_STAMP_VALUE_GET(x)  (((x) & MAC_PCU_AZIMUTH_TIME_STAMP_VALUE_MASK) >> MAC_PCU_AZIMUTH_TIME_STAMP_VALUE_LSB)
#define MAC_PCU_AZIMUTH_TIME_STAMP_VALUE_SET(x)  (((x) << MAC_PCU_AZIMUTH_TIME_STAMP_VALUE_LSB) & MAC_PCU_AZIMUTH_TIME_STAMP_VALUE_MASK)

#define MAC_PCU_MAX_CFP_DUR_ADDRESS              0x00008150
#define MAC_PCU_MAX_CFP_DUR_OFFSET               0x00000150
#define MAC_PCU_MAX_CFP_DUR_USEC_FRAC_DENOMINATOR_MSB 7
#define MAC_PCU_MAX_CFP_DUR_USEC_FRAC_DENOMINATOR_LSB 4
#define MAC_PCU_MAX_CFP_DUR_USEC_FRAC_DENOMINATOR_MASK 0x000000f0
#define MAC_PCU_MAX_CFP_DUR_USEC_FRAC_DENOMINATOR_GET(x) (((x) & MAC_PCU_MAX_CFP_DUR_USEC_FRAC_DENOMINATOR_MASK) >> MAC_PCU_MAX_CFP_DUR_USEC_FRAC_DENOMINATOR_LSB)
#define MAC_PCU_MAX_CFP_DUR_USEC_FRAC_DENOMINATOR_SET(x) (((x) << MAC_PCU_MAX_CFP_DUR_USEC_FRAC_DENOMINATOR_LSB) & MAC_PCU_MAX_CFP_DUR_USEC_FRAC_DENOMINATOR_MASK)
#define MAC_PCU_MAX_CFP_DUR_USEC_FRAC_NUMERATOR_MSB 3
#define MAC_PCU_MAX_CFP_DUR_USEC_FRAC_NUMERATOR_LSB 0
#define MAC_PCU_MAX_CFP_DUR_USEC_FRAC_NUMERATOR_MASK 0x0000000f
#define MAC_PCU_MAX_CFP_DUR_USEC_FRAC_NUMERATOR_GET(x) (((x) & MAC_PCU_MAX_CFP_DUR_USEC_FRAC_NUMERATOR_MASK) >> MAC_PCU_MAX_CFP_DUR_USEC_FRAC_NUMERATOR_LSB)
#define MAC_PCU_MAX_CFP_DUR_USEC_FRAC_NUMERATOR_SET(x) (((x) << MAC_PCU_MAX_CFP_DUR_USEC_FRAC_NUMERATOR_LSB) & MAC_PCU_MAX_CFP_DUR_USEC_FRAC_NUMERATOR_MASK)

#define MAC_PCU_HCF_TIMEOUT_ADDRESS              0x00008154
#define MAC_PCU_HCF_TIMEOUT_OFFSET               0x00000154
#define MAC_PCU_HCF_TIMEOUT_VALUE_MSB            15
#define MAC_PCU_HCF_TIMEOUT_VALUE_LSB            0
#define MAC_PCU_HCF_TIMEOUT_VALUE_MASK           0x0000ffff
#define MAC_PCU_HCF_TIMEOUT_VALUE_GET(x)         (((x) & MAC_PCU_HCF_TIMEOUT_VALUE_MASK) >> MAC_PCU_HCF_TIMEOUT_VALUE_LSB)
#define MAC_PCU_HCF_TIMEOUT_VALUE_SET(x)         (((x) << MAC_PCU_HCF_TIMEOUT_VALUE_LSB) & MAC_PCU_HCF_TIMEOUT_VALUE_MASK)

#define MAC_PCU_BLUETOOTH_WEIGHTS2_ADDRESS       0x00008158
#define MAC_PCU_BLUETOOTH_WEIGHTS2_OFFSET        0x00000158
#define MAC_PCU_BLUETOOTH_WEIGHTS2_WL_WEIGHT_CONTD_MSB 31
#define MAC_PCU_BLUETOOTH_WEIGHTS2_WL_WEIGHT_CONTD_LSB 16
#define MAC_PCU_BLUETOOTH_WEIGHTS2_WL_WEIGHT_CONTD_MASK 0xffff0000
#define MAC_PCU_BLUETOOTH_WEIGHTS2_WL_WEIGHT_CONTD_GET(x) (((x) & MAC_PCU_BLUETOOTH_WEIGHTS2_WL_WEIGHT_CONTD_MASK) >> MAC_PCU_BLUETOOTH_WEIGHTS2_WL_WEIGHT_CONTD_LSB)
#define MAC_PCU_BLUETOOTH_WEIGHTS2_WL_WEIGHT_CONTD_SET(x) (((x) << MAC_PCU_BLUETOOTH_WEIGHTS2_WL_WEIGHT_CONTD_LSB) & MAC_PCU_BLUETOOTH_WEIGHTS2_WL_WEIGHT_CONTD_MASK)

#define MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_ADDRESS  0x0000815c
#define MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_OFFSET   0x0000015c
#define MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_VALUE_MSB 31
#define MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_VALUE_LSB 0
#define MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_VALUE_MASK 0xffffffff
#define MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_VALUE_GET(x) (((x) & MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_VALUE_MASK) >> MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_VALUE_LSB)
#define MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_VALUE_SET(x) (((x) << MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_VALUE_LSB) & MAC_PCU_BLUETOOTH_TSF_BT_ACTIVE_VALUE_MASK)

#define MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_ADDRESS 0x00008160
#define MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_OFFSET 0x00000160
#define MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_VALUE_MSB 31
#define MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_VALUE_LSB 0
#define MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_VALUE_MASK 0xffffffff
#define MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_VALUE_GET(x) (((x) & MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_VALUE_MASK) >> MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_VALUE_LSB)
#define MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_VALUE_SET(x) (((x) << MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_VALUE_LSB) & MAC_PCU_BLUETOOTH_TSF_BT_PRIORITY_VALUE_MASK)

#define MAC_PCU_BLUETOOTH_MODE3_ADDRESS          0x00008164
#define MAC_PCU_BLUETOOTH_MODE3_OFFSET           0x00000164
#define MAC_PCU_BLUETOOTH_MODE3_BT_PRIORITY_EXTEND_THRES_MSB 31
#define MAC_PCU_BLUETOOTH_MODE3_BT_PRIORITY_EXTEND_THRES_LSB 28
#define MAC_PCU_BLUETOOTH_MODE3_BT_PRIORITY_EXTEND_THRES_MASK 0xf0000000
#define MAC_PCU_BLUETOOTH_MODE3_BT_PRIORITY_EXTEND_THRES_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_BT_PRIORITY_EXTEND_THRES_MASK) >> MAC_PCU_BLUETOOTH_MODE3_BT_PRIORITY_EXTEND_THRES_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_BT_PRIORITY_EXTEND_THRES_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_BT_PRIORITY_EXTEND_THRES_LSB) & MAC_PCU_BLUETOOTH_MODE3_BT_PRIORITY_EXTEND_THRES_MASK)
#define MAC_PCU_BLUETOOTH_MODE3_BT_TX_ON_EN_MSB  27
#define MAC_PCU_BLUETOOTH_MODE3_BT_TX_ON_EN_LSB  27
#define MAC_PCU_BLUETOOTH_MODE3_BT_TX_ON_EN_MASK 0x08000000
#define MAC_PCU_BLUETOOTH_MODE3_BT_TX_ON_EN_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_BT_TX_ON_EN_MASK) >> MAC_PCU_BLUETOOTH_MODE3_BT_TX_ON_EN_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_BT_TX_ON_EN_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_BT_TX_ON_EN_LSB) & MAC_PCU_BLUETOOTH_MODE3_BT_TX_ON_EN_MASK)
#define MAC_PCU_BLUETOOTH_MODE3_SLOT_SLOP_MSB    26
#define MAC_PCU_BLUETOOTH_MODE3_SLOT_SLOP_LSB    25
#define MAC_PCU_BLUETOOTH_MODE3_SLOT_SLOP_MASK   0x06000000
#define MAC_PCU_BLUETOOTH_MODE3_SLOT_SLOP_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_SLOT_SLOP_MASK) >> MAC_PCU_BLUETOOTH_MODE3_SLOT_SLOP_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_SLOT_SLOP_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_SLOT_SLOP_LSB) & MAC_PCU_BLUETOOTH_MODE3_SLOT_SLOP_MASK)
#define MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_TOGGLE_WLA_EN_MSB 24
#define MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_TOGGLE_WLA_EN_LSB 24
#define MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_TOGGLE_WLA_EN_MASK 0x01000000
#define MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_TOGGLE_WLA_EN_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_TOGGLE_WLA_EN_MASK) >> MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_TOGGLE_WLA_EN_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_TOGGLE_WLA_EN_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_TOGGLE_WLA_EN_LSB) & MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_TOGGLE_WLA_EN_MASK)
#define MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_PRI_EN_MSB 23
#define MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_PRI_EN_LSB 23
#define MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_PRI_EN_MASK 0x00800000
#define MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_PRI_EN_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_PRI_EN_MASK) >> MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_PRI_EN_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_PRI_EN_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_PRI_EN_LSB) & MAC_PCU_BLUETOOTH_MODE3_DYNAMIC_PRI_EN_MASK)
#define MAC_PCU_BLUETOOTH_MODE3_RFGAIN_LOCK_SRC_MSB 22
#define MAC_PCU_BLUETOOTH_MODE3_RFGAIN_LOCK_SRC_LSB 22
#define MAC_PCU_BLUETOOTH_MODE3_RFGAIN_LOCK_SRC_MASK 0x00400000
#define MAC_PCU_BLUETOOTH_MODE3_RFGAIN_LOCK_SRC_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_RFGAIN_LOCK_SRC_MASK) >> MAC_PCU_BLUETOOTH_MODE3_RFGAIN_LOCK_SRC_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_RFGAIN_LOCK_SRC_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_RFGAIN_LOCK_SRC_LSB) & MAC_PCU_BLUETOOTH_MODE3_RFGAIN_LOCK_SRC_MASK)
#define MAC_PCU_BLUETOOTH_MODE3_WL_PRIORITY_OFFSET_EN_MSB 21
#define MAC_PCU_BLUETOOTH_MODE3_WL_PRIORITY_OFFSET_EN_LSB 21
#define MAC_PCU_BLUETOOTH_MODE3_WL_PRIORITY_OFFSET_EN_MASK 0x00200000
#define MAC_PCU_BLUETOOTH_MODE3_WL_PRIORITY_OFFSET_EN_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_WL_PRIORITY_OFFSET_EN_MASK) >> MAC_PCU_BLUETOOTH_MODE3_WL_PRIORITY_OFFSET_EN_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_WL_PRIORITY_OFFSET_EN_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_WL_PRIORITY_OFFSET_EN_LSB) & MAC_PCU_BLUETOOTH_MODE3_WL_PRIORITY_OFFSET_EN_MASK)
#define MAC_PCU_BLUETOOTH_MODE3_SHARED_RX_MSB    20
#define MAC_PCU_BLUETOOTH_MODE3_SHARED_RX_LSB    20
#define MAC_PCU_BLUETOOTH_MODE3_SHARED_RX_MASK   0x00100000
#define MAC_PCU_BLUETOOTH_MODE3_SHARED_RX_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_SHARED_RX_MASK) >> MAC_PCU_BLUETOOTH_MODE3_SHARED_RX_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_SHARED_RX_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_SHARED_RX_LSB) & MAC_PCU_BLUETOOTH_MODE3_SHARED_RX_MASK)
#define MAC_PCU_BLUETOOTH_MODE3_ALLOW_CONCURRENT_ACCESS_MSB 19
#define MAC_PCU_BLUETOOTH_MODE3_ALLOW_CONCURRENT_ACCESS_LSB 16
#define MAC_PCU_BLUETOOTH_MODE3_ALLOW_CONCURRENT_ACCESS_MASK 0x000f0000
#define MAC_PCU_BLUETOOTH_MODE3_ALLOW_CONCURRENT_ACCESS_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_ALLOW_CONCURRENT_ACCESS_MASK) >> MAC_PCU_BLUETOOTH_MODE3_ALLOW_CONCURRENT_ACCESS_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_ALLOW_CONCURRENT_ACCESS_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_ALLOW_CONCURRENT_ACCESS_LSB) & MAC_PCU_BLUETOOTH_MODE3_ALLOW_CONCURRENT_ACCESS_MASK)
#define MAC_PCU_BLUETOOTH_MODE3_WL_QC_TIME_MSB   15
#define MAC_PCU_BLUETOOTH_MODE3_WL_QC_TIME_LSB   8
#define MAC_PCU_BLUETOOTH_MODE3_WL_QC_TIME_MASK  0x0000ff00
#define MAC_PCU_BLUETOOTH_MODE3_WL_QC_TIME_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_WL_QC_TIME_MASK) >> MAC_PCU_BLUETOOTH_MODE3_WL_QC_TIME_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_WL_QC_TIME_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_WL_QC_TIME_LSB) & MAC_PCU_BLUETOOTH_MODE3_WL_QC_TIME_MASK)
#define MAC_PCU_BLUETOOTH_MODE3_WL_ACTIVE_TIME_MSB 7
#define MAC_PCU_BLUETOOTH_MODE3_WL_ACTIVE_TIME_LSB 0
#define MAC_PCU_BLUETOOTH_MODE3_WL_ACTIVE_TIME_MASK 0x000000ff
#define MAC_PCU_BLUETOOTH_MODE3_WL_ACTIVE_TIME_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE3_WL_ACTIVE_TIME_MASK) >> MAC_PCU_BLUETOOTH_MODE3_WL_ACTIVE_TIME_LSB)
#define MAC_PCU_BLUETOOTH_MODE3_WL_ACTIVE_TIME_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE3_WL_ACTIVE_TIME_LSB) & MAC_PCU_BLUETOOTH_MODE3_WL_ACTIVE_TIME_MASK)

#define MAC_PCU_BLUETOOTH_MODE4_ADDRESS          0x00008168
#define MAC_PCU_BLUETOOTH_MODE4_OFFSET           0x00000168
#define MAC_PCU_BLUETOOTH_MODE4_BT_PRIORITY_EXTEND_MSB 31
#define MAC_PCU_BLUETOOTH_MODE4_BT_PRIORITY_EXTEND_LSB 16
#define MAC_PCU_BLUETOOTH_MODE4_BT_PRIORITY_EXTEND_MASK 0xffff0000
#define MAC_PCU_BLUETOOTH_MODE4_BT_PRIORITY_EXTEND_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE4_BT_PRIORITY_EXTEND_MASK) >> MAC_PCU_BLUETOOTH_MODE4_BT_PRIORITY_EXTEND_LSB)
#define MAC_PCU_BLUETOOTH_MODE4_BT_PRIORITY_EXTEND_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE4_BT_PRIORITY_EXTEND_LSB) & MAC_PCU_BLUETOOTH_MODE4_BT_PRIORITY_EXTEND_MASK)
#define MAC_PCU_BLUETOOTH_MODE4_BT_ACTIVE_EXTEND_MSB 15
#define MAC_PCU_BLUETOOTH_MODE4_BT_ACTIVE_EXTEND_LSB 0
#define MAC_PCU_BLUETOOTH_MODE4_BT_ACTIVE_EXTEND_MASK 0x0000ffff
#define MAC_PCU_BLUETOOTH_MODE4_BT_ACTIVE_EXTEND_GET(x) (((x) & MAC_PCU_BLUETOOTH_MODE4_BT_ACTIVE_EXTEND_MASK) >> MAC_PCU_BLUETOOTH_MODE4_BT_ACTIVE_EXTEND_LSB)
#define MAC_PCU_BLUETOOTH_MODE4_BT_ACTIVE_EXTEND_SET(x) (((x) << MAC_PCU_BLUETOOTH_MODE4_BT_ACTIVE_EXTEND_LSB) & MAC_PCU_BLUETOOTH_MODE4_BT_ACTIVE_EXTEND_MASK)

#define MAC_PCU_BT_BT_ADDRESS                    0x00008200
#define MAC_PCU_BT_BT_OFFSET                     0x00000200
#define MAC_PCU_BT_BT_WEIGHT_MSB                 31
#define MAC_PCU_BT_BT_WEIGHT_LSB                 0
#define MAC_PCU_BT_BT_WEIGHT_MASK                0xffffffff
#define MAC_PCU_BT_BT_WEIGHT_GET(x)              (((x) & MAC_PCU_BT_BT_WEIGHT_MASK) >> MAC_PCU_BT_BT_WEIGHT_LSB)
#define MAC_PCU_BT_BT_WEIGHT_SET(x)              (((x) << MAC_PCU_BT_BT_WEIGHT_LSB) & MAC_PCU_BT_BT_WEIGHT_MASK)

#define MAC_PCU_BT_BT_ASYNC_ADDRESS              0x00008300
#define MAC_PCU_BT_BT_ASYNC_OFFSET               0x00000300
#define MAC_PCU_BT_BT_ASYNC_RXLP_WEIGHT_MSB      15
#define MAC_PCU_BT_BT_ASYNC_RXLP_WEIGHT_LSB      12
#define MAC_PCU_BT_BT_ASYNC_RXLP_WEIGHT_MASK     0x0000f000
#define MAC_PCU_BT_BT_ASYNC_RXLP_WEIGHT_GET(x)   (((x) & MAC_PCU_BT_BT_ASYNC_RXLP_WEIGHT_MASK) >> MAC_PCU_BT_BT_ASYNC_RXLP_WEIGHT_LSB)
#define MAC_PCU_BT_BT_ASYNC_RXLP_WEIGHT_SET(x)   (((x) << MAC_PCU_BT_BT_ASYNC_RXLP_WEIGHT_LSB) & MAC_PCU_BT_BT_ASYNC_RXLP_WEIGHT_MASK)
#define MAC_PCU_BT_BT_ASYNC_RXHP_WEIGHT_MSB      11
#define MAC_PCU_BT_BT_ASYNC_RXHP_WEIGHT_LSB      8
#define MAC_PCU_BT_BT_ASYNC_RXHP_WEIGHT_MASK     0x00000f00
#define MAC_PCU_BT_BT_ASYNC_RXHP_WEIGHT_GET(x)   (((x) & MAC_PCU_BT_BT_ASYNC_RXHP_WEIGHT_MASK) >> MAC_PCU_BT_BT_ASYNC_RXHP_WEIGHT_LSB)
#define MAC_PCU_BT_BT_ASYNC_RXHP_WEIGHT_SET(x)   (((x) << MAC_PCU_BT_BT_ASYNC_RXHP_WEIGHT_LSB) & MAC_PCU_BT_BT_ASYNC_RXHP_WEIGHT_MASK)
#define MAC_PCU_BT_BT_ASYNC_TXLP_WEIGHT_MSB      7
#define MAC_PCU_BT_BT_ASYNC_TXLP_WEIGHT_LSB      4
#define MAC_PCU_BT_BT_ASYNC_TXLP_WEIGHT_MASK     0x000000f0
#define MAC_PCU_BT_BT_ASYNC_TXLP_WEIGHT_GET(x)   (((x) & MAC_PCU_BT_BT_ASYNC_TXLP_WEIGHT_MASK) >> MAC_PCU_BT_BT_ASYNC_TXLP_WEIGHT_LSB)
#define MAC_PCU_BT_BT_ASYNC_TXLP_WEIGHT_SET(x)   (((x) << MAC_PCU_BT_BT_ASYNC_TXLP_WEIGHT_LSB) & MAC_PCU_BT_BT_ASYNC_TXLP_WEIGHT_MASK)
#define MAC_PCU_BT_BT_ASYNC_TXHP_WEIGHT_MSB      3
#define MAC_PCU_BT_BT_ASYNC_TXHP_WEIGHT_LSB      0
#define MAC_PCU_BT_BT_ASYNC_TXHP_WEIGHT_MASK     0x0000000f
#define MAC_PCU_BT_BT_ASYNC_TXHP_WEIGHT_GET(x)   (((x) & MAC_PCU_BT_BT_ASYNC_TXHP_WEIGHT_MASK) >> MAC_PCU_BT_BT_ASYNC_TXHP_WEIGHT_LSB)
#define MAC_PCU_BT_BT_ASYNC_TXHP_WEIGHT_SET(x)   (((x) << MAC_PCU_BT_BT_ASYNC_TXHP_WEIGHT_LSB) & MAC_PCU_BT_BT_ASYNC_TXHP_WEIGHT_MASK)

#define MAC_PCU_BT_WL_1_ADDRESS                  0x00008304
#define MAC_PCU_BT_WL_1_OFFSET                   0x00000304
#define MAC_PCU_BT_WL_1_WEIGHT_MSB               31
#define MAC_PCU_BT_WL_1_WEIGHT_LSB               0
#define MAC_PCU_BT_WL_1_WEIGHT_MASK              0xffffffff
#define MAC_PCU_BT_WL_1_WEIGHT_GET(x)            (((x) & MAC_PCU_BT_WL_1_WEIGHT_MASK) >> MAC_PCU_BT_WL_1_WEIGHT_LSB)
#define MAC_PCU_BT_WL_1_WEIGHT_SET(x)            (((x) << MAC_PCU_BT_WL_1_WEIGHT_LSB) & MAC_PCU_BT_WL_1_WEIGHT_MASK)

#define MAC_PCU_BT_WL_2_ADDRESS                  0x00008308
#define MAC_PCU_BT_WL_2_OFFSET                   0x00000308
#define MAC_PCU_BT_WL_2_WEIGHT_MSB               31
#define MAC_PCU_BT_WL_2_WEIGHT_LSB               0
#define MAC_PCU_BT_WL_2_WEIGHT_MASK              0xffffffff
#define MAC_PCU_BT_WL_2_WEIGHT_GET(x)            (((x) & MAC_PCU_BT_WL_2_WEIGHT_MASK) >> MAC_PCU_BT_WL_2_WEIGHT_LSB)
#define MAC_PCU_BT_WL_2_WEIGHT_SET(x)            (((x) << MAC_PCU_BT_WL_2_WEIGHT_LSB) & MAC_PCU_BT_WL_2_WEIGHT_MASK)

#define MAC_PCU_BT_WL_3_ADDRESS                  0x0000830c
#define MAC_PCU_BT_WL_3_OFFSET                   0x0000030c
#define MAC_PCU_BT_WL_3_WEIGHT_MSB               31
#define MAC_PCU_BT_WL_3_WEIGHT_LSB               0
#define MAC_PCU_BT_WL_3_WEIGHT_MASK              0xffffffff
#define MAC_PCU_BT_WL_3_WEIGHT_GET(x)            (((x) & MAC_PCU_BT_WL_3_WEIGHT_MASK) >> MAC_PCU_BT_WL_3_WEIGHT_LSB)
#define MAC_PCU_BT_WL_3_WEIGHT_SET(x)            (((x) << MAC_PCU_BT_WL_3_WEIGHT_LSB) & MAC_PCU_BT_WL_3_WEIGHT_MASK)

#define MAC_PCU_BT_WL_4_ADDRESS                  0x00008310
#define MAC_PCU_BT_WL_4_OFFSET                   0x00000310
#define MAC_PCU_BT_WL_4_WEIGHT_MSB               31
#define MAC_PCU_BT_WL_4_WEIGHT_LSB               0
#define MAC_PCU_BT_WL_4_WEIGHT_MASK              0xffffffff
#define MAC_PCU_BT_WL_4_WEIGHT_GET(x)            (((x) & MAC_PCU_BT_WL_4_WEIGHT_MASK) >> MAC_PCU_BT_WL_4_WEIGHT_LSB)
#define MAC_PCU_BT_WL_4_WEIGHT_SET(x)            (((x) << MAC_PCU_BT_WL_4_WEIGHT_LSB) & MAC_PCU_BT_WL_4_WEIGHT_MASK)

#define MAC_PCU_COEX_EPTA_ADDRESS                0x00008314
#define MAC_PCU_COEX_EPTA_OFFSET                 0x00000314
#define MAC_PCU_COEX_EPTA_WT_IDX_MSB             12
#define MAC_PCU_COEX_EPTA_WT_IDX_LSB             6
#define MAC_PCU_COEX_EPTA_WT_IDX_MASK            0x00001fc0
#define MAC_PCU_COEX_EPTA_WT_IDX_GET(x)          (((x) & MAC_PCU_COEX_EPTA_WT_IDX_MASK) >> MAC_PCU_COEX_EPTA_WT_IDX_LSB)
#define MAC_PCU_COEX_EPTA_WT_IDX_SET(x)          (((x) << MAC_PCU_COEX_EPTA_WT_IDX_LSB) & MAC_PCU_COEX_EPTA_WT_IDX_MASK)
#define MAC_PCU_COEX_EPTA_LINKID_MSB             5
#define MAC_PCU_COEX_EPTA_LINKID_LSB             0
#define MAC_PCU_COEX_EPTA_LINKID_MASK            0x0000003f
#define MAC_PCU_COEX_EPTA_LINKID_GET(x)          (((x) & MAC_PCU_COEX_EPTA_LINKID_MASK) >> MAC_PCU_COEX_EPTA_LINKID_LSB)
#define MAC_PCU_COEX_EPTA_LINKID_SET(x)          (((x) << MAC_PCU_COEX_EPTA_LINKID_LSB) & MAC_PCU_COEX_EPTA_LINKID_MASK)

#define MAC_PCU_COEX_LNAMAXGAIN1_ADDRESS         0x00008318
#define MAC_PCU_COEX_LNAMAXGAIN1_OFFSET          0x00000318
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN4_MSB    31
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN4_LSB    24
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN4_MASK   0xff000000
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN4_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN4_MASK) >> MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN4_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN4_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN4_LSB) & MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN4_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN3_MSB    23
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN3_LSB    16
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN3_MASK   0x00ff0000
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN3_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN3_MASK) >> MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN3_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN3_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN3_LSB) & MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN3_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN2_MSB    15
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN2_LSB    8
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN2_MASK   0x0000ff00
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN2_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN2_MASK) >> MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN2_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN2_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN2_LSB) & MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN2_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN1_MSB    7
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN1_LSB    0
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN1_MASK   0x000000ff
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN1_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN1_MASK) >> MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN1_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN1_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN1_LSB) & MAC_PCU_COEX_LNAMAXGAIN1_MAXGAIN1_MASK)

#define MAC_PCU_COEX_LNAMAXGAIN2_ADDRESS         0x0000831c
#define MAC_PCU_COEX_LNAMAXGAIN2_OFFSET          0x0000031c
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN4_MSB    31
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN4_LSB    24
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN4_MASK   0xff000000
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN4_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN4_MASK) >> MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN4_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN4_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN4_LSB) & MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN4_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN3_MSB    23
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN3_LSB    16
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN3_MASK   0x00ff0000
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN3_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN3_MASK) >> MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN3_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN3_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN3_LSB) & MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN3_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN2_MSB    15
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN2_LSB    8
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN2_MASK   0x0000ff00
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN2_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN2_MASK) >> MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN2_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN2_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN2_LSB) & MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN2_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN1_MSB    7
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN1_LSB    0
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN1_MASK   0x000000ff
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN1_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN1_MASK) >> MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN1_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN1_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN1_LSB) & MAC_PCU_COEX_LNAMAXGAIN2_MAXGAIN1_MASK)

#define MAC_PCU_COEX_LNAMAXGAIN3_ADDRESS         0x00008320
#define MAC_PCU_COEX_LNAMAXGAIN3_OFFSET          0x00000320
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN4_MSB    31
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN4_LSB    24
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN4_MASK   0xff000000
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN4_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN4_MASK) >> MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN4_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN4_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN4_LSB) & MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN4_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN3_MSB    23
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN3_LSB    16
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN3_MASK   0x00ff0000
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN3_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN3_MASK) >> MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN3_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN3_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN3_LSB) & MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN3_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN2_MSB    15
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN2_LSB    8
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN2_MASK   0x0000ff00
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN2_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN2_MASK) >> MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN2_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN2_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN2_LSB) & MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN2_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN1_MSB    7
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN1_LSB    0
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN1_MASK   0x000000ff
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN1_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN1_MASK) >> MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN1_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN1_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN1_LSB) & MAC_PCU_COEX_LNAMAXGAIN3_MAXGAIN1_MASK)

#define MAC_PCU_COEX_LNAMAXGAIN4_ADDRESS         0x00008324
#define MAC_PCU_COEX_LNAMAXGAIN4_OFFSET          0x00000324
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN4_MSB    31
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN4_LSB    24
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN4_MASK   0xff000000
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN4_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN4_MASK) >> MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN4_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN4_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN4_LSB) & MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN4_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN3_MSB    23
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN3_LSB    16
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN3_MASK   0x00ff0000
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN3_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN3_MASK) >> MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN3_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN3_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN3_LSB) & MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN3_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN2_MSB    15
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN2_LSB    8
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN2_MASK   0x0000ff00
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN2_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN2_MASK) >> MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN2_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN2_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN2_LSB) & MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN2_MASK)
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN1_MSB    7
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN1_LSB    0
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN1_MASK   0x000000ff
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN1_GET(x) (((x) & MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN1_MASK) >> MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN1_LSB)
#define MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN1_SET(x) (((x) << MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN1_LSB) & MAC_PCU_COEX_LNAMAXGAIN4_MAXGAIN1_MASK)

#define MAC_PCU_BASIC_RATE_SET0_ADDRESS          0x00008328
#define MAC_PCU_BASIC_RATE_SET0_OFFSET           0x00000328
#define MAC_PCU_BASIC_RATE_SET0_VALUE_MSB        29
#define MAC_PCU_BASIC_RATE_SET0_VALUE_LSB        0
#define MAC_PCU_BASIC_RATE_SET0_VALUE_MASK       0x3fffffff
#define MAC_PCU_BASIC_RATE_SET0_VALUE_GET(x)     (((x) & MAC_PCU_BASIC_RATE_SET0_VALUE_MASK) >> MAC_PCU_BASIC_RATE_SET0_VALUE_LSB)
#define MAC_PCU_BASIC_RATE_SET0_VALUE_SET(x)     (((x) << MAC_PCU_BASIC_RATE_SET0_VALUE_LSB) & MAC_PCU_BASIC_RATE_SET0_VALUE_MASK)

#define MAC_PCU_BASIC_RATE_SET1_ADDRESS          0x0000832c
#define MAC_PCU_BASIC_RATE_SET1_OFFSET           0x0000032c
#define MAC_PCU_BASIC_RATE_SET1_VALUE_MSB        29
#define MAC_PCU_BASIC_RATE_SET1_VALUE_LSB        0
#define MAC_PCU_BASIC_RATE_SET1_VALUE_MASK       0x3fffffff
#define MAC_PCU_BASIC_RATE_SET1_VALUE_GET(x)     (((x) & MAC_PCU_BASIC_RATE_SET1_VALUE_MASK) >> MAC_PCU_BASIC_RATE_SET1_VALUE_LSB)
#define MAC_PCU_BASIC_RATE_SET1_VALUE_SET(x)     (((x) << MAC_PCU_BASIC_RATE_SET1_VALUE_LSB) & MAC_PCU_BASIC_RATE_SET1_VALUE_MASK)

#define MAC_PCU_BASIC_RATE_SET2_ADDRESS          0x00008330
#define MAC_PCU_BASIC_RATE_SET2_OFFSET           0x00000330
#define MAC_PCU_BASIC_RATE_SET2_VALUE_MSB        29
#define MAC_PCU_BASIC_RATE_SET2_VALUE_LSB        0
#define MAC_PCU_BASIC_RATE_SET2_VALUE_MASK       0x3fffffff
#define MAC_PCU_BASIC_RATE_SET2_VALUE_GET(x)     (((x) & MAC_PCU_BASIC_RATE_SET2_VALUE_MASK) >> MAC_PCU_BASIC_RATE_SET2_VALUE_LSB)
#define MAC_PCU_BASIC_RATE_SET2_VALUE_SET(x)     (((x) << MAC_PCU_BASIC_RATE_SET2_VALUE_LSB) & MAC_PCU_BASIC_RATE_SET2_VALUE_MASK)

#define MAC_PCU_BASIC_RATE_SET3_ADDRESS          0x00008334
#define MAC_PCU_BASIC_RATE_SET3_OFFSET           0x00000334
#define MAC_PCU_BASIC_RATE_SET3_VALUE_MSB        24
#define MAC_PCU_BASIC_RATE_SET3_VALUE_LSB        0
#define MAC_PCU_BASIC_RATE_SET3_VALUE_MASK       0x01ffffff
#define MAC_PCU_BASIC_RATE_SET3_VALUE_GET(x)     (((x) & MAC_PCU_BASIC_RATE_SET3_VALUE_MASK) >> MAC_PCU_BASIC_RATE_SET3_VALUE_LSB)
#define MAC_PCU_BASIC_RATE_SET3_VALUE_SET(x)     (((x) << MAC_PCU_BASIC_RATE_SET3_VALUE_LSB) & MAC_PCU_BASIC_RATE_SET3_VALUE_MASK)

#define MAC_PCU_RX_INT_STATUS0_ADDRESS           0x00008338
#define MAC_PCU_RX_INT_STATUS0_OFFSET            0x00000338
#define MAC_PCU_RX_INT_STATUS0_DURATION_H_MSB    31
#define MAC_PCU_RX_INT_STATUS0_DURATION_H_LSB    24
#define MAC_PCU_RX_INT_STATUS0_DURATION_H_MASK   0xff000000
#define MAC_PCU_RX_INT_STATUS0_DURATION_H_GET(x) (((x) & MAC_PCU_RX_INT_STATUS0_DURATION_H_MASK) >> MAC_PCU_RX_INT_STATUS0_DURATION_H_LSB)
#define MAC_PCU_RX_INT_STATUS0_DURATION_H_SET(x) (((x) << MAC_PCU_RX_INT_STATUS0_DURATION_H_LSB) & MAC_PCU_RX_INT_STATUS0_DURATION_H_MASK)
#define MAC_PCU_RX_INT_STATUS0_DURATION_L_MSB    23
#define MAC_PCU_RX_INT_STATUS0_DURATION_L_LSB    16
#define MAC_PCU_RX_INT_STATUS0_DURATION_L_MASK   0x00ff0000
#define MAC_PCU_RX_INT_STATUS0_DURATION_L_GET(x) (((x) & MAC_PCU_RX_INT_STATUS0_DURATION_L_MASK) >> MAC_PCU_RX_INT_STATUS0_DURATION_L_LSB)
#define MAC_PCU_RX_INT_STATUS0_DURATION_L_SET(x) (((x) << MAC_PCU_RX_INT_STATUS0_DURATION_L_LSB) & MAC_PCU_RX_INT_STATUS0_DURATION_L_MASK)
#define MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_H_MSB 15
#define MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_H_LSB 8
#define MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_H_MASK 0x0000ff00
#define MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_H_GET(x) (((x) & MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_H_MASK) >> MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_H_LSB)
#define MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_H_SET(x) (((x) << MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_H_LSB) & MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_H_MASK)
#define MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_L_MSB 7
#define MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_L_LSB 0
#define MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_L_MASK 0x000000ff
#define MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_L_GET(x) (((x) & MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_L_MASK) >> MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_L_LSB)
#define MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_L_SET(x) (((x) << MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_L_LSB) & MAC_PCU_RX_INT_STATUS0_FRAME_CONTROL_L_MASK)

#define MAC_PCU_RX_INT_STATUS1_ADDRESS           0x0000833c
#define MAC_PCU_RX_INT_STATUS1_OFFSET            0x0000033c
#define MAC_PCU_RX_INT_STATUS1_VALUE_MSB         17
#define MAC_PCU_RX_INT_STATUS1_VALUE_LSB         0
#define MAC_PCU_RX_INT_STATUS1_VALUE_MASK        0x0003ffff
#define MAC_PCU_RX_INT_STATUS1_VALUE_GET(x)      (((x) & MAC_PCU_RX_INT_STATUS1_VALUE_MASK) >> MAC_PCU_RX_INT_STATUS1_VALUE_LSB)
#define MAC_PCU_RX_INT_STATUS1_VALUE_SET(x)      (((x) << MAC_PCU_RX_INT_STATUS1_VALUE_LSB) & MAC_PCU_RX_INT_STATUS1_VALUE_MASK)

#define MAC_PCU_RX_INT_STATUS2_ADDRESS           0x00008340
#define MAC_PCU_RX_INT_STATUS2_OFFSET            0x00000340
#define MAC_PCU_RX_INT_STATUS2_VALUE_MSB         26
#define MAC_PCU_RX_INT_STATUS2_VALUE_LSB         0
#define MAC_PCU_RX_INT_STATUS2_VALUE_MASK        0x07ffffff
#define MAC_PCU_RX_INT_STATUS2_VALUE_GET(x)      (((x) & MAC_PCU_RX_INT_STATUS2_VALUE_MASK) >> MAC_PCU_RX_INT_STATUS2_VALUE_LSB)
#define MAC_PCU_RX_INT_STATUS2_VALUE_SET(x)      (((x) << MAC_PCU_RX_INT_STATUS2_VALUE_LSB) & MAC_PCU_RX_INT_STATUS2_VALUE_MASK)

#define MAC_PCU_RX_INT_STATUS3_ADDRESS           0x00008344
#define MAC_PCU_RX_INT_STATUS3_OFFSET            0x00000344
#define MAC_PCU_RX_INT_STATUS3_VALUE_MSB         23
#define MAC_PCU_RX_INT_STATUS3_VALUE_LSB         0
#define MAC_PCU_RX_INT_STATUS3_VALUE_MASK        0x00ffffff
#define MAC_PCU_RX_INT_STATUS3_VALUE_GET(x)      (((x) & MAC_PCU_RX_INT_STATUS3_VALUE_MASK) >> MAC_PCU_RX_INT_STATUS3_VALUE_LSB)
#define MAC_PCU_RX_INT_STATUS3_VALUE_SET(x)      (((x) << MAC_PCU_RX_INT_STATUS3_VALUE_LSB) & MAC_PCU_RX_INT_STATUS3_VALUE_MASK)

#define HT_HALF_GI_RATE1_ADDRESS                 0x00008348
#define HT_HALF_GI_RATE1_OFFSET                  0x00000348
#define HT_HALF_GI_RATE1_MCS3_MSB                31
#define HT_HALF_GI_RATE1_MCS3_LSB                24
#define HT_HALF_GI_RATE1_MCS3_MASK               0xff000000
#define HT_HALF_GI_RATE1_MCS3_GET(x)             (((x) & HT_HALF_GI_RATE1_MCS3_MASK) >> HT_HALF_GI_RATE1_MCS3_LSB)
#define HT_HALF_GI_RATE1_MCS3_SET(x)             (((x) << HT_HALF_GI_RATE1_MCS3_LSB) & HT_HALF_GI_RATE1_MCS3_MASK)
#define HT_HALF_GI_RATE1_MCS2_MSB                23
#define HT_HALF_GI_RATE1_MCS2_LSB                16
#define HT_HALF_GI_RATE1_MCS2_MASK               0x00ff0000
#define HT_HALF_GI_RATE1_MCS2_GET(x)             (((x) & HT_HALF_GI_RATE1_MCS2_MASK) >> HT_HALF_GI_RATE1_MCS2_LSB)
#define HT_HALF_GI_RATE1_MCS2_SET(x)             (((x) << HT_HALF_GI_RATE1_MCS2_LSB) & HT_HALF_GI_RATE1_MCS2_MASK)
#define HT_HALF_GI_RATE1_MCS1_MSB                15
#define HT_HALF_GI_RATE1_MCS1_LSB                8
#define HT_HALF_GI_RATE1_MCS1_MASK               0x0000ff00
#define HT_HALF_GI_RATE1_MCS1_GET(x)             (((x) & HT_HALF_GI_RATE1_MCS1_MASK) >> HT_HALF_GI_RATE1_MCS1_LSB)
#define HT_HALF_GI_RATE1_MCS1_SET(x)             (((x) << HT_HALF_GI_RATE1_MCS1_LSB) & HT_HALF_GI_RATE1_MCS1_MASK)
#define HT_HALF_GI_RATE1_MCS0_MSB                7
#define HT_HALF_GI_RATE1_MCS0_LSB                0
#define HT_HALF_GI_RATE1_MCS0_MASK               0x000000ff
#define HT_HALF_GI_RATE1_MCS0_GET(x)             (((x) & HT_HALF_GI_RATE1_MCS0_MASK) >> HT_HALF_GI_RATE1_MCS0_LSB)
#define HT_HALF_GI_RATE1_MCS0_SET(x)             (((x) << HT_HALF_GI_RATE1_MCS0_LSB) & HT_HALF_GI_RATE1_MCS0_MASK)

#define HT_HALF_GI_RATE2_ADDRESS                 0x0000834c
#define HT_HALF_GI_RATE2_OFFSET                  0x0000034c
#define HT_HALF_GI_RATE2_MCS7_MSB                31
#define HT_HALF_GI_RATE2_MCS7_LSB                24
#define HT_HALF_GI_RATE2_MCS7_MASK               0xff000000
#define HT_HALF_GI_RATE2_MCS7_GET(x)             (((x) & HT_HALF_GI_RATE2_MCS7_MASK) >> HT_HALF_GI_RATE2_MCS7_LSB)
#define HT_HALF_GI_RATE2_MCS7_SET(x)             (((x) << HT_HALF_GI_RATE2_MCS7_LSB) & HT_HALF_GI_RATE2_MCS7_MASK)
#define HT_HALF_GI_RATE2_MCS6_MSB                23
#define HT_HALF_GI_RATE2_MCS6_LSB                16
#define HT_HALF_GI_RATE2_MCS6_MASK               0x00ff0000
#define HT_HALF_GI_RATE2_MCS6_GET(x)             (((x) & HT_HALF_GI_RATE2_MCS6_MASK) >> HT_HALF_GI_RATE2_MCS6_LSB)
#define HT_HALF_GI_RATE2_MCS6_SET(x)             (((x) << HT_HALF_GI_RATE2_MCS6_LSB) & HT_HALF_GI_RATE2_MCS6_MASK)
#define HT_HALF_GI_RATE2_MCS5_MSB                15
#define HT_HALF_GI_RATE2_MCS5_LSB                8
#define HT_HALF_GI_RATE2_MCS5_MASK               0x0000ff00
#define HT_HALF_GI_RATE2_MCS5_GET(x)             (((x) & HT_HALF_GI_RATE2_MCS5_MASK) >> HT_HALF_GI_RATE2_MCS5_LSB)
#define HT_HALF_GI_RATE2_MCS5_SET(x)             (((x) << HT_HALF_GI_RATE2_MCS5_LSB) & HT_HALF_GI_RATE2_MCS5_MASK)
#define HT_HALF_GI_RATE2_MCS4_MSB                7
#define HT_HALF_GI_RATE2_MCS4_LSB                0
#define HT_HALF_GI_RATE2_MCS4_MASK               0x000000ff
#define HT_HALF_GI_RATE2_MCS4_GET(x)             (((x) & HT_HALF_GI_RATE2_MCS4_MASK) >> HT_HALF_GI_RATE2_MCS4_LSB)
#define HT_HALF_GI_RATE2_MCS4_SET(x)             (((x) << HT_HALF_GI_RATE2_MCS4_LSB) & HT_HALF_GI_RATE2_MCS4_MASK)

#define HT_FULL_GI_RATE1_ADDRESS                 0x00008350
#define HT_FULL_GI_RATE1_OFFSET                  0x00000350
#define HT_FULL_GI_RATE1_MCS3_MSB                31
#define HT_FULL_GI_RATE1_MCS3_LSB                24
#define HT_FULL_GI_RATE1_MCS3_MASK               0xff000000
#define HT_FULL_GI_RATE1_MCS3_GET(x)             (((x) & HT_FULL_GI_RATE1_MCS3_MASK) >> HT_FULL_GI_RATE1_MCS3_LSB)
#define HT_FULL_GI_RATE1_MCS3_SET(x)             (((x) << HT_FULL_GI_RATE1_MCS3_LSB) & HT_FULL_GI_RATE1_MCS3_MASK)
#define HT_FULL_GI_RATE1_MCS2_MSB                23
#define HT_FULL_GI_RATE1_MCS2_LSB                16
#define HT_FULL_GI_RATE1_MCS2_MASK               0x00ff0000
#define HT_FULL_GI_RATE1_MCS2_GET(x)             (((x) & HT_FULL_GI_RATE1_MCS2_MASK) >> HT_FULL_GI_RATE1_MCS2_LSB)
#define HT_FULL_GI_RATE1_MCS2_SET(x)             (((x) << HT_FULL_GI_RATE1_MCS2_LSB) & HT_FULL_GI_RATE1_MCS2_MASK)
#define HT_FULL_GI_RATE1_MCS1_MSB                15
#define HT_FULL_GI_RATE1_MCS1_LSB                8
#define HT_FULL_GI_RATE1_MCS1_MASK               0x0000ff00
#define HT_FULL_GI_RATE1_MCS1_GET(x)             (((x) & HT_FULL_GI_RATE1_MCS1_MASK) >> HT_FULL_GI_RATE1_MCS1_LSB)
#define HT_FULL_GI_RATE1_MCS1_SET(x)             (((x) << HT_FULL_GI_RATE1_MCS1_LSB) & HT_FULL_GI_RATE1_MCS1_MASK)
#define HT_FULL_GI_RATE1_MCS0_MSB                7
#define HT_FULL_GI_RATE1_MCS0_LSB                0
#define HT_FULL_GI_RATE1_MCS0_MASK               0x000000ff
#define HT_FULL_GI_RATE1_MCS0_GET(x)             (((x) & HT_FULL_GI_RATE1_MCS0_MASK) >> HT_FULL_GI_RATE1_MCS0_LSB)
#define HT_FULL_GI_RATE1_MCS0_SET(x)             (((x) << HT_FULL_GI_RATE1_MCS0_LSB) & HT_FULL_GI_RATE1_MCS0_MASK)

#define HT_FULL_GI_RATE2_ADDRESS                 0x00008354
#define HT_FULL_GI_RATE2_OFFSET                  0x00000354
#define HT_FULL_GI_RATE2_MCS7_MSB                31
#define HT_FULL_GI_RATE2_MCS7_LSB                24
#define HT_FULL_GI_RATE2_MCS7_MASK               0xff000000
#define HT_FULL_GI_RATE2_MCS7_GET(x)             (((x) & HT_FULL_GI_RATE2_MCS7_MASK) >> HT_FULL_GI_RATE2_MCS7_LSB)
#define HT_FULL_GI_RATE2_MCS7_SET(x)             (((x) << HT_FULL_GI_RATE2_MCS7_LSB) & HT_FULL_GI_RATE2_MCS7_MASK)
#define HT_FULL_GI_RATE2_MCS6_MSB                23
#define HT_FULL_GI_RATE2_MCS6_LSB                16
#define HT_FULL_GI_RATE2_MCS6_MASK               0x00ff0000
#define HT_FULL_GI_RATE2_MCS6_GET(x)             (((x) & HT_FULL_GI_RATE2_MCS6_MASK) >> HT_FULL_GI_RATE2_MCS6_LSB)
#define HT_FULL_GI_RATE2_MCS6_SET(x)             (((x) << HT_FULL_GI_RATE2_MCS6_LSB) & HT_FULL_GI_RATE2_MCS6_MASK)
#define HT_FULL_GI_RATE2_MCS5_MSB                15
#define HT_FULL_GI_RATE2_MCS5_LSB                8
#define HT_FULL_GI_RATE2_MCS5_MASK               0x0000ff00
#define HT_FULL_GI_RATE2_MCS5_GET(x)             (((x) & HT_FULL_GI_RATE2_MCS5_MASK) >> HT_FULL_GI_RATE2_MCS5_LSB)
#define HT_FULL_GI_RATE2_MCS5_SET(x)             (((x) << HT_FULL_GI_RATE2_MCS5_LSB) & HT_FULL_GI_RATE2_MCS5_MASK)
#define HT_FULL_GI_RATE2_MCS4_MSB                7
#define HT_FULL_GI_RATE2_MCS4_LSB                0
#define HT_FULL_GI_RATE2_MCS4_MASK               0x000000ff
#define HT_FULL_GI_RATE2_MCS4_GET(x)             (((x) & HT_FULL_GI_RATE2_MCS4_MASK) >> HT_FULL_GI_RATE2_MCS4_LSB)
#define HT_FULL_GI_RATE2_MCS4_SET(x)             (((x) << HT_FULL_GI_RATE2_MCS4_LSB) & HT_FULL_GI_RATE2_MCS4_MASK)

#define LEGACY_RATE1_ADDRESS                     0x00008358
#define LEGACY_RATE1_OFFSET                      0x00000358
#define LEGACY_RATE1_RATE12_MSB                  29
#define LEGACY_RATE1_RATE12_LSB                  24
#define LEGACY_RATE1_RATE12_MASK                 0x3f000000
#define LEGACY_RATE1_RATE12_GET(x)               (((x) & LEGACY_RATE1_RATE12_MASK) >> LEGACY_RATE1_RATE12_LSB)
#define LEGACY_RATE1_RATE12_SET(x)               (((x) << LEGACY_RATE1_RATE12_LSB) & LEGACY_RATE1_RATE12_MASK)
#define LEGACY_RATE1_RATE11_MSB                  23
#define LEGACY_RATE1_RATE11_LSB                  18
#define LEGACY_RATE1_RATE11_MASK                 0x00fc0000
#define LEGACY_RATE1_RATE11_GET(x)               (((x) & LEGACY_RATE1_RATE11_MASK) >> LEGACY_RATE1_RATE11_LSB)
#define LEGACY_RATE1_RATE11_SET(x)               (((x) << LEGACY_RATE1_RATE11_LSB) & LEGACY_RATE1_RATE11_MASK)
#define LEGACY_RATE1_RATE10_MSB                  17
#define LEGACY_RATE1_RATE10_LSB                  12
#define LEGACY_RATE1_RATE10_MASK                 0x0003f000
#define LEGACY_RATE1_RATE10_GET(x)               (((x) & LEGACY_RATE1_RATE10_MASK) >> LEGACY_RATE1_RATE10_LSB)
#define LEGACY_RATE1_RATE10_SET(x)               (((x) << LEGACY_RATE1_RATE10_LSB) & LEGACY_RATE1_RATE10_MASK)
#define LEGACY_RATE1_RATE9_MSB                   11
#define LEGACY_RATE1_RATE9_LSB                   6
#define LEGACY_RATE1_RATE9_MASK                  0x00000fc0
#define LEGACY_RATE1_RATE9_GET(x)                (((x) & LEGACY_RATE1_RATE9_MASK) >> LEGACY_RATE1_RATE9_LSB)
#define LEGACY_RATE1_RATE9_SET(x)                (((x) << LEGACY_RATE1_RATE9_LSB) & LEGACY_RATE1_RATE9_MASK)
#define LEGACY_RATE1_RATE8_MSB                   5
#define LEGACY_RATE1_RATE8_LSB                   0
#define LEGACY_RATE1_RATE8_MASK                  0x0000003f
#define LEGACY_RATE1_RATE8_GET(x)                (((x) & LEGACY_RATE1_RATE8_MASK) >> LEGACY_RATE1_RATE8_LSB)
#define LEGACY_RATE1_RATE8_SET(x)                (((x) << LEGACY_RATE1_RATE8_LSB) & LEGACY_RATE1_RATE8_MASK)

#define LEGACY_RATE2_ADDRESS                     0x0000835c
#define LEGACY_RATE2_OFFSET                      0x0000035c
#define LEGACY_RATE2_RATE25_MSB                  29
#define LEGACY_RATE2_RATE25_LSB                  24
#define LEGACY_RATE2_RATE25_MASK                 0x3f000000
#define LEGACY_RATE2_RATE25_GET(x)               (((x) & LEGACY_RATE2_RATE25_MASK) >> LEGACY_RATE2_RATE25_LSB)
#define LEGACY_RATE2_RATE25_SET(x)               (((x) << LEGACY_RATE2_RATE25_LSB) & LEGACY_RATE2_RATE25_MASK)
#define LEGACY_RATE2_RATE24_MSB                  23
#define LEGACY_RATE2_RATE24_LSB                  18
#define LEGACY_RATE2_RATE24_MASK                 0x00fc0000
#define LEGACY_RATE2_RATE24_GET(x)               (((x) & LEGACY_RATE2_RATE24_MASK) >> LEGACY_RATE2_RATE24_LSB)
#define LEGACY_RATE2_RATE24_SET(x)               (((x) << LEGACY_RATE2_RATE24_LSB) & LEGACY_RATE2_RATE24_MASK)
#define LEGACY_RATE2_RATE15_MSB                  17
#define LEGACY_RATE2_RATE15_LSB                  12
#define LEGACY_RATE2_RATE15_MASK                 0x0003f000
#define LEGACY_RATE2_RATE15_GET(x)               (((x) & LEGACY_RATE2_RATE15_MASK) >> LEGACY_RATE2_RATE15_LSB)
#define LEGACY_RATE2_RATE15_SET(x)               (((x) << LEGACY_RATE2_RATE15_LSB) & LEGACY_RATE2_RATE15_MASK)
#define LEGACY_RATE2_RATE14_MSB                  11
#define LEGACY_RATE2_RATE14_LSB                  6
#define LEGACY_RATE2_RATE14_MASK                 0x00000fc0
#define LEGACY_RATE2_RATE14_GET(x)               (((x) & LEGACY_RATE2_RATE14_MASK) >> LEGACY_RATE2_RATE14_LSB)
#define LEGACY_RATE2_RATE14_SET(x)               (((x) << LEGACY_RATE2_RATE14_LSB) & LEGACY_RATE2_RATE14_MASK)
#define LEGACY_RATE2_RATE13_MSB                  5
#define LEGACY_RATE2_RATE13_LSB                  0
#define LEGACY_RATE2_RATE13_MASK                 0x0000003f
#define LEGACY_RATE2_RATE13_GET(x)               (((x) & LEGACY_RATE2_RATE13_MASK) >> LEGACY_RATE2_RATE13_LSB)
#define LEGACY_RATE2_RATE13_SET(x)               (((x) << LEGACY_RATE2_RATE13_LSB) & LEGACY_RATE2_RATE13_MASK)

#define LEGACY_RATE3_ADDRESS                     0x00008360
#define LEGACY_RATE3_OFFSET                      0x00000360
#define LEGACY_RATE3_RATE30_MSB                  29
#define LEGACY_RATE3_RATE30_LSB                  24
#define LEGACY_RATE3_RATE30_MASK                 0x3f000000
#define LEGACY_RATE3_RATE30_GET(x)               (((x) & LEGACY_RATE3_RATE30_MASK) >> LEGACY_RATE3_RATE30_LSB)
#define LEGACY_RATE3_RATE30_SET(x)               (((x) << LEGACY_RATE3_RATE30_LSB) & LEGACY_RATE3_RATE30_MASK)
#define LEGACY_RATE3_RATE29_MSB                  23
#define LEGACY_RATE3_RATE29_LSB                  18
#define LEGACY_RATE3_RATE29_MASK                 0x00fc0000
#define LEGACY_RATE3_RATE29_GET(x)               (((x) & LEGACY_RATE3_RATE29_MASK) >> LEGACY_RATE3_RATE29_LSB)
#define LEGACY_RATE3_RATE29_SET(x)               (((x) << LEGACY_RATE3_RATE29_LSB) & LEGACY_RATE3_RATE29_MASK)
#define LEGACY_RATE3_RATE28_MSB                  17
#define LEGACY_RATE3_RATE28_LSB                  12
#define LEGACY_RATE3_RATE28_MASK                 0x0003f000
#define LEGACY_RATE3_RATE28_GET(x)               (((x) & LEGACY_RATE3_RATE28_MASK) >> LEGACY_RATE3_RATE28_LSB)
#define LEGACY_RATE3_RATE28_SET(x)               (((x) << LEGACY_RATE3_RATE28_LSB) & LEGACY_RATE3_RATE28_MASK)
#define LEGACY_RATE3_RATE27_MSB                  11
#define LEGACY_RATE3_RATE27_LSB                  6
#define LEGACY_RATE3_RATE27_MASK                 0x00000fc0
#define LEGACY_RATE3_RATE27_GET(x)               (((x) & LEGACY_RATE3_RATE27_MASK) >> LEGACY_RATE3_RATE27_LSB)
#define LEGACY_RATE3_RATE27_SET(x)               (((x) << LEGACY_RATE3_RATE27_LSB) & LEGACY_RATE3_RATE27_MASK)
#define LEGACY_RATE3_RATE26_MSB                  5
#define LEGACY_RATE3_RATE26_LSB                  0
#define LEGACY_RATE3_RATE26_MASK                 0x0000003f
#define LEGACY_RATE3_RATE26_GET(x)               (((x) & LEGACY_RATE3_RATE26_MASK) >> LEGACY_RATE3_RATE26_LSB)
#define LEGACY_RATE3_RATE26_SET(x)               (((x) << LEGACY_RATE3_RATE26_LSB) & LEGACY_RATE3_RATE26_MASK)

#define RX_INT_FILTER_ADDRESS                    0x00008364
#define RX_INT_FILTER_OFFSET                     0x00000364
#define RX_INT_FILTER_BEACON_MSB                 17
#define RX_INT_FILTER_BEACON_LSB                 17
#define RX_INT_FILTER_BEACON_MASK                0x00020000
#define RX_INT_FILTER_BEACON_GET(x)              (((x) & RX_INT_FILTER_BEACON_MASK) >> RX_INT_FILTER_BEACON_LSB)
#define RX_INT_FILTER_BEACON_SET(x)              (((x) << RX_INT_FILTER_BEACON_LSB) & RX_INT_FILTER_BEACON_MASK)
#define RX_INT_FILTER_AMPDU_MSB                  16
#define RX_INT_FILTER_AMPDU_LSB                  16
#define RX_INT_FILTER_AMPDU_MASK                 0x00010000
#define RX_INT_FILTER_AMPDU_GET(x)               (((x) & RX_INT_FILTER_AMPDU_MASK) >> RX_INT_FILTER_AMPDU_LSB)
#define RX_INT_FILTER_AMPDU_SET(x)               (((x) << RX_INT_FILTER_AMPDU_LSB) & RX_INT_FILTER_AMPDU_MASK)
#define RX_INT_FILTER_EOSP_MSB                   15
#define RX_INT_FILTER_EOSP_LSB                   15
#define RX_INT_FILTER_EOSP_MASK                  0x00008000
#define RX_INT_FILTER_EOSP_GET(x)                (((x) & RX_INT_FILTER_EOSP_MASK) >> RX_INT_FILTER_EOSP_LSB)
#define RX_INT_FILTER_EOSP_SET(x)                (((x) << RX_INT_FILTER_EOSP_LSB) & RX_INT_FILTER_EOSP_MASK)
#define RX_INT_FILTER_LENGTH_LOW_MSB             14
#define RX_INT_FILTER_LENGTH_LOW_LSB             14
#define RX_INT_FILTER_LENGTH_LOW_MASK            0x00004000
#define RX_INT_FILTER_LENGTH_LOW_GET(x)          (((x) & RX_INT_FILTER_LENGTH_LOW_MASK) >> RX_INT_FILTER_LENGTH_LOW_LSB)
#define RX_INT_FILTER_LENGTH_LOW_SET(x)          (((x) << RX_INT_FILTER_LENGTH_LOW_LSB) & RX_INT_FILTER_LENGTH_LOW_MASK)
#define RX_INT_FILTER_LENGTH_HIGH_MSB            13
#define RX_INT_FILTER_LENGTH_HIGH_LSB            13
#define RX_INT_FILTER_LENGTH_HIGH_MASK           0x00002000
#define RX_INT_FILTER_LENGTH_HIGH_GET(x)         (((x) & RX_INT_FILTER_LENGTH_HIGH_MASK) >> RX_INT_FILTER_LENGTH_HIGH_LSB)
#define RX_INT_FILTER_LENGTH_HIGH_SET(x)         (((x) << RX_INT_FILTER_LENGTH_HIGH_LSB) & RX_INT_FILTER_LENGTH_HIGH_MASK)
#define RX_INT_FILTER_RSSI_MSB                   12
#define RX_INT_FILTER_RSSI_LSB                   12
#define RX_INT_FILTER_RSSI_MASK                  0x00001000
#define RX_INT_FILTER_RSSI_GET(x)                (((x) & RX_INT_FILTER_RSSI_MASK) >> RX_INT_FILTER_RSSI_LSB)
#define RX_INT_FILTER_RSSI_SET(x)                (((x) << RX_INT_FILTER_RSSI_LSB) & RX_INT_FILTER_RSSI_MASK)
#define RX_INT_FILTER_RATE_LOW_MSB               11
#define RX_INT_FILTER_RATE_LOW_LSB               11
#define RX_INT_FILTER_RATE_LOW_MASK              0x00000800
#define RX_INT_FILTER_RATE_LOW_GET(x)            (((x) & RX_INT_FILTER_RATE_LOW_MASK) >> RX_INT_FILTER_RATE_LOW_LSB)
#define RX_INT_FILTER_RATE_LOW_SET(x)            (((x) << RX_INT_FILTER_RATE_LOW_LSB) & RX_INT_FILTER_RATE_LOW_MASK)
#define RX_INT_FILTER_RATE_HIGH_MSB              10
#define RX_INT_FILTER_RATE_HIGH_LSB              10
#define RX_INT_FILTER_RATE_HIGH_MASK             0x00000400
#define RX_INT_FILTER_RATE_HIGH_GET(x)           (((x) & RX_INT_FILTER_RATE_HIGH_MASK) >> RX_INT_FILTER_RATE_HIGH_LSB)
#define RX_INT_FILTER_RATE_HIGH_SET(x)           (((x) << RX_INT_FILTER_RATE_HIGH_LSB) & RX_INT_FILTER_RATE_HIGH_MASK)
#define RX_INT_FILTER_MORE_FRAG_MSB              9
#define RX_INT_FILTER_MORE_FRAG_LSB              9
#define RX_INT_FILTER_MORE_FRAG_MASK             0x00000200
#define RX_INT_FILTER_MORE_FRAG_GET(x)           (((x) & RX_INT_FILTER_MORE_FRAG_MASK) >> RX_INT_FILTER_MORE_FRAG_LSB)
#define RX_INT_FILTER_MORE_FRAG_SET(x)           (((x) << RX_INT_FILTER_MORE_FRAG_LSB) & RX_INT_FILTER_MORE_FRAG_MASK)
#define RX_INT_FILTER_MORE_DATA_MSB              8
#define RX_INT_FILTER_MORE_DATA_LSB              8
#define RX_INT_FILTER_MORE_DATA_MASK             0x00000100
#define RX_INT_FILTER_MORE_DATA_GET(x)           (((x) & RX_INT_FILTER_MORE_DATA_MASK) >> RX_INT_FILTER_MORE_DATA_LSB)
#define RX_INT_FILTER_MORE_DATA_SET(x)           (((x) << RX_INT_FILTER_MORE_DATA_LSB) & RX_INT_FILTER_MORE_DATA_MASK)
#define RX_INT_FILTER_RETRY_MSB                  7
#define RX_INT_FILTER_RETRY_LSB                  7
#define RX_INT_FILTER_RETRY_MASK                 0x00000080
#define RX_INT_FILTER_RETRY_GET(x)               (((x) & RX_INT_FILTER_RETRY_MASK) >> RX_INT_FILTER_RETRY_LSB)
#define RX_INT_FILTER_RETRY_SET(x)               (((x) << RX_INT_FILTER_RETRY_LSB) & RX_INT_FILTER_RETRY_MASK)
#define RX_INT_FILTER_CTS_MSB                    6
#define RX_INT_FILTER_CTS_LSB                    6
#define RX_INT_FILTER_CTS_MASK                   0x00000040
#define RX_INT_FILTER_CTS_GET(x)                 (((x) & RX_INT_FILTER_CTS_MASK) >> RX_INT_FILTER_CTS_LSB)
#define RX_INT_FILTER_CTS_SET(x)                 (((x) << RX_INT_FILTER_CTS_LSB) & RX_INT_FILTER_CTS_MASK)
#define RX_INT_FILTER_ACK_MSB                    5
#define RX_INT_FILTER_ACK_LSB                    5
#define RX_INT_FILTER_ACK_MASK                   0x00000020
#define RX_INT_FILTER_ACK_GET(x)                 (((x) & RX_INT_FILTER_ACK_MASK) >> RX_INT_FILTER_ACK_LSB)
#define RX_INT_FILTER_ACK_SET(x)                 (((x) << RX_INT_FILTER_ACK_LSB) & RX_INT_FILTER_ACK_MASK)
#define RX_INT_FILTER_RTS_MSB                    4
#define RX_INT_FILTER_RTS_LSB                    4
#define RX_INT_FILTER_RTS_MASK                   0x00000010
#define RX_INT_FILTER_RTS_GET(x)                 (((x) & RX_INT_FILTER_RTS_MASK) >> RX_INT_FILTER_RTS_LSB)
#define RX_INT_FILTER_RTS_SET(x)                 (((x) << RX_INT_FILTER_RTS_LSB) & RX_INT_FILTER_RTS_MASK)
#define RX_INT_FILTER_MCAST_MSB                  3
#define RX_INT_FILTER_MCAST_LSB                  3
#define RX_INT_FILTER_MCAST_MASK                 0x00000008
#define RX_INT_FILTER_MCAST_GET(x)               (((x) & RX_INT_FILTER_MCAST_MASK) >> RX_INT_FILTER_MCAST_LSB)
#define RX_INT_FILTER_MCAST_SET(x)               (((x) << RX_INT_FILTER_MCAST_LSB) & RX_INT_FILTER_MCAST_MASK)
#define RX_INT_FILTER_BCAST_MSB                  2
#define RX_INT_FILTER_BCAST_LSB                  2
#define RX_INT_FILTER_BCAST_MASK                 0x00000004
#define RX_INT_FILTER_BCAST_GET(x)               (((x) & RX_INT_FILTER_BCAST_MASK) >> RX_INT_FILTER_BCAST_LSB)
#define RX_INT_FILTER_BCAST_SET(x)               (((x) << RX_INT_FILTER_BCAST_LSB) & RX_INT_FILTER_BCAST_MASK)
#define RX_INT_FILTER_DIRECTED_MSB               1
#define RX_INT_FILTER_DIRECTED_LSB               1
#define RX_INT_FILTER_DIRECTED_MASK              0x00000002
#define RX_INT_FILTER_DIRECTED_GET(x)            (((x) & RX_INT_FILTER_DIRECTED_MASK) >> RX_INT_FILTER_DIRECTED_LSB)
#define RX_INT_FILTER_DIRECTED_SET(x)            (((x) << RX_INT_FILTER_DIRECTED_LSB) & RX_INT_FILTER_DIRECTED_MASK)
#define RX_INT_FILTER_ENABLE_MSB                 0
#define RX_INT_FILTER_ENABLE_LSB                 0
#define RX_INT_FILTER_ENABLE_MASK                0x00000001
#define RX_INT_FILTER_ENABLE_GET(x)              (((x) & RX_INT_FILTER_ENABLE_MASK) >> RX_INT_FILTER_ENABLE_LSB)
#define RX_INT_FILTER_ENABLE_SET(x)              (((x) << RX_INT_FILTER_ENABLE_LSB) & RX_INT_FILTER_ENABLE_MASK)

#define RX_INT_OVERFLOW_ADDRESS                  0x00008368
#define RX_INT_OVERFLOW_OFFSET                   0x00000368
#define RX_INT_OVERFLOW_STATUS_MSB               0
#define RX_INT_OVERFLOW_STATUS_LSB               0
#define RX_INT_OVERFLOW_STATUS_MASK              0x00000001
#define RX_INT_OVERFLOW_STATUS_GET(x)            (((x) & RX_INT_OVERFLOW_STATUS_MASK) >> RX_INT_OVERFLOW_STATUS_LSB)
#define RX_INT_OVERFLOW_STATUS_SET(x)            (((x) << RX_INT_OVERFLOW_STATUS_LSB) & RX_INT_OVERFLOW_STATUS_MASK)

#define RX_FILTER_THRESH_ADDRESS                 0x0000836c
#define RX_FILTER_THRESH_OFFSET                  0x0000036c
#define RX_FILTER_THRESH_RSSI_LOW_MSB            23
#define RX_FILTER_THRESH_RSSI_LOW_LSB            16
#define RX_FILTER_THRESH_RSSI_LOW_MASK           0x00ff0000
#define RX_FILTER_THRESH_RSSI_LOW_GET(x)         (((x) & RX_FILTER_THRESH_RSSI_LOW_MASK) >> RX_FILTER_THRESH_RSSI_LOW_LSB)
#define RX_FILTER_THRESH_RSSI_LOW_SET(x)         (((x) << RX_FILTER_THRESH_RSSI_LOW_LSB) & RX_FILTER_THRESH_RSSI_LOW_MASK)
#define RX_FILTER_THRESH_RATE_LOW_MSB            15
#define RX_FILTER_THRESH_RATE_LOW_LSB            8
#define RX_FILTER_THRESH_RATE_LOW_MASK           0x0000ff00
#define RX_FILTER_THRESH_RATE_LOW_GET(x)         (((x) & RX_FILTER_THRESH_RATE_LOW_MASK) >> RX_FILTER_THRESH_RATE_LOW_LSB)
#define RX_FILTER_THRESH_RATE_LOW_SET(x)         (((x) << RX_FILTER_THRESH_RATE_LOW_LSB) & RX_FILTER_THRESH_RATE_LOW_MASK)
#define RX_FILTER_THRESH_RATE_HIGH_MSB           7
#define RX_FILTER_THRESH_RATE_HIGH_LSB           0
#define RX_FILTER_THRESH_RATE_HIGH_MASK          0x000000ff
#define RX_FILTER_THRESH_RATE_HIGH_GET(x)        (((x) & RX_FILTER_THRESH_RATE_HIGH_MASK) >> RX_FILTER_THRESH_RATE_HIGH_LSB)
#define RX_FILTER_THRESH_RATE_HIGH_SET(x)        (((x) << RX_FILTER_THRESH_RATE_HIGH_LSB) & RX_FILTER_THRESH_RATE_HIGH_MASK)

#define RX_FILTER_THRESH1_ADDRESS                0x00008370
#define RX_FILTER_THRESH1_OFFSET                 0x00000370
#define RX_FILTER_THRESH1_LENGTH_LOW_MSB         23
#define RX_FILTER_THRESH1_LENGTH_LOW_LSB         12
#define RX_FILTER_THRESH1_LENGTH_LOW_MASK        0x00fff000
#define RX_FILTER_THRESH1_LENGTH_LOW_GET(x)      (((x) & RX_FILTER_THRESH1_LENGTH_LOW_MASK) >> RX_FILTER_THRESH1_LENGTH_LOW_LSB)
#define RX_FILTER_THRESH1_LENGTH_LOW_SET(x)      (((x) << RX_FILTER_THRESH1_LENGTH_LOW_LSB) & RX_FILTER_THRESH1_LENGTH_LOW_MASK)
#define RX_FILTER_THRESH1_LENGTH_HIGH_MSB        11
#define RX_FILTER_THRESH1_LENGTH_HIGH_LSB        0
#define RX_FILTER_THRESH1_LENGTH_HIGH_MASK       0x00000fff
#define RX_FILTER_THRESH1_LENGTH_HIGH_GET(x)     (((x) & RX_FILTER_THRESH1_LENGTH_HIGH_MASK) >> RX_FILTER_THRESH1_LENGTH_HIGH_LSB)
#define RX_FILTER_THRESH1_LENGTH_HIGH_SET(x)     (((x) << RX_FILTER_THRESH1_LENGTH_HIGH_LSB) & RX_FILTER_THRESH1_LENGTH_HIGH_MASK)

#define RX_PRIORITY_THRESH0_ADDRESS              0x00008374
#define RX_PRIORITY_THRESH0_OFFSET               0x00000374
#define RX_PRIORITY_THRESH0_RSSI_LOW_MSB         31
#define RX_PRIORITY_THRESH0_RSSI_LOW_LSB         24
#define RX_PRIORITY_THRESH0_RSSI_LOW_MASK        0xff000000
#define RX_PRIORITY_THRESH0_RSSI_LOW_GET(x)      (((x) & RX_PRIORITY_THRESH0_RSSI_LOW_MASK) >> RX_PRIORITY_THRESH0_RSSI_LOW_LSB)
#define RX_PRIORITY_THRESH0_RSSI_LOW_SET(x)      (((x) << RX_PRIORITY_THRESH0_RSSI_LOW_LSB) & RX_PRIORITY_THRESH0_RSSI_LOW_MASK)
#define RX_PRIORITY_THRESH0_RSSI_HIGH_MSB        23
#define RX_PRIORITY_THRESH0_RSSI_HIGH_LSB        16
#define RX_PRIORITY_THRESH0_RSSI_HIGH_MASK       0x00ff0000
#define RX_PRIORITY_THRESH0_RSSI_HIGH_GET(x)     (((x) & RX_PRIORITY_THRESH0_RSSI_HIGH_MASK) >> RX_PRIORITY_THRESH0_RSSI_HIGH_LSB)
#define RX_PRIORITY_THRESH0_RSSI_HIGH_SET(x)     (((x) << RX_PRIORITY_THRESH0_RSSI_HIGH_LSB) & RX_PRIORITY_THRESH0_RSSI_HIGH_MASK)
#define RX_PRIORITY_THRESH0_RATE_LOW_MSB         15
#define RX_PRIORITY_THRESH0_RATE_LOW_LSB         8
#define RX_PRIORITY_THRESH0_RATE_LOW_MASK        0x0000ff00
#define RX_PRIORITY_THRESH0_RATE_LOW_GET(x)      (((x) & RX_PRIORITY_THRESH0_RATE_LOW_MASK) >> RX_PRIORITY_THRESH0_RATE_LOW_LSB)
#define RX_PRIORITY_THRESH0_RATE_LOW_SET(x)      (((x) << RX_PRIORITY_THRESH0_RATE_LOW_LSB) & RX_PRIORITY_THRESH0_RATE_LOW_MASK)
#define RX_PRIORITY_THRESH0_RATE_HIGH_MSB        7
#define RX_PRIORITY_THRESH0_RATE_HIGH_LSB        0
#define RX_PRIORITY_THRESH0_RATE_HIGH_MASK       0x000000ff
#define RX_PRIORITY_THRESH0_RATE_HIGH_GET(x)     (((x) & RX_PRIORITY_THRESH0_RATE_HIGH_MASK) >> RX_PRIORITY_THRESH0_RATE_HIGH_LSB)
#define RX_PRIORITY_THRESH0_RATE_HIGH_SET(x)     (((x) << RX_PRIORITY_THRESH0_RATE_HIGH_LSB) & RX_PRIORITY_THRESH0_RATE_HIGH_MASK)

#define RX_PRIORITY_THRESH1_ADDRESS              0x00008378
#define RX_PRIORITY_THRESH1_OFFSET               0x00000378
#define RX_PRIORITY_THRESH1_XCAST_RSSI_HIGH_MSB  31
#define RX_PRIORITY_THRESH1_XCAST_RSSI_HIGH_LSB  24
#define RX_PRIORITY_THRESH1_XCAST_RSSI_HIGH_MASK 0xff000000
#define RX_PRIORITY_THRESH1_XCAST_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_THRESH1_XCAST_RSSI_HIGH_MASK) >> RX_PRIORITY_THRESH1_XCAST_RSSI_HIGH_LSB)
#define RX_PRIORITY_THRESH1_XCAST_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_THRESH1_XCAST_RSSI_HIGH_LSB) & RX_PRIORITY_THRESH1_XCAST_RSSI_HIGH_MASK)
#define RX_PRIORITY_THRESH1_LENGTH_LOW_MSB       23
#define RX_PRIORITY_THRESH1_LENGTH_LOW_LSB       12
#define RX_PRIORITY_THRESH1_LENGTH_LOW_MASK      0x00fff000
#define RX_PRIORITY_THRESH1_LENGTH_LOW_GET(x)    (((x) & RX_PRIORITY_THRESH1_LENGTH_LOW_MASK) >> RX_PRIORITY_THRESH1_LENGTH_LOW_LSB)
#define RX_PRIORITY_THRESH1_LENGTH_LOW_SET(x)    (((x) << RX_PRIORITY_THRESH1_LENGTH_LOW_LSB) & RX_PRIORITY_THRESH1_LENGTH_LOW_MASK)
#define RX_PRIORITY_THRESH1_LENGTH_HIGH_MSB      11
#define RX_PRIORITY_THRESH1_LENGTH_HIGH_LSB      0
#define RX_PRIORITY_THRESH1_LENGTH_HIGH_MASK     0x00000fff
#define RX_PRIORITY_THRESH1_LENGTH_HIGH_GET(x)   (((x) & RX_PRIORITY_THRESH1_LENGTH_HIGH_MASK) >> RX_PRIORITY_THRESH1_LENGTH_HIGH_LSB)
#define RX_PRIORITY_THRESH1_LENGTH_HIGH_SET(x)   (((x) << RX_PRIORITY_THRESH1_LENGTH_HIGH_LSB) & RX_PRIORITY_THRESH1_LENGTH_HIGH_MASK)

#define RX_PRIORITY_THRESH2_ADDRESS              0x0000837c
#define RX_PRIORITY_THRESH2_OFFSET               0x0000037c
#define RX_PRIORITY_THRESH2_NULL_RSSI_HIGH_MSB   31
#define RX_PRIORITY_THRESH2_NULL_RSSI_HIGH_LSB   24
#define RX_PRIORITY_THRESH2_NULL_RSSI_HIGH_MASK  0xff000000
#define RX_PRIORITY_THRESH2_NULL_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_THRESH2_NULL_RSSI_HIGH_MASK) >> RX_PRIORITY_THRESH2_NULL_RSSI_HIGH_LSB)
#define RX_PRIORITY_THRESH2_NULL_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_THRESH2_NULL_RSSI_HIGH_LSB) & RX_PRIORITY_THRESH2_NULL_RSSI_HIGH_MASK)
#define RX_PRIORITY_THRESH2_BEACON_RSSI_HIGH_MSB 23
#define RX_PRIORITY_THRESH2_BEACON_RSSI_HIGH_LSB 16
#define RX_PRIORITY_THRESH2_BEACON_RSSI_HIGH_MASK 0x00ff0000
#define RX_PRIORITY_THRESH2_BEACON_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_THRESH2_BEACON_RSSI_HIGH_MASK) >> RX_PRIORITY_THRESH2_BEACON_RSSI_HIGH_LSB)
#define RX_PRIORITY_THRESH2_BEACON_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_THRESH2_BEACON_RSSI_HIGH_LSB) & RX_PRIORITY_THRESH2_BEACON_RSSI_HIGH_MASK)
#define RX_PRIORITY_THRESH2_MGMT_RSSI_HIGH_MSB   15
#define RX_PRIORITY_THRESH2_MGMT_RSSI_HIGH_LSB   8
#define RX_PRIORITY_THRESH2_MGMT_RSSI_HIGH_MASK  0x0000ff00
#define RX_PRIORITY_THRESH2_MGMT_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_THRESH2_MGMT_RSSI_HIGH_MASK) >> RX_PRIORITY_THRESH2_MGMT_RSSI_HIGH_LSB)
#define RX_PRIORITY_THRESH2_MGMT_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_THRESH2_MGMT_RSSI_HIGH_LSB) & RX_PRIORITY_THRESH2_MGMT_RSSI_HIGH_MASK)
#define RX_PRIORITY_THRESH2_PRESP_RSSI_HIGH_MSB  7
#define RX_PRIORITY_THRESH2_PRESP_RSSI_HIGH_LSB  0
#define RX_PRIORITY_THRESH2_PRESP_RSSI_HIGH_MASK 0x000000ff
#define RX_PRIORITY_THRESH2_PRESP_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_THRESH2_PRESP_RSSI_HIGH_MASK) >> RX_PRIORITY_THRESH2_PRESP_RSSI_HIGH_LSB)
#define RX_PRIORITY_THRESH2_PRESP_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_THRESH2_PRESP_RSSI_HIGH_LSB) & RX_PRIORITY_THRESH2_PRESP_RSSI_HIGH_MASK)

#define RX_PRIORITY_THRESH3_ADDRESS              0x00008380
#define RX_PRIORITY_THRESH3_OFFSET               0x00000380
#define RX_PRIORITY_THRESH3_PS_POLL_RSSI_HIGH_MSB 15
#define RX_PRIORITY_THRESH3_PS_POLL_RSSI_HIGH_LSB 8
#define RX_PRIORITY_THRESH3_PS_POLL_RSSI_HIGH_MASK 0x0000ff00
#define RX_PRIORITY_THRESH3_PS_POLL_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_THRESH3_PS_POLL_RSSI_HIGH_MASK) >> RX_PRIORITY_THRESH3_PS_POLL_RSSI_HIGH_LSB)
#define RX_PRIORITY_THRESH3_PS_POLL_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_THRESH3_PS_POLL_RSSI_HIGH_LSB) & RX_PRIORITY_THRESH3_PS_POLL_RSSI_HIGH_MASK)
#define RX_PRIORITY_THRESH3_PREQ_RSSI_HIGH_MSB   7
#define RX_PRIORITY_THRESH3_PREQ_RSSI_HIGH_LSB   0
#define RX_PRIORITY_THRESH3_PREQ_RSSI_HIGH_MASK  0x000000ff
#define RX_PRIORITY_THRESH3_PREQ_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_THRESH3_PREQ_RSSI_HIGH_MASK) >> RX_PRIORITY_THRESH3_PREQ_RSSI_HIGH_LSB)
#define RX_PRIORITY_THRESH3_PREQ_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_THRESH3_PREQ_RSSI_HIGH_LSB) & RX_PRIORITY_THRESH3_PREQ_RSSI_HIGH_MASK)

#define RX_PRIORITY_OFFSET0_ADDRESS              0x00008384
#define RX_PRIORITY_OFFSET0_OFFSET               0x00000384
#define RX_PRIORITY_OFFSET0_XCAST_RSSI_HIGH_MSB  29
#define RX_PRIORITY_OFFSET0_XCAST_RSSI_HIGH_LSB  24
#define RX_PRIORITY_OFFSET0_XCAST_RSSI_HIGH_MASK 0x3f000000
#define RX_PRIORITY_OFFSET0_XCAST_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_OFFSET0_XCAST_RSSI_HIGH_MASK) >> RX_PRIORITY_OFFSET0_XCAST_RSSI_HIGH_LSB)
#define RX_PRIORITY_OFFSET0_XCAST_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_OFFSET0_XCAST_RSSI_HIGH_LSB) & RX_PRIORITY_OFFSET0_XCAST_RSSI_HIGH_MASK)
#define RX_PRIORITY_OFFSET0_RSSI_LOW_MSB         23
#define RX_PRIORITY_OFFSET0_RSSI_LOW_LSB         18
#define RX_PRIORITY_OFFSET0_RSSI_LOW_MASK        0x00fc0000
#define RX_PRIORITY_OFFSET0_RSSI_LOW_GET(x)      (((x) & RX_PRIORITY_OFFSET0_RSSI_LOW_MASK) >> RX_PRIORITY_OFFSET0_RSSI_LOW_LSB)
#define RX_PRIORITY_OFFSET0_RSSI_LOW_SET(x)      (((x) << RX_PRIORITY_OFFSET0_RSSI_LOW_LSB) & RX_PRIORITY_OFFSET0_RSSI_LOW_MASK)
#define RX_PRIORITY_OFFSET0_RSSI_HIGH_MSB        17
#define RX_PRIORITY_OFFSET0_RSSI_HIGH_LSB        12
#define RX_PRIORITY_OFFSET0_RSSI_HIGH_MASK       0x0003f000
#define RX_PRIORITY_OFFSET0_RSSI_HIGH_GET(x)     (((x) & RX_PRIORITY_OFFSET0_RSSI_HIGH_MASK) >> RX_PRIORITY_OFFSET0_RSSI_HIGH_LSB)
#define RX_PRIORITY_OFFSET0_RSSI_HIGH_SET(x)     (((x) << RX_PRIORITY_OFFSET0_RSSI_HIGH_LSB) & RX_PRIORITY_OFFSET0_RSSI_HIGH_MASK)
#define RX_PRIORITY_OFFSET0_PHY_RATE_LOW_MSB     11
#define RX_PRIORITY_OFFSET0_PHY_RATE_LOW_LSB     6
#define RX_PRIORITY_OFFSET0_PHY_RATE_LOW_MASK    0x00000fc0
#define RX_PRIORITY_OFFSET0_PHY_RATE_LOW_GET(x)  (((x) & RX_PRIORITY_OFFSET0_PHY_RATE_LOW_MASK) >> RX_PRIORITY_OFFSET0_PHY_RATE_LOW_LSB)
#define RX_PRIORITY_OFFSET0_PHY_RATE_LOW_SET(x)  (((x) << RX_PRIORITY_OFFSET0_PHY_RATE_LOW_LSB) & RX_PRIORITY_OFFSET0_PHY_RATE_LOW_MASK)
#define RX_PRIORITY_OFFSET0_PHY_RATE_HIGH_MSB    5
#define RX_PRIORITY_OFFSET0_PHY_RATE_HIGH_LSB    0
#define RX_PRIORITY_OFFSET0_PHY_RATE_HIGH_MASK   0x0000003f
#define RX_PRIORITY_OFFSET0_PHY_RATE_HIGH_GET(x) (((x) & RX_PRIORITY_OFFSET0_PHY_RATE_HIGH_MASK) >> RX_PRIORITY_OFFSET0_PHY_RATE_HIGH_LSB)
#define RX_PRIORITY_OFFSET0_PHY_RATE_HIGH_SET(x) (((x) << RX_PRIORITY_OFFSET0_PHY_RATE_HIGH_LSB) & RX_PRIORITY_OFFSET0_PHY_RATE_HIGH_MASK)

#define RX_PRIORITY_OFFSET1_ADDRESS              0x00008388
#define RX_PRIORITY_OFFSET1_OFFSET               0x00000388
#define RX_PRIORITY_OFFSET1_RTS_MSB              29
#define RX_PRIORITY_OFFSET1_RTS_LSB              24
#define RX_PRIORITY_OFFSET1_RTS_MASK             0x3f000000
#define RX_PRIORITY_OFFSET1_RTS_GET(x)           (((x) & RX_PRIORITY_OFFSET1_RTS_MASK) >> RX_PRIORITY_OFFSET1_RTS_LSB)
#define RX_PRIORITY_OFFSET1_RTS_SET(x)           (((x) << RX_PRIORITY_OFFSET1_RTS_LSB) & RX_PRIORITY_OFFSET1_RTS_MASK)
#define RX_PRIORITY_OFFSET1_RETX_MSB             23
#define RX_PRIORITY_OFFSET1_RETX_LSB             18
#define RX_PRIORITY_OFFSET1_RETX_MASK            0x00fc0000
#define RX_PRIORITY_OFFSET1_RETX_GET(x)          (((x) & RX_PRIORITY_OFFSET1_RETX_MASK) >> RX_PRIORITY_OFFSET1_RETX_LSB)
#define RX_PRIORITY_OFFSET1_RETX_SET(x)          (((x) << RX_PRIORITY_OFFSET1_RETX_LSB) & RX_PRIORITY_OFFSET1_RETX_MASK)
#define RX_PRIORITY_OFFSET1_PRESP_RSSI_HIGH_MSB  17
#define RX_PRIORITY_OFFSET1_PRESP_RSSI_HIGH_LSB  12
#define RX_PRIORITY_OFFSET1_PRESP_RSSI_HIGH_MASK 0x0003f000
#define RX_PRIORITY_OFFSET1_PRESP_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_OFFSET1_PRESP_RSSI_HIGH_MASK) >> RX_PRIORITY_OFFSET1_PRESP_RSSI_HIGH_LSB)
#define RX_PRIORITY_OFFSET1_PRESP_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_OFFSET1_PRESP_RSSI_HIGH_LSB) & RX_PRIORITY_OFFSET1_PRESP_RSSI_HIGH_MASK)
#define RX_PRIORITY_OFFSET1_LENGTH_LOW_MSB       11
#define RX_PRIORITY_OFFSET1_LENGTH_LOW_LSB       6
#define RX_PRIORITY_OFFSET1_LENGTH_LOW_MASK      0x00000fc0
#define RX_PRIORITY_OFFSET1_LENGTH_LOW_GET(x)    (((x) & RX_PRIORITY_OFFSET1_LENGTH_LOW_MASK) >> RX_PRIORITY_OFFSET1_LENGTH_LOW_LSB)
#define RX_PRIORITY_OFFSET1_LENGTH_LOW_SET(x)    (((x) << RX_PRIORITY_OFFSET1_LENGTH_LOW_LSB) & RX_PRIORITY_OFFSET1_LENGTH_LOW_MASK)
#define RX_PRIORITY_OFFSET1_LENGTH_HIGH_MSB      5
#define RX_PRIORITY_OFFSET1_LENGTH_HIGH_LSB      0
#define RX_PRIORITY_OFFSET1_LENGTH_HIGH_MASK     0x0000003f
#define RX_PRIORITY_OFFSET1_LENGTH_HIGH_GET(x)   (((x) & RX_PRIORITY_OFFSET1_LENGTH_HIGH_MASK) >> RX_PRIORITY_OFFSET1_LENGTH_HIGH_LSB)
#define RX_PRIORITY_OFFSET1_LENGTH_HIGH_SET(x)   (((x) << RX_PRIORITY_OFFSET1_LENGTH_HIGH_LSB) & RX_PRIORITY_OFFSET1_LENGTH_HIGH_MASK)

#define RX_PRIORITY_OFFSET2_ADDRESS              0x0000838c
#define RX_PRIORITY_OFFSET2_OFFSET               0x0000038c
#define RX_PRIORITY_OFFSET2_BEACON_MSB           29
#define RX_PRIORITY_OFFSET2_BEACON_LSB           24
#define RX_PRIORITY_OFFSET2_BEACON_MASK          0x3f000000
#define RX_PRIORITY_OFFSET2_BEACON_GET(x)        (((x) & RX_PRIORITY_OFFSET2_BEACON_MASK) >> RX_PRIORITY_OFFSET2_BEACON_LSB)
#define RX_PRIORITY_OFFSET2_BEACON_SET(x)        (((x) << RX_PRIORITY_OFFSET2_BEACON_LSB) & RX_PRIORITY_OFFSET2_BEACON_MASK)
#define RX_PRIORITY_OFFSET2_MGMT_MSB             23
#define RX_PRIORITY_OFFSET2_MGMT_LSB             18
#define RX_PRIORITY_OFFSET2_MGMT_MASK            0x00fc0000
#define RX_PRIORITY_OFFSET2_MGMT_GET(x)          (((x) & RX_PRIORITY_OFFSET2_MGMT_MASK) >> RX_PRIORITY_OFFSET2_MGMT_LSB)
#define RX_PRIORITY_OFFSET2_MGMT_SET(x)          (((x) << RX_PRIORITY_OFFSET2_MGMT_LSB) & RX_PRIORITY_OFFSET2_MGMT_MASK)
#define RX_PRIORITY_OFFSET2_ATIM_MSB             17
#define RX_PRIORITY_OFFSET2_ATIM_LSB             12
#define RX_PRIORITY_OFFSET2_ATIM_MASK            0x0003f000
#define RX_PRIORITY_OFFSET2_ATIM_GET(x)          (((x) & RX_PRIORITY_OFFSET2_ATIM_MASK) >> RX_PRIORITY_OFFSET2_ATIM_LSB)
#define RX_PRIORITY_OFFSET2_ATIM_SET(x)          (((x) << RX_PRIORITY_OFFSET2_ATIM_LSB) & RX_PRIORITY_OFFSET2_ATIM_MASK)
#define RX_PRIORITY_OFFSET2_PRESP_MSB            11
#define RX_PRIORITY_OFFSET2_PRESP_LSB            6
#define RX_PRIORITY_OFFSET2_PRESP_MASK           0x00000fc0
#define RX_PRIORITY_OFFSET2_PRESP_GET(x)         (((x) & RX_PRIORITY_OFFSET2_PRESP_MASK) >> RX_PRIORITY_OFFSET2_PRESP_LSB)
#define RX_PRIORITY_OFFSET2_PRESP_SET(x)         (((x) << RX_PRIORITY_OFFSET2_PRESP_LSB) & RX_PRIORITY_OFFSET2_PRESP_MASK)
#define RX_PRIORITY_OFFSET2_XCAST_MSB            5
#define RX_PRIORITY_OFFSET2_XCAST_LSB            0
#define RX_PRIORITY_OFFSET2_XCAST_MASK           0x0000003f
#define RX_PRIORITY_OFFSET2_XCAST_GET(x)         (((x) & RX_PRIORITY_OFFSET2_XCAST_MASK) >> RX_PRIORITY_OFFSET2_XCAST_LSB)
#define RX_PRIORITY_OFFSET2_XCAST_SET(x)         (((x) << RX_PRIORITY_OFFSET2_XCAST_LSB) & RX_PRIORITY_OFFSET2_XCAST_MASK)

#define RX_PRIORITY_OFFSET3_ADDRESS              0x00008390
#define RX_PRIORITY_OFFSET3_OFFSET               0x00000390
#define RX_PRIORITY_OFFSET3_PS_POLL_MSB          29
#define RX_PRIORITY_OFFSET3_PS_POLL_LSB          24
#define RX_PRIORITY_OFFSET3_PS_POLL_MASK         0x3f000000
#define RX_PRIORITY_OFFSET3_PS_POLL_GET(x)       (((x) & RX_PRIORITY_OFFSET3_PS_POLL_MASK) >> RX_PRIORITY_OFFSET3_PS_POLL_LSB)
#define RX_PRIORITY_OFFSET3_PS_POLL_SET(x)       (((x) << RX_PRIORITY_OFFSET3_PS_POLL_LSB) & RX_PRIORITY_OFFSET3_PS_POLL_MASK)
#define RX_PRIORITY_OFFSET3_AMSDU_MSB            23
#define RX_PRIORITY_OFFSET3_AMSDU_LSB            18
#define RX_PRIORITY_OFFSET3_AMSDU_MASK           0x00fc0000
#define RX_PRIORITY_OFFSET3_AMSDU_GET(x)         (((x) & RX_PRIORITY_OFFSET3_AMSDU_MASK) >> RX_PRIORITY_OFFSET3_AMSDU_LSB)
#define RX_PRIORITY_OFFSET3_AMSDU_SET(x)         (((x) << RX_PRIORITY_OFFSET3_AMSDU_LSB) & RX_PRIORITY_OFFSET3_AMSDU_MASK)
#define RX_PRIORITY_OFFSET3_AMPDU_MSB            17
#define RX_PRIORITY_OFFSET3_AMPDU_LSB            12
#define RX_PRIORITY_OFFSET3_AMPDU_MASK           0x0003f000
#define RX_PRIORITY_OFFSET3_AMPDU_GET(x)         (((x) & RX_PRIORITY_OFFSET3_AMPDU_MASK) >> RX_PRIORITY_OFFSET3_AMPDU_LSB)
#define RX_PRIORITY_OFFSET3_AMPDU_SET(x)         (((x) << RX_PRIORITY_OFFSET3_AMPDU_LSB) & RX_PRIORITY_OFFSET3_AMPDU_MASK)
#define RX_PRIORITY_OFFSET3_EOSP_MSB             11
#define RX_PRIORITY_OFFSET3_EOSP_LSB             6
#define RX_PRIORITY_OFFSET3_EOSP_MASK            0x00000fc0
#define RX_PRIORITY_OFFSET3_EOSP_GET(x)          (((x) & RX_PRIORITY_OFFSET3_EOSP_MASK) >> RX_PRIORITY_OFFSET3_EOSP_LSB)
#define RX_PRIORITY_OFFSET3_EOSP_SET(x)          (((x) << RX_PRIORITY_OFFSET3_EOSP_LSB) & RX_PRIORITY_OFFSET3_EOSP_MASK)
#define RX_PRIORITY_OFFSET3_MORE_MSB             5
#define RX_PRIORITY_OFFSET3_MORE_LSB             0
#define RX_PRIORITY_OFFSET3_MORE_MASK            0x0000003f
#define RX_PRIORITY_OFFSET3_MORE_GET(x)          (((x) & RX_PRIORITY_OFFSET3_MORE_MASK) >> RX_PRIORITY_OFFSET3_MORE_LSB)
#define RX_PRIORITY_OFFSET3_MORE_SET(x)          (((x) << RX_PRIORITY_OFFSET3_MORE_LSB) & RX_PRIORITY_OFFSET3_MORE_MASK)

#define RX_PRIORITY_OFFSET4_ADDRESS              0x00008394
#define RX_PRIORITY_OFFSET4_OFFSET               0x00000394
#define RX_PRIORITY_OFFSET4_BEACON_RSSI_HIGH_MSB 29
#define RX_PRIORITY_OFFSET4_BEACON_RSSI_HIGH_LSB 24
#define RX_PRIORITY_OFFSET4_BEACON_RSSI_HIGH_MASK 0x3f000000
#define RX_PRIORITY_OFFSET4_BEACON_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_OFFSET4_BEACON_RSSI_HIGH_MASK) >> RX_PRIORITY_OFFSET4_BEACON_RSSI_HIGH_LSB)
#define RX_PRIORITY_OFFSET4_BEACON_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_OFFSET4_BEACON_RSSI_HIGH_LSB) & RX_PRIORITY_OFFSET4_BEACON_RSSI_HIGH_MASK)
#define RX_PRIORITY_OFFSET4_MGMT_RSSI_HIGH_MSB   23
#define RX_PRIORITY_OFFSET4_MGMT_RSSI_HIGH_LSB   18
#define RX_PRIORITY_OFFSET4_MGMT_RSSI_HIGH_MASK  0x00fc0000
#define RX_PRIORITY_OFFSET4_MGMT_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_OFFSET4_MGMT_RSSI_HIGH_MASK) >> RX_PRIORITY_OFFSET4_MGMT_RSSI_HIGH_LSB)
#define RX_PRIORITY_OFFSET4_MGMT_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_OFFSET4_MGMT_RSSI_HIGH_LSB) & RX_PRIORITY_OFFSET4_MGMT_RSSI_HIGH_MASK)
#define RX_PRIORITY_OFFSET4_BEACON_SSID_MSB      17
#define RX_PRIORITY_OFFSET4_BEACON_SSID_LSB      12
#define RX_PRIORITY_OFFSET4_BEACON_SSID_MASK     0x0003f000
#define RX_PRIORITY_OFFSET4_BEACON_SSID_GET(x)   (((x) & RX_PRIORITY_OFFSET4_BEACON_SSID_MASK) >> RX_PRIORITY_OFFSET4_BEACON_SSID_LSB)
#define RX_PRIORITY_OFFSET4_BEACON_SSID_SET(x)   (((x) << RX_PRIORITY_OFFSET4_BEACON_SSID_LSB) & RX_PRIORITY_OFFSET4_BEACON_SSID_MASK)
#define RX_PRIORITY_OFFSET4_NULL_MSB             11
#define RX_PRIORITY_OFFSET4_NULL_LSB             6
#define RX_PRIORITY_OFFSET4_NULL_MASK            0x00000fc0
#define RX_PRIORITY_OFFSET4_NULL_GET(x)          (((x) & RX_PRIORITY_OFFSET4_NULL_MASK) >> RX_PRIORITY_OFFSET4_NULL_LSB)
#define RX_PRIORITY_OFFSET4_NULL_SET(x)          (((x) << RX_PRIORITY_OFFSET4_NULL_LSB) & RX_PRIORITY_OFFSET4_NULL_MASK)
#define RX_PRIORITY_OFFSET4_PREQ_MSB             5
#define RX_PRIORITY_OFFSET4_PREQ_LSB             0
#define RX_PRIORITY_OFFSET4_PREQ_MASK            0x0000003f
#define RX_PRIORITY_OFFSET4_PREQ_GET(x)          (((x) & RX_PRIORITY_OFFSET4_PREQ_MASK) >> RX_PRIORITY_OFFSET4_PREQ_LSB)
#define RX_PRIORITY_OFFSET4_PREQ_SET(x)          (((x) << RX_PRIORITY_OFFSET4_PREQ_LSB) & RX_PRIORITY_OFFSET4_PREQ_MASK)

#define RX_PRIORITY_OFFSET5_ADDRESS              0x00008398
#define RX_PRIORITY_OFFSET5_OFFSET               0x00000398
#define RX_PRIORITY_OFFSET5_PS_POLL_RSSI_HIGH_MSB 17
#define RX_PRIORITY_OFFSET5_PS_POLL_RSSI_HIGH_LSB 12
#define RX_PRIORITY_OFFSET5_PS_POLL_RSSI_HIGH_MASK 0x0003f000
#define RX_PRIORITY_OFFSET5_PS_POLL_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_OFFSET5_PS_POLL_RSSI_HIGH_MASK) >> RX_PRIORITY_OFFSET5_PS_POLL_RSSI_HIGH_LSB)
#define RX_PRIORITY_OFFSET5_PS_POLL_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_OFFSET5_PS_POLL_RSSI_HIGH_LSB) & RX_PRIORITY_OFFSET5_PS_POLL_RSSI_HIGH_MASK)
#define RX_PRIORITY_OFFSET5_PREQ_RSSI_HIGH_MSB   11
#define RX_PRIORITY_OFFSET5_PREQ_RSSI_HIGH_LSB   6
#define RX_PRIORITY_OFFSET5_PREQ_RSSI_HIGH_MASK  0x00000fc0
#define RX_PRIORITY_OFFSET5_PREQ_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_OFFSET5_PREQ_RSSI_HIGH_MASK) >> RX_PRIORITY_OFFSET5_PREQ_RSSI_HIGH_LSB)
#define RX_PRIORITY_OFFSET5_PREQ_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_OFFSET5_PREQ_RSSI_HIGH_LSB) & RX_PRIORITY_OFFSET5_PREQ_RSSI_HIGH_MASK)
#define RX_PRIORITY_OFFSET5_NULL_RSSI_HIGH_MSB   5
#define RX_PRIORITY_OFFSET5_NULL_RSSI_HIGH_LSB   0
#define RX_PRIORITY_OFFSET5_NULL_RSSI_HIGH_MASK  0x0000003f
#define RX_PRIORITY_OFFSET5_NULL_RSSI_HIGH_GET(x) (((x) & RX_PRIORITY_OFFSET5_NULL_RSSI_HIGH_MASK) >> RX_PRIORITY_OFFSET5_NULL_RSSI_HIGH_LSB)
#define RX_PRIORITY_OFFSET5_NULL_RSSI_HIGH_SET(x) (((x) << RX_PRIORITY_OFFSET5_NULL_RSSI_HIGH_LSB) & RX_PRIORITY_OFFSET5_NULL_RSSI_HIGH_MASK)

#define MAC_PCU_BSSID2_L32_ADDRESS               0x0000839c
#define MAC_PCU_BSSID2_L32_OFFSET                0x0000039c
#define MAC_PCU_BSSID2_L32_ADDR_MSB              31
#define MAC_PCU_BSSID2_L32_ADDR_LSB              0
#define MAC_PCU_BSSID2_L32_ADDR_MASK             0xffffffff
#define MAC_PCU_BSSID2_L32_ADDR_GET(x)           (((x) & MAC_PCU_BSSID2_L32_ADDR_MASK) >> MAC_PCU_BSSID2_L32_ADDR_LSB)
#define MAC_PCU_BSSID2_L32_ADDR_SET(x)           (((x) << MAC_PCU_BSSID2_L32_ADDR_LSB) & MAC_PCU_BSSID2_L32_ADDR_MASK)

#define MAC_PCU_BSSID2_U16_ADDRESS               0x000083a0
#define MAC_PCU_BSSID2_U16_OFFSET                0x000003a0
#define MAC_PCU_BSSID2_U16_ENABLE_MSB            16
#define MAC_PCU_BSSID2_U16_ENABLE_LSB            16
#define MAC_PCU_BSSID2_U16_ENABLE_MASK           0x00010000
#define MAC_PCU_BSSID2_U16_ENABLE_GET(x)         (((x) & MAC_PCU_BSSID2_U16_ENABLE_MASK) >> MAC_PCU_BSSID2_U16_ENABLE_LSB)
#define MAC_PCU_BSSID2_U16_ENABLE_SET(x)         (((x) << MAC_PCU_BSSID2_U16_ENABLE_LSB) & MAC_PCU_BSSID2_U16_ENABLE_MASK)
#define MAC_PCU_BSSID2_U16_ADDR_MSB              15
#define MAC_PCU_BSSID2_U16_ADDR_LSB              0
#define MAC_PCU_BSSID2_U16_ADDR_MASK             0x0000ffff
#define MAC_PCU_BSSID2_U16_ADDR_GET(x)           (((x) & MAC_PCU_BSSID2_U16_ADDR_MASK) >> MAC_PCU_BSSID2_U16_ADDR_LSB)
#define MAC_PCU_BSSID2_U16_ADDR_SET(x)           (((x) << MAC_PCU_BSSID2_U16_ADDR_LSB) & MAC_PCU_BSSID2_U16_ADDR_MASK)

#define MAC_PCU_TSF1_STATUS_L32_ADDRESS          0x000083a4
#define MAC_PCU_TSF1_STATUS_L32_OFFSET           0x000003a4
#define MAC_PCU_TSF1_STATUS_L32_VALUE_MSB        31
#define MAC_PCU_TSF1_STATUS_L32_VALUE_LSB        0
#define MAC_PCU_TSF1_STATUS_L32_VALUE_MASK       0xffffffff
#define MAC_PCU_TSF1_STATUS_L32_VALUE_GET(x)     (((x) & MAC_PCU_TSF1_STATUS_L32_VALUE_MASK) >> MAC_PCU_TSF1_STATUS_L32_VALUE_LSB)
#define MAC_PCU_TSF1_STATUS_L32_VALUE_SET(x)     (((x) << MAC_PCU_TSF1_STATUS_L32_VALUE_LSB) & MAC_PCU_TSF1_STATUS_L32_VALUE_MASK)

#define MAC_PCU_TSF1_STATUS_U32_ADDRESS          0x000083a8
#define MAC_PCU_TSF1_STATUS_U32_OFFSET           0x000003a8
#define MAC_PCU_TSF1_STATUS_U32_VALUE_MSB        31
#define MAC_PCU_TSF1_STATUS_U32_VALUE_LSB        0
#define MAC_PCU_TSF1_STATUS_U32_VALUE_MASK       0xffffffff
#define MAC_PCU_TSF1_STATUS_U32_VALUE_GET(x)     (((x) & MAC_PCU_TSF1_STATUS_U32_VALUE_MASK) >> MAC_PCU_TSF1_STATUS_U32_VALUE_LSB)
#define MAC_PCU_TSF1_STATUS_U32_VALUE_SET(x)     (((x) << MAC_PCU_TSF1_STATUS_U32_VALUE_LSB) & MAC_PCU_TSF1_STATUS_U32_VALUE_MASK)

#define MAC_PCU_TSF2_STATUS_L32_ADDRESS          0x000083ac
#define MAC_PCU_TSF2_STATUS_L32_OFFSET           0x000003ac
#define MAC_PCU_TSF2_STATUS_L32_VALUE_MSB        31
#define MAC_PCU_TSF2_STATUS_L32_VALUE_LSB        0
#define MAC_PCU_TSF2_STATUS_L32_VALUE_MASK       0xffffffff
#define MAC_PCU_TSF2_STATUS_L32_VALUE_GET(x)     (((x) & MAC_PCU_TSF2_STATUS_L32_VALUE_MASK) >> MAC_PCU_TSF2_STATUS_L32_VALUE_LSB)
#define MAC_PCU_TSF2_STATUS_L32_VALUE_SET(x)     (((x) << MAC_PCU_TSF2_STATUS_L32_VALUE_LSB) & MAC_PCU_TSF2_STATUS_L32_VALUE_MASK)

#define MAC_PCU_TSF2_STATUS_U32_ADDRESS          0x000083b0
#define MAC_PCU_TSF2_STATUS_U32_OFFSET           0x000003b0
#define MAC_PCU_TSF2_STATUS_U32_VALUE_MSB        31
#define MAC_PCU_TSF2_STATUS_U32_VALUE_LSB        0
#define MAC_PCU_TSF2_STATUS_U32_VALUE_MASK       0xffffffff
#define MAC_PCU_TSF2_STATUS_U32_VALUE_GET(x)     (((x) & MAC_PCU_TSF2_STATUS_U32_VALUE_MASK) >> MAC_PCU_TSF2_STATUS_U32_VALUE_LSB)
#define MAC_PCU_TSF2_STATUS_U32_VALUE_SET(x)     (((x) << MAC_PCU_TSF2_STATUS_U32_VALUE_LSB) & MAC_PCU_TSF2_STATUS_U32_VALUE_MASK)

#define MAC_PCU_TXBUF_BA_ADDRESS                 0x00008400
#define MAC_PCU_TXBUF_BA_OFFSET                  0x00000400
#define MAC_PCU_TXBUF_BA_DATA_MSB                31
#define MAC_PCU_TXBUF_BA_DATA_LSB                0
#define MAC_PCU_TXBUF_BA_DATA_MASK               0xffffffff
#define MAC_PCU_TXBUF_BA_DATA_GET(x)             (((x) & MAC_PCU_TXBUF_BA_DATA_MASK) >> MAC_PCU_TXBUF_BA_DATA_LSB)
#define MAC_PCU_TXBUF_BA_DATA_SET(x)             (((x) << MAC_PCU_TXBUF_BA_DATA_LSB) & MAC_PCU_TXBUF_BA_DATA_MASK)

#define MAC_PCU_KEY_CACHE_1_ADDRESS              0x00008800
#define MAC_PCU_KEY_CACHE_1_OFFSET               0x00000800
#define MAC_PCU_KEY_CACHE_1_DATA_MSB             31
#define MAC_PCU_KEY_CACHE_1_DATA_LSB             0
#define MAC_PCU_KEY_CACHE_1_DATA_MASK            0xffffffff
#define MAC_PCU_KEY_CACHE_1_DATA_GET(x)          (((x) & MAC_PCU_KEY_CACHE_1_DATA_MASK) >> MAC_PCU_KEY_CACHE_1_DATA_LSB)
#define MAC_PCU_KEY_CACHE_1_DATA_SET(x)          (((x) << MAC_PCU_KEY_CACHE_1_DATA_LSB) & MAC_PCU_KEY_CACHE_1_DATA_MASK)

#define MAC_PCU_BASEBAND_0_ADDRESS               0x00009800
#define MAC_PCU_BASEBAND_0_OFFSET                0x00001800
#define MAC_PCU_BASEBAND_0_DATA_MSB              31
#define MAC_PCU_BASEBAND_0_DATA_LSB              0
#define MAC_PCU_BASEBAND_0_DATA_MASK             0xffffffff
#define MAC_PCU_BASEBAND_0_DATA_GET(x)           (((x) & MAC_PCU_BASEBAND_0_DATA_MASK) >> MAC_PCU_BASEBAND_0_DATA_LSB)
#define MAC_PCU_BASEBAND_0_DATA_SET(x)           (((x) << MAC_PCU_BASEBAND_0_DATA_LSB) & MAC_PCU_BASEBAND_0_DATA_MASK)

#define MAC_PCU_BASEBAND_1_ADDRESS               0x0000a000
#define MAC_PCU_BASEBAND_1_OFFSET                0x00002000
#define MAC_PCU_BASEBAND_1_DATA_MSB              31
#define MAC_PCU_BASEBAND_1_DATA_LSB              0
#define MAC_PCU_BASEBAND_1_DATA_MASK             0xffffffff
#define MAC_PCU_BASEBAND_1_DATA_GET(x)           (((x) & MAC_PCU_BASEBAND_1_DATA_MASK) >> MAC_PCU_BASEBAND_1_DATA_LSB)
#define MAC_PCU_BASEBAND_1_DATA_SET(x)           (((x) << MAC_PCU_BASEBAND_1_DATA_LSB) & MAC_PCU_BASEBAND_1_DATA_MASK)

#define MAC_PCU_BASEBAND_2_ADDRESS               0x0000c000
#define MAC_PCU_BASEBAND_2_OFFSET                0x00004000
#define MAC_PCU_BASEBAND_2_DATA_MSB              31
#define MAC_PCU_BASEBAND_2_DATA_LSB              0
#define MAC_PCU_BASEBAND_2_DATA_MASK             0xffffffff
#define MAC_PCU_BASEBAND_2_DATA_GET(x)           (((x) & MAC_PCU_BASEBAND_2_DATA_MASK) >> MAC_PCU_BASEBAND_2_DATA_LSB)
#define MAC_PCU_BASEBAND_2_DATA_SET(x)           (((x) << MAC_PCU_BASEBAND_2_DATA_LSB) & MAC_PCU_BASEBAND_2_DATA_MASK)

#define MAC_PCU_BASEBAND_3_ADDRESS               0x0000d000
#define MAC_PCU_BASEBAND_3_OFFSET                0x00005000
#define MAC_PCU_BASEBAND_3_DATA_MSB              31
#define MAC_PCU_BASEBAND_3_DATA_LSB              0
#define MAC_PCU_BASEBAND_3_DATA_MASK             0xffffffff
#define MAC_PCU_BASEBAND_3_DATA_GET(x)           (((x) & MAC_PCU_BASEBAND_3_DATA_MASK) >> MAC_PCU_BASEBAND_3_DATA_LSB)
#define MAC_PCU_BASEBAND_3_DATA_SET(x)           (((x) << MAC_PCU_BASEBAND_3_DATA_LSB) & MAC_PCU_BASEBAND_3_DATA_MASK)

#define MAC_PCU_BUF_ADDRESS                      0x0000e000
#define MAC_PCU_BUF_OFFSET                       0x00006000
#define MAC_PCU_BUF_DATA_MSB                     31
#define MAC_PCU_BUF_DATA_LSB                     0
#define MAC_PCU_BUF_DATA_MASK                    0xffffffff
#define MAC_PCU_BUF_DATA_GET(x)                  (((x) & MAC_PCU_BUF_DATA_MASK) >> MAC_PCU_BUF_DATA_LSB)
#define MAC_PCU_BUF_DATA_SET(x)                  (((x) << MAC_PCU_BUF_DATA_LSB) & MAC_PCU_BUF_DATA_MASK)


#ifndef __ASSEMBLER__

typedef struct mac_pcu_reg_s {
  volatile unsigned int mac_pcu_sta_addr_l32;
  volatile unsigned int mac_pcu_sta_addr_u16;
  volatile unsigned int mac_pcu_bssid_l32;
  volatile unsigned int mac_pcu_bssid_u16;
  volatile unsigned int mac_pcu_bcn_rssi_ave;
  volatile unsigned int mac_pcu_ack_cts_timeout;
  volatile unsigned int mac_pcu_bcn_rssi_ctl;
  volatile unsigned int mac_pcu_usec_latency;
  volatile unsigned int pcu_max_cfp_dur;
  volatile unsigned int mac_pcu_rx_filter;
  volatile unsigned int mac_pcu_mcast_filter_l32;
  volatile unsigned int mac_pcu_mcast_filter_u32;
  volatile unsigned int mac_pcu_diag_sw;
  volatile unsigned int mac_pcu_tst_addac;
  volatile unsigned int mac_pcu_def_antenna;
  volatile unsigned int mac_pcu_aes_mute_mask_0;
  volatile unsigned int mac_pcu_aes_mute_mask_1;
  volatile unsigned int mac_pcu_gated_clks;
  volatile unsigned int mac_pcu_obs_bus_2;
  volatile unsigned int mac_pcu_obs_bus_1;
  volatile unsigned int mac_pcu_dym_mimo_pwr_save;
  volatile unsigned int mac_pcu_last_beacon_tsf;
  volatile unsigned int mac_pcu_nav;
  volatile unsigned int mac_pcu_rts_success_cnt;
  volatile unsigned int mac_pcu_rts_fail_cnt;
  volatile unsigned int mac_pcu_ack_fail_cnt;
  volatile unsigned int mac_pcu_fcs_fail_cnt;
  volatile unsigned int mac_pcu_beacon_cnt;
  volatile unsigned int mac_pcu_xrmode;
  volatile unsigned int mac_pcu_xrdel;
  volatile unsigned int mac_pcu_xrto;
  volatile unsigned int mac_pcu_xrcrp;
  volatile unsigned int mac_pcu_xrstmp;
  volatile unsigned int mac_pcu_addr1_mask_l32;
  volatile unsigned int mac_pcu_addr1_mask_u16;
  volatile unsigned int mac_pcu_tpc;
  volatile unsigned int mac_pcu_tx_frame_cnt;
  volatile unsigned int mac_pcu_rx_frame_cnt;
  volatile unsigned int mac_pcu_rx_clear_cnt;
  volatile unsigned int mac_pcu_cycle_cnt;
  volatile unsigned int mac_pcu_quiet_time_1;
  volatile unsigned int mac_pcu_quiet_time_2;
  volatile unsigned int mac_pcu_qos_no_ack;
  volatile unsigned int mac_pcu_phy_error_mask;
  volatile unsigned int mac_pcu_xrlat;
  volatile unsigned int mac_pcu_rxbuf;
  volatile unsigned int mac_pcu_mic_qos_control;
  volatile unsigned int mac_pcu_mic_qos_select;
  volatile unsigned int mac_pcu_misc_mode;
  volatile unsigned int mac_pcu_filter_ofdm_cnt;
  volatile unsigned int mac_pcu_filter_cck_cnt;
  volatile unsigned int mac_pcu_phy_err_cnt_1;
  volatile unsigned int mac_pcu_phy_err_cnt_1_mask;
  volatile unsigned int mac_pcu_phy_err_cnt_2;
  volatile unsigned int mac_pcu_phy_err_cnt_2_mask;
  volatile unsigned int mac_pcu_tsf_threshold;
  volatile unsigned int mac_pcu_phy_error_eifs_mask;
  volatile unsigned int mac_pcu_phy_err_cnt_3;
  volatile unsigned int mac_pcu_phy_err_cnt_3_mask;
  volatile unsigned int mac_pcu_bluetooth_mode;
  volatile unsigned int mac_pcu_bluetooth_weights;
  volatile unsigned int mac_pcu_bluetooth_mode2;
  volatile unsigned int mac_pcu_txsifs;
  volatile unsigned int mac_pcu_txop_x;
  volatile unsigned int mac_pcu_txop_0_3;
  volatile unsigned int mac_pcu_txop_4_7;
  volatile unsigned int mac_pcu_txop_8_11;
  volatile unsigned int mac_pcu_txop_12_15;
  volatile unsigned int mac_pcu_logic_analyzer;
  volatile unsigned int mac_pcu_logic_analyzer_32l;
  volatile unsigned int mac_pcu_logic_analyzer_16u;
  volatile unsigned int mac_pcu_phy_err_cnt_mask_cont;
  volatile unsigned int mac_pcu_azimuth_mode;
  volatile unsigned int mac_pcu_20_40_mode;
  volatile unsigned int mac_pcu_rx_clear_diff_cnt;
  volatile unsigned int mac_pcu_self_gen_antenna_mask;
  volatile unsigned int mac_pcu_ba_bar_control;
  volatile unsigned int mac_pcu_legacy_plcp_spoof;
  volatile unsigned int mac_pcu_phy_error_mask_cont;
  volatile unsigned int mac_pcu_tx_timer;
  volatile unsigned int mac_pcu_txbuf_ctrl;
  volatile unsigned int mac_pcu_misc_mode2;
  volatile unsigned int mac_pcu_alt_aes_mute_mask;
  volatile unsigned int mac_pcu_azimuth_time_stamp;
  volatile unsigned int mac_pcu_max_cfp_dur;
  volatile unsigned int mac_pcu_hcf_timeout;
  volatile unsigned int mac_pcu_bluetooth_weights2;
  volatile unsigned int mac_pcu_bluetooth_tsf_bt_active;
  volatile unsigned int mac_pcu_bluetooth_tsf_bt_priority;
  volatile unsigned int mac_pcu_bluetooth_mode3;
  volatile unsigned int mac_pcu_bluetooth_mode4;
  unsigned char pad0[148]; /* pad to 0x200 */
  volatile unsigned int mac_pcu_bt_bt[64];
  volatile unsigned int mac_pcu_bt_bt_async;
  volatile unsigned int mac_pcu_bt_wl_1;
  volatile unsigned int mac_pcu_bt_wl_2;
  volatile unsigned int mac_pcu_bt_wl_3;
  volatile unsigned int mac_pcu_bt_wl_4;
  volatile unsigned int mac_pcu_coex_epta;
  volatile unsigned int mac_pcu_coex_lnamaxgain1;
  volatile unsigned int mac_pcu_coex_lnamaxgain2;
  volatile unsigned int mac_pcu_coex_lnamaxgain3;
  volatile unsigned int mac_pcu_coex_lnamaxgain4;
  volatile unsigned int mac_pcu_basic_rate_set0;
  volatile unsigned int mac_pcu_basic_rate_set1;
  volatile unsigned int mac_pcu_basic_rate_set2;
  volatile unsigned int mac_pcu_basic_rate_set3;
  volatile unsigned int mac_pcu_rx_int_status0;
  volatile unsigned int mac_pcu_rx_int_status1;
  volatile unsigned int mac_pcu_rx_int_status2;
  volatile unsigned int mac_pcu_rx_int_status3;
  volatile unsigned int ht_half_gi_rate1;
  volatile unsigned int ht_half_gi_rate2;
  volatile unsigned int ht_full_gi_rate1;
  volatile unsigned int ht_full_gi_rate2;
  volatile unsigned int legacy_rate1;
  volatile unsigned int legacy_rate2;
  volatile unsigned int legacy_rate3;
  volatile unsigned int rx_int_filter;
  volatile unsigned int rx_int_overflow;
  volatile unsigned int rx_filter_thresh;
  volatile unsigned int rx_filter_thresh1;
  volatile unsigned int rx_priority_thresh0;
  volatile unsigned int rx_priority_thresh1;
  volatile unsigned int rx_priority_thresh2;
  volatile unsigned int rx_priority_thresh3;
  volatile unsigned int rx_priority_offset0;
  volatile unsigned int rx_priority_offset1;
  volatile unsigned int rx_priority_offset2;
  volatile unsigned int rx_priority_offset3;
  volatile unsigned int rx_priority_offset4;
  volatile unsigned int rx_priority_offset5;
  volatile unsigned int mac_pcu_bssid2_l32;
  volatile unsigned int mac_pcu_bssid2_u16;
  volatile unsigned int mac_pcu_tsf1_status_l32;
  volatile unsigned int mac_pcu_tsf1_status_u32;
  volatile unsigned int mac_pcu_tsf2_status_l32;
  volatile unsigned int mac_pcu_tsf2_status_u32;
  unsigned char pad1[76]; /* pad to 0x400 */
  volatile unsigned int mac_pcu_txbuf_ba[64];
  unsigned char pad2[768]; /* pad to 0x800 */
  volatile unsigned int mac_pcu_key_cache_1[256];
  unsigned char pad3[3072]; /* pad to 0x1800 */
  volatile unsigned int mac_pcu_baseband_0[512];
  volatile unsigned int mac_pcu_baseband_1[2048];
  volatile unsigned int mac_pcu_baseband_2[1024];
  volatile unsigned int mac_pcu_baseband_3[1024];
  volatile unsigned int mac_pcu_buf[512];
} mac_pcu_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _MAC_PCU_H_ */
