/*
 * Copyright 2008-2010 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
#ifndef DCP_H_
#define DCP_H_

#define CIPHER_CHAN	1
#define CIPHER_MASK	(1 << CIPHER_CHAN)

#define HASH_CHAN	0
#define HASH_MASK	(1 << HASH_CHAN)

/* DCP boostream interface uses this channel (same as the ROM) */
#define ROM_DCP_CHAN 3
#define ROM_DCP_CHAN_MASK (1 << ROM_DCP_CHAN)


#define ALL_MASK	(CIPHER_MASK | HASH_MASK | ROM_DCP_CHAN_MASK)

/* Defines the initialization value for the dcp control register */
#define DCP_CTRL_INIT \
   (BM_DCP_CTRL_GATHER_RESIDUAL_WRITES | \
    BM_DCP_CTRL_ENABLE_CONTEXT_CACHING | \
    BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH0 | \
    BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH1 | \
    BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH2 | \
    BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH3)

/* Defines the initialization value for the dcp channel control register */
#define DCP_CHANNELCTRL_INIT \
    BF(ALL_MASK, DCP_CHANNELCTRL_ENABLE_CHANNEL)

/* DCP work packet 1 value for encryption */
#define DCP_PKT1_ENCRYPT \
   (BM_DCP_PACKET1_DECR_SEMAPHORE | \
    BM_DCP_PACKET1_ENABLE_CIPHER | \
    BM_DCP_PACKET1_CIPHER_ENCRYPT | \
    BM_DCP_PACKET1_CIPHER_INIT)

/* DCP work packet 1 value for decryption */
#define DCP_PKT1_DECRYPT \
   (BM_DCP_PACKET1_DECR_SEMAPHORE | \
    BM_DCP_PACKET1_ENABLE_CIPHER | \
    BM_DCP_PACKET1_CIPHER_INIT)

/* DCP (decryption) work packet definition */
struct dcp_hw_packet {
	uint32_t pNext;     /* next dcp work packet address */
	uint32_t pkt1;      /* dcp work packet 1 (control 0) */
	uint32_t pkt2;      /* dcp work packet 2 (control 1) */
	uint32_t pSrc;      /* source buffer address */
	uint32_t pDst;      /* destination buffer address */
	uint32_t size;      /* buffer size in bytes */
	uint32_t pPayload;  /* payload buffer address */
	uint32_t stat;      /* dcp status (written by dcp) */
};

#define DCP_NUM_CHANNELS 4

/* DCP Register definitions */

#ifndef BF
#define BF(value, field) (((value) << BP_##field) & BM_##field)
#endif

#define REGS_DCP_SIZE 0x00002000

#define HW_DCP_CTRL	(0x00000000)
#define HW_DCP_CTRL_SET	(0x00000004)
#define HW_DCP_CTRL_CLR	(0x00000008)
#define HW_DCP_CTRL_TOG	(0x0000000c)

#define BM_DCP_CTRL_SFTRST	0x80000000
#define BM_DCP_CTRL_CLKGATE	0x40000000
#define BM_DCP_CTRL_PRESENT_CRYPTO	0x20000000
#define BV_DCP_CTRL_PRESENT_CRYPTO__Present 0x1
#define BV_DCP_CTRL_PRESENT_CRYPTO__Absent  0x0
#define BM_DCP_CTRL_PRESENT_CSC	0x10000000
#define BV_DCP_CTRL_PRESENT_CSC__Present 0x1
#define BV_DCP_CTRL_PRESENT_CSC__Absent  0x0
#define BP_DCP_CTRL_RSVD1	24
#define BM_DCP_CTRL_RSVD1	0x0F000000
#define BF_DCP_CTRL_RSVD1(v)  \
		(((v) << 24) & BM_DCP_CTRL_RSVD1)
#define BM_DCP_CTRL_GATHER_RESIDUAL_WRITES	0x00800000
#define BM_DCP_CTRL_ENABLE_CONTEXT_CACHING	0x00400000
#define BM_DCP_CTRL_ENABLE_CONTEXT_SWITCHING	0x00200000
#define BP_DCP_CTRL_RSVD0	9
#define BM_DCP_CTRL_RSVD0	0x001FFE00
#define BF_DCP_CTRL_RSVD0(v)  \
		(((v) << 9) & BM_DCP_CTRL_RSVD0)
#define BM_DCP_CTRL_CSC_INTERRUPT_ENABLE	0x00000100
#define BP_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE	0
#define BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE	0x000000FF
#define BF_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(v)  \
		(((v) << 0) & BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE)
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH0 0x01
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH1 0x02
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH2 0x04
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH3 0x08

#define HW_DCP_STAT	(0x00000010)
#define HW_DCP_STAT_SET	(0x00000014)
#define HW_DCP_STAT_CLR	(0x00000018)
#define HW_DCP_STAT_TOG	(0x0000001c)

#define BP_DCP_STAT_RSVD2	29
#define BM_DCP_STAT_RSVD2	0xE0000000
#define BF_DCP_STAT_RSVD2(v) \
		(((v) << 29) & BM_DCP_STAT_RSVD2)
#define BM_DCP_STAT_OTP_KEY_READY	0x10000000
#define BP_DCP_STAT_CUR_CHANNEL	24
#define BM_DCP_STAT_CUR_CHANNEL	0x0F000000
#define BF_DCP_STAT_CUR_CHANNEL(v)  \
		(((v) << 24) & BM_DCP_STAT_CUR_CHANNEL)
#define BV_DCP_STAT_CUR_CHANNEL__None 0x0
#define BV_DCP_STAT_CUR_CHANNEL__CH0  0x1
#define BV_DCP_STAT_CUR_CHANNEL__CH1  0x2
#define BV_DCP_STAT_CUR_CHANNEL__CH2  0x3
#define BV_DCP_STAT_CUR_CHANNEL__CH3  0x4
#define BV_DCP_STAT_CUR_CHANNEL__CSC  0x8
#define BP_DCP_STAT_READY_CHANNELS	16
#define BM_DCP_STAT_READY_CHANNELS	0x00FF0000
#define BF_DCP_STAT_READY_CHANNELS(v)  \
		(((v) << 16) & BM_DCP_STAT_READY_CHANNELS)
#define BV_DCP_STAT_READY_CHANNELS__CH0 0x01
#define BV_DCP_STAT_READY_CHANNELS__CH1 0x02
#define BV_DCP_STAT_READY_CHANNELS__CH2 0x04
#define BV_DCP_STAT_READY_CHANNELS__CH3 0x08
#define BP_DCP_STAT_RSVD1	9
#define BM_DCP_STAT_RSVD1	0x0000FE00
#define BF_DCP_STAT_RSVD1(v)  \
		(((v) << 9) & BM_DCP_STAT_RSVD1)
#define BM_DCP_STAT_CSCIRQ	0x00000100
#define BP_DCP_STAT_RSVD0	4
#define BM_DCP_STAT_RSVD0	0x000000F0
#define BF_DCP_STAT_RSVD0(v)  \
		(((v) << 4) & BM_DCP_STAT_RSVD0)
#define BP_DCP_STAT_IRQ	0
#define BM_DCP_STAT_IRQ	0x0000000F
#define BF_DCP_STAT_IRQ(v)  \
		(((v) << 0) & BM_DCP_STAT_IRQ)

#define HW_DCP_CHANNELCTRL	(0x00000020)
#define HW_DCP_CHANNELCTRL_SET	(0x00000024)
#define HW_DCP_CHANNELCTRL_CLR	(0x00000028)
#define HW_DCP_CHANNELCTRL_TOG	(0x0000002c)

#define BP_DCP_CHANNELCTRL_RSVD	19
#define BM_DCP_CHANNELCTRL_RSVD	0xFFF80000
#define BF_DCP_CHANNELCTRL_RSVD(v) \
		(((v) << 19) & BM_DCP_CHANNELCTRL_RSVD)
#define BP_DCP_CHANNELCTRL_CSC_PRIORITY	17
#define BM_DCP_CHANNELCTRL_CSC_PRIORITY	0x00060000
#define BF_DCP_CHANNELCTRL_CSC_PRIORITY(v)  \
		(((v) << 17) & BM_DCP_CHANNELCTRL_CSC_PRIORITY)
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__HIGH       0x3
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__MED        0x2
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__LOW        0x1
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__BACKGROUND 0x0
#define BM_DCP_CHANNELCTRL_CH0_IRQ_MERGED	0x00010000
#define BP_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL	8
#define BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL	0x0000FF00
#define BF_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(v)  \
		(((v) << 8) & BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL)
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH0 0x01
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH1 0x02
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH2 0x04
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH3 0x08
#define BP_DCP_CHANNELCTRL_ENABLE_CHANNEL	0
#define BM_DCP_CHANNELCTRL_ENABLE_CHANNEL	0x000000FF
#define BF_DCP_CHANNELCTRL_ENABLE_CHANNEL(v)  \
		(((v) << 0) & BM_DCP_CHANNELCTRL_ENABLE_CHANNEL)
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH0 0x01
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH1 0x02
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH2 0x04
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH3 0x08

#define HW_DCP_CAPABILITY0	(0x00000030)

#define BM_DCP_CAPABILITY0_DISABLE_DECRYPT	0x80000000
#define BM_DCP_CAPABILITY0_ENABLE_TZONE	0x40000000
#define BP_DCP_CAPABILITY0_RSVD	12
#define BM_DCP_CAPABILITY0_RSVD	0x3FFFF000
#define BF_DCP_CAPABILITY0_RSVD(v)  \
		(((v) << 12) & BM_DCP_CAPABILITY0_RSVD)
#define BP_DCP_CAPABILITY0_NUM_CHANNELS	8
#define BM_DCP_CAPABILITY0_NUM_CHANNELS	0x00000F00
#define BF_DCP_CAPABILITY0_NUM_CHANNELS(v)  \
		(((v) << 8) & BM_DCP_CAPABILITY0_NUM_CHANNELS)
#define BP_DCP_CAPABILITY0_NUM_KEYS	0
#define BM_DCP_CAPABILITY0_NUM_KEYS	0x000000FF
#define BF_DCP_CAPABILITY0_NUM_KEYS(v)  \
		(((v) << 0) & BM_DCP_CAPABILITY0_NUM_KEYS)

#define HW_DCP_CAPABILITY1	(0x00000040)

#define BP_DCP_CAPABILITY1_HASH_ALGORITHMS	16
#define BM_DCP_CAPABILITY1_HASH_ALGORITHMS	0xFFFF0000
#define BF_DCP_CAPABILITY1_HASH_ALGORITHMS(v) \
		(((v) << 16) & BM_DCP_CAPABILITY1_HASH_ALGORITHMS)
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS__SHA1  0x0001
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS__CRC32 0x0002
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS__SHA256  0x0004
#define BP_DCP_CAPABILITY1_CIPHER_ALGORITHMS	0
#define BM_DCP_CAPABILITY1_CIPHER_ALGORITHMS	0x0000FFFF
#define BF_DCP_CAPABILITY1_CIPHER_ALGORITHMS(v)  \
		(((v) << 0) & BM_DCP_CAPABILITY1_CIPHER_ALGORITHMS)
#define BV_DCP_CAPABILITY1_CIPHER_ALGORITHMS__AES128 0x0001

#define HW_DCP_CONTEXT	(0x00000050)

#define BP_DCP_CONTEXT_ADDR	0
#define BM_DCP_CONTEXT_ADDR	0xFFFFFFFF
#define BF_DCP_CONTEXT_ADDR(v)	(v)

#define HW_DCP_KEY	(0x00000060)

#define BP_DCP_KEY_RSVD	8
#define BM_DCP_KEY_RSVD	0xFFFFFF00
#define BF_DCP_KEY_RSVD(v) \
		(((v) << 8) & BM_DCP_KEY_RSVD)
#define BP_DCP_KEY_RSVD_INDEX	6
#define BM_DCP_KEY_RSVD_INDEX	0x000000C0
#define BF_DCP_KEY_RSVD_INDEX(v)  \
		(((v) << 6) & BM_DCP_KEY_RSVD_INDEX)
#define BP_DCP_KEY_INDEX	4
#define BM_DCP_KEY_INDEX	0x00000030
#define BF_DCP_KEY_INDEX(v)  \
		(((v) << 4) & BM_DCP_KEY_INDEX)
#define BP_DCP_KEY_RSVD_SUBWORD	2
#define BM_DCP_KEY_RSVD_SUBWORD	0x0000000C
#define BF_DCP_KEY_RSVD_SUBWORD(v)  \
		(((v) << 2) & BM_DCP_KEY_RSVD_SUBWORD)
#define BP_DCP_KEY_SUBWORD	0
#define BM_DCP_KEY_SUBWORD	0x00000003
#define BF_DCP_KEY_SUBWORD(v)  \
		(((v) << 0) & BM_DCP_KEY_SUBWORD)

#define HW_DCP_KEYDATA	(0x00000070)

#define BP_DCP_KEYDATA_DATA	0
#define BM_DCP_KEYDATA_DATA	0xFFFFFFFF
#define BF_DCP_KEYDATA_DATA(v)	(v)

#define HW_DCP_PACKET0	(0x00000080)

#define BP_DCP_PACKET0_ADDR	0
#define BM_DCP_PACKET0_ADDR	0xFFFFFFFF
#define BF_DCP_PACKET0_ADDR(v)	(v)

#define HW_DCP_PACKET1	(0x00000090)

#define BP_DCP_PACKET1_TAG	24
#define BM_DCP_PACKET1_TAG	0xFF000000
#define BF_DCP_PACKET1_TAG(v) \
		(((v) << 24) & BM_DCP_PACKET1_TAG)
#define BM_DCP_PACKET1_OUTPUT_WORDSWAP	0x00800000
#define BM_DCP_PACKET1_OUTPUT_BYTESWAP	0x00400000
#define BM_DCP_PACKET1_INPUT_WORDSWAP	0x00200000
#define BM_DCP_PACKET1_INPUT_BYTESWAP	0x00100000
#define BM_DCP_PACKET1_KEY_WORDSWAP	0x00080000
#define BM_DCP_PACKET1_KEY_BYTESWAP	0x00040000
#define BM_DCP_PACKET1_TEST_SEMA_IRQ	0x00020000
#define BM_DCP_PACKET1_CONSTANT_FILL	0x00010000
#define BM_DCP_PACKET1_HASH_OUTPUT	0x00008000
#define BV_DCP_PACKET1_HASH_OUTPUT__INPUT  0x00
#define BV_DCP_PACKET1_HASH_OUTPUT__OUTPUT 0x01
#define BM_DCP_PACKET1_CHECK_HASH	0x00004000
#define BM_DCP_PACKET1_HASH_TERM	0x00002000
#define BM_DCP_PACKET1_HASH_INIT	0x00001000
#define BM_DCP_PACKET1_PAYLOAD_KEY	0x00000800
#define BM_DCP_PACKET1_OTP_KEY	0x00000400
#define BM_DCP_PACKET1_CIPHER_INIT	0x00000200
#define BM_DCP_PACKET1_CIPHER_ENCRYPT	0x00000100
#define BV_DCP_PACKET1_CIPHER_ENCRYPT__ENCRYPT 0x01
#define BV_DCP_PACKET1_CIPHER_ENCRYPT__DECRYPT 0x00
#define BM_DCP_PACKET1_ENABLE_BLIT	0x00000080
#define BM_DCP_PACKET1_ENABLE_HASH	0x00000040
#define BM_DCP_PACKET1_ENABLE_CIPHER	0x00000020
#define BM_DCP_PACKET1_ENABLE_MEMCOPY	0x00000010
#define BM_DCP_PACKET1_CHAIN_CONTIGUOUS	0x00000008
#define BM_DCP_PACKET1_CHAIN	0x00000004
#define BM_DCP_PACKET1_DECR_SEMAPHORE	0x00000002
#define BM_DCP_PACKET1_INTERRUPT	0x00000001

#define HW_DCP_PACKET2	(0x000000a0)

#define BP_DCP_PACKET2_CIPHER_CFG	24
#define BM_DCP_PACKET2_CIPHER_CFG	0xFF000000
#define BF_DCP_PACKET2_CIPHER_CFG(v) \
		(((v) << 24) & BM_DCP_PACKET2_CIPHER_CFG)
#define BP_DCP_PACKET2_RSVD	20
#define BM_DCP_PACKET2_RSVD	0x00F00000
#define BF_DCP_PACKET2_RSVD(v)  \
		(((v) << 20) & BM_DCP_PACKET2_RSVD)
#define BP_DCP_PACKET2_HASH_SELECT	16
#define BM_DCP_PACKET2_HASH_SELECT	0x000F0000
#define BF_DCP_PACKET2_HASH_SELECT(v)  \
		(((v) << 16) & BM_DCP_PACKET2_HASH_SELECT)
#define BV_DCP_PACKET2_HASH_SELECT__SHA1  0x00
#define BV_DCP_PACKET2_HASH_SELECT__CRC32 0x01
#define BV_DCP_PACKET2_HASH_SELECT__SHA256  0x02
#define BP_DCP_PACKET2_KEY_SELECT	8
#define BM_DCP_PACKET2_KEY_SELECT	0x0000FF00
#define BF_DCP_PACKET2_KEY_SELECT(v)  \
		(((v) << 8) & BM_DCP_PACKET2_KEY_SELECT)
#define BP_DCP_PACKET2_CIPHER_MODE	4
#define BM_DCP_PACKET2_CIPHER_MODE	0x000000F0
#define BF_DCP_PACKET2_CIPHER_MODE(v)  \
		(((v) << 4) & BM_DCP_PACKET2_CIPHER_MODE)
#define BV_DCP_PACKET2_CIPHER_MODE__ECB 0x00
#define BV_DCP_PACKET2_CIPHER_MODE__CBC 0x01
#define BP_DCP_PACKET2_CIPHER_SELECT	0
#define BM_DCP_PACKET2_CIPHER_SELECT	0x0000000F
#define BF_DCP_PACKET2_CIPHER_SELECT(v)  \
		(((v) << 0) & BM_DCP_PACKET2_CIPHER_SELECT)
#define BV_DCP_PACKET2_CIPHER_SELECT__AES128 0x00

#define HW_DCP_PACKET3	(0x000000b0)

#define BP_DCP_PACKET3_ADDR	0
#define BM_DCP_PACKET3_ADDR	0xFFFFFFFF
#define BF_DCP_PACKET3_ADDR(v)	(v)

#define HW_DCP_PACKET4	(0x000000c0)

#define BP_DCP_PACKET4_ADDR	0
#define BM_DCP_PACKET4_ADDR	0xFFFFFFFF
#define BF_DCP_PACKET4_ADDR(v)	(v)

#define HW_DCP_PACKET5	(0x000000d0)

#define BP_DCP_PACKET5_COUNT	0
#define BM_DCP_PACKET5_COUNT	0xFFFFFFFF
#define BF_DCP_PACKET5_COUNT(v)	(v)

#define HW_DCP_PACKET6	(0x000000e0)

#define BP_DCP_PACKET6_ADDR	0
#define BM_DCP_PACKET6_ADDR	0xFFFFFFFF
#define BF_DCP_PACKET6_ADDR(v)	(v)

/*
 *  multi-register-define name HW_DCP_CHnCMDPTR
 *              base 0x00000100
 *              count 4
 *              offset 0x40
 */
#define HW_DCP_CHnCMDPTR(n)	(0x00000100 + (n) * 0x40)

#define BP_DCP_CHnCMDPTR_ADDR	0
#define BM_DCP_CHnCMDPTR_ADDR	0xFFFFFFFF
#define BF_DCP_CHnCMDPTR_ADDR(v)	(v)

/*
 *  multi-register-define name HW_DCP_CHnSEMA
 *              base 0x00000110
 *              count 4
 *              offset 0x40
 */
#define HW_DCP_CHnSEMA(n)	(0x00000110 + (n) * 0x40)

#define BP_DCP_CHnSEMA_RSVD2	24
#define BM_DCP_CHnSEMA_RSVD2	0xFF000000
#define BF_DCP_CHnSEMA_RSVD2(v) \
		(((v) << 24) & BM_DCP_CHnSEMA_RSVD2)
#define BP_DCP_CHnSEMA_VALUE	16
#define BM_DCP_CHnSEMA_VALUE	0x00FF0000
#define BF_DCP_CHnSEMA_VALUE(v)  \
		(((v) << 16) & BM_DCP_CHnSEMA_VALUE)
#define BP_DCP_CHnSEMA_RSVD1	8
#define BM_DCP_CHnSEMA_RSVD1	0x0000FF00
#define BF_DCP_CHnSEMA_RSVD1(v)  \
		(((v) << 8) & BM_DCP_CHnSEMA_RSVD1)
#define BP_DCP_CHnSEMA_INCREMENT	0
#define BM_DCP_CHnSEMA_INCREMENT	0x000000FF
#define BF_DCP_CHnSEMA_INCREMENT(v)  \
		(((v) << 0) & BM_DCP_CHnSEMA_INCREMENT)

/*
 *  multi-register-define name HW_DCP_CHnSTAT
 *              base 0x00000120
 *              count 4
 *              offset 0x40
 */
#define HW_DCP_CHnSTAT(n)	(0x00000120 + (n) * 0x40)
#define HW_DCP_CHnSTAT_SET(n)	(0x00000124 + (n) * 0x40)
#define HW_DCP_CHnSTAT_CLR(n)	(0x00000128 + (n) * 0x40)
#define HW_DCP_CHnSTAT_TOG(n)	(0x0000012c + (n) * 0x40)

#define BP_DCP_CHnSTAT_TAG	24
#define BM_DCP_CHnSTAT_TAG	0xFF000000
#define BF_DCP_CHnSTAT_TAG(v) \
		(((v) << 24) & BM_DCP_CHnSTAT_TAG)
#define BP_DCP_CHnSTAT_ERROR_CODE	16
#define BM_DCP_CHnSTAT_ERROR_CODE	0x00FF0000
#define BF_DCP_CHnSTAT_ERROR_CODE(v)  \
		(((v) << 16) & BM_DCP_CHnSTAT_ERROR_CODE)
#define BV_DCP_CHnSTAT_ERROR_CODE__NEXT_CHAIN_IS_0 0x01
#define BV_DCP_CHnSTAT_ERROR_CODE__NO_CHAIN        0x02
#define BV_DCP_CHnSTAT_ERROR_CODE__CONTEXT_ERROR   0x03
#define BV_DCP_CHnSTAT_ERROR_CODE__PAYLOAD_ERROR   0x04
#define BV_DCP_CHnSTAT_ERROR_CODE__INVALID_MODE    0x05
#define BP_DCP_CHnSTAT_RSVD0	7
#define BM_DCP_CHnSTAT_RSVD0	0x0000FF80
#define BF_DCP_CHnSTAT_RSVD0(v)  \
		(((v) << 7) & BM_DCP_CHnSTAT_RSVD0)
#define BM_DCP_CHnSTAT_ERROR_PAGEFAULT	0x00000040
#define BM_DCP_CHnSTAT_ERROR_DST	0x00000020
#define BM_DCP_CHnSTAT_ERROR_SRC	0x00000010
#define BM_DCP_CHnSTAT_ERROR_PACKET	0x00000008
#define BM_DCP_CHnSTAT_ERROR_SETUP	0x00000004
#define BM_DCP_CHnSTAT_HASH_MISMATCH	0x00000002
#define BM_DCP_CHnSTAT_RSVD_COMPLETE	0x00000001

/*
 *  multi-register-define name HW_DCP_CHnOPTS
 *              base 0x00000130
 *              count 4
 *              offset 0x40
 */
#define HW_DCP_CHnOPTS(n)	(0x00000130 + (n) * 0x40)
#define HW_DCP_CHnOPTS_SET(n)	(0x00000134 + (n) * 0x40)
#define HW_DCP_CHnOPTS_CLR(n)	(0x00000138 + (n) * 0x40)
#define HW_DCP_CHnOPTS_TOG(n)	(0x0000013c + (n) * 0x40)

#define BP_DCP_CHnOPTS_RSVD	16
#define BM_DCP_CHnOPTS_RSVD	0xFFFF0000
#define BF_DCP_CHnOPTS_RSVD(v) \
		(((v) << 16) & BM_DCP_CHnOPTS_RSVD)
#define BP_DCP_CHnOPTS_RECOVERY_TIMER	0
#define BM_DCP_CHnOPTS_RECOVERY_TIMER	0x0000FFFF
#define BF_DCP_CHnOPTS_RECOVERY_TIMER(v)  \
		(((v) << 0) & BM_DCP_CHnOPTS_RECOVERY_TIMER)

#define HW_DCP_CSCCTRL0	(0x00000300)
#define HW_DCP_CSCCTRL0_SET	(0x00000304)
#define HW_DCP_CSCCTRL0_CLR	(0x00000308)
#define HW_DCP_CSCCTRL0_TOG	(0x0000030c)

#define BP_DCP_CSCCTRL0_RSVD1	16
#define BM_DCP_CSCCTRL0_RSVD1	0xFFFF0000
#define BF_DCP_CSCCTRL0_RSVD1(v) \
		(((v) << 16) & BM_DCP_CSCCTRL0_RSVD1)
#define BM_DCP_CSCCTRL0_CLIP	0x00008000
#define BM_DCP_CSCCTRL0_UPSAMPLE	0x00004000
#define BM_DCP_CSCCTRL0_SCALE	0x00002000
#define BM_DCP_CSCCTRL0_ROTATE	0x00001000
#define BM_DCP_CSCCTRL0_SUBSAMPLE	0x00000800
#define BM_DCP_CSCCTRL0_DELTA	0x00000400
#define BP_DCP_CSCCTRL0_RGB_FORMAT	8
#define BM_DCP_CSCCTRL0_RGB_FORMAT	0x00000300
#define BF_DCP_CSCCTRL0_RGB_FORMAT(v)  \
		(((v) << 8) & BM_DCP_CSCCTRL0_RGB_FORMAT)
#define BV_DCP_CSCCTRL0_RGB_FORMAT__RGB16_565 0x0
#define BV_DCP_CSCCTRL0_RGB_FORMAT__YCbCrI    0x1
#define BV_DCP_CSCCTRL0_RGB_FORMAT__RGB24     0x2
#define BV_DCP_CSCCTRL0_RGB_FORMAT__YUV422I   0x3
#define BP_DCP_CSCCTRL0_YUV_FORMAT	4
#define BM_DCP_CSCCTRL0_YUV_FORMAT	0x000000F0
#define BF_DCP_CSCCTRL0_YUV_FORMAT(v)  \
		(((v) << 4) & BM_DCP_CSCCTRL0_YUV_FORMAT)
#define BV_DCP_CSCCTRL0_YUV_FORMAT__YUV420 0x0
#define BV_DCP_CSCCTRL0_YUV_FORMAT__YUV422 0x2
#define BP_DCP_CSCCTRL0_RSVD0	1
#define BM_DCP_CSCCTRL0_RSVD0	0x0000000E
#define BF_DCP_CSCCTRL0_RSVD0(v)  \
		(((v) << 1) & BM_DCP_CSCCTRL0_RSVD0)
#define BM_DCP_CSCCTRL0_ENABLE	0x00000001

#define HW_DCP_CSCSTAT	(0x00000310)
#define HW_DCP_CSCSTAT_SET	(0x00000314)
#define HW_DCP_CSCSTAT_CLR	(0x00000318)
#define HW_DCP_CSCSTAT_TOG	(0x0000031c)

#define BP_DCP_CSCSTAT_RSVD3	24
#define BM_DCP_CSCSTAT_RSVD3	0xFF000000
#define BF_DCP_CSCSTAT_RSVD3(v) \
		(((v) << 24) & BM_DCP_CSCSTAT_RSVD3)
#define BP_DCP_CSCSTAT_ERROR_CODE	16
#define BM_DCP_CSCSTAT_ERROR_CODE	0x00FF0000
#define BF_DCP_CSCSTAT_ERROR_CODE(v)  \
		(((v) << 16) & BM_DCP_CSCSTAT_ERROR_CODE)
#define BV_DCP_CSCSTAT_ERROR_CODE__LUMA0_FETCH_ERROR_Y0 0x01
#define BV_DCP_CSCSTAT_ERROR_CODE__LUMA1_FETCH_ERROR_Y1 0x02
#define BV_DCP_CSCSTAT_ERROR_CODE__CHROMA_FETCH_ERROR_U 0x03
#define BV_DCP_CSCSTAT_ERROR_CODE__CHROMA_FETCH_ERROR_V 0x04
#define BP_DCP_CSCSTAT_RSVD2	7
#define BM_DCP_CSCSTAT_RSVD2	0x0000FF80
#define BF_DCP_CSCSTAT_RSVD2(v)  \
		(((v) << 7) & BM_DCP_CSCSTAT_RSVD2)
#define BM_DCP_CSCSTAT_ERROR_PAGEFAULT	0x00000040
#define BM_DCP_CSCSTAT_ERROR_DST	0x00000020
#define BM_DCP_CSCSTAT_ERROR_SRC	0x00000010
#define BM_DCP_CSCSTAT_RSVD1	0x00000008
#define BM_DCP_CSCSTAT_ERROR_SETUP	0x00000004
#define BM_DCP_CSCSTAT_RSVD0	0x00000002
#define BM_DCP_CSCSTAT_COMPLETE	0x00000001

#define HW_DCP_CSCOUTBUFPARAM	(0x00000320)

#define BP_DCP_CSCOUTBUFPARAM_RSVD1	24
#define BM_DCP_CSCOUTBUFPARAM_RSVD1	0xFF000000
#define BF_DCP_CSCOUTBUFPARAM_RSVD1(v) \
		(((v) << 24) & BM_DCP_CSCOUTBUFPARAM_RSVD1)
#define BP_DCP_CSCOUTBUFPARAM_FIELD_SIZE	12
#define BM_DCP_CSCOUTBUFPARAM_FIELD_SIZE	0x00FFF000
#define BF_DCP_CSCOUTBUFPARAM_FIELD_SIZE(v)  \
		(((v) << 12) & BM_DCP_CSCOUTBUFPARAM_FIELD_SIZE)
#define BP_DCP_CSCOUTBUFPARAM_LINE_SIZE	0
#define BM_DCP_CSCOUTBUFPARAM_LINE_SIZE	0x00000FFF
#define BF_DCP_CSCOUTBUFPARAM_LINE_SIZE(v)  \
		(((v) << 0) & BM_DCP_CSCOUTBUFPARAM_LINE_SIZE)

#define HW_DCP_CSCINBUFPARAM	(0x00000330)

#define BP_DCP_CSCINBUFPARAM_RSVD1	12
#define BM_DCP_CSCINBUFPARAM_RSVD1	0xFFFFF000
#define BF_DCP_CSCINBUFPARAM_RSVD1(v) \
		(((v) << 12) & BM_DCP_CSCINBUFPARAM_RSVD1)
#define BP_DCP_CSCINBUFPARAM_LINE_SIZE	0
#define BM_DCP_CSCINBUFPARAM_LINE_SIZE	0x00000FFF
#define BF_DCP_CSCINBUFPARAM_LINE_SIZE(v)  \
		(((v) << 0) & BM_DCP_CSCINBUFPARAM_LINE_SIZE)

#define HW_DCP_CSCRGB	(0x00000340)

#define BP_DCP_CSCRGB_ADDR	0
#define BM_DCP_CSCRGB_ADDR	0xFFFFFFFF
#define BF_DCP_CSCRGB_ADDR(v)	(v)

#define HW_DCP_CSCLUMA	(0x00000350)

#define BP_DCP_CSCLUMA_ADDR	0
#define BM_DCP_CSCLUMA_ADDR	0xFFFFFFFF
#define BF_DCP_CSCLUMA_ADDR(v)	(v)

#define HW_DCP_CSCCHROMAU	(0x00000360)

#define BP_DCP_CSCCHROMAU_ADDR	0
#define BM_DCP_CSCCHROMAU_ADDR	0xFFFFFFFF
#define BF_DCP_CSCCHROMAU_ADDR(v)	(v)

#define HW_DCP_CSCCHROMAV	(0x00000370)

#define BP_DCP_CSCCHROMAV_ADDR	0
#define BM_DCP_CSCCHROMAV_ADDR	0xFFFFFFFF
#define BF_DCP_CSCCHROMAV_ADDR(v)	(v)

#define HW_DCP_CSCCOEFF0	(0x00000380)

#define BP_DCP_CSCCOEFF0_RSVD1	26
#define BM_DCP_CSCCOEFF0_RSVD1	0xFC000000
#define BF_DCP_CSCCOEFF0_RSVD1(v) \
		(((v) << 26) & BM_DCP_CSCCOEFF0_RSVD1)
#define BP_DCP_CSCCOEFF0_C0	16
#define BM_DCP_CSCCOEFF0_C0	0x03FF0000
#define BF_DCP_CSCCOEFF0_C0(v)  \
		(((v) << 16) & BM_DCP_CSCCOEFF0_C0)
#define BP_DCP_CSCCOEFF0_UV_OFFSET	8
#define BM_DCP_CSCCOEFF0_UV_OFFSET	0x0000FF00
#define BF_DCP_CSCCOEFF0_UV_OFFSET(v)  \
		(((v) << 8) & BM_DCP_CSCCOEFF0_UV_OFFSET)
#define BP_DCP_CSCCOEFF0_Y_OFFSET	0
#define BM_DCP_CSCCOEFF0_Y_OFFSET	0x000000FF
#define BF_DCP_CSCCOEFF0_Y_OFFSET(v)  \
		(((v) << 0) & BM_DCP_CSCCOEFF0_Y_OFFSET)

#define HW_DCP_CSCCOEFF1	(0x00000390)

#define BP_DCP_CSCCOEFF1_RSVD1	26
#define BM_DCP_CSCCOEFF1_RSVD1	0xFC000000
#define BF_DCP_CSCCOEFF1_RSVD1(v) \
		(((v) << 26) & BM_DCP_CSCCOEFF1_RSVD1)
#define BP_DCP_CSCCOEFF1_C1	16
#define BM_DCP_CSCCOEFF1_C1	0x03FF0000
#define BF_DCP_CSCCOEFF1_C1(v)  \
		(((v) << 16) & BM_DCP_CSCCOEFF1_C1)
#define BP_DCP_CSCCOEFF1_RSVD0	10
#define BM_DCP_CSCCOEFF1_RSVD0	0x0000FC00
#define BF_DCP_CSCCOEFF1_RSVD0(v)  \
		(((v) << 10) & BM_DCP_CSCCOEFF1_RSVD0)
#define BP_DCP_CSCCOEFF1_C4	0
#define BM_DCP_CSCCOEFF1_C4	0x000003FF
#define BF_DCP_CSCCOEFF1_C4(v)  \
		(((v) << 0) & BM_DCP_CSCCOEFF1_C4)

#define HW_DCP_CSCCOEFF2	(0x000003a0)

#define BP_DCP_CSCCOEFF2_RSVD1	26
#define BM_DCP_CSCCOEFF2_RSVD1	0xFC000000
#define BF_DCP_CSCCOEFF2_RSVD1(v) \
		(((v) << 26) & BM_DCP_CSCCOEFF2_RSVD1)
#define BP_DCP_CSCCOEFF2_C2	16
#define BM_DCP_CSCCOEFF2_C2	0x03FF0000
#define BF_DCP_CSCCOEFF2_C2(v)  \
		(((v) << 16) & BM_DCP_CSCCOEFF2_C2)
#define BP_DCP_CSCCOEFF2_RSVD0	10
#define BM_DCP_CSCCOEFF2_RSVD0	0x0000FC00
#define BF_DCP_CSCCOEFF2_RSVD0(v)  \
		(((v) << 10) & BM_DCP_CSCCOEFF2_RSVD0)
#define BP_DCP_CSCCOEFF2_C3	0
#define BM_DCP_CSCCOEFF2_C3	0x000003FF
#define BF_DCP_CSCCOEFF2_C3(v)  \
		(((v) << 0) & BM_DCP_CSCCOEFF2_C3)

#define HW_DCP_CSCCLIP	(0x000003d0)

#define BP_DCP_CSCCLIP_RSVD1	24
#define BM_DCP_CSCCLIP_RSVD1	0xFF000000
#define BF_DCP_CSCCLIP_RSVD1(v) \
		(((v) << 24) & BM_DCP_CSCCLIP_RSVD1)
#define BP_DCP_CSCCLIP_HEIGHT	12
#define BM_DCP_CSCCLIP_HEIGHT	0x00FFF000
#define BF_DCP_CSCCLIP_HEIGHT(v)  \
		(((v) << 12) & BM_DCP_CSCCLIP_HEIGHT)
#define BP_DCP_CSCCLIP_WIDTH	0
#define BM_DCP_CSCCLIP_WIDTH	0x00000FFF
#define BF_DCP_CSCCLIP_WIDTH(v)  \
		(((v) << 0) & BM_DCP_CSCCLIP_WIDTH)

#define HW_DCP_CSCXSCALE	(0x000003e0)

#define BP_DCP_CSCXSCALE_RSVD1	26
#define BM_DCP_CSCXSCALE_RSVD1	0xFC000000
#define BF_DCP_CSCXSCALE_RSVD1(v) \
		(((v) << 26) & BM_DCP_CSCXSCALE_RSVD1)
#define BP_DCP_CSCXSCALE_INT	24
#define BM_DCP_CSCXSCALE_INT	0x03000000
#define BF_DCP_CSCXSCALE_INT(v)  \
		(((v) << 24) & BM_DCP_CSCXSCALE_INT)
#define BP_DCP_CSCXSCALE_FRAC	12
#define BM_DCP_CSCXSCALE_FRAC	0x00FFF000
#define BF_DCP_CSCXSCALE_FRAC(v)  \
		(((v) << 12) & BM_DCP_CSCXSCALE_FRAC)
#define BP_DCP_CSCXSCALE_WIDTH	0
#define BM_DCP_CSCXSCALE_WIDTH	0x00000FFF
#define BF_DCP_CSCXSCALE_WIDTH(v)  \
		(((v) << 0) & BM_DCP_CSCXSCALE_WIDTH)

#define HW_DCP_CSCYSCALE	(0x000003f0)

#define BP_DCP_CSCYSCALE_RSVD1	26
#define BM_DCP_CSCYSCALE_RSVD1	0xFC000000
#define BF_DCP_CSCYSCALE_RSVD1(v) \
		(((v) << 26) & BM_DCP_CSCYSCALE_RSVD1)
#define BP_DCP_CSCYSCALE_INT	24
#define BM_DCP_CSCYSCALE_INT	0x03000000
#define BF_DCP_CSCYSCALE_INT(v)  \
		(((v) << 24) & BM_DCP_CSCYSCALE_INT)
#define BP_DCP_CSCYSCALE_FRAC	12
#define BM_DCP_CSCYSCALE_FRAC	0x00FFF000
#define BF_DCP_CSCYSCALE_FRAC(v)  \
		(((v) << 12) & BM_DCP_CSCYSCALE_FRAC)
#define BP_DCP_CSCYSCALE_HEIGHT	0
#define BM_DCP_CSCYSCALE_HEIGHT	0x00000FFF
#define BF_DCP_CSCYSCALE_HEIGHT(v)  \
		(((v) << 0) & BM_DCP_CSCYSCALE_HEIGHT)

#define HW_DCP_DBGSELECT	(0x00000400)

#define BP_DCP_DBGSELECT_RSVD	8
#define BM_DCP_DBGSELECT_RSVD	0xFFFFFF00
#define BF_DCP_DBGSELECT_RSVD(v) \
		(((v) << 8) & BM_DCP_DBGSELECT_RSVD)
#define BP_DCP_DBGSELECT_INDEX	0
#define BM_DCP_DBGSELECT_INDEX	0x000000FF
#define BF_DCP_DBGSELECT_INDEX(v)  \
		(((v) << 0) & BM_DCP_DBGSELECT_INDEX)
#define BV_DCP_DBGSELECT_INDEX__CONTROL 0x01
#define BV_DCP_DBGSELECT_INDEX__OTPKEY0 0x10
#define BV_DCP_DBGSELECT_INDEX__OTPKEY1 0x11
#define BV_DCP_DBGSELECT_INDEX__OTPKEY2 0x12
#define BV_DCP_DBGSELECT_INDEX__OTPKEY3 0x13

#define HW_DCP_DBGDATA	(0x00000410)

#define BP_DCP_DBGDATA_DATA	0
#define BM_DCP_DBGDATA_DATA	0xFFFFFFFF
#define BF_DCP_DBGDATA_DATA(v)	(v)

#define HW_DCP_PAGETABLE	(0x00000420)

#define BP_DCP_PAGETABLE_BASE	2
#define BM_DCP_PAGETABLE_BASE	0xFFFFFFFC
#define BF_DCP_PAGETABLE_BASE(v) \
		(((v) << 2) & BM_DCP_PAGETABLE_BASE)
#define BM_DCP_PAGETABLE_FLUSH	0x00000002
#define BM_DCP_PAGETABLE_ENABLE	0x00000001

#define HW_DCP_VERSION	(0x00000430)

#define BP_DCP_VERSION_MAJOR	24
#define BM_DCP_VERSION_MAJOR	0xFF000000
#define BF_DCP_VERSION_MAJOR(v) \
		(((v) << 24) & BM_DCP_VERSION_MAJOR)
#define BP_DCP_VERSION_MINOR	16
#define BM_DCP_VERSION_MINOR	0x00FF0000
#define BF_DCP_VERSION_MINOR(v)  \
		(((v) << 16) & BM_DCP_VERSION_MINOR)
#define BP_DCP_VERSION_STEP	0
#define BM_DCP_VERSION_STEP	0x0000FFFF
#define BF_DCP_VERSION_STEP(v)  \
		(((v) << 0) & BM_DCP_VERSION_STEP)


#endif
