/*
 * Freescale DRAM Register Definitions
 *
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 * Copyright 2008-2010 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 */

#ifndef __ARCH_ARM___DRAM_H
#define __ARCH_ARM___DRAM_H  1

#define REGS_DRAM_PHYS (0x800E0000)
#define REGS_DRAM_SIZE 0x00002000

#define HW_DRAM_CTL00	(0x00000000)

#define BP_DRAM_CTL00_RSVD4	25
#define BM_DRAM_CTL00_RSVD4	0xFE000000
#define BF_DRAM_CTL00_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL00_RSVD4)
#define BM_DRAM_CTL00_AHB0_W_PRIORITY	0x01000000
#define BP_DRAM_CTL00_RSVD3	17
#define BM_DRAM_CTL00_RSVD3	0x00FE0000
#define BF_DRAM_CTL00_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL00_RSVD3)
#define BM_DRAM_CTL00_AHB0_R_PRIORITY	0x00010000
#define BP_DRAM_CTL00_RSVD2	9
#define BM_DRAM_CTL00_RSVD2	0x0000FE00
#define BF_DRAM_CTL00_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL00_RSVD2)
#define BM_DRAM_CTL00_AHB0_FIFO_TYPE_REG	0x00000100
#define BP_DRAM_CTL00_RSVD1	1
#define BM_DRAM_CTL00_RSVD1	0x000000FE
#define BF_DRAM_CTL00_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL00_RSVD1)
#define BM_DRAM_CTL00_ADDR_CMP_EN	0x00000001

#define HW_DRAM_CTL01	(0x00000004)

#define BP_DRAM_CTL01_RSVD4	25
#define BM_DRAM_CTL01_RSVD4	0xFE000000
#define BF_DRAM_CTL01_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL01_RSVD4)
#define BM_DRAM_CTL01_AHB2_FIFO_TYPE_REG	0x01000000
#define BP_DRAM_CTL01_RSVD3	17
#define BM_DRAM_CTL01_RSVD3	0x00FE0000
#define BF_DRAM_CTL01_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL01_RSVD3)
#define BM_DRAM_CTL01_AHB1_W_PRIORITY	0x00010000
#define BP_DRAM_CTL01_RSVD2	9
#define BM_DRAM_CTL01_RSVD2	0x0000FE00
#define BF_DRAM_CTL01_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL01_RSVD2)
#define BM_DRAM_CTL01_AHB1_R_PRIORITY	0x00000100
#define BP_DRAM_CTL01_RSVD1	1
#define BM_DRAM_CTL01_RSVD1	0x000000FE
#define BF_DRAM_CTL01_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL01_RSVD1)
#define BM_DRAM_CTL01_AHB1_FIFO_TYPE_REG	0x00000001

#define HW_DRAM_CTL02	(0x00000008)

#define BP_DRAM_CTL02_RSVD4	25
#define BM_DRAM_CTL02_RSVD4	0xFE000000
#define BF_DRAM_CTL02_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL02_RSVD4)
#define BM_DRAM_CTL02_AHB3_R_PRIORITY	0x01000000
#define BP_DRAM_CTL02_RSVD3	17
#define BM_DRAM_CTL02_RSVD3	0x00FE0000
#define BF_DRAM_CTL02_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL02_RSVD3)
#define BM_DRAM_CTL02_AHB3_FIFO_TYPE_REG	0x00010000
#define BP_DRAM_CTL02_RSVD2	9
#define BM_DRAM_CTL02_RSVD2	0x0000FE00
#define BF_DRAM_CTL02_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL02_RSVD2)
#define BM_DRAM_CTL02_AHB2_W_PRIORITY	0x00000100
#define BP_DRAM_CTL02_RSVD1	1
#define BM_DRAM_CTL02_RSVD1	0x000000FE
#define BF_DRAM_CTL02_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL02_RSVD1)
#define BM_DRAM_CTL02_AHB2_R_PRIORITY	0x00000001

#define HW_DRAM_CTL03	(0x0000000c)

#define BP_DRAM_CTL03_RSVD4	25
#define BM_DRAM_CTL03_RSVD4	0xFE000000
#define BF_DRAM_CTL03_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL03_RSVD4)
#define BM_DRAM_CTL03_AUTO_REFRESH_MODE	0x01000000
#define BP_DRAM_CTL03_RSVD3	17
#define BM_DRAM_CTL03_RSVD3	0x00FE0000
#define BF_DRAM_CTL03_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL03_RSVD3)
#define BM_DRAM_CTL03_AREFRESH	0x00010000
#define BP_DRAM_CTL03_RSVD2	9
#define BM_DRAM_CTL03_RSVD2	0x0000FE00
#define BF_DRAM_CTL03_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL03_RSVD2)
#define BM_DRAM_CTL03_AP	0x00000100
#define BP_DRAM_CTL03_RSVD1	1
#define BM_DRAM_CTL03_RSVD1	0x000000FE
#define BF_DRAM_CTL03_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL03_RSVD1)
#define BM_DRAM_CTL03_AHB3_W_PRIORITY	0x00000001

#define HW_DRAM_CTL04	(0x00000010)

#define BP_DRAM_CTL04_RSVD4	25
#define BM_DRAM_CTL04_RSVD4	0xFE000000
#define BF_DRAM_CTL04_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL04_RSVD4)
#define BM_DRAM_CTL04_DLL_BYPASS_MODE	0x01000000
#define BP_DRAM_CTL04_RSVD3	17
#define BM_DRAM_CTL04_RSVD3	0x00FE0000
#define BF_DRAM_CTL04_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL04_RSVD3)
#define BM_DRAM_CTL04_DLLLOCKREG	0x00010000
#define BP_DRAM_CTL04_RSVD2	9
#define BM_DRAM_CTL04_RSVD2	0x0000FE00
#define BF_DRAM_CTL04_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL04_RSVD2)
#define BM_DRAM_CTL04_CONCURRENTAP	0x00000100
#define BP_DRAM_CTL04_RSVD1	1
#define BM_DRAM_CTL04_RSVD1	0x000000FE
#define BF_DRAM_CTL04_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL04_RSVD1)
#define BM_DRAM_CTL04_BANK_SPLIT_EN	0x00000001

#define HW_DRAM_CTL05	(0x00000014)

#define BP_DRAM_CTL05_RSVD4	25
#define BM_DRAM_CTL05_RSVD4	0xFE000000
#define BF_DRAM_CTL05_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL05_RSVD4)
#define BM_DRAM_CTL05_INTRPTREADA	0x01000000
#define BP_DRAM_CTL05_RSVD3	17
#define BM_DRAM_CTL05_RSVD3	0x00FE0000
#define BF_DRAM_CTL05_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL05_RSVD3)
#define BM_DRAM_CTL05_INTRPTAPBURST	0x00010000
#define BP_DRAM_CTL05_RSVD2	9
#define BM_DRAM_CTL05_RSVD2	0x0000FE00
#define BF_DRAM_CTL05_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL05_RSVD2)
#define BM_DRAM_CTL05_FAST_WRITE	0x00000100
#define BP_DRAM_CTL05_RSVD1	1
#define BM_DRAM_CTL05_RSVD1	0x000000FE
#define BF_DRAM_CTL05_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL05_RSVD1)
#define BM_DRAM_CTL05_EN_LOWPOWER_MODE	0x00000001

#define HW_DRAM_CTL06	(0x00000018)

#define BP_DRAM_CTL06_RSVD4	25
#define BM_DRAM_CTL06_RSVD4	0xFE000000
#define BF_DRAM_CTL06_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL06_RSVD4)
#define BM_DRAM_CTL06_POWER_DOWN	0x01000000
#define BP_DRAM_CTL06_RSVD3	17
#define BM_DRAM_CTL06_RSVD3	0x00FE0000
#define BF_DRAM_CTL06_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL06_RSVD3)
#define BM_DRAM_CTL06_PLACEMENT_EN	0x00010000
#define BP_DRAM_CTL06_RSVD2	9
#define BM_DRAM_CTL06_RSVD2	0x0000FE00
#define BF_DRAM_CTL06_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL06_RSVD2)
#define BM_DRAM_CTL06_NO_CMD_INIT	0x00000100
#define BP_DRAM_CTL06_RSVD1	1
#define BM_DRAM_CTL06_RSVD1	0x000000FE
#define BF_DRAM_CTL06_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL06_RSVD1)
#define BM_DRAM_CTL06_INTRPTWRITEA	0x00000001

#define HW_DRAM_CTL07	(0x0000001c)

#define BP_DRAM_CTL07_RSVD4	25
#define BM_DRAM_CTL07_RSVD4	0xFE000000
#define BF_DRAM_CTL07_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL07_RSVD4)
#define BM_DRAM_CTL07_RW_SAME_EN	0x01000000
#define BP_DRAM_CTL07_RSVD3	17
#define BM_DRAM_CTL07_RSVD3	0x00FE0000
#define BF_DRAM_CTL07_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL07_RSVD3)
#define BM_DRAM_CTL07_REG_DIMM_ENABLE	0x00010000
#define BP_DRAM_CTL07_RSVD2	9
#define BM_DRAM_CTL07_RSVD2	0x0000FE00
#define BF_DRAM_CTL07_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL07_RSVD2)
#define BM_DRAM_CTL07_RD2RD_TURN	0x00000100
#define BP_DRAM_CTL07_RSVD1	1
#define BM_DRAM_CTL07_RSVD1	0x000000FE
#define BF_DRAM_CTL07_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL07_RSVD1)
#define BM_DRAM_CTL07_PRIORITY_EN	0x00000001

#define HW_DRAM_CTL08	(0x00000020)

#define BP_DRAM_CTL08_RSVD4	25
#define BM_DRAM_CTL08_RSVD4	0xFE000000
#define BF_DRAM_CTL08_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL08_RSVD4)
#define BM_DRAM_CTL08_TRAS_LOCKOUT	0x01000000
#define BP_DRAM_CTL08_RSVD3	17
#define BM_DRAM_CTL08_RSVD3	0x00FE0000
#define BF_DRAM_CTL08_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL08_RSVD3)
#define BM_DRAM_CTL08_START	0x00010000
#define BP_DRAM_CTL08_RSVD2	9
#define BM_DRAM_CTL08_RSVD2	0x0000FE00
#define BF_DRAM_CTL08_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL08_RSVD2)
#define BM_DRAM_CTL08_SREFRESH	0x00000100
#define BP_DRAM_CTL08_RSVD1	1
#define BM_DRAM_CTL08_RSVD1	0x000000FE
#define BF_DRAM_CTL08_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL08_RSVD1)
#define BM_DRAM_CTL08_SDR_MODE	0x00000001

#define HW_DRAM_CTL09	(0x00000024)

#define BP_DRAM_CTL09_RSVD4	26
#define BM_DRAM_CTL09_RSVD4	0xFC000000
#define BF_DRAM_CTL09_RSVD4(v) \
		(((v) << 26) & BM_DRAM_CTL09_RSVD4)
#define BP_DRAM_CTL09_OUT_OF_RANGE_TYPE	24
#define BM_DRAM_CTL09_OUT_OF_RANGE_TYPE	0x03000000
#define BF_DRAM_CTL09_OUT_OF_RANGE_TYPE(v)  \
		(((v) << 24) & BM_DRAM_CTL09_OUT_OF_RANGE_TYPE)
#define BP_DRAM_CTL09_RSVD3	18
#define BM_DRAM_CTL09_RSVD3	0x00FC0000
#define BF_DRAM_CTL09_RSVD3(v)  \
		(((v) << 18) & BM_DRAM_CTL09_RSVD3)
#define BP_DRAM_CTL09_OUT_OF_RANGE_SOURCE_ID	16
#define BM_DRAM_CTL09_OUT_OF_RANGE_SOURCE_ID	0x00030000
#define BF_DRAM_CTL09_OUT_OF_RANGE_SOURCE_ID(v)  \
		(((v) << 16) & BM_DRAM_CTL09_OUT_OF_RANGE_SOURCE_ID)
#define BP_DRAM_CTL09_RSVD2	9
#define BM_DRAM_CTL09_RSVD2	0x0000FE00
#define BF_DRAM_CTL09_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL09_RSVD2)
#define BM_DRAM_CTL09_WRITE_MODEREG	0x00000100
#define BP_DRAM_CTL09_RSVD1	1
#define BM_DRAM_CTL09_RSVD1	0x000000FE
#define BF_DRAM_CTL09_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL09_RSVD1)
#define BM_DRAM_CTL09_WRITEINTERP	0x00000001

#define HW_DRAM_CTL10	(0x00000028)

#define BP_DRAM_CTL10_RSVD4	27
#define BM_DRAM_CTL10_RSVD4	0xF8000000
#define BF_DRAM_CTL10_RSVD4(v) \
		(((v) << 27) & BM_DRAM_CTL10_RSVD4)
#define BP_DRAM_CTL10_AGE_COUNT	24
#define BM_DRAM_CTL10_AGE_COUNT	0x07000000
#define BF_DRAM_CTL10_AGE_COUNT(v)  \
		(((v) << 24) & BM_DRAM_CTL10_AGE_COUNT)
#define BP_DRAM_CTL10_RSVD3	19
#define BM_DRAM_CTL10_RSVD3	0x00F80000
#define BF_DRAM_CTL10_RSVD3(v)  \
		(((v) << 19) & BM_DRAM_CTL10_RSVD3)
#define BP_DRAM_CTL10_ADDR_PINS	16
#define BM_DRAM_CTL10_ADDR_PINS	0x00070000
#define BF_DRAM_CTL10_ADDR_PINS(v)  \
		(((v) << 16) & BM_DRAM_CTL10_ADDR_PINS)
#define BP_DRAM_CTL10_RSVD2	10
#define BM_DRAM_CTL10_RSVD2	0x0000FC00
#define BF_DRAM_CTL10_RSVD2(v)  \
		(((v) << 10) & BM_DRAM_CTL10_RSVD2)
#define BP_DRAM_CTL10_TEMRS	8
#define BM_DRAM_CTL10_TEMRS	0x00000300
#define BF_DRAM_CTL10_TEMRS(v)  \
		(((v) << 8) & BM_DRAM_CTL10_TEMRS)
#define BP_DRAM_CTL10_RSVD1	2
#define BM_DRAM_CTL10_RSVD1	0x000000FC
#define BF_DRAM_CTL10_RSVD1(v)  \
		(((v) << 2) & BM_DRAM_CTL10_RSVD1)
#define BP_DRAM_CTL10_Q_FULLNESS	0
#define BM_DRAM_CTL10_Q_FULLNESS	0x00000003
#define BF_DRAM_CTL10_Q_FULLNESS(v)  \
		(((v) << 0) & BM_DRAM_CTL10_Q_FULLNESS)

#define HW_DRAM_CTL11	(0x0000002c)

#define BP_DRAM_CTL11_RSVD4	27
#define BM_DRAM_CTL11_RSVD4	0xF8000000
#define BF_DRAM_CTL11_RSVD4(v) \
		(((v) << 27) & BM_DRAM_CTL11_RSVD4)
#define BP_DRAM_CTL11_MAX_CS_REG	24
#define BM_DRAM_CTL11_MAX_CS_REG	0x07000000
#define BF_DRAM_CTL11_MAX_CS_REG(v)  \
		(((v) << 24) & BM_DRAM_CTL11_MAX_CS_REG)
#define BP_DRAM_CTL11_RSVD3	19
#define BM_DRAM_CTL11_RSVD3	0x00F80000
#define BF_DRAM_CTL11_RSVD3(v)  \
		(((v) << 19) & BM_DRAM_CTL11_RSVD3)
#define BP_DRAM_CTL11_COMMAND_AGE_COUNT	16
#define BM_DRAM_CTL11_COMMAND_AGE_COUNT	0x00070000
#define BF_DRAM_CTL11_COMMAND_AGE_COUNT(v)  \
		(((v) << 16) & BM_DRAM_CTL11_COMMAND_AGE_COUNT)
#define BP_DRAM_CTL11_RSVD2	11
#define BM_DRAM_CTL11_RSVD2	0x0000F800
#define BF_DRAM_CTL11_RSVD2(v)  \
		(((v) << 11) & BM_DRAM_CTL11_RSVD2)
#define BP_DRAM_CTL11_COLUMN_SIZE	8
#define BM_DRAM_CTL11_COLUMN_SIZE	0x00000700
#define BF_DRAM_CTL11_COLUMN_SIZE(v)  \
		(((v) << 8) & BM_DRAM_CTL11_COLUMN_SIZE)
#define BP_DRAM_CTL11_RSVD1	3
#define BM_DRAM_CTL11_RSVD1	0x000000F8
#define BF_DRAM_CTL11_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL11_RSVD1)
#define BP_DRAM_CTL11_CASLAT	0
#define BM_DRAM_CTL11_CASLAT	0x00000007
#define BF_DRAM_CTL11_CASLAT(v)  \
		(((v) << 0) & BM_DRAM_CTL11_CASLAT)

#define HW_DRAM_CTL12	(0x00000030)

#define BP_DRAM_CTL12_RSVD3	27
#define BM_DRAM_CTL12_RSVD3	0xF8000000
#define BF_DRAM_CTL12_RSVD3(v) \
		(((v) << 27) & BM_DRAM_CTL12_RSVD3)
#define BP_DRAM_CTL12_TWR_INT	24
#define BM_DRAM_CTL12_TWR_INT	0x07000000
#define BF_DRAM_CTL12_TWR_INT(v)  \
		(((v) << 24) & BM_DRAM_CTL12_TWR_INT)
#define BP_DRAM_CTL12_RSVD2	19
#define BM_DRAM_CTL12_RSVD2	0x00F80000
#define BF_DRAM_CTL12_RSVD2(v)  \
		(((v) << 19) & BM_DRAM_CTL12_RSVD2)
#define BP_DRAM_CTL12_TRRD	16
#define BM_DRAM_CTL12_TRRD	0x00070000
#define BF_DRAM_CTL12_TRRD(v)  \
		(((v) << 16) & BM_DRAM_CTL12_TRRD)
#define BP_DRAM_CTL12_OBSOLETE	8
#define BM_DRAM_CTL12_OBSOLETE	0x0000FF00
#define BF_DRAM_CTL12_OBSOLETE(v)  \
		(((v) << 8) & BM_DRAM_CTL12_OBSOLETE)
#define BP_DRAM_CTL12_RSVD1	3
#define BM_DRAM_CTL12_RSVD1	0x000000F8
#define BF_DRAM_CTL12_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL12_RSVD1)
#define BP_DRAM_CTL12_TCKE	0
#define BM_DRAM_CTL12_TCKE	0x00000007
#define BF_DRAM_CTL12_TCKE(v)  \
		(((v) << 0) & BM_DRAM_CTL12_TCKE)

#define HW_DRAM_CTL13	(0x00000034)

#define BP_DRAM_CTL13_RSVD4	28
#define BM_DRAM_CTL13_RSVD4	0xF0000000
#define BF_DRAM_CTL13_RSVD4(v) \
		(((v) << 28) & BM_DRAM_CTL13_RSVD4)
#define BP_DRAM_CTL13_CASLAT_LIN_GATE	24
#define BM_DRAM_CTL13_CASLAT_LIN_GATE	0x0F000000
#define BF_DRAM_CTL13_CASLAT_LIN_GATE(v)  \
		(((v) << 24) & BM_DRAM_CTL13_CASLAT_LIN_GATE)
#define BP_DRAM_CTL13_RSVD3	20
#define BM_DRAM_CTL13_RSVD3	0x00F00000
#define BF_DRAM_CTL13_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL13_RSVD3)
#define BP_DRAM_CTL13_CASLAT_LIN	16
#define BM_DRAM_CTL13_CASLAT_LIN	0x000F0000
#define BF_DRAM_CTL13_CASLAT_LIN(v)  \
		(((v) << 16) & BM_DRAM_CTL13_CASLAT_LIN)
#define BP_DRAM_CTL13_RSVD2	12
#define BM_DRAM_CTL13_RSVD2	0x0000F000
#define BF_DRAM_CTL13_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL13_RSVD2)
#define BP_DRAM_CTL13_APREBIT	8
#define BM_DRAM_CTL13_APREBIT	0x00000F00
#define BF_DRAM_CTL13_APREBIT(v)  \
		(((v) << 8) & BM_DRAM_CTL13_APREBIT)
#define BP_DRAM_CTL13_RSVD1	3
#define BM_DRAM_CTL13_RSVD1	0x000000F8
#define BF_DRAM_CTL13_RSVD1(v)  \
		(((v) << 3) & BM_DRAM_CTL13_RSVD1)
#define BP_DRAM_CTL13_TWTR	0
#define BM_DRAM_CTL13_TWTR	0x00000007
#define BF_DRAM_CTL13_TWTR(v)  \
		(((v) << 0) & BM_DRAM_CTL13_TWTR)

#define HW_DRAM_CTL14	(0x00000038)

#define BP_DRAM_CTL14_RSVD4	28
#define BM_DRAM_CTL14_RSVD4	0xF0000000
#define BF_DRAM_CTL14_RSVD4(v) \
		(((v) << 28) & BM_DRAM_CTL14_RSVD4)
#define BP_DRAM_CTL14_MAX_COL_REG	24
#define BM_DRAM_CTL14_MAX_COL_REG	0x0F000000
#define BF_DRAM_CTL14_MAX_COL_REG(v)  \
		(((v) << 24) & BM_DRAM_CTL14_MAX_COL_REG)
#define BP_DRAM_CTL14_RSVD3	20
#define BM_DRAM_CTL14_RSVD3	0x00F00000
#define BF_DRAM_CTL14_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL14_RSVD3)
#define BP_DRAM_CTL14_LOWPOWER_REFRESH_ENABLE	16
#define BM_DRAM_CTL14_LOWPOWER_REFRESH_ENABLE	0x000F0000
#define BF_DRAM_CTL14_LOWPOWER_REFRESH_ENABLE(v)  \
		(((v) << 16) & BM_DRAM_CTL14_LOWPOWER_REFRESH_ENABLE)
#define BP_DRAM_CTL14_RSVD2	12
#define BM_DRAM_CTL14_RSVD2	0x0000F000
#define BF_DRAM_CTL14_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL14_RSVD2)
#define BP_DRAM_CTL14_INITAREF	8
#define BM_DRAM_CTL14_INITAREF	0x00000F00
#define BF_DRAM_CTL14_INITAREF(v)  \
		(((v) << 8) & BM_DRAM_CTL14_INITAREF)
#define BP_DRAM_CTL14_RSVD1	4
#define BM_DRAM_CTL14_RSVD1	0x000000F0
#define BF_DRAM_CTL14_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL14_RSVD1)
#define BP_DRAM_CTL14_CS_MAP	0
#define BM_DRAM_CTL14_CS_MAP	0x0000000F
#define BF_DRAM_CTL14_CS_MAP(v)  \
		(((v) << 0) & BM_DRAM_CTL14_CS_MAP)

#define HW_DRAM_CTL15	(0x0000003c)

#define BP_DRAM_CTL15_RSVD4	28
#define BM_DRAM_CTL15_RSVD4	0xF0000000
#define BF_DRAM_CTL15_RSVD4(v) \
		(((v) << 28) & BM_DRAM_CTL15_RSVD4)
#define BP_DRAM_CTL15_TRP	24
#define BM_DRAM_CTL15_TRP	0x0F000000
#define BF_DRAM_CTL15_TRP(v)  \
		(((v) << 24) & BM_DRAM_CTL15_TRP)
#define BP_DRAM_CTL15_RSVD3	20
#define BM_DRAM_CTL15_RSVD3	0x00F00000
#define BF_DRAM_CTL15_RSVD3(v)  \
		(((v) << 20) & BM_DRAM_CTL15_RSVD3)
#define BP_DRAM_CTL15_TDAL	16
#define BM_DRAM_CTL15_TDAL	0x000F0000
#define BF_DRAM_CTL15_TDAL(v)  \
		(((v) << 16) & BM_DRAM_CTL15_TDAL)
#define BP_DRAM_CTL15_RSVD2	12
#define BM_DRAM_CTL15_RSVD2	0x0000F000
#define BF_DRAM_CTL15_RSVD2(v)  \
		(((v) << 12) & BM_DRAM_CTL15_RSVD2)
#define BP_DRAM_CTL15_PORT_BUSY	8
#define BM_DRAM_CTL15_PORT_BUSY	0x00000F00
#define BF_DRAM_CTL15_PORT_BUSY(v)  \
		(((v) << 8) & BM_DRAM_CTL15_PORT_BUSY)
#define BP_DRAM_CTL15_RSVD1	4
#define BM_DRAM_CTL15_RSVD1	0x000000F0
#define BF_DRAM_CTL15_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL15_RSVD1)
#define BP_DRAM_CTL15_MAX_ROW_REG	0
#define BM_DRAM_CTL15_MAX_ROW_REG	0x0000000F
#define BF_DRAM_CTL15_MAX_ROW_REG(v)  \
		(((v) << 0) & BM_DRAM_CTL15_MAX_ROW_REG)

#define HW_DRAM_CTL16	(0x00000040)

#define BP_DRAM_CTL16_RSVD4	29
#define BM_DRAM_CTL16_RSVD4	0xE0000000
#define BF_DRAM_CTL16_RSVD4(v) \
		(((v) << 29) & BM_DRAM_CTL16_RSVD4)
#define BP_DRAM_CTL16_TMRD	24
#define BM_DRAM_CTL16_TMRD	0x1F000000
#define BF_DRAM_CTL16_TMRD(v)  \
		(((v) << 24) & BM_DRAM_CTL16_TMRD)
#define BP_DRAM_CTL16_RSVD3	21
#define BM_DRAM_CTL16_RSVD3	0x00E00000
#define BF_DRAM_CTL16_RSVD3(v)  \
		(((v) << 21) & BM_DRAM_CTL16_RSVD3)
#define BP_DRAM_CTL16_LOWPOWER_CONTROL	16
#define BM_DRAM_CTL16_LOWPOWER_CONTROL	0x001F0000
#define BF_DRAM_CTL16_LOWPOWER_CONTROL(v)  \
		(((v) << 16) & BM_DRAM_CTL16_LOWPOWER_CONTROL)
#define BP_DRAM_CTL16_RSVD2	13
#define BM_DRAM_CTL16_RSVD2	0x0000E000
#define BF_DRAM_CTL16_RSVD2(v)  \
		(((v) << 13) & BM_DRAM_CTL16_RSVD2)
#define BP_DRAM_CTL16_LOWPOWER_AUTO_ENABLE	8
#define BM_DRAM_CTL16_LOWPOWER_AUTO_ENABLE	0x00001F00
#define BF_DRAM_CTL16_LOWPOWER_AUTO_ENABLE(v)  \
		(((v) << 8) & BM_DRAM_CTL16_LOWPOWER_AUTO_ENABLE)
#define BP_DRAM_CTL16_RSVD1	4
#define BM_DRAM_CTL16_RSVD1	0x000000F0
#define BF_DRAM_CTL16_RSVD1(v)  \
		(((v) << 4) & BM_DRAM_CTL16_RSVD1)
#define BP_DRAM_CTL16_INT_ACK	0
#define BM_DRAM_CTL16_INT_ACK	0x0000000F
#define BF_DRAM_CTL16_INT_ACK(v)  \
		(((v) << 0) & BM_DRAM_CTL16_INT_ACK)

#define HW_DRAM_CTL17	(0x00000044)

#define BP_DRAM_CTL17_DLL_START_POINT	24
#define BM_DRAM_CTL17_DLL_START_POINT	0xFF000000
#define BF_DRAM_CTL17_DLL_START_POINT(v) \
		(((v) << 24) & BM_DRAM_CTL17_DLL_START_POINT)
#define BP_DRAM_CTL17_DLL_LOCK	16
#define BM_DRAM_CTL17_DLL_LOCK	0x00FF0000
#define BF_DRAM_CTL17_DLL_LOCK(v)  \
		(((v) << 16) & BM_DRAM_CTL17_DLL_LOCK)
#define BP_DRAM_CTL17_DLL_INCREMENT	8
#define BM_DRAM_CTL17_DLL_INCREMENT	0x0000FF00
#define BF_DRAM_CTL17_DLL_INCREMENT(v)  \
		(((v) << 8) & BM_DRAM_CTL17_DLL_INCREMENT)
#define BP_DRAM_CTL17_RSVD1	5
#define BM_DRAM_CTL17_RSVD1	0x000000E0
#define BF_DRAM_CTL17_RSVD1(v)  \
		(((v) << 5) & BM_DRAM_CTL17_RSVD1)
#define BP_DRAM_CTL17_TRC	0
#define BM_DRAM_CTL17_TRC	0x0000001F
#define BF_DRAM_CTL17_TRC(v)  \
		(((v) << 0) & BM_DRAM_CTL17_TRC)

#define HW_DRAM_CTL18	(0x00000048)

#define BM_DRAM_CTL18_RSVD4	0x80000000
#define BP_DRAM_CTL18_DLL_DQS_DELAY_1	24
#define BM_DRAM_CTL18_DLL_DQS_DELAY_1	0x7F000000
#define BF_DRAM_CTL18_DLL_DQS_DELAY_1(v)  \
		(((v) << 24) & BM_DRAM_CTL18_DLL_DQS_DELAY_1)
#define BM_DRAM_CTL18_RSVD3	0x00800000
#define BP_DRAM_CTL18_DLL_DQS_DELAY_0	16
#define BM_DRAM_CTL18_DLL_DQS_DELAY_0	0x007F0000
#define BF_DRAM_CTL18_DLL_DQS_DELAY_0(v)  \
		(((v) << 16) & BM_DRAM_CTL18_DLL_DQS_DELAY_0)
#define BP_DRAM_CTL18_RSVD2	13
#define BM_DRAM_CTL18_RSVD2	0x0000E000
#define BF_DRAM_CTL18_RSVD2(v)  \
		(((v) << 13) & BM_DRAM_CTL18_RSVD2)
#define BP_DRAM_CTL18_INT_STATUS	8
#define BM_DRAM_CTL18_INT_STATUS	0x00001F00
#define BF_DRAM_CTL18_INT_STATUS(v)  \
		(((v) << 8) & BM_DRAM_CTL18_INT_STATUS)
#define BP_DRAM_CTL18_RSVD1	5
#define BM_DRAM_CTL18_RSVD1	0x000000E0
#define BF_DRAM_CTL18_RSVD1(v)  \
		(((v) << 5) & BM_DRAM_CTL18_RSVD1)
#define BP_DRAM_CTL18_INT_MASK	0
#define BM_DRAM_CTL18_INT_MASK	0x0000001F
#define BF_DRAM_CTL18_INT_MASK(v)  \
		(((v) << 0) & BM_DRAM_CTL18_INT_MASK)

#define HW_DRAM_CTL19	(0x0000004c)

#define BP_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS	24
#define BM_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS	0xFF000000
#define BF_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS(v) \
		(((v) << 24) & BM_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS)
#define BM_DRAM_CTL19_RSVD1	0x00800000
#define BP_DRAM_CTL19_DQS_OUT_SHIFT	16
#define BM_DRAM_CTL19_DQS_OUT_SHIFT	0x007F0000
#define BF_DRAM_CTL19_DQS_OUT_SHIFT(v)  \
		(((v) << 16) & BM_DRAM_CTL19_DQS_OUT_SHIFT)
#define BP_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_1	8
#define BM_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_1	0x0000FF00
#define BF_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_1(v)  \
		(((v) << 8) & BM_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_1)
#define BP_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_0	0
#define BM_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_0	0x000000FF
#define BF_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_0(v)  \
		(((v) << 0) & BM_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_0)

#define HW_DRAM_CTL20	(0x00000050)

#define BP_DRAM_CTL20_TRCD_INT	24
#define BM_DRAM_CTL20_TRCD_INT	0xFF000000
#define BF_DRAM_CTL20_TRCD_INT(v) \
		(((v) << 24) & BM_DRAM_CTL20_TRCD_INT)
#define BP_DRAM_CTL20_TRAS_MIN	16
#define BM_DRAM_CTL20_TRAS_MIN	0x00FF0000
#define BF_DRAM_CTL20_TRAS_MIN(v)  \
		(((v) << 16) & BM_DRAM_CTL20_TRAS_MIN)
#define BP_DRAM_CTL20_WR_DQS_SHIFT_BYPASS	8
#define BM_DRAM_CTL20_WR_DQS_SHIFT_BYPASS	0x0000FF00
#define BF_DRAM_CTL20_WR_DQS_SHIFT_BYPASS(v)  \
		(((v) << 8) & BM_DRAM_CTL20_WR_DQS_SHIFT_BYPASS)
#define BM_DRAM_CTL20_RSVD1	0x00000080
#define BP_DRAM_CTL20_WR_DQS_SHIFT	0
#define BM_DRAM_CTL20_WR_DQS_SHIFT	0x0000007F
#define BF_DRAM_CTL20_WR_DQS_SHIFT(v)  \
		(((v) << 0) & BM_DRAM_CTL20_WR_DQS_SHIFT)

#define HW_DRAM_CTL21	(0x00000054)

#define BP_DRAM_CTL21_OBSOLETE	24
#define BM_DRAM_CTL21_OBSOLETE	0xFF000000
#define BF_DRAM_CTL21_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL21_OBSOLETE)
#define BP_DRAM_CTL21_RSVD1	18
#define BM_DRAM_CTL21_RSVD1	0x00FC0000
#define BF_DRAM_CTL21_RSVD1(v)  \
		(((v) << 18) & BM_DRAM_CTL21_RSVD1)
#define BP_DRAM_CTL21_OUT_OF_RANGE_LENGTH	8
#define BM_DRAM_CTL21_OUT_OF_RANGE_LENGTH	0x0003FF00
#define BF_DRAM_CTL21_OUT_OF_RANGE_LENGTH(v)  \
		(((v) << 8) & BM_DRAM_CTL21_OUT_OF_RANGE_LENGTH)
#define BP_DRAM_CTL21_TRFC	0
#define BM_DRAM_CTL21_TRFC	0x000000FF
#define BF_DRAM_CTL21_TRFC(v)  \
		(((v) << 0) & BM_DRAM_CTL21_TRFC)

#define HW_DRAM_CTL22	(0x00000058)

#define BP_DRAM_CTL22_RSVD2	27
#define BM_DRAM_CTL22_RSVD2	0xF8000000
#define BF_DRAM_CTL22_RSVD2(v) \
		(((v) << 27) & BM_DRAM_CTL22_RSVD2)
#define BP_DRAM_CTL22_AHB0_WRCNT	16
#define BM_DRAM_CTL22_AHB0_WRCNT	0x07FF0000
#define BF_DRAM_CTL22_AHB0_WRCNT(v)  \
		(((v) << 16) & BM_DRAM_CTL22_AHB0_WRCNT)
#define BP_DRAM_CTL22_RSVD1	11
#define BM_DRAM_CTL22_RSVD1	0x0000F800
#define BF_DRAM_CTL22_RSVD1(v)  \
		(((v) << 11) & BM_DRAM_CTL22_RSVD1)
#define BP_DRAM_CTL22_AHB0_RDCNT	0
#define BM_DRAM_CTL22_AHB0_RDCNT	0x000007FF
#define BF_DRAM_CTL22_AHB0_RDCNT(v)  \
		(((v) << 0) & BM_DRAM_CTL22_AHB0_RDCNT)

#define HW_DRAM_CTL23	(0x0000005c)

#define BP_DRAM_CTL23_RSVD2	27
#define BM_DRAM_CTL23_RSVD2	0xF8000000
#define BF_DRAM_CTL23_RSVD2(v) \
		(((v) << 27) & BM_DRAM_CTL23_RSVD2)
#define BP_DRAM_CTL23_AHB1_WRCNT	16
#define BM_DRAM_CTL23_AHB1_WRCNT	0x07FF0000
#define BF_DRAM_CTL23_AHB1_WRCNT(v)  \
		(((v) << 16) & BM_DRAM_CTL23_AHB1_WRCNT)
#define BP_DRAM_CTL23_RSVD1	11
#define BM_DRAM_CTL23_RSVD1	0x0000F800
#define BF_DRAM_CTL23_RSVD1(v)  \
		(((v) << 11) & BM_DRAM_CTL23_RSVD1)
#define BP_DRAM_CTL23_AHB1_RDCNT	0
#define BM_DRAM_CTL23_AHB1_RDCNT	0x000007FF
#define BF_DRAM_CTL23_AHB1_RDCNT(v)  \
		(((v) << 0) & BM_DRAM_CTL23_AHB1_RDCNT)

#define HW_DRAM_CTL24	(0x00000060)

#define BP_DRAM_CTL24_RSVD2	27
#define BM_DRAM_CTL24_RSVD2	0xF8000000
#define BF_DRAM_CTL24_RSVD2(v) \
		(((v) << 27) & BM_DRAM_CTL24_RSVD2)
#define BP_DRAM_CTL24_AHB2_WRCNT	16
#define BM_DRAM_CTL24_AHB2_WRCNT	0x07FF0000
#define BF_DRAM_CTL24_AHB2_WRCNT(v)  \
		(((v) << 16) & BM_DRAM_CTL24_AHB2_WRCNT)
#define BP_DRAM_CTL24_RSVD1	11
#define BM_DRAM_CTL24_RSVD1	0x0000F800
#define BF_DRAM_CTL24_RSVD1(v)  \
		(((v) << 11) & BM_DRAM_CTL24_RSVD1)
#define BP_DRAM_CTL24_AHB2_RDCNT	0
#define BM_DRAM_CTL24_AHB2_RDCNT	0x000007FF
#define BF_DRAM_CTL24_AHB2_RDCNT(v)  \
		(((v) << 0) & BM_DRAM_CTL24_AHB2_RDCNT)

#define HW_DRAM_CTL25	(0x00000064)

#define BP_DRAM_CTL25_RSVD2	27
#define BM_DRAM_CTL25_RSVD2	0xF8000000
#define BF_DRAM_CTL25_RSVD2(v) \
		(((v) << 27) & BM_DRAM_CTL25_RSVD2)
#define BP_DRAM_CTL25_AHB3_WRCNT	16
#define BM_DRAM_CTL25_AHB3_WRCNT	0x07FF0000
#define BF_DRAM_CTL25_AHB3_WRCNT(v)  \
		(((v) << 16) & BM_DRAM_CTL25_AHB3_WRCNT)
#define BP_DRAM_CTL25_RSVD1	11
#define BM_DRAM_CTL25_RSVD1	0x0000F800
#define BF_DRAM_CTL25_RSVD1(v)  \
		(((v) << 11) & BM_DRAM_CTL25_RSVD1)
#define BP_DRAM_CTL25_AHB3_RDCNT	0
#define BM_DRAM_CTL25_AHB3_RDCNT	0x000007FF
#define BF_DRAM_CTL25_AHB3_RDCNT(v)  \
		(((v) << 0) & BM_DRAM_CTL25_AHB3_RDCNT)

#define HW_DRAM_CTL26	(0x00000068)

#define BP_DRAM_CTL26_OBSOLETE	16
#define BM_DRAM_CTL26_OBSOLETE	0xFFFF0000
#define BF_DRAM_CTL26_OBSOLETE(v) \
		(((v) << 16) & BM_DRAM_CTL26_OBSOLETE)
#define BP_DRAM_CTL26_RSVD1	12
#define BM_DRAM_CTL26_RSVD1	0x0000F000
#define BF_DRAM_CTL26_RSVD1(v)  \
		(((v) << 12) & BM_DRAM_CTL26_RSVD1)
#define BP_DRAM_CTL26_TREF	0
#define BM_DRAM_CTL26_TREF	0x00000FFF
#define BF_DRAM_CTL26_TREF(v)  \
		(((v) << 0) & BM_DRAM_CTL26_TREF)

#define HW_DRAM_CTL27	(0x0000006c)

#define BP_DRAM_CTL27_OBSOLETE	0
#define BM_DRAM_CTL27_OBSOLETE	0xFFFFFFFF
#define BF_DRAM_CTL27_OBSOLETE(v)	(v)

#define HW_DRAM_CTL28	(0x00000070)

#define BP_DRAM_CTL28_OBSOLETE	0
#define BM_DRAM_CTL28_OBSOLETE	0xFFFFFFFF
#define BF_DRAM_CTL28_OBSOLETE(v)	(v)

#define HW_DRAM_CTL29	(0x00000074)

#define BP_DRAM_CTL29_LOWPOWER_INTERNAL_CNT	16
#define BM_DRAM_CTL29_LOWPOWER_INTERNAL_CNT	0xFFFF0000
#define BF_DRAM_CTL29_LOWPOWER_INTERNAL_CNT(v) \
		(((v) << 16) & BM_DRAM_CTL29_LOWPOWER_INTERNAL_CNT)
#define BP_DRAM_CTL29_LOWPOWER_EXTERNAL_CNT	0
#define BM_DRAM_CTL29_LOWPOWER_EXTERNAL_CNT	0x0000FFFF
#define BF_DRAM_CTL29_LOWPOWER_EXTERNAL_CNT(v)  \
		(((v) << 0) & BM_DRAM_CTL29_LOWPOWER_EXTERNAL_CNT)

#define HW_DRAM_CTL30	(0x00000078)

#define BP_DRAM_CTL30_LOWPOWER_REFRESH_HOLD	16
#define BM_DRAM_CTL30_LOWPOWER_REFRESH_HOLD	0xFFFF0000
#define BF_DRAM_CTL30_LOWPOWER_REFRESH_HOLD(v) \
		(((v) << 16) & BM_DRAM_CTL30_LOWPOWER_REFRESH_HOLD)
#define BP_DRAM_CTL30_LOWPOWER_POWER_DOWN_CNT	0
#define BM_DRAM_CTL30_LOWPOWER_POWER_DOWN_CNT	0x0000FFFF
#define BF_DRAM_CTL30_LOWPOWER_POWER_DOWN_CNT(v)  \
		(((v) << 0) & BM_DRAM_CTL30_LOWPOWER_POWER_DOWN_CNT)

#define HW_DRAM_CTL31	(0x0000007c)

#define BP_DRAM_CTL31_TDLL	16
#define BM_DRAM_CTL31_TDLL	0xFFFF0000
#define BF_DRAM_CTL31_TDLL(v) \
		(((v) << 16) & BM_DRAM_CTL31_TDLL)
#define BP_DRAM_CTL31_LOWPOWER_SELF_REFRESH_CNT	0
#define BM_DRAM_CTL31_LOWPOWER_SELF_REFRESH_CNT	0x0000FFFF
#define BF_DRAM_CTL31_LOWPOWER_SELF_REFRESH_CNT(v)  \
		(((v) << 0) & BM_DRAM_CTL31_LOWPOWER_SELF_REFRESH_CNT)

#define HW_DRAM_CTL32	(0x00000080)

#define BP_DRAM_CTL32_TXSNR	16
#define BM_DRAM_CTL32_TXSNR	0xFFFF0000
#define BF_DRAM_CTL32_TXSNR(v) \
		(((v) << 16) & BM_DRAM_CTL32_TXSNR)
#define BP_DRAM_CTL32_TRAS_MAX	0
#define BM_DRAM_CTL32_TRAS_MAX	0x0000FFFF
#define BF_DRAM_CTL32_TRAS_MAX(v)  \
		(((v) << 0) & BM_DRAM_CTL32_TRAS_MAX)

#define HW_DRAM_CTL33	(0x00000084)

#define BP_DRAM_CTL33_VERSION	16
#define BM_DRAM_CTL33_VERSION	0xFFFF0000
#define BF_DRAM_CTL33_VERSION(v) \
		(((v) << 16) & BM_DRAM_CTL33_VERSION)
#define BP_DRAM_CTL33_TXSR	0
#define BM_DRAM_CTL33_TXSR	0x0000FFFF
#define BF_DRAM_CTL33_TXSR(v)  \
		(((v) << 0) & BM_DRAM_CTL33_TXSR)

#define HW_DRAM_CTL34	(0x00000088)

#define BP_DRAM_CTL34_RSVD1	24
#define BM_DRAM_CTL34_RSVD1	0xFF000000
#define BF_DRAM_CTL34_RSVD1(v) \
		(((v) << 24) & BM_DRAM_CTL34_RSVD1)
#define BP_DRAM_CTL34_TINIT	0
#define BM_DRAM_CTL34_TINIT	0x00FFFFFF
#define BF_DRAM_CTL34_TINIT(v)  \
		(((v) << 0) & BM_DRAM_CTL34_TINIT)

#define HW_DRAM_CTL35	(0x0000008c)

#define BM_DRAM_CTL35_RSVD1	0x80000000
#define BP_DRAM_CTL35_OUT_OF_RANGE_ADDR	0
#define BM_DRAM_CTL35_OUT_OF_RANGE_ADDR	0x7FFFFFFF
#define BF_DRAM_CTL35_OUT_OF_RANGE_ADDR(v)  \
		(((v) << 0) & BM_DRAM_CTL35_OUT_OF_RANGE_ADDR)

#define HW_DRAM_CTL36	(0x00000090)

#define BP_DRAM_CTL36_RSVD4	25
#define BM_DRAM_CTL36_RSVD4	0xFE000000
#define BF_DRAM_CTL36_RSVD4(v) \
		(((v) << 25) & BM_DRAM_CTL36_RSVD4)
#define BM_DRAM_CTL36_PWRUP_SREFRESH_EXIT	0x01000000
#define BP_DRAM_CTL36_RSVD3	17
#define BM_DRAM_CTL36_RSVD3	0x00FE0000
#define BF_DRAM_CTL36_RSVD3(v)  \
		(((v) << 17) & BM_DRAM_CTL36_RSVD3)
#define BM_DRAM_CTL36_ENABLE_QUICK_SREFRESH	0x00010000
#define BP_DRAM_CTL36_RSVD2	9
#define BM_DRAM_CTL36_RSVD2	0x0000FE00
#define BF_DRAM_CTL36_RSVD2(v)  \
		(((v) << 9) & BM_DRAM_CTL36_RSVD2)
#define BM_DRAM_CTL36_BUS_SHARE_ENABLE	0x00000100
#define BP_DRAM_CTL36_RSVD1	1
#define BM_DRAM_CTL36_RSVD1	0x000000FE
#define BF_DRAM_CTL36_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL36_RSVD1)
#define BM_DRAM_CTL36_ACTIVE_AGING	0x00000001

#define HW_DRAM_CTL37	(0x00000094)

#define BP_DRAM_CTL37_OBSOLETE	24
#define BM_DRAM_CTL37_OBSOLETE	0xFF000000
#define BF_DRAM_CTL37_OBSOLETE(v) \
		(((v) << 24) & BM_DRAM_CTL37_OBSOLETE)
#define BP_DRAM_CTL37_RSVD2	18
#define BM_DRAM_CTL37_RSVD2	0x00FC0000
#define BF_DRAM_CTL37_RSVD2(v)  \
		(((v) << 18) & BM_DRAM_CTL37_RSVD2)
#define BP_DRAM_CTL37_BUS_SHARE_TIMEOUT	8
#define BM_DRAM_CTL37_BUS_SHARE_TIMEOUT	0x0003FF00
#define BF_DRAM_CTL37_BUS_SHARE_TIMEOUT(v)  \
		(((v) << 8) & BM_DRAM_CTL37_BUS_SHARE_TIMEOUT)
#define BP_DRAM_CTL37_RSVD1	1
#define BM_DRAM_CTL37_RSVD1	0x000000FE
#define BF_DRAM_CTL37_RSVD1(v)  \
		(((v) << 1) & BM_DRAM_CTL37_RSVD1)
#define BM_DRAM_CTL37_TREF_ENABLE	0x00000001

#define HW_DRAM_CTL38	(0x00000098)

#define BP_DRAM_CTL38_RSVD2	29
#define BM_DRAM_CTL38_RSVD2	0xE0000000
#define BF_DRAM_CTL38_RSVD2(v) \
		(((v) << 29) & BM_DRAM_CTL38_RSVD2)
#define BP_DRAM_CTL38_EMRS2_DATA_0	16
#define BM_DRAM_CTL38_EMRS2_DATA_0	0x1FFF0000
#define BF_DRAM_CTL38_EMRS2_DATA_0(v)  \
		(((v) << 16) & BM_DRAM_CTL38_EMRS2_DATA_0)
#define BP_DRAM_CTL38_RSVD1	13
#define BM_DRAM_CTL38_RSVD1	0x0000E000
#define BF_DRAM_CTL38_RSVD1(v)  \
		(((v) << 13) & BM_DRAM_CTL38_RSVD1)
#define BP_DRAM_CTL38_EMRS1_DATA	0
#define BM_DRAM_CTL38_EMRS1_DATA	0x00001FFF
#define BF_DRAM_CTL38_EMRS1_DATA(v)  \
		(((v) << 0) & BM_DRAM_CTL38_EMRS1_DATA)

#define HW_DRAM_CTL39	(0x0000009c)

#define BP_DRAM_CTL39_RSVD2	29
#define BM_DRAM_CTL39_RSVD2	0xE0000000
#define BF_DRAM_CTL39_RSVD2(v) \
		(((v) << 29) & BM_DRAM_CTL39_RSVD2)
#define BP_DRAM_CTL39_EMRS2_DATA_2	16
#define BM_DRAM_CTL39_EMRS2_DATA_2	0x1FFF0000
#define BF_DRAM_CTL39_EMRS2_DATA_2(v)  \
		(((v) << 16) & BM_DRAM_CTL39_EMRS2_DATA_2)
#define BP_DRAM_CTL39_RSVD1	13
#define BM_DRAM_CTL39_RSVD1	0x0000E000
#define BF_DRAM_CTL39_RSVD1(v)  \
		(((v) << 13) & BM_DRAM_CTL39_RSVD1)
#define BP_DRAM_CTL39_EMRS2_DATA_1	0
#define BM_DRAM_CTL39_EMRS2_DATA_1	0x00001FFF
#define BF_DRAM_CTL39_EMRS2_DATA_1(v)  \
		(((v) << 0) & BM_DRAM_CTL39_EMRS2_DATA_1)

#define HW_DRAM_CTL40	(0x000000a0)

#define BP_DRAM_CTL40_TPDEX	16
#define BM_DRAM_CTL40_TPDEX	0xFFFF0000
#define BF_DRAM_CTL40_TPDEX(v) \
		(((v) << 16) & BM_DRAM_CTL40_TPDEX)
#define BP_DRAM_CTL40_RSVD1	13
#define BM_DRAM_CTL40_RSVD1	0x0000E000
#define BF_DRAM_CTL40_RSVD1(v)  \
		(((v) << 13) & BM_DRAM_CTL40_RSVD1)
#define BP_DRAM_CTL40_EMRS2_DATA_3	0
#define BM_DRAM_CTL40_EMRS2_DATA_3	0x00001FFF
#define BF_DRAM_CTL40_EMRS2_DATA_3(v)  \
		(((v) << 0) & BM_DRAM_CTL40_EMRS2_DATA_3)
#endif /* __ARCH_ARM___DRAM_H */
