/*
 * Copyright (C) 2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <linux/errno.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/delay.h>
#include <linux/io.h>
#include <mach/hardware.h>
#include <mach/gpio.h>

#include "iomux.h"
#include "mx50_pins.h"

/*!
 * @file mach-mx5/mx50_arm2_gpio.c
 *
 * @brief This file contains all the GPIO setup functions for the board.
 *
 * @ingroup GPIO
 */

static struct mxc_iomux_pin_cfg __initdata mxc_iomux_pins[] = {
	{		/* SD1 WP */
	 MX50_PIN_ECSPI2_SS0, IOMUX_CONFIG_GPIO,
	 },
	{		/* SD1 CD */
	 MX50_PIN_EIM_CRE, IOMUX_CONFIG_GPIO,
	 },
	{		/* SD1 CMD */
	 MX50_PIN_SD1_CMD, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD1 CLK */
	 MX50_PIN_SD1_CLK, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD1 D0 */
	 MX50_PIN_SD1_D0, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD1 D1 */
	 MX50_PIN_SD1_D1, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD1 D2 */
	 MX50_PIN_SD1_D2, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD1 D3 */
	 MX50_PIN_SD1_D3, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 CD */
	 MX50_PIN_SD2_CD, IOMUX_CONFIG_GPIO,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 WP */
	 MX50_PIN_SD2_WP, IOMUX_CONFIG_GPIO,
	 },
	{		/* SD2 CMD */
	 MX50_PIN_SD2_CMD, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 CLK */
	 MX50_PIN_SD2_CLK, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 D0 */
	 MX50_PIN_SD2_D0, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 D1 */
	 MX50_PIN_SD2_D1, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 D2 */
	 MX50_PIN_SD2_D2, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 D3 */
	 MX50_PIN_SD2_D3, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 D4 */
	 MX50_PIN_SD2_D4, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 D5 */
	 MX50_PIN_SD2_D5, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 D6 */
	 MX50_PIN_SD2_D6, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD2 D7 */
	 MX50_PIN_SD2_D7, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD3 CD */
	 MX50_PIN_KEY_COL2, IOMUX_CONFIG_GPIO,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_75k_PU | PAD_CTL_SRE_FAST),
	 },
	{		/* SD3 WP */
	 MX50_PIN_SD3_WP, IOMUX_CONFIG_GPIO,
	 },
	{		/* SD3 CMD */
	 MX50_PIN_SD3_CMD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	 PAD_CTL_100K_PU | PAD_CTL_DRV_HIGH),
	 },
	{		/* SD3 CLK */
	 MX50_PIN_SD3_CLK, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL | PAD_CTL_47K_PU |
	 PAD_CTL_DRV_HIGH),
	 },
	{		/* SD3 D0 */
	 MX50_PIN_SD3_D0, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	 PAD_CTL_47K_PU | PAD_CTL_DRV_HIGH),
	 },
	{		/* SD3 D1 */
	 MX50_PIN_SD3_D1, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	 PAD_CTL_47K_PU | PAD_CTL_DRV_HIGH),
	 },
	{		/* SD3 D2 */
	 MX50_PIN_SD3_D2, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	 PAD_CTL_47K_PU | PAD_CTL_DRV_HIGH),
	 },
	{		/* SD3 D3 */
	 MX50_PIN_SD3_D3, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	 PAD_CTL_47K_PU | PAD_CTL_DRV_HIGH),
	 },
	{		/* SD3 D4 */
	 MX50_PIN_SD3_D4, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	 PAD_CTL_47K_PU | PAD_CTL_DRV_HIGH),
	 },
	{		/* SD3 D5 */
	 MX50_PIN_SD3_D5, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	 PAD_CTL_47K_PU | PAD_CTL_DRV_HIGH),
	 },
	{		/* SD3 D6 */
	 MX50_PIN_SD3_D6, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	 PAD_CTL_47K_PU | PAD_CTL_DRV_HIGH),
	 },
	{		/* SD3 D7 */
	 MX50_PIN_SD3_D7, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	 PAD_CTL_47K_PU | PAD_CTL_DRV_HIGH),
	 },

	{
	 MX50_PIN_SSI_TXD, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX50_PIN_SSI_RXD, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX50_PIN_SSI_TXC, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX50_PIN_SSI_TXFS, IOMUX_CONFIG_ALT0,
	 },
	/* LINE1_DETECT (headphone detect) */
	{
	 MX50_PIN_ECSPI1_SS0, IOMUX_CONFIG_GPIO, PAD_CTL_100K_PU,
	 },
	{
	 MX50_PIN_ECSPI2_MISO, IOMUX_CONFIG_GPIO, PAD_CTL_100K_PU,
	 },
	 /* UART pad setting */
	{
	 MX50_PIN_UART1_TXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	 PAD_CTL_PKE_ENABLE | PAD_CTL_ODE_OPENDRAIN_NONE),
	 },
	{
	 MX50_PIN_UART1_RXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	 PAD_CTL_PKE_ENABLE | PAD_CTL_ODE_OPENDRAIN_NONE),
	 MUX_IN_UART1_IPP_UART_RXD_MUX_SELECT_INPUT,
	 INPUT_CTL_PATH1,
	},
	{
	 MX50_PIN_UART1_CTS, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	 PAD_CTL_PKE_ENABLE | PAD_CTL_ODE_OPENDRAIN_NONE),
	 },
	{
	 MX50_PIN_UART1_RTS, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	 PAD_CTL_PKE_ENABLE | PAD_CTL_ODE_OPENDRAIN_NONE),
	  MUX_IN_UART1_IPP_UART_RTS_B_SELECT_INPUT,
	 INPUT_CTL_PATH1,
	},
	{
	 MX50_PIN_UART2_TXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	 PAD_CTL_PKE_ENABLE | PAD_CTL_ODE_OPENDRAIN_NONE),
	 },
	{
	 MX50_PIN_UART2_RXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	 PAD_CTL_PKE_ENABLE | PAD_CTL_ODE_OPENDRAIN_NONE),
	 MUX_IN_UART2_IPP_UART_RXD_MUX_SELECT_INPUT,
	 INPUT_CTL_PATH1,
	},
	{
	 MX50_PIN_UART2_CTS, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	 PAD_CTL_PKE_ENABLE | PAD_CTL_ODE_OPENDRAIN_NONE),
	 },
	{
	 MX50_PIN_UART2_RTS, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	 PAD_CTL_PKE_ENABLE | PAD_CTL_ODE_OPENDRAIN_NONE),
	 MUX_IN_UART2_IPP_UART_RTS_B_SELECT_INPUT,
	 INPUT_CTL_PATH1,
	},
	{ /* I2C1 SDA */
	 MX50_PIN_I2C1_SDA, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_SRE_FAST | PAD_CTL_ODE_OPENDRAIN_ENABLE |
	 PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	 PAD_CTL_HYS_ENABLE),
	 },
	{ /* I2C1 SCL */
	 MX50_PIN_I2C1_SCL, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_SRE_FAST | PAD_CTL_ODE_OPENDRAIN_ENABLE |
	 PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	 PAD_CTL_HYS_ENABLE),
	 },
	{ /* I2C2 SDA */
	 MX50_PIN_I2C2_SDA, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_SRE_FAST | PAD_CTL_ODE_OPENDRAIN_ENABLE |
	 PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	 PAD_CTL_HYS_ENABLE),
	 },
	{ /* I2C2 SCL */
	 MX50_PIN_I2C2_SCL, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_SRE_FAST | PAD_CTL_ODE_OPENDRAIN_ENABLE |
	 PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	 PAD_CTL_HYS_ENABLE),
	 },
	{ /* I2C3 SDA */
	 MX50_PIN_I2C3_SDA, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_SRE_FAST | PAD_CTL_ODE_OPENDRAIN_ENABLE |
	 PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	 PAD_CTL_HYS_ENABLE),
	 },
	{ /* I2C3 SCL */
	 MX50_PIN_I2C3_SCL, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_SRE_FAST | PAD_CTL_ODE_OPENDRAIN_ENABLE |
	 PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	 PAD_CTL_HYS_ENABLE),
	 },
	 /* EPDC pins */
	{ /* EPDC D0 */
	 MX50_PIN_EPDC_D0, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC D1 */
	 MX50_PIN_EPDC_D1, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC D2 */
	 MX50_PIN_EPDC_D2, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC D3 */
	 MX50_PIN_EPDC_D3, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC D4 */
	 MX50_PIN_EPDC_D4, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC D5 */
	 MX50_PIN_EPDC_D5, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC D6 */
	 MX50_PIN_EPDC_D6, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC D7 */
	 MX50_PIN_EPDC_D7, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC GDCLK */
	 MX50_PIN_EPDC_GDCLK, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC GDSP */
	 MX50_PIN_EPDC_GDSP, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC GDOE */
	 MX50_PIN_EPDC_GDOE, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC GDRL */
	 MX50_PIN_EPDC_GDRL, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC SDCLK */
	 MX50_PIN_EPDC_SDCLK, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC SDOE */
	 MX50_PIN_EPDC_SDOE, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC SDLE */
	 MX50_PIN_EPDC_SDLE, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC SDSHR */
	 MX50_PIN_EPDC_SDSHR, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC BDR0 */
	 MX50_PIN_EPDC_BDR0, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC SDCE0 */
	 MX50_PIN_EPDC_SDCE0, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC SDCE1 */
	 MX50_PIN_EPDC_SDCE1, IOMUX_CONFIG_ALT0,
	 },
	{ /* EPDC SDCE2 */
	 MX50_PIN_EPDC_SDCE2, IOMUX_CONFIG_ALT0,
	 },
	 /* EPD PMIC pins */
	{ /* EPDC PWRSTAT - GPIO3[28] for PWR_GOOD status */
	 MX50_PIN_EPDC_PWRSTAT, IOMUX_CONFIG_ALT1,
	 },
	{ /* EPDC VCOM0 - GPIO4[21] for VCOM control */
	 MX50_PIN_EPDC_VCOM0, IOMUX_CONFIG_ALT1,
	 },
	{ /* ELCDIF D8 */
	 MX50_PIN_DISP_D8, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF D9 */
	 MX50_PIN_DISP_D9, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF D10 */
	 MX50_PIN_DISP_D10, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF D11 */
	 MX50_PIN_DISP_D11, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF D12 */
	 MX50_PIN_DISP_D12, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF D13 */
	 MX50_PIN_DISP_D13, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF D14 */
	 MX50_PIN_DISP_D14, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF D15 */
	 MX50_PIN_DISP_D15, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF VSYNC */
	 MX50_PIN_DISP_RS, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF contrast */
	 MX50_PIN_DISP_BUSY, IOMUX_CONFIG_ALT1,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF HSYNC */
	 MX50_PIN_DISP_CS, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF DRDY */
	 MX50_PIN_DISP_RD, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* ELCDIF PIXCLK */
	 MX50_PIN_DISP_WR, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_DRV_HIGH),
	 },
	{ /* UART4 TXD - GPIO6[16] for EPD PMIC WAKEUP */
	 MX50_PIN_UART4_TXD, IOMUX_CONFIG_ALT1,
	 },
	{ /* UART4 RXD - GPIO6[17] for EPD PMIC intr */
	 MX50_PIN_UART4_RXD, IOMUX_CONFIG_ALT1,
	 },
	/* USB_H1_PWR */
	{
	 MX50_PIN_EPITO, IOMUX_CONFIG_ALT2,
	 PAD_CTL_PKE_ENABLE | PAD_CTL_DRV_HIGH,
	},
	/* FIXME: USB_H1_OC, need to comment below line if
	 * one needs to debug owire.
	 */
	{
	 MX50_PIN_OWIRE, IOMUX_CONFIG_ALT2,
	 PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL | PAD_CTL_DRV_HIGH | PAD_CTL_47K_PU,
	},
	/* USB_OTG_PWR */
	{
	 MX50_PIN_PWM2, IOMUX_CONFIG_ALT2,
	 PAD_CTL_PKE_ENABLE | PAD_CTL_DRV_HIGH,
	},
	/*
	 * Set USB_OTG_OC, the pad value is the default value
	 * according to IC suggestion.
	 */
	{
	 MX50_PIN_PWM1, IOMUX_CONFIG_ALT2,
	 PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL | PAD_CTL_DRV_HIGH | PAD_CTL_47K_PU,
	 MUX_IN_USBOH1_IPP_IND_OTG_OC_SELECT_INPUT, INPUT_CTL_PATH1,
	},
	{ /* FEC_MDIO */
	 MX50_PIN_SSI_RXC, IOMUX_CONFIG_ALT6,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	  PAD_CTL_22K_PU | PAD_CTL_ODE_OPENDRAIN_ENABLE | PAD_CTL_DRV_HIGH),
	 MUX_IN_FEC_FEC_MDI_SELECT_INPUT,
	 INPUT_CTL_PATH1,
	 },
	{ /* FEC_TX_CLK */
	 MX50_PIN_DISP_D0, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE),
	 },
	{ /* FEC_RX_ER */
	 MX50_PIN_DISP_D1, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE),
	 MUX_IN_FEC_FEC_RX_ER_SELECT_INPUT,
	 INPUT_CTL_PATH0,
	 },
	{ /* FEC_CRS_DV */
	 MX50_PIN_DISP_D2, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE),
	 MUX_IN_FEC_FEC_RX_DV_SELECT_INPUT,
	 INPUT_CTL_PATH0,
	 },
	{ /* FEC_RXD1 */
	 MX50_PIN_DISP_D3, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE),
	 MUX_IN_FEC_FEC_RDATA_1_SELECT_INPUT,
	 INPUT_CTL_PATH0,
	 },
	{ /* FEC_RXD0 */
	 MX50_PIN_DISP_D4, IOMUX_CONFIG_ALT2,
	(PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE),
	 MUX_IN_FEC_FEC_RDATA_0_SELECT_INPUT,
	 INPUT_CTL_PATH0,
	 },
	{ /* FEC_TX_EN */
	 MX50_PIN_DISP_D5, IOMUX_CONFIG_ALT2,
	 PAD_CTL_DRV_HIGH,
	 },
	{ /* FEC_TXD1 */
	 MX50_PIN_DISP_D6, IOMUX_CONFIG_ALT2,
	 PAD_CTL_DRV_HIGH,
	 },
	{ /* FEC_TXD0 */
	 MX50_PIN_DISP_D7, IOMUX_CONFIG_ALT2,
	 PAD_CTL_DRV_HIGH,
	 },
	{ /* FEC_MDC */
	 MX50_PIN_SSI_RXFS, IOMUX_CONFIG_ALT6,
	 PAD_CTL_DRV_HIGH,
	 },
	{ /* CSPI SS0 */
	 MX50_PIN_CSPI_SS0, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL | PAD_CTL_DRV_HIGH),
	 },
	{ /* CSPI SS1 */
	 MX50_PIN_ECSPI1_MOSI, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	  PAD_CTL_22K_PU | PAD_CTL_DRV_HIGH),
	 },
	{
	 MX50_PIN_CSPI_MOSI, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX50_PIN_CSPI_MISO, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX50_PIN_CSPI_SCLK, IOMUX_CONFIG_ALT0,
	 },
};

static int __initdata enable_w1 = { 0 };
static int __init w1_setup(char *__unused)
{
	enable_w1 = 1;
	return cpu_is_mx50();
}

__setup("w1", w1_setup);

void __init mx50_arm2_io_init(void)
{
	int i;

	for (i = 0; i < ARRAY_SIZE(mxc_iomux_pins); i++) {
		mxc_request_iomux(mxc_iomux_pins[i].pin,
				  mxc_iomux_pins[i].mux_mode);
		if (mxc_iomux_pins[i].pad_cfg)
			mxc_iomux_set_pad(mxc_iomux_pins[i].pin,
					  mxc_iomux_pins[i].pad_cfg);
		if (mxc_iomux_pins[i].in_select)
			mxc_iomux_set_input(mxc_iomux_pins[i].in_select,
					    mxc_iomux_pins[i].in_mode);
	}

	/* SD1 WP */
	gpio_request(IOMUX_TO_GPIO(MX50_PIN_ECSPI2_SS0), "ecspi2_ss0");
	gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_ECSPI2_SS0));

	/* SD1 CD */
	gpio_request(IOMUX_TO_GPIO(MX50_PIN_EIM_CRE), "eim_cre");
	gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_EIM_CRE));

	/* SD2 WP */
	gpio_request(IOMUX_TO_GPIO(MX50_PIN_SD2_WP), "sd2_wp");
	gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_SD2_WP));

	/* SD2 CD */
	gpio_request(IOMUX_TO_GPIO(MX50_PIN_SD2_CD), "sd2_cd");
	gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_SD2_CD));

	/* SD3 WP */
	gpio_request(IOMUX_TO_GPIO(MX50_PIN_SD3_WP), "sd3_wp");
	gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_SD2_WP));

	/* SD3 CD */
	gpio_request(IOMUX_TO_GPIO(MX50_PIN_KEY_COL2), "key_col2");
	gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_KEY_COL2));

	/* LINE1_DETECT (headphone detect) */
	gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_ECSPI1_SS0));

	gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_ECSPI2_MISO));

	/* EPDC PMIC */
	gpio_request(IOMUX_TO_GPIO(MX50_PIN_UART4_TXD), "uart4_txd");
	gpio_direction_output(IOMUX_TO_GPIO(MX50_PIN_UART4_TXD), 0);

	gpio_request(IOMUX_TO_GPIO(MX50_PIN_EPDC_VCOM0), "epdc_vcom");
	gpio_direction_output(IOMUX_TO_GPIO(MX50_PIN_EPDC_VCOM0), 0);

	gpio_request(IOMUX_TO_GPIO(MX50_PIN_UART4_RXD), "uart4_rxd");
	gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_UART4_RXD));

	gpio_request(IOMUX_TO_GPIO(MX50_PIN_EPDC_PWRSTAT), "epdc_pwrstat");
	gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_EPDC_PWRSTAT));

	/* ELCDIF backlight */
	gpio_request(IOMUX_TO_GPIO(MX50_PIN_DISP_BUSY), "gp2_18");
	gpio_direction_output(IOMUX_TO_GPIO(MX50_PIN_DISP_BUSY), 1);

	if (enable_w1) {
		/* OneWire */
		mxc_request_iomux(MX50_PIN_OWIRE, IOMUX_CONFIG_ALT0);
		mxc_iomux_set_pad(MX50_PIN_OWIRE, PAD_CTL_HYS_ENABLE |
						  PAD_CTL_PKE_ENABLE |
						  PAD_CTL_ODE_OPENDRAIN_ENABLE |
						  PAD_CTL_DRV_HIGH |
						  PAD_CTL_SRE_FAST |
						  PAD_CTL_100K_PU |
						  PAD_CTL_PUE_PULL);
	}
}

/* workaround for cspi chipselect pin may not keep correct level when idle */
void mx50_arm2_gpio_spi_chipselect_active(int cspi_mode, int status,
					     int chipselect)
{
	switch (cspi_mode) {
	case 1:
		break;
	case 2:
		break;
	case 3:
		switch (chipselect) {
		case 0x1:
			/* enable ss0 */
			mxc_request_iomux(MX50_PIN_CSPI_SS0, IOMUX_CONFIG_ALT0);
			/*disable other ss */
			mxc_request_iomux(MX50_PIN_ECSPI1_MOSI, IOMUX_CONFIG_GPIO);
			/* pull up/down deassert it */
			gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_ECSPI1_MOSI));
			break;
		case 0x2:
			/* enable ss1 */
			mxc_request_iomux(MX50_PIN_ECSPI1_MOSI, IOMUX_CONFIG_ALT2);
			/*disable other ss */
			mxc_request_iomux(MX50_PIN_CSPI_SS0, IOMUX_CONFIG_GPIO);
			/* pull up/down deassert it */
			gpio_direction_input(IOMUX_TO_GPIO(MX50_PIN_CSPI_SS0));
			break;
		default:
			break;
		}
		break;

	default:
		break;
	}
}

void mx50_arm2_gpio_spi_chipselect_inactive(int cspi_mode, int status,
					       int chipselect)
{
	switch (cspi_mode) {
	case 1:
		break;
	case 2:
		break;
	case 3:
		switch (chipselect) {
		case 0x1:
			mxc_free_iomux(MX50_PIN_ECSPI1_MOSI, IOMUX_CONFIG_GPIO);
			break;
		case 0x2:
			mxc_free_iomux(MX50_PIN_CSPI_SS0, IOMUX_CONFIG_GPIO);
			break;
		default:
			break;
		}
		break;
	default:
		break;
	}

}
