
/*
 * Copyright 2008 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*!
 * @file sdma_script_code.h
 * @brief This file contains functions of SDMA scripts code initialization
 *
 * The file was generated automatically. Based on sdma scripts library.
 *
 * @ingroup SDMA
 */
/************************************************************************

			SDMA RELEASE LABEL: 	"SS15_SENNA"

************************************************************************/

#ifndef SDMA_SCRIPT_CODE_H
#define SDMA_SCRIPT_CODE_H

/*!
 * SDMA ROM scripts start addresses and sizes
 */
#define start_ADDR	0
#define start_SIZE	22

#define core_ADDR	80
#define core_SIZE	233

#define common_ADDR	313
#define common_SIZE	416

#define ap_2_ap_ADDR	729
#define ap_2_ap_SIZE	41

#define app_2_mcu_ADDR	770
#define app_2_mcu_SIZE	64

#define mcu_2_app_ADDR	834
#define mcu_2_app_SIZE	70

#define uart_2_mcu_ADDR	904
#define uart_2_mcu_SIZE	75

#define shp_2_mcu_ADDR	979
#define shp_2_mcu_SIZE	69

#define mcu_2_shp_ADDR	1048
#define mcu_2_shp_SIZE	72

#define uartsh_2_mcu_ADDR	1120
#define uartsh_2_mcu_SIZE	69

#define app_2_per_ADDR	1189
#define app_2_per_SIZE	66

#define per_2_app_ADDR	1255
#define per_2_app_SIZE	74

#define per_2_shp_ADDR	1329
#define per_2_shp_SIZE	78

#define shp_2_per_ADDR	1407
#define shp_2_per_SIZE	72

#define mcu_2_ata_ADDR	1479
#define mcu_2_ata_SIZE	81

#define ata_2_mcu_ADDR	1560
#define ata_2_mcu_SIZE	96

#define loop_DMAs_routines_ADDR	1656
#define loop_DMAs_routines_SIZE	227

#define test_ADDR	1883
#define test_SIZE	63

#define signature_ADDR	1022
#define signature_SIZE	1

/*!
 * SDMA RAM scripts start addresses and sizes
 */
#define ext_mem__ipu_ram_ADDR	6144
#define ext_mem__ipu_ram_SIZE	123

#define uart_2_per_ADDR	6267
#define uart_2_per_SIZE	73

#define uartsh_2_per_ADDR	6340
#define uartsh_2_per_SIZE	67

/*!
 * SDMA RAM image start address and size
 */
#define RAM_CODE_START_ADDR		6144
#define RAM_CODE_SIZE			263

/*!
 * Buffer that holds the SDMA RAM image
 */
__attribute__ ((__aligned__(4)))
#ifndef CONFIG_XIP_KERNEL
const
#endif
static const short sdma_code[] = {
	0x0e70, 0x0611, 0x5616, 0xc18a, 0x7d2a, 0x5ade, 0x008e, 0xc19c,
	0x7c26, 0x5be0, 0x5ef0, 0x5ce8, 0x0688, 0x08ff, 0x0011, 0x28ff,
	0x00bc, 0x53f6, 0x05df, 0x7d0b, 0x6dc5, 0x03df, 0x7d03, 0x6bd5,
	0xd84f, 0x982b, 0x6b05, 0xc6d8, 0x7e27, 0x7f29, 0x982b, 0x6d01,
	0x03df, 0x7d05, 0x6bd5, 0xc702, 0x7e18, 0x7f1a, 0x982b, 0x6b05,
	0xc678, 0x7e07, 0x7f06, 0x52de, 0x53e6, 0xc1a8, 0x7dd7, 0x0200,
	0x9803, 0x0007, 0x6004, 0x680c, 0x53f6, 0x028e, 0x00a3, 0xc2ad,
	0x048b, 0x0498, 0x0454, 0x068a, 0x982b, 0x0207, 0x680c, 0x6ddf,
	0x0107, 0x68ff, 0x60d0, 0x9834, 0x0207, 0x68ff, 0x6d28, 0x0107,
	0x6004, 0x680c, 0x9834, 0x0007, 0x68ff, 0x60d0, 0x9834, 0x0288,
	0x03a5, 0x3b03, 0x3d03, 0x4d00, 0x7d0a, 0x0804, 0x00a5, 0x00da,
	0x7d1a, 0x02a0, 0x7b01, 0x65d8, 0x7eee, 0x65ff, 0x7eec, 0x0804,
	0x02d0, 0x7d11, 0x4b00, 0x7c0f, 0x008a, 0x3003, 0x6dcf, 0x6bdf,
	0x0015, 0x0015, 0x7b02, 0x65d8, 0x0000, 0x7edd, 0x63ff, 0x7edb,
	0x3a03, 0x6dcd, 0x6bdd, 0x008a, 0x7b02, 0x65d8, 0x0000, 0x7ed3,
	0x65ff, 0x7ed1, 0x0006, 0xc23a, 0x57db, 0x52f3, 0x6ad5, 0x56fb,
	0x028e, 0x1a94, 0x6ac3, 0x62c8, 0x0269, 0x7d1e, 0x1e94, 0x6ee3,
	0x62d0, 0x5aeb, 0x62c8, 0x0248, 0x6ed3, 0x6ac8, 0x2694, 0x52eb,
	0x6ad5, 0x6ee3, 0x62c8, 0x026e, 0x7d27, 0x6ac8, 0x7f23, 0x2501,
	0x4d00, 0x7d26, 0x028e, 0x1a98, 0x6ac3, 0x62c8, 0x6ec3, 0x0260,
	0x7df1, 0x62d0, 0xc2d1, 0x98c0, 0x6ee3, 0x008f, 0x2001, 0x00d5,
	0x7d01, 0x008d, 0x05a0, 0x62c8, 0x026e, 0x7d0e, 0x6ac8, 0x7f0a,
	0x2001, 0x7cf9, 0x6add, 0x7f06, 0x0000, 0x4d00, 0x7d09, 0xc251,
	0x57db, 0x987f, 0x0007, 0x6aff, 0x62d0, 0xc2d1, 0x0458, 0x0454,
	0x6add, 0x7ff8, 0xc261, 0x987c, 0xc230, 0xc23a, 0x57db, 0x52f3,
	0x6ad5, 0x56fb, 0x028e, 0x1a94, 0x5202, 0x0269, 0x7d17, 0x1e94,
	0x5206, 0x0248, 0x5a06, 0x2694, 0x5206, 0x026e, 0x7d26, 0x6ac8,
	0x7f22, 0x2501, 0x4d00, 0x7d27, 0x028e, 0x1a98, 0x5202, 0x0260,
	0x7df3, 0x6add, 0x7f18, 0x62d0, 0xc2d1, 0x9903, 0x008f, 0x2001,
	0x00d5, 0x7d01, 0x008d, 0x05a0, 0x5206, 0x026e, 0x7d0e, 0x6ac8,
	0x7f0a, 0x2001, 0x7cf9, 0x6add, 0x7f06, 0x0000, 0x4d00, 0x7d0b,
	0xc251, 0x57db, 0x98c9, 0x0007, 0x6aff, 0x6add, 0x7ffc, 0x62d0,
	0xc2d1, 0x0458, 0x0454, 0x6add, 0x7ff6, 0xc261, 0x98c6
};
#endif
