/*
 * STMP UARTAPP Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 */

#ifndef __ARCH_ARM___UARTAPP_H
#define __ARCH_ARM___UARTAPP_H  1

#define REGS_UARTAPP_BASE (STMP3XXX_REGS_BASE + 0x6c000)
#define REGS_UARTAPP1_BASE (STMP3XXX_REGS_BASE + 0x6c000)
#define REGS_UARTAPP1_PHYS (0x8006C000)
#define REGS_UARTAPP2_BASE (STMP3XXX_REGS_BASE + 0x6e000)
#define REGS_UARTAPP2_PHYS (0x8006E000)
#define REGS_UARTAPP_SIZE 0x00002000

#define HW_UARTAPP_CTRL0	(0x00000000)
#define HW_UARTAPP_CTRL0_SET	(0x00000004)
#define HW_UARTAPP_CTRL0_CLR	(0x00000008)
#define HW_UARTAPP_CTRL0_TOG	(0x0000000c)
#define HW_UARTAPP_CTRL0_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL0)
#define HW_UARTAPP_CTRL0_SET_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL0_SET)
#define HW_UARTAPP_CTRL0_CLR_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL0_CLR)
#define HW_UARTAPP_CTRL0_TOG_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL0_TOG)

#define BM_UARTAPP_CTRL0_SFTRST	0x80000000
#define BM_UARTAPP_CTRL0_CLKGATE	0x40000000
#define BM_UARTAPP_CTRL0_RUN	0x20000000
#define BM_UARTAPP_CTRL0_RX_SOURCE	0x10000000
#define BM_UARTAPP_CTRL0_RXTO_ENABLE	0x08000000
#define BP_UARTAPP_CTRL0_RXTIMEOUT	16
#define BM_UARTAPP_CTRL0_RXTIMEOUT	0x07FF0000
#define BF_UARTAPP_CTRL0_RXTIMEOUT(v)  \
		(((v) << 16) & BM_UARTAPP_CTRL0_RXTIMEOUT)
#define BP_UARTAPP_CTRL0_XFER_COUNT	0
#define BM_UARTAPP_CTRL0_XFER_COUNT	0x0000FFFF
#define BF_UARTAPP_CTRL0_XFER_COUNT(v)  \
		(((v) << 0) & BM_UARTAPP_CTRL0_XFER_COUNT)

#define HW_UARTAPP_CTRL1	(0x00000010)
#define HW_UARTAPP_CTRL1_SET	(0x00000014)
#define HW_UARTAPP_CTRL1_CLR	(0x00000018)
#define HW_UARTAPP_CTRL1_TOG	(0x0000001c)
#define HW_UARTAPP_CTRL1_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL1)
#define HW_UARTAPP_CTRL1_SET_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL1_SET)
#define HW_UARTAPP_CTRL1_CLR_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL1_CLR)
#define HW_UARTAPP_CTRL1_TOG_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL1_TOG)

#define BP_UARTAPP_CTRL1_RSVD2	29
#define BM_UARTAPP_CTRL1_RSVD2	0xE0000000
#define BF_UARTAPP_CTRL1_RSVD2(v) \
		(((v) << 29) & BM_UARTAPP_CTRL1_RSVD2)
#define BM_UARTAPP_CTRL1_RUN	0x10000000
#define BP_UARTAPP_CTRL1_RSVD1	16
#define BM_UARTAPP_CTRL1_RSVD1	0x0FFF0000
#define BF_UARTAPP_CTRL1_RSVD1(v)  \
		(((v) << 16) & BM_UARTAPP_CTRL1_RSVD1)
#define BP_UARTAPP_CTRL1_XFER_COUNT	0
#define BM_UARTAPP_CTRL1_XFER_COUNT	0x0000FFFF
#define BF_UARTAPP_CTRL1_XFER_COUNT(v)  \
		(((v) << 0) & BM_UARTAPP_CTRL1_XFER_COUNT)

#define HW_UARTAPP_CTRL2	(0x00000020)
#define HW_UARTAPP_CTRL2_SET	(0x00000024)
#define HW_UARTAPP_CTRL2_CLR	(0x00000028)
#define HW_UARTAPP_CTRL2_TOG	(0x0000002c)
#define HW_UARTAPP_CTRL2_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL2)
#define HW_UARTAPP_CTRL2_SET_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL2_SET)
#define HW_UARTAPP_CTRL2_CLR_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL2_CLR)
#define HW_UARTAPP_CTRL2_TOG_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_CTRL2_TOG)

#define BM_UARTAPP_CTRL2_INVERT_RTS	0x80000000
#define BM_UARTAPP_CTRL2_INVERT_CTS	0x40000000
#define BM_UARTAPP_CTRL2_INVERT_TX	0x20000000
#define BM_UARTAPP_CTRL2_INVERT_RX	0x10000000
#define BM_UARTAPP_CTRL2_RTS_SEMAPHORE	0x08000000
#define BM_UARTAPP_CTRL2_DMAONERR	0x04000000
#define BM_UARTAPP_CTRL2_TXDMAE	0x02000000
#define BM_UARTAPP_CTRL2_RXDMAE	0x01000000
#define BM_UARTAPP_CTRL2_RSVD2	0x00800000
#define BP_UARTAPP_CTRL2_RXIFLSEL	20
#define BM_UARTAPP_CTRL2_RXIFLSEL	0x00700000
#define BF_UARTAPP_CTRL2_RXIFLSEL(v)  \
		(((v) << 20) & BM_UARTAPP_CTRL2_RXIFLSEL)
#define BV_UARTAPP_CTRL2_RXIFLSEL__NOT_EMPTY      0x0
#define BV_UARTAPP_CTRL2_RXIFLSEL__ONE_QUARTER    0x1
#define BV_UARTAPP_CTRL2_RXIFLSEL__ONE_HALF       0x2
#define BV_UARTAPP_CTRL2_RXIFLSEL__THREE_QUARTERS 0x3
#define BV_UARTAPP_CTRL2_RXIFLSEL__SEVEN_EIGHTHS  0x4
#define BV_UARTAPP_CTRL2_RXIFLSEL__INVALID5       0x5
#define BV_UARTAPP_CTRL2_RXIFLSEL__INVALID6       0x6
#define BV_UARTAPP_CTRL2_RXIFLSEL__INVALID7       0x7
#define BM_UARTAPP_CTRL2_RSVD3	0x00080000
#define BP_UARTAPP_CTRL2_TXIFLSEL	16
#define BM_UARTAPP_CTRL2_TXIFLSEL	0x00070000
#define BF_UARTAPP_CTRL2_TXIFLSEL(v)  \
		(((v) << 16) & BM_UARTAPP_CTRL2_TXIFLSEL)
#define BV_UARTAPP_CTRL2_TXIFLSEL__EMPTY          0x0
#define BV_UARTAPP_CTRL2_TXIFLSEL__ONE_QUARTER    0x1
#define BV_UARTAPP_CTRL2_TXIFLSEL__ONE_HALF       0x2
#define BV_UARTAPP_CTRL2_TXIFLSEL__THREE_QUARTERS 0x3
#define BV_UARTAPP_CTRL2_TXIFLSEL__SEVEN_EIGHTHS  0x4
#define BV_UARTAPP_CTRL2_TXIFLSEL__INVALID5       0x5
#define BV_UARTAPP_CTRL2_TXIFLSEL__INVALID6       0x6
#define BV_UARTAPP_CTRL2_TXIFLSEL__INVALID7       0x7
#define BM_UARTAPP_CTRL2_CTSEN	0x00008000
#define BM_UARTAPP_CTRL2_RTSEN	0x00004000
#define BM_UARTAPP_CTRL2_OUT2	0x00002000
#define BM_UARTAPP_CTRL2_OUT1	0x00001000
#define BM_UARTAPP_CTRL2_RTS	0x00000800
#define BM_UARTAPP_CTRL2_DTR	0x00000400
#define BM_UARTAPP_CTRL2_RXE	0x00000200
#define BM_UARTAPP_CTRL2_TXE	0x00000100
#define BM_UARTAPP_CTRL2_LBE	0x00000080
#define BM_UARTAPP_CTRL2_USE_LCR2	0x00000040
#define BP_UARTAPP_CTRL2_RSVD4	3
#define BM_UARTAPP_CTRL2_RSVD4	0x00000038
#define BF_UARTAPP_CTRL2_RSVD4(v)  \
		(((v) << 3) & BM_UARTAPP_CTRL2_RSVD4)
#define BM_UARTAPP_CTRL2_SIRLP	0x00000004
#define BM_UARTAPP_CTRL2_SIREN	0x00000002
#define BM_UARTAPP_CTRL2_UARTEN	0x00000001

#define HW_UARTAPP_LINECTRL	(0x00000030)
#define HW_UARTAPP_LINECTRL_SET	(0x00000034)
#define HW_UARTAPP_LINECTRL_CLR	(0x00000038)
#define HW_UARTAPP_LINECTRL_TOG	(0x0000003c)
#define HW_UARTAPP_LINECTRL_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_LINECTRL)
#define HW_UARTAPP_LINECTRL_SET_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_LINECTRL_SET)
#define HW_UARTAPP_LINECTRL_CLR_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_LINECTRL_CLR)
#define HW_UARTAPP_LINECTRL_TOG_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_LINECTRL_TOG)

#define BP_UARTAPP_LINECTRL_BAUD_DIVINT	16
#define BM_UARTAPP_LINECTRL_BAUD_DIVINT	0xFFFF0000
#define BF_UARTAPP_LINECTRL_BAUD_DIVINT(v) \
		(((v) << 16) & BM_UARTAPP_LINECTRL_BAUD_DIVINT)
#define BP_UARTAPP_LINECTRL_RSVD	14
#define BM_UARTAPP_LINECTRL_RSVD	0x0000C000
#define BF_UARTAPP_LINECTRL_RSVD(v)  \
		(((v) << 14) & BM_UARTAPP_LINECTRL_RSVD)
#define BP_UARTAPP_LINECTRL_BAUD_DIVFRAC	8
#define BM_UARTAPP_LINECTRL_BAUD_DIVFRAC	0x00003F00
#define BF_UARTAPP_LINECTRL_BAUD_DIVFRAC(v)  \
		(((v) << 8) & BM_UARTAPP_LINECTRL_BAUD_DIVFRAC)
#define BM_UARTAPP_LINECTRL_SPS	0x00000080
#define BP_UARTAPP_LINECTRL_WLEN	5
#define BM_UARTAPP_LINECTRL_WLEN	0x00000060
#define BF_UARTAPP_LINECTRL_WLEN(v)  \
		(((v) << 5) & BM_UARTAPP_LINECTRL_WLEN)
#define BM_UARTAPP_LINECTRL_FEN	0x00000010
#define BM_UARTAPP_LINECTRL_STP2	0x00000008
#define BM_UARTAPP_LINECTRL_EPS	0x00000004
#define BM_UARTAPP_LINECTRL_PEN	0x00000002
#define BM_UARTAPP_LINECTRL_BRK	0x00000001

#define HW_UARTAPP_LINECTRL2	(0x00000040)
#define HW_UARTAPP_LINECTRL2_SET	(0x00000044)
#define HW_UARTAPP_LINECTRL2_CLR	(0x00000048)
#define HW_UARTAPP_LINECTRL2_TOG	(0x0000004c)
#define HW_UARTAPP_LINECTRL2_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_LINECTRL2)
#define HW_UARTAPP_LINECTRL2_SET_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_LINECTRL2_SET)
#define HW_UARTAPP_LINECTRL2_CLR_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_LINECTRL2_CLR)
#define HW_UARTAPP_LINECTRL2_TOG_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_LINECTRL2_TOG)

#define BP_UARTAPP_LINECTRL2_BAUD_DIVINT	16
#define BM_UARTAPP_LINECTRL2_BAUD_DIVINT	0xFFFF0000
#define BF_UARTAPP_LINECTRL2_BAUD_DIVINT(v) \
		(((v) << 16) & BM_UARTAPP_LINECTRL2_BAUD_DIVINT)
#define BP_UARTAPP_LINECTRL2_RSVD	14
#define BM_UARTAPP_LINECTRL2_RSVD	0x0000C000
#define BF_UARTAPP_LINECTRL2_RSVD(v)  \
		(((v) << 14) & BM_UARTAPP_LINECTRL2_RSVD)
#define BP_UARTAPP_LINECTRL2_BAUD_DIVFRAC	8
#define BM_UARTAPP_LINECTRL2_BAUD_DIVFRAC	0x00003F00
#define BF_UARTAPP_LINECTRL2_BAUD_DIVFRAC(v)  \
		(((v) << 8) & BM_UARTAPP_LINECTRL2_BAUD_DIVFRAC)
#define BM_UARTAPP_LINECTRL2_SPS	0x00000080
#define BP_UARTAPP_LINECTRL2_WLEN	5
#define BM_UARTAPP_LINECTRL2_WLEN	0x00000060
#define BF_UARTAPP_LINECTRL2_WLEN(v)  \
		(((v) << 5) & BM_UARTAPP_LINECTRL2_WLEN)
#define BM_UARTAPP_LINECTRL2_FEN	0x00000010
#define BM_UARTAPP_LINECTRL2_STP2	0x00000008
#define BM_UARTAPP_LINECTRL2_EPS	0x00000004
#define BM_UARTAPP_LINECTRL2_PEN	0x00000002
#define BM_UARTAPP_LINECTRL2_RSVD1	0x00000001

#define HW_UARTAPP_INTR	(0x00000050)
#define HW_UARTAPP_INTR_SET	(0x00000054)
#define HW_UARTAPP_INTR_CLR	(0x00000058)
#define HW_UARTAPP_INTR_TOG	(0x0000005c)
#define HW_UARTAPP_INTR_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_INTR)
#define HW_UARTAPP_INTR_SET_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_INTR_SET)
#define HW_UARTAPP_INTR_CLR_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_INTR_CLR)
#define HW_UARTAPP_INTR_TOG_ADDR(x) \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_INTR_TOG)

#define BP_UARTAPP_INTR_RSVD1	27
#define BM_UARTAPP_INTR_RSVD1	0xF8000000
#define BF_UARTAPP_INTR_RSVD1(v) \
		(((v) << 27) & BM_UARTAPP_INTR_RSVD1)
#define BM_UARTAPP_INTR_OEIEN	0x04000000
#define BM_UARTAPP_INTR_BEIEN	0x02000000
#define BM_UARTAPP_INTR_PEIEN	0x01000000
#define BM_UARTAPP_INTR_FEIEN	0x00800000
#define BM_UARTAPP_INTR_RTIEN	0x00400000
#define BM_UARTAPP_INTR_TXIEN	0x00200000
#define BM_UARTAPP_INTR_RXIEN	0x00100000
#define BM_UARTAPP_INTR_DSRMIEN	0x00080000
#define BM_UARTAPP_INTR_DCDMIEN	0x00040000
#define BM_UARTAPP_INTR_CTSMIEN	0x00020000
#define BM_UARTAPP_INTR_RIMIEN	0x00010000
#define BP_UARTAPP_INTR_RSVD2	11
#define BM_UARTAPP_INTR_RSVD2	0x0000F800
#define BF_UARTAPP_INTR_RSVD2(v)  \
		(((v) << 11) & BM_UARTAPP_INTR_RSVD2)
#define BM_UARTAPP_INTR_OEIS	0x00000400
#define BM_UARTAPP_INTR_BEIS	0x00000200
#define BM_UARTAPP_INTR_PEIS	0x00000100
#define BM_UARTAPP_INTR_FEIS	0x00000080
#define BM_UARTAPP_INTR_RTIS	0x00000040
#define BM_UARTAPP_INTR_TXIS	0x00000020
#define BM_UARTAPP_INTR_RXIS	0x00000010
#define BM_UARTAPP_INTR_DSRMIS	0x00000008
#define BM_UARTAPP_INTR_DCDMIS	0x00000004
#define BM_UARTAPP_INTR_CTSMIS	0x00000002
#define BM_UARTAPP_INTR_RIMIS	0x00000001

#define HW_UARTAPP_DATA	(0x00000060)
#define HW_UARTAPP_DATA_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_DATA)

#define BP_UARTAPP_DATA_DATA	0
#define BM_UARTAPP_DATA_DATA	0xFFFFFFFF
#define BF_UARTAPP_DATA_DATA(v)	(v)

#define HW_UARTAPP_STAT	(0x00000070)
#define HW_UARTAPP_STAT_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_STAT)

#define BM_UARTAPP_STAT_PRESENT	0x80000000
#define BV_UARTAPP_STAT_PRESENT__UNAVAILABLE 0x0
#define BV_UARTAPP_STAT_PRESENT__AVAILABLE   0x1
#define BM_UARTAPP_STAT_HISPEED	0x40000000
#define BV_UARTAPP_STAT_HISPEED__UNAVAILABLE 0x0
#define BV_UARTAPP_STAT_HISPEED__AVAILABLE   0x1
#define BM_UARTAPP_STAT_BUSY	0x20000000
#define BM_UARTAPP_STAT_CTS	0x10000000
#define BM_UARTAPP_STAT_TXFE	0x08000000
#define BM_UARTAPP_STAT_RXFF	0x04000000
#define BM_UARTAPP_STAT_TXFF	0x02000000
#define BM_UARTAPP_STAT_RXFE	0x01000000
#define BP_UARTAPP_STAT_RXBYTE_INVALID	20
#define BM_UARTAPP_STAT_RXBYTE_INVALID	0x00F00000
#define BF_UARTAPP_STAT_RXBYTE_INVALID(v)  \
		(((v) << 20) & BM_UARTAPP_STAT_RXBYTE_INVALID)
#define BM_UARTAPP_STAT_OERR	0x00080000
#define BM_UARTAPP_STAT_BERR	0x00040000
#define BM_UARTAPP_STAT_PERR	0x00020000
#define BM_UARTAPP_STAT_FERR	0x00010000
#define BP_UARTAPP_STAT_RXCOUNT	0
#define BM_UARTAPP_STAT_RXCOUNT	0x0000FFFF
#define BF_UARTAPP_STAT_RXCOUNT(v)  \
		(((v) << 0) & BM_UARTAPP_STAT_RXCOUNT)

#define HW_UARTAPP_DEBUG	(0x00000080)
#define HW_UARTAPP_DEBUG_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_DEBUG)

#define BP_UARTAPP_DEBUG_RXIBAUD_DIV	16
#define BM_UARTAPP_DEBUG_RXIBAUD_DIV	0xFFFF0000
#define BF_UARTAPP_DEBUG_RXIBAUD_DIV(v) \
		(((v) << 16) & BM_UARTAPP_DEBUG_RXIBAUD_DIV)
#define BP_UARTAPP_DEBUG_RXFBAUD_DIV	10
#define BM_UARTAPP_DEBUG_RXFBAUD_DIV	0x0000FC00
#define BF_UARTAPP_DEBUG_RXFBAUD_DIV(v)  \
		(((v) << 10) & BM_UARTAPP_DEBUG_RXFBAUD_DIV)
#define BP_UARTAPP_DEBUG_RSVD1	6
#define BM_UARTAPP_DEBUG_RSVD1	0x000003C0
#define BF_UARTAPP_DEBUG_RSVD1(v)  \
		(((v) << 6) & BM_UARTAPP_DEBUG_RSVD1)
#define BM_UARTAPP_DEBUG_TXDMARUN	0x00000020
#define BM_UARTAPP_DEBUG_RXDMARUN	0x00000010
#define BM_UARTAPP_DEBUG_TXCMDEND	0x00000008
#define BM_UARTAPP_DEBUG_RXCMDEND	0x00000004
#define BM_UARTAPP_DEBUG_TXDMARQ	0x00000002
#define BM_UARTAPP_DEBUG_RXDMARQ	0x00000001

#define HW_UARTAPP_VERSION	(0x00000090)
#define HW_UARTAPP_VERSION_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_VERSION)

#define BP_UARTAPP_VERSION_MAJOR	24
#define BM_UARTAPP_VERSION_MAJOR	0xFF000000
#define BF_UARTAPP_VERSION_MAJOR(v) \
		(((v) << 24) & BM_UARTAPP_VERSION_MAJOR)
#define BP_UARTAPP_VERSION_MINOR	16
#define BM_UARTAPP_VERSION_MINOR	0x00FF0000
#define BF_UARTAPP_VERSION_MINOR(v)  \
		(((v) << 16) & BM_UARTAPP_VERSION_MINOR)
#define BP_UARTAPP_VERSION_STEP	0
#define BM_UARTAPP_VERSION_STEP	0x0000FFFF
#define BF_UARTAPP_VERSION_STEP(v)  \
		(((v) << 0) & BM_UARTAPP_VERSION_STEP)

#define HW_UARTAPP_AUTOBAUD	(0x000000a0)
#define HW_UARTAPP_AUTOBAUD_ADDR(x)  \
		(REGS_UARTAPP_BASE(x) + HW_UARTAPP_AUTOBAUD)

#define BP_UARTAPP_AUTOBAUD_REFCHAR1	24
#define BM_UARTAPP_AUTOBAUD_REFCHAR1	0xFF000000
#define BF_UARTAPP_AUTOBAUD_REFCHAR1(v) \
		(((v) << 24) & BM_UARTAPP_AUTOBAUD_REFCHAR1)
#define BP_UARTAPP_AUTOBAUD_REFCHAR0	16
#define BM_UARTAPP_AUTOBAUD_REFCHAR0	0x00FF0000
#define BF_UARTAPP_AUTOBAUD_REFCHAR0(v)  \
		(((v) << 16) & BM_UARTAPP_AUTOBAUD_REFCHAR0)
#define BP_UARTAPP_AUTOBAUD_RSVD1	5
#define BM_UARTAPP_AUTOBAUD_RSVD1	0x0000FFE0
#define BF_UARTAPP_AUTOBAUD_RSVD1(v)  \
		(((v) << 5) & BM_UARTAPP_AUTOBAUD_RSVD1)
#define BM_UARTAPP_AUTOBAUD_UPDATE_TX	0x00000010
#define BM_UARTAPP_AUTOBAUD_TWO_REF_CHARS	0x00000008
#define BM_UARTAPP_AUTOBAUD_START_WITH_RUNBIT	0x00000004
#define BM_UARTAPP_AUTOBAUD_START_BAUD_DETECT	0x00000002
#define BM_UARTAPP_AUTOBAUD_BAUD_DETECT_ENABLE	0x00000001
#endif /* __ARCH_ARM___UARTAPP_H */
