/*
 * STMP AUDIOOUT Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 */

#ifndef __ARCH_ARM___AUDIOOUT_H
#define __ARCH_ARM___AUDIOOUT_H  1

#define REGS_AUDIOOUT_BASE (STMP3XXX_REGS_BASE + 0x48000)
#define REGS_AUDIOOUT_PHYS (0x80048000)
#define REGS_AUDIOOUT_SIZE 0x00002000

#define HW_AUDIOOUT_CTRL	(0x00000000)
#define HW_AUDIOOUT_CTRL_SET	(0x00000004)
#define HW_AUDIOOUT_CTRL_CLR	(0x00000008)
#define HW_AUDIOOUT_CTRL_TOG	(0x0000000c)
#define HW_AUDIOOUT_CTRL_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_CTRL)
#define HW_AUDIOOUT_CTRL_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_CTRL_SET)
#define HW_AUDIOOUT_CTRL_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_CTRL_CLR)
#define HW_AUDIOOUT_CTRL_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_CTRL_TOG)

#define BM_AUDIOOUT_CTRL_SFTRST	0x80000000
#define BM_AUDIOOUT_CTRL_CLKGATE	0x40000000
#define BP_AUDIOOUT_CTRL_RSRVD4	21
#define BM_AUDIOOUT_CTRL_RSRVD4	0x3FE00000
#define BF_AUDIOOUT_CTRL_RSRVD4(v)  \
		(((v) << 21) & BM_AUDIOOUT_CTRL_RSRVD4)
#define BP_AUDIOOUT_CTRL_DMAWAIT_COUNT	16
#define BM_AUDIOOUT_CTRL_DMAWAIT_COUNT	0x001F0000
#define BF_AUDIOOUT_CTRL_DMAWAIT_COUNT(v)  \
		(((v) << 16) & BM_AUDIOOUT_CTRL_DMAWAIT_COUNT)
#define BM_AUDIOOUT_CTRL_RSRVD3	0x00008000
#define BM_AUDIOOUT_CTRL_LR_SWAP	0x00004000
#define BM_AUDIOOUT_CTRL_EDGE_SYNC	0x00002000
#define BM_AUDIOOUT_CTRL_INVERT_1BIT	0x00001000
#define BP_AUDIOOUT_CTRL_RSRVD2	10
#define BM_AUDIOOUT_CTRL_RSRVD2	0x00000C00
#define BF_AUDIOOUT_CTRL_RSRVD2(v)  \
		(((v) << 10) & BM_AUDIOOUT_CTRL_RSRVD2)
#define BP_AUDIOOUT_CTRL_SS3D_EFFECT	8
#define BM_AUDIOOUT_CTRL_SS3D_EFFECT	0x00000300
#define BF_AUDIOOUT_CTRL_SS3D_EFFECT(v)  \
		(((v) << 8) & BM_AUDIOOUT_CTRL_SS3D_EFFECT)
#define BM_AUDIOOUT_CTRL_RSRVD1	0x00000080
#define BM_AUDIOOUT_CTRL_WORD_LENGTH	0x00000040
#define BM_AUDIOOUT_CTRL_DAC_ZERO_ENABLE	0x00000020
#define BM_AUDIOOUT_CTRL_LOOPBACK	0x00000010
#define BM_AUDIOOUT_CTRL_FIFO_UNDERFLOW_IRQ	0x00000008
#define BM_AUDIOOUT_CTRL_FIFO_OVERFLOW_IRQ	0x00000004
#define BM_AUDIOOUT_CTRL_FIFO_ERROR_IRQ_EN	0x00000002
#define BM_AUDIOOUT_CTRL_RUN	0x00000001

#define HW_AUDIOOUT_STAT	(0x00000010)
#define HW_AUDIOOUT_STAT_SET	(0x00000014)
#define HW_AUDIOOUT_STAT_CLR	(0x00000018)
#define HW_AUDIOOUT_STAT_TOG	(0x0000001c)
#define HW_AUDIOOUT_STAT_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_STAT)
#define HW_AUDIOOUT_STAT_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_STAT_SET)
#define HW_AUDIOOUT_STAT_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_STAT_CLR)
#define HW_AUDIOOUT_STAT_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_STAT_TOG)

#define BM_AUDIOOUT_STAT_DAC_PRESENT	0x80000000
#define BP_AUDIOOUT_STAT_RSRVD1	0
#define BM_AUDIOOUT_STAT_RSRVD1	0x7FFFFFFF
#define BF_AUDIOOUT_STAT_RSRVD1(v)  \
		(((v) << 0) & BM_AUDIOOUT_STAT_RSRVD1)

#define HW_AUDIOOUT_DACSRR	(0x00000020)
#define HW_AUDIOOUT_DACSRR_SET	(0x00000024)
#define HW_AUDIOOUT_DACSRR_CLR	(0x00000028)
#define HW_AUDIOOUT_DACSRR_TOG	(0x0000002c)
#define HW_AUDIOOUT_DACSRR_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACSRR)
#define HW_AUDIOOUT_DACSRR_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACSRR_SET)
#define HW_AUDIOOUT_DACSRR_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACSRR_CLR)
#define HW_AUDIOOUT_DACSRR_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACSRR_TOG)

#define BM_AUDIOOUT_DACSRR_OSR	0x80000000
#define BV_AUDIOOUT_DACSRR_OSR__OSR6  0x0
#define BV_AUDIOOUT_DACSRR_OSR__OSR12 0x1
#define BP_AUDIOOUT_DACSRR_BASEMULT	28
#define BM_AUDIOOUT_DACSRR_BASEMULT	0x70000000
#define BF_AUDIOOUT_DACSRR_BASEMULT(v)  \
		(((v) << 28) & BM_AUDIOOUT_DACSRR_BASEMULT)
#define BV_AUDIOOUT_DACSRR_BASEMULT__SINGLE_RATE 0x1
#define BV_AUDIOOUT_DACSRR_BASEMULT__DOUBLE_RATE 0x2
#define BV_AUDIOOUT_DACSRR_BASEMULT__QUAD_RATE   0x4
#define BM_AUDIOOUT_DACSRR_RSRVD2	0x08000000
#define BP_AUDIOOUT_DACSRR_SRC_HOLD	24
#define BM_AUDIOOUT_DACSRR_SRC_HOLD	0x07000000
#define BF_AUDIOOUT_DACSRR_SRC_HOLD(v)  \
		(((v) << 24) & BM_AUDIOOUT_DACSRR_SRC_HOLD)
#define BP_AUDIOOUT_DACSRR_RSRVD1	21
#define BM_AUDIOOUT_DACSRR_RSRVD1	0x00E00000
#define BF_AUDIOOUT_DACSRR_RSRVD1(v)  \
		(((v) << 21) & BM_AUDIOOUT_DACSRR_RSRVD1)
#define BP_AUDIOOUT_DACSRR_SRC_INT	16
#define BM_AUDIOOUT_DACSRR_SRC_INT	0x001F0000
#define BF_AUDIOOUT_DACSRR_SRC_INT(v)  \
		(((v) << 16) & BM_AUDIOOUT_DACSRR_SRC_INT)
#define BP_AUDIOOUT_DACSRR_RSRVD0	13
#define BM_AUDIOOUT_DACSRR_RSRVD0	0x0000E000
#define BF_AUDIOOUT_DACSRR_RSRVD0(v)  \
		(((v) << 13) & BM_AUDIOOUT_DACSRR_RSRVD0)
#define BP_AUDIOOUT_DACSRR_SRC_FRAC	0
#define BM_AUDIOOUT_DACSRR_SRC_FRAC	0x00001FFF
#define BF_AUDIOOUT_DACSRR_SRC_FRAC(v)  \
		(((v) << 0) & BM_AUDIOOUT_DACSRR_SRC_FRAC)

#define HW_AUDIOOUT_DACVOLUME	(0x00000030)
#define HW_AUDIOOUT_DACVOLUME_SET	(0x00000034)
#define HW_AUDIOOUT_DACVOLUME_CLR	(0x00000038)
#define HW_AUDIOOUT_DACVOLUME_TOG	(0x0000003c)
#define HW_AUDIOOUT_DACVOLUME_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACVOLUME)
#define HW_AUDIOOUT_DACVOLUME_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACVOLUME_SET)
#define HW_AUDIOOUT_DACVOLUME_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACVOLUME_CLR)
#define HW_AUDIOOUT_DACVOLUME_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACVOLUME_TOG)

#define BP_AUDIOOUT_DACVOLUME_RSRVD4	29
#define BM_AUDIOOUT_DACVOLUME_RSRVD4	0xE0000000
#define BF_AUDIOOUT_DACVOLUME_RSRVD4(v) \
		(((v) << 29) & BM_AUDIOOUT_DACVOLUME_RSRVD4)
#define BM_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_LEFT	0x10000000
#define BP_AUDIOOUT_DACVOLUME_RSRVD3	26
#define BM_AUDIOOUT_DACVOLUME_RSRVD3	0x0C000000
#define BF_AUDIOOUT_DACVOLUME_RSRVD3(v)  \
		(((v) << 26) & BM_AUDIOOUT_DACVOLUME_RSRVD3)
#define BM_AUDIOOUT_DACVOLUME_EN_ZCD	0x02000000
#define BM_AUDIOOUT_DACVOLUME_MUTE_LEFT	0x01000000
#define BP_AUDIOOUT_DACVOLUME_VOLUME_LEFT	16
#define BM_AUDIOOUT_DACVOLUME_VOLUME_LEFT	0x00FF0000
#define BF_AUDIOOUT_DACVOLUME_VOLUME_LEFT(v)  \
		(((v) << 16) & BM_AUDIOOUT_DACVOLUME_VOLUME_LEFT)
#define BP_AUDIOOUT_DACVOLUME_RSRVD2	13
#define BM_AUDIOOUT_DACVOLUME_RSRVD2	0x0000E000
#define BF_AUDIOOUT_DACVOLUME_RSRVD2(v)  \
		(((v) << 13) & BM_AUDIOOUT_DACVOLUME_RSRVD2)
#define BM_AUDIOOUT_DACVOLUME_VOLUME_UPDATE_RIGHT	0x00001000
#define BP_AUDIOOUT_DACVOLUME_RSRVD1	9
#define BM_AUDIOOUT_DACVOLUME_RSRVD1	0x00000E00
#define BF_AUDIOOUT_DACVOLUME_RSRVD1(v)  \
		(((v) << 9) & BM_AUDIOOUT_DACVOLUME_RSRVD1)
#define BM_AUDIOOUT_DACVOLUME_MUTE_RIGHT	0x00000100
#define BP_AUDIOOUT_DACVOLUME_VOLUME_RIGHT	0
#define BM_AUDIOOUT_DACVOLUME_VOLUME_RIGHT	0x000000FF
#define BF_AUDIOOUT_DACVOLUME_VOLUME_RIGHT(v)  \
		(((v) << 0) & BM_AUDIOOUT_DACVOLUME_VOLUME_RIGHT)

#define HW_AUDIOOUT_DACDEBUG	(0x00000040)
#define HW_AUDIOOUT_DACDEBUG_SET	(0x00000044)
#define HW_AUDIOOUT_DACDEBUG_CLR	(0x00000048)
#define HW_AUDIOOUT_DACDEBUG_TOG	(0x0000004c)
#define HW_AUDIOOUT_DACDEBUG_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACDEBUG)
#define HW_AUDIOOUT_DACDEBUG_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACDEBUG_SET)
#define HW_AUDIOOUT_DACDEBUG_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACDEBUG_CLR)
#define HW_AUDIOOUT_DACDEBUG_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DACDEBUG_TOG)

#define BM_AUDIOOUT_DACDEBUG_ENABLE_DACDMA	0x80000000
#define BP_AUDIOOUT_DACDEBUG_RSRVD2	12
#define BM_AUDIOOUT_DACDEBUG_RSRVD2	0x7FFFF000
#define BF_AUDIOOUT_DACDEBUG_RSRVD2(v)  \
		(((v) << 12) & BM_AUDIOOUT_DACDEBUG_RSRVD2)
#define BP_AUDIOOUT_DACDEBUG_RAM_SS	8
#define BM_AUDIOOUT_DACDEBUG_RAM_SS	0x00000F00
#define BF_AUDIOOUT_DACDEBUG_RAM_SS(v)  \
		(((v) << 8) & BM_AUDIOOUT_DACDEBUG_RAM_SS)
#define BP_AUDIOOUT_DACDEBUG_RSRVD1	6
#define BM_AUDIOOUT_DACDEBUG_RSRVD1	0x000000C0
#define BF_AUDIOOUT_DACDEBUG_RSRVD1(v)  \
		(((v) << 6) & BM_AUDIOOUT_DACDEBUG_RSRVD1)
#define BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_CLK_CROSS	0x00000020
#define BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_CLK_CROSS	0x00000010
#define BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT1_HAND_SHAKE	0x00000008
#define BM_AUDIOOUT_DACDEBUG_SET_INTERRUPT0_HAND_SHAKE	0x00000004
#define BM_AUDIOOUT_DACDEBUG_DMA_PREQ	0x00000002
#define BM_AUDIOOUT_DACDEBUG_FIFO_STATUS	0x00000001

#define HW_AUDIOOUT_HPVOL	(0x00000050)
#define HW_AUDIOOUT_HPVOL_SET	(0x00000054)
#define HW_AUDIOOUT_HPVOL_CLR	(0x00000058)
#define HW_AUDIOOUT_HPVOL_TOG	(0x0000005c)
#define HW_AUDIOOUT_HPVOL_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_HPVOL)
#define HW_AUDIOOUT_HPVOL_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_HPVOL_SET)
#define HW_AUDIOOUT_HPVOL_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_HPVOL_CLR)
#define HW_AUDIOOUT_HPVOL_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_HPVOL_TOG)

#define BP_AUDIOOUT_HPVOL_RSRVD5	29
#define BM_AUDIOOUT_HPVOL_RSRVD5	0xE0000000
#define BF_AUDIOOUT_HPVOL_RSRVD5(v) \
		(((v) << 29) & BM_AUDIOOUT_HPVOL_RSRVD5)
#define BM_AUDIOOUT_HPVOL_VOLUME_UPDATE_PENDING	0x10000000
#define BP_AUDIOOUT_HPVOL_RSRVD4	26
#define BM_AUDIOOUT_HPVOL_RSRVD4	0x0C000000
#define BF_AUDIOOUT_HPVOL_RSRVD4(v)  \
		(((v) << 26) & BM_AUDIOOUT_HPVOL_RSRVD4)
#define BM_AUDIOOUT_HPVOL_EN_MSTR_ZCD	0x02000000
#define BM_AUDIOOUT_HPVOL_MUTE	0x01000000
#define BP_AUDIOOUT_HPVOL_RSRVD3	17
#define BM_AUDIOOUT_HPVOL_RSRVD3	0x00FE0000
#define BF_AUDIOOUT_HPVOL_RSRVD3(v)  \
		(((v) << 17) & BM_AUDIOOUT_HPVOL_RSRVD3)
#define BM_AUDIOOUT_HPVOL_SELECT	0x00010000
#define BM_AUDIOOUT_HPVOL_RSRVD2	0x00008000
#define BP_AUDIOOUT_HPVOL_VOL_LEFT	8
#define BM_AUDIOOUT_HPVOL_VOL_LEFT	0x00007F00
#define BF_AUDIOOUT_HPVOL_VOL_LEFT(v)  \
		(((v) << 8) & BM_AUDIOOUT_HPVOL_VOL_LEFT)
#define BM_AUDIOOUT_HPVOL_RSRVD1	0x00000080
#define BP_AUDIOOUT_HPVOL_VOL_RIGHT	0
#define BM_AUDIOOUT_HPVOL_VOL_RIGHT	0x0000007F
#define BF_AUDIOOUT_HPVOL_VOL_RIGHT(v)  \
		(((v) << 0) & BM_AUDIOOUT_HPVOL_VOL_RIGHT)

#define HW_AUDIOOUT_RESERVED	(0x00000060)
#define HW_AUDIOOUT_RESERVED_SET	(0x00000064)
#define HW_AUDIOOUT_RESERVED_CLR	(0x00000068)
#define HW_AUDIOOUT_RESERVED_TOG	(0x0000006c)
#define HW_AUDIOOUT_RESERVED_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_RESERVED)
#define HW_AUDIOOUT_RESERVED_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_RESERVED_SET)
#define HW_AUDIOOUT_RESERVED_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_RESERVED_CLR)
#define HW_AUDIOOUT_RESERVED_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_RESERVED_TOG)

#define BP_AUDIOOUT_RESERVED_RSRVD1	0
#define BM_AUDIOOUT_RESERVED_RSRVD1	0xFFFFFFFF
#define BF_AUDIOOUT_RESERVED_RSRVD1(v)	(v)

#define HW_AUDIOOUT_PWRDN	(0x00000070)
#define HW_AUDIOOUT_PWRDN_SET	(0x00000074)
#define HW_AUDIOOUT_PWRDN_CLR	(0x00000078)
#define HW_AUDIOOUT_PWRDN_TOG	(0x0000007c)
#define HW_AUDIOOUT_PWRDN_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_PWRDN)
#define HW_AUDIOOUT_PWRDN_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_PWRDN_SET)
#define HW_AUDIOOUT_PWRDN_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_PWRDN_CLR)
#define HW_AUDIOOUT_PWRDN_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_PWRDN_TOG)

#define BP_AUDIOOUT_PWRDN_RSRVD7	25
#define BM_AUDIOOUT_PWRDN_RSRVD7	0xFE000000
#define BF_AUDIOOUT_PWRDN_RSRVD7(v) \
		(((v) << 25) & BM_AUDIOOUT_PWRDN_RSRVD7)
#define BM_AUDIOOUT_PWRDN_SPEAKER	0x01000000
#define BP_AUDIOOUT_PWRDN_RSRVD6	21
#define BM_AUDIOOUT_PWRDN_RSRVD6	0x00E00000
#define BF_AUDIOOUT_PWRDN_RSRVD6(v)  \
		(((v) << 21) & BM_AUDIOOUT_PWRDN_RSRVD6)
#define BM_AUDIOOUT_PWRDN_SELFBIAS	0x00100000
#define BP_AUDIOOUT_PWRDN_RSRVD5	17
#define BM_AUDIOOUT_PWRDN_RSRVD5	0x000E0000
#define BF_AUDIOOUT_PWRDN_RSRVD5(v)  \
		(((v) << 17) & BM_AUDIOOUT_PWRDN_RSRVD5)
#define BM_AUDIOOUT_PWRDN_RIGHT_ADC	0x00010000
#define BP_AUDIOOUT_PWRDN_RSRVD4	13
#define BM_AUDIOOUT_PWRDN_RSRVD4	0x0000E000
#define BF_AUDIOOUT_PWRDN_RSRVD4(v)  \
		(((v) << 13) & BM_AUDIOOUT_PWRDN_RSRVD4)
#define BM_AUDIOOUT_PWRDN_DAC	0x00001000
#define BP_AUDIOOUT_PWRDN_RSRVD3	9
#define BM_AUDIOOUT_PWRDN_RSRVD3	0x00000E00
#define BF_AUDIOOUT_PWRDN_RSRVD3(v)  \
		(((v) << 9) & BM_AUDIOOUT_PWRDN_RSRVD3)
#define BM_AUDIOOUT_PWRDN_ADC	0x00000100
#define BP_AUDIOOUT_PWRDN_RSRVD2	5
#define BM_AUDIOOUT_PWRDN_RSRVD2	0x000000E0
#define BF_AUDIOOUT_PWRDN_RSRVD2(v)  \
		(((v) << 5) & BM_AUDIOOUT_PWRDN_RSRVD2)
#define BM_AUDIOOUT_PWRDN_CAPLESS	0x00000010
#define BP_AUDIOOUT_PWRDN_RSRVD1	1
#define BM_AUDIOOUT_PWRDN_RSRVD1	0x0000000E
#define BF_AUDIOOUT_PWRDN_RSRVD1(v)  \
		(((v) << 1) & BM_AUDIOOUT_PWRDN_RSRVD1)
#define BM_AUDIOOUT_PWRDN_HEADPHONE	0x00000001

#define HW_AUDIOOUT_REFCTRL	(0x00000080)
#define HW_AUDIOOUT_REFCTRL_SET	(0x00000084)
#define HW_AUDIOOUT_REFCTRL_CLR	(0x00000088)
#define HW_AUDIOOUT_REFCTRL_TOG	(0x0000008c)
#define HW_AUDIOOUT_REFCTRL_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_REFCTRL)
#define HW_AUDIOOUT_REFCTRL_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_REFCTRL_SET)
#define HW_AUDIOOUT_REFCTRL_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_REFCTRL_CLR)
#define HW_AUDIOOUT_REFCTRL_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_REFCTRL_TOG)

#define BP_AUDIOOUT_REFCTRL_RSRVD4	27
#define BM_AUDIOOUT_REFCTRL_RSRVD4	0xF8000000
#define BF_AUDIOOUT_REFCTRL_RSRVD4(v) \
		(((v) << 27) & BM_AUDIOOUT_REFCTRL_RSRVD4)
#define BM_AUDIOOUT_REFCTRL_FASTSETTLING	0x04000000
#define BM_AUDIOOUT_REFCTRL_RAISE_REF	0x02000000
#define BM_AUDIOOUT_REFCTRL_XTAL_BGR_BIAS	0x01000000
#define BM_AUDIOOUT_REFCTRL_RSRVD3	0x00800000
#define BP_AUDIOOUT_REFCTRL_VBG_ADJ	20
#define BM_AUDIOOUT_REFCTRL_VBG_ADJ	0x00700000
#define BF_AUDIOOUT_REFCTRL_VBG_ADJ(v)  \
		(((v) << 20) & BM_AUDIOOUT_REFCTRL_VBG_ADJ)
#define BM_AUDIOOUT_REFCTRL_LOW_PWR	0x00080000
#define BM_AUDIOOUT_REFCTRL_LW_REF	0x00040000
#define BP_AUDIOOUT_REFCTRL_BIAS_CTRL	16
#define BM_AUDIOOUT_REFCTRL_BIAS_CTRL	0x00030000
#define BF_AUDIOOUT_REFCTRL_BIAS_CTRL(v)  \
		(((v) << 16) & BM_AUDIOOUT_REFCTRL_BIAS_CTRL)
#define BM_AUDIOOUT_REFCTRL_RSRVD2	0x00008000
#define BM_AUDIOOUT_REFCTRL_VDDXTAL_TO_VDDD	0x00004000
#define BM_AUDIOOUT_REFCTRL_ADJ_ADC	0x00002000
#define BM_AUDIOOUT_REFCTRL_ADJ_VAG	0x00001000
#define BP_AUDIOOUT_REFCTRL_ADC_REFVAL	8
#define BM_AUDIOOUT_REFCTRL_ADC_REFVAL	0x00000F00
#define BF_AUDIOOUT_REFCTRL_ADC_REFVAL(v)  \
		(((v) << 8) & BM_AUDIOOUT_REFCTRL_ADC_REFVAL)
#define BP_AUDIOOUT_REFCTRL_VAG_VAL	4
#define BM_AUDIOOUT_REFCTRL_VAG_VAL	0x000000F0
#define BF_AUDIOOUT_REFCTRL_VAG_VAL(v)  \
		(((v) << 4) & BM_AUDIOOUT_REFCTRL_VAG_VAL)
#define BM_AUDIOOUT_REFCTRL_RSRVD1	0x00000008
#define BP_AUDIOOUT_REFCTRL_DAC_ADJ	0
#define BM_AUDIOOUT_REFCTRL_DAC_ADJ	0x00000007
#define BF_AUDIOOUT_REFCTRL_DAC_ADJ(v)  \
		(((v) << 0) & BM_AUDIOOUT_REFCTRL_DAC_ADJ)

#define HW_AUDIOOUT_ANACTRL	(0x00000090)
#define HW_AUDIOOUT_ANACTRL_SET	(0x00000094)
#define HW_AUDIOOUT_ANACTRL_CLR	(0x00000098)
#define HW_AUDIOOUT_ANACTRL_TOG	(0x0000009c)
#define HW_AUDIOOUT_ANACTRL_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_ANACTRL)
#define HW_AUDIOOUT_ANACTRL_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_ANACTRL_SET)
#define HW_AUDIOOUT_ANACTRL_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_ANACTRL_CLR)
#define HW_AUDIOOUT_ANACTRL_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_ANACTRL_TOG)

#define BP_AUDIOOUT_ANACTRL_RSRVD8	29
#define BM_AUDIOOUT_ANACTRL_RSRVD8	0xE0000000
#define BF_AUDIOOUT_ANACTRL_RSRVD8(v) \
		(((v) << 29) & BM_AUDIOOUT_ANACTRL_RSRVD8)
#define BM_AUDIOOUT_ANACTRL_SHORT_CM_STS	0x10000000
#define BP_AUDIOOUT_ANACTRL_RSRVD7	25
#define BM_AUDIOOUT_ANACTRL_RSRVD7	0x0E000000
#define BF_AUDIOOUT_ANACTRL_RSRVD7(v)  \
		(((v) << 25) & BM_AUDIOOUT_ANACTRL_RSRVD7)
#define BM_AUDIOOUT_ANACTRL_SHORT_LR_STS	0x01000000
#define BP_AUDIOOUT_ANACTRL_RSRVD6	22
#define BM_AUDIOOUT_ANACTRL_RSRVD6	0x00C00000
#define BF_AUDIOOUT_ANACTRL_RSRVD6(v)  \
		(((v) << 22) & BM_AUDIOOUT_ANACTRL_RSRVD6)
#define BP_AUDIOOUT_ANACTRL_SHORTMODE_CM	20
#define BM_AUDIOOUT_ANACTRL_SHORTMODE_CM	0x00300000
#define BF_AUDIOOUT_ANACTRL_SHORTMODE_CM(v)  \
		(((v) << 20) & BM_AUDIOOUT_ANACTRL_SHORTMODE_CM)
#define BM_AUDIOOUT_ANACTRL_RSRVD5	0x00080000
#define BP_AUDIOOUT_ANACTRL_SHORTMODE_LR	17
#define BM_AUDIOOUT_ANACTRL_SHORTMODE_LR	0x00060000
#define BF_AUDIOOUT_ANACTRL_SHORTMODE_LR(v)  \
		(((v) << 17) & BM_AUDIOOUT_ANACTRL_SHORTMODE_LR)
#define BP_AUDIOOUT_ANACTRL_RSRVD4	15
#define BM_AUDIOOUT_ANACTRL_RSRVD4	0x00018000
#define BF_AUDIOOUT_ANACTRL_RSRVD4(v)  \
		(((v) << 15) & BM_AUDIOOUT_ANACTRL_RSRVD4)
#define BP_AUDIOOUT_ANACTRL_SHORT_LVLADJL	12
#define BM_AUDIOOUT_ANACTRL_SHORT_LVLADJL	0x00007000
#define BF_AUDIOOUT_ANACTRL_SHORT_LVLADJL(v)  \
		(((v) << 12) & BM_AUDIOOUT_ANACTRL_SHORT_LVLADJL)
#define BM_AUDIOOUT_ANACTRL_RSRVD3	0x00000800
#define BP_AUDIOOUT_ANACTRL_SHORT_LVLADJR	8
#define BM_AUDIOOUT_ANACTRL_SHORT_LVLADJR	0x00000700
#define BF_AUDIOOUT_ANACTRL_SHORT_LVLADJR(v)  \
		(((v) << 8) & BM_AUDIOOUT_ANACTRL_SHORT_LVLADJR)
#define BP_AUDIOOUT_ANACTRL_RSRVD2	6
#define BM_AUDIOOUT_ANACTRL_RSRVD2	0x000000C0
#define BF_AUDIOOUT_ANACTRL_RSRVD2(v)  \
		(((v) << 6) & BM_AUDIOOUT_ANACTRL_RSRVD2)
#define BM_AUDIOOUT_ANACTRL_HP_HOLD_GND	0x00000020
#define BM_AUDIOOUT_ANACTRL_HP_CLASSAB	0x00000010
#define BP_AUDIOOUT_ANACTRL_RSRVD1	0
#define BM_AUDIOOUT_ANACTRL_RSRVD1	0x0000000F
#define BF_AUDIOOUT_ANACTRL_RSRVD1(v)  \
		(((v) << 0) & BM_AUDIOOUT_ANACTRL_RSRVD1)

#define HW_AUDIOOUT_TEST	(0x000000a0)
#define HW_AUDIOOUT_TEST_SET	(0x000000a4)
#define HW_AUDIOOUT_TEST_CLR	(0x000000a8)
#define HW_AUDIOOUT_TEST_TOG	(0x000000ac)
#define HW_AUDIOOUT_TEST_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_TEST)
#define HW_AUDIOOUT_TEST_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_TEST_SET)
#define HW_AUDIOOUT_TEST_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_TEST_CLR)
#define HW_AUDIOOUT_TEST_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_TEST_TOG)

#define BM_AUDIOOUT_TEST_RSRVD4	0x80000000
#define BP_AUDIOOUT_TEST_HP_ANTIPOP	28
#define BM_AUDIOOUT_TEST_HP_ANTIPOP	0x70000000
#define BF_AUDIOOUT_TEST_HP_ANTIPOP(v)  \
		(((v) << 28) & BM_AUDIOOUT_TEST_HP_ANTIPOP)
#define BM_AUDIOOUT_TEST_RSRVD3	0x08000000
#define BM_AUDIOOUT_TEST_TM_ADCIN_TOHP	0x04000000
#define BM_AUDIOOUT_TEST_TM_LOOP	0x02000000
#define BM_AUDIOOUT_TEST_TM_HPCOMMON	0x01000000
#define BP_AUDIOOUT_TEST_HP_I1_ADJ	22
#define BM_AUDIOOUT_TEST_HP_I1_ADJ	0x00C00000
#define BF_AUDIOOUT_TEST_HP_I1_ADJ(v)  \
		(((v) << 22) & BM_AUDIOOUT_TEST_HP_I1_ADJ)
#define BP_AUDIOOUT_TEST_HP_IALL_ADJ	20
#define BM_AUDIOOUT_TEST_HP_IALL_ADJ	0x00300000
#define BF_AUDIOOUT_TEST_HP_IALL_ADJ(v)  \
		(((v) << 20) & BM_AUDIOOUT_TEST_HP_IALL_ADJ)
#define BP_AUDIOOUT_TEST_RSRVD2	14
#define BM_AUDIOOUT_TEST_RSRVD2	0x000FC000
#define BF_AUDIOOUT_TEST_RSRVD2(v)  \
		(((v) << 14) & BM_AUDIOOUT_TEST_RSRVD2)
#define BM_AUDIOOUT_TEST_VAG_CLASSA	0x00002000
#define BM_AUDIOOUT_TEST_VAG_DOUBLE_I	0x00001000
#define BP_AUDIOOUT_TEST_RSRVD1	4
#define BM_AUDIOOUT_TEST_RSRVD1	0x00000FF0
#define BF_AUDIOOUT_TEST_RSRVD1(v)  \
		(((v) << 4) & BM_AUDIOOUT_TEST_RSRVD1)
#define BM_AUDIOOUT_TEST_ADCTODAC_LOOP	0x00000008
#define BM_AUDIOOUT_TEST_DAC_CLASSA	0x00000004
#define BM_AUDIOOUT_TEST_DAC_DOUBLE_I	0x00000002
#define BM_AUDIOOUT_TEST_DAC_DIS_RTZ	0x00000001

#define HW_AUDIOOUT_BISTCTRL	(0x000000b0)
#define HW_AUDIOOUT_BISTCTRL_SET	(0x000000b4)
#define HW_AUDIOOUT_BISTCTRL_CLR	(0x000000b8)
#define HW_AUDIOOUT_BISTCTRL_TOG	(0x000000bc)
#define HW_AUDIOOUT_BISTCTRL_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTCTRL)
#define HW_AUDIOOUT_BISTCTRL_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTCTRL_SET)
#define HW_AUDIOOUT_BISTCTRL_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTCTRL_CLR)
#define HW_AUDIOOUT_BISTCTRL_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTCTRL_TOG)

#define BP_AUDIOOUT_BISTCTRL_RSVD0	4
#define BM_AUDIOOUT_BISTCTRL_RSVD0	0xFFFFFFF0
#define BF_AUDIOOUT_BISTCTRL_RSVD0(v) \
		(((v) << 4) & BM_AUDIOOUT_BISTCTRL_RSVD0)
#define BM_AUDIOOUT_BISTCTRL_FAIL	0x00000008
#define BM_AUDIOOUT_BISTCTRL_PASS	0x00000004
#define BM_AUDIOOUT_BISTCTRL_DONE	0x00000002
#define BM_AUDIOOUT_BISTCTRL_START	0x00000001

#define HW_AUDIOOUT_BISTSTAT0	(0x000000c0)
#define HW_AUDIOOUT_BISTSTAT0_SET	(0x000000c4)
#define HW_AUDIOOUT_BISTSTAT0_CLR	(0x000000c8)
#define HW_AUDIOOUT_BISTSTAT0_TOG	(0x000000cc)
#define HW_AUDIOOUT_BISTSTAT0_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTSTAT0)
#define HW_AUDIOOUT_BISTSTAT0_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTSTAT0_SET)
#define HW_AUDIOOUT_BISTSTAT0_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTSTAT0_CLR)
#define HW_AUDIOOUT_BISTSTAT0_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTSTAT0_TOG)

#define BP_AUDIOOUT_BISTSTAT0_RSVD0	24
#define BM_AUDIOOUT_BISTSTAT0_RSVD0	0xFF000000
#define BF_AUDIOOUT_BISTSTAT0_RSVD0(v) \
		(((v) << 24) & BM_AUDIOOUT_BISTSTAT0_RSVD0)
#define BP_AUDIOOUT_BISTSTAT0_DATA	0
#define BM_AUDIOOUT_BISTSTAT0_DATA	0x00FFFFFF
#define BF_AUDIOOUT_BISTSTAT0_DATA(v)  \
		(((v) << 0) & BM_AUDIOOUT_BISTSTAT0_DATA)

#define HW_AUDIOOUT_BISTSTAT1	(0x000000d0)
#define HW_AUDIOOUT_BISTSTAT1_SET	(0x000000d4)
#define HW_AUDIOOUT_BISTSTAT1_CLR	(0x000000d8)
#define HW_AUDIOOUT_BISTSTAT1_TOG	(0x000000dc)
#define HW_AUDIOOUT_BISTSTAT1_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTSTAT1)
#define HW_AUDIOOUT_BISTSTAT1_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTSTAT1_SET)
#define HW_AUDIOOUT_BISTSTAT1_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTSTAT1_CLR)
#define HW_AUDIOOUT_BISTSTAT1_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_BISTSTAT1_TOG)

#define BP_AUDIOOUT_BISTSTAT1_RSVD1	29
#define BM_AUDIOOUT_BISTSTAT1_RSVD1	0xE0000000
#define BF_AUDIOOUT_BISTSTAT1_RSVD1(v) \
		(((v) << 29) & BM_AUDIOOUT_BISTSTAT1_RSVD1)
#define BP_AUDIOOUT_BISTSTAT1_STATE	24
#define BM_AUDIOOUT_BISTSTAT1_STATE	0x1F000000
#define BF_AUDIOOUT_BISTSTAT1_STATE(v)  \
		(((v) << 24) & BM_AUDIOOUT_BISTSTAT1_STATE)
#define BP_AUDIOOUT_BISTSTAT1_RSVD0	8
#define BM_AUDIOOUT_BISTSTAT1_RSVD0	0x00FFFF00
#define BF_AUDIOOUT_BISTSTAT1_RSVD0(v)  \
		(((v) << 8) & BM_AUDIOOUT_BISTSTAT1_RSVD0)
#define BP_AUDIOOUT_BISTSTAT1_ADDR	0
#define BM_AUDIOOUT_BISTSTAT1_ADDR	0x000000FF
#define BF_AUDIOOUT_BISTSTAT1_ADDR(v)  \
		(((v) << 0) & BM_AUDIOOUT_BISTSTAT1_ADDR)

#define HW_AUDIOOUT_ANACLKCTRL	(0x000000e0)
#define HW_AUDIOOUT_ANACLKCTRL_SET	(0x000000e4)
#define HW_AUDIOOUT_ANACLKCTRL_CLR	(0x000000e8)
#define HW_AUDIOOUT_ANACLKCTRL_TOG	(0x000000ec)
#define HW_AUDIOOUT_ANACLKCTRL_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_ANACLKCTRL)
#define HW_AUDIOOUT_ANACLKCTRL_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_ANACLKCTRL_SET)
#define HW_AUDIOOUT_ANACLKCTRL_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_ANACLKCTRL_CLR)
#define HW_AUDIOOUT_ANACLKCTRL_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_ANACLKCTRL_TOG)

#define BM_AUDIOOUT_ANACLKCTRL_CLKGATE	0x80000000
#define BP_AUDIOOUT_ANACLKCTRL_RSRVD3	5
#define BM_AUDIOOUT_ANACLKCTRL_RSRVD3	0x7FFFFFE0
#define BF_AUDIOOUT_ANACLKCTRL_RSRVD3(v)  \
		(((v) << 5) & BM_AUDIOOUT_ANACLKCTRL_RSRVD3)
#define BM_AUDIOOUT_ANACLKCTRL_INVERT_DACCLK	0x00000010
#define BM_AUDIOOUT_ANACLKCTRL_RSRVD2	0x00000008
#define BP_AUDIOOUT_ANACLKCTRL_DACDIV	0
#define BM_AUDIOOUT_ANACLKCTRL_DACDIV	0x00000007
#define BF_AUDIOOUT_ANACLKCTRL_DACDIV(v)  \
		(((v) << 0) & BM_AUDIOOUT_ANACLKCTRL_DACDIV)

#define HW_AUDIOOUT_DATA	(0x000000f0)
#define HW_AUDIOOUT_DATA_SET	(0x000000f4)
#define HW_AUDIOOUT_DATA_CLR	(0x000000f8)
#define HW_AUDIOOUT_DATA_TOG	(0x000000fc)
#define HW_AUDIOOUT_DATA_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DATA)
#define HW_AUDIOOUT_DATA_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DATA_SET)
#define HW_AUDIOOUT_DATA_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DATA_CLR)
#define HW_AUDIOOUT_DATA_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_DATA_TOG)

#define BP_AUDIOOUT_DATA_HIGH	16
#define BM_AUDIOOUT_DATA_HIGH	0xFFFF0000
#define BF_AUDIOOUT_DATA_HIGH(v) \
		(((v) << 16) & BM_AUDIOOUT_DATA_HIGH)
#define BP_AUDIOOUT_DATA_LOW	0
#define BM_AUDIOOUT_DATA_LOW	0x0000FFFF
#define BF_AUDIOOUT_DATA_LOW(v)  \
		(((v) << 0) & BM_AUDIOOUT_DATA_LOW)

#define HW_AUDIOOUT_SPEAKERCTRL	(0x00000100)
#define HW_AUDIOOUT_SPEAKERCTRL_SET	(0x00000104)
#define HW_AUDIOOUT_SPEAKERCTRL_CLR	(0x00000108)
#define HW_AUDIOOUT_SPEAKERCTRL_TOG	(0x0000010c)
#define HW_AUDIOOUT_SPEAKERCTRL_ADDR  \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_SPEAKERCTRL)
#define HW_AUDIOOUT_SPEAKERCTRL_SET_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_SPEAKERCTRL_SET)
#define HW_AUDIOOUT_SPEAKERCTRL_CLR_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_SPEAKERCTRL_CLR)
#define HW_AUDIOOUT_SPEAKERCTRL_TOG_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_SPEAKERCTRL_TOG)

#define BP_AUDIOOUT_SPEAKERCTRL_RSRVD2	25
#define BM_AUDIOOUT_SPEAKERCTRL_RSRVD2	0xFE000000
#define BF_AUDIOOUT_SPEAKERCTRL_RSRVD2(v) \
		(((v) << 25) & BM_AUDIOOUT_SPEAKERCTRL_RSRVD2)
#define BM_AUDIOOUT_SPEAKERCTRL_MUTE	0x01000000
#define BP_AUDIOOUT_SPEAKERCTRL_I1_ADJ	22
#define BM_AUDIOOUT_SPEAKERCTRL_I1_ADJ	0x00C00000
#define BF_AUDIOOUT_SPEAKERCTRL_I1_ADJ(v)  \
		(((v) << 22) & BM_AUDIOOUT_SPEAKERCTRL_I1_ADJ)
#define BP_AUDIOOUT_SPEAKERCTRL_IALL_ADJ	20
#define BM_AUDIOOUT_SPEAKERCTRL_IALL_ADJ	0x00300000
#define BF_AUDIOOUT_SPEAKERCTRL_IALL_ADJ(v)  \
		(((v) << 20) & BM_AUDIOOUT_SPEAKERCTRL_IALL_ADJ)
#define BP_AUDIOOUT_SPEAKERCTRL_RSRVD1	16
#define BM_AUDIOOUT_SPEAKERCTRL_RSRVD1	0x000F0000
#define BF_AUDIOOUT_SPEAKERCTRL_RSRVD1(v)  \
		(((v) << 16) & BM_AUDIOOUT_SPEAKERCTRL_RSRVD1)
#define BP_AUDIOOUT_SPEAKERCTRL_POSDRIVER	14
#define BM_AUDIOOUT_SPEAKERCTRL_POSDRIVER	0x0000C000
#define BF_AUDIOOUT_SPEAKERCTRL_POSDRIVER(v)  \
		(((v) << 14) & BM_AUDIOOUT_SPEAKERCTRL_POSDRIVER)
#define BP_AUDIOOUT_SPEAKERCTRL_NEGDRIVER	12
#define BM_AUDIOOUT_SPEAKERCTRL_NEGDRIVER	0x00003000
#define BF_AUDIOOUT_SPEAKERCTRL_NEGDRIVER(v)  \
		(((v) << 12) & BM_AUDIOOUT_SPEAKERCTRL_NEGDRIVER)
#define BP_AUDIOOUT_SPEAKERCTRL_RSRVD0	0
#define BM_AUDIOOUT_SPEAKERCTRL_RSRVD0	0x00000FFF
#define BF_AUDIOOUT_SPEAKERCTRL_RSRVD0(v)  \
		(((v) << 0) & BM_AUDIOOUT_SPEAKERCTRL_RSRVD0)

#define HW_AUDIOOUT_VERSION	(0x00000200)
#define HW_AUDIOOUT_VERSION_ADDR \
		(REGS_AUDIOOUT_BASE + HW_AUDIOOUT_VERSION)

#define BP_AUDIOOUT_VERSION_MAJOR	24
#define BM_AUDIOOUT_VERSION_MAJOR	0xFF000000
#define BF_AUDIOOUT_VERSION_MAJOR(v) \
		(((v) << 24) & BM_AUDIOOUT_VERSION_MAJOR)
#define BP_AUDIOOUT_VERSION_MINOR	16
#define BM_AUDIOOUT_VERSION_MINOR	0x00FF0000
#define BF_AUDIOOUT_VERSION_MINOR(v)  \
		(((v) << 16) & BM_AUDIOOUT_VERSION_MINOR)
#define BP_AUDIOOUT_VERSION_STEP	0
#define BM_AUDIOOUT_VERSION_STEP	0x0000FFFF
#define BF_AUDIOOUT_VERSION_STEP(v)  \
		(((v) << 0) & BM_AUDIOOUT_VERSION_STEP)
#endif /* __ARCH_ARM___AUDIOOUT_H */
