/*
 * Copyright (C) 2009-2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __ARCH_ARM___DIGCTL_H
#define __ARCH_ARM___DIGCTL_H


#define HW_DIGCTL_CTRL	(0x00000000)
#define HW_DIGCTL_CTRL_SET	(0x00000004)
#define HW_DIGCTL_CTRL_CLR	(0x00000008)
#define HW_DIGCTL_CTRL_TOG	(0x0000000c)

#define BM_DIGCTL_CTRL_RSVD3	0x80000000
#define BM_DIGCTL_CTRL_XTAL24M_GATE	0x40000000
#define BP_DIGCTL_CTRL_RSVD2	25
#define BM_DIGCTL_CTRL_RSVD2	0x3E000000
#define BF_DIGCTL_CTRL_RSVD2(v)  \
		(((v) << 25) & BM_DIGCTL_CTRL_RSVD2)
#define BM_DIGCTL_CTRL_USB1_OVERCURRENT_ENABLE	0x01000000
#define BM_DIGCTL_CTRL_USB0_OVERCURRENT_ENABLE	0x00800000
#define BM_DIGCTL_CTRL_USB1_OVERCURRENT_POL	0x00400000
#define BM_DIGCTL_CTRL_USB0_OVERCURRENT_POL	0x00200000
#define BM_DIGCTL_CTRL_USB1_TESTMODE	0x00100000
#define BM_DIGCTL_CTRL_USB0_TESTMODE	0x00080000
#define BM_DIGCTL_CTRL_ANALOG_TESTMODE	0x00040000
#define BM_DIGCTL_CTRL_DIGITAL_TESTMODE	0x00020000
#define BM_DIGCTL_CTRL_USB1_CLKGATE	0x00010000
#define BV_DIGCTL_CTRL_USB1_CLKGATE__RUN     0x0
#define BV_DIGCTL_CTRL_USB1_CLKGATE__NO_CLKS 0x1
#define BM_DIGCTL_CTRL_SAIF_LOOPBACK	0x00008000
#define BV_DIGCTL_CTRL_SAIF_LOOPBACK__NORMAL 0x0
#define BV_DIGCTL_CTRL_SAIF_LOOPBACK__LOOPIT 0x1
#define BM_DIGCTL_CTRL_DUART_LOOPBACK	0x00004000
#define BV_DIGCTL_CTRL_DUART_LOOPBACK__NORMAL 0x0
#define BV_DIGCTL_CTRL_DUART_LOOPBACK__LOOPIT 0x1
#define BM_DIGCTL_CTRL_AUART01_LOOPBACK	0x00002000
#define BV_DIGCTL_CTRL_AUART01_LOOPBACK__NORMAL 0x0
#define BV_DIGCTL_CTRL_AUART01_LOOPBACK__LOOPIT 0x1
#define BM_DIGCTL_CTRL_RSVD1	0x00001000
#define BP_DIGCTL_CTRL_SAIF_CLKMUX_SEL	10
#define BM_DIGCTL_CTRL_SAIF_CLKMUX_SEL	0x00000C00
#define BF_DIGCTL_CTRL_SAIF_CLKMUX_SEL(v)  \
		(((v) << 10) & BM_DIGCTL_CTRL_SAIF_CLKMUX_SEL)
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__DIRECT         0x0
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__CROSSINPUT     0x1
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__CLKSRCSAIF0PIN 0x2
#define BV_DIGCTL_CTRL_SAIF_CLKMUX_SEL__CLKSRCSAIF1PIN 0x3
#define BP_DIGCTL_CTRL_RSVD0	4
#define BM_DIGCTL_CTRL_RSVD0	0x000003F0
#define BF_DIGCTL_CTRL_RSVD0(v)  \
		(((v) << 4) & BM_DIGCTL_CTRL_RSVD0)
#define BM_DIGCTL_CTRL_DEBUG_DISABLE	0x00000008
#define BM_DIGCTL_CTRL_USB0_CLKGATE	0x00000004
#define BV_DIGCTL_CTRL_USB0_CLKGATE__RUN     0x0
#define BV_DIGCTL_CTRL_USB0_CLKGATE__NO_CLKS 0x1
#define BM_DIGCTL_CTRL_JTAG_SHIELD	0x00000002
#define BV_DIGCTL_CTRL_JTAG_SHIELD__NORMAL     0x0
#define BV_DIGCTL_CTRL_JTAG_SHIELD__SHIELDS_UP 0x1
#define BM_DIGCTL_CTRL_LATCH_ENTROPY	0x00000001

#define HW_DIGCTL_STATUS	(0x00000010)
#define HW_DIGCTL_STATUS_SET	(0x00000014)
#define HW_DIGCTL_STATUS_CLR	(0x00000018)
#define HW_DIGCTL_STATUS_TOG	(0x0000001c)

#define BM_DIGCTL_STATUS_USB0_HS_PRESENT	0x80000000
#define BM_DIGCTL_STATUS_USB0_OTG_PRESENT	0x40000000
#define BM_DIGCTL_STATUS_USB0_HOST_PRESENT	0x20000000
#define BM_DIGCTL_STATUS_USB0_DEVICE_PRESENT	0x10000000
#define BM_DIGCTL_STATUS_USB1_HS_PRESENT	0x08000000
#define BM_DIGCTL_STATUS_USB1_OTG_PRESENT	0x04000000
#define BM_DIGCTL_STATUS_USB1_HOST_PRESENT	0x02000000
#define BM_DIGCTL_STATUS_USB1_DEVICE_PRESENT	0x01000000
#define BP_DIGCTL_STATUS_RSVD0	5
#define BM_DIGCTL_STATUS_RSVD0	0x00FFFFE0
#define BF_DIGCTL_STATUS_RSVD0(v)  \
		(((v) << 5) & BM_DIGCTL_STATUS_RSVD0)
#define BM_DIGCTL_STATUS_JTAG_IN_USE	0x00000010
#define BP_DIGCTL_STATUS_PACKAGE_TYPE	1
#define BM_DIGCTL_STATUS_PACKAGE_TYPE	0x0000000E
#define BF_DIGCTL_STATUS_PACKAGE_TYPE(v)  \
		(((v) << 1) & BM_DIGCTL_STATUS_PACKAGE_TYPE)
#define BM_DIGCTL_STATUS_WRITTEN	0x00000001

#define HW_DIGCTL_HCLKCOUNT	(0x00000020)
#define HW_DIGCTL_HCLKCOUNT_SET	(0x00000024)
#define HW_DIGCTL_HCLKCOUNT_CLR	(0x00000028)
#define HW_DIGCTL_HCLKCOUNT_TOG	(0x0000002c)

#define BP_DIGCTL_HCLKCOUNT_COUNT	0
#define BM_DIGCTL_HCLKCOUNT_COUNT	0xFFFFFFFF
#define BF_DIGCTL_HCLKCOUNT_COUNT(v)	(v)

#define HW_DIGCTL_RAMCTRL	(0x00000030)
#define HW_DIGCTL_RAMCTRL_SET	(0x00000034)
#define HW_DIGCTL_RAMCTRL_CLR	(0x00000038)
#define HW_DIGCTL_RAMCTRL_TOG	(0x0000003c)

#define BP_DIGCTL_RAMCTRL_RSVD1	15
#define BM_DIGCTL_RAMCTRL_RSVD1	0xFFFF8000
#define BF_DIGCTL_RAMCTRL_RSVD1(v) \
		(((v) << 15) & BM_DIGCTL_RAMCTRL_RSVD1)
#define BM_DIGCTL_RAMCTRL_TBYPASS	0x00004000
#define BM_DIGCTL_RAMCTRL_DEBUG_ENABLE	0x00002000
#define BP_DIGCTL_RAMCTRL_DEBUG_CODE	8
#define BM_DIGCTL_RAMCTRL_DEBUG_CODE	0x00001F00
#define BF_DIGCTL_RAMCTRL_DEBUG_CODE(v)  \
		(((v) << 8) & BM_DIGCTL_RAMCTRL_DEBUG_CODE)
#define BV_DIGCTL_RAMCTRL_DEBUG_CODE__NORMAL 0x0
#define BV_DIGCTL_RAMCTRL_DEBUG_CODE__DELAY1 0x4
#define BV_DIGCTL_RAMCTRL_DEBUG_CODE__DELAY2 0x5
#define BV_DIGCTL_RAMCTRL_DEBUG_CODE__DELAY3 0x6
#define BV_DIGCTL_RAMCTRL_DEBUG_CODE__DELAY4 0x7
#define BP_DIGCTL_RAMCTRL_RSVD0	0
#define BM_DIGCTL_RAMCTRL_RSVD0	0x000000FF
#define BF_DIGCTL_RAMCTRL_RSVD0(v)  \
		(((v) << 0) & BM_DIGCTL_RAMCTRL_RSVD0)

#define HW_DIGCTL_EMI_STATUS	(0x00000040)
#define HW_DIGCTL_EMI_STATUS_SET	(0x00000044)
#define HW_DIGCTL_EMI_STATUS_CLR	(0x00000048)
#define HW_DIGCTL_EMI_STATUS_TOG	(0x0000004c)

#define BP_DIGCTL_EMI_STATUS_RSVD0	5
#define BM_DIGCTL_EMI_STATUS_RSVD0	0xFFFFFFE0
#define BF_DIGCTL_EMI_STATUS_RSVD0(v) \
		(((v) << 5) & BM_DIGCTL_EMI_STATUS_RSVD0)
#define BP_DIGCTL_EMI_STATUS_POWER_MODE	0
#define BM_DIGCTL_EMI_STATUS_POWER_MODE	0x0000001F
#define BF_DIGCTL_EMI_STATUS_POWER_MODE(v)  \
		(((v) << 0) & BM_DIGCTL_EMI_STATUS_POWER_MODE)
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__PM5    0x1
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__PM4    0x2
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__PM3    0x4
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__PM2    0x8
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__PM1    0x10
#define BV_DIGCTL_EMI_STATUS_POWER_MODE__NORMAL 0x0

#define HW_DIGCTL_READ_MARGIN	(0x00000050)
#define HW_DIGCTL_READ_MARGIN_SET	(0x00000054)
#define HW_DIGCTL_READ_MARGIN_CLR	(0x00000058)
#define HW_DIGCTL_READ_MARGIN_TOG	(0x0000005c)

#define BP_DIGCTL_READ_MARGIN_RSVD0	4
#define BM_DIGCTL_READ_MARGIN_RSVD0	0xFFFFFFF0
#define BF_DIGCTL_READ_MARGIN_RSVD0(v) \
		(((v) << 4) & BM_DIGCTL_READ_MARGIN_RSVD0)
#define BP_DIGCTL_READ_MARGIN_ROM	0
#define BM_DIGCTL_READ_MARGIN_ROM	0x0000000F
#define BF_DIGCTL_READ_MARGIN_ROM(v)  \
		(((v) << 0) & BM_DIGCTL_READ_MARGIN_ROM)

#define HW_DIGCTL_WRITEONCE	(0x00000060)

#define BP_DIGCTL_WRITEONCE_BITS	0
#define BM_DIGCTL_WRITEONCE_BITS	0xFFFFFFFF
#define BF_DIGCTL_WRITEONCE_BITS(v)	(v)

#define HW_DIGCTL_BIST_CTL	(0x00000070)
#define HW_DIGCTL_BIST_CTL_SET	(0x00000074)
#define HW_DIGCTL_BIST_CTL_CLR	(0x00000078)
#define HW_DIGCTL_BIST_CTL_TOG	(0x0000007c)

#define BM_DIGCTL_BIST_CTL_BIST_TESTMODE	0x80000000
#define BM_DIGCTL_BIST_CTL_BIST_RESETN	0x40000000
#define BM_DIGCTL_BIST_CTL_BIST_DEBUGZ	0x20000000
#define BM_DIGCTL_BIST_CTL_BIST_CHECKB	0x10000000
#define BM_DIGCTL_BIST_CTL_BIST_RESUME	0x08000000
#define BP_DIGCTL_BIST_CTL_RSVD0	15
#define BM_DIGCTL_BIST_CTL_RSVD0	0x07FF8000
#define BF_DIGCTL_BIST_CTL_RSVD0(v)  \
		(((v) << 15) & BM_DIGCTL_BIST_CTL_RSVD0)
#define BM_DIGCTL_BIST_CTL_OCRAM_BIST_RETENTION	0x00004000
#define BM_DIGCTL_BIST_CTL_OCRAM_BIST_PASS	0x00002000
#define BM_DIGCTL_BIST_CTL_OCRAM_BIST_FAIL	0x00001000
#define BM_DIGCTL_BIST_CTL_OCRAM_BIST_DONE	0x00000800
#define BM_DIGCTL_BIST_CTL_OCRAM_BIST_START	0x00000400
#define BM_DIGCTL_BIST_CTL_PXP_BIST_START	0x00000200
#define BM_DIGCTL_BIST_CTL_LCDIF_BIST_START	0x00000100
#define BM_DIGCTL_BIST_CTL_DCP_BIST_START	0x00000080
#define BM_DIGCTL_BIST_CTL_ENET_BIST_START	0x00000040
#define BM_DIGCTL_BIST_CTL_USB1_BIST_START	0x00000020
#define BM_DIGCTL_BIST_CTL_USB0_BIST_START	0x00000010
#define BM_DIGCTL_BIST_CTL_DMA1_BIST_START	0x00000008
#define BM_DIGCTL_BIST_CTL_DMA0_BIST_START	0x00000004
#define BM_DIGCTL_BIST_CTL_CACHE_BIST_START	0x00000002
#define BM_DIGCTL_BIST_CTL_CAN_BIST_START	0x00000001

#define HW_DIGCTL_BIST_STATUS	(0x00000080)
#define HW_DIGCTL_BIST_STATUS_SET	(0x00000084)
#define HW_DIGCTL_BIST_STATUS_CLR	(0x00000088)
#define HW_DIGCTL_BIST_STATUS_TOG	(0x0000008c)

#define BP_DIGCTL_BIST_STATUS_RSVD0	30
#define BM_DIGCTL_BIST_STATUS_RSVD0	0xC0000000
#define BF_DIGCTL_BIST_STATUS_RSVD0(v) \
		(((v) << 30) & BM_DIGCTL_BIST_STATUS_RSVD0)
#define BM_DIGCTL_BIST_STATUS_PXP_BIST_RETENTION	0x20000000
#define BM_DIGCTL_BIST_STATUS_LCDIF_BIST_RETENTION	0x10000000
#define BM_DIGCTL_BIST_STATUS_DCP_BIST_RETENTION	0x08000000
#define BM_DIGCTL_BIST_STATUS_ENET_BIST_RETENTION	0x04000000
#define BM_DIGCTL_BIST_STATUS_USB1_BIST_RETENTION	0x02000000
#define BM_DIGCTL_BIST_STATUS_USB0_BIST_RETENTION	0x01000000
#define BM_DIGCTL_BIST_STATUS_DMA1_BIST_RETENTION	0x00800000
#define BM_DIGCTL_BIST_STATUS_DMA0_BIST_RETENTION	0x00400000
#define BM_DIGCTL_BIST_STATUS_CACHE_BIST_RETENTION	0x00200000
#define BM_DIGCTL_BIST_STATUS_CAN_BIST_RETENTION	0x00100000
#define BM_DIGCTL_BIST_STATUS_PXP_BIST_FAIL	0x00080000
#define BM_DIGCTL_BIST_STATUS_LCDIF_BIST_FAIL	0x00040000
#define BM_DIGCTL_BIST_STATUS_DCP_BIST_FAIL	0x00020000
#define BM_DIGCTL_BIST_STATUS_ENET_BIST_FAIL	0x00010000
#define BM_DIGCTL_BIST_STATUS_USB1_BIST_FAIL	0x00008000
#define BM_DIGCTL_BIST_STATUS_USB0_BIST_FAIL	0x00004000
#define BM_DIGCTL_BIST_STATUS_DMA1_BIST_FAIL	0x00002000
#define BM_DIGCTL_BIST_STATUS_DMA0_BIST_FAIL	0x00001000
#define BM_DIGCTL_BIST_STATUS_CACHE_BIST_FAIL	0x00000800
#define BM_DIGCTL_BIST_STATUS_CAN_BIST_FAIL	0x00000400
#define BM_DIGCTL_BIST_STATUS_PXP_BIST_DONE	0x00000200
#define BM_DIGCTL_BIST_STATUS_LCDIF_BIST_DONE	0x00000100
#define BM_DIGCTL_BIST_STATUS_DCP_BIST_DONE	0x00000080
#define BM_DIGCTL_BIST_STATUS_ENET_BIST_DONE	0x00000040
#define BM_DIGCTL_BIST_STATUS_USB1_BIST_DONE	0x00000020
#define BM_DIGCTL_BIST_STATUS_USB0_BIST_DONE	0x00000010
#define BM_DIGCTL_BIST_STATUS_DMA1_BIST_DONE	0x00000008
#define BM_DIGCTL_BIST_STATUS_DMA0_BIST_DONE	0x00000004
#define BM_DIGCTL_BIST_STATUS_CACHE_BIST_DONE	0x00000002
#define BM_DIGCTL_BIST_STATUS_CAN_BIST_DONE	0x00000001

#define HW_DIGCTL_ENTROPY	(0x00000090)

#define BP_DIGCTL_ENTROPY_VALUE	0
#define BM_DIGCTL_ENTROPY_VALUE	0xFFFFFFFF
#define BF_DIGCTL_ENTROPY_VALUE(v)	(v)

#define HW_DIGCTL_ENTROPY_LATCHED	(0x000000a0)

#define BP_DIGCTL_ENTROPY_LATCHED_VALUE	0
#define BM_DIGCTL_ENTROPY_LATCHED_VALUE	0xFFFFFFFF
#define BF_DIGCTL_ENTROPY_LATCHED_VALUE(v)	(v)

#define HW_DIGCTL_MICROSECONDS	(0x000000c0)
#define HW_DIGCTL_MICROSECONDS_SET	(0x000000c4)
#define HW_DIGCTL_MICROSECONDS_CLR	(0x000000c8)
#define HW_DIGCTL_MICROSECONDS_TOG	(0x000000cc)

#define BP_DIGCTL_MICROSECONDS_VALUE	0
#define BM_DIGCTL_MICROSECONDS_VALUE	0xFFFFFFFF
#define BF_DIGCTL_MICROSECONDS_VALUE(v)	(v)

#define HW_DIGCTL_DBGRD	(0x000000d0)

#define BP_DIGCTL_DBGRD_COMPLEMENT	0
#define BM_DIGCTL_DBGRD_COMPLEMENT	0xFFFFFFFF
#define BF_DIGCTL_DBGRD_COMPLEMENT(v)	(v)

#define HW_DIGCTL_DBG	(0x000000e0)

#define BP_DIGCTL_DBG_VALUE	0
#define BM_DIGCTL_DBG_VALUE	0xFFFFFFFF
#define BF_DIGCTL_DBG_VALUE(v)	(v)

#define HW_DIGCTL_USB_LOOPBACK	(0x00000100)
#define HW_DIGCTL_USB_LOOPBACK_SET	(0x00000104)
#define HW_DIGCTL_USB_LOOPBACK_CLR	(0x00000108)
#define HW_DIGCTL_USB_LOOPBACK_TOG	(0x0000010c)

#define BP_DIGCTL_USB_LOOPBACK_RSVD0	18
#define BM_DIGCTL_USB_LOOPBACK_RSVD0	0xFFFC0000
#define BF_DIGCTL_USB_LOOPBACK_RSVD0(v) \
		(((v) << 18) & BM_DIGCTL_USB_LOOPBACK_RSVD0)
#define BM_DIGCTL_USB_LOOPBACK_USB1_TST_START	0x00020000
#define BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_LS	0x00010000
#define BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_HS	0x00008000
#define BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_EN	0x00004000
#define BM_DIGCTL_USB_LOOPBACK_TSTI1_TX_HIZ	0x00002000
#define BM_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST1	0x00001000
#define BM_DIGCTL_USB_LOOPBACK_UTMI1_DIG_TST0	0x00000800
#define BM_DIGCTL_USB_LOOPBACK_USB0_TST_START	0x00000400
#define BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_LS	0x00000200
#define BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_HS	0x00000100
#define BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_EN	0x00000080
#define BM_DIGCTL_USB_LOOPBACK_TSTI0_TX_HIZ	0x00000040
#define BM_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST1	0x00000020
#define BM_DIGCTL_USB_LOOPBACK_UTMI0_DIG_TST0	0x00000010
#define BM_DIGCTL_USB_LOOPBACK_UTMO1_DIG_TST1	0x00000008
#define BM_DIGCTL_USB_LOOPBACK_UTMO1_DIG_TST0	0x00000004
#define BM_DIGCTL_USB_LOOPBACK_UTMO0_DIG_TST1	0x00000002
#define BM_DIGCTL_USB_LOOPBACK_UTMO0_DIG_TST0	0x00000001

#define HW_DIGCTL_OCRAM_STATUS0	(0x00000110)
#define HW_DIGCTL_OCRAM_STATUS0_SET	(0x00000114)
#define HW_DIGCTL_OCRAM_STATUS0_CLR	(0x00000118)
#define HW_DIGCTL_OCRAM_STATUS0_TOG	(0x0000011c)

#define BP_DIGCTL_OCRAM_STATUS0_FAILDATA00	0
#define BM_DIGCTL_OCRAM_STATUS0_FAILDATA00	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS0_FAILDATA00(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS1	(0x00000120)
#define HW_DIGCTL_OCRAM_STATUS1_SET	(0x00000124)
#define HW_DIGCTL_OCRAM_STATUS1_CLR	(0x00000128)
#define HW_DIGCTL_OCRAM_STATUS1_TOG	(0x0000012c)

#define BP_DIGCTL_OCRAM_STATUS1_FAILDATA01	0
#define BM_DIGCTL_OCRAM_STATUS1_FAILDATA01	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS1_FAILDATA01(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS2	(0x00000130)
#define HW_DIGCTL_OCRAM_STATUS2_SET	(0x00000134)
#define HW_DIGCTL_OCRAM_STATUS2_CLR	(0x00000138)
#define HW_DIGCTL_OCRAM_STATUS2_TOG	(0x0000013c)

#define BP_DIGCTL_OCRAM_STATUS2_FAILDATA10	0
#define BM_DIGCTL_OCRAM_STATUS2_FAILDATA10	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS2_FAILDATA10(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS3	(0x00000140)
#define HW_DIGCTL_OCRAM_STATUS3_SET	(0x00000144)
#define HW_DIGCTL_OCRAM_STATUS3_CLR	(0x00000148)
#define HW_DIGCTL_OCRAM_STATUS3_TOG	(0x0000014c)

#define BP_DIGCTL_OCRAM_STATUS3_FAILDATA11	0
#define BM_DIGCTL_OCRAM_STATUS3_FAILDATA11	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS3_FAILDATA11(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS4	(0x00000150)
#define HW_DIGCTL_OCRAM_STATUS4_SET	(0x00000154)
#define HW_DIGCTL_OCRAM_STATUS4_CLR	(0x00000158)
#define HW_DIGCTL_OCRAM_STATUS4_TOG	(0x0000015c)

#define BP_DIGCTL_OCRAM_STATUS4_FAILDATA20	0
#define BM_DIGCTL_OCRAM_STATUS4_FAILDATA20	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS4_FAILDATA20(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS5	(0x00000160)
#define HW_DIGCTL_OCRAM_STATUS5_SET	(0x00000164)
#define HW_DIGCTL_OCRAM_STATUS5_CLR	(0x00000168)
#define HW_DIGCTL_OCRAM_STATUS5_TOG	(0x0000016c)

#define BP_DIGCTL_OCRAM_STATUS5_FAILDATA21	0
#define BM_DIGCTL_OCRAM_STATUS5_FAILDATA21	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS5_FAILDATA21(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS6	(0x00000170)
#define HW_DIGCTL_OCRAM_STATUS6_SET	(0x00000174)
#define HW_DIGCTL_OCRAM_STATUS6_CLR	(0x00000178)
#define HW_DIGCTL_OCRAM_STATUS6_TOG	(0x0000017c)

#define BP_DIGCTL_OCRAM_STATUS6_FAILDATA30	0
#define BM_DIGCTL_OCRAM_STATUS6_FAILDATA30	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS6_FAILDATA30(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS7	(0x00000180)
#define HW_DIGCTL_OCRAM_STATUS7_SET	(0x00000184)
#define HW_DIGCTL_OCRAM_STATUS7_CLR	(0x00000188)
#define HW_DIGCTL_OCRAM_STATUS7_TOG	(0x0000018c)

#define BP_DIGCTL_OCRAM_STATUS7_FAILDATA31	0
#define BM_DIGCTL_OCRAM_STATUS7_FAILDATA31	0xFFFFFFFF
#define BF_DIGCTL_OCRAM_STATUS7_FAILDATA31(v)	(v)

#define HW_DIGCTL_OCRAM_STATUS8	(0x00000190)
#define HW_DIGCTL_OCRAM_STATUS8_SET	(0x00000194)
#define HW_DIGCTL_OCRAM_STATUS8_CLR	(0x00000198)
#define HW_DIGCTL_OCRAM_STATUS8_TOG	(0x0000019c)

#define BP_DIGCTL_OCRAM_STATUS8_FAILADDR01	16
#define BM_DIGCTL_OCRAM_STATUS8_FAILADDR01	0xFFFF0000
#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR01(v) \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR01)
#define BP_DIGCTL_OCRAM_STATUS8_FAILADDR00	0
#define BM_DIGCTL_OCRAM_STATUS8_FAILADDR00	0x0000FFFF
#define BF_DIGCTL_OCRAM_STATUS8_FAILADDR00(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS8_FAILADDR00)

#define HW_DIGCTL_OCRAM_STATUS9	(0x000001a0)
#define HW_DIGCTL_OCRAM_STATUS9_SET	(0x000001a4)
#define HW_DIGCTL_OCRAM_STATUS9_CLR	(0x000001a8)
#define HW_DIGCTL_OCRAM_STATUS9_TOG	(0x000001ac)

#define BP_DIGCTL_OCRAM_STATUS9_FAILADDR11	16
#define BM_DIGCTL_OCRAM_STATUS9_FAILADDR11	0xFFFF0000
#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR11(v) \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR11)
#define BP_DIGCTL_OCRAM_STATUS9_FAILADDR10	0
#define BM_DIGCTL_OCRAM_STATUS9_FAILADDR10	0x0000FFFF
#define BF_DIGCTL_OCRAM_STATUS9_FAILADDR10(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS9_FAILADDR10)

#define HW_DIGCTL_OCRAM_STATUS10	(0x000001b0)
#define HW_DIGCTL_OCRAM_STATUS10_SET	(0x000001b4)
#define HW_DIGCTL_OCRAM_STATUS10_CLR	(0x000001b8)
#define HW_DIGCTL_OCRAM_STATUS10_TOG	(0x000001bc)

#define BP_DIGCTL_OCRAM_STATUS10_FAILADDR21	16
#define BM_DIGCTL_OCRAM_STATUS10_FAILADDR21	0xFFFF0000
#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR21(v) \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR21)
#define BP_DIGCTL_OCRAM_STATUS10_FAILADDR20	0
#define BM_DIGCTL_OCRAM_STATUS10_FAILADDR20	0x0000FFFF
#define BF_DIGCTL_OCRAM_STATUS10_FAILADDR20(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS10_FAILADDR20)

#define HW_DIGCTL_OCRAM_STATUS11	(0x000001c0)
#define HW_DIGCTL_OCRAM_STATUS11_SET	(0x000001c4)
#define HW_DIGCTL_OCRAM_STATUS11_CLR	(0x000001c8)
#define HW_DIGCTL_OCRAM_STATUS11_TOG	(0x000001cc)

#define BP_DIGCTL_OCRAM_STATUS11_FAILADDR31	16
#define BM_DIGCTL_OCRAM_STATUS11_FAILADDR31	0xFFFF0000
#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR31(v) \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR31)
#define BP_DIGCTL_OCRAM_STATUS11_FAILADDR30	0
#define BM_DIGCTL_OCRAM_STATUS11_FAILADDR30	0x0000FFFF
#define BF_DIGCTL_OCRAM_STATUS11_FAILADDR30(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS11_FAILADDR30)

#define HW_DIGCTL_OCRAM_STATUS12	(0x000001d0)
#define HW_DIGCTL_OCRAM_STATUS12_SET	(0x000001d4)
#define HW_DIGCTL_OCRAM_STATUS12_CLR	(0x000001d8)
#define HW_DIGCTL_OCRAM_STATUS12_TOG	(0x000001dc)

#define BM_DIGCTL_OCRAM_STATUS12_RSVD3	0x80000000
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE11	24
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE11	0x7F000000
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE11(v)  \
		(((v) << 24) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE11)
#define BM_DIGCTL_OCRAM_STATUS12_RSVD2	0x00800000
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE10	16
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE10	0x007F0000
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE10(v)  \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE10)
#define BM_DIGCTL_OCRAM_STATUS12_RSVD1	0x00008000
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE01	8
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE01	0x00007F00
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE01(v)  \
		(((v) << 8) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE01)
#define BM_DIGCTL_OCRAM_STATUS12_RSVD0	0x00000080
#define BP_DIGCTL_OCRAM_STATUS12_FAILSTATE00	0
#define BM_DIGCTL_OCRAM_STATUS12_FAILSTATE00	0x0000007F
#define BF_DIGCTL_OCRAM_STATUS12_FAILSTATE00(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS12_FAILSTATE00)

#define HW_DIGCTL_OCRAM_STATUS13	(0x000001e0)
#define HW_DIGCTL_OCRAM_STATUS13_SET	(0x000001e4)
#define HW_DIGCTL_OCRAM_STATUS13_CLR	(0x000001e8)
#define HW_DIGCTL_OCRAM_STATUS13_TOG	(0x000001ec)

#define BM_DIGCTL_OCRAM_STATUS13_RSVD3	0x80000000
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE31	24
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE31	0x7F000000
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE31(v)  \
		(((v) << 24) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE31)
#define BM_DIGCTL_OCRAM_STATUS13_RSVD2	0x00800000
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE30	16
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE30	0x007F0000
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE30(v)  \
		(((v) << 16) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE30)
#define BM_DIGCTL_OCRAM_STATUS13_RSVD1	0x00008000
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE21	8
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE21	0x00007F00
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE21(v)  \
		(((v) << 8) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE21)
#define BM_DIGCTL_OCRAM_STATUS13_RSVD0	0x00000080
#define BP_DIGCTL_OCRAM_STATUS13_FAILSTATE20	0
#define BM_DIGCTL_OCRAM_STATUS13_FAILSTATE20	0x0000007F
#define BF_DIGCTL_OCRAM_STATUS13_FAILSTATE20(v)  \
		(((v) << 0) & BM_DIGCTL_OCRAM_STATUS13_FAILSTATE20)

#define HW_DIGCTL_SCRATCH0	(0x00000280)

#define BP_DIGCTL_SCRATCH0_PTR	0
#define BM_DIGCTL_SCRATCH0_PTR	0xFFFFFFFF
#define BF_DIGCTL_SCRATCH0_PTR(v)	(v)

#define HW_DIGCTL_SCRATCH1	(0x00000290)

#define BP_DIGCTL_SCRATCH1_PTR	0
#define BM_DIGCTL_SCRATCH1_PTR	0xFFFFFFFF
#define BF_DIGCTL_SCRATCH1_PTR(v)	(v)

#define HW_DIGCTL_ARMCACHE	(0x000002a0)

#define BP_DIGCTL_ARMCACHE_RSVD4	18
#define BM_DIGCTL_ARMCACHE_RSVD4	0xFFFC0000
#define BF_DIGCTL_ARMCACHE_RSVD4(v) \
		(((v) << 18) & BM_DIGCTL_ARMCACHE_RSVD4)
#define BP_DIGCTL_ARMCACHE_VALID_SS	16
#define BM_DIGCTL_ARMCACHE_VALID_SS	0x00030000
#define BF_DIGCTL_ARMCACHE_VALID_SS(v)  \
		(((v) << 16) & BM_DIGCTL_ARMCACHE_VALID_SS)
#define BP_DIGCTL_ARMCACHE_RSVD3	14
#define BM_DIGCTL_ARMCACHE_RSVD3	0x0000C000
#define BF_DIGCTL_ARMCACHE_RSVD3(v)  \
		(((v) << 14) & BM_DIGCTL_ARMCACHE_RSVD3)
#define BP_DIGCTL_ARMCACHE_DRTY_SS	12
#define BM_DIGCTL_ARMCACHE_DRTY_SS	0x00003000
#define BF_DIGCTL_ARMCACHE_DRTY_SS(v)  \
		(((v) << 12) & BM_DIGCTL_ARMCACHE_DRTY_SS)
#define BP_DIGCTL_ARMCACHE_RSVD2	10
#define BM_DIGCTL_ARMCACHE_RSVD2	0x00000C00
#define BF_DIGCTL_ARMCACHE_RSVD2(v)  \
		(((v) << 10) & BM_DIGCTL_ARMCACHE_RSVD2)
#define BP_DIGCTL_ARMCACHE_CACHE_SS	8
#define BM_DIGCTL_ARMCACHE_CACHE_SS	0x00000300
#define BF_DIGCTL_ARMCACHE_CACHE_SS(v)  \
		(((v) << 8) & BM_DIGCTL_ARMCACHE_CACHE_SS)
#define BP_DIGCTL_ARMCACHE_RSVD1	6
#define BM_DIGCTL_ARMCACHE_RSVD1	0x000000C0
#define BF_DIGCTL_ARMCACHE_RSVD1(v)  \
		(((v) << 6) & BM_DIGCTL_ARMCACHE_RSVD1)
#define BP_DIGCTL_ARMCACHE_DTAG_SS	4
#define BM_DIGCTL_ARMCACHE_DTAG_SS	0x00000030
#define BF_DIGCTL_ARMCACHE_DTAG_SS(v)  \
		(((v) << 4) & BM_DIGCTL_ARMCACHE_DTAG_SS)
#define BP_DIGCTL_ARMCACHE_RSVD0	2
#define BM_DIGCTL_ARMCACHE_RSVD0	0x0000000C
#define BF_DIGCTL_ARMCACHE_RSVD0(v)  \
		(((v) << 2) & BM_DIGCTL_ARMCACHE_RSVD0)
#define BP_DIGCTL_ARMCACHE_ITAG_SS	0
#define BM_DIGCTL_ARMCACHE_ITAG_SS	0x00000003
#define BF_DIGCTL_ARMCACHE_ITAG_SS(v)  \
		(((v) << 0) & BM_DIGCTL_ARMCACHE_ITAG_SS)

#define HW_DIGCTL_DEBUG_TRAP	(0x000002b0)
#define HW_DIGCTL_DEBUG_TRAP_SET	(0x000002b4)
#define HW_DIGCTL_DEBUG_TRAP_CLR	(0x000002b8)
#define HW_DIGCTL_DEBUG_TRAP_TOG	(0x000002bc)

#define BP_DIGCTL_DEBUG_TRAP_RSVD2	12
#define BM_DIGCTL_DEBUG_TRAP_RSVD2	0xFFFFF000
#define BF_DIGCTL_DEBUG_TRAP_RSVD2(v) \
		(((v) << 12) & BM_DIGCTL_DEBUG_TRAP_RSVD2)
#define BP_DIGCTL_DEBUG_TRAP_RSVD1	10
#define BM_DIGCTL_DEBUG_TRAP_RSVD1	0x00000C00
#define BF_DIGCTL_DEBUG_TRAP_RSVD1(v)  \
		(((v) << 10) & BM_DIGCTL_DEBUG_TRAP_RSVD1)
#define BP_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID	8
#define BM_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID	0x00000300
#define BF_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID(v)  \
		(((v) << 8) & BM_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID)
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID__PXP   0x0
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID__LCDIF 0x1
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID__BCH   0x2
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L0_MASTER_ID__DCP   0x3
#define BM_DIGCTL_DEBUG_TRAP_RSVD0	0x00000080
#define BP_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID	4
#define BM_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID	0x00000070
#define BF_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID(v)  \
		(((v) << 4) & BM_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID)
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__APBH_BRIDE_DMA 0x0
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__APBX_BRIDE_DMA 0x1
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__USB0           0x2
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__USB1           0x3
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__ENET_M0        0x4
#define BV_DIGCTL_DEBUG_TRAP_TRAP_L3_MASTER_ID__ENET_M1        0x5
#define BM_DIGCTL_DEBUG_TRAP_TRAP_L3_IRQ	0x00000008
#define BM_DIGCTL_DEBUG_TRAP_TRAP_L0_IRQ	0x00000004
#define BM_DIGCTL_DEBUG_TRAP_TRAP_IN_RANGE	0x00000002
#define BM_DIGCTL_DEBUG_TRAP_TRAP_ENABLE	0x00000001

#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW	(0x000002c0)

#define BP_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_ADDR	0
#define BM_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_ADDR	0xFFFFFFFF
#define BF_DIGCTL_DEBUG_TRAP_L0_ADDR_LOW_ADDR(v)	(v)

#define HW_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH	(0x000002d0)

#define BP_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_ADDR	0
#define BM_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_ADDR	0xFFFFFFFF
#define BF_DIGCTL_DEBUG_TRAP_L0_ADDR_HIGH_ADDR(v)	(v)

#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW	(0x000002e0)

#define BP_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_ADDR	0
#define BM_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_ADDR	0xFFFFFFFF
#define BF_DIGCTL_DEBUG_TRAP_L3_ADDR_LOW_ADDR(v)	(v)

#define HW_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH	(0x000002f0)

#define BP_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_ADDR	0
#define BM_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_ADDR	0xFFFFFFFF
#define BF_DIGCTL_DEBUG_TRAP_L3_ADDR_HIGH_ADDR(v)	(v)

#define HW_DIGCTL_FSL	(0x00000300)

#define BP_DIGCTL_FSL_COPYRIGHT	0
#define BM_DIGCTL_FSL_COPYRIGHT	0xFFFFFFFF
#define BF_DIGCTL_FSL_COPYRIGHT(v)	(v)

#define HW_DIGCTL_CHIPID	(0x00000310)

#define BP_DIGCTL_CHIPID_PRODUCT_CODE	16
#define BM_DIGCTL_CHIPID_PRODUCT_CODE	0xFFFF0000
#define BF_DIGCTL_CHIPID_PRODUCT_CODE(v) \
		(((v) << 16) & BM_DIGCTL_CHIPID_PRODUCT_CODE)
#define BP_DIGCTL_CHIPID_RSVD0	8
#define BM_DIGCTL_CHIPID_RSVD0	0x0000FF00
#define BF_DIGCTL_CHIPID_RSVD0(v)  \
		(((v) << 8) & BM_DIGCTL_CHIPID_RSVD0)
#define BP_DIGCTL_CHIPID_REVISION	0
#define BM_DIGCTL_CHIPID_REVISION	0x000000FF
#define BF_DIGCTL_CHIPID_REVISION(v)  \
		(((v) << 0) & BM_DIGCTL_CHIPID_REVISION)

#define HW_DIGCTL_AHB_STATS_SELECT	(0x00000330)

#define BP_DIGCTL_AHB_STATS_SELECT_RSVD0	24
#define BM_DIGCTL_AHB_STATS_SELECT_RSVD0	0xFF000000
#define BF_DIGCTL_AHB_STATS_SELECT_RSVD0(v) \
		(((v) << 24) & BM_DIGCTL_AHB_STATS_SELECT_RSVD0)
#define BP_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT	16
#define BM_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT	0x00FF0000
#define BF_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT(v)  \
		(((v) << 16) & BM_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__APBHDMA 0x1
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__APBXDMA 0x2
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__USB0    0x4
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__USB1    0x8
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__UDMA0   0x10
#define BV_DIGCTL_AHB_STATS_SELECT_L3_MASTER_SELECT__UDMA1   0x20
#define BP_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT	8
#define BM_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT	0x0000FF00
#define BF_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT(v)  \
		(((v) << 8) & BM_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L2_MASTER_SELECT__ARMD 0x1
#define BP_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT	0
#define BM_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT	0x000000FF
#define BF_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT(v)  \
		(((v) << 0) & BM_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT)
#define BV_DIGCTL_AHB_STATS_SELECT_L1_MASTER_SELECT__ARMI 0x1

#define HW_DIGCTL_L1_AHB_ACTIVE_CYCLES	(0x00000370)

#define BP_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT	0
#define BM_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L1_AHB_ACTIVE_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L1_AHB_DATA_STALLED	(0x00000380)

#define BP_DIGCTL_L1_AHB_DATA_STALLED_COUNT	0
#define BM_DIGCTL_L1_AHB_DATA_STALLED_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L1_AHB_DATA_STALLED_COUNT(v)	(v)

#define HW_DIGCTL_L1_AHB_DATA_CYCLES	(0x00000390)

#define BP_DIGCTL_L1_AHB_DATA_CYCLES_COUNT	0
#define BM_DIGCTL_L1_AHB_DATA_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L1_AHB_DATA_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L2_AHB_ACTIVE_CYCLES	(0x000003a0)

#define BP_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT	0
#define BM_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L2_AHB_ACTIVE_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L2_AHB_DATA_STALLED	(0x000003b0)

#define BP_DIGCTL_L2_AHB_DATA_STALLED_COUNT	0
#define BM_DIGCTL_L2_AHB_DATA_STALLED_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L2_AHB_DATA_STALLED_COUNT(v)	(v)

#define HW_DIGCTL_L2_AHB_DATA_CYCLES	(0x000003c0)

#define BP_DIGCTL_L2_AHB_DATA_CYCLES_COUNT	0
#define BM_DIGCTL_L2_AHB_DATA_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L2_AHB_DATA_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L3_AHB_ACTIVE_CYCLES	(0x000003d0)

#define BP_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT	0
#define BM_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L3_AHB_ACTIVE_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_L3_AHB_DATA_STALLED	(0x000003e0)

#define BP_DIGCTL_L3_AHB_DATA_STALLED_COUNT	0
#define BM_DIGCTL_L3_AHB_DATA_STALLED_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L3_AHB_DATA_STALLED_COUNT(v)	(v)

#define HW_DIGCTL_L3_AHB_DATA_CYCLES	(0x000003f0)

#define BP_DIGCTL_L3_AHB_DATA_CYCLES_COUNT	0
#define BM_DIGCTL_L3_AHB_DATA_CYCLES_COUNT	0xFFFFFFFF
#define BF_DIGCTL_L3_AHB_DATA_CYCLES_COUNT(v)	(v)

#define HW_DIGCTL_MPTE0_LOC	(0x00000500)

#define BM_DIGCTL_MPTE0_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE0_LOC_RSVD1	27
#define BM_DIGCTL_MPTE0_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE0_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE0_LOC_RSVD1)
#define BP_DIGCTL_MPTE0_LOC_SPAN	24
#define BM_DIGCTL_MPTE0_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE0_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE0_LOC_SPAN)
#define BP_DIGCTL_MPTE0_LOC_RSVD0	12
#define BM_DIGCTL_MPTE0_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE0_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE0_LOC_RSVD0)
#define BP_DIGCTL_MPTE0_LOC_LOC	0
#define BM_DIGCTL_MPTE0_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE0_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE0_LOC_LOC)

#define HW_DIGCTL_MPTE1_LOC	(0x00000510)

#define BM_DIGCTL_MPTE1_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE1_LOC_RSVD1	27
#define BM_DIGCTL_MPTE1_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE1_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE1_LOC_RSVD1)
#define BP_DIGCTL_MPTE1_LOC_SPAN	24
#define BM_DIGCTL_MPTE1_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE1_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE1_LOC_SPAN)
#define BP_DIGCTL_MPTE1_LOC_RSVD0	12
#define BM_DIGCTL_MPTE1_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE1_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE1_LOC_RSVD0)
#define BP_DIGCTL_MPTE1_LOC_LOC	0
#define BM_DIGCTL_MPTE1_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE1_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE1_LOC_LOC)

#define HW_DIGCTL_MPTE2_LOC	(0x00000520)

#define BM_DIGCTL_MPTE2_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE2_LOC_RSVD1	27
#define BM_DIGCTL_MPTE2_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE2_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE2_LOC_RSVD1)
#define BP_DIGCTL_MPTE2_LOC_SPAN	24
#define BM_DIGCTL_MPTE2_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE2_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE2_LOC_SPAN)
#define BP_DIGCTL_MPTE2_LOC_RSVD0	12
#define BM_DIGCTL_MPTE2_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE2_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE2_LOC_RSVD0)
#define BP_DIGCTL_MPTE2_LOC_LOC	0
#define BM_DIGCTL_MPTE2_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE2_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE2_LOC_LOC)

#define HW_DIGCTL_MPTE3_LOC	(0x00000530)

#define BM_DIGCTL_MPTE3_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE3_LOC_RSVD1	27
#define BM_DIGCTL_MPTE3_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE3_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE3_LOC_RSVD1)
#define BP_DIGCTL_MPTE3_LOC_SPAN	24
#define BM_DIGCTL_MPTE3_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE3_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE3_LOC_SPAN)
#define BP_DIGCTL_MPTE3_LOC_RSVD0	12
#define BM_DIGCTL_MPTE3_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE3_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE3_LOC_RSVD0)
#define BP_DIGCTL_MPTE3_LOC_LOC	0
#define BM_DIGCTL_MPTE3_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE3_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE3_LOC_LOC)

#define HW_DIGCTL_MPTE4_LOC	(0x00000540)

#define BM_DIGCTL_MPTE4_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE4_LOC_RSVD1	27
#define BM_DIGCTL_MPTE4_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE4_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE4_LOC_RSVD1)
#define BP_DIGCTL_MPTE4_LOC_SPAN	24
#define BM_DIGCTL_MPTE4_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE4_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE4_LOC_SPAN)
#define BP_DIGCTL_MPTE4_LOC_RSVD0	12
#define BM_DIGCTL_MPTE4_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE4_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE4_LOC_RSVD0)
#define BP_DIGCTL_MPTE4_LOC_LOC	0
#define BM_DIGCTL_MPTE4_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE4_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE4_LOC_LOC)

#define HW_DIGCTL_MPTE5_LOC	(0x00000550)

#define BM_DIGCTL_MPTE5_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE5_LOC_RSVD1	27
#define BM_DIGCTL_MPTE5_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE5_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE5_LOC_RSVD1)
#define BP_DIGCTL_MPTE5_LOC_SPAN	24
#define BM_DIGCTL_MPTE5_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE5_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE5_LOC_SPAN)
#define BP_DIGCTL_MPTE5_LOC_RSVD0	12
#define BM_DIGCTL_MPTE5_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE5_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE5_LOC_RSVD0)
#define BP_DIGCTL_MPTE5_LOC_LOC	0
#define BM_DIGCTL_MPTE5_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE5_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE5_LOC_LOC)

#define HW_DIGCTL_MPTE6_LOC	(0x00000560)

#define BM_DIGCTL_MPTE6_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE6_LOC_RSVD1	27
#define BM_DIGCTL_MPTE6_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE6_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE6_LOC_RSVD1)
#define BP_DIGCTL_MPTE6_LOC_SPAN	24
#define BM_DIGCTL_MPTE6_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE6_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE6_LOC_SPAN)
#define BP_DIGCTL_MPTE6_LOC_RSVD0	12
#define BM_DIGCTL_MPTE6_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE6_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE6_LOC_RSVD0)
#define BP_DIGCTL_MPTE6_LOC_LOC	0
#define BM_DIGCTL_MPTE6_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE6_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE6_LOC_LOC)

#define HW_DIGCTL_MPTE7_LOC	(0x00000570)

#define BM_DIGCTL_MPTE7_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE7_LOC_RSVD1	27
#define BM_DIGCTL_MPTE7_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE7_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE7_LOC_RSVD1)
#define BP_DIGCTL_MPTE7_LOC_SPAN	24
#define BM_DIGCTL_MPTE7_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE7_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE7_LOC_SPAN)
#define BP_DIGCTL_MPTE7_LOC_RSVD0	12
#define BM_DIGCTL_MPTE7_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE7_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE7_LOC_RSVD0)
#define BP_DIGCTL_MPTE7_LOC_LOC	0
#define BM_DIGCTL_MPTE7_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE7_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE7_LOC_LOC)

#define HW_DIGCTL_MPTE8_LOC	(0x00000580)

#define BM_DIGCTL_MPTE8_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE8_LOC_RSVD1	27
#define BM_DIGCTL_MPTE8_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE8_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE8_LOC_RSVD1)
#define BP_DIGCTL_MPTE8_LOC_SPAN	24
#define BM_DIGCTL_MPTE8_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE8_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE8_LOC_SPAN)
#define BP_DIGCTL_MPTE8_LOC_RSVD0	12
#define BM_DIGCTL_MPTE8_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE8_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE8_LOC_RSVD0)
#define BP_DIGCTL_MPTE8_LOC_LOC	0
#define BM_DIGCTL_MPTE8_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE8_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE8_LOC_LOC)

#define HW_DIGCTL_MPTE9_LOC	(0x00000590)

#define BM_DIGCTL_MPTE9_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE9_LOC_RSVD1	27
#define BM_DIGCTL_MPTE9_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE9_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE9_LOC_RSVD1)
#define BP_DIGCTL_MPTE9_LOC_SPAN	24
#define BM_DIGCTL_MPTE9_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE9_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE9_LOC_SPAN)
#define BP_DIGCTL_MPTE9_LOC_RSVD0	12
#define BM_DIGCTL_MPTE9_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE9_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE9_LOC_RSVD0)
#define BP_DIGCTL_MPTE9_LOC_LOC	0
#define BM_DIGCTL_MPTE9_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE9_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE9_LOC_LOC)

#define HW_DIGCTL_MPTE10_LOC	(0x000005a0)

#define BM_DIGCTL_MPTE10_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE10_LOC_RSVD1	27
#define BM_DIGCTL_MPTE10_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE10_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE10_LOC_RSVD1)
#define BP_DIGCTL_MPTE10_LOC_SPAN	24
#define BM_DIGCTL_MPTE10_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE10_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE10_LOC_SPAN)
#define BP_DIGCTL_MPTE10_LOC_RSVD0	12
#define BM_DIGCTL_MPTE10_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE10_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE10_LOC_RSVD0)
#define BP_DIGCTL_MPTE10_LOC_LOC	0
#define BM_DIGCTL_MPTE10_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE10_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE10_LOC_LOC)

#define HW_DIGCTL_MPTE11_LOC	(0x000005b0)

#define BM_DIGCTL_MPTE11_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE11_LOC_RSVD1	27
#define BM_DIGCTL_MPTE11_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE11_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE11_LOC_RSVD1)
#define BP_DIGCTL_MPTE11_LOC_SPAN	24
#define BM_DIGCTL_MPTE11_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE11_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE11_LOC_SPAN)
#define BP_DIGCTL_MPTE11_LOC_RSVD0	12
#define BM_DIGCTL_MPTE11_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE11_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE11_LOC_RSVD0)
#define BP_DIGCTL_MPTE11_LOC_LOC	0
#define BM_DIGCTL_MPTE11_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE11_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE11_LOC_LOC)

#define HW_DIGCTL_MPTE12_LOC	(0x000005c0)

#define BM_DIGCTL_MPTE12_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE12_LOC_RSVD1	27
#define BM_DIGCTL_MPTE12_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE12_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE12_LOC_RSVD1)
#define BP_DIGCTL_MPTE12_LOC_SPAN	24
#define BM_DIGCTL_MPTE12_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE12_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE12_LOC_SPAN)
#define BP_DIGCTL_MPTE12_LOC_RSVD0	12
#define BM_DIGCTL_MPTE12_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE12_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE12_LOC_RSVD0)
#define BP_DIGCTL_MPTE12_LOC_LOC	0
#define BM_DIGCTL_MPTE12_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE12_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE12_LOC_LOC)

#define HW_DIGCTL_MPTE13_LOC	(0x000005d0)

#define BM_DIGCTL_MPTE13_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE13_LOC_RSVD1	27
#define BM_DIGCTL_MPTE13_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE13_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE13_LOC_RSVD1)
#define BP_DIGCTL_MPTE13_LOC_SPAN	24
#define BM_DIGCTL_MPTE13_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE13_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE13_LOC_SPAN)
#define BP_DIGCTL_MPTE13_LOC_RSVD0	12
#define BM_DIGCTL_MPTE13_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE13_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE13_LOC_RSVD0)
#define BP_DIGCTL_MPTE13_LOC_LOC	0
#define BM_DIGCTL_MPTE13_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE13_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE13_LOC_LOC)

#define HW_DIGCTL_MPTE14_LOC	(0x000005e0)

#define BM_DIGCTL_MPTE14_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE14_LOC_RSVD1	27
#define BM_DIGCTL_MPTE14_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE14_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE14_LOC_RSVD1)
#define BP_DIGCTL_MPTE14_LOC_SPAN	24
#define BM_DIGCTL_MPTE14_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE14_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE14_LOC_SPAN)
#define BP_DIGCTL_MPTE14_LOC_RSVD0	12
#define BM_DIGCTL_MPTE14_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE14_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE14_LOC_RSVD0)
#define BP_DIGCTL_MPTE14_LOC_LOC	0
#define BM_DIGCTL_MPTE14_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE14_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE14_LOC_LOC)

#define HW_DIGCTL_MPTE15_LOC	(0x000005f0)

#define BM_DIGCTL_MPTE15_LOC_DIS	0x80000000
#define BP_DIGCTL_MPTE15_LOC_RSVD1	27
#define BM_DIGCTL_MPTE15_LOC_RSVD1	0x78000000
#define BF_DIGCTL_MPTE15_LOC_RSVD1(v)  \
		(((v) << 27) & BM_DIGCTL_MPTE15_LOC_RSVD1)
#define BP_DIGCTL_MPTE15_LOC_SPAN	24
#define BM_DIGCTL_MPTE15_LOC_SPAN	0x07000000
#define BF_DIGCTL_MPTE15_LOC_SPAN(v)  \
		(((v) << 24) & BM_DIGCTL_MPTE15_LOC_SPAN)
#define BP_DIGCTL_MPTE15_LOC_RSVD0	12
#define BM_DIGCTL_MPTE15_LOC_RSVD0	0x00FFF000
#define BF_DIGCTL_MPTE15_LOC_RSVD0(v)  \
		(((v) << 12) & BM_DIGCTL_MPTE15_LOC_RSVD0)
#define BP_DIGCTL_MPTE15_LOC_LOC	0
#define BM_DIGCTL_MPTE15_LOC_LOC	0x00000FFF
#define BF_DIGCTL_MPTE15_LOC_LOC(v)  \
		(((v) << 0) & BM_DIGCTL_MPTE15_LOC_LOC)
#endif /* __ARCH_ARM___DIGCTL_H */
