/*
 * Freescale OCOTP Register Definitions
 *
 * Copyright 2008-2010 Freescale Semiconductor, Inc.
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 *
 * Xml Revision: 1.21
 * Template revision: 26195
 */

#ifndef __ARCH_ARM___OCOTP_H
#define __ARCH_ARM___OCOTP_H


#define HW_OCOTP_CTRL	(0x00000000)
#define HW_OCOTP_CTRL_SET	(0x00000004)
#define HW_OCOTP_CTRL_CLR	(0x00000008)
#define HW_OCOTP_CTRL_TOG	(0x0000000c)

#define BP_OCOTP_CTRL_WR_UNLOCK	16
#define BM_OCOTP_CTRL_WR_UNLOCK	0xFFFF0000
#define BF_OCOTP_CTRL_WR_UNLOCK(v) \
		(((v) << 16) & BM_OCOTP_CTRL_WR_UNLOCK)
#define BV_OCOTP_CTRL_WR_UNLOCK__KEY 0x3E77
#define BP_OCOTP_CTRL_RSRVD2	14
#define BM_OCOTP_CTRL_RSRVD2	0x0000C000
#define BF_OCOTP_CTRL_RSRVD2(v)  \
		(((v) << 14) & BM_OCOTP_CTRL_RSRVD2)
#define BM_OCOTP_CTRL_RELOAD_SHADOWS	0x00002000
#define BM_OCOTP_CTRL_RD_BANK_OPEN	0x00001000
#define BP_OCOTP_CTRL_RSRVD1	10
#define BM_OCOTP_CTRL_RSRVD1	0x00000C00
#define BF_OCOTP_CTRL_RSRVD1(v)  \
		(((v) << 10) & BM_OCOTP_CTRL_RSRVD1)
#define BM_OCOTP_CTRL_ERROR	0x00000200
#define BM_OCOTP_CTRL_BUSY	0x00000100
#define BP_OCOTP_CTRL_RSRVD0	5
#define BM_OCOTP_CTRL_RSRVD0	0x000000E0
#define BF_OCOTP_CTRL_RSRVD0(v)  \
		(((v) << 5) & BM_OCOTP_CTRL_RSRVD0)
#define BP_OCOTP_CTRL_ADDR	0
#define BM_OCOTP_CTRL_ADDR	0x0000001F
#define BF_OCOTP_CTRL_ADDR(v)  \
		(((v) << 0) & BM_OCOTP_CTRL_ADDR)

#define HW_OCOTP_DATA	(0x00000010)

#define BP_OCOTP_DATA_DATA	0
#define BM_OCOTP_DATA_DATA	0xFFFFFFFF
#define BF_OCOTP_DATA_DATA(v)	(v)

/*
 *  multi-register-define name HW_OCOTP_CUSTn
 *              base 0x00000020
 *              count 4
 *              offset 0x10
 */
#define HW_OCOTP_CUSTn(n)	(0x00000020 + (n) * 0x10)
#define BP_OCOTP_CUSTn_BITS	0
#define BM_OCOTP_CUSTn_BITS	0xFFFFFFFF
#define BF_OCOTP_CUSTn_BITS(v)	(v)

/*
 *  multi-register-define name HW_OCOTP_CRYPTOn
 *              base 0x00000060
 *              count 4
 *              offset 0x10
 */
#define HW_OCOTP_CRYPTOn(n)	(0x00000060 + (n) * 0x10)
#define BP_OCOTP_CRYPTOn_BITS	0
#define BM_OCOTP_CRYPTOn_BITS	0xFFFFFFFF
#define BF_OCOTP_CRYPTOn_BITS(v)	(v)

/*
 *  multi-register-define name HW_OCOTP_HWCAPn
 *              base 0x000000A0
 *              count 6
 *              offset 0x10
 */
#define HW_OCOTP_HWCAPn(n)	(0x000000a0 + (n) * 0x10)
#define BP_OCOTP_HWCAPn_BITS	0
#define BM_OCOTP_HWCAPn_BITS	0xFFFFFFFF
#define BF_OCOTP_HWCAPn_BITS(v)	(v)

#define HW_OCOTP_SWCAP	(0x00000100)

#define BP_OCOTP_SWCAP_BITS	0
#define BM_OCOTP_SWCAP_BITS	0xFFFFFFFF
#define BF_OCOTP_SWCAP_BITS(v)	(v)

#define HW_OCOTP_CUSTCAP	(0x00000110)

#define BM_OCOTP_CUSTCAP_CUST_DISABLE_WMADRM9	0x80000000
#define BM_OCOTP_CUSTCAP_CUST_DISABLE_JANUSDRM10	0x40000000
#define BP_OCOTP_CUSTCAP_RSRVD1	5
#define BM_OCOTP_CUSTCAP_RSRVD1	0x3FFFFFE0
#define BF_OCOTP_CUSTCAP_RSRVD1(v)  \
		(((v) << 5) & BM_OCOTP_CUSTCAP_RSRVD1)
#define BM_OCOTP_CUSTCAP_ENABLE_SJTAG_12MA_DRIVE	0x00000010
#define BM_OCOTP_CUSTCAP_USE_PARALLEL_JTAG	0x00000008
#define BM_OCOTP_CUSTCAP_RTC_XTAL_32768_PRESENT	0x00000004
#define BM_OCOTP_CUSTCAP_RTC_XTAL_32000_PRESENT	0x00000002
#define BM_OCOTP_CUSTCAP_RSRVD0	0x00000001

#define HW_OCOTP_LOCK	(0x00000120)

#define BM_OCOTP_LOCK_ROM7	0x80000000
#define BM_OCOTP_LOCK_ROM6	0x40000000
#define BM_OCOTP_LOCK_ROM5	0x20000000
#define BM_OCOTP_LOCK_ROM4	0x10000000
#define BM_OCOTP_LOCK_ROM3	0x08000000
#define BM_OCOTP_LOCK_ROM2	0x04000000
#define BM_OCOTP_LOCK_ROM1	0x02000000
#define BM_OCOTP_LOCK_ROM0	0x01000000
#define BM_OCOTP_LOCK_HWSW_SHADOW_ALT	0x00800000
#define BM_OCOTP_LOCK_CRYPTODCP_ALT	0x00400000
#define BM_OCOTP_LOCK_CRYPTOKEY_ALT	0x00200000
#define BM_OCOTP_LOCK_PIN	0x00100000
#define BM_OCOTP_LOCK_OPS	0x00080000
#define BM_OCOTP_LOCK_UN2	0x00040000
#define BM_OCOTP_LOCK_UN1	0x00020000
#define BM_OCOTP_LOCK_UN0	0x00010000
#define BP_OCOTP_LOCK_UNALLOCATED	11
#define BM_OCOTP_LOCK_UNALLOCATED	0x0000F800
#define BF_OCOTP_LOCK_UNALLOCATED(v)  \
		(((v) << 11) & BM_OCOTP_LOCK_UNALLOCATED)
#define BM_OCOTP_LOCK_ROM_SHADOW	0x00000400
#define BM_OCOTP_LOCK_CUSTCAP	0x00000200
#define BM_OCOTP_LOCK_HWSW	0x00000100
#define BM_OCOTP_LOCK_CUSTCAP_SHADOW	0x00000080
#define BM_OCOTP_LOCK_HWSW_SHADOW	0x00000040
#define BM_OCOTP_LOCK_CRYPTODCP	0x00000020
#define BM_OCOTP_LOCK_CRYPTOKEY	0x00000010
#define BM_OCOTP_LOCK_CUST3	0x00000008
#define BM_OCOTP_LOCK_CUST2	0x00000004
#define BM_OCOTP_LOCK_CUST1	0x00000002
#define BM_OCOTP_LOCK_CUST0	0x00000001

/*
 *  multi-register-define name HW_OCOTP_OPSn
 *              base 0x00000130
 *              count 4
 *              offset 0x10
 */
#define HW_OCOTP_OPSn(n)	(0x00000130 + (n) * 0x10)
#define BP_OCOTP_OPSn_BITS	0
#define BM_OCOTP_OPSn_BITS	0xFFFFFFFF
#define BF_OCOTP_OPSn_BITS(v)	(v)

/*
 *  multi-register-define name HW_OCOTP_UNn
 *              base 0x00000170
 *              count 3
 *              offset 0x10
 */
#define HW_OCOTP_UNn(n)	(0x00000170 + (n) * 0x10)
#define BP_OCOTP_UNn_BITS	0
#define BM_OCOTP_UNn_BITS	0xFFFFFFFF
#define BF_OCOTP_UNn_BITS(v)	(v)

#define HW_OCOTP_ROM0	(0x000001a0)

#define BP_OCOTP_ROM0_BOOT_MODE	24
#define BM_OCOTP_ROM0_BOOT_MODE	0xFF000000
#define BF_OCOTP_ROM0_BOOT_MODE(v) \
		(((v) << 24) & BM_OCOTP_ROM0_BOOT_MODE)
#define BM_OCOTP_ROM0_ENABLE_PJTAG_12MA_DRIVE	0x00800000
#define BM_OCOTP_ROM0_USE_PARALLEL_JTAG	0x00400000
#define BP_OCOTP_ROM0_SD_POWER_GATE_GPIO	20
#define BM_OCOTP_ROM0_SD_POWER_GATE_GPIO	0x00300000
#define BF_OCOTP_ROM0_SD_POWER_GATE_GPIO(v)  \
		(((v) << 20) & BM_OCOTP_ROM0_SD_POWER_GATE_GPIO)
#define BP_OCOTP_ROM0_SD_POWER_UP_DELAY	14
#define BM_OCOTP_ROM0_SD_POWER_UP_DELAY	0x000FC000
#define BF_OCOTP_ROM0_SD_POWER_UP_DELAY(v)  \
		(((v) << 14) & BM_OCOTP_ROM0_SD_POWER_UP_DELAY)
#define BP_OCOTP_ROM0_SD_BUS_WIDTH	12
#define BM_OCOTP_ROM0_SD_BUS_WIDTH	0x00003000
#define BF_OCOTP_ROM0_SD_BUS_WIDTH(v)  \
		(((v) << 12) & BM_OCOTP_ROM0_SD_BUS_WIDTH)
#define BP_OCOTP_ROM0_SSP_SCK_INDEX	8
#define BM_OCOTP_ROM0_SSP_SCK_INDEX	0x00000F00
#define BF_OCOTP_ROM0_SSP_SCK_INDEX(v)  \
		(((v) << 8) & BM_OCOTP_ROM0_SSP_SCK_INDEX)
#define BM_OCOTP_ROM0_RSRVD3	0x00000080
#define BM_OCOTP_ROM0_DISABLE_SPI_NOR_FAST_ READ	0x00000040
#define BM_OCOTP_ROM0_ENABLE_USB_BOOT_SERIAL_NUM	0x00000020
#define BM_OCOTP_ROM0_ENABLE_UNENCRYPTED_ BOOT	0x00000010
#define BM_OCOTP_ROM0_SD_MBR_BOOT	0x00000008
#define BM_OCOTP_ROM0_RSRVD2	0x00000004
#define BM_OCOTP_ROM0_RSRVD1	0x00000002
#define BM_OCOTP_ROM0_RSRVD0	0x00000001

#define HW_OCOTP_ROM1	(0x000001b0)

#define BP_OCOTP_ROM1_RSRVD1	30
#define BM_OCOTP_ROM1_RSRVD1	0xC0000000
#define BF_OCOTP_ROM1_RSRVD1(v) \
		(((v) << 30) & BM_OCOTP_ROM1_RSRVD1)
#define BP_OCOTP_ROM1_USE_ALT_GPMI_RDY3	28
#define BM_OCOTP_ROM1_USE_ALT_GPMI_RDY3	0x30000000
#define BF_OCOTP_ROM1_USE_ALT_GPMI_RDY3(v)  \
		(((v) << 28) & BM_OCOTP_ROM1_USE_ALT_GPMI_RDY3)
#define BP_OCOTP_ROM1_USE_ALT_GPMI_CE3	26
#define BM_OCOTP_ROM1_USE_ALT_GPMI_CE3	0x0C000000
#define BF_OCOTP_ROM1_USE_ALT_GPMI_CE3(v)  \
		(((v) << 26) & BM_OCOTP_ROM1_USE_ALT_GPMI_CE3)
#define BM_OCOTP_ROM1_USE_ALT_GPMI_RDY2	0x02000000
#define BM_OCOTP_ROM1_USE_ALT_GPMI_CE2	0x01000000
#define BM_OCOTP_ROM1_ENABLE_NAND3_CE_RDY_PULLUP	0x00800000
#define BM_OCOTP_ROM1_ENABLE_NAND2_CE_RDY_PULLUP	0x00400000
#define BM_OCOTP_ROM1_ENABLE_NAND1_CE_RDY_PULLUP	0x00200000
#define BM_OCOTP_ROM1_ENABLE_NAND0_CE_RDY_PULLUP	0x00100000
#define BM_OCOTP_ROM1_UNTOUCH_INTERNAL_SSP_PULLUP	0x00080000
#define BM_OCOTP_ROM1_SSP2_EXT_PULLUP	0x00040000
#define BM_OCOTP_ROM1_SSP1_EXT_PULLUP	0x00020000
#define BM_OCOTP_ROM1_SD_INCREASE_INIT_SEQ_TIME	0x00010000
#define BM_OCOTP_ROM1_SD_INIT_SEQ_2_ENABLE	0x00008000
#define BM_OCOTP_ROM1_SD_CMD0_DISABLE	0x00004000
#define BM_OCOTP_ROM1_SD_INIT_SEQ_1_DISABLE	0x00002000
#define BM_OCOTP_ROM1_USE_ALT_SSP1_DATA4_7	0x00001000
#define BP_OCOTP_ROM1_BOOT_SEARCH_COUNT	8
#define BM_OCOTP_ROM1_BOOT_SEARCH_COUNT	0x00000F00
#define BF_OCOTP_ROM1_BOOT_SEARCH_COUNT(v)  \
		(((v) << 8) & BM_OCOTP_ROM1_BOOT_SEARCH_COUNT)
#define BP_OCOTP_ROM1_RSRVD0	3
#define BM_OCOTP_ROM1_RSRVD0	0x000000F8
#define BF_OCOTP_ROM1_RSRVD0(v)  \
		(((v) << 3) & BM_OCOTP_ROM1_RSRVD0)
#define BP_OCOTP_ROM1_NUMBER_OF_NANDS	0
#define BM_OCOTP_ROM1_NUMBER_OF_NANDS	0x00000007
#define BF_OCOTP_ROM1_NUMBER_OF_NANDS(v)  \
		(((v) << 0) & BM_OCOTP_ROM1_NUMBER_OF_NANDS)

#define HW_OCOTP_ROM2	(0x000001c0)

#define BP_OCOTP_ROM2_USB_VID	16
#define BM_OCOTP_ROM2_USB_VID	0xFFFF0000
#define BF_OCOTP_ROM2_USB_VID(v) \
		(((v) << 16) & BM_OCOTP_ROM2_USB_VID)
#define BP_OCOTP_ROM2_USB_PID	0
#define BM_OCOTP_ROM2_USB_PID	0x0000FFFF
#define BF_OCOTP_ROM2_USB_PID(v)  \
		(((v) << 0) & BM_OCOTP_ROM2_USB_PID)

#define HW_OCOTP_ROM3	(0x000001d0)

#define BP_OCOTP_ROM3_RSRVD1	10
#define BM_OCOTP_ROM3_RSRVD1	0xFFFFFC00
#define BF_OCOTP_ROM3_RSRVD1(v) \
		(((v) << 10) & BM_OCOTP_ROM3_RSRVD1)
#define BP_OCOTP_ROM3_RSRVD0	0
#define BM_OCOTP_ROM3_RSRVD0	0x000003FF
#define BF_OCOTP_ROM3_RSRVD0(v)  \
		(((v) << 0) & BM_OCOTP_ROM3_RSRVD0)

#define HW_OCOTP_ROM4	(0x000001e0)

#define BP_OCOTP_ROM4_BITS	0
#define BM_OCOTP_ROM4_BITS	0xFFFFFFFF
#define BF_OCOTP_ROM4_BITS(v)	(v)

#define HW_OCOTP_ROM5	(0x000001f0)

#define BP_OCOTP_ROM5_BITS	0
#define BM_OCOTP_ROM5_BITS	0xFFFFFFFF
#define BF_OCOTP_ROM5_BITS(v)	(v)

#define HW_OCOTP_ROM6	(0x00000200)

#define BP_OCOTP_ROM6_BITS	0
#define BM_OCOTP_ROM6_BITS	0xFFFFFFFF
#define BF_OCOTP_ROM6_BITS(v)	(v)

#define HW_OCOTP_ROM7	(0x00000210)

#define BP_OCOTP_ROM7_BITS	0
#define BM_OCOTP_ROM7_BITS	0xFFFFFFFF
#define BF_OCOTP_ROM7_BITS(v)	(v)

#define HW_OCOTP_VERSION	(0x00000220)

#define BP_OCOTP_VERSION_MAJOR	24
#define BM_OCOTP_VERSION_MAJOR	0xFF000000
#define BF_OCOTP_VERSION_MAJOR(v) \
		(((v) << 24) & BM_OCOTP_VERSION_MAJOR)
#define BP_OCOTP_VERSION_MINOR	16
#define BM_OCOTP_VERSION_MINOR	0x00FF0000
#define BF_OCOTP_VERSION_MINOR(v)  \
		(((v) << 16) & BM_OCOTP_VERSION_MINOR)
#define BP_OCOTP_VERSION_STEP	0
#define BM_OCOTP_VERSION_STEP	0x0000FFFF
#define BF_OCOTP_VERSION_STEP(v)  \
		(((v) << 0) & BM_OCOTP_VERSION_STEP)
#endif /* __ARCH_ARM___OCOTP_H */
