/*
 * ALSA SoC MXS SPDIF codec driver
 *
 * Copyright (C) 2008-2010 Freescale Semiconductor, Inc.
 *
 * Based on stmp3xxx_spdif.h by:
 * Vladimir Barinov <vbarinov@embeddedalley.com>
 *
 * Copyright 2008 SigmaTel, Inc
 * Copyright 2008 Embedded Alley Solutions, Inc
 * Copyright 2008-2009 Freescale Semiconductor, Inc.
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2.  This program  is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 */
#ifndef __MXS_SPDIF_CODEC_H
#define __MXS_SPDIF_CODEC_H

#define SPDIF_CTRL_L		0
#define SPDIF_CTRL_H		1
#define SPDIF_STAT_L		2
#define SPDIF_STAT_H		3
#define SPDIF_FRAMECTRL_L	4
#define SPDIF_FRAMECTRL_H	5
#define SPDIF_SRR_L		6
#define SPDIF_SRR_H		7
#define SPDIF_DEBUG_L		8
#define SPDIF_DEBUG_H		9
#define SPDIF_DATA_L		10
#define SPDIF_DATA_H		11
#define SPDIF_VERSION_L		12
#define SPDIF_VERSION_H		13

#define SPDIF_REGNUM		14

#define HW_SPDIF_CTRL	(0x00000000)
#define HW_SPDIF_CTRL_SET	(0x00000004)
#define HW_SPDIF_CTRL_CLR	(0x00000008)
#define HW_SPDIF_CTRL_TOG	(0x0000000c)

#define BM_SPDIF_CTRL_SFTRST	0x80000000
#define BM_SPDIF_CTRL_CLKGATE	0x40000000
#define BP_SPDIF_CTRL_RSRVD1	21
#define BM_SPDIF_CTRL_RSRVD1	0x3FE00000
#define BF_SPDIF_CTRL_RSRVD1(v)  \
		(((v) << 21) & BM_SPDIF_CTRL_RSRVD1)
#define BP_SPDIF_CTRL_DMAWAIT_COUNT	16
#define BM_SPDIF_CTRL_DMAWAIT_COUNT	0x001F0000
#define BF_SPDIF_CTRL_DMAWAIT_COUNT(v)  \
		(((v) << 16) & BM_SPDIF_CTRL_DMAWAIT_COUNT)
#define BP_SPDIF_CTRL_RSRVD0	6
#define BM_SPDIF_CTRL_RSRVD0	0x0000FFC0
#define BF_SPDIF_CTRL_RSRVD0(v)  \
		(((v) << 6) & BM_SPDIF_CTRL_RSRVD0)
#define BM_SPDIF_CTRL_WAIT_END_XFER	0x00000020
#define BM_SPDIF_CTRL_WORD_LENGTH	0x00000010
#define BM_SPDIF_CTRL_FIFO_UNDERFLOW_IRQ	0x00000008
#define BM_SPDIF_CTRL_FIFO_OVERFLOW_IRQ	0x00000004
#define BM_SPDIF_CTRL_FIFO_ERROR_IRQ_EN	0x00000002
#define BM_SPDIF_CTRL_RUN	0x00000001

#define HW_SPDIF_STAT	(0x00000010)
#define HW_SPDIF_STAT_SET	(0x00000014)
#define HW_SPDIF_STAT_CLR	(0x00000018)
#define HW_SPDIF_STAT_TOG	(0x0000001c)

#define BM_SPDIF_STAT_PRESENT	0x80000000
#define BP_SPDIF_STAT_RSRVD1	1
#define BM_SPDIF_STAT_RSRVD1	0x7FFFFFFE
#define BF_SPDIF_STAT_RSRVD1(v)  \
		(((v) << 1) & BM_SPDIF_STAT_RSRVD1)
#define BM_SPDIF_STAT_END_XFER	0x00000001

#define HW_SPDIF_FRAMECTRL	(0x00000020)
#define HW_SPDIF_FRAMECTRL_SET	(0x00000024)
#define HW_SPDIF_FRAMECTRL_CLR	(0x00000028)
#define HW_SPDIF_FRAMECTRL_TOG	(0x0000002c)

#define BP_SPDIF_FRAMECTRL_RSRVD2	18
#define BM_SPDIF_FRAMECTRL_RSRVD2	0xFFFC0000
#define BF_SPDIF_FRAMECTRL_RSRVD2(v) \
		(((v) << 18) & BM_SPDIF_FRAMECTRL_RSRVD2)
#define BM_SPDIF_FRAMECTRL_V_CONFIG	0x00020000
#define BM_SPDIF_FRAMECTRL_AUTO_MUTE	0x00010000
#define BM_SPDIF_FRAMECTRL_RSRVD1	0x00008000
#define BM_SPDIF_FRAMECTRL_USER_DATA	0x00004000
#define BM_SPDIF_FRAMECTRL_V	0x00002000
#define BM_SPDIF_FRAMECTRL_L	0x00001000
#define BM_SPDIF_FRAMECTRL_RSRVD0	0x00000800
#define BP_SPDIF_FRAMECTRL_CC	4
#define BM_SPDIF_FRAMECTRL_CC	0x000007F0
#define BF_SPDIF_FRAMECTRL_CC(v)  \
		(((v) << 4) & BM_SPDIF_FRAMECTRL_CC)
#define BM_SPDIF_FRAMECTRL_PRE	0x00000008
#define BM_SPDIF_FRAMECTRL_COPY	0x00000004
#define BM_SPDIF_FRAMECTRL_AUDIO	0x00000002
#define BM_SPDIF_FRAMECTRL_PRO	0x00000001

#define HW_SPDIF_SRR	(0x00000030)
#define HW_SPDIF_SRR_SET	(0x00000034)
#define HW_SPDIF_SRR_CLR	(0x00000038)
#define HW_SPDIF_SRR_TOG	(0x0000003c)

#define BM_SPDIF_SRR_RSRVD1	0x80000000
#define BP_SPDIF_SRR_BASEMULT	28
#define BM_SPDIF_SRR_BASEMULT	0x70000000
#define BF_SPDIF_SRR_BASEMULT(v)  \
		(((v) << 28) & BM_SPDIF_SRR_BASEMULT)
#define BP_SPDIF_SRR_RSRVD0	20
#define BM_SPDIF_SRR_RSRVD0	0x0FF00000
#define BF_SPDIF_SRR_RSRVD0(v)  \
		(((v) << 20) & BM_SPDIF_SRR_RSRVD0)
#define BP_SPDIF_SRR_RATE	0
#define BM_SPDIF_SRR_RATE	0x000FFFFF
#define BF_SPDIF_SRR_RATE(v)  \
		(((v) << 0) & BM_SPDIF_SRR_RATE)

#define HW_SPDIF_DEBUG	(0x00000040)
#define HW_SPDIF_DEBUG_SET	(0x00000044)
#define HW_SPDIF_DEBUG_CLR	(0x00000048)
#define HW_SPDIF_DEBUG_TOG	(0x0000004c)

#define BP_SPDIF_DEBUG_RSRVD1	2
#define BM_SPDIF_DEBUG_RSRVD1	0xFFFFFFFC
#define BF_SPDIF_DEBUG_RSRVD1(v) \
		(((v) << 2) & BM_SPDIF_DEBUG_RSRVD1)
#define BM_SPDIF_DEBUG_DMA_PREQ	0x00000002
#define BM_SPDIF_DEBUG_FIFO_STATUS	0x00000001

#define HW_SPDIF_DATA	(0x00000050)
#define HW_SPDIF_DATA_SET	(0x00000054)
#define HW_SPDIF_DATA_CLR	(0x00000058)
#define HW_SPDIF_DATA_TOG	(0x0000005c)

#define BP_SPDIF_DATA_HIGH	16
#define BM_SPDIF_DATA_HIGH	0xFFFF0000
#define BF_SPDIF_DATA_HIGH(v) \
		(((v) << 16) & BM_SPDIF_DATA_HIGH)
#define BP_SPDIF_DATA_LOW	0
#define BM_SPDIF_DATA_LOW	0x0000FFFF
#define BF_SPDIF_DATA_LOW(v)  \
		(((v) << 0) & BM_SPDIF_DATA_LOW)

#define HW_SPDIF_VERSION	(0x00000060)

#define BP_SPDIF_VERSION_MAJOR	24
#define BM_SPDIF_VERSION_MAJOR	0xFF000000
#define BF_SPDIF_VERSION_MAJOR(v) \
		(((v) << 24) & BM_SPDIF_VERSION_MAJOR)
#define BP_SPDIF_VERSION_MINOR	16
#define BM_SPDIF_VERSION_MINOR	0x00FF0000
#define BF_SPDIF_VERSION_MINOR(v)  \
		(((v) << 16) & BM_SPDIF_VERSION_MINOR)
#define BP_SPDIF_VERSION_STEP	0
#define BM_SPDIF_VERSION_STEP	0x0000FFFF
#define BF_SPDIF_VERSION_STEP(v)  \
		(((v) << 0) & BM_SPDIF_VERSION_STEP)

#define MXS_SPDIF_RATES         (SNDRV_PCM_RATE_32000 | SNDRV_PCM_RATE_44100 | \
				SNDRV_PCM_RATE_48000 | SNDRV_PCM_RATE_64000 | \
				SNDRV_PCM_RATE_88200 | SNDRV_PCM_RATE_96000)

#define MXS_SPDIF_FORMATS       (SNDRV_PCM_FMTBIT_S16_LE | \
				SNDRV_PCM_FMTBIT_S20_3LE | \
				SNDRV_PCM_FMTBIT_S24_LE | \
				SNDRV_PCM_FMTBIT_S32_LE)

extern struct snd_soc_dai mxs_spdif_codec_dai;
extern struct snd_soc_codec_device soc_spdif_codec_dev_mxs;

#endif /* __MXS_SPDIF_CODEC_H */
