/* Copyright (c) 2002,2007-2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if !defined (_CP_FIDDLE_H)
#define _CP_FIDDLE_H


/*******************************************************
 * Enums
 *******************************************************/


/*******************************************************
 * Values
 *******************************************************/


/*******************************************************
 * Structures
 *******************************************************/

/*
 * CP_RB_BASE struct
 */

#define CP_RB_BASE_RB_BASE_SIZE        27

#define CP_RB_BASE_RB_BASE_SHIFT       5

#define CP_RB_BASE_RB_BASE_MASK        0xffffffe0

#define CP_RB_BASE_MASK \
     (CP_RB_BASE_RB_BASE_MASK)

#define CP_RB_BASE(rb_base) \
     ((rb_base << CP_RB_BASE_RB_BASE_SHIFT))

#define CP_RB_BASE_GET_RB_BASE(cp_rb_base) \
     ((cp_rb_base & CP_RB_BASE_RB_BASE_MASK) >> CP_RB_BASE_RB_BASE_SHIFT)

#define CP_RB_BASE_SET_RB_BASE(cp_rb_base_reg, rb_base) \
     cp_rb_base_reg = (cp_rb_base_reg & ~CP_RB_BASE_RB_BASE_MASK) | (rb_base << CP_RB_BASE_RB_BASE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_rb_base_t {
          unsigned int                                : 5;
          unsigned int rb_base                        : CP_RB_BASE_RB_BASE_SIZE;
     } cp_rb_base_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_rb_base_t {
          unsigned int rb_base                        : CP_RB_BASE_RB_BASE_SIZE;
          unsigned int                                : 5;
     } cp_rb_base_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_rb_base_t f;
} cp_rb_base_u;


/*
 * CP_RB_CNTL struct
 */

#define CP_RB_CNTL_RB_BUFSZ_SIZE       6
#define CP_RB_CNTL_RB_BLKSZ_SIZE       6
#define CP_RB_CNTL_BUF_SWAP_SIZE       2
#define CP_RB_CNTL_RB_POLL_EN_SIZE     1
#define CP_RB_CNTL_RB_NO_UPDATE_SIZE   1
#define CP_RB_CNTL_RB_RPTR_WR_ENA_SIZE 1

#define CP_RB_CNTL_RB_BUFSZ_SHIFT      0
#define CP_RB_CNTL_RB_BLKSZ_SHIFT      8
#define CP_RB_CNTL_BUF_SWAP_SHIFT      16
#define CP_RB_CNTL_RB_POLL_EN_SHIFT    20
#define CP_RB_CNTL_RB_NO_UPDATE_SHIFT  27
#define CP_RB_CNTL_RB_RPTR_WR_ENA_SHIFT 31

#define CP_RB_CNTL_RB_BUFSZ_MASK       0x0000003f
#define CP_RB_CNTL_RB_BLKSZ_MASK       0x00003f00
#define CP_RB_CNTL_BUF_SWAP_MASK       0x00030000
#define CP_RB_CNTL_RB_POLL_EN_MASK     0x00100000
#define CP_RB_CNTL_RB_NO_UPDATE_MASK   0x08000000
#define CP_RB_CNTL_RB_RPTR_WR_ENA_MASK 0x80000000

#define CP_RB_CNTL_MASK \
     (CP_RB_CNTL_RB_BUFSZ_MASK | \
      CP_RB_CNTL_RB_BLKSZ_MASK | \
      CP_RB_CNTL_BUF_SWAP_MASK | \
      CP_RB_CNTL_RB_POLL_EN_MASK | \
      CP_RB_CNTL_RB_NO_UPDATE_MASK | \
      CP_RB_CNTL_RB_RPTR_WR_ENA_MASK)

#define CP_RB_CNTL(rb_bufsz, rb_blksz, buf_swap, rb_poll_en, rb_no_update, rb_rptr_wr_ena) \
     ((rb_bufsz << CP_RB_CNTL_RB_BUFSZ_SHIFT) | \
      (rb_blksz << CP_RB_CNTL_RB_BLKSZ_SHIFT) | \
      (buf_swap << CP_RB_CNTL_BUF_SWAP_SHIFT) | \
      (rb_poll_en << CP_RB_CNTL_RB_POLL_EN_SHIFT) | \
      (rb_no_update << CP_RB_CNTL_RB_NO_UPDATE_SHIFT) | \
      (rb_rptr_wr_ena << CP_RB_CNTL_RB_RPTR_WR_ENA_SHIFT))

#define CP_RB_CNTL_GET_RB_BUFSZ(cp_rb_cntl) \
     ((cp_rb_cntl & CP_RB_CNTL_RB_BUFSZ_MASK) >> CP_RB_CNTL_RB_BUFSZ_SHIFT)
#define CP_RB_CNTL_GET_RB_BLKSZ(cp_rb_cntl) \
     ((cp_rb_cntl & CP_RB_CNTL_RB_BLKSZ_MASK) >> CP_RB_CNTL_RB_BLKSZ_SHIFT)
#define CP_RB_CNTL_GET_BUF_SWAP(cp_rb_cntl) \
     ((cp_rb_cntl & CP_RB_CNTL_BUF_SWAP_MASK) >> CP_RB_CNTL_BUF_SWAP_SHIFT)
#define CP_RB_CNTL_GET_RB_POLL_EN(cp_rb_cntl) \
     ((cp_rb_cntl & CP_RB_CNTL_RB_POLL_EN_MASK) >> CP_RB_CNTL_RB_POLL_EN_SHIFT)
#define CP_RB_CNTL_GET_RB_NO_UPDATE(cp_rb_cntl) \
     ((cp_rb_cntl & CP_RB_CNTL_RB_NO_UPDATE_MASK) >> CP_RB_CNTL_RB_NO_UPDATE_SHIFT)
#define CP_RB_CNTL_GET_RB_RPTR_WR_ENA(cp_rb_cntl) \
     ((cp_rb_cntl & CP_RB_CNTL_RB_RPTR_WR_ENA_MASK) >> CP_RB_CNTL_RB_RPTR_WR_ENA_SHIFT)

#define CP_RB_CNTL_SET_RB_BUFSZ(cp_rb_cntl_reg, rb_bufsz) \
     cp_rb_cntl_reg = (cp_rb_cntl_reg & ~CP_RB_CNTL_RB_BUFSZ_MASK) | (rb_bufsz << CP_RB_CNTL_RB_BUFSZ_SHIFT)
#define CP_RB_CNTL_SET_RB_BLKSZ(cp_rb_cntl_reg, rb_blksz) \
     cp_rb_cntl_reg = (cp_rb_cntl_reg & ~CP_RB_CNTL_RB_BLKSZ_MASK) | (rb_blksz << CP_RB_CNTL_RB_BLKSZ_SHIFT)
#define CP_RB_CNTL_SET_BUF_SWAP(cp_rb_cntl_reg, buf_swap) \
     cp_rb_cntl_reg = (cp_rb_cntl_reg & ~CP_RB_CNTL_BUF_SWAP_MASK) | (buf_swap << CP_RB_CNTL_BUF_SWAP_SHIFT)
#define CP_RB_CNTL_SET_RB_POLL_EN(cp_rb_cntl_reg, rb_poll_en) \
     cp_rb_cntl_reg = (cp_rb_cntl_reg & ~CP_RB_CNTL_RB_POLL_EN_MASK) | (rb_poll_en << CP_RB_CNTL_RB_POLL_EN_SHIFT)
#define CP_RB_CNTL_SET_RB_NO_UPDATE(cp_rb_cntl_reg, rb_no_update) \
     cp_rb_cntl_reg = (cp_rb_cntl_reg & ~CP_RB_CNTL_RB_NO_UPDATE_MASK) | (rb_no_update << CP_RB_CNTL_RB_NO_UPDATE_SHIFT)
#define CP_RB_CNTL_SET_RB_RPTR_WR_ENA(cp_rb_cntl_reg, rb_rptr_wr_ena) \
     cp_rb_cntl_reg = (cp_rb_cntl_reg & ~CP_RB_CNTL_RB_RPTR_WR_ENA_MASK) | (rb_rptr_wr_ena << CP_RB_CNTL_RB_RPTR_WR_ENA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_rb_cntl_t {
          unsigned int rb_bufsz                       : CP_RB_CNTL_RB_BUFSZ_SIZE;
          unsigned int                                : 2;
          unsigned int rb_blksz                       : CP_RB_CNTL_RB_BLKSZ_SIZE;
          unsigned int                                : 2;
          unsigned int buf_swap                       : CP_RB_CNTL_BUF_SWAP_SIZE;
          unsigned int                                : 2;
          unsigned int rb_poll_en                     : CP_RB_CNTL_RB_POLL_EN_SIZE;
          unsigned int                                : 6;
          unsigned int rb_no_update                   : CP_RB_CNTL_RB_NO_UPDATE_SIZE;
          unsigned int                                : 3;
          unsigned int rb_rptr_wr_ena                 : CP_RB_CNTL_RB_RPTR_WR_ENA_SIZE;
     } cp_rb_cntl_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_rb_cntl_t {
          unsigned int rb_rptr_wr_ena                 : CP_RB_CNTL_RB_RPTR_WR_ENA_SIZE;
          unsigned int                                : 3;
          unsigned int rb_no_update                   : CP_RB_CNTL_RB_NO_UPDATE_SIZE;
          unsigned int                                : 6;
          unsigned int rb_poll_en                     : CP_RB_CNTL_RB_POLL_EN_SIZE;
          unsigned int                                : 2;
          unsigned int buf_swap                       : CP_RB_CNTL_BUF_SWAP_SIZE;
          unsigned int                                : 2;
          unsigned int rb_blksz                       : CP_RB_CNTL_RB_BLKSZ_SIZE;
          unsigned int                                : 2;
          unsigned int rb_bufsz                       : CP_RB_CNTL_RB_BUFSZ_SIZE;
     } cp_rb_cntl_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_rb_cntl_t f;
} cp_rb_cntl_u;


/*
 * CP_RB_RPTR_ADDR struct
 */

#define CP_RB_RPTR_ADDR_RB_RPTR_SWAP_SIZE 2
#define CP_RB_RPTR_ADDR_RB_RPTR_ADDR_SIZE 30

#define CP_RB_RPTR_ADDR_RB_RPTR_SWAP_SHIFT 0
#define CP_RB_RPTR_ADDR_RB_RPTR_ADDR_SHIFT 2

#define CP_RB_RPTR_ADDR_RB_RPTR_SWAP_MASK 0x00000003
#define CP_RB_RPTR_ADDR_RB_RPTR_ADDR_MASK 0xfffffffc

#define CP_RB_RPTR_ADDR_MASK \
     (CP_RB_RPTR_ADDR_RB_RPTR_SWAP_MASK | \
      CP_RB_RPTR_ADDR_RB_RPTR_ADDR_MASK)

#define CP_RB_RPTR_ADDR(rb_rptr_swap, rb_rptr_addr) \
     ((rb_rptr_swap << CP_RB_RPTR_ADDR_RB_RPTR_SWAP_SHIFT) | \
      (rb_rptr_addr << CP_RB_RPTR_ADDR_RB_RPTR_ADDR_SHIFT))

#define CP_RB_RPTR_ADDR_GET_RB_RPTR_SWAP(cp_rb_rptr_addr) \
     ((cp_rb_rptr_addr & CP_RB_RPTR_ADDR_RB_RPTR_SWAP_MASK) >> CP_RB_RPTR_ADDR_RB_RPTR_SWAP_SHIFT)
#define CP_RB_RPTR_ADDR_GET_RB_RPTR_ADDR(cp_rb_rptr_addr) \
     ((cp_rb_rptr_addr & CP_RB_RPTR_ADDR_RB_RPTR_ADDR_MASK) >> CP_RB_RPTR_ADDR_RB_RPTR_ADDR_SHIFT)

#define CP_RB_RPTR_ADDR_SET_RB_RPTR_SWAP(cp_rb_rptr_addr_reg, rb_rptr_swap) \
     cp_rb_rptr_addr_reg = (cp_rb_rptr_addr_reg & ~CP_RB_RPTR_ADDR_RB_RPTR_SWAP_MASK) | (rb_rptr_swap << CP_RB_RPTR_ADDR_RB_RPTR_SWAP_SHIFT)
#define CP_RB_RPTR_ADDR_SET_RB_RPTR_ADDR(cp_rb_rptr_addr_reg, rb_rptr_addr) \
     cp_rb_rptr_addr_reg = (cp_rb_rptr_addr_reg & ~CP_RB_RPTR_ADDR_RB_RPTR_ADDR_MASK) | (rb_rptr_addr << CP_RB_RPTR_ADDR_RB_RPTR_ADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_rb_rptr_addr_t {
          unsigned int rb_rptr_swap                   : CP_RB_RPTR_ADDR_RB_RPTR_SWAP_SIZE;
          unsigned int rb_rptr_addr                   : CP_RB_RPTR_ADDR_RB_RPTR_ADDR_SIZE;
     } cp_rb_rptr_addr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_rb_rptr_addr_t {
          unsigned int rb_rptr_addr                   : CP_RB_RPTR_ADDR_RB_RPTR_ADDR_SIZE;
          unsigned int rb_rptr_swap                   : CP_RB_RPTR_ADDR_RB_RPTR_SWAP_SIZE;
     } cp_rb_rptr_addr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_rb_rptr_addr_t f;
} cp_rb_rptr_addr_u;


/*
 * CP_RB_RPTR struct
 */

#define CP_RB_RPTR_RB_RPTR_SIZE        20

#define CP_RB_RPTR_RB_RPTR_SHIFT       0

#define CP_RB_RPTR_RB_RPTR_MASK        0x000fffff

#define CP_RB_RPTR_MASK \
     (CP_RB_RPTR_RB_RPTR_MASK)

#define CP_RB_RPTR(rb_rptr) \
     ((rb_rptr << CP_RB_RPTR_RB_RPTR_SHIFT))

#define CP_RB_RPTR_GET_RB_RPTR(cp_rb_rptr) \
     ((cp_rb_rptr & CP_RB_RPTR_RB_RPTR_MASK) >> CP_RB_RPTR_RB_RPTR_SHIFT)

#define CP_RB_RPTR_SET_RB_RPTR(cp_rb_rptr_reg, rb_rptr) \
     cp_rb_rptr_reg = (cp_rb_rptr_reg & ~CP_RB_RPTR_RB_RPTR_MASK) | (rb_rptr << CP_RB_RPTR_RB_RPTR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_rb_rptr_t {
          unsigned int rb_rptr                        : CP_RB_RPTR_RB_RPTR_SIZE;
          unsigned int                                : 12;
     } cp_rb_rptr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_rb_rptr_t {
          unsigned int                                : 12;
          unsigned int rb_rptr                        : CP_RB_RPTR_RB_RPTR_SIZE;
     } cp_rb_rptr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_rb_rptr_t f;
} cp_rb_rptr_u;


/*
 * CP_RB_RPTR_WR struct
 */

#define CP_RB_RPTR_WR_RB_RPTR_WR_SIZE  20

#define CP_RB_RPTR_WR_RB_RPTR_WR_SHIFT 0

#define CP_RB_RPTR_WR_RB_RPTR_WR_MASK  0x000fffff

#define CP_RB_RPTR_WR_MASK \
     (CP_RB_RPTR_WR_RB_RPTR_WR_MASK)

#define CP_RB_RPTR_WR(rb_rptr_wr) \
     ((rb_rptr_wr << CP_RB_RPTR_WR_RB_RPTR_WR_SHIFT))

#define CP_RB_RPTR_WR_GET_RB_RPTR_WR(cp_rb_rptr_wr) \
     ((cp_rb_rptr_wr & CP_RB_RPTR_WR_RB_RPTR_WR_MASK) >> CP_RB_RPTR_WR_RB_RPTR_WR_SHIFT)

#define CP_RB_RPTR_WR_SET_RB_RPTR_WR(cp_rb_rptr_wr_reg, rb_rptr_wr) \
     cp_rb_rptr_wr_reg = (cp_rb_rptr_wr_reg & ~CP_RB_RPTR_WR_RB_RPTR_WR_MASK) | (rb_rptr_wr << CP_RB_RPTR_WR_RB_RPTR_WR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_rb_rptr_wr_t {
          unsigned int rb_rptr_wr                     : CP_RB_RPTR_WR_RB_RPTR_WR_SIZE;
          unsigned int                                : 12;
     } cp_rb_rptr_wr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_rb_rptr_wr_t {
          unsigned int                                : 12;
          unsigned int rb_rptr_wr                     : CP_RB_RPTR_WR_RB_RPTR_WR_SIZE;
     } cp_rb_rptr_wr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_rb_rptr_wr_t f;
} cp_rb_rptr_wr_u;


/*
 * CP_RB_WPTR struct
 */

#define CP_RB_WPTR_RB_WPTR_SIZE        20

#define CP_RB_WPTR_RB_WPTR_SHIFT       0

#define CP_RB_WPTR_RB_WPTR_MASK        0x000fffff

#define CP_RB_WPTR_MASK \
     (CP_RB_WPTR_RB_WPTR_MASK)

#define CP_RB_WPTR(rb_wptr) \
     ((rb_wptr << CP_RB_WPTR_RB_WPTR_SHIFT))

#define CP_RB_WPTR_GET_RB_WPTR(cp_rb_wptr) \
     ((cp_rb_wptr & CP_RB_WPTR_RB_WPTR_MASK) >> CP_RB_WPTR_RB_WPTR_SHIFT)

#define CP_RB_WPTR_SET_RB_WPTR(cp_rb_wptr_reg, rb_wptr) \
     cp_rb_wptr_reg = (cp_rb_wptr_reg & ~CP_RB_WPTR_RB_WPTR_MASK) | (rb_wptr << CP_RB_WPTR_RB_WPTR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_rb_wptr_t {
          unsigned int rb_wptr                        : CP_RB_WPTR_RB_WPTR_SIZE;
          unsigned int                                : 12;
     } cp_rb_wptr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_rb_wptr_t {
          unsigned int                                : 12;
          unsigned int rb_wptr                        : CP_RB_WPTR_RB_WPTR_SIZE;
     } cp_rb_wptr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_rb_wptr_t f;
} cp_rb_wptr_u;


/*
 * CP_RB_WPTR_DELAY struct
 */

#define CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_SIZE 28
#define CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_SIZE 4

#define CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_SHIFT 0
#define CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_SHIFT 28

#define CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_MASK 0x0fffffff
#define CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_MASK 0xf0000000

#define CP_RB_WPTR_DELAY_MASK \
     (CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_MASK | \
      CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_MASK)

#define CP_RB_WPTR_DELAY(pre_write_timer, pre_write_limit) \
     ((pre_write_timer << CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_SHIFT) | \
      (pre_write_limit << CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_SHIFT))

#define CP_RB_WPTR_DELAY_GET_PRE_WRITE_TIMER(cp_rb_wptr_delay) \
     ((cp_rb_wptr_delay & CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_MASK) >> CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_SHIFT)
#define CP_RB_WPTR_DELAY_GET_PRE_WRITE_LIMIT(cp_rb_wptr_delay) \
     ((cp_rb_wptr_delay & CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_MASK) >> CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_SHIFT)

#define CP_RB_WPTR_DELAY_SET_PRE_WRITE_TIMER(cp_rb_wptr_delay_reg, pre_write_timer) \
     cp_rb_wptr_delay_reg = (cp_rb_wptr_delay_reg & ~CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_MASK) | (pre_write_timer << CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_SHIFT)
#define CP_RB_WPTR_DELAY_SET_PRE_WRITE_LIMIT(cp_rb_wptr_delay_reg, pre_write_limit) \
     cp_rb_wptr_delay_reg = (cp_rb_wptr_delay_reg & ~CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_MASK) | (pre_write_limit << CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_rb_wptr_delay_t {
          unsigned int pre_write_timer                : CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_SIZE;
          unsigned int pre_write_limit                : CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_SIZE;
     } cp_rb_wptr_delay_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_rb_wptr_delay_t {
          unsigned int pre_write_limit                : CP_RB_WPTR_DELAY_PRE_WRITE_LIMIT_SIZE;
          unsigned int pre_write_timer                : CP_RB_WPTR_DELAY_PRE_WRITE_TIMER_SIZE;
     } cp_rb_wptr_delay_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_rb_wptr_delay_t f;
} cp_rb_wptr_delay_u;


/*
 * CP_RB_WPTR_BASE struct
 */

#define CP_RB_WPTR_BASE_RB_WPTR_SWAP_SIZE 2
#define CP_RB_WPTR_BASE_RB_WPTR_BASE_SIZE 30

#define CP_RB_WPTR_BASE_RB_WPTR_SWAP_SHIFT 0
#define CP_RB_WPTR_BASE_RB_WPTR_BASE_SHIFT 2

#define CP_RB_WPTR_BASE_RB_WPTR_SWAP_MASK 0x00000003
#define CP_RB_WPTR_BASE_RB_WPTR_BASE_MASK 0xfffffffc

#define CP_RB_WPTR_BASE_MASK \
     (CP_RB_WPTR_BASE_RB_WPTR_SWAP_MASK | \
      CP_RB_WPTR_BASE_RB_WPTR_BASE_MASK)

#define CP_RB_WPTR_BASE(rb_wptr_swap, rb_wptr_base) \
     ((rb_wptr_swap << CP_RB_WPTR_BASE_RB_WPTR_SWAP_SHIFT) | \
      (rb_wptr_base << CP_RB_WPTR_BASE_RB_WPTR_BASE_SHIFT))

#define CP_RB_WPTR_BASE_GET_RB_WPTR_SWAP(cp_rb_wptr_base) \
     ((cp_rb_wptr_base & CP_RB_WPTR_BASE_RB_WPTR_SWAP_MASK) >> CP_RB_WPTR_BASE_RB_WPTR_SWAP_SHIFT)
#define CP_RB_WPTR_BASE_GET_RB_WPTR_BASE(cp_rb_wptr_base) \
     ((cp_rb_wptr_base & CP_RB_WPTR_BASE_RB_WPTR_BASE_MASK) >> CP_RB_WPTR_BASE_RB_WPTR_BASE_SHIFT)

#define CP_RB_WPTR_BASE_SET_RB_WPTR_SWAP(cp_rb_wptr_base_reg, rb_wptr_swap) \
     cp_rb_wptr_base_reg = (cp_rb_wptr_base_reg & ~CP_RB_WPTR_BASE_RB_WPTR_SWAP_MASK) | (rb_wptr_swap << CP_RB_WPTR_BASE_RB_WPTR_SWAP_SHIFT)
#define CP_RB_WPTR_BASE_SET_RB_WPTR_BASE(cp_rb_wptr_base_reg, rb_wptr_base) \
     cp_rb_wptr_base_reg = (cp_rb_wptr_base_reg & ~CP_RB_WPTR_BASE_RB_WPTR_BASE_MASK) | (rb_wptr_base << CP_RB_WPTR_BASE_RB_WPTR_BASE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_rb_wptr_base_t {
          unsigned int rb_wptr_swap                   : CP_RB_WPTR_BASE_RB_WPTR_SWAP_SIZE;
          unsigned int rb_wptr_base                   : CP_RB_WPTR_BASE_RB_WPTR_BASE_SIZE;
     } cp_rb_wptr_base_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_rb_wptr_base_t {
          unsigned int rb_wptr_base                   : CP_RB_WPTR_BASE_RB_WPTR_BASE_SIZE;
          unsigned int rb_wptr_swap                   : CP_RB_WPTR_BASE_RB_WPTR_SWAP_SIZE;
     } cp_rb_wptr_base_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_rb_wptr_base_t f;
} cp_rb_wptr_base_u;


/*
 * CP_IB1_BASE struct
 */

#define CP_IB1_BASE_IB1_BASE_SIZE      30

#define CP_IB1_BASE_IB1_BASE_SHIFT     2

#define CP_IB1_BASE_IB1_BASE_MASK      0xfffffffc

#define CP_IB1_BASE_MASK \
     (CP_IB1_BASE_IB1_BASE_MASK)

#define CP_IB1_BASE(ib1_base) \
     ((ib1_base << CP_IB1_BASE_IB1_BASE_SHIFT))

#define CP_IB1_BASE_GET_IB1_BASE(cp_ib1_base) \
     ((cp_ib1_base & CP_IB1_BASE_IB1_BASE_MASK) >> CP_IB1_BASE_IB1_BASE_SHIFT)

#define CP_IB1_BASE_SET_IB1_BASE(cp_ib1_base_reg, ib1_base) \
     cp_ib1_base_reg = (cp_ib1_base_reg & ~CP_IB1_BASE_IB1_BASE_MASK) | (ib1_base << CP_IB1_BASE_IB1_BASE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_ib1_base_t {
          unsigned int                                : 2;
          unsigned int ib1_base                       : CP_IB1_BASE_IB1_BASE_SIZE;
     } cp_ib1_base_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_ib1_base_t {
          unsigned int ib1_base                       : CP_IB1_BASE_IB1_BASE_SIZE;
          unsigned int                                : 2;
     } cp_ib1_base_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_ib1_base_t f;
} cp_ib1_base_u;


/*
 * CP_IB1_BUFSZ struct
 */

#define CP_IB1_BUFSZ_IB1_BUFSZ_SIZE    20

#define CP_IB1_BUFSZ_IB1_BUFSZ_SHIFT   0

#define CP_IB1_BUFSZ_IB1_BUFSZ_MASK    0x000fffff

#define CP_IB1_BUFSZ_MASK \
     (CP_IB1_BUFSZ_IB1_BUFSZ_MASK)

#define CP_IB1_BUFSZ(ib1_bufsz) \
     ((ib1_bufsz << CP_IB1_BUFSZ_IB1_BUFSZ_SHIFT))

#define CP_IB1_BUFSZ_GET_IB1_BUFSZ(cp_ib1_bufsz) \
     ((cp_ib1_bufsz & CP_IB1_BUFSZ_IB1_BUFSZ_MASK) >> CP_IB1_BUFSZ_IB1_BUFSZ_SHIFT)

#define CP_IB1_BUFSZ_SET_IB1_BUFSZ(cp_ib1_bufsz_reg, ib1_bufsz) \
     cp_ib1_bufsz_reg = (cp_ib1_bufsz_reg & ~CP_IB1_BUFSZ_IB1_BUFSZ_MASK) | (ib1_bufsz << CP_IB1_BUFSZ_IB1_BUFSZ_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_ib1_bufsz_t {
          unsigned int ib1_bufsz                      : CP_IB1_BUFSZ_IB1_BUFSZ_SIZE;
          unsigned int                                : 12;
     } cp_ib1_bufsz_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_ib1_bufsz_t {
          unsigned int                                : 12;
          unsigned int ib1_bufsz                      : CP_IB1_BUFSZ_IB1_BUFSZ_SIZE;
     } cp_ib1_bufsz_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_ib1_bufsz_t f;
} cp_ib1_bufsz_u;


/*
 * CP_IB2_BASE struct
 */

#define CP_IB2_BASE_IB2_BASE_SIZE      30

#define CP_IB2_BASE_IB2_BASE_SHIFT     2

#define CP_IB2_BASE_IB2_BASE_MASK      0xfffffffc

#define CP_IB2_BASE_MASK \
     (CP_IB2_BASE_IB2_BASE_MASK)

#define CP_IB2_BASE(ib2_base) \
     ((ib2_base << CP_IB2_BASE_IB2_BASE_SHIFT))

#define CP_IB2_BASE_GET_IB2_BASE(cp_ib2_base) \
     ((cp_ib2_base & CP_IB2_BASE_IB2_BASE_MASK) >> CP_IB2_BASE_IB2_BASE_SHIFT)

#define CP_IB2_BASE_SET_IB2_BASE(cp_ib2_base_reg, ib2_base) \
     cp_ib2_base_reg = (cp_ib2_base_reg & ~CP_IB2_BASE_IB2_BASE_MASK) | (ib2_base << CP_IB2_BASE_IB2_BASE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_ib2_base_t {
          unsigned int                                : 2;
          unsigned int ib2_base                       : CP_IB2_BASE_IB2_BASE_SIZE;
     } cp_ib2_base_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_ib2_base_t {
          unsigned int ib2_base                       : CP_IB2_BASE_IB2_BASE_SIZE;
          unsigned int                                : 2;
     } cp_ib2_base_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_ib2_base_t f;
} cp_ib2_base_u;


/*
 * CP_IB2_BUFSZ struct
 */

#define CP_IB2_BUFSZ_IB2_BUFSZ_SIZE    20

#define CP_IB2_BUFSZ_IB2_BUFSZ_SHIFT   0

#define CP_IB2_BUFSZ_IB2_BUFSZ_MASK    0x000fffff

#define CP_IB2_BUFSZ_MASK \
     (CP_IB2_BUFSZ_IB2_BUFSZ_MASK)

#define CP_IB2_BUFSZ(ib2_bufsz) \
     ((ib2_bufsz << CP_IB2_BUFSZ_IB2_BUFSZ_SHIFT))

#define CP_IB2_BUFSZ_GET_IB2_BUFSZ(cp_ib2_bufsz) \
     ((cp_ib2_bufsz & CP_IB2_BUFSZ_IB2_BUFSZ_MASK) >> CP_IB2_BUFSZ_IB2_BUFSZ_SHIFT)

#define CP_IB2_BUFSZ_SET_IB2_BUFSZ(cp_ib2_bufsz_reg, ib2_bufsz) \
     cp_ib2_bufsz_reg = (cp_ib2_bufsz_reg & ~CP_IB2_BUFSZ_IB2_BUFSZ_MASK) | (ib2_bufsz << CP_IB2_BUFSZ_IB2_BUFSZ_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_ib2_bufsz_t {
          unsigned int ib2_bufsz                      : CP_IB2_BUFSZ_IB2_BUFSZ_SIZE;
          unsigned int                                : 12;
     } cp_ib2_bufsz_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_ib2_bufsz_t {
          unsigned int                                : 12;
          unsigned int ib2_bufsz                      : CP_IB2_BUFSZ_IB2_BUFSZ_SIZE;
     } cp_ib2_bufsz_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_ib2_bufsz_t f;
} cp_ib2_bufsz_u;


/*
 * CP_ST_BASE struct
 */

#define CP_ST_BASE_ST_BASE_SIZE        30

#define CP_ST_BASE_ST_BASE_SHIFT       2

#define CP_ST_BASE_ST_BASE_MASK        0xfffffffc

#define CP_ST_BASE_MASK \
     (CP_ST_BASE_ST_BASE_MASK)

#define CP_ST_BASE(st_base) \
     ((st_base << CP_ST_BASE_ST_BASE_SHIFT))

#define CP_ST_BASE_GET_ST_BASE(cp_st_base) \
     ((cp_st_base & CP_ST_BASE_ST_BASE_MASK) >> CP_ST_BASE_ST_BASE_SHIFT)

#define CP_ST_BASE_SET_ST_BASE(cp_st_base_reg, st_base) \
     cp_st_base_reg = (cp_st_base_reg & ~CP_ST_BASE_ST_BASE_MASK) | (st_base << CP_ST_BASE_ST_BASE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_st_base_t {
          unsigned int                                : 2;
          unsigned int st_base                        : CP_ST_BASE_ST_BASE_SIZE;
     } cp_st_base_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_st_base_t {
          unsigned int st_base                        : CP_ST_BASE_ST_BASE_SIZE;
          unsigned int                                : 2;
     } cp_st_base_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_st_base_t f;
} cp_st_base_u;


/*
 * CP_ST_BUFSZ struct
 */

#define CP_ST_BUFSZ_ST_BUFSZ_SIZE      20

#define CP_ST_BUFSZ_ST_BUFSZ_SHIFT     0

#define CP_ST_BUFSZ_ST_BUFSZ_MASK      0x000fffff

#define CP_ST_BUFSZ_MASK \
     (CP_ST_BUFSZ_ST_BUFSZ_MASK)

#define CP_ST_BUFSZ(st_bufsz) \
     ((st_bufsz << CP_ST_BUFSZ_ST_BUFSZ_SHIFT))

#define CP_ST_BUFSZ_GET_ST_BUFSZ(cp_st_bufsz) \
     ((cp_st_bufsz & CP_ST_BUFSZ_ST_BUFSZ_MASK) >> CP_ST_BUFSZ_ST_BUFSZ_SHIFT)

#define CP_ST_BUFSZ_SET_ST_BUFSZ(cp_st_bufsz_reg, st_bufsz) \
     cp_st_bufsz_reg = (cp_st_bufsz_reg & ~CP_ST_BUFSZ_ST_BUFSZ_MASK) | (st_bufsz << CP_ST_BUFSZ_ST_BUFSZ_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_st_bufsz_t {
          unsigned int st_bufsz                       : CP_ST_BUFSZ_ST_BUFSZ_SIZE;
          unsigned int                                : 12;
     } cp_st_bufsz_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_st_bufsz_t {
          unsigned int                                : 12;
          unsigned int st_bufsz                       : CP_ST_BUFSZ_ST_BUFSZ_SIZE;
     } cp_st_bufsz_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_st_bufsz_t f;
} cp_st_bufsz_u;


/*
 * CP_QUEUE_THRESHOLDS struct
 */

#define CP_QUEUE_THRESHOLDS_CSQ_IB1_START_SIZE 4
#define CP_QUEUE_THRESHOLDS_CSQ_IB2_START_SIZE 4
#define CP_QUEUE_THRESHOLDS_CSQ_ST_START_SIZE 4

#define CP_QUEUE_THRESHOLDS_CSQ_IB1_START_SHIFT 0
#define CP_QUEUE_THRESHOLDS_CSQ_IB2_START_SHIFT 8
#define CP_QUEUE_THRESHOLDS_CSQ_ST_START_SHIFT 16

#define CP_QUEUE_THRESHOLDS_CSQ_IB1_START_MASK 0x0000000f
#define CP_QUEUE_THRESHOLDS_CSQ_IB2_START_MASK 0x00000f00
#define CP_QUEUE_THRESHOLDS_CSQ_ST_START_MASK 0x000f0000

#define CP_QUEUE_THRESHOLDS_MASK \
     (CP_QUEUE_THRESHOLDS_CSQ_IB1_START_MASK | \
      CP_QUEUE_THRESHOLDS_CSQ_IB2_START_MASK | \
      CP_QUEUE_THRESHOLDS_CSQ_ST_START_MASK)

#define CP_QUEUE_THRESHOLDS(csq_ib1_start, csq_ib2_start, csq_st_start) \
     ((csq_ib1_start << CP_QUEUE_THRESHOLDS_CSQ_IB1_START_SHIFT) | \
      (csq_ib2_start << CP_QUEUE_THRESHOLDS_CSQ_IB2_START_SHIFT) | \
      (csq_st_start << CP_QUEUE_THRESHOLDS_CSQ_ST_START_SHIFT))

#define CP_QUEUE_THRESHOLDS_GET_CSQ_IB1_START(cp_queue_thresholds) \
     ((cp_queue_thresholds & CP_QUEUE_THRESHOLDS_CSQ_IB1_START_MASK) >> CP_QUEUE_THRESHOLDS_CSQ_IB1_START_SHIFT)
#define CP_QUEUE_THRESHOLDS_GET_CSQ_IB2_START(cp_queue_thresholds) \
     ((cp_queue_thresholds & CP_QUEUE_THRESHOLDS_CSQ_IB2_START_MASK) >> CP_QUEUE_THRESHOLDS_CSQ_IB2_START_SHIFT)
#define CP_QUEUE_THRESHOLDS_GET_CSQ_ST_START(cp_queue_thresholds) \
     ((cp_queue_thresholds & CP_QUEUE_THRESHOLDS_CSQ_ST_START_MASK) >> CP_QUEUE_THRESHOLDS_CSQ_ST_START_SHIFT)

#define CP_QUEUE_THRESHOLDS_SET_CSQ_IB1_START(cp_queue_thresholds_reg, csq_ib1_start) \
     cp_queue_thresholds_reg = (cp_queue_thresholds_reg & ~CP_QUEUE_THRESHOLDS_CSQ_IB1_START_MASK) | (csq_ib1_start << CP_QUEUE_THRESHOLDS_CSQ_IB1_START_SHIFT)
#define CP_QUEUE_THRESHOLDS_SET_CSQ_IB2_START(cp_queue_thresholds_reg, csq_ib2_start) \
     cp_queue_thresholds_reg = (cp_queue_thresholds_reg & ~CP_QUEUE_THRESHOLDS_CSQ_IB2_START_MASK) | (csq_ib2_start << CP_QUEUE_THRESHOLDS_CSQ_IB2_START_SHIFT)
#define CP_QUEUE_THRESHOLDS_SET_CSQ_ST_START(cp_queue_thresholds_reg, csq_st_start) \
     cp_queue_thresholds_reg = (cp_queue_thresholds_reg & ~CP_QUEUE_THRESHOLDS_CSQ_ST_START_MASK) | (csq_st_start << CP_QUEUE_THRESHOLDS_CSQ_ST_START_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_queue_thresholds_t {
          unsigned int csq_ib1_start                  : CP_QUEUE_THRESHOLDS_CSQ_IB1_START_SIZE;
          unsigned int                                : 4;
          unsigned int csq_ib2_start                  : CP_QUEUE_THRESHOLDS_CSQ_IB2_START_SIZE;
          unsigned int                                : 4;
          unsigned int csq_st_start                   : CP_QUEUE_THRESHOLDS_CSQ_ST_START_SIZE;
          unsigned int                                : 12;
     } cp_queue_thresholds_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_queue_thresholds_t {
          unsigned int                                : 12;
          unsigned int csq_st_start                   : CP_QUEUE_THRESHOLDS_CSQ_ST_START_SIZE;
          unsigned int                                : 4;
          unsigned int csq_ib2_start                  : CP_QUEUE_THRESHOLDS_CSQ_IB2_START_SIZE;
          unsigned int                                : 4;
          unsigned int csq_ib1_start                  : CP_QUEUE_THRESHOLDS_CSQ_IB1_START_SIZE;
     } cp_queue_thresholds_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_queue_thresholds_t f;
} cp_queue_thresholds_u;


/*
 * CP_MEQ_THRESHOLDS struct
 */

#define CP_MEQ_THRESHOLDS_MEQ_END_SIZE 5
#define CP_MEQ_THRESHOLDS_ROQ_END_SIZE 5

#define CP_MEQ_THRESHOLDS_MEQ_END_SHIFT 16
#define CP_MEQ_THRESHOLDS_ROQ_END_SHIFT 24

#define CP_MEQ_THRESHOLDS_MEQ_END_MASK 0x001f0000
#define CP_MEQ_THRESHOLDS_ROQ_END_MASK 0x1f000000

#define CP_MEQ_THRESHOLDS_MASK \
     (CP_MEQ_THRESHOLDS_MEQ_END_MASK | \
      CP_MEQ_THRESHOLDS_ROQ_END_MASK)

#define CP_MEQ_THRESHOLDS(meq_end, roq_end) \
     ((meq_end << CP_MEQ_THRESHOLDS_MEQ_END_SHIFT) | \
      (roq_end << CP_MEQ_THRESHOLDS_ROQ_END_SHIFT))

#define CP_MEQ_THRESHOLDS_GET_MEQ_END(cp_meq_thresholds) \
     ((cp_meq_thresholds & CP_MEQ_THRESHOLDS_MEQ_END_MASK) >> CP_MEQ_THRESHOLDS_MEQ_END_SHIFT)
#define CP_MEQ_THRESHOLDS_GET_ROQ_END(cp_meq_thresholds) \
     ((cp_meq_thresholds & CP_MEQ_THRESHOLDS_ROQ_END_MASK) >> CP_MEQ_THRESHOLDS_ROQ_END_SHIFT)

#define CP_MEQ_THRESHOLDS_SET_MEQ_END(cp_meq_thresholds_reg, meq_end) \
     cp_meq_thresholds_reg = (cp_meq_thresholds_reg & ~CP_MEQ_THRESHOLDS_MEQ_END_MASK) | (meq_end << CP_MEQ_THRESHOLDS_MEQ_END_SHIFT)
#define CP_MEQ_THRESHOLDS_SET_ROQ_END(cp_meq_thresholds_reg, roq_end) \
     cp_meq_thresholds_reg = (cp_meq_thresholds_reg & ~CP_MEQ_THRESHOLDS_ROQ_END_MASK) | (roq_end << CP_MEQ_THRESHOLDS_ROQ_END_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_meq_thresholds_t {
          unsigned int                                : 16;
          unsigned int meq_end                        : CP_MEQ_THRESHOLDS_MEQ_END_SIZE;
          unsigned int                                : 3;
          unsigned int roq_end                        : CP_MEQ_THRESHOLDS_ROQ_END_SIZE;
          unsigned int                                : 3;
     } cp_meq_thresholds_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_meq_thresholds_t {
          unsigned int                                : 3;
          unsigned int roq_end                        : CP_MEQ_THRESHOLDS_ROQ_END_SIZE;
          unsigned int                                : 3;
          unsigned int meq_end                        : CP_MEQ_THRESHOLDS_MEQ_END_SIZE;
          unsigned int                                : 16;
     } cp_meq_thresholds_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_meq_thresholds_t f;
} cp_meq_thresholds_u;


/*
 * CP_CSQ_AVAIL struct
 */

#define CP_CSQ_AVAIL_CSQ_CNT_RING_SIZE 7
#define CP_CSQ_AVAIL_CSQ_CNT_IB1_SIZE  7
#define CP_CSQ_AVAIL_CSQ_CNT_IB2_SIZE  7

#define CP_CSQ_AVAIL_CSQ_CNT_RING_SHIFT 0
#define CP_CSQ_AVAIL_CSQ_CNT_IB1_SHIFT 8
#define CP_CSQ_AVAIL_CSQ_CNT_IB2_SHIFT 16

#define CP_CSQ_AVAIL_CSQ_CNT_RING_MASK 0x0000007f
#define CP_CSQ_AVAIL_CSQ_CNT_IB1_MASK  0x00007f00
#define CP_CSQ_AVAIL_CSQ_CNT_IB2_MASK  0x007f0000

#define CP_CSQ_AVAIL_MASK \
     (CP_CSQ_AVAIL_CSQ_CNT_RING_MASK | \
      CP_CSQ_AVAIL_CSQ_CNT_IB1_MASK | \
      CP_CSQ_AVAIL_CSQ_CNT_IB2_MASK)

#define CP_CSQ_AVAIL(csq_cnt_ring, csq_cnt_ib1, csq_cnt_ib2) \
     ((csq_cnt_ring << CP_CSQ_AVAIL_CSQ_CNT_RING_SHIFT) | \
      (csq_cnt_ib1 << CP_CSQ_AVAIL_CSQ_CNT_IB1_SHIFT) | \
      (csq_cnt_ib2 << CP_CSQ_AVAIL_CSQ_CNT_IB2_SHIFT))

#define CP_CSQ_AVAIL_GET_CSQ_CNT_RING(cp_csq_avail) \
     ((cp_csq_avail & CP_CSQ_AVAIL_CSQ_CNT_RING_MASK) >> CP_CSQ_AVAIL_CSQ_CNT_RING_SHIFT)
#define CP_CSQ_AVAIL_GET_CSQ_CNT_IB1(cp_csq_avail) \
     ((cp_csq_avail & CP_CSQ_AVAIL_CSQ_CNT_IB1_MASK) >> CP_CSQ_AVAIL_CSQ_CNT_IB1_SHIFT)
#define CP_CSQ_AVAIL_GET_CSQ_CNT_IB2(cp_csq_avail) \
     ((cp_csq_avail & CP_CSQ_AVAIL_CSQ_CNT_IB2_MASK) >> CP_CSQ_AVAIL_CSQ_CNT_IB2_SHIFT)

#define CP_CSQ_AVAIL_SET_CSQ_CNT_RING(cp_csq_avail_reg, csq_cnt_ring) \
     cp_csq_avail_reg = (cp_csq_avail_reg & ~CP_CSQ_AVAIL_CSQ_CNT_RING_MASK) | (csq_cnt_ring << CP_CSQ_AVAIL_CSQ_CNT_RING_SHIFT)
#define CP_CSQ_AVAIL_SET_CSQ_CNT_IB1(cp_csq_avail_reg, csq_cnt_ib1) \
     cp_csq_avail_reg = (cp_csq_avail_reg & ~CP_CSQ_AVAIL_CSQ_CNT_IB1_MASK) | (csq_cnt_ib1 << CP_CSQ_AVAIL_CSQ_CNT_IB1_SHIFT)
#define CP_CSQ_AVAIL_SET_CSQ_CNT_IB2(cp_csq_avail_reg, csq_cnt_ib2) \
     cp_csq_avail_reg = (cp_csq_avail_reg & ~CP_CSQ_AVAIL_CSQ_CNT_IB2_MASK) | (csq_cnt_ib2 << CP_CSQ_AVAIL_CSQ_CNT_IB2_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_csq_avail_t {
          unsigned int csq_cnt_ring                   : CP_CSQ_AVAIL_CSQ_CNT_RING_SIZE;
          unsigned int                                : 1;
          unsigned int csq_cnt_ib1                    : CP_CSQ_AVAIL_CSQ_CNT_IB1_SIZE;
          unsigned int                                : 1;
          unsigned int csq_cnt_ib2                    : CP_CSQ_AVAIL_CSQ_CNT_IB2_SIZE;
          unsigned int                                : 9;
     } cp_csq_avail_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_csq_avail_t {
          unsigned int                                : 9;
          unsigned int csq_cnt_ib2                    : CP_CSQ_AVAIL_CSQ_CNT_IB2_SIZE;
          unsigned int                                : 1;
          unsigned int csq_cnt_ib1                    : CP_CSQ_AVAIL_CSQ_CNT_IB1_SIZE;
          unsigned int                                : 1;
          unsigned int csq_cnt_ring                   : CP_CSQ_AVAIL_CSQ_CNT_RING_SIZE;
     } cp_csq_avail_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_csq_avail_t f;
} cp_csq_avail_u;


/*
 * CP_STQ_AVAIL struct
 */

#define CP_STQ_AVAIL_STQ_CNT_ST_SIZE   7

#define CP_STQ_AVAIL_STQ_CNT_ST_SHIFT  0

#define CP_STQ_AVAIL_STQ_CNT_ST_MASK   0x0000007f

#define CP_STQ_AVAIL_MASK \
     (CP_STQ_AVAIL_STQ_CNT_ST_MASK)

#define CP_STQ_AVAIL(stq_cnt_st) \
     ((stq_cnt_st << CP_STQ_AVAIL_STQ_CNT_ST_SHIFT))

#define CP_STQ_AVAIL_GET_STQ_CNT_ST(cp_stq_avail) \
     ((cp_stq_avail & CP_STQ_AVAIL_STQ_CNT_ST_MASK) >> CP_STQ_AVAIL_STQ_CNT_ST_SHIFT)

#define CP_STQ_AVAIL_SET_STQ_CNT_ST(cp_stq_avail_reg, stq_cnt_st) \
     cp_stq_avail_reg = (cp_stq_avail_reg & ~CP_STQ_AVAIL_STQ_CNT_ST_MASK) | (stq_cnt_st << CP_STQ_AVAIL_STQ_CNT_ST_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_stq_avail_t {
          unsigned int stq_cnt_st                     : CP_STQ_AVAIL_STQ_CNT_ST_SIZE;
          unsigned int                                : 25;
     } cp_stq_avail_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_stq_avail_t {
          unsigned int                                : 25;
          unsigned int stq_cnt_st                     : CP_STQ_AVAIL_STQ_CNT_ST_SIZE;
     } cp_stq_avail_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_stq_avail_t f;
} cp_stq_avail_u;


/*
 * CP_MEQ_AVAIL struct
 */

#define CP_MEQ_AVAIL_MEQ_CNT_SIZE      5

#define CP_MEQ_AVAIL_MEQ_CNT_SHIFT     0

#define CP_MEQ_AVAIL_MEQ_CNT_MASK      0x0000001f

#define CP_MEQ_AVAIL_MASK \
     (CP_MEQ_AVAIL_MEQ_CNT_MASK)

#define CP_MEQ_AVAIL(meq_cnt) \
     ((meq_cnt << CP_MEQ_AVAIL_MEQ_CNT_SHIFT))

#define CP_MEQ_AVAIL_GET_MEQ_CNT(cp_meq_avail) \
     ((cp_meq_avail & CP_MEQ_AVAIL_MEQ_CNT_MASK) >> CP_MEQ_AVAIL_MEQ_CNT_SHIFT)

#define CP_MEQ_AVAIL_SET_MEQ_CNT(cp_meq_avail_reg, meq_cnt) \
     cp_meq_avail_reg = (cp_meq_avail_reg & ~CP_MEQ_AVAIL_MEQ_CNT_MASK) | (meq_cnt << CP_MEQ_AVAIL_MEQ_CNT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_meq_avail_t {
          unsigned int meq_cnt                        : CP_MEQ_AVAIL_MEQ_CNT_SIZE;
          unsigned int                                : 27;
     } cp_meq_avail_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_meq_avail_t {
          unsigned int                                : 27;
          unsigned int meq_cnt                        : CP_MEQ_AVAIL_MEQ_CNT_SIZE;
     } cp_meq_avail_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_meq_avail_t f;
} cp_meq_avail_u;


/*
 * CP_CSQ_RB_STAT struct
 */

#define CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_SIZE 7
#define CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_SIZE 7

#define CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_SHIFT 0
#define CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_SHIFT 16

#define CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_MASK 0x0000007f
#define CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_MASK 0x007f0000

#define CP_CSQ_RB_STAT_MASK \
     (CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_MASK | \
      CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_MASK)

#define CP_CSQ_RB_STAT(csq_rptr_primary, csq_wptr_primary) \
     ((csq_rptr_primary << CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_SHIFT) | \
      (csq_wptr_primary << CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_SHIFT))

#define CP_CSQ_RB_STAT_GET_CSQ_RPTR_PRIMARY(cp_csq_rb_stat) \
     ((cp_csq_rb_stat & CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_MASK) >> CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_SHIFT)
#define CP_CSQ_RB_STAT_GET_CSQ_WPTR_PRIMARY(cp_csq_rb_stat) \
     ((cp_csq_rb_stat & CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_MASK) >> CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_SHIFT)

#define CP_CSQ_RB_STAT_SET_CSQ_RPTR_PRIMARY(cp_csq_rb_stat_reg, csq_rptr_primary) \
     cp_csq_rb_stat_reg = (cp_csq_rb_stat_reg & ~CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_MASK) | (csq_rptr_primary << CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_SHIFT)
#define CP_CSQ_RB_STAT_SET_CSQ_WPTR_PRIMARY(cp_csq_rb_stat_reg, csq_wptr_primary) \
     cp_csq_rb_stat_reg = (cp_csq_rb_stat_reg & ~CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_MASK) | (csq_wptr_primary << CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_csq_rb_stat_t {
          unsigned int csq_rptr_primary               : CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_SIZE;
          unsigned int                                : 9;
          unsigned int csq_wptr_primary               : CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_SIZE;
          unsigned int                                : 9;
     } cp_csq_rb_stat_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_csq_rb_stat_t {
          unsigned int                                : 9;
          unsigned int csq_wptr_primary               : CP_CSQ_RB_STAT_CSQ_WPTR_PRIMARY_SIZE;
          unsigned int                                : 9;
          unsigned int csq_rptr_primary               : CP_CSQ_RB_STAT_CSQ_RPTR_PRIMARY_SIZE;
     } cp_csq_rb_stat_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_csq_rb_stat_t f;
} cp_csq_rb_stat_u;


/*
 * CP_CSQ_IB1_STAT struct
 */

#define CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_SIZE 7
#define CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_SIZE 7

#define CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_SHIFT 0
#define CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_SHIFT 16

#define CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_MASK 0x0000007f
#define CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_MASK 0x007f0000

#define CP_CSQ_IB1_STAT_MASK \
     (CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_MASK | \
      CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_MASK)

#define CP_CSQ_IB1_STAT(csq_rptr_indirect1, csq_wptr_indirect1) \
     ((csq_rptr_indirect1 << CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_SHIFT) | \
      (csq_wptr_indirect1 << CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_SHIFT))

#define CP_CSQ_IB1_STAT_GET_CSQ_RPTR_INDIRECT1(cp_csq_ib1_stat) \
     ((cp_csq_ib1_stat & CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_MASK) >> CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_SHIFT)
#define CP_CSQ_IB1_STAT_GET_CSQ_WPTR_INDIRECT1(cp_csq_ib1_stat) \
     ((cp_csq_ib1_stat & CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_MASK) >> CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_SHIFT)

#define CP_CSQ_IB1_STAT_SET_CSQ_RPTR_INDIRECT1(cp_csq_ib1_stat_reg, csq_rptr_indirect1) \
     cp_csq_ib1_stat_reg = (cp_csq_ib1_stat_reg & ~CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_MASK) | (csq_rptr_indirect1 << CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_SHIFT)
#define CP_CSQ_IB1_STAT_SET_CSQ_WPTR_INDIRECT1(cp_csq_ib1_stat_reg, csq_wptr_indirect1) \
     cp_csq_ib1_stat_reg = (cp_csq_ib1_stat_reg & ~CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_MASK) | (csq_wptr_indirect1 << CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_csq_ib1_stat_t {
          unsigned int csq_rptr_indirect1             : CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_SIZE;
          unsigned int                                : 9;
          unsigned int csq_wptr_indirect1             : CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_SIZE;
          unsigned int                                : 9;
     } cp_csq_ib1_stat_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_csq_ib1_stat_t {
          unsigned int                                : 9;
          unsigned int csq_wptr_indirect1             : CP_CSQ_IB1_STAT_CSQ_WPTR_INDIRECT1_SIZE;
          unsigned int                                : 9;
          unsigned int csq_rptr_indirect1             : CP_CSQ_IB1_STAT_CSQ_RPTR_INDIRECT1_SIZE;
     } cp_csq_ib1_stat_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_csq_ib1_stat_t f;
} cp_csq_ib1_stat_u;


/*
 * CP_CSQ_IB2_STAT struct
 */

#define CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_SIZE 7
#define CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_SIZE 7

#define CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_SHIFT 0
#define CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_SHIFT 16

#define CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_MASK 0x0000007f
#define CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_MASK 0x007f0000

#define CP_CSQ_IB2_STAT_MASK \
     (CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_MASK | \
      CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_MASK)

#define CP_CSQ_IB2_STAT(csq_rptr_indirect2, csq_wptr_indirect2) \
     ((csq_rptr_indirect2 << CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_SHIFT) | \
      (csq_wptr_indirect2 << CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_SHIFT))

#define CP_CSQ_IB2_STAT_GET_CSQ_RPTR_INDIRECT2(cp_csq_ib2_stat) \
     ((cp_csq_ib2_stat & CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_MASK) >> CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_SHIFT)
#define CP_CSQ_IB2_STAT_GET_CSQ_WPTR_INDIRECT2(cp_csq_ib2_stat) \
     ((cp_csq_ib2_stat & CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_MASK) >> CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_SHIFT)

#define CP_CSQ_IB2_STAT_SET_CSQ_RPTR_INDIRECT2(cp_csq_ib2_stat_reg, csq_rptr_indirect2) \
     cp_csq_ib2_stat_reg = (cp_csq_ib2_stat_reg & ~CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_MASK) | (csq_rptr_indirect2 << CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_SHIFT)
#define CP_CSQ_IB2_STAT_SET_CSQ_WPTR_INDIRECT2(cp_csq_ib2_stat_reg, csq_wptr_indirect2) \
     cp_csq_ib2_stat_reg = (cp_csq_ib2_stat_reg & ~CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_MASK) | (csq_wptr_indirect2 << CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_csq_ib2_stat_t {
          unsigned int csq_rptr_indirect2             : CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_SIZE;
          unsigned int                                : 9;
          unsigned int csq_wptr_indirect2             : CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_SIZE;
          unsigned int                                : 9;
     } cp_csq_ib2_stat_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_csq_ib2_stat_t {
          unsigned int                                : 9;
          unsigned int csq_wptr_indirect2             : CP_CSQ_IB2_STAT_CSQ_WPTR_INDIRECT2_SIZE;
          unsigned int                                : 9;
          unsigned int csq_rptr_indirect2             : CP_CSQ_IB2_STAT_CSQ_RPTR_INDIRECT2_SIZE;
     } cp_csq_ib2_stat_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_csq_ib2_stat_t f;
} cp_csq_ib2_stat_u;


/*
 * CP_NON_PREFETCH_CNTRS struct
 */

#define CP_NON_PREFETCH_CNTRS_IB1_COUNTER_SIZE 3
#define CP_NON_PREFETCH_CNTRS_IB2_COUNTER_SIZE 3

#define CP_NON_PREFETCH_CNTRS_IB1_COUNTER_SHIFT 0
#define CP_NON_PREFETCH_CNTRS_IB2_COUNTER_SHIFT 8

#define CP_NON_PREFETCH_CNTRS_IB1_COUNTER_MASK 0x00000007
#define CP_NON_PREFETCH_CNTRS_IB2_COUNTER_MASK 0x00000700

#define CP_NON_PREFETCH_CNTRS_MASK \
     (CP_NON_PREFETCH_CNTRS_IB1_COUNTER_MASK | \
      CP_NON_PREFETCH_CNTRS_IB2_COUNTER_MASK)

#define CP_NON_PREFETCH_CNTRS(ib1_counter, ib2_counter) \
     ((ib1_counter << CP_NON_PREFETCH_CNTRS_IB1_COUNTER_SHIFT) | \
      (ib2_counter << CP_NON_PREFETCH_CNTRS_IB2_COUNTER_SHIFT))

#define CP_NON_PREFETCH_CNTRS_GET_IB1_COUNTER(cp_non_prefetch_cntrs) \
     ((cp_non_prefetch_cntrs & CP_NON_PREFETCH_CNTRS_IB1_COUNTER_MASK) >> CP_NON_PREFETCH_CNTRS_IB1_COUNTER_SHIFT)
#define CP_NON_PREFETCH_CNTRS_GET_IB2_COUNTER(cp_non_prefetch_cntrs) \
     ((cp_non_prefetch_cntrs & CP_NON_PREFETCH_CNTRS_IB2_COUNTER_MASK) >> CP_NON_PREFETCH_CNTRS_IB2_COUNTER_SHIFT)

#define CP_NON_PREFETCH_CNTRS_SET_IB1_COUNTER(cp_non_prefetch_cntrs_reg, ib1_counter) \
     cp_non_prefetch_cntrs_reg = (cp_non_prefetch_cntrs_reg & ~CP_NON_PREFETCH_CNTRS_IB1_COUNTER_MASK) | (ib1_counter << CP_NON_PREFETCH_CNTRS_IB1_COUNTER_SHIFT)
#define CP_NON_PREFETCH_CNTRS_SET_IB2_COUNTER(cp_non_prefetch_cntrs_reg, ib2_counter) \
     cp_non_prefetch_cntrs_reg = (cp_non_prefetch_cntrs_reg & ~CP_NON_PREFETCH_CNTRS_IB2_COUNTER_MASK) | (ib2_counter << CP_NON_PREFETCH_CNTRS_IB2_COUNTER_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_non_prefetch_cntrs_t {
          unsigned int ib1_counter                    : CP_NON_PREFETCH_CNTRS_IB1_COUNTER_SIZE;
          unsigned int                                : 5;
          unsigned int ib2_counter                    : CP_NON_PREFETCH_CNTRS_IB2_COUNTER_SIZE;
          unsigned int                                : 21;
     } cp_non_prefetch_cntrs_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_non_prefetch_cntrs_t {
          unsigned int                                : 21;
          unsigned int ib2_counter                    : CP_NON_PREFETCH_CNTRS_IB2_COUNTER_SIZE;
          unsigned int                                : 5;
          unsigned int ib1_counter                    : CP_NON_PREFETCH_CNTRS_IB1_COUNTER_SIZE;
     } cp_non_prefetch_cntrs_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_non_prefetch_cntrs_t f;
} cp_non_prefetch_cntrs_u;


/*
 * CP_STQ_ST_STAT struct
 */

#define CP_STQ_ST_STAT_STQ_RPTR_ST_SIZE 7
#define CP_STQ_ST_STAT_STQ_WPTR_ST_SIZE 7

#define CP_STQ_ST_STAT_STQ_RPTR_ST_SHIFT 0
#define CP_STQ_ST_STAT_STQ_WPTR_ST_SHIFT 16

#define CP_STQ_ST_STAT_STQ_RPTR_ST_MASK 0x0000007f
#define CP_STQ_ST_STAT_STQ_WPTR_ST_MASK 0x007f0000

#define CP_STQ_ST_STAT_MASK \
     (CP_STQ_ST_STAT_STQ_RPTR_ST_MASK | \
      CP_STQ_ST_STAT_STQ_WPTR_ST_MASK)

#define CP_STQ_ST_STAT(stq_rptr_st, stq_wptr_st) \
     ((stq_rptr_st << CP_STQ_ST_STAT_STQ_RPTR_ST_SHIFT) | \
      (stq_wptr_st << CP_STQ_ST_STAT_STQ_WPTR_ST_SHIFT))

#define CP_STQ_ST_STAT_GET_STQ_RPTR_ST(cp_stq_st_stat) \
     ((cp_stq_st_stat & CP_STQ_ST_STAT_STQ_RPTR_ST_MASK) >> CP_STQ_ST_STAT_STQ_RPTR_ST_SHIFT)
#define CP_STQ_ST_STAT_GET_STQ_WPTR_ST(cp_stq_st_stat) \
     ((cp_stq_st_stat & CP_STQ_ST_STAT_STQ_WPTR_ST_MASK) >> CP_STQ_ST_STAT_STQ_WPTR_ST_SHIFT)

#define CP_STQ_ST_STAT_SET_STQ_RPTR_ST(cp_stq_st_stat_reg, stq_rptr_st) \
     cp_stq_st_stat_reg = (cp_stq_st_stat_reg & ~CP_STQ_ST_STAT_STQ_RPTR_ST_MASK) | (stq_rptr_st << CP_STQ_ST_STAT_STQ_RPTR_ST_SHIFT)
#define CP_STQ_ST_STAT_SET_STQ_WPTR_ST(cp_stq_st_stat_reg, stq_wptr_st) \
     cp_stq_st_stat_reg = (cp_stq_st_stat_reg & ~CP_STQ_ST_STAT_STQ_WPTR_ST_MASK) | (stq_wptr_st << CP_STQ_ST_STAT_STQ_WPTR_ST_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_stq_st_stat_t {
          unsigned int stq_rptr_st                    : CP_STQ_ST_STAT_STQ_RPTR_ST_SIZE;
          unsigned int                                : 9;
          unsigned int stq_wptr_st                    : CP_STQ_ST_STAT_STQ_WPTR_ST_SIZE;
          unsigned int                                : 9;
     } cp_stq_st_stat_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_stq_st_stat_t {
          unsigned int                                : 9;
          unsigned int stq_wptr_st                    : CP_STQ_ST_STAT_STQ_WPTR_ST_SIZE;
          unsigned int                                : 9;
          unsigned int stq_rptr_st                    : CP_STQ_ST_STAT_STQ_RPTR_ST_SIZE;
     } cp_stq_st_stat_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_stq_st_stat_t f;
} cp_stq_st_stat_u;


/*
 * CP_MEQ_STAT struct
 */

#define CP_MEQ_STAT_MEQ_RPTR_SIZE      10
#define CP_MEQ_STAT_MEQ_WPTR_SIZE      10

#define CP_MEQ_STAT_MEQ_RPTR_SHIFT     0
#define CP_MEQ_STAT_MEQ_WPTR_SHIFT     16

#define CP_MEQ_STAT_MEQ_RPTR_MASK      0x000003ff
#define CP_MEQ_STAT_MEQ_WPTR_MASK      0x03ff0000

#define CP_MEQ_STAT_MASK \
     (CP_MEQ_STAT_MEQ_RPTR_MASK | \
      CP_MEQ_STAT_MEQ_WPTR_MASK)

#define CP_MEQ_STAT(meq_rptr, meq_wptr) \
     ((meq_rptr << CP_MEQ_STAT_MEQ_RPTR_SHIFT) | \
      (meq_wptr << CP_MEQ_STAT_MEQ_WPTR_SHIFT))

#define CP_MEQ_STAT_GET_MEQ_RPTR(cp_meq_stat) \
     ((cp_meq_stat & CP_MEQ_STAT_MEQ_RPTR_MASK) >> CP_MEQ_STAT_MEQ_RPTR_SHIFT)
#define CP_MEQ_STAT_GET_MEQ_WPTR(cp_meq_stat) \
     ((cp_meq_stat & CP_MEQ_STAT_MEQ_WPTR_MASK) >> CP_MEQ_STAT_MEQ_WPTR_SHIFT)

#define CP_MEQ_STAT_SET_MEQ_RPTR(cp_meq_stat_reg, meq_rptr) \
     cp_meq_stat_reg = (cp_meq_stat_reg & ~CP_MEQ_STAT_MEQ_RPTR_MASK) | (meq_rptr << CP_MEQ_STAT_MEQ_RPTR_SHIFT)
#define CP_MEQ_STAT_SET_MEQ_WPTR(cp_meq_stat_reg, meq_wptr) \
     cp_meq_stat_reg = (cp_meq_stat_reg & ~CP_MEQ_STAT_MEQ_WPTR_MASK) | (meq_wptr << CP_MEQ_STAT_MEQ_WPTR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_meq_stat_t {
          unsigned int meq_rptr                       : CP_MEQ_STAT_MEQ_RPTR_SIZE;
          unsigned int                                : 6;
          unsigned int meq_wptr                       : CP_MEQ_STAT_MEQ_WPTR_SIZE;
          unsigned int                                : 6;
     } cp_meq_stat_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_meq_stat_t {
          unsigned int                                : 6;
          unsigned int meq_wptr                       : CP_MEQ_STAT_MEQ_WPTR_SIZE;
          unsigned int                                : 6;
          unsigned int meq_rptr                       : CP_MEQ_STAT_MEQ_RPTR_SIZE;
     } cp_meq_stat_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_meq_stat_t f;
} cp_meq_stat_u;


/*
 * CP_MIU_TAG_STAT struct
 */

#define CP_MIU_TAG_STAT_TAG_0_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_1_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_2_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_3_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_4_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_5_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_6_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_7_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_8_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_9_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_10_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_11_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_12_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_13_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_14_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_15_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_16_STAT_SIZE 1
#define CP_MIU_TAG_STAT_TAG_17_STAT_SIZE 1
#define CP_MIU_TAG_STAT_INVALID_RETURN_TAG_SIZE 1

#define CP_MIU_TAG_STAT_TAG_0_STAT_SHIFT 0
#define CP_MIU_TAG_STAT_TAG_1_STAT_SHIFT 1
#define CP_MIU_TAG_STAT_TAG_2_STAT_SHIFT 2
#define CP_MIU_TAG_STAT_TAG_3_STAT_SHIFT 3
#define CP_MIU_TAG_STAT_TAG_4_STAT_SHIFT 4
#define CP_MIU_TAG_STAT_TAG_5_STAT_SHIFT 5
#define CP_MIU_TAG_STAT_TAG_6_STAT_SHIFT 6
#define CP_MIU_TAG_STAT_TAG_7_STAT_SHIFT 7
#define CP_MIU_TAG_STAT_TAG_8_STAT_SHIFT 8
#define CP_MIU_TAG_STAT_TAG_9_STAT_SHIFT 9
#define CP_MIU_TAG_STAT_TAG_10_STAT_SHIFT 10
#define CP_MIU_TAG_STAT_TAG_11_STAT_SHIFT 11
#define CP_MIU_TAG_STAT_TAG_12_STAT_SHIFT 12
#define CP_MIU_TAG_STAT_TAG_13_STAT_SHIFT 13
#define CP_MIU_TAG_STAT_TAG_14_STAT_SHIFT 14
#define CP_MIU_TAG_STAT_TAG_15_STAT_SHIFT 15
#define CP_MIU_TAG_STAT_TAG_16_STAT_SHIFT 16
#define CP_MIU_TAG_STAT_TAG_17_STAT_SHIFT 17
#define CP_MIU_TAG_STAT_INVALID_RETURN_TAG_SHIFT 31

#define CP_MIU_TAG_STAT_TAG_0_STAT_MASK 0x00000001
#define CP_MIU_TAG_STAT_TAG_1_STAT_MASK 0x00000002
#define CP_MIU_TAG_STAT_TAG_2_STAT_MASK 0x00000004
#define CP_MIU_TAG_STAT_TAG_3_STAT_MASK 0x00000008
#define CP_MIU_TAG_STAT_TAG_4_STAT_MASK 0x00000010
#define CP_MIU_TAG_STAT_TAG_5_STAT_MASK 0x00000020
#define CP_MIU_TAG_STAT_TAG_6_STAT_MASK 0x00000040
#define CP_MIU_TAG_STAT_TAG_7_STAT_MASK 0x00000080
#define CP_MIU_TAG_STAT_TAG_8_STAT_MASK 0x00000100
#define CP_MIU_TAG_STAT_TAG_9_STAT_MASK 0x00000200
#define CP_MIU_TAG_STAT_TAG_10_STAT_MASK 0x00000400
#define CP_MIU_TAG_STAT_TAG_11_STAT_MASK 0x00000800
#define CP_MIU_TAG_STAT_TAG_12_STAT_MASK 0x00001000
#define CP_MIU_TAG_STAT_TAG_13_STAT_MASK 0x00002000
#define CP_MIU_TAG_STAT_TAG_14_STAT_MASK 0x00004000
#define CP_MIU_TAG_STAT_TAG_15_STAT_MASK 0x00008000
#define CP_MIU_TAG_STAT_TAG_16_STAT_MASK 0x00010000
#define CP_MIU_TAG_STAT_TAG_17_STAT_MASK 0x00020000
#define CP_MIU_TAG_STAT_INVALID_RETURN_TAG_MASK 0x80000000

#define CP_MIU_TAG_STAT_MASK \
     (CP_MIU_TAG_STAT_TAG_0_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_1_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_2_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_3_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_4_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_5_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_6_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_7_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_8_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_9_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_10_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_11_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_12_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_13_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_14_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_15_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_16_STAT_MASK | \
      CP_MIU_TAG_STAT_TAG_17_STAT_MASK | \
      CP_MIU_TAG_STAT_INVALID_RETURN_TAG_MASK)

#define CP_MIU_TAG_STAT(tag_0_stat, tag_1_stat, tag_2_stat, tag_3_stat, tag_4_stat, tag_5_stat, tag_6_stat, tag_7_stat, tag_8_stat, tag_9_stat, tag_10_stat, tag_11_stat, tag_12_stat, tag_13_stat, tag_14_stat, tag_15_stat, tag_16_stat, tag_17_stat, invalid_return_tag) \
     ((tag_0_stat << CP_MIU_TAG_STAT_TAG_0_STAT_SHIFT) | \
      (tag_1_stat << CP_MIU_TAG_STAT_TAG_1_STAT_SHIFT) | \
      (tag_2_stat << CP_MIU_TAG_STAT_TAG_2_STAT_SHIFT) | \
      (tag_3_stat << CP_MIU_TAG_STAT_TAG_3_STAT_SHIFT) | \
      (tag_4_stat << CP_MIU_TAG_STAT_TAG_4_STAT_SHIFT) | \
      (tag_5_stat << CP_MIU_TAG_STAT_TAG_5_STAT_SHIFT) | \
      (tag_6_stat << CP_MIU_TAG_STAT_TAG_6_STAT_SHIFT) | \
      (tag_7_stat << CP_MIU_TAG_STAT_TAG_7_STAT_SHIFT) | \
      (tag_8_stat << CP_MIU_TAG_STAT_TAG_8_STAT_SHIFT) | \
      (tag_9_stat << CP_MIU_TAG_STAT_TAG_9_STAT_SHIFT) | \
      (tag_10_stat << CP_MIU_TAG_STAT_TAG_10_STAT_SHIFT) | \
      (tag_11_stat << CP_MIU_TAG_STAT_TAG_11_STAT_SHIFT) | \
      (tag_12_stat << CP_MIU_TAG_STAT_TAG_12_STAT_SHIFT) | \
      (tag_13_stat << CP_MIU_TAG_STAT_TAG_13_STAT_SHIFT) | \
      (tag_14_stat << CP_MIU_TAG_STAT_TAG_14_STAT_SHIFT) | \
      (tag_15_stat << CP_MIU_TAG_STAT_TAG_15_STAT_SHIFT) | \
      (tag_16_stat << CP_MIU_TAG_STAT_TAG_16_STAT_SHIFT) | \
      (tag_17_stat << CP_MIU_TAG_STAT_TAG_17_STAT_SHIFT) | \
      (invalid_return_tag << CP_MIU_TAG_STAT_INVALID_RETURN_TAG_SHIFT))

#define CP_MIU_TAG_STAT_GET_TAG_0_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_0_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_0_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_1_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_1_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_1_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_2_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_2_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_2_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_3_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_3_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_3_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_4_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_4_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_4_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_5_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_5_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_5_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_6_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_6_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_6_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_7_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_7_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_7_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_8_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_8_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_8_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_9_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_9_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_9_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_10_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_10_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_10_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_11_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_11_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_11_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_12_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_12_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_12_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_13_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_13_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_13_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_14_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_14_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_14_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_15_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_15_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_15_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_16_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_16_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_16_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_TAG_17_STAT(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_TAG_17_STAT_MASK) >> CP_MIU_TAG_STAT_TAG_17_STAT_SHIFT)
#define CP_MIU_TAG_STAT_GET_INVALID_RETURN_TAG(cp_miu_tag_stat) \
     ((cp_miu_tag_stat & CP_MIU_TAG_STAT_INVALID_RETURN_TAG_MASK) >> CP_MIU_TAG_STAT_INVALID_RETURN_TAG_SHIFT)

#define CP_MIU_TAG_STAT_SET_TAG_0_STAT(cp_miu_tag_stat_reg, tag_0_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_0_STAT_MASK) | (tag_0_stat << CP_MIU_TAG_STAT_TAG_0_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_1_STAT(cp_miu_tag_stat_reg, tag_1_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_1_STAT_MASK) | (tag_1_stat << CP_MIU_TAG_STAT_TAG_1_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_2_STAT(cp_miu_tag_stat_reg, tag_2_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_2_STAT_MASK) | (tag_2_stat << CP_MIU_TAG_STAT_TAG_2_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_3_STAT(cp_miu_tag_stat_reg, tag_3_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_3_STAT_MASK) | (tag_3_stat << CP_MIU_TAG_STAT_TAG_3_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_4_STAT(cp_miu_tag_stat_reg, tag_4_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_4_STAT_MASK) | (tag_4_stat << CP_MIU_TAG_STAT_TAG_4_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_5_STAT(cp_miu_tag_stat_reg, tag_5_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_5_STAT_MASK) | (tag_5_stat << CP_MIU_TAG_STAT_TAG_5_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_6_STAT(cp_miu_tag_stat_reg, tag_6_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_6_STAT_MASK) | (tag_6_stat << CP_MIU_TAG_STAT_TAG_6_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_7_STAT(cp_miu_tag_stat_reg, tag_7_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_7_STAT_MASK) | (tag_7_stat << CP_MIU_TAG_STAT_TAG_7_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_8_STAT(cp_miu_tag_stat_reg, tag_8_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_8_STAT_MASK) | (tag_8_stat << CP_MIU_TAG_STAT_TAG_8_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_9_STAT(cp_miu_tag_stat_reg, tag_9_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_9_STAT_MASK) | (tag_9_stat << CP_MIU_TAG_STAT_TAG_9_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_10_STAT(cp_miu_tag_stat_reg, tag_10_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_10_STAT_MASK) | (tag_10_stat << CP_MIU_TAG_STAT_TAG_10_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_11_STAT(cp_miu_tag_stat_reg, tag_11_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_11_STAT_MASK) | (tag_11_stat << CP_MIU_TAG_STAT_TAG_11_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_12_STAT(cp_miu_tag_stat_reg, tag_12_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_12_STAT_MASK) | (tag_12_stat << CP_MIU_TAG_STAT_TAG_12_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_13_STAT(cp_miu_tag_stat_reg, tag_13_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_13_STAT_MASK) | (tag_13_stat << CP_MIU_TAG_STAT_TAG_13_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_14_STAT(cp_miu_tag_stat_reg, tag_14_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_14_STAT_MASK) | (tag_14_stat << CP_MIU_TAG_STAT_TAG_14_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_15_STAT(cp_miu_tag_stat_reg, tag_15_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_15_STAT_MASK) | (tag_15_stat << CP_MIU_TAG_STAT_TAG_15_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_16_STAT(cp_miu_tag_stat_reg, tag_16_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_16_STAT_MASK) | (tag_16_stat << CP_MIU_TAG_STAT_TAG_16_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_TAG_17_STAT(cp_miu_tag_stat_reg, tag_17_stat) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_TAG_17_STAT_MASK) | (tag_17_stat << CP_MIU_TAG_STAT_TAG_17_STAT_SHIFT)
#define CP_MIU_TAG_STAT_SET_INVALID_RETURN_TAG(cp_miu_tag_stat_reg, invalid_return_tag) \
     cp_miu_tag_stat_reg = (cp_miu_tag_stat_reg & ~CP_MIU_TAG_STAT_INVALID_RETURN_TAG_MASK) | (invalid_return_tag << CP_MIU_TAG_STAT_INVALID_RETURN_TAG_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_miu_tag_stat_t {
          unsigned int tag_0_stat                     : CP_MIU_TAG_STAT_TAG_0_STAT_SIZE;
          unsigned int tag_1_stat                     : CP_MIU_TAG_STAT_TAG_1_STAT_SIZE;
          unsigned int tag_2_stat                     : CP_MIU_TAG_STAT_TAG_2_STAT_SIZE;
          unsigned int tag_3_stat                     : CP_MIU_TAG_STAT_TAG_3_STAT_SIZE;
          unsigned int tag_4_stat                     : CP_MIU_TAG_STAT_TAG_4_STAT_SIZE;
          unsigned int tag_5_stat                     : CP_MIU_TAG_STAT_TAG_5_STAT_SIZE;
          unsigned int tag_6_stat                     : CP_MIU_TAG_STAT_TAG_6_STAT_SIZE;
          unsigned int tag_7_stat                     : CP_MIU_TAG_STAT_TAG_7_STAT_SIZE;
          unsigned int tag_8_stat                     : CP_MIU_TAG_STAT_TAG_8_STAT_SIZE;
          unsigned int tag_9_stat                     : CP_MIU_TAG_STAT_TAG_9_STAT_SIZE;
          unsigned int tag_10_stat                    : CP_MIU_TAG_STAT_TAG_10_STAT_SIZE;
          unsigned int tag_11_stat                    : CP_MIU_TAG_STAT_TAG_11_STAT_SIZE;
          unsigned int tag_12_stat                    : CP_MIU_TAG_STAT_TAG_12_STAT_SIZE;
          unsigned int tag_13_stat                    : CP_MIU_TAG_STAT_TAG_13_STAT_SIZE;
          unsigned int tag_14_stat                    : CP_MIU_TAG_STAT_TAG_14_STAT_SIZE;
          unsigned int tag_15_stat                    : CP_MIU_TAG_STAT_TAG_15_STAT_SIZE;
          unsigned int tag_16_stat                    : CP_MIU_TAG_STAT_TAG_16_STAT_SIZE;
          unsigned int tag_17_stat                    : CP_MIU_TAG_STAT_TAG_17_STAT_SIZE;
          unsigned int                                : 13;
          unsigned int invalid_return_tag             : CP_MIU_TAG_STAT_INVALID_RETURN_TAG_SIZE;
     } cp_miu_tag_stat_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_miu_tag_stat_t {
          unsigned int invalid_return_tag             : CP_MIU_TAG_STAT_INVALID_RETURN_TAG_SIZE;
          unsigned int                                : 13;
          unsigned int tag_17_stat                    : CP_MIU_TAG_STAT_TAG_17_STAT_SIZE;
          unsigned int tag_16_stat                    : CP_MIU_TAG_STAT_TAG_16_STAT_SIZE;
          unsigned int tag_15_stat                    : CP_MIU_TAG_STAT_TAG_15_STAT_SIZE;
          unsigned int tag_14_stat                    : CP_MIU_TAG_STAT_TAG_14_STAT_SIZE;
          unsigned int tag_13_stat                    : CP_MIU_TAG_STAT_TAG_13_STAT_SIZE;
          unsigned int tag_12_stat                    : CP_MIU_TAG_STAT_TAG_12_STAT_SIZE;
          unsigned int tag_11_stat                    : CP_MIU_TAG_STAT_TAG_11_STAT_SIZE;
          unsigned int tag_10_stat                    : CP_MIU_TAG_STAT_TAG_10_STAT_SIZE;
          unsigned int tag_9_stat                     : CP_MIU_TAG_STAT_TAG_9_STAT_SIZE;
          unsigned int tag_8_stat                     : CP_MIU_TAG_STAT_TAG_8_STAT_SIZE;
          unsigned int tag_7_stat                     : CP_MIU_TAG_STAT_TAG_7_STAT_SIZE;
          unsigned int tag_6_stat                     : CP_MIU_TAG_STAT_TAG_6_STAT_SIZE;
          unsigned int tag_5_stat                     : CP_MIU_TAG_STAT_TAG_5_STAT_SIZE;
          unsigned int tag_4_stat                     : CP_MIU_TAG_STAT_TAG_4_STAT_SIZE;
          unsigned int tag_3_stat                     : CP_MIU_TAG_STAT_TAG_3_STAT_SIZE;
          unsigned int tag_2_stat                     : CP_MIU_TAG_STAT_TAG_2_STAT_SIZE;
          unsigned int tag_1_stat                     : CP_MIU_TAG_STAT_TAG_1_STAT_SIZE;
          unsigned int tag_0_stat                     : CP_MIU_TAG_STAT_TAG_0_STAT_SIZE;
     } cp_miu_tag_stat_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_miu_tag_stat_t f;
} cp_miu_tag_stat_u;


/*
 * CP_CMD_INDEX struct
 */

#define CP_CMD_INDEX_CMD_INDEX_SIZE    7
#define CP_CMD_INDEX_CMD_QUEUE_SEL_SIZE 2

#define CP_CMD_INDEX_CMD_INDEX_SHIFT   0
#define CP_CMD_INDEX_CMD_QUEUE_SEL_SHIFT 16

#define CP_CMD_INDEX_CMD_INDEX_MASK    0x0000007f
#define CP_CMD_INDEX_CMD_QUEUE_SEL_MASK 0x00030000

#define CP_CMD_INDEX_MASK \
     (CP_CMD_INDEX_CMD_INDEX_MASK | \
      CP_CMD_INDEX_CMD_QUEUE_SEL_MASK)

#define CP_CMD_INDEX(cmd_index, cmd_queue_sel) \
     ((cmd_index << CP_CMD_INDEX_CMD_INDEX_SHIFT) | \
      (cmd_queue_sel << CP_CMD_INDEX_CMD_QUEUE_SEL_SHIFT))

#define CP_CMD_INDEX_GET_CMD_INDEX(cp_cmd_index) \
     ((cp_cmd_index & CP_CMD_INDEX_CMD_INDEX_MASK) >> CP_CMD_INDEX_CMD_INDEX_SHIFT)
#define CP_CMD_INDEX_GET_CMD_QUEUE_SEL(cp_cmd_index) \
     ((cp_cmd_index & CP_CMD_INDEX_CMD_QUEUE_SEL_MASK) >> CP_CMD_INDEX_CMD_QUEUE_SEL_SHIFT)

#define CP_CMD_INDEX_SET_CMD_INDEX(cp_cmd_index_reg, cmd_index) \
     cp_cmd_index_reg = (cp_cmd_index_reg & ~CP_CMD_INDEX_CMD_INDEX_MASK) | (cmd_index << CP_CMD_INDEX_CMD_INDEX_SHIFT)
#define CP_CMD_INDEX_SET_CMD_QUEUE_SEL(cp_cmd_index_reg, cmd_queue_sel) \
     cp_cmd_index_reg = (cp_cmd_index_reg & ~CP_CMD_INDEX_CMD_QUEUE_SEL_MASK) | (cmd_queue_sel << CP_CMD_INDEX_CMD_QUEUE_SEL_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_cmd_index_t {
          unsigned int cmd_index                      : CP_CMD_INDEX_CMD_INDEX_SIZE;
          unsigned int                                : 9;
          unsigned int cmd_queue_sel                  : CP_CMD_INDEX_CMD_QUEUE_SEL_SIZE;
          unsigned int                                : 14;
     } cp_cmd_index_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_cmd_index_t {
          unsigned int                                : 14;
          unsigned int cmd_queue_sel                  : CP_CMD_INDEX_CMD_QUEUE_SEL_SIZE;
          unsigned int                                : 9;
          unsigned int cmd_index                      : CP_CMD_INDEX_CMD_INDEX_SIZE;
     } cp_cmd_index_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_cmd_index_t f;
} cp_cmd_index_u;


/*
 * CP_CMD_DATA struct
 */

#define CP_CMD_DATA_CMD_DATA_SIZE      32

#define CP_CMD_DATA_CMD_DATA_SHIFT     0

#define CP_CMD_DATA_CMD_DATA_MASK      0xffffffff

#define CP_CMD_DATA_MASK \
     (CP_CMD_DATA_CMD_DATA_MASK)

#define CP_CMD_DATA(cmd_data) \
     ((cmd_data << CP_CMD_DATA_CMD_DATA_SHIFT))

#define CP_CMD_DATA_GET_CMD_DATA(cp_cmd_data) \
     ((cp_cmd_data & CP_CMD_DATA_CMD_DATA_MASK) >> CP_CMD_DATA_CMD_DATA_SHIFT)

#define CP_CMD_DATA_SET_CMD_DATA(cp_cmd_data_reg, cmd_data) \
     cp_cmd_data_reg = (cp_cmd_data_reg & ~CP_CMD_DATA_CMD_DATA_MASK) | (cmd_data << CP_CMD_DATA_CMD_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_cmd_data_t {
          unsigned int cmd_data                       : CP_CMD_DATA_CMD_DATA_SIZE;
     } cp_cmd_data_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_cmd_data_t {
          unsigned int cmd_data                       : CP_CMD_DATA_CMD_DATA_SIZE;
     } cp_cmd_data_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_cmd_data_t f;
} cp_cmd_data_u;


/*
 * CP_ME_CNTL struct
 */

#define CP_ME_CNTL_ME_STATMUX_SIZE     16
#define CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_SIZE 1
#define CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_SIZE 1
#define CP_ME_CNTL_ME_HALT_SIZE        1
#define CP_ME_CNTL_ME_BUSY_SIZE        1
#define CP_ME_CNTL_PROG_CNT_SIZE_SIZE  1

#define CP_ME_CNTL_ME_STATMUX_SHIFT    0
#define CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_SHIFT 25
#define CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_SHIFT 26
#define CP_ME_CNTL_ME_HALT_SHIFT       28
#define CP_ME_CNTL_ME_BUSY_SHIFT       29
#define CP_ME_CNTL_PROG_CNT_SIZE_SHIFT 31

#define CP_ME_CNTL_ME_STATMUX_MASK     0x0000ffff
#define CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_MASK 0x02000000
#define CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_MASK 0x04000000
#define CP_ME_CNTL_ME_HALT_MASK        0x10000000
#define CP_ME_CNTL_ME_BUSY_MASK        0x20000000
#define CP_ME_CNTL_PROG_CNT_SIZE_MASK  0x80000000

#define CP_ME_CNTL_MASK \
     (CP_ME_CNTL_ME_STATMUX_MASK | \
      CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_MASK | \
      CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_MASK | \
      CP_ME_CNTL_ME_HALT_MASK | \
      CP_ME_CNTL_ME_BUSY_MASK | \
      CP_ME_CNTL_PROG_CNT_SIZE_MASK)

#define CP_ME_CNTL(me_statmux, vtx_dealloc_fifo_empty, pix_dealloc_fifo_empty, me_halt, me_busy, prog_cnt_size) \
     ((me_statmux << CP_ME_CNTL_ME_STATMUX_SHIFT) | \
      (vtx_dealloc_fifo_empty << CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_SHIFT) | \
      (pix_dealloc_fifo_empty << CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_SHIFT) | \
      (me_halt << CP_ME_CNTL_ME_HALT_SHIFT) | \
      (me_busy << CP_ME_CNTL_ME_BUSY_SHIFT) | \
      (prog_cnt_size << CP_ME_CNTL_PROG_CNT_SIZE_SHIFT))

#define CP_ME_CNTL_GET_ME_STATMUX(cp_me_cntl) \
     ((cp_me_cntl & CP_ME_CNTL_ME_STATMUX_MASK) >> CP_ME_CNTL_ME_STATMUX_SHIFT)
#define CP_ME_CNTL_GET_VTX_DEALLOC_FIFO_EMPTY(cp_me_cntl) \
     ((cp_me_cntl & CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_MASK) >> CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_SHIFT)
#define CP_ME_CNTL_GET_PIX_DEALLOC_FIFO_EMPTY(cp_me_cntl) \
     ((cp_me_cntl & CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_MASK) >> CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_SHIFT)
#define CP_ME_CNTL_GET_ME_HALT(cp_me_cntl) \
     ((cp_me_cntl & CP_ME_CNTL_ME_HALT_MASK) >> CP_ME_CNTL_ME_HALT_SHIFT)
#define CP_ME_CNTL_GET_ME_BUSY(cp_me_cntl) \
     ((cp_me_cntl & CP_ME_CNTL_ME_BUSY_MASK) >> CP_ME_CNTL_ME_BUSY_SHIFT)
#define CP_ME_CNTL_GET_PROG_CNT_SIZE(cp_me_cntl) \
     ((cp_me_cntl & CP_ME_CNTL_PROG_CNT_SIZE_MASK) >> CP_ME_CNTL_PROG_CNT_SIZE_SHIFT)

#define CP_ME_CNTL_SET_ME_STATMUX(cp_me_cntl_reg, me_statmux) \
     cp_me_cntl_reg = (cp_me_cntl_reg & ~CP_ME_CNTL_ME_STATMUX_MASK) | (me_statmux << CP_ME_CNTL_ME_STATMUX_SHIFT)
#define CP_ME_CNTL_SET_VTX_DEALLOC_FIFO_EMPTY(cp_me_cntl_reg, vtx_dealloc_fifo_empty) \
     cp_me_cntl_reg = (cp_me_cntl_reg & ~CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_MASK) | (vtx_dealloc_fifo_empty << CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_SHIFT)
#define CP_ME_CNTL_SET_PIX_DEALLOC_FIFO_EMPTY(cp_me_cntl_reg, pix_dealloc_fifo_empty) \
     cp_me_cntl_reg = (cp_me_cntl_reg & ~CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_MASK) | (pix_dealloc_fifo_empty << CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_SHIFT)
#define CP_ME_CNTL_SET_ME_HALT(cp_me_cntl_reg, me_halt) \
     cp_me_cntl_reg = (cp_me_cntl_reg & ~CP_ME_CNTL_ME_HALT_MASK) | (me_halt << CP_ME_CNTL_ME_HALT_SHIFT)
#define CP_ME_CNTL_SET_ME_BUSY(cp_me_cntl_reg, me_busy) \
     cp_me_cntl_reg = (cp_me_cntl_reg & ~CP_ME_CNTL_ME_BUSY_MASK) | (me_busy << CP_ME_CNTL_ME_BUSY_SHIFT)
#define CP_ME_CNTL_SET_PROG_CNT_SIZE(cp_me_cntl_reg, prog_cnt_size) \
     cp_me_cntl_reg = (cp_me_cntl_reg & ~CP_ME_CNTL_PROG_CNT_SIZE_MASK) | (prog_cnt_size << CP_ME_CNTL_PROG_CNT_SIZE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_cntl_t {
          unsigned int me_statmux                     : CP_ME_CNTL_ME_STATMUX_SIZE;
          unsigned int                                : 9;
          unsigned int vtx_dealloc_fifo_empty         : CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_SIZE;
          unsigned int pix_dealloc_fifo_empty         : CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_SIZE;
          unsigned int                                : 1;
          unsigned int me_halt                        : CP_ME_CNTL_ME_HALT_SIZE;
          unsigned int me_busy                        : CP_ME_CNTL_ME_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int prog_cnt_size                  : CP_ME_CNTL_PROG_CNT_SIZE_SIZE;
     } cp_me_cntl_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_cntl_t {
          unsigned int prog_cnt_size                  : CP_ME_CNTL_PROG_CNT_SIZE_SIZE;
          unsigned int                                : 1;
          unsigned int me_busy                        : CP_ME_CNTL_ME_BUSY_SIZE;
          unsigned int me_halt                        : CP_ME_CNTL_ME_HALT_SIZE;
          unsigned int                                : 1;
          unsigned int pix_dealloc_fifo_empty         : CP_ME_CNTL_PIX_DEALLOC_FIFO_EMPTY_SIZE;
          unsigned int vtx_dealloc_fifo_empty         : CP_ME_CNTL_VTX_DEALLOC_FIFO_EMPTY_SIZE;
          unsigned int                                : 9;
          unsigned int me_statmux                     : CP_ME_CNTL_ME_STATMUX_SIZE;
     } cp_me_cntl_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_cntl_t f;
} cp_me_cntl_u;


/*
 * CP_ME_STATUS struct
 */

#define CP_ME_STATUS_ME_DEBUG_DATA_SIZE 32

#define CP_ME_STATUS_ME_DEBUG_DATA_SHIFT 0

#define CP_ME_STATUS_ME_DEBUG_DATA_MASK 0xffffffff

#define CP_ME_STATUS_MASK \
     (CP_ME_STATUS_ME_DEBUG_DATA_MASK)

#define CP_ME_STATUS(me_debug_data) \
     ((me_debug_data << CP_ME_STATUS_ME_DEBUG_DATA_SHIFT))

#define CP_ME_STATUS_GET_ME_DEBUG_DATA(cp_me_status) \
     ((cp_me_status & CP_ME_STATUS_ME_DEBUG_DATA_MASK) >> CP_ME_STATUS_ME_DEBUG_DATA_SHIFT)

#define CP_ME_STATUS_SET_ME_DEBUG_DATA(cp_me_status_reg, me_debug_data) \
     cp_me_status_reg = (cp_me_status_reg & ~CP_ME_STATUS_ME_DEBUG_DATA_MASK) | (me_debug_data << CP_ME_STATUS_ME_DEBUG_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_status_t {
          unsigned int me_debug_data                  : CP_ME_STATUS_ME_DEBUG_DATA_SIZE;
     } cp_me_status_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_status_t {
          unsigned int me_debug_data                  : CP_ME_STATUS_ME_DEBUG_DATA_SIZE;
     } cp_me_status_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_status_t f;
} cp_me_status_u;


/*
 * CP_ME_RAM_WADDR struct
 */

#define CP_ME_RAM_WADDR_ME_RAM_WADDR_SIZE 10

#define CP_ME_RAM_WADDR_ME_RAM_WADDR_SHIFT 0

#define CP_ME_RAM_WADDR_ME_RAM_WADDR_MASK 0x000003ff

#define CP_ME_RAM_WADDR_MASK \
     (CP_ME_RAM_WADDR_ME_RAM_WADDR_MASK)

#define CP_ME_RAM_WADDR(me_ram_waddr) \
     ((me_ram_waddr << CP_ME_RAM_WADDR_ME_RAM_WADDR_SHIFT))

#define CP_ME_RAM_WADDR_GET_ME_RAM_WADDR(cp_me_ram_waddr) \
     ((cp_me_ram_waddr & CP_ME_RAM_WADDR_ME_RAM_WADDR_MASK) >> CP_ME_RAM_WADDR_ME_RAM_WADDR_SHIFT)

#define CP_ME_RAM_WADDR_SET_ME_RAM_WADDR(cp_me_ram_waddr_reg, me_ram_waddr) \
     cp_me_ram_waddr_reg = (cp_me_ram_waddr_reg & ~CP_ME_RAM_WADDR_ME_RAM_WADDR_MASK) | (me_ram_waddr << CP_ME_RAM_WADDR_ME_RAM_WADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_ram_waddr_t {
          unsigned int me_ram_waddr                   : CP_ME_RAM_WADDR_ME_RAM_WADDR_SIZE;
          unsigned int                                : 22;
     } cp_me_ram_waddr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_ram_waddr_t {
          unsigned int                                : 22;
          unsigned int me_ram_waddr                   : CP_ME_RAM_WADDR_ME_RAM_WADDR_SIZE;
     } cp_me_ram_waddr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_ram_waddr_t f;
} cp_me_ram_waddr_u;


/*
 * CP_ME_RAM_RADDR struct
 */

#define CP_ME_RAM_RADDR_ME_RAM_RADDR_SIZE 10

#define CP_ME_RAM_RADDR_ME_RAM_RADDR_SHIFT 0

#define CP_ME_RAM_RADDR_ME_RAM_RADDR_MASK 0x000003ff

#define CP_ME_RAM_RADDR_MASK \
     (CP_ME_RAM_RADDR_ME_RAM_RADDR_MASK)

#define CP_ME_RAM_RADDR(me_ram_raddr) \
     ((me_ram_raddr << CP_ME_RAM_RADDR_ME_RAM_RADDR_SHIFT))

#define CP_ME_RAM_RADDR_GET_ME_RAM_RADDR(cp_me_ram_raddr) \
     ((cp_me_ram_raddr & CP_ME_RAM_RADDR_ME_RAM_RADDR_MASK) >> CP_ME_RAM_RADDR_ME_RAM_RADDR_SHIFT)

#define CP_ME_RAM_RADDR_SET_ME_RAM_RADDR(cp_me_ram_raddr_reg, me_ram_raddr) \
     cp_me_ram_raddr_reg = (cp_me_ram_raddr_reg & ~CP_ME_RAM_RADDR_ME_RAM_RADDR_MASK) | (me_ram_raddr << CP_ME_RAM_RADDR_ME_RAM_RADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_ram_raddr_t {
          unsigned int me_ram_raddr                   : CP_ME_RAM_RADDR_ME_RAM_RADDR_SIZE;
          unsigned int                                : 22;
     } cp_me_ram_raddr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_ram_raddr_t {
          unsigned int                                : 22;
          unsigned int me_ram_raddr                   : CP_ME_RAM_RADDR_ME_RAM_RADDR_SIZE;
     } cp_me_ram_raddr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_ram_raddr_t f;
} cp_me_ram_raddr_u;


/*
 * CP_ME_RAM_DATA struct
 */

#define CP_ME_RAM_DATA_ME_RAM_DATA_SIZE 32

#define CP_ME_RAM_DATA_ME_RAM_DATA_SHIFT 0

#define CP_ME_RAM_DATA_ME_RAM_DATA_MASK 0xffffffff

#define CP_ME_RAM_DATA_MASK \
     (CP_ME_RAM_DATA_ME_RAM_DATA_MASK)

#define CP_ME_RAM_DATA(me_ram_data) \
     ((me_ram_data << CP_ME_RAM_DATA_ME_RAM_DATA_SHIFT))

#define CP_ME_RAM_DATA_GET_ME_RAM_DATA(cp_me_ram_data) \
     ((cp_me_ram_data & CP_ME_RAM_DATA_ME_RAM_DATA_MASK) >> CP_ME_RAM_DATA_ME_RAM_DATA_SHIFT)

#define CP_ME_RAM_DATA_SET_ME_RAM_DATA(cp_me_ram_data_reg, me_ram_data) \
     cp_me_ram_data_reg = (cp_me_ram_data_reg & ~CP_ME_RAM_DATA_ME_RAM_DATA_MASK) | (me_ram_data << CP_ME_RAM_DATA_ME_RAM_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_ram_data_t {
          unsigned int me_ram_data                    : CP_ME_RAM_DATA_ME_RAM_DATA_SIZE;
     } cp_me_ram_data_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_ram_data_t {
          unsigned int me_ram_data                    : CP_ME_RAM_DATA_ME_RAM_DATA_SIZE;
     } cp_me_ram_data_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_ram_data_t f;
} cp_me_ram_data_u;


/*
 * CP_ME_RDADDR struct
 */

#define CP_ME_RDADDR_ME_RDADDR_SIZE    32

#define CP_ME_RDADDR_ME_RDADDR_SHIFT   0

#define CP_ME_RDADDR_ME_RDADDR_MASK    0xffffffff

#define CP_ME_RDADDR_MASK \
     (CP_ME_RDADDR_ME_RDADDR_MASK)

#define CP_ME_RDADDR(me_rdaddr) \
     ((me_rdaddr << CP_ME_RDADDR_ME_RDADDR_SHIFT))

#define CP_ME_RDADDR_GET_ME_RDADDR(cp_me_rdaddr) \
     ((cp_me_rdaddr & CP_ME_RDADDR_ME_RDADDR_MASK) >> CP_ME_RDADDR_ME_RDADDR_SHIFT)

#define CP_ME_RDADDR_SET_ME_RDADDR(cp_me_rdaddr_reg, me_rdaddr) \
     cp_me_rdaddr_reg = (cp_me_rdaddr_reg & ~CP_ME_RDADDR_ME_RDADDR_MASK) | (me_rdaddr << CP_ME_RDADDR_ME_RDADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_rdaddr_t {
          unsigned int me_rdaddr                      : CP_ME_RDADDR_ME_RDADDR_SIZE;
     } cp_me_rdaddr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_rdaddr_t {
          unsigned int me_rdaddr                      : CP_ME_RDADDR_ME_RDADDR_SIZE;
     } cp_me_rdaddr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_rdaddr_t f;
} cp_me_rdaddr_u;


/*
 * CP_DEBUG struct
 */

#define CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_SIZE 23
#define CP_DEBUG_PREDICATE_DISABLE_SIZE 1
#define CP_DEBUG_PROG_END_PTR_ENABLE_SIZE 1
#define CP_DEBUG_MIU_128BIT_WRITE_ENABLE_SIZE 1
#define CP_DEBUG_PREFETCH_PASS_NOPS_SIZE 1
#define CP_DEBUG_DYNAMIC_CLK_DISABLE_SIZE 1
#define CP_DEBUG_PREFETCH_MATCH_DISABLE_SIZE 1
#define CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_SIZE 1
#define CP_DEBUG_MIU_WRITE_PACK_DISABLE_SIZE 1

#define CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_SHIFT 0
#define CP_DEBUG_PREDICATE_DISABLE_SHIFT 23
#define CP_DEBUG_PROG_END_PTR_ENABLE_SHIFT 24
#define CP_DEBUG_MIU_128BIT_WRITE_ENABLE_SHIFT 25
#define CP_DEBUG_PREFETCH_PASS_NOPS_SHIFT 26
#define CP_DEBUG_DYNAMIC_CLK_DISABLE_SHIFT 27
#define CP_DEBUG_PREFETCH_MATCH_DISABLE_SHIFT 28
#define CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_SHIFT 30
#define CP_DEBUG_MIU_WRITE_PACK_DISABLE_SHIFT 31

#define CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_MASK 0x007fffff
#define CP_DEBUG_PREDICATE_DISABLE_MASK 0x00800000
#define CP_DEBUG_PROG_END_PTR_ENABLE_MASK 0x01000000
#define CP_DEBUG_MIU_128BIT_WRITE_ENABLE_MASK 0x02000000
#define CP_DEBUG_PREFETCH_PASS_NOPS_MASK 0x04000000
#define CP_DEBUG_DYNAMIC_CLK_DISABLE_MASK 0x08000000
#define CP_DEBUG_PREFETCH_MATCH_DISABLE_MASK 0x10000000
#define CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_MASK 0x40000000
#define CP_DEBUG_MIU_WRITE_PACK_DISABLE_MASK 0x80000000

#define CP_DEBUG_MASK \
     (CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_MASK | \
      CP_DEBUG_PREDICATE_DISABLE_MASK | \
      CP_DEBUG_PROG_END_PTR_ENABLE_MASK | \
      CP_DEBUG_MIU_128BIT_WRITE_ENABLE_MASK | \
      CP_DEBUG_PREFETCH_PASS_NOPS_MASK | \
      CP_DEBUG_DYNAMIC_CLK_DISABLE_MASK | \
      CP_DEBUG_PREFETCH_MATCH_DISABLE_MASK | \
      CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_MASK | \
      CP_DEBUG_MIU_WRITE_PACK_DISABLE_MASK)

#define CP_DEBUG(cp_debug_unused_22_to_0, predicate_disable, prog_end_ptr_enable, miu_128bit_write_enable, prefetch_pass_nops, dynamic_clk_disable, prefetch_match_disable, simple_me_flow_control, miu_write_pack_disable) \
     ((cp_debug_unused_22_to_0 << CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_SHIFT) | \
      (predicate_disable << CP_DEBUG_PREDICATE_DISABLE_SHIFT) | \
      (prog_end_ptr_enable << CP_DEBUG_PROG_END_PTR_ENABLE_SHIFT) | \
      (miu_128bit_write_enable << CP_DEBUG_MIU_128BIT_WRITE_ENABLE_SHIFT) | \
      (prefetch_pass_nops << CP_DEBUG_PREFETCH_PASS_NOPS_SHIFT) | \
      (dynamic_clk_disable << CP_DEBUG_DYNAMIC_CLK_DISABLE_SHIFT) | \
      (prefetch_match_disable << CP_DEBUG_PREFETCH_MATCH_DISABLE_SHIFT) | \
      (simple_me_flow_control << CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_SHIFT) | \
      (miu_write_pack_disable << CP_DEBUG_MIU_WRITE_PACK_DISABLE_SHIFT))

#define CP_DEBUG_GET_CP_DEBUG_UNUSED_22_to_0(cp_debug) \
     ((cp_debug & CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_MASK) >> CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_SHIFT)
#define CP_DEBUG_GET_PREDICATE_DISABLE(cp_debug) \
     ((cp_debug & CP_DEBUG_PREDICATE_DISABLE_MASK) >> CP_DEBUG_PREDICATE_DISABLE_SHIFT)
#define CP_DEBUG_GET_PROG_END_PTR_ENABLE(cp_debug) \
     ((cp_debug & CP_DEBUG_PROG_END_PTR_ENABLE_MASK) >> CP_DEBUG_PROG_END_PTR_ENABLE_SHIFT)
#define CP_DEBUG_GET_MIU_128BIT_WRITE_ENABLE(cp_debug) \
     ((cp_debug & CP_DEBUG_MIU_128BIT_WRITE_ENABLE_MASK) >> CP_DEBUG_MIU_128BIT_WRITE_ENABLE_SHIFT)
#define CP_DEBUG_GET_PREFETCH_PASS_NOPS(cp_debug) \
     ((cp_debug & CP_DEBUG_PREFETCH_PASS_NOPS_MASK) >> CP_DEBUG_PREFETCH_PASS_NOPS_SHIFT)
#define CP_DEBUG_GET_DYNAMIC_CLK_DISABLE(cp_debug) \
     ((cp_debug & CP_DEBUG_DYNAMIC_CLK_DISABLE_MASK) >> CP_DEBUG_DYNAMIC_CLK_DISABLE_SHIFT)
#define CP_DEBUG_GET_PREFETCH_MATCH_DISABLE(cp_debug) \
     ((cp_debug & CP_DEBUG_PREFETCH_MATCH_DISABLE_MASK) >> CP_DEBUG_PREFETCH_MATCH_DISABLE_SHIFT)
#define CP_DEBUG_GET_SIMPLE_ME_FLOW_CONTROL(cp_debug) \
     ((cp_debug & CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_MASK) >> CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_SHIFT)
#define CP_DEBUG_GET_MIU_WRITE_PACK_DISABLE(cp_debug) \
     ((cp_debug & CP_DEBUG_MIU_WRITE_PACK_DISABLE_MASK) >> CP_DEBUG_MIU_WRITE_PACK_DISABLE_SHIFT)

#define CP_DEBUG_SET_CP_DEBUG_UNUSED_22_to_0(cp_debug_reg, cp_debug_unused_22_to_0) \
     cp_debug_reg = (cp_debug_reg & ~CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_MASK) | (cp_debug_unused_22_to_0 << CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_SHIFT)
#define CP_DEBUG_SET_PREDICATE_DISABLE(cp_debug_reg, predicate_disable) \
     cp_debug_reg = (cp_debug_reg & ~CP_DEBUG_PREDICATE_DISABLE_MASK) | (predicate_disable << CP_DEBUG_PREDICATE_DISABLE_SHIFT)
#define CP_DEBUG_SET_PROG_END_PTR_ENABLE(cp_debug_reg, prog_end_ptr_enable) \
     cp_debug_reg = (cp_debug_reg & ~CP_DEBUG_PROG_END_PTR_ENABLE_MASK) | (prog_end_ptr_enable << CP_DEBUG_PROG_END_PTR_ENABLE_SHIFT)
#define CP_DEBUG_SET_MIU_128BIT_WRITE_ENABLE(cp_debug_reg, miu_128bit_write_enable) \
     cp_debug_reg = (cp_debug_reg & ~CP_DEBUG_MIU_128BIT_WRITE_ENABLE_MASK) | (miu_128bit_write_enable << CP_DEBUG_MIU_128BIT_WRITE_ENABLE_SHIFT)
#define CP_DEBUG_SET_PREFETCH_PASS_NOPS(cp_debug_reg, prefetch_pass_nops) \
     cp_debug_reg = (cp_debug_reg & ~CP_DEBUG_PREFETCH_PASS_NOPS_MASK) | (prefetch_pass_nops << CP_DEBUG_PREFETCH_PASS_NOPS_SHIFT)
#define CP_DEBUG_SET_DYNAMIC_CLK_DISABLE(cp_debug_reg, dynamic_clk_disable) \
     cp_debug_reg = (cp_debug_reg & ~CP_DEBUG_DYNAMIC_CLK_DISABLE_MASK) | (dynamic_clk_disable << CP_DEBUG_DYNAMIC_CLK_DISABLE_SHIFT)
#define CP_DEBUG_SET_PREFETCH_MATCH_DISABLE(cp_debug_reg, prefetch_match_disable) \
     cp_debug_reg = (cp_debug_reg & ~CP_DEBUG_PREFETCH_MATCH_DISABLE_MASK) | (prefetch_match_disable << CP_DEBUG_PREFETCH_MATCH_DISABLE_SHIFT)
#define CP_DEBUG_SET_SIMPLE_ME_FLOW_CONTROL(cp_debug_reg, simple_me_flow_control) \
     cp_debug_reg = (cp_debug_reg & ~CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_MASK) | (simple_me_flow_control << CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_SHIFT)
#define CP_DEBUG_SET_MIU_WRITE_PACK_DISABLE(cp_debug_reg, miu_write_pack_disable) \
     cp_debug_reg = (cp_debug_reg & ~CP_DEBUG_MIU_WRITE_PACK_DISABLE_MASK) | (miu_write_pack_disable << CP_DEBUG_MIU_WRITE_PACK_DISABLE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_debug_t {
          unsigned int cp_debug_unused_22_to_0        : CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_SIZE;
          unsigned int predicate_disable              : CP_DEBUG_PREDICATE_DISABLE_SIZE;
          unsigned int prog_end_ptr_enable            : CP_DEBUG_PROG_END_PTR_ENABLE_SIZE;
          unsigned int miu_128bit_write_enable        : CP_DEBUG_MIU_128BIT_WRITE_ENABLE_SIZE;
          unsigned int prefetch_pass_nops             : CP_DEBUG_PREFETCH_PASS_NOPS_SIZE;
          unsigned int dynamic_clk_disable            : CP_DEBUG_DYNAMIC_CLK_DISABLE_SIZE;
          unsigned int prefetch_match_disable         : CP_DEBUG_PREFETCH_MATCH_DISABLE_SIZE;
          unsigned int                                : 1;
          unsigned int simple_me_flow_control         : CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_SIZE;
          unsigned int miu_write_pack_disable         : CP_DEBUG_MIU_WRITE_PACK_DISABLE_SIZE;
     } cp_debug_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_debug_t {
          unsigned int miu_write_pack_disable         : CP_DEBUG_MIU_WRITE_PACK_DISABLE_SIZE;
          unsigned int simple_me_flow_control         : CP_DEBUG_SIMPLE_ME_FLOW_CONTROL_SIZE;
          unsigned int                                : 1;
          unsigned int prefetch_match_disable         : CP_DEBUG_PREFETCH_MATCH_DISABLE_SIZE;
          unsigned int dynamic_clk_disable            : CP_DEBUG_DYNAMIC_CLK_DISABLE_SIZE;
          unsigned int prefetch_pass_nops             : CP_DEBUG_PREFETCH_PASS_NOPS_SIZE;
          unsigned int miu_128bit_write_enable        : CP_DEBUG_MIU_128BIT_WRITE_ENABLE_SIZE;
          unsigned int prog_end_ptr_enable            : CP_DEBUG_PROG_END_PTR_ENABLE_SIZE;
          unsigned int predicate_disable              : CP_DEBUG_PREDICATE_DISABLE_SIZE;
          unsigned int cp_debug_unused_22_to_0        : CP_DEBUG_CP_DEBUG_UNUSED_22_to_0_SIZE;
     } cp_debug_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_debug_t f;
} cp_debug_u;


/*
 * SCRATCH_REG0 struct
 */

#define SCRATCH_REG0_SCRATCH_REG0_SIZE 32

#define SCRATCH_REG0_SCRATCH_REG0_SHIFT 0

#define SCRATCH_REG0_SCRATCH_REG0_MASK 0xffffffff

#define SCRATCH_REG0_MASK \
     (SCRATCH_REG0_SCRATCH_REG0_MASK)

#define SCRATCH_REG0(scratch_reg0) \
     ((scratch_reg0 << SCRATCH_REG0_SCRATCH_REG0_SHIFT))

#define SCRATCH_REG0_GET_SCRATCH_REG0(scratch_reg0) \
     ((scratch_reg0 & SCRATCH_REG0_SCRATCH_REG0_MASK) >> SCRATCH_REG0_SCRATCH_REG0_SHIFT)

#define SCRATCH_REG0_SET_SCRATCH_REG0(scratch_reg0_reg, scratch_reg0) \
     scratch_reg0_reg = (scratch_reg0_reg & ~SCRATCH_REG0_SCRATCH_REG0_MASK) | (scratch_reg0 << SCRATCH_REG0_SCRATCH_REG0_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _scratch_reg0_t {
          unsigned int scratch_reg0                   : SCRATCH_REG0_SCRATCH_REG0_SIZE;
     } scratch_reg0_t;

#else   // !BIGENDIAN_OS

     typedef struct _scratch_reg0_t {
          unsigned int scratch_reg0                   : SCRATCH_REG0_SCRATCH_REG0_SIZE;
     } scratch_reg0_t;

#endif

typedef union {
     unsigned int val : 32;
     scratch_reg0_t f;
} scratch_reg0_u;


/*
 * SCRATCH_REG1 struct
 */

#define SCRATCH_REG1_SCRATCH_REG1_SIZE 32

#define SCRATCH_REG1_SCRATCH_REG1_SHIFT 0

#define SCRATCH_REG1_SCRATCH_REG1_MASK 0xffffffff

#define SCRATCH_REG1_MASK \
     (SCRATCH_REG1_SCRATCH_REG1_MASK)

#define SCRATCH_REG1(scratch_reg1) \
     ((scratch_reg1 << SCRATCH_REG1_SCRATCH_REG1_SHIFT))

#define SCRATCH_REG1_GET_SCRATCH_REG1(scratch_reg1) \
     ((scratch_reg1 & SCRATCH_REG1_SCRATCH_REG1_MASK) >> SCRATCH_REG1_SCRATCH_REG1_SHIFT)

#define SCRATCH_REG1_SET_SCRATCH_REG1(scratch_reg1_reg, scratch_reg1) \
     scratch_reg1_reg = (scratch_reg1_reg & ~SCRATCH_REG1_SCRATCH_REG1_MASK) | (scratch_reg1 << SCRATCH_REG1_SCRATCH_REG1_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _scratch_reg1_t {
          unsigned int scratch_reg1                   : SCRATCH_REG1_SCRATCH_REG1_SIZE;
     } scratch_reg1_t;

#else   // !BIGENDIAN_OS

     typedef struct _scratch_reg1_t {
          unsigned int scratch_reg1                   : SCRATCH_REG1_SCRATCH_REG1_SIZE;
     } scratch_reg1_t;

#endif

typedef union {
     unsigned int val : 32;
     scratch_reg1_t f;
} scratch_reg1_u;


/*
 * SCRATCH_REG2 struct
 */

#define SCRATCH_REG2_SCRATCH_REG2_SIZE 32

#define SCRATCH_REG2_SCRATCH_REG2_SHIFT 0

#define SCRATCH_REG2_SCRATCH_REG2_MASK 0xffffffff

#define SCRATCH_REG2_MASK \
     (SCRATCH_REG2_SCRATCH_REG2_MASK)

#define SCRATCH_REG2(scratch_reg2) \
     ((scratch_reg2 << SCRATCH_REG2_SCRATCH_REG2_SHIFT))

#define SCRATCH_REG2_GET_SCRATCH_REG2(scratch_reg2) \
     ((scratch_reg2 & SCRATCH_REG2_SCRATCH_REG2_MASK) >> SCRATCH_REG2_SCRATCH_REG2_SHIFT)

#define SCRATCH_REG2_SET_SCRATCH_REG2(scratch_reg2_reg, scratch_reg2) \
     scratch_reg2_reg = (scratch_reg2_reg & ~SCRATCH_REG2_SCRATCH_REG2_MASK) | (scratch_reg2 << SCRATCH_REG2_SCRATCH_REG2_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _scratch_reg2_t {
          unsigned int scratch_reg2                   : SCRATCH_REG2_SCRATCH_REG2_SIZE;
     } scratch_reg2_t;

#else   // !BIGENDIAN_OS

     typedef struct _scratch_reg2_t {
          unsigned int scratch_reg2                   : SCRATCH_REG2_SCRATCH_REG2_SIZE;
     } scratch_reg2_t;

#endif

typedef union {
     unsigned int val : 32;
     scratch_reg2_t f;
} scratch_reg2_u;


/*
 * SCRATCH_REG3 struct
 */

#define SCRATCH_REG3_SCRATCH_REG3_SIZE 32

#define SCRATCH_REG3_SCRATCH_REG3_SHIFT 0

#define SCRATCH_REG3_SCRATCH_REG3_MASK 0xffffffff

#define SCRATCH_REG3_MASK \
     (SCRATCH_REG3_SCRATCH_REG3_MASK)

#define SCRATCH_REG3(scratch_reg3) \
     ((scratch_reg3 << SCRATCH_REG3_SCRATCH_REG3_SHIFT))

#define SCRATCH_REG3_GET_SCRATCH_REG3(scratch_reg3) \
     ((scratch_reg3 & SCRATCH_REG3_SCRATCH_REG3_MASK) >> SCRATCH_REG3_SCRATCH_REG3_SHIFT)

#define SCRATCH_REG3_SET_SCRATCH_REG3(scratch_reg3_reg, scratch_reg3) \
     scratch_reg3_reg = (scratch_reg3_reg & ~SCRATCH_REG3_SCRATCH_REG3_MASK) | (scratch_reg3 << SCRATCH_REG3_SCRATCH_REG3_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _scratch_reg3_t {
          unsigned int scratch_reg3                   : SCRATCH_REG3_SCRATCH_REG3_SIZE;
     } scratch_reg3_t;

#else   // !BIGENDIAN_OS

     typedef struct _scratch_reg3_t {
          unsigned int scratch_reg3                   : SCRATCH_REG3_SCRATCH_REG3_SIZE;
     } scratch_reg3_t;

#endif

typedef union {
     unsigned int val : 32;
     scratch_reg3_t f;
} scratch_reg3_u;


/*
 * SCRATCH_REG4 struct
 */

#define SCRATCH_REG4_SCRATCH_REG4_SIZE 32

#define SCRATCH_REG4_SCRATCH_REG4_SHIFT 0

#define SCRATCH_REG4_SCRATCH_REG4_MASK 0xffffffff

#define SCRATCH_REG4_MASK \
     (SCRATCH_REG4_SCRATCH_REG4_MASK)

#define SCRATCH_REG4(scratch_reg4) \
     ((scratch_reg4 << SCRATCH_REG4_SCRATCH_REG4_SHIFT))

#define SCRATCH_REG4_GET_SCRATCH_REG4(scratch_reg4) \
     ((scratch_reg4 & SCRATCH_REG4_SCRATCH_REG4_MASK) >> SCRATCH_REG4_SCRATCH_REG4_SHIFT)

#define SCRATCH_REG4_SET_SCRATCH_REG4(scratch_reg4_reg, scratch_reg4) \
     scratch_reg4_reg = (scratch_reg4_reg & ~SCRATCH_REG4_SCRATCH_REG4_MASK) | (scratch_reg4 << SCRATCH_REG4_SCRATCH_REG4_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _scratch_reg4_t {
          unsigned int scratch_reg4                   : SCRATCH_REG4_SCRATCH_REG4_SIZE;
     } scratch_reg4_t;

#else   // !BIGENDIAN_OS

     typedef struct _scratch_reg4_t {
          unsigned int scratch_reg4                   : SCRATCH_REG4_SCRATCH_REG4_SIZE;
     } scratch_reg4_t;

#endif

typedef union {
     unsigned int val : 32;
     scratch_reg4_t f;
} scratch_reg4_u;


/*
 * SCRATCH_REG5 struct
 */

#define SCRATCH_REG5_SCRATCH_REG5_SIZE 32

#define SCRATCH_REG5_SCRATCH_REG5_SHIFT 0

#define SCRATCH_REG5_SCRATCH_REG5_MASK 0xffffffff

#define SCRATCH_REG5_MASK \
     (SCRATCH_REG5_SCRATCH_REG5_MASK)

#define SCRATCH_REG5(scratch_reg5) \
     ((scratch_reg5 << SCRATCH_REG5_SCRATCH_REG5_SHIFT))

#define SCRATCH_REG5_GET_SCRATCH_REG5(scratch_reg5) \
     ((scratch_reg5 & SCRATCH_REG5_SCRATCH_REG5_MASK) >> SCRATCH_REG5_SCRATCH_REG5_SHIFT)

#define SCRATCH_REG5_SET_SCRATCH_REG5(scratch_reg5_reg, scratch_reg5) \
     scratch_reg5_reg = (scratch_reg5_reg & ~SCRATCH_REG5_SCRATCH_REG5_MASK) | (scratch_reg5 << SCRATCH_REG5_SCRATCH_REG5_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _scratch_reg5_t {
          unsigned int scratch_reg5                   : SCRATCH_REG5_SCRATCH_REG5_SIZE;
     } scratch_reg5_t;

#else   // !BIGENDIAN_OS

     typedef struct _scratch_reg5_t {
          unsigned int scratch_reg5                   : SCRATCH_REG5_SCRATCH_REG5_SIZE;
     } scratch_reg5_t;

#endif

typedef union {
     unsigned int val : 32;
     scratch_reg5_t f;
} scratch_reg5_u;


/*
 * SCRATCH_REG6 struct
 */

#define SCRATCH_REG6_SCRATCH_REG6_SIZE 32

#define SCRATCH_REG6_SCRATCH_REG6_SHIFT 0

#define SCRATCH_REG6_SCRATCH_REG6_MASK 0xffffffff

#define SCRATCH_REG6_MASK \
     (SCRATCH_REG6_SCRATCH_REG6_MASK)

#define SCRATCH_REG6(scratch_reg6) \
     ((scratch_reg6 << SCRATCH_REG6_SCRATCH_REG6_SHIFT))

#define SCRATCH_REG6_GET_SCRATCH_REG6(scratch_reg6) \
     ((scratch_reg6 & SCRATCH_REG6_SCRATCH_REG6_MASK) >> SCRATCH_REG6_SCRATCH_REG6_SHIFT)

#define SCRATCH_REG6_SET_SCRATCH_REG6(scratch_reg6_reg, scratch_reg6) \
     scratch_reg6_reg = (scratch_reg6_reg & ~SCRATCH_REG6_SCRATCH_REG6_MASK) | (scratch_reg6 << SCRATCH_REG6_SCRATCH_REG6_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _scratch_reg6_t {
          unsigned int scratch_reg6                   : SCRATCH_REG6_SCRATCH_REG6_SIZE;
     } scratch_reg6_t;

#else   // !BIGENDIAN_OS

     typedef struct _scratch_reg6_t {
          unsigned int scratch_reg6                   : SCRATCH_REG6_SCRATCH_REG6_SIZE;
     } scratch_reg6_t;

#endif

typedef union {
     unsigned int val : 32;
     scratch_reg6_t f;
} scratch_reg6_u;


/*
 * SCRATCH_REG7 struct
 */

#define SCRATCH_REG7_SCRATCH_REG7_SIZE 32

#define SCRATCH_REG7_SCRATCH_REG7_SHIFT 0

#define SCRATCH_REG7_SCRATCH_REG7_MASK 0xffffffff

#define SCRATCH_REG7_MASK \
     (SCRATCH_REG7_SCRATCH_REG7_MASK)

#define SCRATCH_REG7(scratch_reg7) \
     ((scratch_reg7 << SCRATCH_REG7_SCRATCH_REG7_SHIFT))

#define SCRATCH_REG7_GET_SCRATCH_REG7(scratch_reg7) \
     ((scratch_reg7 & SCRATCH_REG7_SCRATCH_REG7_MASK) >> SCRATCH_REG7_SCRATCH_REG7_SHIFT)

#define SCRATCH_REG7_SET_SCRATCH_REG7(scratch_reg7_reg, scratch_reg7) \
     scratch_reg7_reg = (scratch_reg7_reg & ~SCRATCH_REG7_SCRATCH_REG7_MASK) | (scratch_reg7 << SCRATCH_REG7_SCRATCH_REG7_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _scratch_reg7_t {
          unsigned int scratch_reg7                   : SCRATCH_REG7_SCRATCH_REG7_SIZE;
     } scratch_reg7_t;

#else   // !BIGENDIAN_OS

     typedef struct _scratch_reg7_t {
          unsigned int scratch_reg7                   : SCRATCH_REG7_SCRATCH_REG7_SIZE;
     } scratch_reg7_t;

#endif

typedef union {
     unsigned int val : 32;
     scratch_reg7_t f;
} scratch_reg7_u;


/*
 * SCRATCH_UMSK struct
 */

#define SCRATCH_UMSK_SCRATCH_UMSK_SIZE 8
#define SCRATCH_UMSK_SCRATCH_SWAP_SIZE 2

#define SCRATCH_UMSK_SCRATCH_UMSK_SHIFT 0
#define SCRATCH_UMSK_SCRATCH_SWAP_SHIFT 16

#define SCRATCH_UMSK_SCRATCH_UMSK_MASK 0x000000ff
#define SCRATCH_UMSK_SCRATCH_SWAP_MASK 0x00030000

#define SCRATCH_UMSK_MASK \
     (SCRATCH_UMSK_SCRATCH_UMSK_MASK | \
      SCRATCH_UMSK_SCRATCH_SWAP_MASK)

#define SCRATCH_UMSK(scratch_umsk, scratch_swap) \
     ((scratch_umsk << SCRATCH_UMSK_SCRATCH_UMSK_SHIFT) | \
      (scratch_swap << SCRATCH_UMSK_SCRATCH_SWAP_SHIFT))

#define SCRATCH_UMSK_GET_SCRATCH_UMSK(scratch_umsk) \
     ((scratch_umsk & SCRATCH_UMSK_SCRATCH_UMSK_MASK) >> SCRATCH_UMSK_SCRATCH_UMSK_SHIFT)
#define SCRATCH_UMSK_GET_SCRATCH_SWAP(scratch_umsk) \
     ((scratch_umsk & SCRATCH_UMSK_SCRATCH_SWAP_MASK) >> SCRATCH_UMSK_SCRATCH_SWAP_SHIFT)

#define SCRATCH_UMSK_SET_SCRATCH_UMSK(scratch_umsk_reg, scratch_umsk) \
     scratch_umsk_reg = (scratch_umsk_reg & ~SCRATCH_UMSK_SCRATCH_UMSK_MASK) | (scratch_umsk << SCRATCH_UMSK_SCRATCH_UMSK_SHIFT)
#define SCRATCH_UMSK_SET_SCRATCH_SWAP(scratch_umsk_reg, scratch_swap) \
     scratch_umsk_reg = (scratch_umsk_reg & ~SCRATCH_UMSK_SCRATCH_SWAP_MASK) | (scratch_swap << SCRATCH_UMSK_SCRATCH_SWAP_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _scratch_umsk_t {
          unsigned int scratch_umsk                   : SCRATCH_UMSK_SCRATCH_UMSK_SIZE;
          unsigned int                                : 8;
          unsigned int scratch_swap                   : SCRATCH_UMSK_SCRATCH_SWAP_SIZE;
          unsigned int                                : 14;
     } scratch_umsk_t;

#else   // !BIGENDIAN_OS

     typedef struct _scratch_umsk_t {
          unsigned int                                : 14;
          unsigned int scratch_swap                   : SCRATCH_UMSK_SCRATCH_SWAP_SIZE;
          unsigned int                                : 8;
          unsigned int scratch_umsk                   : SCRATCH_UMSK_SCRATCH_UMSK_SIZE;
     } scratch_umsk_t;

#endif

typedef union {
     unsigned int val : 32;
     scratch_umsk_t f;
} scratch_umsk_u;


/*
 * SCRATCH_ADDR struct
 */

#define SCRATCH_ADDR_SCRATCH_ADDR_SIZE 27

#define SCRATCH_ADDR_SCRATCH_ADDR_SHIFT 5

#define SCRATCH_ADDR_SCRATCH_ADDR_MASK 0xffffffe0

#define SCRATCH_ADDR_MASK \
     (SCRATCH_ADDR_SCRATCH_ADDR_MASK)

#define SCRATCH_ADDR(scratch_addr) \
     ((scratch_addr << SCRATCH_ADDR_SCRATCH_ADDR_SHIFT))

#define SCRATCH_ADDR_GET_SCRATCH_ADDR(scratch_addr) \
     ((scratch_addr & SCRATCH_ADDR_SCRATCH_ADDR_MASK) >> SCRATCH_ADDR_SCRATCH_ADDR_SHIFT)

#define SCRATCH_ADDR_SET_SCRATCH_ADDR(scratch_addr_reg, scratch_addr) \
     scratch_addr_reg = (scratch_addr_reg & ~SCRATCH_ADDR_SCRATCH_ADDR_MASK) | (scratch_addr << SCRATCH_ADDR_SCRATCH_ADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _scratch_addr_t {
          unsigned int                                : 5;
          unsigned int scratch_addr                   : SCRATCH_ADDR_SCRATCH_ADDR_SIZE;
     } scratch_addr_t;

#else   // !BIGENDIAN_OS

     typedef struct _scratch_addr_t {
          unsigned int scratch_addr                   : SCRATCH_ADDR_SCRATCH_ADDR_SIZE;
          unsigned int                                : 5;
     } scratch_addr_t;

#endif

typedef union {
     unsigned int val : 32;
     scratch_addr_t f;
} scratch_addr_u;


/*
 * CP_ME_VS_EVENT_SRC struct
 */

#define CP_ME_VS_EVENT_SRC_VS_DONE_SWM_SIZE 1
#define CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_SIZE 1

#define CP_ME_VS_EVENT_SRC_VS_DONE_SWM_SHIFT 0
#define CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_SHIFT 1

#define CP_ME_VS_EVENT_SRC_VS_DONE_SWM_MASK 0x00000001
#define CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_MASK 0x00000002

#define CP_ME_VS_EVENT_SRC_MASK \
     (CP_ME_VS_EVENT_SRC_VS_DONE_SWM_MASK | \
      CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_MASK)

#define CP_ME_VS_EVENT_SRC(vs_done_swm, vs_done_cntr) \
     ((vs_done_swm << CP_ME_VS_EVENT_SRC_VS_DONE_SWM_SHIFT) | \
      (vs_done_cntr << CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_SHIFT))

#define CP_ME_VS_EVENT_SRC_GET_VS_DONE_SWM(cp_me_vs_event_src) \
     ((cp_me_vs_event_src & CP_ME_VS_EVENT_SRC_VS_DONE_SWM_MASK) >> CP_ME_VS_EVENT_SRC_VS_DONE_SWM_SHIFT)
#define CP_ME_VS_EVENT_SRC_GET_VS_DONE_CNTR(cp_me_vs_event_src) \
     ((cp_me_vs_event_src & CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_MASK) >> CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_SHIFT)

#define CP_ME_VS_EVENT_SRC_SET_VS_DONE_SWM(cp_me_vs_event_src_reg, vs_done_swm) \
     cp_me_vs_event_src_reg = (cp_me_vs_event_src_reg & ~CP_ME_VS_EVENT_SRC_VS_DONE_SWM_MASK) | (vs_done_swm << CP_ME_VS_EVENT_SRC_VS_DONE_SWM_SHIFT)
#define CP_ME_VS_EVENT_SRC_SET_VS_DONE_CNTR(cp_me_vs_event_src_reg, vs_done_cntr) \
     cp_me_vs_event_src_reg = (cp_me_vs_event_src_reg & ~CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_MASK) | (vs_done_cntr << CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_vs_event_src_t {
          unsigned int vs_done_swm                    : CP_ME_VS_EVENT_SRC_VS_DONE_SWM_SIZE;
          unsigned int vs_done_cntr                   : CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_SIZE;
          unsigned int                                : 30;
     } cp_me_vs_event_src_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_vs_event_src_t {
          unsigned int                                : 30;
          unsigned int vs_done_cntr                   : CP_ME_VS_EVENT_SRC_VS_DONE_CNTR_SIZE;
          unsigned int vs_done_swm                    : CP_ME_VS_EVENT_SRC_VS_DONE_SWM_SIZE;
     } cp_me_vs_event_src_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_vs_event_src_t f;
} cp_me_vs_event_src_u;


/*
 * CP_ME_VS_EVENT_ADDR struct
 */

#define CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_SIZE 2
#define CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_SIZE 30

#define CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_SHIFT 0
#define CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_SHIFT 2

#define CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_MASK 0x00000003
#define CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_MASK 0xfffffffc

#define CP_ME_VS_EVENT_ADDR_MASK \
     (CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_MASK | \
      CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_MASK)

#define CP_ME_VS_EVENT_ADDR(vs_done_swap, vs_done_addr) \
     ((vs_done_swap << CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_SHIFT) | \
      (vs_done_addr << CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_SHIFT))

#define CP_ME_VS_EVENT_ADDR_GET_VS_DONE_SWAP(cp_me_vs_event_addr) \
     ((cp_me_vs_event_addr & CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_MASK) >> CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_SHIFT)
#define CP_ME_VS_EVENT_ADDR_GET_VS_DONE_ADDR(cp_me_vs_event_addr) \
     ((cp_me_vs_event_addr & CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_MASK) >> CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_SHIFT)

#define CP_ME_VS_EVENT_ADDR_SET_VS_DONE_SWAP(cp_me_vs_event_addr_reg, vs_done_swap) \
     cp_me_vs_event_addr_reg = (cp_me_vs_event_addr_reg & ~CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_MASK) | (vs_done_swap << CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_SHIFT)
#define CP_ME_VS_EVENT_ADDR_SET_VS_DONE_ADDR(cp_me_vs_event_addr_reg, vs_done_addr) \
     cp_me_vs_event_addr_reg = (cp_me_vs_event_addr_reg & ~CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_MASK) | (vs_done_addr << CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_vs_event_addr_t {
          unsigned int vs_done_swap                   : CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_SIZE;
          unsigned int vs_done_addr                   : CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_SIZE;
     } cp_me_vs_event_addr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_vs_event_addr_t {
          unsigned int vs_done_addr                   : CP_ME_VS_EVENT_ADDR_VS_DONE_ADDR_SIZE;
          unsigned int vs_done_swap                   : CP_ME_VS_EVENT_ADDR_VS_DONE_SWAP_SIZE;
     } cp_me_vs_event_addr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_vs_event_addr_t f;
} cp_me_vs_event_addr_u;


/*
 * CP_ME_VS_EVENT_DATA struct
 */

#define CP_ME_VS_EVENT_DATA_VS_DONE_DATA_SIZE 32

#define CP_ME_VS_EVENT_DATA_VS_DONE_DATA_SHIFT 0

#define CP_ME_VS_EVENT_DATA_VS_DONE_DATA_MASK 0xffffffff

#define CP_ME_VS_EVENT_DATA_MASK \
     (CP_ME_VS_EVENT_DATA_VS_DONE_DATA_MASK)

#define CP_ME_VS_EVENT_DATA(vs_done_data) \
     ((vs_done_data << CP_ME_VS_EVENT_DATA_VS_DONE_DATA_SHIFT))

#define CP_ME_VS_EVENT_DATA_GET_VS_DONE_DATA(cp_me_vs_event_data) \
     ((cp_me_vs_event_data & CP_ME_VS_EVENT_DATA_VS_DONE_DATA_MASK) >> CP_ME_VS_EVENT_DATA_VS_DONE_DATA_SHIFT)

#define CP_ME_VS_EVENT_DATA_SET_VS_DONE_DATA(cp_me_vs_event_data_reg, vs_done_data) \
     cp_me_vs_event_data_reg = (cp_me_vs_event_data_reg & ~CP_ME_VS_EVENT_DATA_VS_DONE_DATA_MASK) | (vs_done_data << CP_ME_VS_EVENT_DATA_VS_DONE_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_vs_event_data_t {
          unsigned int vs_done_data                   : CP_ME_VS_EVENT_DATA_VS_DONE_DATA_SIZE;
     } cp_me_vs_event_data_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_vs_event_data_t {
          unsigned int vs_done_data                   : CP_ME_VS_EVENT_DATA_VS_DONE_DATA_SIZE;
     } cp_me_vs_event_data_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_vs_event_data_t f;
} cp_me_vs_event_data_u;


/*
 * CP_ME_VS_EVENT_ADDR_SWM struct
 */

#define CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_SIZE 2
#define CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_SIZE 30

#define CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_SHIFT 0
#define CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_SHIFT 2

#define CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_MASK 0x00000003
#define CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_MASK 0xfffffffc

#define CP_ME_VS_EVENT_ADDR_SWM_MASK \
     (CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_MASK | \
      CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_MASK)

#define CP_ME_VS_EVENT_ADDR_SWM(vs_done_swap_swm, vs_done_addr_swm) \
     ((vs_done_swap_swm << CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_SHIFT) | \
      (vs_done_addr_swm << CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_SHIFT))

#define CP_ME_VS_EVENT_ADDR_SWM_GET_VS_DONE_SWAP_SWM(cp_me_vs_event_addr_swm) \
     ((cp_me_vs_event_addr_swm & CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_MASK) >> CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_SHIFT)
#define CP_ME_VS_EVENT_ADDR_SWM_GET_VS_DONE_ADDR_SWM(cp_me_vs_event_addr_swm) \
     ((cp_me_vs_event_addr_swm & CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_MASK) >> CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_SHIFT)

#define CP_ME_VS_EVENT_ADDR_SWM_SET_VS_DONE_SWAP_SWM(cp_me_vs_event_addr_swm_reg, vs_done_swap_swm) \
     cp_me_vs_event_addr_swm_reg = (cp_me_vs_event_addr_swm_reg & ~CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_MASK) | (vs_done_swap_swm << CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_SHIFT)
#define CP_ME_VS_EVENT_ADDR_SWM_SET_VS_DONE_ADDR_SWM(cp_me_vs_event_addr_swm_reg, vs_done_addr_swm) \
     cp_me_vs_event_addr_swm_reg = (cp_me_vs_event_addr_swm_reg & ~CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_MASK) | (vs_done_addr_swm << CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_vs_event_addr_swm_t {
          unsigned int vs_done_swap_swm               : CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_SIZE;
          unsigned int vs_done_addr_swm               : CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_SIZE;
     } cp_me_vs_event_addr_swm_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_vs_event_addr_swm_t {
          unsigned int vs_done_addr_swm               : CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_ADDR_SWM_SIZE;
          unsigned int vs_done_swap_swm               : CP_ME_VS_EVENT_ADDR_SWM_VS_DONE_SWAP_SWM_SIZE;
     } cp_me_vs_event_addr_swm_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_vs_event_addr_swm_t f;
} cp_me_vs_event_addr_swm_u;


/*
 * CP_ME_VS_EVENT_DATA_SWM struct
 */

#define CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_SIZE 32

#define CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_SHIFT 0

#define CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_MASK 0xffffffff

#define CP_ME_VS_EVENT_DATA_SWM_MASK \
     (CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_MASK)

#define CP_ME_VS_EVENT_DATA_SWM(vs_done_data_swm) \
     ((vs_done_data_swm << CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_SHIFT))

#define CP_ME_VS_EVENT_DATA_SWM_GET_VS_DONE_DATA_SWM(cp_me_vs_event_data_swm) \
     ((cp_me_vs_event_data_swm & CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_MASK) >> CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_SHIFT)

#define CP_ME_VS_EVENT_DATA_SWM_SET_VS_DONE_DATA_SWM(cp_me_vs_event_data_swm_reg, vs_done_data_swm) \
     cp_me_vs_event_data_swm_reg = (cp_me_vs_event_data_swm_reg & ~CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_MASK) | (vs_done_data_swm << CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_vs_event_data_swm_t {
          unsigned int vs_done_data_swm               : CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_SIZE;
     } cp_me_vs_event_data_swm_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_vs_event_data_swm_t {
          unsigned int vs_done_data_swm               : CP_ME_VS_EVENT_DATA_SWM_VS_DONE_DATA_SWM_SIZE;
     } cp_me_vs_event_data_swm_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_vs_event_data_swm_t f;
} cp_me_vs_event_data_swm_u;


/*
 * CP_ME_PS_EVENT_SRC struct
 */

#define CP_ME_PS_EVENT_SRC_PS_DONE_SWM_SIZE 1
#define CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_SIZE 1

#define CP_ME_PS_EVENT_SRC_PS_DONE_SWM_SHIFT 0
#define CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_SHIFT 1

#define CP_ME_PS_EVENT_SRC_PS_DONE_SWM_MASK 0x00000001
#define CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_MASK 0x00000002

#define CP_ME_PS_EVENT_SRC_MASK \
     (CP_ME_PS_EVENT_SRC_PS_DONE_SWM_MASK | \
      CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_MASK)

#define CP_ME_PS_EVENT_SRC(ps_done_swm, ps_done_cntr) \
     ((ps_done_swm << CP_ME_PS_EVENT_SRC_PS_DONE_SWM_SHIFT) | \
      (ps_done_cntr << CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_SHIFT))

#define CP_ME_PS_EVENT_SRC_GET_PS_DONE_SWM(cp_me_ps_event_src) \
     ((cp_me_ps_event_src & CP_ME_PS_EVENT_SRC_PS_DONE_SWM_MASK) >> CP_ME_PS_EVENT_SRC_PS_DONE_SWM_SHIFT)
#define CP_ME_PS_EVENT_SRC_GET_PS_DONE_CNTR(cp_me_ps_event_src) \
     ((cp_me_ps_event_src & CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_MASK) >> CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_SHIFT)

#define CP_ME_PS_EVENT_SRC_SET_PS_DONE_SWM(cp_me_ps_event_src_reg, ps_done_swm) \
     cp_me_ps_event_src_reg = (cp_me_ps_event_src_reg & ~CP_ME_PS_EVENT_SRC_PS_DONE_SWM_MASK) | (ps_done_swm << CP_ME_PS_EVENT_SRC_PS_DONE_SWM_SHIFT)
#define CP_ME_PS_EVENT_SRC_SET_PS_DONE_CNTR(cp_me_ps_event_src_reg, ps_done_cntr) \
     cp_me_ps_event_src_reg = (cp_me_ps_event_src_reg & ~CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_MASK) | (ps_done_cntr << CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_ps_event_src_t {
          unsigned int ps_done_swm                    : CP_ME_PS_EVENT_SRC_PS_DONE_SWM_SIZE;
          unsigned int ps_done_cntr                   : CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_SIZE;
          unsigned int                                : 30;
     } cp_me_ps_event_src_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_ps_event_src_t {
          unsigned int                                : 30;
          unsigned int ps_done_cntr                   : CP_ME_PS_EVENT_SRC_PS_DONE_CNTR_SIZE;
          unsigned int ps_done_swm                    : CP_ME_PS_EVENT_SRC_PS_DONE_SWM_SIZE;
     } cp_me_ps_event_src_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_ps_event_src_t f;
} cp_me_ps_event_src_u;


/*
 * CP_ME_PS_EVENT_ADDR struct
 */

#define CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_SIZE 2
#define CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_SIZE 30

#define CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_SHIFT 0
#define CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_SHIFT 2

#define CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_MASK 0x00000003
#define CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_MASK 0xfffffffc

#define CP_ME_PS_EVENT_ADDR_MASK \
     (CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_MASK | \
      CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_MASK)

#define CP_ME_PS_EVENT_ADDR(ps_done_swap, ps_done_addr) \
     ((ps_done_swap << CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_SHIFT) | \
      (ps_done_addr << CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_SHIFT))

#define CP_ME_PS_EVENT_ADDR_GET_PS_DONE_SWAP(cp_me_ps_event_addr) \
     ((cp_me_ps_event_addr & CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_MASK) >> CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_SHIFT)
#define CP_ME_PS_EVENT_ADDR_GET_PS_DONE_ADDR(cp_me_ps_event_addr) \
     ((cp_me_ps_event_addr & CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_MASK) >> CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_SHIFT)

#define CP_ME_PS_EVENT_ADDR_SET_PS_DONE_SWAP(cp_me_ps_event_addr_reg, ps_done_swap) \
     cp_me_ps_event_addr_reg = (cp_me_ps_event_addr_reg & ~CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_MASK) | (ps_done_swap << CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_SHIFT)
#define CP_ME_PS_EVENT_ADDR_SET_PS_DONE_ADDR(cp_me_ps_event_addr_reg, ps_done_addr) \
     cp_me_ps_event_addr_reg = (cp_me_ps_event_addr_reg & ~CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_MASK) | (ps_done_addr << CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_ps_event_addr_t {
          unsigned int ps_done_swap                   : CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_SIZE;
          unsigned int ps_done_addr                   : CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_SIZE;
     } cp_me_ps_event_addr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_ps_event_addr_t {
          unsigned int ps_done_addr                   : CP_ME_PS_EVENT_ADDR_PS_DONE_ADDR_SIZE;
          unsigned int ps_done_swap                   : CP_ME_PS_EVENT_ADDR_PS_DONE_SWAP_SIZE;
     } cp_me_ps_event_addr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_ps_event_addr_t f;
} cp_me_ps_event_addr_u;


/*
 * CP_ME_PS_EVENT_DATA struct
 */

#define CP_ME_PS_EVENT_DATA_PS_DONE_DATA_SIZE 32

#define CP_ME_PS_EVENT_DATA_PS_DONE_DATA_SHIFT 0

#define CP_ME_PS_EVENT_DATA_PS_DONE_DATA_MASK 0xffffffff

#define CP_ME_PS_EVENT_DATA_MASK \
     (CP_ME_PS_EVENT_DATA_PS_DONE_DATA_MASK)

#define CP_ME_PS_EVENT_DATA(ps_done_data) \
     ((ps_done_data << CP_ME_PS_EVENT_DATA_PS_DONE_DATA_SHIFT))

#define CP_ME_PS_EVENT_DATA_GET_PS_DONE_DATA(cp_me_ps_event_data) \
     ((cp_me_ps_event_data & CP_ME_PS_EVENT_DATA_PS_DONE_DATA_MASK) >> CP_ME_PS_EVENT_DATA_PS_DONE_DATA_SHIFT)

#define CP_ME_PS_EVENT_DATA_SET_PS_DONE_DATA(cp_me_ps_event_data_reg, ps_done_data) \
     cp_me_ps_event_data_reg = (cp_me_ps_event_data_reg & ~CP_ME_PS_EVENT_DATA_PS_DONE_DATA_MASK) | (ps_done_data << CP_ME_PS_EVENT_DATA_PS_DONE_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_ps_event_data_t {
          unsigned int ps_done_data                   : CP_ME_PS_EVENT_DATA_PS_DONE_DATA_SIZE;
     } cp_me_ps_event_data_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_ps_event_data_t {
          unsigned int ps_done_data                   : CP_ME_PS_EVENT_DATA_PS_DONE_DATA_SIZE;
     } cp_me_ps_event_data_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_ps_event_data_t f;
} cp_me_ps_event_data_u;


/*
 * CP_ME_PS_EVENT_ADDR_SWM struct
 */

#define CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_SIZE 2
#define CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_SIZE 30

#define CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_SHIFT 0
#define CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_SHIFT 2

#define CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_MASK 0x00000003
#define CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_MASK 0xfffffffc

#define CP_ME_PS_EVENT_ADDR_SWM_MASK \
     (CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_MASK | \
      CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_MASK)

#define CP_ME_PS_EVENT_ADDR_SWM(ps_done_swap_swm, ps_done_addr_swm) \
     ((ps_done_swap_swm << CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_SHIFT) | \
      (ps_done_addr_swm << CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_SHIFT))

#define CP_ME_PS_EVENT_ADDR_SWM_GET_PS_DONE_SWAP_SWM(cp_me_ps_event_addr_swm) \
     ((cp_me_ps_event_addr_swm & CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_MASK) >> CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_SHIFT)
#define CP_ME_PS_EVENT_ADDR_SWM_GET_PS_DONE_ADDR_SWM(cp_me_ps_event_addr_swm) \
     ((cp_me_ps_event_addr_swm & CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_MASK) >> CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_SHIFT)

#define CP_ME_PS_EVENT_ADDR_SWM_SET_PS_DONE_SWAP_SWM(cp_me_ps_event_addr_swm_reg, ps_done_swap_swm) \
     cp_me_ps_event_addr_swm_reg = (cp_me_ps_event_addr_swm_reg & ~CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_MASK) | (ps_done_swap_swm << CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_SHIFT)
#define CP_ME_PS_EVENT_ADDR_SWM_SET_PS_DONE_ADDR_SWM(cp_me_ps_event_addr_swm_reg, ps_done_addr_swm) \
     cp_me_ps_event_addr_swm_reg = (cp_me_ps_event_addr_swm_reg & ~CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_MASK) | (ps_done_addr_swm << CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_ps_event_addr_swm_t {
          unsigned int ps_done_swap_swm               : CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_SIZE;
          unsigned int ps_done_addr_swm               : CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_SIZE;
     } cp_me_ps_event_addr_swm_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_ps_event_addr_swm_t {
          unsigned int ps_done_addr_swm               : CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_ADDR_SWM_SIZE;
          unsigned int ps_done_swap_swm               : CP_ME_PS_EVENT_ADDR_SWM_PS_DONE_SWAP_SWM_SIZE;
     } cp_me_ps_event_addr_swm_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_ps_event_addr_swm_t f;
} cp_me_ps_event_addr_swm_u;


/*
 * CP_ME_PS_EVENT_DATA_SWM struct
 */

#define CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_SIZE 32

#define CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_SHIFT 0

#define CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_MASK 0xffffffff

#define CP_ME_PS_EVENT_DATA_SWM_MASK \
     (CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_MASK)

#define CP_ME_PS_EVENT_DATA_SWM(ps_done_data_swm) \
     ((ps_done_data_swm << CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_SHIFT))

#define CP_ME_PS_EVENT_DATA_SWM_GET_PS_DONE_DATA_SWM(cp_me_ps_event_data_swm) \
     ((cp_me_ps_event_data_swm & CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_MASK) >> CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_SHIFT)

#define CP_ME_PS_EVENT_DATA_SWM_SET_PS_DONE_DATA_SWM(cp_me_ps_event_data_swm_reg, ps_done_data_swm) \
     cp_me_ps_event_data_swm_reg = (cp_me_ps_event_data_swm_reg & ~CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_MASK) | (ps_done_data_swm << CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_ps_event_data_swm_t {
          unsigned int ps_done_data_swm               : CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_SIZE;
     } cp_me_ps_event_data_swm_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_ps_event_data_swm_t {
          unsigned int ps_done_data_swm               : CP_ME_PS_EVENT_DATA_SWM_PS_DONE_DATA_SWM_SIZE;
     } cp_me_ps_event_data_swm_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_ps_event_data_swm_t f;
} cp_me_ps_event_data_swm_u;


/*
 * CP_ME_CF_EVENT_SRC struct
 */

#define CP_ME_CF_EVENT_SRC_CF_DONE_SRC_SIZE 1

#define CP_ME_CF_EVENT_SRC_CF_DONE_SRC_SHIFT 0

#define CP_ME_CF_EVENT_SRC_CF_DONE_SRC_MASK 0x00000001

#define CP_ME_CF_EVENT_SRC_MASK \
     (CP_ME_CF_EVENT_SRC_CF_DONE_SRC_MASK)

#define CP_ME_CF_EVENT_SRC(cf_done_src) \
     ((cf_done_src << CP_ME_CF_EVENT_SRC_CF_DONE_SRC_SHIFT))

#define CP_ME_CF_EVENT_SRC_GET_CF_DONE_SRC(cp_me_cf_event_src) \
     ((cp_me_cf_event_src & CP_ME_CF_EVENT_SRC_CF_DONE_SRC_MASK) >> CP_ME_CF_EVENT_SRC_CF_DONE_SRC_SHIFT)

#define CP_ME_CF_EVENT_SRC_SET_CF_DONE_SRC(cp_me_cf_event_src_reg, cf_done_src) \
     cp_me_cf_event_src_reg = (cp_me_cf_event_src_reg & ~CP_ME_CF_EVENT_SRC_CF_DONE_SRC_MASK) | (cf_done_src << CP_ME_CF_EVENT_SRC_CF_DONE_SRC_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_cf_event_src_t {
          unsigned int cf_done_src                    : CP_ME_CF_EVENT_SRC_CF_DONE_SRC_SIZE;
          unsigned int                                : 31;
     } cp_me_cf_event_src_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_cf_event_src_t {
          unsigned int                                : 31;
          unsigned int cf_done_src                    : CP_ME_CF_EVENT_SRC_CF_DONE_SRC_SIZE;
     } cp_me_cf_event_src_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_cf_event_src_t f;
} cp_me_cf_event_src_u;


/*
 * CP_ME_CF_EVENT_ADDR struct
 */

#define CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_SIZE 2
#define CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_SIZE 30

#define CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_SHIFT 0
#define CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_SHIFT 2

#define CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_MASK 0x00000003
#define CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_MASK 0xfffffffc

#define CP_ME_CF_EVENT_ADDR_MASK \
     (CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_MASK | \
      CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_MASK)

#define CP_ME_CF_EVENT_ADDR(cf_done_swap, cf_done_addr) \
     ((cf_done_swap << CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_SHIFT) | \
      (cf_done_addr << CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_SHIFT))

#define CP_ME_CF_EVENT_ADDR_GET_CF_DONE_SWAP(cp_me_cf_event_addr) \
     ((cp_me_cf_event_addr & CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_MASK) >> CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_SHIFT)
#define CP_ME_CF_EVENT_ADDR_GET_CF_DONE_ADDR(cp_me_cf_event_addr) \
     ((cp_me_cf_event_addr & CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_MASK) >> CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_SHIFT)

#define CP_ME_CF_EVENT_ADDR_SET_CF_DONE_SWAP(cp_me_cf_event_addr_reg, cf_done_swap) \
     cp_me_cf_event_addr_reg = (cp_me_cf_event_addr_reg & ~CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_MASK) | (cf_done_swap << CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_SHIFT)
#define CP_ME_CF_EVENT_ADDR_SET_CF_DONE_ADDR(cp_me_cf_event_addr_reg, cf_done_addr) \
     cp_me_cf_event_addr_reg = (cp_me_cf_event_addr_reg & ~CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_MASK) | (cf_done_addr << CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_cf_event_addr_t {
          unsigned int cf_done_swap                   : CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_SIZE;
          unsigned int cf_done_addr                   : CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_SIZE;
     } cp_me_cf_event_addr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_cf_event_addr_t {
          unsigned int cf_done_addr                   : CP_ME_CF_EVENT_ADDR_CF_DONE_ADDR_SIZE;
          unsigned int cf_done_swap                   : CP_ME_CF_EVENT_ADDR_CF_DONE_SWAP_SIZE;
     } cp_me_cf_event_addr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_cf_event_addr_t f;
} cp_me_cf_event_addr_u;


/*
 * CP_ME_CF_EVENT_DATA struct
 */

#define CP_ME_CF_EVENT_DATA_CF_DONE_DATA_SIZE 32

#define CP_ME_CF_EVENT_DATA_CF_DONE_DATA_SHIFT 0

#define CP_ME_CF_EVENT_DATA_CF_DONE_DATA_MASK 0xffffffff

#define CP_ME_CF_EVENT_DATA_MASK \
     (CP_ME_CF_EVENT_DATA_CF_DONE_DATA_MASK)

#define CP_ME_CF_EVENT_DATA(cf_done_data) \
     ((cf_done_data << CP_ME_CF_EVENT_DATA_CF_DONE_DATA_SHIFT))

#define CP_ME_CF_EVENT_DATA_GET_CF_DONE_DATA(cp_me_cf_event_data) \
     ((cp_me_cf_event_data & CP_ME_CF_EVENT_DATA_CF_DONE_DATA_MASK) >> CP_ME_CF_EVENT_DATA_CF_DONE_DATA_SHIFT)

#define CP_ME_CF_EVENT_DATA_SET_CF_DONE_DATA(cp_me_cf_event_data_reg, cf_done_data) \
     cp_me_cf_event_data_reg = (cp_me_cf_event_data_reg & ~CP_ME_CF_EVENT_DATA_CF_DONE_DATA_MASK) | (cf_done_data << CP_ME_CF_EVENT_DATA_CF_DONE_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_cf_event_data_t {
          unsigned int cf_done_data                   : CP_ME_CF_EVENT_DATA_CF_DONE_DATA_SIZE;
     } cp_me_cf_event_data_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_cf_event_data_t {
          unsigned int cf_done_data                   : CP_ME_CF_EVENT_DATA_CF_DONE_DATA_SIZE;
     } cp_me_cf_event_data_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_cf_event_data_t f;
} cp_me_cf_event_data_u;


/*
 * CP_ME_NRT_ADDR struct
 */

#define CP_ME_NRT_ADDR_NRT_WRITE_SWAP_SIZE 2
#define CP_ME_NRT_ADDR_NRT_WRITE_ADDR_SIZE 30

#define CP_ME_NRT_ADDR_NRT_WRITE_SWAP_SHIFT 0
#define CP_ME_NRT_ADDR_NRT_WRITE_ADDR_SHIFT 2

#define CP_ME_NRT_ADDR_NRT_WRITE_SWAP_MASK 0x00000003
#define CP_ME_NRT_ADDR_NRT_WRITE_ADDR_MASK 0xfffffffc

#define CP_ME_NRT_ADDR_MASK \
     (CP_ME_NRT_ADDR_NRT_WRITE_SWAP_MASK | \
      CP_ME_NRT_ADDR_NRT_WRITE_ADDR_MASK)

#define CP_ME_NRT_ADDR(nrt_write_swap, nrt_write_addr) \
     ((nrt_write_swap << CP_ME_NRT_ADDR_NRT_WRITE_SWAP_SHIFT) | \
      (nrt_write_addr << CP_ME_NRT_ADDR_NRT_WRITE_ADDR_SHIFT))

#define CP_ME_NRT_ADDR_GET_NRT_WRITE_SWAP(cp_me_nrt_addr) \
     ((cp_me_nrt_addr & CP_ME_NRT_ADDR_NRT_WRITE_SWAP_MASK) >> CP_ME_NRT_ADDR_NRT_WRITE_SWAP_SHIFT)
#define CP_ME_NRT_ADDR_GET_NRT_WRITE_ADDR(cp_me_nrt_addr) \
     ((cp_me_nrt_addr & CP_ME_NRT_ADDR_NRT_WRITE_ADDR_MASK) >> CP_ME_NRT_ADDR_NRT_WRITE_ADDR_SHIFT)

#define CP_ME_NRT_ADDR_SET_NRT_WRITE_SWAP(cp_me_nrt_addr_reg, nrt_write_swap) \
     cp_me_nrt_addr_reg = (cp_me_nrt_addr_reg & ~CP_ME_NRT_ADDR_NRT_WRITE_SWAP_MASK) | (nrt_write_swap << CP_ME_NRT_ADDR_NRT_WRITE_SWAP_SHIFT)
#define CP_ME_NRT_ADDR_SET_NRT_WRITE_ADDR(cp_me_nrt_addr_reg, nrt_write_addr) \
     cp_me_nrt_addr_reg = (cp_me_nrt_addr_reg & ~CP_ME_NRT_ADDR_NRT_WRITE_ADDR_MASK) | (nrt_write_addr << CP_ME_NRT_ADDR_NRT_WRITE_ADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_nrt_addr_t {
          unsigned int nrt_write_swap                 : CP_ME_NRT_ADDR_NRT_WRITE_SWAP_SIZE;
          unsigned int nrt_write_addr                 : CP_ME_NRT_ADDR_NRT_WRITE_ADDR_SIZE;
     } cp_me_nrt_addr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_nrt_addr_t {
          unsigned int nrt_write_addr                 : CP_ME_NRT_ADDR_NRT_WRITE_ADDR_SIZE;
          unsigned int nrt_write_swap                 : CP_ME_NRT_ADDR_NRT_WRITE_SWAP_SIZE;
     } cp_me_nrt_addr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_nrt_addr_t f;
} cp_me_nrt_addr_u;


/*
 * CP_ME_NRT_DATA struct
 */

#define CP_ME_NRT_DATA_NRT_WRITE_DATA_SIZE 32

#define CP_ME_NRT_DATA_NRT_WRITE_DATA_SHIFT 0

#define CP_ME_NRT_DATA_NRT_WRITE_DATA_MASK 0xffffffff

#define CP_ME_NRT_DATA_MASK \
     (CP_ME_NRT_DATA_NRT_WRITE_DATA_MASK)

#define CP_ME_NRT_DATA(nrt_write_data) \
     ((nrt_write_data << CP_ME_NRT_DATA_NRT_WRITE_DATA_SHIFT))

#define CP_ME_NRT_DATA_GET_NRT_WRITE_DATA(cp_me_nrt_data) \
     ((cp_me_nrt_data & CP_ME_NRT_DATA_NRT_WRITE_DATA_MASK) >> CP_ME_NRT_DATA_NRT_WRITE_DATA_SHIFT)

#define CP_ME_NRT_DATA_SET_NRT_WRITE_DATA(cp_me_nrt_data_reg, nrt_write_data) \
     cp_me_nrt_data_reg = (cp_me_nrt_data_reg & ~CP_ME_NRT_DATA_NRT_WRITE_DATA_MASK) | (nrt_write_data << CP_ME_NRT_DATA_NRT_WRITE_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_nrt_data_t {
          unsigned int nrt_write_data                 : CP_ME_NRT_DATA_NRT_WRITE_DATA_SIZE;
     } cp_me_nrt_data_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_nrt_data_t {
          unsigned int nrt_write_data                 : CP_ME_NRT_DATA_NRT_WRITE_DATA_SIZE;
     } cp_me_nrt_data_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_nrt_data_t f;
} cp_me_nrt_data_u;


/*
 * CP_ME_VS_FETCH_DONE_SRC struct
 */

#define CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_SIZE 1

#define CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_SHIFT 0

#define CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_MASK 0x00000001

#define CP_ME_VS_FETCH_DONE_SRC_MASK \
     (CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_MASK)

#define CP_ME_VS_FETCH_DONE_SRC(vs_fetch_done_cntr) \
     ((vs_fetch_done_cntr << CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_SHIFT))

#define CP_ME_VS_FETCH_DONE_SRC_GET_VS_FETCH_DONE_CNTR(cp_me_vs_fetch_done_src) \
     ((cp_me_vs_fetch_done_src & CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_MASK) >> CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_SHIFT)

#define CP_ME_VS_FETCH_DONE_SRC_SET_VS_FETCH_DONE_CNTR(cp_me_vs_fetch_done_src_reg, vs_fetch_done_cntr) \
     cp_me_vs_fetch_done_src_reg = (cp_me_vs_fetch_done_src_reg & ~CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_MASK) | (vs_fetch_done_cntr << CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_vs_fetch_done_src_t {
          unsigned int vs_fetch_done_cntr             : CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_SIZE;
          unsigned int                                : 31;
     } cp_me_vs_fetch_done_src_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_vs_fetch_done_src_t {
          unsigned int                                : 31;
          unsigned int vs_fetch_done_cntr             : CP_ME_VS_FETCH_DONE_SRC_VS_FETCH_DONE_CNTR_SIZE;
     } cp_me_vs_fetch_done_src_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_vs_fetch_done_src_t f;
} cp_me_vs_fetch_done_src_u;


/*
 * CP_ME_VS_FETCH_DONE_ADDR struct
 */

#define CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_SIZE 2
#define CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_SIZE 30

#define CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_SHIFT 0
#define CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_SHIFT 2

#define CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_MASK 0x00000003
#define CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_MASK 0xfffffffc

#define CP_ME_VS_FETCH_DONE_ADDR_MASK \
     (CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_MASK | \
      CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_MASK)

#define CP_ME_VS_FETCH_DONE_ADDR(vs_fetch_done_swap, vs_fetch_done_addr) \
     ((vs_fetch_done_swap << CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_SHIFT) | \
      (vs_fetch_done_addr << CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_SHIFT))

#define CP_ME_VS_FETCH_DONE_ADDR_GET_VS_FETCH_DONE_SWAP(cp_me_vs_fetch_done_addr) \
     ((cp_me_vs_fetch_done_addr & CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_MASK) >> CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_SHIFT)
#define CP_ME_VS_FETCH_DONE_ADDR_GET_VS_FETCH_DONE_ADDR(cp_me_vs_fetch_done_addr) \
     ((cp_me_vs_fetch_done_addr & CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_MASK) >> CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_SHIFT)

#define CP_ME_VS_FETCH_DONE_ADDR_SET_VS_FETCH_DONE_SWAP(cp_me_vs_fetch_done_addr_reg, vs_fetch_done_swap) \
     cp_me_vs_fetch_done_addr_reg = (cp_me_vs_fetch_done_addr_reg & ~CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_MASK) | (vs_fetch_done_swap << CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_SHIFT)
#define CP_ME_VS_FETCH_DONE_ADDR_SET_VS_FETCH_DONE_ADDR(cp_me_vs_fetch_done_addr_reg, vs_fetch_done_addr) \
     cp_me_vs_fetch_done_addr_reg = (cp_me_vs_fetch_done_addr_reg & ~CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_MASK) | (vs_fetch_done_addr << CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_vs_fetch_done_addr_t {
          unsigned int vs_fetch_done_swap             : CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_SIZE;
          unsigned int vs_fetch_done_addr             : CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_SIZE;
     } cp_me_vs_fetch_done_addr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_vs_fetch_done_addr_t {
          unsigned int vs_fetch_done_addr             : CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_ADDR_SIZE;
          unsigned int vs_fetch_done_swap             : CP_ME_VS_FETCH_DONE_ADDR_VS_FETCH_DONE_SWAP_SIZE;
     } cp_me_vs_fetch_done_addr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_vs_fetch_done_addr_t f;
} cp_me_vs_fetch_done_addr_u;


/*
 * CP_ME_VS_FETCH_DONE_DATA struct
 */

#define CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_SIZE 32

#define CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_SHIFT 0

#define CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_MASK 0xffffffff

#define CP_ME_VS_FETCH_DONE_DATA_MASK \
     (CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_MASK)

#define CP_ME_VS_FETCH_DONE_DATA(vs_fetch_done_data) \
     ((vs_fetch_done_data << CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_SHIFT))

#define CP_ME_VS_FETCH_DONE_DATA_GET_VS_FETCH_DONE_DATA(cp_me_vs_fetch_done_data) \
     ((cp_me_vs_fetch_done_data & CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_MASK) >> CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_SHIFT)

#define CP_ME_VS_FETCH_DONE_DATA_SET_VS_FETCH_DONE_DATA(cp_me_vs_fetch_done_data_reg, vs_fetch_done_data) \
     cp_me_vs_fetch_done_data_reg = (cp_me_vs_fetch_done_data_reg & ~CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_MASK) | (vs_fetch_done_data << CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_me_vs_fetch_done_data_t {
          unsigned int vs_fetch_done_data             : CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_SIZE;
     } cp_me_vs_fetch_done_data_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_me_vs_fetch_done_data_t {
          unsigned int vs_fetch_done_data             : CP_ME_VS_FETCH_DONE_DATA_VS_FETCH_DONE_DATA_SIZE;
     } cp_me_vs_fetch_done_data_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_me_vs_fetch_done_data_t f;
} cp_me_vs_fetch_done_data_u;


/*
 * CP_INT_CNTL struct
 */

#define CP_INT_CNTL_SW_INT_MASK_SIZE   1
#define CP_INT_CNTL_T0_PACKET_IN_IB_MASK_SIZE 1
#define CP_INT_CNTL_OPCODE_ERROR_MASK_SIZE 1
#define CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_SIZE 1
#define CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_SIZE 1
#define CP_INT_CNTL_IB_ERROR_MASK_SIZE 1
#define CP_INT_CNTL_IB2_INT_MASK_SIZE  1
#define CP_INT_CNTL_IB1_INT_MASK_SIZE  1
#define CP_INT_CNTL_RB_INT_MASK_SIZE   1

#define CP_INT_CNTL_SW_INT_MASK_SHIFT  19
#define CP_INT_CNTL_T0_PACKET_IN_IB_MASK_SHIFT 23
#define CP_INT_CNTL_OPCODE_ERROR_MASK_SHIFT 24
#define CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_SHIFT 25
#define CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_SHIFT 26
#define CP_INT_CNTL_IB_ERROR_MASK_SHIFT 27
#define CP_INT_CNTL_IB2_INT_MASK_SHIFT 29
#define CP_INT_CNTL_IB1_INT_MASK_SHIFT 30
#define CP_INT_CNTL_RB_INT_MASK_SHIFT  31

#define CP_INT_CNTL_SW_INT_MASK_MASK   0x00080000
#define CP_INT_CNTL_T0_PACKET_IN_IB_MASK_MASK 0x00800000
#define CP_INT_CNTL_OPCODE_ERROR_MASK_MASK 0x01000000
#define CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_MASK 0x02000000
#define CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_MASK 0x04000000
#define CP_INT_CNTL_IB_ERROR_MASK_MASK 0x08000000
#define CP_INT_CNTL_IB2_INT_MASK_MASK  0x20000000
#define CP_INT_CNTL_IB1_INT_MASK_MASK  0x40000000
#define CP_INT_CNTL_RB_INT_MASK_MASK   0x80000000

#define CP_INT_CNTL_MASK \
     (CP_INT_CNTL_SW_INT_MASK_MASK | \
      CP_INT_CNTL_T0_PACKET_IN_IB_MASK_MASK | \
      CP_INT_CNTL_OPCODE_ERROR_MASK_MASK | \
      CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_MASK | \
      CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_MASK | \
      CP_INT_CNTL_IB_ERROR_MASK_MASK | \
      CP_INT_CNTL_IB2_INT_MASK_MASK | \
      CP_INT_CNTL_IB1_INT_MASK_MASK | \
      CP_INT_CNTL_RB_INT_MASK_MASK)

#define CP_INT_CNTL(sw_int_mask, t0_packet_in_ib_mask, opcode_error_mask, protected_mode_error_mask, reserved_bit_error_mask, ib_error_mask, ib2_int_mask, ib1_int_mask, rb_int_mask) \
     ((sw_int_mask << CP_INT_CNTL_SW_INT_MASK_SHIFT) | \
      (t0_packet_in_ib_mask << CP_INT_CNTL_T0_PACKET_IN_IB_MASK_SHIFT) | \
      (opcode_error_mask << CP_INT_CNTL_OPCODE_ERROR_MASK_SHIFT) | \
      (protected_mode_error_mask << CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_SHIFT) | \
      (reserved_bit_error_mask << CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_SHIFT) | \
      (ib_error_mask << CP_INT_CNTL_IB_ERROR_MASK_SHIFT) | \
      (ib2_int_mask << CP_INT_CNTL_IB2_INT_MASK_SHIFT) | \
      (ib1_int_mask << CP_INT_CNTL_IB1_INT_MASK_SHIFT) | \
      (rb_int_mask << CP_INT_CNTL_RB_INT_MASK_SHIFT))

#define CP_INT_CNTL_GET_SW_INT_MASK(cp_int_cntl) \
     ((cp_int_cntl & CP_INT_CNTL_SW_INT_MASK_MASK) >> CP_INT_CNTL_SW_INT_MASK_SHIFT)
#define CP_INT_CNTL_GET_T0_PACKET_IN_IB_MASK(cp_int_cntl) \
     ((cp_int_cntl & CP_INT_CNTL_T0_PACKET_IN_IB_MASK_MASK) >> CP_INT_CNTL_T0_PACKET_IN_IB_MASK_SHIFT)
#define CP_INT_CNTL_GET_OPCODE_ERROR_MASK(cp_int_cntl) \
     ((cp_int_cntl & CP_INT_CNTL_OPCODE_ERROR_MASK_MASK) >> CP_INT_CNTL_OPCODE_ERROR_MASK_SHIFT)
#define CP_INT_CNTL_GET_PROTECTED_MODE_ERROR_MASK(cp_int_cntl) \
     ((cp_int_cntl & CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_MASK) >> CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_SHIFT)
#define CP_INT_CNTL_GET_RESERVED_BIT_ERROR_MASK(cp_int_cntl) \
     ((cp_int_cntl & CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_MASK) >> CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_SHIFT)
#define CP_INT_CNTL_GET_IB_ERROR_MASK(cp_int_cntl) \
     ((cp_int_cntl & CP_INT_CNTL_IB_ERROR_MASK_MASK) >> CP_INT_CNTL_IB_ERROR_MASK_SHIFT)
#define CP_INT_CNTL_GET_IB2_INT_MASK(cp_int_cntl) \
     ((cp_int_cntl & CP_INT_CNTL_IB2_INT_MASK_MASK) >> CP_INT_CNTL_IB2_INT_MASK_SHIFT)
#define CP_INT_CNTL_GET_IB1_INT_MASK(cp_int_cntl) \
     ((cp_int_cntl & CP_INT_CNTL_IB1_INT_MASK_MASK) >> CP_INT_CNTL_IB1_INT_MASK_SHIFT)
#define CP_INT_CNTL_GET_RB_INT_MASK(cp_int_cntl) \
     ((cp_int_cntl & CP_INT_CNTL_RB_INT_MASK_MASK) >> CP_INT_CNTL_RB_INT_MASK_SHIFT)

#define CP_INT_CNTL_SET_SW_INT_MASK(cp_int_cntl_reg, sw_int_mask) \
     cp_int_cntl_reg = (cp_int_cntl_reg & ~CP_INT_CNTL_SW_INT_MASK_MASK) | (sw_int_mask << CP_INT_CNTL_SW_INT_MASK_SHIFT)
#define CP_INT_CNTL_SET_T0_PACKET_IN_IB_MASK(cp_int_cntl_reg, t0_packet_in_ib_mask) \
     cp_int_cntl_reg = (cp_int_cntl_reg & ~CP_INT_CNTL_T0_PACKET_IN_IB_MASK_MASK) | (t0_packet_in_ib_mask << CP_INT_CNTL_T0_PACKET_IN_IB_MASK_SHIFT)
#define CP_INT_CNTL_SET_OPCODE_ERROR_MASK(cp_int_cntl_reg, opcode_error_mask) \
     cp_int_cntl_reg = (cp_int_cntl_reg & ~CP_INT_CNTL_OPCODE_ERROR_MASK_MASK) | (opcode_error_mask << CP_INT_CNTL_OPCODE_ERROR_MASK_SHIFT)
#define CP_INT_CNTL_SET_PROTECTED_MODE_ERROR_MASK(cp_int_cntl_reg, protected_mode_error_mask) \
     cp_int_cntl_reg = (cp_int_cntl_reg & ~CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_MASK) | (protected_mode_error_mask << CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_SHIFT)
#define CP_INT_CNTL_SET_RESERVED_BIT_ERROR_MASK(cp_int_cntl_reg, reserved_bit_error_mask) \
     cp_int_cntl_reg = (cp_int_cntl_reg & ~CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_MASK) | (reserved_bit_error_mask << CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_SHIFT)
#define CP_INT_CNTL_SET_IB_ERROR_MASK(cp_int_cntl_reg, ib_error_mask) \
     cp_int_cntl_reg = (cp_int_cntl_reg & ~CP_INT_CNTL_IB_ERROR_MASK_MASK) | (ib_error_mask << CP_INT_CNTL_IB_ERROR_MASK_SHIFT)
#define CP_INT_CNTL_SET_IB2_INT_MASK(cp_int_cntl_reg, ib2_int_mask) \
     cp_int_cntl_reg = (cp_int_cntl_reg & ~CP_INT_CNTL_IB2_INT_MASK_MASK) | (ib2_int_mask << CP_INT_CNTL_IB2_INT_MASK_SHIFT)
#define CP_INT_CNTL_SET_IB1_INT_MASK(cp_int_cntl_reg, ib1_int_mask) \
     cp_int_cntl_reg = (cp_int_cntl_reg & ~CP_INT_CNTL_IB1_INT_MASK_MASK) | (ib1_int_mask << CP_INT_CNTL_IB1_INT_MASK_SHIFT)
#define CP_INT_CNTL_SET_RB_INT_MASK(cp_int_cntl_reg, rb_int_mask) \
     cp_int_cntl_reg = (cp_int_cntl_reg & ~CP_INT_CNTL_RB_INT_MASK_MASK) | (rb_int_mask << CP_INT_CNTL_RB_INT_MASK_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_int_cntl_t {
          unsigned int                                : 19;
          unsigned int sw_int_mask                    : CP_INT_CNTL_SW_INT_MASK_SIZE;
          unsigned int                                : 3;
          unsigned int t0_packet_in_ib_mask           : CP_INT_CNTL_T0_PACKET_IN_IB_MASK_SIZE;
          unsigned int opcode_error_mask              : CP_INT_CNTL_OPCODE_ERROR_MASK_SIZE;
          unsigned int protected_mode_error_mask      : CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_SIZE;
          unsigned int reserved_bit_error_mask        : CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_SIZE;
          unsigned int ib_error_mask                  : CP_INT_CNTL_IB_ERROR_MASK_SIZE;
          unsigned int                                : 1;
          unsigned int ib2_int_mask                   : CP_INT_CNTL_IB2_INT_MASK_SIZE;
          unsigned int ib1_int_mask                   : CP_INT_CNTL_IB1_INT_MASK_SIZE;
          unsigned int rb_int_mask                    : CP_INT_CNTL_RB_INT_MASK_SIZE;
     } cp_int_cntl_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_int_cntl_t {
          unsigned int rb_int_mask                    : CP_INT_CNTL_RB_INT_MASK_SIZE;
          unsigned int ib1_int_mask                   : CP_INT_CNTL_IB1_INT_MASK_SIZE;
          unsigned int ib2_int_mask                   : CP_INT_CNTL_IB2_INT_MASK_SIZE;
          unsigned int                                : 1;
          unsigned int ib_error_mask                  : CP_INT_CNTL_IB_ERROR_MASK_SIZE;
          unsigned int reserved_bit_error_mask        : CP_INT_CNTL_RESERVED_BIT_ERROR_MASK_SIZE;
          unsigned int protected_mode_error_mask      : CP_INT_CNTL_PROTECTED_MODE_ERROR_MASK_SIZE;
          unsigned int opcode_error_mask              : CP_INT_CNTL_OPCODE_ERROR_MASK_SIZE;
          unsigned int t0_packet_in_ib_mask           : CP_INT_CNTL_T0_PACKET_IN_IB_MASK_SIZE;
          unsigned int                                : 3;
          unsigned int sw_int_mask                    : CP_INT_CNTL_SW_INT_MASK_SIZE;
          unsigned int                                : 19;
     } cp_int_cntl_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_int_cntl_t f;
} cp_int_cntl_u;


/*
 * CP_INT_STATUS struct
 */

#define CP_INT_STATUS_SW_INT_STAT_SIZE 1
#define CP_INT_STATUS_T0_PACKET_IN_IB_STAT_SIZE 1
#define CP_INT_STATUS_OPCODE_ERROR_STAT_SIZE 1
#define CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_SIZE 1
#define CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_SIZE 1
#define CP_INT_STATUS_IB_ERROR_STAT_SIZE 1
#define CP_INT_STATUS_IB2_INT_STAT_SIZE 1
#define CP_INT_STATUS_IB1_INT_STAT_SIZE 1
#define CP_INT_STATUS_RB_INT_STAT_SIZE 1

#define CP_INT_STATUS_SW_INT_STAT_SHIFT 19
#define CP_INT_STATUS_T0_PACKET_IN_IB_STAT_SHIFT 23
#define CP_INT_STATUS_OPCODE_ERROR_STAT_SHIFT 24
#define CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_SHIFT 25
#define CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_SHIFT 26
#define CP_INT_STATUS_IB_ERROR_STAT_SHIFT 27
#define CP_INT_STATUS_IB2_INT_STAT_SHIFT 29
#define CP_INT_STATUS_IB1_INT_STAT_SHIFT 30
#define CP_INT_STATUS_RB_INT_STAT_SHIFT 31

#define CP_INT_STATUS_SW_INT_STAT_MASK 0x00080000
#define CP_INT_STATUS_T0_PACKET_IN_IB_STAT_MASK 0x00800000
#define CP_INT_STATUS_OPCODE_ERROR_STAT_MASK 0x01000000
#define CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_MASK 0x02000000
#define CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_MASK 0x04000000
#define CP_INT_STATUS_IB_ERROR_STAT_MASK 0x08000000
#define CP_INT_STATUS_IB2_INT_STAT_MASK 0x20000000
#define CP_INT_STATUS_IB1_INT_STAT_MASK 0x40000000
#define CP_INT_STATUS_RB_INT_STAT_MASK 0x80000000

#define CP_INT_STATUS_MASK \
     (CP_INT_STATUS_SW_INT_STAT_MASK | \
      CP_INT_STATUS_T0_PACKET_IN_IB_STAT_MASK | \
      CP_INT_STATUS_OPCODE_ERROR_STAT_MASK | \
      CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_MASK | \
      CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_MASK | \
      CP_INT_STATUS_IB_ERROR_STAT_MASK | \
      CP_INT_STATUS_IB2_INT_STAT_MASK | \
      CP_INT_STATUS_IB1_INT_STAT_MASK | \
      CP_INT_STATUS_RB_INT_STAT_MASK)

#define CP_INT_STATUS(sw_int_stat, t0_packet_in_ib_stat, opcode_error_stat, protected_mode_error_stat, reserved_bit_error_stat, ib_error_stat, ib2_int_stat, ib1_int_stat, rb_int_stat) \
     ((sw_int_stat << CP_INT_STATUS_SW_INT_STAT_SHIFT) | \
      (t0_packet_in_ib_stat << CP_INT_STATUS_T0_PACKET_IN_IB_STAT_SHIFT) | \
      (opcode_error_stat << CP_INT_STATUS_OPCODE_ERROR_STAT_SHIFT) | \
      (protected_mode_error_stat << CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_SHIFT) | \
      (reserved_bit_error_stat << CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_SHIFT) | \
      (ib_error_stat << CP_INT_STATUS_IB_ERROR_STAT_SHIFT) | \
      (ib2_int_stat << CP_INT_STATUS_IB2_INT_STAT_SHIFT) | \
      (ib1_int_stat << CP_INT_STATUS_IB1_INT_STAT_SHIFT) | \
      (rb_int_stat << CP_INT_STATUS_RB_INT_STAT_SHIFT))

#define CP_INT_STATUS_GET_SW_INT_STAT(cp_int_status) \
     ((cp_int_status & CP_INT_STATUS_SW_INT_STAT_MASK) >> CP_INT_STATUS_SW_INT_STAT_SHIFT)
#define CP_INT_STATUS_GET_T0_PACKET_IN_IB_STAT(cp_int_status) \
     ((cp_int_status & CP_INT_STATUS_T0_PACKET_IN_IB_STAT_MASK) >> CP_INT_STATUS_T0_PACKET_IN_IB_STAT_SHIFT)
#define CP_INT_STATUS_GET_OPCODE_ERROR_STAT(cp_int_status) \
     ((cp_int_status & CP_INT_STATUS_OPCODE_ERROR_STAT_MASK) >> CP_INT_STATUS_OPCODE_ERROR_STAT_SHIFT)
#define CP_INT_STATUS_GET_PROTECTED_MODE_ERROR_STAT(cp_int_status) \
     ((cp_int_status & CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_MASK) >> CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_SHIFT)
#define CP_INT_STATUS_GET_RESERVED_BIT_ERROR_STAT(cp_int_status) \
     ((cp_int_status & CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_MASK) >> CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_SHIFT)
#define CP_INT_STATUS_GET_IB_ERROR_STAT(cp_int_status) \
     ((cp_int_status & CP_INT_STATUS_IB_ERROR_STAT_MASK) >> CP_INT_STATUS_IB_ERROR_STAT_SHIFT)
#define CP_INT_STATUS_GET_IB2_INT_STAT(cp_int_status) \
     ((cp_int_status & CP_INT_STATUS_IB2_INT_STAT_MASK) >> CP_INT_STATUS_IB2_INT_STAT_SHIFT)
#define CP_INT_STATUS_GET_IB1_INT_STAT(cp_int_status) \
     ((cp_int_status & CP_INT_STATUS_IB1_INT_STAT_MASK) >> CP_INT_STATUS_IB1_INT_STAT_SHIFT)
#define CP_INT_STATUS_GET_RB_INT_STAT(cp_int_status) \
     ((cp_int_status & CP_INT_STATUS_RB_INT_STAT_MASK) >> CP_INT_STATUS_RB_INT_STAT_SHIFT)

#define CP_INT_STATUS_SET_SW_INT_STAT(cp_int_status_reg, sw_int_stat) \
     cp_int_status_reg = (cp_int_status_reg & ~CP_INT_STATUS_SW_INT_STAT_MASK) | (sw_int_stat << CP_INT_STATUS_SW_INT_STAT_SHIFT)
#define CP_INT_STATUS_SET_T0_PACKET_IN_IB_STAT(cp_int_status_reg, t0_packet_in_ib_stat) \
     cp_int_status_reg = (cp_int_status_reg & ~CP_INT_STATUS_T0_PACKET_IN_IB_STAT_MASK) | (t0_packet_in_ib_stat << CP_INT_STATUS_T0_PACKET_IN_IB_STAT_SHIFT)
#define CP_INT_STATUS_SET_OPCODE_ERROR_STAT(cp_int_status_reg, opcode_error_stat) \
     cp_int_status_reg = (cp_int_status_reg & ~CP_INT_STATUS_OPCODE_ERROR_STAT_MASK) | (opcode_error_stat << CP_INT_STATUS_OPCODE_ERROR_STAT_SHIFT)
#define CP_INT_STATUS_SET_PROTECTED_MODE_ERROR_STAT(cp_int_status_reg, protected_mode_error_stat) \
     cp_int_status_reg = (cp_int_status_reg & ~CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_MASK) | (protected_mode_error_stat << CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_SHIFT)
#define CP_INT_STATUS_SET_RESERVED_BIT_ERROR_STAT(cp_int_status_reg, reserved_bit_error_stat) \
     cp_int_status_reg = (cp_int_status_reg & ~CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_MASK) | (reserved_bit_error_stat << CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_SHIFT)
#define CP_INT_STATUS_SET_IB_ERROR_STAT(cp_int_status_reg, ib_error_stat) \
     cp_int_status_reg = (cp_int_status_reg & ~CP_INT_STATUS_IB_ERROR_STAT_MASK) | (ib_error_stat << CP_INT_STATUS_IB_ERROR_STAT_SHIFT)
#define CP_INT_STATUS_SET_IB2_INT_STAT(cp_int_status_reg, ib2_int_stat) \
     cp_int_status_reg = (cp_int_status_reg & ~CP_INT_STATUS_IB2_INT_STAT_MASK) | (ib2_int_stat << CP_INT_STATUS_IB2_INT_STAT_SHIFT)
#define CP_INT_STATUS_SET_IB1_INT_STAT(cp_int_status_reg, ib1_int_stat) \
     cp_int_status_reg = (cp_int_status_reg & ~CP_INT_STATUS_IB1_INT_STAT_MASK) | (ib1_int_stat << CP_INT_STATUS_IB1_INT_STAT_SHIFT)
#define CP_INT_STATUS_SET_RB_INT_STAT(cp_int_status_reg, rb_int_stat) \
     cp_int_status_reg = (cp_int_status_reg & ~CP_INT_STATUS_RB_INT_STAT_MASK) | (rb_int_stat << CP_INT_STATUS_RB_INT_STAT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_int_status_t {
          unsigned int                                : 19;
          unsigned int sw_int_stat                    : CP_INT_STATUS_SW_INT_STAT_SIZE;
          unsigned int                                : 3;
          unsigned int t0_packet_in_ib_stat           : CP_INT_STATUS_T0_PACKET_IN_IB_STAT_SIZE;
          unsigned int opcode_error_stat              : CP_INT_STATUS_OPCODE_ERROR_STAT_SIZE;
          unsigned int protected_mode_error_stat      : CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_SIZE;
          unsigned int reserved_bit_error_stat        : CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_SIZE;
          unsigned int ib_error_stat                  : CP_INT_STATUS_IB_ERROR_STAT_SIZE;
          unsigned int                                : 1;
          unsigned int ib2_int_stat                   : CP_INT_STATUS_IB2_INT_STAT_SIZE;
          unsigned int ib1_int_stat                   : CP_INT_STATUS_IB1_INT_STAT_SIZE;
          unsigned int rb_int_stat                    : CP_INT_STATUS_RB_INT_STAT_SIZE;
     } cp_int_status_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_int_status_t {
          unsigned int rb_int_stat                    : CP_INT_STATUS_RB_INT_STAT_SIZE;
          unsigned int ib1_int_stat                   : CP_INT_STATUS_IB1_INT_STAT_SIZE;
          unsigned int ib2_int_stat                   : CP_INT_STATUS_IB2_INT_STAT_SIZE;
          unsigned int                                : 1;
          unsigned int ib_error_stat                  : CP_INT_STATUS_IB_ERROR_STAT_SIZE;
          unsigned int reserved_bit_error_stat        : CP_INT_STATUS_RESERVED_BIT_ERROR_STAT_SIZE;
          unsigned int protected_mode_error_stat      : CP_INT_STATUS_PROTECTED_MODE_ERROR_STAT_SIZE;
          unsigned int opcode_error_stat              : CP_INT_STATUS_OPCODE_ERROR_STAT_SIZE;
          unsigned int t0_packet_in_ib_stat           : CP_INT_STATUS_T0_PACKET_IN_IB_STAT_SIZE;
          unsigned int                                : 3;
          unsigned int sw_int_stat                    : CP_INT_STATUS_SW_INT_STAT_SIZE;
          unsigned int                                : 19;
     } cp_int_status_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_int_status_t f;
} cp_int_status_u;


/*
 * CP_INT_ACK struct
 */

#define CP_INT_ACK_SW_INT_ACK_SIZE     1
#define CP_INT_ACK_T0_PACKET_IN_IB_ACK_SIZE 1
#define CP_INT_ACK_OPCODE_ERROR_ACK_SIZE 1
#define CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_SIZE 1
#define CP_INT_ACK_RESERVED_BIT_ERROR_ACK_SIZE 1
#define CP_INT_ACK_IB_ERROR_ACK_SIZE   1
#define CP_INT_ACK_IB2_INT_ACK_SIZE    1
#define CP_INT_ACK_IB1_INT_ACK_SIZE    1
#define CP_INT_ACK_RB_INT_ACK_SIZE     1

#define CP_INT_ACK_SW_INT_ACK_SHIFT    19
#define CP_INT_ACK_T0_PACKET_IN_IB_ACK_SHIFT 23
#define CP_INT_ACK_OPCODE_ERROR_ACK_SHIFT 24
#define CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_SHIFT 25
#define CP_INT_ACK_RESERVED_BIT_ERROR_ACK_SHIFT 26
#define CP_INT_ACK_IB_ERROR_ACK_SHIFT  27
#define CP_INT_ACK_IB2_INT_ACK_SHIFT   29
#define CP_INT_ACK_IB1_INT_ACK_SHIFT   30
#define CP_INT_ACK_RB_INT_ACK_SHIFT    31

#define CP_INT_ACK_SW_INT_ACK_MASK     0x00080000
#define CP_INT_ACK_T0_PACKET_IN_IB_ACK_MASK 0x00800000
#define CP_INT_ACK_OPCODE_ERROR_ACK_MASK 0x01000000
#define CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_MASK 0x02000000
#define CP_INT_ACK_RESERVED_BIT_ERROR_ACK_MASK 0x04000000
#define CP_INT_ACK_IB_ERROR_ACK_MASK   0x08000000
#define CP_INT_ACK_IB2_INT_ACK_MASK    0x20000000
#define CP_INT_ACK_IB1_INT_ACK_MASK    0x40000000
#define CP_INT_ACK_RB_INT_ACK_MASK     0x80000000

#define CP_INT_ACK_MASK \
     (CP_INT_ACK_SW_INT_ACK_MASK | \
      CP_INT_ACK_T0_PACKET_IN_IB_ACK_MASK | \
      CP_INT_ACK_OPCODE_ERROR_ACK_MASK | \
      CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_MASK | \
      CP_INT_ACK_RESERVED_BIT_ERROR_ACK_MASK | \
      CP_INT_ACK_IB_ERROR_ACK_MASK | \
      CP_INT_ACK_IB2_INT_ACK_MASK | \
      CP_INT_ACK_IB1_INT_ACK_MASK | \
      CP_INT_ACK_RB_INT_ACK_MASK)

#define CP_INT_ACK(sw_int_ack, t0_packet_in_ib_ack, opcode_error_ack, protected_mode_error_ack, reserved_bit_error_ack, ib_error_ack, ib2_int_ack, ib1_int_ack, rb_int_ack) \
     ((sw_int_ack << CP_INT_ACK_SW_INT_ACK_SHIFT) | \
      (t0_packet_in_ib_ack << CP_INT_ACK_T0_PACKET_IN_IB_ACK_SHIFT) | \
      (opcode_error_ack << CP_INT_ACK_OPCODE_ERROR_ACK_SHIFT) | \
      (protected_mode_error_ack << CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_SHIFT) | \
      (reserved_bit_error_ack << CP_INT_ACK_RESERVED_BIT_ERROR_ACK_SHIFT) | \
      (ib_error_ack << CP_INT_ACK_IB_ERROR_ACK_SHIFT) | \
      (ib2_int_ack << CP_INT_ACK_IB2_INT_ACK_SHIFT) | \
      (ib1_int_ack << CP_INT_ACK_IB1_INT_ACK_SHIFT) | \
      (rb_int_ack << CP_INT_ACK_RB_INT_ACK_SHIFT))

#define CP_INT_ACK_GET_SW_INT_ACK(cp_int_ack) \
     ((cp_int_ack & CP_INT_ACK_SW_INT_ACK_MASK) >> CP_INT_ACK_SW_INT_ACK_SHIFT)
#define CP_INT_ACK_GET_T0_PACKET_IN_IB_ACK(cp_int_ack) \
     ((cp_int_ack & CP_INT_ACK_T0_PACKET_IN_IB_ACK_MASK) >> CP_INT_ACK_T0_PACKET_IN_IB_ACK_SHIFT)
#define CP_INT_ACK_GET_OPCODE_ERROR_ACK(cp_int_ack) \
     ((cp_int_ack & CP_INT_ACK_OPCODE_ERROR_ACK_MASK) >> CP_INT_ACK_OPCODE_ERROR_ACK_SHIFT)
#define CP_INT_ACK_GET_PROTECTED_MODE_ERROR_ACK(cp_int_ack) \
     ((cp_int_ack & CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_MASK) >> CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_SHIFT)
#define CP_INT_ACK_GET_RESERVED_BIT_ERROR_ACK(cp_int_ack) \
     ((cp_int_ack & CP_INT_ACK_RESERVED_BIT_ERROR_ACK_MASK) >> CP_INT_ACK_RESERVED_BIT_ERROR_ACK_SHIFT)
#define CP_INT_ACK_GET_IB_ERROR_ACK(cp_int_ack) \
     ((cp_int_ack & CP_INT_ACK_IB_ERROR_ACK_MASK) >> CP_INT_ACK_IB_ERROR_ACK_SHIFT)
#define CP_INT_ACK_GET_IB2_INT_ACK(cp_int_ack) \
     ((cp_int_ack & CP_INT_ACK_IB2_INT_ACK_MASK) >> CP_INT_ACK_IB2_INT_ACK_SHIFT)
#define CP_INT_ACK_GET_IB1_INT_ACK(cp_int_ack) \
     ((cp_int_ack & CP_INT_ACK_IB1_INT_ACK_MASK) >> CP_INT_ACK_IB1_INT_ACK_SHIFT)
#define CP_INT_ACK_GET_RB_INT_ACK(cp_int_ack) \
     ((cp_int_ack & CP_INT_ACK_RB_INT_ACK_MASK) >> CP_INT_ACK_RB_INT_ACK_SHIFT)

#define CP_INT_ACK_SET_SW_INT_ACK(cp_int_ack_reg, sw_int_ack) \
     cp_int_ack_reg = (cp_int_ack_reg & ~CP_INT_ACK_SW_INT_ACK_MASK) | (sw_int_ack << CP_INT_ACK_SW_INT_ACK_SHIFT)
#define CP_INT_ACK_SET_T0_PACKET_IN_IB_ACK(cp_int_ack_reg, t0_packet_in_ib_ack) \
     cp_int_ack_reg = (cp_int_ack_reg & ~CP_INT_ACK_T0_PACKET_IN_IB_ACK_MASK) | (t0_packet_in_ib_ack << CP_INT_ACK_T0_PACKET_IN_IB_ACK_SHIFT)
#define CP_INT_ACK_SET_OPCODE_ERROR_ACK(cp_int_ack_reg, opcode_error_ack) \
     cp_int_ack_reg = (cp_int_ack_reg & ~CP_INT_ACK_OPCODE_ERROR_ACK_MASK) | (opcode_error_ack << CP_INT_ACK_OPCODE_ERROR_ACK_SHIFT)
#define CP_INT_ACK_SET_PROTECTED_MODE_ERROR_ACK(cp_int_ack_reg, protected_mode_error_ack) \
     cp_int_ack_reg = (cp_int_ack_reg & ~CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_MASK) | (protected_mode_error_ack << CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_SHIFT)
#define CP_INT_ACK_SET_RESERVED_BIT_ERROR_ACK(cp_int_ack_reg, reserved_bit_error_ack) \
     cp_int_ack_reg = (cp_int_ack_reg & ~CP_INT_ACK_RESERVED_BIT_ERROR_ACK_MASK) | (reserved_bit_error_ack << CP_INT_ACK_RESERVED_BIT_ERROR_ACK_SHIFT)
#define CP_INT_ACK_SET_IB_ERROR_ACK(cp_int_ack_reg, ib_error_ack) \
     cp_int_ack_reg = (cp_int_ack_reg & ~CP_INT_ACK_IB_ERROR_ACK_MASK) | (ib_error_ack << CP_INT_ACK_IB_ERROR_ACK_SHIFT)
#define CP_INT_ACK_SET_IB2_INT_ACK(cp_int_ack_reg, ib2_int_ack) \
     cp_int_ack_reg = (cp_int_ack_reg & ~CP_INT_ACK_IB2_INT_ACK_MASK) | (ib2_int_ack << CP_INT_ACK_IB2_INT_ACK_SHIFT)
#define CP_INT_ACK_SET_IB1_INT_ACK(cp_int_ack_reg, ib1_int_ack) \
     cp_int_ack_reg = (cp_int_ack_reg & ~CP_INT_ACK_IB1_INT_ACK_MASK) | (ib1_int_ack << CP_INT_ACK_IB1_INT_ACK_SHIFT)
#define CP_INT_ACK_SET_RB_INT_ACK(cp_int_ack_reg, rb_int_ack) \
     cp_int_ack_reg = (cp_int_ack_reg & ~CP_INT_ACK_RB_INT_ACK_MASK) | (rb_int_ack << CP_INT_ACK_RB_INT_ACK_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_int_ack_t {
          unsigned int                                : 19;
          unsigned int sw_int_ack                     : CP_INT_ACK_SW_INT_ACK_SIZE;
          unsigned int                                : 3;
          unsigned int t0_packet_in_ib_ack            : CP_INT_ACK_T0_PACKET_IN_IB_ACK_SIZE;
          unsigned int opcode_error_ack               : CP_INT_ACK_OPCODE_ERROR_ACK_SIZE;
          unsigned int protected_mode_error_ack       : CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_SIZE;
          unsigned int reserved_bit_error_ack         : CP_INT_ACK_RESERVED_BIT_ERROR_ACK_SIZE;
          unsigned int ib_error_ack                   : CP_INT_ACK_IB_ERROR_ACK_SIZE;
          unsigned int                                : 1;
          unsigned int ib2_int_ack                    : CP_INT_ACK_IB2_INT_ACK_SIZE;
          unsigned int ib1_int_ack                    : CP_INT_ACK_IB1_INT_ACK_SIZE;
          unsigned int rb_int_ack                     : CP_INT_ACK_RB_INT_ACK_SIZE;
     } cp_int_ack_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_int_ack_t {
          unsigned int rb_int_ack                     : CP_INT_ACK_RB_INT_ACK_SIZE;
          unsigned int ib1_int_ack                    : CP_INT_ACK_IB1_INT_ACK_SIZE;
          unsigned int ib2_int_ack                    : CP_INT_ACK_IB2_INT_ACK_SIZE;
          unsigned int                                : 1;
          unsigned int ib_error_ack                   : CP_INT_ACK_IB_ERROR_ACK_SIZE;
          unsigned int reserved_bit_error_ack         : CP_INT_ACK_RESERVED_BIT_ERROR_ACK_SIZE;
          unsigned int protected_mode_error_ack       : CP_INT_ACK_PROTECTED_MODE_ERROR_ACK_SIZE;
          unsigned int opcode_error_ack               : CP_INT_ACK_OPCODE_ERROR_ACK_SIZE;
          unsigned int t0_packet_in_ib_ack            : CP_INT_ACK_T0_PACKET_IN_IB_ACK_SIZE;
          unsigned int                                : 3;
          unsigned int sw_int_ack                     : CP_INT_ACK_SW_INT_ACK_SIZE;
          unsigned int                                : 19;
     } cp_int_ack_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_int_ack_t f;
} cp_int_ack_u;


/*
 * CP_PFP_UCODE_ADDR struct
 */

#define CP_PFP_UCODE_ADDR_UCODE_ADDR_SIZE 9

#define CP_PFP_UCODE_ADDR_UCODE_ADDR_SHIFT 0

#define CP_PFP_UCODE_ADDR_UCODE_ADDR_MASK 0x000001ff

#define CP_PFP_UCODE_ADDR_MASK \
     (CP_PFP_UCODE_ADDR_UCODE_ADDR_MASK)

#define CP_PFP_UCODE_ADDR(ucode_addr) \
     ((ucode_addr << CP_PFP_UCODE_ADDR_UCODE_ADDR_SHIFT))

#define CP_PFP_UCODE_ADDR_GET_UCODE_ADDR(cp_pfp_ucode_addr) \
     ((cp_pfp_ucode_addr & CP_PFP_UCODE_ADDR_UCODE_ADDR_MASK) >> CP_PFP_UCODE_ADDR_UCODE_ADDR_SHIFT)

#define CP_PFP_UCODE_ADDR_SET_UCODE_ADDR(cp_pfp_ucode_addr_reg, ucode_addr) \
     cp_pfp_ucode_addr_reg = (cp_pfp_ucode_addr_reg & ~CP_PFP_UCODE_ADDR_UCODE_ADDR_MASK) | (ucode_addr << CP_PFP_UCODE_ADDR_UCODE_ADDR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_pfp_ucode_addr_t {
          unsigned int ucode_addr                     : CP_PFP_UCODE_ADDR_UCODE_ADDR_SIZE;
          unsigned int                                : 23;
     } cp_pfp_ucode_addr_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_pfp_ucode_addr_t {
          unsigned int                                : 23;
          unsigned int ucode_addr                     : CP_PFP_UCODE_ADDR_UCODE_ADDR_SIZE;
     } cp_pfp_ucode_addr_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_pfp_ucode_addr_t f;
} cp_pfp_ucode_addr_u;


/*
 * CP_PFP_UCODE_DATA struct
 */

#define CP_PFP_UCODE_DATA_UCODE_DATA_SIZE 24

#define CP_PFP_UCODE_DATA_UCODE_DATA_SHIFT 0

#define CP_PFP_UCODE_DATA_UCODE_DATA_MASK 0x00ffffff

#define CP_PFP_UCODE_DATA_MASK \
     (CP_PFP_UCODE_DATA_UCODE_DATA_MASK)

#define CP_PFP_UCODE_DATA(ucode_data) \
     ((ucode_data << CP_PFP_UCODE_DATA_UCODE_DATA_SHIFT))

#define CP_PFP_UCODE_DATA_GET_UCODE_DATA(cp_pfp_ucode_data) \
     ((cp_pfp_ucode_data & CP_PFP_UCODE_DATA_UCODE_DATA_MASK) >> CP_PFP_UCODE_DATA_UCODE_DATA_SHIFT)

#define CP_PFP_UCODE_DATA_SET_UCODE_DATA(cp_pfp_ucode_data_reg, ucode_data) \
     cp_pfp_ucode_data_reg = (cp_pfp_ucode_data_reg & ~CP_PFP_UCODE_DATA_UCODE_DATA_MASK) | (ucode_data << CP_PFP_UCODE_DATA_UCODE_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_pfp_ucode_data_t {
          unsigned int ucode_data                     : CP_PFP_UCODE_DATA_UCODE_DATA_SIZE;
          unsigned int                                : 8;
     } cp_pfp_ucode_data_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_pfp_ucode_data_t {
          unsigned int                                : 8;
          unsigned int ucode_data                     : CP_PFP_UCODE_DATA_UCODE_DATA_SIZE;
     } cp_pfp_ucode_data_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_pfp_ucode_data_t f;
} cp_pfp_ucode_data_u;


/*
 * CP_PERFMON_CNTL struct
 */

#define CP_PERFMON_CNTL_PERFMON_STATE_SIZE 4
#define CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_SIZE 2

#define CP_PERFMON_CNTL_PERFMON_STATE_SHIFT 0
#define CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_SHIFT 8

#define CP_PERFMON_CNTL_PERFMON_STATE_MASK 0x0000000f
#define CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_MASK 0x00000300

#define CP_PERFMON_CNTL_MASK \
     (CP_PERFMON_CNTL_PERFMON_STATE_MASK | \
      CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_MASK)

#define CP_PERFMON_CNTL(perfmon_state, perfmon_enable_mode) \
     ((perfmon_state << CP_PERFMON_CNTL_PERFMON_STATE_SHIFT) | \
      (perfmon_enable_mode << CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_SHIFT))

#define CP_PERFMON_CNTL_GET_PERFMON_STATE(cp_perfmon_cntl) \
     ((cp_perfmon_cntl & CP_PERFMON_CNTL_PERFMON_STATE_MASK) >> CP_PERFMON_CNTL_PERFMON_STATE_SHIFT)
#define CP_PERFMON_CNTL_GET_PERFMON_ENABLE_MODE(cp_perfmon_cntl) \
     ((cp_perfmon_cntl & CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_MASK) >> CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_SHIFT)

#define CP_PERFMON_CNTL_SET_PERFMON_STATE(cp_perfmon_cntl_reg, perfmon_state) \
     cp_perfmon_cntl_reg = (cp_perfmon_cntl_reg & ~CP_PERFMON_CNTL_PERFMON_STATE_MASK) | (perfmon_state << CP_PERFMON_CNTL_PERFMON_STATE_SHIFT)
#define CP_PERFMON_CNTL_SET_PERFMON_ENABLE_MODE(cp_perfmon_cntl_reg, perfmon_enable_mode) \
     cp_perfmon_cntl_reg = (cp_perfmon_cntl_reg & ~CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_MASK) | (perfmon_enable_mode << CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_perfmon_cntl_t {
          unsigned int perfmon_state                  : CP_PERFMON_CNTL_PERFMON_STATE_SIZE;
          unsigned int                                : 4;
          unsigned int perfmon_enable_mode            : CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_SIZE;
          unsigned int                                : 22;
     } cp_perfmon_cntl_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_perfmon_cntl_t {
          unsigned int                                : 22;
          unsigned int perfmon_enable_mode            : CP_PERFMON_CNTL_PERFMON_ENABLE_MODE_SIZE;
          unsigned int                                : 4;
          unsigned int perfmon_state                  : CP_PERFMON_CNTL_PERFMON_STATE_SIZE;
     } cp_perfmon_cntl_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_perfmon_cntl_t f;
} cp_perfmon_cntl_u;


/*
 * CP_PERFCOUNTER_SELECT struct
 */

#define CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_SIZE 6

#define CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_SHIFT 0

#define CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_MASK 0x0000003f

#define CP_PERFCOUNTER_SELECT_MASK \
     (CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_MASK)

#define CP_PERFCOUNTER_SELECT(perfcount_sel) \
     ((perfcount_sel << CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_SHIFT))

#define CP_PERFCOUNTER_SELECT_GET_PERFCOUNT_SEL(cp_perfcounter_select) \
     ((cp_perfcounter_select & CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_MASK) >> CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_SHIFT)

#define CP_PERFCOUNTER_SELECT_SET_PERFCOUNT_SEL(cp_perfcounter_select_reg, perfcount_sel) \
     cp_perfcounter_select_reg = (cp_perfcounter_select_reg & ~CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_MASK) | (perfcount_sel << CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_perfcounter_select_t {
          unsigned int perfcount_sel                  : CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_SIZE;
          unsigned int                                : 26;
     } cp_perfcounter_select_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_perfcounter_select_t {
          unsigned int                                : 26;
          unsigned int perfcount_sel                  : CP_PERFCOUNTER_SELECT_PERFCOUNT_SEL_SIZE;
     } cp_perfcounter_select_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_perfcounter_select_t f;
} cp_perfcounter_select_u;


/*
 * CP_PERFCOUNTER_LO struct
 */

#define CP_PERFCOUNTER_LO_PERFCOUNT_LO_SIZE 32

#define CP_PERFCOUNTER_LO_PERFCOUNT_LO_SHIFT 0

#define CP_PERFCOUNTER_LO_PERFCOUNT_LO_MASK 0xffffffff

#define CP_PERFCOUNTER_LO_MASK \
     (CP_PERFCOUNTER_LO_PERFCOUNT_LO_MASK)

#define CP_PERFCOUNTER_LO(perfcount_lo) \
     ((perfcount_lo << CP_PERFCOUNTER_LO_PERFCOUNT_LO_SHIFT))

#define CP_PERFCOUNTER_LO_GET_PERFCOUNT_LO(cp_perfcounter_lo) \
     ((cp_perfcounter_lo & CP_PERFCOUNTER_LO_PERFCOUNT_LO_MASK) >> CP_PERFCOUNTER_LO_PERFCOUNT_LO_SHIFT)

#define CP_PERFCOUNTER_LO_SET_PERFCOUNT_LO(cp_perfcounter_lo_reg, perfcount_lo) \
     cp_perfcounter_lo_reg = (cp_perfcounter_lo_reg & ~CP_PERFCOUNTER_LO_PERFCOUNT_LO_MASK) | (perfcount_lo << CP_PERFCOUNTER_LO_PERFCOUNT_LO_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_perfcounter_lo_t {
          unsigned int perfcount_lo                   : CP_PERFCOUNTER_LO_PERFCOUNT_LO_SIZE;
     } cp_perfcounter_lo_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_perfcounter_lo_t {
          unsigned int perfcount_lo                   : CP_PERFCOUNTER_LO_PERFCOUNT_LO_SIZE;
     } cp_perfcounter_lo_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_perfcounter_lo_t f;
} cp_perfcounter_lo_u;


/*
 * CP_PERFCOUNTER_HI struct
 */

#define CP_PERFCOUNTER_HI_PERFCOUNT_HI_SIZE 16

#define CP_PERFCOUNTER_HI_PERFCOUNT_HI_SHIFT 0

#define CP_PERFCOUNTER_HI_PERFCOUNT_HI_MASK 0x0000ffff

#define CP_PERFCOUNTER_HI_MASK \
     (CP_PERFCOUNTER_HI_PERFCOUNT_HI_MASK)

#define CP_PERFCOUNTER_HI(perfcount_hi) \
     ((perfcount_hi << CP_PERFCOUNTER_HI_PERFCOUNT_HI_SHIFT))

#define CP_PERFCOUNTER_HI_GET_PERFCOUNT_HI(cp_perfcounter_hi) \
     ((cp_perfcounter_hi & CP_PERFCOUNTER_HI_PERFCOUNT_HI_MASK) >> CP_PERFCOUNTER_HI_PERFCOUNT_HI_SHIFT)

#define CP_PERFCOUNTER_HI_SET_PERFCOUNT_HI(cp_perfcounter_hi_reg, perfcount_hi) \
     cp_perfcounter_hi_reg = (cp_perfcounter_hi_reg & ~CP_PERFCOUNTER_HI_PERFCOUNT_HI_MASK) | (perfcount_hi << CP_PERFCOUNTER_HI_PERFCOUNT_HI_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_perfcounter_hi_t {
          unsigned int perfcount_hi                   : CP_PERFCOUNTER_HI_PERFCOUNT_HI_SIZE;
          unsigned int                                : 16;
     } cp_perfcounter_hi_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_perfcounter_hi_t {
          unsigned int                                : 16;
          unsigned int perfcount_hi                   : CP_PERFCOUNTER_HI_PERFCOUNT_HI_SIZE;
     } cp_perfcounter_hi_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_perfcounter_hi_t f;
} cp_perfcounter_hi_u;


/*
 * CP_BIN_MASK_LO struct
 */

#define CP_BIN_MASK_LO_BIN_MASK_LO_SIZE 32

#define CP_BIN_MASK_LO_BIN_MASK_LO_SHIFT 0

#define CP_BIN_MASK_LO_BIN_MASK_LO_MASK 0xffffffff

#define CP_BIN_MASK_LO_MASK \
     (CP_BIN_MASK_LO_BIN_MASK_LO_MASK)

#define CP_BIN_MASK_LO(bin_mask_lo) \
     ((bin_mask_lo << CP_BIN_MASK_LO_BIN_MASK_LO_SHIFT))

#define CP_BIN_MASK_LO_GET_BIN_MASK_LO(cp_bin_mask_lo) \
     ((cp_bin_mask_lo & CP_BIN_MASK_LO_BIN_MASK_LO_MASK) >> CP_BIN_MASK_LO_BIN_MASK_LO_SHIFT)

#define CP_BIN_MASK_LO_SET_BIN_MASK_LO(cp_bin_mask_lo_reg, bin_mask_lo) \
     cp_bin_mask_lo_reg = (cp_bin_mask_lo_reg & ~CP_BIN_MASK_LO_BIN_MASK_LO_MASK) | (bin_mask_lo << CP_BIN_MASK_LO_BIN_MASK_LO_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_bin_mask_lo_t {
          unsigned int bin_mask_lo                    : CP_BIN_MASK_LO_BIN_MASK_LO_SIZE;
     } cp_bin_mask_lo_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_bin_mask_lo_t {
          unsigned int bin_mask_lo                    : CP_BIN_MASK_LO_BIN_MASK_LO_SIZE;
     } cp_bin_mask_lo_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_bin_mask_lo_t f;
} cp_bin_mask_lo_u;


/*
 * CP_BIN_MASK_HI struct
 */

#define CP_BIN_MASK_HI_BIN_MASK_HI_SIZE 32

#define CP_BIN_MASK_HI_BIN_MASK_HI_SHIFT 0

#define CP_BIN_MASK_HI_BIN_MASK_HI_MASK 0xffffffff

#define CP_BIN_MASK_HI_MASK \
     (CP_BIN_MASK_HI_BIN_MASK_HI_MASK)

#define CP_BIN_MASK_HI(bin_mask_hi) \
     ((bin_mask_hi << CP_BIN_MASK_HI_BIN_MASK_HI_SHIFT))

#define CP_BIN_MASK_HI_GET_BIN_MASK_HI(cp_bin_mask_hi) \
     ((cp_bin_mask_hi & CP_BIN_MASK_HI_BIN_MASK_HI_MASK) >> CP_BIN_MASK_HI_BIN_MASK_HI_SHIFT)

#define CP_BIN_MASK_HI_SET_BIN_MASK_HI(cp_bin_mask_hi_reg, bin_mask_hi) \
     cp_bin_mask_hi_reg = (cp_bin_mask_hi_reg & ~CP_BIN_MASK_HI_BIN_MASK_HI_MASK) | (bin_mask_hi << CP_BIN_MASK_HI_BIN_MASK_HI_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_bin_mask_hi_t {
          unsigned int bin_mask_hi                    : CP_BIN_MASK_HI_BIN_MASK_HI_SIZE;
     } cp_bin_mask_hi_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_bin_mask_hi_t {
          unsigned int bin_mask_hi                    : CP_BIN_MASK_HI_BIN_MASK_HI_SIZE;
     } cp_bin_mask_hi_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_bin_mask_hi_t f;
} cp_bin_mask_hi_u;


/*
 * CP_BIN_SELECT_LO struct
 */

#define CP_BIN_SELECT_LO_BIN_SELECT_LO_SIZE 32

#define CP_BIN_SELECT_LO_BIN_SELECT_LO_SHIFT 0

#define CP_BIN_SELECT_LO_BIN_SELECT_LO_MASK 0xffffffff

#define CP_BIN_SELECT_LO_MASK \
     (CP_BIN_SELECT_LO_BIN_SELECT_LO_MASK)

#define CP_BIN_SELECT_LO(bin_select_lo) \
     ((bin_select_lo << CP_BIN_SELECT_LO_BIN_SELECT_LO_SHIFT))

#define CP_BIN_SELECT_LO_GET_BIN_SELECT_LO(cp_bin_select_lo) \
     ((cp_bin_select_lo & CP_BIN_SELECT_LO_BIN_SELECT_LO_MASK) >> CP_BIN_SELECT_LO_BIN_SELECT_LO_SHIFT)

#define CP_BIN_SELECT_LO_SET_BIN_SELECT_LO(cp_bin_select_lo_reg, bin_select_lo) \
     cp_bin_select_lo_reg = (cp_bin_select_lo_reg & ~CP_BIN_SELECT_LO_BIN_SELECT_LO_MASK) | (bin_select_lo << CP_BIN_SELECT_LO_BIN_SELECT_LO_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_bin_select_lo_t {
          unsigned int bin_select_lo                  : CP_BIN_SELECT_LO_BIN_SELECT_LO_SIZE;
     } cp_bin_select_lo_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_bin_select_lo_t {
          unsigned int bin_select_lo                  : CP_BIN_SELECT_LO_BIN_SELECT_LO_SIZE;
     } cp_bin_select_lo_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_bin_select_lo_t f;
} cp_bin_select_lo_u;


/*
 * CP_BIN_SELECT_HI struct
 */

#define CP_BIN_SELECT_HI_BIN_SELECT_HI_SIZE 32

#define CP_BIN_SELECT_HI_BIN_SELECT_HI_SHIFT 0

#define CP_BIN_SELECT_HI_BIN_SELECT_HI_MASK 0xffffffff

#define CP_BIN_SELECT_HI_MASK \
     (CP_BIN_SELECT_HI_BIN_SELECT_HI_MASK)

#define CP_BIN_SELECT_HI(bin_select_hi) \
     ((bin_select_hi << CP_BIN_SELECT_HI_BIN_SELECT_HI_SHIFT))

#define CP_BIN_SELECT_HI_GET_BIN_SELECT_HI(cp_bin_select_hi) \
     ((cp_bin_select_hi & CP_BIN_SELECT_HI_BIN_SELECT_HI_MASK) >> CP_BIN_SELECT_HI_BIN_SELECT_HI_SHIFT)

#define CP_BIN_SELECT_HI_SET_BIN_SELECT_HI(cp_bin_select_hi_reg, bin_select_hi) \
     cp_bin_select_hi_reg = (cp_bin_select_hi_reg & ~CP_BIN_SELECT_HI_BIN_SELECT_HI_MASK) | (bin_select_hi << CP_BIN_SELECT_HI_BIN_SELECT_HI_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_bin_select_hi_t {
          unsigned int bin_select_hi                  : CP_BIN_SELECT_HI_BIN_SELECT_HI_SIZE;
     } cp_bin_select_hi_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_bin_select_hi_t {
          unsigned int bin_select_hi                  : CP_BIN_SELECT_HI_BIN_SELECT_HI_SIZE;
     } cp_bin_select_hi_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_bin_select_hi_t f;
} cp_bin_select_hi_u;


/*
 * CP_NV_FLAGS_0 struct
 */

#define CP_NV_FLAGS_0_DISCARD_0_SIZE   1
#define CP_NV_FLAGS_0_END_RCVD_0_SIZE  1
#define CP_NV_FLAGS_0_DISCARD_1_SIZE   1
#define CP_NV_FLAGS_0_END_RCVD_1_SIZE  1
#define CP_NV_FLAGS_0_DISCARD_2_SIZE   1
#define CP_NV_FLAGS_0_END_RCVD_2_SIZE  1
#define CP_NV_FLAGS_0_DISCARD_3_SIZE   1
#define CP_NV_FLAGS_0_END_RCVD_3_SIZE  1
#define CP_NV_FLAGS_0_DISCARD_4_SIZE   1
#define CP_NV_FLAGS_0_END_RCVD_4_SIZE  1
#define CP_NV_FLAGS_0_DISCARD_5_SIZE   1
#define CP_NV_FLAGS_0_END_RCVD_5_SIZE  1
#define CP_NV_FLAGS_0_DISCARD_6_SIZE   1
#define CP_NV_FLAGS_0_END_RCVD_6_SIZE  1
#define CP_NV_FLAGS_0_DISCARD_7_SIZE   1
#define CP_NV_FLAGS_0_END_RCVD_7_SIZE  1
#define CP_NV_FLAGS_0_DISCARD_8_SIZE   1
#define CP_NV_FLAGS_0_END_RCVD_8_SIZE  1
#define CP_NV_FLAGS_0_DISCARD_9_SIZE   1
#define CP_NV_FLAGS_0_END_RCVD_9_SIZE  1
#define CP_NV_FLAGS_0_DISCARD_10_SIZE  1
#define CP_NV_FLAGS_0_END_RCVD_10_SIZE 1
#define CP_NV_FLAGS_0_DISCARD_11_SIZE  1
#define CP_NV_FLAGS_0_END_RCVD_11_SIZE 1
#define CP_NV_FLAGS_0_DISCARD_12_SIZE  1
#define CP_NV_FLAGS_0_END_RCVD_12_SIZE 1
#define CP_NV_FLAGS_0_DISCARD_13_SIZE  1
#define CP_NV_FLAGS_0_END_RCVD_13_SIZE 1
#define CP_NV_FLAGS_0_DISCARD_14_SIZE  1
#define CP_NV_FLAGS_0_END_RCVD_14_SIZE 1
#define CP_NV_FLAGS_0_DISCARD_15_SIZE  1
#define CP_NV_FLAGS_0_END_RCVD_15_SIZE 1

#define CP_NV_FLAGS_0_DISCARD_0_SHIFT  0
#define CP_NV_FLAGS_0_END_RCVD_0_SHIFT 1
#define CP_NV_FLAGS_0_DISCARD_1_SHIFT  2
#define CP_NV_FLAGS_0_END_RCVD_1_SHIFT 3
#define CP_NV_FLAGS_0_DISCARD_2_SHIFT  4
#define CP_NV_FLAGS_0_END_RCVD_2_SHIFT 5
#define CP_NV_FLAGS_0_DISCARD_3_SHIFT  6
#define CP_NV_FLAGS_0_END_RCVD_3_SHIFT 7
#define CP_NV_FLAGS_0_DISCARD_4_SHIFT  8
#define CP_NV_FLAGS_0_END_RCVD_4_SHIFT 9
#define CP_NV_FLAGS_0_DISCARD_5_SHIFT  10
#define CP_NV_FLAGS_0_END_RCVD_5_SHIFT 11
#define CP_NV_FLAGS_0_DISCARD_6_SHIFT  12
#define CP_NV_FLAGS_0_END_RCVD_6_SHIFT 13
#define CP_NV_FLAGS_0_DISCARD_7_SHIFT  14
#define CP_NV_FLAGS_0_END_RCVD_7_SHIFT 15
#define CP_NV_FLAGS_0_DISCARD_8_SHIFT  16
#define CP_NV_FLAGS_0_END_RCVD_8_SHIFT 17
#define CP_NV_FLAGS_0_DISCARD_9_SHIFT  18
#define CP_NV_FLAGS_0_END_RCVD_9_SHIFT 19
#define CP_NV_FLAGS_0_DISCARD_10_SHIFT 20
#define CP_NV_FLAGS_0_END_RCVD_10_SHIFT 21
#define CP_NV_FLAGS_0_DISCARD_11_SHIFT 22
#define CP_NV_FLAGS_0_END_RCVD_11_SHIFT 23
#define CP_NV_FLAGS_0_DISCARD_12_SHIFT 24
#define CP_NV_FLAGS_0_END_RCVD_12_SHIFT 25
#define CP_NV_FLAGS_0_DISCARD_13_SHIFT 26
#define CP_NV_FLAGS_0_END_RCVD_13_SHIFT 27
#define CP_NV_FLAGS_0_DISCARD_14_SHIFT 28
#define CP_NV_FLAGS_0_END_RCVD_14_SHIFT 29
#define CP_NV_FLAGS_0_DISCARD_15_SHIFT 30
#define CP_NV_FLAGS_0_END_RCVD_15_SHIFT 31

#define CP_NV_FLAGS_0_DISCARD_0_MASK   0x00000001
#define CP_NV_FLAGS_0_END_RCVD_0_MASK  0x00000002
#define CP_NV_FLAGS_0_DISCARD_1_MASK   0x00000004
#define CP_NV_FLAGS_0_END_RCVD_1_MASK  0x00000008
#define CP_NV_FLAGS_0_DISCARD_2_MASK   0x00000010
#define CP_NV_FLAGS_0_END_RCVD_2_MASK  0x00000020
#define CP_NV_FLAGS_0_DISCARD_3_MASK   0x00000040
#define CP_NV_FLAGS_0_END_RCVD_3_MASK  0x00000080
#define CP_NV_FLAGS_0_DISCARD_4_MASK   0x00000100
#define CP_NV_FLAGS_0_END_RCVD_4_MASK  0x00000200
#define CP_NV_FLAGS_0_DISCARD_5_MASK   0x00000400
#define CP_NV_FLAGS_0_END_RCVD_5_MASK  0x00000800
#define CP_NV_FLAGS_0_DISCARD_6_MASK   0x00001000
#define CP_NV_FLAGS_0_END_RCVD_6_MASK  0x00002000
#define CP_NV_FLAGS_0_DISCARD_7_MASK   0x00004000
#define CP_NV_FLAGS_0_END_RCVD_7_MASK  0x00008000
#define CP_NV_FLAGS_0_DISCARD_8_MASK   0x00010000
#define CP_NV_FLAGS_0_END_RCVD_8_MASK  0x00020000
#define CP_NV_FLAGS_0_DISCARD_9_MASK   0x00040000
#define CP_NV_FLAGS_0_END_RCVD_9_MASK  0x00080000
#define CP_NV_FLAGS_0_DISCARD_10_MASK  0x00100000
#define CP_NV_FLAGS_0_END_RCVD_10_MASK 0x00200000
#define CP_NV_FLAGS_0_DISCARD_11_MASK  0x00400000
#define CP_NV_FLAGS_0_END_RCVD_11_MASK 0x00800000
#define CP_NV_FLAGS_0_DISCARD_12_MASK  0x01000000
#define CP_NV_FLAGS_0_END_RCVD_12_MASK 0x02000000
#define CP_NV_FLAGS_0_DISCARD_13_MASK  0x04000000
#define CP_NV_FLAGS_0_END_RCVD_13_MASK 0x08000000
#define CP_NV_FLAGS_0_DISCARD_14_MASK  0x10000000
#define CP_NV_FLAGS_0_END_RCVD_14_MASK 0x20000000
#define CP_NV_FLAGS_0_DISCARD_15_MASK  0x40000000
#define CP_NV_FLAGS_0_END_RCVD_15_MASK 0x80000000

#define CP_NV_FLAGS_0_MASK \
     (CP_NV_FLAGS_0_DISCARD_0_MASK | \
      CP_NV_FLAGS_0_END_RCVD_0_MASK | \
      CP_NV_FLAGS_0_DISCARD_1_MASK | \
      CP_NV_FLAGS_0_END_RCVD_1_MASK | \
      CP_NV_FLAGS_0_DISCARD_2_MASK | \
      CP_NV_FLAGS_0_END_RCVD_2_MASK | \
      CP_NV_FLAGS_0_DISCARD_3_MASK | \
      CP_NV_FLAGS_0_END_RCVD_3_MASK | \
      CP_NV_FLAGS_0_DISCARD_4_MASK | \
      CP_NV_FLAGS_0_END_RCVD_4_MASK | \
      CP_NV_FLAGS_0_DISCARD_5_MASK | \
      CP_NV_FLAGS_0_END_RCVD_5_MASK | \
      CP_NV_FLAGS_0_DISCARD_6_MASK | \
      CP_NV_FLAGS_0_END_RCVD_6_MASK | \
      CP_NV_FLAGS_0_DISCARD_7_MASK | \
      CP_NV_FLAGS_0_END_RCVD_7_MASK | \
      CP_NV_FLAGS_0_DISCARD_8_MASK | \
      CP_NV_FLAGS_0_END_RCVD_8_MASK | \
      CP_NV_FLAGS_0_DISCARD_9_MASK | \
      CP_NV_FLAGS_0_END_RCVD_9_MASK | \
      CP_NV_FLAGS_0_DISCARD_10_MASK | \
      CP_NV_FLAGS_0_END_RCVD_10_MASK | \
      CP_NV_FLAGS_0_DISCARD_11_MASK | \
      CP_NV_FLAGS_0_END_RCVD_11_MASK | \
      CP_NV_FLAGS_0_DISCARD_12_MASK | \
      CP_NV_FLAGS_0_END_RCVD_12_MASK | \
      CP_NV_FLAGS_0_DISCARD_13_MASK | \
      CP_NV_FLAGS_0_END_RCVD_13_MASK | \
      CP_NV_FLAGS_0_DISCARD_14_MASK | \
      CP_NV_FLAGS_0_END_RCVD_14_MASK | \
      CP_NV_FLAGS_0_DISCARD_15_MASK | \
      CP_NV_FLAGS_0_END_RCVD_15_MASK)

#define CP_NV_FLAGS_0(discard_0, end_rcvd_0, discard_1, end_rcvd_1, discard_2, end_rcvd_2, discard_3, end_rcvd_3, discard_4, end_rcvd_4, discard_5, end_rcvd_5, discard_6, end_rcvd_6, discard_7, end_rcvd_7, discard_8, end_rcvd_8, discard_9, end_rcvd_9, discard_10, end_rcvd_10, discard_11, end_rcvd_11, discard_12, end_rcvd_12, discard_13, end_rcvd_13, discard_14, end_rcvd_14, discard_15, end_rcvd_15) \
     ((discard_0 << CP_NV_FLAGS_0_DISCARD_0_SHIFT) | \
      (end_rcvd_0 << CP_NV_FLAGS_0_END_RCVD_0_SHIFT) | \
      (discard_1 << CP_NV_FLAGS_0_DISCARD_1_SHIFT) | \
      (end_rcvd_1 << CP_NV_FLAGS_0_END_RCVD_1_SHIFT) | \
      (discard_2 << CP_NV_FLAGS_0_DISCARD_2_SHIFT) | \
      (end_rcvd_2 << CP_NV_FLAGS_0_END_RCVD_2_SHIFT) | \
      (discard_3 << CP_NV_FLAGS_0_DISCARD_3_SHIFT) | \
      (end_rcvd_3 << CP_NV_FLAGS_0_END_RCVD_3_SHIFT) | \
      (discard_4 << CP_NV_FLAGS_0_DISCARD_4_SHIFT) | \
      (end_rcvd_4 << CP_NV_FLAGS_0_END_RCVD_4_SHIFT) | \
      (discard_5 << CP_NV_FLAGS_0_DISCARD_5_SHIFT) | \
      (end_rcvd_5 << CP_NV_FLAGS_0_END_RCVD_5_SHIFT) | \
      (discard_6 << CP_NV_FLAGS_0_DISCARD_6_SHIFT) | \
      (end_rcvd_6 << CP_NV_FLAGS_0_END_RCVD_6_SHIFT) | \
      (discard_7 << CP_NV_FLAGS_0_DISCARD_7_SHIFT) | \
      (end_rcvd_7 << CP_NV_FLAGS_0_END_RCVD_7_SHIFT) | \
      (discard_8 << CP_NV_FLAGS_0_DISCARD_8_SHIFT) | \
      (end_rcvd_8 << CP_NV_FLAGS_0_END_RCVD_8_SHIFT) | \
      (discard_9 << CP_NV_FLAGS_0_DISCARD_9_SHIFT) | \
      (end_rcvd_9 << CP_NV_FLAGS_0_END_RCVD_9_SHIFT) | \
      (discard_10 << CP_NV_FLAGS_0_DISCARD_10_SHIFT) | \
      (end_rcvd_10 << CP_NV_FLAGS_0_END_RCVD_10_SHIFT) | \
      (discard_11 << CP_NV_FLAGS_0_DISCARD_11_SHIFT) | \
      (end_rcvd_11 << CP_NV_FLAGS_0_END_RCVD_11_SHIFT) | \
      (discard_12 << CP_NV_FLAGS_0_DISCARD_12_SHIFT) | \
      (end_rcvd_12 << CP_NV_FLAGS_0_END_RCVD_12_SHIFT) | \
      (discard_13 << CP_NV_FLAGS_0_DISCARD_13_SHIFT) | \
      (end_rcvd_13 << CP_NV_FLAGS_0_END_RCVD_13_SHIFT) | \
      (discard_14 << CP_NV_FLAGS_0_DISCARD_14_SHIFT) | \
      (end_rcvd_14 << CP_NV_FLAGS_0_END_RCVD_14_SHIFT) | \
      (discard_15 << CP_NV_FLAGS_0_DISCARD_15_SHIFT) | \
      (end_rcvd_15 << CP_NV_FLAGS_0_END_RCVD_15_SHIFT))

#define CP_NV_FLAGS_0_GET_DISCARD_0(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_0_MASK) >> CP_NV_FLAGS_0_DISCARD_0_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_0(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_0_MASK) >> CP_NV_FLAGS_0_END_RCVD_0_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_1(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_1_MASK) >> CP_NV_FLAGS_0_DISCARD_1_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_1(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_1_MASK) >> CP_NV_FLAGS_0_END_RCVD_1_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_2(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_2_MASK) >> CP_NV_FLAGS_0_DISCARD_2_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_2(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_2_MASK) >> CP_NV_FLAGS_0_END_RCVD_2_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_3(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_3_MASK) >> CP_NV_FLAGS_0_DISCARD_3_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_3(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_3_MASK) >> CP_NV_FLAGS_0_END_RCVD_3_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_4(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_4_MASK) >> CP_NV_FLAGS_0_DISCARD_4_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_4(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_4_MASK) >> CP_NV_FLAGS_0_END_RCVD_4_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_5(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_5_MASK) >> CP_NV_FLAGS_0_DISCARD_5_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_5(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_5_MASK) >> CP_NV_FLAGS_0_END_RCVD_5_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_6(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_6_MASK) >> CP_NV_FLAGS_0_DISCARD_6_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_6(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_6_MASK) >> CP_NV_FLAGS_0_END_RCVD_6_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_7(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_7_MASK) >> CP_NV_FLAGS_0_DISCARD_7_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_7(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_7_MASK) >> CP_NV_FLAGS_0_END_RCVD_7_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_8(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_8_MASK) >> CP_NV_FLAGS_0_DISCARD_8_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_8(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_8_MASK) >> CP_NV_FLAGS_0_END_RCVD_8_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_9(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_9_MASK) >> CP_NV_FLAGS_0_DISCARD_9_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_9(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_9_MASK) >> CP_NV_FLAGS_0_END_RCVD_9_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_10(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_10_MASK) >> CP_NV_FLAGS_0_DISCARD_10_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_10(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_10_MASK) >> CP_NV_FLAGS_0_END_RCVD_10_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_11(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_11_MASK) >> CP_NV_FLAGS_0_DISCARD_11_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_11(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_11_MASK) >> CP_NV_FLAGS_0_END_RCVD_11_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_12(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_12_MASK) >> CP_NV_FLAGS_0_DISCARD_12_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_12(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_12_MASK) >> CP_NV_FLAGS_0_END_RCVD_12_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_13(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_13_MASK) >> CP_NV_FLAGS_0_DISCARD_13_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_13(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_13_MASK) >> CP_NV_FLAGS_0_END_RCVD_13_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_14(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_14_MASK) >> CP_NV_FLAGS_0_DISCARD_14_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_14(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_14_MASK) >> CP_NV_FLAGS_0_END_RCVD_14_SHIFT)
#define CP_NV_FLAGS_0_GET_DISCARD_15(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_DISCARD_15_MASK) >> CP_NV_FLAGS_0_DISCARD_15_SHIFT)
#define CP_NV_FLAGS_0_GET_END_RCVD_15(cp_nv_flags_0) \
     ((cp_nv_flags_0 & CP_NV_FLAGS_0_END_RCVD_15_MASK) >> CP_NV_FLAGS_0_END_RCVD_15_SHIFT)

#define CP_NV_FLAGS_0_SET_DISCARD_0(cp_nv_flags_0_reg, discard_0) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_0_MASK) | (discard_0 << CP_NV_FLAGS_0_DISCARD_0_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_0(cp_nv_flags_0_reg, end_rcvd_0) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_0_MASK) | (end_rcvd_0 << CP_NV_FLAGS_0_END_RCVD_0_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_1(cp_nv_flags_0_reg, discard_1) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_1_MASK) | (discard_1 << CP_NV_FLAGS_0_DISCARD_1_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_1(cp_nv_flags_0_reg, end_rcvd_1) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_1_MASK) | (end_rcvd_1 << CP_NV_FLAGS_0_END_RCVD_1_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_2(cp_nv_flags_0_reg, discard_2) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_2_MASK) | (discard_2 << CP_NV_FLAGS_0_DISCARD_2_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_2(cp_nv_flags_0_reg, end_rcvd_2) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_2_MASK) | (end_rcvd_2 << CP_NV_FLAGS_0_END_RCVD_2_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_3(cp_nv_flags_0_reg, discard_3) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_3_MASK) | (discard_3 << CP_NV_FLAGS_0_DISCARD_3_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_3(cp_nv_flags_0_reg, end_rcvd_3) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_3_MASK) | (end_rcvd_3 << CP_NV_FLAGS_0_END_RCVD_3_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_4(cp_nv_flags_0_reg, discard_4) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_4_MASK) | (discard_4 << CP_NV_FLAGS_0_DISCARD_4_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_4(cp_nv_flags_0_reg, end_rcvd_4) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_4_MASK) | (end_rcvd_4 << CP_NV_FLAGS_0_END_RCVD_4_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_5(cp_nv_flags_0_reg, discard_5) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_5_MASK) | (discard_5 << CP_NV_FLAGS_0_DISCARD_5_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_5(cp_nv_flags_0_reg, end_rcvd_5) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_5_MASK) | (end_rcvd_5 << CP_NV_FLAGS_0_END_RCVD_5_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_6(cp_nv_flags_0_reg, discard_6) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_6_MASK) | (discard_6 << CP_NV_FLAGS_0_DISCARD_6_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_6(cp_nv_flags_0_reg, end_rcvd_6) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_6_MASK) | (end_rcvd_6 << CP_NV_FLAGS_0_END_RCVD_6_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_7(cp_nv_flags_0_reg, discard_7) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_7_MASK) | (discard_7 << CP_NV_FLAGS_0_DISCARD_7_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_7(cp_nv_flags_0_reg, end_rcvd_7) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_7_MASK) | (end_rcvd_7 << CP_NV_FLAGS_0_END_RCVD_7_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_8(cp_nv_flags_0_reg, discard_8) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_8_MASK) | (discard_8 << CP_NV_FLAGS_0_DISCARD_8_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_8(cp_nv_flags_0_reg, end_rcvd_8) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_8_MASK) | (end_rcvd_8 << CP_NV_FLAGS_0_END_RCVD_8_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_9(cp_nv_flags_0_reg, discard_9) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_9_MASK) | (discard_9 << CP_NV_FLAGS_0_DISCARD_9_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_9(cp_nv_flags_0_reg, end_rcvd_9) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_9_MASK) | (end_rcvd_9 << CP_NV_FLAGS_0_END_RCVD_9_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_10(cp_nv_flags_0_reg, discard_10) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_10_MASK) | (discard_10 << CP_NV_FLAGS_0_DISCARD_10_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_10(cp_nv_flags_0_reg, end_rcvd_10) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_10_MASK) | (end_rcvd_10 << CP_NV_FLAGS_0_END_RCVD_10_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_11(cp_nv_flags_0_reg, discard_11) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_11_MASK) | (discard_11 << CP_NV_FLAGS_0_DISCARD_11_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_11(cp_nv_flags_0_reg, end_rcvd_11) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_11_MASK) | (end_rcvd_11 << CP_NV_FLAGS_0_END_RCVD_11_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_12(cp_nv_flags_0_reg, discard_12) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_12_MASK) | (discard_12 << CP_NV_FLAGS_0_DISCARD_12_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_12(cp_nv_flags_0_reg, end_rcvd_12) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_12_MASK) | (end_rcvd_12 << CP_NV_FLAGS_0_END_RCVD_12_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_13(cp_nv_flags_0_reg, discard_13) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_13_MASK) | (discard_13 << CP_NV_FLAGS_0_DISCARD_13_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_13(cp_nv_flags_0_reg, end_rcvd_13) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_13_MASK) | (end_rcvd_13 << CP_NV_FLAGS_0_END_RCVD_13_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_14(cp_nv_flags_0_reg, discard_14) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_14_MASK) | (discard_14 << CP_NV_FLAGS_0_DISCARD_14_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_14(cp_nv_flags_0_reg, end_rcvd_14) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_14_MASK) | (end_rcvd_14 << CP_NV_FLAGS_0_END_RCVD_14_SHIFT)
#define CP_NV_FLAGS_0_SET_DISCARD_15(cp_nv_flags_0_reg, discard_15) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_DISCARD_15_MASK) | (discard_15 << CP_NV_FLAGS_0_DISCARD_15_SHIFT)
#define CP_NV_FLAGS_0_SET_END_RCVD_15(cp_nv_flags_0_reg, end_rcvd_15) \
     cp_nv_flags_0_reg = (cp_nv_flags_0_reg & ~CP_NV_FLAGS_0_END_RCVD_15_MASK) | (end_rcvd_15 << CP_NV_FLAGS_0_END_RCVD_15_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_nv_flags_0_t {
          unsigned int discard_0                      : CP_NV_FLAGS_0_DISCARD_0_SIZE;
          unsigned int end_rcvd_0                     : CP_NV_FLAGS_0_END_RCVD_0_SIZE;
          unsigned int discard_1                      : CP_NV_FLAGS_0_DISCARD_1_SIZE;
          unsigned int end_rcvd_1                     : CP_NV_FLAGS_0_END_RCVD_1_SIZE;
          unsigned int discard_2                      : CP_NV_FLAGS_0_DISCARD_2_SIZE;
          unsigned int end_rcvd_2                     : CP_NV_FLAGS_0_END_RCVD_2_SIZE;
          unsigned int discard_3                      : CP_NV_FLAGS_0_DISCARD_3_SIZE;
          unsigned int end_rcvd_3                     : CP_NV_FLAGS_0_END_RCVD_3_SIZE;
          unsigned int discard_4                      : CP_NV_FLAGS_0_DISCARD_4_SIZE;
          unsigned int end_rcvd_4                     : CP_NV_FLAGS_0_END_RCVD_4_SIZE;
          unsigned int discard_5                      : CP_NV_FLAGS_0_DISCARD_5_SIZE;
          unsigned int end_rcvd_5                     : CP_NV_FLAGS_0_END_RCVD_5_SIZE;
          unsigned int discard_6                      : CP_NV_FLAGS_0_DISCARD_6_SIZE;
          unsigned int end_rcvd_6                     : CP_NV_FLAGS_0_END_RCVD_6_SIZE;
          unsigned int discard_7                      : CP_NV_FLAGS_0_DISCARD_7_SIZE;
          unsigned int end_rcvd_7                     : CP_NV_FLAGS_0_END_RCVD_7_SIZE;
          unsigned int discard_8                      : CP_NV_FLAGS_0_DISCARD_8_SIZE;
          unsigned int end_rcvd_8                     : CP_NV_FLAGS_0_END_RCVD_8_SIZE;
          unsigned int discard_9                      : CP_NV_FLAGS_0_DISCARD_9_SIZE;
          unsigned int end_rcvd_9                     : CP_NV_FLAGS_0_END_RCVD_9_SIZE;
          unsigned int discard_10                     : CP_NV_FLAGS_0_DISCARD_10_SIZE;
          unsigned int end_rcvd_10                    : CP_NV_FLAGS_0_END_RCVD_10_SIZE;
          unsigned int discard_11                     : CP_NV_FLAGS_0_DISCARD_11_SIZE;
          unsigned int end_rcvd_11                    : CP_NV_FLAGS_0_END_RCVD_11_SIZE;
          unsigned int discard_12                     : CP_NV_FLAGS_0_DISCARD_12_SIZE;
          unsigned int end_rcvd_12                    : CP_NV_FLAGS_0_END_RCVD_12_SIZE;
          unsigned int discard_13                     : CP_NV_FLAGS_0_DISCARD_13_SIZE;
          unsigned int end_rcvd_13                    : CP_NV_FLAGS_0_END_RCVD_13_SIZE;
          unsigned int discard_14                     : CP_NV_FLAGS_0_DISCARD_14_SIZE;
          unsigned int end_rcvd_14                    : CP_NV_FLAGS_0_END_RCVD_14_SIZE;
          unsigned int discard_15                     : CP_NV_FLAGS_0_DISCARD_15_SIZE;
          unsigned int end_rcvd_15                    : CP_NV_FLAGS_0_END_RCVD_15_SIZE;
     } cp_nv_flags_0_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_nv_flags_0_t {
          unsigned int end_rcvd_15                    : CP_NV_FLAGS_0_END_RCVD_15_SIZE;
          unsigned int discard_15                     : CP_NV_FLAGS_0_DISCARD_15_SIZE;
          unsigned int end_rcvd_14                    : CP_NV_FLAGS_0_END_RCVD_14_SIZE;
          unsigned int discard_14                     : CP_NV_FLAGS_0_DISCARD_14_SIZE;
          unsigned int end_rcvd_13                    : CP_NV_FLAGS_0_END_RCVD_13_SIZE;
          unsigned int discard_13                     : CP_NV_FLAGS_0_DISCARD_13_SIZE;
          unsigned int end_rcvd_12                    : CP_NV_FLAGS_0_END_RCVD_12_SIZE;
          unsigned int discard_12                     : CP_NV_FLAGS_0_DISCARD_12_SIZE;
          unsigned int end_rcvd_11                    : CP_NV_FLAGS_0_END_RCVD_11_SIZE;
          unsigned int discard_11                     : CP_NV_FLAGS_0_DISCARD_11_SIZE;
          unsigned int end_rcvd_10                    : CP_NV_FLAGS_0_END_RCVD_10_SIZE;
          unsigned int discard_10                     : CP_NV_FLAGS_0_DISCARD_10_SIZE;
          unsigned int end_rcvd_9                     : CP_NV_FLAGS_0_END_RCVD_9_SIZE;
          unsigned int discard_9                      : CP_NV_FLAGS_0_DISCARD_9_SIZE;
          unsigned int end_rcvd_8                     : CP_NV_FLAGS_0_END_RCVD_8_SIZE;
          unsigned int discard_8                      : CP_NV_FLAGS_0_DISCARD_8_SIZE;
          unsigned int end_rcvd_7                     : CP_NV_FLAGS_0_END_RCVD_7_SIZE;
          unsigned int discard_7                      : CP_NV_FLAGS_0_DISCARD_7_SIZE;
          unsigned int end_rcvd_6                     : CP_NV_FLAGS_0_END_RCVD_6_SIZE;
          unsigned int discard_6                      : CP_NV_FLAGS_0_DISCARD_6_SIZE;
          unsigned int end_rcvd_5                     : CP_NV_FLAGS_0_END_RCVD_5_SIZE;
          unsigned int discard_5                      : CP_NV_FLAGS_0_DISCARD_5_SIZE;
          unsigned int end_rcvd_4                     : CP_NV_FLAGS_0_END_RCVD_4_SIZE;
          unsigned int discard_4                      : CP_NV_FLAGS_0_DISCARD_4_SIZE;
          unsigned int end_rcvd_3                     : CP_NV_FLAGS_0_END_RCVD_3_SIZE;
          unsigned int discard_3                      : CP_NV_FLAGS_0_DISCARD_3_SIZE;
          unsigned int end_rcvd_2                     : CP_NV_FLAGS_0_END_RCVD_2_SIZE;
          unsigned int discard_2                      : CP_NV_FLAGS_0_DISCARD_2_SIZE;
          unsigned int end_rcvd_1                     : CP_NV_FLAGS_0_END_RCVD_1_SIZE;
          unsigned int discard_1                      : CP_NV_FLAGS_0_DISCARD_1_SIZE;
          unsigned int end_rcvd_0                     : CP_NV_FLAGS_0_END_RCVD_0_SIZE;
          unsigned int discard_0                      : CP_NV_FLAGS_0_DISCARD_0_SIZE;
     } cp_nv_flags_0_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_nv_flags_0_t f;
} cp_nv_flags_0_u;


/*
 * CP_NV_FLAGS_1 struct
 */

#define CP_NV_FLAGS_1_DISCARD_16_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_16_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_17_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_17_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_18_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_18_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_19_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_19_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_20_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_20_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_21_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_21_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_22_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_22_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_23_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_23_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_24_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_24_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_25_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_25_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_26_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_26_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_27_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_27_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_28_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_28_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_29_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_29_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_30_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_30_SIZE 1
#define CP_NV_FLAGS_1_DISCARD_31_SIZE  1
#define CP_NV_FLAGS_1_END_RCVD_31_SIZE 1

#define CP_NV_FLAGS_1_DISCARD_16_SHIFT 0
#define CP_NV_FLAGS_1_END_RCVD_16_SHIFT 1
#define CP_NV_FLAGS_1_DISCARD_17_SHIFT 2
#define CP_NV_FLAGS_1_END_RCVD_17_SHIFT 3
#define CP_NV_FLAGS_1_DISCARD_18_SHIFT 4
#define CP_NV_FLAGS_1_END_RCVD_18_SHIFT 5
#define CP_NV_FLAGS_1_DISCARD_19_SHIFT 6
#define CP_NV_FLAGS_1_END_RCVD_19_SHIFT 7
#define CP_NV_FLAGS_1_DISCARD_20_SHIFT 8
#define CP_NV_FLAGS_1_END_RCVD_20_SHIFT 9
#define CP_NV_FLAGS_1_DISCARD_21_SHIFT 10
#define CP_NV_FLAGS_1_END_RCVD_21_SHIFT 11
#define CP_NV_FLAGS_1_DISCARD_22_SHIFT 12
#define CP_NV_FLAGS_1_END_RCVD_22_SHIFT 13
#define CP_NV_FLAGS_1_DISCARD_23_SHIFT 14
#define CP_NV_FLAGS_1_END_RCVD_23_SHIFT 15
#define CP_NV_FLAGS_1_DISCARD_24_SHIFT 16
#define CP_NV_FLAGS_1_END_RCVD_24_SHIFT 17
#define CP_NV_FLAGS_1_DISCARD_25_SHIFT 18
#define CP_NV_FLAGS_1_END_RCVD_25_SHIFT 19
#define CP_NV_FLAGS_1_DISCARD_26_SHIFT 20
#define CP_NV_FLAGS_1_END_RCVD_26_SHIFT 21
#define CP_NV_FLAGS_1_DISCARD_27_SHIFT 22
#define CP_NV_FLAGS_1_END_RCVD_27_SHIFT 23
#define CP_NV_FLAGS_1_DISCARD_28_SHIFT 24
#define CP_NV_FLAGS_1_END_RCVD_28_SHIFT 25
#define CP_NV_FLAGS_1_DISCARD_29_SHIFT 26
#define CP_NV_FLAGS_1_END_RCVD_29_SHIFT 27
#define CP_NV_FLAGS_1_DISCARD_30_SHIFT 28
#define CP_NV_FLAGS_1_END_RCVD_30_SHIFT 29
#define CP_NV_FLAGS_1_DISCARD_31_SHIFT 30
#define CP_NV_FLAGS_1_END_RCVD_31_SHIFT 31

#define CP_NV_FLAGS_1_DISCARD_16_MASK  0x00000001
#define CP_NV_FLAGS_1_END_RCVD_16_MASK 0x00000002
#define CP_NV_FLAGS_1_DISCARD_17_MASK  0x00000004
#define CP_NV_FLAGS_1_END_RCVD_17_MASK 0x00000008
#define CP_NV_FLAGS_1_DISCARD_18_MASK  0x00000010
#define CP_NV_FLAGS_1_END_RCVD_18_MASK 0x00000020
#define CP_NV_FLAGS_1_DISCARD_19_MASK  0x00000040
#define CP_NV_FLAGS_1_END_RCVD_19_MASK 0x00000080
#define CP_NV_FLAGS_1_DISCARD_20_MASK  0x00000100
#define CP_NV_FLAGS_1_END_RCVD_20_MASK 0x00000200
#define CP_NV_FLAGS_1_DISCARD_21_MASK  0x00000400
#define CP_NV_FLAGS_1_END_RCVD_21_MASK 0x00000800
#define CP_NV_FLAGS_1_DISCARD_22_MASK  0x00001000
#define CP_NV_FLAGS_1_END_RCVD_22_MASK 0x00002000
#define CP_NV_FLAGS_1_DISCARD_23_MASK  0x00004000
#define CP_NV_FLAGS_1_END_RCVD_23_MASK 0x00008000
#define CP_NV_FLAGS_1_DISCARD_24_MASK  0x00010000
#define CP_NV_FLAGS_1_END_RCVD_24_MASK 0x00020000
#define CP_NV_FLAGS_1_DISCARD_25_MASK  0x00040000
#define CP_NV_FLAGS_1_END_RCVD_25_MASK 0x00080000
#define CP_NV_FLAGS_1_DISCARD_26_MASK  0x00100000
#define CP_NV_FLAGS_1_END_RCVD_26_MASK 0x00200000
#define CP_NV_FLAGS_1_DISCARD_27_MASK  0x00400000
#define CP_NV_FLAGS_1_END_RCVD_27_MASK 0x00800000
#define CP_NV_FLAGS_1_DISCARD_28_MASK  0x01000000
#define CP_NV_FLAGS_1_END_RCVD_28_MASK 0x02000000
#define CP_NV_FLAGS_1_DISCARD_29_MASK  0x04000000
#define CP_NV_FLAGS_1_END_RCVD_29_MASK 0x08000000
#define CP_NV_FLAGS_1_DISCARD_30_MASK  0x10000000
#define CP_NV_FLAGS_1_END_RCVD_30_MASK 0x20000000
#define CP_NV_FLAGS_1_DISCARD_31_MASK  0x40000000
#define CP_NV_FLAGS_1_END_RCVD_31_MASK 0x80000000

#define CP_NV_FLAGS_1_MASK \
     (CP_NV_FLAGS_1_DISCARD_16_MASK | \
      CP_NV_FLAGS_1_END_RCVD_16_MASK | \
      CP_NV_FLAGS_1_DISCARD_17_MASK | \
      CP_NV_FLAGS_1_END_RCVD_17_MASK | \
      CP_NV_FLAGS_1_DISCARD_18_MASK | \
      CP_NV_FLAGS_1_END_RCVD_18_MASK | \
      CP_NV_FLAGS_1_DISCARD_19_MASK | \
      CP_NV_FLAGS_1_END_RCVD_19_MASK | \
      CP_NV_FLAGS_1_DISCARD_20_MASK | \
      CP_NV_FLAGS_1_END_RCVD_20_MASK | \
      CP_NV_FLAGS_1_DISCARD_21_MASK | \
      CP_NV_FLAGS_1_END_RCVD_21_MASK | \
      CP_NV_FLAGS_1_DISCARD_22_MASK | \
      CP_NV_FLAGS_1_END_RCVD_22_MASK | \
      CP_NV_FLAGS_1_DISCARD_23_MASK | \
      CP_NV_FLAGS_1_END_RCVD_23_MASK | \
      CP_NV_FLAGS_1_DISCARD_24_MASK | \
      CP_NV_FLAGS_1_END_RCVD_24_MASK | \
      CP_NV_FLAGS_1_DISCARD_25_MASK | \
      CP_NV_FLAGS_1_END_RCVD_25_MASK | \
      CP_NV_FLAGS_1_DISCARD_26_MASK | \
      CP_NV_FLAGS_1_END_RCVD_26_MASK | \
      CP_NV_FLAGS_1_DISCARD_27_MASK | \
      CP_NV_FLAGS_1_END_RCVD_27_MASK | \
      CP_NV_FLAGS_1_DISCARD_28_MASK | \
      CP_NV_FLAGS_1_END_RCVD_28_MASK | \
      CP_NV_FLAGS_1_DISCARD_29_MASK | \
      CP_NV_FLAGS_1_END_RCVD_29_MASK | \
      CP_NV_FLAGS_1_DISCARD_30_MASK | \
      CP_NV_FLAGS_1_END_RCVD_30_MASK | \
      CP_NV_FLAGS_1_DISCARD_31_MASK | \
      CP_NV_FLAGS_1_END_RCVD_31_MASK)

#define CP_NV_FLAGS_1(discard_16, end_rcvd_16, discard_17, end_rcvd_17, discard_18, end_rcvd_18, discard_19, end_rcvd_19, discard_20, end_rcvd_20, discard_21, end_rcvd_21, discard_22, end_rcvd_22, discard_23, end_rcvd_23, discard_24, end_rcvd_24, discard_25, end_rcvd_25, discard_26, end_rcvd_26, discard_27, end_rcvd_27, discard_28, end_rcvd_28, discard_29, end_rcvd_29, discard_30, end_rcvd_30, discard_31, end_rcvd_31) \
     ((discard_16 << CP_NV_FLAGS_1_DISCARD_16_SHIFT) | \
      (end_rcvd_16 << CP_NV_FLAGS_1_END_RCVD_16_SHIFT) | \
      (discard_17 << CP_NV_FLAGS_1_DISCARD_17_SHIFT) | \
      (end_rcvd_17 << CP_NV_FLAGS_1_END_RCVD_17_SHIFT) | \
      (discard_18 << CP_NV_FLAGS_1_DISCARD_18_SHIFT) | \
      (end_rcvd_18 << CP_NV_FLAGS_1_END_RCVD_18_SHIFT) | \
      (discard_19 << CP_NV_FLAGS_1_DISCARD_19_SHIFT) | \
      (end_rcvd_19 << CP_NV_FLAGS_1_END_RCVD_19_SHIFT) | \
      (discard_20 << CP_NV_FLAGS_1_DISCARD_20_SHIFT) | \
      (end_rcvd_20 << CP_NV_FLAGS_1_END_RCVD_20_SHIFT) | \
      (discard_21 << CP_NV_FLAGS_1_DISCARD_21_SHIFT) | \
      (end_rcvd_21 << CP_NV_FLAGS_1_END_RCVD_21_SHIFT) | \
      (discard_22 << CP_NV_FLAGS_1_DISCARD_22_SHIFT) | \
      (end_rcvd_22 << CP_NV_FLAGS_1_END_RCVD_22_SHIFT) | \
      (discard_23 << CP_NV_FLAGS_1_DISCARD_23_SHIFT) | \
      (end_rcvd_23 << CP_NV_FLAGS_1_END_RCVD_23_SHIFT) | \
      (discard_24 << CP_NV_FLAGS_1_DISCARD_24_SHIFT) | \
      (end_rcvd_24 << CP_NV_FLAGS_1_END_RCVD_24_SHIFT) | \
      (discard_25 << CP_NV_FLAGS_1_DISCARD_25_SHIFT) | \
      (end_rcvd_25 << CP_NV_FLAGS_1_END_RCVD_25_SHIFT) | \
      (discard_26 << CP_NV_FLAGS_1_DISCARD_26_SHIFT) | \
      (end_rcvd_26 << CP_NV_FLAGS_1_END_RCVD_26_SHIFT) | \
      (discard_27 << CP_NV_FLAGS_1_DISCARD_27_SHIFT) | \
      (end_rcvd_27 << CP_NV_FLAGS_1_END_RCVD_27_SHIFT) | \
      (discard_28 << CP_NV_FLAGS_1_DISCARD_28_SHIFT) | \
      (end_rcvd_28 << CP_NV_FLAGS_1_END_RCVD_28_SHIFT) | \
      (discard_29 << CP_NV_FLAGS_1_DISCARD_29_SHIFT) | \
      (end_rcvd_29 << CP_NV_FLAGS_1_END_RCVD_29_SHIFT) | \
      (discard_30 << CP_NV_FLAGS_1_DISCARD_30_SHIFT) | \
      (end_rcvd_30 << CP_NV_FLAGS_1_END_RCVD_30_SHIFT) | \
      (discard_31 << CP_NV_FLAGS_1_DISCARD_31_SHIFT) | \
      (end_rcvd_31 << CP_NV_FLAGS_1_END_RCVD_31_SHIFT))

#define CP_NV_FLAGS_1_GET_DISCARD_16(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_16_MASK) >> CP_NV_FLAGS_1_DISCARD_16_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_16(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_16_MASK) >> CP_NV_FLAGS_1_END_RCVD_16_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_17(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_17_MASK) >> CP_NV_FLAGS_1_DISCARD_17_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_17(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_17_MASK) >> CP_NV_FLAGS_1_END_RCVD_17_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_18(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_18_MASK) >> CP_NV_FLAGS_1_DISCARD_18_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_18(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_18_MASK) >> CP_NV_FLAGS_1_END_RCVD_18_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_19(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_19_MASK) >> CP_NV_FLAGS_1_DISCARD_19_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_19(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_19_MASK) >> CP_NV_FLAGS_1_END_RCVD_19_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_20(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_20_MASK) >> CP_NV_FLAGS_1_DISCARD_20_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_20(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_20_MASK) >> CP_NV_FLAGS_1_END_RCVD_20_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_21(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_21_MASK) >> CP_NV_FLAGS_1_DISCARD_21_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_21(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_21_MASK) >> CP_NV_FLAGS_1_END_RCVD_21_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_22(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_22_MASK) >> CP_NV_FLAGS_1_DISCARD_22_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_22(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_22_MASK) >> CP_NV_FLAGS_1_END_RCVD_22_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_23(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_23_MASK) >> CP_NV_FLAGS_1_DISCARD_23_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_23(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_23_MASK) >> CP_NV_FLAGS_1_END_RCVD_23_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_24(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_24_MASK) >> CP_NV_FLAGS_1_DISCARD_24_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_24(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_24_MASK) >> CP_NV_FLAGS_1_END_RCVD_24_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_25(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_25_MASK) >> CP_NV_FLAGS_1_DISCARD_25_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_25(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_25_MASK) >> CP_NV_FLAGS_1_END_RCVD_25_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_26(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_26_MASK) >> CP_NV_FLAGS_1_DISCARD_26_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_26(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_26_MASK) >> CP_NV_FLAGS_1_END_RCVD_26_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_27(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_27_MASK) >> CP_NV_FLAGS_1_DISCARD_27_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_27(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_27_MASK) >> CP_NV_FLAGS_1_END_RCVD_27_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_28(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_28_MASK) >> CP_NV_FLAGS_1_DISCARD_28_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_28(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_28_MASK) >> CP_NV_FLAGS_1_END_RCVD_28_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_29(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_29_MASK) >> CP_NV_FLAGS_1_DISCARD_29_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_29(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_29_MASK) >> CP_NV_FLAGS_1_END_RCVD_29_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_30(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_30_MASK) >> CP_NV_FLAGS_1_DISCARD_30_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_30(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_30_MASK) >> CP_NV_FLAGS_1_END_RCVD_30_SHIFT)
#define CP_NV_FLAGS_1_GET_DISCARD_31(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_DISCARD_31_MASK) >> CP_NV_FLAGS_1_DISCARD_31_SHIFT)
#define CP_NV_FLAGS_1_GET_END_RCVD_31(cp_nv_flags_1) \
     ((cp_nv_flags_1 & CP_NV_FLAGS_1_END_RCVD_31_MASK) >> CP_NV_FLAGS_1_END_RCVD_31_SHIFT)

#define CP_NV_FLAGS_1_SET_DISCARD_16(cp_nv_flags_1_reg, discard_16) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_16_MASK) | (discard_16 << CP_NV_FLAGS_1_DISCARD_16_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_16(cp_nv_flags_1_reg, end_rcvd_16) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_16_MASK) | (end_rcvd_16 << CP_NV_FLAGS_1_END_RCVD_16_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_17(cp_nv_flags_1_reg, discard_17) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_17_MASK) | (discard_17 << CP_NV_FLAGS_1_DISCARD_17_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_17(cp_nv_flags_1_reg, end_rcvd_17) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_17_MASK) | (end_rcvd_17 << CP_NV_FLAGS_1_END_RCVD_17_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_18(cp_nv_flags_1_reg, discard_18) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_18_MASK) | (discard_18 << CP_NV_FLAGS_1_DISCARD_18_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_18(cp_nv_flags_1_reg, end_rcvd_18) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_18_MASK) | (end_rcvd_18 << CP_NV_FLAGS_1_END_RCVD_18_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_19(cp_nv_flags_1_reg, discard_19) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_19_MASK) | (discard_19 << CP_NV_FLAGS_1_DISCARD_19_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_19(cp_nv_flags_1_reg, end_rcvd_19) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_19_MASK) | (end_rcvd_19 << CP_NV_FLAGS_1_END_RCVD_19_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_20(cp_nv_flags_1_reg, discard_20) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_20_MASK) | (discard_20 << CP_NV_FLAGS_1_DISCARD_20_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_20(cp_nv_flags_1_reg, end_rcvd_20) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_20_MASK) | (end_rcvd_20 << CP_NV_FLAGS_1_END_RCVD_20_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_21(cp_nv_flags_1_reg, discard_21) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_21_MASK) | (discard_21 << CP_NV_FLAGS_1_DISCARD_21_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_21(cp_nv_flags_1_reg, end_rcvd_21) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_21_MASK) | (end_rcvd_21 << CP_NV_FLAGS_1_END_RCVD_21_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_22(cp_nv_flags_1_reg, discard_22) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_22_MASK) | (discard_22 << CP_NV_FLAGS_1_DISCARD_22_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_22(cp_nv_flags_1_reg, end_rcvd_22) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_22_MASK) | (end_rcvd_22 << CP_NV_FLAGS_1_END_RCVD_22_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_23(cp_nv_flags_1_reg, discard_23) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_23_MASK) | (discard_23 << CP_NV_FLAGS_1_DISCARD_23_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_23(cp_nv_flags_1_reg, end_rcvd_23) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_23_MASK) | (end_rcvd_23 << CP_NV_FLAGS_1_END_RCVD_23_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_24(cp_nv_flags_1_reg, discard_24) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_24_MASK) | (discard_24 << CP_NV_FLAGS_1_DISCARD_24_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_24(cp_nv_flags_1_reg, end_rcvd_24) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_24_MASK) | (end_rcvd_24 << CP_NV_FLAGS_1_END_RCVD_24_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_25(cp_nv_flags_1_reg, discard_25) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_25_MASK) | (discard_25 << CP_NV_FLAGS_1_DISCARD_25_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_25(cp_nv_flags_1_reg, end_rcvd_25) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_25_MASK) | (end_rcvd_25 << CP_NV_FLAGS_1_END_RCVD_25_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_26(cp_nv_flags_1_reg, discard_26) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_26_MASK) | (discard_26 << CP_NV_FLAGS_1_DISCARD_26_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_26(cp_nv_flags_1_reg, end_rcvd_26) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_26_MASK) | (end_rcvd_26 << CP_NV_FLAGS_1_END_RCVD_26_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_27(cp_nv_flags_1_reg, discard_27) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_27_MASK) | (discard_27 << CP_NV_FLAGS_1_DISCARD_27_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_27(cp_nv_flags_1_reg, end_rcvd_27) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_27_MASK) | (end_rcvd_27 << CP_NV_FLAGS_1_END_RCVD_27_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_28(cp_nv_flags_1_reg, discard_28) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_28_MASK) | (discard_28 << CP_NV_FLAGS_1_DISCARD_28_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_28(cp_nv_flags_1_reg, end_rcvd_28) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_28_MASK) | (end_rcvd_28 << CP_NV_FLAGS_1_END_RCVD_28_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_29(cp_nv_flags_1_reg, discard_29) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_29_MASK) | (discard_29 << CP_NV_FLAGS_1_DISCARD_29_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_29(cp_nv_flags_1_reg, end_rcvd_29) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_29_MASK) | (end_rcvd_29 << CP_NV_FLAGS_1_END_RCVD_29_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_30(cp_nv_flags_1_reg, discard_30) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_30_MASK) | (discard_30 << CP_NV_FLAGS_1_DISCARD_30_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_30(cp_nv_flags_1_reg, end_rcvd_30) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_30_MASK) | (end_rcvd_30 << CP_NV_FLAGS_1_END_RCVD_30_SHIFT)
#define CP_NV_FLAGS_1_SET_DISCARD_31(cp_nv_flags_1_reg, discard_31) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_DISCARD_31_MASK) | (discard_31 << CP_NV_FLAGS_1_DISCARD_31_SHIFT)
#define CP_NV_FLAGS_1_SET_END_RCVD_31(cp_nv_flags_1_reg, end_rcvd_31) \
     cp_nv_flags_1_reg = (cp_nv_flags_1_reg & ~CP_NV_FLAGS_1_END_RCVD_31_MASK) | (end_rcvd_31 << CP_NV_FLAGS_1_END_RCVD_31_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_nv_flags_1_t {
          unsigned int discard_16                     : CP_NV_FLAGS_1_DISCARD_16_SIZE;
          unsigned int end_rcvd_16                    : CP_NV_FLAGS_1_END_RCVD_16_SIZE;
          unsigned int discard_17                     : CP_NV_FLAGS_1_DISCARD_17_SIZE;
          unsigned int end_rcvd_17                    : CP_NV_FLAGS_1_END_RCVD_17_SIZE;
          unsigned int discard_18                     : CP_NV_FLAGS_1_DISCARD_18_SIZE;
          unsigned int end_rcvd_18                    : CP_NV_FLAGS_1_END_RCVD_18_SIZE;
          unsigned int discard_19                     : CP_NV_FLAGS_1_DISCARD_19_SIZE;
          unsigned int end_rcvd_19                    : CP_NV_FLAGS_1_END_RCVD_19_SIZE;
          unsigned int discard_20                     : CP_NV_FLAGS_1_DISCARD_20_SIZE;
          unsigned int end_rcvd_20                    : CP_NV_FLAGS_1_END_RCVD_20_SIZE;
          unsigned int discard_21                     : CP_NV_FLAGS_1_DISCARD_21_SIZE;
          unsigned int end_rcvd_21                    : CP_NV_FLAGS_1_END_RCVD_21_SIZE;
          unsigned int discard_22                     : CP_NV_FLAGS_1_DISCARD_22_SIZE;
          unsigned int end_rcvd_22                    : CP_NV_FLAGS_1_END_RCVD_22_SIZE;
          unsigned int discard_23                     : CP_NV_FLAGS_1_DISCARD_23_SIZE;
          unsigned int end_rcvd_23                    : CP_NV_FLAGS_1_END_RCVD_23_SIZE;
          unsigned int discard_24                     : CP_NV_FLAGS_1_DISCARD_24_SIZE;
          unsigned int end_rcvd_24                    : CP_NV_FLAGS_1_END_RCVD_24_SIZE;
          unsigned int discard_25                     : CP_NV_FLAGS_1_DISCARD_25_SIZE;
          unsigned int end_rcvd_25                    : CP_NV_FLAGS_1_END_RCVD_25_SIZE;
          unsigned int discard_26                     : CP_NV_FLAGS_1_DISCARD_26_SIZE;
          unsigned int end_rcvd_26                    : CP_NV_FLAGS_1_END_RCVD_26_SIZE;
          unsigned int discard_27                     : CP_NV_FLAGS_1_DISCARD_27_SIZE;
          unsigned int end_rcvd_27                    : CP_NV_FLAGS_1_END_RCVD_27_SIZE;
          unsigned int discard_28                     : CP_NV_FLAGS_1_DISCARD_28_SIZE;
          unsigned int end_rcvd_28                    : CP_NV_FLAGS_1_END_RCVD_28_SIZE;
          unsigned int discard_29                     : CP_NV_FLAGS_1_DISCARD_29_SIZE;
          unsigned int end_rcvd_29                    : CP_NV_FLAGS_1_END_RCVD_29_SIZE;
          unsigned int discard_30                     : CP_NV_FLAGS_1_DISCARD_30_SIZE;
          unsigned int end_rcvd_30                    : CP_NV_FLAGS_1_END_RCVD_30_SIZE;
          unsigned int discard_31                     : CP_NV_FLAGS_1_DISCARD_31_SIZE;
          unsigned int end_rcvd_31                    : CP_NV_FLAGS_1_END_RCVD_31_SIZE;
     } cp_nv_flags_1_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_nv_flags_1_t {
          unsigned int end_rcvd_31                    : CP_NV_FLAGS_1_END_RCVD_31_SIZE;
          unsigned int discard_31                     : CP_NV_FLAGS_1_DISCARD_31_SIZE;
          unsigned int end_rcvd_30                    : CP_NV_FLAGS_1_END_RCVD_30_SIZE;
          unsigned int discard_30                     : CP_NV_FLAGS_1_DISCARD_30_SIZE;
          unsigned int end_rcvd_29                    : CP_NV_FLAGS_1_END_RCVD_29_SIZE;
          unsigned int discard_29                     : CP_NV_FLAGS_1_DISCARD_29_SIZE;
          unsigned int end_rcvd_28                    : CP_NV_FLAGS_1_END_RCVD_28_SIZE;
          unsigned int discard_28                     : CP_NV_FLAGS_1_DISCARD_28_SIZE;
          unsigned int end_rcvd_27                    : CP_NV_FLAGS_1_END_RCVD_27_SIZE;
          unsigned int discard_27                     : CP_NV_FLAGS_1_DISCARD_27_SIZE;
          unsigned int end_rcvd_26                    : CP_NV_FLAGS_1_END_RCVD_26_SIZE;
          unsigned int discard_26                     : CP_NV_FLAGS_1_DISCARD_26_SIZE;
          unsigned int end_rcvd_25                    : CP_NV_FLAGS_1_END_RCVD_25_SIZE;
          unsigned int discard_25                     : CP_NV_FLAGS_1_DISCARD_25_SIZE;
          unsigned int end_rcvd_24                    : CP_NV_FLAGS_1_END_RCVD_24_SIZE;
          unsigned int discard_24                     : CP_NV_FLAGS_1_DISCARD_24_SIZE;
          unsigned int end_rcvd_23                    : CP_NV_FLAGS_1_END_RCVD_23_SIZE;
          unsigned int discard_23                     : CP_NV_FLAGS_1_DISCARD_23_SIZE;
          unsigned int end_rcvd_22                    : CP_NV_FLAGS_1_END_RCVD_22_SIZE;
          unsigned int discard_22                     : CP_NV_FLAGS_1_DISCARD_22_SIZE;
          unsigned int end_rcvd_21                    : CP_NV_FLAGS_1_END_RCVD_21_SIZE;
          unsigned int discard_21                     : CP_NV_FLAGS_1_DISCARD_21_SIZE;
          unsigned int end_rcvd_20                    : CP_NV_FLAGS_1_END_RCVD_20_SIZE;
          unsigned int discard_20                     : CP_NV_FLAGS_1_DISCARD_20_SIZE;
          unsigned int end_rcvd_19                    : CP_NV_FLAGS_1_END_RCVD_19_SIZE;
          unsigned int discard_19                     : CP_NV_FLAGS_1_DISCARD_19_SIZE;
          unsigned int end_rcvd_18                    : CP_NV_FLAGS_1_END_RCVD_18_SIZE;
          unsigned int discard_18                     : CP_NV_FLAGS_1_DISCARD_18_SIZE;
          unsigned int end_rcvd_17                    : CP_NV_FLAGS_1_END_RCVD_17_SIZE;
          unsigned int discard_17                     : CP_NV_FLAGS_1_DISCARD_17_SIZE;
          unsigned int end_rcvd_16                    : CP_NV_FLAGS_1_END_RCVD_16_SIZE;
          unsigned int discard_16                     : CP_NV_FLAGS_1_DISCARD_16_SIZE;
     } cp_nv_flags_1_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_nv_flags_1_t f;
} cp_nv_flags_1_u;


/*
 * CP_NV_FLAGS_2 struct
 */

#define CP_NV_FLAGS_2_DISCARD_32_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_32_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_33_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_33_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_34_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_34_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_35_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_35_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_36_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_36_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_37_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_37_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_38_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_38_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_39_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_39_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_40_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_40_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_41_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_41_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_42_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_42_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_43_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_43_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_44_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_44_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_45_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_45_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_46_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_46_SIZE 1
#define CP_NV_FLAGS_2_DISCARD_47_SIZE  1
#define CP_NV_FLAGS_2_END_RCVD_47_SIZE 1

#define CP_NV_FLAGS_2_DISCARD_32_SHIFT 0
#define CP_NV_FLAGS_2_END_RCVD_32_SHIFT 1
#define CP_NV_FLAGS_2_DISCARD_33_SHIFT 2
#define CP_NV_FLAGS_2_END_RCVD_33_SHIFT 3
#define CP_NV_FLAGS_2_DISCARD_34_SHIFT 4
#define CP_NV_FLAGS_2_END_RCVD_34_SHIFT 5
#define CP_NV_FLAGS_2_DISCARD_35_SHIFT 6
#define CP_NV_FLAGS_2_END_RCVD_35_SHIFT 7
#define CP_NV_FLAGS_2_DISCARD_36_SHIFT 8
#define CP_NV_FLAGS_2_END_RCVD_36_SHIFT 9
#define CP_NV_FLAGS_2_DISCARD_37_SHIFT 10
#define CP_NV_FLAGS_2_END_RCVD_37_SHIFT 11
#define CP_NV_FLAGS_2_DISCARD_38_SHIFT 12
#define CP_NV_FLAGS_2_END_RCVD_38_SHIFT 13
#define CP_NV_FLAGS_2_DISCARD_39_SHIFT 14
#define CP_NV_FLAGS_2_END_RCVD_39_SHIFT 15
#define CP_NV_FLAGS_2_DISCARD_40_SHIFT 16
#define CP_NV_FLAGS_2_END_RCVD_40_SHIFT 17
#define CP_NV_FLAGS_2_DISCARD_41_SHIFT 18
#define CP_NV_FLAGS_2_END_RCVD_41_SHIFT 19
#define CP_NV_FLAGS_2_DISCARD_42_SHIFT 20
#define CP_NV_FLAGS_2_END_RCVD_42_SHIFT 21
#define CP_NV_FLAGS_2_DISCARD_43_SHIFT 22
#define CP_NV_FLAGS_2_END_RCVD_43_SHIFT 23
#define CP_NV_FLAGS_2_DISCARD_44_SHIFT 24
#define CP_NV_FLAGS_2_END_RCVD_44_SHIFT 25
#define CP_NV_FLAGS_2_DISCARD_45_SHIFT 26
#define CP_NV_FLAGS_2_END_RCVD_45_SHIFT 27
#define CP_NV_FLAGS_2_DISCARD_46_SHIFT 28
#define CP_NV_FLAGS_2_END_RCVD_46_SHIFT 29
#define CP_NV_FLAGS_2_DISCARD_47_SHIFT 30
#define CP_NV_FLAGS_2_END_RCVD_47_SHIFT 31

#define CP_NV_FLAGS_2_DISCARD_32_MASK  0x00000001
#define CP_NV_FLAGS_2_END_RCVD_32_MASK 0x00000002
#define CP_NV_FLAGS_2_DISCARD_33_MASK  0x00000004
#define CP_NV_FLAGS_2_END_RCVD_33_MASK 0x00000008
#define CP_NV_FLAGS_2_DISCARD_34_MASK  0x00000010
#define CP_NV_FLAGS_2_END_RCVD_34_MASK 0x00000020
#define CP_NV_FLAGS_2_DISCARD_35_MASK  0x00000040
#define CP_NV_FLAGS_2_END_RCVD_35_MASK 0x00000080
#define CP_NV_FLAGS_2_DISCARD_36_MASK  0x00000100
#define CP_NV_FLAGS_2_END_RCVD_36_MASK 0x00000200
#define CP_NV_FLAGS_2_DISCARD_37_MASK  0x00000400
#define CP_NV_FLAGS_2_END_RCVD_37_MASK 0x00000800
#define CP_NV_FLAGS_2_DISCARD_38_MASK  0x00001000
#define CP_NV_FLAGS_2_END_RCVD_38_MASK 0x00002000
#define CP_NV_FLAGS_2_DISCARD_39_MASK  0x00004000
#define CP_NV_FLAGS_2_END_RCVD_39_MASK 0x00008000
#define CP_NV_FLAGS_2_DISCARD_40_MASK  0x00010000
#define CP_NV_FLAGS_2_END_RCVD_40_MASK 0x00020000
#define CP_NV_FLAGS_2_DISCARD_41_MASK  0x00040000
#define CP_NV_FLAGS_2_END_RCVD_41_MASK 0x00080000
#define CP_NV_FLAGS_2_DISCARD_42_MASK  0x00100000
#define CP_NV_FLAGS_2_END_RCVD_42_MASK 0x00200000
#define CP_NV_FLAGS_2_DISCARD_43_MASK  0x00400000
#define CP_NV_FLAGS_2_END_RCVD_43_MASK 0x00800000
#define CP_NV_FLAGS_2_DISCARD_44_MASK  0x01000000
#define CP_NV_FLAGS_2_END_RCVD_44_MASK 0x02000000
#define CP_NV_FLAGS_2_DISCARD_45_MASK  0x04000000
#define CP_NV_FLAGS_2_END_RCVD_45_MASK 0x08000000
#define CP_NV_FLAGS_2_DISCARD_46_MASK  0x10000000
#define CP_NV_FLAGS_2_END_RCVD_46_MASK 0x20000000
#define CP_NV_FLAGS_2_DISCARD_47_MASK  0x40000000
#define CP_NV_FLAGS_2_END_RCVD_47_MASK 0x80000000

#define CP_NV_FLAGS_2_MASK \
     (CP_NV_FLAGS_2_DISCARD_32_MASK | \
      CP_NV_FLAGS_2_END_RCVD_32_MASK | \
      CP_NV_FLAGS_2_DISCARD_33_MASK | \
      CP_NV_FLAGS_2_END_RCVD_33_MASK | \
      CP_NV_FLAGS_2_DISCARD_34_MASK | \
      CP_NV_FLAGS_2_END_RCVD_34_MASK | \
      CP_NV_FLAGS_2_DISCARD_35_MASK | \
      CP_NV_FLAGS_2_END_RCVD_35_MASK | \
      CP_NV_FLAGS_2_DISCARD_36_MASK | \
      CP_NV_FLAGS_2_END_RCVD_36_MASK | \
      CP_NV_FLAGS_2_DISCARD_37_MASK | \
      CP_NV_FLAGS_2_END_RCVD_37_MASK | \
      CP_NV_FLAGS_2_DISCARD_38_MASK | \
      CP_NV_FLAGS_2_END_RCVD_38_MASK | \
      CP_NV_FLAGS_2_DISCARD_39_MASK | \
      CP_NV_FLAGS_2_END_RCVD_39_MASK | \
      CP_NV_FLAGS_2_DISCARD_40_MASK | \
      CP_NV_FLAGS_2_END_RCVD_40_MASK | \
      CP_NV_FLAGS_2_DISCARD_41_MASK | \
      CP_NV_FLAGS_2_END_RCVD_41_MASK | \
      CP_NV_FLAGS_2_DISCARD_42_MASK | \
      CP_NV_FLAGS_2_END_RCVD_42_MASK | \
      CP_NV_FLAGS_2_DISCARD_43_MASK | \
      CP_NV_FLAGS_2_END_RCVD_43_MASK | \
      CP_NV_FLAGS_2_DISCARD_44_MASK | \
      CP_NV_FLAGS_2_END_RCVD_44_MASK | \
      CP_NV_FLAGS_2_DISCARD_45_MASK | \
      CP_NV_FLAGS_2_END_RCVD_45_MASK | \
      CP_NV_FLAGS_2_DISCARD_46_MASK | \
      CP_NV_FLAGS_2_END_RCVD_46_MASK | \
      CP_NV_FLAGS_2_DISCARD_47_MASK | \
      CP_NV_FLAGS_2_END_RCVD_47_MASK)

#define CP_NV_FLAGS_2(discard_32, end_rcvd_32, discard_33, end_rcvd_33, discard_34, end_rcvd_34, discard_35, end_rcvd_35, discard_36, end_rcvd_36, discard_37, end_rcvd_37, discard_38, end_rcvd_38, discard_39, end_rcvd_39, discard_40, end_rcvd_40, discard_41, end_rcvd_41, discard_42, end_rcvd_42, discard_43, end_rcvd_43, discard_44, end_rcvd_44, discard_45, end_rcvd_45, discard_46, end_rcvd_46, discard_47, end_rcvd_47) \
     ((discard_32 << CP_NV_FLAGS_2_DISCARD_32_SHIFT) | \
      (end_rcvd_32 << CP_NV_FLAGS_2_END_RCVD_32_SHIFT) | \
      (discard_33 << CP_NV_FLAGS_2_DISCARD_33_SHIFT) | \
      (end_rcvd_33 << CP_NV_FLAGS_2_END_RCVD_33_SHIFT) | \
      (discard_34 << CP_NV_FLAGS_2_DISCARD_34_SHIFT) | \
      (end_rcvd_34 << CP_NV_FLAGS_2_END_RCVD_34_SHIFT) | \
      (discard_35 << CP_NV_FLAGS_2_DISCARD_35_SHIFT) | \
      (end_rcvd_35 << CP_NV_FLAGS_2_END_RCVD_35_SHIFT) | \
      (discard_36 << CP_NV_FLAGS_2_DISCARD_36_SHIFT) | \
      (end_rcvd_36 << CP_NV_FLAGS_2_END_RCVD_36_SHIFT) | \
      (discard_37 << CP_NV_FLAGS_2_DISCARD_37_SHIFT) | \
      (end_rcvd_37 << CP_NV_FLAGS_2_END_RCVD_37_SHIFT) | \
      (discard_38 << CP_NV_FLAGS_2_DISCARD_38_SHIFT) | \
      (end_rcvd_38 << CP_NV_FLAGS_2_END_RCVD_38_SHIFT) | \
      (discard_39 << CP_NV_FLAGS_2_DISCARD_39_SHIFT) | \
      (end_rcvd_39 << CP_NV_FLAGS_2_END_RCVD_39_SHIFT) | \
      (discard_40 << CP_NV_FLAGS_2_DISCARD_40_SHIFT) | \
      (end_rcvd_40 << CP_NV_FLAGS_2_END_RCVD_40_SHIFT) | \
      (discard_41 << CP_NV_FLAGS_2_DISCARD_41_SHIFT) | \
      (end_rcvd_41 << CP_NV_FLAGS_2_END_RCVD_41_SHIFT) | \
      (discard_42 << CP_NV_FLAGS_2_DISCARD_42_SHIFT) | \
      (end_rcvd_42 << CP_NV_FLAGS_2_END_RCVD_42_SHIFT) | \
      (discard_43 << CP_NV_FLAGS_2_DISCARD_43_SHIFT) | \
      (end_rcvd_43 << CP_NV_FLAGS_2_END_RCVD_43_SHIFT) | \
      (discard_44 << CP_NV_FLAGS_2_DISCARD_44_SHIFT) | \
      (end_rcvd_44 << CP_NV_FLAGS_2_END_RCVD_44_SHIFT) | \
      (discard_45 << CP_NV_FLAGS_2_DISCARD_45_SHIFT) | \
      (end_rcvd_45 << CP_NV_FLAGS_2_END_RCVD_45_SHIFT) | \
      (discard_46 << CP_NV_FLAGS_2_DISCARD_46_SHIFT) | \
      (end_rcvd_46 << CP_NV_FLAGS_2_END_RCVD_46_SHIFT) | \
      (discard_47 << CP_NV_FLAGS_2_DISCARD_47_SHIFT) | \
      (end_rcvd_47 << CP_NV_FLAGS_2_END_RCVD_47_SHIFT))

#define CP_NV_FLAGS_2_GET_DISCARD_32(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_32_MASK) >> CP_NV_FLAGS_2_DISCARD_32_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_32(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_32_MASK) >> CP_NV_FLAGS_2_END_RCVD_32_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_33(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_33_MASK) >> CP_NV_FLAGS_2_DISCARD_33_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_33(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_33_MASK) >> CP_NV_FLAGS_2_END_RCVD_33_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_34(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_34_MASK) >> CP_NV_FLAGS_2_DISCARD_34_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_34(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_34_MASK) >> CP_NV_FLAGS_2_END_RCVD_34_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_35(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_35_MASK) >> CP_NV_FLAGS_2_DISCARD_35_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_35(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_35_MASK) >> CP_NV_FLAGS_2_END_RCVD_35_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_36(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_36_MASK) >> CP_NV_FLAGS_2_DISCARD_36_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_36(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_36_MASK) >> CP_NV_FLAGS_2_END_RCVD_36_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_37(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_37_MASK) >> CP_NV_FLAGS_2_DISCARD_37_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_37(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_37_MASK) >> CP_NV_FLAGS_2_END_RCVD_37_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_38(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_38_MASK) >> CP_NV_FLAGS_2_DISCARD_38_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_38(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_38_MASK) >> CP_NV_FLAGS_2_END_RCVD_38_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_39(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_39_MASK) >> CP_NV_FLAGS_2_DISCARD_39_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_39(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_39_MASK) >> CP_NV_FLAGS_2_END_RCVD_39_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_40(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_40_MASK) >> CP_NV_FLAGS_2_DISCARD_40_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_40(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_40_MASK) >> CP_NV_FLAGS_2_END_RCVD_40_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_41(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_41_MASK) >> CP_NV_FLAGS_2_DISCARD_41_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_41(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_41_MASK) >> CP_NV_FLAGS_2_END_RCVD_41_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_42(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_42_MASK) >> CP_NV_FLAGS_2_DISCARD_42_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_42(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_42_MASK) >> CP_NV_FLAGS_2_END_RCVD_42_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_43(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_43_MASK) >> CP_NV_FLAGS_2_DISCARD_43_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_43(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_43_MASK) >> CP_NV_FLAGS_2_END_RCVD_43_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_44(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_44_MASK) >> CP_NV_FLAGS_2_DISCARD_44_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_44(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_44_MASK) >> CP_NV_FLAGS_2_END_RCVD_44_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_45(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_45_MASK) >> CP_NV_FLAGS_2_DISCARD_45_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_45(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_45_MASK) >> CP_NV_FLAGS_2_END_RCVD_45_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_46(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_46_MASK) >> CP_NV_FLAGS_2_DISCARD_46_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_46(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_46_MASK) >> CP_NV_FLAGS_2_END_RCVD_46_SHIFT)
#define CP_NV_FLAGS_2_GET_DISCARD_47(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_DISCARD_47_MASK) >> CP_NV_FLAGS_2_DISCARD_47_SHIFT)
#define CP_NV_FLAGS_2_GET_END_RCVD_47(cp_nv_flags_2) \
     ((cp_nv_flags_2 & CP_NV_FLAGS_2_END_RCVD_47_MASK) >> CP_NV_FLAGS_2_END_RCVD_47_SHIFT)

#define CP_NV_FLAGS_2_SET_DISCARD_32(cp_nv_flags_2_reg, discard_32) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_32_MASK) | (discard_32 << CP_NV_FLAGS_2_DISCARD_32_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_32(cp_nv_flags_2_reg, end_rcvd_32) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_32_MASK) | (end_rcvd_32 << CP_NV_FLAGS_2_END_RCVD_32_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_33(cp_nv_flags_2_reg, discard_33) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_33_MASK) | (discard_33 << CP_NV_FLAGS_2_DISCARD_33_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_33(cp_nv_flags_2_reg, end_rcvd_33) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_33_MASK) | (end_rcvd_33 << CP_NV_FLAGS_2_END_RCVD_33_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_34(cp_nv_flags_2_reg, discard_34) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_34_MASK) | (discard_34 << CP_NV_FLAGS_2_DISCARD_34_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_34(cp_nv_flags_2_reg, end_rcvd_34) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_34_MASK) | (end_rcvd_34 << CP_NV_FLAGS_2_END_RCVD_34_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_35(cp_nv_flags_2_reg, discard_35) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_35_MASK) | (discard_35 << CP_NV_FLAGS_2_DISCARD_35_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_35(cp_nv_flags_2_reg, end_rcvd_35) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_35_MASK) | (end_rcvd_35 << CP_NV_FLAGS_2_END_RCVD_35_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_36(cp_nv_flags_2_reg, discard_36) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_36_MASK) | (discard_36 << CP_NV_FLAGS_2_DISCARD_36_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_36(cp_nv_flags_2_reg, end_rcvd_36) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_36_MASK) | (end_rcvd_36 << CP_NV_FLAGS_2_END_RCVD_36_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_37(cp_nv_flags_2_reg, discard_37) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_37_MASK) | (discard_37 << CP_NV_FLAGS_2_DISCARD_37_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_37(cp_nv_flags_2_reg, end_rcvd_37) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_37_MASK) | (end_rcvd_37 << CP_NV_FLAGS_2_END_RCVD_37_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_38(cp_nv_flags_2_reg, discard_38) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_38_MASK) | (discard_38 << CP_NV_FLAGS_2_DISCARD_38_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_38(cp_nv_flags_2_reg, end_rcvd_38) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_38_MASK) | (end_rcvd_38 << CP_NV_FLAGS_2_END_RCVD_38_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_39(cp_nv_flags_2_reg, discard_39) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_39_MASK) | (discard_39 << CP_NV_FLAGS_2_DISCARD_39_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_39(cp_nv_flags_2_reg, end_rcvd_39) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_39_MASK) | (end_rcvd_39 << CP_NV_FLAGS_2_END_RCVD_39_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_40(cp_nv_flags_2_reg, discard_40) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_40_MASK) | (discard_40 << CP_NV_FLAGS_2_DISCARD_40_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_40(cp_nv_flags_2_reg, end_rcvd_40) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_40_MASK) | (end_rcvd_40 << CP_NV_FLAGS_2_END_RCVD_40_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_41(cp_nv_flags_2_reg, discard_41) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_41_MASK) | (discard_41 << CP_NV_FLAGS_2_DISCARD_41_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_41(cp_nv_flags_2_reg, end_rcvd_41) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_41_MASK) | (end_rcvd_41 << CP_NV_FLAGS_2_END_RCVD_41_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_42(cp_nv_flags_2_reg, discard_42) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_42_MASK) | (discard_42 << CP_NV_FLAGS_2_DISCARD_42_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_42(cp_nv_flags_2_reg, end_rcvd_42) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_42_MASK) | (end_rcvd_42 << CP_NV_FLAGS_2_END_RCVD_42_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_43(cp_nv_flags_2_reg, discard_43) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_43_MASK) | (discard_43 << CP_NV_FLAGS_2_DISCARD_43_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_43(cp_nv_flags_2_reg, end_rcvd_43) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_43_MASK) | (end_rcvd_43 << CP_NV_FLAGS_2_END_RCVD_43_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_44(cp_nv_flags_2_reg, discard_44) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_44_MASK) | (discard_44 << CP_NV_FLAGS_2_DISCARD_44_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_44(cp_nv_flags_2_reg, end_rcvd_44) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_44_MASK) | (end_rcvd_44 << CP_NV_FLAGS_2_END_RCVD_44_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_45(cp_nv_flags_2_reg, discard_45) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_45_MASK) | (discard_45 << CP_NV_FLAGS_2_DISCARD_45_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_45(cp_nv_flags_2_reg, end_rcvd_45) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_45_MASK) | (end_rcvd_45 << CP_NV_FLAGS_2_END_RCVD_45_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_46(cp_nv_flags_2_reg, discard_46) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_46_MASK) | (discard_46 << CP_NV_FLAGS_2_DISCARD_46_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_46(cp_nv_flags_2_reg, end_rcvd_46) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_46_MASK) | (end_rcvd_46 << CP_NV_FLAGS_2_END_RCVD_46_SHIFT)
#define CP_NV_FLAGS_2_SET_DISCARD_47(cp_nv_flags_2_reg, discard_47) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_DISCARD_47_MASK) | (discard_47 << CP_NV_FLAGS_2_DISCARD_47_SHIFT)
#define CP_NV_FLAGS_2_SET_END_RCVD_47(cp_nv_flags_2_reg, end_rcvd_47) \
     cp_nv_flags_2_reg = (cp_nv_flags_2_reg & ~CP_NV_FLAGS_2_END_RCVD_47_MASK) | (end_rcvd_47 << CP_NV_FLAGS_2_END_RCVD_47_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_nv_flags_2_t {
          unsigned int discard_32                     : CP_NV_FLAGS_2_DISCARD_32_SIZE;
          unsigned int end_rcvd_32                    : CP_NV_FLAGS_2_END_RCVD_32_SIZE;
          unsigned int discard_33                     : CP_NV_FLAGS_2_DISCARD_33_SIZE;
          unsigned int end_rcvd_33                    : CP_NV_FLAGS_2_END_RCVD_33_SIZE;
          unsigned int discard_34                     : CP_NV_FLAGS_2_DISCARD_34_SIZE;
          unsigned int end_rcvd_34                    : CP_NV_FLAGS_2_END_RCVD_34_SIZE;
          unsigned int discard_35                     : CP_NV_FLAGS_2_DISCARD_35_SIZE;
          unsigned int end_rcvd_35                    : CP_NV_FLAGS_2_END_RCVD_35_SIZE;
          unsigned int discard_36                     : CP_NV_FLAGS_2_DISCARD_36_SIZE;
          unsigned int end_rcvd_36                    : CP_NV_FLAGS_2_END_RCVD_36_SIZE;
          unsigned int discard_37                     : CP_NV_FLAGS_2_DISCARD_37_SIZE;
          unsigned int end_rcvd_37                    : CP_NV_FLAGS_2_END_RCVD_37_SIZE;
          unsigned int discard_38                     : CP_NV_FLAGS_2_DISCARD_38_SIZE;
          unsigned int end_rcvd_38                    : CP_NV_FLAGS_2_END_RCVD_38_SIZE;
          unsigned int discard_39                     : CP_NV_FLAGS_2_DISCARD_39_SIZE;
          unsigned int end_rcvd_39                    : CP_NV_FLAGS_2_END_RCVD_39_SIZE;
          unsigned int discard_40                     : CP_NV_FLAGS_2_DISCARD_40_SIZE;
          unsigned int end_rcvd_40                    : CP_NV_FLAGS_2_END_RCVD_40_SIZE;
          unsigned int discard_41                     : CP_NV_FLAGS_2_DISCARD_41_SIZE;
          unsigned int end_rcvd_41                    : CP_NV_FLAGS_2_END_RCVD_41_SIZE;
          unsigned int discard_42                     : CP_NV_FLAGS_2_DISCARD_42_SIZE;
          unsigned int end_rcvd_42                    : CP_NV_FLAGS_2_END_RCVD_42_SIZE;
          unsigned int discard_43                     : CP_NV_FLAGS_2_DISCARD_43_SIZE;
          unsigned int end_rcvd_43                    : CP_NV_FLAGS_2_END_RCVD_43_SIZE;
          unsigned int discard_44                     : CP_NV_FLAGS_2_DISCARD_44_SIZE;
          unsigned int end_rcvd_44                    : CP_NV_FLAGS_2_END_RCVD_44_SIZE;
          unsigned int discard_45                     : CP_NV_FLAGS_2_DISCARD_45_SIZE;
          unsigned int end_rcvd_45                    : CP_NV_FLAGS_2_END_RCVD_45_SIZE;
          unsigned int discard_46                     : CP_NV_FLAGS_2_DISCARD_46_SIZE;
          unsigned int end_rcvd_46                    : CP_NV_FLAGS_2_END_RCVD_46_SIZE;
          unsigned int discard_47                     : CP_NV_FLAGS_2_DISCARD_47_SIZE;
          unsigned int end_rcvd_47                    : CP_NV_FLAGS_2_END_RCVD_47_SIZE;
     } cp_nv_flags_2_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_nv_flags_2_t {
          unsigned int end_rcvd_47                    : CP_NV_FLAGS_2_END_RCVD_47_SIZE;
          unsigned int discard_47                     : CP_NV_FLAGS_2_DISCARD_47_SIZE;
          unsigned int end_rcvd_46                    : CP_NV_FLAGS_2_END_RCVD_46_SIZE;
          unsigned int discard_46                     : CP_NV_FLAGS_2_DISCARD_46_SIZE;
          unsigned int end_rcvd_45                    : CP_NV_FLAGS_2_END_RCVD_45_SIZE;
          unsigned int discard_45                     : CP_NV_FLAGS_2_DISCARD_45_SIZE;
          unsigned int end_rcvd_44                    : CP_NV_FLAGS_2_END_RCVD_44_SIZE;
          unsigned int discard_44                     : CP_NV_FLAGS_2_DISCARD_44_SIZE;
          unsigned int end_rcvd_43                    : CP_NV_FLAGS_2_END_RCVD_43_SIZE;
          unsigned int discard_43                     : CP_NV_FLAGS_2_DISCARD_43_SIZE;
          unsigned int end_rcvd_42                    : CP_NV_FLAGS_2_END_RCVD_42_SIZE;
          unsigned int discard_42                     : CP_NV_FLAGS_2_DISCARD_42_SIZE;
          unsigned int end_rcvd_41                    : CP_NV_FLAGS_2_END_RCVD_41_SIZE;
          unsigned int discard_41                     : CP_NV_FLAGS_2_DISCARD_41_SIZE;
          unsigned int end_rcvd_40                    : CP_NV_FLAGS_2_END_RCVD_40_SIZE;
          unsigned int discard_40                     : CP_NV_FLAGS_2_DISCARD_40_SIZE;
          unsigned int end_rcvd_39                    : CP_NV_FLAGS_2_END_RCVD_39_SIZE;
          unsigned int discard_39                     : CP_NV_FLAGS_2_DISCARD_39_SIZE;
          unsigned int end_rcvd_38                    : CP_NV_FLAGS_2_END_RCVD_38_SIZE;
          unsigned int discard_38                     : CP_NV_FLAGS_2_DISCARD_38_SIZE;
          unsigned int end_rcvd_37                    : CP_NV_FLAGS_2_END_RCVD_37_SIZE;
          unsigned int discard_37                     : CP_NV_FLAGS_2_DISCARD_37_SIZE;
          unsigned int end_rcvd_36                    : CP_NV_FLAGS_2_END_RCVD_36_SIZE;
          unsigned int discard_36                     : CP_NV_FLAGS_2_DISCARD_36_SIZE;
          unsigned int end_rcvd_35                    : CP_NV_FLAGS_2_END_RCVD_35_SIZE;
          unsigned int discard_35                     : CP_NV_FLAGS_2_DISCARD_35_SIZE;
          unsigned int end_rcvd_34                    : CP_NV_FLAGS_2_END_RCVD_34_SIZE;
          unsigned int discard_34                     : CP_NV_FLAGS_2_DISCARD_34_SIZE;
          unsigned int end_rcvd_33                    : CP_NV_FLAGS_2_END_RCVD_33_SIZE;
          unsigned int discard_33                     : CP_NV_FLAGS_2_DISCARD_33_SIZE;
          unsigned int end_rcvd_32                    : CP_NV_FLAGS_2_END_RCVD_32_SIZE;
          unsigned int discard_32                     : CP_NV_FLAGS_2_DISCARD_32_SIZE;
     } cp_nv_flags_2_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_nv_flags_2_t f;
} cp_nv_flags_2_u;


/*
 * CP_NV_FLAGS_3 struct
 */

#define CP_NV_FLAGS_3_DISCARD_48_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_48_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_49_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_49_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_50_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_50_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_51_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_51_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_52_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_52_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_53_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_53_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_54_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_54_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_55_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_55_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_56_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_56_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_57_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_57_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_58_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_58_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_59_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_59_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_60_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_60_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_61_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_61_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_62_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_62_SIZE 1
#define CP_NV_FLAGS_3_DISCARD_63_SIZE  1
#define CP_NV_FLAGS_3_END_RCVD_63_SIZE 1

#define CP_NV_FLAGS_3_DISCARD_48_SHIFT 0
#define CP_NV_FLAGS_3_END_RCVD_48_SHIFT 1
#define CP_NV_FLAGS_3_DISCARD_49_SHIFT 2
#define CP_NV_FLAGS_3_END_RCVD_49_SHIFT 3
#define CP_NV_FLAGS_3_DISCARD_50_SHIFT 4
#define CP_NV_FLAGS_3_END_RCVD_50_SHIFT 5
#define CP_NV_FLAGS_3_DISCARD_51_SHIFT 6
#define CP_NV_FLAGS_3_END_RCVD_51_SHIFT 7
#define CP_NV_FLAGS_3_DISCARD_52_SHIFT 8
#define CP_NV_FLAGS_3_END_RCVD_52_SHIFT 9
#define CP_NV_FLAGS_3_DISCARD_53_SHIFT 10
#define CP_NV_FLAGS_3_END_RCVD_53_SHIFT 11
#define CP_NV_FLAGS_3_DISCARD_54_SHIFT 12
#define CP_NV_FLAGS_3_END_RCVD_54_SHIFT 13
#define CP_NV_FLAGS_3_DISCARD_55_SHIFT 14
#define CP_NV_FLAGS_3_END_RCVD_55_SHIFT 15
#define CP_NV_FLAGS_3_DISCARD_56_SHIFT 16
#define CP_NV_FLAGS_3_END_RCVD_56_SHIFT 17
#define CP_NV_FLAGS_3_DISCARD_57_SHIFT 18
#define CP_NV_FLAGS_3_END_RCVD_57_SHIFT 19
#define CP_NV_FLAGS_3_DISCARD_58_SHIFT 20
#define CP_NV_FLAGS_3_END_RCVD_58_SHIFT 21
#define CP_NV_FLAGS_3_DISCARD_59_SHIFT 22
#define CP_NV_FLAGS_3_END_RCVD_59_SHIFT 23
#define CP_NV_FLAGS_3_DISCARD_60_SHIFT 24
#define CP_NV_FLAGS_3_END_RCVD_60_SHIFT 25
#define CP_NV_FLAGS_3_DISCARD_61_SHIFT 26
#define CP_NV_FLAGS_3_END_RCVD_61_SHIFT 27
#define CP_NV_FLAGS_3_DISCARD_62_SHIFT 28
#define CP_NV_FLAGS_3_END_RCVD_62_SHIFT 29
#define CP_NV_FLAGS_3_DISCARD_63_SHIFT 30
#define CP_NV_FLAGS_3_END_RCVD_63_SHIFT 31

#define CP_NV_FLAGS_3_DISCARD_48_MASK  0x00000001
#define CP_NV_FLAGS_3_END_RCVD_48_MASK 0x00000002
#define CP_NV_FLAGS_3_DISCARD_49_MASK  0x00000004
#define CP_NV_FLAGS_3_END_RCVD_49_MASK 0x00000008
#define CP_NV_FLAGS_3_DISCARD_50_MASK  0x00000010
#define CP_NV_FLAGS_3_END_RCVD_50_MASK 0x00000020
#define CP_NV_FLAGS_3_DISCARD_51_MASK  0x00000040
#define CP_NV_FLAGS_3_END_RCVD_51_MASK 0x00000080
#define CP_NV_FLAGS_3_DISCARD_52_MASK  0x00000100
#define CP_NV_FLAGS_3_END_RCVD_52_MASK 0x00000200
#define CP_NV_FLAGS_3_DISCARD_53_MASK  0x00000400
#define CP_NV_FLAGS_3_END_RCVD_53_MASK 0x00000800
#define CP_NV_FLAGS_3_DISCARD_54_MASK  0x00001000
#define CP_NV_FLAGS_3_END_RCVD_54_MASK 0x00002000
#define CP_NV_FLAGS_3_DISCARD_55_MASK  0x00004000
#define CP_NV_FLAGS_3_END_RCVD_55_MASK 0x00008000
#define CP_NV_FLAGS_3_DISCARD_56_MASK  0x00010000
#define CP_NV_FLAGS_3_END_RCVD_56_MASK 0x00020000
#define CP_NV_FLAGS_3_DISCARD_57_MASK  0x00040000
#define CP_NV_FLAGS_3_END_RCVD_57_MASK 0x00080000
#define CP_NV_FLAGS_3_DISCARD_58_MASK  0x00100000
#define CP_NV_FLAGS_3_END_RCVD_58_MASK 0x00200000
#define CP_NV_FLAGS_3_DISCARD_59_MASK  0x00400000
#define CP_NV_FLAGS_3_END_RCVD_59_MASK 0x00800000
#define CP_NV_FLAGS_3_DISCARD_60_MASK  0x01000000
#define CP_NV_FLAGS_3_END_RCVD_60_MASK 0x02000000
#define CP_NV_FLAGS_3_DISCARD_61_MASK  0x04000000
#define CP_NV_FLAGS_3_END_RCVD_61_MASK 0x08000000
#define CP_NV_FLAGS_3_DISCARD_62_MASK  0x10000000
#define CP_NV_FLAGS_3_END_RCVD_62_MASK 0x20000000
#define CP_NV_FLAGS_3_DISCARD_63_MASK  0x40000000
#define CP_NV_FLAGS_3_END_RCVD_63_MASK 0x80000000

#define CP_NV_FLAGS_3_MASK \
     (CP_NV_FLAGS_3_DISCARD_48_MASK | \
      CP_NV_FLAGS_3_END_RCVD_48_MASK | \
      CP_NV_FLAGS_3_DISCARD_49_MASK | \
      CP_NV_FLAGS_3_END_RCVD_49_MASK | \
      CP_NV_FLAGS_3_DISCARD_50_MASK | \
      CP_NV_FLAGS_3_END_RCVD_50_MASK | \
      CP_NV_FLAGS_3_DISCARD_51_MASK | \
      CP_NV_FLAGS_3_END_RCVD_51_MASK | \
      CP_NV_FLAGS_3_DISCARD_52_MASK | \
      CP_NV_FLAGS_3_END_RCVD_52_MASK | \
      CP_NV_FLAGS_3_DISCARD_53_MASK | \
      CP_NV_FLAGS_3_END_RCVD_53_MASK | \
      CP_NV_FLAGS_3_DISCARD_54_MASK | \
      CP_NV_FLAGS_3_END_RCVD_54_MASK | \
      CP_NV_FLAGS_3_DISCARD_55_MASK | \
      CP_NV_FLAGS_3_END_RCVD_55_MASK | \
      CP_NV_FLAGS_3_DISCARD_56_MASK | \
      CP_NV_FLAGS_3_END_RCVD_56_MASK | \
      CP_NV_FLAGS_3_DISCARD_57_MASK | \
      CP_NV_FLAGS_3_END_RCVD_57_MASK | \
      CP_NV_FLAGS_3_DISCARD_58_MASK | \
      CP_NV_FLAGS_3_END_RCVD_58_MASK | \
      CP_NV_FLAGS_3_DISCARD_59_MASK | \
      CP_NV_FLAGS_3_END_RCVD_59_MASK | \
      CP_NV_FLAGS_3_DISCARD_60_MASK | \
      CP_NV_FLAGS_3_END_RCVD_60_MASK | \
      CP_NV_FLAGS_3_DISCARD_61_MASK | \
      CP_NV_FLAGS_3_END_RCVD_61_MASK | \
      CP_NV_FLAGS_3_DISCARD_62_MASK | \
      CP_NV_FLAGS_3_END_RCVD_62_MASK | \
      CP_NV_FLAGS_3_DISCARD_63_MASK | \
      CP_NV_FLAGS_3_END_RCVD_63_MASK)

#define CP_NV_FLAGS_3(discard_48, end_rcvd_48, discard_49, end_rcvd_49, discard_50, end_rcvd_50, discard_51, end_rcvd_51, discard_52, end_rcvd_52, discard_53, end_rcvd_53, discard_54, end_rcvd_54, discard_55, end_rcvd_55, discard_56, end_rcvd_56, discard_57, end_rcvd_57, discard_58, end_rcvd_58, discard_59, end_rcvd_59, discard_60, end_rcvd_60, discard_61, end_rcvd_61, discard_62, end_rcvd_62, discard_63, end_rcvd_63) \
     ((discard_48 << CP_NV_FLAGS_3_DISCARD_48_SHIFT) | \
      (end_rcvd_48 << CP_NV_FLAGS_3_END_RCVD_48_SHIFT) | \
      (discard_49 << CP_NV_FLAGS_3_DISCARD_49_SHIFT) | \
      (end_rcvd_49 << CP_NV_FLAGS_3_END_RCVD_49_SHIFT) | \
      (discard_50 << CP_NV_FLAGS_3_DISCARD_50_SHIFT) | \
      (end_rcvd_50 << CP_NV_FLAGS_3_END_RCVD_50_SHIFT) | \
      (discard_51 << CP_NV_FLAGS_3_DISCARD_51_SHIFT) | \
      (end_rcvd_51 << CP_NV_FLAGS_3_END_RCVD_51_SHIFT) | \
      (discard_52 << CP_NV_FLAGS_3_DISCARD_52_SHIFT) | \
      (end_rcvd_52 << CP_NV_FLAGS_3_END_RCVD_52_SHIFT) | \
      (discard_53 << CP_NV_FLAGS_3_DISCARD_53_SHIFT) | \
      (end_rcvd_53 << CP_NV_FLAGS_3_END_RCVD_53_SHIFT) | \
      (discard_54 << CP_NV_FLAGS_3_DISCARD_54_SHIFT) | \
      (end_rcvd_54 << CP_NV_FLAGS_3_END_RCVD_54_SHIFT) | \
      (discard_55 << CP_NV_FLAGS_3_DISCARD_55_SHIFT) | \
      (end_rcvd_55 << CP_NV_FLAGS_3_END_RCVD_55_SHIFT) | \
      (discard_56 << CP_NV_FLAGS_3_DISCARD_56_SHIFT) | \
      (end_rcvd_56 << CP_NV_FLAGS_3_END_RCVD_56_SHIFT) | \
      (discard_57 << CP_NV_FLAGS_3_DISCARD_57_SHIFT) | \
      (end_rcvd_57 << CP_NV_FLAGS_3_END_RCVD_57_SHIFT) | \
      (discard_58 << CP_NV_FLAGS_3_DISCARD_58_SHIFT) | \
      (end_rcvd_58 << CP_NV_FLAGS_3_END_RCVD_58_SHIFT) | \
      (discard_59 << CP_NV_FLAGS_3_DISCARD_59_SHIFT) | \
      (end_rcvd_59 << CP_NV_FLAGS_3_END_RCVD_59_SHIFT) | \
      (discard_60 << CP_NV_FLAGS_3_DISCARD_60_SHIFT) | \
      (end_rcvd_60 << CP_NV_FLAGS_3_END_RCVD_60_SHIFT) | \
      (discard_61 << CP_NV_FLAGS_3_DISCARD_61_SHIFT) | \
      (end_rcvd_61 << CP_NV_FLAGS_3_END_RCVD_61_SHIFT) | \
      (discard_62 << CP_NV_FLAGS_3_DISCARD_62_SHIFT) | \
      (end_rcvd_62 << CP_NV_FLAGS_3_END_RCVD_62_SHIFT) | \
      (discard_63 << CP_NV_FLAGS_3_DISCARD_63_SHIFT) | \
      (end_rcvd_63 << CP_NV_FLAGS_3_END_RCVD_63_SHIFT))

#define CP_NV_FLAGS_3_GET_DISCARD_48(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_48_MASK) >> CP_NV_FLAGS_3_DISCARD_48_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_48(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_48_MASK) >> CP_NV_FLAGS_3_END_RCVD_48_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_49(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_49_MASK) >> CP_NV_FLAGS_3_DISCARD_49_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_49(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_49_MASK) >> CP_NV_FLAGS_3_END_RCVD_49_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_50(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_50_MASK) >> CP_NV_FLAGS_3_DISCARD_50_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_50(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_50_MASK) >> CP_NV_FLAGS_3_END_RCVD_50_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_51(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_51_MASK) >> CP_NV_FLAGS_3_DISCARD_51_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_51(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_51_MASK) >> CP_NV_FLAGS_3_END_RCVD_51_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_52(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_52_MASK) >> CP_NV_FLAGS_3_DISCARD_52_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_52(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_52_MASK) >> CP_NV_FLAGS_3_END_RCVD_52_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_53(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_53_MASK) >> CP_NV_FLAGS_3_DISCARD_53_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_53(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_53_MASK) >> CP_NV_FLAGS_3_END_RCVD_53_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_54(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_54_MASK) >> CP_NV_FLAGS_3_DISCARD_54_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_54(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_54_MASK) >> CP_NV_FLAGS_3_END_RCVD_54_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_55(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_55_MASK) >> CP_NV_FLAGS_3_DISCARD_55_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_55(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_55_MASK) >> CP_NV_FLAGS_3_END_RCVD_55_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_56(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_56_MASK) >> CP_NV_FLAGS_3_DISCARD_56_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_56(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_56_MASK) >> CP_NV_FLAGS_3_END_RCVD_56_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_57(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_57_MASK) >> CP_NV_FLAGS_3_DISCARD_57_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_57(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_57_MASK) >> CP_NV_FLAGS_3_END_RCVD_57_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_58(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_58_MASK) >> CP_NV_FLAGS_3_DISCARD_58_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_58(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_58_MASK) >> CP_NV_FLAGS_3_END_RCVD_58_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_59(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_59_MASK) >> CP_NV_FLAGS_3_DISCARD_59_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_59(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_59_MASK) >> CP_NV_FLAGS_3_END_RCVD_59_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_60(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_60_MASK) >> CP_NV_FLAGS_3_DISCARD_60_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_60(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_60_MASK) >> CP_NV_FLAGS_3_END_RCVD_60_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_61(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_61_MASK) >> CP_NV_FLAGS_3_DISCARD_61_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_61(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_61_MASK) >> CP_NV_FLAGS_3_END_RCVD_61_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_62(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_62_MASK) >> CP_NV_FLAGS_3_DISCARD_62_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_62(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_62_MASK) >> CP_NV_FLAGS_3_END_RCVD_62_SHIFT)
#define CP_NV_FLAGS_3_GET_DISCARD_63(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_DISCARD_63_MASK) >> CP_NV_FLAGS_3_DISCARD_63_SHIFT)
#define CP_NV_FLAGS_3_GET_END_RCVD_63(cp_nv_flags_3) \
     ((cp_nv_flags_3 & CP_NV_FLAGS_3_END_RCVD_63_MASK) >> CP_NV_FLAGS_3_END_RCVD_63_SHIFT)

#define CP_NV_FLAGS_3_SET_DISCARD_48(cp_nv_flags_3_reg, discard_48) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_48_MASK) | (discard_48 << CP_NV_FLAGS_3_DISCARD_48_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_48(cp_nv_flags_3_reg, end_rcvd_48) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_48_MASK) | (end_rcvd_48 << CP_NV_FLAGS_3_END_RCVD_48_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_49(cp_nv_flags_3_reg, discard_49) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_49_MASK) | (discard_49 << CP_NV_FLAGS_3_DISCARD_49_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_49(cp_nv_flags_3_reg, end_rcvd_49) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_49_MASK) | (end_rcvd_49 << CP_NV_FLAGS_3_END_RCVD_49_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_50(cp_nv_flags_3_reg, discard_50) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_50_MASK) | (discard_50 << CP_NV_FLAGS_3_DISCARD_50_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_50(cp_nv_flags_3_reg, end_rcvd_50) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_50_MASK) | (end_rcvd_50 << CP_NV_FLAGS_3_END_RCVD_50_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_51(cp_nv_flags_3_reg, discard_51) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_51_MASK) | (discard_51 << CP_NV_FLAGS_3_DISCARD_51_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_51(cp_nv_flags_3_reg, end_rcvd_51) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_51_MASK) | (end_rcvd_51 << CP_NV_FLAGS_3_END_RCVD_51_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_52(cp_nv_flags_3_reg, discard_52) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_52_MASK) | (discard_52 << CP_NV_FLAGS_3_DISCARD_52_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_52(cp_nv_flags_3_reg, end_rcvd_52) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_52_MASK) | (end_rcvd_52 << CP_NV_FLAGS_3_END_RCVD_52_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_53(cp_nv_flags_3_reg, discard_53) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_53_MASK) | (discard_53 << CP_NV_FLAGS_3_DISCARD_53_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_53(cp_nv_flags_3_reg, end_rcvd_53) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_53_MASK) | (end_rcvd_53 << CP_NV_FLAGS_3_END_RCVD_53_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_54(cp_nv_flags_3_reg, discard_54) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_54_MASK) | (discard_54 << CP_NV_FLAGS_3_DISCARD_54_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_54(cp_nv_flags_3_reg, end_rcvd_54) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_54_MASK) | (end_rcvd_54 << CP_NV_FLAGS_3_END_RCVD_54_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_55(cp_nv_flags_3_reg, discard_55) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_55_MASK) | (discard_55 << CP_NV_FLAGS_3_DISCARD_55_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_55(cp_nv_flags_3_reg, end_rcvd_55) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_55_MASK) | (end_rcvd_55 << CP_NV_FLAGS_3_END_RCVD_55_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_56(cp_nv_flags_3_reg, discard_56) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_56_MASK) | (discard_56 << CP_NV_FLAGS_3_DISCARD_56_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_56(cp_nv_flags_3_reg, end_rcvd_56) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_56_MASK) | (end_rcvd_56 << CP_NV_FLAGS_3_END_RCVD_56_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_57(cp_nv_flags_3_reg, discard_57) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_57_MASK) | (discard_57 << CP_NV_FLAGS_3_DISCARD_57_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_57(cp_nv_flags_3_reg, end_rcvd_57) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_57_MASK) | (end_rcvd_57 << CP_NV_FLAGS_3_END_RCVD_57_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_58(cp_nv_flags_3_reg, discard_58) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_58_MASK) | (discard_58 << CP_NV_FLAGS_3_DISCARD_58_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_58(cp_nv_flags_3_reg, end_rcvd_58) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_58_MASK) | (end_rcvd_58 << CP_NV_FLAGS_3_END_RCVD_58_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_59(cp_nv_flags_3_reg, discard_59) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_59_MASK) | (discard_59 << CP_NV_FLAGS_3_DISCARD_59_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_59(cp_nv_flags_3_reg, end_rcvd_59) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_59_MASK) | (end_rcvd_59 << CP_NV_FLAGS_3_END_RCVD_59_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_60(cp_nv_flags_3_reg, discard_60) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_60_MASK) | (discard_60 << CP_NV_FLAGS_3_DISCARD_60_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_60(cp_nv_flags_3_reg, end_rcvd_60) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_60_MASK) | (end_rcvd_60 << CP_NV_FLAGS_3_END_RCVD_60_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_61(cp_nv_flags_3_reg, discard_61) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_61_MASK) | (discard_61 << CP_NV_FLAGS_3_DISCARD_61_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_61(cp_nv_flags_3_reg, end_rcvd_61) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_61_MASK) | (end_rcvd_61 << CP_NV_FLAGS_3_END_RCVD_61_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_62(cp_nv_flags_3_reg, discard_62) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_62_MASK) | (discard_62 << CP_NV_FLAGS_3_DISCARD_62_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_62(cp_nv_flags_3_reg, end_rcvd_62) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_62_MASK) | (end_rcvd_62 << CP_NV_FLAGS_3_END_RCVD_62_SHIFT)
#define CP_NV_FLAGS_3_SET_DISCARD_63(cp_nv_flags_3_reg, discard_63) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_DISCARD_63_MASK) | (discard_63 << CP_NV_FLAGS_3_DISCARD_63_SHIFT)
#define CP_NV_FLAGS_3_SET_END_RCVD_63(cp_nv_flags_3_reg, end_rcvd_63) \
     cp_nv_flags_3_reg = (cp_nv_flags_3_reg & ~CP_NV_FLAGS_3_END_RCVD_63_MASK) | (end_rcvd_63 << CP_NV_FLAGS_3_END_RCVD_63_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_nv_flags_3_t {
          unsigned int discard_48                     : CP_NV_FLAGS_3_DISCARD_48_SIZE;
          unsigned int end_rcvd_48                    : CP_NV_FLAGS_3_END_RCVD_48_SIZE;
          unsigned int discard_49                     : CP_NV_FLAGS_3_DISCARD_49_SIZE;
          unsigned int end_rcvd_49                    : CP_NV_FLAGS_3_END_RCVD_49_SIZE;
          unsigned int discard_50                     : CP_NV_FLAGS_3_DISCARD_50_SIZE;
          unsigned int end_rcvd_50                    : CP_NV_FLAGS_3_END_RCVD_50_SIZE;
          unsigned int discard_51                     : CP_NV_FLAGS_3_DISCARD_51_SIZE;
          unsigned int end_rcvd_51                    : CP_NV_FLAGS_3_END_RCVD_51_SIZE;
          unsigned int discard_52                     : CP_NV_FLAGS_3_DISCARD_52_SIZE;
          unsigned int end_rcvd_52                    : CP_NV_FLAGS_3_END_RCVD_52_SIZE;
          unsigned int discard_53                     : CP_NV_FLAGS_3_DISCARD_53_SIZE;
          unsigned int end_rcvd_53                    : CP_NV_FLAGS_3_END_RCVD_53_SIZE;
          unsigned int discard_54                     : CP_NV_FLAGS_3_DISCARD_54_SIZE;
          unsigned int end_rcvd_54                    : CP_NV_FLAGS_3_END_RCVD_54_SIZE;
          unsigned int discard_55                     : CP_NV_FLAGS_3_DISCARD_55_SIZE;
          unsigned int end_rcvd_55                    : CP_NV_FLAGS_3_END_RCVD_55_SIZE;
          unsigned int discard_56                     : CP_NV_FLAGS_3_DISCARD_56_SIZE;
          unsigned int end_rcvd_56                    : CP_NV_FLAGS_3_END_RCVD_56_SIZE;
          unsigned int discard_57                     : CP_NV_FLAGS_3_DISCARD_57_SIZE;
          unsigned int end_rcvd_57                    : CP_NV_FLAGS_3_END_RCVD_57_SIZE;
          unsigned int discard_58                     : CP_NV_FLAGS_3_DISCARD_58_SIZE;
          unsigned int end_rcvd_58                    : CP_NV_FLAGS_3_END_RCVD_58_SIZE;
          unsigned int discard_59                     : CP_NV_FLAGS_3_DISCARD_59_SIZE;
          unsigned int end_rcvd_59                    : CP_NV_FLAGS_3_END_RCVD_59_SIZE;
          unsigned int discard_60                     : CP_NV_FLAGS_3_DISCARD_60_SIZE;
          unsigned int end_rcvd_60                    : CP_NV_FLAGS_3_END_RCVD_60_SIZE;
          unsigned int discard_61                     : CP_NV_FLAGS_3_DISCARD_61_SIZE;
          unsigned int end_rcvd_61                    : CP_NV_FLAGS_3_END_RCVD_61_SIZE;
          unsigned int discard_62                     : CP_NV_FLAGS_3_DISCARD_62_SIZE;
          unsigned int end_rcvd_62                    : CP_NV_FLAGS_3_END_RCVD_62_SIZE;
          unsigned int discard_63                     : CP_NV_FLAGS_3_DISCARD_63_SIZE;
          unsigned int end_rcvd_63                    : CP_NV_FLAGS_3_END_RCVD_63_SIZE;
     } cp_nv_flags_3_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_nv_flags_3_t {
          unsigned int end_rcvd_63                    : CP_NV_FLAGS_3_END_RCVD_63_SIZE;
          unsigned int discard_63                     : CP_NV_FLAGS_3_DISCARD_63_SIZE;
          unsigned int end_rcvd_62                    : CP_NV_FLAGS_3_END_RCVD_62_SIZE;
          unsigned int discard_62                     : CP_NV_FLAGS_3_DISCARD_62_SIZE;
          unsigned int end_rcvd_61                    : CP_NV_FLAGS_3_END_RCVD_61_SIZE;
          unsigned int discard_61                     : CP_NV_FLAGS_3_DISCARD_61_SIZE;
          unsigned int end_rcvd_60                    : CP_NV_FLAGS_3_END_RCVD_60_SIZE;
          unsigned int discard_60                     : CP_NV_FLAGS_3_DISCARD_60_SIZE;
          unsigned int end_rcvd_59                    : CP_NV_FLAGS_3_END_RCVD_59_SIZE;
          unsigned int discard_59                     : CP_NV_FLAGS_3_DISCARD_59_SIZE;
          unsigned int end_rcvd_58                    : CP_NV_FLAGS_3_END_RCVD_58_SIZE;
          unsigned int discard_58                     : CP_NV_FLAGS_3_DISCARD_58_SIZE;
          unsigned int end_rcvd_57                    : CP_NV_FLAGS_3_END_RCVD_57_SIZE;
          unsigned int discard_57                     : CP_NV_FLAGS_3_DISCARD_57_SIZE;
          unsigned int end_rcvd_56                    : CP_NV_FLAGS_3_END_RCVD_56_SIZE;
          unsigned int discard_56                     : CP_NV_FLAGS_3_DISCARD_56_SIZE;
          unsigned int end_rcvd_55                    : CP_NV_FLAGS_3_END_RCVD_55_SIZE;
          unsigned int discard_55                     : CP_NV_FLAGS_3_DISCARD_55_SIZE;
          unsigned int end_rcvd_54                    : CP_NV_FLAGS_3_END_RCVD_54_SIZE;
          unsigned int discard_54                     : CP_NV_FLAGS_3_DISCARD_54_SIZE;
          unsigned int end_rcvd_53                    : CP_NV_FLAGS_3_END_RCVD_53_SIZE;
          unsigned int discard_53                     : CP_NV_FLAGS_3_DISCARD_53_SIZE;
          unsigned int end_rcvd_52                    : CP_NV_FLAGS_3_END_RCVD_52_SIZE;
          unsigned int discard_52                     : CP_NV_FLAGS_3_DISCARD_52_SIZE;
          unsigned int end_rcvd_51                    : CP_NV_FLAGS_3_END_RCVD_51_SIZE;
          unsigned int discard_51                     : CP_NV_FLAGS_3_DISCARD_51_SIZE;
          unsigned int end_rcvd_50                    : CP_NV_FLAGS_3_END_RCVD_50_SIZE;
          unsigned int discard_50                     : CP_NV_FLAGS_3_DISCARD_50_SIZE;
          unsigned int end_rcvd_49                    : CP_NV_FLAGS_3_END_RCVD_49_SIZE;
          unsigned int discard_49                     : CP_NV_FLAGS_3_DISCARD_49_SIZE;
          unsigned int end_rcvd_48                    : CP_NV_FLAGS_3_END_RCVD_48_SIZE;
          unsigned int discard_48                     : CP_NV_FLAGS_3_DISCARD_48_SIZE;
     } cp_nv_flags_3_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_nv_flags_3_t f;
} cp_nv_flags_3_u;


/*
 * CP_STATE_DEBUG_INDEX struct
 */

#define CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_SIZE 5

#define CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_SHIFT 0

#define CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_MASK 0x0000001f

#define CP_STATE_DEBUG_INDEX_MASK \
     (CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_MASK)

#define CP_STATE_DEBUG_INDEX(state_debug_index) \
     ((state_debug_index << CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_SHIFT))

#define CP_STATE_DEBUG_INDEX_GET_STATE_DEBUG_INDEX(cp_state_debug_index) \
     ((cp_state_debug_index & CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_MASK) >> CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_SHIFT)

#define CP_STATE_DEBUG_INDEX_SET_STATE_DEBUG_INDEX(cp_state_debug_index_reg, state_debug_index) \
     cp_state_debug_index_reg = (cp_state_debug_index_reg & ~CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_MASK) | (state_debug_index << CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_state_debug_index_t {
          unsigned int state_debug_index              : CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_SIZE;
          unsigned int                                : 27;
     } cp_state_debug_index_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_state_debug_index_t {
          unsigned int                                : 27;
          unsigned int state_debug_index              : CP_STATE_DEBUG_INDEX_STATE_DEBUG_INDEX_SIZE;
     } cp_state_debug_index_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_state_debug_index_t f;
} cp_state_debug_index_u;


/*
 * CP_STATE_DEBUG_DATA struct
 */

#define CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_SIZE 32

#define CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_SHIFT 0

#define CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_MASK 0xffffffff

#define CP_STATE_DEBUG_DATA_MASK \
     (CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_MASK)

#define CP_STATE_DEBUG_DATA(state_debug_data) \
     ((state_debug_data << CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_SHIFT))

#define CP_STATE_DEBUG_DATA_GET_STATE_DEBUG_DATA(cp_state_debug_data) \
     ((cp_state_debug_data & CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_MASK) >> CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_SHIFT)

#define CP_STATE_DEBUG_DATA_SET_STATE_DEBUG_DATA(cp_state_debug_data_reg, state_debug_data) \
     cp_state_debug_data_reg = (cp_state_debug_data_reg & ~CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_MASK) | (state_debug_data << CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_state_debug_data_t {
          unsigned int state_debug_data               : CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_SIZE;
     } cp_state_debug_data_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_state_debug_data_t {
          unsigned int state_debug_data               : CP_STATE_DEBUG_DATA_STATE_DEBUG_DATA_SIZE;
     } cp_state_debug_data_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_state_debug_data_t f;
} cp_state_debug_data_u;


/*
 * CP_PROG_COUNTER struct
 */

#define CP_PROG_COUNTER_COUNTER_SIZE   32

#define CP_PROG_COUNTER_COUNTER_SHIFT  0

#define CP_PROG_COUNTER_COUNTER_MASK   0xffffffff

#define CP_PROG_COUNTER_MASK \
     (CP_PROG_COUNTER_COUNTER_MASK)

#define CP_PROG_COUNTER(counter) \
     ((counter << CP_PROG_COUNTER_COUNTER_SHIFT))

#define CP_PROG_COUNTER_GET_COUNTER(cp_prog_counter) \
     ((cp_prog_counter & CP_PROG_COUNTER_COUNTER_MASK) >> CP_PROG_COUNTER_COUNTER_SHIFT)

#define CP_PROG_COUNTER_SET_COUNTER(cp_prog_counter_reg, counter) \
     cp_prog_counter_reg = (cp_prog_counter_reg & ~CP_PROG_COUNTER_COUNTER_MASK) | (counter << CP_PROG_COUNTER_COUNTER_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_prog_counter_t {
          unsigned int counter                        : CP_PROG_COUNTER_COUNTER_SIZE;
     } cp_prog_counter_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_prog_counter_t {
          unsigned int counter                        : CP_PROG_COUNTER_COUNTER_SIZE;
     } cp_prog_counter_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_prog_counter_t f;
} cp_prog_counter_u;


/*
 * CP_STAT struct
 */

#define CP_STAT_MIU_WR_BUSY_SIZE       1
#define CP_STAT_MIU_RD_REQ_BUSY_SIZE   1
#define CP_STAT_MIU_RD_RETURN_BUSY_SIZE 1
#define CP_STAT_RBIU_BUSY_SIZE         1
#define CP_STAT_RCIU_BUSY_SIZE         1
#define CP_STAT_CSF_RING_BUSY_SIZE     1
#define CP_STAT_CSF_INDIRECTS_BUSY_SIZE 1
#define CP_STAT_CSF_INDIRECT2_BUSY_SIZE 1
#define CP_STAT_CSF_ST_BUSY_SIZE       1
#define CP_STAT_CSF_BUSY_SIZE          1
#define CP_STAT_RING_QUEUE_BUSY_SIZE   1
#define CP_STAT_INDIRECTS_QUEUE_BUSY_SIZE 1
#define CP_STAT_INDIRECT2_QUEUE_BUSY_SIZE 1
#define CP_STAT_ST_QUEUE_BUSY_SIZE     1
#define CP_STAT_PFP_BUSY_SIZE          1
#define CP_STAT_MEQ_RING_BUSY_SIZE     1
#define CP_STAT_MEQ_INDIRECTS_BUSY_SIZE 1
#define CP_STAT_MEQ_INDIRECT2_BUSY_SIZE 1
#define CP_STAT_MIU_WC_STALL_SIZE      1
#define CP_STAT_CP_NRT_BUSY_SIZE       1
#define CP_STAT__3D_BUSY_SIZE          1
#define CP_STAT_ME_BUSY_SIZE           1
#define CP_STAT_ME_WC_BUSY_SIZE        1
#define CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_SIZE 1
#define CP_STAT_CP_BUSY_SIZE           1

#define CP_STAT_MIU_WR_BUSY_SHIFT      0
#define CP_STAT_MIU_RD_REQ_BUSY_SHIFT  1
#define CP_STAT_MIU_RD_RETURN_BUSY_SHIFT 2
#define CP_STAT_RBIU_BUSY_SHIFT        3
#define CP_STAT_RCIU_BUSY_SHIFT        4
#define CP_STAT_CSF_RING_BUSY_SHIFT    5
#define CP_STAT_CSF_INDIRECTS_BUSY_SHIFT 6
#define CP_STAT_CSF_INDIRECT2_BUSY_SHIFT 7
#define CP_STAT_CSF_ST_BUSY_SHIFT      9
#define CP_STAT_CSF_BUSY_SHIFT         10
#define CP_STAT_RING_QUEUE_BUSY_SHIFT  11
#define CP_STAT_INDIRECTS_QUEUE_BUSY_SHIFT 12
#define CP_STAT_INDIRECT2_QUEUE_BUSY_SHIFT 13
#define CP_STAT_ST_QUEUE_BUSY_SHIFT    16
#define CP_STAT_PFP_BUSY_SHIFT         17
#define CP_STAT_MEQ_RING_BUSY_SHIFT    18
#define CP_STAT_MEQ_INDIRECTS_BUSY_SHIFT 19
#define CP_STAT_MEQ_INDIRECT2_BUSY_SHIFT 20
#define CP_STAT_MIU_WC_STALL_SHIFT     21
#define CP_STAT_CP_NRT_BUSY_SHIFT      22
#define CP_STAT__3D_BUSY_SHIFT         23
#define CP_STAT_ME_BUSY_SHIFT          26
#define CP_STAT_ME_WC_BUSY_SHIFT       29
#define CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_SHIFT 30
#define CP_STAT_CP_BUSY_SHIFT          31

#define CP_STAT_MIU_WR_BUSY_MASK       0x00000001
#define CP_STAT_MIU_RD_REQ_BUSY_MASK   0x00000002
#define CP_STAT_MIU_RD_RETURN_BUSY_MASK 0x00000004
#define CP_STAT_RBIU_BUSY_MASK         0x00000008
#define CP_STAT_RCIU_BUSY_MASK         0x00000010
#define CP_STAT_CSF_RING_BUSY_MASK     0x00000020
#define CP_STAT_CSF_INDIRECTS_BUSY_MASK 0x00000040
#define CP_STAT_CSF_INDIRECT2_BUSY_MASK 0x00000080
#define CP_STAT_CSF_ST_BUSY_MASK       0x00000200
#define CP_STAT_CSF_BUSY_MASK          0x00000400
#define CP_STAT_RING_QUEUE_BUSY_MASK   0x00000800
#define CP_STAT_INDIRECTS_QUEUE_BUSY_MASK 0x00001000
#define CP_STAT_INDIRECT2_QUEUE_BUSY_MASK 0x00002000
#define CP_STAT_ST_QUEUE_BUSY_MASK     0x00010000
#define CP_STAT_PFP_BUSY_MASK          0x00020000
#define CP_STAT_MEQ_RING_BUSY_MASK     0x00040000
#define CP_STAT_MEQ_INDIRECTS_BUSY_MASK 0x00080000
#define CP_STAT_MEQ_INDIRECT2_BUSY_MASK 0x00100000
#define CP_STAT_MIU_WC_STALL_MASK      0x00200000
#define CP_STAT_CP_NRT_BUSY_MASK       0x00400000
#define CP_STAT__3D_BUSY_MASK          0x00800000
#define CP_STAT_ME_BUSY_MASK           0x04000000
#define CP_STAT_ME_WC_BUSY_MASK        0x20000000
#define CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_MASK 0x40000000
#define CP_STAT_CP_BUSY_MASK           0x80000000

#define CP_STAT_MASK \
     (CP_STAT_MIU_WR_BUSY_MASK | \
      CP_STAT_MIU_RD_REQ_BUSY_MASK | \
      CP_STAT_MIU_RD_RETURN_BUSY_MASK | \
      CP_STAT_RBIU_BUSY_MASK | \
      CP_STAT_RCIU_BUSY_MASK | \
      CP_STAT_CSF_RING_BUSY_MASK | \
      CP_STAT_CSF_INDIRECTS_BUSY_MASK | \
      CP_STAT_CSF_INDIRECT2_BUSY_MASK | \
      CP_STAT_CSF_ST_BUSY_MASK | \
      CP_STAT_CSF_BUSY_MASK | \
      CP_STAT_RING_QUEUE_BUSY_MASK | \
      CP_STAT_INDIRECTS_QUEUE_BUSY_MASK | \
      CP_STAT_INDIRECT2_QUEUE_BUSY_MASK | \
      CP_STAT_ST_QUEUE_BUSY_MASK | \
      CP_STAT_PFP_BUSY_MASK | \
      CP_STAT_MEQ_RING_BUSY_MASK | \
      CP_STAT_MEQ_INDIRECTS_BUSY_MASK | \
      CP_STAT_MEQ_INDIRECT2_BUSY_MASK | \
      CP_STAT_MIU_WC_STALL_MASK | \
      CP_STAT_CP_NRT_BUSY_MASK | \
      CP_STAT__3D_BUSY_MASK | \
      CP_STAT_ME_BUSY_MASK | \
      CP_STAT_ME_WC_BUSY_MASK | \
      CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_MASK | \
      CP_STAT_CP_BUSY_MASK)

#define CP_STAT(miu_wr_busy, miu_rd_req_busy, miu_rd_return_busy, rbiu_busy, rciu_busy, csf_ring_busy, csf_indirects_busy, csf_indirect2_busy, csf_st_busy, csf_busy, ring_queue_busy, indirects_queue_busy, indirect2_queue_busy, st_queue_busy, pfp_busy, meq_ring_busy, meq_indirects_busy, meq_indirect2_busy, miu_wc_stall, cp_nrt_busy, _3d_busy, me_busy, me_wc_busy, miu_wc_track_fifo_empty, cp_busy) \
     ((miu_wr_busy << CP_STAT_MIU_WR_BUSY_SHIFT) | \
      (miu_rd_req_busy << CP_STAT_MIU_RD_REQ_BUSY_SHIFT) | \
      (miu_rd_return_busy << CP_STAT_MIU_RD_RETURN_BUSY_SHIFT) | \
      (rbiu_busy << CP_STAT_RBIU_BUSY_SHIFT) | \
      (rciu_busy << CP_STAT_RCIU_BUSY_SHIFT) | \
      (csf_ring_busy << CP_STAT_CSF_RING_BUSY_SHIFT) | \
      (csf_indirects_busy << CP_STAT_CSF_INDIRECTS_BUSY_SHIFT) | \
      (csf_indirect2_busy << CP_STAT_CSF_INDIRECT2_BUSY_SHIFT) | \
      (csf_st_busy << CP_STAT_CSF_ST_BUSY_SHIFT) | \
      (csf_busy << CP_STAT_CSF_BUSY_SHIFT) | \
      (ring_queue_busy << CP_STAT_RING_QUEUE_BUSY_SHIFT) | \
      (indirects_queue_busy << CP_STAT_INDIRECTS_QUEUE_BUSY_SHIFT) | \
      (indirect2_queue_busy << CP_STAT_INDIRECT2_QUEUE_BUSY_SHIFT) | \
      (st_queue_busy << CP_STAT_ST_QUEUE_BUSY_SHIFT) | \
      (pfp_busy << CP_STAT_PFP_BUSY_SHIFT) | \
      (meq_ring_busy << CP_STAT_MEQ_RING_BUSY_SHIFT) | \
      (meq_indirects_busy << CP_STAT_MEQ_INDIRECTS_BUSY_SHIFT) | \
      (meq_indirect2_busy << CP_STAT_MEQ_INDIRECT2_BUSY_SHIFT) | \
      (miu_wc_stall << CP_STAT_MIU_WC_STALL_SHIFT) | \
      (cp_nrt_busy << CP_STAT_CP_NRT_BUSY_SHIFT) | \
      (_3d_busy << CP_STAT__3D_BUSY_SHIFT) | \
      (me_busy << CP_STAT_ME_BUSY_SHIFT) | \
      (me_wc_busy << CP_STAT_ME_WC_BUSY_SHIFT) | \
      (miu_wc_track_fifo_empty << CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_SHIFT) | \
      (cp_busy << CP_STAT_CP_BUSY_SHIFT))

#define CP_STAT_GET_MIU_WR_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_MIU_WR_BUSY_MASK) >> CP_STAT_MIU_WR_BUSY_SHIFT)
#define CP_STAT_GET_MIU_RD_REQ_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_MIU_RD_REQ_BUSY_MASK) >> CP_STAT_MIU_RD_REQ_BUSY_SHIFT)
#define CP_STAT_GET_MIU_RD_RETURN_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_MIU_RD_RETURN_BUSY_MASK) >> CP_STAT_MIU_RD_RETURN_BUSY_SHIFT)
#define CP_STAT_GET_RBIU_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_RBIU_BUSY_MASK) >> CP_STAT_RBIU_BUSY_SHIFT)
#define CP_STAT_GET_RCIU_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_RCIU_BUSY_MASK) >> CP_STAT_RCIU_BUSY_SHIFT)
#define CP_STAT_GET_CSF_RING_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_CSF_RING_BUSY_MASK) >> CP_STAT_CSF_RING_BUSY_SHIFT)
#define CP_STAT_GET_CSF_INDIRECTS_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_CSF_INDIRECTS_BUSY_MASK) >> CP_STAT_CSF_INDIRECTS_BUSY_SHIFT)
#define CP_STAT_GET_CSF_INDIRECT2_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_CSF_INDIRECT2_BUSY_MASK) >> CP_STAT_CSF_INDIRECT2_BUSY_SHIFT)
#define CP_STAT_GET_CSF_ST_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_CSF_ST_BUSY_MASK) >> CP_STAT_CSF_ST_BUSY_SHIFT)
#define CP_STAT_GET_CSF_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_CSF_BUSY_MASK) >> CP_STAT_CSF_BUSY_SHIFT)
#define CP_STAT_GET_RING_QUEUE_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_RING_QUEUE_BUSY_MASK) >> CP_STAT_RING_QUEUE_BUSY_SHIFT)
#define CP_STAT_GET_INDIRECTS_QUEUE_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_INDIRECTS_QUEUE_BUSY_MASK) >> CP_STAT_INDIRECTS_QUEUE_BUSY_SHIFT)
#define CP_STAT_GET_INDIRECT2_QUEUE_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_INDIRECT2_QUEUE_BUSY_MASK) >> CP_STAT_INDIRECT2_QUEUE_BUSY_SHIFT)
#define CP_STAT_GET_ST_QUEUE_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_ST_QUEUE_BUSY_MASK) >> CP_STAT_ST_QUEUE_BUSY_SHIFT)
#define CP_STAT_GET_PFP_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_PFP_BUSY_MASK) >> CP_STAT_PFP_BUSY_SHIFT)
#define CP_STAT_GET_MEQ_RING_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_MEQ_RING_BUSY_MASK) >> CP_STAT_MEQ_RING_BUSY_SHIFT)
#define CP_STAT_GET_MEQ_INDIRECTS_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_MEQ_INDIRECTS_BUSY_MASK) >> CP_STAT_MEQ_INDIRECTS_BUSY_SHIFT)
#define CP_STAT_GET_MEQ_INDIRECT2_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_MEQ_INDIRECT2_BUSY_MASK) >> CP_STAT_MEQ_INDIRECT2_BUSY_SHIFT)
#define CP_STAT_GET_MIU_WC_STALL(cp_stat) \
     ((cp_stat & CP_STAT_MIU_WC_STALL_MASK) >> CP_STAT_MIU_WC_STALL_SHIFT)
#define CP_STAT_GET_CP_NRT_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_CP_NRT_BUSY_MASK) >> CP_STAT_CP_NRT_BUSY_SHIFT)
#define CP_STAT_GET__3D_BUSY(cp_stat) \
     ((cp_stat & CP_STAT__3D_BUSY_MASK) >> CP_STAT__3D_BUSY_SHIFT)
#define CP_STAT_GET_ME_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_ME_BUSY_MASK) >> CP_STAT_ME_BUSY_SHIFT)
#define CP_STAT_GET_ME_WC_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_ME_WC_BUSY_MASK) >> CP_STAT_ME_WC_BUSY_SHIFT)
#define CP_STAT_GET_MIU_WC_TRACK_FIFO_EMPTY(cp_stat) \
     ((cp_stat & CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_MASK) >> CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_SHIFT)
#define CP_STAT_GET_CP_BUSY(cp_stat) \
     ((cp_stat & CP_STAT_CP_BUSY_MASK) >> CP_STAT_CP_BUSY_SHIFT)

#define CP_STAT_SET_MIU_WR_BUSY(cp_stat_reg, miu_wr_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_MIU_WR_BUSY_MASK) | (miu_wr_busy << CP_STAT_MIU_WR_BUSY_SHIFT)
#define CP_STAT_SET_MIU_RD_REQ_BUSY(cp_stat_reg, miu_rd_req_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_MIU_RD_REQ_BUSY_MASK) | (miu_rd_req_busy << CP_STAT_MIU_RD_REQ_BUSY_SHIFT)
#define CP_STAT_SET_MIU_RD_RETURN_BUSY(cp_stat_reg, miu_rd_return_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_MIU_RD_RETURN_BUSY_MASK) | (miu_rd_return_busy << CP_STAT_MIU_RD_RETURN_BUSY_SHIFT)
#define CP_STAT_SET_RBIU_BUSY(cp_stat_reg, rbiu_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_RBIU_BUSY_MASK) | (rbiu_busy << CP_STAT_RBIU_BUSY_SHIFT)
#define CP_STAT_SET_RCIU_BUSY(cp_stat_reg, rciu_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_RCIU_BUSY_MASK) | (rciu_busy << CP_STAT_RCIU_BUSY_SHIFT)
#define CP_STAT_SET_CSF_RING_BUSY(cp_stat_reg, csf_ring_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_CSF_RING_BUSY_MASK) | (csf_ring_busy << CP_STAT_CSF_RING_BUSY_SHIFT)
#define CP_STAT_SET_CSF_INDIRECTS_BUSY(cp_stat_reg, csf_indirects_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_CSF_INDIRECTS_BUSY_MASK) | (csf_indirects_busy << CP_STAT_CSF_INDIRECTS_BUSY_SHIFT)
#define CP_STAT_SET_CSF_INDIRECT2_BUSY(cp_stat_reg, csf_indirect2_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_CSF_INDIRECT2_BUSY_MASK) | (csf_indirect2_busy << CP_STAT_CSF_INDIRECT2_BUSY_SHIFT)
#define CP_STAT_SET_CSF_ST_BUSY(cp_stat_reg, csf_st_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_CSF_ST_BUSY_MASK) | (csf_st_busy << CP_STAT_CSF_ST_BUSY_SHIFT)
#define CP_STAT_SET_CSF_BUSY(cp_stat_reg, csf_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_CSF_BUSY_MASK) | (csf_busy << CP_STAT_CSF_BUSY_SHIFT)
#define CP_STAT_SET_RING_QUEUE_BUSY(cp_stat_reg, ring_queue_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_RING_QUEUE_BUSY_MASK) | (ring_queue_busy << CP_STAT_RING_QUEUE_BUSY_SHIFT)
#define CP_STAT_SET_INDIRECTS_QUEUE_BUSY(cp_stat_reg, indirects_queue_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_INDIRECTS_QUEUE_BUSY_MASK) | (indirects_queue_busy << CP_STAT_INDIRECTS_QUEUE_BUSY_SHIFT)
#define CP_STAT_SET_INDIRECT2_QUEUE_BUSY(cp_stat_reg, indirect2_queue_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_INDIRECT2_QUEUE_BUSY_MASK) | (indirect2_queue_busy << CP_STAT_INDIRECT2_QUEUE_BUSY_SHIFT)
#define CP_STAT_SET_ST_QUEUE_BUSY(cp_stat_reg, st_queue_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_ST_QUEUE_BUSY_MASK) | (st_queue_busy << CP_STAT_ST_QUEUE_BUSY_SHIFT)
#define CP_STAT_SET_PFP_BUSY(cp_stat_reg, pfp_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_PFP_BUSY_MASK) | (pfp_busy << CP_STAT_PFP_BUSY_SHIFT)
#define CP_STAT_SET_MEQ_RING_BUSY(cp_stat_reg, meq_ring_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_MEQ_RING_BUSY_MASK) | (meq_ring_busy << CP_STAT_MEQ_RING_BUSY_SHIFT)
#define CP_STAT_SET_MEQ_INDIRECTS_BUSY(cp_stat_reg, meq_indirects_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_MEQ_INDIRECTS_BUSY_MASK) | (meq_indirects_busy << CP_STAT_MEQ_INDIRECTS_BUSY_SHIFT)
#define CP_STAT_SET_MEQ_INDIRECT2_BUSY(cp_stat_reg, meq_indirect2_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_MEQ_INDIRECT2_BUSY_MASK) | (meq_indirect2_busy << CP_STAT_MEQ_INDIRECT2_BUSY_SHIFT)
#define CP_STAT_SET_MIU_WC_STALL(cp_stat_reg, miu_wc_stall) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_MIU_WC_STALL_MASK) | (miu_wc_stall << CP_STAT_MIU_WC_STALL_SHIFT)
#define CP_STAT_SET_CP_NRT_BUSY(cp_stat_reg, cp_nrt_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_CP_NRT_BUSY_MASK) | (cp_nrt_busy << CP_STAT_CP_NRT_BUSY_SHIFT)
#define CP_STAT_SET__3D_BUSY(cp_stat_reg, _3d_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT__3D_BUSY_MASK) | (_3d_busy << CP_STAT__3D_BUSY_SHIFT)
#define CP_STAT_SET_ME_BUSY(cp_stat_reg, me_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_ME_BUSY_MASK) | (me_busy << CP_STAT_ME_BUSY_SHIFT)
#define CP_STAT_SET_ME_WC_BUSY(cp_stat_reg, me_wc_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_ME_WC_BUSY_MASK) | (me_wc_busy << CP_STAT_ME_WC_BUSY_SHIFT)
#define CP_STAT_SET_MIU_WC_TRACK_FIFO_EMPTY(cp_stat_reg, miu_wc_track_fifo_empty) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_MASK) | (miu_wc_track_fifo_empty << CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_SHIFT)
#define CP_STAT_SET_CP_BUSY(cp_stat_reg, cp_busy) \
     cp_stat_reg = (cp_stat_reg & ~CP_STAT_CP_BUSY_MASK) | (cp_busy << CP_STAT_CP_BUSY_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _cp_stat_t {
          unsigned int miu_wr_busy                    : CP_STAT_MIU_WR_BUSY_SIZE;
          unsigned int miu_rd_req_busy                : CP_STAT_MIU_RD_REQ_BUSY_SIZE;
          unsigned int miu_rd_return_busy             : CP_STAT_MIU_RD_RETURN_BUSY_SIZE;
          unsigned int rbiu_busy                      : CP_STAT_RBIU_BUSY_SIZE;
          unsigned int rciu_busy                      : CP_STAT_RCIU_BUSY_SIZE;
          unsigned int csf_ring_busy                  : CP_STAT_CSF_RING_BUSY_SIZE;
          unsigned int csf_indirects_busy             : CP_STAT_CSF_INDIRECTS_BUSY_SIZE;
          unsigned int csf_indirect2_busy             : CP_STAT_CSF_INDIRECT2_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int csf_st_busy                    : CP_STAT_CSF_ST_BUSY_SIZE;
          unsigned int csf_busy                       : CP_STAT_CSF_BUSY_SIZE;
          unsigned int ring_queue_busy                : CP_STAT_RING_QUEUE_BUSY_SIZE;
          unsigned int indirects_queue_busy           : CP_STAT_INDIRECTS_QUEUE_BUSY_SIZE;
          unsigned int indirect2_queue_busy           : CP_STAT_INDIRECT2_QUEUE_BUSY_SIZE;
          unsigned int                                : 2;
          unsigned int st_queue_busy                  : CP_STAT_ST_QUEUE_BUSY_SIZE;
          unsigned int pfp_busy                       : CP_STAT_PFP_BUSY_SIZE;
          unsigned int meq_ring_busy                  : CP_STAT_MEQ_RING_BUSY_SIZE;
          unsigned int meq_indirects_busy             : CP_STAT_MEQ_INDIRECTS_BUSY_SIZE;
          unsigned int meq_indirect2_busy             : CP_STAT_MEQ_INDIRECT2_BUSY_SIZE;
          unsigned int miu_wc_stall                   : CP_STAT_MIU_WC_STALL_SIZE;
          unsigned int cp_nrt_busy                    : CP_STAT_CP_NRT_BUSY_SIZE;
          unsigned int _3d_busy                       : CP_STAT__3D_BUSY_SIZE;
          unsigned int                                : 2;
          unsigned int me_busy                        : CP_STAT_ME_BUSY_SIZE;
          unsigned int                                : 2;
          unsigned int me_wc_busy                     : CP_STAT_ME_WC_BUSY_SIZE;
          unsigned int miu_wc_track_fifo_empty        : CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_SIZE;
          unsigned int cp_busy                        : CP_STAT_CP_BUSY_SIZE;
     } cp_stat_t;

#else   // !BIGENDIAN_OS

     typedef struct _cp_stat_t {
          unsigned int cp_busy                        : CP_STAT_CP_BUSY_SIZE;
          unsigned int miu_wc_track_fifo_empty        : CP_STAT_MIU_WC_TRACK_FIFO_EMPTY_SIZE;
          unsigned int me_wc_busy                     : CP_STAT_ME_WC_BUSY_SIZE;
          unsigned int                                : 2;
          unsigned int me_busy                        : CP_STAT_ME_BUSY_SIZE;
          unsigned int                                : 2;
          unsigned int _3d_busy                       : CP_STAT__3D_BUSY_SIZE;
          unsigned int cp_nrt_busy                    : CP_STAT_CP_NRT_BUSY_SIZE;
          unsigned int miu_wc_stall                   : CP_STAT_MIU_WC_STALL_SIZE;
          unsigned int meq_indirect2_busy             : CP_STAT_MEQ_INDIRECT2_BUSY_SIZE;
          unsigned int meq_indirects_busy             : CP_STAT_MEQ_INDIRECTS_BUSY_SIZE;
          unsigned int meq_ring_busy                  : CP_STAT_MEQ_RING_BUSY_SIZE;
          unsigned int pfp_busy                       : CP_STAT_PFP_BUSY_SIZE;
          unsigned int st_queue_busy                  : CP_STAT_ST_QUEUE_BUSY_SIZE;
          unsigned int                                : 2;
          unsigned int indirect2_queue_busy           : CP_STAT_INDIRECT2_QUEUE_BUSY_SIZE;
          unsigned int indirects_queue_busy           : CP_STAT_INDIRECTS_QUEUE_BUSY_SIZE;
          unsigned int ring_queue_busy                : CP_STAT_RING_QUEUE_BUSY_SIZE;
          unsigned int csf_busy                       : CP_STAT_CSF_BUSY_SIZE;
          unsigned int csf_st_busy                    : CP_STAT_CSF_ST_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int csf_indirect2_busy             : CP_STAT_CSF_INDIRECT2_BUSY_SIZE;
          unsigned int csf_indirects_busy             : CP_STAT_CSF_INDIRECTS_BUSY_SIZE;
          unsigned int csf_ring_busy                  : CP_STAT_CSF_RING_BUSY_SIZE;
          unsigned int rciu_busy                      : CP_STAT_RCIU_BUSY_SIZE;
          unsigned int rbiu_busy                      : CP_STAT_RBIU_BUSY_SIZE;
          unsigned int miu_rd_return_busy             : CP_STAT_MIU_RD_RETURN_BUSY_SIZE;
          unsigned int miu_rd_req_busy                : CP_STAT_MIU_RD_REQ_BUSY_SIZE;
          unsigned int miu_wr_busy                    : CP_STAT_MIU_WR_BUSY_SIZE;
     } cp_stat_t;

#endif

typedef union {
     unsigned int val : 32;
     cp_stat_t f;
} cp_stat_u;


/*
 * BIOS_0_SCRATCH struct
 */

#define BIOS_0_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_0_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_0_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_0_SCRATCH_MASK \
     (BIOS_0_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_0_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_0_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_0_SCRATCH_GET_BIOS_SCRATCH(bios_0_scratch) \
     ((bios_0_scratch & BIOS_0_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_0_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_0_SCRATCH_SET_BIOS_SCRATCH(bios_0_scratch_reg, bios_scratch) \
     bios_0_scratch_reg = (bios_0_scratch_reg & ~BIOS_0_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_0_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_0_scratch_t {
          unsigned int bios_scratch                   : BIOS_0_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_0_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_0_scratch_t {
          unsigned int bios_scratch                   : BIOS_0_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_0_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_0_scratch_t f;
} bios_0_scratch_u;


/*
 * BIOS_1_SCRATCH struct
 */

#define BIOS_1_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_1_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_1_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_1_SCRATCH_MASK \
     (BIOS_1_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_1_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_1_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_1_SCRATCH_GET_BIOS_SCRATCH(bios_1_scratch) \
     ((bios_1_scratch & BIOS_1_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_1_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_1_SCRATCH_SET_BIOS_SCRATCH(bios_1_scratch_reg, bios_scratch) \
     bios_1_scratch_reg = (bios_1_scratch_reg & ~BIOS_1_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_1_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_1_scratch_t {
          unsigned int bios_scratch                   : BIOS_1_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_1_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_1_scratch_t {
          unsigned int bios_scratch                   : BIOS_1_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_1_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_1_scratch_t f;
} bios_1_scratch_u;


/*
 * BIOS_2_SCRATCH struct
 */

#define BIOS_2_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_2_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_2_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_2_SCRATCH_MASK \
     (BIOS_2_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_2_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_2_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_2_SCRATCH_GET_BIOS_SCRATCH(bios_2_scratch) \
     ((bios_2_scratch & BIOS_2_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_2_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_2_SCRATCH_SET_BIOS_SCRATCH(bios_2_scratch_reg, bios_scratch) \
     bios_2_scratch_reg = (bios_2_scratch_reg & ~BIOS_2_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_2_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_2_scratch_t {
          unsigned int bios_scratch                   : BIOS_2_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_2_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_2_scratch_t {
          unsigned int bios_scratch                   : BIOS_2_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_2_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_2_scratch_t f;
} bios_2_scratch_u;


/*
 * BIOS_3_SCRATCH struct
 */

#define BIOS_3_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_3_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_3_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_3_SCRATCH_MASK \
     (BIOS_3_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_3_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_3_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_3_SCRATCH_GET_BIOS_SCRATCH(bios_3_scratch) \
     ((bios_3_scratch & BIOS_3_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_3_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_3_SCRATCH_SET_BIOS_SCRATCH(bios_3_scratch_reg, bios_scratch) \
     bios_3_scratch_reg = (bios_3_scratch_reg & ~BIOS_3_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_3_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_3_scratch_t {
          unsigned int bios_scratch                   : BIOS_3_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_3_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_3_scratch_t {
          unsigned int bios_scratch                   : BIOS_3_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_3_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_3_scratch_t f;
} bios_3_scratch_u;


/*
 * BIOS_4_SCRATCH struct
 */

#define BIOS_4_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_4_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_4_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_4_SCRATCH_MASK \
     (BIOS_4_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_4_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_4_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_4_SCRATCH_GET_BIOS_SCRATCH(bios_4_scratch) \
     ((bios_4_scratch & BIOS_4_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_4_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_4_SCRATCH_SET_BIOS_SCRATCH(bios_4_scratch_reg, bios_scratch) \
     bios_4_scratch_reg = (bios_4_scratch_reg & ~BIOS_4_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_4_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_4_scratch_t {
          unsigned int bios_scratch                   : BIOS_4_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_4_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_4_scratch_t {
          unsigned int bios_scratch                   : BIOS_4_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_4_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_4_scratch_t f;
} bios_4_scratch_u;


/*
 * BIOS_5_SCRATCH struct
 */

#define BIOS_5_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_5_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_5_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_5_SCRATCH_MASK \
     (BIOS_5_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_5_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_5_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_5_SCRATCH_GET_BIOS_SCRATCH(bios_5_scratch) \
     ((bios_5_scratch & BIOS_5_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_5_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_5_SCRATCH_SET_BIOS_SCRATCH(bios_5_scratch_reg, bios_scratch) \
     bios_5_scratch_reg = (bios_5_scratch_reg & ~BIOS_5_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_5_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_5_scratch_t {
          unsigned int bios_scratch                   : BIOS_5_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_5_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_5_scratch_t {
          unsigned int bios_scratch                   : BIOS_5_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_5_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_5_scratch_t f;
} bios_5_scratch_u;


/*
 * BIOS_6_SCRATCH struct
 */

#define BIOS_6_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_6_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_6_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_6_SCRATCH_MASK \
     (BIOS_6_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_6_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_6_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_6_SCRATCH_GET_BIOS_SCRATCH(bios_6_scratch) \
     ((bios_6_scratch & BIOS_6_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_6_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_6_SCRATCH_SET_BIOS_SCRATCH(bios_6_scratch_reg, bios_scratch) \
     bios_6_scratch_reg = (bios_6_scratch_reg & ~BIOS_6_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_6_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_6_scratch_t {
          unsigned int bios_scratch                   : BIOS_6_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_6_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_6_scratch_t {
          unsigned int bios_scratch                   : BIOS_6_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_6_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_6_scratch_t f;
} bios_6_scratch_u;


/*
 * BIOS_7_SCRATCH struct
 */

#define BIOS_7_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_7_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_7_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_7_SCRATCH_MASK \
     (BIOS_7_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_7_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_7_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_7_SCRATCH_GET_BIOS_SCRATCH(bios_7_scratch) \
     ((bios_7_scratch & BIOS_7_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_7_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_7_SCRATCH_SET_BIOS_SCRATCH(bios_7_scratch_reg, bios_scratch) \
     bios_7_scratch_reg = (bios_7_scratch_reg & ~BIOS_7_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_7_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_7_scratch_t {
          unsigned int bios_scratch                   : BIOS_7_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_7_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_7_scratch_t {
          unsigned int bios_scratch                   : BIOS_7_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_7_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_7_scratch_t f;
} bios_7_scratch_u;


/*
 * BIOS_8_SCRATCH struct
 */

#define BIOS_8_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_8_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_8_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_8_SCRATCH_MASK \
     (BIOS_8_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_8_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_8_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_8_SCRATCH_GET_BIOS_SCRATCH(bios_8_scratch) \
     ((bios_8_scratch & BIOS_8_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_8_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_8_SCRATCH_SET_BIOS_SCRATCH(bios_8_scratch_reg, bios_scratch) \
     bios_8_scratch_reg = (bios_8_scratch_reg & ~BIOS_8_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_8_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_8_scratch_t {
          unsigned int bios_scratch                   : BIOS_8_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_8_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_8_scratch_t {
          unsigned int bios_scratch                   : BIOS_8_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_8_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_8_scratch_t f;
} bios_8_scratch_u;


/*
 * BIOS_9_SCRATCH struct
 */

#define BIOS_9_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_9_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_9_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_9_SCRATCH_MASK \
     (BIOS_9_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_9_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_9_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_9_SCRATCH_GET_BIOS_SCRATCH(bios_9_scratch) \
     ((bios_9_scratch & BIOS_9_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_9_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_9_SCRATCH_SET_BIOS_SCRATCH(bios_9_scratch_reg, bios_scratch) \
     bios_9_scratch_reg = (bios_9_scratch_reg & ~BIOS_9_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_9_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_9_scratch_t {
          unsigned int bios_scratch                   : BIOS_9_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_9_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_9_scratch_t {
          unsigned int bios_scratch                   : BIOS_9_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_9_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_9_scratch_t f;
} bios_9_scratch_u;


/*
 * BIOS_10_SCRATCH struct
 */

#define BIOS_10_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_10_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_10_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_10_SCRATCH_MASK \
     (BIOS_10_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_10_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_10_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_10_SCRATCH_GET_BIOS_SCRATCH(bios_10_scratch) \
     ((bios_10_scratch & BIOS_10_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_10_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_10_SCRATCH_SET_BIOS_SCRATCH(bios_10_scratch_reg, bios_scratch) \
     bios_10_scratch_reg = (bios_10_scratch_reg & ~BIOS_10_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_10_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_10_scratch_t {
          unsigned int bios_scratch                   : BIOS_10_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_10_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_10_scratch_t {
          unsigned int bios_scratch                   : BIOS_10_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_10_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_10_scratch_t f;
} bios_10_scratch_u;


/*
 * BIOS_11_SCRATCH struct
 */

#define BIOS_11_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_11_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_11_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_11_SCRATCH_MASK \
     (BIOS_11_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_11_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_11_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_11_SCRATCH_GET_BIOS_SCRATCH(bios_11_scratch) \
     ((bios_11_scratch & BIOS_11_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_11_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_11_SCRATCH_SET_BIOS_SCRATCH(bios_11_scratch_reg, bios_scratch) \
     bios_11_scratch_reg = (bios_11_scratch_reg & ~BIOS_11_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_11_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_11_scratch_t {
          unsigned int bios_scratch                   : BIOS_11_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_11_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_11_scratch_t {
          unsigned int bios_scratch                   : BIOS_11_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_11_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_11_scratch_t f;
} bios_11_scratch_u;


/*
 * BIOS_12_SCRATCH struct
 */

#define BIOS_12_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_12_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_12_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_12_SCRATCH_MASK \
     (BIOS_12_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_12_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_12_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_12_SCRATCH_GET_BIOS_SCRATCH(bios_12_scratch) \
     ((bios_12_scratch & BIOS_12_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_12_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_12_SCRATCH_SET_BIOS_SCRATCH(bios_12_scratch_reg, bios_scratch) \
     bios_12_scratch_reg = (bios_12_scratch_reg & ~BIOS_12_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_12_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_12_scratch_t {
          unsigned int bios_scratch                   : BIOS_12_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_12_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_12_scratch_t {
          unsigned int bios_scratch                   : BIOS_12_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_12_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_12_scratch_t f;
} bios_12_scratch_u;


/*
 * BIOS_13_SCRATCH struct
 */

#define BIOS_13_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_13_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_13_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_13_SCRATCH_MASK \
     (BIOS_13_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_13_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_13_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_13_SCRATCH_GET_BIOS_SCRATCH(bios_13_scratch) \
     ((bios_13_scratch & BIOS_13_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_13_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_13_SCRATCH_SET_BIOS_SCRATCH(bios_13_scratch_reg, bios_scratch) \
     bios_13_scratch_reg = (bios_13_scratch_reg & ~BIOS_13_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_13_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_13_scratch_t {
          unsigned int bios_scratch                   : BIOS_13_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_13_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_13_scratch_t {
          unsigned int bios_scratch                   : BIOS_13_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_13_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_13_scratch_t f;
} bios_13_scratch_u;


/*
 * BIOS_14_SCRATCH struct
 */

#define BIOS_14_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_14_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_14_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_14_SCRATCH_MASK \
     (BIOS_14_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_14_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_14_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_14_SCRATCH_GET_BIOS_SCRATCH(bios_14_scratch) \
     ((bios_14_scratch & BIOS_14_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_14_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_14_SCRATCH_SET_BIOS_SCRATCH(bios_14_scratch_reg, bios_scratch) \
     bios_14_scratch_reg = (bios_14_scratch_reg & ~BIOS_14_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_14_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_14_scratch_t {
          unsigned int bios_scratch                   : BIOS_14_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_14_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_14_scratch_t {
          unsigned int bios_scratch                   : BIOS_14_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_14_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_14_scratch_t f;
} bios_14_scratch_u;


/*
 * BIOS_15_SCRATCH struct
 */

#define BIOS_15_SCRATCH_BIOS_SCRATCH_SIZE 32

#define BIOS_15_SCRATCH_BIOS_SCRATCH_SHIFT 0

#define BIOS_15_SCRATCH_BIOS_SCRATCH_MASK 0xffffffff

#define BIOS_15_SCRATCH_MASK \
     (BIOS_15_SCRATCH_BIOS_SCRATCH_MASK)

#define BIOS_15_SCRATCH(bios_scratch) \
     ((bios_scratch << BIOS_15_SCRATCH_BIOS_SCRATCH_SHIFT))

#define BIOS_15_SCRATCH_GET_BIOS_SCRATCH(bios_15_scratch) \
     ((bios_15_scratch & BIOS_15_SCRATCH_BIOS_SCRATCH_MASK) >> BIOS_15_SCRATCH_BIOS_SCRATCH_SHIFT)

#define BIOS_15_SCRATCH_SET_BIOS_SCRATCH(bios_15_scratch_reg, bios_scratch) \
     bios_15_scratch_reg = (bios_15_scratch_reg & ~BIOS_15_SCRATCH_BIOS_SCRATCH_MASK) | (bios_scratch << BIOS_15_SCRATCH_BIOS_SCRATCH_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _bios_15_scratch_t {
          unsigned int bios_scratch                   : BIOS_15_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_15_scratch_t;

#else   // !BIGENDIAN_OS

     typedef struct _bios_15_scratch_t {
          unsigned int bios_scratch                   : BIOS_15_SCRATCH_BIOS_SCRATCH_SIZE;
     } bios_15_scratch_t;

#endif

typedef union {
     unsigned int val : 32;
     bios_15_scratch_t f;
} bios_15_scratch_u;


/*
 * COHER_SIZE_PM4 struct
 */

#define COHER_SIZE_PM4_SIZE_SIZE       32

#define COHER_SIZE_PM4_SIZE_SHIFT      0

#define COHER_SIZE_PM4_SIZE_MASK       0xffffffff

#define COHER_SIZE_PM4_MASK \
     (COHER_SIZE_PM4_SIZE_MASK)

#define COHER_SIZE_PM4(size) \
     ((size << COHER_SIZE_PM4_SIZE_SHIFT))

#define COHER_SIZE_PM4_GET_SIZE(coher_size_pm4) \
     ((coher_size_pm4 & COHER_SIZE_PM4_SIZE_MASK) >> COHER_SIZE_PM4_SIZE_SHIFT)

#define COHER_SIZE_PM4_SET_SIZE(coher_size_pm4_reg, size) \
     coher_size_pm4_reg = (coher_size_pm4_reg & ~COHER_SIZE_PM4_SIZE_MASK) | (size << COHER_SIZE_PM4_SIZE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_size_pm4_t {
          unsigned int size                           : COHER_SIZE_PM4_SIZE_SIZE;
     } coher_size_pm4_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_size_pm4_t {
          unsigned int size                           : COHER_SIZE_PM4_SIZE_SIZE;
     } coher_size_pm4_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_size_pm4_t f;
} coher_size_pm4_u;


/*
 * COHER_BASE_PM4 struct
 */

#define COHER_BASE_PM4_BASE_SIZE       32

#define COHER_BASE_PM4_BASE_SHIFT      0

#define COHER_BASE_PM4_BASE_MASK       0xffffffff

#define COHER_BASE_PM4_MASK \
     (COHER_BASE_PM4_BASE_MASK)

#define COHER_BASE_PM4(base) \
     ((base << COHER_BASE_PM4_BASE_SHIFT))

#define COHER_BASE_PM4_GET_BASE(coher_base_pm4) \
     ((coher_base_pm4 & COHER_BASE_PM4_BASE_MASK) >> COHER_BASE_PM4_BASE_SHIFT)

#define COHER_BASE_PM4_SET_BASE(coher_base_pm4_reg, base) \
     coher_base_pm4_reg = (coher_base_pm4_reg & ~COHER_BASE_PM4_BASE_MASK) | (base << COHER_BASE_PM4_BASE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_base_pm4_t {
          unsigned int base                           : COHER_BASE_PM4_BASE_SIZE;
     } coher_base_pm4_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_base_pm4_t {
          unsigned int base                           : COHER_BASE_PM4_BASE_SIZE;
     } coher_base_pm4_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_base_pm4_t f;
} coher_base_pm4_u;


/*
 * COHER_STATUS_PM4 struct
 */

#define COHER_STATUS_PM4_MATCHING_CONTEXTS_SIZE 8
#define COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_SIZE 1
#define COHER_STATUS_PM4_DEST_BASE_0_ENA_SIZE 1
#define COHER_STATUS_PM4_DEST_BASE_1_ENA_SIZE 1
#define COHER_STATUS_PM4_DEST_BASE_2_ENA_SIZE 1
#define COHER_STATUS_PM4_DEST_BASE_3_ENA_SIZE 1
#define COHER_STATUS_PM4_DEST_BASE_4_ENA_SIZE 1
#define COHER_STATUS_PM4_DEST_BASE_5_ENA_SIZE 1
#define COHER_STATUS_PM4_DEST_BASE_6_ENA_SIZE 1
#define COHER_STATUS_PM4_DEST_BASE_7_ENA_SIZE 1
#define COHER_STATUS_PM4_RB_COLOR_INFO_ENA_SIZE 1
#define COHER_STATUS_PM4_TC_ACTION_ENA_SIZE 1
#define COHER_STATUS_PM4_STATUS_SIZE   1

#define COHER_STATUS_PM4_MATCHING_CONTEXTS_SHIFT 0
#define COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_SHIFT 8
#define COHER_STATUS_PM4_DEST_BASE_0_ENA_SHIFT 9
#define COHER_STATUS_PM4_DEST_BASE_1_ENA_SHIFT 10
#define COHER_STATUS_PM4_DEST_BASE_2_ENA_SHIFT 11
#define COHER_STATUS_PM4_DEST_BASE_3_ENA_SHIFT 12
#define COHER_STATUS_PM4_DEST_BASE_4_ENA_SHIFT 13
#define COHER_STATUS_PM4_DEST_BASE_5_ENA_SHIFT 14
#define COHER_STATUS_PM4_DEST_BASE_6_ENA_SHIFT 15
#define COHER_STATUS_PM4_DEST_BASE_7_ENA_SHIFT 16
#define COHER_STATUS_PM4_RB_COLOR_INFO_ENA_SHIFT 17
#define COHER_STATUS_PM4_TC_ACTION_ENA_SHIFT 25
#define COHER_STATUS_PM4_STATUS_SHIFT  31

#define COHER_STATUS_PM4_MATCHING_CONTEXTS_MASK 0x000000ff
#define COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_MASK 0x00000100
#define COHER_STATUS_PM4_DEST_BASE_0_ENA_MASK 0x00000200
#define COHER_STATUS_PM4_DEST_BASE_1_ENA_MASK 0x00000400
#define COHER_STATUS_PM4_DEST_BASE_2_ENA_MASK 0x00000800
#define COHER_STATUS_PM4_DEST_BASE_3_ENA_MASK 0x00001000
#define COHER_STATUS_PM4_DEST_BASE_4_ENA_MASK 0x00002000
#define COHER_STATUS_PM4_DEST_BASE_5_ENA_MASK 0x00004000
#define COHER_STATUS_PM4_DEST_BASE_6_ENA_MASK 0x00008000
#define COHER_STATUS_PM4_DEST_BASE_7_ENA_MASK 0x00010000
#define COHER_STATUS_PM4_RB_COLOR_INFO_ENA_MASK 0x00020000
#define COHER_STATUS_PM4_TC_ACTION_ENA_MASK 0x02000000
#define COHER_STATUS_PM4_STATUS_MASK   0x80000000

#define COHER_STATUS_PM4_MASK \
     (COHER_STATUS_PM4_MATCHING_CONTEXTS_MASK | \
      COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_MASK | \
      COHER_STATUS_PM4_DEST_BASE_0_ENA_MASK | \
      COHER_STATUS_PM4_DEST_BASE_1_ENA_MASK | \
      COHER_STATUS_PM4_DEST_BASE_2_ENA_MASK | \
      COHER_STATUS_PM4_DEST_BASE_3_ENA_MASK | \
      COHER_STATUS_PM4_DEST_BASE_4_ENA_MASK | \
      COHER_STATUS_PM4_DEST_BASE_5_ENA_MASK | \
      COHER_STATUS_PM4_DEST_BASE_6_ENA_MASK | \
      COHER_STATUS_PM4_DEST_BASE_7_ENA_MASK | \
      COHER_STATUS_PM4_RB_COLOR_INFO_ENA_MASK | \
      COHER_STATUS_PM4_TC_ACTION_ENA_MASK | \
      COHER_STATUS_PM4_STATUS_MASK)

#define COHER_STATUS_PM4(matching_contexts, rb_copy_dest_base_ena, dest_base_0_ena, dest_base_1_ena, dest_base_2_ena, dest_base_3_ena, dest_base_4_ena, dest_base_5_ena, dest_base_6_ena, dest_base_7_ena, rb_color_info_ena, tc_action_ena, status) \
     ((matching_contexts << COHER_STATUS_PM4_MATCHING_CONTEXTS_SHIFT) | \
      (rb_copy_dest_base_ena << COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_SHIFT) | \
      (dest_base_0_ena << COHER_STATUS_PM4_DEST_BASE_0_ENA_SHIFT) | \
      (dest_base_1_ena << COHER_STATUS_PM4_DEST_BASE_1_ENA_SHIFT) | \
      (dest_base_2_ena << COHER_STATUS_PM4_DEST_BASE_2_ENA_SHIFT) | \
      (dest_base_3_ena << COHER_STATUS_PM4_DEST_BASE_3_ENA_SHIFT) | \
      (dest_base_4_ena << COHER_STATUS_PM4_DEST_BASE_4_ENA_SHIFT) | \
      (dest_base_5_ena << COHER_STATUS_PM4_DEST_BASE_5_ENA_SHIFT) | \
      (dest_base_6_ena << COHER_STATUS_PM4_DEST_BASE_6_ENA_SHIFT) | \
      (dest_base_7_ena << COHER_STATUS_PM4_DEST_BASE_7_ENA_SHIFT) | \
      (rb_color_info_ena << COHER_STATUS_PM4_RB_COLOR_INFO_ENA_SHIFT) | \
      (tc_action_ena << COHER_STATUS_PM4_TC_ACTION_ENA_SHIFT) | \
      (status << COHER_STATUS_PM4_STATUS_SHIFT))

#define COHER_STATUS_PM4_GET_MATCHING_CONTEXTS(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_MATCHING_CONTEXTS_MASK) >> COHER_STATUS_PM4_MATCHING_CONTEXTS_SHIFT)
#define COHER_STATUS_PM4_GET_RB_COPY_DEST_BASE_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_MASK) >> COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_DEST_BASE_0_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_DEST_BASE_0_ENA_MASK) >> COHER_STATUS_PM4_DEST_BASE_0_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_DEST_BASE_1_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_DEST_BASE_1_ENA_MASK) >> COHER_STATUS_PM4_DEST_BASE_1_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_DEST_BASE_2_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_DEST_BASE_2_ENA_MASK) >> COHER_STATUS_PM4_DEST_BASE_2_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_DEST_BASE_3_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_DEST_BASE_3_ENA_MASK) >> COHER_STATUS_PM4_DEST_BASE_3_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_DEST_BASE_4_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_DEST_BASE_4_ENA_MASK) >> COHER_STATUS_PM4_DEST_BASE_4_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_DEST_BASE_5_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_DEST_BASE_5_ENA_MASK) >> COHER_STATUS_PM4_DEST_BASE_5_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_DEST_BASE_6_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_DEST_BASE_6_ENA_MASK) >> COHER_STATUS_PM4_DEST_BASE_6_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_DEST_BASE_7_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_DEST_BASE_7_ENA_MASK) >> COHER_STATUS_PM4_DEST_BASE_7_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_RB_COLOR_INFO_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_RB_COLOR_INFO_ENA_MASK) >> COHER_STATUS_PM4_RB_COLOR_INFO_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_TC_ACTION_ENA(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_TC_ACTION_ENA_MASK) >> COHER_STATUS_PM4_TC_ACTION_ENA_SHIFT)
#define COHER_STATUS_PM4_GET_STATUS(coher_status_pm4) \
     ((coher_status_pm4 & COHER_STATUS_PM4_STATUS_MASK) >> COHER_STATUS_PM4_STATUS_SHIFT)

#define COHER_STATUS_PM4_SET_MATCHING_CONTEXTS(coher_status_pm4_reg, matching_contexts) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_MATCHING_CONTEXTS_MASK) | (matching_contexts << COHER_STATUS_PM4_MATCHING_CONTEXTS_SHIFT)
#define COHER_STATUS_PM4_SET_RB_COPY_DEST_BASE_ENA(coher_status_pm4_reg, rb_copy_dest_base_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_MASK) | (rb_copy_dest_base_ena << COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_DEST_BASE_0_ENA(coher_status_pm4_reg, dest_base_0_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_DEST_BASE_0_ENA_MASK) | (dest_base_0_ena << COHER_STATUS_PM4_DEST_BASE_0_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_DEST_BASE_1_ENA(coher_status_pm4_reg, dest_base_1_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_DEST_BASE_1_ENA_MASK) | (dest_base_1_ena << COHER_STATUS_PM4_DEST_BASE_1_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_DEST_BASE_2_ENA(coher_status_pm4_reg, dest_base_2_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_DEST_BASE_2_ENA_MASK) | (dest_base_2_ena << COHER_STATUS_PM4_DEST_BASE_2_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_DEST_BASE_3_ENA(coher_status_pm4_reg, dest_base_3_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_DEST_BASE_3_ENA_MASK) | (dest_base_3_ena << COHER_STATUS_PM4_DEST_BASE_3_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_DEST_BASE_4_ENA(coher_status_pm4_reg, dest_base_4_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_DEST_BASE_4_ENA_MASK) | (dest_base_4_ena << COHER_STATUS_PM4_DEST_BASE_4_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_DEST_BASE_5_ENA(coher_status_pm4_reg, dest_base_5_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_DEST_BASE_5_ENA_MASK) | (dest_base_5_ena << COHER_STATUS_PM4_DEST_BASE_5_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_DEST_BASE_6_ENA(coher_status_pm4_reg, dest_base_6_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_DEST_BASE_6_ENA_MASK) | (dest_base_6_ena << COHER_STATUS_PM4_DEST_BASE_6_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_DEST_BASE_7_ENA(coher_status_pm4_reg, dest_base_7_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_DEST_BASE_7_ENA_MASK) | (dest_base_7_ena << COHER_STATUS_PM4_DEST_BASE_7_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_RB_COLOR_INFO_ENA(coher_status_pm4_reg, rb_color_info_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_RB_COLOR_INFO_ENA_MASK) | (rb_color_info_ena << COHER_STATUS_PM4_RB_COLOR_INFO_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_TC_ACTION_ENA(coher_status_pm4_reg, tc_action_ena) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_TC_ACTION_ENA_MASK) | (tc_action_ena << COHER_STATUS_PM4_TC_ACTION_ENA_SHIFT)
#define COHER_STATUS_PM4_SET_STATUS(coher_status_pm4_reg, status) \
     coher_status_pm4_reg = (coher_status_pm4_reg & ~COHER_STATUS_PM4_STATUS_MASK) | (status << COHER_STATUS_PM4_STATUS_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_status_pm4_t {
          unsigned int matching_contexts              : COHER_STATUS_PM4_MATCHING_CONTEXTS_SIZE;
          unsigned int rb_copy_dest_base_ena          : COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_SIZE;
          unsigned int dest_base_0_ena                : COHER_STATUS_PM4_DEST_BASE_0_ENA_SIZE;
          unsigned int dest_base_1_ena                : COHER_STATUS_PM4_DEST_BASE_1_ENA_SIZE;
          unsigned int dest_base_2_ena                : COHER_STATUS_PM4_DEST_BASE_2_ENA_SIZE;
          unsigned int dest_base_3_ena                : COHER_STATUS_PM4_DEST_BASE_3_ENA_SIZE;
          unsigned int dest_base_4_ena                : COHER_STATUS_PM4_DEST_BASE_4_ENA_SIZE;
          unsigned int dest_base_5_ena                : COHER_STATUS_PM4_DEST_BASE_5_ENA_SIZE;
          unsigned int dest_base_6_ena                : COHER_STATUS_PM4_DEST_BASE_6_ENA_SIZE;
          unsigned int dest_base_7_ena                : COHER_STATUS_PM4_DEST_BASE_7_ENA_SIZE;
          unsigned int rb_color_info_ena              : COHER_STATUS_PM4_RB_COLOR_INFO_ENA_SIZE;
          unsigned int                                : 7;
          unsigned int tc_action_ena                  : COHER_STATUS_PM4_TC_ACTION_ENA_SIZE;
          unsigned int                                : 5;
          unsigned int status                         : COHER_STATUS_PM4_STATUS_SIZE;
     } coher_status_pm4_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_status_pm4_t {
          unsigned int status                         : COHER_STATUS_PM4_STATUS_SIZE;
          unsigned int                                : 5;
          unsigned int tc_action_ena                  : COHER_STATUS_PM4_TC_ACTION_ENA_SIZE;
          unsigned int                                : 7;
          unsigned int rb_color_info_ena              : COHER_STATUS_PM4_RB_COLOR_INFO_ENA_SIZE;
          unsigned int dest_base_7_ena                : COHER_STATUS_PM4_DEST_BASE_7_ENA_SIZE;
          unsigned int dest_base_6_ena                : COHER_STATUS_PM4_DEST_BASE_6_ENA_SIZE;
          unsigned int dest_base_5_ena                : COHER_STATUS_PM4_DEST_BASE_5_ENA_SIZE;
          unsigned int dest_base_4_ena                : COHER_STATUS_PM4_DEST_BASE_4_ENA_SIZE;
          unsigned int dest_base_3_ena                : COHER_STATUS_PM4_DEST_BASE_3_ENA_SIZE;
          unsigned int dest_base_2_ena                : COHER_STATUS_PM4_DEST_BASE_2_ENA_SIZE;
          unsigned int dest_base_1_ena                : COHER_STATUS_PM4_DEST_BASE_1_ENA_SIZE;
          unsigned int dest_base_0_ena                : COHER_STATUS_PM4_DEST_BASE_0_ENA_SIZE;
          unsigned int rb_copy_dest_base_ena          : COHER_STATUS_PM4_RB_COPY_DEST_BASE_ENA_SIZE;
          unsigned int matching_contexts              : COHER_STATUS_PM4_MATCHING_CONTEXTS_SIZE;
     } coher_status_pm4_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_status_pm4_t f;
} coher_status_pm4_u;


/*
 * COHER_SIZE_HOST struct
 */

#define COHER_SIZE_HOST_SIZE_SIZE      32

#define COHER_SIZE_HOST_SIZE_SHIFT     0

#define COHER_SIZE_HOST_SIZE_MASK      0xffffffff

#define COHER_SIZE_HOST_MASK \
     (COHER_SIZE_HOST_SIZE_MASK)

#define COHER_SIZE_HOST(size) \
     ((size << COHER_SIZE_HOST_SIZE_SHIFT))

#define COHER_SIZE_HOST_GET_SIZE(coher_size_host) \
     ((coher_size_host & COHER_SIZE_HOST_SIZE_MASK) >> COHER_SIZE_HOST_SIZE_SHIFT)

#define COHER_SIZE_HOST_SET_SIZE(coher_size_host_reg, size) \
     coher_size_host_reg = (coher_size_host_reg & ~COHER_SIZE_HOST_SIZE_MASK) | (size << COHER_SIZE_HOST_SIZE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_size_host_t {
          unsigned int size                           : COHER_SIZE_HOST_SIZE_SIZE;
     } coher_size_host_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_size_host_t {
          unsigned int size                           : COHER_SIZE_HOST_SIZE_SIZE;
     } coher_size_host_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_size_host_t f;
} coher_size_host_u;


/*
 * COHER_BASE_HOST struct
 */

#define COHER_BASE_HOST_BASE_SIZE      32

#define COHER_BASE_HOST_BASE_SHIFT     0

#define COHER_BASE_HOST_BASE_MASK      0xffffffff

#define COHER_BASE_HOST_MASK \
     (COHER_BASE_HOST_BASE_MASK)

#define COHER_BASE_HOST(base) \
     ((base << COHER_BASE_HOST_BASE_SHIFT))

#define COHER_BASE_HOST_GET_BASE(coher_base_host) \
     ((coher_base_host & COHER_BASE_HOST_BASE_MASK) >> COHER_BASE_HOST_BASE_SHIFT)

#define COHER_BASE_HOST_SET_BASE(coher_base_host_reg, base) \
     coher_base_host_reg = (coher_base_host_reg & ~COHER_BASE_HOST_BASE_MASK) | (base << COHER_BASE_HOST_BASE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_base_host_t {
          unsigned int base                           : COHER_BASE_HOST_BASE_SIZE;
     } coher_base_host_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_base_host_t {
          unsigned int base                           : COHER_BASE_HOST_BASE_SIZE;
     } coher_base_host_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_base_host_t f;
} coher_base_host_u;


/*
 * COHER_STATUS_HOST struct
 */

#define COHER_STATUS_HOST_MATCHING_CONTEXTS_SIZE 8
#define COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_SIZE 1
#define COHER_STATUS_HOST_DEST_BASE_0_ENA_SIZE 1
#define COHER_STATUS_HOST_DEST_BASE_1_ENA_SIZE 1
#define COHER_STATUS_HOST_DEST_BASE_2_ENA_SIZE 1
#define COHER_STATUS_HOST_DEST_BASE_3_ENA_SIZE 1
#define COHER_STATUS_HOST_DEST_BASE_4_ENA_SIZE 1
#define COHER_STATUS_HOST_DEST_BASE_5_ENA_SIZE 1
#define COHER_STATUS_HOST_DEST_BASE_6_ENA_SIZE 1
#define COHER_STATUS_HOST_DEST_BASE_7_ENA_SIZE 1
#define COHER_STATUS_HOST_RB_COLOR_INFO_ENA_SIZE 1
#define COHER_STATUS_HOST_TC_ACTION_ENA_SIZE 1
#define COHER_STATUS_HOST_STATUS_SIZE  1

#define COHER_STATUS_HOST_MATCHING_CONTEXTS_SHIFT 0
#define COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_SHIFT 8
#define COHER_STATUS_HOST_DEST_BASE_0_ENA_SHIFT 9
#define COHER_STATUS_HOST_DEST_BASE_1_ENA_SHIFT 10
#define COHER_STATUS_HOST_DEST_BASE_2_ENA_SHIFT 11
#define COHER_STATUS_HOST_DEST_BASE_3_ENA_SHIFT 12
#define COHER_STATUS_HOST_DEST_BASE_4_ENA_SHIFT 13
#define COHER_STATUS_HOST_DEST_BASE_5_ENA_SHIFT 14
#define COHER_STATUS_HOST_DEST_BASE_6_ENA_SHIFT 15
#define COHER_STATUS_HOST_DEST_BASE_7_ENA_SHIFT 16
#define COHER_STATUS_HOST_RB_COLOR_INFO_ENA_SHIFT 17
#define COHER_STATUS_HOST_TC_ACTION_ENA_SHIFT 25
#define COHER_STATUS_HOST_STATUS_SHIFT 31

#define COHER_STATUS_HOST_MATCHING_CONTEXTS_MASK 0x000000ff
#define COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_MASK 0x00000100
#define COHER_STATUS_HOST_DEST_BASE_0_ENA_MASK 0x00000200
#define COHER_STATUS_HOST_DEST_BASE_1_ENA_MASK 0x00000400
#define COHER_STATUS_HOST_DEST_BASE_2_ENA_MASK 0x00000800
#define COHER_STATUS_HOST_DEST_BASE_3_ENA_MASK 0x00001000
#define COHER_STATUS_HOST_DEST_BASE_4_ENA_MASK 0x00002000
#define COHER_STATUS_HOST_DEST_BASE_5_ENA_MASK 0x00004000
#define COHER_STATUS_HOST_DEST_BASE_6_ENA_MASK 0x00008000
#define COHER_STATUS_HOST_DEST_BASE_7_ENA_MASK 0x00010000
#define COHER_STATUS_HOST_RB_COLOR_INFO_ENA_MASK 0x00020000
#define COHER_STATUS_HOST_TC_ACTION_ENA_MASK 0x02000000
#define COHER_STATUS_HOST_STATUS_MASK  0x80000000

#define COHER_STATUS_HOST_MASK \
     (COHER_STATUS_HOST_MATCHING_CONTEXTS_MASK | \
      COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_MASK | \
      COHER_STATUS_HOST_DEST_BASE_0_ENA_MASK | \
      COHER_STATUS_HOST_DEST_BASE_1_ENA_MASK | \
      COHER_STATUS_HOST_DEST_BASE_2_ENA_MASK | \
      COHER_STATUS_HOST_DEST_BASE_3_ENA_MASK | \
      COHER_STATUS_HOST_DEST_BASE_4_ENA_MASK | \
      COHER_STATUS_HOST_DEST_BASE_5_ENA_MASK | \
      COHER_STATUS_HOST_DEST_BASE_6_ENA_MASK | \
      COHER_STATUS_HOST_DEST_BASE_7_ENA_MASK | \
      COHER_STATUS_HOST_RB_COLOR_INFO_ENA_MASK | \
      COHER_STATUS_HOST_TC_ACTION_ENA_MASK | \
      COHER_STATUS_HOST_STATUS_MASK)

#define COHER_STATUS_HOST(matching_contexts, rb_copy_dest_base_ena, dest_base_0_ena, dest_base_1_ena, dest_base_2_ena, dest_base_3_ena, dest_base_4_ena, dest_base_5_ena, dest_base_6_ena, dest_base_7_ena, rb_color_info_ena, tc_action_ena, status) \
     ((matching_contexts << COHER_STATUS_HOST_MATCHING_CONTEXTS_SHIFT) | \
      (rb_copy_dest_base_ena << COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_SHIFT) | \
      (dest_base_0_ena << COHER_STATUS_HOST_DEST_BASE_0_ENA_SHIFT) | \
      (dest_base_1_ena << COHER_STATUS_HOST_DEST_BASE_1_ENA_SHIFT) | \
      (dest_base_2_ena << COHER_STATUS_HOST_DEST_BASE_2_ENA_SHIFT) | \
      (dest_base_3_ena << COHER_STATUS_HOST_DEST_BASE_3_ENA_SHIFT) | \
      (dest_base_4_ena << COHER_STATUS_HOST_DEST_BASE_4_ENA_SHIFT) | \
      (dest_base_5_ena << COHER_STATUS_HOST_DEST_BASE_5_ENA_SHIFT) | \
      (dest_base_6_ena << COHER_STATUS_HOST_DEST_BASE_6_ENA_SHIFT) | \
      (dest_base_7_ena << COHER_STATUS_HOST_DEST_BASE_7_ENA_SHIFT) | \
      (rb_color_info_ena << COHER_STATUS_HOST_RB_COLOR_INFO_ENA_SHIFT) | \
      (tc_action_ena << COHER_STATUS_HOST_TC_ACTION_ENA_SHIFT) | \
      (status << COHER_STATUS_HOST_STATUS_SHIFT))

#define COHER_STATUS_HOST_GET_MATCHING_CONTEXTS(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_MATCHING_CONTEXTS_MASK) >> COHER_STATUS_HOST_MATCHING_CONTEXTS_SHIFT)
#define COHER_STATUS_HOST_GET_RB_COPY_DEST_BASE_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_MASK) >> COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_DEST_BASE_0_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_DEST_BASE_0_ENA_MASK) >> COHER_STATUS_HOST_DEST_BASE_0_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_DEST_BASE_1_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_DEST_BASE_1_ENA_MASK) >> COHER_STATUS_HOST_DEST_BASE_1_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_DEST_BASE_2_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_DEST_BASE_2_ENA_MASK) >> COHER_STATUS_HOST_DEST_BASE_2_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_DEST_BASE_3_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_DEST_BASE_3_ENA_MASK) >> COHER_STATUS_HOST_DEST_BASE_3_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_DEST_BASE_4_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_DEST_BASE_4_ENA_MASK) >> COHER_STATUS_HOST_DEST_BASE_4_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_DEST_BASE_5_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_DEST_BASE_5_ENA_MASK) >> COHER_STATUS_HOST_DEST_BASE_5_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_DEST_BASE_6_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_DEST_BASE_6_ENA_MASK) >> COHER_STATUS_HOST_DEST_BASE_6_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_DEST_BASE_7_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_DEST_BASE_7_ENA_MASK) >> COHER_STATUS_HOST_DEST_BASE_7_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_RB_COLOR_INFO_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_RB_COLOR_INFO_ENA_MASK) >> COHER_STATUS_HOST_RB_COLOR_INFO_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_TC_ACTION_ENA(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_TC_ACTION_ENA_MASK) >> COHER_STATUS_HOST_TC_ACTION_ENA_SHIFT)
#define COHER_STATUS_HOST_GET_STATUS(coher_status_host) \
     ((coher_status_host & COHER_STATUS_HOST_STATUS_MASK) >> COHER_STATUS_HOST_STATUS_SHIFT)

#define COHER_STATUS_HOST_SET_MATCHING_CONTEXTS(coher_status_host_reg, matching_contexts) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_MATCHING_CONTEXTS_MASK) | (matching_contexts << COHER_STATUS_HOST_MATCHING_CONTEXTS_SHIFT)
#define COHER_STATUS_HOST_SET_RB_COPY_DEST_BASE_ENA(coher_status_host_reg, rb_copy_dest_base_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_MASK) | (rb_copy_dest_base_ena << COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_DEST_BASE_0_ENA(coher_status_host_reg, dest_base_0_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_DEST_BASE_0_ENA_MASK) | (dest_base_0_ena << COHER_STATUS_HOST_DEST_BASE_0_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_DEST_BASE_1_ENA(coher_status_host_reg, dest_base_1_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_DEST_BASE_1_ENA_MASK) | (dest_base_1_ena << COHER_STATUS_HOST_DEST_BASE_1_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_DEST_BASE_2_ENA(coher_status_host_reg, dest_base_2_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_DEST_BASE_2_ENA_MASK) | (dest_base_2_ena << COHER_STATUS_HOST_DEST_BASE_2_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_DEST_BASE_3_ENA(coher_status_host_reg, dest_base_3_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_DEST_BASE_3_ENA_MASK) | (dest_base_3_ena << COHER_STATUS_HOST_DEST_BASE_3_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_DEST_BASE_4_ENA(coher_status_host_reg, dest_base_4_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_DEST_BASE_4_ENA_MASK) | (dest_base_4_ena << COHER_STATUS_HOST_DEST_BASE_4_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_DEST_BASE_5_ENA(coher_status_host_reg, dest_base_5_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_DEST_BASE_5_ENA_MASK) | (dest_base_5_ena << COHER_STATUS_HOST_DEST_BASE_5_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_DEST_BASE_6_ENA(coher_status_host_reg, dest_base_6_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_DEST_BASE_6_ENA_MASK) | (dest_base_6_ena << COHER_STATUS_HOST_DEST_BASE_6_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_DEST_BASE_7_ENA(coher_status_host_reg, dest_base_7_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_DEST_BASE_7_ENA_MASK) | (dest_base_7_ena << COHER_STATUS_HOST_DEST_BASE_7_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_RB_COLOR_INFO_ENA(coher_status_host_reg, rb_color_info_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_RB_COLOR_INFO_ENA_MASK) | (rb_color_info_ena << COHER_STATUS_HOST_RB_COLOR_INFO_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_TC_ACTION_ENA(coher_status_host_reg, tc_action_ena) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_TC_ACTION_ENA_MASK) | (tc_action_ena << COHER_STATUS_HOST_TC_ACTION_ENA_SHIFT)
#define COHER_STATUS_HOST_SET_STATUS(coher_status_host_reg, status) \
     coher_status_host_reg = (coher_status_host_reg & ~COHER_STATUS_HOST_STATUS_MASK) | (status << COHER_STATUS_HOST_STATUS_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_status_host_t {
          unsigned int matching_contexts              : COHER_STATUS_HOST_MATCHING_CONTEXTS_SIZE;
          unsigned int rb_copy_dest_base_ena          : COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_SIZE;
          unsigned int dest_base_0_ena                : COHER_STATUS_HOST_DEST_BASE_0_ENA_SIZE;
          unsigned int dest_base_1_ena                : COHER_STATUS_HOST_DEST_BASE_1_ENA_SIZE;
          unsigned int dest_base_2_ena                : COHER_STATUS_HOST_DEST_BASE_2_ENA_SIZE;
          unsigned int dest_base_3_ena                : COHER_STATUS_HOST_DEST_BASE_3_ENA_SIZE;
          unsigned int dest_base_4_ena                : COHER_STATUS_HOST_DEST_BASE_4_ENA_SIZE;
          unsigned int dest_base_5_ena                : COHER_STATUS_HOST_DEST_BASE_5_ENA_SIZE;
          unsigned int dest_base_6_ena                : COHER_STATUS_HOST_DEST_BASE_6_ENA_SIZE;
          unsigned int dest_base_7_ena                : COHER_STATUS_HOST_DEST_BASE_7_ENA_SIZE;
          unsigned int rb_color_info_ena              : COHER_STATUS_HOST_RB_COLOR_INFO_ENA_SIZE;
          unsigned int                                : 7;
          unsigned int tc_action_ena                  : COHER_STATUS_HOST_TC_ACTION_ENA_SIZE;
          unsigned int                                : 5;
          unsigned int status                         : COHER_STATUS_HOST_STATUS_SIZE;
     } coher_status_host_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_status_host_t {
          unsigned int status                         : COHER_STATUS_HOST_STATUS_SIZE;
          unsigned int                                : 5;
          unsigned int tc_action_ena                  : COHER_STATUS_HOST_TC_ACTION_ENA_SIZE;
          unsigned int                                : 7;
          unsigned int rb_color_info_ena              : COHER_STATUS_HOST_RB_COLOR_INFO_ENA_SIZE;
          unsigned int dest_base_7_ena                : COHER_STATUS_HOST_DEST_BASE_7_ENA_SIZE;
          unsigned int dest_base_6_ena                : COHER_STATUS_HOST_DEST_BASE_6_ENA_SIZE;
          unsigned int dest_base_5_ena                : COHER_STATUS_HOST_DEST_BASE_5_ENA_SIZE;
          unsigned int dest_base_4_ena                : COHER_STATUS_HOST_DEST_BASE_4_ENA_SIZE;
          unsigned int dest_base_3_ena                : COHER_STATUS_HOST_DEST_BASE_3_ENA_SIZE;
          unsigned int dest_base_2_ena                : COHER_STATUS_HOST_DEST_BASE_2_ENA_SIZE;
          unsigned int dest_base_1_ena                : COHER_STATUS_HOST_DEST_BASE_1_ENA_SIZE;
          unsigned int dest_base_0_ena                : COHER_STATUS_HOST_DEST_BASE_0_ENA_SIZE;
          unsigned int rb_copy_dest_base_ena          : COHER_STATUS_HOST_RB_COPY_DEST_BASE_ENA_SIZE;
          unsigned int matching_contexts              : COHER_STATUS_HOST_MATCHING_CONTEXTS_SIZE;
     } coher_status_host_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_status_host_t f;
} coher_status_host_u;


/*
 * COHER_DEST_BASE_0 struct
 */

#define COHER_DEST_BASE_0_DEST_BASE_0_SIZE 20

#define COHER_DEST_BASE_0_DEST_BASE_0_SHIFT 12

#define COHER_DEST_BASE_0_DEST_BASE_0_MASK 0xfffff000

#define COHER_DEST_BASE_0_MASK \
     (COHER_DEST_BASE_0_DEST_BASE_0_MASK)

#define COHER_DEST_BASE_0(dest_base_0) \
     ((dest_base_0 << COHER_DEST_BASE_0_DEST_BASE_0_SHIFT))

#define COHER_DEST_BASE_0_GET_DEST_BASE_0(coher_dest_base_0) \
     ((coher_dest_base_0 & COHER_DEST_BASE_0_DEST_BASE_0_MASK) >> COHER_DEST_BASE_0_DEST_BASE_0_SHIFT)

#define COHER_DEST_BASE_0_SET_DEST_BASE_0(coher_dest_base_0_reg, dest_base_0) \
     coher_dest_base_0_reg = (coher_dest_base_0_reg & ~COHER_DEST_BASE_0_DEST_BASE_0_MASK) | (dest_base_0 << COHER_DEST_BASE_0_DEST_BASE_0_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_dest_base_0_t {
          unsigned int                                : 12;
          unsigned int dest_base_0                    : COHER_DEST_BASE_0_DEST_BASE_0_SIZE;
     } coher_dest_base_0_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_dest_base_0_t {
          unsigned int dest_base_0                    : COHER_DEST_BASE_0_DEST_BASE_0_SIZE;
          unsigned int                                : 12;
     } coher_dest_base_0_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_dest_base_0_t f;
} coher_dest_base_0_u;


/*
 * COHER_DEST_BASE_1 struct
 */

#define COHER_DEST_BASE_1_DEST_BASE_1_SIZE 20

#define COHER_DEST_BASE_1_DEST_BASE_1_SHIFT 12

#define COHER_DEST_BASE_1_DEST_BASE_1_MASK 0xfffff000

#define COHER_DEST_BASE_1_MASK \
     (COHER_DEST_BASE_1_DEST_BASE_1_MASK)

#define COHER_DEST_BASE_1(dest_base_1) \
     ((dest_base_1 << COHER_DEST_BASE_1_DEST_BASE_1_SHIFT))

#define COHER_DEST_BASE_1_GET_DEST_BASE_1(coher_dest_base_1) \
     ((coher_dest_base_1 & COHER_DEST_BASE_1_DEST_BASE_1_MASK) >> COHER_DEST_BASE_1_DEST_BASE_1_SHIFT)

#define COHER_DEST_BASE_1_SET_DEST_BASE_1(coher_dest_base_1_reg, dest_base_1) \
     coher_dest_base_1_reg = (coher_dest_base_1_reg & ~COHER_DEST_BASE_1_DEST_BASE_1_MASK) | (dest_base_1 << COHER_DEST_BASE_1_DEST_BASE_1_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_dest_base_1_t {
          unsigned int                                : 12;
          unsigned int dest_base_1                    : COHER_DEST_BASE_1_DEST_BASE_1_SIZE;
     } coher_dest_base_1_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_dest_base_1_t {
          unsigned int dest_base_1                    : COHER_DEST_BASE_1_DEST_BASE_1_SIZE;
          unsigned int                                : 12;
     } coher_dest_base_1_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_dest_base_1_t f;
} coher_dest_base_1_u;


/*
 * COHER_DEST_BASE_2 struct
 */

#define COHER_DEST_BASE_2_DEST_BASE_2_SIZE 20

#define COHER_DEST_BASE_2_DEST_BASE_2_SHIFT 12

#define COHER_DEST_BASE_2_DEST_BASE_2_MASK 0xfffff000

#define COHER_DEST_BASE_2_MASK \
     (COHER_DEST_BASE_2_DEST_BASE_2_MASK)

#define COHER_DEST_BASE_2(dest_base_2) \
     ((dest_base_2 << COHER_DEST_BASE_2_DEST_BASE_2_SHIFT))

#define COHER_DEST_BASE_2_GET_DEST_BASE_2(coher_dest_base_2) \
     ((coher_dest_base_2 & COHER_DEST_BASE_2_DEST_BASE_2_MASK) >> COHER_DEST_BASE_2_DEST_BASE_2_SHIFT)

#define COHER_DEST_BASE_2_SET_DEST_BASE_2(coher_dest_base_2_reg, dest_base_2) \
     coher_dest_base_2_reg = (coher_dest_base_2_reg & ~COHER_DEST_BASE_2_DEST_BASE_2_MASK) | (dest_base_2 << COHER_DEST_BASE_2_DEST_BASE_2_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_dest_base_2_t {
          unsigned int                                : 12;
          unsigned int dest_base_2                    : COHER_DEST_BASE_2_DEST_BASE_2_SIZE;
     } coher_dest_base_2_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_dest_base_2_t {
          unsigned int dest_base_2                    : COHER_DEST_BASE_2_DEST_BASE_2_SIZE;
          unsigned int                                : 12;
     } coher_dest_base_2_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_dest_base_2_t f;
} coher_dest_base_2_u;


/*
 * COHER_DEST_BASE_3 struct
 */

#define COHER_DEST_BASE_3_DEST_BASE_3_SIZE 20

#define COHER_DEST_BASE_3_DEST_BASE_3_SHIFT 12

#define COHER_DEST_BASE_3_DEST_BASE_3_MASK 0xfffff000

#define COHER_DEST_BASE_3_MASK \
     (COHER_DEST_BASE_3_DEST_BASE_3_MASK)

#define COHER_DEST_BASE_3(dest_base_3) \
     ((dest_base_3 << COHER_DEST_BASE_3_DEST_BASE_3_SHIFT))

#define COHER_DEST_BASE_3_GET_DEST_BASE_3(coher_dest_base_3) \
     ((coher_dest_base_3 & COHER_DEST_BASE_3_DEST_BASE_3_MASK) >> COHER_DEST_BASE_3_DEST_BASE_3_SHIFT)

#define COHER_DEST_BASE_3_SET_DEST_BASE_3(coher_dest_base_3_reg, dest_base_3) \
     coher_dest_base_3_reg = (coher_dest_base_3_reg & ~COHER_DEST_BASE_3_DEST_BASE_3_MASK) | (dest_base_3 << COHER_DEST_BASE_3_DEST_BASE_3_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_dest_base_3_t {
          unsigned int                                : 12;
          unsigned int dest_base_3                    : COHER_DEST_BASE_3_DEST_BASE_3_SIZE;
     } coher_dest_base_3_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_dest_base_3_t {
          unsigned int dest_base_3                    : COHER_DEST_BASE_3_DEST_BASE_3_SIZE;
          unsigned int                                : 12;
     } coher_dest_base_3_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_dest_base_3_t f;
} coher_dest_base_3_u;


/*
 * COHER_DEST_BASE_4 struct
 */

#define COHER_DEST_BASE_4_DEST_BASE_4_SIZE 20

#define COHER_DEST_BASE_4_DEST_BASE_4_SHIFT 12

#define COHER_DEST_BASE_4_DEST_BASE_4_MASK 0xfffff000

#define COHER_DEST_BASE_4_MASK \
     (COHER_DEST_BASE_4_DEST_BASE_4_MASK)

#define COHER_DEST_BASE_4(dest_base_4) \
     ((dest_base_4 << COHER_DEST_BASE_4_DEST_BASE_4_SHIFT))

#define COHER_DEST_BASE_4_GET_DEST_BASE_4(coher_dest_base_4) \
     ((coher_dest_base_4 & COHER_DEST_BASE_4_DEST_BASE_4_MASK) >> COHER_DEST_BASE_4_DEST_BASE_4_SHIFT)

#define COHER_DEST_BASE_4_SET_DEST_BASE_4(coher_dest_base_4_reg, dest_base_4) \
     coher_dest_base_4_reg = (coher_dest_base_4_reg & ~COHER_DEST_BASE_4_DEST_BASE_4_MASK) | (dest_base_4 << COHER_DEST_BASE_4_DEST_BASE_4_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_dest_base_4_t {
          unsigned int                                : 12;
          unsigned int dest_base_4                    : COHER_DEST_BASE_4_DEST_BASE_4_SIZE;
     } coher_dest_base_4_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_dest_base_4_t {
          unsigned int dest_base_4                    : COHER_DEST_BASE_4_DEST_BASE_4_SIZE;
          unsigned int                                : 12;
     } coher_dest_base_4_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_dest_base_4_t f;
} coher_dest_base_4_u;


/*
 * COHER_DEST_BASE_5 struct
 */

#define COHER_DEST_BASE_5_DEST_BASE_5_SIZE 20

#define COHER_DEST_BASE_5_DEST_BASE_5_SHIFT 12

#define COHER_DEST_BASE_5_DEST_BASE_5_MASK 0xfffff000

#define COHER_DEST_BASE_5_MASK \
     (COHER_DEST_BASE_5_DEST_BASE_5_MASK)

#define COHER_DEST_BASE_5(dest_base_5) \
     ((dest_base_5 << COHER_DEST_BASE_5_DEST_BASE_5_SHIFT))

#define COHER_DEST_BASE_5_GET_DEST_BASE_5(coher_dest_base_5) \
     ((coher_dest_base_5 & COHER_DEST_BASE_5_DEST_BASE_5_MASK) >> COHER_DEST_BASE_5_DEST_BASE_5_SHIFT)

#define COHER_DEST_BASE_5_SET_DEST_BASE_5(coher_dest_base_5_reg, dest_base_5) \
     coher_dest_base_5_reg = (coher_dest_base_5_reg & ~COHER_DEST_BASE_5_DEST_BASE_5_MASK) | (dest_base_5 << COHER_DEST_BASE_5_DEST_BASE_5_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_dest_base_5_t {
          unsigned int                                : 12;
          unsigned int dest_base_5                    : COHER_DEST_BASE_5_DEST_BASE_5_SIZE;
     } coher_dest_base_5_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_dest_base_5_t {
          unsigned int dest_base_5                    : COHER_DEST_BASE_5_DEST_BASE_5_SIZE;
          unsigned int                                : 12;
     } coher_dest_base_5_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_dest_base_5_t f;
} coher_dest_base_5_u;


/*
 * COHER_DEST_BASE_6 struct
 */

#define COHER_DEST_BASE_6_DEST_BASE_6_SIZE 20

#define COHER_DEST_BASE_6_DEST_BASE_6_SHIFT 12

#define COHER_DEST_BASE_6_DEST_BASE_6_MASK 0xfffff000

#define COHER_DEST_BASE_6_MASK \
     (COHER_DEST_BASE_6_DEST_BASE_6_MASK)

#define COHER_DEST_BASE_6(dest_base_6) \
     ((dest_base_6 << COHER_DEST_BASE_6_DEST_BASE_6_SHIFT))

#define COHER_DEST_BASE_6_GET_DEST_BASE_6(coher_dest_base_6) \
     ((coher_dest_base_6 & COHER_DEST_BASE_6_DEST_BASE_6_MASK) >> COHER_DEST_BASE_6_DEST_BASE_6_SHIFT)

#define COHER_DEST_BASE_6_SET_DEST_BASE_6(coher_dest_base_6_reg, dest_base_6) \
     coher_dest_base_6_reg = (coher_dest_base_6_reg & ~COHER_DEST_BASE_6_DEST_BASE_6_MASK) | (dest_base_6 << COHER_DEST_BASE_6_DEST_BASE_6_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_dest_base_6_t {
          unsigned int                                : 12;
          unsigned int dest_base_6                    : COHER_DEST_BASE_6_DEST_BASE_6_SIZE;
     } coher_dest_base_6_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_dest_base_6_t {
          unsigned int dest_base_6                    : COHER_DEST_BASE_6_DEST_BASE_6_SIZE;
          unsigned int                                : 12;
     } coher_dest_base_6_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_dest_base_6_t f;
} coher_dest_base_6_u;


/*
 * COHER_DEST_BASE_7 struct
 */

#define COHER_DEST_BASE_7_DEST_BASE_7_SIZE 20

#define COHER_DEST_BASE_7_DEST_BASE_7_SHIFT 12

#define COHER_DEST_BASE_7_DEST_BASE_7_MASK 0xfffff000

#define COHER_DEST_BASE_7_MASK \
     (COHER_DEST_BASE_7_DEST_BASE_7_MASK)

#define COHER_DEST_BASE_7(dest_base_7) \
     ((dest_base_7 << COHER_DEST_BASE_7_DEST_BASE_7_SHIFT))

#define COHER_DEST_BASE_7_GET_DEST_BASE_7(coher_dest_base_7) \
     ((coher_dest_base_7 & COHER_DEST_BASE_7_DEST_BASE_7_MASK) >> COHER_DEST_BASE_7_DEST_BASE_7_SHIFT)

#define COHER_DEST_BASE_7_SET_DEST_BASE_7(coher_dest_base_7_reg, dest_base_7) \
     coher_dest_base_7_reg = (coher_dest_base_7_reg & ~COHER_DEST_BASE_7_DEST_BASE_7_MASK) | (dest_base_7 << COHER_DEST_BASE_7_DEST_BASE_7_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _coher_dest_base_7_t {
          unsigned int                                : 12;
          unsigned int dest_base_7                    : COHER_DEST_BASE_7_DEST_BASE_7_SIZE;
     } coher_dest_base_7_t;

#else   // !BIGENDIAN_OS

     typedef struct _coher_dest_base_7_t {
          unsigned int dest_base_7                    : COHER_DEST_BASE_7_DEST_BASE_7_SIZE;
          unsigned int                                : 12;
     } coher_dest_base_7_t;

#endif

typedef union {
     unsigned int val : 32;
     coher_dest_base_7_t f;
} coher_dest_base_7_u;


#endif


#if !defined (_RBBM_FIDDLE_H)
#define _RBBM_FIDDLE_H

/*****************************************************************************************************************
 *
 *  rbbm_reg.h
 *
 *  Register Spec Release:  Block Spec 1.0
 *
 *   (c) 2000 ATI Technologies Inc.  (unpublished)
 *
 *   All rights reserved.  This notice is intended as a precaution against
 *   inadvertent publication and does not imply publication or any waiver
 *   of confidentiality.  The year included in the foregoing notice is the
 *   year of creation of the work.
 *
 *****************************************************************************************************************/

/*******************************************************
 * Enums
 *******************************************************/


/*******************************************************
 * Values
 *******************************************************/


/*******************************************************
 * Structures
 *******************************************************/

/*
 * WAIT_UNTIL struct
 */

#define WAIT_UNTIL_WAIT_RE_VSYNC_SIZE  1
#define WAIT_UNTIL_WAIT_FE_VSYNC_SIZE  1
#define WAIT_UNTIL_WAIT_VSYNC_SIZE     1
#define WAIT_UNTIL_WAIT_DSPLY_ID0_SIZE 1
#define WAIT_UNTIL_WAIT_DSPLY_ID1_SIZE 1
#define WAIT_UNTIL_WAIT_DSPLY_ID2_SIZE 1
#define WAIT_UNTIL_WAIT_CMDFIFO_SIZE   1
#define WAIT_UNTIL_WAIT_2D_IDLE_SIZE   1
#define WAIT_UNTIL_WAIT_3D_IDLE_SIZE   1
#define WAIT_UNTIL_WAIT_2D_IDLECLEAN_SIZE 1
#define WAIT_UNTIL_WAIT_3D_IDLECLEAN_SIZE 1
#define WAIT_UNTIL_CMDFIFO_ENTRIES_SIZE 4

#define WAIT_UNTIL_WAIT_RE_VSYNC_SHIFT 1
#define WAIT_UNTIL_WAIT_FE_VSYNC_SHIFT 2
#define WAIT_UNTIL_WAIT_VSYNC_SHIFT    3
#define WAIT_UNTIL_WAIT_DSPLY_ID0_SHIFT 4
#define WAIT_UNTIL_WAIT_DSPLY_ID1_SHIFT 5
#define WAIT_UNTIL_WAIT_DSPLY_ID2_SHIFT 6
#define WAIT_UNTIL_WAIT_CMDFIFO_SHIFT  10
#define WAIT_UNTIL_WAIT_2D_IDLE_SHIFT  14
#define WAIT_UNTIL_WAIT_3D_IDLE_SHIFT  15
#define WAIT_UNTIL_WAIT_2D_IDLECLEAN_SHIFT 16
#define WAIT_UNTIL_WAIT_3D_IDLECLEAN_SHIFT 17
#define WAIT_UNTIL_CMDFIFO_ENTRIES_SHIFT 20

#define WAIT_UNTIL_WAIT_RE_VSYNC_MASK  0x00000002
#define WAIT_UNTIL_WAIT_FE_VSYNC_MASK  0x00000004
#define WAIT_UNTIL_WAIT_VSYNC_MASK     0x00000008
#define WAIT_UNTIL_WAIT_DSPLY_ID0_MASK 0x00000010
#define WAIT_UNTIL_WAIT_DSPLY_ID1_MASK 0x00000020
#define WAIT_UNTIL_WAIT_DSPLY_ID2_MASK 0x00000040
#define WAIT_UNTIL_WAIT_CMDFIFO_MASK   0x00000400
#define WAIT_UNTIL_WAIT_2D_IDLE_MASK   0x00004000
#define WAIT_UNTIL_WAIT_3D_IDLE_MASK   0x00008000
#define WAIT_UNTIL_WAIT_2D_IDLECLEAN_MASK 0x00010000
#define WAIT_UNTIL_WAIT_3D_IDLECLEAN_MASK 0x00020000
#define WAIT_UNTIL_CMDFIFO_ENTRIES_MASK 0x00f00000

#define WAIT_UNTIL_MASK \
     (WAIT_UNTIL_WAIT_RE_VSYNC_MASK | \
      WAIT_UNTIL_WAIT_FE_VSYNC_MASK | \
      WAIT_UNTIL_WAIT_VSYNC_MASK | \
      WAIT_UNTIL_WAIT_DSPLY_ID0_MASK | \
      WAIT_UNTIL_WAIT_DSPLY_ID1_MASK | \
      WAIT_UNTIL_WAIT_DSPLY_ID2_MASK | \
      WAIT_UNTIL_WAIT_CMDFIFO_MASK | \
      WAIT_UNTIL_WAIT_2D_IDLE_MASK | \
      WAIT_UNTIL_WAIT_3D_IDLE_MASK | \
      WAIT_UNTIL_WAIT_2D_IDLECLEAN_MASK | \
      WAIT_UNTIL_WAIT_3D_IDLECLEAN_MASK | \
      WAIT_UNTIL_CMDFIFO_ENTRIES_MASK)

#define WAIT_UNTIL(wait_re_vsync, wait_fe_vsync, wait_vsync, wait_dsply_id0, wait_dsply_id1, wait_dsply_id2, wait_cmdfifo, wait_2d_idle, wait_3d_idle, wait_2d_idleclean, wait_3d_idleclean, cmdfifo_entries) \
     ((wait_re_vsync << WAIT_UNTIL_WAIT_RE_VSYNC_SHIFT) | \
      (wait_fe_vsync << WAIT_UNTIL_WAIT_FE_VSYNC_SHIFT) | \
      (wait_vsync << WAIT_UNTIL_WAIT_VSYNC_SHIFT) | \
      (wait_dsply_id0 << WAIT_UNTIL_WAIT_DSPLY_ID0_SHIFT) | \
      (wait_dsply_id1 << WAIT_UNTIL_WAIT_DSPLY_ID1_SHIFT) | \
      (wait_dsply_id2 << WAIT_UNTIL_WAIT_DSPLY_ID2_SHIFT) | \
      (wait_cmdfifo << WAIT_UNTIL_WAIT_CMDFIFO_SHIFT) | \
      (wait_2d_idle << WAIT_UNTIL_WAIT_2D_IDLE_SHIFT) | \
      (wait_3d_idle << WAIT_UNTIL_WAIT_3D_IDLE_SHIFT) | \
      (wait_2d_idleclean << WAIT_UNTIL_WAIT_2D_IDLECLEAN_SHIFT) | \
      (wait_3d_idleclean << WAIT_UNTIL_WAIT_3D_IDLECLEAN_SHIFT) | \
      (cmdfifo_entries << WAIT_UNTIL_CMDFIFO_ENTRIES_SHIFT))

#define WAIT_UNTIL_GET_WAIT_RE_VSYNC(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_RE_VSYNC_MASK) >> WAIT_UNTIL_WAIT_RE_VSYNC_SHIFT)
#define WAIT_UNTIL_GET_WAIT_FE_VSYNC(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_FE_VSYNC_MASK) >> WAIT_UNTIL_WAIT_FE_VSYNC_SHIFT)
#define WAIT_UNTIL_GET_WAIT_VSYNC(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_VSYNC_MASK) >> WAIT_UNTIL_WAIT_VSYNC_SHIFT)
#define WAIT_UNTIL_GET_WAIT_DSPLY_ID0(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_DSPLY_ID0_MASK) >> WAIT_UNTIL_WAIT_DSPLY_ID0_SHIFT)
#define WAIT_UNTIL_GET_WAIT_DSPLY_ID1(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_DSPLY_ID1_MASK) >> WAIT_UNTIL_WAIT_DSPLY_ID1_SHIFT)
#define WAIT_UNTIL_GET_WAIT_DSPLY_ID2(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_DSPLY_ID2_MASK) >> WAIT_UNTIL_WAIT_DSPLY_ID2_SHIFT)
#define WAIT_UNTIL_GET_WAIT_CMDFIFO(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_CMDFIFO_MASK) >> WAIT_UNTIL_WAIT_CMDFIFO_SHIFT)
#define WAIT_UNTIL_GET_WAIT_2D_IDLE(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_2D_IDLE_MASK) >> WAIT_UNTIL_WAIT_2D_IDLE_SHIFT)
#define WAIT_UNTIL_GET_WAIT_3D_IDLE(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_3D_IDLE_MASK) >> WAIT_UNTIL_WAIT_3D_IDLE_SHIFT)
#define WAIT_UNTIL_GET_WAIT_2D_IDLECLEAN(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_2D_IDLECLEAN_MASK) >> WAIT_UNTIL_WAIT_2D_IDLECLEAN_SHIFT)
#define WAIT_UNTIL_GET_WAIT_3D_IDLECLEAN(wait_until) \
     ((wait_until & WAIT_UNTIL_WAIT_3D_IDLECLEAN_MASK) >> WAIT_UNTIL_WAIT_3D_IDLECLEAN_SHIFT)
#define WAIT_UNTIL_GET_CMDFIFO_ENTRIES(wait_until) \
     ((wait_until & WAIT_UNTIL_CMDFIFO_ENTRIES_MASK) >> WAIT_UNTIL_CMDFIFO_ENTRIES_SHIFT)

#define WAIT_UNTIL_SET_WAIT_RE_VSYNC(wait_until_reg, wait_re_vsync) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_RE_VSYNC_MASK) | (wait_re_vsync << WAIT_UNTIL_WAIT_RE_VSYNC_SHIFT)
#define WAIT_UNTIL_SET_WAIT_FE_VSYNC(wait_until_reg, wait_fe_vsync) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_FE_VSYNC_MASK) | (wait_fe_vsync << WAIT_UNTIL_WAIT_FE_VSYNC_SHIFT)
#define WAIT_UNTIL_SET_WAIT_VSYNC(wait_until_reg, wait_vsync) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_VSYNC_MASK) | (wait_vsync << WAIT_UNTIL_WAIT_VSYNC_SHIFT)
#define WAIT_UNTIL_SET_WAIT_DSPLY_ID0(wait_until_reg, wait_dsply_id0) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_DSPLY_ID0_MASK) | (wait_dsply_id0 << WAIT_UNTIL_WAIT_DSPLY_ID0_SHIFT)
#define WAIT_UNTIL_SET_WAIT_DSPLY_ID1(wait_until_reg, wait_dsply_id1) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_DSPLY_ID1_MASK) | (wait_dsply_id1 << WAIT_UNTIL_WAIT_DSPLY_ID1_SHIFT)
#define WAIT_UNTIL_SET_WAIT_DSPLY_ID2(wait_until_reg, wait_dsply_id2) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_DSPLY_ID2_MASK) | (wait_dsply_id2 << WAIT_UNTIL_WAIT_DSPLY_ID2_SHIFT)
#define WAIT_UNTIL_SET_WAIT_CMDFIFO(wait_until_reg, wait_cmdfifo) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_CMDFIFO_MASK) | (wait_cmdfifo << WAIT_UNTIL_WAIT_CMDFIFO_SHIFT)
#define WAIT_UNTIL_SET_WAIT_2D_IDLE(wait_until_reg, wait_2d_idle) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_2D_IDLE_MASK) | (wait_2d_idle << WAIT_UNTIL_WAIT_2D_IDLE_SHIFT)
#define WAIT_UNTIL_SET_WAIT_3D_IDLE(wait_until_reg, wait_3d_idle) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_3D_IDLE_MASK) | (wait_3d_idle << WAIT_UNTIL_WAIT_3D_IDLE_SHIFT)
#define WAIT_UNTIL_SET_WAIT_2D_IDLECLEAN(wait_until_reg, wait_2d_idleclean) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_2D_IDLECLEAN_MASK) | (wait_2d_idleclean << WAIT_UNTIL_WAIT_2D_IDLECLEAN_SHIFT)
#define WAIT_UNTIL_SET_WAIT_3D_IDLECLEAN(wait_until_reg, wait_3d_idleclean) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_WAIT_3D_IDLECLEAN_MASK) | (wait_3d_idleclean << WAIT_UNTIL_WAIT_3D_IDLECLEAN_SHIFT)
#define WAIT_UNTIL_SET_CMDFIFO_ENTRIES(wait_until_reg, cmdfifo_entries) \
     wait_until_reg = (wait_until_reg & ~WAIT_UNTIL_CMDFIFO_ENTRIES_MASK) | (cmdfifo_entries << WAIT_UNTIL_CMDFIFO_ENTRIES_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _wait_until_t {
          unsigned int                                : 1;
          unsigned int wait_re_vsync                  : WAIT_UNTIL_WAIT_RE_VSYNC_SIZE;
          unsigned int wait_fe_vsync                  : WAIT_UNTIL_WAIT_FE_VSYNC_SIZE;
          unsigned int wait_vsync                     : WAIT_UNTIL_WAIT_VSYNC_SIZE;
          unsigned int wait_dsply_id0                 : WAIT_UNTIL_WAIT_DSPLY_ID0_SIZE;
          unsigned int wait_dsply_id1                 : WAIT_UNTIL_WAIT_DSPLY_ID1_SIZE;
          unsigned int wait_dsply_id2                 : WAIT_UNTIL_WAIT_DSPLY_ID2_SIZE;
          unsigned int                                : 3;
          unsigned int wait_cmdfifo                   : WAIT_UNTIL_WAIT_CMDFIFO_SIZE;
          unsigned int                                : 3;
          unsigned int wait_2d_idle                   : WAIT_UNTIL_WAIT_2D_IDLE_SIZE;
          unsigned int wait_3d_idle                   : WAIT_UNTIL_WAIT_3D_IDLE_SIZE;
          unsigned int wait_2d_idleclean              : WAIT_UNTIL_WAIT_2D_IDLECLEAN_SIZE;
          unsigned int wait_3d_idleclean              : WAIT_UNTIL_WAIT_3D_IDLECLEAN_SIZE;
          unsigned int                                : 2;
          unsigned int cmdfifo_entries                : WAIT_UNTIL_CMDFIFO_ENTRIES_SIZE;
          unsigned int                                : 8;
     } wait_until_t;

#else   // !BIGENDIAN_OS

     typedef struct _wait_until_t {
          unsigned int                                : 8;
          unsigned int cmdfifo_entries                : WAIT_UNTIL_CMDFIFO_ENTRIES_SIZE;
          unsigned int                                : 2;
          unsigned int wait_3d_idleclean              : WAIT_UNTIL_WAIT_3D_IDLECLEAN_SIZE;
          unsigned int wait_2d_idleclean              : WAIT_UNTIL_WAIT_2D_IDLECLEAN_SIZE;
          unsigned int wait_3d_idle                   : WAIT_UNTIL_WAIT_3D_IDLE_SIZE;
          unsigned int wait_2d_idle                   : WAIT_UNTIL_WAIT_2D_IDLE_SIZE;
          unsigned int                                : 3;
          unsigned int wait_cmdfifo                   : WAIT_UNTIL_WAIT_CMDFIFO_SIZE;
          unsigned int                                : 3;
          unsigned int wait_dsply_id2                 : WAIT_UNTIL_WAIT_DSPLY_ID2_SIZE;
          unsigned int wait_dsply_id1                 : WAIT_UNTIL_WAIT_DSPLY_ID1_SIZE;
          unsigned int wait_dsply_id0                 : WAIT_UNTIL_WAIT_DSPLY_ID0_SIZE;
          unsigned int wait_vsync                     : WAIT_UNTIL_WAIT_VSYNC_SIZE;
          unsigned int wait_fe_vsync                  : WAIT_UNTIL_WAIT_FE_VSYNC_SIZE;
          unsigned int wait_re_vsync                  : WAIT_UNTIL_WAIT_RE_VSYNC_SIZE;
          unsigned int                                : 1;
     } wait_until_t;

#endif

typedef union {
     unsigned int val : 32;
     wait_until_t f;
} wait_until_u;


/*
 * RBBM_ISYNC_CNTL struct
 */

#define RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_SIZE 1
#define RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_SIZE 1

#define RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_SHIFT 4
#define RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_SHIFT 5

#define RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_MASK 0x00000010
#define RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_MASK 0x00000020

#define RBBM_ISYNC_CNTL_MASK \
     (RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_MASK | \
      RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_MASK)

#define RBBM_ISYNC_CNTL(isync_wait_idlegui, isync_cpscratch_idlegui) \
     ((isync_wait_idlegui << RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_SHIFT) | \
      (isync_cpscratch_idlegui << RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_SHIFT))

#define RBBM_ISYNC_CNTL_GET_ISYNC_WAIT_IDLEGUI(rbbm_isync_cntl) \
     ((rbbm_isync_cntl & RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_MASK) >> RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_SHIFT)
#define RBBM_ISYNC_CNTL_GET_ISYNC_CPSCRATCH_IDLEGUI(rbbm_isync_cntl) \
     ((rbbm_isync_cntl & RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_MASK) >> RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_SHIFT)

#define RBBM_ISYNC_CNTL_SET_ISYNC_WAIT_IDLEGUI(rbbm_isync_cntl_reg, isync_wait_idlegui) \
     rbbm_isync_cntl_reg = (rbbm_isync_cntl_reg & ~RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_MASK) | (isync_wait_idlegui << RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_SHIFT)
#define RBBM_ISYNC_CNTL_SET_ISYNC_CPSCRATCH_IDLEGUI(rbbm_isync_cntl_reg, isync_cpscratch_idlegui) \
     rbbm_isync_cntl_reg = (rbbm_isync_cntl_reg & ~RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_MASK) | (isync_cpscratch_idlegui << RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_isync_cntl_t {
          unsigned int                                : 4;
          unsigned int isync_wait_idlegui             : RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_SIZE;
          unsigned int isync_cpscratch_idlegui        : RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_SIZE;
          unsigned int                                : 26;
     } rbbm_isync_cntl_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_isync_cntl_t {
          unsigned int                                : 26;
          unsigned int isync_cpscratch_idlegui        : RBBM_ISYNC_CNTL_ISYNC_CPSCRATCH_IDLEGUI_SIZE;
          unsigned int isync_wait_idlegui             : RBBM_ISYNC_CNTL_ISYNC_WAIT_IDLEGUI_SIZE;
          unsigned int                                : 4;
     } rbbm_isync_cntl_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_isync_cntl_t f;
} rbbm_isync_cntl_u;


/*
 * RBBM_STATUS struct
 */

#define RBBM_STATUS_CMDFIFO_AVAIL_SIZE 5
#define RBBM_STATUS_TC_BUSY_SIZE       1
#define RBBM_STATUS_HIRQ_PENDING_SIZE  1
#define RBBM_STATUS_CPRQ_PENDING_SIZE  1
#define RBBM_STATUS_CFRQ_PENDING_SIZE  1
#define RBBM_STATUS_PFRQ_PENDING_SIZE  1
#define RBBM_STATUS_VGT_BUSY_NO_DMA_SIZE 1
#define RBBM_STATUS_RBBM_WU_BUSY_SIZE  1
#define RBBM_STATUS_CP_NRT_BUSY_SIZE   1
#define RBBM_STATUS_MH_BUSY_SIZE       1
#define RBBM_STATUS_MH_COHERENCY_BUSY_SIZE 1
#define RBBM_STATUS_SX_BUSY_SIZE       1
#define RBBM_STATUS_TPC_BUSY_SIZE      1
#define RBBM_STATUS_SC_CNTX_BUSY_SIZE  1
#define RBBM_STATUS_PA_BUSY_SIZE       1
#define RBBM_STATUS_VGT_BUSY_SIZE      1
#define RBBM_STATUS_SQ_CNTX17_BUSY_SIZE 1
#define RBBM_STATUS_SQ_CNTX0_BUSY_SIZE 1
#define RBBM_STATUS_RB_CNTX_BUSY_SIZE  1
#define RBBM_STATUS_GUI_ACTIVE_SIZE    1

#define RBBM_STATUS_CMDFIFO_AVAIL_SHIFT 0
#define RBBM_STATUS_TC_BUSY_SHIFT      5
#define RBBM_STATUS_HIRQ_PENDING_SHIFT 8
#define RBBM_STATUS_CPRQ_PENDING_SHIFT 9
#define RBBM_STATUS_CFRQ_PENDING_SHIFT 10
#define RBBM_STATUS_PFRQ_PENDING_SHIFT 11
#define RBBM_STATUS_VGT_BUSY_NO_DMA_SHIFT 12
#define RBBM_STATUS_RBBM_WU_BUSY_SHIFT 14
#define RBBM_STATUS_CP_NRT_BUSY_SHIFT  16
#define RBBM_STATUS_MH_BUSY_SHIFT      18
#define RBBM_STATUS_MH_COHERENCY_BUSY_SHIFT 19
#define RBBM_STATUS_SX_BUSY_SHIFT      21
#define RBBM_STATUS_TPC_BUSY_SHIFT     22
#define RBBM_STATUS_SC_CNTX_BUSY_SHIFT 24
#define RBBM_STATUS_PA_BUSY_SHIFT      25
#define RBBM_STATUS_VGT_BUSY_SHIFT     26
#define RBBM_STATUS_SQ_CNTX17_BUSY_SHIFT 27
#define RBBM_STATUS_SQ_CNTX0_BUSY_SHIFT 28
#define RBBM_STATUS_RB_CNTX_BUSY_SHIFT 30
#define RBBM_STATUS_GUI_ACTIVE_SHIFT   31

#define RBBM_STATUS_CMDFIFO_AVAIL_MASK 0x0000001f
#define RBBM_STATUS_TC_BUSY_MASK       0x00000020
#define RBBM_STATUS_HIRQ_PENDING_MASK  0x00000100
#define RBBM_STATUS_CPRQ_PENDING_MASK  0x00000200
#define RBBM_STATUS_CFRQ_PENDING_MASK  0x00000400
#define RBBM_STATUS_PFRQ_PENDING_MASK  0x00000800
#define RBBM_STATUS_VGT_BUSY_NO_DMA_MASK 0x00001000
#define RBBM_STATUS_RBBM_WU_BUSY_MASK  0x00004000
#define RBBM_STATUS_CP_NRT_BUSY_MASK   0x00010000
#define RBBM_STATUS_MH_BUSY_MASK       0x00040000
#define RBBM_STATUS_MH_COHERENCY_BUSY_MASK 0x00080000
#define RBBM_STATUS_SX_BUSY_MASK       0x00200000
#define RBBM_STATUS_TPC_BUSY_MASK      0x00400000
#define RBBM_STATUS_SC_CNTX_BUSY_MASK  0x01000000
#define RBBM_STATUS_PA_BUSY_MASK       0x02000000
#define RBBM_STATUS_VGT_BUSY_MASK      0x04000000
#define RBBM_STATUS_SQ_CNTX17_BUSY_MASK 0x08000000
#define RBBM_STATUS_SQ_CNTX0_BUSY_MASK 0x10000000
#define RBBM_STATUS_RB_CNTX_BUSY_MASK  0x40000000
#define RBBM_STATUS_GUI_ACTIVE_MASK    0x80000000

#define RBBM_STATUS_MASK \
     (RBBM_STATUS_CMDFIFO_AVAIL_MASK | \
      RBBM_STATUS_TC_BUSY_MASK | \
      RBBM_STATUS_HIRQ_PENDING_MASK | \
      RBBM_STATUS_CPRQ_PENDING_MASK | \
      RBBM_STATUS_CFRQ_PENDING_MASK | \
      RBBM_STATUS_PFRQ_PENDING_MASK | \
      RBBM_STATUS_VGT_BUSY_NO_DMA_MASK | \
      RBBM_STATUS_RBBM_WU_BUSY_MASK | \
      RBBM_STATUS_CP_NRT_BUSY_MASK | \
      RBBM_STATUS_MH_BUSY_MASK | \
      RBBM_STATUS_MH_COHERENCY_BUSY_MASK | \
      RBBM_STATUS_SX_BUSY_MASK | \
      RBBM_STATUS_TPC_BUSY_MASK | \
      RBBM_STATUS_SC_CNTX_BUSY_MASK | \
      RBBM_STATUS_PA_BUSY_MASK | \
      RBBM_STATUS_VGT_BUSY_MASK | \
      RBBM_STATUS_SQ_CNTX17_BUSY_MASK | \
      RBBM_STATUS_SQ_CNTX0_BUSY_MASK | \
      RBBM_STATUS_RB_CNTX_BUSY_MASK | \
      RBBM_STATUS_GUI_ACTIVE_MASK)

#define RBBM_STATUS(cmdfifo_avail, tc_busy, hirq_pending, cprq_pending, cfrq_pending, pfrq_pending, vgt_busy_no_dma, rbbm_wu_busy, cp_nrt_busy, mh_busy, mh_coherency_busy, sx_busy, tpc_busy, sc_cntx_busy, pa_busy, vgt_busy, sq_cntx17_busy, sq_cntx0_busy, rb_cntx_busy, gui_active) \
     ((cmdfifo_avail << RBBM_STATUS_CMDFIFO_AVAIL_SHIFT) | \
      (tc_busy << RBBM_STATUS_TC_BUSY_SHIFT) | \
      (hirq_pending << RBBM_STATUS_HIRQ_PENDING_SHIFT) | \
      (cprq_pending << RBBM_STATUS_CPRQ_PENDING_SHIFT) | \
      (cfrq_pending << RBBM_STATUS_CFRQ_PENDING_SHIFT) | \
      (pfrq_pending << RBBM_STATUS_PFRQ_PENDING_SHIFT) | \
      (vgt_busy_no_dma << RBBM_STATUS_VGT_BUSY_NO_DMA_SHIFT) | \
      (rbbm_wu_busy << RBBM_STATUS_RBBM_WU_BUSY_SHIFT) | \
      (cp_nrt_busy << RBBM_STATUS_CP_NRT_BUSY_SHIFT) | \
      (mh_busy << RBBM_STATUS_MH_BUSY_SHIFT) | \
      (mh_coherency_busy << RBBM_STATUS_MH_COHERENCY_BUSY_SHIFT) | \
      (sx_busy << RBBM_STATUS_SX_BUSY_SHIFT) | \
      (tpc_busy << RBBM_STATUS_TPC_BUSY_SHIFT) | \
      (sc_cntx_busy << RBBM_STATUS_SC_CNTX_BUSY_SHIFT) | \
      (pa_busy << RBBM_STATUS_PA_BUSY_SHIFT) | \
      (vgt_busy << RBBM_STATUS_VGT_BUSY_SHIFT) | \
      (sq_cntx17_busy << RBBM_STATUS_SQ_CNTX17_BUSY_SHIFT) | \
      (sq_cntx0_busy << RBBM_STATUS_SQ_CNTX0_BUSY_SHIFT) | \
      (rb_cntx_busy << RBBM_STATUS_RB_CNTX_BUSY_SHIFT) | \
      (gui_active << RBBM_STATUS_GUI_ACTIVE_SHIFT))

#define RBBM_STATUS_GET_CMDFIFO_AVAIL(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_CMDFIFO_AVAIL_MASK) >> RBBM_STATUS_CMDFIFO_AVAIL_SHIFT)
#define RBBM_STATUS_GET_TC_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_TC_BUSY_MASK) >> RBBM_STATUS_TC_BUSY_SHIFT)
#define RBBM_STATUS_GET_HIRQ_PENDING(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_HIRQ_PENDING_MASK) >> RBBM_STATUS_HIRQ_PENDING_SHIFT)
#define RBBM_STATUS_GET_CPRQ_PENDING(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_CPRQ_PENDING_MASK) >> RBBM_STATUS_CPRQ_PENDING_SHIFT)
#define RBBM_STATUS_GET_CFRQ_PENDING(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_CFRQ_PENDING_MASK) >> RBBM_STATUS_CFRQ_PENDING_SHIFT)
#define RBBM_STATUS_GET_PFRQ_PENDING(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_PFRQ_PENDING_MASK) >> RBBM_STATUS_PFRQ_PENDING_SHIFT)
#define RBBM_STATUS_GET_VGT_BUSY_NO_DMA(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_VGT_BUSY_NO_DMA_MASK) >> RBBM_STATUS_VGT_BUSY_NO_DMA_SHIFT)
#define RBBM_STATUS_GET_RBBM_WU_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_RBBM_WU_BUSY_MASK) >> RBBM_STATUS_RBBM_WU_BUSY_SHIFT)
#define RBBM_STATUS_GET_CP_NRT_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_CP_NRT_BUSY_MASK) >> RBBM_STATUS_CP_NRT_BUSY_SHIFT)
#define RBBM_STATUS_GET_MH_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_MH_BUSY_MASK) >> RBBM_STATUS_MH_BUSY_SHIFT)
#define RBBM_STATUS_GET_MH_COHERENCY_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_MH_COHERENCY_BUSY_MASK) >> RBBM_STATUS_MH_COHERENCY_BUSY_SHIFT)
#define RBBM_STATUS_GET_SX_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_SX_BUSY_MASK) >> RBBM_STATUS_SX_BUSY_SHIFT)
#define RBBM_STATUS_GET_TPC_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_TPC_BUSY_MASK) >> RBBM_STATUS_TPC_BUSY_SHIFT)
#define RBBM_STATUS_GET_SC_CNTX_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_SC_CNTX_BUSY_MASK) >> RBBM_STATUS_SC_CNTX_BUSY_SHIFT)
#define RBBM_STATUS_GET_PA_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_PA_BUSY_MASK) >> RBBM_STATUS_PA_BUSY_SHIFT)
#define RBBM_STATUS_GET_VGT_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_VGT_BUSY_MASK) >> RBBM_STATUS_VGT_BUSY_SHIFT)
#define RBBM_STATUS_GET_SQ_CNTX17_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_SQ_CNTX17_BUSY_MASK) >> RBBM_STATUS_SQ_CNTX17_BUSY_SHIFT)
#define RBBM_STATUS_GET_SQ_CNTX0_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_SQ_CNTX0_BUSY_MASK) >> RBBM_STATUS_SQ_CNTX0_BUSY_SHIFT)
#define RBBM_STATUS_GET_RB_CNTX_BUSY(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_RB_CNTX_BUSY_MASK) >> RBBM_STATUS_RB_CNTX_BUSY_SHIFT)
#define RBBM_STATUS_GET_GUI_ACTIVE(rbbm_status) \
     ((rbbm_status & RBBM_STATUS_GUI_ACTIVE_MASK) >> RBBM_STATUS_GUI_ACTIVE_SHIFT)

#define RBBM_STATUS_SET_CMDFIFO_AVAIL(rbbm_status_reg, cmdfifo_avail) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_CMDFIFO_AVAIL_MASK) | (cmdfifo_avail << RBBM_STATUS_CMDFIFO_AVAIL_SHIFT)
#define RBBM_STATUS_SET_TC_BUSY(rbbm_status_reg, tc_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_TC_BUSY_MASK) | (tc_busy << RBBM_STATUS_TC_BUSY_SHIFT)
#define RBBM_STATUS_SET_HIRQ_PENDING(rbbm_status_reg, hirq_pending) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_HIRQ_PENDING_MASK) | (hirq_pending << RBBM_STATUS_HIRQ_PENDING_SHIFT)
#define RBBM_STATUS_SET_CPRQ_PENDING(rbbm_status_reg, cprq_pending) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_CPRQ_PENDING_MASK) | (cprq_pending << RBBM_STATUS_CPRQ_PENDING_SHIFT)
#define RBBM_STATUS_SET_CFRQ_PENDING(rbbm_status_reg, cfrq_pending) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_CFRQ_PENDING_MASK) | (cfrq_pending << RBBM_STATUS_CFRQ_PENDING_SHIFT)
#define RBBM_STATUS_SET_PFRQ_PENDING(rbbm_status_reg, pfrq_pending) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_PFRQ_PENDING_MASK) | (pfrq_pending << RBBM_STATUS_PFRQ_PENDING_SHIFT)
#define RBBM_STATUS_SET_VGT_BUSY_NO_DMA(rbbm_status_reg, vgt_busy_no_dma) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_VGT_BUSY_NO_DMA_MASK) | (vgt_busy_no_dma << RBBM_STATUS_VGT_BUSY_NO_DMA_SHIFT)
#define RBBM_STATUS_SET_RBBM_WU_BUSY(rbbm_status_reg, rbbm_wu_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_RBBM_WU_BUSY_MASK) | (rbbm_wu_busy << RBBM_STATUS_RBBM_WU_BUSY_SHIFT)
#define RBBM_STATUS_SET_CP_NRT_BUSY(rbbm_status_reg, cp_nrt_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_CP_NRT_BUSY_MASK) | (cp_nrt_busy << RBBM_STATUS_CP_NRT_BUSY_SHIFT)
#define RBBM_STATUS_SET_MH_BUSY(rbbm_status_reg, mh_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_MH_BUSY_MASK) | (mh_busy << RBBM_STATUS_MH_BUSY_SHIFT)
#define RBBM_STATUS_SET_MH_COHERENCY_BUSY(rbbm_status_reg, mh_coherency_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_MH_COHERENCY_BUSY_MASK) | (mh_coherency_busy << RBBM_STATUS_MH_COHERENCY_BUSY_SHIFT)
#define RBBM_STATUS_SET_SX_BUSY(rbbm_status_reg, sx_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_SX_BUSY_MASK) | (sx_busy << RBBM_STATUS_SX_BUSY_SHIFT)
#define RBBM_STATUS_SET_TPC_BUSY(rbbm_status_reg, tpc_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_TPC_BUSY_MASK) | (tpc_busy << RBBM_STATUS_TPC_BUSY_SHIFT)
#define RBBM_STATUS_SET_SC_CNTX_BUSY(rbbm_status_reg, sc_cntx_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_SC_CNTX_BUSY_MASK) | (sc_cntx_busy << RBBM_STATUS_SC_CNTX_BUSY_SHIFT)
#define RBBM_STATUS_SET_PA_BUSY(rbbm_status_reg, pa_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_PA_BUSY_MASK) | (pa_busy << RBBM_STATUS_PA_BUSY_SHIFT)
#define RBBM_STATUS_SET_VGT_BUSY(rbbm_status_reg, vgt_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_VGT_BUSY_MASK) | (vgt_busy << RBBM_STATUS_VGT_BUSY_SHIFT)
#define RBBM_STATUS_SET_SQ_CNTX17_BUSY(rbbm_status_reg, sq_cntx17_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_SQ_CNTX17_BUSY_MASK) | (sq_cntx17_busy << RBBM_STATUS_SQ_CNTX17_BUSY_SHIFT)
#define RBBM_STATUS_SET_SQ_CNTX0_BUSY(rbbm_status_reg, sq_cntx0_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_SQ_CNTX0_BUSY_MASK) | (sq_cntx0_busy << RBBM_STATUS_SQ_CNTX0_BUSY_SHIFT)
#define RBBM_STATUS_SET_RB_CNTX_BUSY(rbbm_status_reg, rb_cntx_busy) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_RB_CNTX_BUSY_MASK) | (rb_cntx_busy << RBBM_STATUS_RB_CNTX_BUSY_SHIFT)
#define RBBM_STATUS_SET_GUI_ACTIVE(rbbm_status_reg, gui_active) \
     rbbm_status_reg = (rbbm_status_reg & ~RBBM_STATUS_GUI_ACTIVE_MASK) | (gui_active << RBBM_STATUS_GUI_ACTIVE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_status_t {
          unsigned int cmdfifo_avail                  : RBBM_STATUS_CMDFIFO_AVAIL_SIZE;
          unsigned int tc_busy                        : RBBM_STATUS_TC_BUSY_SIZE;
          unsigned int                                : 2;
          unsigned int hirq_pending                   : RBBM_STATUS_HIRQ_PENDING_SIZE;
          unsigned int cprq_pending                   : RBBM_STATUS_CPRQ_PENDING_SIZE;
          unsigned int cfrq_pending                   : RBBM_STATUS_CFRQ_PENDING_SIZE;
          unsigned int pfrq_pending                   : RBBM_STATUS_PFRQ_PENDING_SIZE;
          unsigned int vgt_busy_no_dma                : RBBM_STATUS_VGT_BUSY_NO_DMA_SIZE;
          unsigned int                                : 1;
          unsigned int rbbm_wu_busy                   : RBBM_STATUS_RBBM_WU_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int cp_nrt_busy                    : RBBM_STATUS_CP_NRT_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int mh_busy                        : RBBM_STATUS_MH_BUSY_SIZE;
          unsigned int mh_coherency_busy              : RBBM_STATUS_MH_COHERENCY_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int sx_busy                        : RBBM_STATUS_SX_BUSY_SIZE;
          unsigned int tpc_busy                       : RBBM_STATUS_TPC_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int sc_cntx_busy                   : RBBM_STATUS_SC_CNTX_BUSY_SIZE;
          unsigned int pa_busy                        : RBBM_STATUS_PA_BUSY_SIZE;
          unsigned int vgt_busy                       : RBBM_STATUS_VGT_BUSY_SIZE;
          unsigned int sq_cntx17_busy                 : RBBM_STATUS_SQ_CNTX17_BUSY_SIZE;
          unsigned int sq_cntx0_busy                  : RBBM_STATUS_SQ_CNTX0_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int rb_cntx_busy                   : RBBM_STATUS_RB_CNTX_BUSY_SIZE;
          unsigned int gui_active                     : RBBM_STATUS_GUI_ACTIVE_SIZE;
     } rbbm_status_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_status_t {
          unsigned int gui_active                     : RBBM_STATUS_GUI_ACTIVE_SIZE;
          unsigned int rb_cntx_busy                   : RBBM_STATUS_RB_CNTX_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int sq_cntx0_busy                  : RBBM_STATUS_SQ_CNTX0_BUSY_SIZE;
          unsigned int sq_cntx17_busy                 : RBBM_STATUS_SQ_CNTX17_BUSY_SIZE;
          unsigned int vgt_busy                       : RBBM_STATUS_VGT_BUSY_SIZE;
          unsigned int pa_busy                        : RBBM_STATUS_PA_BUSY_SIZE;
          unsigned int sc_cntx_busy                   : RBBM_STATUS_SC_CNTX_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int tpc_busy                       : RBBM_STATUS_TPC_BUSY_SIZE;
          unsigned int sx_busy                        : RBBM_STATUS_SX_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int mh_coherency_busy              : RBBM_STATUS_MH_COHERENCY_BUSY_SIZE;
          unsigned int mh_busy                        : RBBM_STATUS_MH_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int cp_nrt_busy                    : RBBM_STATUS_CP_NRT_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int rbbm_wu_busy                   : RBBM_STATUS_RBBM_WU_BUSY_SIZE;
          unsigned int                                : 1;
          unsigned int vgt_busy_no_dma                : RBBM_STATUS_VGT_BUSY_NO_DMA_SIZE;
          unsigned int pfrq_pending                   : RBBM_STATUS_PFRQ_PENDING_SIZE;
          unsigned int cfrq_pending                   : RBBM_STATUS_CFRQ_PENDING_SIZE;
          unsigned int cprq_pending                   : RBBM_STATUS_CPRQ_PENDING_SIZE;
          unsigned int hirq_pending                   : RBBM_STATUS_HIRQ_PENDING_SIZE;
          unsigned int                                : 2;
          unsigned int tc_busy                        : RBBM_STATUS_TC_BUSY_SIZE;
          unsigned int cmdfifo_avail                  : RBBM_STATUS_CMDFIFO_AVAIL_SIZE;
     } rbbm_status_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_status_t f;
} rbbm_status_u;


/*
 * RBBM_DSPLY struct
 */

#define RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_SIZE 1
#define RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_SIZE 1
#define RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_SIZE 1
#define RBBM_DSPLY_SEL_DMI_VSYNC_VALID_SIZE 1
#define RBBM_DSPLY_DMI_CH1_USE_BUFID0_SIZE 1
#define RBBM_DSPLY_DMI_CH1_USE_BUFID1_SIZE 1
#define RBBM_DSPLY_DMI_CH1_USE_BUFID2_SIZE 1
#define RBBM_DSPLY_DMI_CH1_SW_CNTL_SIZE 1
#define RBBM_DSPLY_DMI_CH1_NUM_BUFS_SIZE 2
#define RBBM_DSPLY_DMI_CH2_USE_BUFID0_SIZE 1
#define RBBM_DSPLY_DMI_CH2_USE_BUFID1_SIZE 1
#define RBBM_DSPLY_DMI_CH2_USE_BUFID2_SIZE 1
#define RBBM_DSPLY_DMI_CH2_SW_CNTL_SIZE 1
#define RBBM_DSPLY_DMI_CH2_NUM_BUFS_SIZE 2
#define RBBM_DSPLY_DMI_CHANNEL_SELECT_SIZE 2
#define RBBM_DSPLY_DMI_CH3_USE_BUFID0_SIZE 1
#define RBBM_DSPLY_DMI_CH3_USE_BUFID1_SIZE 1
#define RBBM_DSPLY_DMI_CH3_USE_BUFID2_SIZE 1
#define RBBM_DSPLY_DMI_CH3_SW_CNTL_SIZE 1
#define RBBM_DSPLY_DMI_CH3_NUM_BUFS_SIZE 2
#define RBBM_DSPLY_DMI_CH4_USE_BUFID0_SIZE 1
#define RBBM_DSPLY_DMI_CH4_USE_BUFID1_SIZE 1
#define RBBM_DSPLY_DMI_CH4_USE_BUFID2_SIZE 1
#define RBBM_DSPLY_DMI_CH4_SW_CNTL_SIZE 1
#define RBBM_DSPLY_DMI_CH4_NUM_BUFS_SIZE 2

#define RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_SHIFT 0
#define RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_SHIFT 1
#define RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_SHIFT 2
#define RBBM_DSPLY_SEL_DMI_VSYNC_VALID_SHIFT 3
#define RBBM_DSPLY_DMI_CH1_USE_BUFID0_SHIFT 4
#define RBBM_DSPLY_DMI_CH1_USE_BUFID1_SHIFT 5
#define RBBM_DSPLY_DMI_CH1_USE_BUFID2_SHIFT 6
#define RBBM_DSPLY_DMI_CH1_SW_CNTL_SHIFT 7
#define RBBM_DSPLY_DMI_CH1_NUM_BUFS_SHIFT 8
#define RBBM_DSPLY_DMI_CH2_USE_BUFID0_SHIFT 10
#define RBBM_DSPLY_DMI_CH2_USE_BUFID1_SHIFT 11
#define RBBM_DSPLY_DMI_CH2_USE_BUFID2_SHIFT 12
#define RBBM_DSPLY_DMI_CH2_SW_CNTL_SHIFT 13
#define RBBM_DSPLY_DMI_CH2_NUM_BUFS_SHIFT 14
#define RBBM_DSPLY_DMI_CHANNEL_SELECT_SHIFT 16
#define RBBM_DSPLY_DMI_CH3_USE_BUFID0_SHIFT 20
#define RBBM_DSPLY_DMI_CH3_USE_BUFID1_SHIFT 21
#define RBBM_DSPLY_DMI_CH3_USE_BUFID2_SHIFT 22
#define RBBM_DSPLY_DMI_CH3_SW_CNTL_SHIFT 23
#define RBBM_DSPLY_DMI_CH3_NUM_BUFS_SHIFT 24
#define RBBM_DSPLY_DMI_CH4_USE_BUFID0_SHIFT 26
#define RBBM_DSPLY_DMI_CH4_USE_BUFID1_SHIFT 27
#define RBBM_DSPLY_DMI_CH4_USE_BUFID2_SHIFT 28
#define RBBM_DSPLY_DMI_CH4_SW_CNTL_SHIFT 29
#define RBBM_DSPLY_DMI_CH4_NUM_BUFS_SHIFT 30

#define RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_MASK 0x00000001
#define RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_MASK 0x00000002
#define RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_MASK 0x00000004
#define RBBM_DSPLY_SEL_DMI_VSYNC_VALID_MASK 0x00000008
#define RBBM_DSPLY_DMI_CH1_USE_BUFID0_MASK 0x00000010
#define RBBM_DSPLY_DMI_CH1_USE_BUFID1_MASK 0x00000020
#define RBBM_DSPLY_DMI_CH1_USE_BUFID2_MASK 0x00000040
#define RBBM_DSPLY_DMI_CH1_SW_CNTL_MASK 0x00000080
#define RBBM_DSPLY_DMI_CH1_NUM_BUFS_MASK 0x00000300
#define RBBM_DSPLY_DMI_CH2_USE_BUFID0_MASK 0x00000400
#define RBBM_DSPLY_DMI_CH2_USE_BUFID1_MASK 0x00000800
#define RBBM_DSPLY_DMI_CH2_USE_BUFID2_MASK 0x00001000
#define RBBM_DSPLY_DMI_CH2_SW_CNTL_MASK 0x00002000
#define RBBM_DSPLY_DMI_CH2_NUM_BUFS_MASK 0x0000c000
#define RBBM_DSPLY_DMI_CHANNEL_SELECT_MASK 0x00030000
#define RBBM_DSPLY_DMI_CH3_USE_BUFID0_MASK 0x00100000
#define RBBM_DSPLY_DMI_CH3_USE_BUFID1_MASK 0x00200000
#define RBBM_DSPLY_DMI_CH3_USE_BUFID2_MASK 0x00400000
#define RBBM_DSPLY_DMI_CH3_SW_CNTL_MASK 0x00800000
#define RBBM_DSPLY_DMI_CH3_NUM_BUFS_MASK 0x03000000
#define RBBM_DSPLY_DMI_CH4_USE_BUFID0_MASK 0x04000000
#define RBBM_DSPLY_DMI_CH4_USE_BUFID1_MASK 0x08000000
#define RBBM_DSPLY_DMI_CH4_USE_BUFID2_MASK 0x10000000
#define RBBM_DSPLY_DMI_CH4_SW_CNTL_MASK 0x20000000
#define RBBM_DSPLY_DMI_CH4_NUM_BUFS_MASK 0xc0000000

#define RBBM_DSPLY_MASK \
     (RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_MASK | \
      RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_MASK | \
      RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_MASK | \
      RBBM_DSPLY_SEL_DMI_VSYNC_VALID_MASK | \
      RBBM_DSPLY_DMI_CH1_USE_BUFID0_MASK | \
      RBBM_DSPLY_DMI_CH1_USE_BUFID1_MASK | \
      RBBM_DSPLY_DMI_CH1_USE_BUFID2_MASK | \
      RBBM_DSPLY_DMI_CH1_SW_CNTL_MASK | \
      RBBM_DSPLY_DMI_CH1_NUM_BUFS_MASK | \
      RBBM_DSPLY_DMI_CH2_USE_BUFID0_MASK | \
      RBBM_DSPLY_DMI_CH2_USE_BUFID1_MASK | \
      RBBM_DSPLY_DMI_CH2_USE_BUFID2_MASK | \
      RBBM_DSPLY_DMI_CH2_SW_CNTL_MASK | \
      RBBM_DSPLY_DMI_CH2_NUM_BUFS_MASK | \
      RBBM_DSPLY_DMI_CHANNEL_SELECT_MASK | \
      RBBM_DSPLY_DMI_CH3_USE_BUFID0_MASK | \
      RBBM_DSPLY_DMI_CH3_USE_BUFID1_MASK | \
      RBBM_DSPLY_DMI_CH3_USE_BUFID2_MASK | \
      RBBM_DSPLY_DMI_CH3_SW_CNTL_MASK | \
      RBBM_DSPLY_DMI_CH3_NUM_BUFS_MASK | \
      RBBM_DSPLY_DMI_CH4_USE_BUFID0_MASK | \
      RBBM_DSPLY_DMI_CH4_USE_BUFID1_MASK | \
      RBBM_DSPLY_DMI_CH4_USE_BUFID2_MASK | \
      RBBM_DSPLY_DMI_CH4_SW_CNTL_MASK | \
      RBBM_DSPLY_DMI_CH4_NUM_BUFS_MASK)

#define RBBM_DSPLY(sel_dmi_active_bufid0, sel_dmi_active_bufid1, sel_dmi_active_bufid2, sel_dmi_vsync_valid, dmi_ch1_use_bufid0, dmi_ch1_use_bufid1, dmi_ch1_use_bufid2, dmi_ch1_sw_cntl, dmi_ch1_num_bufs, dmi_ch2_use_bufid0, dmi_ch2_use_bufid1, dmi_ch2_use_bufid2, dmi_ch2_sw_cntl, dmi_ch2_num_bufs, dmi_channel_select, dmi_ch3_use_bufid0, dmi_ch3_use_bufid1, dmi_ch3_use_bufid2, dmi_ch3_sw_cntl, dmi_ch3_num_bufs, dmi_ch4_use_bufid0, dmi_ch4_use_bufid1, dmi_ch4_use_bufid2, dmi_ch4_sw_cntl, dmi_ch4_num_bufs) \
     ((sel_dmi_active_bufid0 << RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_SHIFT) | \
      (sel_dmi_active_bufid1 << RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_SHIFT) | \
      (sel_dmi_active_bufid2 << RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_SHIFT) | \
      (sel_dmi_vsync_valid << RBBM_DSPLY_SEL_DMI_VSYNC_VALID_SHIFT) | \
      (dmi_ch1_use_bufid0 << RBBM_DSPLY_DMI_CH1_USE_BUFID0_SHIFT) | \
      (dmi_ch1_use_bufid1 << RBBM_DSPLY_DMI_CH1_USE_BUFID1_SHIFT) | \
      (dmi_ch1_use_bufid2 << RBBM_DSPLY_DMI_CH1_USE_BUFID2_SHIFT) | \
      (dmi_ch1_sw_cntl << RBBM_DSPLY_DMI_CH1_SW_CNTL_SHIFT) | \
      (dmi_ch1_num_bufs << RBBM_DSPLY_DMI_CH1_NUM_BUFS_SHIFT) | \
      (dmi_ch2_use_bufid0 << RBBM_DSPLY_DMI_CH2_USE_BUFID0_SHIFT) | \
      (dmi_ch2_use_bufid1 << RBBM_DSPLY_DMI_CH2_USE_BUFID1_SHIFT) | \
      (dmi_ch2_use_bufid2 << RBBM_DSPLY_DMI_CH2_USE_BUFID2_SHIFT) | \
      (dmi_ch2_sw_cntl << RBBM_DSPLY_DMI_CH2_SW_CNTL_SHIFT) | \
      (dmi_ch2_num_bufs << RBBM_DSPLY_DMI_CH2_NUM_BUFS_SHIFT) | \
      (dmi_channel_select << RBBM_DSPLY_DMI_CHANNEL_SELECT_SHIFT) | \
      (dmi_ch3_use_bufid0 << RBBM_DSPLY_DMI_CH3_USE_BUFID0_SHIFT) | \
      (dmi_ch3_use_bufid1 << RBBM_DSPLY_DMI_CH3_USE_BUFID1_SHIFT) | \
      (dmi_ch3_use_bufid2 << RBBM_DSPLY_DMI_CH3_USE_BUFID2_SHIFT) | \
      (dmi_ch3_sw_cntl << RBBM_DSPLY_DMI_CH3_SW_CNTL_SHIFT) | \
      (dmi_ch3_num_bufs << RBBM_DSPLY_DMI_CH3_NUM_BUFS_SHIFT) | \
      (dmi_ch4_use_bufid0 << RBBM_DSPLY_DMI_CH4_USE_BUFID0_SHIFT) | \
      (dmi_ch4_use_bufid1 << RBBM_DSPLY_DMI_CH4_USE_BUFID1_SHIFT) | \
      (dmi_ch4_use_bufid2 << RBBM_DSPLY_DMI_CH4_USE_BUFID2_SHIFT) | \
      (dmi_ch4_sw_cntl << RBBM_DSPLY_DMI_CH4_SW_CNTL_SHIFT) | \
      (dmi_ch4_num_bufs << RBBM_DSPLY_DMI_CH4_NUM_BUFS_SHIFT))

#define RBBM_DSPLY_GET_SEL_DMI_ACTIVE_BUFID0(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_MASK) >> RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_SHIFT)
#define RBBM_DSPLY_GET_SEL_DMI_ACTIVE_BUFID1(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_MASK) >> RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_SHIFT)
#define RBBM_DSPLY_GET_SEL_DMI_ACTIVE_BUFID2(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_MASK) >> RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_SHIFT)
#define RBBM_DSPLY_GET_SEL_DMI_VSYNC_VALID(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_SEL_DMI_VSYNC_VALID_MASK) >> RBBM_DSPLY_SEL_DMI_VSYNC_VALID_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH1_USE_BUFID0(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH1_USE_BUFID0_MASK) >> RBBM_DSPLY_DMI_CH1_USE_BUFID0_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH1_USE_BUFID1(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH1_USE_BUFID1_MASK) >> RBBM_DSPLY_DMI_CH1_USE_BUFID1_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH1_USE_BUFID2(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH1_USE_BUFID2_MASK) >> RBBM_DSPLY_DMI_CH1_USE_BUFID2_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH1_SW_CNTL(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH1_SW_CNTL_MASK) >> RBBM_DSPLY_DMI_CH1_SW_CNTL_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH1_NUM_BUFS(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH1_NUM_BUFS_MASK) >> RBBM_DSPLY_DMI_CH1_NUM_BUFS_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH2_USE_BUFID0(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH2_USE_BUFID0_MASK) >> RBBM_DSPLY_DMI_CH2_USE_BUFID0_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH2_USE_BUFID1(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH2_USE_BUFID1_MASK) >> RBBM_DSPLY_DMI_CH2_USE_BUFID1_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH2_USE_BUFID2(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH2_USE_BUFID2_MASK) >> RBBM_DSPLY_DMI_CH2_USE_BUFID2_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH2_SW_CNTL(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH2_SW_CNTL_MASK) >> RBBM_DSPLY_DMI_CH2_SW_CNTL_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH2_NUM_BUFS(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH2_NUM_BUFS_MASK) >> RBBM_DSPLY_DMI_CH2_NUM_BUFS_SHIFT)
#define RBBM_DSPLY_GET_DMI_CHANNEL_SELECT(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CHANNEL_SELECT_MASK) >> RBBM_DSPLY_DMI_CHANNEL_SELECT_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH3_USE_BUFID0(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH3_USE_BUFID0_MASK) >> RBBM_DSPLY_DMI_CH3_USE_BUFID0_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH3_USE_BUFID1(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH3_USE_BUFID1_MASK) >> RBBM_DSPLY_DMI_CH3_USE_BUFID1_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH3_USE_BUFID2(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH3_USE_BUFID2_MASK) >> RBBM_DSPLY_DMI_CH3_USE_BUFID2_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH3_SW_CNTL(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH3_SW_CNTL_MASK) >> RBBM_DSPLY_DMI_CH3_SW_CNTL_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH3_NUM_BUFS(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH3_NUM_BUFS_MASK) >> RBBM_DSPLY_DMI_CH3_NUM_BUFS_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH4_USE_BUFID0(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH4_USE_BUFID0_MASK) >> RBBM_DSPLY_DMI_CH4_USE_BUFID0_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH4_USE_BUFID1(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH4_USE_BUFID1_MASK) >> RBBM_DSPLY_DMI_CH4_USE_BUFID1_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH4_USE_BUFID2(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH4_USE_BUFID2_MASK) >> RBBM_DSPLY_DMI_CH4_USE_BUFID2_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH4_SW_CNTL(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH4_SW_CNTL_MASK) >> RBBM_DSPLY_DMI_CH4_SW_CNTL_SHIFT)
#define RBBM_DSPLY_GET_DMI_CH4_NUM_BUFS(rbbm_dsply) \
     ((rbbm_dsply & RBBM_DSPLY_DMI_CH4_NUM_BUFS_MASK) >> RBBM_DSPLY_DMI_CH4_NUM_BUFS_SHIFT)

#define RBBM_DSPLY_SET_SEL_DMI_ACTIVE_BUFID0(rbbm_dsply_reg, sel_dmi_active_bufid0) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_MASK) | (sel_dmi_active_bufid0 << RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_SHIFT)
#define RBBM_DSPLY_SET_SEL_DMI_ACTIVE_BUFID1(rbbm_dsply_reg, sel_dmi_active_bufid1) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_MASK) | (sel_dmi_active_bufid1 << RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_SHIFT)
#define RBBM_DSPLY_SET_SEL_DMI_ACTIVE_BUFID2(rbbm_dsply_reg, sel_dmi_active_bufid2) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_MASK) | (sel_dmi_active_bufid2 << RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_SHIFT)
#define RBBM_DSPLY_SET_SEL_DMI_VSYNC_VALID(rbbm_dsply_reg, sel_dmi_vsync_valid) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_SEL_DMI_VSYNC_VALID_MASK) | (sel_dmi_vsync_valid << RBBM_DSPLY_SEL_DMI_VSYNC_VALID_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH1_USE_BUFID0(rbbm_dsply_reg, dmi_ch1_use_bufid0) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH1_USE_BUFID0_MASK) | (dmi_ch1_use_bufid0 << RBBM_DSPLY_DMI_CH1_USE_BUFID0_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH1_USE_BUFID1(rbbm_dsply_reg, dmi_ch1_use_bufid1) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH1_USE_BUFID1_MASK) | (dmi_ch1_use_bufid1 << RBBM_DSPLY_DMI_CH1_USE_BUFID1_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH1_USE_BUFID2(rbbm_dsply_reg, dmi_ch1_use_bufid2) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH1_USE_BUFID2_MASK) | (dmi_ch1_use_bufid2 << RBBM_DSPLY_DMI_CH1_USE_BUFID2_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH1_SW_CNTL(rbbm_dsply_reg, dmi_ch1_sw_cntl) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH1_SW_CNTL_MASK) | (dmi_ch1_sw_cntl << RBBM_DSPLY_DMI_CH1_SW_CNTL_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH1_NUM_BUFS(rbbm_dsply_reg, dmi_ch1_num_bufs) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH1_NUM_BUFS_MASK) | (dmi_ch1_num_bufs << RBBM_DSPLY_DMI_CH1_NUM_BUFS_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH2_USE_BUFID0(rbbm_dsply_reg, dmi_ch2_use_bufid0) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH2_USE_BUFID0_MASK) | (dmi_ch2_use_bufid0 << RBBM_DSPLY_DMI_CH2_USE_BUFID0_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH2_USE_BUFID1(rbbm_dsply_reg, dmi_ch2_use_bufid1) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH2_USE_BUFID1_MASK) | (dmi_ch2_use_bufid1 << RBBM_DSPLY_DMI_CH2_USE_BUFID1_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH2_USE_BUFID2(rbbm_dsply_reg, dmi_ch2_use_bufid2) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH2_USE_BUFID2_MASK) | (dmi_ch2_use_bufid2 << RBBM_DSPLY_DMI_CH2_USE_BUFID2_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH2_SW_CNTL(rbbm_dsply_reg, dmi_ch2_sw_cntl) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH2_SW_CNTL_MASK) | (dmi_ch2_sw_cntl << RBBM_DSPLY_DMI_CH2_SW_CNTL_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH2_NUM_BUFS(rbbm_dsply_reg, dmi_ch2_num_bufs) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH2_NUM_BUFS_MASK) | (dmi_ch2_num_bufs << RBBM_DSPLY_DMI_CH2_NUM_BUFS_SHIFT)
#define RBBM_DSPLY_SET_DMI_CHANNEL_SELECT(rbbm_dsply_reg, dmi_channel_select) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CHANNEL_SELECT_MASK) | (dmi_channel_select << RBBM_DSPLY_DMI_CHANNEL_SELECT_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH3_USE_BUFID0(rbbm_dsply_reg, dmi_ch3_use_bufid0) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH3_USE_BUFID0_MASK) | (dmi_ch3_use_bufid0 << RBBM_DSPLY_DMI_CH3_USE_BUFID0_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH3_USE_BUFID1(rbbm_dsply_reg, dmi_ch3_use_bufid1) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH3_USE_BUFID1_MASK) | (dmi_ch3_use_bufid1 << RBBM_DSPLY_DMI_CH3_USE_BUFID1_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH3_USE_BUFID2(rbbm_dsply_reg, dmi_ch3_use_bufid2) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH3_USE_BUFID2_MASK) | (dmi_ch3_use_bufid2 << RBBM_DSPLY_DMI_CH3_USE_BUFID2_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH3_SW_CNTL(rbbm_dsply_reg, dmi_ch3_sw_cntl) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH3_SW_CNTL_MASK) | (dmi_ch3_sw_cntl << RBBM_DSPLY_DMI_CH3_SW_CNTL_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH3_NUM_BUFS(rbbm_dsply_reg, dmi_ch3_num_bufs) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH3_NUM_BUFS_MASK) | (dmi_ch3_num_bufs << RBBM_DSPLY_DMI_CH3_NUM_BUFS_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH4_USE_BUFID0(rbbm_dsply_reg, dmi_ch4_use_bufid0) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH4_USE_BUFID0_MASK) | (dmi_ch4_use_bufid0 << RBBM_DSPLY_DMI_CH4_USE_BUFID0_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH4_USE_BUFID1(rbbm_dsply_reg, dmi_ch4_use_bufid1) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH4_USE_BUFID1_MASK) | (dmi_ch4_use_bufid1 << RBBM_DSPLY_DMI_CH4_USE_BUFID1_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH4_USE_BUFID2(rbbm_dsply_reg, dmi_ch4_use_bufid2) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH4_USE_BUFID2_MASK) | (dmi_ch4_use_bufid2 << RBBM_DSPLY_DMI_CH4_USE_BUFID2_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH4_SW_CNTL(rbbm_dsply_reg, dmi_ch4_sw_cntl) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH4_SW_CNTL_MASK) | (dmi_ch4_sw_cntl << RBBM_DSPLY_DMI_CH4_SW_CNTL_SHIFT)
#define RBBM_DSPLY_SET_DMI_CH4_NUM_BUFS(rbbm_dsply_reg, dmi_ch4_num_bufs) \
     rbbm_dsply_reg = (rbbm_dsply_reg & ~RBBM_DSPLY_DMI_CH4_NUM_BUFS_MASK) | (dmi_ch4_num_bufs << RBBM_DSPLY_DMI_CH4_NUM_BUFS_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_dsply_t {
          unsigned int sel_dmi_active_bufid0          : RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_SIZE;
          unsigned int sel_dmi_active_bufid1          : RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_SIZE;
          unsigned int sel_dmi_active_bufid2          : RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_SIZE;
          unsigned int sel_dmi_vsync_valid            : RBBM_DSPLY_SEL_DMI_VSYNC_VALID_SIZE;
          unsigned int dmi_ch1_use_bufid0             : RBBM_DSPLY_DMI_CH1_USE_BUFID0_SIZE;
          unsigned int dmi_ch1_use_bufid1             : RBBM_DSPLY_DMI_CH1_USE_BUFID1_SIZE;
          unsigned int dmi_ch1_use_bufid2             : RBBM_DSPLY_DMI_CH1_USE_BUFID2_SIZE;
          unsigned int dmi_ch1_sw_cntl                : RBBM_DSPLY_DMI_CH1_SW_CNTL_SIZE;
          unsigned int dmi_ch1_num_bufs               : RBBM_DSPLY_DMI_CH1_NUM_BUFS_SIZE;
          unsigned int dmi_ch2_use_bufid0             : RBBM_DSPLY_DMI_CH2_USE_BUFID0_SIZE;
          unsigned int dmi_ch2_use_bufid1             : RBBM_DSPLY_DMI_CH2_USE_BUFID1_SIZE;
          unsigned int dmi_ch2_use_bufid2             : RBBM_DSPLY_DMI_CH2_USE_BUFID2_SIZE;
          unsigned int dmi_ch2_sw_cntl                : RBBM_DSPLY_DMI_CH2_SW_CNTL_SIZE;
          unsigned int dmi_ch2_num_bufs               : RBBM_DSPLY_DMI_CH2_NUM_BUFS_SIZE;
          unsigned int dmi_channel_select             : RBBM_DSPLY_DMI_CHANNEL_SELECT_SIZE;
          unsigned int                                : 2;
          unsigned int dmi_ch3_use_bufid0             : RBBM_DSPLY_DMI_CH3_USE_BUFID0_SIZE;
          unsigned int dmi_ch3_use_bufid1             : RBBM_DSPLY_DMI_CH3_USE_BUFID1_SIZE;
          unsigned int dmi_ch3_use_bufid2             : RBBM_DSPLY_DMI_CH3_USE_BUFID2_SIZE;
          unsigned int dmi_ch3_sw_cntl                : RBBM_DSPLY_DMI_CH3_SW_CNTL_SIZE;
          unsigned int dmi_ch3_num_bufs               : RBBM_DSPLY_DMI_CH3_NUM_BUFS_SIZE;
          unsigned int dmi_ch4_use_bufid0             : RBBM_DSPLY_DMI_CH4_USE_BUFID0_SIZE;
          unsigned int dmi_ch4_use_bufid1             : RBBM_DSPLY_DMI_CH4_USE_BUFID1_SIZE;
          unsigned int dmi_ch4_use_bufid2             : RBBM_DSPLY_DMI_CH4_USE_BUFID2_SIZE;
          unsigned int dmi_ch4_sw_cntl                : RBBM_DSPLY_DMI_CH4_SW_CNTL_SIZE;
          unsigned int dmi_ch4_num_bufs               : RBBM_DSPLY_DMI_CH4_NUM_BUFS_SIZE;
     } rbbm_dsply_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_dsply_t {
          unsigned int dmi_ch4_num_bufs               : RBBM_DSPLY_DMI_CH4_NUM_BUFS_SIZE;
          unsigned int dmi_ch4_sw_cntl                : RBBM_DSPLY_DMI_CH4_SW_CNTL_SIZE;
          unsigned int dmi_ch4_use_bufid2             : RBBM_DSPLY_DMI_CH4_USE_BUFID2_SIZE;
          unsigned int dmi_ch4_use_bufid1             : RBBM_DSPLY_DMI_CH4_USE_BUFID1_SIZE;
          unsigned int dmi_ch4_use_bufid0             : RBBM_DSPLY_DMI_CH4_USE_BUFID0_SIZE;
          unsigned int dmi_ch3_num_bufs               : RBBM_DSPLY_DMI_CH3_NUM_BUFS_SIZE;
          unsigned int dmi_ch3_sw_cntl                : RBBM_DSPLY_DMI_CH3_SW_CNTL_SIZE;
          unsigned int dmi_ch3_use_bufid2             : RBBM_DSPLY_DMI_CH3_USE_BUFID2_SIZE;
          unsigned int dmi_ch3_use_bufid1             : RBBM_DSPLY_DMI_CH3_USE_BUFID1_SIZE;
          unsigned int dmi_ch3_use_bufid0             : RBBM_DSPLY_DMI_CH3_USE_BUFID0_SIZE;
          unsigned int                                : 2;
          unsigned int dmi_channel_select             : RBBM_DSPLY_DMI_CHANNEL_SELECT_SIZE;
          unsigned int dmi_ch2_num_bufs               : RBBM_DSPLY_DMI_CH2_NUM_BUFS_SIZE;
          unsigned int dmi_ch2_sw_cntl                : RBBM_DSPLY_DMI_CH2_SW_CNTL_SIZE;
          unsigned int dmi_ch2_use_bufid2             : RBBM_DSPLY_DMI_CH2_USE_BUFID2_SIZE;
          unsigned int dmi_ch2_use_bufid1             : RBBM_DSPLY_DMI_CH2_USE_BUFID1_SIZE;
          unsigned int dmi_ch2_use_bufid0             : RBBM_DSPLY_DMI_CH2_USE_BUFID0_SIZE;
          unsigned int dmi_ch1_num_bufs               : RBBM_DSPLY_DMI_CH1_NUM_BUFS_SIZE;
          unsigned int dmi_ch1_sw_cntl                : RBBM_DSPLY_DMI_CH1_SW_CNTL_SIZE;
          unsigned int dmi_ch1_use_bufid2             : RBBM_DSPLY_DMI_CH1_USE_BUFID2_SIZE;
          unsigned int dmi_ch1_use_bufid1             : RBBM_DSPLY_DMI_CH1_USE_BUFID1_SIZE;
          unsigned int dmi_ch1_use_bufid0             : RBBM_DSPLY_DMI_CH1_USE_BUFID0_SIZE;
          unsigned int sel_dmi_vsync_valid            : RBBM_DSPLY_SEL_DMI_VSYNC_VALID_SIZE;
          unsigned int sel_dmi_active_bufid2          : RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID2_SIZE;
          unsigned int sel_dmi_active_bufid1          : RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID1_SIZE;
          unsigned int sel_dmi_active_bufid0          : RBBM_DSPLY_SEL_DMI_ACTIVE_BUFID0_SIZE;
     } rbbm_dsply_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_dsply_t f;
} rbbm_dsply_u;


/*
 * RBBM_RENDER_LATEST struct
 */

#define RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_SIZE 2
#define RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_SIZE 2
#define RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_SIZE 2
#define RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_SIZE 2

#define RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_SHIFT 0
#define RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_SHIFT 8
#define RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_SHIFT 16
#define RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_SHIFT 24

#define RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_MASK 0x00000003
#define RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_MASK 0x00000300
#define RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_MASK 0x00030000
#define RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_MASK 0x03000000

#define RBBM_RENDER_LATEST_MASK \
     (RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_MASK | \
      RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_MASK | \
      RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_MASK | \
      RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_MASK)

#define RBBM_RENDER_LATEST(dmi_ch1_buffer_id, dmi_ch2_buffer_id, dmi_ch3_buffer_id, dmi_ch4_buffer_id) \
     ((dmi_ch1_buffer_id << RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_SHIFT) | \
      (dmi_ch2_buffer_id << RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_SHIFT) | \
      (dmi_ch3_buffer_id << RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_SHIFT) | \
      (dmi_ch4_buffer_id << RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_SHIFT))

#define RBBM_RENDER_LATEST_GET_DMI_CH1_BUFFER_ID(rbbm_render_latest) \
     ((rbbm_render_latest & RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_MASK) >> RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_SHIFT)
#define RBBM_RENDER_LATEST_GET_DMI_CH2_BUFFER_ID(rbbm_render_latest) \
     ((rbbm_render_latest & RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_MASK) >> RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_SHIFT)
#define RBBM_RENDER_LATEST_GET_DMI_CH3_BUFFER_ID(rbbm_render_latest) \
     ((rbbm_render_latest & RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_MASK) >> RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_SHIFT)
#define RBBM_RENDER_LATEST_GET_DMI_CH4_BUFFER_ID(rbbm_render_latest) \
     ((rbbm_render_latest & RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_MASK) >> RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_SHIFT)

#define RBBM_RENDER_LATEST_SET_DMI_CH1_BUFFER_ID(rbbm_render_latest_reg, dmi_ch1_buffer_id) \
     rbbm_render_latest_reg = (rbbm_render_latest_reg & ~RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_MASK) | (dmi_ch1_buffer_id << RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_SHIFT)
#define RBBM_RENDER_LATEST_SET_DMI_CH2_BUFFER_ID(rbbm_render_latest_reg, dmi_ch2_buffer_id) \
     rbbm_render_latest_reg = (rbbm_render_latest_reg & ~RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_MASK) | (dmi_ch2_buffer_id << RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_SHIFT)
#define RBBM_RENDER_LATEST_SET_DMI_CH3_BUFFER_ID(rbbm_render_latest_reg, dmi_ch3_buffer_id) \
     rbbm_render_latest_reg = (rbbm_render_latest_reg & ~RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_MASK) | (dmi_ch3_buffer_id << RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_SHIFT)
#define RBBM_RENDER_LATEST_SET_DMI_CH4_BUFFER_ID(rbbm_render_latest_reg, dmi_ch4_buffer_id) \
     rbbm_render_latest_reg = (rbbm_render_latest_reg & ~RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_MASK) | (dmi_ch4_buffer_id << RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_render_latest_t {
          unsigned int dmi_ch1_buffer_id              : RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_SIZE;
          unsigned int                                : 6;
          unsigned int dmi_ch2_buffer_id              : RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_SIZE;
          unsigned int                                : 6;
          unsigned int dmi_ch3_buffer_id              : RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_SIZE;
          unsigned int                                : 6;
          unsigned int dmi_ch4_buffer_id              : RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_SIZE;
          unsigned int                                : 6;
     } rbbm_render_latest_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_render_latest_t {
          unsigned int                                : 6;
          unsigned int dmi_ch4_buffer_id              : RBBM_RENDER_LATEST_DMI_CH4_BUFFER_ID_SIZE;
          unsigned int                                : 6;
          unsigned int dmi_ch3_buffer_id              : RBBM_RENDER_LATEST_DMI_CH3_BUFFER_ID_SIZE;
          unsigned int                                : 6;
          unsigned int dmi_ch2_buffer_id              : RBBM_RENDER_LATEST_DMI_CH2_BUFFER_ID_SIZE;
          unsigned int                                : 6;
          unsigned int dmi_ch1_buffer_id              : RBBM_RENDER_LATEST_DMI_CH1_BUFFER_ID_SIZE;
     } rbbm_render_latest_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_render_latest_t f;
} rbbm_render_latest_u;


/*
 * RBBM_RTL_RELEASE struct
 */

#define RBBM_RTL_RELEASE_CHANGELIST_SIZE 32

#define RBBM_RTL_RELEASE_CHANGELIST_SHIFT 0

#define RBBM_RTL_RELEASE_CHANGELIST_MASK 0xffffffff

#define RBBM_RTL_RELEASE_MASK \
     (RBBM_RTL_RELEASE_CHANGELIST_MASK)

#define RBBM_RTL_RELEASE(changelist) \
     ((changelist << RBBM_RTL_RELEASE_CHANGELIST_SHIFT))

#define RBBM_RTL_RELEASE_GET_CHANGELIST(rbbm_rtl_release) \
     ((rbbm_rtl_release & RBBM_RTL_RELEASE_CHANGELIST_MASK) >> RBBM_RTL_RELEASE_CHANGELIST_SHIFT)

#define RBBM_RTL_RELEASE_SET_CHANGELIST(rbbm_rtl_release_reg, changelist) \
     rbbm_rtl_release_reg = (rbbm_rtl_release_reg & ~RBBM_RTL_RELEASE_CHANGELIST_MASK) | (changelist << RBBM_RTL_RELEASE_CHANGELIST_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_rtl_release_t {
          unsigned int changelist                     : RBBM_RTL_RELEASE_CHANGELIST_SIZE;
     } rbbm_rtl_release_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_rtl_release_t {
          unsigned int changelist                     : RBBM_RTL_RELEASE_CHANGELIST_SIZE;
     } rbbm_rtl_release_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_rtl_release_t f;
} rbbm_rtl_release_u;


/*
 * RBBM_PATCH_RELEASE struct
 */

#define RBBM_PATCH_RELEASE_PATCH_REVISION_SIZE 16
#define RBBM_PATCH_RELEASE_PATCH_SELECTION_SIZE 8
#define RBBM_PATCH_RELEASE_CUSTOMER_ID_SIZE 8

#define RBBM_PATCH_RELEASE_PATCH_REVISION_SHIFT 0
#define RBBM_PATCH_RELEASE_PATCH_SELECTION_SHIFT 16
#define RBBM_PATCH_RELEASE_CUSTOMER_ID_SHIFT 24

#define RBBM_PATCH_RELEASE_PATCH_REVISION_MASK 0x0000ffff
#define RBBM_PATCH_RELEASE_PATCH_SELECTION_MASK 0x00ff0000
#define RBBM_PATCH_RELEASE_CUSTOMER_ID_MASK 0xff000000

#define RBBM_PATCH_RELEASE_MASK \
     (RBBM_PATCH_RELEASE_PATCH_REVISION_MASK | \
      RBBM_PATCH_RELEASE_PATCH_SELECTION_MASK | \
      RBBM_PATCH_RELEASE_CUSTOMER_ID_MASK)

#define RBBM_PATCH_RELEASE(patch_revision, patch_selection, customer_id) \
     ((patch_revision << RBBM_PATCH_RELEASE_PATCH_REVISION_SHIFT) | \
      (patch_selection << RBBM_PATCH_RELEASE_PATCH_SELECTION_SHIFT) | \
      (customer_id << RBBM_PATCH_RELEASE_CUSTOMER_ID_SHIFT))

#define RBBM_PATCH_RELEASE_GET_PATCH_REVISION(rbbm_patch_release) \
     ((rbbm_patch_release & RBBM_PATCH_RELEASE_PATCH_REVISION_MASK) >> RBBM_PATCH_RELEASE_PATCH_REVISION_SHIFT)
#define RBBM_PATCH_RELEASE_GET_PATCH_SELECTION(rbbm_patch_release) \
     ((rbbm_patch_release & RBBM_PATCH_RELEASE_PATCH_SELECTION_MASK) >> RBBM_PATCH_RELEASE_PATCH_SELECTION_SHIFT)
#define RBBM_PATCH_RELEASE_GET_CUSTOMER_ID(rbbm_patch_release) \
     ((rbbm_patch_release & RBBM_PATCH_RELEASE_CUSTOMER_ID_MASK) >> RBBM_PATCH_RELEASE_CUSTOMER_ID_SHIFT)

#define RBBM_PATCH_RELEASE_SET_PATCH_REVISION(rbbm_patch_release_reg, patch_revision) \
     rbbm_patch_release_reg = (rbbm_patch_release_reg & ~RBBM_PATCH_RELEASE_PATCH_REVISION_MASK) | (patch_revision << RBBM_PATCH_RELEASE_PATCH_REVISION_SHIFT)
#define RBBM_PATCH_RELEASE_SET_PATCH_SELECTION(rbbm_patch_release_reg, patch_selection) \
     rbbm_patch_release_reg = (rbbm_patch_release_reg & ~RBBM_PATCH_RELEASE_PATCH_SELECTION_MASK) | (patch_selection << RBBM_PATCH_RELEASE_PATCH_SELECTION_SHIFT)
#define RBBM_PATCH_RELEASE_SET_CUSTOMER_ID(rbbm_patch_release_reg, customer_id) \
     rbbm_patch_release_reg = (rbbm_patch_release_reg & ~RBBM_PATCH_RELEASE_CUSTOMER_ID_MASK) | (customer_id << RBBM_PATCH_RELEASE_CUSTOMER_ID_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_patch_release_t {
          unsigned int patch_revision                 : RBBM_PATCH_RELEASE_PATCH_REVISION_SIZE;
          unsigned int patch_selection                : RBBM_PATCH_RELEASE_PATCH_SELECTION_SIZE;
          unsigned int customer_id                    : RBBM_PATCH_RELEASE_CUSTOMER_ID_SIZE;
     } rbbm_patch_release_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_patch_release_t {
          unsigned int customer_id                    : RBBM_PATCH_RELEASE_CUSTOMER_ID_SIZE;
          unsigned int patch_selection                : RBBM_PATCH_RELEASE_PATCH_SELECTION_SIZE;
          unsigned int patch_revision                 : RBBM_PATCH_RELEASE_PATCH_REVISION_SIZE;
     } rbbm_patch_release_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_patch_release_t f;
} rbbm_patch_release_u;


/*
 * RBBM_AUXILIARY_CONFIG struct
 */

#define RBBM_AUXILIARY_CONFIG_RESERVED_SIZE 32

#define RBBM_AUXILIARY_CONFIG_RESERVED_SHIFT 0

#define RBBM_AUXILIARY_CONFIG_RESERVED_MASK 0xffffffff

#define RBBM_AUXILIARY_CONFIG_MASK \
     (RBBM_AUXILIARY_CONFIG_RESERVED_MASK)

#define RBBM_AUXILIARY_CONFIG(reserved) \
     ((reserved << RBBM_AUXILIARY_CONFIG_RESERVED_SHIFT))

#define RBBM_AUXILIARY_CONFIG_GET_RESERVED(rbbm_auxiliary_config) \
     ((rbbm_auxiliary_config & RBBM_AUXILIARY_CONFIG_RESERVED_MASK) >> RBBM_AUXILIARY_CONFIG_RESERVED_SHIFT)

#define RBBM_AUXILIARY_CONFIG_SET_RESERVED(rbbm_auxiliary_config_reg, reserved) \
     rbbm_auxiliary_config_reg = (rbbm_auxiliary_config_reg & ~RBBM_AUXILIARY_CONFIG_RESERVED_MASK) | (reserved << RBBM_AUXILIARY_CONFIG_RESERVED_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_auxiliary_config_t {
          unsigned int reserved                       : RBBM_AUXILIARY_CONFIG_RESERVED_SIZE;
     } rbbm_auxiliary_config_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_auxiliary_config_t {
          unsigned int reserved                       : RBBM_AUXILIARY_CONFIG_RESERVED_SIZE;
     } rbbm_auxiliary_config_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_auxiliary_config_t f;
} rbbm_auxiliary_config_u;


/*
 * RBBM_PERIPHID0 struct
 */

#define RBBM_PERIPHID0_PARTNUMBER0_SIZE 8

#define RBBM_PERIPHID0_PARTNUMBER0_SHIFT 0

#define RBBM_PERIPHID0_PARTNUMBER0_MASK 0x000000ff

#define RBBM_PERIPHID0_MASK \
     (RBBM_PERIPHID0_PARTNUMBER0_MASK)

#define RBBM_PERIPHID0(partnumber0) \
     ((partnumber0 << RBBM_PERIPHID0_PARTNUMBER0_SHIFT))

#define RBBM_PERIPHID0_GET_PARTNUMBER0(rbbm_periphid0) \
     ((rbbm_periphid0 & RBBM_PERIPHID0_PARTNUMBER0_MASK) >> RBBM_PERIPHID0_PARTNUMBER0_SHIFT)

#define RBBM_PERIPHID0_SET_PARTNUMBER0(rbbm_periphid0_reg, partnumber0) \
     rbbm_periphid0_reg = (rbbm_periphid0_reg & ~RBBM_PERIPHID0_PARTNUMBER0_MASK) | (partnumber0 << RBBM_PERIPHID0_PARTNUMBER0_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_periphid0_t {
          unsigned int partnumber0                    : RBBM_PERIPHID0_PARTNUMBER0_SIZE;
          unsigned int                                : 24;
     } rbbm_periphid0_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_periphid0_t {
          unsigned int                                : 24;
          unsigned int partnumber0                    : RBBM_PERIPHID0_PARTNUMBER0_SIZE;
     } rbbm_periphid0_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_periphid0_t f;
} rbbm_periphid0_u;


/*
 * RBBM_PERIPHID1 struct
 */

#define RBBM_PERIPHID1_PARTNUMBER1_SIZE 4
#define RBBM_PERIPHID1_DESIGNER0_SIZE  4

#define RBBM_PERIPHID1_PARTNUMBER1_SHIFT 0
#define RBBM_PERIPHID1_DESIGNER0_SHIFT 4

#define RBBM_PERIPHID1_PARTNUMBER1_MASK 0x0000000f
#define RBBM_PERIPHID1_DESIGNER0_MASK  0x000000f0

#define RBBM_PERIPHID1_MASK \
     (RBBM_PERIPHID1_PARTNUMBER1_MASK | \
      RBBM_PERIPHID1_DESIGNER0_MASK)

#define RBBM_PERIPHID1(partnumber1, designer0) \
     ((partnumber1 << RBBM_PERIPHID1_PARTNUMBER1_SHIFT) | \
      (designer0 << RBBM_PERIPHID1_DESIGNER0_SHIFT))

#define RBBM_PERIPHID1_GET_PARTNUMBER1(rbbm_periphid1) \
     ((rbbm_periphid1 & RBBM_PERIPHID1_PARTNUMBER1_MASK) >> RBBM_PERIPHID1_PARTNUMBER1_SHIFT)
#define RBBM_PERIPHID1_GET_DESIGNER0(rbbm_periphid1) \
     ((rbbm_periphid1 & RBBM_PERIPHID1_DESIGNER0_MASK) >> RBBM_PERIPHID1_DESIGNER0_SHIFT)

#define RBBM_PERIPHID1_SET_PARTNUMBER1(rbbm_periphid1_reg, partnumber1) \
     rbbm_periphid1_reg = (rbbm_periphid1_reg & ~RBBM_PERIPHID1_PARTNUMBER1_MASK) | (partnumber1 << RBBM_PERIPHID1_PARTNUMBER1_SHIFT)
#define RBBM_PERIPHID1_SET_DESIGNER0(rbbm_periphid1_reg, designer0) \
     rbbm_periphid1_reg = (rbbm_periphid1_reg & ~RBBM_PERIPHID1_DESIGNER0_MASK) | (designer0 << RBBM_PERIPHID1_DESIGNER0_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_periphid1_t {
          unsigned int partnumber1                    : RBBM_PERIPHID1_PARTNUMBER1_SIZE;
          unsigned int designer0                      : RBBM_PERIPHID1_DESIGNER0_SIZE;
          unsigned int                                : 24;
     } rbbm_periphid1_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_periphid1_t {
          unsigned int                                : 24;
          unsigned int designer0                      : RBBM_PERIPHID1_DESIGNER0_SIZE;
          unsigned int partnumber1                    : RBBM_PERIPHID1_PARTNUMBER1_SIZE;
     } rbbm_periphid1_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_periphid1_t f;
} rbbm_periphid1_u;


/*
 * RBBM_PERIPHID2 struct
 */

#define RBBM_PERIPHID2_DESIGNER1_SIZE  4
#define RBBM_PERIPHID2_REVISION_SIZE   4

#define RBBM_PERIPHID2_DESIGNER1_SHIFT 0
#define RBBM_PERIPHID2_REVISION_SHIFT  4

#define RBBM_PERIPHID2_DESIGNER1_MASK  0x0000000f
#define RBBM_PERIPHID2_REVISION_MASK   0x000000f0

#define RBBM_PERIPHID2_MASK \
     (RBBM_PERIPHID2_DESIGNER1_MASK | \
      RBBM_PERIPHID2_REVISION_MASK)

#define RBBM_PERIPHID2(designer1, revision) \
     ((designer1 << RBBM_PERIPHID2_DESIGNER1_SHIFT) | \
      (revision << RBBM_PERIPHID2_REVISION_SHIFT))

#define RBBM_PERIPHID2_GET_DESIGNER1(rbbm_periphid2) \
     ((rbbm_periphid2 & RBBM_PERIPHID2_DESIGNER1_MASK) >> RBBM_PERIPHID2_DESIGNER1_SHIFT)
#define RBBM_PERIPHID2_GET_REVISION(rbbm_periphid2) \
     ((rbbm_periphid2 & RBBM_PERIPHID2_REVISION_MASK) >> RBBM_PERIPHID2_REVISION_SHIFT)

#define RBBM_PERIPHID2_SET_DESIGNER1(rbbm_periphid2_reg, designer1) \
     rbbm_periphid2_reg = (rbbm_periphid2_reg & ~RBBM_PERIPHID2_DESIGNER1_MASK) | (designer1 << RBBM_PERIPHID2_DESIGNER1_SHIFT)
#define RBBM_PERIPHID2_SET_REVISION(rbbm_periphid2_reg, revision) \
     rbbm_periphid2_reg = (rbbm_periphid2_reg & ~RBBM_PERIPHID2_REVISION_MASK) | (revision << RBBM_PERIPHID2_REVISION_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_periphid2_t {
          unsigned int designer1                      : RBBM_PERIPHID2_DESIGNER1_SIZE;
          unsigned int revision                       : RBBM_PERIPHID2_REVISION_SIZE;
          unsigned int                                : 24;
     } rbbm_periphid2_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_periphid2_t {
          unsigned int                                : 24;
          unsigned int revision                       : RBBM_PERIPHID2_REVISION_SIZE;
          unsigned int designer1                      : RBBM_PERIPHID2_DESIGNER1_SIZE;
     } rbbm_periphid2_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_periphid2_t f;
} rbbm_periphid2_u;


/*
 * RBBM_PERIPHID3 struct
 */

#define RBBM_PERIPHID3_RBBM_HOST_INTERFACE_SIZE 2
#define RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_SIZE 2
#define RBBM_PERIPHID3_MH_INTERFACE_SIZE 2
#define RBBM_PERIPHID3_CONTINUATION_SIZE 1

#define RBBM_PERIPHID3_RBBM_HOST_INTERFACE_SHIFT 0
#define RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_SHIFT 2
#define RBBM_PERIPHID3_MH_INTERFACE_SHIFT 4
#define RBBM_PERIPHID3_CONTINUATION_SHIFT 7

#define RBBM_PERIPHID3_RBBM_HOST_INTERFACE_MASK 0x00000003
#define RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_MASK 0x0000000c
#define RBBM_PERIPHID3_MH_INTERFACE_MASK 0x00000030
#define RBBM_PERIPHID3_CONTINUATION_MASK 0x00000080

#define RBBM_PERIPHID3_MASK \
     (RBBM_PERIPHID3_RBBM_HOST_INTERFACE_MASK | \
      RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_MASK | \
      RBBM_PERIPHID3_MH_INTERFACE_MASK | \
      RBBM_PERIPHID3_CONTINUATION_MASK)

#define RBBM_PERIPHID3(rbbm_host_interface, garb_slave_interface, mh_interface, continuation) \
     ((rbbm_host_interface << RBBM_PERIPHID3_RBBM_HOST_INTERFACE_SHIFT) | \
      (garb_slave_interface << RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_SHIFT) | \
      (mh_interface << RBBM_PERIPHID3_MH_INTERFACE_SHIFT) | \
      (continuation << RBBM_PERIPHID3_CONTINUATION_SHIFT))

#define RBBM_PERIPHID3_GET_RBBM_HOST_INTERFACE(rbbm_periphid3) \
     ((rbbm_periphid3 & RBBM_PERIPHID3_RBBM_HOST_INTERFACE_MASK) >> RBBM_PERIPHID3_RBBM_HOST_INTERFACE_SHIFT)
#define RBBM_PERIPHID3_GET_GARB_SLAVE_INTERFACE(rbbm_periphid3) \
     ((rbbm_periphid3 & RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_MASK) >> RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_SHIFT)
#define RBBM_PERIPHID3_GET_MH_INTERFACE(rbbm_periphid3) \
     ((rbbm_periphid3 & RBBM_PERIPHID3_MH_INTERFACE_MASK) >> RBBM_PERIPHID3_MH_INTERFACE_SHIFT)
#define RBBM_PERIPHID3_GET_CONTINUATION(rbbm_periphid3) \
     ((rbbm_periphid3 & RBBM_PERIPHID3_CONTINUATION_MASK) >> RBBM_PERIPHID3_CONTINUATION_SHIFT)

#define RBBM_PERIPHID3_SET_RBBM_HOST_INTERFACE(rbbm_periphid3_reg, rbbm_host_interface) \
     rbbm_periphid3_reg = (rbbm_periphid3_reg & ~RBBM_PERIPHID3_RBBM_HOST_INTERFACE_MASK) | (rbbm_host_interface << RBBM_PERIPHID3_RBBM_HOST_INTERFACE_SHIFT)
#define RBBM_PERIPHID3_SET_GARB_SLAVE_INTERFACE(rbbm_periphid3_reg, garb_slave_interface) \
     rbbm_periphid3_reg = (rbbm_periphid3_reg & ~RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_MASK) | (garb_slave_interface << RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_SHIFT)
#define RBBM_PERIPHID3_SET_MH_INTERFACE(rbbm_periphid3_reg, mh_interface) \
     rbbm_periphid3_reg = (rbbm_periphid3_reg & ~RBBM_PERIPHID3_MH_INTERFACE_MASK) | (mh_interface << RBBM_PERIPHID3_MH_INTERFACE_SHIFT)
#define RBBM_PERIPHID3_SET_CONTINUATION(rbbm_periphid3_reg, continuation) \
     rbbm_periphid3_reg = (rbbm_periphid3_reg & ~RBBM_PERIPHID3_CONTINUATION_MASK) | (continuation << RBBM_PERIPHID3_CONTINUATION_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_periphid3_t {
          unsigned int rbbm_host_interface            : RBBM_PERIPHID3_RBBM_HOST_INTERFACE_SIZE;
          unsigned int garb_slave_interface           : RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_SIZE;
          unsigned int mh_interface                   : RBBM_PERIPHID3_MH_INTERFACE_SIZE;
          unsigned int                                : 1;
          unsigned int continuation                   : RBBM_PERIPHID3_CONTINUATION_SIZE;
          unsigned int                                : 24;
     } rbbm_periphid3_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_periphid3_t {
          unsigned int                                : 24;
          unsigned int continuation                   : RBBM_PERIPHID3_CONTINUATION_SIZE;
          unsigned int                                : 1;
          unsigned int mh_interface                   : RBBM_PERIPHID3_MH_INTERFACE_SIZE;
          unsigned int garb_slave_interface           : RBBM_PERIPHID3_GARB_SLAVE_INTERFACE_SIZE;
          unsigned int rbbm_host_interface            : RBBM_PERIPHID3_RBBM_HOST_INTERFACE_SIZE;
     } rbbm_periphid3_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_periphid3_t f;
} rbbm_periphid3_u;


/*
 * RBBM_CNTL struct
 */

#define RBBM_CNTL_READ_TIMEOUT_SIZE    8
#define RBBM_CNTL_REGCLK_DEASSERT_TIME_SIZE 9

#define RBBM_CNTL_READ_TIMEOUT_SHIFT   0
#define RBBM_CNTL_REGCLK_DEASSERT_TIME_SHIFT 8

#define RBBM_CNTL_READ_TIMEOUT_MASK    0x000000ff
#define RBBM_CNTL_REGCLK_DEASSERT_TIME_MASK 0x0001ff00

#define RBBM_CNTL_MASK \
     (RBBM_CNTL_READ_TIMEOUT_MASK | \
      RBBM_CNTL_REGCLK_DEASSERT_TIME_MASK)

#define RBBM_CNTL(read_timeout, regclk_deassert_time) \
     ((read_timeout << RBBM_CNTL_READ_TIMEOUT_SHIFT) | \
      (regclk_deassert_time << RBBM_CNTL_REGCLK_DEASSERT_TIME_SHIFT))

#define RBBM_CNTL_GET_READ_TIMEOUT(rbbm_cntl) \
     ((rbbm_cntl & RBBM_CNTL_READ_TIMEOUT_MASK) >> RBBM_CNTL_READ_TIMEOUT_SHIFT)
#define RBBM_CNTL_GET_REGCLK_DEASSERT_TIME(rbbm_cntl) \
     ((rbbm_cntl & RBBM_CNTL_REGCLK_DEASSERT_TIME_MASK) >> RBBM_CNTL_REGCLK_DEASSERT_TIME_SHIFT)

#define RBBM_CNTL_SET_READ_TIMEOUT(rbbm_cntl_reg, read_timeout) \
     rbbm_cntl_reg = (rbbm_cntl_reg & ~RBBM_CNTL_READ_TIMEOUT_MASK) | (read_timeout << RBBM_CNTL_READ_TIMEOUT_SHIFT)
#define RBBM_CNTL_SET_REGCLK_DEASSERT_TIME(rbbm_cntl_reg, regclk_deassert_time) \
     rbbm_cntl_reg = (rbbm_cntl_reg & ~RBBM_CNTL_REGCLK_DEASSERT_TIME_MASK) | (regclk_deassert_time << RBBM_CNTL_REGCLK_DEASSERT_TIME_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_cntl_t {
          unsigned int read_timeout                   : RBBM_CNTL_READ_TIMEOUT_SIZE;
          unsigned int regclk_deassert_time           : RBBM_CNTL_REGCLK_DEASSERT_TIME_SIZE;
          unsigned int                                : 15;
     } rbbm_cntl_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_cntl_t {
          unsigned int                                : 15;
          unsigned int regclk_deassert_time           : RBBM_CNTL_REGCLK_DEASSERT_TIME_SIZE;
          unsigned int read_timeout                   : RBBM_CNTL_READ_TIMEOUT_SIZE;
     } rbbm_cntl_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_cntl_t f;
} rbbm_cntl_u;


/*
 * RBBM_SKEW_CNTL struct
 */

#define RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_SIZE 5
#define RBBM_SKEW_CNTL_SKEW_COUNT_SIZE 5

#define RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_SHIFT 0
#define RBBM_SKEW_CNTL_SKEW_COUNT_SHIFT 5

#define RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_MASK 0x0000001f
#define RBBM_SKEW_CNTL_SKEW_COUNT_MASK 0x000003e0

#define RBBM_SKEW_CNTL_MASK \
     (RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_MASK | \
      RBBM_SKEW_CNTL_SKEW_COUNT_MASK)

#define RBBM_SKEW_CNTL(skew_top_threshold, skew_count) \
     ((skew_top_threshold << RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_SHIFT) | \
      (skew_count << RBBM_SKEW_CNTL_SKEW_COUNT_SHIFT))

#define RBBM_SKEW_CNTL_GET_SKEW_TOP_THRESHOLD(rbbm_skew_cntl) \
     ((rbbm_skew_cntl & RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_MASK) >> RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_SHIFT)
#define RBBM_SKEW_CNTL_GET_SKEW_COUNT(rbbm_skew_cntl) \
     ((rbbm_skew_cntl & RBBM_SKEW_CNTL_SKEW_COUNT_MASK) >> RBBM_SKEW_CNTL_SKEW_COUNT_SHIFT)

#define RBBM_SKEW_CNTL_SET_SKEW_TOP_THRESHOLD(rbbm_skew_cntl_reg, skew_top_threshold) \
     rbbm_skew_cntl_reg = (rbbm_skew_cntl_reg & ~RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_MASK) | (skew_top_threshold << RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_SHIFT)
#define RBBM_SKEW_CNTL_SET_SKEW_COUNT(rbbm_skew_cntl_reg, skew_count) \
     rbbm_skew_cntl_reg = (rbbm_skew_cntl_reg & ~RBBM_SKEW_CNTL_SKEW_COUNT_MASK) | (skew_count << RBBM_SKEW_CNTL_SKEW_COUNT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_skew_cntl_t {
          unsigned int skew_top_threshold             : RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_SIZE;
          unsigned int skew_count                     : RBBM_SKEW_CNTL_SKEW_COUNT_SIZE;
          unsigned int                                : 22;
     } rbbm_skew_cntl_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_skew_cntl_t {
          unsigned int                                : 22;
          unsigned int skew_count                     : RBBM_SKEW_CNTL_SKEW_COUNT_SIZE;
          unsigned int skew_top_threshold             : RBBM_SKEW_CNTL_SKEW_TOP_THRESHOLD_SIZE;
     } rbbm_skew_cntl_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_skew_cntl_t f;
} rbbm_skew_cntl_u;


/*
 * RBBM_SOFT_RESET struct
 */

#define RBBM_SOFT_RESET_SOFT_RESET_CP_SIZE 1
#define RBBM_SOFT_RESET_SOFT_RESET_PA_SIZE 1
#define RBBM_SOFT_RESET_SOFT_RESET_MH_SIZE 1
#define RBBM_SOFT_RESET_SOFT_RESET_BC_SIZE 1
#define RBBM_SOFT_RESET_SOFT_RESET_SQ_SIZE 1
#define RBBM_SOFT_RESET_SOFT_RESET_SX_SIZE 1
#define RBBM_SOFT_RESET_SOFT_RESET_CIB_SIZE 1
#define RBBM_SOFT_RESET_SOFT_RESET_SC_SIZE 1
#define RBBM_SOFT_RESET_SOFT_RESET_VGT_SIZE 1

#define RBBM_SOFT_RESET_SOFT_RESET_CP_SHIFT 0
#define RBBM_SOFT_RESET_SOFT_RESET_PA_SHIFT 2
#define RBBM_SOFT_RESET_SOFT_RESET_MH_SHIFT 3
#define RBBM_SOFT_RESET_SOFT_RESET_BC_SHIFT 4
#define RBBM_SOFT_RESET_SOFT_RESET_SQ_SHIFT 5
#define RBBM_SOFT_RESET_SOFT_RESET_SX_SHIFT 6
#define RBBM_SOFT_RESET_SOFT_RESET_CIB_SHIFT 12
#define RBBM_SOFT_RESET_SOFT_RESET_SC_SHIFT 15
#define RBBM_SOFT_RESET_SOFT_RESET_VGT_SHIFT 16

#define RBBM_SOFT_RESET_SOFT_RESET_CP_MASK 0x00000001
#define RBBM_SOFT_RESET_SOFT_RESET_PA_MASK 0x00000004
#define RBBM_SOFT_RESET_SOFT_RESET_MH_MASK 0x00000008
#define RBBM_SOFT_RESET_SOFT_RESET_BC_MASK 0x00000010
#define RBBM_SOFT_RESET_SOFT_RESET_SQ_MASK 0x00000020
#define RBBM_SOFT_RESET_SOFT_RESET_SX_MASK 0x00000040
#define RBBM_SOFT_RESET_SOFT_RESET_CIB_MASK 0x00001000
#define RBBM_SOFT_RESET_SOFT_RESET_SC_MASK 0x00008000
#define RBBM_SOFT_RESET_SOFT_RESET_VGT_MASK 0x00010000

#define RBBM_SOFT_RESET_MASK \
     (RBBM_SOFT_RESET_SOFT_RESET_CP_MASK | \
      RBBM_SOFT_RESET_SOFT_RESET_PA_MASK | \
      RBBM_SOFT_RESET_SOFT_RESET_MH_MASK | \
      RBBM_SOFT_RESET_SOFT_RESET_BC_MASK | \
      RBBM_SOFT_RESET_SOFT_RESET_SQ_MASK | \
      RBBM_SOFT_RESET_SOFT_RESET_SX_MASK | \
      RBBM_SOFT_RESET_SOFT_RESET_CIB_MASK | \
      RBBM_SOFT_RESET_SOFT_RESET_SC_MASK | \
      RBBM_SOFT_RESET_SOFT_RESET_VGT_MASK)

#define RBBM_SOFT_RESET(soft_reset_cp, soft_reset_pa, soft_reset_mh, soft_reset_bc, soft_reset_sq, soft_reset_sx, soft_reset_cib, soft_reset_sc, soft_reset_vgt) \
     ((soft_reset_cp << RBBM_SOFT_RESET_SOFT_RESET_CP_SHIFT) | \
      (soft_reset_pa << RBBM_SOFT_RESET_SOFT_RESET_PA_SHIFT) | \
      (soft_reset_mh << RBBM_SOFT_RESET_SOFT_RESET_MH_SHIFT) | \
      (soft_reset_bc << RBBM_SOFT_RESET_SOFT_RESET_BC_SHIFT) | \
      (soft_reset_sq << RBBM_SOFT_RESET_SOFT_RESET_SQ_SHIFT) | \
      (soft_reset_sx << RBBM_SOFT_RESET_SOFT_RESET_SX_SHIFT) | \
      (soft_reset_cib << RBBM_SOFT_RESET_SOFT_RESET_CIB_SHIFT) | \
      (soft_reset_sc << RBBM_SOFT_RESET_SOFT_RESET_SC_SHIFT) | \
      (soft_reset_vgt << RBBM_SOFT_RESET_SOFT_RESET_VGT_SHIFT))

#define RBBM_SOFT_RESET_GET_SOFT_RESET_CP(rbbm_soft_reset) \
     ((rbbm_soft_reset & RBBM_SOFT_RESET_SOFT_RESET_CP_MASK) >> RBBM_SOFT_RESET_SOFT_RESET_CP_SHIFT)
#define RBBM_SOFT_RESET_GET_SOFT_RESET_PA(rbbm_soft_reset) \
     ((rbbm_soft_reset & RBBM_SOFT_RESET_SOFT_RESET_PA_MASK) >> RBBM_SOFT_RESET_SOFT_RESET_PA_SHIFT)
#define RBBM_SOFT_RESET_GET_SOFT_RESET_MH(rbbm_soft_reset) \
     ((rbbm_soft_reset & RBBM_SOFT_RESET_SOFT_RESET_MH_MASK) >> RBBM_SOFT_RESET_SOFT_RESET_MH_SHIFT)
#define RBBM_SOFT_RESET_GET_SOFT_RESET_BC(rbbm_soft_reset) \
     ((rbbm_soft_reset & RBBM_SOFT_RESET_SOFT_RESET_BC_MASK) >> RBBM_SOFT_RESET_SOFT_RESET_BC_SHIFT)
#define RBBM_SOFT_RESET_GET_SOFT_RESET_SQ(rbbm_soft_reset) \
     ((rbbm_soft_reset & RBBM_SOFT_RESET_SOFT_RESET_SQ_MASK) >> RBBM_SOFT_RESET_SOFT_RESET_SQ_SHIFT)
#define RBBM_SOFT_RESET_GET_SOFT_RESET_SX(rbbm_soft_reset) \
     ((rbbm_soft_reset & RBBM_SOFT_RESET_SOFT_RESET_SX_MASK) >> RBBM_SOFT_RESET_SOFT_RESET_SX_SHIFT)
#define RBBM_SOFT_RESET_GET_SOFT_RESET_CIB(rbbm_soft_reset) \
     ((rbbm_soft_reset & RBBM_SOFT_RESET_SOFT_RESET_CIB_MASK) >> RBBM_SOFT_RESET_SOFT_RESET_CIB_SHIFT)
#define RBBM_SOFT_RESET_GET_SOFT_RESET_SC(rbbm_soft_reset) \
     ((rbbm_soft_reset & RBBM_SOFT_RESET_SOFT_RESET_SC_MASK) >> RBBM_SOFT_RESET_SOFT_RESET_SC_SHIFT)
#define RBBM_SOFT_RESET_GET_SOFT_RESET_VGT(rbbm_soft_reset) \
     ((rbbm_soft_reset & RBBM_SOFT_RESET_SOFT_RESET_VGT_MASK) >> RBBM_SOFT_RESET_SOFT_RESET_VGT_SHIFT)

#define RBBM_SOFT_RESET_SET_SOFT_RESET_CP(rbbm_soft_reset_reg, soft_reset_cp) \
     rbbm_soft_reset_reg = (rbbm_soft_reset_reg & ~RBBM_SOFT_RESET_SOFT_RESET_CP_MASK) | (soft_reset_cp << RBBM_SOFT_RESET_SOFT_RESET_CP_SHIFT)
#define RBBM_SOFT_RESET_SET_SOFT_RESET_PA(rbbm_soft_reset_reg, soft_reset_pa) \
     rbbm_soft_reset_reg = (rbbm_soft_reset_reg & ~RBBM_SOFT_RESET_SOFT_RESET_PA_MASK) | (soft_reset_pa << RBBM_SOFT_RESET_SOFT_RESET_PA_SHIFT)
#define RBBM_SOFT_RESET_SET_SOFT_RESET_MH(rbbm_soft_reset_reg, soft_reset_mh) \
     rbbm_soft_reset_reg = (rbbm_soft_reset_reg & ~RBBM_SOFT_RESET_SOFT_RESET_MH_MASK) | (soft_reset_mh << RBBM_SOFT_RESET_SOFT_RESET_MH_SHIFT)
#define RBBM_SOFT_RESET_SET_SOFT_RESET_BC(rbbm_soft_reset_reg, soft_reset_bc) \
     rbbm_soft_reset_reg = (rbbm_soft_reset_reg & ~RBBM_SOFT_RESET_SOFT_RESET_BC_MASK) | (soft_reset_bc << RBBM_SOFT_RESET_SOFT_RESET_BC_SHIFT)
#define RBBM_SOFT_RESET_SET_SOFT_RESET_SQ(rbbm_soft_reset_reg, soft_reset_sq) \
     rbbm_soft_reset_reg = (rbbm_soft_reset_reg & ~RBBM_SOFT_RESET_SOFT_RESET_SQ_MASK) | (soft_reset_sq << RBBM_SOFT_RESET_SOFT_RESET_SQ_SHIFT)
#define RBBM_SOFT_RESET_SET_SOFT_RESET_SX(rbbm_soft_reset_reg, soft_reset_sx) \
     rbbm_soft_reset_reg = (rbbm_soft_reset_reg & ~RBBM_SOFT_RESET_SOFT_RESET_SX_MASK) | (soft_reset_sx << RBBM_SOFT_RESET_SOFT_RESET_SX_SHIFT)
#define RBBM_SOFT_RESET_SET_SOFT_RESET_CIB(rbbm_soft_reset_reg, soft_reset_cib) \
     rbbm_soft_reset_reg = (rbbm_soft_reset_reg & ~RBBM_SOFT_RESET_SOFT_RESET_CIB_MASK) | (soft_reset_cib << RBBM_SOFT_RESET_SOFT_RESET_CIB_SHIFT)
#define RBBM_SOFT_RESET_SET_SOFT_RESET_SC(rbbm_soft_reset_reg, soft_reset_sc) \
     rbbm_soft_reset_reg = (rbbm_soft_reset_reg & ~RBBM_SOFT_RESET_SOFT_RESET_SC_MASK) | (soft_reset_sc << RBBM_SOFT_RESET_SOFT_RESET_SC_SHIFT)
#define RBBM_SOFT_RESET_SET_SOFT_RESET_VGT(rbbm_soft_reset_reg, soft_reset_vgt) \
     rbbm_soft_reset_reg = (rbbm_soft_reset_reg & ~RBBM_SOFT_RESET_SOFT_RESET_VGT_MASK) | (soft_reset_vgt << RBBM_SOFT_RESET_SOFT_RESET_VGT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_soft_reset_t {
          unsigned int soft_reset_cp                  : RBBM_SOFT_RESET_SOFT_RESET_CP_SIZE;
          unsigned int                                : 1;
          unsigned int soft_reset_pa                  : RBBM_SOFT_RESET_SOFT_RESET_PA_SIZE;
          unsigned int soft_reset_mh                  : RBBM_SOFT_RESET_SOFT_RESET_MH_SIZE;
          unsigned int soft_reset_bc                  : RBBM_SOFT_RESET_SOFT_RESET_BC_SIZE;
          unsigned int soft_reset_sq                  : RBBM_SOFT_RESET_SOFT_RESET_SQ_SIZE;
          unsigned int soft_reset_sx                  : RBBM_SOFT_RESET_SOFT_RESET_SX_SIZE;
          unsigned int                                : 5;
          unsigned int soft_reset_cib                 : RBBM_SOFT_RESET_SOFT_RESET_CIB_SIZE;
          unsigned int                                : 2;
          unsigned int soft_reset_sc                  : RBBM_SOFT_RESET_SOFT_RESET_SC_SIZE;
          unsigned int soft_reset_vgt                 : RBBM_SOFT_RESET_SOFT_RESET_VGT_SIZE;
          unsigned int                                : 15;
     } rbbm_soft_reset_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_soft_reset_t {
          unsigned int                                : 15;
          unsigned int soft_reset_vgt                 : RBBM_SOFT_RESET_SOFT_RESET_VGT_SIZE;
          unsigned int soft_reset_sc                  : RBBM_SOFT_RESET_SOFT_RESET_SC_SIZE;
          unsigned int                                : 2;
          unsigned int soft_reset_cib                 : RBBM_SOFT_RESET_SOFT_RESET_CIB_SIZE;
          unsigned int                                : 5;
          unsigned int soft_reset_sx                  : RBBM_SOFT_RESET_SOFT_RESET_SX_SIZE;
          unsigned int soft_reset_sq                  : RBBM_SOFT_RESET_SOFT_RESET_SQ_SIZE;
          unsigned int soft_reset_bc                  : RBBM_SOFT_RESET_SOFT_RESET_BC_SIZE;
          unsigned int soft_reset_mh                  : RBBM_SOFT_RESET_SOFT_RESET_MH_SIZE;
          unsigned int soft_reset_pa                  : RBBM_SOFT_RESET_SOFT_RESET_PA_SIZE;
          unsigned int                                : 1;
          unsigned int soft_reset_cp                  : RBBM_SOFT_RESET_SOFT_RESET_CP_SIZE;
     } rbbm_soft_reset_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_soft_reset_t f;
} rbbm_soft_reset_u;


/*
 * RBBM_PM_OVERRIDE1 struct
 */

#define RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_SIZE 1

#define RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_SHIFT 0
#define RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_SHIFT 1
#define RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_SHIFT 2
#define RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_SHIFT 3
#define RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_SHIFT 4
#define RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_SHIFT 5
#define RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_SHIFT 6
#define RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_SHIFT 7
#define RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_SHIFT 8
#define RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_SHIFT 9
#define RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_SHIFT 10
#define RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_SHIFT 11
#define RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_SHIFT 12
#define RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_SHIFT 13
#define RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_SHIFT 14
#define RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_SHIFT 15
#define RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_SHIFT 16
#define RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_SHIFT 17
#define RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_SHIFT 18
#define RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_SHIFT 19
#define RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_SHIFT 20
#define RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_SHIFT 21
#define RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_SHIFT 22
#define RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_SHIFT 23
#define RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_SHIFT 24
#define RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_SHIFT 25
#define RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_SHIFT 26
#define RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_SHIFT 27
#define RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_SHIFT 28
#define RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_SHIFT 29
#define RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_SHIFT 30
#define RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_SHIFT 31

#define RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_MASK 0x00000001
#define RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_MASK 0x00000002
#define RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_MASK 0x00000004
#define RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_MASK 0x00000008
#define RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_MASK 0x00000010
#define RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_MASK 0x00000020
#define RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_MASK 0x00000040
#define RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_MASK 0x00000080
#define RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_MASK 0x00000100
#define RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_MASK 0x00000200
#define RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_MASK 0x00000400
#define RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_MASK 0x00000800
#define RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_MASK 0x00001000
#define RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_MASK 0x00002000
#define RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_MASK 0x00004000
#define RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_MASK 0x00008000
#define RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_MASK 0x00010000
#define RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_MASK 0x00020000
#define RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_MASK 0x00040000
#define RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_MASK 0x00080000
#define RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_MASK 0x00100000
#define RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_MASK 0x00200000
#define RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_MASK 0x00400000
#define RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_MASK 0x00800000
#define RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_MASK 0x01000000
#define RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_MASK 0x02000000
#define RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_MASK 0x04000000
#define RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_MASK 0x08000000
#define RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_MASK 0x10000000
#define RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_MASK 0x20000000
#define RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_MASK 0x40000000
#define RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_MASK 0x80000000

#define RBBM_PM_OVERRIDE1_MASK \
     (RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_MASK)

#define RBBM_PM_OVERRIDE1(rbbm_ahbclk_pm_override, sc_reg_sclk_pm_override, sc_sclk_pm_override, sp_top_sclk_pm_override, sp_v0_sclk_pm_override, sq_reg_sclk_pm_override, sq_reg_fifos_sclk_pm_override, sq_const_mem_sclk_pm_override, sq_sq_sclk_pm_override, sx_sclk_pm_override, sx_reg_sclk_pm_override, tcm_tco_sclk_pm_override, tcm_tcm_sclk_pm_override, tcm_tcd_sclk_pm_override, tcm_reg_sclk_pm_override, tpc_tpc_sclk_pm_override, tpc_reg_sclk_pm_override, tcf_tca_sclk_pm_override, tcf_tcb_sclk_pm_override, tcf_tcb_read_sclk_pm_override, tp_tp_sclk_pm_override, tp_reg_sclk_pm_override, cp_g_sclk_pm_override, cp_reg_sclk_pm_override, cp_g_reg_sclk_pm_override, spi_sclk_pm_override, rb_reg_sclk_pm_override, rb_sclk_pm_override, mh_mh_sclk_pm_override, mh_reg_sclk_pm_override, mh_mmu_sclk_pm_override, mh_tcroq_sclk_pm_override) \
     ((rbbm_ahbclk_pm_override << RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_SHIFT) | \
      (sc_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (sc_sclk_pm_override << RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_SHIFT) | \
      (sp_top_sclk_pm_override << RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_SHIFT) | \
      (sp_v0_sclk_pm_override << RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_SHIFT) | \
      (sq_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (sq_reg_fifos_sclk_pm_override << RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_SHIFT) | \
      (sq_const_mem_sclk_pm_override << RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_SHIFT) | \
      (sq_sq_sclk_pm_override << RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_SHIFT) | \
      (sx_sclk_pm_override << RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_SHIFT) | \
      (sx_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (tcm_tco_sclk_pm_override << RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_SHIFT) | \
      (tcm_tcm_sclk_pm_override << RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_SHIFT) | \
      (tcm_tcd_sclk_pm_override << RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_SHIFT) | \
      (tcm_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (tpc_tpc_sclk_pm_override << RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_SHIFT) | \
      (tpc_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (tcf_tca_sclk_pm_override << RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_SHIFT) | \
      (tcf_tcb_sclk_pm_override << RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_SHIFT) | \
      (tcf_tcb_read_sclk_pm_override << RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_SHIFT) | \
      (tp_tp_sclk_pm_override << RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_SHIFT) | \
      (tp_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (cp_g_sclk_pm_override << RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_SHIFT) | \
      (cp_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (cp_g_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (spi_sclk_pm_override << RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_SHIFT) | \
      (rb_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (rb_sclk_pm_override << RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_SHIFT) | \
      (mh_mh_sclk_pm_override << RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_SHIFT) | \
      (mh_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (mh_mmu_sclk_pm_override << RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_SHIFT) | \
      (mh_tcroq_sclk_pm_override << RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_SHIFT))

#define RBBM_PM_OVERRIDE1_GET_RBBM_AHBCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SC_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SC_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SP_TOP_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SP_V0_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SQ_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SQ_REG_FIFOS_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SQ_CONST_MEM_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SQ_SQ_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SX_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SX_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TCM_TCO_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TCM_TCM_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TCM_TCD_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TCM_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TPC_TPC_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TPC_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TCF_TCA_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TCF_TCB_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TCF_TCB_READ_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TP_TP_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_TP_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_CP_G_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_CP_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_CP_G_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_SPI_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_RB_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_RB_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_MH_MH_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_MH_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_MH_MMU_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_GET_MH_TCROQ_SCLK_PM_OVERRIDE(rbbm_pm_override1) \
     ((rbbm_pm_override1 & RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_SHIFT)

#define RBBM_PM_OVERRIDE1_SET_RBBM_AHBCLK_PM_OVERRIDE(rbbm_pm_override1_reg, rbbm_ahbclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_MASK) | (rbbm_ahbclk_pm_override << RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SC_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, sc_reg_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_MASK) | (sc_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SC_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, sc_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_MASK) | (sc_sclk_pm_override << RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SP_TOP_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, sp_top_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_MASK) | (sp_top_sclk_pm_override << RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SP_V0_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, sp_v0_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_MASK) | (sp_v0_sclk_pm_override << RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SQ_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, sq_reg_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_MASK) | (sq_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SQ_REG_FIFOS_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, sq_reg_fifos_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_MASK) | (sq_reg_fifos_sclk_pm_override << RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SQ_CONST_MEM_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, sq_const_mem_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_MASK) | (sq_const_mem_sclk_pm_override << RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SQ_SQ_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, sq_sq_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_MASK) | (sq_sq_sclk_pm_override << RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SX_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, sx_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_MASK) | (sx_sclk_pm_override << RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SX_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, sx_reg_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_MASK) | (sx_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TCM_TCO_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tcm_tco_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_MASK) | (tcm_tco_sclk_pm_override << RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TCM_TCM_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tcm_tcm_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_MASK) | (tcm_tcm_sclk_pm_override << RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TCM_TCD_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tcm_tcd_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_MASK) | (tcm_tcd_sclk_pm_override << RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TCM_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tcm_reg_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_MASK) | (tcm_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TPC_TPC_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tpc_tpc_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_MASK) | (tpc_tpc_sclk_pm_override << RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TPC_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tpc_reg_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_MASK) | (tpc_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TCF_TCA_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tcf_tca_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_MASK) | (tcf_tca_sclk_pm_override << RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TCF_TCB_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tcf_tcb_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_MASK) | (tcf_tcb_sclk_pm_override << RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TCF_TCB_READ_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tcf_tcb_read_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_MASK) | (tcf_tcb_read_sclk_pm_override << RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TP_TP_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tp_tp_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_MASK) | (tp_tp_sclk_pm_override << RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_TP_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, tp_reg_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_MASK) | (tp_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_CP_G_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, cp_g_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_MASK) | (cp_g_sclk_pm_override << RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_CP_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, cp_reg_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_MASK) | (cp_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_CP_G_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, cp_g_reg_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_MASK) | (cp_g_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_SPI_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, spi_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_MASK) | (spi_sclk_pm_override << RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_RB_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, rb_reg_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_MASK) | (rb_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_RB_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, rb_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_MASK) | (rb_sclk_pm_override << RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_MH_MH_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, mh_mh_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_MASK) | (mh_mh_sclk_pm_override << RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_MH_REG_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, mh_reg_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_MASK) | (mh_reg_sclk_pm_override << RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_MH_MMU_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, mh_mmu_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_MASK) | (mh_mmu_sclk_pm_override << RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE1_SET_MH_TCROQ_SCLK_PM_OVERRIDE(rbbm_pm_override1_reg, mh_tcroq_sclk_pm_override) \
     rbbm_pm_override1_reg = (rbbm_pm_override1_reg & ~RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_MASK) | (mh_tcroq_sclk_pm_override << RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_pm_override1_t {
          unsigned int rbbm_ahbclk_pm_override        : RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_SIZE;
          unsigned int sc_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sc_sclk_pm_override            : RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sp_top_sclk_pm_override        : RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sp_v0_sclk_pm_override         : RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sq_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sq_reg_fifos_sclk_pm_override  : RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sq_const_mem_sclk_pm_override  : RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sq_sq_sclk_pm_override         : RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sx_sclk_pm_override            : RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sx_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcm_tco_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcm_tcm_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcm_tcd_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcm_reg_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tpc_tpc_sclk_pm_override       : RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tpc_reg_sclk_pm_override       : RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcf_tca_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcf_tcb_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcf_tcb_read_sclk_pm_override  : RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tp_tp_sclk_pm_override         : RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tp_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int cp_g_sclk_pm_override          : RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_SIZE;
          unsigned int cp_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int cp_g_reg_sclk_pm_override      : RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int spi_sclk_pm_override           : RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_SIZE;
          unsigned int rb_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int rb_sclk_pm_override            : RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_SIZE;
          unsigned int mh_mh_sclk_pm_override         : RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_SIZE;
          unsigned int mh_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int mh_mmu_sclk_pm_override        : RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_SIZE;
          unsigned int mh_tcroq_sclk_pm_override      : RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_SIZE;
     } rbbm_pm_override1_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_pm_override1_t {
          unsigned int mh_tcroq_sclk_pm_override      : RBBM_PM_OVERRIDE1_MH_TCROQ_SCLK_PM_OVERRIDE_SIZE;
          unsigned int mh_mmu_sclk_pm_override        : RBBM_PM_OVERRIDE1_MH_MMU_SCLK_PM_OVERRIDE_SIZE;
          unsigned int mh_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_MH_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int mh_mh_sclk_pm_override         : RBBM_PM_OVERRIDE1_MH_MH_SCLK_PM_OVERRIDE_SIZE;
          unsigned int rb_sclk_pm_override            : RBBM_PM_OVERRIDE1_RB_SCLK_PM_OVERRIDE_SIZE;
          unsigned int rb_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_RB_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int spi_sclk_pm_override           : RBBM_PM_OVERRIDE1_SPI_SCLK_PM_OVERRIDE_SIZE;
          unsigned int cp_g_reg_sclk_pm_override      : RBBM_PM_OVERRIDE1_CP_G_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int cp_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_CP_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int cp_g_sclk_pm_override          : RBBM_PM_OVERRIDE1_CP_G_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tp_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_TP_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tp_tp_sclk_pm_override         : RBBM_PM_OVERRIDE1_TP_TP_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcf_tcb_read_sclk_pm_override  : RBBM_PM_OVERRIDE1_TCF_TCB_READ_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcf_tcb_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCF_TCB_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcf_tca_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCF_TCA_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tpc_reg_sclk_pm_override       : RBBM_PM_OVERRIDE1_TPC_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tpc_tpc_sclk_pm_override       : RBBM_PM_OVERRIDE1_TPC_TPC_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcm_reg_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCM_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcm_tcd_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCM_TCD_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcm_tcm_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCM_TCM_SCLK_PM_OVERRIDE_SIZE;
          unsigned int tcm_tco_sclk_pm_override       : RBBM_PM_OVERRIDE1_TCM_TCO_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sx_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_SX_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sx_sclk_pm_override            : RBBM_PM_OVERRIDE1_SX_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sq_sq_sclk_pm_override         : RBBM_PM_OVERRIDE1_SQ_SQ_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sq_const_mem_sclk_pm_override  : RBBM_PM_OVERRIDE1_SQ_CONST_MEM_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sq_reg_fifos_sclk_pm_override  : RBBM_PM_OVERRIDE1_SQ_REG_FIFOS_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sq_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_SQ_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sp_v0_sclk_pm_override         : RBBM_PM_OVERRIDE1_SP_V0_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sp_top_sclk_pm_override        : RBBM_PM_OVERRIDE1_SP_TOP_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sc_sclk_pm_override            : RBBM_PM_OVERRIDE1_SC_SCLK_PM_OVERRIDE_SIZE;
          unsigned int sc_reg_sclk_pm_override        : RBBM_PM_OVERRIDE1_SC_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int rbbm_ahbclk_pm_override        : RBBM_PM_OVERRIDE1_RBBM_AHBCLK_PM_OVERRIDE_SIZE;
     } rbbm_pm_override1_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_pm_override1_t f;
} rbbm_pm_override1_u;


/*
 * RBBM_PM_OVERRIDE2 struct
 */

#define RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_SIZE 1
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_SIZE 1

#define RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_SHIFT 0
#define RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_SHIFT 1
#define RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_SHIFT 2
#define RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_SHIFT 3
#define RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_SHIFT 4
#define RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_SHIFT 5
#define RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_SHIFT 6
#define RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_SHIFT 7
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_SHIFT 8
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_SHIFT 9
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_SHIFT 10
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_SHIFT 11

#define RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_MASK 0x00000001
#define RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_MASK 0x00000002
#define RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_MASK 0x00000004
#define RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_MASK 0x00000008
#define RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_MASK 0x00000010
#define RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_MASK 0x00000020
#define RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_MASK 0x00000040
#define RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_MASK 0x00000080
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_MASK 0x00000100
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_MASK 0x00000200
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_MASK 0x00000400
#define RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_MASK 0x00000800

#define RBBM_PM_OVERRIDE2_MASK \
     (RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_MASK | \
      RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_MASK)

#define RBBM_PM_OVERRIDE2(pa_reg_sclk_pm_override, pa_pa_sclk_pm_override, pa_ag_sclk_pm_override, vgt_reg_sclk_pm_override, vgt_fifos_sclk_pm_override, vgt_vgt_sclk_pm_override, debug_perf_sclk_pm_override, perm_sclk_pm_override, gc_ga_gmem0_pm_override, gc_ga_gmem1_pm_override, gc_ga_gmem2_pm_override, gc_ga_gmem3_pm_override) \
     ((pa_reg_sclk_pm_override << RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (pa_pa_sclk_pm_override << RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_SHIFT) | \
      (pa_ag_sclk_pm_override << RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_SHIFT) | \
      (vgt_reg_sclk_pm_override << RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_SHIFT) | \
      (vgt_fifos_sclk_pm_override << RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_SHIFT) | \
      (vgt_vgt_sclk_pm_override << RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_SHIFT) | \
      (debug_perf_sclk_pm_override << RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_SHIFT) | \
      (perm_sclk_pm_override << RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_SHIFT) | \
      (gc_ga_gmem0_pm_override << RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_SHIFT) | \
      (gc_ga_gmem1_pm_override << RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_SHIFT) | \
      (gc_ga_gmem2_pm_override << RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_SHIFT) | \
      (gc_ga_gmem3_pm_override << RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_SHIFT))

#define RBBM_PM_OVERRIDE2_GET_PA_REG_SCLK_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_PA_PA_SCLK_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_PA_AG_SCLK_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_VGT_REG_SCLK_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_VGT_FIFOS_SCLK_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_VGT_VGT_SCLK_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_DEBUG_PERF_SCLK_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_PERM_SCLK_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_GC_GA_GMEM0_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_GC_GA_GMEM1_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_GC_GA_GMEM2_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_GET_GC_GA_GMEM3_PM_OVERRIDE(rbbm_pm_override2) \
     ((rbbm_pm_override2 & RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_MASK) >> RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_SHIFT)

#define RBBM_PM_OVERRIDE2_SET_PA_REG_SCLK_PM_OVERRIDE(rbbm_pm_override2_reg, pa_reg_sclk_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_MASK) | (pa_reg_sclk_pm_override << RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_PA_PA_SCLK_PM_OVERRIDE(rbbm_pm_override2_reg, pa_pa_sclk_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_MASK) | (pa_pa_sclk_pm_override << RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_PA_AG_SCLK_PM_OVERRIDE(rbbm_pm_override2_reg, pa_ag_sclk_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_MASK) | (pa_ag_sclk_pm_override << RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_VGT_REG_SCLK_PM_OVERRIDE(rbbm_pm_override2_reg, vgt_reg_sclk_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_MASK) | (vgt_reg_sclk_pm_override << RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_VGT_FIFOS_SCLK_PM_OVERRIDE(rbbm_pm_override2_reg, vgt_fifos_sclk_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_MASK) | (vgt_fifos_sclk_pm_override << RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_VGT_VGT_SCLK_PM_OVERRIDE(rbbm_pm_override2_reg, vgt_vgt_sclk_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_MASK) | (vgt_vgt_sclk_pm_override << RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_DEBUG_PERF_SCLK_PM_OVERRIDE(rbbm_pm_override2_reg, debug_perf_sclk_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_MASK) | (debug_perf_sclk_pm_override << RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_PERM_SCLK_PM_OVERRIDE(rbbm_pm_override2_reg, perm_sclk_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_MASK) | (perm_sclk_pm_override << RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_GC_GA_GMEM0_PM_OVERRIDE(rbbm_pm_override2_reg, gc_ga_gmem0_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_MASK) | (gc_ga_gmem0_pm_override << RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_GC_GA_GMEM1_PM_OVERRIDE(rbbm_pm_override2_reg, gc_ga_gmem1_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_MASK) | (gc_ga_gmem1_pm_override << RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_GC_GA_GMEM2_PM_OVERRIDE(rbbm_pm_override2_reg, gc_ga_gmem2_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_MASK) | (gc_ga_gmem2_pm_override << RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_SHIFT)
#define RBBM_PM_OVERRIDE2_SET_GC_GA_GMEM3_PM_OVERRIDE(rbbm_pm_override2_reg, gc_ga_gmem3_pm_override) \
     rbbm_pm_override2_reg = (rbbm_pm_override2_reg & ~RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_MASK) | (gc_ga_gmem3_pm_override << RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_pm_override2_t {
          unsigned int pa_reg_sclk_pm_override        : RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int pa_pa_sclk_pm_override         : RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_SIZE;
          unsigned int pa_ag_sclk_pm_override         : RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int vgt_reg_sclk_pm_override       : RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int vgt_fifos_sclk_pm_override     : RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_SIZE;
          unsigned int vgt_vgt_sclk_pm_override       : RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_SIZE;
          unsigned int debug_perf_sclk_pm_override    : RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_SIZE;
          unsigned int perm_sclk_pm_override          : RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_SIZE;
          unsigned int gc_ga_gmem0_pm_override        : RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_SIZE;
          unsigned int gc_ga_gmem1_pm_override        : RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_SIZE;
          unsigned int gc_ga_gmem2_pm_override        : RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_SIZE;
          unsigned int gc_ga_gmem3_pm_override        : RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_SIZE;
          unsigned int                                : 20;
     } rbbm_pm_override2_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_pm_override2_t {
          unsigned int                                : 20;
          unsigned int gc_ga_gmem3_pm_override        : RBBM_PM_OVERRIDE2_GC_GA_GMEM3_PM_OVERRIDE_SIZE;
          unsigned int gc_ga_gmem2_pm_override        : RBBM_PM_OVERRIDE2_GC_GA_GMEM2_PM_OVERRIDE_SIZE;
          unsigned int gc_ga_gmem1_pm_override        : RBBM_PM_OVERRIDE2_GC_GA_GMEM1_PM_OVERRIDE_SIZE;
          unsigned int gc_ga_gmem0_pm_override        : RBBM_PM_OVERRIDE2_GC_GA_GMEM0_PM_OVERRIDE_SIZE;
          unsigned int perm_sclk_pm_override          : RBBM_PM_OVERRIDE2_PERM_SCLK_PM_OVERRIDE_SIZE;
          unsigned int debug_perf_sclk_pm_override    : RBBM_PM_OVERRIDE2_DEBUG_PERF_SCLK_PM_OVERRIDE_SIZE;
          unsigned int vgt_vgt_sclk_pm_override       : RBBM_PM_OVERRIDE2_VGT_VGT_SCLK_PM_OVERRIDE_SIZE;
          unsigned int vgt_fifos_sclk_pm_override     : RBBM_PM_OVERRIDE2_VGT_FIFOS_SCLK_PM_OVERRIDE_SIZE;
          unsigned int vgt_reg_sclk_pm_override       : RBBM_PM_OVERRIDE2_VGT_REG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int pa_ag_sclk_pm_override         : RBBM_PM_OVERRIDE2_PA_AG_SCLK_PM_OVERRIDE_SIZE;
          unsigned int pa_pa_sclk_pm_override         : RBBM_PM_OVERRIDE2_PA_PA_SCLK_PM_OVERRIDE_SIZE;
          unsigned int pa_reg_sclk_pm_override        : RBBM_PM_OVERRIDE2_PA_REG_SCLK_PM_OVERRIDE_SIZE;
     } rbbm_pm_override2_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_pm_override2_t f;
} rbbm_pm_override2_u;


/*
 * GC_SYS_IDLE struct
 */

#define GC_SYS_IDLE_GC_SYS_IDLE_DELAY_SIZE 16
#define GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_SIZE 6
#define GC_SYS_IDLE_GC_SYS_URGENT_RAMP_SIZE 1
#define GC_SYS_IDLE_GC_SYS_WAIT_DMI_SIZE 1
#define GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_SIZE 1
#define GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_SIZE 1
#define GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_SIZE 1

#define GC_SYS_IDLE_GC_SYS_IDLE_DELAY_SHIFT 0
#define GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_SHIFT 16
#define GC_SYS_IDLE_GC_SYS_URGENT_RAMP_SHIFT 24
#define GC_SYS_IDLE_GC_SYS_WAIT_DMI_SHIFT 25
#define GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_SHIFT 29
#define GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_SHIFT 30
#define GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_SHIFT 31

#define GC_SYS_IDLE_GC_SYS_IDLE_DELAY_MASK 0x0000ffff
#define GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_MASK 0x003f0000
#define GC_SYS_IDLE_GC_SYS_URGENT_RAMP_MASK 0x01000000
#define GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK 0x02000000
#define GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_MASK 0x20000000
#define GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_MASK 0x40000000
#define GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_MASK 0x80000000

#define GC_SYS_IDLE_MASK \
     (GC_SYS_IDLE_GC_SYS_IDLE_DELAY_MASK | \
      GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_MASK | \
      GC_SYS_IDLE_GC_SYS_URGENT_RAMP_MASK | \
      GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK | \
      GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_MASK | \
      GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_MASK | \
      GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_MASK)

#define GC_SYS_IDLE(gc_sys_idle_delay, gc_sys_wait_dmi_mask, gc_sys_urgent_ramp, gc_sys_wait_dmi, gc_sys_urgent_ramp_override, gc_sys_wait_dmi_override, gc_sys_idle_override) \
     ((gc_sys_idle_delay << GC_SYS_IDLE_GC_SYS_IDLE_DELAY_SHIFT) | \
      (gc_sys_wait_dmi_mask << GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_SHIFT) | \
      (gc_sys_urgent_ramp << GC_SYS_IDLE_GC_SYS_URGENT_RAMP_SHIFT) | \
      (gc_sys_wait_dmi << GC_SYS_IDLE_GC_SYS_WAIT_DMI_SHIFT) | \
      (gc_sys_urgent_ramp_override << GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_SHIFT) | \
      (gc_sys_wait_dmi_override << GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_SHIFT) | \
      (gc_sys_idle_override << GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_SHIFT))

#define GC_SYS_IDLE_GET_GC_SYS_IDLE_DELAY(gc_sys_idle) \
     ((gc_sys_idle & GC_SYS_IDLE_GC_SYS_IDLE_DELAY_MASK) >> GC_SYS_IDLE_GC_SYS_IDLE_DELAY_SHIFT)
#define GC_SYS_IDLE_GET_GC_SYS_WAIT_DMI_MASK(gc_sys_idle) \
     ((gc_sys_idle & GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_MASK) >> GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_SHIFT)
#define GC_SYS_IDLE_GET_GC_SYS_URGENT_RAMP(gc_sys_idle) \
     ((gc_sys_idle & GC_SYS_IDLE_GC_SYS_URGENT_RAMP_MASK) >> GC_SYS_IDLE_GC_SYS_URGENT_RAMP_SHIFT)
#define GC_SYS_IDLE_GET_GC_SYS_WAIT_DMI(gc_sys_idle) \
     ((gc_sys_idle & GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK) >> GC_SYS_IDLE_GC_SYS_WAIT_DMI_SHIFT)
#define GC_SYS_IDLE_GET_GC_SYS_URGENT_RAMP_OVERRIDE(gc_sys_idle) \
     ((gc_sys_idle & GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_MASK) >> GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_SHIFT)
#define GC_SYS_IDLE_GET_GC_SYS_WAIT_DMI_OVERRIDE(gc_sys_idle) \
     ((gc_sys_idle & GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_MASK) >> GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_SHIFT)
#define GC_SYS_IDLE_GET_GC_SYS_IDLE_OVERRIDE(gc_sys_idle) \
     ((gc_sys_idle & GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_MASK) >> GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_SHIFT)

#define GC_SYS_IDLE_SET_GC_SYS_IDLE_DELAY(gc_sys_idle_reg, gc_sys_idle_delay) \
     gc_sys_idle_reg = (gc_sys_idle_reg & ~GC_SYS_IDLE_GC_SYS_IDLE_DELAY_MASK) | (gc_sys_idle_delay << GC_SYS_IDLE_GC_SYS_IDLE_DELAY_SHIFT)
#define GC_SYS_IDLE_SET_GC_SYS_WAIT_DMI_MASK(gc_sys_idle_reg, gc_sys_wait_dmi_mask) \
     gc_sys_idle_reg = (gc_sys_idle_reg & ~GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_MASK) | (gc_sys_wait_dmi_mask << GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_SHIFT)
#define GC_SYS_IDLE_SET_GC_SYS_URGENT_RAMP(gc_sys_idle_reg, gc_sys_urgent_ramp) \
     gc_sys_idle_reg = (gc_sys_idle_reg & ~GC_SYS_IDLE_GC_SYS_URGENT_RAMP_MASK) | (gc_sys_urgent_ramp << GC_SYS_IDLE_GC_SYS_URGENT_RAMP_SHIFT)
#define GC_SYS_IDLE_SET_GC_SYS_WAIT_DMI(gc_sys_idle_reg, gc_sys_wait_dmi) \
     gc_sys_idle_reg = (gc_sys_idle_reg & ~GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK) | (gc_sys_wait_dmi << GC_SYS_IDLE_GC_SYS_WAIT_DMI_SHIFT)
#define GC_SYS_IDLE_SET_GC_SYS_URGENT_RAMP_OVERRIDE(gc_sys_idle_reg, gc_sys_urgent_ramp_override) \
     gc_sys_idle_reg = (gc_sys_idle_reg & ~GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_MASK) | (gc_sys_urgent_ramp_override << GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_SHIFT)
#define GC_SYS_IDLE_SET_GC_SYS_WAIT_DMI_OVERRIDE(gc_sys_idle_reg, gc_sys_wait_dmi_override) \
     gc_sys_idle_reg = (gc_sys_idle_reg & ~GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_MASK) | (gc_sys_wait_dmi_override << GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_SHIFT)
#define GC_SYS_IDLE_SET_GC_SYS_IDLE_OVERRIDE(gc_sys_idle_reg, gc_sys_idle_override) \
     gc_sys_idle_reg = (gc_sys_idle_reg & ~GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_MASK) | (gc_sys_idle_override << GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _gc_sys_idle_t {
          unsigned int gc_sys_idle_delay              : GC_SYS_IDLE_GC_SYS_IDLE_DELAY_SIZE;
          unsigned int gc_sys_wait_dmi_mask           : GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_SIZE;
          unsigned int                                : 2;
          unsigned int gc_sys_urgent_ramp             : GC_SYS_IDLE_GC_SYS_URGENT_RAMP_SIZE;
          unsigned int gc_sys_wait_dmi                : GC_SYS_IDLE_GC_SYS_WAIT_DMI_SIZE;
          unsigned int                                : 3;
          unsigned int gc_sys_urgent_ramp_override    : GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_SIZE;
          unsigned int gc_sys_wait_dmi_override       : GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_SIZE;
          unsigned int gc_sys_idle_override           : GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_SIZE;
     } gc_sys_idle_t;

#else   // !BIGENDIAN_OS

     typedef struct _gc_sys_idle_t {
          unsigned int gc_sys_idle_override           : GC_SYS_IDLE_GC_SYS_IDLE_OVERRIDE_SIZE;
          unsigned int gc_sys_wait_dmi_override       : GC_SYS_IDLE_GC_SYS_WAIT_DMI_OVERRIDE_SIZE;
          unsigned int gc_sys_urgent_ramp_override    : GC_SYS_IDLE_GC_SYS_URGENT_RAMP_OVERRIDE_SIZE;
          unsigned int                                : 3;
          unsigned int gc_sys_wait_dmi                : GC_SYS_IDLE_GC_SYS_WAIT_DMI_SIZE;
          unsigned int gc_sys_urgent_ramp             : GC_SYS_IDLE_GC_SYS_URGENT_RAMP_SIZE;
          unsigned int                                : 2;
          unsigned int gc_sys_wait_dmi_mask           : GC_SYS_IDLE_GC_SYS_WAIT_DMI_MASK_SIZE;
          unsigned int gc_sys_idle_delay              : GC_SYS_IDLE_GC_SYS_IDLE_DELAY_SIZE;
     } gc_sys_idle_t;

#endif

typedef union {
     unsigned int val : 32;
     gc_sys_idle_t f;
} gc_sys_idle_u;


/*
 * NQWAIT_UNTIL struct
 */

#define NQWAIT_UNTIL_WAIT_GUI_IDLE_SIZE 1

#define NQWAIT_UNTIL_WAIT_GUI_IDLE_SHIFT 0

#define NQWAIT_UNTIL_WAIT_GUI_IDLE_MASK 0x00000001

#define NQWAIT_UNTIL_MASK \
     (NQWAIT_UNTIL_WAIT_GUI_IDLE_MASK)

#define NQWAIT_UNTIL(wait_gui_idle) \
     ((wait_gui_idle << NQWAIT_UNTIL_WAIT_GUI_IDLE_SHIFT))

#define NQWAIT_UNTIL_GET_WAIT_GUI_IDLE(nqwait_until) \
     ((nqwait_until & NQWAIT_UNTIL_WAIT_GUI_IDLE_MASK) >> NQWAIT_UNTIL_WAIT_GUI_IDLE_SHIFT)

#define NQWAIT_UNTIL_SET_WAIT_GUI_IDLE(nqwait_until_reg, wait_gui_idle) \
     nqwait_until_reg = (nqwait_until_reg & ~NQWAIT_UNTIL_WAIT_GUI_IDLE_MASK) | (wait_gui_idle << NQWAIT_UNTIL_WAIT_GUI_IDLE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _nqwait_until_t {
          unsigned int wait_gui_idle                  : NQWAIT_UNTIL_WAIT_GUI_IDLE_SIZE;
          unsigned int                                : 31;
     } nqwait_until_t;

#else   // !BIGENDIAN_OS

     typedef struct _nqwait_until_t {
          unsigned int                                : 31;
          unsigned int wait_gui_idle                  : NQWAIT_UNTIL_WAIT_GUI_IDLE_SIZE;
     } nqwait_until_t;

#endif

typedef union {
     unsigned int val : 32;
     nqwait_until_t f;
} nqwait_until_u;


/*
 * RBBM_DEBUG_OUT struct
 */

#define RBBM_DEBUG_OUT_DEBUG_BUS_OUT_SIZE 32

#define RBBM_DEBUG_OUT_DEBUG_BUS_OUT_SHIFT 0

#define RBBM_DEBUG_OUT_DEBUG_BUS_OUT_MASK 0xffffffff

#define RBBM_DEBUG_OUT_MASK \
     (RBBM_DEBUG_OUT_DEBUG_BUS_OUT_MASK)

#define RBBM_DEBUG_OUT(debug_bus_out) \
     ((debug_bus_out << RBBM_DEBUG_OUT_DEBUG_BUS_OUT_SHIFT))

#define RBBM_DEBUG_OUT_GET_DEBUG_BUS_OUT(rbbm_debug_out) \
     ((rbbm_debug_out & RBBM_DEBUG_OUT_DEBUG_BUS_OUT_MASK) >> RBBM_DEBUG_OUT_DEBUG_BUS_OUT_SHIFT)

#define RBBM_DEBUG_OUT_SET_DEBUG_BUS_OUT(rbbm_debug_out_reg, debug_bus_out) \
     rbbm_debug_out_reg = (rbbm_debug_out_reg & ~RBBM_DEBUG_OUT_DEBUG_BUS_OUT_MASK) | (debug_bus_out << RBBM_DEBUG_OUT_DEBUG_BUS_OUT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_debug_out_t {
          unsigned int debug_bus_out                  : RBBM_DEBUG_OUT_DEBUG_BUS_OUT_SIZE;
     } rbbm_debug_out_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_debug_out_t {
          unsigned int debug_bus_out                  : RBBM_DEBUG_OUT_DEBUG_BUS_OUT_SIZE;
     } rbbm_debug_out_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_debug_out_t f;
} rbbm_debug_out_u;


/*
 * RBBM_DEBUG_CNTL struct
 */

#define RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_SIZE 6
#define RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_SIZE 4
#define RBBM_DEBUG_CNTL_SW_ENABLE_SIZE 1
#define RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_SIZE 6
#define RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_SIZE 4
#define RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_SIZE 4

#define RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_SHIFT 0
#define RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_SHIFT 8
#define RBBM_DEBUG_CNTL_SW_ENABLE_SHIFT 12
#define RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_SHIFT 16
#define RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_SHIFT 24
#define RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_SHIFT 28

#define RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_MASK 0x0000003f
#define RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_MASK 0x00000f00
#define RBBM_DEBUG_CNTL_SW_ENABLE_MASK 0x00001000
#define RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_MASK 0x003f0000
#define RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_MASK 0x0f000000
#define RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_MASK 0xf0000000

#define RBBM_DEBUG_CNTL_MASK \
     (RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_MASK | \
      RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_MASK | \
      RBBM_DEBUG_CNTL_SW_ENABLE_MASK | \
      RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_MASK | \
      RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_MASK | \
      RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_MASK)

#define RBBM_DEBUG_CNTL(sub_block_addr, sub_block_sel, sw_enable, gpio_sub_block_addr, gpio_sub_block_sel, gpio_byte_lane_enb) \
     ((sub_block_addr << RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_SHIFT) | \
      (sub_block_sel << RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_SHIFT) | \
      (sw_enable << RBBM_DEBUG_CNTL_SW_ENABLE_SHIFT) | \
      (gpio_sub_block_addr << RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_SHIFT) | \
      (gpio_sub_block_sel << RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_SHIFT) | \
      (gpio_byte_lane_enb << RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_SHIFT))

#define RBBM_DEBUG_CNTL_GET_SUB_BLOCK_ADDR(rbbm_debug_cntl) \
     ((rbbm_debug_cntl & RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_MASK) >> RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_SHIFT)
#define RBBM_DEBUG_CNTL_GET_SUB_BLOCK_SEL(rbbm_debug_cntl) \
     ((rbbm_debug_cntl & RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_MASK) >> RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_SHIFT)
#define RBBM_DEBUG_CNTL_GET_SW_ENABLE(rbbm_debug_cntl) \
     ((rbbm_debug_cntl & RBBM_DEBUG_CNTL_SW_ENABLE_MASK) >> RBBM_DEBUG_CNTL_SW_ENABLE_SHIFT)
#define RBBM_DEBUG_CNTL_GET_GPIO_SUB_BLOCK_ADDR(rbbm_debug_cntl) \
     ((rbbm_debug_cntl & RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_MASK) >> RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_SHIFT)
#define RBBM_DEBUG_CNTL_GET_GPIO_SUB_BLOCK_SEL(rbbm_debug_cntl) \
     ((rbbm_debug_cntl & RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_MASK) >> RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_SHIFT)
#define RBBM_DEBUG_CNTL_GET_GPIO_BYTE_LANE_ENB(rbbm_debug_cntl) \
     ((rbbm_debug_cntl & RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_MASK) >> RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_SHIFT)

#define RBBM_DEBUG_CNTL_SET_SUB_BLOCK_ADDR(rbbm_debug_cntl_reg, sub_block_addr) \
     rbbm_debug_cntl_reg = (rbbm_debug_cntl_reg & ~RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_MASK) | (sub_block_addr << RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_SHIFT)
#define RBBM_DEBUG_CNTL_SET_SUB_BLOCK_SEL(rbbm_debug_cntl_reg, sub_block_sel) \
     rbbm_debug_cntl_reg = (rbbm_debug_cntl_reg & ~RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_MASK) | (sub_block_sel << RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_SHIFT)
#define RBBM_DEBUG_CNTL_SET_SW_ENABLE(rbbm_debug_cntl_reg, sw_enable) \
     rbbm_debug_cntl_reg = (rbbm_debug_cntl_reg & ~RBBM_DEBUG_CNTL_SW_ENABLE_MASK) | (sw_enable << RBBM_DEBUG_CNTL_SW_ENABLE_SHIFT)
#define RBBM_DEBUG_CNTL_SET_GPIO_SUB_BLOCK_ADDR(rbbm_debug_cntl_reg, gpio_sub_block_addr) \
     rbbm_debug_cntl_reg = (rbbm_debug_cntl_reg & ~RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_MASK) | (gpio_sub_block_addr << RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_SHIFT)
#define RBBM_DEBUG_CNTL_SET_GPIO_SUB_BLOCK_SEL(rbbm_debug_cntl_reg, gpio_sub_block_sel) \
     rbbm_debug_cntl_reg = (rbbm_debug_cntl_reg & ~RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_MASK) | (gpio_sub_block_sel << RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_SHIFT)
#define RBBM_DEBUG_CNTL_SET_GPIO_BYTE_LANE_ENB(rbbm_debug_cntl_reg, gpio_byte_lane_enb) \
     rbbm_debug_cntl_reg = (rbbm_debug_cntl_reg & ~RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_MASK) | (gpio_byte_lane_enb << RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_debug_cntl_t {
          unsigned int sub_block_addr                 : RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_SIZE;
          unsigned int                                : 2;
          unsigned int sub_block_sel                  : RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_SIZE;
          unsigned int sw_enable                      : RBBM_DEBUG_CNTL_SW_ENABLE_SIZE;
          unsigned int                                : 3;
          unsigned int gpio_sub_block_addr            : RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_SIZE;
          unsigned int                                : 2;
          unsigned int gpio_sub_block_sel             : RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_SIZE;
          unsigned int gpio_byte_lane_enb             : RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_SIZE;
     } rbbm_debug_cntl_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_debug_cntl_t {
          unsigned int gpio_byte_lane_enb             : RBBM_DEBUG_CNTL_GPIO_BYTE_LANE_ENB_SIZE;
          unsigned int gpio_sub_block_sel             : RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_SEL_SIZE;
          unsigned int                                : 2;
          unsigned int gpio_sub_block_addr            : RBBM_DEBUG_CNTL_GPIO_SUB_BLOCK_ADDR_SIZE;
          unsigned int                                : 3;
          unsigned int sw_enable                      : RBBM_DEBUG_CNTL_SW_ENABLE_SIZE;
          unsigned int sub_block_sel                  : RBBM_DEBUG_CNTL_SUB_BLOCK_SEL_SIZE;
          unsigned int                                : 2;
          unsigned int sub_block_addr                 : RBBM_DEBUG_CNTL_SUB_BLOCK_ADDR_SIZE;
     } rbbm_debug_cntl_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_debug_cntl_t f;
} rbbm_debug_cntl_u;


/*
 * RBBM_DEBUG struct
 */

#define RBBM_DEBUG_IGNORE_RTR_SIZE     1
#define RBBM_DEBUG_IGNORE_CP_SCHED_WU_SIZE 1
#define RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_SIZE 1
#define RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_SIZE 1
#define RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_SIZE 4
#define RBBM_DEBUG_IGNORE_RTR_FOR_HI_SIZE 1
#define RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_SIZE 1
#define RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_SIZE 1
#define RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_SIZE 1
#define RBBM_DEBUG_CP_RBBM_NRTRTR_SIZE 1
#define RBBM_DEBUG_VGT_RBBM_NRTRTR_SIZE 1
#define RBBM_DEBUG_SQ_RBBM_NRTRTR_SIZE 1
#define RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_SIZE 1
#define RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_SIZE 1
#define RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_SIZE 1

#define RBBM_DEBUG_IGNORE_RTR_SHIFT    1
#define RBBM_DEBUG_IGNORE_CP_SCHED_WU_SHIFT 2
#define RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_SHIFT 3
#define RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_SHIFT 4
#define RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_SHIFT 8
#define RBBM_DEBUG_IGNORE_RTR_FOR_HI_SHIFT 16
#define RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_SHIFT 17
#define RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_SHIFT 18
#define RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_SHIFT 19
#define RBBM_DEBUG_CP_RBBM_NRTRTR_SHIFT 20
#define RBBM_DEBUG_VGT_RBBM_NRTRTR_SHIFT 21
#define RBBM_DEBUG_SQ_RBBM_NRTRTR_SHIFT 22
#define RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_SHIFT 23
#define RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_SHIFT 24
#define RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_SHIFT 31

#define RBBM_DEBUG_IGNORE_RTR_MASK     0x00000002
#define RBBM_DEBUG_IGNORE_CP_SCHED_WU_MASK 0x00000004
#define RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_MASK 0x00000008
#define RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_MASK 0x00000010
#define RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_MASK 0x00000f00
#define RBBM_DEBUG_IGNORE_RTR_FOR_HI_MASK 0x00010000
#define RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_MASK 0x00020000
#define RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_MASK 0x00040000
#define RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_MASK 0x00080000
#define RBBM_DEBUG_CP_RBBM_NRTRTR_MASK 0x00100000
#define RBBM_DEBUG_VGT_RBBM_NRTRTR_MASK 0x00200000
#define RBBM_DEBUG_SQ_RBBM_NRTRTR_MASK 0x00400000
#define RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_MASK 0x00800000
#define RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_MASK 0x01000000
#define RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_MASK 0x80000000

#define RBBM_DEBUG_MASK \
     (RBBM_DEBUG_IGNORE_RTR_MASK | \
      RBBM_DEBUG_IGNORE_CP_SCHED_WU_MASK | \
      RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_MASK | \
      RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_MASK | \
      RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_MASK | \
      RBBM_DEBUG_IGNORE_RTR_FOR_HI_MASK | \
      RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_MASK | \
      RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_MASK | \
      RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_MASK | \
      RBBM_DEBUG_CP_RBBM_NRTRTR_MASK | \
      RBBM_DEBUG_VGT_RBBM_NRTRTR_MASK | \
      RBBM_DEBUG_SQ_RBBM_NRTRTR_MASK | \
      RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_MASK | \
      RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_MASK | \
      RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_MASK)

#define RBBM_DEBUG(ignore_rtr, ignore_cp_sched_wu, ignore_cp_sched_isync, ignore_cp_sched_nq_hi, hysteresis_nrt_gui_active, ignore_rtr_for_hi, ignore_cp_rbbm_nrtrtr_for_hi, ignore_vgt_rbbm_nrtrtr_for_hi, ignore_sq_rbbm_nrtrtr_for_hi, cp_rbbm_nrtrtr, vgt_rbbm_nrtrtr, sq_rbbm_nrtrtr, clients_for_nrt_rtr_for_hi, clients_for_nrt_rtr, ignore_sx_rbbm_busy) \
     ((ignore_rtr << RBBM_DEBUG_IGNORE_RTR_SHIFT) | \
      (ignore_cp_sched_wu << RBBM_DEBUG_IGNORE_CP_SCHED_WU_SHIFT) | \
      (ignore_cp_sched_isync << RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_SHIFT) | \
      (ignore_cp_sched_nq_hi << RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_SHIFT) | \
      (hysteresis_nrt_gui_active << RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_SHIFT) | \
      (ignore_rtr_for_hi << RBBM_DEBUG_IGNORE_RTR_FOR_HI_SHIFT) | \
      (ignore_cp_rbbm_nrtrtr_for_hi << RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_SHIFT) | \
      (ignore_vgt_rbbm_nrtrtr_for_hi << RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_SHIFT) | \
      (ignore_sq_rbbm_nrtrtr_for_hi << RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_SHIFT) | \
      (cp_rbbm_nrtrtr << RBBM_DEBUG_CP_RBBM_NRTRTR_SHIFT) | \
      (vgt_rbbm_nrtrtr << RBBM_DEBUG_VGT_RBBM_NRTRTR_SHIFT) | \
      (sq_rbbm_nrtrtr << RBBM_DEBUG_SQ_RBBM_NRTRTR_SHIFT) | \
      (clients_for_nrt_rtr_for_hi << RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_SHIFT) | \
      (clients_for_nrt_rtr << RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_SHIFT) | \
      (ignore_sx_rbbm_busy << RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_SHIFT))

#define RBBM_DEBUG_GET_IGNORE_RTR(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_IGNORE_RTR_MASK) >> RBBM_DEBUG_IGNORE_RTR_SHIFT)
#define RBBM_DEBUG_GET_IGNORE_CP_SCHED_WU(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_IGNORE_CP_SCHED_WU_MASK) >> RBBM_DEBUG_IGNORE_CP_SCHED_WU_SHIFT)
#define RBBM_DEBUG_GET_IGNORE_CP_SCHED_ISYNC(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_MASK) >> RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_SHIFT)
#define RBBM_DEBUG_GET_IGNORE_CP_SCHED_NQ_HI(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_MASK) >> RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_SHIFT)
#define RBBM_DEBUG_GET_HYSTERESIS_NRT_GUI_ACTIVE(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_MASK) >> RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_SHIFT)
#define RBBM_DEBUG_GET_IGNORE_RTR_FOR_HI(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_IGNORE_RTR_FOR_HI_MASK) >> RBBM_DEBUG_IGNORE_RTR_FOR_HI_SHIFT)
#define RBBM_DEBUG_GET_IGNORE_CP_RBBM_NRTRTR_FOR_HI(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_MASK) >> RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_SHIFT)
#define RBBM_DEBUG_GET_IGNORE_VGT_RBBM_NRTRTR_FOR_HI(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_MASK) >> RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_SHIFT)
#define RBBM_DEBUG_GET_IGNORE_SQ_RBBM_NRTRTR_FOR_HI(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_MASK) >> RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_SHIFT)
#define RBBM_DEBUG_GET_CP_RBBM_NRTRTR(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_CP_RBBM_NRTRTR_MASK) >> RBBM_DEBUG_CP_RBBM_NRTRTR_SHIFT)
#define RBBM_DEBUG_GET_VGT_RBBM_NRTRTR(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_VGT_RBBM_NRTRTR_MASK) >> RBBM_DEBUG_VGT_RBBM_NRTRTR_SHIFT)
#define RBBM_DEBUG_GET_SQ_RBBM_NRTRTR(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_SQ_RBBM_NRTRTR_MASK) >> RBBM_DEBUG_SQ_RBBM_NRTRTR_SHIFT)
#define RBBM_DEBUG_GET_CLIENTS_FOR_NRT_RTR_FOR_HI(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_MASK) >> RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_SHIFT)
#define RBBM_DEBUG_GET_CLIENTS_FOR_NRT_RTR(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_MASK) >> RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_SHIFT)
#define RBBM_DEBUG_GET_IGNORE_SX_RBBM_BUSY(rbbm_debug) \
     ((rbbm_debug & RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_MASK) >> RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_SHIFT)

#define RBBM_DEBUG_SET_IGNORE_RTR(rbbm_debug_reg, ignore_rtr) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_IGNORE_RTR_MASK) | (ignore_rtr << RBBM_DEBUG_IGNORE_RTR_SHIFT)
#define RBBM_DEBUG_SET_IGNORE_CP_SCHED_WU(rbbm_debug_reg, ignore_cp_sched_wu) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_IGNORE_CP_SCHED_WU_MASK) | (ignore_cp_sched_wu << RBBM_DEBUG_IGNORE_CP_SCHED_WU_SHIFT)
#define RBBM_DEBUG_SET_IGNORE_CP_SCHED_ISYNC(rbbm_debug_reg, ignore_cp_sched_isync) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_MASK) | (ignore_cp_sched_isync << RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_SHIFT)
#define RBBM_DEBUG_SET_IGNORE_CP_SCHED_NQ_HI(rbbm_debug_reg, ignore_cp_sched_nq_hi) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_MASK) | (ignore_cp_sched_nq_hi << RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_SHIFT)
#define RBBM_DEBUG_SET_HYSTERESIS_NRT_GUI_ACTIVE(rbbm_debug_reg, hysteresis_nrt_gui_active) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_MASK) | (hysteresis_nrt_gui_active << RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_SHIFT)
#define RBBM_DEBUG_SET_IGNORE_RTR_FOR_HI(rbbm_debug_reg, ignore_rtr_for_hi) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_IGNORE_RTR_FOR_HI_MASK) | (ignore_rtr_for_hi << RBBM_DEBUG_IGNORE_RTR_FOR_HI_SHIFT)
#define RBBM_DEBUG_SET_IGNORE_CP_RBBM_NRTRTR_FOR_HI(rbbm_debug_reg, ignore_cp_rbbm_nrtrtr_for_hi) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_MASK) | (ignore_cp_rbbm_nrtrtr_for_hi << RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_SHIFT)
#define RBBM_DEBUG_SET_IGNORE_VGT_RBBM_NRTRTR_FOR_HI(rbbm_debug_reg, ignore_vgt_rbbm_nrtrtr_for_hi) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_MASK) | (ignore_vgt_rbbm_nrtrtr_for_hi << RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_SHIFT)
#define RBBM_DEBUG_SET_IGNORE_SQ_RBBM_NRTRTR_FOR_HI(rbbm_debug_reg, ignore_sq_rbbm_nrtrtr_for_hi) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_MASK) | (ignore_sq_rbbm_nrtrtr_for_hi << RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_SHIFT)
#define RBBM_DEBUG_SET_CP_RBBM_NRTRTR(rbbm_debug_reg, cp_rbbm_nrtrtr) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_CP_RBBM_NRTRTR_MASK) | (cp_rbbm_nrtrtr << RBBM_DEBUG_CP_RBBM_NRTRTR_SHIFT)
#define RBBM_DEBUG_SET_VGT_RBBM_NRTRTR(rbbm_debug_reg, vgt_rbbm_nrtrtr) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_VGT_RBBM_NRTRTR_MASK) | (vgt_rbbm_nrtrtr << RBBM_DEBUG_VGT_RBBM_NRTRTR_SHIFT)
#define RBBM_DEBUG_SET_SQ_RBBM_NRTRTR(rbbm_debug_reg, sq_rbbm_nrtrtr) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_SQ_RBBM_NRTRTR_MASK) | (sq_rbbm_nrtrtr << RBBM_DEBUG_SQ_RBBM_NRTRTR_SHIFT)
#define RBBM_DEBUG_SET_CLIENTS_FOR_NRT_RTR_FOR_HI(rbbm_debug_reg, clients_for_nrt_rtr_for_hi) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_MASK) | (clients_for_nrt_rtr_for_hi << RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_SHIFT)
#define RBBM_DEBUG_SET_CLIENTS_FOR_NRT_RTR(rbbm_debug_reg, clients_for_nrt_rtr) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_MASK) | (clients_for_nrt_rtr << RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_SHIFT)
#define RBBM_DEBUG_SET_IGNORE_SX_RBBM_BUSY(rbbm_debug_reg, ignore_sx_rbbm_busy) \
     rbbm_debug_reg = (rbbm_debug_reg & ~RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_MASK) | (ignore_sx_rbbm_busy << RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_debug_t {
          unsigned int                                : 1;
          unsigned int ignore_rtr                     : RBBM_DEBUG_IGNORE_RTR_SIZE;
          unsigned int ignore_cp_sched_wu             : RBBM_DEBUG_IGNORE_CP_SCHED_WU_SIZE;
          unsigned int ignore_cp_sched_isync          : RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_SIZE;
          unsigned int ignore_cp_sched_nq_hi          : RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_SIZE;
          unsigned int                                : 3;
          unsigned int hysteresis_nrt_gui_active      : RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_SIZE;
          unsigned int                                : 4;
          unsigned int ignore_rtr_for_hi              : RBBM_DEBUG_IGNORE_RTR_FOR_HI_SIZE;
          unsigned int ignore_cp_rbbm_nrtrtr_for_hi   : RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_SIZE;
          unsigned int ignore_vgt_rbbm_nrtrtr_for_hi  : RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_SIZE;
          unsigned int ignore_sq_rbbm_nrtrtr_for_hi   : RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_SIZE;
          unsigned int cp_rbbm_nrtrtr                 : RBBM_DEBUG_CP_RBBM_NRTRTR_SIZE;
          unsigned int vgt_rbbm_nrtrtr                : RBBM_DEBUG_VGT_RBBM_NRTRTR_SIZE;
          unsigned int sq_rbbm_nrtrtr                 : RBBM_DEBUG_SQ_RBBM_NRTRTR_SIZE;
          unsigned int clients_for_nrt_rtr_for_hi     : RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_SIZE;
          unsigned int clients_for_nrt_rtr            : RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_SIZE;
          unsigned int                                : 6;
          unsigned int ignore_sx_rbbm_busy            : RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_SIZE;
     } rbbm_debug_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_debug_t {
          unsigned int ignore_sx_rbbm_busy            : RBBM_DEBUG_IGNORE_SX_RBBM_BUSY_SIZE;
          unsigned int                                : 6;
          unsigned int clients_for_nrt_rtr            : RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_SIZE;
          unsigned int clients_for_nrt_rtr_for_hi     : RBBM_DEBUG_CLIENTS_FOR_NRT_RTR_FOR_HI_SIZE;
          unsigned int sq_rbbm_nrtrtr                 : RBBM_DEBUG_SQ_RBBM_NRTRTR_SIZE;
          unsigned int vgt_rbbm_nrtrtr                : RBBM_DEBUG_VGT_RBBM_NRTRTR_SIZE;
          unsigned int cp_rbbm_nrtrtr                 : RBBM_DEBUG_CP_RBBM_NRTRTR_SIZE;
          unsigned int ignore_sq_rbbm_nrtrtr_for_hi   : RBBM_DEBUG_IGNORE_SQ_RBBM_NRTRTR_FOR_HI_SIZE;
          unsigned int ignore_vgt_rbbm_nrtrtr_for_hi  : RBBM_DEBUG_IGNORE_VGT_RBBM_NRTRTR_FOR_HI_SIZE;
          unsigned int ignore_cp_rbbm_nrtrtr_for_hi   : RBBM_DEBUG_IGNORE_CP_RBBM_NRTRTR_FOR_HI_SIZE;
          unsigned int ignore_rtr_for_hi              : RBBM_DEBUG_IGNORE_RTR_FOR_HI_SIZE;
          unsigned int                                : 4;
          unsigned int hysteresis_nrt_gui_active      : RBBM_DEBUG_HYSTERESIS_NRT_GUI_ACTIVE_SIZE;
          unsigned int                                : 3;
          unsigned int ignore_cp_sched_nq_hi          : RBBM_DEBUG_IGNORE_CP_SCHED_NQ_HI_SIZE;
          unsigned int ignore_cp_sched_isync          : RBBM_DEBUG_IGNORE_CP_SCHED_ISYNC_SIZE;
          unsigned int ignore_cp_sched_wu             : RBBM_DEBUG_IGNORE_CP_SCHED_WU_SIZE;
          unsigned int ignore_rtr                     : RBBM_DEBUG_IGNORE_RTR_SIZE;
          unsigned int                                : 1;
     } rbbm_debug_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_debug_t f;
} rbbm_debug_u;


/*
 * RBBM_READ_ERROR struct
 */

#define RBBM_READ_ERROR_READ_ADDRESS_SIZE 15
#define RBBM_READ_ERROR_READ_REQUESTER_SIZE 1
#define RBBM_READ_ERROR_READ_ERROR_SIZE 1

#define RBBM_READ_ERROR_READ_ADDRESS_SHIFT 2
#define RBBM_READ_ERROR_READ_REQUESTER_SHIFT 30
#define RBBM_READ_ERROR_READ_ERROR_SHIFT 31

#define RBBM_READ_ERROR_READ_ADDRESS_MASK 0x0001fffc
#define RBBM_READ_ERROR_READ_REQUESTER_MASK 0x40000000
#define RBBM_READ_ERROR_READ_ERROR_MASK 0x80000000

#define RBBM_READ_ERROR_MASK \
     (RBBM_READ_ERROR_READ_ADDRESS_MASK | \
      RBBM_READ_ERROR_READ_REQUESTER_MASK | \
      RBBM_READ_ERROR_READ_ERROR_MASK)

#define RBBM_READ_ERROR(read_address, read_requester, read_error) \
     ((read_address << RBBM_READ_ERROR_READ_ADDRESS_SHIFT) | \
      (read_requester << RBBM_READ_ERROR_READ_REQUESTER_SHIFT) | \
      (read_error << RBBM_READ_ERROR_READ_ERROR_SHIFT))

#define RBBM_READ_ERROR_GET_READ_ADDRESS(rbbm_read_error) \
     ((rbbm_read_error & RBBM_READ_ERROR_READ_ADDRESS_MASK) >> RBBM_READ_ERROR_READ_ADDRESS_SHIFT)
#define RBBM_READ_ERROR_GET_READ_REQUESTER(rbbm_read_error) \
     ((rbbm_read_error & RBBM_READ_ERROR_READ_REQUESTER_MASK) >> RBBM_READ_ERROR_READ_REQUESTER_SHIFT)
#define RBBM_READ_ERROR_GET_READ_ERROR(rbbm_read_error) \
     ((rbbm_read_error & RBBM_READ_ERROR_READ_ERROR_MASK) >> RBBM_READ_ERROR_READ_ERROR_SHIFT)

#define RBBM_READ_ERROR_SET_READ_ADDRESS(rbbm_read_error_reg, read_address) \
     rbbm_read_error_reg = (rbbm_read_error_reg & ~RBBM_READ_ERROR_READ_ADDRESS_MASK) | (read_address << RBBM_READ_ERROR_READ_ADDRESS_SHIFT)
#define RBBM_READ_ERROR_SET_READ_REQUESTER(rbbm_read_error_reg, read_requester) \
     rbbm_read_error_reg = (rbbm_read_error_reg & ~RBBM_READ_ERROR_READ_REQUESTER_MASK) | (read_requester << RBBM_READ_ERROR_READ_REQUESTER_SHIFT)
#define RBBM_READ_ERROR_SET_READ_ERROR(rbbm_read_error_reg, read_error) \
     rbbm_read_error_reg = (rbbm_read_error_reg & ~RBBM_READ_ERROR_READ_ERROR_MASK) | (read_error << RBBM_READ_ERROR_READ_ERROR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_read_error_t {
          unsigned int                                : 2;
          unsigned int read_address                   : RBBM_READ_ERROR_READ_ADDRESS_SIZE;
          unsigned int                                : 13;
          unsigned int read_requester                 : RBBM_READ_ERROR_READ_REQUESTER_SIZE;
          unsigned int read_error                     : RBBM_READ_ERROR_READ_ERROR_SIZE;
     } rbbm_read_error_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_read_error_t {
          unsigned int read_error                     : RBBM_READ_ERROR_READ_ERROR_SIZE;
          unsigned int read_requester                 : RBBM_READ_ERROR_READ_REQUESTER_SIZE;
          unsigned int                                : 13;
          unsigned int read_address                   : RBBM_READ_ERROR_READ_ADDRESS_SIZE;
          unsigned int                                : 2;
     } rbbm_read_error_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_read_error_t f;
} rbbm_read_error_u;


/*
 * RBBM_WAIT_IDLE_CLOCKS struct
 */

#define RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_SIZE 8

#define RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_SHIFT 0

#define RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_MASK 0x000000ff

#define RBBM_WAIT_IDLE_CLOCKS_MASK \
     (RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_MASK)

#define RBBM_WAIT_IDLE_CLOCKS(wait_idle_clocks_nrt) \
     ((wait_idle_clocks_nrt << RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_SHIFT))

#define RBBM_WAIT_IDLE_CLOCKS_GET_WAIT_IDLE_CLOCKS_NRT(rbbm_wait_idle_clocks) \
     ((rbbm_wait_idle_clocks & RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_MASK) >> RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_SHIFT)

#define RBBM_WAIT_IDLE_CLOCKS_SET_WAIT_IDLE_CLOCKS_NRT(rbbm_wait_idle_clocks_reg, wait_idle_clocks_nrt) \
     rbbm_wait_idle_clocks_reg = (rbbm_wait_idle_clocks_reg & ~RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_MASK) | (wait_idle_clocks_nrt << RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_wait_idle_clocks_t {
          unsigned int wait_idle_clocks_nrt           : RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_SIZE;
          unsigned int                                : 24;
     } rbbm_wait_idle_clocks_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_wait_idle_clocks_t {
          unsigned int                                : 24;
          unsigned int wait_idle_clocks_nrt           : RBBM_WAIT_IDLE_CLOCKS_WAIT_IDLE_CLOCKS_NRT_SIZE;
     } rbbm_wait_idle_clocks_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_wait_idle_clocks_t f;
} rbbm_wait_idle_clocks_u;


/*
 * RBBM_INT_CNTL struct
 */

#define RBBM_INT_CNTL_RDERR_INT_MASK_SIZE 1
#define RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_SIZE 1
#define RBBM_INT_CNTL_GUI_IDLE_INT_MASK_SIZE 1

#define RBBM_INT_CNTL_RDERR_INT_MASK_SHIFT 0
#define RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_SHIFT 1
#define RBBM_INT_CNTL_GUI_IDLE_INT_MASK_SHIFT 19

#define RBBM_INT_CNTL_RDERR_INT_MASK_MASK 0x00000001
#define RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_MASK 0x00000002
#define RBBM_INT_CNTL_GUI_IDLE_INT_MASK_MASK 0x00080000

#define RBBM_INT_CNTL_MASK \
     (RBBM_INT_CNTL_RDERR_INT_MASK_MASK | \
      RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_MASK | \
      RBBM_INT_CNTL_GUI_IDLE_INT_MASK_MASK)

#define RBBM_INT_CNTL(rderr_int_mask, display_update_int_mask, gui_idle_int_mask) \
     ((rderr_int_mask << RBBM_INT_CNTL_RDERR_INT_MASK_SHIFT) | \
      (display_update_int_mask << RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_SHIFT) | \
      (gui_idle_int_mask << RBBM_INT_CNTL_GUI_IDLE_INT_MASK_SHIFT))

#define RBBM_INT_CNTL_GET_RDERR_INT_MASK(rbbm_int_cntl) \
     ((rbbm_int_cntl & RBBM_INT_CNTL_RDERR_INT_MASK_MASK) >> RBBM_INT_CNTL_RDERR_INT_MASK_SHIFT)
#define RBBM_INT_CNTL_GET_DISPLAY_UPDATE_INT_MASK(rbbm_int_cntl) \
     ((rbbm_int_cntl & RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_MASK) >> RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_SHIFT)
#define RBBM_INT_CNTL_GET_GUI_IDLE_INT_MASK(rbbm_int_cntl) \
     ((rbbm_int_cntl & RBBM_INT_CNTL_GUI_IDLE_INT_MASK_MASK) >> RBBM_INT_CNTL_GUI_IDLE_INT_MASK_SHIFT)

#define RBBM_INT_CNTL_SET_RDERR_INT_MASK(rbbm_int_cntl_reg, rderr_int_mask) \
     rbbm_int_cntl_reg = (rbbm_int_cntl_reg & ~RBBM_INT_CNTL_RDERR_INT_MASK_MASK) | (rderr_int_mask << RBBM_INT_CNTL_RDERR_INT_MASK_SHIFT)
#define RBBM_INT_CNTL_SET_DISPLAY_UPDATE_INT_MASK(rbbm_int_cntl_reg, display_update_int_mask) \
     rbbm_int_cntl_reg = (rbbm_int_cntl_reg & ~RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_MASK) | (display_update_int_mask << RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_SHIFT)
#define RBBM_INT_CNTL_SET_GUI_IDLE_INT_MASK(rbbm_int_cntl_reg, gui_idle_int_mask) \
     rbbm_int_cntl_reg = (rbbm_int_cntl_reg & ~RBBM_INT_CNTL_GUI_IDLE_INT_MASK_MASK) | (gui_idle_int_mask << RBBM_INT_CNTL_GUI_IDLE_INT_MASK_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_int_cntl_t {
          unsigned int rderr_int_mask                 : RBBM_INT_CNTL_RDERR_INT_MASK_SIZE;
          unsigned int display_update_int_mask        : RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_SIZE;
          unsigned int                                : 17;
          unsigned int gui_idle_int_mask              : RBBM_INT_CNTL_GUI_IDLE_INT_MASK_SIZE;
          unsigned int                                : 12;
     } rbbm_int_cntl_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_int_cntl_t {
          unsigned int                                : 12;
          unsigned int gui_idle_int_mask              : RBBM_INT_CNTL_GUI_IDLE_INT_MASK_SIZE;
          unsigned int                                : 17;
          unsigned int display_update_int_mask        : RBBM_INT_CNTL_DISPLAY_UPDATE_INT_MASK_SIZE;
          unsigned int rderr_int_mask                 : RBBM_INT_CNTL_RDERR_INT_MASK_SIZE;
     } rbbm_int_cntl_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_int_cntl_t f;
} rbbm_int_cntl_u;


/*
 * RBBM_INT_STATUS struct
 */

#define RBBM_INT_STATUS_RDERR_INT_STAT_SIZE 1
#define RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_SIZE 1
#define RBBM_INT_STATUS_GUI_IDLE_INT_STAT_SIZE 1

#define RBBM_INT_STATUS_RDERR_INT_STAT_SHIFT 0
#define RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_SHIFT 1
#define RBBM_INT_STATUS_GUI_IDLE_INT_STAT_SHIFT 19

#define RBBM_INT_STATUS_RDERR_INT_STAT_MASK 0x00000001
#define RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_MASK 0x00000002
#define RBBM_INT_STATUS_GUI_IDLE_INT_STAT_MASK 0x00080000

#define RBBM_INT_STATUS_MASK \
     (RBBM_INT_STATUS_RDERR_INT_STAT_MASK | \
      RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_MASK | \
      RBBM_INT_STATUS_GUI_IDLE_INT_STAT_MASK)

#define RBBM_INT_STATUS(rderr_int_stat, display_update_int_stat, gui_idle_int_stat) \
     ((rderr_int_stat << RBBM_INT_STATUS_RDERR_INT_STAT_SHIFT) | \
      (display_update_int_stat << RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_SHIFT) | \
      (gui_idle_int_stat << RBBM_INT_STATUS_GUI_IDLE_INT_STAT_SHIFT))

#define RBBM_INT_STATUS_GET_RDERR_INT_STAT(rbbm_int_status) \
     ((rbbm_int_status & RBBM_INT_STATUS_RDERR_INT_STAT_MASK) >> RBBM_INT_STATUS_RDERR_INT_STAT_SHIFT)
#define RBBM_INT_STATUS_GET_DISPLAY_UPDATE_INT_STAT(rbbm_int_status) \
     ((rbbm_int_status & RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_MASK) >> RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_SHIFT)
#define RBBM_INT_STATUS_GET_GUI_IDLE_INT_STAT(rbbm_int_status) \
     ((rbbm_int_status & RBBM_INT_STATUS_GUI_IDLE_INT_STAT_MASK) >> RBBM_INT_STATUS_GUI_IDLE_INT_STAT_SHIFT)

#define RBBM_INT_STATUS_SET_RDERR_INT_STAT(rbbm_int_status_reg, rderr_int_stat) \
     rbbm_int_status_reg = (rbbm_int_status_reg & ~RBBM_INT_STATUS_RDERR_INT_STAT_MASK) | (rderr_int_stat << RBBM_INT_STATUS_RDERR_INT_STAT_SHIFT)
#define RBBM_INT_STATUS_SET_DISPLAY_UPDATE_INT_STAT(rbbm_int_status_reg, display_update_int_stat) \
     rbbm_int_status_reg = (rbbm_int_status_reg & ~RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_MASK) | (display_update_int_stat << RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_SHIFT)
#define RBBM_INT_STATUS_SET_GUI_IDLE_INT_STAT(rbbm_int_status_reg, gui_idle_int_stat) \
     rbbm_int_status_reg = (rbbm_int_status_reg & ~RBBM_INT_STATUS_GUI_IDLE_INT_STAT_MASK) | (gui_idle_int_stat << RBBM_INT_STATUS_GUI_IDLE_INT_STAT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_int_status_t {
          unsigned int rderr_int_stat                 : RBBM_INT_STATUS_RDERR_INT_STAT_SIZE;
          unsigned int display_update_int_stat        : RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_SIZE;
          unsigned int                                : 17;
          unsigned int gui_idle_int_stat              : RBBM_INT_STATUS_GUI_IDLE_INT_STAT_SIZE;
          unsigned int                                : 12;
     } rbbm_int_status_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_int_status_t {
          unsigned int                                : 12;
          unsigned int gui_idle_int_stat              : RBBM_INT_STATUS_GUI_IDLE_INT_STAT_SIZE;
          unsigned int                                : 17;
          unsigned int display_update_int_stat        : RBBM_INT_STATUS_DISPLAY_UPDATE_INT_STAT_SIZE;
          unsigned int rderr_int_stat                 : RBBM_INT_STATUS_RDERR_INT_STAT_SIZE;
     } rbbm_int_status_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_int_status_t f;
} rbbm_int_status_u;


/*
 * RBBM_INT_ACK struct
 */

#define RBBM_INT_ACK_RDERR_INT_ACK_SIZE 1
#define RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_SIZE 1
#define RBBM_INT_ACK_GUI_IDLE_INT_ACK_SIZE 1

#define RBBM_INT_ACK_RDERR_INT_ACK_SHIFT 0
#define RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_SHIFT 1
#define RBBM_INT_ACK_GUI_IDLE_INT_ACK_SHIFT 19

#define RBBM_INT_ACK_RDERR_INT_ACK_MASK 0x00000001
#define RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_MASK 0x00000002
#define RBBM_INT_ACK_GUI_IDLE_INT_ACK_MASK 0x00080000

#define RBBM_INT_ACK_MASK \
     (RBBM_INT_ACK_RDERR_INT_ACK_MASK | \
      RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_MASK | \
      RBBM_INT_ACK_GUI_IDLE_INT_ACK_MASK)

#define RBBM_INT_ACK(rderr_int_ack, display_update_int_ack, gui_idle_int_ack) \
     ((rderr_int_ack << RBBM_INT_ACK_RDERR_INT_ACK_SHIFT) | \
      (display_update_int_ack << RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_SHIFT) | \
      (gui_idle_int_ack << RBBM_INT_ACK_GUI_IDLE_INT_ACK_SHIFT))

#define RBBM_INT_ACK_GET_RDERR_INT_ACK(rbbm_int_ack) \
     ((rbbm_int_ack & RBBM_INT_ACK_RDERR_INT_ACK_MASK) >> RBBM_INT_ACK_RDERR_INT_ACK_SHIFT)
#define RBBM_INT_ACK_GET_DISPLAY_UPDATE_INT_ACK(rbbm_int_ack) \
     ((rbbm_int_ack & RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_MASK) >> RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_SHIFT)
#define RBBM_INT_ACK_GET_GUI_IDLE_INT_ACK(rbbm_int_ack) \
     ((rbbm_int_ack & RBBM_INT_ACK_GUI_IDLE_INT_ACK_MASK) >> RBBM_INT_ACK_GUI_IDLE_INT_ACK_SHIFT)

#define RBBM_INT_ACK_SET_RDERR_INT_ACK(rbbm_int_ack_reg, rderr_int_ack) \
     rbbm_int_ack_reg = (rbbm_int_ack_reg & ~RBBM_INT_ACK_RDERR_INT_ACK_MASK) | (rderr_int_ack << RBBM_INT_ACK_RDERR_INT_ACK_SHIFT)
#define RBBM_INT_ACK_SET_DISPLAY_UPDATE_INT_ACK(rbbm_int_ack_reg, display_update_int_ack) \
     rbbm_int_ack_reg = (rbbm_int_ack_reg & ~RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_MASK) | (display_update_int_ack << RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_SHIFT)
#define RBBM_INT_ACK_SET_GUI_IDLE_INT_ACK(rbbm_int_ack_reg, gui_idle_int_ack) \
     rbbm_int_ack_reg = (rbbm_int_ack_reg & ~RBBM_INT_ACK_GUI_IDLE_INT_ACK_MASK) | (gui_idle_int_ack << RBBM_INT_ACK_GUI_IDLE_INT_ACK_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_int_ack_t {
          unsigned int rderr_int_ack                  : RBBM_INT_ACK_RDERR_INT_ACK_SIZE;
          unsigned int display_update_int_ack         : RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_SIZE;
          unsigned int                                : 17;
          unsigned int gui_idle_int_ack               : RBBM_INT_ACK_GUI_IDLE_INT_ACK_SIZE;
          unsigned int                                : 12;
     } rbbm_int_ack_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_int_ack_t {
          unsigned int                                : 12;
          unsigned int gui_idle_int_ack               : RBBM_INT_ACK_GUI_IDLE_INT_ACK_SIZE;
          unsigned int                                : 17;
          unsigned int display_update_int_ack         : RBBM_INT_ACK_DISPLAY_UPDATE_INT_ACK_SIZE;
          unsigned int rderr_int_ack                  : RBBM_INT_ACK_RDERR_INT_ACK_SIZE;
     } rbbm_int_ack_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_int_ack_t f;
} rbbm_int_ack_u;


/*
 * MASTER_INT_SIGNAL struct
 */

#define MASTER_INT_SIGNAL_MH_INT_STAT_SIZE 1
#define MASTER_INT_SIGNAL_SQ_INT_STAT_SIZE 1
#define MASTER_INT_SIGNAL_CP_INT_STAT_SIZE 1
#define MASTER_INT_SIGNAL_RBBM_INT_STAT_SIZE 1

#define MASTER_INT_SIGNAL_MH_INT_STAT_SHIFT 5
#define MASTER_INT_SIGNAL_SQ_INT_STAT_SHIFT 26
#define MASTER_INT_SIGNAL_CP_INT_STAT_SHIFT 30
#define MASTER_INT_SIGNAL_RBBM_INT_STAT_SHIFT 31

#define MASTER_INT_SIGNAL_MH_INT_STAT_MASK 0x00000020
#define MASTER_INT_SIGNAL_SQ_INT_STAT_MASK 0x04000000
#define MASTER_INT_SIGNAL_CP_INT_STAT_MASK 0x40000000
#define MASTER_INT_SIGNAL_RBBM_INT_STAT_MASK 0x80000000

#define MASTER_INT_SIGNAL_MASK \
     (MASTER_INT_SIGNAL_MH_INT_STAT_MASK | \
      MASTER_INT_SIGNAL_SQ_INT_STAT_MASK | \
      MASTER_INT_SIGNAL_CP_INT_STAT_MASK | \
      MASTER_INT_SIGNAL_RBBM_INT_STAT_MASK)

#define MASTER_INT_SIGNAL(mh_int_stat, sq_int_stat, cp_int_stat, rbbm_int_stat) \
     ((mh_int_stat << MASTER_INT_SIGNAL_MH_INT_STAT_SHIFT) | \
      (sq_int_stat << MASTER_INT_SIGNAL_SQ_INT_STAT_SHIFT) | \
      (cp_int_stat << MASTER_INT_SIGNAL_CP_INT_STAT_SHIFT) | \
      (rbbm_int_stat << MASTER_INT_SIGNAL_RBBM_INT_STAT_SHIFT))

#define MASTER_INT_SIGNAL_GET_MH_INT_STAT(master_int_signal) \
     ((master_int_signal & MASTER_INT_SIGNAL_MH_INT_STAT_MASK) >> MASTER_INT_SIGNAL_MH_INT_STAT_SHIFT)
#define MASTER_INT_SIGNAL_GET_SQ_INT_STAT(master_int_signal) \
     ((master_int_signal & MASTER_INT_SIGNAL_SQ_INT_STAT_MASK) >> MASTER_INT_SIGNAL_SQ_INT_STAT_SHIFT)
#define MASTER_INT_SIGNAL_GET_CP_INT_STAT(master_int_signal) \
     ((master_int_signal & MASTER_INT_SIGNAL_CP_INT_STAT_MASK) >> MASTER_INT_SIGNAL_CP_INT_STAT_SHIFT)
#define MASTER_INT_SIGNAL_GET_RBBM_INT_STAT(master_int_signal) \
     ((master_int_signal & MASTER_INT_SIGNAL_RBBM_INT_STAT_MASK) >> MASTER_INT_SIGNAL_RBBM_INT_STAT_SHIFT)

#define MASTER_INT_SIGNAL_SET_MH_INT_STAT(master_int_signal_reg, mh_int_stat) \
     master_int_signal_reg = (master_int_signal_reg & ~MASTER_INT_SIGNAL_MH_INT_STAT_MASK) | (mh_int_stat << MASTER_INT_SIGNAL_MH_INT_STAT_SHIFT)
#define MASTER_INT_SIGNAL_SET_SQ_INT_STAT(master_int_signal_reg, sq_int_stat) \
     master_int_signal_reg = (master_int_signal_reg & ~MASTER_INT_SIGNAL_SQ_INT_STAT_MASK) | (sq_int_stat << MASTER_INT_SIGNAL_SQ_INT_STAT_SHIFT)
#define MASTER_INT_SIGNAL_SET_CP_INT_STAT(master_int_signal_reg, cp_int_stat) \
     master_int_signal_reg = (master_int_signal_reg & ~MASTER_INT_SIGNAL_CP_INT_STAT_MASK) | (cp_int_stat << MASTER_INT_SIGNAL_CP_INT_STAT_SHIFT)
#define MASTER_INT_SIGNAL_SET_RBBM_INT_STAT(master_int_signal_reg, rbbm_int_stat) \
     master_int_signal_reg = (master_int_signal_reg & ~MASTER_INT_SIGNAL_RBBM_INT_STAT_MASK) | (rbbm_int_stat << MASTER_INT_SIGNAL_RBBM_INT_STAT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _master_int_signal_t {
          unsigned int                                : 5;
          unsigned int mh_int_stat                    : MASTER_INT_SIGNAL_MH_INT_STAT_SIZE;
          unsigned int                                : 20;
          unsigned int sq_int_stat                    : MASTER_INT_SIGNAL_SQ_INT_STAT_SIZE;
          unsigned int                                : 3;
          unsigned int cp_int_stat                    : MASTER_INT_SIGNAL_CP_INT_STAT_SIZE;
          unsigned int rbbm_int_stat                  : MASTER_INT_SIGNAL_RBBM_INT_STAT_SIZE;
     } master_int_signal_t;

#else   // !BIGENDIAN_OS

     typedef struct _master_int_signal_t {
          unsigned int rbbm_int_stat                  : MASTER_INT_SIGNAL_RBBM_INT_STAT_SIZE;
          unsigned int cp_int_stat                    : MASTER_INT_SIGNAL_CP_INT_STAT_SIZE;
          unsigned int                                : 3;
          unsigned int sq_int_stat                    : MASTER_INT_SIGNAL_SQ_INT_STAT_SIZE;
          unsigned int                                : 20;
          unsigned int mh_int_stat                    : MASTER_INT_SIGNAL_MH_INT_STAT_SIZE;
          unsigned int                                : 5;
     } master_int_signal_t;

#endif

typedef union {
     unsigned int val : 32;
     master_int_signal_t f;
} master_int_signal_u;


/*
 * RBBM_PERFCOUNTER1_SELECT struct
 */

#define RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_SIZE 6

#define RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_SHIFT 0

#define RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_MASK 0x0000003f

#define RBBM_PERFCOUNTER1_SELECT_MASK \
     (RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_MASK)

#define RBBM_PERFCOUNTER1_SELECT(perf_count1_sel) \
     ((perf_count1_sel << RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_SHIFT))

#define RBBM_PERFCOUNTER1_SELECT_GET_PERF_COUNT1_SEL(rbbm_perfcounter1_select) \
     ((rbbm_perfcounter1_select & RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_MASK) >> RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_SHIFT)

#define RBBM_PERFCOUNTER1_SELECT_SET_PERF_COUNT1_SEL(rbbm_perfcounter1_select_reg, perf_count1_sel) \
     rbbm_perfcounter1_select_reg = (rbbm_perfcounter1_select_reg & ~RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_MASK) | (perf_count1_sel << RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_perfcounter1_select_t {
          unsigned int perf_count1_sel                : RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_SIZE;
          unsigned int                                : 26;
     } rbbm_perfcounter1_select_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_perfcounter1_select_t {
          unsigned int                                : 26;
          unsigned int perf_count1_sel                : RBBM_PERFCOUNTER1_SELECT_PERF_COUNT1_SEL_SIZE;
     } rbbm_perfcounter1_select_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_perfcounter1_select_t f;
} rbbm_perfcounter1_select_u;


/*
 * RBBM_PERFCOUNTER1_LO struct
 */

#define RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_SIZE 32

#define RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_SHIFT 0

#define RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_MASK 0xffffffff

#define RBBM_PERFCOUNTER1_LO_MASK \
     (RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_MASK)

#define RBBM_PERFCOUNTER1_LO(perf_count1_lo) \
     ((perf_count1_lo << RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_SHIFT))

#define RBBM_PERFCOUNTER1_LO_GET_PERF_COUNT1_LO(rbbm_perfcounter1_lo) \
     ((rbbm_perfcounter1_lo & RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_MASK) >> RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_SHIFT)

#define RBBM_PERFCOUNTER1_LO_SET_PERF_COUNT1_LO(rbbm_perfcounter1_lo_reg, perf_count1_lo) \
     rbbm_perfcounter1_lo_reg = (rbbm_perfcounter1_lo_reg & ~RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_MASK) | (perf_count1_lo << RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_perfcounter1_lo_t {
          unsigned int perf_count1_lo                 : RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_SIZE;
     } rbbm_perfcounter1_lo_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_perfcounter1_lo_t {
          unsigned int perf_count1_lo                 : RBBM_PERFCOUNTER1_LO_PERF_COUNT1_LO_SIZE;
     } rbbm_perfcounter1_lo_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_perfcounter1_lo_t f;
} rbbm_perfcounter1_lo_u;


/*
 * RBBM_PERFCOUNTER1_HI struct
 */

#define RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_SIZE 16

#define RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_SHIFT 0

#define RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_MASK 0x0000ffff

#define RBBM_PERFCOUNTER1_HI_MASK \
     (RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_MASK)

#define RBBM_PERFCOUNTER1_HI(perf_count1_hi) \
     ((perf_count1_hi << RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_SHIFT))

#define RBBM_PERFCOUNTER1_HI_GET_PERF_COUNT1_HI(rbbm_perfcounter1_hi) \
     ((rbbm_perfcounter1_hi & RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_MASK) >> RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_SHIFT)

#define RBBM_PERFCOUNTER1_HI_SET_PERF_COUNT1_HI(rbbm_perfcounter1_hi_reg, perf_count1_hi) \
     rbbm_perfcounter1_hi_reg = (rbbm_perfcounter1_hi_reg & ~RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_MASK) | (perf_count1_hi << RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _rbbm_perfcounter1_hi_t {
          unsigned int perf_count1_hi                 : RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_SIZE;
          unsigned int                                : 16;
     } rbbm_perfcounter1_hi_t;

#else   // !BIGENDIAN_OS

     typedef struct _rbbm_perfcounter1_hi_t {
          unsigned int                                : 16;
          unsigned int perf_count1_hi                 : RBBM_PERFCOUNTER1_HI_PERF_COUNT1_HI_SIZE;
     } rbbm_perfcounter1_hi_t;

#endif

typedef union {
     unsigned int val : 32;
     rbbm_perfcounter1_hi_t f;
} rbbm_perfcounter1_hi_u;


#endif


#if !defined (_MH_FIDDLE_H)
#define _MH_FIDDLE_H

/*****************************************************************************************************************
 *
 *  mh_reg.h
 *
 *  Register Spec Release:  Block Spec 1.0
 *
 *   (c) 2000 ATI Technologies Inc.  (unpublished)
 *
 *   All rights reserved.  This notice is intended as a precaution against
 *   inadvertent publication and does not imply publication or any waiver
 *   of confidentiality.  The year included in the foregoing notice is the
 *   year of creation of the work.
 *
 *****************************************************************************************************************/

/*******************************************************
 * Enums
 *******************************************************/


/*******************************************************
 * Values
 *******************************************************/


/*******************************************************
 * Structures
 *******************************************************/

/*
 * MH_ARBITER_CONFIG struct
 */

#define MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_SIZE 6
#define MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_SIZE 1
#define MH_ARBITER_CONFIG_L1_ARB_ENABLE_SIZE 1
#define MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_SIZE 1
#define MH_ARBITER_CONFIG_L2_ARB_CONTROL_SIZE 1
#define MH_ARBITER_CONFIG_PAGE_SIZE_SIZE 3
#define MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SIZE 1
#define MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_SIZE 1
#define MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_SIZE 1
#define MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_SIZE 6
#define MH_ARBITER_CONFIG_CP_CLNT_ENABLE_SIZE 1
#define MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_SIZE 1
#define MH_ARBITER_CONFIG_TC_CLNT_ENABLE_SIZE 1
#define MH_ARBITER_CONFIG_RB_CLNT_ENABLE_SIZE 1
#define MH_ARBITER_CONFIG_PA_CLNT_ENABLE_SIZE 1

#define MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_SHIFT 0
#define MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_SHIFT 6
#define MH_ARBITER_CONFIG_L1_ARB_ENABLE_SHIFT 7
#define MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_SHIFT 8
#define MH_ARBITER_CONFIG_L2_ARB_CONTROL_SHIFT 9
#define MH_ARBITER_CONFIG_PAGE_SIZE_SHIFT 10
#define MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SHIFT 13
#define MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_SHIFT 14
#define MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_SHIFT 15
#define MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_SHIFT 16
#define MH_ARBITER_CONFIG_CP_CLNT_ENABLE_SHIFT 22
#define MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_SHIFT 23
#define MH_ARBITER_CONFIG_TC_CLNT_ENABLE_SHIFT 24
#define MH_ARBITER_CONFIG_RB_CLNT_ENABLE_SHIFT 25
#define MH_ARBITER_CONFIG_PA_CLNT_ENABLE_SHIFT 26

#define MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_MASK 0x0000003f
#define MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_MASK 0x00000040
#define MH_ARBITER_CONFIG_L1_ARB_ENABLE_MASK 0x00000080
#define MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_MASK 0x00000100
#define MH_ARBITER_CONFIG_L2_ARB_CONTROL_MASK 0x00000200
#define MH_ARBITER_CONFIG_PAGE_SIZE_MASK 0x00001c00
#define MH_ARBITER_CONFIG_TC_REORDER_ENABLE_MASK 0x00002000
#define MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_MASK 0x00004000
#define MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_MASK 0x00008000
#define MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_MASK 0x003f0000
#define MH_ARBITER_CONFIG_CP_CLNT_ENABLE_MASK 0x00400000
#define MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_MASK 0x00800000
#define MH_ARBITER_CONFIG_TC_CLNT_ENABLE_MASK 0x01000000
#define MH_ARBITER_CONFIG_RB_CLNT_ENABLE_MASK 0x02000000
#define MH_ARBITER_CONFIG_PA_CLNT_ENABLE_MASK 0x04000000

#define MH_ARBITER_CONFIG_MASK \
     (MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_MASK | \
      MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_MASK | \
      MH_ARBITER_CONFIG_L1_ARB_ENABLE_MASK | \
      MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_MASK | \
      MH_ARBITER_CONFIG_L2_ARB_CONTROL_MASK | \
      MH_ARBITER_CONFIG_PAGE_SIZE_MASK | \
      MH_ARBITER_CONFIG_TC_REORDER_ENABLE_MASK | \
      MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_MASK | \
      MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_MASK | \
      MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_MASK | \
      MH_ARBITER_CONFIG_CP_CLNT_ENABLE_MASK | \
      MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_MASK | \
      MH_ARBITER_CONFIG_TC_CLNT_ENABLE_MASK | \
      MH_ARBITER_CONFIG_RB_CLNT_ENABLE_MASK | \
      MH_ARBITER_CONFIG_PA_CLNT_ENABLE_MASK)

#define MH_ARBITER_CONFIG(same_page_limit, same_page_granularity, l1_arb_enable, l1_arb_hold_enable, l2_arb_control, page_size, tc_reorder_enable, tc_arb_hold_enable, in_flight_limit_enable, in_flight_limit, cp_clnt_enable, vgt_clnt_enable, tc_clnt_enable, rb_clnt_enable, pa_clnt_enable) \
     ((same_page_limit << MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_SHIFT) | \
      (same_page_granularity << MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_SHIFT) | \
      (l1_arb_enable << MH_ARBITER_CONFIG_L1_ARB_ENABLE_SHIFT) | \
      (l1_arb_hold_enable << MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_SHIFT) | \
      (l2_arb_control << MH_ARBITER_CONFIG_L2_ARB_CONTROL_SHIFT) | \
      (page_size << MH_ARBITER_CONFIG_PAGE_SIZE_SHIFT) | \
      (tc_reorder_enable << MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SHIFT) | \
      (tc_arb_hold_enable << MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_SHIFT) | \
      (in_flight_limit_enable << MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_SHIFT) | \
      (in_flight_limit << MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_SHIFT) | \
      (cp_clnt_enable << MH_ARBITER_CONFIG_CP_CLNT_ENABLE_SHIFT) | \
      (vgt_clnt_enable << MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_SHIFT) | \
      (tc_clnt_enable << MH_ARBITER_CONFIG_TC_CLNT_ENABLE_SHIFT) | \
      (rb_clnt_enable << MH_ARBITER_CONFIG_RB_CLNT_ENABLE_SHIFT) | \
      (pa_clnt_enable << MH_ARBITER_CONFIG_PA_CLNT_ENABLE_SHIFT))

#define MH_ARBITER_CONFIG_GET_SAME_PAGE_LIMIT(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_MASK) >> MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_SHIFT)
#define MH_ARBITER_CONFIG_GET_SAME_PAGE_GRANULARITY(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_MASK) >> MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_SHIFT)
#define MH_ARBITER_CONFIG_GET_L1_ARB_ENABLE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_L1_ARB_ENABLE_MASK) >> MH_ARBITER_CONFIG_L1_ARB_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_GET_L1_ARB_HOLD_ENABLE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_MASK) >> MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_GET_L2_ARB_CONTROL(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_L2_ARB_CONTROL_MASK) >> MH_ARBITER_CONFIG_L2_ARB_CONTROL_SHIFT)
#define MH_ARBITER_CONFIG_GET_PAGE_SIZE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_PAGE_SIZE_MASK) >> MH_ARBITER_CONFIG_PAGE_SIZE_SHIFT)
#define MH_ARBITER_CONFIG_GET_TC_REORDER_ENABLE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_TC_REORDER_ENABLE_MASK) >> MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_GET_TC_ARB_HOLD_ENABLE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_MASK) >> MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_GET_IN_FLIGHT_LIMIT_ENABLE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_MASK) >> MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_GET_IN_FLIGHT_LIMIT(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_MASK) >> MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_SHIFT)
#define MH_ARBITER_CONFIG_GET_CP_CLNT_ENABLE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_CP_CLNT_ENABLE_MASK) >> MH_ARBITER_CONFIG_CP_CLNT_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_GET_VGT_CLNT_ENABLE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_MASK) >> MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_GET_TC_CLNT_ENABLE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_TC_CLNT_ENABLE_MASK) >> MH_ARBITER_CONFIG_TC_CLNT_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_GET_RB_CLNT_ENABLE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_RB_CLNT_ENABLE_MASK) >> MH_ARBITER_CONFIG_RB_CLNT_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_GET_PA_CLNT_ENABLE(mh_arbiter_config) \
     ((mh_arbiter_config & MH_ARBITER_CONFIG_PA_CLNT_ENABLE_MASK) >> MH_ARBITER_CONFIG_PA_CLNT_ENABLE_SHIFT)

#define MH_ARBITER_CONFIG_SET_SAME_PAGE_LIMIT(mh_arbiter_config_reg, same_page_limit) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_MASK) | (same_page_limit << MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_SHIFT)
#define MH_ARBITER_CONFIG_SET_SAME_PAGE_GRANULARITY(mh_arbiter_config_reg, same_page_granularity) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_MASK) | (same_page_granularity << MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_SHIFT)
#define MH_ARBITER_CONFIG_SET_L1_ARB_ENABLE(mh_arbiter_config_reg, l1_arb_enable) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_L1_ARB_ENABLE_MASK) | (l1_arb_enable << MH_ARBITER_CONFIG_L1_ARB_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_SET_L1_ARB_HOLD_ENABLE(mh_arbiter_config_reg, l1_arb_hold_enable) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_MASK) | (l1_arb_hold_enable << MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_SET_L2_ARB_CONTROL(mh_arbiter_config_reg, l2_arb_control) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_L2_ARB_CONTROL_MASK) | (l2_arb_control << MH_ARBITER_CONFIG_L2_ARB_CONTROL_SHIFT)
#define MH_ARBITER_CONFIG_SET_PAGE_SIZE(mh_arbiter_config_reg, page_size) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_PAGE_SIZE_MASK) | (page_size << MH_ARBITER_CONFIG_PAGE_SIZE_SHIFT)
#define MH_ARBITER_CONFIG_SET_TC_REORDER_ENABLE(mh_arbiter_config_reg, tc_reorder_enable) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_TC_REORDER_ENABLE_MASK) | (tc_reorder_enable << MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_SET_TC_ARB_HOLD_ENABLE(mh_arbiter_config_reg, tc_arb_hold_enable) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_MASK) | (tc_arb_hold_enable << MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_SET_IN_FLIGHT_LIMIT_ENABLE(mh_arbiter_config_reg, in_flight_limit_enable) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_MASK) | (in_flight_limit_enable << MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_SET_IN_FLIGHT_LIMIT(mh_arbiter_config_reg, in_flight_limit) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_MASK) | (in_flight_limit << MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_SHIFT)
#define MH_ARBITER_CONFIG_SET_CP_CLNT_ENABLE(mh_arbiter_config_reg, cp_clnt_enable) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_CP_CLNT_ENABLE_MASK) | (cp_clnt_enable << MH_ARBITER_CONFIG_CP_CLNT_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_SET_VGT_CLNT_ENABLE(mh_arbiter_config_reg, vgt_clnt_enable) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_MASK) | (vgt_clnt_enable << MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_SET_TC_CLNT_ENABLE(mh_arbiter_config_reg, tc_clnt_enable) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_TC_CLNT_ENABLE_MASK) | (tc_clnt_enable << MH_ARBITER_CONFIG_TC_CLNT_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_SET_RB_CLNT_ENABLE(mh_arbiter_config_reg, rb_clnt_enable) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_RB_CLNT_ENABLE_MASK) | (rb_clnt_enable << MH_ARBITER_CONFIG_RB_CLNT_ENABLE_SHIFT)
#define MH_ARBITER_CONFIG_SET_PA_CLNT_ENABLE(mh_arbiter_config_reg, pa_clnt_enable) \
     mh_arbiter_config_reg = (mh_arbiter_config_reg & ~MH_ARBITER_CONFIG_PA_CLNT_ENABLE_MASK) | (pa_clnt_enable << MH_ARBITER_CONFIG_PA_CLNT_ENABLE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_arbiter_config_t {
          unsigned int same_page_limit                : MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_SIZE;
          unsigned int same_page_granularity          : MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_SIZE;
          unsigned int l1_arb_enable                  : MH_ARBITER_CONFIG_L1_ARB_ENABLE_SIZE;
          unsigned int l1_arb_hold_enable             : MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_SIZE;
          unsigned int l2_arb_control                 : MH_ARBITER_CONFIG_L2_ARB_CONTROL_SIZE;
          unsigned int page_size                      : MH_ARBITER_CONFIG_PAGE_SIZE_SIZE;
          unsigned int tc_reorder_enable              : MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SIZE;
          unsigned int tc_arb_hold_enable             : MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_SIZE;
          unsigned int in_flight_limit_enable         : MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_SIZE;
          unsigned int in_flight_limit                : MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_SIZE;
          unsigned int cp_clnt_enable                 : MH_ARBITER_CONFIG_CP_CLNT_ENABLE_SIZE;
          unsigned int vgt_clnt_enable                : MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_SIZE;
          unsigned int tc_clnt_enable                 : MH_ARBITER_CONFIG_TC_CLNT_ENABLE_SIZE;
          unsigned int rb_clnt_enable                 : MH_ARBITER_CONFIG_RB_CLNT_ENABLE_SIZE;
          unsigned int pa_clnt_enable                 : MH_ARBITER_CONFIG_PA_CLNT_ENABLE_SIZE;
          unsigned int                                : 5;
     } mh_arbiter_config_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_arbiter_config_t {
          unsigned int                                : 5;
          unsigned int pa_clnt_enable                 : MH_ARBITER_CONFIG_PA_CLNT_ENABLE_SIZE;
          unsigned int rb_clnt_enable                 : MH_ARBITER_CONFIG_RB_CLNT_ENABLE_SIZE;
          unsigned int tc_clnt_enable                 : MH_ARBITER_CONFIG_TC_CLNT_ENABLE_SIZE;
          unsigned int vgt_clnt_enable                : MH_ARBITER_CONFIG_VGT_CLNT_ENABLE_SIZE;
          unsigned int cp_clnt_enable                 : MH_ARBITER_CONFIG_CP_CLNT_ENABLE_SIZE;
          unsigned int in_flight_limit                : MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_SIZE;
          unsigned int in_flight_limit_enable         : MH_ARBITER_CONFIG_IN_FLIGHT_LIMIT_ENABLE_SIZE;
          unsigned int tc_arb_hold_enable             : MH_ARBITER_CONFIG_TC_ARB_HOLD_ENABLE_SIZE;
          unsigned int tc_reorder_enable              : MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SIZE;
          unsigned int page_size                      : MH_ARBITER_CONFIG_PAGE_SIZE_SIZE;
          unsigned int l2_arb_control                 : MH_ARBITER_CONFIG_L2_ARB_CONTROL_SIZE;
          unsigned int l1_arb_hold_enable             : MH_ARBITER_CONFIG_L1_ARB_HOLD_ENABLE_SIZE;
          unsigned int l1_arb_enable                  : MH_ARBITER_CONFIG_L1_ARB_ENABLE_SIZE;
          unsigned int same_page_granularity          : MH_ARBITER_CONFIG_SAME_PAGE_GRANULARITY_SIZE;
          unsigned int same_page_limit                : MH_ARBITER_CONFIG_SAME_PAGE_LIMIT_SIZE;
     } mh_arbiter_config_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_arbiter_config_t f;
} mh_arbiter_config_u;


/*
 * MH_CLNT_AXI_ID_REUSE struct
 */

#define MH_CLNT_AXI_ID_REUSE_CPw_ID_SIZE 3
#define MH_CLNT_AXI_ID_REUSE_RESERVED1_SIZE 1
#define MH_CLNT_AXI_ID_REUSE_RBw_ID_SIZE 3
#define MH_CLNT_AXI_ID_REUSE_RESERVED2_SIZE 1
#define MH_CLNT_AXI_ID_REUSE_MMUr_ID_SIZE 3
#define MH_CLNT_AXI_ID_REUSE_RESERVED3_SIZE 1
#define MH_CLNT_AXI_ID_REUSE_PAw_ID_SIZE 3

#define MH_CLNT_AXI_ID_REUSE_CPw_ID_SHIFT 0
#define MH_CLNT_AXI_ID_REUSE_RESERVED1_SHIFT 3
#define MH_CLNT_AXI_ID_REUSE_RBw_ID_SHIFT 4
#define MH_CLNT_AXI_ID_REUSE_RESERVED2_SHIFT 7
#define MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT 8
#define MH_CLNT_AXI_ID_REUSE_RESERVED3_SHIFT 11
#define MH_CLNT_AXI_ID_REUSE_PAw_ID_SHIFT 12

#define MH_CLNT_AXI_ID_REUSE_CPw_ID_MASK 0x00000007
#define MH_CLNT_AXI_ID_REUSE_RESERVED1_MASK 0x00000008
#define MH_CLNT_AXI_ID_REUSE_RBw_ID_MASK 0x00000070
#define MH_CLNT_AXI_ID_REUSE_RESERVED2_MASK 0x00000080
#define MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK 0x00000700
#define MH_CLNT_AXI_ID_REUSE_RESERVED3_MASK 0x00000800
#define MH_CLNT_AXI_ID_REUSE_PAw_ID_MASK 0x00007000

#define MH_CLNT_AXI_ID_REUSE_MASK \
     (MH_CLNT_AXI_ID_REUSE_CPw_ID_MASK | \
      MH_CLNT_AXI_ID_REUSE_RESERVED1_MASK | \
      MH_CLNT_AXI_ID_REUSE_RBw_ID_MASK | \
      MH_CLNT_AXI_ID_REUSE_RESERVED2_MASK | \
      MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK | \
      MH_CLNT_AXI_ID_REUSE_RESERVED3_MASK | \
      MH_CLNT_AXI_ID_REUSE_PAw_ID_MASK)

#define MH_CLNT_AXI_ID_REUSE(cpw_id, reserved1, rbw_id, reserved2, mmur_id, reserved3, paw_id) \
     ((cpw_id << MH_CLNT_AXI_ID_REUSE_CPw_ID_SHIFT) | \
      (reserved1 << MH_CLNT_AXI_ID_REUSE_RESERVED1_SHIFT) | \
      (rbw_id << MH_CLNT_AXI_ID_REUSE_RBw_ID_SHIFT) | \
      (reserved2 << MH_CLNT_AXI_ID_REUSE_RESERVED2_SHIFT) | \
      (mmur_id << MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT) | \
      (reserved3 << MH_CLNT_AXI_ID_REUSE_RESERVED3_SHIFT) | \
      (paw_id << MH_CLNT_AXI_ID_REUSE_PAw_ID_SHIFT))

#define MH_CLNT_AXI_ID_REUSE_GET_CPw_ID(mh_clnt_axi_id_reuse) \
     ((mh_clnt_axi_id_reuse & MH_CLNT_AXI_ID_REUSE_CPw_ID_MASK) >> MH_CLNT_AXI_ID_REUSE_CPw_ID_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_GET_RESERVED1(mh_clnt_axi_id_reuse) \
     ((mh_clnt_axi_id_reuse & MH_CLNT_AXI_ID_REUSE_RESERVED1_MASK) >> MH_CLNT_AXI_ID_REUSE_RESERVED1_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_GET_RBw_ID(mh_clnt_axi_id_reuse) \
     ((mh_clnt_axi_id_reuse & MH_CLNT_AXI_ID_REUSE_RBw_ID_MASK) >> MH_CLNT_AXI_ID_REUSE_RBw_ID_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_GET_RESERVED2(mh_clnt_axi_id_reuse) \
     ((mh_clnt_axi_id_reuse & MH_CLNT_AXI_ID_REUSE_RESERVED2_MASK) >> MH_CLNT_AXI_ID_REUSE_RESERVED2_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_GET_MMUr_ID(mh_clnt_axi_id_reuse) \
     ((mh_clnt_axi_id_reuse & MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK) >> MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_GET_RESERVED3(mh_clnt_axi_id_reuse) \
     ((mh_clnt_axi_id_reuse & MH_CLNT_AXI_ID_REUSE_RESERVED3_MASK) >> MH_CLNT_AXI_ID_REUSE_RESERVED3_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_GET_PAw_ID(mh_clnt_axi_id_reuse) \
     ((mh_clnt_axi_id_reuse & MH_CLNT_AXI_ID_REUSE_PAw_ID_MASK) >> MH_CLNT_AXI_ID_REUSE_PAw_ID_SHIFT)

#define MH_CLNT_AXI_ID_REUSE_SET_CPw_ID(mh_clnt_axi_id_reuse_reg, cpw_id) \
     mh_clnt_axi_id_reuse_reg = (mh_clnt_axi_id_reuse_reg & ~MH_CLNT_AXI_ID_REUSE_CPw_ID_MASK) | (cpw_id << MH_CLNT_AXI_ID_REUSE_CPw_ID_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_SET_RESERVED1(mh_clnt_axi_id_reuse_reg, reserved1) \
     mh_clnt_axi_id_reuse_reg = (mh_clnt_axi_id_reuse_reg & ~MH_CLNT_AXI_ID_REUSE_RESERVED1_MASK) | (reserved1 << MH_CLNT_AXI_ID_REUSE_RESERVED1_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_SET_RBw_ID(mh_clnt_axi_id_reuse_reg, rbw_id) \
     mh_clnt_axi_id_reuse_reg = (mh_clnt_axi_id_reuse_reg & ~MH_CLNT_AXI_ID_REUSE_RBw_ID_MASK) | (rbw_id << MH_CLNT_AXI_ID_REUSE_RBw_ID_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_SET_RESERVED2(mh_clnt_axi_id_reuse_reg, reserved2) \
     mh_clnt_axi_id_reuse_reg = (mh_clnt_axi_id_reuse_reg & ~MH_CLNT_AXI_ID_REUSE_RESERVED2_MASK) | (reserved2 << MH_CLNT_AXI_ID_REUSE_RESERVED2_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_SET_MMUr_ID(mh_clnt_axi_id_reuse_reg, mmur_id) \
     mh_clnt_axi_id_reuse_reg = (mh_clnt_axi_id_reuse_reg & ~MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK) | (mmur_id << MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_SET_RESERVED3(mh_clnt_axi_id_reuse_reg, reserved3) \
     mh_clnt_axi_id_reuse_reg = (mh_clnt_axi_id_reuse_reg & ~MH_CLNT_AXI_ID_REUSE_RESERVED3_MASK) | (reserved3 << MH_CLNT_AXI_ID_REUSE_RESERVED3_SHIFT)
#define MH_CLNT_AXI_ID_REUSE_SET_PAw_ID(mh_clnt_axi_id_reuse_reg, paw_id) \
     mh_clnt_axi_id_reuse_reg = (mh_clnt_axi_id_reuse_reg & ~MH_CLNT_AXI_ID_REUSE_PAw_ID_MASK) | (paw_id << MH_CLNT_AXI_ID_REUSE_PAw_ID_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_clnt_axi_id_reuse_t {
          unsigned int cpw_id                         : MH_CLNT_AXI_ID_REUSE_CPw_ID_SIZE;
          unsigned int reserved1                      : MH_CLNT_AXI_ID_REUSE_RESERVED1_SIZE;
          unsigned int rbw_id                         : MH_CLNT_AXI_ID_REUSE_RBw_ID_SIZE;
          unsigned int reserved2                      : MH_CLNT_AXI_ID_REUSE_RESERVED2_SIZE;
          unsigned int mmur_id                        : MH_CLNT_AXI_ID_REUSE_MMUr_ID_SIZE;
          unsigned int reserved3                      : MH_CLNT_AXI_ID_REUSE_RESERVED3_SIZE;
          unsigned int paw_id                         : MH_CLNT_AXI_ID_REUSE_PAw_ID_SIZE;
          unsigned int                                : 17;
     } mh_clnt_axi_id_reuse_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_clnt_axi_id_reuse_t {
          unsigned int                                : 17;
          unsigned int paw_id                         : MH_CLNT_AXI_ID_REUSE_PAw_ID_SIZE;
          unsigned int reserved3                      : MH_CLNT_AXI_ID_REUSE_RESERVED3_SIZE;
          unsigned int mmur_id                        : MH_CLNT_AXI_ID_REUSE_MMUr_ID_SIZE;
          unsigned int reserved2                      : MH_CLNT_AXI_ID_REUSE_RESERVED2_SIZE;
          unsigned int rbw_id                         : MH_CLNT_AXI_ID_REUSE_RBw_ID_SIZE;
          unsigned int reserved1                      : MH_CLNT_AXI_ID_REUSE_RESERVED1_SIZE;
          unsigned int cpw_id                         : MH_CLNT_AXI_ID_REUSE_CPw_ID_SIZE;
     } mh_clnt_axi_id_reuse_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_clnt_axi_id_reuse_t f;
} mh_clnt_axi_id_reuse_u;


/*
 * MH_INTERRUPT_MASK struct
 */

#define MH_INTERRUPT_MASK_AXI_READ_ERROR_SIZE 1
#define MH_INTERRUPT_MASK_AXI_WRITE_ERROR_SIZE 1
#define MH_INTERRUPT_MASK_MMU_PAGE_FAULT_SIZE 1

#define MH_INTERRUPT_MASK_AXI_READ_ERROR_SHIFT 0
#define MH_INTERRUPT_MASK_AXI_WRITE_ERROR_SHIFT 1
#define MH_INTERRUPT_MASK_MMU_PAGE_FAULT_SHIFT 2

#define MH_INTERRUPT_MASK_AXI_READ_ERROR_MASK 0x00000001
#define MH_INTERRUPT_MASK_AXI_WRITE_ERROR_MASK 0x00000002
#define MH_INTERRUPT_MASK_MMU_PAGE_FAULT_MASK 0x00000004

#define MH_INTERRUPT_MASK_MASK \
     (MH_INTERRUPT_MASK_AXI_READ_ERROR_MASK | \
      MH_INTERRUPT_MASK_AXI_WRITE_ERROR_MASK | \
      MH_INTERRUPT_MASK_MMU_PAGE_FAULT_MASK)

#define MH_INTERRUPT_MASK(axi_read_error, axi_write_error, mmu_page_fault) \
     ((axi_read_error << MH_INTERRUPT_MASK_AXI_READ_ERROR_SHIFT) | \
      (axi_write_error << MH_INTERRUPT_MASK_AXI_WRITE_ERROR_SHIFT) | \
      (mmu_page_fault << MH_INTERRUPT_MASK_MMU_PAGE_FAULT_SHIFT))

#define MH_INTERRUPT_MASK_GET_AXI_READ_ERROR(mh_interrupt_mask) \
     ((mh_interrupt_mask & MH_INTERRUPT_MASK_AXI_READ_ERROR_MASK) >> MH_INTERRUPT_MASK_AXI_READ_ERROR_SHIFT)
#define MH_INTERRUPT_MASK_GET_AXI_WRITE_ERROR(mh_interrupt_mask) \
     ((mh_interrupt_mask & MH_INTERRUPT_MASK_AXI_WRITE_ERROR_MASK) >> MH_INTERRUPT_MASK_AXI_WRITE_ERROR_SHIFT)
#define MH_INTERRUPT_MASK_GET_MMU_PAGE_FAULT(mh_interrupt_mask) \
     ((mh_interrupt_mask & MH_INTERRUPT_MASK_MMU_PAGE_FAULT_MASK) >> MH_INTERRUPT_MASK_MMU_PAGE_FAULT_SHIFT)

#define MH_INTERRUPT_MASK_SET_AXI_READ_ERROR(mh_interrupt_mask_reg, axi_read_error) \
     mh_interrupt_mask_reg = (mh_interrupt_mask_reg & ~MH_INTERRUPT_MASK_AXI_READ_ERROR_MASK) | (axi_read_error << MH_INTERRUPT_MASK_AXI_READ_ERROR_SHIFT)
#define MH_INTERRUPT_MASK_SET_AXI_WRITE_ERROR(mh_interrupt_mask_reg, axi_write_error) \
     mh_interrupt_mask_reg = (mh_interrupt_mask_reg & ~MH_INTERRUPT_MASK_AXI_WRITE_ERROR_MASK) | (axi_write_error << MH_INTERRUPT_MASK_AXI_WRITE_ERROR_SHIFT)
#define MH_INTERRUPT_MASK_SET_MMU_PAGE_FAULT(mh_interrupt_mask_reg, mmu_page_fault) \
     mh_interrupt_mask_reg = (mh_interrupt_mask_reg & ~MH_INTERRUPT_MASK_MMU_PAGE_FAULT_MASK) | (mmu_page_fault << MH_INTERRUPT_MASK_MMU_PAGE_FAULT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_interrupt_mask_t {
          unsigned int axi_read_error                 : MH_INTERRUPT_MASK_AXI_READ_ERROR_SIZE;
          unsigned int axi_write_error                : MH_INTERRUPT_MASK_AXI_WRITE_ERROR_SIZE;
          unsigned int mmu_page_fault                 : MH_INTERRUPT_MASK_MMU_PAGE_FAULT_SIZE;
          unsigned int                                : 29;
     } mh_interrupt_mask_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_interrupt_mask_t {
          unsigned int                                : 29;
          unsigned int mmu_page_fault                 : MH_INTERRUPT_MASK_MMU_PAGE_FAULT_SIZE;
          unsigned int axi_write_error                : MH_INTERRUPT_MASK_AXI_WRITE_ERROR_SIZE;
          unsigned int axi_read_error                 : MH_INTERRUPT_MASK_AXI_READ_ERROR_SIZE;
     } mh_interrupt_mask_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_interrupt_mask_t f;
} mh_interrupt_mask_u;


/*
 * MH_INTERRUPT_STATUS struct
 */

#define MH_INTERRUPT_STATUS_AXI_READ_ERROR_SIZE 1
#define MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_SIZE 1
#define MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_SIZE 1

#define MH_INTERRUPT_STATUS_AXI_READ_ERROR_SHIFT 0
#define MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_SHIFT 1
#define MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_SHIFT 2

#define MH_INTERRUPT_STATUS_AXI_READ_ERROR_MASK 0x00000001
#define MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_MASK 0x00000002
#define MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_MASK 0x00000004

#define MH_INTERRUPT_STATUS_MASK \
     (MH_INTERRUPT_STATUS_AXI_READ_ERROR_MASK | \
      MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_MASK | \
      MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_MASK)

#define MH_INTERRUPT_STATUS(axi_read_error, axi_write_error, mmu_page_fault) \
     ((axi_read_error << MH_INTERRUPT_STATUS_AXI_READ_ERROR_SHIFT) | \
      (axi_write_error << MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_SHIFT) | \
      (mmu_page_fault << MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_SHIFT))

#define MH_INTERRUPT_STATUS_GET_AXI_READ_ERROR(mh_interrupt_status) \
     ((mh_interrupt_status & MH_INTERRUPT_STATUS_AXI_READ_ERROR_MASK) >> MH_INTERRUPT_STATUS_AXI_READ_ERROR_SHIFT)
#define MH_INTERRUPT_STATUS_GET_AXI_WRITE_ERROR(mh_interrupt_status) \
     ((mh_interrupt_status & MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_MASK) >> MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_SHIFT)
#define MH_INTERRUPT_STATUS_GET_MMU_PAGE_FAULT(mh_interrupt_status) \
     ((mh_interrupt_status & MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_MASK) >> MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_SHIFT)

#define MH_INTERRUPT_STATUS_SET_AXI_READ_ERROR(mh_interrupt_status_reg, axi_read_error) \
     mh_interrupt_status_reg = (mh_interrupt_status_reg & ~MH_INTERRUPT_STATUS_AXI_READ_ERROR_MASK) | (axi_read_error << MH_INTERRUPT_STATUS_AXI_READ_ERROR_SHIFT)
#define MH_INTERRUPT_STATUS_SET_AXI_WRITE_ERROR(mh_interrupt_status_reg, axi_write_error) \
     mh_interrupt_status_reg = (mh_interrupt_status_reg & ~MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_MASK) | (axi_write_error << MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_SHIFT)
#define MH_INTERRUPT_STATUS_SET_MMU_PAGE_FAULT(mh_interrupt_status_reg, mmu_page_fault) \
     mh_interrupt_status_reg = (mh_interrupt_status_reg & ~MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_MASK) | (mmu_page_fault << MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_interrupt_status_t {
          unsigned int axi_read_error                 : MH_INTERRUPT_STATUS_AXI_READ_ERROR_SIZE;
          unsigned int axi_write_error                : MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_SIZE;
          unsigned int mmu_page_fault                 : MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_SIZE;
          unsigned int                                : 29;
     } mh_interrupt_status_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_interrupt_status_t {
          unsigned int                                : 29;
          unsigned int mmu_page_fault                 : MH_INTERRUPT_STATUS_MMU_PAGE_FAULT_SIZE;
          unsigned int axi_write_error                : MH_INTERRUPT_STATUS_AXI_WRITE_ERROR_SIZE;
          unsigned int axi_read_error                 : MH_INTERRUPT_STATUS_AXI_READ_ERROR_SIZE;
     } mh_interrupt_status_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_interrupt_status_t f;
} mh_interrupt_status_u;


/*
 * MH_INTERRUPT_CLEAR struct
 */

#define MH_INTERRUPT_CLEAR_AXI_READ_ERROR_SIZE 1
#define MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_SIZE 1
#define MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_SIZE 1

#define MH_INTERRUPT_CLEAR_AXI_READ_ERROR_SHIFT 0
#define MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_SHIFT 1
#define MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_SHIFT 2

#define MH_INTERRUPT_CLEAR_AXI_READ_ERROR_MASK 0x00000001
#define MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_MASK 0x00000002
#define MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_MASK 0x00000004

#define MH_INTERRUPT_CLEAR_MASK \
     (MH_INTERRUPT_CLEAR_AXI_READ_ERROR_MASK | \
      MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_MASK | \
      MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_MASK)

#define MH_INTERRUPT_CLEAR(axi_read_error, axi_write_error, mmu_page_fault) \
     ((axi_read_error << MH_INTERRUPT_CLEAR_AXI_READ_ERROR_SHIFT) | \
      (axi_write_error << MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_SHIFT) | \
      (mmu_page_fault << MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_SHIFT))

#define MH_INTERRUPT_CLEAR_GET_AXI_READ_ERROR(mh_interrupt_clear) \
     ((mh_interrupt_clear & MH_INTERRUPT_CLEAR_AXI_READ_ERROR_MASK) >> MH_INTERRUPT_CLEAR_AXI_READ_ERROR_SHIFT)
#define MH_INTERRUPT_CLEAR_GET_AXI_WRITE_ERROR(mh_interrupt_clear) \
     ((mh_interrupt_clear & MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_MASK) >> MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_SHIFT)
#define MH_INTERRUPT_CLEAR_GET_MMU_PAGE_FAULT(mh_interrupt_clear) \
     ((mh_interrupt_clear & MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_MASK) >> MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_SHIFT)

#define MH_INTERRUPT_CLEAR_SET_AXI_READ_ERROR(mh_interrupt_clear_reg, axi_read_error) \
     mh_interrupt_clear_reg = (mh_interrupt_clear_reg & ~MH_INTERRUPT_CLEAR_AXI_READ_ERROR_MASK) | (axi_read_error << MH_INTERRUPT_CLEAR_AXI_READ_ERROR_SHIFT)
#define MH_INTERRUPT_CLEAR_SET_AXI_WRITE_ERROR(mh_interrupt_clear_reg, axi_write_error) \
     mh_interrupt_clear_reg = (mh_interrupt_clear_reg & ~MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_MASK) | (axi_write_error << MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_SHIFT)
#define MH_INTERRUPT_CLEAR_SET_MMU_PAGE_FAULT(mh_interrupt_clear_reg, mmu_page_fault) \
     mh_interrupt_clear_reg = (mh_interrupt_clear_reg & ~MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_MASK) | (mmu_page_fault << MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_interrupt_clear_t {
          unsigned int axi_read_error                 : MH_INTERRUPT_CLEAR_AXI_READ_ERROR_SIZE;
          unsigned int axi_write_error                : MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_SIZE;
          unsigned int mmu_page_fault                 : MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_SIZE;
          unsigned int                                : 29;
     } mh_interrupt_clear_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_interrupt_clear_t {
          unsigned int                                : 29;
          unsigned int mmu_page_fault                 : MH_INTERRUPT_CLEAR_MMU_PAGE_FAULT_SIZE;
          unsigned int axi_write_error                : MH_INTERRUPT_CLEAR_AXI_WRITE_ERROR_SIZE;
          unsigned int axi_read_error                 : MH_INTERRUPT_CLEAR_AXI_READ_ERROR_SIZE;
     } mh_interrupt_clear_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_interrupt_clear_t f;
} mh_interrupt_clear_u;


/*
 * MH_AXI_ERROR struct
 */

#define MH_AXI_ERROR_AXI_READ_ID_SIZE  3
#define MH_AXI_ERROR_AXI_READ_ERROR_SIZE 1
#define MH_AXI_ERROR_AXI_WRITE_ID_SIZE 3
#define MH_AXI_ERROR_AXI_WRITE_ERROR_SIZE 1

#define MH_AXI_ERROR_AXI_READ_ID_SHIFT 0
#define MH_AXI_ERROR_AXI_READ_ERROR_SHIFT 3
#define MH_AXI_ERROR_AXI_WRITE_ID_SHIFT 4
#define MH_AXI_ERROR_AXI_WRITE_ERROR_SHIFT 7

#define MH_AXI_ERROR_AXI_READ_ID_MASK  0x00000007
#define MH_AXI_ERROR_AXI_READ_ERROR_MASK 0x00000008
#define MH_AXI_ERROR_AXI_WRITE_ID_MASK 0x00000070
#define MH_AXI_ERROR_AXI_WRITE_ERROR_MASK 0x00000080

#define MH_AXI_ERROR_MASK \
     (MH_AXI_ERROR_AXI_READ_ID_MASK | \
      MH_AXI_ERROR_AXI_READ_ERROR_MASK | \
      MH_AXI_ERROR_AXI_WRITE_ID_MASK | \
      MH_AXI_ERROR_AXI_WRITE_ERROR_MASK)

#define MH_AXI_ERROR(axi_read_id, axi_read_error, axi_write_id, axi_write_error) \
     ((axi_read_id << MH_AXI_ERROR_AXI_READ_ID_SHIFT) | \
      (axi_read_error << MH_AXI_ERROR_AXI_READ_ERROR_SHIFT) | \
      (axi_write_id << MH_AXI_ERROR_AXI_WRITE_ID_SHIFT) | \
      (axi_write_error << MH_AXI_ERROR_AXI_WRITE_ERROR_SHIFT))

#define MH_AXI_ERROR_GET_AXI_READ_ID(mh_axi_error) \
     ((mh_axi_error & MH_AXI_ERROR_AXI_READ_ID_MASK) >> MH_AXI_ERROR_AXI_READ_ID_SHIFT)
#define MH_AXI_ERROR_GET_AXI_READ_ERROR(mh_axi_error) \
     ((mh_axi_error & MH_AXI_ERROR_AXI_READ_ERROR_MASK) >> MH_AXI_ERROR_AXI_READ_ERROR_SHIFT)
#define MH_AXI_ERROR_GET_AXI_WRITE_ID(mh_axi_error) \
     ((mh_axi_error & MH_AXI_ERROR_AXI_WRITE_ID_MASK) >> MH_AXI_ERROR_AXI_WRITE_ID_SHIFT)
#define MH_AXI_ERROR_GET_AXI_WRITE_ERROR(mh_axi_error) \
     ((mh_axi_error & MH_AXI_ERROR_AXI_WRITE_ERROR_MASK) >> MH_AXI_ERROR_AXI_WRITE_ERROR_SHIFT)

#define MH_AXI_ERROR_SET_AXI_READ_ID(mh_axi_error_reg, axi_read_id) \
     mh_axi_error_reg = (mh_axi_error_reg & ~MH_AXI_ERROR_AXI_READ_ID_MASK) | (axi_read_id << MH_AXI_ERROR_AXI_READ_ID_SHIFT)
#define MH_AXI_ERROR_SET_AXI_READ_ERROR(mh_axi_error_reg, axi_read_error) \
     mh_axi_error_reg = (mh_axi_error_reg & ~MH_AXI_ERROR_AXI_READ_ERROR_MASK) | (axi_read_error << MH_AXI_ERROR_AXI_READ_ERROR_SHIFT)
#define MH_AXI_ERROR_SET_AXI_WRITE_ID(mh_axi_error_reg, axi_write_id) \
     mh_axi_error_reg = (mh_axi_error_reg & ~MH_AXI_ERROR_AXI_WRITE_ID_MASK) | (axi_write_id << MH_AXI_ERROR_AXI_WRITE_ID_SHIFT)
#define MH_AXI_ERROR_SET_AXI_WRITE_ERROR(mh_axi_error_reg, axi_write_error) \
     mh_axi_error_reg = (mh_axi_error_reg & ~MH_AXI_ERROR_AXI_WRITE_ERROR_MASK) | (axi_write_error << MH_AXI_ERROR_AXI_WRITE_ERROR_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_axi_error_t {
          unsigned int axi_read_id                    : MH_AXI_ERROR_AXI_READ_ID_SIZE;
          unsigned int axi_read_error                 : MH_AXI_ERROR_AXI_READ_ERROR_SIZE;
          unsigned int axi_write_id                   : MH_AXI_ERROR_AXI_WRITE_ID_SIZE;
          unsigned int axi_write_error                : MH_AXI_ERROR_AXI_WRITE_ERROR_SIZE;
          unsigned int                                : 24;
     } mh_axi_error_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_axi_error_t {
          unsigned int                                : 24;
          unsigned int axi_write_error                : MH_AXI_ERROR_AXI_WRITE_ERROR_SIZE;
          unsigned int axi_write_id                   : MH_AXI_ERROR_AXI_WRITE_ID_SIZE;
          unsigned int axi_read_error                 : MH_AXI_ERROR_AXI_READ_ERROR_SIZE;
          unsigned int axi_read_id                    : MH_AXI_ERROR_AXI_READ_ID_SIZE;
     } mh_axi_error_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_axi_error_t f;
} mh_axi_error_u;


/*
 * MH_PERFCOUNTER0_SELECT struct
 */

#define MH_PERFCOUNTER0_SELECT_PERF_SEL_SIZE 8

#define MH_PERFCOUNTER0_SELECT_PERF_SEL_SHIFT 0

#define MH_PERFCOUNTER0_SELECT_PERF_SEL_MASK 0x000000ff

#define MH_PERFCOUNTER0_SELECT_MASK \
     (MH_PERFCOUNTER0_SELECT_PERF_SEL_MASK)

#define MH_PERFCOUNTER0_SELECT(perf_sel) \
     ((perf_sel << MH_PERFCOUNTER0_SELECT_PERF_SEL_SHIFT))

#define MH_PERFCOUNTER0_SELECT_GET_PERF_SEL(mh_perfcounter0_select) \
     ((mh_perfcounter0_select & MH_PERFCOUNTER0_SELECT_PERF_SEL_MASK) >> MH_PERFCOUNTER0_SELECT_PERF_SEL_SHIFT)

#define MH_PERFCOUNTER0_SELECT_SET_PERF_SEL(mh_perfcounter0_select_reg, perf_sel) \
     mh_perfcounter0_select_reg = (mh_perfcounter0_select_reg & ~MH_PERFCOUNTER0_SELECT_PERF_SEL_MASK) | (perf_sel << MH_PERFCOUNTER0_SELECT_PERF_SEL_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_perfcounter0_select_t {
          unsigned int perf_sel                       : MH_PERFCOUNTER0_SELECT_PERF_SEL_SIZE;
          unsigned int                                : 24;
     } mh_perfcounter0_select_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_perfcounter0_select_t {
          unsigned int                                : 24;
          unsigned int perf_sel                       : MH_PERFCOUNTER0_SELECT_PERF_SEL_SIZE;
     } mh_perfcounter0_select_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_perfcounter0_select_t f;
} mh_perfcounter0_select_u;


/*
 * MH_PERFCOUNTER1_SELECT struct
 */

#define MH_PERFCOUNTER1_SELECT_PERF_SEL_SIZE 8

#define MH_PERFCOUNTER1_SELECT_PERF_SEL_SHIFT 0

#define MH_PERFCOUNTER1_SELECT_PERF_SEL_MASK 0x000000ff

#define MH_PERFCOUNTER1_SELECT_MASK \
     (MH_PERFCOUNTER1_SELECT_PERF_SEL_MASK)

#define MH_PERFCOUNTER1_SELECT(perf_sel) \
     ((perf_sel << MH_PERFCOUNTER1_SELECT_PERF_SEL_SHIFT))

#define MH_PERFCOUNTER1_SELECT_GET_PERF_SEL(mh_perfcounter1_select) \
     ((mh_perfcounter1_select & MH_PERFCOUNTER1_SELECT_PERF_SEL_MASK) >> MH_PERFCOUNTER1_SELECT_PERF_SEL_SHIFT)

#define MH_PERFCOUNTER1_SELECT_SET_PERF_SEL(mh_perfcounter1_select_reg, perf_sel) \
     mh_perfcounter1_select_reg = (mh_perfcounter1_select_reg & ~MH_PERFCOUNTER1_SELECT_PERF_SEL_MASK) | (perf_sel << MH_PERFCOUNTER1_SELECT_PERF_SEL_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_perfcounter1_select_t {
          unsigned int perf_sel                       : MH_PERFCOUNTER1_SELECT_PERF_SEL_SIZE;
          unsigned int                                : 24;
     } mh_perfcounter1_select_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_perfcounter1_select_t {
          unsigned int                                : 24;
          unsigned int perf_sel                       : MH_PERFCOUNTER1_SELECT_PERF_SEL_SIZE;
     } mh_perfcounter1_select_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_perfcounter1_select_t f;
} mh_perfcounter1_select_u;


/*
 * MH_PERFCOUNTER0_CONFIG struct
 */

#define MH_PERFCOUNTER0_CONFIG_N_VALUE_SIZE 8

#define MH_PERFCOUNTER0_CONFIG_N_VALUE_SHIFT 0

#define MH_PERFCOUNTER0_CONFIG_N_VALUE_MASK 0x000000ff

#define MH_PERFCOUNTER0_CONFIG_MASK \
     (MH_PERFCOUNTER0_CONFIG_N_VALUE_MASK)

#define MH_PERFCOUNTER0_CONFIG(n_value) \
     ((n_value << MH_PERFCOUNTER0_CONFIG_N_VALUE_SHIFT))

#define MH_PERFCOUNTER0_CONFIG_GET_N_VALUE(mh_perfcounter0_config) \
     ((mh_perfcounter0_config & MH_PERFCOUNTER0_CONFIG_N_VALUE_MASK) >> MH_PERFCOUNTER0_CONFIG_N_VALUE_SHIFT)

#define MH_PERFCOUNTER0_CONFIG_SET_N_VALUE(mh_perfcounter0_config_reg, n_value) \
     mh_perfcounter0_config_reg = (mh_perfcounter0_config_reg & ~MH_PERFCOUNTER0_CONFIG_N_VALUE_MASK) | (n_value << MH_PERFCOUNTER0_CONFIG_N_VALUE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_perfcounter0_config_t {
          unsigned int n_value                        : MH_PERFCOUNTER0_CONFIG_N_VALUE_SIZE;
          unsigned int                                : 24;
     } mh_perfcounter0_config_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_perfcounter0_config_t {
          unsigned int                                : 24;
          unsigned int n_value                        : MH_PERFCOUNTER0_CONFIG_N_VALUE_SIZE;
     } mh_perfcounter0_config_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_perfcounter0_config_t f;
} mh_perfcounter0_config_u;


/*
 * MH_PERFCOUNTER1_CONFIG struct
 */

#define MH_PERFCOUNTER1_CONFIG_N_VALUE_SIZE 8

#define MH_PERFCOUNTER1_CONFIG_N_VALUE_SHIFT 0

#define MH_PERFCOUNTER1_CONFIG_N_VALUE_MASK 0x000000ff

#define MH_PERFCOUNTER1_CONFIG_MASK \
     (MH_PERFCOUNTER1_CONFIG_N_VALUE_MASK)

#define MH_PERFCOUNTER1_CONFIG(n_value) \
     ((n_value << MH_PERFCOUNTER1_CONFIG_N_VALUE_SHIFT))

#define MH_PERFCOUNTER1_CONFIG_GET_N_VALUE(mh_perfcounter1_config) \
     ((mh_perfcounter1_config & MH_PERFCOUNTER1_CONFIG_N_VALUE_MASK) >> MH_PERFCOUNTER1_CONFIG_N_VALUE_SHIFT)

#define MH_PERFCOUNTER1_CONFIG_SET_N_VALUE(mh_perfcounter1_config_reg, n_value) \
     mh_perfcounter1_config_reg = (mh_perfcounter1_config_reg & ~MH_PERFCOUNTER1_CONFIG_N_VALUE_MASK) | (n_value << MH_PERFCOUNTER1_CONFIG_N_VALUE_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_perfcounter1_config_t {
          unsigned int n_value                        : MH_PERFCOUNTER1_CONFIG_N_VALUE_SIZE;
          unsigned int                                : 24;
     } mh_perfcounter1_config_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_perfcounter1_config_t {
          unsigned int                                : 24;
          unsigned int n_value                        : MH_PERFCOUNTER1_CONFIG_N_VALUE_SIZE;
     } mh_perfcounter1_config_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_perfcounter1_config_t f;
} mh_perfcounter1_config_u;


/*
 * MH_PERFCOUNTER0_LOW struct
 */

#define MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_SIZE 32

#define MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_SHIFT 0

#define MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_MASK 0xffffffff

#define MH_PERFCOUNTER0_LOW_MASK \
     (MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_MASK)

#define MH_PERFCOUNTER0_LOW(perf_counter_low) \
     ((perf_counter_low << MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_SHIFT))

#define MH_PERFCOUNTER0_LOW_GET_PERF_COUNTER_LOW(mh_perfcounter0_low) \
     ((mh_perfcounter0_low & MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_MASK) >> MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_SHIFT)

#define MH_PERFCOUNTER0_LOW_SET_PERF_COUNTER_LOW(mh_perfcounter0_low_reg, perf_counter_low) \
     mh_perfcounter0_low_reg = (mh_perfcounter0_low_reg & ~MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_MASK) | (perf_counter_low << MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_perfcounter0_low_t {
          unsigned int perf_counter_low               : MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_SIZE;
     } mh_perfcounter0_low_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_perfcounter0_low_t {
          unsigned int perf_counter_low               : MH_PERFCOUNTER0_LOW_PERF_COUNTER_LOW_SIZE;
     } mh_perfcounter0_low_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_perfcounter0_low_t f;
} mh_perfcounter0_low_u;


/*
 * MH_PERFCOUNTER1_LOW struct
 */

#define MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_SIZE 32

#define MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_SHIFT 0

#define MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_MASK 0xffffffff

#define MH_PERFCOUNTER1_LOW_MASK \
     (MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_MASK)

#define MH_PERFCOUNTER1_LOW(perf_counter_low) \
     ((perf_counter_low << MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_SHIFT))

#define MH_PERFCOUNTER1_LOW_GET_PERF_COUNTER_LOW(mh_perfcounter1_low) \
     ((mh_perfcounter1_low & MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_MASK) >> MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_SHIFT)

#define MH_PERFCOUNTER1_LOW_SET_PERF_COUNTER_LOW(mh_perfcounter1_low_reg, perf_counter_low) \
     mh_perfcounter1_low_reg = (mh_perfcounter1_low_reg & ~MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_MASK) | (perf_counter_low << MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_perfcounter1_low_t {
          unsigned int perf_counter_low               : MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_SIZE;
     } mh_perfcounter1_low_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_perfcounter1_low_t {
          unsigned int perf_counter_low               : MH_PERFCOUNTER1_LOW_PERF_COUNTER_LOW_SIZE;
     } mh_perfcounter1_low_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_perfcounter1_low_t f;
} mh_perfcounter1_low_u;


/*
 * MH_PERFCOUNTER0_HI struct
 */

#define MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_SIZE 16

#define MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_SHIFT 0

#define MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_MASK 0x0000ffff

#define MH_PERFCOUNTER0_HI_MASK \
     (MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_MASK)

#define MH_PERFCOUNTER0_HI(perf_counter_hi) \
     ((perf_counter_hi << MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_SHIFT))

#define MH_PERFCOUNTER0_HI_GET_PERF_COUNTER_HI(mh_perfcounter0_hi) \
     ((mh_perfcounter0_hi & MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_MASK) >> MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_SHIFT)

#define MH_PERFCOUNTER0_HI_SET_PERF_COUNTER_HI(mh_perfcounter0_hi_reg, perf_counter_hi) \
     mh_perfcounter0_hi_reg = (mh_perfcounter0_hi_reg & ~MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_MASK) | (perf_counter_hi << MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_perfcounter0_hi_t {
          unsigned int perf_counter_hi                : MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_SIZE;
          unsigned int                                : 16;
     } mh_perfcounter0_hi_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_perfcounter0_hi_t {
          unsigned int                                : 16;
          unsigned int perf_counter_hi                : MH_PERFCOUNTER0_HI_PERF_COUNTER_HI_SIZE;
     } mh_perfcounter0_hi_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_perfcounter0_hi_t f;
} mh_perfcounter0_hi_u;


/*
 * MH_PERFCOUNTER1_HI struct
 */

#define MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_SIZE 16

#define MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_SHIFT 0

#define MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_MASK 0x0000ffff

#define MH_PERFCOUNTER1_HI_MASK \
     (MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_MASK)

#define MH_PERFCOUNTER1_HI(perf_counter_hi) \
     ((perf_counter_hi << MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_SHIFT))

#define MH_PERFCOUNTER1_HI_GET_PERF_COUNTER_HI(mh_perfcounter1_hi) \
     ((mh_perfcounter1_hi & MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_MASK) >> MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_SHIFT)

#define MH_PERFCOUNTER1_HI_SET_PERF_COUNTER_HI(mh_perfcounter1_hi_reg, perf_counter_hi) \
     mh_perfcounter1_hi_reg = (mh_perfcounter1_hi_reg & ~MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_MASK) | (perf_counter_hi << MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_perfcounter1_hi_t {
          unsigned int perf_counter_hi                : MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_SIZE;
          unsigned int                                : 16;
     } mh_perfcounter1_hi_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_perfcounter1_hi_t {
          unsigned int                                : 16;
          unsigned int perf_counter_hi                : MH_PERFCOUNTER1_HI_PERF_COUNTER_HI_SIZE;
     } mh_perfcounter1_hi_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_perfcounter1_hi_t f;
} mh_perfcounter1_hi_u;


/*
 * MH_DEBUG_CTRL struct
 */

#define MH_DEBUG_CTRL_INDEX_SIZE       6

#define MH_DEBUG_CTRL_INDEX_SHIFT      0

#define MH_DEBUG_CTRL_INDEX_MASK       0x0000003f

#define MH_DEBUG_CTRL_MASK \
     (MH_DEBUG_CTRL_INDEX_MASK)

#define MH_DEBUG_CTRL(index) \
     ((index << MH_DEBUG_CTRL_INDEX_SHIFT))

#define MH_DEBUG_CTRL_GET_INDEX(mh_debug_ctrl) \
     ((mh_debug_ctrl & MH_DEBUG_CTRL_INDEX_MASK) >> MH_DEBUG_CTRL_INDEX_SHIFT)

#define MH_DEBUG_CTRL_SET_INDEX(mh_debug_ctrl_reg, index) \
     mh_debug_ctrl_reg = (mh_debug_ctrl_reg & ~MH_DEBUG_CTRL_INDEX_MASK) | (index << MH_DEBUG_CTRL_INDEX_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_ctrl_t {
          unsigned int index                          : MH_DEBUG_CTRL_INDEX_SIZE;
          unsigned int                                : 26;
     } mh_debug_ctrl_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_ctrl_t {
          unsigned int                                : 26;
          unsigned int index                          : MH_DEBUG_CTRL_INDEX_SIZE;
     } mh_debug_ctrl_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_ctrl_t f;
} mh_debug_ctrl_u;


/*
 * MH_DEBUG_DATA struct
 */

#define MH_DEBUG_DATA_DATA_SIZE        32

#define MH_DEBUG_DATA_DATA_SHIFT       0

#define MH_DEBUG_DATA_DATA_MASK        0xffffffff

#define MH_DEBUG_DATA_MASK \
     (MH_DEBUG_DATA_DATA_MASK)

#define MH_DEBUG_DATA(data) \
     ((data << MH_DEBUG_DATA_DATA_SHIFT))

#define MH_DEBUG_DATA_GET_DATA(mh_debug_data) \
     ((mh_debug_data & MH_DEBUG_DATA_DATA_MASK) >> MH_DEBUG_DATA_DATA_SHIFT)

#define MH_DEBUG_DATA_SET_DATA(mh_debug_data_reg, data) \
     mh_debug_data_reg = (mh_debug_data_reg & ~MH_DEBUG_DATA_DATA_MASK) | (data << MH_DEBUG_DATA_DATA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_data_t {
          unsigned int data                           : MH_DEBUG_DATA_DATA_SIZE;
     } mh_debug_data_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_data_t {
          unsigned int data                           : MH_DEBUG_DATA_DATA_SIZE;
     } mh_debug_data_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_data_t f;
} mh_debug_data_u;


/*
 * MH_AXI_HALT_CONTROL struct
 */

#define MH_AXI_HALT_CONTROL_AXI_HALT_SIZE 1

#define MH_AXI_HALT_CONTROL_AXI_HALT_SHIFT 0

#define MH_AXI_HALT_CONTROL_AXI_HALT_MASK 0x00000001

#define MH_AXI_HALT_CONTROL_MASK \
     (MH_AXI_HALT_CONTROL_AXI_HALT_MASK)

#define MH_AXI_HALT_CONTROL(axi_halt) \
     ((axi_halt << MH_AXI_HALT_CONTROL_AXI_HALT_SHIFT))

#define MH_AXI_HALT_CONTROL_GET_AXI_HALT(mh_axi_halt_control) \
     ((mh_axi_halt_control & MH_AXI_HALT_CONTROL_AXI_HALT_MASK) >> MH_AXI_HALT_CONTROL_AXI_HALT_SHIFT)

#define MH_AXI_HALT_CONTROL_SET_AXI_HALT(mh_axi_halt_control_reg, axi_halt) \
     mh_axi_halt_control_reg = (mh_axi_halt_control_reg & ~MH_AXI_HALT_CONTROL_AXI_HALT_MASK) | (axi_halt << MH_AXI_HALT_CONTROL_AXI_HALT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_axi_halt_control_t {
          unsigned int axi_halt                       : MH_AXI_HALT_CONTROL_AXI_HALT_SIZE;
          unsigned int                                : 31;
     } mh_axi_halt_control_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_axi_halt_control_t {
          unsigned int                                : 31;
          unsigned int axi_halt                       : MH_AXI_HALT_CONTROL_AXI_HALT_SIZE;
     } mh_axi_halt_control_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_axi_halt_control_t f;
} mh_axi_halt_control_u;


/*
 * MH_DEBUG_REG00 struct
 */

#define MH_DEBUG_REG00_MH_BUSY_SIZE    1
#define MH_DEBUG_REG00_TRANS_OUTSTANDING_SIZE 1
#define MH_DEBUG_REG00_CP_REQUEST_SIZE 1
#define MH_DEBUG_REG00_VGT_REQUEST_SIZE 1
#define MH_DEBUG_REG00_TC_REQUEST_SIZE 1
#define MH_DEBUG_REG00_TC_CAM_EMPTY_SIZE 1
#define MH_DEBUG_REG00_TC_CAM_FULL_SIZE 1
#define MH_DEBUG_REG00_TCD_EMPTY_SIZE  1
#define MH_DEBUG_REG00_TCD_FULL_SIZE   1
#define MH_DEBUG_REG00_RB_REQUEST_SIZE 1
#define MH_DEBUG_REG00_PA_REQUEST_SIZE 1
#define MH_DEBUG_REG00_MH_CLK_EN_STATE_SIZE 1
#define MH_DEBUG_REG00_ARQ_EMPTY_SIZE  1
#define MH_DEBUG_REG00_ARQ_FULL_SIZE   1
#define MH_DEBUG_REG00_WDB_EMPTY_SIZE  1
#define MH_DEBUG_REG00_WDB_FULL_SIZE   1
#define MH_DEBUG_REG00_AXI_AVALID_SIZE 1
#define MH_DEBUG_REG00_AXI_AREADY_SIZE 1
#define MH_DEBUG_REG00_AXI_ARVALID_SIZE 1
#define MH_DEBUG_REG00_AXI_ARREADY_SIZE 1
#define MH_DEBUG_REG00_AXI_WVALID_SIZE 1
#define MH_DEBUG_REG00_AXI_WREADY_SIZE 1
#define MH_DEBUG_REG00_AXI_RVALID_SIZE 1
#define MH_DEBUG_REG00_AXI_RREADY_SIZE 1
#define MH_DEBUG_REG00_AXI_BVALID_SIZE 1
#define MH_DEBUG_REG00_AXI_BREADY_SIZE 1
#define MH_DEBUG_REG00_AXI_HALT_REQ_SIZE 1
#define MH_DEBUG_REG00_AXI_HALT_ACK_SIZE 1
#define MH_DEBUG_REG00_AXI_RDY_ENA_SIZE 1

#define MH_DEBUG_REG00_MH_BUSY_SHIFT   0
#define MH_DEBUG_REG00_TRANS_OUTSTANDING_SHIFT 1
#define MH_DEBUG_REG00_CP_REQUEST_SHIFT 2
#define MH_DEBUG_REG00_VGT_REQUEST_SHIFT 3
#define MH_DEBUG_REG00_TC_REQUEST_SHIFT 4
#define MH_DEBUG_REG00_TC_CAM_EMPTY_SHIFT 5
#define MH_DEBUG_REG00_TC_CAM_FULL_SHIFT 6
#define MH_DEBUG_REG00_TCD_EMPTY_SHIFT 7
#define MH_DEBUG_REG00_TCD_FULL_SHIFT  8
#define MH_DEBUG_REG00_RB_REQUEST_SHIFT 9
#define MH_DEBUG_REG00_PA_REQUEST_SHIFT 10
#define MH_DEBUG_REG00_MH_CLK_EN_STATE_SHIFT 11
#define MH_DEBUG_REG00_ARQ_EMPTY_SHIFT 12
#define MH_DEBUG_REG00_ARQ_FULL_SHIFT  13
#define MH_DEBUG_REG00_WDB_EMPTY_SHIFT 14
#define MH_DEBUG_REG00_WDB_FULL_SHIFT  15
#define MH_DEBUG_REG00_AXI_AVALID_SHIFT 16
#define MH_DEBUG_REG00_AXI_AREADY_SHIFT 17
#define MH_DEBUG_REG00_AXI_ARVALID_SHIFT 18
#define MH_DEBUG_REG00_AXI_ARREADY_SHIFT 19
#define MH_DEBUG_REG00_AXI_WVALID_SHIFT 20
#define MH_DEBUG_REG00_AXI_WREADY_SHIFT 21
#define MH_DEBUG_REG00_AXI_RVALID_SHIFT 22
#define MH_DEBUG_REG00_AXI_RREADY_SHIFT 23
#define MH_DEBUG_REG00_AXI_BVALID_SHIFT 24
#define MH_DEBUG_REG00_AXI_BREADY_SHIFT 25
#define MH_DEBUG_REG00_AXI_HALT_REQ_SHIFT 26
#define MH_DEBUG_REG00_AXI_HALT_ACK_SHIFT 27
#define MH_DEBUG_REG00_AXI_RDY_ENA_SHIFT 28

#define MH_DEBUG_REG00_MH_BUSY_MASK    0x00000001
#define MH_DEBUG_REG00_TRANS_OUTSTANDING_MASK 0x00000002
#define MH_DEBUG_REG00_CP_REQUEST_MASK 0x00000004
#define MH_DEBUG_REG00_VGT_REQUEST_MASK 0x00000008
#define MH_DEBUG_REG00_TC_REQUEST_MASK 0x00000010
#define MH_DEBUG_REG00_TC_CAM_EMPTY_MASK 0x00000020
#define MH_DEBUG_REG00_TC_CAM_FULL_MASK 0x00000040
#define MH_DEBUG_REG00_TCD_EMPTY_MASK  0x00000080
#define MH_DEBUG_REG00_TCD_FULL_MASK   0x00000100
#define MH_DEBUG_REG00_RB_REQUEST_MASK 0x00000200
#define MH_DEBUG_REG00_PA_REQUEST_MASK 0x00000400
#define MH_DEBUG_REG00_MH_CLK_EN_STATE_MASK 0x00000800
#define MH_DEBUG_REG00_ARQ_EMPTY_MASK  0x00001000
#define MH_DEBUG_REG00_ARQ_FULL_MASK   0x00002000
#define MH_DEBUG_REG00_WDB_EMPTY_MASK  0x00004000
#define MH_DEBUG_REG00_WDB_FULL_MASK   0x00008000
#define MH_DEBUG_REG00_AXI_AVALID_MASK 0x00010000
#define MH_DEBUG_REG00_AXI_AREADY_MASK 0x00020000
#define MH_DEBUG_REG00_AXI_ARVALID_MASK 0x00040000
#define MH_DEBUG_REG00_AXI_ARREADY_MASK 0x00080000
#define MH_DEBUG_REG00_AXI_WVALID_MASK 0x00100000
#define MH_DEBUG_REG00_AXI_WREADY_MASK 0x00200000
#define MH_DEBUG_REG00_AXI_RVALID_MASK 0x00400000
#define MH_DEBUG_REG00_AXI_RREADY_MASK 0x00800000
#define MH_DEBUG_REG00_AXI_BVALID_MASK 0x01000000
#define MH_DEBUG_REG00_AXI_BREADY_MASK 0x02000000
#define MH_DEBUG_REG00_AXI_HALT_REQ_MASK 0x04000000
#define MH_DEBUG_REG00_AXI_HALT_ACK_MASK 0x08000000
#define MH_DEBUG_REG00_AXI_RDY_ENA_MASK 0x10000000

#define MH_DEBUG_REG00_MASK \
     (MH_DEBUG_REG00_MH_BUSY_MASK | \
      MH_DEBUG_REG00_TRANS_OUTSTANDING_MASK | \
      MH_DEBUG_REG00_CP_REQUEST_MASK | \
      MH_DEBUG_REG00_VGT_REQUEST_MASK | \
      MH_DEBUG_REG00_TC_REQUEST_MASK | \
      MH_DEBUG_REG00_TC_CAM_EMPTY_MASK | \
      MH_DEBUG_REG00_TC_CAM_FULL_MASK | \
      MH_DEBUG_REG00_TCD_EMPTY_MASK | \
      MH_DEBUG_REG00_TCD_FULL_MASK | \
      MH_DEBUG_REG00_RB_REQUEST_MASK | \
      MH_DEBUG_REG00_PA_REQUEST_MASK | \
      MH_DEBUG_REG00_MH_CLK_EN_STATE_MASK | \
      MH_DEBUG_REG00_ARQ_EMPTY_MASK | \
      MH_DEBUG_REG00_ARQ_FULL_MASK | \
      MH_DEBUG_REG00_WDB_EMPTY_MASK | \
      MH_DEBUG_REG00_WDB_FULL_MASK | \
      MH_DEBUG_REG00_AXI_AVALID_MASK | \
      MH_DEBUG_REG00_AXI_AREADY_MASK | \
      MH_DEBUG_REG00_AXI_ARVALID_MASK | \
      MH_DEBUG_REG00_AXI_ARREADY_MASK | \
      MH_DEBUG_REG00_AXI_WVALID_MASK | \
      MH_DEBUG_REG00_AXI_WREADY_MASK | \
      MH_DEBUG_REG00_AXI_RVALID_MASK | \
      MH_DEBUG_REG00_AXI_RREADY_MASK | \
      MH_DEBUG_REG00_AXI_BVALID_MASK | \
      MH_DEBUG_REG00_AXI_BREADY_MASK | \
      MH_DEBUG_REG00_AXI_HALT_REQ_MASK | \
      MH_DEBUG_REG00_AXI_HALT_ACK_MASK | \
      MH_DEBUG_REG00_AXI_RDY_ENA_MASK)

#define MH_DEBUG_REG00(mh_busy, trans_outstanding, cp_request, vgt_request, tc_request, tc_cam_empty, tc_cam_full, tcd_empty, tcd_full, rb_request, pa_request, mh_clk_en_state, arq_empty, arq_full, wdb_empty, wdb_full, axi_avalid, axi_aready, axi_arvalid, axi_arready, axi_wvalid, axi_wready, axi_rvalid, axi_rready, axi_bvalid, axi_bready, axi_halt_req, axi_halt_ack, axi_rdy_ena) \
     ((mh_busy << MH_DEBUG_REG00_MH_BUSY_SHIFT) | \
      (trans_outstanding << MH_DEBUG_REG00_TRANS_OUTSTANDING_SHIFT) | \
      (cp_request << MH_DEBUG_REG00_CP_REQUEST_SHIFT) | \
      (vgt_request << MH_DEBUG_REG00_VGT_REQUEST_SHIFT) | \
      (tc_request << MH_DEBUG_REG00_TC_REQUEST_SHIFT) | \
      (tc_cam_empty << MH_DEBUG_REG00_TC_CAM_EMPTY_SHIFT) | \
      (tc_cam_full << MH_DEBUG_REG00_TC_CAM_FULL_SHIFT) | \
      (tcd_empty << MH_DEBUG_REG00_TCD_EMPTY_SHIFT) | \
      (tcd_full << MH_DEBUG_REG00_TCD_FULL_SHIFT) | \
      (rb_request << MH_DEBUG_REG00_RB_REQUEST_SHIFT) | \
      (pa_request << MH_DEBUG_REG00_PA_REQUEST_SHIFT) | \
      (mh_clk_en_state << MH_DEBUG_REG00_MH_CLK_EN_STATE_SHIFT) | \
      (arq_empty << MH_DEBUG_REG00_ARQ_EMPTY_SHIFT) | \
      (arq_full << MH_DEBUG_REG00_ARQ_FULL_SHIFT) | \
      (wdb_empty << MH_DEBUG_REG00_WDB_EMPTY_SHIFT) | \
      (wdb_full << MH_DEBUG_REG00_WDB_FULL_SHIFT) | \
      (axi_avalid << MH_DEBUG_REG00_AXI_AVALID_SHIFT) | \
      (axi_aready << MH_DEBUG_REG00_AXI_AREADY_SHIFT) | \
      (axi_arvalid << MH_DEBUG_REG00_AXI_ARVALID_SHIFT) | \
      (axi_arready << MH_DEBUG_REG00_AXI_ARREADY_SHIFT) | \
      (axi_wvalid << MH_DEBUG_REG00_AXI_WVALID_SHIFT) | \
      (axi_wready << MH_DEBUG_REG00_AXI_WREADY_SHIFT) | \
      (axi_rvalid << MH_DEBUG_REG00_AXI_RVALID_SHIFT) | \
      (axi_rready << MH_DEBUG_REG00_AXI_RREADY_SHIFT) | \
      (axi_bvalid << MH_DEBUG_REG00_AXI_BVALID_SHIFT) | \
      (axi_bready << MH_DEBUG_REG00_AXI_BREADY_SHIFT) | \
      (axi_halt_req << MH_DEBUG_REG00_AXI_HALT_REQ_SHIFT) | \
      (axi_halt_ack << MH_DEBUG_REG00_AXI_HALT_ACK_SHIFT) | \
      (axi_rdy_ena << MH_DEBUG_REG00_AXI_RDY_ENA_SHIFT))

#define MH_DEBUG_REG00_GET_MH_BUSY(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_MH_BUSY_MASK) >> MH_DEBUG_REG00_MH_BUSY_SHIFT)
#define MH_DEBUG_REG00_GET_TRANS_OUTSTANDING(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_TRANS_OUTSTANDING_MASK) >> MH_DEBUG_REG00_TRANS_OUTSTANDING_SHIFT)
#define MH_DEBUG_REG00_GET_CP_REQUEST(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_CP_REQUEST_MASK) >> MH_DEBUG_REG00_CP_REQUEST_SHIFT)
#define MH_DEBUG_REG00_GET_VGT_REQUEST(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_VGT_REQUEST_MASK) >> MH_DEBUG_REG00_VGT_REQUEST_SHIFT)
#define MH_DEBUG_REG00_GET_TC_REQUEST(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_TC_REQUEST_MASK) >> MH_DEBUG_REG00_TC_REQUEST_SHIFT)
#define MH_DEBUG_REG00_GET_TC_CAM_EMPTY(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_TC_CAM_EMPTY_MASK) >> MH_DEBUG_REG00_TC_CAM_EMPTY_SHIFT)
#define MH_DEBUG_REG00_GET_TC_CAM_FULL(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_TC_CAM_FULL_MASK) >> MH_DEBUG_REG00_TC_CAM_FULL_SHIFT)
#define MH_DEBUG_REG00_GET_TCD_EMPTY(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_TCD_EMPTY_MASK) >> MH_DEBUG_REG00_TCD_EMPTY_SHIFT)
#define MH_DEBUG_REG00_GET_TCD_FULL(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_TCD_FULL_MASK) >> MH_DEBUG_REG00_TCD_FULL_SHIFT)
#define MH_DEBUG_REG00_GET_RB_REQUEST(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_RB_REQUEST_MASK) >> MH_DEBUG_REG00_RB_REQUEST_SHIFT)
#define MH_DEBUG_REG00_GET_PA_REQUEST(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_PA_REQUEST_MASK) >> MH_DEBUG_REG00_PA_REQUEST_SHIFT)
#define MH_DEBUG_REG00_GET_MH_CLK_EN_STATE(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_MH_CLK_EN_STATE_MASK) >> MH_DEBUG_REG00_MH_CLK_EN_STATE_SHIFT)
#define MH_DEBUG_REG00_GET_ARQ_EMPTY(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_ARQ_EMPTY_MASK) >> MH_DEBUG_REG00_ARQ_EMPTY_SHIFT)
#define MH_DEBUG_REG00_GET_ARQ_FULL(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_ARQ_FULL_MASK) >> MH_DEBUG_REG00_ARQ_FULL_SHIFT)
#define MH_DEBUG_REG00_GET_WDB_EMPTY(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_WDB_EMPTY_MASK) >> MH_DEBUG_REG00_WDB_EMPTY_SHIFT)
#define MH_DEBUG_REG00_GET_WDB_FULL(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_WDB_FULL_MASK) >> MH_DEBUG_REG00_WDB_FULL_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_AVALID(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_AVALID_MASK) >> MH_DEBUG_REG00_AXI_AVALID_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_AREADY(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_AREADY_MASK) >> MH_DEBUG_REG00_AXI_AREADY_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_ARVALID(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_ARVALID_MASK) >> MH_DEBUG_REG00_AXI_ARVALID_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_ARREADY(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_ARREADY_MASK) >> MH_DEBUG_REG00_AXI_ARREADY_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_WVALID(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_WVALID_MASK) >> MH_DEBUG_REG00_AXI_WVALID_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_WREADY(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_WREADY_MASK) >> MH_DEBUG_REG00_AXI_WREADY_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_RVALID(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_RVALID_MASK) >> MH_DEBUG_REG00_AXI_RVALID_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_RREADY(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_RREADY_MASK) >> MH_DEBUG_REG00_AXI_RREADY_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_BVALID(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_BVALID_MASK) >> MH_DEBUG_REG00_AXI_BVALID_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_BREADY(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_BREADY_MASK) >> MH_DEBUG_REG00_AXI_BREADY_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_HALT_REQ(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_HALT_REQ_MASK) >> MH_DEBUG_REG00_AXI_HALT_REQ_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_HALT_ACK(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_HALT_ACK_MASK) >> MH_DEBUG_REG00_AXI_HALT_ACK_SHIFT)
#define MH_DEBUG_REG00_GET_AXI_RDY_ENA(mh_debug_reg00) \
     ((mh_debug_reg00 & MH_DEBUG_REG00_AXI_RDY_ENA_MASK) >> MH_DEBUG_REG00_AXI_RDY_ENA_SHIFT)

#define MH_DEBUG_REG00_SET_MH_BUSY(mh_debug_reg00_reg, mh_busy) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_MH_BUSY_MASK) | (mh_busy << MH_DEBUG_REG00_MH_BUSY_SHIFT)
#define MH_DEBUG_REG00_SET_TRANS_OUTSTANDING(mh_debug_reg00_reg, trans_outstanding) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_TRANS_OUTSTANDING_MASK) | (trans_outstanding << MH_DEBUG_REG00_TRANS_OUTSTANDING_SHIFT)
#define MH_DEBUG_REG00_SET_CP_REQUEST(mh_debug_reg00_reg, cp_request) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_CP_REQUEST_MASK) | (cp_request << MH_DEBUG_REG00_CP_REQUEST_SHIFT)
#define MH_DEBUG_REG00_SET_VGT_REQUEST(mh_debug_reg00_reg, vgt_request) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_VGT_REQUEST_MASK) | (vgt_request << MH_DEBUG_REG00_VGT_REQUEST_SHIFT)
#define MH_DEBUG_REG00_SET_TC_REQUEST(mh_debug_reg00_reg, tc_request) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_TC_REQUEST_MASK) | (tc_request << MH_DEBUG_REG00_TC_REQUEST_SHIFT)
#define MH_DEBUG_REG00_SET_TC_CAM_EMPTY(mh_debug_reg00_reg, tc_cam_empty) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_TC_CAM_EMPTY_MASK) | (tc_cam_empty << MH_DEBUG_REG00_TC_CAM_EMPTY_SHIFT)
#define MH_DEBUG_REG00_SET_TC_CAM_FULL(mh_debug_reg00_reg, tc_cam_full) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_TC_CAM_FULL_MASK) | (tc_cam_full << MH_DEBUG_REG00_TC_CAM_FULL_SHIFT)
#define MH_DEBUG_REG00_SET_TCD_EMPTY(mh_debug_reg00_reg, tcd_empty) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_TCD_EMPTY_MASK) | (tcd_empty << MH_DEBUG_REG00_TCD_EMPTY_SHIFT)
#define MH_DEBUG_REG00_SET_TCD_FULL(mh_debug_reg00_reg, tcd_full) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_TCD_FULL_MASK) | (tcd_full << MH_DEBUG_REG00_TCD_FULL_SHIFT)
#define MH_DEBUG_REG00_SET_RB_REQUEST(mh_debug_reg00_reg, rb_request) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_RB_REQUEST_MASK) | (rb_request << MH_DEBUG_REG00_RB_REQUEST_SHIFT)
#define MH_DEBUG_REG00_SET_PA_REQUEST(mh_debug_reg00_reg, pa_request) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_PA_REQUEST_MASK) | (pa_request << MH_DEBUG_REG00_PA_REQUEST_SHIFT)
#define MH_DEBUG_REG00_SET_MH_CLK_EN_STATE(mh_debug_reg00_reg, mh_clk_en_state) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_MH_CLK_EN_STATE_MASK) | (mh_clk_en_state << MH_DEBUG_REG00_MH_CLK_EN_STATE_SHIFT)
#define MH_DEBUG_REG00_SET_ARQ_EMPTY(mh_debug_reg00_reg, arq_empty) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_ARQ_EMPTY_MASK) | (arq_empty << MH_DEBUG_REG00_ARQ_EMPTY_SHIFT)
#define MH_DEBUG_REG00_SET_ARQ_FULL(mh_debug_reg00_reg, arq_full) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_ARQ_FULL_MASK) | (arq_full << MH_DEBUG_REG00_ARQ_FULL_SHIFT)
#define MH_DEBUG_REG00_SET_WDB_EMPTY(mh_debug_reg00_reg, wdb_empty) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_WDB_EMPTY_MASK) | (wdb_empty << MH_DEBUG_REG00_WDB_EMPTY_SHIFT)
#define MH_DEBUG_REG00_SET_WDB_FULL(mh_debug_reg00_reg, wdb_full) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_WDB_FULL_MASK) | (wdb_full << MH_DEBUG_REG00_WDB_FULL_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_AVALID(mh_debug_reg00_reg, axi_avalid) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_AVALID_MASK) | (axi_avalid << MH_DEBUG_REG00_AXI_AVALID_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_AREADY(mh_debug_reg00_reg, axi_aready) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_AREADY_MASK) | (axi_aready << MH_DEBUG_REG00_AXI_AREADY_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_ARVALID(mh_debug_reg00_reg, axi_arvalid) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_ARVALID_MASK) | (axi_arvalid << MH_DEBUG_REG00_AXI_ARVALID_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_ARREADY(mh_debug_reg00_reg, axi_arready) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_ARREADY_MASK) | (axi_arready << MH_DEBUG_REG00_AXI_ARREADY_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_WVALID(mh_debug_reg00_reg, axi_wvalid) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_WVALID_MASK) | (axi_wvalid << MH_DEBUG_REG00_AXI_WVALID_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_WREADY(mh_debug_reg00_reg, axi_wready) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_WREADY_MASK) | (axi_wready << MH_DEBUG_REG00_AXI_WREADY_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_RVALID(mh_debug_reg00_reg, axi_rvalid) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_RVALID_MASK) | (axi_rvalid << MH_DEBUG_REG00_AXI_RVALID_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_RREADY(mh_debug_reg00_reg, axi_rready) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_RREADY_MASK) | (axi_rready << MH_DEBUG_REG00_AXI_RREADY_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_BVALID(mh_debug_reg00_reg, axi_bvalid) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_BVALID_MASK) | (axi_bvalid << MH_DEBUG_REG00_AXI_BVALID_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_BREADY(mh_debug_reg00_reg, axi_bready) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_BREADY_MASK) | (axi_bready << MH_DEBUG_REG00_AXI_BREADY_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_HALT_REQ(mh_debug_reg00_reg, axi_halt_req) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_HALT_REQ_MASK) | (axi_halt_req << MH_DEBUG_REG00_AXI_HALT_REQ_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_HALT_ACK(mh_debug_reg00_reg, axi_halt_ack) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_HALT_ACK_MASK) | (axi_halt_ack << MH_DEBUG_REG00_AXI_HALT_ACK_SHIFT)
#define MH_DEBUG_REG00_SET_AXI_RDY_ENA(mh_debug_reg00_reg, axi_rdy_ena) \
     mh_debug_reg00_reg = (mh_debug_reg00_reg & ~MH_DEBUG_REG00_AXI_RDY_ENA_MASK) | (axi_rdy_ena << MH_DEBUG_REG00_AXI_RDY_ENA_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg00_t {
          unsigned int mh_busy                        : MH_DEBUG_REG00_MH_BUSY_SIZE;
          unsigned int trans_outstanding              : MH_DEBUG_REG00_TRANS_OUTSTANDING_SIZE;
          unsigned int cp_request                     : MH_DEBUG_REG00_CP_REQUEST_SIZE;
          unsigned int vgt_request                    : MH_DEBUG_REG00_VGT_REQUEST_SIZE;
          unsigned int tc_request                     : MH_DEBUG_REG00_TC_REQUEST_SIZE;
          unsigned int tc_cam_empty                   : MH_DEBUG_REG00_TC_CAM_EMPTY_SIZE;
          unsigned int tc_cam_full                    : MH_DEBUG_REG00_TC_CAM_FULL_SIZE;
          unsigned int tcd_empty                      : MH_DEBUG_REG00_TCD_EMPTY_SIZE;
          unsigned int tcd_full                       : MH_DEBUG_REG00_TCD_FULL_SIZE;
          unsigned int rb_request                     : MH_DEBUG_REG00_RB_REQUEST_SIZE;
          unsigned int pa_request                     : MH_DEBUG_REG00_PA_REQUEST_SIZE;
          unsigned int mh_clk_en_state                : MH_DEBUG_REG00_MH_CLK_EN_STATE_SIZE;
          unsigned int arq_empty                      : MH_DEBUG_REG00_ARQ_EMPTY_SIZE;
          unsigned int arq_full                       : MH_DEBUG_REG00_ARQ_FULL_SIZE;
          unsigned int wdb_empty                      : MH_DEBUG_REG00_WDB_EMPTY_SIZE;
          unsigned int wdb_full                       : MH_DEBUG_REG00_WDB_FULL_SIZE;
          unsigned int axi_avalid                     : MH_DEBUG_REG00_AXI_AVALID_SIZE;
          unsigned int axi_aready                     : MH_DEBUG_REG00_AXI_AREADY_SIZE;
          unsigned int axi_arvalid                    : MH_DEBUG_REG00_AXI_ARVALID_SIZE;
          unsigned int axi_arready                    : MH_DEBUG_REG00_AXI_ARREADY_SIZE;
          unsigned int axi_wvalid                     : MH_DEBUG_REG00_AXI_WVALID_SIZE;
          unsigned int axi_wready                     : MH_DEBUG_REG00_AXI_WREADY_SIZE;
          unsigned int axi_rvalid                     : MH_DEBUG_REG00_AXI_RVALID_SIZE;
          unsigned int axi_rready                     : MH_DEBUG_REG00_AXI_RREADY_SIZE;
          unsigned int axi_bvalid                     : MH_DEBUG_REG00_AXI_BVALID_SIZE;
          unsigned int axi_bready                     : MH_DEBUG_REG00_AXI_BREADY_SIZE;
          unsigned int axi_halt_req                   : MH_DEBUG_REG00_AXI_HALT_REQ_SIZE;
          unsigned int axi_halt_ack                   : MH_DEBUG_REG00_AXI_HALT_ACK_SIZE;
          unsigned int axi_rdy_ena                    : MH_DEBUG_REG00_AXI_RDY_ENA_SIZE;
          unsigned int                                : 3;
     } mh_debug_reg00_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg00_t {
          unsigned int                                : 3;
          unsigned int axi_rdy_ena                    : MH_DEBUG_REG00_AXI_RDY_ENA_SIZE;
          unsigned int axi_halt_ack                   : MH_DEBUG_REG00_AXI_HALT_ACK_SIZE;
          unsigned int axi_halt_req                   : MH_DEBUG_REG00_AXI_HALT_REQ_SIZE;
          unsigned int axi_bready                     : MH_DEBUG_REG00_AXI_BREADY_SIZE;
          unsigned int axi_bvalid                     : MH_DEBUG_REG00_AXI_BVALID_SIZE;
          unsigned int axi_rready                     : MH_DEBUG_REG00_AXI_RREADY_SIZE;
          unsigned int axi_rvalid                     : MH_DEBUG_REG00_AXI_RVALID_SIZE;
          unsigned int axi_wready                     : MH_DEBUG_REG00_AXI_WREADY_SIZE;
          unsigned int axi_wvalid                     : MH_DEBUG_REG00_AXI_WVALID_SIZE;
          unsigned int axi_arready                    : MH_DEBUG_REG00_AXI_ARREADY_SIZE;
          unsigned int axi_arvalid                    : MH_DEBUG_REG00_AXI_ARVALID_SIZE;
          unsigned int axi_aready                     : MH_DEBUG_REG00_AXI_AREADY_SIZE;
          unsigned int axi_avalid                     : MH_DEBUG_REG00_AXI_AVALID_SIZE;
          unsigned int wdb_full                       : MH_DEBUG_REG00_WDB_FULL_SIZE;
          unsigned int wdb_empty                      : MH_DEBUG_REG00_WDB_EMPTY_SIZE;
          unsigned int arq_full                       : MH_DEBUG_REG00_ARQ_FULL_SIZE;
          unsigned int arq_empty                      : MH_DEBUG_REG00_ARQ_EMPTY_SIZE;
          unsigned int mh_clk_en_state                : MH_DEBUG_REG00_MH_CLK_EN_STATE_SIZE;
          unsigned int pa_request                     : MH_DEBUG_REG00_PA_REQUEST_SIZE;
          unsigned int rb_request                     : MH_DEBUG_REG00_RB_REQUEST_SIZE;
          unsigned int tcd_full                       : MH_DEBUG_REG00_TCD_FULL_SIZE;
          unsigned int tcd_empty                      : MH_DEBUG_REG00_TCD_EMPTY_SIZE;
          unsigned int tc_cam_full                    : MH_DEBUG_REG00_TC_CAM_FULL_SIZE;
          unsigned int tc_cam_empty                   : MH_DEBUG_REG00_TC_CAM_EMPTY_SIZE;
          unsigned int tc_request                     : MH_DEBUG_REG00_TC_REQUEST_SIZE;
          unsigned int vgt_request                    : MH_DEBUG_REG00_VGT_REQUEST_SIZE;
          unsigned int cp_request                     : MH_DEBUG_REG00_CP_REQUEST_SIZE;
          unsigned int trans_outstanding              : MH_DEBUG_REG00_TRANS_OUTSTANDING_SIZE;
          unsigned int mh_busy                        : MH_DEBUG_REG00_MH_BUSY_SIZE;
     } mh_debug_reg00_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg00_t f;
} mh_debug_reg00_u;


/*
 * MH_DEBUG_REG01 struct
 */

#define MH_DEBUG_REG01_CP_SEND_q_SIZE  1
#define MH_DEBUG_REG01_CP_RTR_q_SIZE   1
#define MH_DEBUG_REG01_CP_WRITE_q_SIZE 1
#define MH_DEBUG_REG01_CP_TAG_q_SIZE   3
#define MH_DEBUG_REG01_CP_BLEN_q_SIZE  1
#define MH_DEBUG_REG01_VGT_SEND_q_SIZE 1
#define MH_DEBUG_REG01_VGT_RTR_q_SIZE  1
#define MH_DEBUG_REG01_VGT_TAG_q_SIZE  1
#define MH_DEBUG_REG01_TC_SEND_q_SIZE  1
#define MH_DEBUG_REG01_TC_RTR_q_SIZE   1
#define MH_DEBUG_REG01_TC_BLEN_q_SIZE  1
#define MH_DEBUG_REG01_TC_ROQ_SEND_q_SIZE 1
#define MH_DEBUG_REG01_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG01_TC_MH_written_SIZE 1
#define MH_DEBUG_REG01_RB_SEND_q_SIZE  1
#define MH_DEBUG_REG01_RB_RTR_q_SIZE   1
#define MH_DEBUG_REG01_PA_SEND_q_SIZE  1
#define MH_DEBUG_REG01_PA_RTR_q_SIZE   1

#define MH_DEBUG_REG01_CP_SEND_q_SHIFT 0
#define MH_DEBUG_REG01_CP_RTR_q_SHIFT  1
#define MH_DEBUG_REG01_CP_WRITE_q_SHIFT 2
#define MH_DEBUG_REG01_CP_TAG_q_SHIFT  3
#define MH_DEBUG_REG01_CP_BLEN_q_SHIFT 6
#define MH_DEBUG_REG01_VGT_SEND_q_SHIFT 7
#define MH_DEBUG_REG01_VGT_RTR_q_SHIFT 8
#define MH_DEBUG_REG01_VGT_TAG_q_SHIFT 9
#define MH_DEBUG_REG01_TC_SEND_q_SHIFT 10
#define MH_DEBUG_REG01_TC_RTR_q_SHIFT  11
#define MH_DEBUG_REG01_TC_BLEN_q_SHIFT 12
#define MH_DEBUG_REG01_TC_ROQ_SEND_q_SHIFT 13
#define MH_DEBUG_REG01_TC_ROQ_RTR_q_SHIFT 14
#define MH_DEBUG_REG01_TC_MH_written_SHIFT 15
#define MH_DEBUG_REG01_RB_SEND_q_SHIFT 16
#define MH_DEBUG_REG01_RB_RTR_q_SHIFT  17
#define MH_DEBUG_REG01_PA_SEND_q_SHIFT 18
#define MH_DEBUG_REG01_PA_RTR_q_SHIFT  19

#define MH_DEBUG_REG01_CP_SEND_q_MASK  0x00000001
#define MH_DEBUG_REG01_CP_RTR_q_MASK   0x00000002
#define MH_DEBUG_REG01_CP_WRITE_q_MASK 0x00000004
#define MH_DEBUG_REG01_CP_TAG_q_MASK   0x00000038
#define MH_DEBUG_REG01_CP_BLEN_q_MASK  0x00000040
#define MH_DEBUG_REG01_VGT_SEND_q_MASK 0x00000080
#define MH_DEBUG_REG01_VGT_RTR_q_MASK  0x00000100
#define MH_DEBUG_REG01_VGT_TAG_q_MASK  0x00000200
#define MH_DEBUG_REG01_TC_SEND_q_MASK  0x00000400
#define MH_DEBUG_REG01_TC_RTR_q_MASK   0x00000800
#define MH_DEBUG_REG01_TC_BLEN_q_MASK  0x00001000
#define MH_DEBUG_REG01_TC_ROQ_SEND_q_MASK 0x00002000
#define MH_DEBUG_REG01_TC_ROQ_RTR_q_MASK 0x00004000
#define MH_DEBUG_REG01_TC_MH_written_MASK 0x00008000
#define MH_DEBUG_REG01_RB_SEND_q_MASK  0x00010000
#define MH_DEBUG_REG01_RB_RTR_q_MASK   0x00020000
#define MH_DEBUG_REG01_PA_SEND_q_MASK  0x00040000
#define MH_DEBUG_REG01_PA_RTR_q_MASK   0x00080000

#define MH_DEBUG_REG01_MASK \
     (MH_DEBUG_REG01_CP_SEND_q_MASK | \
      MH_DEBUG_REG01_CP_RTR_q_MASK | \
      MH_DEBUG_REG01_CP_WRITE_q_MASK | \
      MH_DEBUG_REG01_CP_TAG_q_MASK | \
      MH_DEBUG_REG01_CP_BLEN_q_MASK | \
      MH_DEBUG_REG01_VGT_SEND_q_MASK | \
      MH_DEBUG_REG01_VGT_RTR_q_MASK | \
      MH_DEBUG_REG01_VGT_TAG_q_MASK | \
      MH_DEBUG_REG01_TC_SEND_q_MASK | \
      MH_DEBUG_REG01_TC_RTR_q_MASK | \
      MH_DEBUG_REG01_TC_BLEN_q_MASK | \
      MH_DEBUG_REG01_TC_ROQ_SEND_q_MASK | \
      MH_DEBUG_REG01_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG01_TC_MH_written_MASK | \
      MH_DEBUG_REG01_RB_SEND_q_MASK | \
      MH_DEBUG_REG01_RB_RTR_q_MASK | \
      MH_DEBUG_REG01_PA_SEND_q_MASK | \
      MH_DEBUG_REG01_PA_RTR_q_MASK)

#define MH_DEBUG_REG01(cp_send_q, cp_rtr_q, cp_write_q, cp_tag_q, cp_blen_q, vgt_send_q, vgt_rtr_q, vgt_tag_q, tc_send_q, tc_rtr_q, tc_blen_q, tc_roq_send_q, tc_roq_rtr_q, tc_mh_written, rb_send_q, rb_rtr_q, pa_send_q, pa_rtr_q) \
     ((cp_send_q << MH_DEBUG_REG01_CP_SEND_q_SHIFT) | \
      (cp_rtr_q << MH_DEBUG_REG01_CP_RTR_q_SHIFT) | \
      (cp_write_q << MH_DEBUG_REG01_CP_WRITE_q_SHIFT) | \
      (cp_tag_q << MH_DEBUG_REG01_CP_TAG_q_SHIFT) | \
      (cp_blen_q << MH_DEBUG_REG01_CP_BLEN_q_SHIFT) | \
      (vgt_send_q << MH_DEBUG_REG01_VGT_SEND_q_SHIFT) | \
      (vgt_rtr_q << MH_DEBUG_REG01_VGT_RTR_q_SHIFT) | \
      (vgt_tag_q << MH_DEBUG_REG01_VGT_TAG_q_SHIFT) | \
      (tc_send_q << MH_DEBUG_REG01_TC_SEND_q_SHIFT) | \
      (tc_rtr_q << MH_DEBUG_REG01_TC_RTR_q_SHIFT) | \
      (tc_blen_q << MH_DEBUG_REG01_TC_BLEN_q_SHIFT) | \
      (tc_roq_send_q << MH_DEBUG_REG01_TC_ROQ_SEND_q_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG01_TC_ROQ_RTR_q_SHIFT) | \
      (tc_mh_written << MH_DEBUG_REG01_TC_MH_written_SHIFT) | \
      (rb_send_q << MH_DEBUG_REG01_RB_SEND_q_SHIFT) | \
      (rb_rtr_q << MH_DEBUG_REG01_RB_RTR_q_SHIFT) | \
      (pa_send_q << MH_DEBUG_REG01_PA_SEND_q_SHIFT) | \
      (pa_rtr_q << MH_DEBUG_REG01_PA_RTR_q_SHIFT))

#define MH_DEBUG_REG01_GET_CP_SEND_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_CP_SEND_q_MASK) >> MH_DEBUG_REG01_CP_SEND_q_SHIFT)
#define MH_DEBUG_REG01_GET_CP_RTR_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_CP_RTR_q_MASK) >> MH_DEBUG_REG01_CP_RTR_q_SHIFT)
#define MH_DEBUG_REG01_GET_CP_WRITE_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_CP_WRITE_q_MASK) >> MH_DEBUG_REG01_CP_WRITE_q_SHIFT)
#define MH_DEBUG_REG01_GET_CP_TAG_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_CP_TAG_q_MASK) >> MH_DEBUG_REG01_CP_TAG_q_SHIFT)
#define MH_DEBUG_REG01_GET_CP_BLEN_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_CP_BLEN_q_MASK) >> MH_DEBUG_REG01_CP_BLEN_q_SHIFT)
#define MH_DEBUG_REG01_GET_VGT_SEND_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_VGT_SEND_q_MASK) >> MH_DEBUG_REG01_VGT_SEND_q_SHIFT)
#define MH_DEBUG_REG01_GET_VGT_RTR_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_VGT_RTR_q_MASK) >> MH_DEBUG_REG01_VGT_RTR_q_SHIFT)
#define MH_DEBUG_REG01_GET_VGT_TAG_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_VGT_TAG_q_MASK) >> MH_DEBUG_REG01_VGT_TAG_q_SHIFT)
#define MH_DEBUG_REG01_GET_TC_SEND_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_TC_SEND_q_MASK) >> MH_DEBUG_REG01_TC_SEND_q_SHIFT)
#define MH_DEBUG_REG01_GET_TC_RTR_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_TC_RTR_q_MASK) >> MH_DEBUG_REG01_TC_RTR_q_SHIFT)
#define MH_DEBUG_REG01_GET_TC_BLEN_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_TC_BLEN_q_MASK) >> MH_DEBUG_REG01_TC_BLEN_q_SHIFT)
#define MH_DEBUG_REG01_GET_TC_ROQ_SEND_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_TC_ROQ_SEND_q_MASK) >> MH_DEBUG_REG01_TC_ROQ_SEND_q_SHIFT)
#define MH_DEBUG_REG01_GET_TC_ROQ_RTR_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG01_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG01_GET_TC_MH_written(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_TC_MH_written_MASK) >> MH_DEBUG_REG01_TC_MH_written_SHIFT)
#define MH_DEBUG_REG01_GET_RB_SEND_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_RB_SEND_q_MASK) >> MH_DEBUG_REG01_RB_SEND_q_SHIFT)
#define MH_DEBUG_REG01_GET_RB_RTR_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_RB_RTR_q_MASK) >> MH_DEBUG_REG01_RB_RTR_q_SHIFT)
#define MH_DEBUG_REG01_GET_PA_SEND_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_PA_SEND_q_MASK) >> MH_DEBUG_REG01_PA_SEND_q_SHIFT)
#define MH_DEBUG_REG01_GET_PA_RTR_q(mh_debug_reg01) \
     ((mh_debug_reg01 & MH_DEBUG_REG01_PA_RTR_q_MASK) >> MH_DEBUG_REG01_PA_RTR_q_SHIFT)

#define MH_DEBUG_REG01_SET_CP_SEND_q(mh_debug_reg01_reg, cp_send_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_CP_SEND_q_MASK) | (cp_send_q << MH_DEBUG_REG01_CP_SEND_q_SHIFT)
#define MH_DEBUG_REG01_SET_CP_RTR_q(mh_debug_reg01_reg, cp_rtr_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_CP_RTR_q_MASK) | (cp_rtr_q << MH_DEBUG_REG01_CP_RTR_q_SHIFT)
#define MH_DEBUG_REG01_SET_CP_WRITE_q(mh_debug_reg01_reg, cp_write_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_CP_WRITE_q_MASK) | (cp_write_q << MH_DEBUG_REG01_CP_WRITE_q_SHIFT)
#define MH_DEBUG_REG01_SET_CP_TAG_q(mh_debug_reg01_reg, cp_tag_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_CP_TAG_q_MASK) | (cp_tag_q << MH_DEBUG_REG01_CP_TAG_q_SHIFT)
#define MH_DEBUG_REG01_SET_CP_BLEN_q(mh_debug_reg01_reg, cp_blen_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_CP_BLEN_q_MASK) | (cp_blen_q << MH_DEBUG_REG01_CP_BLEN_q_SHIFT)
#define MH_DEBUG_REG01_SET_VGT_SEND_q(mh_debug_reg01_reg, vgt_send_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_VGT_SEND_q_MASK) | (vgt_send_q << MH_DEBUG_REG01_VGT_SEND_q_SHIFT)
#define MH_DEBUG_REG01_SET_VGT_RTR_q(mh_debug_reg01_reg, vgt_rtr_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_VGT_RTR_q_MASK) | (vgt_rtr_q << MH_DEBUG_REG01_VGT_RTR_q_SHIFT)
#define MH_DEBUG_REG01_SET_VGT_TAG_q(mh_debug_reg01_reg, vgt_tag_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_VGT_TAG_q_MASK) | (vgt_tag_q << MH_DEBUG_REG01_VGT_TAG_q_SHIFT)
#define MH_DEBUG_REG01_SET_TC_SEND_q(mh_debug_reg01_reg, tc_send_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_TC_SEND_q_MASK) | (tc_send_q << MH_DEBUG_REG01_TC_SEND_q_SHIFT)
#define MH_DEBUG_REG01_SET_TC_RTR_q(mh_debug_reg01_reg, tc_rtr_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_TC_RTR_q_MASK) | (tc_rtr_q << MH_DEBUG_REG01_TC_RTR_q_SHIFT)
#define MH_DEBUG_REG01_SET_TC_BLEN_q(mh_debug_reg01_reg, tc_blen_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_TC_BLEN_q_MASK) | (tc_blen_q << MH_DEBUG_REG01_TC_BLEN_q_SHIFT)
#define MH_DEBUG_REG01_SET_TC_ROQ_SEND_q(mh_debug_reg01_reg, tc_roq_send_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_TC_ROQ_SEND_q_MASK) | (tc_roq_send_q << MH_DEBUG_REG01_TC_ROQ_SEND_q_SHIFT)
#define MH_DEBUG_REG01_SET_TC_ROQ_RTR_q(mh_debug_reg01_reg, tc_roq_rtr_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG01_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG01_SET_TC_MH_written(mh_debug_reg01_reg, tc_mh_written) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_TC_MH_written_MASK) | (tc_mh_written << MH_DEBUG_REG01_TC_MH_written_SHIFT)
#define MH_DEBUG_REG01_SET_RB_SEND_q(mh_debug_reg01_reg, rb_send_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_RB_SEND_q_MASK) | (rb_send_q << MH_DEBUG_REG01_RB_SEND_q_SHIFT)
#define MH_DEBUG_REG01_SET_RB_RTR_q(mh_debug_reg01_reg, rb_rtr_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_RB_RTR_q_MASK) | (rb_rtr_q << MH_DEBUG_REG01_RB_RTR_q_SHIFT)
#define MH_DEBUG_REG01_SET_PA_SEND_q(mh_debug_reg01_reg, pa_send_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_PA_SEND_q_MASK) | (pa_send_q << MH_DEBUG_REG01_PA_SEND_q_SHIFT)
#define MH_DEBUG_REG01_SET_PA_RTR_q(mh_debug_reg01_reg, pa_rtr_q) \
     mh_debug_reg01_reg = (mh_debug_reg01_reg & ~MH_DEBUG_REG01_PA_RTR_q_MASK) | (pa_rtr_q << MH_DEBUG_REG01_PA_RTR_q_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg01_t {
          unsigned int cp_send_q                      : MH_DEBUG_REG01_CP_SEND_q_SIZE;
          unsigned int cp_rtr_q                       : MH_DEBUG_REG01_CP_RTR_q_SIZE;
          unsigned int cp_write_q                     : MH_DEBUG_REG01_CP_WRITE_q_SIZE;
          unsigned int cp_tag_q                       : MH_DEBUG_REG01_CP_TAG_q_SIZE;
          unsigned int cp_blen_q                      : MH_DEBUG_REG01_CP_BLEN_q_SIZE;
          unsigned int vgt_send_q                     : MH_DEBUG_REG01_VGT_SEND_q_SIZE;
          unsigned int vgt_rtr_q                      : MH_DEBUG_REG01_VGT_RTR_q_SIZE;
          unsigned int vgt_tag_q                      : MH_DEBUG_REG01_VGT_TAG_q_SIZE;
          unsigned int tc_send_q                      : MH_DEBUG_REG01_TC_SEND_q_SIZE;
          unsigned int tc_rtr_q                       : MH_DEBUG_REG01_TC_RTR_q_SIZE;
          unsigned int tc_blen_q                      : MH_DEBUG_REG01_TC_BLEN_q_SIZE;
          unsigned int tc_roq_send_q                  : MH_DEBUG_REG01_TC_ROQ_SEND_q_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG01_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_written                  : MH_DEBUG_REG01_TC_MH_written_SIZE;
          unsigned int rb_send_q                      : MH_DEBUG_REG01_RB_SEND_q_SIZE;
          unsigned int rb_rtr_q                       : MH_DEBUG_REG01_RB_RTR_q_SIZE;
          unsigned int pa_send_q                      : MH_DEBUG_REG01_PA_SEND_q_SIZE;
          unsigned int pa_rtr_q                       : MH_DEBUG_REG01_PA_RTR_q_SIZE;
          unsigned int                                : 12;
     } mh_debug_reg01_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg01_t {
          unsigned int                                : 12;
          unsigned int pa_rtr_q                       : MH_DEBUG_REG01_PA_RTR_q_SIZE;
          unsigned int pa_send_q                      : MH_DEBUG_REG01_PA_SEND_q_SIZE;
          unsigned int rb_rtr_q                       : MH_DEBUG_REG01_RB_RTR_q_SIZE;
          unsigned int rb_send_q                      : MH_DEBUG_REG01_RB_SEND_q_SIZE;
          unsigned int tc_mh_written                  : MH_DEBUG_REG01_TC_MH_written_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG01_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_roq_send_q                  : MH_DEBUG_REG01_TC_ROQ_SEND_q_SIZE;
          unsigned int tc_blen_q                      : MH_DEBUG_REG01_TC_BLEN_q_SIZE;
          unsigned int tc_rtr_q                       : MH_DEBUG_REG01_TC_RTR_q_SIZE;
          unsigned int tc_send_q                      : MH_DEBUG_REG01_TC_SEND_q_SIZE;
          unsigned int vgt_tag_q                      : MH_DEBUG_REG01_VGT_TAG_q_SIZE;
          unsigned int vgt_rtr_q                      : MH_DEBUG_REG01_VGT_RTR_q_SIZE;
          unsigned int vgt_send_q                     : MH_DEBUG_REG01_VGT_SEND_q_SIZE;
          unsigned int cp_blen_q                      : MH_DEBUG_REG01_CP_BLEN_q_SIZE;
          unsigned int cp_tag_q                       : MH_DEBUG_REG01_CP_TAG_q_SIZE;
          unsigned int cp_write_q                     : MH_DEBUG_REG01_CP_WRITE_q_SIZE;
          unsigned int cp_rtr_q                       : MH_DEBUG_REG01_CP_RTR_q_SIZE;
          unsigned int cp_send_q                      : MH_DEBUG_REG01_CP_SEND_q_SIZE;
     } mh_debug_reg01_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg01_t f;
} mh_debug_reg01_u;


/*
 * MH_DEBUG_REG02 struct
 */

#define MH_DEBUG_REG02_MH_CP_grb_send_SIZE 1
#define MH_DEBUG_REG02_MH_VGT_grb_send_SIZE 1
#define MH_DEBUG_REG02_MH_TC_mcsend_SIZE 1
#define MH_DEBUG_REG02_MH_CLNT_rlast_SIZE 1
#define MH_DEBUG_REG02_MH_CLNT_tag_SIZE 3
#define MH_DEBUG_REG02_RDC_RID_SIZE    3
#define MH_DEBUG_REG02_RDC_RRESP_SIZE  2
#define MH_DEBUG_REG02_MH_CP_writeclean_SIZE 1
#define MH_DEBUG_REG02_MH_RB_writeclean_SIZE 1
#define MH_DEBUG_REG02_MH_PA_writeclean_SIZE 1
#define MH_DEBUG_REG02_BRC_BID_SIZE    3
#define MH_DEBUG_REG02_BRC_BRESP_SIZE  2

#define MH_DEBUG_REG02_MH_CP_grb_send_SHIFT 0
#define MH_DEBUG_REG02_MH_VGT_grb_send_SHIFT 1
#define MH_DEBUG_REG02_MH_TC_mcsend_SHIFT 2
#define MH_DEBUG_REG02_MH_CLNT_rlast_SHIFT 3
#define MH_DEBUG_REG02_MH_CLNT_tag_SHIFT 4
#define MH_DEBUG_REG02_RDC_RID_SHIFT   7
#define MH_DEBUG_REG02_RDC_RRESP_SHIFT 10
#define MH_DEBUG_REG02_MH_CP_writeclean_SHIFT 12
#define MH_DEBUG_REG02_MH_RB_writeclean_SHIFT 13
#define MH_DEBUG_REG02_MH_PA_writeclean_SHIFT 14
#define MH_DEBUG_REG02_BRC_BID_SHIFT   15
#define MH_DEBUG_REG02_BRC_BRESP_SHIFT 18

#define MH_DEBUG_REG02_MH_CP_grb_send_MASK 0x00000001
#define MH_DEBUG_REG02_MH_VGT_grb_send_MASK 0x00000002
#define MH_DEBUG_REG02_MH_TC_mcsend_MASK 0x00000004
#define MH_DEBUG_REG02_MH_CLNT_rlast_MASK 0x00000008
#define MH_DEBUG_REG02_MH_CLNT_tag_MASK 0x00000070
#define MH_DEBUG_REG02_RDC_RID_MASK    0x00000380
#define MH_DEBUG_REG02_RDC_RRESP_MASK  0x00000c00
#define MH_DEBUG_REG02_MH_CP_writeclean_MASK 0x00001000
#define MH_DEBUG_REG02_MH_RB_writeclean_MASK 0x00002000
#define MH_DEBUG_REG02_MH_PA_writeclean_MASK 0x00004000
#define MH_DEBUG_REG02_BRC_BID_MASK    0x00038000
#define MH_DEBUG_REG02_BRC_BRESP_MASK  0x000c0000

#define MH_DEBUG_REG02_MASK \
     (MH_DEBUG_REG02_MH_CP_grb_send_MASK | \
      MH_DEBUG_REG02_MH_VGT_grb_send_MASK | \
      MH_DEBUG_REG02_MH_TC_mcsend_MASK | \
      MH_DEBUG_REG02_MH_CLNT_rlast_MASK | \
      MH_DEBUG_REG02_MH_CLNT_tag_MASK | \
      MH_DEBUG_REG02_RDC_RID_MASK | \
      MH_DEBUG_REG02_RDC_RRESP_MASK | \
      MH_DEBUG_REG02_MH_CP_writeclean_MASK | \
      MH_DEBUG_REG02_MH_RB_writeclean_MASK | \
      MH_DEBUG_REG02_MH_PA_writeclean_MASK | \
      MH_DEBUG_REG02_BRC_BID_MASK | \
      MH_DEBUG_REG02_BRC_BRESP_MASK)

#define MH_DEBUG_REG02(mh_cp_grb_send, mh_vgt_grb_send, mh_tc_mcsend, mh_clnt_rlast, mh_clnt_tag, rdc_rid, rdc_rresp, mh_cp_writeclean, mh_rb_writeclean, mh_pa_writeclean, brc_bid, brc_bresp) \
     ((mh_cp_grb_send << MH_DEBUG_REG02_MH_CP_grb_send_SHIFT) | \
      (mh_vgt_grb_send << MH_DEBUG_REG02_MH_VGT_grb_send_SHIFT) | \
      (mh_tc_mcsend << MH_DEBUG_REG02_MH_TC_mcsend_SHIFT) | \
      (mh_clnt_rlast << MH_DEBUG_REG02_MH_CLNT_rlast_SHIFT) | \
      (mh_clnt_tag << MH_DEBUG_REG02_MH_CLNT_tag_SHIFT) | \
      (rdc_rid << MH_DEBUG_REG02_RDC_RID_SHIFT) | \
      (rdc_rresp << MH_DEBUG_REG02_RDC_RRESP_SHIFT) | \
      (mh_cp_writeclean << MH_DEBUG_REG02_MH_CP_writeclean_SHIFT) | \
      (mh_rb_writeclean << MH_DEBUG_REG02_MH_RB_writeclean_SHIFT) | \
      (mh_pa_writeclean << MH_DEBUG_REG02_MH_PA_writeclean_SHIFT) | \
      (brc_bid << MH_DEBUG_REG02_BRC_BID_SHIFT) | \
      (brc_bresp << MH_DEBUG_REG02_BRC_BRESP_SHIFT))

#define MH_DEBUG_REG02_GET_MH_CP_grb_send(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_MH_CP_grb_send_MASK) >> MH_DEBUG_REG02_MH_CP_grb_send_SHIFT)
#define MH_DEBUG_REG02_GET_MH_VGT_grb_send(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_MH_VGT_grb_send_MASK) >> MH_DEBUG_REG02_MH_VGT_grb_send_SHIFT)
#define MH_DEBUG_REG02_GET_MH_TC_mcsend(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_MH_TC_mcsend_MASK) >> MH_DEBUG_REG02_MH_TC_mcsend_SHIFT)
#define MH_DEBUG_REG02_GET_MH_CLNT_rlast(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_MH_CLNT_rlast_MASK) >> MH_DEBUG_REG02_MH_CLNT_rlast_SHIFT)
#define MH_DEBUG_REG02_GET_MH_CLNT_tag(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_MH_CLNT_tag_MASK) >> MH_DEBUG_REG02_MH_CLNT_tag_SHIFT)
#define MH_DEBUG_REG02_GET_RDC_RID(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_RDC_RID_MASK) >> MH_DEBUG_REG02_RDC_RID_SHIFT)
#define MH_DEBUG_REG02_GET_RDC_RRESP(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_RDC_RRESP_MASK) >> MH_DEBUG_REG02_RDC_RRESP_SHIFT)
#define MH_DEBUG_REG02_GET_MH_CP_writeclean(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_MH_CP_writeclean_MASK) >> MH_DEBUG_REG02_MH_CP_writeclean_SHIFT)
#define MH_DEBUG_REG02_GET_MH_RB_writeclean(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_MH_RB_writeclean_MASK) >> MH_DEBUG_REG02_MH_RB_writeclean_SHIFT)
#define MH_DEBUG_REG02_GET_MH_PA_writeclean(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_MH_PA_writeclean_MASK) >> MH_DEBUG_REG02_MH_PA_writeclean_SHIFT)
#define MH_DEBUG_REG02_GET_BRC_BID(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_BRC_BID_MASK) >> MH_DEBUG_REG02_BRC_BID_SHIFT)
#define MH_DEBUG_REG02_GET_BRC_BRESP(mh_debug_reg02) \
     ((mh_debug_reg02 & MH_DEBUG_REG02_BRC_BRESP_MASK) >> MH_DEBUG_REG02_BRC_BRESP_SHIFT)

#define MH_DEBUG_REG02_SET_MH_CP_grb_send(mh_debug_reg02_reg, mh_cp_grb_send) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_MH_CP_grb_send_MASK) | (mh_cp_grb_send << MH_DEBUG_REG02_MH_CP_grb_send_SHIFT)
#define MH_DEBUG_REG02_SET_MH_VGT_grb_send(mh_debug_reg02_reg, mh_vgt_grb_send) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_MH_VGT_grb_send_MASK) | (mh_vgt_grb_send << MH_DEBUG_REG02_MH_VGT_grb_send_SHIFT)
#define MH_DEBUG_REG02_SET_MH_TC_mcsend(mh_debug_reg02_reg, mh_tc_mcsend) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_MH_TC_mcsend_MASK) | (mh_tc_mcsend << MH_DEBUG_REG02_MH_TC_mcsend_SHIFT)
#define MH_DEBUG_REG02_SET_MH_CLNT_rlast(mh_debug_reg02_reg, mh_clnt_rlast) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_MH_CLNT_rlast_MASK) | (mh_clnt_rlast << MH_DEBUG_REG02_MH_CLNT_rlast_SHIFT)
#define MH_DEBUG_REG02_SET_MH_CLNT_tag(mh_debug_reg02_reg, mh_clnt_tag) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_MH_CLNT_tag_MASK) | (mh_clnt_tag << MH_DEBUG_REG02_MH_CLNT_tag_SHIFT)
#define MH_DEBUG_REG02_SET_RDC_RID(mh_debug_reg02_reg, rdc_rid) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_RDC_RID_MASK) | (rdc_rid << MH_DEBUG_REG02_RDC_RID_SHIFT)
#define MH_DEBUG_REG02_SET_RDC_RRESP(mh_debug_reg02_reg, rdc_rresp) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_RDC_RRESP_MASK) | (rdc_rresp << MH_DEBUG_REG02_RDC_RRESP_SHIFT)
#define MH_DEBUG_REG02_SET_MH_CP_writeclean(mh_debug_reg02_reg, mh_cp_writeclean) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_MH_CP_writeclean_MASK) | (mh_cp_writeclean << MH_DEBUG_REG02_MH_CP_writeclean_SHIFT)
#define MH_DEBUG_REG02_SET_MH_RB_writeclean(mh_debug_reg02_reg, mh_rb_writeclean) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_MH_RB_writeclean_MASK) | (mh_rb_writeclean << MH_DEBUG_REG02_MH_RB_writeclean_SHIFT)
#define MH_DEBUG_REG02_SET_MH_PA_writeclean(mh_debug_reg02_reg, mh_pa_writeclean) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_MH_PA_writeclean_MASK) | (mh_pa_writeclean << MH_DEBUG_REG02_MH_PA_writeclean_SHIFT)
#define MH_DEBUG_REG02_SET_BRC_BID(mh_debug_reg02_reg, brc_bid) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_BRC_BID_MASK) | (brc_bid << MH_DEBUG_REG02_BRC_BID_SHIFT)
#define MH_DEBUG_REG02_SET_BRC_BRESP(mh_debug_reg02_reg, brc_bresp) \
     mh_debug_reg02_reg = (mh_debug_reg02_reg & ~MH_DEBUG_REG02_BRC_BRESP_MASK) | (brc_bresp << MH_DEBUG_REG02_BRC_BRESP_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg02_t {
          unsigned int mh_cp_grb_send                 : MH_DEBUG_REG02_MH_CP_grb_send_SIZE;
          unsigned int mh_vgt_grb_send                : MH_DEBUG_REG02_MH_VGT_grb_send_SIZE;
          unsigned int mh_tc_mcsend                   : MH_DEBUG_REG02_MH_TC_mcsend_SIZE;
          unsigned int mh_clnt_rlast                  : MH_DEBUG_REG02_MH_CLNT_rlast_SIZE;
          unsigned int mh_clnt_tag                    : MH_DEBUG_REG02_MH_CLNT_tag_SIZE;
          unsigned int rdc_rid                        : MH_DEBUG_REG02_RDC_RID_SIZE;
          unsigned int rdc_rresp                      : MH_DEBUG_REG02_RDC_RRESP_SIZE;
          unsigned int mh_cp_writeclean               : MH_DEBUG_REG02_MH_CP_writeclean_SIZE;
          unsigned int mh_rb_writeclean               : MH_DEBUG_REG02_MH_RB_writeclean_SIZE;
          unsigned int mh_pa_writeclean               : MH_DEBUG_REG02_MH_PA_writeclean_SIZE;
          unsigned int brc_bid                        : MH_DEBUG_REG02_BRC_BID_SIZE;
          unsigned int brc_bresp                      : MH_DEBUG_REG02_BRC_BRESP_SIZE;
          unsigned int                                : 12;
     } mh_debug_reg02_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg02_t {
          unsigned int                                : 12;
          unsigned int brc_bresp                      : MH_DEBUG_REG02_BRC_BRESP_SIZE;
          unsigned int brc_bid                        : MH_DEBUG_REG02_BRC_BID_SIZE;
          unsigned int mh_pa_writeclean               : MH_DEBUG_REG02_MH_PA_writeclean_SIZE;
          unsigned int mh_rb_writeclean               : MH_DEBUG_REG02_MH_RB_writeclean_SIZE;
          unsigned int mh_cp_writeclean               : MH_DEBUG_REG02_MH_CP_writeclean_SIZE;
          unsigned int rdc_rresp                      : MH_DEBUG_REG02_RDC_RRESP_SIZE;
          unsigned int rdc_rid                        : MH_DEBUG_REG02_RDC_RID_SIZE;
          unsigned int mh_clnt_tag                    : MH_DEBUG_REG02_MH_CLNT_tag_SIZE;
          unsigned int mh_clnt_rlast                  : MH_DEBUG_REG02_MH_CLNT_rlast_SIZE;
          unsigned int mh_tc_mcsend                   : MH_DEBUG_REG02_MH_TC_mcsend_SIZE;
          unsigned int mh_vgt_grb_send                : MH_DEBUG_REG02_MH_VGT_grb_send_SIZE;
          unsigned int mh_cp_grb_send                 : MH_DEBUG_REG02_MH_CP_grb_send_SIZE;
     } mh_debug_reg02_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg02_t f;
} mh_debug_reg02_u;


/*
 * MH_DEBUG_REG03 struct
 */

#define MH_DEBUG_REG03_MH_CLNT_data_31_0_SIZE 32

#define MH_DEBUG_REG03_MH_CLNT_data_31_0_SHIFT 0

#define MH_DEBUG_REG03_MH_CLNT_data_31_0_MASK 0xffffffff

#define MH_DEBUG_REG03_MASK \
     (MH_DEBUG_REG03_MH_CLNT_data_31_0_MASK)

#define MH_DEBUG_REG03(mh_clnt_data_31_0) \
     ((mh_clnt_data_31_0 << MH_DEBUG_REG03_MH_CLNT_data_31_0_SHIFT))

#define MH_DEBUG_REG03_GET_MH_CLNT_data_31_0(mh_debug_reg03) \
     ((mh_debug_reg03 & MH_DEBUG_REG03_MH_CLNT_data_31_0_MASK) >> MH_DEBUG_REG03_MH_CLNT_data_31_0_SHIFT)

#define MH_DEBUG_REG03_SET_MH_CLNT_data_31_0(mh_debug_reg03_reg, mh_clnt_data_31_0) \
     mh_debug_reg03_reg = (mh_debug_reg03_reg & ~MH_DEBUG_REG03_MH_CLNT_data_31_0_MASK) | (mh_clnt_data_31_0 << MH_DEBUG_REG03_MH_CLNT_data_31_0_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg03_t {
          unsigned int mh_clnt_data_31_0              : MH_DEBUG_REG03_MH_CLNT_data_31_0_SIZE;
     } mh_debug_reg03_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg03_t {
          unsigned int mh_clnt_data_31_0              : MH_DEBUG_REG03_MH_CLNT_data_31_0_SIZE;
     } mh_debug_reg03_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg03_t f;
} mh_debug_reg03_u;


/*
 * MH_DEBUG_REG04 struct
 */

#define MH_DEBUG_REG04_MH_CLNT_data_63_32_SIZE 32

#define MH_DEBUG_REG04_MH_CLNT_data_63_32_SHIFT 0

#define MH_DEBUG_REG04_MH_CLNT_data_63_32_MASK 0xffffffff

#define MH_DEBUG_REG04_MASK \
     (MH_DEBUG_REG04_MH_CLNT_data_63_32_MASK)

#define MH_DEBUG_REG04(mh_clnt_data_63_32) \
     ((mh_clnt_data_63_32 << MH_DEBUG_REG04_MH_CLNT_data_63_32_SHIFT))

#define MH_DEBUG_REG04_GET_MH_CLNT_data_63_32(mh_debug_reg04) \
     ((mh_debug_reg04 & MH_DEBUG_REG04_MH_CLNT_data_63_32_MASK) >> MH_DEBUG_REG04_MH_CLNT_data_63_32_SHIFT)

#define MH_DEBUG_REG04_SET_MH_CLNT_data_63_32(mh_debug_reg04_reg, mh_clnt_data_63_32) \
     mh_debug_reg04_reg = (mh_debug_reg04_reg & ~MH_DEBUG_REG04_MH_CLNT_data_63_32_MASK) | (mh_clnt_data_63_32 << MH_DEBUG_REG04_MH_CLNT_data_63_32_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg04_t {
          unsigned int mh_clnt_data_63_32             : MH_DEBUG_REG04_MH_CLNT_data_63_32_SIZE;
     } mh_debug_reg04_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg04_t {
          unsigned int mh_clnt_data_63_32             : MH_DEBUG_REG04_MH_CLNT_data_63_32_SIZE;
     } mh_debug_reg04_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg04_t f;
} mh_debug_reg04_u;


/*
 * MH_DEBUG_REG05 struct
 */

#define MH_DEBUG_REG05_CP_MH_send_SIZE 1
#define MH_DEBUG_REG05_CP_MH_write_SIZE 1
#define MH_DEBUG_REG05_CP_MH_tag_SIZE  3
#define MH_DEBUG_REG05_CP_MH_ad_31_5_SIZE 27

#define MH_DEBUG_REG05_CP_MH_send_SHIFT 0
#define MH_DEBUG_REG05_CP_MH_write_SHIFT 1
#define MH_DEBUG_REG05_CP_MH_tag_SHIFT 2
#define MH_DEBUG_REG05_CP_MH_ad_31_5_SHIFT 5

#define MH_DEBUG_REG05_CP_MH_send_MASK 0x00000001
#define MH_DEBUG_REG05_CP_MH_write_MASK 0x00000002
#define MH_DEBUG_REG05_CP_MH_tag_MASK  0x0000001c
#define MH_DEBUG_REG05_CP_MH_ad_31_5_MASK 0xffffffe0

#define MH_DEBUG_REG05_MASK \
     (MH_DEBUG_REG05_CP_MH_send_MASK | \
      MH_DEBUG_REG05_CP_MH_write_MASK | \
      MH_DEBUG_REG05_CP_MH_tag_MASK | \
      MH_DEBUG_REG05_CP_MH_ad_31_5_MASK)

#define MH_DEBUG_REG05(cp_mh_send, cp_mh_write, cp_mh_tag, cp_mh_ad_31_5) \
     ((cp_mh_send << MH_DEBUG_REG05_CP_MH_send_SHIFT) | \
      (cp_mh_write << MH_DEBUG_REG05_CP_MH_write_SHIFT) | \
      (cp_mh_tag << MH_DEBUG_REG05_CP_MH_tag_SHIFT) | \
      (cp_mh_ad_31_5 << MH_DEBUG_REG05_CP_MH_ad_31_5_SHIFT))

#define MH_DEBUG_REG05_GET_CP_MH_send(mh_debug_reg05) \
     ((mh_debug_reg05 & MH_DEBUG_REG05_CP_MH_send_MASK) >> MH_DEBUG_REG05_CP_MH_send_SHIFT)
#define MH_DEBUG_REG05_GET_CP_MH_write(mh_debug_reg05) \
     ((mh_debug_reg05 & MH_DEBUG_REG05_CP_MH_write_MASK) >> MH_DEBUG_REG05_CP_MH_write_SHIFT)
#define MH_DEBUG_REG05_GET_CP_MH_tag(mh_debug_reg05) \
     ((mh_debug_reg05 & MH_DEBUG_REG05_CP_MH_tag_MASK) >> MH_DEBUG_REG05_CP_MH_tag_SHIFT)
#define MH_DEBUG_REG05_GET_CP_MH_ad_31_5(mh_debug_reg05) \
     ((mh_debug_reg05 & MH_DEBUG_REG05_CP_MH_ad_31_5_MASK) >> MH_DEBUG_REG05_CP_MH_ad_31_5_SHIFT)

#define MH_DEBUG_REG05_SET_CP_MH_send(mh_debug_reg05_reg, cp_mh_send) \
     mh_debug_reg05_reg = (mh_debug_reg05_reg & ~MH_DEBUG_REG05_CP_MH_send_MASK) | (cp_mh_send << MH_DEBUG_REG05_CP_MH_send_SHIFT)
#define MH_DEBUG_REG05_SET_CP_MH_write(mh_debug_reg05_reg, cp_mh_write) \
     mh_debug_reg05_reg = (mh_debug_reg05_reg & ~MH_DEBUG_REG05_CP_MH_write_MASK) | (cp_mh_write << MH_DEBUG_REG05_CP_MH_write_SHIFT)
#define MH_DEBUG_REG05_SET_CP_MH_tag(mh_debug_reg05_reg, cp_mh_tag) \
     mh_debug_reg05_reg = (mh_debug_reg05_reg & ~MH_DEBUG_REG05_CP_MH_tag_MASK) | (cp_mh_tag << MH_DEBUG_REG05_CP_MH_tag_SHIFT)
#define MH_DEBUG_REG05_SET_CP_MH_ad_31_5(mh_debug_reg05_reg, cp_mh_ad_31_5) \
     mh_debug_reg05_reg = (mh_debug_reg05_reg & ~MH_DEBUG_REG05_CP_MH_ad_31_5_MASK) | (cp_mh_ad_31_5 << MH_DEBUG_REG05_CP_MH_ad_31_5_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg05_t {
          unsigned int cp_mh_send                     : MH_DEBUG_REG05_CP_MH_send_SIZE;
          unsigned int cp_mh_write                    : MH_DEBUG_REG05_CP_MH_write_SIZE;
          unsigned int cp_mh_tag                      : MH_DEBUG_REG05_CP_MH_tag_SIZE;
          unsigned int cp_mh_ad_31_5                  : MH_DEBUG_REG05_CP_MH_ad_31_5_SIZE;
     } mh_debug_reg05_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg05_t {
          unsigned int cp_mh_ad_31_5                  : MH_DEBUG_REG05_CP_MH_ad_31_5_SIZE;
          unsigned int cp_mh_tag                      : MH_DEBUG_REG05_CP_MH_tag_SIZE;
          unsigned int cp_mh_write                    : MH_DEBUG_REG05_CP_MH_write_SIZE;
          unsigned int cp_mh_send                     : MH_DEBUG_REG05_CP_MH_send_SIZE;
     } mh_debug_reg05_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg05_t f;
} mh_debug_reg05_u;


/*
 * MH_DEBUG_REG06 struct
 */

#define MH_DEBUG_REG06_CP_MH_data_31_0_SIZE 32

#define MH_DEBUG_REG06_CP_MH_data_31_0_SHIFT 0

#define MH_DEBUG_REG06_CP_MH_data_31_0_MASK 0xffffffff

#define MH_DEBUG_REG06_MASK \
     (MH_DEBUG_REG06_CP_MH_data_31_0_MASK)

#define MH_DEBUG_REG06(cp_mh_data_31_0) \
     ((cp_mh_data_31_0 << MH_DEBUG_REG06_CP_MH_data_31_0_SHIFT))

#define MH_DEBUG_REG06_GET_CP_MH_data_31_0(mh_debug_reg06) \
     ((mh_debug_reg06 & MH_DEBUG_REG06_CP_MH_data_31_0_MASK) >> MH_DEBUG_REG06_CP_MH_data_31_0_SHIFT)

#define MH_DEBUG_REG06_SET_CP_MH_data_31_0(mh_debug_reg06_reg, cp_mh_data_31_0) \
     mh_debug_reg06_reg = (mh_debug_reg06_reg & ~MH_DEBUG_REG06_CP_MH_data_31_0_MASK) | (cp_mh_data_31_0 << MH_DEBUG_REG06_CP_MH_data_31_0_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg06_t {
          unsigned int cp_mh_data_31_0                : MH_DEBUG_REG06_CP_MH_data_31_0_SIZE;
     } mh_debug_reg06_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg06_t {
          unsigned int cp_mh_data_31_0                : MH_DEBUG_REG06_CP_MH_data_31_0_SIZE;
     } mh_debug_reg06_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg06_t f;
} mh_debug_reg06_u;


/*
 * MH_DEBUG_REG07 struct
 */

#define MH_DEBUG_REG07_CP_MH_data_63_32_SIZE 32

#define MH_DEBUG_REG07_CP_MH_data_63_32_SHIFT 0

#define MH_DEBUG_REG07_CP_MH_data_63_32_MASK 0xffffffff

#define MH_DEBUG_REG07_MASK \
     (MH_DEBUG_REG07_CP_MH_data_63_32_MASK)

#define MH_DEBUG_REG07(cp_mh_data_63_32) \
     ((cp_mh_data_63_32 << MH_DEBUG_REG07_CP_MH_data_63_32_SHIFT))

#define MH_DEBUG_REG07_GET_CP_MH_data_63_32(mh_debug_reg07) \
     ((mh_debug_reg07 & MH_DEBUG_REG07_CP_MH_data_63_32_MASK) >> MH_DEBUG_REG07_CP_MH_data_63_32_SHIFT)

#define MH_DEBUG_REG07_SET_CP_MH_data_63_32(mh_debug_reg07_reg, cp_mh_data_63_32) \
     mh_debug_reg07_reg = (mh_debug_reg07_reg & ~MH_DEBUG_REG07_CP_MH_data_63_32_MASK) | (cp_mh_data_63_32 << MH_DEBUG_REG07_CP_MH_data_63_32_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg07_t {
          unsigned int cp_mh_data_63_32               : MH_DEBUG_REG07_CP_MH_data_63_32_SIZE;
     } mh_debug_reg07_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg07_t {
          unsigned int cp_mh_data_63_32               : MH_DEBUG_REG07_CP_MH_data_63_32_SIZE;
     } mh_debug_reg07_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg07_t f;
} mh_debug_reg07_u;


/*
 * MH_DEBUG_REG08 struct
 */

#define MH_DEBUG_REG08_CP_MH_be_SIZE   8
#define MH_DEBUG_REG08_RB_MH_be_SIZE   8
#define MH_DEBUG_REG08_PA_MH_be_SIZE   8

#define MH_DEBUG_REG08_CP_MH_be_SHIFT  0
#define MH_DEBUG_REG08_RB_MH_be_SHIFT  8
#define MH_DEBUG_REG08_PA_MH_be_SHIFT  16

#define MH_DEBUG_REG08_CP_MH_be_MASK   0x000000ff
#define MH_DEBUG_REG08_RB_MH_be_MASK   0x0000ff00
#define MH_DEBUG_REG08_PA_MH_be_MASK   0x00ff0000

#define MH_DEBUG_REG08_MASK \
     (MH_DEBUG_REG08_CP_MH_be_MASK | \
      MH_DEBUG_REG08_RB_MH_be_MASK | \
      MH_DEBUG_REG08_PA_MH_be_MASK)

#define MH_DEBUG_REG08(cp_mh_be, rb_mh_be, pa_mh_be) \
     ((cp_mh_be << MH_DEBUG_REG08_CP_MH_be_SHIFT) | \
      (rb_mh_be << MH_DEBUG_REG08_RB_MH_be_SHIFT) | \
      (pa_mh_be << MH_DEBUG_REG08_PA_MH_be_SHIFT))

#define MH_DEBUG_REG08_GET_CP_MH_be(mh_debug_reg08) \
     ((mh_debug_reg08 & MH_DEBUG_REG08_CP_MH_be_MASK) >> MH_DEBUG_REG08_CP_MH_be_SHIFT)
#define MH_DEBUG_REG08_GET_RB_MH_be(mh_debug_reg08) \
     ((mh_debug_reg08 & MH_DEBUG_REG08_RB_MH_be_MASK) >> MH_DEBUG_REG08_RB_MH_be_SHIFT)
#define MH_DEBUG_REG08_GET_PA_MH_be(mh_debug_reg08) \
     ((mh_debug_reg08 & MH_DEBUG_REG08_PA_MH_be_MASK) >> MH_DEBUG_REG08_PA_MH_be_SHIFT)

#define MH_DEBUG_REG08_SET_CP_MH_be(mh_debug_reg08_reg, cp_mh_be) \
     mh_debug_reg08_reg = (mh_debug_reg08_reg & ~MH_DEBUG_REG08_CP_MH_be_MASK) | (cp_mh_be << MH_DEBUG_REG08_CP_MH_be_SHIFT)
#define MH_DEBUG_REG08_SET_RB_MH_be(mh_debug_reg08_reg, rb_mh_be) \
     mh_debug_reg08_reg = (mh_debug_reg08_reg & ~MH_DEBUG_REG08_RB_MH_be_MASK) | (rb_mh_be << MH_DEBUG_REG08_RB_MH_be_SHIFT)
#define MH_DEBUG_REG08_SET_PA_MH_be(mh_debug_reg08_reg, pa_mh_be) \
     mh_debug_reg08_reg = (mh_debug_reg08_reg & ~MH_DEBUG_REG08_PA_MH_be_MASK) | (pa_mh_be << MH_DEBUG_REG08_PA_MH_be_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg08_t {
          unsigned int cp_mh_be                       : MH_DEBUG_REG08_CP_MH_be_SIZE;
          unsigned int rb_mh_be                       : MH_DEBUG_REG08_RB_MH_be_SIZE;
          unsigned int pa_mh_be                       : MH_DEBUG_REG08_PA_MH_be_SIZE;
          unsigned int                                : 8;
     } mh_debug_reg08_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg08_t {
          unsigned int                                : 8;
          unsigned int pa_mh_be                       : MH_DEBUG_REG08_PA_MH_be_SIZE;
          unsigned int rb_mh_be                       : MH_DEBUG_REG08_RB_MH_be_SIZE;
          unsigned int cp_mh_be                       : MH_DEBUG_REG08_CP_MH_be_SIZE;
     } mh_debug_reg08_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg08_t f;
} mh_debug_reg08_u;


/*
 * MH_DEBUG_REG09 struct
 */

#define MH_DEBUG_REG09_ALWAYS_ZERO_SIZE 3
#define MH_DEBUG_REG09_VGT_MH_send_SIZE 1
#define MH_DEBUG_REG09_VGT_MH_tagbe_SIZE 1
#define MH_DEBUG_REG09_VGT_MH_ad_31_5_SIZE 27

#define MH_DEBUG_REG09_ALWAYS_ZERO_SHIFT 0
#define MH_DEBUG_REG09_VGT_MH_send_SHIFT 3
#define MH_DEBUG_REG09_VGT_MH_tagbe_SHIFT 4
#define MH_DEBUG_REG09_VGT_MH_ad_31_5_SHIFT 5

#define MH_DEBUG_REG09_ALWAYS_ZERO_MASK 0x00000007
#define MH_DEBUG_REG09_VGT_MH_send_MASK 0x00000008
#define MH_DEBUG_REG09_VGT_MH_tagbe_MASK 0x00000010
#define MH_DEBUG_REG09_VGT_MH_ad_31_5_MASK 0xffffffe0

#define MH_DEBUG_REG09_MASK \
     (MH_DEBUG_REG09_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG09_VGT_MH_send_MASK | \
      MH_DEBUG_REG09_VGT_MH_tagbe_MASK | \
      MH_DEBUG_REG09_VGT_MH_ad_31_5_MASK)

#define MH_DEBUG_REG09(always_zero, vgt_mh_send, vgt_mh_tagbe, vgt_mh_ad_31_5) \
     ((always_zero << MH_DEBUG_REG09_ALWAYS_ZERO_SHIFT) | \
      (vgt_mh_send << MH_DEBUG_REG09_VGT_MH_send_SHIFT) | \
      (vgt_mh_tagbe << MH_DEBUG_REG09_VGT_MH_tagbe_SHIFT) | \
      (vgt_mh_ad_31_5 << MH_DEBUG_REG09_VGT_MH_ad_31_5_SHIFT))

#define MH_DEBUG_REG09_GET_ALWAYS_ZERO(mh_debug_reg09) \
     ((mh_debug_reg09 & MH_DEBUG_REG09_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG09_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG09_GET_VGT_MH_send(mh_debug_reg09) \
     ((mh_debug_reg09 & MH_DEBUG_REG09_VGT_MH_send_MASK) >> MH_DEBUG_REG09_VGT_MH_send_SHIFT)
#define MH_DEBUG_REG09_GET_VGT_MH_tagbe(mh_debug_reg09) \
     ((mh_debug_reg09 & MH_DEBUG_REG09_VGT_MH_tagbe_MASK) >> MH_DEBUG_REG09_VGT_MH_tagbe_SHIFT)
#define MH_DEBUG_REG09_GET_VGT_MH_ad_31_5(mh_debug_reg09) \
     ((mh_debug_reg09 & MH_DEBUG_REG09_VGT_MH_ad_31_5_MASK) >> MH_DEBUG_REG09_VGT_MH_ad_31_5_SHIFT)

#define MH_DEBUG_REG09_SET_ALWAYS_ZERO(mh_debug_reg09_reg, always_zero) \
     mh_debug_reg09_reg = (mh_debug_reg09_reg & ~MH_DEBUG_REG09_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG09_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG09_SET_VGT_MH_send(mh_debug_reg09_reg, vgt_mh_send) \
     mh_debug_reg09_reg = (mh_debug_reg09_reg & ~MH_DEBUG_REG09_VGT_MH_send_MASK) | (vgt_mh_send << MH_DEBUG_REG09_VGT_MH_send_SHIFT)
#define MH_DEBUG_REG09_SET_VGT_MH_tagbe(mh_debug_reg09_reg, vgt_mh_tagbe) \
     mh_debug_reg09_reg = (mh_debug_reg09_reg & ~MH_DEBUG_REG09_VGT_MH_tagbe_MASK) | (vgt_mh_tagbe << MH_DEBUG_REG09_VGT_MH_tagbe_SHIFT)
#define MH_DEBUG_REG09_SET_VGT_MH_ad_31_5(mh_debug_reg09_reg, vgt_mh_ad_31_5) \
     mh_debug_reg09_reg = (mh_debug_reg09_reg & ~MH_DEBUG_REG09_VGT_MH_ad_31_5_MASK) | (vgt_mh_ad_31_5 << MH_DEBUG_REG09_VGT_MH_ad_31_5_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg09_t {
          unsigned int always_zero                    : MH_DEBUG_REG09_ALWAYS_ZERO_SIZE;
          unsigned int vgt_mh_send                    : MH_DEBUG_REG09_VGT_MH_send_SIZE;
          unsigned int vgt_mh_tagbe                   : MH_DEBUG_REG09_VGT_MH_tagbe_SIZE;
          unsigned int vgt_mh_ad_31_5                 : MH_DEBUG_REG09_VGT_MH_ad_31_5_SIZE;
     } mh_debug_reg09_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg09_t {
          unsigned int vgt_mh_ad_31_5                 : MH_DEBUG_REG09_VGT_MH_ad_31_5_SIZE;
          unsigned int vgt_mh_tagbe                   : MH_DEBUG_REG09_VGT_MH_tagbe_SIZE;
          unsigned int vgt_mh_send                    : MH_DEBUG_REG09_VGT_MH_send_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG09_ALWAYS_ZERO_SIZE;
     } mh_debug_reg09_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg09_t f;
} mh_debug_reg09_u;


/*
 * MH_DEBUG_REG10 struct
 */

#define MH_DEBUG_REG10_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG10_TC_MH_send_SIZE 1
#define MH_DEBUG_REG10_TC_MH_mask_SIZE 2
#define MH_DEBUG_REG10_TC_MH_addr_31_5_SIZE 27

#define MH_DEBUG_REG10_ALWAYS_ZERO_SHIFT 0
#define MH_DEBUG_REG10_TC_MH_send_SHIFT 2
#define MH_DEBUG_REG10_TC_MH_mask_SHIFT 3
#define MH_DEBUG_REG10_TC_MH_addr_31_5_SHIFT 5

#define MH_DEBUG_REG10_ALWAYS_ZERO_MASK 0x00000003
#define MH_DEBUG_REG10_TC_MH_send_MASK 0x00000004
#define MH_DEBUG_REG10_TC_MH_mask_MASK 0x00000018
#define MH_DEBUG_REG10_TC_MH_addr_31_5_MASK 0xffffffe0

#define MH_DEBUG_REG10_MASK \
     (MH_DEBUG_REG10_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG10_TC_MH_send_MASK | \
      MH_DEBUG_REG10_TC_MH_mask_MASK | \
      MH_DEBUG_REG10_TC_MH_addr_31_5_MASK)

#define MH_DEBUG_REG10(always_zero, tc_mh_send, tc_mh_mask, tc_mh_addr_31_5) \
     ((always_zero << MH_DEBUG_REG10_ALWAYS_ZERO_SHIFT) | \
      (tc_mh_send << MH_DEBUG_REG10_TC_MH_send_SHIFT) | \
      (tc_mh_mask << MH_DEBUG_REG10_TC_MH_mask_SHIFT) | \
      (tc_mh_addr_31_5 << MH_DEBUG_REG10_TC_MH_addr_31_5_SHIFT))

#define MH_DEBUG_REG10_GET_ALWAYS_ZERO(mh_debug_reg10) \
     ((mh_debug_reg10 & MH_DEBUG_REG10_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG10_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG10_GET_TC_MH_send(mh_debug_reg10) \
     ((mh_debug_reg10 & MH_DEBUG_REG10_TC_MH_send_MASK) >> MH_DEBUG_REG10_TC_MH_send_SHIFT)
#define MH_DEBUG_REG10_GET_TC_MH_mask(mh_debug_reg10) \
     ((mh_debug_reg10 & MH_DEBUG_REG10_TC_MH_mask_MASK) >> MH_DEBUG_REG10_TC_MH_mask_SHIFT)
#define MH_DEBUG_REG10_GET_TC_MH_addr_31_5(mh_debug_reg10) \
     ((mh_debug_reg10 & MH_DEBUG_REG10_TC_MH_addr_31_5_MASK) >> MH_DEBUG_REG10_TC_MH_addr_31_5_SHIFT)

#define MH_DEBUG_REG10_SET_ALWAYS_ZERO(mh_debug_reg10_reg, always_zero) \
     mh_debug_reg10_reg = (mh_debug_reg10_reg & ~MH_DEBUG_REG10_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG10_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG10_SET_TC_MH_send(mh_debug_reg10_reg, tc_mh_send) \
     mh_debug_reg10_reg = (mh_debug_reg10_reg & ~MH_DEBUG_REG10_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG10_TC_MH_send_SHIFT)
#define MH_DEBUG_REG10_SET_TC_MH_mask(mh_debug_reg10_reg, tc_mh_mask) \
     mh_debug_reg10_reg = (mh_debug_reg10_reg & ~MH_DEBUG_REG10_TC_MH_mask_MASK) | (tc_mh_mask << MH_DEBUG_REG10_TC_MH_mask_SHIFT)
#define MH_DEBUG_REG10_SET_TC_MH_addr_31_5(mh_debug_reg10_reg, tc_mh_addr_31_5) \
     mh_debug_reg10_reg = (mh_debug_reg10_reg & ~MH_DEBUG_REG10_TC_MH_addr_31_5_MASK) | (tc_mh_addr_31_5 << MH_DEBUG_REG10_TC_MH_addr_31_5_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg10_t {
          unsigned int always_zero                    : MH_DEBUG_REG10_ALWAYS_ZERO_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG10_TC_MH_send_SIZE;
          unsigned int tc_mh_mask                     : MH_DEBUG_REG10_TC_MH_mask_SIZE;
          unsigned int tc_mh_addr_31_5                : MH_DEBUG_REG10_TC_MH_addr_31_5_SIZE;
     } mh_debug_reg10_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg10_t {
          unsigned int tc_mh_addr_31_5                : MH_DEBUG_REG10_TC_MH_addr_31_5_SIZE;
          unsigned int tc_mh_mask                     : MH_DEBUG_REG10_TC_MH_mask_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG10_TC_MH_send_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG10_ALWAYS_ZERO_SIZE;
     } mh_debug_reg10_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg10_t f;
} mh_debug_reg10_u;


/*
 * MH_DEBUG_REG11 struct
 */

#define MH_DEBUG_REG11_TC_MH_info_SIZE 25
#define MH_DEBUG_REG11_TC_MH_send_SIZE 1

#define MH_DEBUG_REG11_TC_MH_info_SHIFT 0
#define MH_DEBUG_REG11_TC_MH_send_SHIFT 25

#define MH_DEBUG_REG11_TC_MH_info_MASK 0x01ffffff
#define MH_DEBUG_REG11_TC_MH_send_MASK 0x02000000

#define MH_DEBUG_REG11_MASK \
     (MH_DEBUG_REG11_TC_MH_info_MASK | \
      MH_DEBUG_REG11_TC_MH_send_MASK)

#define MH_DEBUG_REG11(tc_mh_info, tc_mh_send) \
     ((tc_mh_info << MH_DEBUG_REG11_TC_MH_info_SHIFT) | \
      (tc_mh_send << MH_DEBUG_REG11_TC_MH_send_SHIFT))

#define MH_DEBUG_REG11_GET_TC_MH_info(mh_debug_reg11) \
     ((mh_debug_reg11 & MH_DEBUG_REG11_TC_MH_info_MASK) >> MH_DEBUG_REG11_TC_MH_info_SHIFT)
#define MH_DEBUG_REG11_GET_TC_MH_send(mh_debug_reg11) \
     ((mh_debug_reg11 & MH_DEBUG_REG11_TC_MH_send_MASK) >> MH_DEBUG_REG11_TC_MH_send_SHIFT)

#define MH_DEBUG_REG11_SET_TC_MH_info(mh_debug_reg11_reg, tc_mh_info) \
     mh_debug_reg11_reg = (mh_debug_reg11_reg & ~MH_DEBUG_REG11_TC_MH_info_MASK) | (tc_mh_info << MH_DEBUG_REG11_TC_MH_info_SHIFT)
#define MH_DEBUG_REG11_SET_TC_MH_send(mh_debug_reg11_reg, tc_mh_send) \
     mh_debug_reg11_reg = (mh_debug_reg11_reg & ~MH_DEBUG_REG11_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG11_TC_MH_send_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg11_t {
          unsigned int tc_mh_info                     : MH_DEBUG_REG11_TC_MH_info_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG11_TC_MH_send_SIZE;
          unsigned int                                : 6;
     } mh_debug_reg11_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg11_t {
          unsigned int                                : 6;
          unsigned int tc_mh_send                     : MH_DEBUG_REG11_TC_MH_send_SIZE;
          unsigned int tc_mh_info                     : MH_DEBUG_REG11_TC_MH_info_SIZE;
     } mh_debug_reg11_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg11_t f;
} mh_debug_reg11_u;


/*
 * MH_DEBUG_REG12 struct
 */

#define MH_DEBUG_REG12_MH_TC_mcinfo_SIZE 25
#define MH_DEBUG_REG12_MH_TC_mcinfo_send_SIZE 1
#define MH_DEBUG_REG12_TC_MH_written_SIZE 1

#define MH_DEBUG_REG12_MH_TC_mcinfo_SHIFT 0
#define MH_DEBUG_REG12_MH_TC_mcinfo_send_SHIFT 25
#define MH_DEBUG_REG12_TC_MH_written_SHIFT 26

#define MH_DEBUG_REG12_MH_TC_mcinfo_MASK 0x01ffffff
#define MH_DEBUG_REG12_MH_TC_mcinfo_send_MASK 0x02000000
#define MH_DEBUG_REG12_TC_MH_written_MASK 0x04000000

#define MH_DEBUG_REG12_MASK \
     (MH_DEBUG_REG12_MH_TC_mcinfo_MASK | \
      MH_DEBUG_REG12_MH_TC_mcinfo_send_MASK | \
      MH_DEBUG_REG12_TC_MH_written_MASK)

#define MH_DEBUG_REG12(mh_tc_mcinfo, mh_tc_mcinfo_send, tc_mh_written) \
     ((mh_tc_mcinfo << MH_DEBUG_REG12_MH_TC_mcinfo_SHIFT) | \
      (mh_tc_mcinfo_send << MH_DEBUG_REG12_MH_TC_mcinfo_send_SHIFT) | \
      (tc_mh_written << MH_DEBUG_REG12_TC_MH_written_SHIFT))

#define MH_DEBUG_REG12_GET_MH_TC_mcinfo(mh_debug_reg12) \
     ((mh_debug_reg12 & MH_DEBUG_REG12_MH_TC_mcinfo_MASK) >> MH_DEBUG_REG12_MH_TC_mcinfo_SHIFT)
#define MH_DEBUG_REG12_GET_MH_TC_mcinfo_send(mh_debug_reg12) \
     ((mh_debug_reg12 & MH_DEBUG_REG12_MH_TC_mcinfo_send_MASK) >> MH_DEBUG_REG12_MH_TC_mcinfo_send_SHIFT)
#define MH_DEBUG_REG12_GET_TC_MH_written(mh_debug_reg12) \
     ((mh_debug_reg12 & MH_DEBUG_REG12_TC_MH_written_MASK) >> MH_DEBUG_REG12_TC_MH_written_SHIFT)

#define MH_DEBUG_REG12_SET_MH_TC_mcinfo(mh_debug_reg12_reg, mh_tc_mcinfo) \
     mh_debug_reg12_reg = (mh_debug_reg12_reg & ~MH_DEBUG_REG12_MH_TC_mcinfo_MASK) | (mh_tc_mcinfo << MH_DEBUG_REG12_MH_TC_mcinfo_SHIFT)
#define MH_DEBUG_REG12_SET_MH_TC_mcinfo_send(mh_debug_reg12_reg, mh_tc_mcinfo_send) \
     mh_debug_reg12_reg = (mh_debug_reg12_reg & ~MH_DEBUG_REG12_MH_TC_mcinfo_send_MASK) | (mh_tc_mcinfo_send << MH_DEBUG_REG12_MH_TC_mcinfo_send_SHIFT)
#define MH_DEBUG_REG12_SET_TC_MH_written(mh_debug_reg12_reg, tc_mh_written) \
     mh_debug_reg12_reg = (mh_debug_reg12_reg & ~MH_DEBUG_REG12_TC_MH_written_MASK) | (tc_mh_written << MH_DEBUG_REG12_TC_MH_written_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg12_t {
          unsigned int mh_tc_mcinfo                   : MH_DEBUG_REG12_MH_TC_mcinfo_SIZE;
          unsigned int mh_tc_mcinfo_send              : MH_DEBUG_REG12_MH_TC_mcinfo_send_SIZE;
          unsigned int tc_mh_written                  : MH_DEBUG_REG12_TC_MH_written_SIZE;
          unsigned int                                : 5;
     } mh_debug_reg12_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg12_t {
          unsigned int                                : 5;
          unsigned int tc_mh_written                  : MH_DEBUG_REG12_TC_MH_written_SIZE;
          unsigned int mh_tc_mcinfo_send              : MH_DEBUG_REG12_MH_TC_mcinfo_send_SIZE;
          unsigned int mh_tc_mcinfo                   : MH_DEBUG_REG12_MH_TC_mcinfo_SIZE;
     } mh_debug_reg12_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg12_t f;
} mh_debug_reg12_u;


/*
 * MH_DEBUG_REG13 struct
 */

#define MH_DEBUG_REG13_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG13_TC_ROQ_SEND_SIZE 1
#define MH_DEBUG_REG13_TC_ROQ_MASK_SIZE 2
#define MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_SIZE 27

#define MH_DEBUG_REG13_ALWAYS_ZERO_SHIFT 0
#define MH_DEBUG_REG13_TC_ROQ_SEND_SHIFT 2
#define MH_DEBUG_REG13_TC_ROQ_MASK_SHIFT 3
#define MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_SHIFT 5

#define MH_DEBUG_REG13_ALWAYS_ZERO_MASK 0x00000003
#define MH_DEBUG_REG13_TC_ROQ_SEND_MASK 0x00000004
#define MH_DEBUG_REG13_TC_ROQ_MASK_MASK 0x00000018
#define MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_MASK 0xffffffe0

#define MH_DEBUG_REG13_MASK \
     (MH_DEBUG_REG13_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG13_TC_ROQ_SEND_MASK | \
      MH_DEBUG_REG13_TC_ROQ_MASK_MASK | \
      MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_MASK)

#define MH_DEBUG_REG13(always_zero, tc_roq_send, tc_roq_mask, tc_roq_addr_31_5) \
     ((always_zero << MH_DEBUG_REG13_ALWAYS_ZERO_SHIFT) | \
      (tc_roq_send << MH_DEBUG_REG13_TC_ROQ_SEND_SHIFT) | \
      (tc_roq_mask << MH_DEBUG_REG13_TC_ROQ_MASK_SHIFT) | \
      (tc_roq_addr_31_5 << MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_SHIFT))

#define MH_DEBUG_REG13_GET_ALWAYS_ZERO(mh_debug_reg13) \
     ((mh_debug_reg13 & MH_DEBUG_REG13_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG13_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG13_GET_TC_ROQ_SEND(mh_debug_reg13) \
     ((mh_debug_reg13 & MH_DEBUG_REG13_TC_ROQ_SEND_MASK) >> MH_DEBUG_REG13_TC_ROQ_SEND_SHIFT)
#define MH_DEBUG_REG13_GET_TC_ROQ_MASK(mh_debug_reg13) \
     ((mh_debug_reg13 & MH_DEBUG_REG13_TC_ROQ_MASK_MASK) >> MH_DEBUG_REG13_TC_ROQ_MASK_SHIFT)
#define MH_DEBUG_REG13_GET_TC_ROQ_ADDR_31_5(mh_debug_reg13) \
     ((mh_debug_reg13 & MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_MASK) >> MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_SHIFT)

#define MH_DEBUG_REG13_SET_ALWAYS_ZERO(mh_debug_reg13_reg, always_zero) \
     mh_debug_reg13_reg = (mh_debug_reg13_reg & ~MH_DEBUG_REG13_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG13_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG13_SET_TC_ROQ_SEND(mh_debug_reg13_reg, tc_roq_send) \
     mh_debug_reg13_reg = (mh_debug_reg13_reg & ~MH_DEBUG_REG13_TC_ROQ_SEND_MASK) | (tc_roq_send << MH_DEBUG_REG13_TC_ROQ_SEND_SHIFT)
#define MH_DEBUG_REG13_SET_TC_ROQ_MASK(mh_debug_reg13_reg, tc_roq_mask) \
     mh_debug_reg13_reg = (mh_debug_reg13_reg & ~MH_DEBUG_REG13_TC_ROQ_MASK_MASK) | (tc_roq_mask << MH_DEBUG_REG13_TC_ROQ_MASK_SHIFT)
#define MH_DEBUG_REG13_SET_TC_ROQ_ADDR_31_5(mh_debug_reg13_reg, tc_roq_addr_31_5) \
     mh_debug_reg13_reg = (mh_debug_reg13_reg & ~MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_MASK) | (tc_roq_addr_31_5 << MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg13_t {
          unsigned int always_zero                    : MH_DEBUG_REG13_ALWAYS_ZERO_SIZE;
          unsigned int tc_roq_send                    : MH_DEBUG_REG13_TC_ROQ_SEND_SIZE;
          unsigned int tc_roq_mask                    : MH_DEBUG_REG13_TC_ROQ_MASK_SIZE;
          unsigned int tc_roq_addr_31_5               : MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_SIZE;
     } mh_debug_reg13_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg13_t {
          unsigned int tc_roq_addr_31_5               : MH_DEBUG_REG13_TC_ROQ_ADDR_31_5_SIZE;
          unsigned int tc_roq_mask                    : MH_DEBUG_REG13_TC_ROQ_MASK_SIZE;
          unsigned int tc_roq_send                    : MH_DEBUG_REG13_TC_ROQ_SEND_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG13_ALWAYS_ZERO_SIZE;
     } mh_debug_reg13_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg13_t f;
} mh_debug_reg13_u;


/*
 * MH_DEBUG_REG14 struct
 */

#define MH_DEBUG_REG14_TC_ROQ_INFO_SIZE 25
#define MH_DEBUG_REG14_TC_ROQ_SEND_SIZE 1

#define MH_DEBUG_REG14_TC_ROQ_INFO_SHIFT 0
#define MH_DEBUG_REG14_TC_ROQ_SEND_SHIFT 25

#define MH_DEBUG_REG14_TC_ROQ_INFO_MASK 0x01ffffff
#define MH_DEBUG_REG14_TC_ROQ_SEND_MASK 0x02000000

#define MH_DEBUG_REG14_MASK \
     (MH_DEBUG_REG14_TC_ROQ_INFO_MASK | \
      MH_DEBUG_REG14_TC_ROQ_SEND_MASK)

#define MH_DEBUG_REG14(tc_roq_info, tc_roq_send) \
     ((tc_roq_info << MH_DEBUG_REG14_TC_ROQ_INFO_SHIFT) | \
      (tc_roq_send << MH_DEBUG_REG14_TC_ROQ_SEND_SHIFT))

#define MH_DEBUG_REG14_GET_TC_ROQ_INFO(mh_debug_reg14) \
     ((mh_debug_reg14 & MH_DEBUG_REG14_TC_ROQ_INFO_MASK) >> MH_DEBUG_REG14_TC_ROQ_INFO_SHIFT)
#define MH_DEBUG_REG14_GET_TC_ROQ_SEND(mh_debug_reg14) \
     ((mh_debug_reg14 & MH_DEBUG_REG14_TC_ROQ_SEND_MASK) >> MH_DEBUG_REG14_TC_ROQ_SEND_SHIFT)

#define MH_DEBUG_REG14_SET_TC_ROQ_INFO(mh_debug_reg14_reg, tc_roq_info) \
     mh_debug_reg14_reg = (mh_debug_reg14_reg & ~MH_DEBUG_REG14_TC_ROQ_INFO_MASK) | (tc_roq_info << MH_DEBUG_REG14_TC_ROQ_INFO_SHIFT)
#define MH_DEBUG_REG14_SET_TC_ROQ_SEND(mh_debug_reg14_reg, tc_roq_send) \
     mh_debug_reg14_reg = (mh_debug_reg14_reg & ~MH_DEBUG_REG14_TC_ROQ_SEND_MASK) | (tc_roq_send << MH_DEBUG_REG14_TC_ROQ_SEND_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg14_t {
          unsigned int tc_roq_info                    : MH_DEBUG_REG14_TC_ROQ_INFO_SIZE;
          unsigned int tc_roq_send                    : MH_DEBUG_REG14_TC_ROQ_SEND_SIZE;
          unsigned int                                : 6;
     } mh_debug_reg14_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg14_t {
          unsigned int                                : 6;
          unsigned int tc_roq_send                    : MH_DEBUG_REG14_TC_ROQ_SEND_SIZE;
          unsigned int tc_roq_info                    : MH_DEBUG_REG14_TC_ROQ_INFO_SIZE;
     } mh_debug_reg14_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg14_t f;
} mh_debug_reg14_u;


/*
 * MH_DEBUG_REG15 struct
 */

#define MH_DEBUG_REG15_ALWAYS_ZERO_SIZE 4
#define MH_DEBUG_REG15_RB_MH_send_SIZE 1
#define MH_DEBUG_REG15_RB_MH_addr_31_5_SIZE 27

#define MH_DEBUG_REG15_ALWAYS_ZERO_SHIFT 0
#define MH_DEBUG_REG15_RB_MH_send_SHIFT 4
#define MH_DEBUG_REG15_RB_MH_addr_31_5_SHIFT 5

#define MH_DEBUG_REG15_ALWAYS_ZERO_MASK 0x0000000f
#define MH_DEBUG_REG15_RB_MH_send_MASK 0x00000010
#define MH_DEBUG_REG15_RB_MH_addr_31_5_MASK 0xffffffe0

#define MH_DEBUG_REG15_MASK \
     (MH_DEBUG_REG15_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG15_RB_MH_send_MASK | \
      MH_DEBUG_REG15_RB_MH_addr_31_5_MASK)

#define MH_DEBUG_REG15(always_zero, rb_mh_send, rb_mh_addr_31_5) \
     ((always_zero << MH_DEBUG_REG15_ALWAYS_ZERO_SHIFT) | \
      (rb_mh_send << MH_DEBUG_REG15_RB_MH_send_SHIFT) | \
      (rb_mh_addr_31_5 << MH_DEBUG_REG15_RB_MH_addr_31_5_SHIFT))

#define MH_DEBUG_REG15_GET_ALWAYS_ZERO(mh_debug_reg15) \
     ((mh_debug_reg15 & MH_DEBUG_REG15_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG15_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG15_GET_RB_MH_send(mh_debug_reg15) \
     ((mh_debug_reg15 & MH_DEBUG_REG15_RB_MH_send_MASK) >> MH_DEBUG_REG15_RB_MH_send_SHIFT)
#define MH_DEBUG_REG15_GET_RB_MH_addr_31_5(mh_debug_reg15) \
     ((mh_debug_reg15 & MH_DEBUG_REG15_RB_MH_addr_31_5_MASK) >> MH_DEBUG_REG15_RB_MH_addr_31_5_SHIFT)

#define MH_DEBUG_REG15_SET_ALWAYS_ZERO(mh_debug_reg15_reg, always_zero) \
     mh_debug_reg15_reg = (mh_debug_reg15_reg & ~MH_DEBUG_REG15_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG15_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG15_SET_RB_MH_send(mh_debug_reg15_reg, rb_mh_send) \
     mh_debug_reg15_reg = (mh_debug_reg15_reg & ~MH_DEBUG_REG15_RB_MH_send_MASK) | (rb_mh_send << MH_DEBUG_REG15_RB_MH_send_SHIFT)
#define MH_DEBUG_REG15_SET_RB_MH_addr_31_5(mh_debug_reg15_reg, rb_mh_addr_31_5) \
     mh_debug_reg15_reg = (mh_debug_reg15_reg & ~MH_DEBUG_REG15_RB_MH_addr_31_5_MASK) | (rb_mh_addr_31_5 << MH_DEBUG_REG15_RB_MH_addr_31_5_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg15_t {
          unsigned int always_zero                    : MH_DEBUG_REG15_ALWAYS_ZERO_SIZE;
          unsigned int rb_mh_send                     : MH_DEBUG_REG15_RB_MH_send_SIZE;
          unsigned int rb_mh_addr_31_5                : MH_DEBUG_REG15_RB_MH_addr_31_5_SIZE;
     } mh_debug_reg15_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg15_t {
          unsigned int rb_mh_addr_31_5                : MH_DEBUG_REG15_RB_MH_addr_31_5_SIZE;
          unsigned int rb_mh_send                     : MH_DEBUG_REG15_RB_MH_send_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG15_ALWAYS_ZERO_SIZE;
     } mh_debug_reg15_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg15_t f;
} mh_debug_reg15_u;


/*
 * MH_DEBUG_REG16 struct
 */

#define MH_DEBUG_REG16_RB_MH_data_31_0_SIZE 32

#define MH_DEBUG_REG16_RB_MH_data_31_0_SHIFT 0

#define MH_DEBUG_REG16_RB_MH_data_31_0_MASK 0xffffffff

#define MH_DEBUG_REG16_MASK \
     (MH_DEBUG_REG16_RB_MH_data_31_0_MASK)

#define MH_DEBUG_REG16(rb_mh_data_31_0) \
     ((rb_mh_data_31_0 << MH_DEBUG_REG16_RB_MH_data_31_0_SHIFT))

#define MH_DEBUG_REG16_GET_RB_MH_data_31_0(mh_debug_reg16) \
     ((mh_debug_reg16 & MH_DEBUG_REG16_RB_MH_data_31_0_MASK) >> MH_DEBUG_REG16_RB_MH_data_31_0_SHIFT)

#define MH_DEBUG_REG16_SET_RB_MH_data_31_0(mh_debug_reg16_reg, rb_mh_data_31_0) \
     mh_debug_reg16_reg = (mh_debug_reg16_reg & ~MH_DEBUG_REG16_RB_MH_data_31_0_MASK) | (rb_mh_data_31_0 << MH_DEBUG_REG16_RB_MH_data_31_0_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg16_t {
          unsigned int rb_mh_data_31_0                : MH_DEBUG_REG16_RB_MH_data_31_0_SIZE;
     } mh_debug_reg16_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg16_t {
          unsigned int rb_mh_data_31_0                : MH_DEBUG_REG16_RB_MH_data_31_0_SIZE;
     } mh_debug_reg16_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg16_t f;
} mh_debug_reg16_u;


/*
 * MH_DEBUG_REG17 struct
 */

#define MH_DEBUG_REG17_RB_MH_data_63_32_SIZE 32

#define MH_DEBUG_REG17_RB_MH_data_63_32_SHIFT 0

#define MH_DEBUG_REG17_RB_MH_data_63_32_MASK 0xffffffff

#define MH_DEBUG_REG17_MASK \
     (MH_DEBUG_REG17_RB_MH_data_63_32_MASK)

#define MH_DEBUG_REG17(rb_mh_data_63_32) \
     ((rb_mh_data_63_32 << MH_DEBUG_REG17_RB_MH_data_63_32_SHIFT))

#define MH_DEBUG_REG17_GET_RB_MH_data_63_32(mh_debug_reg17) \
     ((mh_debug_reg17 & MH_DEBUG_REG17_RB_MH_data_63_32_MASK) >> MH_DEBUG_REG17_RB_MH_data_63_32_SHIFT)

#define MH_DEBUG_REG17_SET_RB_MH_data_63_32(mh_debug_reg17_reg, rb_mh_data_63_32) \
     mh_debug_reg17_reg = (mh_debug_reg17_reg & ~MH_DEBUG_REG17_RB_MH_data_63_32_MASK) | (rb_mh_data_63_32 << MH_DEBUG_REG17_RB_MH_data_63_32_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg17_t {
          unsigned int rb_mh_data_63_32               : MH_DEBUG_REG17_RB_MH_data_63_32_SIZE;
     } mh_debug_reg17_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg17_t {
          unsigned int rb_mh_data_63_32               : MH_DEBUG_REG17_RB_MH_data_63_32_SIZE;
     } mh_debug_reg17_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg17_t f;
} mh_debug_reg17_u;


/*
 * MH_DEBUG_REG18 struct
 */

#define MH_DEBUG_REG18_ALWAYS_ZERO_SIZE 4
#define MH_DEBUG_REG18_PA_MH_send_SIZE 1
#define MH_DEBUG_REG18_PA_MH_addr_31_5_SIZE 27

#define MH_DEBUG_REG18_ALWAYS_ZERO_SHIFT 0
#define MH_DEBUG_REG18_PA_MH_send_SHIFT 4
#define MH_DEBUG_REG18_PA_MH_addr_31_5_SHIFT 5

#define MH_DEBUG_REG18_ALWAYS_ZERO_MASK 0x0000000f
#define MH_DEBUG_REG18_PA_MH_send_MASK 0x00000010
#define MH_DEBUG_REG18_PA_MH_addr_31_5_MASK 0xffffffe0

#define MH_DEBUG_REG18_MASK \
     (MH_DEBUG_REG18_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG18_PA_MH_send_MASK | \
      MH_DEBUG_REG18_PA_MH_addr_31_5_MASK)

#define MH_DEBUG_REG18(always_zero, pa_mh_send, pa_mh_addr_31_5) \
     ((always_zero << MH_DEBUG_REG18_ALWAYS_ZERO_SHIFT) | \
      (pa_mh_send << MH_DEBUG_REG18_PA_MH_send_SHIFT) | \
      (pa_mh_addr_31_5 << MH_DEBUG_REG18_PA_MH_addr_31_5_SHIFT))

#define MH_DEBUG_REG18_GET_ALWAYS_ZERO(mh_debug_reg18) \
     ((mh_debug_reg18 & MH_DEBUG_REG18_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG18_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG18_GET_PA_MH_send(mh_debug_reg18) \
     ((mh_debug_reg18 & MH_DEBUG_REG18_PA_MH_send_MASK) >> MH_DEBUG_REG18_PA_MH_send_SHIFT)
#define MH_DEBUG_REG18_GET_PA_MH_addr_31_5(mh_debug_reg18) \
     ((mh_debug_reg18 & MH_DEBUG_REG18_PA_MH_addr_31_5_MASK) >> MH_DEBUG_REG18_PA_MH_addr_31_5_SHIFT)

#define MH_DEBUG_REG18_SET_ALWAYS_ZERO(mh_debug_reg18_reg, always_zero) \
     mh_debug_reg18_reg = (mh_debug_reg18_reg & ~MH_DEBUG_REG18_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG18_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG18_SET_PA_MH_send(mh_debug_reg18_reg, pa_mh_send) \
     mh_debug_reg18_reg = (mh_debug_reg18_reg & ~MH_DEBUG_REG18_PA_MH_send_MASK) | (pa_mh_send << MH_DEBUG_REG18_PA_MH_send_SHIFT)
#define MH_DEBUG_REG18_SET_PA_MH_addr_31_5(mh_debug_reg18_reg, pa_mh_addr_31_5) \
     mh_debug_reg18_reg = (mh_debug_reg18_reg & ~MH_DEBUG_REG18_PA_MH_addr_31_5_MASK) | (pa_mh_addr_31_5 << MH_DEBUG_REG18_PA_MH_addr_31_5_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg18_t {
          unsigned int always_zero                    : MH_DEBUG_REG18_ALWAYS_ZERO_SIZE;
          unsigned int pa_mh_send                     : MH_DEBUG_REG18_PA_MH_send_SIZE;
          unsigned int pa_mh_addr_31_5                : MH_DEBUG_REG18_PA_MH_addr_31_5_SIZE;
     } mh_debug_reg18_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg18_t {
          unsigned int pa_mh_addr_31_5                : MH_DEBUG_REG18_PA_MH_addr_31_5_SIZE;
          unsigned int pa_mh_send                     : MH_DEBUG_REG18_PA_MH_send_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG18_ALWAYS_ZERO_SIZE;
     } mh_debug_reg18_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg18_t f;
} mh_debug_reg18_u;


/*
 * MH_DEBUG_REG19 struct
 */

#define MH_DEBUG_REG19_PA_MH_data_31_0_SIZE 32

#define MH_DEBUG_REG19_PA_MH_data_31_0_SHIFT 0

#define MH_DEBUG_REG19_PA_MH_data_31_0_MASK 0xffffffff

#define MH_DEBUG_REG19_MASK \
     (MH_DEBUG_REG19_PA_MH_data_31_0_MASK)

#define MH_DEBUG_REG19(pa_mh_data_31_0) \
     ((pa_mh_data_31_0 << MH_DEBUG_REG19_PA_MH_data_31_0_SHIFT))

#define MH_DEBUG_REG19_GET_PA_MH_data_31_0(mh_debug_reg19) \
     ((mh_debug_reg19 & MH_DEBUG_REG19_PA_MH_data_31_0_MASK) >> MH_DEBUG_REG19_PA_MH_data_31_0_SHIFT)

#define MH_DEBUG_REG19_SET_PA_MH_data_31_0(mh_debug_reg19_reg, pa_mh_data_31_0) \
     mh_debug_reg19_reg = (mh_debug_reg19_reg & ~MH_DEBUG_REG19_PA_MH_data_31_0_MASK) | (pa_mh_data_31_0 << MH_DEBUG_REG19_PA_MH_data_31_0_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg19_t {
          unsigned int pa_mh_data_31_0                : MH_DEBUG_REG19_PA_MH_data_31_0_SIZE;
     } mh_debug_reg19_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg19_t {
          unsigned int pa_mh_data_31_0                : MH_DEBUG_REG19_PA_MH_data_31_0_SIZE;
     } mh_debug_reg19_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg19_t f;
} mh_debug_reg19_u;


/*
 * MH_DEBUG_REG20 struct
 */

#define MH_DEBUG_REG20_PA_MH_data_63_32_SIZE 32

#define MH_DEBUG_REG20_PA_MH_data_63_32_SHIFT 0

#define MH_DEBUG_REG20_PA_MH_data_63_32_MASK 0xffffffff

#define MH_DEBUG_REG20_MASK \
     (MH_DEBUG_REG20_PA_MH_data_63_32_MASK)

#define MH_DEBUG_REG20(pa_mh_data_63_32) \
     ((pa_mh_data_63_32 << MH_DEBUG_REG20_PA_MH_data_63_32_SHIFT))

#define MH_DEBUG_REG20_GET_PA_MH_data_63_32(mh_debug_reg20) \
     ((mh_debug_reg20 & MH_DEBUG_REG20_PA_MH_data_63_32_MASK) >> MH_DEBUG_REG20_PA_MH_data_63_32_SHIFT)

#define MH_DEBUG_REG20_SET_PA_MH_data_63_32(mh_debug_reg20_reg, pa_mh_data_63_32) \
     mh_debug_reg20_reg = (mh_debug_reg20_reg & ~MH_DEBUG_REG20_PA_MH_data_63_32_MASK) | (pa_mh_data_63_32 << MH_DEBUG_REG20_PA_MH_data_63_32_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg20_t {
          unsigned int pa_mh_data_63_32               : MH_DEBUG_REG20_PA_MH_data_63_32_SIZE;
     } mh_debug_reg20_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg20_t {
          unsigned int pa_mh_data_63_32               : MH_DEBUG_REG20_PA_MH_data_63_32_SIZE;
     } mh_debug_reg20_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg20_t f;
} mh_debug_reg20_u;


/*
 * MH_DEBUG_REG21 struct
 */

#define MH_DEBUG_REG21_AVALID_q_SIZE   1
#define MH_DEBUG_REG21_AREADY_q_SIZE   1
#define MH_DEBUG_REG21_AID_q_SIZE      3
#define MH_DEBUG_REG21_ALEN_q_2_0_SIZE 3
#define MH_DEBUG_REG21_ARVALID_q_SIZE  1
#define MH_DEBUG_REG21_ARREADY_q_SIZE  1
#define MH_DEBUG_REG21_ARID_q_SIZE     3
#define MH_DEBUG_REG21_ARLEN_q_1_0_SIZE 2
#define MH_DEBUG_REG21_RVALID_q_SIZE   1
#define MH_DEBUG_REG21_RREADY_q_SIZE   1
#define MH_DEBUG_REG21_RLAST_q_SIZE    1
#define MH_DEBUG_REG21_RID_q_SIZE      3
#define MH_DEBUG_REG21_WVALID_q_SIZE   1
#define MH_DEBUG_REG21_WREADY_q_SIZE   1
#define MH_DEBUG_REG21_WLAST_q_SIZE    1
#define MH_DEBUG_REG21_WID_q_SIZE      3
#define MH_DEBUG_REG21_BVALID_q_SIZE   1
#define MH_DEBUG_REG21_BREADY_q_SIZE   1
#define MH_DEBUG_REG21_BID_q_SIZE      3

#define MH_DEBUG_REG21_AVALID_q_SHIFT  0
#define MH_DEBUG_REG21_AREADY_q_SHIFT  1
#define MH_DEBUG_REG21_AID_q_SHIFT     2
#define MH_DEBUG_REG21_ALEN_q_2_0_SHIFT 5
#define MH_DEBUG_REG21_ARVALID_q_SHIFT 8
#define MH_DEBUG_REG21_ARREADY_q_SHIFT 9
#define MH_DEBUG_REG21_ARID_q_SHIFT    10
#define MH_DEBUG_REG21_ARLEN_q_1_0_SHIFT 13
#define MH_DEBUG_REG21_RVALID_q_SHIFT  15
#define MH_DEBUG_REG21_RREADY_q_SHIFT  16
#define MH_DEBUG_REG21_RLAST_q_SHIFT   17
#define MH_DEBUG_REG21_RID_q_SHIFT     18
#define MH_DEBUG_REG21_WVALID_q_SHIFT  21
#define MH_DEBUG_REG21_WREADY_q_SHIFT  22
#define MH_DEBUG_REG21_WLAST_q_SHIFT   23
#define MH_DEBUG_REG21_WID_q_SHIFT     24
#define MH_DEBUG_REG21_BVALID_q_SHIFT  27
#define MH_DEBUG_REG21_BREADY_q_SHIFT  28
#define MH_DEBUG_REG21_BID_q_SHIFT     29

#define MH_DEBUG_REG21_AVALID_q_MASK   0x00000001
#define MH_DEBUG_REG21_AREADY_q_MASK   0x00000002
#define MH_DEBUG_REG21_AID_q_MASK      0x0000001c
#define MH_DEBUG_REG21_ALEN_q_2_0_MASK 0x000000e0
#define MH_DEBUG_REG21_ARVALID_q_MASK  0x00000100
#define MH_DEBUG_REG21_ARREADY_q_MASK  0x00000200
#define MH_DEBUG_REG21_ARID_q_MASK     0x00001c00
#define MH_DEBUG_REG21_ARLEN_q_1_0_MASK 0x00006000
#define MH_DEBUG_REG21_RVALID_q_MASK   0x00008000
#define MH_DEBUG_REG21_RREADY_q_MASK   0x00010000
#define MH_DEBUG_REG21_RLAST_q_MASK    0x00020000
#define MH_DEBUG_REG21_RID_q_MASK      0x001c0000
#define MH_DEBUG_REG21_WVALID_q_MASK   0x00200000
#define MH_DEBUG_REG21_WREADY_q_MASK   0x00400000
#define MH_DEBUG_REG21_WLAST_q_MASK    0x00800000
#define MH_DEBUG_REG21_WID_q_MASK      0x07000000
#define MH_DEBUG_REG21_BVALID_q_MASK   0x08000000
#define MH_DEBUG_REG21_BREADY_q_MASK   0x10000000
#define MH_DEBUG_REG21_BID_q_MASK      0xe0000000

#define MH_DEBUG_REG21_MASK \
     (MH_DEBUG_REG21_AVALID_q_MASK | \
      MH_DEBUG_REG21_AREADY_q_MASK | \
      MH_DEBUG_REG21_AID_q_MASK | \
      MH_DEBUG_REG21_ALEN_q_2_0_MASK | \
      MH_DEBUG_REG21_ARVALID_q_MASK | \
      MH_DEBUG_REG21_ARREADY_q_MASK | \
      MH_DEBUG_REG21_ARID_q_MASK | \
      MH_DEBUG_REG21_ARLEN_q_1_0_MASK | \
      MH_DEBUG_REG21_RVALID_q_MASK | \
      MH_DEBUG_REG21_RREADY_q_MASK | \
      MH_DEBUG_REG21_RLAST_q_MASK | \
      MH_DEBUG_REG21_RID_q_MASK | \
      MH_DEBUG_REG21_WVALID_q_MASK | \
      MH_DEBUG_REG21_WREADY_q_MASK | \
      MH_DEBUG_REG21_WLAST_q_MASK | \
      MH_DEBUG_REG21_WID_q_MASK | \
      MH_DEBUG_REG21_BVALID_q_MASK | \
      MH_DEBUG_REG21_BREADY_q_MASK | \
      MH_DEBUG_REG21_BID_q_MASK)

#define MH_DEBUG_REG21(avalid_q, aready_q, aid_q, alen_q_2_0, arvalid_q, arready_q, arid_q, arlen_q_1_0, rvalid_q, rready_q, rlast_q, rid_q, wvalid_q, wready_q, wlast_q, wid_q, bvalid_q, bready_q, bid_q) \
     ((avalid_q << MH_DEBUG_REG21_AVALID_q_SHIFT) | \
      (aready_q << MH_DEBUG_REG21_AREADY_q_SHIFT) | \
      (aid_q << MH_DEBUG_REG21_AID_q_SHIFT) | \
      (alen_q_2_0 << MH_DEBUG_REG21_ALEN_q_2_0_SHIFT) | \
      (arvalid_q << MH_DEBUG_REG21_ARVALID_q_SHIFT) | \
      (arready_q << MH_DEBUG_REG21_ARREADY_q_SHIFT) | \
      (arid_q << MH_DEBUG_REG21_ARID_q_SHIFT) | \
      (arlen_q_1_0 << MH_DEBUG_REG21_ARLEN_q_1_0_SHIFT) | \
      (rvalid_q << MH_DEBUG_REG21_RVALID_q_SHIFT) | \
      (rready_q << MH_DEBUG_REG21_RREADY_q_SHIFT) | \
      (rlast_q << MH_DEBUG_REG21_RLAST_q_SHIFT) | \
      (rid_q << MH_DEBUG_REG21_RID_q_SHIFT) | \
      (wvalid_q << MH_DEBUG_REG21_WVALID_q_SHIFT) | \
      (wready_q << MH_DEBUG_REG21_WREADY_q_SHIFT) | \
      (wlast_q << MH_DEBUG_REG21_WLAST_q_SHIFT) | \
      (wid_q << MH_DEBUG_REG21_WID_q_SHIFT) | \
      (bvalid_q << MH_DEBUG_REG21_BVALID_q_SHIFT) | \
      (bready_q << MH_DEBUG_REG21_BREADY_q_SHIFT) | \
      (bid_q << MH_DEBUG_REG21_BID_q_SHIFT))

#define MH_DEBUG_REG21_GET_AVALID_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_AVALID_q_MASK) >> MH_DEBUG_REG21_AVALID_q_SHIFT)
#define MH_DEBUG_REG21_GET_AREADY_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_AREADY_q_MASK) >> MH_DEBUG_REG21_AREADY_q_SHIFT)
#define MH_DEBUG_REG21_GET_AID_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_AID_q_MASK) >> MH_DEBUG_REG21_AID_q_SHIFT)
#define MH_DEBUG_REG21_GET_ALEN_q_2_0(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_ALEN_q_2_0_MASK) >> MH_DEBUG_REG21_ALEN_q_2_0_SHIFT)
#define MH_DEBUG_REG21_GET_ARVALID_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_ARVALID_q_MASK) >> MH_DEBUG_REG21_ARVALID_q_SHIFT)
#define MH_DEBUG_REG21_GET_ARREADY_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_ARREADY_q_MASK) >> MH_DEBUG_REG21_ARREADY_q_SHIFT)
#define MH_DEBUG_REG21_GET_ARID_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_ARID_q_MASK) >> MH_DEBUG_REG21_ARID_q_SHIFT)
#define MH_DEBUG_REG21_GET_ARLEN_q_1_0(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_ARLEN_q_1_0_MASK) >> MH_DEBUG_REG21_ARLEN_q_1_0_SHIFT)
#define MH_DEBUG_REG21_GET_RVALID_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_RVALID_q_MASK) >> MH_DEBUG_REG21_RVALID_q_SHIFT)
#define MH_DEBUG_REG21_GET_RREADY_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_RREADY_q_MASK) >> MH_DEBUG_REG21_RREADY_q_SHIFT)
#define MH_DEBUG_REG21_GET_RLAST_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_RLAST_q_MASK) >> MH_DEBUG_REG21_RLAST_q_SHIFT)
#define MH_DEBUG_REG21_GET_RID_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_RID_q_MASK) >> MH_DEBUG_REG21_RID_q_SHIFT)
#define MH_DEBUG_REG21_GET_WVALID_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_WVALID_q_MASK) >> MH_DEBUG_REG21_WVALID_q_SHIFT)
#define MH_DEBUG_REG21_GET_WREADY_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_WREADY_q_MASK) >> MH_DEBUG_REG21_WREADY_q_SHIFT)
#define MH_DEBUG_REG21_GET_WLAST_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_WLAST_q_MASK) >> MH_DEBUG_REG21_WLAST_q_SHIFT)
#define MH_DEBUG_REG21_GET_WID_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_WID_q_MASK) >> MH_DEBUG_REG21_WID_q_SHIFT)
#define MH_DEBUG_REG21_GET_BVALID_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_BVALID_q_MASK) >> MH_DEBUG_REG21_BVALID_q_SHIFT)
#define MH_DEBUG_REG21_GET_BREADY_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_BREADY_q_MASK) >> MH_DEBUG_REG21_BREADY_q_SHIFT)
#define MH_DEBUG_REG21_GET_BID_q(mh_debug_reg21) \
     ((mh_debug_reg21 & MH_DEBUG_REG21_BID_q_MASK) >> MH_DEBUG_REG21_BID_q_SHIFT)

#define MH_DEBUG_REG21_SET_AVALID_q(mh_debug_reg21_reg, avalid_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_AVALID_q_MASK) | (avalid_q << MH_DEBUG_REG21_AVALID_q_SHIFT)
#define MH_DEBUG_REG21_SET_AREADY_q(mh_debug_reg21_reg, aready_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_AREADY_q_MASK) | (aready_q << MH_DEBUG_REG21_AREADY_q_SHIFT)
#define MH_DEBUG_REG21_SET_AID_q(mh_debug_reg21_reg, aid_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_AID_q_MASK) | (aid_q << MH_DEBUG_REG21_AID_q_SHIFT)
#define MH_DEBUG_REG21_SET_ALEN_q_2_0(mh_debug_reg21_reg, alen_q_2_0) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_ALEN_q_2_0_MASK) | (alen_q_2_0 << MH_DEBUG_REG21_ALEN_q_2_0_SHIFT)
#define MH_DEBUG_REG21_SET_ARVALID_q(mh_debug_reg21_reg, arvalid_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_ARVALID_q_MASK) | (arvalid_q << MH_DEBUG_REG21_ARVALID_q_SHIFT)
#define MH_DEBUG_REG21_SET_ARREADY_q(mh_debug_reg21_reg, arready_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_ARREADY_q_MASK) | (arready_q << MH_DEBUG_REG21_ARREADY_q_SHIFT)
#define MH_DEBUG_REG21_SET_ARID_q(mh_debug_reg21_reg, arid_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_ARID_q_MASK) | (arid_q << MH_DEBUG_REG21_ARID_q_SHIFT)
#define MH_DEBUG_REG21_SET_ARLEN_q_1_0(mh_debug_reg21_reg, arlen_q_1_0) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_ARLEN_q_1_0_MASK) | (arlen_q_1_0 << MH_DEBUG_REG21_ARLEN_q_1_0_SHIFT)
#define MH_DEBUG_REG21_SET_RVALID_q(mh_debug_reg21_reg, rvalid_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_RVALID_q_MASK) | (rvalid_q << MH_DEBUG_REG21_RVALID_q_SHIFT)
#define MH_DEBUG_REG21_SET_RREADY_q(mh_debug_reg21_reg, rready_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_RREADY_q_MASK) | (rready_q << MH_DEBUG_REG21_RREADY_q_SHIFT)
#define MH_DEBUG_REG21_SET_RLAST_q(mh_debug_reg21_reg, rlast_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_RLAST_q_MASK) | (rlast_q << MH_DEBUG_REG21_RLAST_q_SHIFT)
#define MH_DEBUG_REG21_SET_RID_q(mh_debug_reg21_reg, rid_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_RID_q_MASK) | (rid_q << MH_DEBUG_REG21_RID_q_SHIFT)
#define MH_DEBUG_REG21_SET_WVALID_q(mh_debug_reg21_reg, wvalid_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_WVALID_q_MASK) | (wvalid_q << MH_DEBUG_REG21_WVALID_q_SHIFT)
#define MH_DEBUG_REG21_SET_WREADY_q(mh_debug_reg21_reg, wready_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_WREADY_q_MASK) | (wready_q << MH_DEBUG_REG21_WREADY_q_SHIFT)
#define MH_DEBUG_REG21_SET_WLAST_q(mh_debug_reg21_reg, wlast_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_WLAST_q_MASK) | (wlast_q << MH_DEBUG_REG21_WLAST_q_SHIFT)
#define MH_DEBUG_REG21_SET_WID_q(mh_debug_reg21_reg, wid_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_WID_q_MASK) | (wid_q << MH_DEBUG_REG21_WID_q_SHIFT)
#define MH_DEBUG_REG21_SET_BVALID_q(mh_debug_reg21_reg, bvalid_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_BVALID_q_MASK) | (bvalid_q << MH_DEBUG_REG21_BVALID_q_SHIFT)
#define MH_DEBUG_REG21_SET_BREADY_q(mh_debug_reg21_reg, bready_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_BREADY_q_MASK) | (bready_q << MH_DEBUG_REG21_BREADY_q_SHIFT)
#define MH_DEBUG_REG21_SET_BID_q(mh_debug_reg21_reg, bid_q) \
     mh_debug_reg21_reg = (mh_debug_reg21_reg & ~MH_DEBUG_REG21_BID_q_MASK) | (bid_q << MH_DEBUG_REG21_BID_q_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg21_t {
          unsigned int avalid_q                       : MH_DEBUG_REG21_AVALID_q_SIZE;
          unsigned int aready_q                       : MH_DEBUG_REG21_AREADY_q_SIZE;
          unsigned int aid_q                          : MH_DEBUG_REG21_AID_q_SIZE;
          unsigned int alen_q_2_0                     : MH_DEBUG_REG21_ALEN_q_2_0_SIZE;
          unsigned int arvalid_q                      : MH_DEBUG_REG21_ARVALID_q_SIZE;
          unsigned int arready_q                      : MH_DEBUG_REG21_ARREADY_q_SIZE;
          unsigned int arid_q                         : MH_DEBUG_REG21_ARID_q_SIZE;
          unsigned int arlen_q_1_0                    : MH_DEBUG_REG21_ARLEN_q_1_0_SIZE;
          unsigned int rvalid_q                       : MH_DEBUG_REG21_RVALID_q_SIZE;
          unsigned int rready_q                       : MH_DEBUG_REG21_RREADY_q_SIZE;
          unsigned int rlast_q                        : MH_DEBUG_REG21_RLAST_q_SIZE;
          unsigned int rid_q                          : MH_DEBUG_REG21_RID_q_SIZE;
          unsigned int wvalid_q                       : MH_DEBUG_REG21_WVALID_q_SIZE;
          unsigned int wready_q                       : MH_DEBUG_REG21_WREADY_q_SIZE;
          unsigned int wlast_q                        : MH_DEBUG_REG21_WLAST_q_SIZE;
          unsigned int wid_q                          : MH_DEBUG_REG21_WID_q_SIZE;
          unsigned int bvalid_q                       : MH_DEBUG_REG21_BVALID_q_SIZE;
          unsigned int bready_q                       : MH_DEBUG_REG21_BREADY_q_SIZE;
          unsigned int bid_q                          : MH_DEBUG_REG21_BID_q_SIZE;
     } mh_debug_reg21_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg21_t {
          unsigned int bid_q                          : MH_DEBUG_REG21_BID_q_SIZE;
          unsigned int bready_q                       : MH_DEBUG_REG21_BREADY_q_SIZE;
          unsigned int bvalid_q                       : MH_DEBUG_REG21_BVALID_q_SIZE;
          unsigned int wid_q                          : MH_DEBUG_REG21_WID_q_SIZE;
          unsigned int wlast_q                        : MH_DEBUG_REG21_WLAST_q_SIZE;
          unsigned int wready_q                       : MH_DEBUG_REG21_WREADY_q_SIZE;
          unsigned int wvalid_q                       : MH_DEBUG_REG21_WVALID_q_SIZE;
          unsigned int rid_q                          : MH_DEBUG_REG21_RID_q_SIZE;
          unsigned int rlast_q                        : MH_DEBUG_REG21_RLAST_q_SIZE;
          unsigned int rready_q                       : MH_DEBUG_REG21_RREADY_q_SIZE;
          unsigned int rvalid_q                       : MH_DEBUG_REG21_RVALID_q_SIZE;
          unsigned int arlen_q_1_0                    : MH_DEBUG_REG21_ARLEN_q_1_0_SIZE;
          unsigned int arid_q                         : MH_DEBUG_REG21_ARID_q_SIZE;
          unsigned int arready_q                      : MH_DEBUG_REG21_ARREADY_q_SIZE;
          unsigned int arvalid_q                      : MH_DEBUG_REG21_ARVALID_q_SIZE;
          unsigned int alen_q_2_0                     : MH_DEBUG_REG21_ALEN_q_2_0_SIZE;
          unsigned int aid_q                          : MH_DEBUG_REG21_AID_q_SIZE;
          unsigned int aready_q                       : MH_DEBUG_REG21_AREADY_q_SIZE;
          unsigned int avalid_q                       : MH_DEBUG_REG21_AVALID_q_SIZE;
     } mh_debug_reg21_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg21_t f;
} mh_debug_reg21_u;


/*
 * MH_DEBUG_REG22 struct
 */

#define MH_DEBUG_REG22_AVALID_q_SIZE   1
#define MH_DEBUG_REG22_AREADY_q_SIZE   1
#define MH_DEBUG_REG22_AID_q_SIZE      3
#define MH_DEBUG_REG22_ALEN_q_1_0_SIZE 2
#define MH_DEBUG_REG22_ARVALID_q_SIZE  1
#define MH_DEBUG_REG22_ARREADY_q_SIZE  1
#define MH_DEBUG_REG22_ARID_q_SIZE     3
#define MH_DEBUG_REG22_ARLEN_q_1_1_SIZE 1
#define MH_DEBUG_REG22_WVALID_q_SIZE   1
#define MH_DEBUG_REG22_WREADY_q_SIZE   1
#define MH_DEBUG_REG22_WLAST_q_SIZE    1
#define MH_DEBUG_REG22_WID_q_SIZE      3
#define MH_DEBUG_REG22_WSTRB_q_SIZE    8
#define MH_DEBUG_REG22_BVALID_q_SIZE   1
#define MH_DEBUG_REG22_BREADY_q_SIZE   1
#define MH_DEBUG_REG22_BID_q_SIZE      3

#define MH_DEBUG_REG22_AVALID_q_SHIFT  0
#define MH_DEBUG_REG22_AREADY_q_SHIFT  1
#define MH_DEBUG_REG22_AID_q_SHIFT     2
#define MH_DEBUG_REG22_ALEN_q_1_0_SHIFT 5
#define MH_DEBUG_REG22_ARVALID_q_SHIFT 7
#define MH_DEBUG_REG22_ARREADY_q_SHIFT 8
#define MH_DEBUG_REG22_ARID_q_SHIFT    9
#define MH_DEBUG_REG22_ARLEN_q_1_1_SHIFT 12
#define MH_DEBUG_REG22_WVALID_q_SHIFT  13
#define MH_DEBUG_REG22_WREADY_q_SHIFT  14
#define MH_DEBUG_REG22_WLAST_q_SHIFT   15
#define MH_DEBUG_REG22_WID_q_SHIFT     16
#define MH_DEBUG_REG22_WSTRB_q_SHIFT   19
#define MH_DEBUG_REG22_BVALID_q_SHIFT  27
#define MH_DEBUG_REG22_BREADY_q_SHIFT  28
#define MH_DEBUG_REG22_BID_q_SHIFT     29

#define MH_DEBUG_REG22_AVALID_q_MASK   0x00000001
#define MH_DEBUG_REG22_AREADY_q_MASK   0x00000002
#define MH_DEBUG_REG22_AID_q_MASK      0x0000001c
#define MH_DEBUG_REG22_ALEN_q_1_0_MASK 0x00000060
#define MH_DEBUG_REG22_ARVALID_q_MASK  0x00000080
#define MH_DEBUG_REG22_ARREADY_q_MASK  0x00000100
#define MH_DEBUG_REG22_ARID_q_MASK     0x00000e00
#define MH_DEBUG_REG22_ARLEN_q_1_1_MASK 0x00001000
#define MH_DEBUG_REG22_WVALID_q_MASK   0x00002000
#define MH_DEBUG_REG22_WREADY_q_MASK   0x00004000
#define MH_DEBUG_REG22_WLAST_q_MASK    0x00008000
#define MH_DEBUG_REG22_WID_q_MASK      0x00070000
#define MH_DEBUG_REG22_WSTRB_q_MASK    0x07f80000
#define MH_DEBUG_REG22_BVALID_q_MASK   0x08000000
#define MH_DEBUG_REG22_BREADY_q_MASK   0x10000000
#define MH_DEBUG_REG22_BID_q_MASK      0xe0000000

#define MH_DEBUG_REG22_MASK \
     (MH_DEBUG_REG22_AVALID_q_MASK | \
      MH_DEBUG_REG22_AREADY_q_MASK | \
      MH_DEBUG_REG22_AID_q_MASK | \
      MH_DEBUG_REG22_ALEN_q_1_0_MASK | \
      MH_DEBUG_REG22_ARVALID_q_MASK | \
      MH_DEBUG_REG22_ARREADY_q_MASK | \
      MH_DEBUG_REG22_ARID_q_MASK | \
      MH_DEBUG_REG22_ARLEN_q_1_1_MASK | \
      MH_DEBUG_REG22_WVALID_q_MASK | \
      MH_DEBUG_REG22_WREADY_q_MASK | \
      MH_DEBUG_REG22_WLAST_q_MASK | \
      MH_DEBUG_REG22_WID_q_MASK | \
      MH_DEBUG_REG22_WSTRB_q_MASK | \
      MH_DEBUG_REG22_BVALID_q_MASK | \
      MH_DEBUG_REG22_BREADY_q_MASK | \
      MH_DEBUG_REG22_BID_q_MASK)

#define MH_DEBUG_REG22(avalid_q, aready_q, aid_q, alen_q_1_0, arvalid_q, arready_q, arid_q, arlen_q_1_1, wvalid_q, wready_q, wlast_q, wid_q, wstrb_q, bvalid_q, bready_q, bid_q) \
     ((avalid_q << MH_DEBUG_REG22_AVALID_q_SHIFT) | \
      (aready_q << MH_DEBUG_REG22_AREADY_q_SHIFT) | \
      (aid_q << MH_DEBUG_REG22_AID_q_SHIFT) | \
      (alen_q_1_0 << MH_DEBUG_REG22_ALEN_q_1_0_SHIFT) | \
      (arvalid_q << MH_DEBUG_REG22_ARVALID_q_SHIFT) | \
      (arready_q << MH_DEBUG_REG22_ARREADY_q_SHIFT) | \
      (arid_q << MH_DEBUG_REG22_ARID_q_SHIFT) | \
      (arlen_q_1_1 << MH_DEBUG_REG22_ARLEN_q_1_1_SHIFT) | \
      (wvalid_q << MH_DEBUG_REG22_WVALID_q_SHIFT) | \
      (wready_q << MH_DEBUG_REG22_WREADY_q_SHIFT) | \
      (wlast_q << MH_DEBUG_REG22_WLAST_q_SHIFT) | \
      (wid_q << MH_DEBUG_REG22_WID_q_SHIFT) | \
      (wstrb_q << MH_DEBUG_REG22_WSTRB_q_SHIFT) | \
      (bvalid_q << MH_DEBUG_REG22_BVALID_q_SHIFT) | \
      (bready_q << MH_DEBUG_REG22_BREADY_q_SHIFT) | \
      (bid_q << MH_DEBUG_REG22_BID_q_SHIFT))

#define MH_DEBUG_REG22_GET_AVALID_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_AVALID_q_MASK) >> MH_DEBUG_REG22_AVALID_q_SHIFT)
#define MH_DEBUG_REG22_GET_AREADY_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_AREADY_q_MASK) >> MH_DEBUG_REG22_AREADY_q_SHIFT)
#define MH_DEBUG_REG22_GET_AID_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_AID_q_MASK) >> MH_DEBUG_REG22_AID_q_SHIFT)
#define MH_DEBUG_REG22_GET_ALEN_q_1_0(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_ALEN_q_1_0_MASK) >> MH_DEBUG_REG22_ALEN_q_1_0_SHIFT)
#define MH_DEBUG_REG22_GET_ARVALID_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_ARVALID_q_MASK) >> MH_DEBUG_REG22_ARVALID_q_SHIFT)
#define MH_DEBUG_REG22_GET_ARREADY_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_ARREADY_q_MASK) >> MH_DEBUG_REG22_ARREADY_q_SHIFT)
#define MH_DEBUG_REG22_GET_ARID_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_ARID_q_MASK) >> MH_DEBUG_REG22_ARID_q_SHIFT)
#define MH_DEBUG_REG22_GET_ARLEN_q_1_1(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_ARLEN_q_1_1_MASK) >> MH_DEBUG_REG22_ARLEN_q_1_1_SHIFT)
#define MH_DEBUG_REG22_GET_WVALID_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_WVALID_q_MASK) >> MH_DEBUG_REG22_WVALID_q_SHIFT)
#define MH_DEBUG_REG22_GET_WREADY_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_WREADY_q_MASK) >> MH_DEBUG_REG22_WREADY_q_SHIFT)
#define MH_DEBUG_REG22_GET_WLAST_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_WLAST_q_MASK) >> MH_DEBUG_REG22_WLAST_q_SHIFT)
#define MH_DEBUG_REG22_GET_WID_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_WID_q_MASK) >> MH_DEBUG_REG22_WID_q_SHIFT)
#define MH_DEBUG_REG22_GET_WSTRB_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_WSTRB_q_MASK) >> MH_DEBUG_REG22_WSTRB_q_SHIFT)
#define MH_DEBUG_REG22_GET_BVALID_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_BVALID_q_MASK) >> MH_DEBUG_REG22_BVALID_q_SHIFT)
#define MH_DEBUG_REG22_GET_BREADY_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_BREADY_q_MASK) >> MH_DEBUG_REG22_BREADY_q_SHIFT)
#define MH_DEBUG_REG22_GET_BID_q(mh_debug_reg22) \
     ((mh_debug_reg22 & MH_DEBUG_REG22_BID_q_MASK) >> MH_DEBUG_REG22_BID_q_SHIFT)

#define MH_DEBUG_REG22_SET_AVALID_q(mh_debug_reg22_reg, avalid_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_AVALID_q_MASK) | (avalid_q << MH_DEBUG_REG22_AVALID_q_SHIFT)
#define MH_DEBUG_REG22_SET_AREADY_q(mh_debug_reg22_reg, aready_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_AREADY_q_MASK) | (aready_q << MH_DEBUG_REG22_AREADY_q_SHIFT)
#define MH_DEBUG_REG22_SET_AID_q(mh_debug_reg22_reg, aid_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_AID_q_MASK) | (aid_q << MH_DEBUG_REG22_AID_q_SHIFT)
#define MH_DEBUG_REG22_SET_ALEN_q_1_0(mh_debug_reg22_reg, alen_q_1_0) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_ALEN_q_1_0_MASK) | (alen_q_1_0 << MH_DEBUG_REG22_ALEN_q_1_0_SHIFT)
#define MH_DEBUG_REG22_SET_ARVALID_q(mh_debug_reg22_reg, arvalid_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_ARVALID_q_MASK) | (arvalid_q << MH_DEBUG_REG22_ARVALID_q_SHIFT)
#define MH_DEBUG_REG22_SET_ARREADY_q(mh_debug_reg22_reg, arready_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_ARREADY_q_MASK) | (arready_q << MH_DEBUG_REG22_ARREADY_q_SHIFT)
#define MH_DEBUG_REG22_SET_ARID_q(mh_debug_reg22_reg, arid_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_ARID_q_MASK) | (arid_q << MH_DEBUG_REG22_ARID_q_SHIFT)
#define MH_DEBUG_REG22_SET_ARLEN_q_1_1(mh_debug_reg22_reg, arlen_q_1_1) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_ARLEN_q_1_1_MASK) | (arlen_q_1_1 << MH_DEBUG_REG22_ARLEN_q_1_1_SHIFT)
#define MH_DEBUG_REG22_SET_WVALID_q(mh_debug_reg22_reg, wvalid_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_WVALID_q_MASK) | (wvalid_q << MH_DEBUG_REG22_WVALID_q_SHIFT)
#define MH_DEBUG_REG22_SET_WREADY_q(mh_debug_reg22_reg, wready_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_WREADY_q_MASK) | (wready_q << MH_DEBUG_REG22_WREADY_q_SHIFT)
#define MH_DEBUG_REG22_SET_WLAST_q(mh_debug_reg22_reg, wlast_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_WLAST_q_MASK) | (wlast_q << MH_DEBUG_REG22_WLAST_q_SHIFT)
#define MH_DEBUG_REG22_SET_WID_q(mh_debug_reg22_reg, wid_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_WID_q_MASK) | (wid_q << MH_DEBUG_REG22_WID_q_SHIFT)
#define MH_DEBUG_REG22_SET_WSTRB_q(mh_debug_reg22_reg, wstrb_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_WSTRB_q_MASK) | (wstrb_q << MH_DEBUG_REG22_WSTRB_q_SHIFT)
#define MH_DEBUG_REG22_SET_BVALID_q(mh_debug_reg22_reg, bvalid_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_BVALID_q_MASK) | (bvalid_q << MH_DEBUG_REG22_BVALID_q_SHIFT)
#define MH_DEBUG_REG22_SET_BREADY_q(mh_debug_reg22_reg, bready_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_BREADY_q_MASK) | (bready_q << MH_DEBUG_REG22_BREADY_q_SHIFT)
#define MH_DEBUG_REG22_SET_BID_q(mh_debug_reg22_reg, bid_q) \
     mh_debug_reg22_reg = (mh_debug_reg22_reg & ~MH_DEBUG_REG22_BID_q_MASK) | (bid_q << MH_DEBUG_REG22_BID_q_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg22_t {
          unsigned int avalid_q                       : MH_DEBUG_REG22_AVALID_q_SIZE;
          unsigned int aready_q                       : MH_DEBUG_REG22_AREADY_q_SIZE;
          unsigned int aid_q                          : MH_DEBUG_REG22_AID_q_SIZE;
          unsigned int alen_q_1_0                     : MH_DEBUG_REG22_ALEN_q_1_0_SIZE;
          unsigned int arvalid_q                      : MH_DEBUG_REG22_ARVALID_q_SIZE;
          unsigned int arready_q                      : MH_DEBUG_REG22_ARREADY_q_SIZE;
          unsigned int arid_q                         : MH_DEBUG_REG22_ARID_q_SIZE;
          unsigned int arlen_q_1_1                    : MH_DEBUG_REG22_ARLEN_q_1_1_SIZE;
          unsigned int wvalid_q                       : MH_DEBUG_REG22_WVALID_q_SIZE;
          unsigned int wready_q                       : MH_DEBUG_REG22_WREADY_q_SIZE;
          unsigned int wlast_q                        : MH_DEBUG_REG22_WLAST_q_SIZE;
          unsigned int wid_q                          : MH_DEBUG_REG22_WID_q_SIZE;
          unsigned int wstrb_q                        : MH_DEBUG_REG22_WSTRB_q_SIZE;
          unsigned int bvalid_q                       : MH_DEBUG_REG22_BVALID_q_SIZE;
          unsigned int bready_q                       : MH_DEBUG_REG22_BREADY_q_SIZE;
          unsigned int bid_q                          : MH_DEBUG_REG22_BID_q_SIZE;
     } mh_debug_reg22_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg22_t {
          unsigned int bid_q                          : MH_DEBUG_REG22_BID_q_SIZE;
          unsigned int bready_q                       : MH_DEBUG_REG22_BREADY_q_SIZE;
          unsigned int bvalid_q                       : MH_DEBUG_REG22_BVALID_q_SIZE;
          unsigned int wstrb_q                        : MH_DEBUG_REG22_WSTRB_q_SIZE;
          unsigned int wid_q                          : MH_DEBUG_REG22_WID_q_SIZE;
          unsigned int wlast_q                        : MH_DEBUG_REG22_WLAST_q_SIZE;
          unsigned int wready_q                       : MH_DEBUG_REG22_WREADY_q_SIZE;
          unsigned int wvalid_q                       : MH_DEBUG_REG22_WVALID_q_SIZE;
          unsigned int arlen_q_1_1                    : MH_DEBUG_REG22_ARLEN_q_1_1_SIZE;
          unsigned int arid_q                         : MH_DEBUG_REG22_ARID_q_SIZE;
          unsigned int arready_q                      : MH_DEBUG_REG22_ARREADY_q_SIZE;
          unsigned int arvalid_q                      : MH_DEBUG_REG22_ARVALID_q_SIZE;
          unsigned int alen_q_1_0                     : MH_DEBUG_REG22_ALEN_q_1_0_SIZE;
          unsigned int aid_q                          : MH_DEBUG_REG22_AID_q_SIZE;
          unsigned int aready_q                       : MH_DEBUG_REG22_AREADY_q_SIZE;
          unsigned int avalid_q                       : MH_DEBUG_REG22_AVALID_q_SIZE;
     } mh_debug_reg22_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg22_t f;
} mh_debug_reg22_u;


/*
 * MH_DEBUG_REG23 struct
 */

#define MH_DEBUG_REG23_ARC_CTRL_RE_q_SIZE 1
#define MH_DEBUG_REG23_CTRL_ARC_ID_SIZE 3
#define MH_DEBUG_REG23_CTRL_ARC_PAD_SIZE 28

#define MH_DEBUG_REG23_ARC_CTRL_RE_q_SHIFT 0
#define MH_DEBUG_REG23_CTRL_ARC_ID_SHIFT 1
#define MH_DEBUG_REG23_CTRL_ARC_PAD_SHIFT 4

#define MH_DEBUG_REG23_ARC_CTRL_RE_q_MASK 0x00000001
#define MH_DEBUG_REG23_CTRL_ARC_ID_MASK 0x0000000e
#define MH_DEBUG_REG23_CTRL_ARC_PAD_MASK 0xfffffff0

#define MH_DEBUG_REG23_MASK \
     (MH_DEBUG_REG23_ARC_CTRL_RE_q_MASK | \
      MH_DEBUG_REG23_CTRL_ARC_ID_MASK | \
      MH_DEBUG_REG23_CTRL_ARC_PAD_MASK)

#define MH_DEBUG_REG23(arc_ctrl_re_q, ctrl_arc_id, ctrl_arc_pad) \
     ((arc_ctrl_re_q << MH_DEBUG_REG23_ARC_CTRL_RE_q_SHIFT) | \
      (ctrl_arc_id << MH_DEBUG_REG23_CTRL_ARC_ID_SHIFT) | \
      (ctrl_arc_pad << MH_DEBUG_REG23_CTRL_ARC_PAD_SHIFT))

#define MH_DEBUG_REG23_GET_ARC_CTRL_RE_q(mh_debug_reg23) \
     ((mh_debug_reg23 & MH_DEBUG_REG23_ARC_CTRL_RE_q_MASK) >> MH_DEBUG_REG23_ARC_CTRL_RE_q_SHIFT)
#define MH_DEBUG_REG23_GET_CTRL_ARC_ID(mh_debug_reg23) \
     ((mh_debug_reg23 & MH_DEBUG_REG23_CTRL_ARC_ID_MASK) >> MH_DEBUG_REG23_CTRL_ARC_ID_SHIFT)
#define MH_DEBUG_REG23_GET_CTRL_ARC_PAD(mh_debug_reg23) \
     ((mh_debug_reg23 & MH_DEBUG_REG23_CTRL_ARC_PAD_MASK) >> MH_DEBUG_REG23_CTRL_ARC_PAD_SHIFT)

#define MH_DEBUG_REG23_SET_ARC_CTRL_RE_q(mh_debug_reg23_reg, arc_ctrl_re_q) \
     mh_debug_reg23_reg = (mh_debug_reg23_reg & ~MH_DEBUG_REG23_ARC_CTRL_RE_q_MASK) | (arc_ctrl_re_q << MH_DEBUG_REG23_ARC_CTRL_RE_q_SHIFT)
#define MH_DEBUG_REG23_SET_CTRL_ARC_ID(mh_debug_reg23_reg, ctrl_arc_id) \
     mh_debug_reg23_reg = (mh_debug_reg23_reg & ~MH_DEBUG_REG23_CTRL_ARC_ID_MASK) | (ctrl_arc_id << MH_DEBUG_REG23_CTRL_ARC_ID_SHIFT)
#define MH_DEBUG_REG23_SET_CTRL_ARC_PAD(mh_debug_reg23_reg, ctrl_arc_pad) \
     mh_debug_reg23_reg = (mh_debug_reg23_reg & ~MH_DEBUG_REG23_CTRL_ARC_PAD_MASK) | (ctrl_arc_pad << MH_DEBUG_REG23_CTRL_ARC_PAD_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg23_t {
          unsigned int arc_ctrl_re_q                  : MH_DEBUG_REG23_ARC_CTRL_RE_q_SIZE;
          unsigned int ctrl_arc_id                    : MH_DEBUG_REG23_CTRL_ARC_ID_SIZE;
          unsigned int ctrl_arc_pad                   : MH_DEBUG_REG23_CTRL_ARC_PAD_SIZE;
     } mh_debug_reg23_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg23_t {
          unsigned int ctrl_arc_pad                   : MH_DEBUG_REG23_CTRL_ARC_PAD_SIZE;
          unsigned int ctrl_arc_id                    : MH_DEBUG_REG23_CTRL_ARC_ID_SIZE;
          unsigned int arc_ctrl_re_q                  : MH_DEBUG_REG23_ARC_CTRL_RE_q_SIZE;
     } mh_debug_reg23_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg23_t f;
} mh_debug_reg23_u;


/*
 * MH_DEBUG_REG24 struct
 */

#define MH_DEBUG_REG24_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG24_REG_A_SIZE      14
#define MH_DEBUG_REG24_REG_RE_SIZE     1
#define MH_DEBUG_REG24_REG_WE_SIZE     1
#define MH_DEBUG_REG24_BLOCK_RS_SIZE   1

#define MH_DEBUG_REG24_ALWAYS_ZERO_SHIFT 0
#define MH_DEBUG_REG24_REG_A_SHIFT     2
#define MH_DEBUG_REG24_REG_RE_SHIFT    16
#define MH_DEBUG_REG24_REG_WE_SHIFT    17
#define MH_DEBUG_REG24_BLOCK_RS_SHIFT  18

#define MH_DEBUG_REG24_ALWAYS_ZERO_MASK 0x00000003
#define MH_DEBUG_REG24_REG_A_MASK      0x0000fffc
#define MH_DEBUG_REG24_REG_RE_MASK     0x00010000
#define MH_DEBUG_REG24_REG_WE_MASK     0x00020000
#define MH_DEBUG_REG24_BLOCK_RS_MASK   0x00040000

#define MH_DEBUG_REG24_MASK \
     (MH_DEBUG_REG24_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG24_REG_A_MASK | \
      MH_DEBUG_REG24_REG_RE_MASK | \
      MH_DEBUG_REG24_REG_WE_MASK | \
      MH_DEBUG_REG24_BLOCK_RS_MASK)

#define MH_DEBUG_REG24(always_zero, reg_a, reg_re, reg_we, block_rs) \
     ((always_zero << MH_DEBUG_REG24_ALWAYS_ZERO_SHIFT) | \
      (reg_a << MH_DEBUG_REG24_REG_A_SHIFT) | \
      (reg_re << MH_DEBUG_REG24_REG_RE_SHIFT) | \
      (reg_we << MH_DEBUG_REG24_REG_WE_SHIFT) | \
      (block_rs << MH_DEBUG_REG24_BLOCK_RS_SHIFT))

#define MH_DEBUG_REG24_GET_ALWAYS_ZERO(mh_debug_reg24) \
     ((mh_debug_reg24 & MH_DEBUG_REG24_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG24_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG24_GET_REG_A(mh_debug_reg24) \
     ((mh_debug_reg24 & MH_DEBUG_REG24_REG_A_MASK) >> MH_DEBUG_REG24_REG_A_SHIFT)
#define MH_DEBUG_REG24_GET_REG_RE(mh_debug_reg24) \
     ((mh_debug_reg24 & MH_DEBUG_REG24_REG_RE_MASK) >> MH_DEBUG_REG24_REG_RE_SHIFT)
#define MH_DEBUG_REG24_GET_REG_WE(mh_debug_reg24) \
     ((mh_debug_reg24 & MH_DEBUG_REG24_REG_WE_MASK) >> MH_DEBUG_REG24_REG_WE_SHIFT)
#define MH_DEBUG_REG24_GET_BLOCK_RS(mh_debug_reg24) \
     ((mh_debug_reg24 & MH_DEBUG_REG24_BLOCK_RS_MASK) >> MH_DEBUG_REG24_BLOCK_RS_SHIFT)

#define MH_DEBUG_REG24_SET_ALWAYS_ZERO(mh_debug_reg24_reg, always_zero) \
     mh_debug_reg24_reg = (mh_debug_reg24_reg & ~MH_DEBUG_REG24_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG24_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG24_SET_REG_A(mh_debug_reg24_reg, reg_a) \
     mh_debug_reg24_reg = (mh_debug_reg24_reg & ~MH_DEBUG_REG24_REG_A_MASK) | (reg_a << MH_DEBUG_REG24_REG_A_SHIFT)
#define MH_DEBUG_REG24_SET_REG_RE(mh_debug_reg24_reg, reg_re) \
     mh_debug_reg24_reg = (mh_debug_reg24_reg & ~MH_DEBUG_REG24_REG_RE_MASK) | (reg_re << MH_DEBUG_REG24_REG_RE_SHIFT)
#define MH_DEBUG_REG24_SET_REG_WE(mh_debug_reg24_reg, reg_we) \
     mh_debug_reg24_reg = (mh_debug_reg24_reg & ~MH_DEBUG_REG24_REG_WE_MASK) | (reg_we << MH_DEBUG_REG24_REG_WE_SHIFT)
#define MH_DEBUG_REG24_SET_BLOCK_RS(mh_debug_reg24_reg, block_rs) \
     mh_debug_reg24_reg = (mh_debug_reg24_reg & ~MH_DEBUG_REG24_BLOCK_RS_MASK) | (block_rs << MH_DEBUG_REG24_BLOCK_RS_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg24_t {
          unsigned int always_zero                    : MH_DEBUG_REG24_ALWAYS_ZERO_SIZE;
          unsigned int reg_a                          : MH_DEBUG_REG24_REG_A_SIZE;
          unsigned int reg_re                         : MH_DEBUG_REG24_REG_RE_SIZE;
          unsigned int reg_we                         : MH_DEBUG_REG24_REG_WE_SIZE;
          unsigned int block_rs                       : MH_DEBUG_REG24_BLOCK_RS_SIZE;
          unsigned int                                : 13;
     } mh_debug_reg24_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg24_t {
          unsigned int                                : 13;
          unsigned int block_rs                       : MH_DEBUG_REG24_BLOCK_RS_SIZE;
          unsigned int reg_we                         : MH_DEBUG_REG24_REG_WE_SIZE;
          unsigned int reg_re                         : MH_DEBUG_REG24_REG_RE_SIZE;
          unsigned int reg_a                          : MH_DEBUG_REG24_REG_A_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG24_ALWAYS_ZERO_SIZE;
     } mh_debug_reg24_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg24_t f;
} mh_debug_reg24_u;


/*
 * MH_DEBUG_REG25 struct
 */

#define MH_DEBUG_REG25_REG_WD_SIZE     32

#define MH_DEBUG_REG25_REG_WD_SHIFT    0

#define MH_DEBUG_REG25_REG_WD_MASK     0xffffffff

#define MH_DEBUG_REG25_MASK \
     (MH_DEBUG_REG25_REG_WD_MASK)

#define MH_DEBUG_REG25(reg_wd) \
     ((reg_wd << MH_DEBUG_REG25_REG_WD_SHIFT))

#define MH_DEBUG_REG25_GET_REG_WD(mh_debug_reg25) \
     ((mh_debug_reg25 & MH_DEBUG_REG25_REG_WD_MASK) >> MH_DEBUG_REG25_REG_WD_SHIFT)

#define MH_DEBUG_REG25_SET_REG_WD(mh_debug_reg25_reg, reg_wd) \
     mh_debug_reg25_reg = (mh_debug_reg25_reg & ~MH_DEBUG_REG25_REG_WD_MASK) | (reg_wd << MH_DEBUG_REG25_REG_WD_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg25_t {
          unsigned int reg_wd                         : MH_DEBUG_REG25_REG_WD_SIZE;
     } mh_debug_reg25_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg25_t {
          unsigned int reg_wd                         : MH_DEBUG_REG25_REG_WD_SIZE;
     } mh_debug_reg25_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg25_t f;
} mh_debug_reg25_u;


/*
 * MH_DEBUG_REG26 struct
 */

#define MH_DEBUG_REG26_MH_RBBM_busy_SIZE 1
#define MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_SIZE 1
#define MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_SIZE 1
#define MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_SIZE 1
#define MH_DEBUG_REG26_GAT_CLK_ENA_SIZE 1
#define MH_DEBUG_REG26_RBBM_MH_clk_en_override_SIZE 1
#define MH_DEBUG_REG26_CNT_q_SIZE      6
#define MH_DEBUG_REG26_TCD_EMPTY_q_SIZE 1
#define MH_DEBUG_REG26_TC_ROQ_EMPTY_SIZE 1
#define MH_DEBUG_REG26_MH_BUSY_d_SIZE  1
#define MH_DEBUG_REG26_ANY_CLNT_BUSY_SIZE 1
#define MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_SIZE 1
#define MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_SIZE 1
#define MH_DEBUG_REG26_CP_SEND_q_SIZE  1
#define MH_DEBUG_REG26_CP_RTR_q_SIZE   1
#define MH_DEBUG_REG26_VGT_SEND_q_SIZE 1
#define MH_DEBUG_REG26_VGT_RTR_q_SIZE  1
#define MH_DEBUG_REG26_TC_ROQ_SEND_q_SIZE 1
#define MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_SIZE 1
#define MH_DEBUG_REG26_RB_SEND_q_SIZE  1
#define MH_DEBUG_REG26_RB_RTR_q_SIZE   1
#define MH_DEBUG_REG26_PA_SEND_q_SIZE  1
#define MH_DEBUG_REG26_PA_RTR_q_SIZE   1
#define MH_DEBUG_REG26_RDC_VALID_SIZE  1
#define MH_DEBUG_REG26_RDC_RLAST_SIZE  1
#define MH_DEBUG_REG26_TLBMISS_VALID_SIZE 1
#define MH_DEBUG_REG26_BRC_VALID_SIZE  1

#define MH_DEBUG_REG26_MH_RBBM_busy_SHIFT 0
#define MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_SHIFT 1
#define MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_SHIFT 2
#define MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_SHIFT 3
#define MH_DEBUG_REG26_GAT_CLK_ENA_SHIFT 4
#define MH_DEBUG_REG26_RBBM_MH_clk_en_override_SHIFT 5
#define MH_DEBUG_REG26_CNT_q_SHIFT     6
#define MH_DEBUG_REG26_TCD_EMPTY_q_SHIFT 12
#define MH_DEBUG_REG26_TC_ROQ_EMPTY_SHIFT 13
#define MH_DEBUG_REG26_MH_BUSY_d_SHIFT 14
#define MH_DEBUG_REG26_ANY_CLNT_BUSY_SHIFT 15
#define MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_SHIFT 16
#define MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_SHIFT 17
#define MH_DEBUG_REG26_CP_SEND_q_SHIFT 18
#define MH_DEBUG_REG26_CP_RTR_q_SHIFT  19
#define MH_DEBUG_REG26_VGT_SEND_q_SHIFT 20
#define MH_DEBUG_REG26_VGT_RTR_q_SHIFT 21
#define MH_DEBUG_REG26_TC_ROQ_SEND_q_SHIFT 22
#define MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_SHIFT 23
#define MH_DEBUG_REG26_RB_SEND_q_SHIFT 24
#define MH_DEBUG_REG26_RB_RTR_q_SHIFT  25
#define MH_DEBUG_REG26_PA_SEND_q_SHIFT 26
#define MH_DEBUG_REG26_PA_RTR_q_SHIFT  27
#define MH_DEBUG_REG26_RDC_VALID_SHIFT 28
#define MH_DEBUG_REG26_RDC_RLAST_SHIFT 29
#define MH_DEBUG_REG26_TLBMISS_VALID_SHIFT 30
#define MH_DEBUG_REG26_BRC_VALID_SHIFT 31

#define MH_DEBUG_REG26_MH_RBBM_busy_MASK 0x00000001
#define MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_MASK 0x00000002
#define MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_MASK 0x00000004
#define MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_MASK 0x00000008
#define MH_DEBUG_REG26_GAT_CLK_ENA_MASK 0x00000010
#define MH_DEBUG_REG26_RBBM_MH_clk_en_override_MASK 0x00000020
#define MH_DEBUG_REG26_CNT_q_MASK      0x00000fc0
#define MH_DEBUG_REG26_TCD_EMPTY_q_MASK 0x00001000
#define MH_DEBUG_REG26_TC_ROQ_EMPTY_MASK 0x00002000
#define MH_DEBUG_REG26_MH_BUSY_d_MASK  0x00004000
#define MH_DEBUG_REG26_ANY_CLNT_BUSY_MASK 0x00008000
#define MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_MASK 0x00010000
#define MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_MASK 0x00020000
#define MH_DEBUG_REG26_CP_SEND_q_MASK  0x00040000
#define MH_DEBUG_REG26_CP_RTR_q_MASK   0x00080000
#define MH_DEBUG_REG26_VGT_SEND_q_MASK 0x00100000
#define MH_DEBUG_REG26_VGT_RTR_q_MASK  0x00200000
#define MH_DEBUG_REG26_TC_ROQ_SEND_q_MASK 0x00400000
#define MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_MASK 0x00800000
#define MH_DEBUG_REG26_RB_SEND_q_MASK  0x01000000
#define MH_DEBUG_REG26_RB_RTR_q_MASK   0x02000000
#define MH_DEBUG_REG26_PA_SEND_q_MASK  0x04000000
#define MH_DEBUG_REG26_PA_RTR_q_MASK   0x08000000
#define MH_DEBUG_REG26_RDC_VALID_MASK  0x10000000
#define MH_DEBUG_REG26_RDC_RLAST_MASK  0x20000000
#define MH_DEBUG_REG26_TLBMISS_VALID_MASK 0x40000000
#define MH_DEBUG_REG26_BRC_VALID_MASK  0x80000000

#define MH_DEBUG_REG26_MASK \
     (MH_DEBUG_REG26_MH_RBBM_busy_MASK | \
      MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_MASK | \
      MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_MASK | \
      MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_MASK | \
      MH_DEBUG_REG26_GAT_CLK_ENA_MASK | \
      MH_DEBUG_REG26_RBBM_MH_clk_en_override_MASK | \
      MH_DEBUG_REG26_CNT_q_MASK | \
      MH_DEBUG_REG26_TCD_EMPTY_q_MASK | \
      MH_DEBUG_REG26_TC_ROQ_EMPTY_MASK | \
      MH_DEBUG_REG26_MH_BUSY_d_MASK | \
      MH_DEBUG_REG26_ANY_CLNT_BUSY_MASK | \
      MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_MASK | \
      MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_MASK | \
      MH_DEBUG_REG26_CP_SEND_q_MASK | \
      MH_DEBUG_REG26_CP_RTR_q_MASK | \
      MH_DEBUG_REG26_VGT_SEND_q_MASK | \
      MH_DEBUG_REG26_VGT_RTR_q_MASK | \
      MH_DEBUG_REG26_TC_ROQ_SEND_q_MASK | \
      MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_MASK | \
      MH_DEBUG_REG26_RB_SEND_q_MASK | \
      MH_DEBUG_REG26_RB_RTR_q_MASK | \
      MH_DEBUG_REG26_PA_SEND_q_MASK | \
      MH_DEBUG_REG26_PA_RTR_q_MASK | \
      MH_DEBUG_REG26_RDC_VALID_MASK | \
      MH_DEBUG_REG26_RDC_RLAST_MASK | \
      MH_DEBUG_REG26_TLBMISS_VALID_MASK | \
      MH_DEBUG_REG26_BRC_VALID_MASK)

#define MH_DEBUG_REG26(mh_rbbm_busy, mh_cib_mh_clk_en_int, mh_cib_mmu_clk_en_int, mh_cib_tcroq_clk_en_int, gat_clk_ena, rbbm_mh_clk_en_override, cnt_q, tcd_empty_q, tc_roq_empty, mh_busy_d, any_clnt_busy, mh_mmu_invalidate_invalidate_all, mh_mmu_invalidate_invalidate_tc, cp_send_q, cp_rtr_q, vgt_send_q, vgt_rtr_q, tc_roq_send_q, tc_roq_rtr_dbg_q, rb_send_q, rb_rtr_q, pa_send_q, pa_rtr_q, rdc_valid, rdc_rlast, tlbmiss_valid, brc_valid) \
     ((mh_rbbm_busy << MH_DEBUG_REG26_MH_RBBM_busy_SHIFT) | \
      (mh_cib_mh_clk_en_int << MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_SHIFT) | \
      (mh_cib_mmu_clk_en_int << MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_SHIFT) | \
      (mh_cib_tcroq_clk_en_int << MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_SHIFT) | \
      (gat_clk_ena << MH_DEBUG_REG26_GAT_CLK_ENA_SHIFT) | \
      (rbbm_mh_clk_en_override << MH_DEBUG_REG26_RBBM_MH_clk_en_override_SHIFT) | \
      (cnt_q << MH_DEBUG_REG26_CNT_q_SHIFT) | \
      (tcd_empty_q << MH_DEBUG_REG26_TCD_EMPTY_q_SHIFT) | \
      (tc_roq_empty << MH_DEBUG_REG26_TC_ROQ_EMPTY_SHIFT) | \
      (mh_busy_d << MH_DEBUG_REG26_MH_BUSY_d_SHIFT) | \
      (any_clnt_busy << MH_DEBUG_REG26_ANY_CLNT_BUSY_SHIFT) | \
      (mh_mmu_invalidate_invalidate_all << MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_SHIFT) | \
      (mh_mmu_invalidate_invalidate_tc << MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_SHIFT) | \
      (cp_send_q << MH_DEBUG_REG26_CP_SEND_q_SHIFT) | \
      (cp_rtr_q << MH_DEBUG_REG26_CP_RTR_q_SHIFT) | \
      (vgt_send_q << MH_DEBUG_REG26_VGT_SEND_q_SHIFT) | \
      (vgt_rtr_q << MH_DEBUG_REG26_VGT_RTR_q_SHIFT) | \
      (tc_roq_send_q << MH_DEBUG_REG26_TC_ROQ_SEND_q_SHIFT) | \
      (tc_roq_rtr_dbg_q << MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_SHIFT) | \
      (rb_send_q << MH_DEBUG_REG26_RB_SEND_q_SHIFT) | \
      (rb_rtr_q << MH_DEBUG_REG26_RB_RTR_q_SHIFT) | \
      (pa_send_q << MH_DEBUG_REG26_PA_SEND_q_SHIFT) | \
      (pa_rtr_q << MH_DEBUG_REG26_PA_RTR_q_SHIFT) | \
      (rdc_valid << MH_DEBUG_REG26_RDC_VALID_SHIFT) | \
      (rdc_rlast << MH_DEBUG_REG26_RDC_RLAST_SHIFT) | \
      (tlbmiss_valid << MH_DEBUG_REG26_TLBMISS_VALID_SHIFT) | \
      (brc_valid << MH_DEBUG_REG26_BRC_VALID_SHIFT))

#define MH_DEBUG_REG26_GET_MH_RBBM_busy(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_MH_RBBM_busy_MASK) >> MH_DEBUG_REG26_MH_RBBM_busy_SHIFT)
#define MH_DEBUG_REG26_GET_MH_CIB_mh_clk_en_int(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_MASK) >> MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_SHIFT)
#define MH_DEBUG_REG26_GET_MH_CIB_mmu_clk_en_int(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_MASK) >> MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_SHIFT)
#define MH_DEBUG_REG26_GET_MH_CIB_tcroq_clk_en_int(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_MASK) >> MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_SHIFT)
#define MH_DEBUG_REG26_GET_GAT_CLK_ENA(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_GAT_CLK_ENA_MASK) >> MH_DEBUG_REG26_GAT_CLK_ENA_SHIFT)
#define MH_DEBUG_REG26_GET_RBBM_MH_clk_en_override(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_RBBM_MH_clk_en_override_MASK) >> MH_DEBUG_REG26_RBBM_MH_clk_en_override_SHIFT)
#define MH_DEBUG_REG26_GET_CNT_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_CNT_q_MASK) >> MH_DEBUG_REG26_CNT_q_SHIFT)
#define MH_DEBUG_REG26_GET_TCD_EMPTY_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_TCD_EMPTY_q_MASK) >> MH_DEBUG_REG26_TCD_EMPTY_q_SHIFT)
#define MH_DEBUG_REG26_GET_TC_ROQ_EMPTY(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_TC_ROQ_EMPTY_MASK) >> MH_DEBUG_REG26_TC_ROQ_EMPTY_SHIFT)
#define MH_DEBUG_REG26_GET_MH_BUSY_d(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_MH_BUSY_d_MASK) >> MH_DEBUG_REG26_MH_BUSY_d_SHIFT)
#define MH_DEBUG_REG26_GET_ANY_CLNT_BUSY(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_ANY_CLNT_BUSY_MASK) >> MH_DEBUG_REG26_ANY_CLNT_BUSY_SHIFT)
#define MH_DEBUG_REG26_GET_MH_MMU_INVALIDATE_INVALIDATE_ALL(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_MASK) >> MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_SHIFT)
#define MH_DEBUG_REG26_GET_MH_MMU_INVALIDATE_INVALIDATE_TC(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_MASK) >> MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_SHIFT)
#define MH_DEBUG_REG26_GET_CP_SEND_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_CP_SEND_q_MASK) >> MH_DEBUG_REG26_CP_SEND_q_SHIFT)
#define MH_DEBUG_REG26_GET_CP_RTR_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_CP_RTR_q_MASK) >> MH_DEBUG_REG26_CP_RTR_q_SHIFT)
#define MH_DEBUG_REG26_GET_VGT_SEND_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_VGT_SEND_q_MASK) >> MH_DEBUG_REG26_VGT_SEND_q_SHIFT)
#define MH_DEBUG_REG26_GET_VGT_RTR_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_VGT_RTR_q_MASK) >> MH_DEBUG_REG26_VGT_RTR_q_SHIFT)
#define MH_DEBUG_REG26_GET_TC_ROQ_SEND_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_TC_ROQ_SEND_q_MASK) >> MH_DEBUG_REG26_TC_ROQ_SEND_q_SHIFT)
#define MH_DEBUG_REG26_GET_TC_ROQ_RTR_DBG_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_MASK) >> MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_SHIFT)
#define MH_DEBUG_REG26_GET_RB_SEND_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_RB_SEND_q_MASK) >> MH_DEBUG_REG26_RB_SEND_q_SHIFT)
#define MH_DEBUG_REG26_GET_RB_RTR_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_RB_RTR_q_MASK) >> MH_DEBUG_REG26_RB_RTR_q_SHIFT)
#define MH_DEBUG_REG26_GET_PA_SEND_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_PA_SEND_q_MASK) >> MH_DEBUG_REG26_PA_SEND_q_SHIFT)
#define MH_DEBUG_REG26_GET_PA_RTR_q(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_PA_RTR_q_MASK) >> MH_DEBUG_REG26_PA_RTR_q_SHIFT)
#define MH_DEBUG_REG26_GET_RDC_VALID(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_RDC_VALID_MASK) >> MH_DEBUG_REG26_RDC_VALID_SHIFT)
#define MH_DEBUG_REG26_GET_RDC_RLAST(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_RDC_RLAST_MASK) >> MH_DEBUG_REG26_RDC_RLAST_SHIFT)
#define MH_DEBUG_REG26_GET_TLBMISS_VALID(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_TLBMISS_VALID_MASK) >> MH_DEBUG_REG26_TLBMISS_VALID_SHIFT)
#define MH_DEBUG_REG26_GET_BRC_VALID(mh_debug_reg26) \
     ((mh_debug_reg26 & MH_DEBUG_REG26_BRC_VALID_MASK) >> MH_DEBUG_REG26_BRC_VALID_SHIFT)

#define MH_DEBUG_REG26_SET_MH_RBBM_busy(mh_debug_reg26_reg, mh_rbbm_busy) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_MH_RBBM_busy_MASK) | (mh_rbbm_busy << MH_DEBUG_REG26_MH_RBBM_busy_SHIFT)
#define MH_DEBUG_REG26_SET_MH_CIB_mh_clk_en_int(mh_debug_reg26_reg, mh_cib_mh_clk_en_int) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_MASK) | (mh_cib_mh_clk_en_int << MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_SHIFT)
#define MH_DEBUG_REG26_SET_MH_CIB_mmu_clk_en_int(mh_debug_reg26_reg, mh_cib_mmu_clk_en_int) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_MASK) | (mh_cib_mmu_clk_en_int << MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_SHIFT)
#define MH_DEBUG_REG26_SET_MH_CIB_tcroq_clk_en_int(mh_debug_reg26_reg, mh_cib_tcroq_clk_en_int) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_MASK) | (mh_cib_tcroq_clk_en_int << MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_SHIFT)
#define MH_DEBUG_REG26_SET_GAT_CLK_ENA(mh_debug_reg26_reg, gat_clk_ena) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_GAT_CLK_ENA_MASK) | (gat_clk_ena << MH_DEBUG_REG26_GAT_CLK_ENA_SHIFT)
#define MH_DEBUG_REG26_SET_RBBM_MH_clk_en_override(mh_debug_reg26_reg, rbbm_mh_clk_en_override) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_RBBM_MH_clk_en_override_MASK) | (rbbm_mh_clk_en_override << MH_DEBUG_REG26_RBBM_MH_clk_en_override_SHIFT)
#define MH_DEBUG_REG26_SET_CNT_q(mh_debug_reg26_reg, cnt_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_CNT_q_MASK) | (cnt_q << MH_DEBUG_REG26_CNT_q_SHIFT)
#define MH_DEBUG_REG26_SET_TCD_EMPTY_q(mh_debug_reg26_reg, tcd_empty_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_TCD_EMPTY_q_MASK) | (tcd_empty_q << MH_DEBUG_REG26_TCD_EMPTY_q_SHIFT)
#define MH_DEBUG_REG26_SET_TC_ROQ_EMPTY(mh_debug_reg26_reg, tc_roq_empty) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_TC_ROQ_EMPTY_MASK) | (tc_roq_empty << MH_DEBUG_REG26_TC_ROQ_EMPTY_SHIFT)
#define MH_DEBUG_REG26_SET_MH_BUSY_d(mh_debug_reg26_reg, mh_busy_d) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_MH_BUSY_d_MASK) | (mh_busy_d << MH_DEBUG_REG26_MH_BUSY_d_SHIFT)
#define MH_DEBUG_REG26_SET_ANY_CLNT_BUSY(mh_debug_reg26_reg, any_clnt_busy) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_ANY_CLNT_BUSY_MASK) | (any_clnt_busy << MH_DEBUG_REG26_ANY_CLNT_BUSY_SHIFT)
#define MH_DEBUG_REG26_SET_MH_MMU_INVALIDATE_INVALIDATE_ALL(mh_debug_reg26_reg, mh_mmu_invalidate_invalidate_all) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_MASK) | (mh_mmu_invalidate_invalidate_all << MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_SHIFT)
#define MH_DEBUG_REG26_SET_MH_MMU_INVALIDATE_INVALIDATE_TC(mh_debug_reg26_reg, mh_mmu_invalidate_invalidate_tc) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_MASK) | (mh_mmu_invalidate_invalidate_tc << MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_SHIFT)
#define MH_DEBUG_REG26_SET_CP_SEND_q(mh_debug_reg26_reg, cp_send_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_CP_SEND_q_MASK) | (cp_send_q << MH_DEBUG_REG26_CP_SEND_q_SHIFT)
#define MH_DEBUG_REG26_SET_CP_RTR_q(mh_debug_reg26_reg, cp_rtr_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_CP_RTR_q_MASK) | (cp_rtr_q << MH_DEBUG_REG26_CP_RTR_q_SHIFT)
#define MH_DEBUG_REG26_SET_VGT_SEND_q(mh_debug_reg26_reg, vgt_send_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_VGT_SEND_q_MASK) | (vgt_send_q << MH_DEBUG_REG26_VGT_SEND_q_SHIFT)
#define MH_DEBUG_REG26_SET_VGT_RTR_q(mh_debug_reg26_reg, vgt_rtr_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_VGT_RTR_q_MASK) | (vgt_rtr_q << MH_DEBUG_REG26_VGT_RTR_q_SHIFT)
#define MH_DEBUG_REG26_SET_TC_ROQ_SEND_q(mh_debug_reg26_reg, tc_roq_send_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_TC_ROQ_SEND_q_MASK) | (tc_roq_send_q << MH_DEBUG_REG26_TC_ROQ_SEND_q_SHIFT)
#define MH_DEBUG_REG26_SET_TC_ROQ_RTR_DBG_q(mh_debug_reg26_reg, tc_roq_rtr_dbg_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_MASK) | (tc_roq_rtr_dbg_q << MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_SHIFT)
#define MH_DEBUG_REG26_SET_RB_SEND_q(mh_debug_reg26_reg, rb_send_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_RB_SEND_q_MASK) | (rb_send_q << MH_DEBUG_REG26_RB_SEND_q_SHIFT)
#define MH_DEBUG_REG26_SET_RB_RTR_q(mh_debug_reg26_reg, rb_rtr_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_RB_RTR_q_MASK) | (rb_rtr_q << MH_DEBUG_REG26_RB_RTR_q_SHIFT)
#define MH_DEBUG_REG26_SET_PA_SEND_q(mh_debug_reg26_reg, pa_send_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_PA_SEND_q_MASK) | (pa_send_q << MH_DEBUG_REG26_PA_SEND_q_SHIFT)
#define MH_DEBUG_REG26_SET_PA_RTR_q(mh_debug_reg26_reg, pa_rtr_q) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_PA_RTR_q_MASK) | (pa_rtr_q << MH_DEBUG_REG26_PA_RTR_q_SHIFT)
#define MH_DEBUG_REG26_SET_RDC_VALID(mh_debug_reg26_reg, rdc_valid) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_RDC_VALID_MASK) | (rdc_valid << MH_DEBUG_REG26_RDC_VALID_SHIFT)
#define MH_DEBUG_REG26_SET_RDC_RLAST(mh_debug_reg26_reg, rdc_rlast) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_RDC_RLAST_MASK) | (rdc_rlast << MH_DEBUG_REG26_RDC_RLAST_SHIFT)
#define MH_DEBUG_REG26_SET_TLBMISS_VALID(mh_debug_reg26_reg, tlbmiss_valid) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_TLBMISS_VALID_MASK) | (tlbmiss_valid << MH_DEBUG_REG26_TLBMISS_VALID_SHIFT)
#define MH_DEBUG_REG26_SET_BRC_VALID(mh_debug_reg26_reg, brc_valid) \
     mh_debug_reg26_reg = (mh_debug_reg26_reg & ~MH_DEBUG_REG26_BRC_VALID_MASK) | (brc_valid << MH_DEBUG_REG26_BRC_VALID_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg26_t {
          unsigned int mh_rbbm_busy                   : MH_DEBUG_REG26_MH_RBBM_busy_SIZE;
          unsigned int mh_cib_mh_clk_en_int           : MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_SIZE;
          unsigned int mh_cib_mmu_clk_en_int          : MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_SIZE;
          unsigned int mh_cib_tcroq_clk_en_int        : MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_SIZE;
          unsigned int gat_clk_ena                    : MH_DEBUG_REG26_GAT_CLK_ENA_SIZE;
          unsigned int rbbm_mh_clk_en_override        : MH_DEBUG_REG26_RBBM_MH_clk_en_override_SIZE;
          unsigned int cnt_q                          : MH_DEBUG_REG26_CNT_q_SIZE;
          unsigned int tcd_empty_q                    : MH_DEBUG_REG26_TCD_EMPTY_q_SIZE;
          unsigned int tc_roq_empty                   : MH_DEBUG_REG26_TC_ROQ_EMPTY_SIZE;
          unsigned int mh_busy_d                      : MH_DEBUG_REG26_MH_BUSY_d_SIZE;
          unsigned int any_clnt_busy                  : MH_DEBUG_REG26_ANY_CLNT_BUSY_SIZE;
          unsigned int mh_mmu_invalidate_invalidate_all : MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_SIZE;
          unsigned int mh_mmu_invalidate_invalidate_tc : MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_SIZE;
          unsigned int cp_send_q                      : MH_DEBUG_REG26_CP_SEND_q_SIZE;
          unsigned int cp_rtr_q                       : MH_DEBUG_REG26_CP_RTR_q_SIZE;
          unsigned int vgt_send_q                     : MH_DEBUG_REG26_VGT_SEND_q_SIZE;
          unsigned int vgt_rtr_q                      : MH_DEBUG_REG26_VGT_RTR_q_SIZE;
          unsigned int tc_roq_send_q                  : MH_DEBUG_REG26_TC_ROQ_SEND_q_SIZE;
          unsigned int tc_roq_rtr_dbg_q               : MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_SIZE;
          unsigned int rb_send_q                      : MH_DEBUG_REG26_RB_SEND_q_SIZE;
          unsigned int rb_rtr_q                       : MH_DEBUG_REG26_RB_RTR_q_SIZE;
          unsigned int pa_send_q                      : MH_DEBUG_REG26_PA_SEND_q_SIZE;
          unsigned int pa_rtr_q                       : MH_DEBUG_REG26_PA_RTR_q_SIZE;
          unsigned int rdc_valid                      : MH_DEBUG_REG26_RDC_VALID_SIZE;
          unsigned int rdc_rlast                      : MH_DEBUG_REG26_RDC_RLAST_SIZE;
          unsigned int tlbmiss_valid                  : MH_DEBUG_REG26_TLBMISS_VALID_SIZE;
          unsigned int brc_valid                      : MH_DEBUG_REG26_BRC_VALID_SIZE;
     } mh_debug_reg26_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg26_t {
          unsigned int brc_valid                      : MH_DEBUG_REG26_BRC_VALID_SIZE;
          unsigned int tlbmiss_valid                  : MH_DEBUG_REG26_TLBMISS_VALID_SIZE;
          unsigned int rdc_rlast                      : MH_DEBUG_REG26_RDC_RLAST_SIZE;
          unsigned int rdc_valid                      : MH_DEBUG_REG26_RDC_VALID_SIZE;
          unsigned int pa_rtr_q                       : MH_DEBUG_REG26_PA_RTR_q_SIZE;
          unsigned int pa_send_q                      : MH_DEBUG_REG26_PA_SEND_q_SIZE;
          unsigned int rb_rtr_q                       : MH_DEBUG_REG26_RB_RTR_q_SIZE;
          unsigned int rb_send_q                      : MH_DEBUG_REG26_RB_SEND_q_SIZE;
          unsigned int tc_roq_rtr_dbg_q               : MH_DEBUG_REG26_TC_ROQ_RTR_DBG_q_SIZE;
          unsigned int tc_roq_send_q                  : MH_DEBUG_REG26_TC_ROQ_SEND_q_SIZE;
          unsigned int vgt_rtr_q                      : MH_DEBUG_REG26_VGT_RTR_q_SIZE;
          unsigned int vgt_send_q                     : MH_DEBUG_REG26_VGT_SEND_q_SIZE;
          unsigned int cp_rtr_q                       : MH_DEBUG_REG26_CP_RTR_q_SIZE;
          unsigned int cp_send_q                      : MH_DEBUG_REG26_CP_SEND_q_SIZE;
          unsigned int mh_mmu_invalidate_invalidate_tc : MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_TC_SIZE;
          unsigned int mh_mmu_invalidate_invalidate_all : MH_DEBUG_REG26_MH_MMU_INVALIDATE_INVALIDATE_ALL_SIZE;
          unsigned int any_clnt_busy                  : MH_DEBUG_REG26_ANY_CLNT_BUSY_SIZE;
          unsigned int mh_busy_d                      : MH_DEBUG_REG26_MH_BUSY_d_SIZE;
          unsigned int tc_roq_empty                   : MH_DEBUG_REG26_TC_ROQ_EMPTY_SIZE;
          unsigned int tcd_empty_q                    : MH_DEBUG_REG26_TCD_EMPTY_q_SIZE;
          unsigned int cnt_q                          : MH_DEBUG_REG26_CNT_q_SIZE;
          unsigned int rbbm_mh_clk_en_override        : MH_DEBUG_REG26_RBBM_MH_clk_en_override_SIZE;
          unsigned int gat_clk_ena                    : MH_DEBUG_REG26_GAT_CLK_ENA_SIZE;
          unsigned int mh_cib_tcroq_clk_en_int        : MH_DEBUG_REG26_MH_CIB_tcroq_clk_en_int_SIZE;
          unsigned int mh_cib_mmu_clk_en_int          : MH_DEBUG_REG26_MH_CIB_mmu_clk_en_int_SIZE;
          unsigned int mh_cib_mh_clk_en_int           : MH_DEBUG_REG26_MH_CIB_mh_clk_en_int_SIZE;
          unsigned int mh_rbbm_busy                   : MH_DEBUG_REG26_MH_RBBM_busy_SIZE;
     } mh_debug_reg26_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg26_t f;
} mh_debug_reg26_u;


/*
 * MH_DEBUG_REG27 struct
 */

#define MH_DEBUG_REG27_EFF2_FP_WINNER_SIZE 3
#define MH_DEBUG_REG27_EFF2_LRU_WINNER_out_SIZE 3
#define MH_DEBUG_REG27_EFF1_WINNER_SIZE 3
#define MH_DEBUG_REG27_ARB_WINNER_SIZE 3
#define MH_DEBUG_REG27_ARB_WINNER_q_SIZE 3
#define MH_DEBUG_REG27_EFF1_WIN_SIZE   1
#define MH_DEBUG_REG27_KILL_EFF1_SIZE  1
#define MH_DEBUG_REG27_ARB_HOLD_SIZE   1
#define MH_DEBUG_REG27_ARB_RTR_q_SIZE  1
#define MH_DEBUG_REG27_CP_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG27_VGT_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG27_TC_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_SIZE 1
#define MH_DEBUG_REG27_RB_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG27_PA_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG27_ARB_QUAL_SIZE   1
#define MH_DEBUG_REG27_CP_EFF1_REQ_SIZE 1
#define MH_DEBUG_REG27_VGT_EFF1_REQ_SIZE 1
#define MH_DEBUG_REG27_TC_EFF1_REQ_SIZE 1
#define MH_DEBUG_REG27_RB_EFF1_REQ_SIZE 1
#define MH_DEBUG_REG27_TCD_NEARFULL_q_SIZE 1
#define MH_DEBUG_REG27_TCHOLD_IP_q_SIZE 1

#define MH_DEBUG_REG27_EFF2_FP_WINNER_SHIFT 0
#define MH_DEBUG_REG27_EFF2_LRU_WINNER_out_SHIFT 3
#define MH_DEBUG_REG27_EFF1_WINNER_SHIFT 6
#define MH_DEBUG_REG27_ARB_WINNER_SHIFT 9
#define MH_DEBUG_REG27_ARB_WINNER_q_SHIFT 12
#define MH_DEBUG_REG27_EFF1_WIN_SHIFT  15
#define MH_DEBUG_REG27_KILL_EFF1_SHIFT 16
#define MH_DEBUG_REG27_ARB_HOLD_SHIFT  17
#define MH_DEBUG_REG27_ARB_RTR_q_SHIFT 18
#define MH_DEBUG_REG27_CP_SEND_QUAL_SHIFT 19
#define MH_DEBUG_REG27_VGT_SEND_QUAL_SHIFT 20
#define MH_DEBUG_REG27_TC_SEND_QUAL_SHIFT 21
#define MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_SHIFT 22
#define MH_DEBUG_REG27_RB_SEND_QUAL_SHIFT 23
#define MH_DEBUG_REG27_PA_SEND_QUAL_SHIFT 24
#define MH_DEBUG_REG27_ARB_QUAL_SHIFT  25
#define MH_DEBUG_REG27_CP_EFF1_REQ_SHIFT 26
#define MH_DEBUG_REG27_VGT_EFF1_REQ_SHIFT 27
#define MH_DEBUG_REG27_TC_EFF1_REQ_SHIFT 28
#define MH_DEBUG_REG27_RB_EFF1_REQ_SHIFT 29
#define MH_DEBUG_REG27_TCD_NEARFULL_q_SHIFT 30
#define MH_DEBUG_REG27_TCHOLD_IP_q_SHIFT 31

#define MH_DEBUG_REG27_EFF2_FP_WINNER_MASK 0x00000007
#define MH_DEBUG_REG27_EFF2_LRU_WINNER_out_MASK 0x00000038
#define MH_DEBUG_REG27_EFF1_WINNER_MASK 0x000001c0
#define MH_DEBUG_REG27_ARB_WINNER_MASK 0x00000e00
#define MH_DEBUG_REG27_ARB_WINNER_q_MASK 0x00007000
#define MH_DEBUG_REG27_EFF1_WIN_MASK   0x00008000
#define MH_DEBUG_REG27_KILL_EFF1_MASK  0x00010000
#define MH_DEBUG_REG27_ARB_HOLD_MASK   0x00020000
#define MH_DEBUG_REG27_ARB_RTR_q_MASK  0x00040000
#define MH_DEBUG_REG27_CP_SEND_QUAL_MASK 0x00080000
#define MH_DEBUG_REG27_VGT_SEND_QUAL_MASK 0x00100000
#define MH_DEBUG_REG27_TC_SEND_QUAL_MASK 0x00200000
#define MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_MASK 0x00400000
#define MH_DEBUG_REG27_RB_SEND_QUAL_MASK 0x00800000
#define MH_DEBUG_REG27_PA_SEND_QUAL_MASK 0x01000000
#define MH_DEBUG_REG27_ARB_QUAL_MASK   0x02000000
#define MH_DEBUG_REG27_CP_EFF1_REQ_MASK 0x04000000
#define MH_DEBUG_REG27_VGT_EFF1_REQ_MASK 0x08000000
#define MH_DEBUG_REG27_TC_EFF1_REQ_MASK 0x10000000
#define MH_DEBUG_REG27_RB_EFF1_REQ_MASK 0x20000000
#define MH_DEBUG_REG27_TCD_NEARFULL_q_MASK 0x40000000
#define MH_DEBUG_REG27_TCHOLD_IP_q_MASK 0x80000000

#define MH_DEBUG_REG27_MASK \
     (MH_DEBUG_REG27_EFF2_FP_WINNER_MASK | \
      MH_DEBUG_REG27_EFF2_LRU_WINNER_out_MASK | \
      MH_DEBUG_REG27_EFF1_WINNER_MASK | \
      MH_DEBUG_REG27_ARB_WINNER_MASK | \
      MH_DEBUG_REG27_ARB_WINNER_q_MASK | \
      MH_DEBUG_REG27_EFF1_WIN_MASK | \
      MH_DEBUG_REG27_KILL_EFF1_MASK | \
      MH_DEBUG_REG27_ARB_HOLD_MASK | \
      MH_DEBUG_REG27_ARB_RTR_q_MASK | \
      MH_DEBUG_REG27_CP_SEND_QUAL_MASK | \
      MH_DEBUG_REG27_VGT_SEND_QUAL_MASK | \
      MH_DEBUG_REG27_TC_SEND_QUAL_MASK | \
      MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_MASK | \
      MH_DEBUG_REG27_RB_SEND_QUAL_MASK | \
      MH_DEBUG_REG27_PA_SEND_QUAL_MASK | \
      MH_DEBUG_REG27_ARB_QUAL_MASK | \
      MH_DEBUG_REG27_CP_EFF1_REQ_MASK | \
      MH_DEBUG_REG27_VGT_EFF1_REQ_MASK | \
      MH_DEBUG_REG27_TC_EFF1_REQ_MASK | \
      MH_DEBUG_REG27_RB_EFF1_REQ_MASK | \
      MH_DEBUG_REG27_TCD_NEARFULL_q_MASK | \
      MH_DEBUG_REG27_TCHOLD_IP_q_MASK)

#define MH_DEBUG_REG27(eff2_fp_winner, eff2_lru_winner_out, eff1_winner, arb_winner, arb_winner_q, eff1_win, kill_eff1, arb_hold, arb_rtr_q, cp_send_qual, vgt_send_qual, tc_send_qual, tc_send_eff1_qual, rb_send_qual, pa_send_qual, arb_qual, cp_eff1_req, vgt_eff1_req, tc_eff1_req, rb_eff1_req, tcd_nearfull_q, tchold_ip_q) \
     ((eff2_fp_winner << MH_DEBUG_REG27_EFF2_FP_WINNER_SHIFT) | \
      (eff2_lru_winner_out << MH_DEBUG_REG27_EFF2_LRU_WINNER_out_SHIFT) | \
      (eff1_winner << MH_DEBUG_REG27_EFF1_WINNER_SHIFT) | \
      (arb_winner << MH_DEBUG_REG27_ARB_WINNER_SHIFT) | \
      (arb_winner_q << MH_DEBUG_REG27_ARB_WINNER_q_SHIFT) | \
      (eff1_win << MH_DEBUG_REG27_EFF1_WIN_SHIFT) | \
      (kill_eff1 << MH_DEBUG_REG27_KILL_EFF1_SHIFT) | \
      (arb_hold << MH_DEBUG_REG27_ARB_HOLD_SHIFT) | \
      (arb_rtr_q << MH_DEBUG_REG27_ARB_RTR_q_SHIFT) | \
      (cp_send_qual << MH_DEBUG_REG27_CP_SEND_QUAL_SHIFT) | \
      (vgt_send_qual << MH_DEBUG_REG27_VGT_SEND_QUAL_SHIFT) | \
      (tc_send_qual << MH_DEBUG_REG27_TC_SEND_QUAL_SHIFT) | \
      (tc_send_eff1_qual << MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_SHIFT) | \
      (rb_send_qual << MH_DEBUG_REG27_RB_SEND_QUAL_SHIFT) | \
      (pa_send_qual << MH_DEBUG_REG27_PA_SEND_QUAL_SHIFT) | \
      (arb_qual << MH_DEBUG_REG27_ARB_QUAL_SHIFT) | \
      (cp_eff1_req << MH_DEBUG_REG27_CP_EFF1_REQ_SHIFT) | \
      (vgt_eff1_req << MH_DEBUG_REG27_VGT_EFF1_REQ_SHIFT) | \
      (tc_eff1_req << MH_DEBUG_REG27_TC_EFF1_REQ_SHIFT) | \
      (rb_eff1_req << MH_DEBUG_REG27_RB_EFF1_REQ_SHIFT) | \
      (tcd_nearfull_q << MH_DEBUG_REG27_TCD_NEARFULL_q_SHIFT) | \
      (tchold_ip_q << MH_DEBUG_REG27_TCHOLD_IP_q_SHIFT))

#define MH_DEBUG_REG27_GET_EFF2_FP_WINNER(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_EFF2_FP_WINNER_MASK) >> MH_DEBUG_REG27_EFF2_FP_WINNER_SHIFT)
#define MH_DEBUG_REG27_GET_EFF2_LRU_WINNER_out(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_EFF2_LRU_WINNER_out_MASK) >> MH_DEBUG_REG27_EFF2_LRU_WINNER_out_SHIFT)
#define MH_DEBUG_REG27_GET_EFF1_WINNER(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_EFF1_WINNER_MASK) >> MH_DEBUG_REG27_EFF1_WINNER_SHIFT)
#define MH_DEBUG_REG27_GET_ARB_WINNER(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_ARB_WINNER_MASK) >> MH_DEBUG_REG27_ARB_WINNER_SHIFT)
#define MH_DEBUG_REG27_GET_ARB_WINNER_q(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_ARB_WINNER_q_MASK) >> MH_DEBUG_REG27_ARB_WINNER_q_SHIFT)
#define MH_DEBUG_REG27_GET_EFF1_WIN(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_EFF1_WIN_MASK) >> MH_DEBUG_REG27_EFF1_WIN_SHIFT)
#define MH_DEBUG_REG27_GET_KILL_EFF1(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_KILL_EFF1_MASK) >> MH_DEBUG_REG27_KILL_EFF1_SHIFT)
#define MH_DEBUG_REG27_GET_ARB_HOLD(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_ARB_HOLD_MASK) >> MH_DEBUG_REG27_ARB_HOLD_SHIFT)
#define MH_DEBUG_REG27_GET_ARB_RTR_q(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_ARB_RTR_q_MASK) >> MH_DEBUG_REG27_ARB_RTR_q_SHIFT)
#define MH_DEBUG_REG27_GET_CP_SEND_QUAL(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_CP_SEND_QUAL_MASK) >> MH_DEBUG_REG27_CP_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG27_GET_VGT_SEND_QUAL(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_VGT_SEND_QUAL_MASK) >> MH_DEBUG_REG27_VGT_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG27_GET_TC_SEND_QUAL(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_TC_SEND_QUAL_MASK) >> MH_DEBUG_REG27_TC_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG27_GET_TC_SEND_EFF1_QUAL(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_MASK) >> MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_SHIFT)
#define MH_DEBUG_REG27_GET_RB_SEND_QUAL(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_RB_SEND_QUAL_MASK) >> MH_DEBUG_REG27_RB_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG27_GET_PA_SEND_QUAL(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_PA_SEND_QUAL_MASK) >> MH_DEBUG_REG27_PA_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG27_GET_ARB_QUAL(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_ARB_QUAL_MASK) >> MH_DEBUG_REG27_ARB_QUAL_SHIFT)
#define MH_DEBUG_REG27_GET_CP_EFF1_REQ(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_CP_EFF1_REQ_MASK) >> MH_DEBUG_REG27_CP_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG27_GET_VGT_EFF1_REQ(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_VGT_EFF1_REQ_MASK) >> MH_DEBUG_REG27_VGT_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG27_GET_TC_EFF1_REQ(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_TC_EFF1_REQ_MASK) >> MH_DEBUG_REG27_TC_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG27_GET_RB_EFF1_REQ(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_RB_EFF1_REQ_MASK) >> MH_DEBUG_REG27_RB_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG27_GET_TCD_NEARFULL_q(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_TCD_NEARFULL_q_MASK) >> MH_DEBUG_REG27_TCD_NEARFULL_q_SHIFT)
#define MH_DEBUG_REG27_GET_TCHOLD_IP_q(mh_debug_reg27) \
     ((mh_debug_reg27 & MH_DEBUG_REG27_TCHOLD_IP_q_MASK) >> MH_DEBUG_REG27_TCHOLD_IP_q_SHIFT)

#define MH_DEBUG_REG27_SET_EFF2_FP_WINNER(mh_debug_reg27_reg, eff2_fp_winner) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_EFF2_FP_WINNER_MASK) | (eff2_fp_winner << MH_DEBUG_REG27_EFF2_FP_WINNER_SHIFT)
#define MH_DEBUG_REG27_SET_EFF2_LRU_WINNER_out(mh_debug_reg27_reg, eff2_lru_winner_out) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_EFF2_LRU_WINNER_out_MASK) | (eff2_lru_winner_out << MH_DEBUG_REG27_EFF2_LRU_WINNER_out_SHIFT)
#define MH_DEBUG_REG27_SET_EFF1_WINNER(mh_debug_reg27_reg, eff1_winner) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_EFF1_WINNER_MASK) | (eff1_winner << MH_DEBUG_REG27_EFF1_WINNER_SHIFT)
#define MH_DEBUG_REG27_SET_ARB_WINNER(mh_debug_reg27_reg, arb_winner) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_ARB_WINNER_MASK) | (arb_winner << MH_DEBUG_REG27_ARB_WINNER_SHIFT)
#define MH_DEBUG_REG27_SET_ARB_WINNER_q(mh_debug_reg27_reg, arb_winner_q) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_ARB_WINNER_q_MASK) | (arb_winner_q << MH_DEBUG_REG27_ARB_WINNER_q_SHIFT)
#define MH_DEBUG_REG27_SET_EFF1_WIN(mh_debug_reg27_reg, eff1_win) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_EFF1_WIN_MASK) | (eff1_win << MH_DEBUG_REG27_EFF1_WIN_SHIFT)
#define MH_DEBUG_REG27_SET_KILL_EFF1(mh_debug_reg27_reg, kill_eff1) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_KILL_EFF1_MASK) | (kill_eff1 << MH_DEBUG_REG27_KILL_EFF1_SHIFT)
#define MH_DEBUG_REG27_SET_ARB_HOLD(mh_debug_reg27_reg, arb_hold) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_ARB_HOLD_MASK) | (arb_hold << MH_DEBUG_REG27_ARB_HOLD_SHIFT)
#define MH_DEBUG_REG27_SET_ARB_RTR_q(mh_debug_reg27_reg, arb_rtr_q) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_ARB_RTR_q_MASK) | (arb_rtr_q << MH_DEBUG_REG27_ARB_RTR_q_SHIFT)
#define MH_DEBUG_REG27_SET_CP_SEND_QUAL(mh_debug_reg27_reg, cp_send_qual) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_CP_SEND_QUAL_MASK) | (cp_send_qual << MH_DEBUG_REG27_CP_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG27_SET_VGT_SEND_QUAL(mh_debug_reg27_reg, vgt_send_qual) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_VGT_SEND_QUAL_MASK) | (vgt_send_qual << MH_DEBUG_REG27_VGT_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG27_SET_TC_SEND_QUAL(mh_debug_reg27_reg, tc_send_qual) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_TC_SEND_QUAL_MASK) | (tc_send_qual << MH_DEBUG_REG27_TC_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG27_SET_TC_SEND_EFF1_QUAL(mh_debug_reg27_reg, tc_send_eff1_qual) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_MASK) | (tc_send_eff1_qual << MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_SHIFT)
#define MH_DEBUG_REG27_SET_RB_SEND_QUAL(mh_debug_reg27_reg, rb_send_qual) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_RB_SEND_QUAL_MASK) | (rb_send_qual << MH_DEBUG_REG27_RB_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG27_SET_PA_SEND_QUAL(mh_debug_reg27_reg, pa_send_qual) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_PA_SEND_QUAL_MASK) | (pa_send_qual << MH_DEBUG_REG27_PA_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG27_SET_ARB_QUAL(mh_debug_reg27_reg, arb_qual) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_ARB_QUAL_MASK) | (arb_qual << MH_DEBUG_REG27_ARB_QUAL_SHIFT)
#define MH_DEBUG_REG27_SET_CP_EFF1_REQ(mh_debug_reg27_reg, cp_eff1_req) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_CP_EFF1_REQ_MASK) | (cp_eff1_req << MH_DEBUG_REG27_CP_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG27_SET_VGT_EFF1_REQ(mh_debug_reg27_reg, vgt_eff1_req) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_VGT_EFF1_REQ_MASK) | (vgt_eff1_req << MH_DEBUG_REG27_VGT_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG27_SET_TC_EFF1_REQ(mh_debug_reg27_reg, tc_eff1_req) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_TC_EFF1_REQ_MASK) | (tc_eff1_req << MH_DEBUG_REG27_TC_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG27_SET_RB_EFF1_REQ(mh_debug_reg27_reg, rb_eff1_req) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_RB_EFF1_REQ_MASK) | (rb_eff1_req << MH_DEBUG_REG27_RB_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG27_SET_TCD_NEARFULL_q(mh_debug_reg27_reg, tcd_nearfull_q) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_TCD_NEARFULL_q_MASK) | (tcd_nearfull_q << MH_DEBUG_REG27_TCD_NEARFULL_q_SHIFT)
#define MH_DEBUG_REG27_SET_TCHOLD_IP_q(mh_debug_reg27_reg, tchold_ip_q) \
     mh_debug_reg27_reg = (mh_debug_reg27_reg & ~MH_DEBUG_REG27_TCHOLD_IP_q_MASK) | (tchold_ip_q << MH_DEBUG_REG27_TCHOLD_IP_q_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg27_t {
          unsigned int eff2_fp_winner                 : MH_DEBUG_REG27_EFF2_FP_WINNER_SIZE;
          unsigned int eff2_lru_winner_out            : MH_DEBUG_REG27_EFF2_LRU_WINNER_out_SIZE;
          unsigned int eff1_winner                    : MH_DEBUG_REG27_EFF1_WINNER_SIZE;
          unsigned int arb_winner                     : MH_DEBUG_REG27_ARB_WINNER_SIZE;
          unsigned int arb_winner_q                   : MH_DEBUG_REG27_ARB_WINNER_q_SIZE;
          unsigned int eff1_win                       : MH_DEBUG_REG27_EFF1_WIN_SIZE;
          unsigned int kill_eff1                      : MH_DEBUG_REG27_KILL_EFF1_SIZE;
          unsigned int arb_hold                       : MH_DEBUG_REG27_ARB_HOLD_SIZE;
          unsigned int arb_rtr_q                      : MH_DEBUG_REG27_ARB_RTR_q_SIZE;
          unsigned int cp_send_qual                   : MH_DEBUG_REG27_CP_SEND_QUAL_SIZE;
          unsigned int vgt_send_qual                  : MH_DEBUG_REG27_VGT_SEND_QUAL_SIZE;
          unsigned int tc_send_qual                   : MH_DEBUG_REG27_TC_SEND_QUAL_SIZE;
          unsigned int tc_send_eff1_qual              : MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_SIZE;
          unsigned int rb_send_qual                   : MH_DEBUG_REG27_RB_SEND_QUAL_SIZE;
          unsigned int pa_send_qual                   : MH_DEBUG_REG27_PA_SEND_QUAL_SIZE;
          unsigned int arb_qual                       : MH_DEBUG_REG27_ARB_QUAL_SIZE;
          unsigned int cp_eff1_req                    : MH_DEBUG_REG27_CP_EFF1_REQ_SIZE;
          unsigned int vgt_eff1_req                   : MH_DEBUG_REG27_VGT_EFF1_REQ_SIZE;
          unsigned int tc_eff1_req                    : MH_DEBUG_REG27_TC_EFF1_REQ_SIZE;
          unsigned int rb_eff1_req                    : MH_DEBUG_REG27_RB_EFF1_REQ_SIZE;
          unsigned int tcd_nearfull_q                 : MH_DEBUG_REG27_TCD_NEARFULL_q_SIZE;
          unsigned int tchold_ip_q                    : MH_DEBUG_REG27_TCHOLD_IP_q_SIZE;
     } mh_debug_reg27_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg27_t {
          unsigned int tchold_ip_q                    : MH_DEBUG_REG27_TCHOLD_IP_q_SIZE;
          unsigned int tcd_nearfull_q                 : MH_DEBUG_REG27_TCD_NEARFULL_q_SIZE;
          unsigned int rb_eff1_req                    : MH_DEBUG_REG27_RB_EFF1_REQ_SIZE;
          unsigned int tc_eff1_req                    : MH_DEBUG_REG27_TC_EFF1_REQ_SIZE;
          unsigned int vgt_eff1_req                   : MH_DEBUG_REG27_VGT_EFF1_REQ_SIZE;
          unsigned int cp_eff1_req                    : MH_DEBUG_REG27_CP_EFF1_REQ_SIZE;
          unsigned int arb_qual                       : MH_DEBUG_REG27_ARB_QUAL_SIZE;
          unsigned int pa_send_qual                   : MH_DEBUG_REG27_PA_SEND_QUAL_SIZE;
          unsigned int rb_send_qual                   : MH_DEBUG_REG27_RB_SEND_QUAL_SIZE;
          unsigned int tc_send_eff1_qual              : MH_DEBUG_REG27_TC_SEND_EFF1_QUAL_SIZE;
          unsigned int tc_send_qual                   : MH_DEBUG_REG27_TC_SEND_QUAL_SIZE;
          unsigned int vgt_send_qual                  : MH_DEBUG_REG27_VGT_SEND_QUAL_SIZE;
          unsigned int cp_send_qual                   : MH_DEBUG_REG27_CP_SEND_QUAL_SIZE;
          unsigned int arb_rtr_q                      : MH_DEBUG_REG27_ARB_RTR_q_SIZE;
          unsigned int arb_hold                       : MH_DEBUG_REG27_ARB_HOLD_SIZE;
          unsigned int kill_eff1                      : MH_DEBUG_REG27_KILL_EFF1_SIZE;
          unsigned int eff1_win                       : MH_DEBUG_REG27_EFF1_WIN_SIZE;
          unsigned int arb_winner_q                   : MH_DEBUG_REG27_ARB_WINNER_q_SIZE;
          unsigned int arb_winner                     : MH_DEBUG_REG27_ARB_WINNER_SIZE;
          unsigned int eff1_winner                    : MH_DEBUG_REG27_EFF1_WINNER_SIZE;
          unsigned int eff2_lru_winner_out            : MH_DEBUG_REG27_EFF2_LRU_WINNER_out_SIZE;
          unsigned int eff2_fp_winner                 : MH_DEBUG_REG27_EFF2_FP_WINNER_SIZE;
     } mh_debug_reg27_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg27_t f;
} mh_debug_reg27_u;


/*
 * MH_DEBUG_REG28 struct
 */

#define MH_DEBUG_REG28_EFF1_WINNER_SIZE 3
#define MH_DEBUG_REG28_ARB_WINNER_SIZE 3
#define MH_DEBUG_REG28_CP_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG28_VGT_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG28_TC_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_SIZE 1
#define MH_DEBUG_REG28_RB_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG28_ARB_QUAL_SIZE   1
#define MH_DEBUG_REG28_CP_EFF1_REQ_SIZE 1
#define MH_DEBUG_REG28_VGT_EFF1_REQ_SIZE 1
#define MH_DEBUG_REG28_TC_EFF1_REQ_SIZE 1
#define MH_DEBUG_REG28_RB_EFF1_REQ_SIZE 1
#define MH_DEBUG_REG28_EFF1_WIN_SIZE   1
#define MH_DEBUG_REG28_KILL_EFF1_SIZE  1
#define MH_DEBUG_REG28_TCD_NEARFULL_q_SIZE 1
#define MH_DEBUG_REG28_TC_ARB_HOLD_SIZE 1
#define MH_DEBUG_REG28_ARB_HOLD_SIZE   1
#define MH_DEBUG_REG28_ARB_RTR_q_SIZE  1
#define MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_SIZE 10

#define MH_DEBUG_REG28_EFF1_WINNER_SHIFT 0
#define MH_DEBUG_REG28_ARB_WINNER_SHIFT 3
#define MH_DEBUG_REG28_CP_SEND_QUAL_SHIFT 6
#define MH_DEBUG_REG28_VGT_SEND_QUAL_SHIFT 7
#define MH_DEBUG_REG28_TC_SEND_QUAL_SHIFT 8
#define MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_SHIFT 9
#define MH_DEBUG_REG28_RB_SEND_QUAL_SHIFT 10
#define MH_DEBUG_REG28_ARB_QUAL_SHIFT  11
#define MH_DEBUG_REG28_CP_EFF1_REQ_SHIFT 12
#define MH_DEBUG_REG28_VGT_EFF1_REQ_SHIFT 13
#define MH_DEBUG_REG28_TC_EFF1_REQ_SHIFT 14
#define MH_DEBUG_REG28_RB_EFF1_REQ_SHIFT 15
#define MH_DEBUG_REG28_EFF1_WIN_SHIFT  16
#define MH_DEBUG_REG28_KILL_EFF1_SHIFT 17
#define MH_DEBUG_REG28_TCD_NEARFULL_q_SHIFT 18
#define MH_DEBUG_REG28_TC_ARB_HOLD_SHIFT 19
#define MH_DEBUG_REG28_ARB_HOLD_SHIFT  20
#define MH_DEBUG_REG28_ARB_RTR_q_SHIFT 21
#define MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_SHIFT 22

#define MH_DEBUG_REG28_EFF1_WINNER_MASK 0x00000007
#define MH_DEBUG_REG28_ARB_WINNER_MASK 0x00000038
#define MH_DEBUG_REG28_CP_SEND_QUAL_MASK 0x00000040
#define MH_DEBUG_REG28_VGT_SEND_QUAL_MASK 0x00000080
#define MH_DEBUG_REG28_TC_SEND_QUAL_MASK 0x00000100
#define MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_MASK 0x00000200
#define MH_DEBUG_REG28_RB_SEND_QUAL_MASK 0x00000400
#define MH_DEBUG_REG28_ARB_QUAL_MASK   0x00000800
#define MH_DEBUG_REG28_CP_EFF1_REQ_MASK 0x00001000
#define MH_DEBUG_REG28_VGT_EFF1_REQ_MASK 0x00002000
#define MH_DEBUG_REG28_TC_EFF1_REQ_MASK 0x00004000
#define MH_DEBUG_REG28_RB_EFF1_REQ_MASK 0x00008000
#define MH_DEBUG_REG28_EFF1_WIN_MASK   0x00010000
#define MH_DEBUG_REG28_KILL_EFF1_MASK  0x00020000
#define MH_DEBUG_REG28_TCD_NEARFULL_q_MASK 0x00040000
#define MH_DEBUG_REG28_TC_ARB_HOLD_MASK 0x00080000
#define MH_DEBUG_REG28_ARB_HOLD_MASK   0x00100000
#define MH_DEBUG_REG28_ARB_RTR_q_MASK  0x00200000
#define MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_MASK 0xffc00000

#define MH_DEBUG_REG28_MASK \
     (MH_DEBUG_REG28_EFF1_WINNER_MASK | \
      MH_DEBUG_REG28_ARB_WINNER_MASK | \
      MH_DEBUG_REG28_CP_SEND_QUAL_MASK | \
      MH_DEBUG_REG28_VGT_SEND_QUAL_MASK | \
      MH_DEBUG_REG28_TC_SEND_QUAL_MASK | \
      MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_MASK | \
      MH_DEBUG_REG28_RB_SEND_QUAL_MASK | \
      MH_DEBUG_REG28_ARB_QUAL_MASK | \
      MH_DEBUG_REG28_CP_EFF1_REQ_MASK | \
      MH_DEBUG_REG28_VGT_EFF1_REQ_MASK | \
      MH_DEBUG_REG28_TC_EFF1_REQ_MASK | \
      MH_DEBUG_REG28_RB_EFF1_REQ_MASK | \
      MH_DEBUG_REG28_EFF1_WIN_MASK | \
      MH_DEBUG_REG28_KILL_EFF1_MASK | \
      MH_DEBUG_REG28_TCD_NEARFULL_q_MASK | \
      MH_DEBUG_REG28_TC_ARB_HOLD_MASK | \
      MH_DEBUG_REG28_ARB_HOLD_MASK | \
      MH_DEBUG_REG28_ARB_RTR_q_MASK | \
      MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_MASK)

#define MH_DEBUG_REG28(eff1_winner, arb_winner, cp_send_qual, vgt_send_qual, tc_send_qual, tc_send_eff1_qual, rb_send_qual, arb_qual, cp_eff1_req, vgt_eff1_req, tc_eff1_req, rb_eff1_req, eff1_win, kill_eff1, tcd_nearfull_q, tc_arb_hold, arb_hold, arb_rtr_q, same_page_limit_count_q) \
     ((eff1_winner << MH_DEBUG_REG28_EFF1_WINNER_SHIFT) | \
      (arb_winner << MH_DEBUG_REG28_ARB_WINNER_SHIFT) | \
      (cp_send_qual << MH_DEBUG_REG28_CP_SEND_QUAL_SHIFT) | \
      (vgt_send_qual << MH_DEBUG_REG28_VGT_SEND_QUAL_SHIFT) | \
      (tc_send_qual << MH_DEBUG_REG28_TC_SEND_QUAL_SHIFT) | \
      (tc_send_eff1_qual << MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_SHIFT) | \
      (rb_send_qual << MH_DEBUG_REG28_RB_SEND_QUAL_SHIFT) | \
      (arb_qual << MH_DEBUG_REG28_ARB_QUAL_SHIFT) | \
      (cp_eff1_req << MH_DEBUG_REG28_CP_EFF1_REQ_SHIFT) | \
      (vgt_eff1_req << MH_DEBUG_REG28_VGT_EFF1_REQ_SHIFT) | \
      (tc_eff1_req << MH_DEBUG_REG28_TC_EFF1_REQ_SHIFT) | \
      (rb_eff1_req << MH_DEBUG_REG28_RB_EFF1_REQ_SHIFT) | \
      (eff1_win << MH_DEBUG_REG28_EFF1_WIN_SHIFT) | \
      (kill_eff1 << MH_DEBUG_REG28_KILL_EFF1_SHIFT) | \
      (tcd_nearfull_q << MH_DEBUG_REG28_TCD_NEARFULL_q_SHIFT) | \
      (tc_arb_hold << MH_DEBUG_REG28_TC_ARB_HOLD_SHIFT) | \
      (arb_hold << MH_DEBUG_REG28_ARB_HOLD_SHIFT) | \
      (arb_rtr_q << MH_DEBUG_REG28_ARB_RTR_q_SHIFT) | \
      (same_page_limit_count_q << MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_SHIFT))

#define MH_DEBUG_REG28_GET_EFF1_WINNER(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_EFF1_WINNER_MASK) >> MH_DEBUG_REG28_EFF1_WINNER_SHIFT)
#define MH_DEBUG_REG28_GET_ARB_WINNER(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_ARB_WINNER_MASK) >> MH_DEBUG_REG28_ARB_WINNER_SHIFT)
#define MH_DEBUG_REG28_GET_CP_SEND_QUAL(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_CP_SEND_QUAL_MASK) >> MH_DEBUG_REG28_CP_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG28_GET_VGT_SEND_QUAL(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_VGT_SEND_QUAL_MASK) >> MH_DEBUG_REG28_VGT_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG28_GET_TC_SEND_QUAL(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_TC_SEND_QUAL_MASK) >> MH_DEBUG_REG28_TC_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG28_GET_TC_SEND_EFF1_QUAL(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_MASK) >> MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_SHIFT)
#define MH_DEBUG_REG28_GET_RB_SEND_QUAL(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_RB_SEND_QUAL_MASK) >> MH_DEBUG_REG28_RB_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG28_GET_ARB_QUAL(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_ARB_QUAL_MASK) >> MH_DEBUG_REG28_ARB_QUAL_SHIFT)
#define MH_DEBUG_REG28_GET_CP_EFF1_REQ(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_CP_EFF1_REQ_MASK) >> MH_DEBUG_REG28_CP_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG28_GET_VGT_EFF1_REQ(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_VGT_EFF1_REQ_MASK) >> MH_DEBUG_REG28_VGT_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG28_GET_TC_EFF1_REQ(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_TC_EFF1_REQ_MASK) >> MH_DEBUG_REG28_TC_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG28_GET_RB_EFF1_REQ(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_RB_EFF1_REQ_MASK) >> MH_DEBUG_REG28_RB_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG28_GET_EFF1_WIN(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_EFF1_WIN_MASK) >> MH_DEBUG_REG28_EFF1_WIN_SHIFT)
#define MH_DEBUG_REG28_GET_KILL_EFF1(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_KILL_EFF1_MASK) >> MH_DEBUG_REG28_KILL_EFF1_SHIFT)
#define MH_DEBUG_REG28_GET_TCD_NEARFULL_q(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_TCD_NEARFULL_q_MASK) >> MH_DEBUG_REG28_TCD_NEARFULL_q_SHIFT)
#define MH_DEBUG_REG28_GET_TC_ARB_HOLD(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_TC_ARB_HOLD_MASK) >> MH_DEBUG_REG28_TC_ARB_HOLD_SHIFT)
#define MH_DEBUG_REG28_GET_ARB_HOLD(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_ARB_HOLD_MASK) >> MH_DEBUG_REG28_ARB_HOLD_SHIFT)
#define MH_DEBUG_REG28_GET_ARB_RTR_q(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_ARB_RTR_q_MASK) >> MH_DEBUG_REG28_ARB_RTR_q_SHIFT)
#define MH_DEBUG_REG28_GET_SAME_PAGE_LIMIT_COUNT_q(mh_debug_reg28) \
     ((mh_debug_reg28 & MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_MASK) >> MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_SHIFT)

#define MH_DEBUG_REG28_SET_EFF1_WINNER(mh_debug_reg28_reg, eff1_winner) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_EFF1_WINNER_MASK) | (eff1_winner << MH_DEBUG_REG28_EFF1_WINNER_SHIFT)
#define MH_DEBUG_REG28_SET_ARB_WINNER(mh_debug_reg28_reg, arb_winner) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_ARB_WINNER_MASK) | (arb_winner << MH_DEBUG_REG28_ARB_WINNER_SHIFT)
#define MH_DEBUG_REG28_SET_CP_SEND_QUAL(mh_debug_reg28_reg, cp_send_qual) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_CP_SEND_QUAL_MASK) | (cp_send_qual << MH_DEBUG_REG28_CP_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG28_SET_VGT_SEND_QUAL(mh_debug_reg28_reg, vgt_send_qual) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_VGT_SEND_QUAL_MASK) | (vgt_send_qual << MH_DEBUG_REG28_VGT_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG28_SET_TC_SEND_QUAL(mh_debug_reg28_reg, tc_send_qual) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_TC_SEND_QUAL_MASK) | (tc_send_qual << MH_DEBUG_REG28_TC_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG28_SET_TC_SEND_EFF1_QUAL(mh_debug_reg28_reg, tc_send_eff1_qual) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_MASK) | (tc_send_eff1_qual << MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_SHIFT)
#define MH_DEBUG_REG28_SET_RB_SEND_QUAL(mh_debug_reg28_reg, rb_send_qual) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_RB_SEND_QUAL_MASK) | (rb_send_qual << MH_DEBUG_REG28_RB_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG28_SET_ARB_QUAL(mh_debug_reg28_reg, arb_qual) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_ARB_QUAL_MASK) | (arb_qual << MH_DEBUG_REG28_ARB_QUAL_SHIFT)
#define MH_DEBUG_REG28_SET_CP_EFF1_REQ(mh_debug_reg28_reg, cp_eff1_req) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_CP_EFF1_REQ_MASK) | (cp_eff1_req << MH_DEBUG_REG28_CP_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG28_SET_VGT_EFF1_REQ(mh_debug_reg28_reg, vgt_eff1_req) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_VGT_EFF1_REQ_MASK) | (vgt_eff1_req << MH_DEBUG_REG28_VGT_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG28_SET_TC_EFF1_REQ(mh_debug_reg28_reg, tc_eff1_req) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_TC_EFF1_REQ_MASK) | (tc_eff1_req << MH_DEBUG_REG28_TC_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG28_SET_RB_EFF1_REQ(mh_debug_reg28_reg, rb_eff1_req) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_RB_EFF1_REQ_MASK) | (rb_eff1_req << MH_DEBUG_REG28_RB_EFF1_REQ_SHIFT)
#define MH_DEBUG_REG28_SET_EFF1_WIN(mh_debug_reg28_reg, eff1_win) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_EFF1_WIN_MASK) | (eff1_win << MH_DEBUG_REG28_EFF1_WIN_SHIFT)
#define MH_DEBUG_REG28_SET_KILL_EFF1(mh_debug_reg28_reg, kill_eff1) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_KILL_EFF1_MASK) | (kill_eff1 << MH_DEBUG_REG28_KILL_EFF1_SHIFT)
#define MH_DEBUG_REG28_SET_TCD_NEARFULL_q(mh_debug_reg28_reg, tcd_nearfull_q) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_TCD_NEARFULL_q_MASK) | (tcd_nearfull_q << MH_DEBUG_REG28_TCD_NEARFULL_q_SHIFT)
#define MH_DEBUG_REG28_SET_TC_ARB_HOLD(mh_debug_reg28_reg, tc_arb_hold) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_TC_ARB_HOLD_MASK) | (tc_arb_hold << MH_DEBUG_REG28_TC_ARB_HOLD_SHIFT)
#define MH_DEBUG_REG28_SET_ARB_HOLD(mh_debug_reg28_reg, arb_hold) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_ARB_HOLD_MASK) | (arb_hold << MH_DEBUG_REG28_ARB_HOLD_SHIFT)
#define MH_DEBUG_REG28_SET_ARB_RTR_q(mh_debug_reg28_reg, arb_rtr_q) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_ARB_RTR_q_MASK) | (arb_rtr_q << MH_DEBUG_REG28_ARB_RTR_q_SHIFT)
#define MH_DEBUG_REG28_SET_SAME_PAGE_LIMIT_COUNT_q(mh_debug_reg28_reg, same_page_limit_count_q) \
     mh_debug_reg28_reg = (mh_debug_reg28_reg & ~MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_MASK) | (same_page_limit_count_q << MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg28_t {
          unsigned int eff1_winner                    : MH_DEBUG_REG28_EFF1_WINNER_SIZE;
          unsigned int arb_winner                     : MH_DEBUG_REG28_ARB_WINNER_SIZE;
          unsigned int cp_send_qual                   : MH_DEBUG_REG28_CP_SEND_QUAL_SIZE;
          unsigned int vgt_send_qual                  : MH_DEBUG_REG28_VGT_SEND_QUAL_SIZE;
          unsigned int tc_send_qual                   : MH_DEBUG_REG28_TC_SEND_QUAL_SIZE;
          unsigned int tc_send_eff1_qual              : MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_SIZE;
          unsigned int rb_send_qual                   : MH_DEBUG_REG28_RB_SEND_QUAL_SIZE;
          unsigned int arb_qual                       : MH_DEBUG_REG28_ARB_QUAL_SIZE;
          unsigned int cp_eff1_req                    : MH_DEBUG_REG28_CP_EFF1_REQ_SIZE;
          unsigned int vgt_eff1_req                   : MH_DEBUG_REG28_VGT_EFF1_REQ_SIZE;
          unsigned int tc_eff1_req                    : MH_DEBUG_REG28_TC_EFF1_REQ_SIZE;
          unsigned int rb_eff1_req                    : MH_DEBUG_REG28_RB_EFF1_REQ_SIZE;
          unsigned int eff1_win                       : MH_DEBUG_REG28_EFF1_WIN_SIZE;
          unsigned int kill_eff1                      : MH_DEBUG_REG28_KILL_EFF1_SIZE;
          unsigned int tcd_nearfull_q                 : MH_DEBUG_REG28_TCD_NEARFULL_q_SIZE;
          unsigned int tc_arb_hold                    : MH_DEBUG_REG28_TC_ARB_HOLD_SIZE;
          unsigned int arb_hold                       : MH_DEBUG_REG28_ARB_HOLD_SIZE;
          unsigned int arb_rtr_q                      : MH_DEBUG_REG28_ARB_RTR_q_SIZE;
          unsigned int same_page_limit_count_q        : MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_SIZE;
     } mh_debug_reg28_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg28_t {
          unsigned int same_page_limit_count_q        : MH_DEBUG_REG28_SAME_PAGE_LIMIT_COUNT_q_SIZE;
          unsigned int arb_rtr_q                      : MH_DEBUG_REG28_ARB_RTR_q_SIZE;
          unsigned int arb_hold                       : MH_DEBUG_REG28_ARB_HOLD_SIZE;
          unsigned int tc_arb_hold                    : MH_DEBUG_REG28_TC_ARB_HOLD_SIZE;
          unsigned int tcd_nearfull_q                 : MH_DEBUG_REG28_TCD_NEARFULL_q_SIZE;
          unsigned int kill_eff1                      : MH_DEBUG_REG28_KILL_EFF1_SIZE;
          unsigned int eff1_win                       : MH_DEBUG_REG28_EFF1_WIN_SIZE;
          unsigned int rb_eff1_req                    : MH_DEBUG_REG28_RB_EFF1_REQ_SIZE;
          unsigned int tc_eff1_req                    : MH_DEBUG_REG28_TC_EFF1_REQ_SIZE;
          unsigned int vgt_eff1_req                   : MH_DEBUG_REG28_VGT_EFF1_REQ_SIZE;
          unsigned int cp_eff1_req                    : MH_DEBUG_REG28_CP_EFF1_REQ_SIZE;
          unsigned int arb_qual                       : MH_DEBUG_REG28_ARB_QUAL_SIZE;
          unsigned int rb_send_qual                   : MH_DEBUG_REG28_RB_SEND_QUAL_SIZE;
          unsigned int tc_send_eff1_qual              : MH_DEBUG_REG28_TC_SEND_EFF1_QUAL_SIZE;
          unsigned int tc_send_qual                   : MH_DEBUG_REG28_TC_SEND_QUAL_SIZE;
          unsigned int vgt_send_qual                  : MH_DEBUG_REG28_VGT_SEND_QUAL_SIZE;
          unsigned int cp_send_qual                   : MH_DEBUG_REG28_CP_SEND_QUAL_SIZE;
          unsigned int arb_winner                     : MH_DEBUG_REG28_ARB_WINNER_SIZE;
          unsigned int eff1_winner                    : MH_DEBUG_REG28_EFF1_WINNER_SIZE;
     } mh_debug_reg28_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg28_t f;
} mh_debug_reg28_u;


/*
 * MH_DEBUG_REG29 struct
 */

#define MH_DEBUG_REG29_EFF2_LRU_WINNER_out_SIZE 3
#define MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_SIZE 3
#define MH_DEBUG_REG29_LEAST_RECENT_d_SIZE 3
#define MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_SIZE 1
#define MH_DEBUG_REG29_ARB_HOLD_SIZE   1
#define MH_DEBUG_REG29_ARB_RTR_q_SIZE  1
#define MH_DEBUG_REG29_CLNT_REQ_SIZE   5
#define MH_DEBUG_REG29_RECENT_d_0_SIZE 3
#define MH_DEBUG_REG29_RECENT_d_1_SIZE 3
#define MH_DEBUG_REG29_RECENT_d_2_SIZE 3
#define MH_DEBUG_REG29_RECENT_d_3_SIZE 3
#define MH_DEBUG_REG29_RECENT_d_4_SIZE 3

#define MH_DEBUG_REG29_EFF2_LRU_WINNER_out_SHIFT 0
#define MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_SHIFT 3
#define MH_DEBUG_REG29_LEAST_RECENT_d_SHIFT 6
#define MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_SHIFT 9
#define MH_DEBUG_REG29_ARB_HOLD_SHIFT  10
#define MH_DEBUG_REG29_ARB_RTR_q_SHIFT 11
#define MH_DEBUG_REG29_CLNT_REQ_SHIFT  12
#define MH_DEBUG_REG29_RECENT_d_0_SHIFT 17
#define MH_DEBUG_REG29_RECENT_d_1_SHIFT 20
#define MH_DEBUG_REG29_RECENT_d_2_SHIFT 23
#define MH_DEBUG_REG29_RECENT_d_3_SHIFT 26
#define MH_DEBUG_REG29_RECENT_d_4_SHIFT 29

#define MH_DEBUG_REG29_EFF2_LRU_WINNER_out_MASK 0x00000007
#define MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_MASK 0x00000038
#define MH_DEBUG_REG29_LEAST_RECENT_d_MASK 0x000001c0
#define MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_MASK 0x00000200
#define MH_DEBUG_REG29_ARB_HOLD_MASK   0x00000400
#define MH_DEBUG_REG29_ARB_RTR_q_MASK  0x00000800
#define MH_DEBUG_REG29_CLNT_REQ_MASK   0x0001f000
#define MH_DEBUG_REG29_RECENT_d_0_MASK 0x000e0000
#define MH_DEBUG_REG29_RECENT_d_1_MASK 0x00700000
#define MH_DEBUG_REG29_RECENT_d_2_MASK 0x03800000
#define MH_DEBUG_REG29_RECENT_d_3_MASK 0x1c000000
#define MH_DEBUG_REG29_RECENT_d_4_MASK 0xe0000000

#define MH_DEBUG_REG29_MASK \
     (MH_DEBUG_REG29_EFF2_LRU_WINNER_out_MASK | \
      MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_MASK | \
      MH_DEBUG_REG29_LEAST_RECENT_d_MASK | \
      MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_MASK | \
      MH_DEBUG_REG29_ARB_HOLD_MASK | \
      MH_DEBUG_REG29_ARB_RTR_q_MASK | \
      MH_DEBUG_REG29_CLNT_REQ_MASK | \
      MH_DEBUG_REG29_RECENT_d_0_MASK | \
      MH_DEBUG_REG29_RECENT_d_1_MASK | \
      MH_DEBUG_REG29_RECENT_d_2_MASK | \
      MH_DEBUG_REG29_RECENT_d_3_MASK | \
      MH_DEBUG_REG29_RECENT_d_4_MASK)

#define MH_DEBUG_REG29(eff2_lru_winner_out, least_recent_index_d, least_recent_d, update_recent_stack_d, arb_hold, arb_rtr_q, clnt_req, recent_d_0, recent_d_1, recent_d_2, recent_d_3, recent_d_4) \
     ((eff2_lru_winner_out << MH_DEBUG_REG29_EFF2_LRU_WINNER_out_SHIFT) | \
      (least_recent_index_d << MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_SHIFT) | \
      (least_recent_d << MH_DEBUG_REG29_LEAST_RECENT_d_SHIFT) | \
      (update_recent_stack_d << MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_SHIFT) | \
      (arb_hold << MH_DEBUG_REG29_ARB_HOLD_SHIFT) | \
      (arb_rtr_q << MH_DEBUG_REG29_ARB_RTR_q_SHIFT) | \
      (clnt_req << MH_DEBUG_REG29_CLNT_REQ_SHIFT) | \
      (recent_d_0 << MH_DEBUG_REG29_RECENT_d_0_SHIFT) | \
      (recent_d_1 << MH_DEBUG_REG29_RECENT_d_1_SHIFT) | \
      (recent_d_2 << MH_DEBUG_REG29_RECENT_d_2_SHIFT) | \
      (recent_d_3 << MH_DEBUG_REG29_RECENT_d_3_SHIFT) | \
      (recent_d_4 << MH_DEBUG_REG29_RECENT_d_4_SHIFT))

#define MH_DEBUG_REG29_GET_EFF2_LRU_WINNER_out(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_EFF2_LRU_WINNER_out_MASK) >> MH_DEBUG_REG29_EFF2_LRU_WINNER_out_SHIFT)
#define MH_DEBUG_REG29_GET_LEAST_RECENT_INDEX_d(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_MASK) >> MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_SHIFT)
#define MH_DEBUG_REG29_GET_LEAST_RECENT_d(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_LEAST_RECENT_d_MASK) >> MH_DEBUG_REG29_LEAST_RECENT_d_SHIFT)
#define MH_DEBUG_REG29_GET_UPDATE_RECENT_STACK_d(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_MASK) >> MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_SHIFT)
#define MH_DEBUG_REG29_GET_ARB_HOLD(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_ARB_HOLD_MASK) >> MH_DEBUG_REG29_ARB_HOLD_SHIFT)
#define MH_DEBUG_REG29_GET_ARB_RTR_q(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_ARB_RTR_q_MASK) >> MH_DEBUG_REG29_ARB_RTR_q_SHIFT)
#define MH_DEBUG_REG29_GET_CLNT_REQ(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_CLNT_REQ_MASK) >> MH_DEBUG_REG29_CLNT_REQ_SHIFT)
#define MH_DEBUG_REG29_GET_RECENT_d_0(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_RECENT_d_0_MASK) >> MH_DEBUG_REG29_RECENT_d_0_SHIFT)
#define MH_DEBUG_REG29_GET_RECENT_d_1(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_RECENT_d_1_MASK) >> MH_DEBUG_REG29_RECENT_d_1_SHIFT)
#define MH_DEBUG_REG29_GET_RECENT_d_2(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_RECENT_d_2_MASK) >> MH_DEBUG_REG29_RECENT_d_2_SHIFT)
#define MH_DEBUG_REG29_GET_RECENT_d_3(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_RECENT_d_3_MASK) >> MH_DEBUG_REG29_RECENT_d_3_SHIFT)
#define MH_DEBUG_REG29_GET_RECENT_d_4(mh_debug_reg29) \
     ((mh_debug_reg29 & MH_DEBUG_REG29_RECENT_d_4_MASK) >> MH_DEBUG_REG29_RECENT_d_4_SHIFT)

#define MH_DEBUG_REG29_SET_EFF2_LRU_WINNER_out(mh_debug_reg29_reg, eff2_lru_winner_out) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_EFF2_LRU_WINNER_out_MASK) | (eff2_lru_winner_out << MH_DEBUG_REG29_EFF2_LRU_WINNER_out_SHIFT)
#define MH_DEBUG_REG29_SET_LEAST_RECENT_INDEX_d(mh_debug_reg29_reg, least_recent_index_d) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_MASK) | (least_recent_index_d << MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_SHIFT)
#define MH_DEBUG_REG29_SET_LEAST_RECENT_d(mh_debug_reg29_reg, least_recent_d) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_LEAST_RECENT_d_MASK) | (least_recent_d << MH_DEBUG_REG29_LEAST_RECENT_d_SHIFT)
#define MH_DEBUG_REG29_SET_UPDATE_RECENT_STACK_d(mh_debug_reg29_reg, update_recent_stack_d) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_MASK) | (update_recent_stack_d << MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_SHIFT)
#define MH_DEBUG_REG29_SET_ARB_HOLD(mh_debug_reg29_reg, arb_hold) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_ARB_HOLD_MASK) | (arb_hold << MH_DEBUG_REG29_ARB_HOLD_SHIFT)
#define MH_DEBUG_REG29_SET_ARB_RTR_q(mh_debug_reg29_reg, arb_rtr_q) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_ARB_RTR_q_MASK) | (arb_rtr_q << MH_DEBUG_REG29_ARB_RTR_q_SHIFT)
#define MH_DEBUG_REG29_SET_CLNT_REQ(mh_debug_reg29_reg, clnt_req) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_CLNT_REQ_MASK) | (clnt_req << MH_DEBUG_REG29_CLNT_REQ_SHIFT)
#define MH_DEBUG_REG29_SET_RECENT_d_0(mh_debug_reg29_reg, recent_d_0) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_RECENT_d_0_MASK) | (recent_d_0 << MH_DEBUG_REG29_RECENT_d_0_SHIFT)
#define MH_DEBUG_REG29_SET_RECENT_d_1(mh_debug_reg29_reg, recent_d_1) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_RECENT_d_1_MASK) | (recent_d_1 << MH_DEBUG_REG29_RECENT_d_1_SHIFT)
#define MH_DEBUG_REG29_SET_RECENT_d_2(mh_debug_reg29_reg, recent_d_2) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_RECENT_d_2_MASK) | (recent_d_2 << MH_DEBUG_REG29_RECENT_d_2_SHIFT)
#define MH_DEBUG_REG29_SET_RECENT_d_3(mh_debug_reg29_reg, recent_d_3) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_RECENT_d_3_MASK) | (recent_d_3 << MH_DEBUG_REG29_RECENT_d_3_SHIFT)
#define MH_DEBUG_REG29_SET_RECENT_d_4(mh_debug_reg29_reg, recent_d_4) \
     mh_debug_reg29_reg = (mh_debug_reg29_reg & ~MH_DEBUG_REG29_RECENT_d_4_MASK) | (recent_d_4 << MH_DEBUG_REG29_RECENT_d_4_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg29_t {
          unsigned int eff2_lru_winner_out            : MH_DEBUG_REG29_EFF2_LRU_WINNER_out_SIZE;
          unsigned int least_recent_index_d           : MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_SIZE;
          unsigned int least_recent_d                 : MH_DEBUG_REG29_LEAST_RECENT_d_SIZE;
          unsigned int update_recent_stack_d          : MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_SIZE;
          unsigned int arb_hold                       : MH_DEBUG_REG29_ARB_HOLD_SIZE;
          unsigned int arb_rtr_q                      : MH_DEBUG_REG29_ARB_RTR_q_SIZE;
          unsigned int clnt_req                       : MH_DEBUG_REG29_CLNT_REQ_SIZE;
          unsigned int recent_d_0                     : MH_DEBUG_REG29_RECENT_d_0_SIZE;
          unsigned int recent_d_1                     : MH_DEBUG_REG29_RECENT_d_1_SIZE;
          unsigned int recent_d_2                     : MH_DEBUG_REG29_RECENT_d_2_SIZE;
          unsigned int recent_d_3                     : MH_DEBUG_REG29_RECENT_d_3_SIZE;
          unsigned int recent_d_4                     : MH_DEBUG_REG29_RECENT_d_4_SIZE;
     } mh_debug_reg29_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg29_t {
          unsigned int recent_d_4                     : MH_DEBUG_REG29_RECENT_d_4_SIZE;
          unsigned int recent_d_3                     : MH_DEBUG_REG29_RECENT_d_3_SIZE;
          unsigned int recent_d_2                     : MH_DEBUG_REG29_RECENT_d_2_SIZE;
          unsigned int recent_d_1                     : MH_DEBUG_REG29_RECENT_d_1_SIZE;
          unsigned int recent_d_0                     : MH_DEBUG_REG29_RECENT_d_0_SIZE;
          unsigned int clnt_req                       : MH_DEBUG_REG29_CLNT_REQ_SIZE;
          unsigned int arb_rtr_q                      : MH_DEBUG_REG29_ARB_RTR_q_SIZE;
          unsigned int arb_hold                       : MH_DEBUG_REG29_ARB_HOLD_SIZE;
          unsigned int update_recent_stack_d          : MH_DEBUG_REG29_UPDATE_RECENT_STACK_d_SIZE;
          unsigned int least_recent_d                 : MH_DEBUG_REG29_LEAST_RECENT_d_SIZE;
          unsigned int least_recent_index_d           : MH_DEBUG_REG29_LEAST_RECENT_INDEX_d_SIZE;
          unsigned int eff2_lru_winner_out            : MH_DEBUG_REG29_EFF2_LRU_WINNER_out_SIZE;
     } mh_debug_reg29_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg29_t f;
} mh_debug_reg29_u;


/*
 * MH_DEBUG_REG30 struct
 */

#define MH_DEBUG_REG30_TC_ARB_HOLD_SIZE 1
#define MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_SIZE 1
#define MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_SIZE 1
#define MH_DEBUG_REG30_TCD_NEARFULL_q_SIZE 1
#define MH_DEBUG_REG30_TCHOLD_IP_q_SIZE 1
#define MH_DEBUG_REG30_TCHOLD_CNT_q_SIZE 3
#define MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SIZE 1
#define MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_SIZE 1
#define MH_DEBUG_REG30_TC_ROQ_SEND_q_SIZE 1
#define MH_DEBUG_REG30_TC_MH_written_SIZE 1
#define MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_SIZE 7
#define MH_DEBUG_REG30_WBURST_ACTIVE_SIZE 1
#define MH_DEBUG_REG30_WLAST_q_SIZE    1
#define MH_DEBUG_REG30_WBURST_IP_q_SIZE 1
#define MH_DEBUG_REG30_WBURST_CNT_q_SIZE 3
#define MH_DEBUG_REG30_CP_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG30_CP_MH_write_SIZE 1
#define MH_DEBUG_REG30_RB_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG30_PA_SEND_QUAL_SIZE 1
#define MH_DEBUG_REG30_ARB_WINNER_SIZE 3

#define MH_DEBUG_REG30_TC_ARB_HOLD_SHIFT 0
#define MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_SHIFT 1
#define MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_SHIFT 2
#define MH_DEBUG_REG30_TCD_NEARFULL_q_SHIFT 3
#define MH_DEBUG_REG30_TCHOLD_IP_q_SHIFT 4
#define MH_DEBUG_REG30_TCHOLD_CNT_q_SHIFT 5
#define MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SHIFT 8
#define MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_SHIFT 9
#define MH_DEBUG_REG30_TC_ROQ_SEND_q_SHIFT 10
#define MH_DEBUG_REG30_TC_MH_written_SHIFT 11
#define MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_SHIFT 12
#define MH_DEBUG_REG30_WBURST_ACTIVE_SHIFT 19
#define MH_DEBUG_REG30_WLAST_q_SHIFT   20
#define MH_DEBUG_REG30_WBURST_IP_q_SHIFT 21
#define MH_DEBUG_REG30_WBURST_CNT_q_SHIFT 22
#define MH_DEBUG_REG30_CP_SEND_QUAL_SHIFT 25
#define MH_DEBUG_REG30_CP_MH_write_SHIFT 26
#define MH_DEBUG_REG30_RB_SEND_QUAL_SHIFT 27
#define MH_DEBUG_REG30_PA_SEND_QUAL_SHIFT 28
#define MH_DEBUG_REG30_ARB_WINNER_SHIFT 29

#define MH_DEBUG_REG30_TC_ARB_HOLD_MASK 0x00000001
#define MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_MASK 0x00000002
#define MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_MASK 0x00000004
#define MH_DEBUG_REG30_TCD_NEARFULL_q_MASK 0x00000008
#define MH_DEBUG_REG30_TCHOLD_IP_q_MASK 0x00000010
#define MH_DEBUG_REG30_TCHOLD_CNT_q_MASK 0x000000e0
#define MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_MASK 0x00000100
#define MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_MASK 0x00000200
#define MH_DEBUG_REG30_TC_ROQ_SEND_q_MASK 0x00000400
#define MH_DEBUG_REG30_TC_MH_written_MASK 0x00000800
#define MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_MASK 0x0007f000
#define MH_DEBUG_REG30_WBURST_ACTIVE_MASK 0x00080000
#define MH_DEBUG_REG30_WLAST_q_MASK    0x00100000
#define MH_DEBUG_REG30_WBURST_IP_q_MASK 0x00200000
#define MH_DEBUG_REG30_WBURST_CNT_q_MASK 0x01c00000
#define MH_DEBUG_REG30_CP_SEND_QUAL_MASK 0x02000000
#define MH_DEBUG_REG30_CP_MH_write_MASK 0x04000000
#define MH_DEBUG_REG30_RB_SEND_QUAL_MASK 0x08000000
#define MH_DEBUG_REG30_PA_SEND_QUAL_MASK 0x10000000
#define MH_DEBUG_REG30_ARB_WINNER_MASK 0xe0000000

#define MH_DEBUG_REG30_MASK \
     (MH_DEBUG_REG30_TC_ARB_HOLD_MASK | \
      MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_MASK | \
      MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_MASK | \
      MH_DEBUG_REG30_TCD_NEARFULL_q_MASK | \
      MH_DEBUG_REG30_TCHOLD_IP_q_MASK | \
      MH_DEBUG_REG30_TCHOLD_CNT_q_MASK | \
      MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_MASK | \
      MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_MASK | \
      MH_DEBUG_REG30_TC_ROQ_SEND_q_MASK | \
      MH_DEBUG_REG30_TC_MH_written_MASK | \
      MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_MASK | \
      MH_DEBUG_REG30_WBURST_ACTIVE_MASK | \
      MH_DEBUG_REG30_WLAST_q_MASK | \
      MH_DEBUG_REG30_WBURST_IP_q_MASK | \
      MH_DEBUG_REG30_WBURST_CNT_q_MASK | \
      MH_DEBUG_REG30_CP_SEND_QUAL_MASK | \
      MH_DEBUG_REG30_CP_MH_write_MASK | \
      MH_DEBUG_REG30_RB_SEND_QUAL_MASK | \
      MH_DEBUG_REG30_PA_SEND_QUAL_MASK | \
      MH_DEBUG_REG30_ARB_WINNER_MASK)

#define MH_DEBUG_REG30(tc_arb_hold, tc_noroq_same_row_bank, tc_roq_same_row_bank, tcd_nearfull_q, tchold_ip_q, tchold_cnt_q, mh_arbiter_config_tc_reorder_enable, tc_roq_rtr_dbg_q, tc_roq_send_q, tc_mh_written, tcd_fullness_cnt_q, wburst_active, wlast_q, wburst_ip_q, wburst_cnt_q, cp_send_qual, cp_mh_write, rb_send_qual, pa_send_qual, arb_winner) \
     ((tc_arb_hold << MH_DEBUG_REG30_TC_ARB_HOLD_SHIFT) | \
      (tc_noroq_same_row_bank << MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_SHIFT) | \
      (tc_roq_same_row_bank << MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_SHIFT) | \
      (tcd_nearfull_q << MH_DEBUG_REG30_TCD_NEARFULL_q_SHIFT) | \
      (tchold_ip_q << MH_DEBUG_REG30_TCHOLD_IP_q_SHIFT) | \
      (tchold_cnt_q << MH_DEBUG_REG30_TCHOLD_CNT_q_SHIFT) | \
      (mh_arbiter_config_tc_reorder_enable << MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SHIFT) | \
      (tc_roq_rtr_dbg_q << MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_SHIFT) | \
      (tc_roq_send_q << MH_DEBUG_REG30_TC_ROQ_SEND_q_SHIFT) | \
      (tc_mh_written << MH_DEBUG_REG30_TC_MH_written_SHIFT) | \
      (tcd_fullness_cnt_q << MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_SHIFT) | \
      (wburst_active << MH_DEBUG_REG30_WBURST_ACTIVE_SHIFT) | \
      (wlast_q << MH_DEBUG_REG30_WLAST_q_SHIFT) | \
      (wburst_ip_q << MH_DEBUG_REG30_WBURST_IP_q_SHIFT) | \
      (wburst_cnt_q << MH_DEBUG_REG30_WBURST_CNT_q_SHIFT) | \
      (cp_send_qual << MH_DEBUG_REG30_CP_SEND_QUAL_SHIFT) | \
      (cp_mh_write << MH_DEBUG_REG30_CP_MH_write_SHIFT) | \
      (rb_send_qual << MH_DEBUG_REG30_RB_SEND_QUAL_SHIFT) | \
      (pa_send_qual << MH_DEBUG_REG30_PA_SEND_QUAL_SHIFT) | \
      (arb_winner << MH_DEBUG_REG30_ARB_WINNER_SHIFT))

#define MH_DEBUG_REG30_GET_TC_ARB_HOLD(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_TC_ARB_HOLD_MASK) >> MH_DEBUG_REG30_TC_ARB_HOLD_SHIFT)
#define MH_DEBUG_REG30_GET_TC_NOROQ_SAME_ROW_BANK(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_MASK) >> MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_SHIFT)
#define MH_DEBUG_REG30_GET_TC_ROQ_SAME_ROW_BANK(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_MASK) >> MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_SHIFT)
#define MH_DEBUG_REG30_GET_TCD_NEARFULL_q(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_TCD_NEARFULL_q_MASK) >> MH_DEBUG_REG30_TCD_NEARFULL_q_SHIFT)
#define MH_DEBUG_REG30_GET_TCHOLD_IP_q(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_TCHOLD_IP_q_MASK) >> MH_DEBUG_REG30_TCHOLD_IP_q_SHIFT)
#define MH_DEBUG_REG30_GET_TCHOLD_CNT_q(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_TCHOLD_CNT_q_MASK) >> MH_DEBUG_REG30_TCHOLD_CNT_q_SHIFT)
#define MH_DEBUG_REG30_GET_MH_ARBITER_CONFIG_TC_REORDER_ENABLE(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_MASK) >> MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SHIFT)
#define MH_DEBUG_REG30_GET_TC_ROQ_RTR_DBG_q(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_MASK) >> MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_SHIFT)
#define MH_DEBUG_REG30_GET_TC_ROQ_SEND_q(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_TC_ROQ_SEND_q_MASK) >> MH_DEBUG_REG30_TC_ROQ_SEND_q_SHIFT)
#define MH_DEBUG_REG30_GET_TC_MH_written(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_TC_MH_written_MASK) >> MH_DEBUG_REG30_TC_MH_written_SHIFT)
#define MH_DEBUG_REG30_GET_TCD_FULLNESS_CNT_q(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_MASK) >> MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_SHIFT)
#define MH_DEBUG_REG30_GET_WBURST_ACTIVE(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_WBURST_ACTIVE_MASK) >> MH_DEBUG_REG30_WBURST_ACTIVE_SHIFT)
#define MH_DEBUG_REG30_GET_WLAST_q(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_WLAST_q_MASK) >> MH_DEBUG_REG30_WLAST_q_SHIFT)
#define MH_DEBUG_REG30_GET_WBURST_IP_q(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_WBURST_IP_q_MASK) >> MH_DEBUG_REG30_WBURST_IP_q_SHIFT)
#define MH_DEBUG_REG30_GET_WBURST_CNT_q(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_WBURST_CNT_q_MASK) >> MH_DEBUG_REG30_WBURST_CNT_q_SHIFT)
#define MH_DEBUG_REG30_GET_CP_SEND_QUAL(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_CP_SEND_QUAL_MASK) >> MH_DEBUG_REG30_CP_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG30_GET_CP_MH_write(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_CP_MH_write_MASK) >> MH_DEBUG_REG30_CP_MH_write_SHIFT)
#define MH_DEBUG_REG30_GET_RB_SEND_QUAL(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_RB_SEND_QUAL_MASK) >> MH_DEBUG_REG30_RB_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG30_GET_PA_SEND_QUAL(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_PA_SEND_QUAL_MASK) >> MH_DEBUG_REG30_PA_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG30_GET_ARB_WINNER(mh_debug_reg30) \
     ((mh_debug_reg30 & MH_DEBUG_REG30_ARB_WINNER_MASK) >> MH_DEBUG_REG30_ARB_WINNER_SHIFT)

#define MH_DEBUG_REG30_SET_TC_ARB_HOLD(mh_debug_reg30_reg, tc_arb_hold) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_TC_ARB_HOLD_MASK) | (tc_arb_hold << MH_DEBUG_REG30_TC_ARB_HOLD_SHIFT)
#define MH_DEBUG_REG30_SET_TC_NOROQ_SAME_ROW_BANK(mh_debug_reg30_reg, tc_noroq_same_row_bank) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_MASK) | (tc_noroq_same_row_bank << MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_SHIFT)
#define MH_DEBUG_REG30_SET_TC_ROQ_SAME_ROW_BANK(mh_debug_reg30_reg, tc_roq_same_row_bank) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_MASK) | (tc_roq_same_row_bank << MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_SHIFT)
#define MH_DEBUG_REG30_SET_TCD_NEARFULL_q(mh_debug_reg30_reg, tcd_nearfull_q) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_TCD_NEARFULL_q_MASK) | (tcd_nearfull_q << MH_DEBUG_REG30_TCD_NEARFULL_q_SHIFT)
#define MH_DEBUG_REG30_SET_TCHOLD_IP_q(mh_debug_reg30_reg, tchold_ip_q) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_TCHOLD_IP_q_MASK) | (tchold_ip_q << MH_DEBUG_REG30_TCHOLD_IP_q_SHIFT)
#define MH_DEBUG_REG30_SET_TCHOLD_CNT_q(mh_debug_reg30_reg, tchold_cnt_q) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_TCHOLD_CNT_q_MASK) | (tchold_cnt_q << MH_DEBUG_REG30_TCHOLD_CNT_q_SHIFT)
#define MH_DEBUG_REG30_SET_MH_ARBITER_CONFIG_TC_REORDER_ENABLE(mh_debug_reg30_reg, mh_arbiter_config_tc_reorder_enable) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_MASK) | (mh_arbiter_config_tc_reorder_enable << MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SHIFT)
#define MH_DEBUG_REG30_SET_TC_ROQ_RTR_DBG_q(mh_debug_reg30_reg, tc_roq_rtr_dbg_q) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_MASK) | (tc_roq_rtr_dbg_q << MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_SHIFT)
#define MH_DEBUG_REG30_SET_TC_ROQ_SEND_q(mh_debug_reg30_reg, tc_roq_send_q) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_TC_ROQ_SEND_q_MASK) | (tc_roq_send_q << MH_DEBUG_REG30_TC_ROQ_SEND_q_SHIFT)
#define MH_DEBUG_REG30_SET_TC_MH_written(mh_debug_reg30_reg, tc_mh_written) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_TC_MH_written_MASK) | (tc_mh_written << MH_DEBUG_REG30_TC_MH_written_SHIFT)
#define MH_DEBUG_REG30_SET_TCD_FULLNESS_CNT_q(mh_debug_reg30_reg, tcd_fullness_cnt_q) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_MASK) | (tcd_fullness_cnt_q << MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_SHIFT)
#define MH_DEBUG_REG30_SET_WBURST_ACTIVE(mh_debug_reg30_reg, wburst_active) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_WBURST_ACTIVE_MASK) | (wburst_active << MH_DEBUG_REG30_WBURST_ACTIVE_SHIFT)
#define MH_DEBUG_REG30_SET_WLAST_q(mh_debug_reg30_reg, wlast_q) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_WLAST_q_MASK) | (wlast_q << MH_DEBUG_REG30_WLAST_q_SHIFT)
#define MH_DEBUG_REG30_SET_WBURST_IP_q(mh_debug_reg30_reg, wburst_ip_q) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_WBURST_IP_q_MASK) | (wburst_ip_q << MH_DEBUG_REG30_WBURST_IP_q_SHIFT)
#define MH_DEBUG_REG30_SET_WBURST_CNT_q(mh_debug_reg30_reg, wburst_cnt_q) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_WBURST_CNT_q_MASK) | (wburst_cnt_q << MH_DEBUG_REG30_WBURST_CNT_q_SHIFT)
#define MH_DEBUG_REG30_SET_CP_SEND_QUAL(mh_debug_reg30_reg, cp_send_qual) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_CP_SEND_QUAL_MASK) | (cp_send_qual << MH_DEBUG_REG30_CP_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG30_SET_CP_MH_write(mh_debug_reg30_reg, cp_mh_write) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_CP_MH_write_MASK) | (cp_mh_write << MH_DEBUG_REG30_CP_MH_write_SHIFT)
#define MH_DEBUG_REG30_SET_RB_SEND_QUAL(mh_debug_reg30_reg, rb_send_qual) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_RB_SEND_QUAL_MASK) | (rb_send_qual << MH_DEBUG_REG30_RB_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG30_SET_PA_SEND_QUAL(mh_debug_reg30_reg, pa_send_qual) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_PA_SEND_QUAL_MASK) | (pa_send_qual << MH_DEBUG_REG30_PA_SEND_QUAL_SHIFT)
#define MH_DEBUG_REG30_SET_ARB_WINNER(mh_debug_reg30_reg, arb_winner) \
     mh_debug_reg30_reg = (mh_debug_reg30_reg & ~MH_DEBUG_REG30_ARB_WINNER_MASK) | (arb_winner << MH_DEBUG_REG30_ARB_WINNER_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg30_t {
          unsigned int tc_arb_hold                    : MH_DEBUG_REG30_TC_ARB_HOLD_SIZE;
          unsigned int tc_noroq_same_row_bank         : MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_SIZE;
          unsigned int tc_roq_same_row_bank           : MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_SIZE;
          unsigned int tcd_nearfull_q                 : MH_DEBUG_REG30_TCD_NEARFULL_q_SIZE;
          unsigned int tchold_ip_q                    : MH_DEBUG_REG30_TCHOLD_IP_q_SIZE;
          unsigned int tchold_cnt_q                   : MH_DEBUG_REG30_TCHOLD_CNT_q_SIZE;
          unsigned int mh_arbiter_config_tc_reorder_enable : MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SIZE;
          unsigned int tc_roq_rtr_dbg_q               : MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_SIZE;
          unsigned int tc_roq_send_q                  : MH_DEBUG_REG30_TC_ROQ_SEND_q_SIZE;
          unsigned int tc_mh_written                  : MH_DEBUG_REG30_TC_MH_written_SIZE;
          unsigned int tcd_fullness_cnt_q             : MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_SIZE;
          unsigned int wburst_active                  : MH_DEBUG_REG30_WBURST_ACTIVE_SIZE;
          unsigned int wlast_q                        : MH_DEBUG_REG30_WLAST_q_SIZE;
          unsigned int wburst_ip_q                    : MH_DEBUG_REG30_WBURST_IP_q_SIZE;
          unsigned int wburst_cnt_q                   : MH_DEBUG_REG30_WBURST_CNT_q_SIZE;
          unsigned int cp_send_qual                   : MH_DEBUG_REG30_CP_SEND_QUAL_SIZE;
          unsigned int cp_mh_write                    : MH_DEBUG_REG30_CP_MH_write_SIZE;
          unsigned int rb_send_qual                   : MH_DEBUG_REG30_RB_SEND_QUAL_SIZE;
          unsigned int pa_send_qual                   : MH_DEBUG_REG30_PA_SEND_QUAL_SIZE;
          unsigned int arb_winner                     : MH_DEBUG_REG30_ARB_WINNER_SIZE;
     } mh_debug_reg30_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg30_t {
          unsigned int arb_winner                     : MH_DEBUG_REG30_ARB_WINNER_SIZE;
          unsigned int pa_send_qual                   : MH_DEBUG_REG30_PA_SEND_QUAL_SIZE;
          unsigned int rb_send_qual                   : MH_DEBUG_REG30_RB_SEND_QUAL_SIZE;
          unsigned int cp_mh_write                    : MH_DEBUG_REG30_CP_MH_write_SIZE;
          unsigned int cp_send_qual                   : MH_DEBUG_REG30_CP_SEND_QUAL_SIZE;
          unsigned int wburst_cnt_q                   : MH_DEBUG_REG30_WBURST_CNT_q_SIZE;
          unsigned int wburst_ip_q                    : MH_DEBUG_REG30_WBURST_IP_q_SIZE;
          unsigned int wlast_q                        : MH_DEBUG_REG30_WLAST_q_SIZE;
          unsigned int wburst_active                  : MH_DEBUG_REG30_WBURST_ACTIVE_SIZE;
          unsigned int tcd_fullness_cnt_q             : MH_DEBUG_REG30_TCD_FULLNESS_CNT_q_SIZE;
          unsigned int tc_mh_written                  : MH_DEBUG_REG30_TC_MH_written_SIZE;
          unsigned int tc_roq_send_q                  : MH_DEBUG_REG30_TC_ROQ_SEND_q_SIZE;
          unsigned int tc_roq_rtr_dbg_q               : MH_DEBUG_REG30_TC_ROQ_RTR_DBG_q_SIZE;
          unsigned int mh_arbiter_config_tc_reorder_enable : MH_DEBUG_REG30_MH_ARBITER_CONFIG_TC_REORDER_ENABLE_SIZE;
          unsigned int tchold_cnt_q                   : MH_DEBUG_REG30_TCHOLD_CNT_q_SIZE;
          unsigned int tchold_ip_q                    : MH_DEBUG_REG30_TCHOLD_IP_q_SIZE;
          unsigned int tcd_nearfull_q                 : MH_DEBUG_REG30_TCD_NEARFULL_q_SIZE;
          unsigned int tc_roq_same_row_bank           : MH_DEBUG_REG30_TC_ROQ_SAME_ROW_BANK_SIZE;
          unsigned int tc_noroq_same_row_bank         : MH_DEBUG_REG30_TC_NOROQ_SAME_ROW_BANK_SIZE;
          unsigned int tc_arb_hold                    : MH_DEBUG_REG30_TC_ARB_HOLD_SIZE;
     } mh_debug_reg30_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg30_t f;
} mh_debug_reg30_u;


/*
 * MH_DEBUG_REG31 struct
 */

#define MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_SIZE 26
#define MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SIZE 3

#define MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_SHIFT 0
#define MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT 26

#define MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_MASK 0x03ffffff
#define MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK 0x1c000000

#define MH_DEBUG_REG31_MASK \
     (MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_MASK | \
      MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK)

#define MH_DEBUG_REG31(rf_arbiter_config_q, mh_clnt_axi_id_reuse_mmur_id) \
     ((rf_arbiter_config_q << MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_SHIFT) | \
      (mh_clnt_axi_id_reuse_mmur_id << MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT))

#define MH_DEBUG_REG31_GET_RF_ARBITER_CONFIG_q(mh_debug_reg31) \
     ((mh_debug_reg31 & MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_MASK) >> MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_SHIFT)
#define MH_DEBUG_REG31_GET_MH_CLNT_AXI_ID_REUSE_MMUr_ID(mh_debug_reg31) \
     ((mh_debug_reg31 & MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK) >> MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT)

#define MH_DEBUG_REG31_SET_RF_ARBITER_CONFIG_q(mh_debug_reg31_reg, rf_arbiter_config_q) \
     mh_debug_reg31_reg = (mh_debug_reg31_reg & ~MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_MASK) | (rf_arbiter_config_q << MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_SHIFT)
#define MH_DEBUG_REG31_SET_MH_CLNT_AXI_ID_REUSE_MMUr_ID(mh_debug_reg31_reg, mh_clnt_axi_id_reuse_mmur_id) \
     mh_debug_reg31_reg = (mh_debug_reg31_reg & ~MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK) | (mh_clnt_axi_id_reuse_mmur_id << MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg31_t {
          unsigned int rf_arbiter_config_q            : MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_SIZE;
          unsigned int mh_clnt_axi_id_reuse_mmur_id   : MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SIZE;
          unsigned int                                : 3;
     } mh_debug_reg31_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg31_t {
          unsigned int                                : 3;
          unsigned int mh_clnt_axi_id_reuse_mmur_id   : MH_DEBUG_REG31_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SIZE;
          unsigned int rf_arbiter_config_q            : MH_DEBUG_REG31_RF_ARBITER_CONFIG_q_SIZE;
     } mh_debug_reg31_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg31_t f;
} mh_debug_reg31_u;


/*
 * MH_DEBUG_REG32 struct
 */

#define MH_DEBUG_REG32_SAME_ROW_BANK_q_SIZE 8
#define MH_DEBUG_REG32_ROQ_MARK_q_SIZE 8
#define MH_DEBUG_REG32_ROQ_VALID_q_SIZE 8
#define MH_DEBUG_REG32_TC_MH_send_SIZE 1
#define MH_DEBUG_REG32_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG32_KILL_EFF1_SIZE  1
#define MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_SIZE 1
#define MH_DEBUG_REG32_ANY_SAME_ROW_BANK_SIZE 1
#define MH_DEBUG_REG32_TC_EFF1_QUAL_SIZE 1
#define MH_DEBUG_REG32_TC_ROQ_EMPTY_SIZE 1
#define MH_DEBUG_REG32_TC_ROQ_FULL_SIZE 1

#define MH_DEBUG_REG32_SAME_ROW_BANK_q_SHIFT 0
#define MH_DEBUG_REG32_ROQ_MARK_q_SHIFT 8
#define MH_DEBUG_REG32_ROQ_VALID_q_SHIFT 16
#define MH_DEBUG_REG32_TC_MH_send_SHIFT 24
#define MH_DEBUG_REG32_TC_ROQ_RTR_q_SHIFT 25
#define MH_DEBUG_REG32_KILL_EFF1_SHIFT 26
#define MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_SHIFT 27
#define MH_DEBUG_REG32_ANY_SAME_ROW_BANK_SHIFT 28
#define MH_DEBUG_REG32_TC_EFF1_QUAL_SHIFT 29
#define MH_DEBUG_REG32_TC_ROQ_EMPTY_SHIFT 30
#define MH_DEBUG_REG32_TC_ROQ_FULL_SHIFT 31

#define MH_DEBUG_REG32_SAME_ROW_BANK_q_MASK 0x000000ff
#define MH_DEBUG_REG32_ROQ_MARK_q_MASK 0x0000ff00
#define MH_DEBUG_REG32_ROQ_VALID_q_MASK 0x00ff0000
#define MH_DEBUG_REG32_TC_MH_send_MASK 0x01000000
#define MH_DEBUG_REG32_TC_ROQ_RTR_q_MASK 0x02000000
#define MH_DEBUG_REG32_KILL_EFF1_MASK  0x04000000
#define MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_MASK 0x08000000
#define MH_DEBUG_REG32_ANY_SAME_ROW_BANK_MASK 0x10000000
#define MH_DEBUG_REG32_TC_EFF1_QUAL_MASK 0x20000000
#define MH_DEBUG_REG32_TC_ROQ_EMPTY_MASK 0x40000000
#define MH_DEBUG_REG32_TC_ROQ_FULL_MASK 0x80000000

#define MH_DEBUG_REG32_MASK \
     (MH_DEBUG_REG32_SAME_ROW_BANK_q_MASK | \
      MH_DEBUG_REG32_ROQ_MARK_q_MASK | \
      MH_DEBUG_REG32_ROQ_VALID_q_MASK | \
      MH_DEBUG_REG32_TC_MH_send_MASK | \
      MH_DEBUG_REG32_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG32_KILL_EFF1_MASK | \
      MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_MASK | \
      MH_DEBUG_REG32_ANY_SAME_ROW_BANK_MASK | \
      MH_DEBUG_REG32_TC_EFF1_QUAL_MASK | \
      MH_DEBUG_REG32_TC_ROQ_EMPTY_MASK | \
      MH_DEBUG_REG32_TC_ROQ_FULL_MASK)

#define MH_DEBUG_REG32(same_row_bank_q, roq_mark_q, roq_valid_q, tc_mh_send, tc_roq_rtr_q, kill_eff1, tc_roq_same_row_bank_sel, any_same_row_bank, tc_eff1_qual, tc_roq_empty, tc_roq_full) \
     ((same_row_bank_q << MH_DEBUG_REG32_SAME_ROW_BANK_q_SHIFT) | \
      (roq_mark_q << MH_DEBUG_REG32_ROQ_MARK_q_SHIFT) | \
      (roq_valid_q << MH_DEBUG_REG32_ROQ_VALID_q_SHIFT) | \
      (tc_mh_send << MH_DEBUG_REG32_TC_MH_send_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG32_TC_ROQ_RTR_q_SHIFT) | \
      (kill_eff1 << MH_DEBUG_REG32_KILL_EFF1_SHIFT) | \
      (tc_roq_same_row_bank_sel << MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_SHIFT) | \
      (any_same_row_bank << MH_DEBUG_REG32_ANY_SAME_ROW_BANK_SHIFT) | \
      (tc_eff1_qual << MH_DEBUG_REG32_TC_EFF1_QUAL_SHIFT) | \
      (tc_roq_empty << MH_DEBUG_REG32_TC_ROQ_EMPTY_SHIFT) | \
      (tc_roq_full << MH_DEBUG_REG32_TC_ROQ_FULL_SHIFT))

#define MH_DEBUG_REG32_GET_SAME_ROW_BANK_q(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_SAME_ROW_BANK_q_MASK) >> MH_DEBUG_REG32_SAME_ROW_BANK_q_SHIFT)
#define MH_DEBUG_REG32_GET_ROQ_MARK_q(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_ROQ_MARK_q_MASK) >> MH_DEBUG_REG32_ROQ_MARK_q_SHIFT)
#define MH_DEBUG_REG32_GET_ROQ_VALID_q(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_ROQ_VALID_q_MASK) >> MH_DEBUG_REG32_ROQ_VALID_q_SHIFT)
#define MH_DEBUG_REG32_GET_TC_MH_send(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_TC_MH_send_MASK) >> MH_DEBUG_REG32_TC_MH_send_SHIFT)
#define MH_DEBUG_REG32_GET_TC_ROQ_RTR_q(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG32_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG32_GET_KILL_EFF1(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_KILL_EFF1_MASK) >> MH_DEBUG_REG32_KILL_EFF1_SHIFT)
#define MH_DEBUG_REG32_GET_TC_ROQ_SAME_ROW_BANK_SEL(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_MASK) >> MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_SHIFT)
#define MH_DEBUG_REG32_GET_ANY_SAME_ROW_BANK(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_ANY_SAME_ROW_BANK_MASK) >> MH_DEBUG_REG32_ANY_SAME_ROW_BANK_SHIFT)
#define MH_DEBUG_REG32_GET_TC_EFF1_QUAL(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_TC_EFF1_QUAL_MASK) >> MH_DEBUG_REG32_TC_EFF1_QUAL_SHIFT)
#define MH_DEBUG_REG32_GET_TC_ROQ_EMPTY(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_TC_ROQ_EMPTY_MASK) >> MH_DEBUG_REG32_TC_ROQ_EMPTY_SHIFT)
#define MH_DEBUG_REG32_GET_TC_ROQ_FULL(mh_debug_reg32) \
     ((mh_debug_reg32 & MH_DEBUG_REG32_TC_ROQ_FULL_MASK) >> MH_DEBUG_REG32_TC_ROQ_FULL_SHIFT)

#define MH_DEBUG_REG32_SET_SAME_ROW_BANK_q(mh_debug_reg32_reg, same_row_bank_q) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_SAME_ROW_BANK_q_MASK) | (same_row_bank_q << MH_DEBUG_REG32_SAME_ROW_BANK_q_SHIFT)
#define MH_DEBUG_REG32_SET_ROQ_MARK_q(mh_debug_reg32_reg, roq_mark_q) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_ROQ_MARK_q_MASK) | (roq_mark_q << MH_DEBUG_REG32_ROQ_MARK_q_SHIFT)
#define MH_DEBUG_REG32_SET_ROQ_VALID_q(mh_debug_reg32_reg, roq_valid_q) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_ROQ_VALID_q_MASK) | (roq_valid_q << MH_DEBUG_REG32_ROQ_VALID_q_SHIFT)
#define MH_DEBUG_REG32_SET_TC_MH_send(mh_debug_reg32_reg, tc_mh_send) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG32_TC_MH_send_SHIFT)
#define MH_DEBUG_REG32_SET_TC_ROQ_RTR_q(mh_debug_reg32_reg, tc_roq_rtr_q) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG32_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG32_SET_KILL_EFF1(mh_debug_reg32_reg, kill_eff1) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_KILL_EFF1_MASK) | (kill_eff1 << MH_DEBUG_REG32_KILL_EFF1_SHIFT)
#define MH_DEBUG_REG32_SET_TC_ROQ_SAME_ROW_BANK_SEL(mh_debug_reg32_reg, tc_roq_same_row_bank_sel) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_MASK) | (tc_roq_same_row_bank_sel << MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_SHIFT)
#define MH_DEBUG_REG32_SET_ANY_SAME_ROW_BANK(mh_debug_reg32_reg, any_same_row_bank) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_ANY_SAME_ROW_BANK_MASK) | (any_same_row_bank << MH_DEBUG_REG32_ANY_SAME_ROW_BANK_SHIFT)
#define MH_DEBUG_REG32_SET_TC_EFF1_QUAL(mh_debug_reg32_reg, tc_eff1_qual) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_TC_EFF1_QUAL_MASK) | (tc_eff1_qual << MH_DEBUG_REG32_TC_EFF1_QUAL_SHIFT)
#define MH_DEBUG_REG32_SET_TC_ROQ_EMPTY(mh_debug_reg32_reg, tc_roq_empty) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_TC_ROQ_EMPTY_MASK) | (tc_roq_empty << MH_DEBUG_REG32_TC_ROQ_EMPTY_SHIFT)
#define MH_DEBUG_REG32_SET_TC_ROQ_FULL(mh_debug_reg32_reg, tc_roq_full) \
     mh_debug_reg32_reg = (mh_debug_reg32_reg & ~MH_DEBUG_REG32_TC_ROQ_FULL_MASK) | (tc_roq_full << MH_DEBUG_REG32_TC_ROQ_FULL_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg32_t {
          unsigned int same_row_bank_q                : MH_DEBUG_REG32_SAME_ROW_BANK_q_SIZE;
          unsigned int roq_mark_q                     : MH_DEBUG_REG32_ROQ_MARK_q_SIZE;
          unsigned int roq_valid_q                    : MH_DEBUG_REG32_ROQ_VALID_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG32_TC_MH_send_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG32_TC_ROQ_RTR_q_SIZE;
          unsigned int kill_eff1                      : MH_DEBUG_REG32_KILL_EFF1_SIZE;
          unsigned int tc_roq_same_row_bank_sel       : MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_SIZE;
          unsigned int any_same_row_bank              : MH_DEBUG_REG32_ANY_SAME_ROW_BANK_SIZE;
          unsigned int tc_eff1_qual                   : MH_DEBUG_REG32_TC_EFF1_QUAL_SIZE;
          unsigned int tc_roq_empty                   : MH_DEBUG_REG32_TC_ROQ_EMPTY_SIZE;
          unsigned int tc_roq_full                    : MH_DEBUG_REG32_TC_ROQ_FULL_SIZE;
     } mh_debug_reg32_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg32_t {
          unsigned int tc_roq_full                    : MH_DEBUG_REG32_TC_ROQ_FULL_SIZE;
          unsigned int tc_roq_empty                   : MH_DEBUG_REG32_TC_ROQ_EMPTY_SIZE;
          unsigned int tc_eff1_qual                   : MH_DEBUG_REG32_TC_EFF1_QUAL_SIZE;
          unsigned int any_same_row_bank              : MH_DEBUG_REG32_ANY_SAME_ROW_BANK_SIZE;
          unsigned int tc_roq_same_row_bank_sel       : MH_DEBUG_REG32_TC_ROQ_SAME_ROW_BANK_SEL_SIZE;
          unsigned int kill_eff1                      : MH_DEBUG_REG32_KILL_EFF1_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG32_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG32_TC_MH_send_SIZE;
          unsigned int roq_valid_q                    : MH_DEBUG_REG32_ROQ_VALID_q_SIZE;
          unsigned int roq_mark_q                     : MH_DEBUG_REG32_ROQ_MARK_q_SIZE;
          unsigned int same_row_bank_q                : MH_DEBUG_REG32_SAME_ROW_BANK_q_SIZE;
     } mh_debug_reg32_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg32_t f;
} mh_debug_reg32_u;


/*
 * MH_DEBUG_REG33 struct
 */

#define MH_DEBUG_REG33_SAME_ROW_BANK_q_SIZE 8
#define MH_DEBUG_REG33_ROQ_MARK_d_SIZE 8
#define MH_DEBUG_REG33_ROQ_VALID_d_SIZE 8
#define MH_DEBUG_REG33_TC_MH_send_SIZE 1
#define MH_DEBUG_REG33_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG33_KILL_EFF1_SIZE  1
#define MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_SIZE 1
#define MH_DEBUG_REG33_ANY_SAME_ROW_BANK_SIZE 1
#define MH_DEBUG_REG33_TC_EFF1_QUAL_SIZE 1
#define MH_DEBUG_REG33_TC_ROQ_EMPTY_SIZE 1
#define MH_DEBUG_REG33_TC_ROQ_FULL_SIZE 1

#define MH_DEBUG_REG33_SAME_ROW_BANK_q_SHIFT 0
#define MH_DEBUG_REG33_ROQ_MARK_d_SHIFT 8
#define MH_DEBUG_REG33_ROQ_VALID_d_SHIFT 16
#define MH_DEBUG_REG33_TC_MH_send_SHIFT 24
#define MH_DEBUG_REG33_TC_ROQ_RTR_q_SHIFT 25
#define MH_DEBUG_REG33_KILL_EFF1_SHIFT 26
#define MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_SHIFT 27
#define MH_DEBUG_REG33_ANY_SAME_ROW_BANK_SHIFT 28
#define MH_DEBUG_REG33_TC_EFF1_QUAL_SHIFT 29
#define MH_DEBUG_REG33_TC_ROQ_EMPTY_SHIFT 30
#define MH_DEBUG_REG33_TC_ROQ_FULL_SHIFT 31

#define MH_DEBUG_REG33_SAME_ROW_BANK_q_MASK 0x000000ff
#define MH_DEBUG_REG33_ROQ_MARK_d_MASK 0x0000ff00
#define MH_DEBUG_REG33_ROQ_VALID_d_MASK 0x00ff0000
#define MH_DEBUG_REG33_TC_MH_send_MASK 0x01000000
#define MH_DEBUG_REG33_TC_ROQ_RTR_q_MASK 0x02000000
#define MH_DEBUG_REG33_KILL_EFF1_MASK  0x04000000
#define MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_MASK 0x08000000
#define MH_DEBUG_REG33_ANY_SAME_ROW_BANK_MASK 0x10000000
#define MH_DEBUG_REG33_TC_EFF1_QUAL_MASK 0x20000000
#define MH_DEBUG_REG33_TC_ROQ_EMPTY_MASK 0x40000000
#define MH_DEBUG_REG33_TC_ROQ_FULL_MASK 0x80000000

#define MH_DEBUG_REG33_MASK \
     (MH_DEBUG_REG33_SAME_ROW_BANK_q_MASK | \
      MH_DEBUG_REG33_ROQ_MARK_d_MASK | \
      MH_DEBUG_REG33_ROQ_VALID_d_MASK | \
      MH_DEBUG_REG33_TC_MH_send_MASK | \
      MH_DEBUG_REG33_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG33_KILL_EFF1_MASK | \
      MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_MASK | \
      MH_DEBUG_REG33_ANY_SAME_ROW_BANK_MASK | \
      MH_DEBUG_REG33_TC_EFF1_QUAL_MASK | \
      MH_DEBUG_REG33_TC_ROQ_EMPTY_MASK | \
      MH_DEBUG_REG33_TC_ROQ_FULL_MASK)

#define MH_DEBUG_REG33(same_row_bank_q, roq_mark_d, roq_valid_d, tc_mh_send, tc_roq_rtr_q, kill_eff1, tc_roq_same_row_bank_sel, any_same_row_bank, tc_eff1_qual, tc_roq_empty, tc_roq_full) \
     ((same_row_bank_q << MH_DEBUG_REG33_SAME_ROW_BANK_q_SHIFT) | \
      (roq_mark_d << MH_DEBUG_REG33_ROQ_MARK_d_SHIFT) | \
      (roq_valid_d << MH_DEBUG_REG33_ROQ_VALID_d_SHIFT) | \
      (tc_mh_send << MH_DEBUG_REG33_TC_MH_send_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG33_TC_ROQ_RTR_q_SHIFT) | \
      (kill_eff1 << MH_DEBUG_REG33_KILL_EFF1_SHIFT) | \
      (tc_roq_same_row_bank_sel << MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_SHIFT) | \
      (any_same_row_bank << MH_DEBUG_REG33_ANY_SAME_ROW_BANK_SHIFT) | \
      (tc_eff1_qual << MH_DEBUG_REG33_TC_EFF1_QUAL_SHIFT) | \
      (tc_roq_empty << MH_DEBUG_REG33_TC_ROQ_EMPTY_SHIFT) | \
      (tc_roq_full << MH_DEBUG_REG33_TC_ROQ_FULL_SHIFT))

#define MH_DEBUG_REG33_GET_SAME_ROW_BANK_q(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_SAME_ROW_BANK_q_MASK) >> MH_DEBUG_REG33_SAME_ROW_BANK_q_SHIFT)
#define MH_DEBUG_REG33_GET_ROQ_MARK_d(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_ROQ_MARK_d_MASK) >> MH_DEBUG_REG33_ROQ_MARK_d_SHIFT)
#define MH_DEBUG_REG33_GET_ROQ_VALID_d(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_ROQ_VALID_d_MASK) >> MH_DEBUG_REG33_ROQ_VALID_d_SHIFT)
#define MH_DEBUG_REG33_GET_TC_MH_send(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_TC_MH_send_MASK) >> MH_DEBUG_REG33_TC_MH_send_SHIFT)
#define MH_DEBUG_REG33_GET_TC_ROQ_RTR_q(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG33_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG33_GET_KILL_EFF1(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_KILL_EFF1_MASK) >> MH_DEBUG_REG33_KILL_EFF1_SHIFT)
#define MH_DEBUG_REG33_GET_TC_ROQ_SAME_ROW_BANK_SEL(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_MASK) >> MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_SHIFT)
#define MH_DEBUG_REG33_GET_ANY_SAME_ROW_BANK(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_ANY_SAME_ROW_BANK_MASK) >> MH_DEBUG_REG33_ANY_SAME_ROW_BANK_SHIFT)
#define MH_DEBUG_REG33_GET_TC_EFF1_QUAL(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_TC_EFF1_QUAL_MASK) >> MH_DEBUG_REG33_TC_EFF1_QUAL_SHIFT)
#define MH_DEBUG_REG33_GET_TC_ROQ_EMPTY(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_TC_ROQ_EMPTY_MASK) >> MH_DEBUG_REG33_TC_ROQ_EMPTY_SHIFT)
#define MH_DEBUG_REG33_GET_TC_ROQ_FULL(mh_debug_reg33) \
     ((mh_debug_reg33 & MH_DEBUG_REG33_TC_ROQ_FULL_MASK) >> MH_DEBUG_REG33_TC_ROQ_FULL_SHIFT)

#define MH_DEBUG_REG33_SET_SAME_ROW_BANK_q(mh_debug_reg33_reg, same_row_bank_q) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_SAME_ROW_BANK_q_MASK) | (same_row_bank_q << MH_DEBUG_REG33_SAME_ROW_BANK_q_SHIFT)
#define MH_DEBUG_REG33_SET_ROQ_MARK_d(mh_debug_reg33_reg, roq_mark_d) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_ROQ_MARK_d_MASK) | (roq_mark_d << MH_DEBUG_REG33_ROQ_MARK_d_SHIFT)
#define MH_DEBUG_REG33_SET_ROQ_VALID_d(mh_debug_reg33_reg, roq_valid_d) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_ROQ_VALID_d_MASK) | (roq_valid_d << MH_DEBUG_REG33_ROQ_VALID_d_SHIFT)
#define MH_DEBUG_REG33_SET_TC_MH_send(mh_debug_reg33_reg, tc_mh_send) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG33_TC_MH_send_SHIFT)
#define MH_DEBUG_REG33_SET_TC_ROQ_RTR_q(mh_debug_reg33_reg, tc_roq_rtr_q) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG33_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG33_SET_KILL_EFF1(mh_debug_reg33_reg, kill_eff1) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_KILL_EFF1_MASK) | (kill_eff1 << MH_DEBUG_REG33_KILL_EFF1_SHIFT)
#define MH_DEBUG_REG33_SET_TC_ROQ_SAME_ROW_BANK_SEL(mh_debug_reg33_reg, tc_roq_same_row_bank_sel) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_MASK) | (tc_roq_same_row_bank_sel << MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_SHIFT)
#define MH_DEBUG_REG33_SET_ANY_SAME_ROW_BANK(mh_debug_reg33_reg, any_same_row_bank) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_ANY_SAME_ROW_BANK_MASK) | (any_same_row_bank << MH_DEBUG_REG33_ANY_SAME_ROW_BANK_SHIFT)
#define MH_DEBUG_REG33_SET_TC_EFF1_QUAL(mh_debug_reg33_reg, tc_eff1_qual) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_TC_EFF1_QUAL_MASK) | (tc_eff1_qual << MH_DEBUG_REG33_TC_EFF1_QUAL_SHIFT)
#define MH_DEBUG_REG33_SET_TC_ROQ_EMPTY(mh_debug_reg33_reg, tc_roq_empty) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_TC_ROQ_EMPTY_MASK) | (tc_roq_empty << MH_DEBUG_REG33_TC_ROQ_EMPTY_SHIFT)
#define MH_DEBUG_REG33_SET_TC_ROQ_FULL(mh_debug_reg33_reg, tc_roq_full) \
     mh_debug_reg33_reg = (mh_debug_reg33_reg & ~MH_DEBUG_REG33_TC_ROQ_FULL_MASK) | (tc_roq_full << MH_DEBUG_REG33_TC_ROQ_FULL_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg33_t {
          unsigned int same_row_bank_q                : MH_DEBUG_REG33_SAME_ROW_BANK_q_SIZE;
          unsigned int roq_mark_d                     : MH_DEBUG_REG33_ROQ_MARK_d_SIZE;
          unsigned int roq_valid_d                    : MH_DEBUG_REG33_ROQ_VALID_d_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG33_TC_MH_send_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG33_TC_ROQ_RTR_q_SIZE;
          unsigned int kill_eff1                      : MH_DEBUG_REG33_KILL_EFF1_SIZE;
          unsigned int tc_roq_same_row_bank_sel       : MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_SIZE;
          unsigned int any_same_row_bank              : MH_DEBUG_REG33_ANY_SAME_ROW_BANK_SIZE;
          unsigned int tc_eff1_qual                   : MH_DEBUG_REG33_TC_EFF1_QUAL_SIZE;
          unsigned int tc_roq_empty                   : MH_DEBUG_REG33_TC_ROQ_EMPTY_SIZE;
          unsigned int tc_roq_full                    : MH_DEBUG_REG33_TC_ROQ_FULL_SIZE;
     } mh_debug_reg33_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg33_t {
          unsigned int tc_roq_full                    : MH_DEBUG_REG33_TC_ROQ_FULL_SIZE;
          unsigned int tc_roq_empty                   : MH_DEBUG_REG33_TC_ROQ_EMPTY_SIZE;
          unsigned int tc_eff1_qual                   : MH_DEBUG_REG33_TC_EFF1_QUAL_SIZE;
          unsigned int any_same_row_bank              : MH_DEBUG_REG33_ANY_SAME_ROW_BANK_SIZE;
          unsigned int tc_roq_same_row_bank_sel       : MH_DEBUG_REG33_TC_ROQ_SAME_ROW_BANK_SEL_SIZE;
          unsigned int kill_eff1                      : MH_DEBUG_REG33_KILL_EFF1_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG33_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG33_TC_MH_send_SIZE;
          unsigned int roq_valid_d                    : MH_DEBUG_REG33_ROQ_VALID_d_SIZE;
          unsigned int roq_mark_d                     : MH_DEBUG_REG33_ROQ_MARK_d_SIZE;
          unsigned int same_row_bank_q                : MH_DEBUG_REG33_SAME_ROW_BANK_q_SIZE;
     } mh_debug_reg33_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg33_t f;
} mh_debug_reg33_u;


/*
 * MH_DEBUG_REG34 struct
 */

#define MH_DEBUG_REG34_SAME_ROW_BANK_WIN_SIZE 8
#define MH_DEBUG_REG34_SAME_ROW_BANK_REQ_SIZE 8
#define MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_SIZE 8
#define MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_SIZE 8

#define MH_DEBUG_REG34_SAME_ROW_BANK_WIN_SHIFT 0
#define MH_DEBUG_REG34_SAME_ROW_BANK_REQ_SHIFT 8
#define MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_SHIFT 16
#define MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_SHIFT 24

#define MH_DEBUG_REG34_SAME_ROW_BANK_WIN_MASK 0x000000ff
#define MH_DEBUG_REG34_SAME_ROW_BANK_REQ_MASK 0x0000ff00
#define MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_MASK 0x00ff0000
#define MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_MASK 0xff000000

#define MH_DEBUG_REG34_MASK \
     (MH_DEBUG_REG34_SAME_ROW_BANK_WIN_MASK | \
      MH_DEBUG_REG34_SAME_ROW_BANK_REQ_MASK | \
      MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_MASK | \
      MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_MASK)

#define MH_DEBUG_REG34(same_row_bank_win, same_row_bank_req, non_same_row_bank_win, non_same_row_bank_req) \
     ((same_row_bank_win << MH_DEBUG_REG34_SAME_ROW_BANK_WIN_SHIFT) | \
      (same_row_bank_req << MH_DEBUG_REG34_SAME_ROW_BANK_REQ_SHIFT) | \
      (non_same_row_bank_win << MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_SHIFT) | \
      (non_same_row_bank_req << MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_SHIFT))

#define MH_DEBUG_REG34_GET_SAME_ROW_BANK_WIN(mh_debug_reg34) \
     ((mh_debug_reg34 & MH_DEBUG_REG34_SAME_ROW_BANK_WIN_MASK) >> MH_DEBUG_REG34_SAME_ROW_BANK_WIN_SHIFT)
#define MH_DEBUG_REG34_GET_SAME_ROW_BANK_REQ(mh_debug_reg34) \
     ((mh_debug_reg34 & MH_DEBUG_REG34_SAME_ROW_BANK_REQ_MASK) >> MH_DEBUG_REG34_SAME_ROW_BANK_REQ_SHIFT)
#define MH_DEBUG_REG34_GET_NON_SAME_ROW_BANK_WIN(mh_debug_reg34) \
     ((mh_debug_reg34 & MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_MASK) >> MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_SHIFT)
#define MH_DEBUG_REG34_GET_NON_SAME_ROW_BANK_REQ(mh_debug_reg34) \
     ((mh_debug_reg34 & MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_MASK) >> MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_SHIFT)

#define MH_DEBUG_REG34_SET_SAME_ROW_BANK_WIN(mh_debug_reg34_reg, same_row_bank_win) \
     mh_debug_reg34_reg = (mh_debug_reg34_reg & ~MH_DEBUG_REG34_SAME_ROW_BANK_WIN_MASK) | (same_row_bank_win << MH_DEBUG_REG34_SAME_ROW_BANK_WIN_SHIFT)
#define MH_DEBUG_REG34_SET_SAME_ROW_BANK_REQ(mh_debug_reg34_reg, same_row_bank_req) \
     mh_debug_reg34_reg = (mh_debug_reg34_reg & ~MH_DEBUG_REG34_SAME_ROW_BANK_REQ_MASK) | (same_row_bank_req << MH_DEBUG_REG34_SAME_ROW_BANK_REQ_SHIFT)
#define MH_DEBUG_REG34_SET_NON_SAME_ROW_BANK_WIN(mh_debug_reg34_reg, non_same_row_bank_win) \
     mh_debug_reg34_reg = (mh_debug_reg34_reg & ~MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_MASK) | (non_same_row_bank_win << MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_SHIFT)
#define MH_DEBUG_REG34_SET_NON_SAME_ROW_BANK_REQ(mh_debug_reg34_reg, non_same_row_bank_req) \
     mh_debug_reg34_reg = (mh_debug_reg34_reg & ~MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_MASK) | (non_same_row_bank_req << MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg34_t {
          unsigned int same_row_bank_win              : MH_DEBUG_REG34_SAME_ROW_BANK_WIN_SIZE;
          unsigned int same_row_bank_req              : MH_DEBUG_REG34_SAME_ROW_BANK_REQ_SIZE;
          unsigned int non_same_row_bank_win          : MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_SIZE;
          unsigned int non_same_row_bank_req          : MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_SIZE;
     } mh_debug_reg34_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg34_t {
          unsigned int non_same_row_bank_req          : MH_DEBUG_REG34_NON_SAME_ROW_BANK_REQ_SIZE;
          unsigned int non_same_row_bank_win          : MH_DEBUG_REG34_NON_SAME_ROW_BANK_WIN_SIZE;
          unsigned int same_row_bank_req              : MH_DEBUG_REG34_SAME_ROW_BANK_REQ_SIZE;
          unsigned int same_row_bank_win              : MH_DEBUG_REG34_SAME_ROW_BANK_WIN_SIZE;
     } mh_debug_reg34_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg34_t f;
} mh_debug_reg34_u;


/*
 * MH_DEBUG_REG35 struct
 */

#define MH_DEBUG_REG35_TC_MH_send_SIZE 1
#define MH_DEBUG_REG35_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG35_ROQ_MARK_q_0_SIZE 1
#define MH_DEBUG_REG35_ROQ_VALID_q_0_SIZE 1
#define MH_DEBUG_REG35_SAME_ROW_BANK_q_0_SIZE 1
#define MH_DEBUG_REG35_ROQ_ADDR_0_SIZE 27

#define MH_DEBUG_REG35_TC_MH_send_SHIFT 0
#define MH_DEBUG_REG35_TC_ROQ_RTR_q_SHIFT 1
#define MH_DEBUG_REG35_ROQ_MARK_q_0_SHIFT 2
#define MH_DEBUG_REG35_ROQ_VALID_q_0_SHIFT 3
#define MH_DEBUG_REG35_SAME_ROW_BANK_q_0_SHIFT 4
#define MH_DEBUG_REG35_ROQ_ADDR_0_SHIFT 5

#define MH_DEBUG_REG35_TC_MH_send_MASK 0x00000001
#define MH_DEBUG_REG35_TC_ROQ_RTR_q_MASK 0x00000002
#define MH_DEBUG_REG35_ROQ_MARK_q_0_MASK 0x00000004
#define MH_DEBUG_REG35_ROQ_VALID_q_0_MASK 0x00000008
#define MH_DEBUG_REG35_SAME_ROW_BANK_q_0_MASK 0x00000010
#define MH_DEBUG_REG35_ROQ_ADDR_0_MASK 0xffffffe0

#define MH_DEBUG_REG35_MASK \
     (MH_DEBUG_REG35_TC_MH_send_MASK | \
      MH_DEBUG_REG35_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG35_ROQ_MARK_q_0_MASK | \
      MH_DEBUG_REG35_ROQ_VALID_q_0_MASK | \
      MH_DEBUG_REG35_SAME_ROW_BANK_q_0_MASK | \
      MH_DEBUG_REG35_ROQ_ADDR_0_MASK)

#define MH_DEBUG_REG35(tc_mh_send, tc_roq_rtr_q, roq_mark_q_0, roq_valid_q_0, same_row_bank_q_0, roq_addr_0) \
     ((tc_mh_send << MH_DEBUG_REG35_TC_MH_send_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG35_TC_ROQ_RTR_q_SHIFT) | \
      (roq_mark_q_0 << MH_DEBUG_REG35_ROQ_MARK_q_0_SHIFT) | \
      (roq_valid_q_0 << MH_DEBUG_REG35_ROQ_VALID_q_0_SHIFT) | \
      (same_row_bank_q_0 << MH_DEBUG_REG35_SAME_ROW_BANK_q_0_SHIFT) | \
      (roq_addr_0 << MH_DEBUG_REG35_ROQ_ADDR_0_SHIFT))

#define MH_DEBUG_REG35_GET_TC_MH_send(mh_debug_reg35) \
     ((mh_debug_reg35 & MH_DEBUG_REG35_TC_MH_send_MASK) >> MH_DEBUG_REG35_TC_MH_send_SHIFT)
#define MH_DEBUG_REG35_GET_TC_ROQ_RTR_q(mh_debug_reg35) \
     ((mh_debug_reg35 & MH_DEBUG_REG35_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG35_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG35_GET_ROQ_MARK_q_0(mh_debug_reg35) \
     ((mh_debug_reg35 & MH_DEBUG_REG35_ROQ_MARK_q_0_MASK) >> MH_DEBUG_REG35_ROQ_MARK_q_0_SHIFT)
#define MH_DEBUG_REG35_GET_ROQ_VALID_q_0(mh_debug_reg35) \
     ((mh_debug_reg35 & MH_DEBUG_REG35_ROQ_VALID_q_0_MASK) >> MH_DEBUG_REG35_ROQ_VALID_q_0_SHIFT)
#define MH_DEBUG_REG35_GET_SAME_ROW_BANK_q_0(mh_debug_reg35) \
     ((mh_debug_reg35 & MH_DEBUG_REG35_SAME_ROW_BANK_q_0_MASK) >> MH_DEBUG_REG35_SAME_ROW_BANK_q_0_SHIFT)
#define MH_DEBUG_REG35_GET_ROQ_ADDR_0(mh_debug_reg35) \
     ((mh_debug_reg35 & MH_DEBUG_REG35_ROQ_ADDR_0_MASK) >> MH_DEBUG_REG35_ROQ_ADDR_0_SHIFT)

#define MH_DEBUG_REG35_SET_TC_MH_send(mh_debug_reg35_reg, tc_mh_send) \
     mh_debug_reg35_reg = (mh_debug_reg35_reg & ~MH_DEBUG_REG35_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG35_TC_MH_send_SHIFT)
#define MH_DEBUG_REG35_SET_TC_ROQ_RTR_q(mh_debug_reg35_reg, tc_roq_rtr_q) \
     mh_debug_reg35_reg = (mh_debug_reg35_reg & ~MH_DEBUG_REG35_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG35_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG35_SET_ROQ_MARK_q_0(mh_debug_reg35_reg, roq_mark_q_0) \
     mh_debug_reg35_reg = (mh_debug_reg35_reg & ~MH_DEBUG_REG35_ROQ_MARK_q_0_MASK) | (roq_mark_q_0 << MH_DEBUG_REG35_ROQ_MARK_q_0_SHIFT)
#define MH_DEBUG_REG35_SET_ROQ_VALID_q_0(mh_debug_reg35_reg, roq_valid_q_0) \
     mh_debug_reg35_reg = (mh_debug_reg35_reg & ~MH_DEBUG_REG35_ROQ_VALID_q_0_MASK) | (roq_valid_q_0 << MH_DEBUG_REG35_ROQ_VALID_q_0_SHIFT)
#define MH_DEBUG_REG35_SET_SAME_ROW_BANK_q_0(mh_debug_reg35_reg, same_row_bank_q_0) \
     mh_debug_reg35_reg = (mh_debug_reg35_reg & ~MH_DEBUG_REG35_SAME_ROW_BANK_q_0_MASK) | (same_row_bank_q_0 << MH_DEBUG_REG35_SAME_ROW_BANK_q_0_SHIFT)
#define MH_DEBUG_REG35_SET_ROQ_ADDR_0(mh_debug_reg35_reg, roq_addr_0) \
     mh_debug_reg35_reg = (mh_debug_reg35_reg & ~MH_DEBUG_REG35_ROQ_ADDR_0_MASK) | (roq_addr_0 << MH_DEBUG_REG35_ROQ_ADDR_0_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg35_t {
          unsigned int tc_mh_send                     : MH_DEBUG_REG35_TC_MH_send_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG35_TC_ROQ_RTR_q_SIZE;
          unsigned int roq_mark_q_0                   : MH_DEBUG_REG35_ROQ_MARK_q_0_SIZE;
          unsigned int roq_valid_q_0                  : MH_DEBUG_REG35_ROQ_VALID_q_0_SIZE;
          unsigned int same_row_bank_q_0              : MH_DEBUG_REG35_SAME_ROW_BANK_q_0_SIZE;
          unsigned int roq_addr_0                     : MH_DEBUG_REG35_ROQ_ADDR_0_SIZE;
     } mh_debug_reg35_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg35_t {
          unsigned int roq_addr_0                     : MH_DEBUG_REG35_ROQ_ADDR_0_SIZE;
          unsigned int same_row_bank_q_0              : MH_DEBUG_REG35_SAME_ROW_BANK_q_0_SIZE;
          unsigned int roq_valid_q_0                  : MH_DEBUG_REG35_ROQ_VALID_q_0_SIZE;
          unsigned int roq_mark_q_0                   : MH_DEBUG_REG35_ROQ_MARK_q_0_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG35_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG35_TC_MH_send_SIZE;
     } mh_debug_reg35_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg35_t f;
} mh_debug_reg35_u;


/*
 * MH_DEBUG_REG36 struct
 */

#define MH_DEBUG_REG36_TC_MH_send_SIZE 1
#define MH_DEBUG_REG36_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG36_ROQ_MARK_q_1_SIZE 1
#define MH_DEBUG_REG36_ROQ_VALID_q_1_SIZE 1
#define MH_DEBUG_REG36_SAME_ROW_BANK_q_1_SIZE 1
#define MH_DEBUG_REG36_ROQ_ADDR_1_SIZE 27

#define MH_DEBUG_REG36_TC_MH_send_SHIFT 0
#define MH_DEBUG_REG36_TC_ROQ_RTR_q_SHIFT 1
#define MH_DEBUG_REG36_ROQ_MARK_q_1_SHIFT 2
#define MH_DEBUG_REG36_ROQ_VALID_q_1_SHIFT 3
#define MH_DEBUG_REG36_SAME_ROW_BANK_q_1_SHIFT 4
#define MH_DEBUG_REG36_ROQ_ADDR_1_SHIFT 5

#define MH_DEBUG_REG36_TC_MH_send_MASK 0x00000001
#define MH_DEBUG_REG36_TC_ROQ_RTR_q_MASK 0x00000002
#define MH_DEBUG_REG36_ROQ_MARK_q_1_MASK 0x00000004
#define MH_DEBUG_REG36_ROQ_VALID_q_1_MASK 0x00000008
#define MH_DEBUG_REG36_SAME_ROW_BANK_q_1_MASK 0x00000010
#define MH_DEBUG_REG36_ROQ_ADDR_1_MASK 0xffffffe0

#define MH_DEBUG_REG36_MASK \
     (MH_DEBUG_REG36_TC_MH_send_MASK | \
      MH_DEBUG_REG36_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG36_ROQ_MARK_q_1_MASK | \
      MH_DEBUG_REG36_ROQ_VALID_q_1_MASK | \
      MH_DEBUG_REG36_SAME_ROW_BANK_q_1_MASK | \
      MH_DEBUG_REG36_ROQ_ADDR_1_MASK)

#define MH_DEBUG_REG36(tc_mh_send, tc_roq_rtr_q, roq_mark_q_1, roq_valid_q_1, same_row_bank_q_1, roq_addr_1) \
     ((tc_mh_send << MH_DEBUG_REG36_TC_MH_send_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG36_TC_ROQ_RTR_q_SHIFT) | \
      (roq_mark_q_1 << MH_DEBUG_REG36_ROQ_MARK_q_1_SHIFT) | \
      (roq_valid_q_1 << MH_DEBUG_REG36_ROQ_VALID_q_1_SHIFT) | \
      (same_row_bank_q_1 << MH_DEBUG_REG36_SAME_ROW_BANK_q_1_SHIFT) | \
      (roq_addr_1 << MH_DEBUG_REG36_ROQ_ADDR_1_SHIFT))

#define MH_DEBUG_REG36_GET_TC_MH_send(mh_debug_reg36) \
     ((mh_debug_reg36 & MH_DEBUG_REG36_TC_MH_send_MASK) >> MH_DEBUG_REG36_TC_MH_send_SHIFT)
#define MH_DEBUG_REG36_GET_TC_ROQ_RTR_q(mh_debug_reg36) \
     ((mh_debug_reg36 & MH_DEBUG_REG36_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG36_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG36_GET_ROQ_MARK_q_1(mh_debug_reg36) \
     ((mh_debug_reg36 & MH_DEBUG_REG36_ROQ_MARK_q_1_MASK) >> MH_DEBUG_REG36_ROQ_MARK_q_1_SHIFT)
#define MH_DEBUG_REG36_GET_ROQ_VALID_q_1(mh_debug_reg36) \
     ((mh_debug_reg36 & MH_DEBUG_REG36_ROQ_VALID_q_1_MASK) >> MH_DEBUG_REG36_ROQ_VALID_q_1_SHIFT)
#define MH_DEBUG_REG36_GET_SAME_ROW_BANK_q_1(mh_debug_reg36) \
     ((mh_debug_reg36 & MH_DEBUG_REG36_SAME_ROW_BANK_q_1_MASK) >> MH_DEBUG_REG36_SAME_ROW_BANK_q_1_SHIFT)
#define MH_DEBUG_REG36_GET_ROQ_ADDR_1(mh_debug_reg36) \
     ((mh_debug_reg36 & MH_DEBUG_REG36_ROQ_ADDR_1_MASK) >> MH_DEBUG_REG36_ROQ_ADDR_1_SHIFT)

#define MH_DEBUG_REG36_SET_TC_MH_send(mh_debug_reg36_reg, tc_mh_send) \
     mh_debug_reg36_reg = (mh_debug_reg36_reg & ~MH_DEBUG_REG36_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG36_TC_MH_send_SHIFT)
#define MH_DEBUG_REG36_SET_TC_ROQ_RTR_q(mh_debug_reg36_reg, tc_roq_rtr_q) \
     mh_debug_reg36_reg = (mh_debug_reg36_reg & ~MH_DEBUG_REG36_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG36_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG36_SET_ROQ_MARK_q_1(mh_debug_reg36_reg, roq_mark_q_1) \
     mh_debug_reg36_reg = (mh_debug_reg36_reg & ~MH_DEBUG_REG36_ROQ_MARK_q_1_MASK) | (roq_mark_q_1 << MH_DEBUG_REG36_ROQ_MARK_q_1_SHIFT)
#define MH_DEBUG_REG36_SET_ROQ_VALID_q_1(mh_debug_reg36_reg, roq_valid_q_1) \
     mh_debug_reg36_reg = (mh_debug_reg36_reg & ~MH_DEBUG_REG36_ROQ_VALID_q_1_MASK) | (roq_valid_q_1 << MH_DEBUG_REG36_ROQ_VALID_q_1_SHIFT)
#define MH_DEBUG_REG36_SET_SAME_ROW_BANK_q_1(mh_debug_reg36_reg, same_row_bank_q_1) \
     mh_debug_reg36_reg = (mh_debug_reg36_reg & ~MH_DEBUG_REG36_SAME_ROW_BANK_q_1_MASK) | (same_row_bank_q_1 << MH_DEBUG_REG36_SAME_ROW_BANK_q_1_SHIFT)
#define MH_DEBUG_REG36_SET_ROQ_ADDR_1(mh_debug_reg36_reg, roq_addr_1) \
     mh_debug_reg36_reg = (mh_debug_reg36_reg & ~MH_DEBUG_REG36_ROQ_ADDR_1_MASK) | (roq_addr_1 << MH_DEBUG_REG36_ROQ_ADDR_1_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg36_t {
          unsigned int tc_mh_send                     : MH_DEBUG_REG36_TC_MH_send_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG36_TC_ROQ_RTR_q_SIZE;
          unsigned int roq_mark_q_1                   : MH_DEBUG_REG36_ROQ_MARK_q_1_SIZE;
          unsigned int roq_valid_q_1                  : MH_DEBUG_REG36_ROQ_VALID_q_1_SIZE;
          unsigned int same_row_bank_q_1              : MH_DEBUG_REG36_SAME_ROW_BANK_q_1_SIZE;
          unsigned int roq_addr_1                     : MH_DEBUG_REG36_ROQ_ADDR_1_SIZE;
     } mh_debug_reg36_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg36_t {
          unsigned int roq_addr_1                     : MH_DEBUG_REG36_ROQ_ADDR_1_SIZE;
          unsigned int same_row_bank_q_1              : MH_DEBUG_REG36_SAME_ROW_BANK_q_1_SIZE;
          unsigned int roq_valid_q_1                  : MH_DEBUG_REG36_ROQ_VALID_q_1_SIZE;
          unsigned int roq_mark_q_1                   : MH_DEBUG_REG36_ROQ_MARK_q_1_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG36_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG36_TC_MH_send_SIZE;
     } mh_debug_reg36_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg36_t f;
} mh_debug_reg36_u;


/*
 * MH_DEBUG_REG37 struct
 */

#define MH_DEBUG_REG37_TC_MH_send_SIZE 1
#define MH_DEBUG_REG37_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG37_ROQ_MARK_q_2_SIZE 1
#define MH_DEBUG_REG37_ROQ_VALID_q_2_SIZE 1
#define MH_DEBUG_REG37_SAME_ROW_BANK_q_2_SIZE 1
#define MH_DEBUG_REG37_ROQ_ADDR_2_SIZE 27

#define MH_DEBUG_REG37_TC_MH_send_SHIFT 0
#define MH_DEBUG_REG37_TC_ROQ_RTR_q_SHIFT 1
#define MH_DEBUG_REG37_ROQ_MARK_q_2_SHIFT 2
#define MH_DEBUG_REG37_ROQ_VALID_q_2_SHIFT 3
#define MH_DEBUG_REG37_SAME_ROW_BANK_q_2_SHIFT 4
#define MH_DEBUG_REG37_ROQ_ADDR_2_SHIFT 5

#define MH_DEBUG_REG37_TC_MH_send_MASK 0x00000001
#define MH_DEBUG_REG37_TC_ROQ_RTR_q_MASK 0x00000002
#define MH_DEBUG_REG37_ROQ_MARK_q_2_MASK 0x00000004
#define MH_DEBUG_REG37_ROQ_VALID_q_2_MASK 0x00000008
#define MH_DEBUG_REG37_SAME_ROW_BANK_q_2_MASK 0x00000010
#define MH_DEBUG_REG37_ROQ_ADDR_2_MASK 0xffffffe0

#define MH_DEBUG_REG37_MASK \
     (MH_DEBUG_REG37_TC_MH_send_MASK | \
      MH_DEBUG_REG37_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG37_ROQ_MARK_q_2_MASK | \
      MH_DEBUG_REG37_ROQ_VALID_q_2_MASK | \
      MH_DEBUG_REG37_SAME_ROW_BANK_q_2_MASK | \
      MH_DEBUG_REG37_ROQ_ADDR_2_MASK)

#define MH_DEBUG_REG37(tc_mh_send, tc_roq_rtr_q, roq_mark_q_2, roq_valid_q_2, same_row_bank_q_2, roq_addr_2) \
     ((tc_mh_send << MH_DEBUG_REG37_TC_MH_send_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG37_TC_ROQ_RTR_q_SHIFT) | \
      (roq_mark_q_2 << MH_DEBUG_REG37_ROQ_MARK_q_2_SHIFT) | \
      (roq_valid_q_2 << MH_DEBUG_REG37_ROQ_VALID_q_2_SHIFT) | \
      (same_row_bank_q_2 << MH_DEBUG_REG37_SAME_ROW_BANK_q_2_SHIFT) | \
      (roq_addr_2 << MH_DEBUG_REG37_ROQ_ADDR_2_SHIFT))

#define MH_DEBUG_REG37_GET_TC_MH_send(mh_debug_reg37) \
     ((mh_debug_reg37 & MH_DEBUG_REG37_TC_MH_send_MASK) >> MH_DEBUG_REG37_TC_MH_send_SHIFT)
#define MH_DEBUG_REG37_GET_TC_ROQ_RTR_q(mh_debug_reg37) \
     ((mh_debug_reg37 & MH_DEBUG_REG37_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG37_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG37_GET_ROQ_MARK_q_2(mh_debug_reg37) \
     ((mh_debug_reg37 & MH_DEBUG_REG37_ROQ_MARK_q_2_MASK) >> MH_DEBUG_REG37_ROQ_MARK_q_2_SHIFT)
#define MH_DEBUG_REG37_GET_ROQ_VALID_q_2(mh_debug_reg37) \
     ((mh_debug_reg37 & MH_DEBUG_REG37_ROQ_VALID_q_2_MASK) >> MH_DEBUG_REG37_ROQ_VALID_q_2_SHIFT)
#define MH_DEBUG_REG37_GET_SAME_ROW_BANK_q_2(mh_debug_reg37) \
     ((mh_debug_reg37 & MH_DEBUG_REG37_SAME_ROW_BANK_q_2_MASK) >> MH_DEBUG_REG37_SAME_ROW_BANK_q_2_SHIFT)
#define MH_DEBUG_REG37_GET_ROQ_ADDR_2(mh_debug_reg37) \
     ((mh_debug_reg37 & MH_DEBUG_REG37_ROQ_ADDR_2_MASK) >> MH_DEBUG_REG37_ROQ_ADDR_2_SHIFT)

#define MH_DEBUG_REG37_SET_TC_MH_send(mh_debug_reg37_reg, tc_mh_send) \
     mh_debug_reg37_reg = (mh_debug_reg37_reg & ~MH_DEBUG_REG37_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG37_TC_MH_send_SHIFT)
#define MH_DEBUG_REG37_SET_TC_ROQ_RTR_q(mh_debug_reg37_reg, tc_roq_rtr_q) \
     mh_debug_reg37_reg = (mh_debug_reg37_reg & ~MH_DEBUG_REG37_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG37_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG37_SET_ROQ_MARK_q_2(mh_debug_reg37_reg, roq_mark_q_2) \
     mh_debug_reg37_reg = (mh_debug_reg37_reg & ~MH_DEBUG_REG37_ROQ_MARK_q_2_MASK) | (roq_mark_q_2 << MH_DEBUG_REG37_ROQ_MARK_q_2_SHIFT)
#define MH_DEBUG_REG37_SET_ROQ_VALID_q_2(mh_debug_reg37_reg, roq_valid_q_2) \
     mh_debug_reg37_reg = (mh_debug_reg37_reg & ~MH_DEBUG_REG37_ROQ_VALID_q_2_MASK) | (roq_valid_q_2 << MH_DEBUG_REG37_ROQ_VALID_q_2_SHIFT)
#define MH_DEBUG_REG37_SET_SAME_ROW_BANK_q_2(mh_debug_reg37_reg, same_row_bank_q_2) \
     mh_debug_reg37_reg = (mh_debug_reg37_reg & ~MH_DEBUG_REG37_SAME_ROW_BANK_q_2_MASK) | (same_row_bank_q_2 << MH_DEBUG_REG37_SAME_ROW_BANK_q_2_SHIFT)
#define MH_DEBUG_REG37_SET_ROQ_ADDR_2(mh_debug_reg37_reg, roq_addr_2) \
     mh_debug_reg37_reg = (mh_debug_reg37_reg & ~MH_DEBUG_REG37_ROQ_ADDR_2_MASK) | (roq_addr_2 << MH_DEBUG_REG37_ROQ_ADDR_2_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg37_t {
          unsigned int tc_mh_send                     : MH_DEBUG_REG37_TC_MH_send_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG37_TC_ROQ_RTR_q_SIZE;
          unsigned int roq_mark_q_2                   : MH_DEBUG_REG37_ROQ_MARK_q_2_SIZE;
          unsigned int roq_valid_q_2                  : MH_DEBUG_REG37_ROQ_VALID_q_2_SIZE;
          unsigned int same_row_bank_q_2              : MH_DEBUG_REG37_SAME_ROW_BANK_q_2_SIZE;
          unsigned int roq_addr_2                     : MH_DEBUG_REG37_ROQ_ADDR_2_SIZE;
     } mh_debug_reg37_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg37_t {
          unsigned int roq_addr_2                     : MH_DEBUG_REG37_ROQ_ADDR_2_SIZE;
          unsigned int same_row_bank_q_2              : MH_DEBUG_REG37_SAME_ROW_BANK_q_2_SIZE;
          unsigned int roq_valid_q_2                  : MH_DEBUG_REG37_ROQ_VALID_q_2_SIZE;
          unsigned int roq_mark_q_2                   : MH_DEBUG_REG37_ROQ_MARK_q_2_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG37_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG37_TC_MH_send_SIZE;
     } mh_debug_reg37_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg37_t f;
} mh_debug_reg37_u;


/*
 * MH_DEBUG_REG38 struct
 */

#define MH_DEBUG_REG38_TC_MH_send_SIZE 1
#define MH_DEBUG_REG38_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG38_ROQ_MARK_q_3_SIZE 1
#define MH_DEBUG_REG38_ROQ_VALID_q_3_SIZE 1
#define MH_DEBUG_REG38_SAME_ROW_BANK_q_3_SIZE 1
#define MH_DEBUG_REG38_ROQ_ADDR_3_SIZE 27

#define MH_DEBUG_REG38_TC_MH_send_SHIFT 0
#define MH_DEBUG_REG38_TC_ROQ_RTR_q_SHIFT 1
#define MH_DEBUG_REG38_ROQ_MARK_q_3_SHIFT 2
#define MH_DEBUG_REG38_ROQ_VALID_q_3_SHIFT 3
#define MH_DEBUG_REG38_SAME_ROW_BANK_q_3_SHIFT 4
#define MH_DEBUG_REG38_ROQ_ADDR_3_SHIFT 5

#define MH_DEBUG_REG38_TC_MH_send_MASK 0x00000001
#define MH_DEBUG_REG38_TC_ROQ_RTR_q_MASK 0x00000002
#define MH_DEBUG_REG38_ROQ_MARK_q_3_MASK 0x00000004
#define MH_DEBUG_REG38_ROQ_VALID_q_3_MASK 0x00000008
#define MH_DEBUG_REG38_SAME_ROW_BANK_q_3_MASK 0x00000010
#define MH_DEBUG_REG38_ROQ_ADDR_3_MASK 0xffffffe0

#define MH_DEBUG_REG38_MASK \
     (MH_DEBUG_REG38_TC_MH_send_MASK | \
      MH_DEBUG_REG38_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG38_ROQ_MARK_q_3_MASK | \
      MH_DEBUG_REG38_ROQ_VALID_q_3_MASK | \
      MH_DEBUG_REG38_SAME_ROW_BANK_q_3_MASK | \
      MH_DEBUG_REG38_ROQ_ADDR_3_MASK)

#define MH_DEBUG_REG38(tc_mh_send, tc_roq_rtr_q, roq_mark_q_3, roq_valid_q_3, same_row_bank_q_3, roq_addr_3) \
     ((tc_mh_send << MH_DEBUG_REG38_TC_MH_send_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG38_TC_ROQ_RTR_q_SHIFT) | \
      (roq_mark_q_3 << MH_DEBUG_REG38_ROQ_MARK_q_3_SHIFT) | \
      (roq_valid_q_3 << MH_DEBUG_REG38_ROQ_VALID_q_3_SHIFT) | \
      (same_row_bank_q_3 << MH_DEBUG_REG38_SAME_ROW_BANK_q_3_SHIFT) | \
      (roq_addr_3 << MH_DEBUG_REG38_ROQ_ADDR_3_SHIFT))

#define MH_DEBUG_REG38_GET_TC_MH_send(mh_debug_reg38) \
     ((mh_debug_reg38 & MH_DEBUG_REG38_TC_MH_send_MASK) >> MH_DEBUG_REG38_TC_MH_send_SHIFT)
#define MH_DEBUG_REG38_GET_TC_ROQ_RTR_q(mh_debug_reg38) \
     ((mh_debug_reg38 & MH_DEBUG_REG38_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG38_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG38_GET_ROQ_MARK_q_3(mh_debug_reg38) \
     ((mh_debug_reg38 & MH_DEBUG_REG38_ROQ_MARK_q_3_MASK) >> MH_DEBUG_REG38_ROQ_MARK_q_3_SHIFT)
#define MH_DEBUG_REG38_GET_ROQ_VALID_q_3(mh_debug_reg38) \
     ((mh_debug_reg38 & MH_DEBUG_REG38_ROQ_VALID_q_3_MASK) >> MH_DEBUG_REG38_ROQ_VALID_q_3_SHIFT)
#define MH_DEBUG_REG38_GET_SAME_ROW_BANK_q_3(mh_debug_reg38) \
     ((mh_debug_reg38 & MH_DEBUG_REG38_SAME_ROW_BANK_q_3_MASK) >> MH_DEBUG_REG38_SAME_ROW_BANK_q_3_SHIFT)
#define MH_DEBUG_REG38_GET_ROQ_ADDR_3(mh_debug_reg38) \
     ((mh_debug_reg38 & MH_DEBUG_REG38_ROQ_ADDR_3_MASK) >> MH_DEBUG_REG38_ROQ_ADDR_3_SHIFT)

#define MH_DEBUG_REG38_SET_TC_MH_send(mh_debug_reg38_reg, tc_mh_send) \
     mh_debug_reg38_reg = (mh_debug_reg38_reg & ~MH_DEBUG_REG38_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG38_TC_MH_send_SHIFT)
#define MH_DEBUG_REG38_SET_TC_ROQ_RTR_q(mh_debug_reg38_reg, tc_roq_rtr_q) \
     mh_debug_reg38_reg = (mh_debug_reg38_reg & ~MH_DEBUG_REG38_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG38_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG38_SET_ROQ_MARK_q_3(mh_debug_reg38_reg, roq_mark_q_3) \
     mh_debug_reg38_reg = (mh_debug_reg38_reg & ~MH_DEBUG_REG38_ROQ_MARK_q_3_MASK) | (roq_mark_q_3 << MH_DEBUG_REG38_ROQ_MARK_q_3_SHIFT)
#define MH_DEBUG_REG38_SET_ROQ_VALID_q_3(mh_debug_reg38_reg, roq_valid_q_3) \
     mh_debug_reg38_reg = (mh_debug_reg38_reg & ~MH_DEBUG_REG38_ROQ_VALID_q_3_MASK) | (roq_valid_q_3 << MH_DEBUG_REG38_ROQ_VALID_q_3_SHIFT)
#define MH_DEBUG_REG38_SET_SAME_ROW_BANK_q_3(mh_debug_reg38_reg, same_row_bank_q_3) \
     mh_debug_reg38_reg = (mh_debug_reg38_reg & ~MH_DEBUG_REG38_SAME_ROW_BANK_q_3_MASK) | (same_row_bank_q_3 << MH_DEBUG_REG38_SAME_ROW_BANK_q_3_SHIFT)
#define MH_DEBUG_REG38_SET_ROQ_ADDR_3(mh_debug_reg38_reg, roq_addr_3) \
     mh_debug_reg38_reg = (mh_debug_reg38_reg & ~MH_DEBUG_REG38_ROQ_ADDR_3_MASK) | (roq_addr_3 << MH_DEBUG_REG38_ROQ_ADDR_3_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg38_t {
          unsigned int tc_mh_send                     : MH_DEBUG_REG38_TC_MH_send_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG38_TC_ROQ_RTR_q_SIZE;
          unsigned int roq_mark_q_3                   : MH_DEBUG_REG38_ROQ_MARK_q_3_SIZE;
          unsigned int roq_valid_q_3                  : MH_DEBUG_REG38_ROQ_VALID_q_3_SIZE;
          unsigned int same_row_bank_q_3              : MH_DEBUG_REG38_SAME_ROW_BANK_q_3_SIZE;
          unsigned int roq_addr_3                     : MH_DEBUG_REG38_ROQ_ADDR_3_SIZE;
     } mh_debug_reg38_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg38_t {
          unsigned int roq_addr_3                     : MH_DEBUG_REG38_ROQ_ADDR_3_SIZE;
          unsigned int same_row_bank_q_3              : MH_DEBUG_REG38_SAME_ROW_BANK_q_3_SIZE;
          unsigned int roq_valid_q_3                  : MH_DEBUG_REG38_ROQ_VALID_q_3_SIZE;
          unsigned int roq_mark_q_3                   : MH_DEBUG_REG38_ROQ_MARK_q_3_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG38_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG38_TC_MH_send_SIZE;
     } mh_debug_reg38_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg38_t f;
} mh_debug_reg38_u;


/*
 * MH_DEBUG_REG39 struct
 */

#define MH_DEBUG_REG39_TC_MH_send_SIZE 1
#define MH_DEBUG_REG39_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG39_ROQ_MARK_q_4_SIZE 1
#define MH_DEBUG_REG39_ROQ_VALID_q_4_SIZE 1
#define MH_DEBUG_REG39_SAME_ROW_BANK_q_4_SIZE 1
#define MH_DEBUG_REG39_ROQ_ADDR_4_SIZE 27

#define MH_DEBUG_REG39_TC_MH_send_SHIFT 0
#define MH_DEBUG_REG39_TC_ROQ_RTR_q_SHIFT 1
#define MH_DEBUG_REG39_ROQ_MARK_q_4_SHIFT 2
#define MH_DEBUG_REG39_ROQ_VALID_q_4_SHIFT 3
#define MH_DEBUG_REG39_SAME_ROW_BANK_q_4_SHIFT 4
#define MH_DEBUG_REG39_ROQ_ADDR_4_SHIFT 5

#define MH_DEBUG_REG39_TC_MH_send_MASK 0x00000001
#define MH_DEBUG_REG39_TC_ROQ_RTR_q_MASK 0x00000002
#define MH_DEBUG_REG39_ROQ_MARK_q_4_MASK 0x00000004
#define MH_DEBUG_REG39_ROQ_VALID_q_4_MASK 0x00000008
#define MH_DEBUG_REG39_SAME_ROW_BANK_q_4_MASK 0x00000010
#define MH_DEBUG_REG39_ROQ_ADDR_4_MASK 0xffffffe0

#define MH_DEBUG_REG39_MASK \
     (MH_DEBUG_REG39_TC_MH_send_MASK | \
      MH_DEBUG_REG39_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG39_ROQ_MARK_q_4_MASK | \
      MH_DEBUG_REG39_ROQ_VALID_q_4_MASK | \
      MH_DEBUG_REG39_SAME_ROW_BANK_q_4_MASK | \
      MH_DEBUG_REG39_ROQ_ADDR_4_MASK)

#define MH_DEBUG_REG39(tc_mh_send, tc_roq_rtr_q, roq_mark_q_4, roq_valid_q_4, same_row_bank_q_4, roq_addr_4) \
     ((tc_mh_send << MH_DEBUG_REG39_TC_MH_send_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG39_TC_ROQ_RTR_q_SHIFT) | \
      (roq_mark_q_4 << MH_DEBUG_REG39_ROQ_MARK_q_4_SHIFT) | \
      (roq_valid_q_4 << MH_DEBUG_REG39_ROQ_VALID_q_4_SHIFT) | \
      (same_row_bank_q_4 << MH_DEBUG_REG39_SAME_ROW_BANK_q_4_SHIFT) | \
      (roq_addr_4 << MH_DEBUG_REG39_ROQ_ADDR_4_SHIFT))

#define MH_DEBUG_REG39_GET_TC_MH_send(mh_debug_reg39) \
     ((mh_debug_reg39 & MH_DEBUG_REG39_TC_MH_send_MASK) >> MH_DEBUG_REG39_TC_MH_send_SHIFT)
#define MH_DEBUG_REG39_GET_TC_ROQ_RTR_q(mh_debug_reg39) \
     ((mh_debug_reg39 & MH_DEBUG_REG39_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG39_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG39_GET_ROQ_MARK_q_4(mh_debug_reg39) \
     ((mh_debug_reg39 & MH_DEBUG_REG39_ROQ_MARK_q_4_MASK) >> MH_DEBUG_REG39_ROQ_MARK_q_4_SHIFT)
#define MH_DEBUG_REG39_GET_ROQ_VALID_q_4(mh_debug_reg39) \
     ((mh_debug_reg39 & MH_DEBUG_REG39_ROQ_VALID_q_4_MASK) >> MH_DEBUG_REG39_ROQ_VALID_q_4_SHIFT)
#define MH_DEBUG_REG39_GET_SAME_ROW_BANK_q_4(mh_debug_reg39) \
     ((mh_debug_reg39 & MH_DEBUG_REG39_SAME_ROW_BANK_q_4_MASK) >> MH_DEBUG_REG39_SAME_ROW_BANK_q_4_SHIFT)
#define MH_DEBUG_REG39_GET_ROQ_ADDR_4(mh_debug_reg39) \
     ((mh_debug_reg39 & MH_DEBUG_REG39_ROQ_ADDR_4_MASK) >> MH_DEBUG_REG39_ROQ_ADDR_4_SHIFT)

#define MH_DEBUG_REG39_SET_TC_MH_send(mh_debug_reg39_reg, tc_mh_send) \
     mh_debug_reg39_reg = (mh_debug_reg39_reg & ~MH_DEBUG_REG39_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG39_TC_MH_send_SHIFT)
#define MH_DEBUG_REG39_SET_TC_ROQ_RTR_q(mh_debug_reg39_reg, tc_roq_rtr_q) \
     mh_debug_reg39_reg = (mh_debug_reg39_reg & ~MH_DEBUG_REG39_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG39_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG39_SET_ROQ_MARK_q_4(mh_debug_reg39_reg, roq_mark_q_4) \
     mh_debug_reg39_reg = (mh_debug_reg39_reg & ~MH_DEBUG_REG39_ROQ_MARK_q_4_MASK) | (roq_mark_q_4 << MH_DEBUG_REG39_ROQ_MARK_q_4_SHIFT)
#define MH_DEBUG_REG39_SET_ROQ_VALID_q_4(mh_debug_reg39_reg, roq_valid_q_4) \
     mh_debug_reg39_reg = (mh_debug_reg39_reg & ~MH_DEBUG_REG39_ROQ_VALID_q_4_MASK) | (roq_valid_q_4 << MH_DEBUG_REG39_ROQ_VALID_q_4_SHIFT)
#define MH_DEBUG_REG39_SET_SAME_ROW_BANK_q_4(mh_debug_reg39_reg, same_row_bank_q_4) \
     mh_debug_reg39_reg = (mh_debug_reg39_reg & ~MH_DEBUG_REG39_SAME_ROW_BANK_q_4_MASK) | (same_row_bank_q_4 << MH_DEBUG_REG39_SAME_ROW_BANK_q_4_SHIFT)
#define MH_DEBUG_REG39_SET_ROQ_ADDR_4(mh_debug_reg39_reg, roq_addr_4) \
     mh_debug_reg39_reg = (mh_debug_reg39_reg & ~MH_DEBUG_REG39_ROQ_ADDR_4_MASK) | (roq_addr_4 << MH_DEBUG_REG39_ROQ_ADDR_4_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg39_t {
          unsigned int tc_mh_send                     : MH_DEBUG_REG39_TC_MH_send_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG39_TC_ROQ_RTR_q_SIZE;
          unsigned int roq_mark_q_4                   : MH_DEBUG_REG39_ROQ_MARK_q_4_SIZE;
          unsigned int roq_valid_q_4                  : MH_DEBUG_REG39_ROQ_VALID_q_4_SIZE;
          unsigned int same_row_bank_q_4              : MH_DEBUG_REG39_SAME_ROW_BANK_q_4_SIZE;
          unsigned int roq_addr_4                     : MH_DEBUG_REG39_ROQ_ADDR_4_SIZE;
     } mh_debug_reg39_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg39_t {
          unsigned int roq_addr_4                     : MH_DEBUG_REG39_ROQ_ADDR_4_SIZE;
          unsigned int same_row_bank_q_4              : MH_DEBUG_REG39_SAME_ROW_BANK_q_4_SIZE;
          unsigned int roq_valid_q_4                  : MH_DEBUG_REG39_ROQ_VALID_q_4_SIZE;
          unsigned int roq_mark_q_4                   : MH_DEBUG_REG39_ROQ_MARK_q_4_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG39_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG39_TC_MH_send_SIZE;
     } mh_debug_reg39_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg39_t f;
} mh_debug_reg39_u;


/*
 * MH_DEBUG_REG40 struct
 */

#define MH_DEBUG_REG40_TC_MH_send_SIZE 1
#define MH_DEBUG_REG40_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG40_ROQ_MARK_q_5_SIZE 1
#define MH_DEBUG_REG40_ROQ_VALID_q_5_SIZE 1
#define MH_DEBUG_REG40_SAME_ROW_BANK_q_5_SIZE 1
#define MH_DEBUG_REG40_ROQ_ADDR_5_SIZE 27

#define MH_DEBUG_REG40_TC_MH_send_SHIFT 0
#define MH_DEBUG_REG40_TC_ROQ_RTR_q_SHIFT 1
#define MH_DEBUG_REG40_ROQ_MARK_q_5_SHIFT 2
#define MH_DEBUG_REG40_ROQ_VALID_q_5_SHIFT 3
#define MH_DEBUG_REG40_SAME_ROW_BANK_q_5_SHIFT 4
#define MH_DEBUG_REG40_ROQ_ADDR_5_SHIFT 5

#define MH_DEBUG_REG40_TC_MH_send_MASK 0x00000001
#define MH_DEBUG_REG40_TC_ROQ_RTR_q_MASK 0x00000002
#define MH_DEBUG_REG40_ROQ_MARK_q_5_MASK 0x00000004
#define MH_DEBUG_REG40_ROQ_VALID_q_5_MASK 0x00000008
#define MH_DEBUG_REG40_SAME_ROW_BANK_q_5_MASK 0x00000010
#define MH_DEBUG_REG40_ROQ_ADDR_5_MASK 0xffffffe0

#define MH_DEBUG_REG40_MASK \
     (MH_DEBUG_REG40_TC_MH_send_MASK | \
      MH_DEBUG_REG40_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG40_ROQ_MARK_q_5_MASK | \
      MH_DEBUG_REG40_ROQ_VALID_q_5_MASK | \
      MH_DEBUG_REG40_SAME_ROW_BANK_q_5_MASK | \
      MH_DEBUG_REG40_ROQ_ADDR_5_MASK)

#define MH_DEBUG_REG40(tc_mh_send, tc_roq_rtr_q, roq_mark_q_5, roq_valid_q_5, same_row_bank_q_5, roq_addr_5) \
     ((tc_mh_send << MH_DEBUG_REG40_TC_MH_send_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG40_TC_ROQ_RTR_q_SHIFT) | \
      (roq_mark_q_5 << MH_DEBUG_REG40_ROQ_MARK_q_5_SHIFT) | \
      (roq_valid_q_5 << MH_DEBUG_REG40_ROQ_VALID_q_5_SHIFT) | \
      (same_row_bank_q_5 << MH_DEBUG_REG40_SAME_ROW_BANK_q_5_SHIFT) | \
      (roq_addr_5 << MH_DEBUG_REG40_ROQ_ADDR_5_SHIFT))

#define MH_DEBUG_REG40_GET_TC_MH_send(mh_debug_reg40) \
     ((mh_debug_reg40 & MH_DEBUG_REG40_TC_MH_send_MASK) >> MH_DEBUG_REG40_TC_MH_send_SHIFT)
#define MH_DEBUG_REG40_GET_TC_ROQ_RTR_q(mh_debug_reg40) \
     ((mh_debug_reg40 & MH_DEBUG_REG40_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG40_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG40_GET_ROQ_MARK_q_5(mh_debug_reg40) \
     ((mh_debug_reg40 & MH_DEBUG_REG40_ROQ_MARK_q_5_MASK) >> MH_DEBUG_REG40_ROQ_MARK_q_5_SHIFT)
#define MH_DEBUG_REG40_GET_ROQ_VALID_q_5(mh_debug_reg40) \
     ((mh_debug_reg40 & MH_DEBUG_REG40_ROQ_VALID_q_5_MASK) >> MH_DEBUG_REG40_ROQ_VALID_q_5_SHIFT)
#define MH_DEBUG_REG40_GET_SAME_ROW_BANK_q_5(mh_debug_reg40) \
     ((mh_debug_reg40 & MH_DEBUG_REG40_SAME_ROW_BANK_q_5_MASK) >> MH_DEBUG_REG40_SAME_ROW_BANK_q_5_SHIFT)
#define MH_DEBUG_REG40_GET_ROQ_ADDR_5(mh_debug_reg40) \
     ((mh_debug_reg40 & MH_DEBUG_REG40_ROQ_ADDR_5_MASK) >> MH_DEBUG_REG40_ROQ_ADDR_5_SHIFT)

#define MH_DEBUG_REG40_SET_TC_MH_send(mh_debug_reg40_reg, tc_mh_send) \
     mh_debug_reg40_reg = (mh_debug_reg40_reg & ~MH_DEBUG_REG40_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG40_TC_MH_send_SHIFT)
#define MH_DEBUG_REG40_SET_TC_ROQ_RTR_q(mh_debug_reg40_reg, tc_roq_rtr_q) \
     mh_debug_reg40_reg = (mh_debug_reg40_reg & ~MH_DEBUG_REG40_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG40_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG40_SET_ROQ_MARK_q_5(mh_debug_reg40_reg, roq_mark_q_5) \
     mh_debug_reg40_reg = (mh_debug_reg40_reg & ~MH_DEBUG_REG40_ROQ_MARK_q_5_MASK) | (roq_mark_q_5 << MH_DEBUG_REG40_ROQ_MARK_q_5_SHIFT)
#define MH_DEBUG_REG40_SET_ROQ_VALID_q_5(mh_debug_reg40_reg, roq_valid_q_5) \
     mh_debug_reg40_reg = (mh_debug_reg40_reg & ~MH_DEBUG_REG40_ROQ_VALID_q_5_MASK) | (roq_valid_q_5 << MH_DEBUG_REG40_ROQ_VALID_q_5_SHIFT)
#define MH_DEBUG_REG40_SET_SAME_ROW_BANK_q_5(mh_debug_reg40_reg, same_row_bank_q_5) \
     mh_debug_reg40_reg = (mh_debug_reg40_reg & ~MH_DEBUG_REG40_SAME_ROW_BANK_q_5_MASK) | (same_row_bank_q_5 << MH_DEBUG_REG40_SAME_ROW_BANK_q_5_SHIFT)
#define MH_DEBUG_REG40_SET_ROQ_ADDR_5(mh_debug_reg40_reg, roq_addr_5) \
     mh_debug_reg40_reg = (mh_debug_reg40_reg & ~MH_DEBUG_REG40_ROQ_ADDR_5_MASK) | (roq_addr_5 << MH_DEBUG_REG40_ROQ_ADDR_5_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg40_t {
          unsigned int tc_mh_send                     : MH_DEBUG_REG40_TC_MH_send_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG40_TC_ROQ_RTR_q_SIZE;
          unsigned int roq_mark_q_5                   : MH_DEBUG_REG40_ROQ_MARK_q_5_SIZE;
          unsigned int roq_valid_q_5                  : MH_DEBUG_REG40_ROQ_VALID_q_5_SIZE;
          unsigned int same_row_bank_q_5              : MH_DEBUG_REG40_SAME_ROW_BANK_q_5_SIZE;
          unsigned int roq_addr_5                     : MH_DEBUG_REG40_ROQ_ADDR_5_SIZE;
     } mh_debug_reg40_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg40_t {
          unsigned int roq_addr_5                     : MH_DEBUG_REG40_ROQ_ADDR_5_SIZE;
          unsigned int same_row_bank_q_5              : MH_DEBUG_REG40_SAME_ROW_BANK_q_5_SIZE;
          unsigned int roq_valid_q_5                  : MH_DEBUG_REG40_ROQ_VALID_q_5_SIZE;
          unsigned int roq_mark_q_5                   : MH_DEBUG_REG40_ROQ_MARK_q_5_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG40_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG40_TC_MH_send_SIZE;
     } mh_debug_reg40_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg40_t f;
} mh_debug_reg40_u;


/*
 * MH_DEBUG_REG41 struct
 */

#define MH_DEBUG_REG41_TC_MH_send_SIZE 1
#define MH_DEBUG_REG41_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG41_ROQ_MARK_q_6_SIZE 1
#define MH_DEBUG_REG41_ROQ_VALID_q_6_SIZE 1
#define MH_DEBUG_REG41_SAME_ROW_BANK_q_6_SIZE 1
#define MH_DEBUG_REG41_ROQ_ADDR_6_SIZE 27

#define MH_DEBUG_REG41_TC_MH_send_SHIFT 0
#define MH_DEBUG_REG41_TC_ROQ_RTR_q_SHIFT 1
#define MH_DEBUG_REG41_ROQ_MARK_q_6_SHIFT 2
#define MH_DEBUG_REG41_ROQ_VALID_q_6_SHIFT 3
#define MH_DEBUG_REG41_SAME_ROW_BANK_q_6_SHIFT 4
#define MH_DEBUG_REG41_ROQ_ADDR_6_SHIFT 5

#define MH_DEBUG_REG41_TC_MH_send_MASK 0x00000001
#define MH_DEBUG_REG41_TC_ROQ_RTR_q_MASK 0x00000002
#define MH_DEBUG_REG41_ROQ_MARK_q_6_MASK 0x00000004
#define MH_DEBUG_REG41_ROQ_VALID_q_6_MASK 0x00000008
#define MH_DEBUG_REG41_SAME_ROW_BANK_q_6_MASK 0x00000010
#define MH_DEBUG_REG41_ROQ_ADDR_6_MASK 0xffffffe0

#define MH_DEBUG_REG41_MASK \
     (MH_DEBUG_REG41_TC_MH_send_MASK | \
      MH_DEBUG_REG41_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG41_ROQ_MARK_q_6_MASK | \
      MH_DEBUG_REG41_ROQ_VALID_q_6_MASK | \
      MH_DEBUG_REG41_SAME_ROW_BANK_q_6_MASK | \
      MH_DEBUG_REG41_ROQ_ADDR_6_MASK)

#define MH_DEBUG_REG41(tc_mh_send, tc_roq_rtr_q, roq_mark_q_6, roq_valid_q_6, same_row_bank_q_6, roq_addr_6) \
     ((tc_mh_send << MH_DEBUG_REG41_TC_MH_send_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG41_TC_ROQ_RTR_q_SHIFT) | \
      (roq_mark_q_6 << MH_DEBUG_REG41_ROQ_MARK_q_6_SHIFT) | \
      (roq_valid_q_6 << MH_DEBUG_REG41_ROQ_VALID_q_6_SHIFT) | \
      (same_row_bank_q_6 << MH_DEBUG_REG41_SAME_ROW_BANK_q_6_SHIFT) | \
      (roq_addr_6 << MH_DEBUG_REG41_ROQ_ADDR_6_SHIFT))

#define MH_DEBUG_REG41_GET_TC_MH_send(mh_debug_reg41) \
     ((mh_debug_reg41 & MH_DEBUG_REG41_TC_MH_send_MASK) >> MH_DEBUG_REG41_TC_MH_send_SHIFT)
#define MH_DEBUG_REG41_GET_TC_ROQ_RTR_q(mh_debug_reg41) \
     ((mh_debug_reg41 & MH_DEBUG_REG41_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG41_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG41_GET_ROQ_MARK_q_6(mh_debug_reg41) \
     ((mh_debug_reg41 & MH_DEBUG_REG41_ROQ_MARK_q_6_MASK) >> MH_DEBUG_REG41_ROQ_MARK_q_6_SHIFT)
#define MH_DEBUG_REG41_GET_ROQ_VALID_q_6(mh_debug_reg41) \
     ((mh_debug_reg41 & MH_DEBUG_REG41_ROQ_VALID_q_6_MASK) >> MH_DEBUG_REG41_ROQ_VALID_q_6_SHIFT)
#define MH_DEBUG_REG41_GET_SAME_ROW_BANK_q_6(mh_debug_reg41) \
     ((mh_debug_reg41 & MH_DEBUG_REG41_SAME_ROW_BANK_q_6_MASK) >> MH_DEBUG_REG41_SAME_ROW_BANK_q_6_SHIFT)
#define MH_DEBUG_REG41_GET_ROQ_ADDR_6(mh_debug_reg41) \
     ((mh_debug_reg41 & MH_DEBUG_REG41_ROQ_ADDR_6_MASK) >> MH_DEBUG_REG41_ROQ_ADDR_6_SHIFT)

#define MH_DEBUG_REG41_SET_TC_MH_send(mh_debug_reg41_reg, tc_mh_send) \
     mh_debug_reg41_reg = (mh_debug_reg41_reg & ~MH_DEBUG_REG41_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG41_TC_MH_send_SHIFT)
#define MH_DEBUG_REG41_SET_TC_ROQ_RTR_q(mh_debug_reg41_reg, tc_roq_rtr_q) \
     mh_debug_reg41_reg = (mh_debug_reg41_reg & ~MH_DEBUG_REG41_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG41_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG41_SET_ROQ_MARK_q_6(mh_debug_reg41_reg, roq_mark_q_6) \
     mh_debug_reg41_reg = (mh_debug_reg41_reg & ~MH_DEBUG_REG41_ROQ_MARK_q_6_MASK) | (roq_mark_q_6 << MH_DEBUG_REG41_ROQ_MARK_q_6_SHIFT)
#define MH_DEBUG_REG41_SET_ROQ_VALID_q_6(mh_debug_reg41_reg, roq_valid_q_6) \
     mh_debug_reg41_reg = (mh_debug_reg41_reg & ~MH_DEBUG_REG41_ROQ_VALID_q_6_MASK) | (roq_valid_q_6 << MH_DEBUG_REG41_ROQ_VALID_q_6_SHIFT)
#define MH_DEBUG_REG41_SET_SAME_ROW_BANK_q_6(mh_debug_reg41_reg, same_row_bank_q_6) \
     mh_debug_reg41_reg = (mh_debug_reg41_reg & ~MH_DEBUG_REG41_SAME_ROW_BANK_q_6_MASK) | (same_row_bank_q_6 << MH_DEBUG_REG41_SAME_ROW_BANK_q_6_SHIFT)
#define MH_DEBUG_REG41_SET_ROQ_ADDR_6(mh_debug_reg41_reg, roq_addr_6) \
     mh_debug_reg41_reg = (mh_debug_reg41_reg & ~MH_DEBUG_REG41_ROQ_ADDR_6_MASK) | (roq_addr_6 << MH_DEBUG_REG41_ROQ_ADDR_6_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg41_t {
          unsigned int tc_mh_send                     : MH_DEBUG_REG41_TC_MH_send_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG41_TC_ROQ_RTR_q_SIZE;
          unsigned int roq_mark_q_6                   : MH_DEBUG_REG41_ROQ_MARK_q_6_SIZE;
          unsigned int roq_valid_q_6                  : MH_DEBUG_REG41_ROQ_VALID_q_6_SIZE;
          unsigned int same_row_bank_q_6              : MH_DEBUG_REG41_SAME_ROW_BANK_q_6_SIZE;
          unsigned int roq_addr_6                     : MH_DEBUG_REG41_ROQ_ADDR_6_SIZE;
     } mh_debug_reg41_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg41_t {
          unsigned int roq_addr_6                     : MH_DEBUG_REG41_ROQ_ADDR_6_SIZE;
          unsigned int same_row_bank_q_6              : MH_DEBUG_REG41_SAME_ROW_BANK_q_6_SIZE;
          unsigned int roq_valid_q_6                  : MH_DEBUG_REG41_ROQ_VALID_q_6_SIZE;
          unsigned int roq_mark_q_6                   : MH_DEBUG_REG41_ROQ_MARK_q_6_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG41_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG41_TC_MH_send_SIZE;
     } mh_debug_reg41_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg41_t f;
} mh_debug_reg41_u;


/*
 * MH_DEBUG_REG42 struct
 */

#define MH_DEBUG_REG42_TC_MH_send_SIZE 1
#define MH_DEBUG_REG42_TC_ROQ_RTR_q_SIZE 1
#define MH_DEBUG_REG42_ROQ_MARK_q_7_SIZE 1
#define MH_DEBUG_REG42_ROQ_VALID_q_7_SIZE 1
#define MH_DEBUG_REG42_SAME_ROW_BANK_q_7_SIZE 1
#define MH_DEBUG_REG42_ROQ_ADDR_7_SIZE 27

#define MH_DEBUG_REG42_TC_MH_send_SHIFT 0
#define MH_DEBUG_REG42_TC_ROQ_RTR_q_SHIFT 1
#define MH_DEBUG_REG42_ROQ_MARK_q_7_SHIFT 2
#define MH_DEBUG_REG42_ROQ_VALID_q_7_SHIFT 3
#define MH_DEBUG_REG42_SAME_ROW_BANK_q_7_SHIFT 4
#define MH_DEBUG_REG42_ROQ_ADDR_7_SHIFT 5

#define MH_DEBUG_REG42_TC_MH_send_MASK 0x00000001
#define MH_DEBUG_REG42_TC_ROQ_RTR_q_MASK 0x00000002
#define MH_DEBUG_REG42_ROQ_MARK_q_7_MASK 0x00000004
#define MH_DEBUG_REG42_ROQ_VALID_q_7_MASK 0x00000008
#define MH_DEBUG_REG42_SAME_ROW_BANK_q_7_MASK 0x00000010
#define MH_DEBUG_REG42_ROQ_ADDR_7_MASK 0xffffffe0

#define MH_DEBUG_REG42_MASK \
     (MH_DEBUG_REG42_TC_MH_send_MASK | \
      MH_DEBUG_REG42_TC_ROQ_RTR_q_MASK | \
      MH_DEBUG_REG42_ROQ_MARK_q_7_MASK | \
      MH_DEBUG_REG42_ROQ_VALID_q_7_MASK | \
      MH_DEBUG_REG42_SAME_ROW_BANK_q_7_MASK | \
      MH_DEBUG_REG42_ROQ_ADDR_7_MASK)

#define MH_DEBUG_REG42(tc_mh_send, tc_roq_rtr_q, roq_mark_q_7, roq_valid_q_7, same_row_bank_q_7, roq_addr_7) \
     ((tc_mh_send << MH_DEBUG_REG42_TC_MH_send_SHIFT) | \
      (tc_roq_rtr_q << MH_DEBUG_REG42_TC_ROQ_RTR_q_SHIFT) | \
      (roq_mark_q_7 << MH_DEBUG_REG42_ROQ_MARK_q_7_SHIFT) | \
      (roq_valid_q_7 << MH_DEBUG_REG42_ROQ_VALID_q_7_SHIFT) | \
      (same_row_bank_q_7 << MH_DEBUG_REG42_SAME_ROW_BANK_q_7_SHIFT) | \
      (roq_addr_7 << MH_DEBUG_REG42_ROQ_ADDR_7_SHIFT))

#define MH_DEBUG_REG42_GET_TC_MH_send(mh_debug_reg42) \
     ((mh_debug_reg42 & MH_DEBUG_REG42_TC_MH_send_MASK) >> MH_DEBUG_REG42_TC_MH_send_SHIFT)
#define MH_DEBUG_REG42_GET_TC_ROQ_RTR_q(mh_debug_reg42) \
     ((mh_debug_reg42 & MH_DEBUG_REG42_TC_ROQ_RTR_q_MASK) >> MH_DEBUG_REG42_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG42_GET_ROQ_MARK_q_7(mh_debug_reg42) \
     ((mh_debug_reg42 & MH_DEBUG_REG42_ROQ_MARK_q_7_MASK) >> MH_DEBUG_REG42_ROQ_MARK_q_7_SHIFT)
#define MH_DEBUG_REG42_GET_ROQ_VALID_q_7(mh_debug_reg42) \
     ((mh_debug_reg42 & MH_DEBUG_REG42_ROQ_VALID_q_7_MASK) >> MH_DEBUG_REG42_ROQ_VALID_q_7_SHIFT)
#define MH_DEBUG_REG42_GET_SAME_ROW_BANK_q_7(mh_debug_reg42) \
     ((mh_debug_reg42 & MH_DEBUG_REG42_SAME_ROW_BANK_q_7_MASK) >> MH_DEBUG_REG42_SAME_ROW_BANK_q_7_SHIFT)
#define MH_DEBUG_REG42_GET_ROQ_ADDR_7(mh_debug_reg42) \
     ((mh_debug_reg42 & MH_DEBUG_REG42_ROQ_ADDR_7_MASK) >> MH_DEBUG_REG42_ROQ_ADDR_7_SHIFT)

#define MH_DEBUG_REG42_SET_TC_MH_send(mh_debug_reg42_reg, tc_mh_send) \
     mh_debug_reg42_reg = (mh_debug_reg42_reg & ~MH_DEBUG_REG42_TC_MH_send_MASK) | (tc_mh_send << MH_DEBUG_REG42_TC_MH_send_SHIFT)
#define MH_DEBUG_REG42_SET_TC_ROQ_RTR_q(mh_debug_reg42_reg, tc_roq_rtr_q) \
     mh_debug_reg42_reg = (mh_debug_reg42_reg & ~MH_DEBUG_REG42_TC_ROQ_RTR_q_MASK) | (tc_roq_rtr_q << MH_DEBUG_REG42_TC_ROQ_RTR_q_SHIFT)
#define MH_DEBUG_REG42_SET_ROQ_MARK_q_7(mh_debug_reg42_reg, roq_mark_q_7) \
     mh_debug_reg42_reg = (mh_debug_reg42_reg & ~MH_DEBUG_REG42_ROQ_MARK_q_7_MASK) | (roq_mark_q_7 << MH_DEBUG_REG42_ROQ_MARK_q_7_SHIFT)
#define MH_DEBUG_REG42_SET_ROQ_VALID_q_7(mh_debug_reg42_reg, roq_valid_q_7) \
     mh_debug_reg42_reg = (mh_debug_reg42_reg & ~MH_DEBUG_REG42_ROQ_VALID_q_7_MASK) | (roq_valid_q_7 << MH_DEBUG_REG42_ROQ_VALID_q_7_SHIFT)
#define MH_DEBUG_REG42_SET_SAME_ROW_BANK_q_7(mh_debug_reg42_reg, same_row_bank_q_7) \
     mh_debug_reg42_reg = (mh_debug_reg42_reg & ~MH_DEBUG_REG42_SAME_ROW_BANK_q_7_MASK) | (same_row_bank_q_7 << MH_DEBUG_REG42_SAME_ROW_BANK_q_7_SHIFT)
#define MH_DEBUG_REG42_SET_ROQ_ADDR_7(mh_debug_reg42_reg, roq_addr_7) \
     mh_debug_reg42_reg = (mh_debug_reg42_reg & ~MH_DEBUG_REG42_ROQ_ADDR_7_MASK) | (roq_addr_7 << MH_DEBUG_REG42_ROQ_ADDR_7_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg42_t {
          unsigned int tc_mh_send                     : MH_DEBUG_REG42_TC_MH_send_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG42_TC_ROQ_RTR_q_SIZE;
          unsigned int roq_mark_q_7                   : MH_DEBUG_REG42_ROQ_MARK_q_7_SIZE;
          unsigned int roq_valid_q_7                  : MH_DEBUG_REG42_ROQ_VALID_q_7_SIZE;
          unsigned int same_row_bank_q_7              : MH_DEBUG_REG42_SAME_ROW_BANK_q_7_SIZE;
          unsigned int roq_addr_7                     : MH_DEBUG_REG42_ROQ_ADDR_7_SIZE;
     } mh_debug_reg42_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg42_t {
          unsigned int roq_addr_7                     : MH_DEBUG_REG42_ROQ_ADDR_7_SIZE;
          unsigned int same_row_bank_q_7              : MH_DEBUG_REG42_SAME_ROW_BANK_q_7_SIZE;
          unsigned int roq_valid_q_7                  : MH_DEBUG_REG42_ROQ_VALID_q_7_SIZE;
          unsigned int roq_mark_q_7                   : MH_DEBUG_REG42_ROQ_MARK_q_7_SIZE;
          unsigned int tc_roq_rtr_q                   : MH_DEBUG_REG42_TC_ROQ_RTR_q_SIZE;
          unsigned int tc_mh_send                     : MH_DEBUG_REG42_TC_MH_send_SIZE;
     } mh_debug_reg42_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg42_t f;
} mh_debug_reg42_u;


/*
 * MH_DEBUG_REG43 struct
 */

#define MH_DEBUG_REG43_ARB_REG_WE_q_SIZE 1
#define MH_DEBUG_REG43_ARB_WE_SIZE     1
#define MH_DEBUG_REG43_ARB_REG_VALID_q_SIZE 1
#define MH_DEBUG_REG43_ARB_RTR_q_SIZE  1
#define MH_DEBUG_REG43_ARB_REG_RTR_SIZE 1
#define MH_DEBUG_REG43_WDAT_BURST_RTR_SIZE 1
#define MH_DEBUG_REG43_MMU_RTR_SIZE    1
#define MH_DEBUG_REG43_ARB_ID_q_SIZE   3
#define MH_DEBUG_REG43_ARB_WRITE_q_SIZE 1
#define MH_DEBUG_REG43_ARB_BLEN_q_SIZE 1
#define MH_DEBUG_REG43_ARQ_CTRL_EMPTY_SIZE 1
#define MH_DEBUG_REG43_ARQ_FIFO_CNT_q_SIZE 3
#define MH_DEBUG_REG43_MMU_WE_SIZE     1
#define MH_DEBUG_REG43_ARQ_RTR_SIZE    1
#define MH_DEBUG_REG43_MMU_ID_SIZE     3
#define MH_DEBUG_REG43_MMU_WRITE_SIZE  1
#define MH_DEBUG_REG43_MMU_BLEN_SIZE   1
#define MH_DEBUG_REG43_WBURST_IP_q_SIZE 1
#define MH_DEBUG_REG43_WDAT_REG_WE_q_SIZE 1
#define MH_DEBUG_REG43_WDB_WE_SIZE     1
#define MH_DEBUG_REG43_WDB_RTR_SKID_4_SIZE 1
#define MH_DEBUG_REG43_WDB_RTR_SKID_3_SIZE 1

#define MH_DEBUG_REG43_ARB_REG_WE_q_SHIFT 0
#define MH_DEBUG_REG43_ARB_WE_SHIFT    1
#define MH_DEBUG_REG43_ARB_REG_VALID_q_SHIFT 2
#define MH_DEBUG_REG43_ARB_RTR_q_SHIFT 3
#define MH_DEBUG_REG43_ARB_REG_RTR_SHIFT 4
#define MH_DEBUG_REG43_WDAT_BURST_RTR_SHIFT 5
#define MH_DEBUG_REG43_MMU_RTR_SHIFT   6
#define MH_DEBUG_REG43_ARB_ID_q_SHIFT  7
#define MH_DEBUG_REG43_ARB_WRITE_q_SHIFT 10
#define MH_DEBUG_REG43_ARB_BLEN_q_SHIFT 11
#define MH_DEBUG_REG43_ARQ_CTRL_EMPTY_SHIFT 12
#define MH_DEBUG_REG43_ARQ_FIFO_CNT_q_SHIFT 13
#define MH_DEBUG_REG43_MMU_WE_SHIFT    16
#define MH_DEBUG_REG43_ARQ_RTR_SHIFT   17
#define MH_DEBUG_REG43_MMU_ID_SHIFT    18
#define MH_DEBUG_REG43_MMU_WRITE_SHIFT 21
#define MH_DEBUG_REG43_MMU_BLEN_SHIFT  22
#define MH_DEBUG_REG43_WBURST_IP_q_SHIFT 23
#define MH_DEBUG_REG43_WDAT_REG_WE_q_SHIFT 24
#define MH_DEBUG_REG43_WDB_WE_SHIFT    25
#define MH_DEBUG_REG43_WDB_RTR_SKID_4_SHIFT 26
#define MH_DEBUG_REG43_WDB_RTR_SKID_3_SHIFT 27

#define MH_DEBUG_REG43_ARB_REG_WE_q_MASK 0x00000001
#define MH_DEBUG_REG43_ARB_WE_MASK     0x00000002
#define MH_DEBUG_REG43_ARB_REG_VALID_q_MASK 0x00000004
#define MH_DEBUG_REG43_ARB_RTR_q_MASK  0x00000008
#define MH_DEBUG_REG43_ARB_REG_RTR_MASK 0x00000010
#define MH_DEBUG_REG43_WDAT_BURST_RTR_MASK 0x00000020
#define MH_DEBUG_REG43_MMU_RTR_MASK    0x00000040
#define MH_DEBUG_REG43_ARB_ID_q_MASK   0x00000380
#define MH_DEBUG_REG43_ARB_WRITE_q_MASK 0x00000400
#define MH_DEBUG_REG43_ARB_BLEN_q_MASK 0x00000800
#define MH_DEBUG_REG43_ARQ_CTRL_EMPTY_MASK 0x00001000
#define MH_DEBUG_REG43_ARQ_FIFO_CNT_q_MASK 0x0000e000
#define MH_DEBUG_REG43_MMU_WE_MASK     0x00010000
#define MH_DEBUG_REG43_ARQ_RTR_MASK    0x00020000
#define MH_DEBUG_REG43_MMU_ID_MASK     0x001c0000
#define MH_DEBUG_REG43_MMU_WRITE_MASK  0x00200000
#define MH_DEBUG_REG43_MMU_BLEN_MASK   0x00400000
#define MH_DEBUG_REG43_WBURST_IP_q_MASK 0x00800000
#define MH_DEBUG_REG43_WDAT_REG_WE_q_MASK 0x01000000
#define MH_DEBUG_REG43_WDB_WE_MASK     0x02000000
#define MH_DEBUG_REG43_WDB_RTR_SKID_4_MASK 0x04000000
#define MH_DEBUG_REG43_WDB_RTR_SKID_3_MASK 0x08000000

#define MH_DEBUG_REG43_MASK \
     (MH_DEBUG_REG43_ARB_REG_WE_q_MASK | \
      MH_DEBUG_REG43_ARB_WE_MASK | \
      MH_DEBUG_REG43_ARB_REG_VALID_q_MASK | \
      MH_DEBUG_REG43_ARB_RTR_q_MASK | \
      MH_DEBUG_REG43_ARB_REG_RTR_MASK | \
      MH_DEBUG_REG43_WDAT_BURST_RTR_MASK | \
      MH_DEBUG_REG43_MMU_RTR_MASK | \
      MH_DEBUG_REG43_ARB_ID_q_MASK | \
      MH_DEBUG_REG43_ARB_WRITE_q_MASK | \
      MH_DEBUG_REG43_ARB_BLEN_q_MASK | \
      MH_DEBUG_REG43_ARQ_CTRL_EMPTY_MASK | \
      MH_DEBUG_REG43_ARQ_FIFO_CNT_q_MASK | \
      MH_DEBUG_REG43_MMU_WE_MASK | \
      MH_DEBUG_REG43_ARQ_RTR_MASK | \
      MH_DEBUG_REG43_MMU_ID_MASK | \
      MH_DEBUG_REG43_MMU_WRITE_MASK | \
      MH_DEBUG_REG43_MMU_BLEN_MASK | \
      MH_DEBUG_REG43_WBURST_IP_q_MASK | \
      MH_DEBUG_REG43_WDAT_REG_WE_q_MASK | \
      MH_DEBUG_REG43_WDB_WE_MASK | \
      MH_DEBUG_REG43_WDB_RTR_SKID_4_MASK | \
      MH_DEBUG_REG43_WDB_RTR_SKID_3_MASK)

#define MH_DEBUG_REG43(arb_reg_we_q, arb_we, arb_reg_valid_q, arb_rtr_q, arb_reg_rtr, wdat_burst_rtr, mmu_rtr, arb_id_q, arb_write_q, arb_blen_q, arq_ctrl_empty, arq_fifo_cnt_q, mmu_we, arq_rtr, mmu_id, mmu_write, mmu_blen, wburst_ip_q, wdat_reg_we_q, wdb_we, wdb_rtr_skid_4, wdb_rtr_skid_3) \
     ((arb_reg_we_q << MH_DEBUG_REG43_ARB_REG_WE_q_SHIFT) | \
      (arb_we << MH_DEBUG_REG43_ARB_WE_SHIFT) | \
      (arb_reg_valid_q << MH_DEBUG_REG43_ARB_REG_VALID_q_SHIFT) | \
      (arb_rtr_q << MH_DEBUG_REG43_ARB_RTR_q_SHIFT) | \
      (arb_reg_rtr << MH_DEBUG_REG43_ARB_REG_RTR_SHIFT) | \
      (wdat_burst_rtr << MH_DEBUG_REG43_WDAT_BURST_RTR_SHIFT) | \
      (mmu_rtr << MH_DEBUG_REG43_MMU_RTR_SHIFT) | \
      (arb_id_q << MH_DEBUG_REG43_ARB_ID_q_SHIFT) | \
      (arb_write_q << MH_DEBUG_REG43_ARB_WRITE_q_SHIFT) | \
      (arb_blen_q << MH_DEBUG_REG43_ARB_BLEN_q_SHIFT) | \
      (arq_ctrl_empty << MH_DEBUG_REG43_ARQ_CTRL_EMPTY_SHIFT) | \
      (arq_fifo_cnt_q << MH_DEBUG_REG43_ARQ_FIFO_CNT_q_SHIFT) | \
      (mmu_we << MH_DEBUG_REG43_MMU_WE_SHIFT) | \
      (arq_rtr << MH_DEBUG_REG43_ARQ_RTR_SHIFT) | \
      (mmu_id << MH_DEBUG_REG43_MMU_ID_SHIFT) | \
      (mmu_write << MH_DEBUG_REG43_MMU_WRITE_SHIFT) | \
      (mmu_blen << MH_DEBUG_REG43_MMU_BLEN_SHIFT) | \
      (wburst_ip_q << MH_DEBUG_REG43_WBURST_IP_q_SHIFT) | \
      (wdat_reg_we_q << MH_DEBUG_REG43_WDAT_REG_WE_q_SHIFT) | \
      (wdb_we << MH_DEBUG_REG43_WDB_WE_SHIFT) | \
      (wdb_rtr_skid_4 << MH_DEBUG_REG43_WDB_RTR_SKID_4_SHIFT) | \
      (wdb_rtr_skid_3 << MH_DEBUG_REG43_WDB_RTR_SKID_3_SHIFT))

#define MH_DEBUG_REG43_GET_ARB_REG_WE_q(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARB_REG_WE_q_MASK) >> MH_DEBUG_REG43_ARB_REG_WE_q_SHIFT)
#define MH_DEBUG_REG43_GET_ARB_WE(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARB_WE_MASK) >> MH_DEBUG_REG43_ARB_WE_SHIFT)
#define MH_DEBUG_REG43_GET_ARB_REG_VALID_q(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARB_REG_VALID_q_MASK) >> MH_DEBUG_REG43_ARB_REG_VALID_q_SHIFT)
#define MH_DEBUG_REG43_GET_ARB_RTR_q(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARB_RTR_q_MASK) >> MH_DEBUG_REG43_ARB_RTR_q_SHIFT)
#define MH_DEBUG_REG43_GET_ARB_REG_RTR(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARB_REG_RTR_MASK) >> MH_DEBUG_REG43_ARB_REG_RTR_SHIFT)
#define MH_DEBUG_REG43_GET_WDAT_BURST_RTR(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_WDAT_BURST_RTR_MASK) >> MH_DEBUG_REG43_WDAT_BURST_RTR_SHIFT)
#define MH_DEBUG_REG43_GET_MMU_RTR(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_MMU_RTR_MASK) >> MH_DEBUG_REG43_MMU_RTR_SHIFT)
#define MH_DEBUG_REG43_GET_ARB_ID_q(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARB_ID_q_MASK) >> MH_DEBUG_REG43_ARB_ID_q_SHIFT)
#define MH_DEBUG_REG43_GET_ARB_WRITE_q(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARB_WRITE_q_MASK) >> MH_DEBUG_REG43_ARB_WRITE_q_SHIFT)
#define MH_DEBUG_REG43_GET_ARB_BLEN_q(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARB_BLEN_q_MASK) >> MH_DEBUG_REG43_ARB_BLEN_q_SHIFT)
#define MH_DEBUG_REG43_GET_ARQ_CTRL_EMPTY(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARQ_CTRL_EMPTY_MASK) >> MH_DEBUG_REG43_ARQ_CTRL_EMPTY_SHIFT)
#define MH_DEBUG_REG43_GET_ARQ_FIFO_CNT_q(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARQ_FIFO_CNT_q_MASK) >> MH_DEBUG_REG43_ARQ_FIFO_CNT_q_SHIFT)
#define MH_DEBUG_REG43_GET_MMU_WE(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_MMU_WE_MASK) >> MH_DEBUG_REG43_MMU_WE_SHIFT)
#define MH_DEBUG_REG43_GET_ARQ_RTR(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_ARQ_RTR_MASK) >> MH_DEBUG_REG43_ARQ_RTR_SHIFT)
#define MH_DEBUG_REG43_GET_MMU_ID(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_MMU_ID_MASK) >> MH_DEBUG_REG43_MMU_ID_SHIFT)
#define MH_DEBUG_REG43_GET_MMU_WRITE(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_MMU_WRITE_MASK) >> MH_DEBUG_REG43_MMU_WRITE_SHIFT)
#define MH_DEBUG_REG43_GET_MMU_BLEN(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_MMU_BLEN_MASK) >> MH_DEBUG_REG43_MMU_BLEN_SHIFT)
#define MH_DEBUG_REG43_GET_WBURST_IP_q(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_WBURST_IP_q_MASK) >> MH_DEBUG_REG43_WBURST_IP_q_SHIFT)
#define MH_DEBUG_REG43_GET_WDAT_REG_WE_q(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_WDAT_REG_WE_q_MASK) >> MH_DEBUG_REG43_WDAT_REG_WE_q_SHIFT)
#define MH_DEBUG_REG43_GET_WDB_WE(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_WDB_WE_MASK) >> MH_DEBUG_REG43_WDB_WE_SHIFT)
#define MH_DEBUG_REG43_GET_WDB_RTR_SKID_4(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_WDB_RTR_SKID_4_MASK) >> MH_DEBUG_REG43_WDB_RTR_SKID_4_SHIFT)
#define MH_DEBUG_REG43_GET_WDB_RTR_SKID_3(mh_debug_reg43) \
     ((mh_debug_reg43 & MH_DEBUG_REG43_WDB_RTR_SKID_3_MASK) >> MH_DEBUG_REG43_WDB_RTR_SKID_3_SHIFT)

#define MH_DEBUG_REG43_SET_ARB_REG_WE_q(mh_debug_reg43_reg, arb_reg_we_q) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARB_REG_WE_q_MASK) | (arb_reg_we_q << MH_DEBUG_REG43_ARB_REG_WE_q_SHIFT)
#define MH_DEBUG_REG43_SET_ARB_WE(mh_debug_reg43_reg, arb_we) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARB_WE_MASK) | (arb_we << MH_DEBUG_REG43_ARB_WE_SHIFT)
#define MH_DEBUG_REG43_SET_ARB_REG_VALID_q(mh_debug_reg43_reg, arb_reg_valid_q) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARB_REG_VALID_q_MASK) | (arb_reg_valid_q << MH_DEBUG_REG43_ARB_REG_VALID_q_SHIFT)
#define MH_DEBUG_REG43_SET_ARB_RTR_q(mh_debug_reg43_reg, arb_rtr_q) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARB_RTR_q_MASK) | (arb_rtr_q << MH_DEBUG_REG43_ARB_RTR_q_SHIFT)
#define MH_DEBUG_REG43_SET_ARB_REG_RTR(mh_debug_reg43_reg, arb_reg_rtr) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARB_REG_RTR_MASK) | (arb_reg_rtr << MH_DEBUG_REG43_ARB_REG_RTR_SHIFT)
#define MH_DEBUG_REG43_SET_WDAT_BURST_RTR(mh_debug_reg43_reg, wdat_burst_rtr) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_WDAT_BURST_RTR_MASK) | (wdat_burst_rtr << MH_DEBUG_REG43_WDAT_BURST_RTR_SHIFT)
#define MH_DEBUG_REG43_SET_MMU_RTR(mh_debug_reg43_reg, mmu_rtr) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_MMU_RTR_MASK) | (mmu_rtr << MH_DEBUG_REG43_MMU_RTR_SHIFT)
#define MH_DEBUG_REG43_SET_ARB_ID_q(mh_debug_reg43_reg, arb_id_q) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARB_ID_q_MASK) | (arb_id_q << MH_DEBUG_REG43_ARB_ID_q_SHIFT)
#define MH_DEBUG_REG43_SET_ARB_WRITE_q(mh_debug_reg43_reg, arb_write_q) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARB_WRITE_q_MASK) | (arb_write_q << MH_DEBUG_REG43_ARB_WRITE_q_SHIFT)
#define MH_DEBUG_REG43_SET_ARB_BLEN_q(mh_debug_reg43_reg, arb_blen_q) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARB_BLEN_q_MASK) | (arb_blen_q << MH_DEBUG_REG43_ARB_BLEN_q_SHIFT)
#define MH_DEBUG_REG43_SET_ARQ_CTRL_EMPTY(mh_debug_reg43_reg, arq_ctrl_empty) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARQ_CTRL_EMPTY_MASK) | (arq_ctrl_empty << MH_DEBUG_REG43_ARQ_CTRL_EMPTY_SHIFT)
#define MH_DEBUG_REG43_SET_ARQ_FIFO_CNT_q(mh_debug_reg43_reg, arq_fifo_cnt_q) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARQ_FIFO_CNT_q_MASK) | (arq_fifo_cnt_q << MH_DEBUG_REG43_ARQ_FIFO_CNT_q_SHIFT)
#define MH_DEBUG_REG43_SET_MMU_WE(mh_debug_reg43_reg, mmu_we) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_MMU_WE_MASK) | (mmu_we << MH_DEBUG_REG43_MMU_WE_SHIFT)
#define MH_DEBUG_REG43_SET_ARQ_RTR(mh_debug_reg43_reg, arq_rtr) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_ARQ_RTR_MASK) | (arq_rtr << MH_DEBUG_REG43_ARQ_RTR_SHIFT)
#define MH_DEBUG_REG43_SET_MMU_ID(mh_debug_reg43_reg, mmu_id) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_MMU_ID_MASK) | (mmu_id << MH_DEBUG_REG43_MMU_ID_SHIFT)
#define MH_DEBUG_REG43_SET_MMU_WRITE(mh_debug_reg43_reg, mmu_write) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_MMU_WRITE_MASK) | (mmu_write << MH_DEBUG_REG43_MMU_WRITE_SHIFT)
#define MH_DEBUG_REG43_SET_MMU_BLEN(mh_debug_reg43_reg, mmu_blen) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_MMU_BLEN_MASK) | (mmu_blen << MH_DEBUG_REG43_MMU_BLEN_SHIFT)
#define MH_DEBUG_REG43_SET_WBURST_IP_q(mh_debug_reg43_reg, wburst_ip_q) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_WBURST_IP_q_MASK) | (wburst_ip_q << MH_DEBUG_REG43_WBURST_IP_q_SHIFT)
#define MH_DEBUG_REG43_SET_WDAT_REG_WE_q(mh_debug_reg43_reg, wdat_reg_we_q) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_WDAT_REG_WE_q_MASK) | (wdat_reg_we_q << MH_DEBUG_REG43_WDAT_REG_WE_q_SHIFT)
#define MH_DEBUG_REG43_SET_WDB_WE(mh_debug_reg43_reg, wdb_we) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_WDB_WE_MASK) | (wdb_we << MH_DEBUG_REG43_WDB_WE_SHIFT)
#define MH_DEBUG_REG43_SET_WDB_RTR_SKID_4(mh_debug_reg43_reg, wdb_rtr_skid_4) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_WDB_RTR_SKID_4_MASK) | (wdb_rtr_skid_4 << MH_DEBUG_REG43_WDB_RTR_SKID_4_SHIFT)
#define MH_DEBUG_REG43_SET_WDB_RTR_SKID_3(mh_debug_reg43_reg, wdb_rtr_skid_3) \
     mh_debug_reg43_reg = (mh_debug_reg43_reg & ~MH_DEBUG_REG43_WDB_RTR_SKID_3_MASK) | (wdb_rtr_skid_3 << MH_DEBUG_REG43_WDB_RTR_SKID_3_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg43_t {
          unsigned int arb_reg_we_q                   : MH_DEBUG_REG43_ARB_REG_WE_q_SIZE;
          unsigned int arb_we                         : MH_DEBUG_REG43_ARB_WE_SIZE;
          unsigned int arb_reg_valid_q                : MH_DEBUG_REG43_ARB_REG_VALID_q_SIZE;
          unsigned int arb_rtr_q                      : MH_DEBUG_REG43_ARB_RTR_q_SIZE;
          unsigned int arb_reg_rtr                    : MH_DEBUG_REG43_ARB_REG_RTR_SIZE;
          unsigned int wdat_burst_rtr                 : MH_DEBUG_REG43_WDAT_BURST_RTR_SIZE;
          unsigned int mmu_rtr                        : MH_DEBUG_REG43_MMU_RTR_SIZE;
          unsigned int arb_id_q                       : MH_DEBUG_REG43_ARB_ID_q_SIZE;
          unsigned int arb_write_q                    : MH_DEBUG_REG43_ARB_WRITE_q_SIZE;
          unsigned int arb_blen_q                     : MH_DEBUG_REG43_ARB_BLEN_q_SIZE;
          unsigned int arq_ctrl_empty                 : MH_DEBUG_REG43_ARQ_CTRL_EMPTY_SIZE;
          unsigned int arq_fifo_cnt_q                 : MH_DEBUG_REG43_ARQ_FIFO_CNT_q_SIZE;
          unsigned int mmu_we                         : MH_DEBUG_REG43_MMU_WE_SIZE;
          unsigned int arq_rtr                        : MH_DEBUG_REG43_ARQ_RTR_SIZE;
          unsigned int mmu_id                         : MH_DEBUG_REG43_MMU_ID_SIZE;
          unsigned int mmu_write                      : MH_DEBUG_REG43_MMU_WRITE_SIZE;
          unsigned int mmu_blen                       : MH_DEBUG_REG43_MMU_BLEN_SIZE;
          unsigned int wburst_ip_q                    : MH_DEBUG_REG43_WBURST_IP_q_SIZE;
          unsigned int wdat_reg_we_q                  : MH_DEBUG_REG43_WDAT_REG_WE_q_SIZE;
          unsigned int wdb_we                         : MH_DEBUG_REG43_WDB_WE_SIZE;
          unsigned int wdb_rtr_skid_4                 : MH_DEBUG_REG43_WDB_RTR_SKID_4_SIZE;
          unsigned int wdb_rtr_skid_3                 : MH_DEBUG_REG43_WDB_RTR_SKID_3_SIZE;
          unsigned int                                : 4;
     } mh_debug_reg43_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg43_t {
          unsigned int                                : 4;
          unsigned int wdb_rtr_skid_3                 : MH_DEBUG_REG43_WDB_RTR_SKID_3_SIZE;
          unsigned int wdb_rtr_skid_4                 : MH_DEBUG_REG43_WDB_RTR_SKID_4_SIZE;
          unsigned int wdb_we                         : MH_DEBUG_REG43_WDB_WE_SIZE;
          unsigned int wdat_reg_we_q                  : MH_DEBUG_REG43_WDAT_REG_WE_q_SIZE;
          unsigned int wburst_ip_q                    : MH_DEBUG_REG43_WBURST_IP_q_SIZE;
          unsigned int mmu_blen                       : MH_DEBUG_REG43_MMU_BLEN_SIZE;
          unsigned int mmu_write                      : MH_DEBUG_REG43_MMU_WRITE_SIZE;
          unsigned int mmu_id                         : MH_DEBUG_REG43_MMU_ID_SIZE;
          unsigned int arq_rtr                        : MH_DEBUG_REG43_ARQ_RTR_SIZE;
          unsigned int mmu_we                         : MH_DEBUG_REG43_MMU_WE_SIZE;
          unsigned int arq_fifo_cnt_q                 : MH_DEBUG_REG43_ARQ_FIFO_CNT_q_SIZE;
          unsigned int arq_ctrl_empty                 : MH_DEBUG_REG43_ARQ_CTRL_EMPTY_SIZE;
          unsigned int arb_blen_q                     : MH_DEBUG_REG43_ARB_BLEN_q_SIZE;
          unsigned int arb_write_q                    : MH_DEBUG_REG43_ARB_WRITE_q_SIZE;
          unsigned int arb_id_q                       : MH_DEBUG_REG43_ARB_ID_q_SIZE;
          unsigned int mmu_rtr                        : MH_DEBUG_REG43_MMU_RTR_SIZE;
          unsigned int wdat_burst_rtr                 : MH_DEBUG_REG43_WDAT_BURST_RTR_SIZE;
          unsigned int arb_reg_rtr                    : MH_DEBUG_REG43_ARB_REG_RTR_SIZE;
          unsigned int arb_rtr_q                      : MH_DEBUG_REG43_ARB_RTR_q_SIZE;
          unsigned int arb_reg_valid_q                : MH_DEBUG_REG43_ARB_REG_VALID_q_SIZE;
          unsigned int arb_we                         : MH_DEBUG_REG43_ARB_WE_SIZE;
          unsigned int arb_reg_we_q                   : MH_DEBUG_REG43_ARB_REG_WE_q_SIZE;
     } mh_debug_reg43_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg43_t f;
} mh_debug_reg43_u;


/*
 * MH_DEBUG_REG44 struct
 */

#define MH_DEBUG_REG44_ARB_WE_SIZE     1
#define MH_DEBUG_REG44_ARB_ID_q_SIZE   3
#define MH_DEBUG_REG44_ARB_VAD_q_SIZE  28

#define MH_DEBUG_REG44_ARB_WE_SHIFT    0
#define MH_DEBUG_REG44_ARB_ID_q_SHIFT  1
#define MH_DEBUG_REG44_ARB_VAD_q_SHIFT 4

#define MH_DEBUG_REG44_ARB_WE_MASK     0x00000001
#define MH_DEBUG_REG44_ARB_ID_q_MASK   0x0000000e
#define MH_DEBUG_REG44_ARB_VAD_q_MASK  0xfffffff0

#define MH_DEBUG_REG44_MASK \
     (MH_DEBUG_REG44_ARB_WE_MASK | \
      MH_DEBUG_REG44_ARB_ID_q_MASK | \
      MH_DEBUG_REG44_ARB_VAD_q_MASK)

#define MH_DEBUG_REG44(arb_we, arb_id_q, arb_vad_q) \
     ((arb_we << MH_DEBUG_REG44_ARB_WE_SHIFT) | \
      (arb_id_q << MH_DEBUG_REG44_ARB_ID_q_SHIFT) | \
      (arb_vad_q << MH_DEBUG_REG44_ARB_VAD_q_SHIFT))

#define MH_DEBUG_REG44_GET_ARB_WE(mh_debug_reg44) \
     ((mh_debug_reg44 & MH_DEBUG_REG44_ARB_WE_MASK) >> MH_DEBUG_REG44_ARB_WE_SHIFT)
#define MH_DEBUG_REG44_GET_ARB_ID_q(mh_debug_reg44) \
     ((mh_debug_reg44 & MH_DEBUG_REG44_ARB_ID_q_MASK) >> MH_DEBUG_REG44_ARB_ID_q_SHIFT)
#define MH_DEBUG_REG44_GET_ARB_VAD_q(mh_debug_reg44) \
     ((mh_debug_reg44 & MH_DEBUG_REG44_ARB_VAD_q_MASK) >> MH_DEBUG_REG44_ARB_VAD_q_SHIFT)

#define MH_DEBUG_REG44_SET_ARB_WE(mh_debug_reg44_reg, arb_we) \
     mh_debug_reg44_reg = (mh_debug_reg44_reg & ~MH_DEBUG_REG44_ARB_WE_MASK) | (arb_we << MH_DEBUG_REG44_ARB_WE_SHIFT)
#define MH_DEBUG_REG44_SET_ARB_ID_q(mh_debug_reg44_reg, arb_id_q) \
     mh_debug_reg44_reg = (mh_debug_reg44_reg & ~MH_DEBUG_REG44_ARB_ID_q_MASK) | (arb_id_q << MH_DEBUG_REG44_ARB_ID_q_SHIFT)
#define MH_DEBUG_REG44_SET_ARB_VAD_q(mh_debug_reg44_reg, arb_vad_q) \
     mh_debug_reg44_reg = (mh_debug_reg44_reg & ~MH_DEBUG_REG44_ARB_VAD_q_MASK) | (arb_vad_q << MH_DEBUG_REG44_ARB_VAD_q_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg44_t {
          unsigned int arb_we                         : MH_DEBUG_REG44_ARB_WE_SIZE;
          unsigned int arb_id_q                       : MH_DEBUG_REG44_ARB_ID_q_SIZE;
          unsigned int arb_vad_q                      : MH_DEBUG_REG44_ARB_VAD_q_SIZE;
     } mh_debug_reg44_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg44_t {
          unsigned int arb_vad_q                      : MH_DEBUG_REG44_ARB_VAD_q_SIZE;
          unsigned int arb_id_q                       : MH_DEBUG_REG44_ARB_ID_q_SIZE;
          unsigned int arb_we                         : MH_DEBUG_REG44_ARB_WE_SIZE;
     } mh_debug_reg44_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg44_t f;
} mh_debug_reg44_u;


/*
 * MH_DEBUG_REG45 struct
 */

#define MH_DEBUG_REG45_MMU_WE_SIZE     1
#define MH_DEBUG_REG45_MMU_ID_SIZE     3
#define MH_DEBUG_REG45_MMU_PAD_SIZE    28

#define MH_DEBUG_REG45_MMU_WE_SHIFT    0
#define MH_DEBUG_REG45_MMU_ID_SHIFT    1
#define MH_DEBUG_REG45_MMU_PAD_SHIFT   4

#define MH_DEBUG_REG45_MMU_WE_MASK     0x00000001
#define MH_DEBUG_REG45_MMU_ID_MASK     0x0000000e
#define MH_DEBUG_REG45_MMU_PAD_MASK    0xfffffff0

#define MH_DEBUG_REG45_MASK \
     (MH_DEBUG_REG45_MMU_WE_MASK | \
      MH_DEBUG_REG45_MMU_ID_MASK | \
      MH_DEBUG_REG45_MMU_PAD_MASK)

#define MH_DEBUG_REG45(mmu_we, mmu_id, mmu_pad) \
     ((mmu_we << MH_DEBUG_REG45_MMU_WE_SHIFT) | \
      (mmu_id << MH_DEBUG_REG45_MMU_ID_SHIFT) | \
      (mmu_pad << MH_DEBUG_REG45_MMU_PAD_SHIFT))

#define MH_DEBUG_REG45_GET_MMU_WE(mh_debug_reg45) \
     ((mh_debug_reg45 & MH_DEBUG_REG45_MMU_WE_MASK) >> MH_DEBUG_REG45_MMU_WE_SHIFT)
#define MH_DEBUG_REG45_GET_MMU_ID(mh_debug_reg45) \
     ((mh_debug_reg45 & MH_DEBUG_REG45_MMU_ID_MASK) >> MH_DEBUG_REG45_MMU_ID_SHIFT)
#define MH_DEBUG_REG45_GET_MMU_PAD(mh_debug_reg45) \
     ((mh_debug_reg45 & MH_DEBUG_REG45_MMU_PAD_MASK) >> MH_DEBUG_REG45_MMU_PAD_SHIFT)

#define MH_DEBUG_REG45_SET_MMU_WE(mh_debug_reg45_reg, mmu_we) \
     mh_debug_reg45_reg = (mh_debug_reg45_reg & ~MH_DEBUG_REG45_MMU_WE_MASK) | (mmu_we << MH_DEBUG_REG45_MMU_WE_SHIFT)
#define MH_DEBUG_REG45_SET_MMU_ID(mh_debug_reg45_reg, mmu_id) \
     mh_debug_reg45_reg = (mh_debug_reg45_reg & ~MH_DEBUG_REG45_MMU_ID_MASK) | (mmu_id << MH_DEBUG_REG45_MMU_ID_SHIFT)
#define MH_DEBUG_REG45_SET_MMU_PAD(mh_debug_reg45_reg, mmu_pad) \
     mh_debug_reg45_reg = (mh_debug_reg45_reg & ~MH_DEBUG_REG45_MMU_PAD_MASK) | (mmu_pad << MH_DEBUG_REG45_MMU_PAD_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg45_t {
          unsigned int mmu_we                         : MH_DEBUG_REG45_MMU_WE_SIZE;
          unsigned int mmu_id                         : MH_DEBUG_REG45_MMU_ID_SIZE;
          unsigned int mmu_pad                        : MH_DEBUG_REG45_MMU_PAD_SIZE;
     } mh_debug_reg45_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg45_t {
          unsigned int mmu_pad                        : MH_DEBUG_REG45_MMU_PAD_SIZE;
          unsigned int mmu_id                         : MH_DEBUG_REG45_MMU_ID_SIZE;
          unsigned int mmu_we                         : MH_DEBUG_REG45_MMU_WE_SIZE;
     } mh_debug_reg45_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg45_t f;
} mh_debug_reg45_u;


/*
 * MH_DEBUG_REG46 struct
 */

#define MH_DEBUG_REG46_WDAT_REG_WE_q_SIZE 1
#define MH_DEBUG_REG46_WDB_WE_SIZE     1
#define MH_DEBUG_REG46_WDAT_REG_VALID_q_SIZE 1
#define MH_DEBUG_REG46_WDB_RTR_SKID_4_SIZE 1
#define MH_DEBUG_REG46_ARB_WSTRB_q_SIZE 8
#define MH_DEBUG_REG46_ARB_WLAST_SIZE  1
#define MH_DEBUG_REG46_WDB_CTRL_EMPTY_SIZE 1
#define MH_DEBUG_REG46_WDB_FIFO_CNT_q_SIZE 5
#define MH_DEBUG_REG46_WDC_WDB_RE_q_SIZE 1
#define MH_DEBUG_REG46_WDB_WDC_WID_SIZE 3
#define MH_DEBUG_REG46_WDB_WDC_WLAST_SIZE 1
#define MH_DEBUG_REG46_WDB_WDC_WSTRB_SIZE 8

#define MH_DEBUG_REG46_WDAT_REG_WE_q_SHIFT 0
#define MH_DEBUG_REG46_WDB_WE_SHIFT    1
#define MH_DEBUG_REG46_WDAT_REG_VALID_q_SHIFT 2
#define MH_DEBUG_REG46_WDB_RTR_SKID_4_SHIFT 3
#define MH_DEBUG_REG46_ARB_WSTRB_q_SHIFT 4
#define MH_DEBUG_REG46_ARB_WLAST_SHIFT 12
#define MH_DEBUG_REG46_WDB_CTRL_EMPTY_SHIFT 13
#define MH_DEBUG_REG46_WDB_FIFO_CNT_q_SHIFT 14
#define MH_DEBUG_REG46_WDC_WDB_RE_q_SHIFT 19
#define MH_DEBUG_REG46_WDB_WDC_WID_SHIFT 20
#define MH_DEBUG_REG46_WDB_WDC_WLAST_SHIFT 23
#define MH_DEBUG_REG46_WDB_WDC_WSTRB_SHIFT 24

#define MH_DEBUG_REG46_WDAT_REG_WE_q_MASK 0x00000001
#define MH_DEBUG_REG46_WDB_WE_MASK     0x00000002
#define MH_DEBUG_REG46_WDAT_REG_VALID_q_MASK 0x00000004
#define MH_DEBUG_REG46_WDB_RTR_SKID_4_MASK 0x00000008
#define MH_DEBUG_REG46_ARB_WSTRB_q_MASK 0x00000ff0
#define MH_DEBUG_REG46_ARB_WLAST_MASK  0x00001000
#define MH_DEBUG_REG46_WDB_CTRL_EMPTY_MASK 0x00002000
#define MH_DEBUG_REG46_WDB_FIFO_CNT_q_MASK 0x0007c000
#define MH_DEBUG_REG46_WDC_WDB_RE_q_MASK 0x00080000
#define MH_DEBUG_REG46_WDB_WDC_WID_MASK 0x00700000
#define MH_DEBUG_REG46_WDB_WDC_WLAST_MASK 0x00800000
#define MH_DEBUG_REG46_WDB_WDC_WSTRB_MASK 0xff000000

#define MH_DEBUG_REG46_MASK \
     (MH_DEBUG_REG46_WDAT_REG_WE_q_MASK | \
      MH_DEBUG_REG46_WDB_WE_MASK | \
      MH_DEBUG_REG46_WDAT_REG_VALID_q_MASK | \
      MH_DEBUG_REG46_WDB_RTR_SKID_4_MASK | \
      MH_DEBUG_REG46_ARB_WSTRB_q_MASK | \
      MH_DEBUG_REG46_ARB_WLAST_MASK | \
      MH_DEBUG_REG46_WDB_CTRL_EMPTY_MASK | \
      MH_DEBUG_REG46_WDB_FIFO_CNT_q_MASK | \
      MH_DEBUG_REG46_WDC_WDB_RE_q_MASK | \
      MH_DEBUG_REG46_WDB_WDC_WID_MASK | \
      MH_DEBUG_REG46_WDB_WDC_WLAST_MASK | \
      MH_DEBUG_REG46_WDB_WDC_WSTRB_MASK)

#define MH_DEBUG_REG46(wdat_reg_we_q, wdb_we, wdat_reg_valid_q, wdb_rtr_skid_4, arb_wstrb_q, arb_wlast, wdb_ctrl_empty, wdb_fifo_cnt_q, wdc_wdb_re_q, wdb_wdc_wid, wdb_wdc_wlast, wdb_wdc_wstrb) \
     ((wdat_reg_we_q << MH_DEBUG_REG46_WDAT_REG_WE_q_SHIFT) | \
      (wdb_we << MH_DEBUG_REG46_WDB_WE_SHIFT) | \
      (wdat_reg_valid_q << MH_DEBUG_REG46_WDAT_REG_VALID_q_SHIFT) | \
      (wdb_rtr_skid_4 << MH_DEBUG_REG46_WDB_RTR_SKID_4_SHIFT) | \
      (arb_wstrb_q << MH_DEBUG_REG46_ARB_WSTRB_q_SHIFT) | \
      (arb_wlast << MH_DEBUG_REG46_ARB_WLAST_SHIFT) | \
      (wdb_ctrl_empty << MH_DEBUG_REG46_WDB_CTRL_EMPTY_SHIFT) | \
      (wdb_fifo_cnt_q << MH_DEBUG_REG46_WDB_FIFO_CNT_q_SHIFT) | \
      (wdc_wdb_re_q << MH_DEBUG_REG46_WDC_WDB_RE_q_SHIFT) | \
      (wdb_wdc_wid << MH_DEBUG_REG46_WDB_WDC_WID_SHIFT) | \
      (wdb_wdc_wlast << MH_DEBUG_REG46_WDB_WDC_WLAST_SHIFT) | \
      (wdb_wdc_wstrb << MH_DEBUG_REG46_WDB_WDC_WSTRB_SHIFT))

#define MH_DEBUG_REG46_GET_WDAT_REG_WE_q(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_WDAT_REG_WE_q_MASK) >> MH_DEBUG_REG46_WDAT_REG_WE_q_SHIFT)
#define MH_DEBUG_REG46_GET_WDB_WE(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_WDB_WE_MASK) >> MH_DEBUG_REG46_WDB_WE_SHIFT)
#define MH_DEBUG_REG46_GET_WDAT_REG_VALID_q(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_WDAT_REG_VALID_q_MASK) >> MH_DEBUG_REG46_WDAT_REG_VALID_q_SHIFT)
#define MH_DEBUG_REG46_GET_WDB_RTR_SKID_4(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_WDB_RTR_SKID_4_MASK) >> MH_DEBUG_REG46_WDB_RTR_SKID_4_SHIFT)
#define MH_DEBUG_REG46_GET_ARB_WSTRB_q(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_ARB_WSTRB_q_MASK) >> MH_DEBUG_REG46_ARB_WSTRB_q_SHIFT)
#define MH_DEBUG_REG46_GET_ARB_WLAST(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_ARB_WLAST_MASK) >> MH_DEBUG_REG46_ARB_WLAST_SHIFT)
#define MH_DEBUG_REG46_GET_WDB_CTRL_EMPTY(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_WDB_CTRL_EMPTY_MASK) >> MH_DEBUG_REG46_WDB_CTRL_EMPTY_SHIFT)
#define MH_DEBUG_REG46_GET_WDB_FIFO_CNT_q(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_WDB_FIFO_CNT_q_MASK) >> MH_DEBUG_REG46_WDB_FIFO_CNT_q_SHIFT)
#define MH_DEBUG_REG46_GET_WDC_WDB_RE_q(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_WDC_WDB_RE_q_MASK) >> MH_DEBUG_REG46_WDC_WDB_RE_q_SHIFT)
#define MH_DEBUG_REG46_GET_WDB_WDC_WID(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_WDB_WDC_WID_MASK) >> MH_DEBUG_REG46_WDB_WDC_WID_SHIFT)
#define MH_DEBUG_REG46_GET_WDB_WDC_WLAST(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_WDB_WDC_WLAST_MASK) >> MH_DEBUG_REG46_WDB_WDC_WLAST_SHIFT)
#define MH_DEBUG_REG46_GET_WDB_WDC_WSTRB(mh_debug_reg46) \
     ((mh_debug_reg46 & MH_DEBUG_REG46_WDB_WDC_WSTRB_MASK) >> MH_DEBUG_REG46_WDB_WDC_WSTRB_SHIFT)

#define MH_DEBUG_REG46_SET_WDAT_REG_WE_q(mh_debug_reg46_reg, wdat_reg_we_q) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_WDAT_REG_WE_q_MASK) | (wdat_reg_we_q << MH_DEBUG_REG46_WDAT_REG_WE_q_SHIFT)
#define MH_DEBUG_REG46_SET_WDB_WE(mh_debug_reg46_reg, wdb_we) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_WDB_WE_MASK) | (wdb_we << MH_DEBUG_REG46_WDB_WE_SHIFT)
#define MH_DEBUG_REG46_SET_WDAT_REG_VALID_q(mh_debug_reg46_reg, wdat_reg_valid_q) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_WDAT_REG_VALID_q_MASK) | (wdat_reg_valid_q << MH_DEBUG_REG46_WDAT_REG_VALID_q_SHIFT)
#define MH_DEBUG_REG46_SET_WDB_RTR_SKID_4(mh_debug_reg46_reg, wdb_rtr_skid_4) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_WDB_RTR_SKID_4_MASK) | (wdb_rtr_skid_4 << MH_DEBUG_REG46_WDB_RTR_SKID_4_SHIFT)
#define MH_DEBUG_REG46_SET_ARB_WSTRB_q(mh_debug_reg46_reg, arb_wstrb_q) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_ARB_WSTRB_q_MASK) | (arb_wstrb_q << MH_DEBUG_REG46_ARB_WSTRB_q_SHIFT)
#define MH_DEBUG_REG46_SET_ARB_WLAST(mh_debug_reg46_reg, arb_wlast) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_ARB_WLAST_MASK) | (arb_wlast << MH_DEBUG_REG46_ARB_WLAST_SHIFT)
#define MH_DEBUG_REG46_SET_WDB_CTRL_EMPTY(mh_debug_reg46_reg, wdb_ctrl_empty) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_WDB_CTRL_EMPTY_MASK) | (wdb_ctrl_empty << MH_DEBUG_REG46_WDB_CTRL_EMPTY_SHIFT)
#define MH_DEBUG_REG46_SET_WDB_FIFO_CNT_q(mh_debug_reg46_reg, wdb_fifo_cnt_q) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_WDB_FIFO_CNT_q_MASK) | (wdb_fifo_cnt_q << MH_DEBUG_REG46_WDB_FIFO_CNT_q_SHIFT)
#define MH_DEBUG_REG46_SET_WDC_WDB_RE_q(mh_debug_reg46_reg, wdc_wdb_re_q) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_WDC_WDB_RE_q_MASK) | (wdc_wdb_re_q << MH_DEBUG_REG46_WDC_WDB_RE_q_SHIFT)
#define MH_DEBUG_REG46_SET_WDB_WDC_WID(mh_debug_reg46_reg, wdb_wdc_wid) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_WDB_WDC_WID_MASK) | (wdb_wdc_wid << MH_DEBUG_REG46_WDB_WDC_WID_SHIFT)
#define MH_DEBUG_REG46_SET_WDB_WDC_WLAST(mh_debug_reg46_reg, wdb_wdc_wlast) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_WDB_WDC_WLAST_MASK) | (wdb_wdc_wlast << MH_DEBUG_REG46_WDB_WDC_WLAST_SHIFT)
#define MH_DEBUG_REG46_SET_WDB_WDC_WSTRB(mh_debug_reg46_reg, wdb_wdc_wstrb) \
     mh_debug_reg46_reg = (mh_debug_reg46_reg & ~MH_DEBUG_REG46_WDB_WDC_WSTRB_MASK) | (wdb_wdc_wstrb << MH_DEBUG_REG46_WDB_WDC_WSTRB_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg46_t {
          unsigned int wdat_reg_we_q                  : MH_DEBUG_REG46_WDAT_REG_WE_q_SIZE;
          unsigned int wdb_we                         : MH_DEBUG_REG46_WDB_WE_SIZE;
          unsigned int wdat_reg_valid_q               : MH_DEBUG_REG46_WDAT_REG_VALID_q_SIZE;
          unsigned int wdb_rtr_skid_4                 : MH_DEBUG_REG46_WDB_RTR_SKID_4_SIZE;
          unsigned int arb_wstrb_q                    : MH_DEBUG_REG46_ARB_WSTRB_q_SIZE;
          unsigned int arb_wlast                      : MH_DEBUG_REG46_ARB_WLAST_SIZE;
          unsigned int wdb_ctrl_empty                 : MH_DEBUG_REG46_WDB_CTRL_EMPTY_SIZE;
          unsigned int wdb_fifo_cnt_q                 : MH_DEBUG_REG46_WDB_FIFO_CNT_q_SIZE;
          unsigned int wdc_wdb_re_q                   : MH_DEBUG_REG46_WDC_WDB_RE_q_SIZE;
          unsigned int wdb_wdc_wid                    : MH_DEBUG_REG46_WDB_WDC_WID_SIZE;
          unsigned int wdb_wdc_wlast                  : MH_DEBUG_REG46_WDB_WDC_WLAST_SIZE;
          unsigned int wdb_wdc_wstrb                  : MH_DEBUG_REG46_WDB_WDC_WSTRB_SIZE;
     } mh_debug_reg46_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg46_t {
          unsigned int wdb_wdc_wstrb                  : MH_DEBUG_REG46_WDB_WDC_WSTRB_SIZE;
          unsigned int wdb_wdc_wlast                  : MH_DEBUG_REG46_WDB_WDC_WLAST_SIZE;
          unsigned int wdb_wdc_wid                    : MH_DEBUG_REG46_WDB_WDC_WID_SIZE;
          unsigned int wdc_wdb_re_q                   : MH_DEBUG_REG46_WDC_WDB_RE_q_SIZE;
          unsigned int wdb_fifo_cnt_q                 : MH_DEBUG_REG46_WDB_FIFO_CNT_q_SIZE;
          unsigned int wdb_ctrl_empty                 : MH_DEBUG_REG46_WDB_CTRL_EMPTY_SIZE;
          unsigned int arb_wlast                      : MH_DEBUG_REG46_ARB_WLAST_SIZE;
          unsigned int arb_wstrb_q                    : MH_DEBUG_REG46_ARB_WSTRB_q_SIZE;
          unsigned int wdb_rtr_skid_4                 : MH_DEBUG_REG46_WDB_RTR_SKID_4_SIZE;
          unsigned int wdat_reg_valid_q               : MH_DEBUG_REG46_WDAT_REG_VALID_q_SIZE;
          unsigned int wdb_we                         : MH_DEBUG_REG46_WDB_WE_SIZE;
          unsigned int wdat_reg_we_q                  : MH_DEBUG_REG46_WDAT_REG_WE_q_SIZE;
     } mh_debug_reg46_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg46_t f;
} mh_debug_reg46_u;


/*
 * MH_DEBUG_REG47 struct
 */

#define MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_SIZE 32

#define MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_SHIFT 0

#define MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_MASK 0xffffffff

#define MH_DEBUG_REG47_MASK \
     (MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_MASK)

#define MH_DEBUG_REG47(wdb_wdc_wdata_31_0) \
     ((wdb_wdc_wdata_31_0 << MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_SHIFT))

#define MH_DEBUG_REG47_GET_WDB_WDC_WDATA_31_0(mh_debug_reg47) \
     ((mh_debug_reg47 & MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_MASK) >> MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_SHIFT)

#define MH_DEBUG_REG47_SET_WDB_WDC_WDATA_31_0(mh_debug_reg47_reg, wdb_wdc_wdata_31_0) \
     mh_debug_reg47_reg = (mh_debug_reg47_reg & ~MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_MASK) | (wdb_wdc_wdata_31_0 << MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg47_t {
          unsigned int wdb_wdc_wdata_31_0             : MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_SIZE;
     } mh_debug_reg47_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg47_t {
          unsigned int wdb_wdc_wdata_31_0             : MH_DEBUG_REG47_WDB_WDC_WDATA_31_0_SIZE;
     } mh_debug_reg47_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg47_t f;
} mh_debug_reg47_u;


/*
 * MH_DEBUG_REG48 struct
 */

#define MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_SIZE 32

#define MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_SHIFT 0

#define MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_MASK 0xffffffff

#define MH_DEBUG_REG48_MASK \
     (MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_MASK)

#define MH_DEBUG_REG48(wdb_wdc_wdata_63_32) \
     ((wdb_wdc_wdata_63_32 << MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_SHIFT))

#define MH_DEBUG_REG48_GET_WDB_WDC_WDATA_63_32(mh_debug_reg48) \
     ((mh_debug_reg48 & MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_MASK) >> MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_SHIFT)

#define MH_DEBUG_REG48_SET_WDB_WDC_WDATA_63_32(mh_debug_reg48_reg, wdb_wdc_wdata_63_32) \
     mh_debug_reg48_reg = (mh_debug_reg48_reg & ~MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_MASK) | (wdb_wdc_wdata_63_32 << MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg48_t {
          unsigned int wdb_wdc_wdata_63_32            : MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_SIZE;
     } mh_debug_reg48_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg48_t {
          unsigned int wdb_wdc_wdata_63_32            : MH_DEBUG_REG48_WDB_WDC_WDATA_63_32_SIZE;
     } mh_debug_reg48_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg48_t f;
} mh_debug_reg48_u;


/*
 * MH_DEBUG_REG49 struct
 */

#define MH_DEBUG_REG49_CTRL_ARC_EMPTY_SIZE 1
#define MH_DEBUG_REG49_CTRL_RARC_EMPTY_SIZE 1
#define MH_DEBUG_REG49_ARQ_CTRL_EMPTY_SIZE 1
#define MH_DEBUG_REG49_ARQ_CTRL_WRITE_SIZE 1
#define MH_DEBUG_REG49_TLBMISS_CTRL_RTS_SIZE 1
#define MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_SIZE 1
#define MH_DEBUG_REG49_INFLT_LIMIT_q_SIZE 1
#define MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_SIZE 6
#define MH_DEBUG_REG49_ARC_CTRL_RE_q_SIZE 1
#define MH_DEBUG_REG49_RARC_CTRL_RE_q_SIZE 1
#define MH_DEBUG_REG49_RVALID_q_SIZE   1
#define MH_DEBUG_REG49_RREADY_q_SIZE   1
#define MH_DEBUG_REG49_RLAST_q_SIZE    1
#define MH_DEBUG_REG49_BVALID_q_SIZE   1
#define MH_DEBUG_REG49_BREADY_q_SIZE   1

#define MH_DEBUG_REG49_CTRL_ARC_EMPTY_SHIFT 0
#define MH_DEBUG_REG49_CTRL_RARC_EMPTY_SHIFT 1
#define MH_DEBUG_REG49_ARQ_CTRL_EMPTY_SHIFT 2
#define MH_DEBUG_REG49_ARQ_CTRL_WRITE_SHIFT 3
#define MH_DEBUG_REG49_TLBMISS_CTRL_RTS_SHIFT 4
#define MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_SHIFT 5
#define MH_DEBUG_REG49_INFLT_LIMIT_q_SHIFT 6
#define MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_SHIFT 7
#define MH_DEBUG_REG49_ARC_CTRL_RE_q_SHIFT 13
#define MH_DEBUG_REG49_RARC_CTRL_RE_q_SHIFT 14
#define MH_DEBUG_REG49_RVALID_q_SHIFT  15
#define MH_DEBUG_REG49_RREADY_q_SHIFT  16
#define MH_DEBUG_REG49_RLAST_q_SHIFT   17
#define MH_DEBUG_REG49_BVALID_q_SHIFT  18
#define MH_DEBUG_REG49_BREADY_q_SHIFT  19

#define MH_DEBUG_REG49_CTRL_ARC_EMPTY_MASK 0x00000001
#define MH_DEBUG_REG49_CTRL_RARC_EMPTY_MASK 0x00000002
#define MH_DEBUG_REG49_ARQ_CTRL_EMPTY_MASK 0x00000004
#define MH_DEBUG_REG49_ARQ_CTRL_WRITE_MASK 0x00000008
#define MH_DEBUG_REG49_TLBMISS_CTRL_RTS_MASK 0x00000010
#define MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_MASK 0x00000020
#define MH_DEBUG_REG49_INFLT_LIMIT_q_MASK 0x00000040
#define MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_MASK 0x00001f80
#define MH_DEBUG_REG49_ARC_CTRL_RE_q_MASK 0x00002000
#define MH_DEBUG_REG49_RARC_CTRL_RE_q_MASK 0x00004000
#define MH_DEBUG_REG49_RVALID_q_MASK   0x00008000
#define MH_DEBUG_REG49_RREADY_q_MASK   0x00010000
#define MH_DEBUG_REG49_RLAST_q_MASK    0x00020000
#define MH_DEBUG_REG49_BVALID_q_MASK   0x00040000
#define MH_DEBUG_REG49_BREADY_q_MASK   0x00080000

#define MH_DEBUG_REG49_MASK \
     (MH_DEBUG_REG49_CTRL_ARC_EMPTY_MASK | \
      MH_DEBUG_REG49_CTRL_RARC_EMPTY_MASK | \
      MH_DEBUG_REG49_ARQ_CTRL_EMPTY_MASK | \
      MH_DEBUG_REG49_ARQ_CTRL_WRITE_MASK | \
      MH_DEBUG_REG49_TLBMISS_CTRL_RTS_MASK | \
      MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_MASK | \
      MH_DEBUG_REG49_INFLT_LIMIT_q_MASK | \
      MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_MASK | \
      MH_DEBUG_REG49_ARC_CTRL_RE_q_MASK | \
      MH_DEBUG_REG49_RARC_CTRL_RE_q_MASK | \
      MH_DEBUG_REG49_RVALID_q_MASK | \
      MH_DEBUG_REG49_RREADY_q_MASK | \
      MH_DEBUG_REG49_RLAST_q_MASK | \
      MH_DEBUG_REG49_BVALID_q_MASK | \
      MH_DEBUG_REG49_BREADY_q_MASK)

#define MH_DEBUG_REG49(ctrl_arc_empty, ctrl_rarc_empty, arq_ctrl_empty, arq_ctrl_write, tlbmiss_ctrl_rts, ctrl_tlbmiss_re_q, inflt_limit_q, inflt_limit_cnt_q, arc_ctrl_re_q, rarc_ctrl_re_q, rvalid_q, rready_q, rlast_q, bvalid_q, bready_q) \
     ((ctrl_arc_empty << MH_DEBUG_REG49_CTRL_ARC_EMPTY_SHIFT) | \
      (ctrl_rarc_empty << MH_DEBUG_REG49_CTRL_RARC_EMPTY_SHIFT) | \
      (arq_ctrl_empty << MH_DEBUG_REG49_ARQ_CTRL_EMPTY_SHIFT) | \
      (arq_ctrl_write << MH_DEBUG_REG49_ARQ_CTRL_WRITE_SHIFT) | \
      (tlbmiss_ctrl_rts << MH_DEBUG_REG49_TLBMISS_CTRL_RTS_SHIFT) | \
      (ctrl_tlbmiss_re_q << MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_SHIFT) | \
      (inflt_limit_q << MH_DEBUG_REG49_INFLT_LIMIT_q_SHIFT) | \
      (inflt_limit_cnt_q << MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_SHIFT) | \
      (arc_ctrl_re_q << MH_DEBUG_REG49_ARC_CTRL_RE_q_SHIFT) | \
      (rarc_ctrl_re_q << MH_DEBUG_REG49_RARC_CTRL_RE_q_SHIFT) | \
      (rvalid_q << MH_DEBUG_REG49_RVALID_q_SHIFT) | \
      (rready_q << MH_DEBUG_REG49_RREADY_q_SHIFT) | \
      (rlast_q << MH_DEBUG_REG49_RLAST_q_SHIFT) | \
      (bvalid_q << MH_DEBUG_REG49_BVALID_q_SHIFT) | \
      (bready_q << MH_DEBUG_REG49_BREADY_q_SHIFT))

#define MH_DEBUG_REG49_GET_CTRL_ARC_EMPTY(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_CTRL_ARC_EMPTY_MASK) >> MH_DEBUG_REG49_CTRL_ARC_EMPTY_SHIFT)
#define MH_DEBUG_REG49_GET_CTRL_RARC_EMPTY(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_CTRL_RARC_EMPTY_MASK) >> MH_DEBUG_REG49_CTRL_RARC_EMPTY_SHIFT)
#define MH_DEBUG_REG49_GET_ARQ_CTRL_EMPTY(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_ARQ_CTRL_EMPTY_MASK) >> MH_DEBUG_REG49_ARQ_CTRL_EMPTY_SHIFT)
#define MH_DEBUG_REG49_GET_ARQ_CTRL_WRITE(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_ARQ_CTRL_WRITE_MASK) >> MH_DEBUG_REG49_ARQ_CTRL_WRITE_SHIFT)
#define MH_DEBUG_REG49_GET_TLBMISS_CTRL_RTS(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_TLBMISS_CTRL_RTS_MASK) >> MH_DEBUG_REG49_TLBMISS_CTRL_RTS_SHIFT)
#define MH_DEBUG_REG49_GET_CTRL_TLBMISS_RE_q(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_MASK) >> MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_SHIFT)
#define MH_DEBUG_REG49_GET_INFLT_LIMIT_q(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_INFLT_LIMIT_q_MASK) >> MH_DEBUG_REG49_INFLT_LIMIT_q_SHIFT)
#define MH_DEBUG_REG49_GET_INFLT_LIMIT_CNT_q(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_MASK) >> MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_SHIFT)
#define MH_DEBUG_REG49_GET_ARC_CTRL_RE_q(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_ARC_CTRL_RE_q_MASK) >> MH_DEBUG_REG49_ARC_CTRL_RE_q_SHIFT)
#define MH_DEBUG_REG49_GET_RARC_CTRL_RE_q(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_RARC_CTRL_RE_q_MASK) >> MH_DEBUG_REG49_RARC_CTRL_RE_q_SHIFT)
#define MH_DEBUG_REG49_GET_RVALID_q(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_RVALID_q_MASK) >> MH_DEBUG_REG49_RVALID_q_SHIFT)
#define MH_DEBUG_REG49_GET_RREADY_q(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_RREADY_q_MASK) >> MH_DEBUG_REG49_RREADY_q_SHIFT)
#define MH_DEBUG_REG49_GET_RLAST_q(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_RLAST_q_MASK) >> MH_DEBUG_REG49_RLAST_q_SHIFT)
#define MH_DEBUG_REG49_GET_BVALID_q(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_BVALID_q_MASK) >> MH_DEBUG_REG49_BVALID_q_SHIFT)
#define MH_DEBUG_REG49_GET_BREADY_q(mh_debug_reg49) \
     ((mh_debug_reg49 & MH_DEBUG_REG49_BREADY_q_MASK) >> MH_DEBUG_REG49_BREADY_q_SHIFT)

#define MH_DEBUG_REG49_SET_CTRL_ARC_EMPTY(mh_debug_reg49_reg, ctrl_arc_empty) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_CTRL_ARC_EMPTY_MASK) | (ctrl_arc_empty << MH_DEBUG_REG49_CTRL_ARC_EMPTY_SHIFT)
#define MH_DEBUG_REG49_SET_CTRL_RARC_EMPTY(mh_debug_reg49_reg, ctrl_rarc_empty) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_CTRL_RARC_EMPTY_MASK) | (ctrl_rarc_empty << MH_DEBUG_REG49_CTRL_RARC_EMPTY_SHIFT)
#define MH_DEBUG_REG49_SET_ARQ_CTRL_EMPTY(mh_debug_reg49_reg, arq_ctrl_empty) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_ARQ_CTRL_EMPTY_MASK) | (arq_ctrl_empty << MH_DEBUG_REG49_ARQ_CTRL_EMPTY_SHIFT)
#define MH_DEBUG_REG49_SET_ARQ_CTRL_WRITE(mh_debug_reg49_reg, arq_ctrl_write) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_ARQ_CTRL_WRITE_MASK) | (arq_ctrl_write << MH_DEBUG_REG49_ARQ_CTRL_WRITE_SHIFT)
#define MH_DEBUG_REG49_SET_TLBMISS_CTRL_RTS(mh_debug_reg49_reg, tlbmiss_ctrl_rts) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_TLBMISS_CTRL_RTS_MASK) | (tlbmiss_ctrl_rts << MH_DEBUG_REG49_TLBMISS_CTRL_RTS_SHIFT)
#define MH_DEBUG_REG49_SET_CTRL_TLBMISS_RE_q(mh_debug_reg49_reg, ctrl_tlbmiss_re_q) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_MASK) | (ctrl_tlbmiss_re_q << MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_SHIFT)
#define MH_DEBUG_REG49_SET_INFLT_LIMIT_q(mh_debug_reg49_reg, inflt_limit_q) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_INFLT_LIMIT_q_MASK) | (inflt_limit_q << MH_DEBUG_REG49_INFLT_LIMIT_q_SHIFT)
#define MH_DEBUG_REG49_SET_INFLT_LIMIT_CNT_q(mh_debug_reg49_reg, inflt_limit_cnt_q) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_MASK) | (inflt_limit_cnt_q << MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_SHIFT)
#define MH_DEBUG_REG49_SET_ARC_CTRL_RE_q(mh_debug_reg49_reg, arc_ctrl_re_q) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_ARC_CTRL_RE_q_MASK) | (arc_ctrl_re_q << MH_DEBUG_REG49_ARC_CTRL_RE_q_SHIFT)
#define MH_DEBUG_REG49_SET_RARC_CTRL_RE_q(mh_debug_reg49_reg, rarc_ctrl_re_q) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_RARC_CTRL_RE_q_MASK) | (rarc_ctrl_re_q << MH_DEBUG_REG49_RARC_CTRL_RE_q_SHIFT)
#define MH_DEBUG_REG49_SET_RVALID_q(mh_debug_reg49_reg, rvalid_q) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_RVALID_q_MASK) | (rvalid_q << MH_DEBUG_REG49_RVALID_q_SHIFT)
#define MH_DEBUG_REG49_SET_RREADY_q(mh_debug_reg49_reg, rready_q) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_RREADY_q_MASK) | (rready_q << MH_DEBUG_REG49_RREADY_q_SHIFT)
#define MH_DEBUG_REG49_SET_RLAST_q(mh_debug_reg49_reg, rlast_q) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_RLAST_q_MASK) | (rlast_q << MH_DEBUG_REG49_RLAST_q_SHIFT)
#define MH_DEBUG_REG49_SET_BVALID_q(mh_debug_reg49_reg, bvalid_q) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_BVALID_q_MASK) | (bvalid_q << MH_DEBUG_REG49_BVALID_q_SHIFT)
#define MH_DEBUG_REG49_SET_BREADY_q(mh_debug_reg49_reg, bready_q) \
     mh_debug_reg49_reg = (mh_debug_reg49_reg & ~MH_DEBUG_REG49_BREADY_q_MASK) | (bready_q << MH_DEBUG_REG49_BREADY_q_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg49_t {
          unsigned int ctrl_arc_empty                 : MH_DEBUG_REG49_CTRL_ARC_EMPTY_SIZE;
          unsigned int ctrl_rarc_empty                : MH_DEBUG_REG49_CTRL_RARC_EMPTY_SIZE;
          unsigned int arq_ctrl_empty                 : MH_DEBUG_REG49_ARQ_CTRL_EMPTY_SIZE;
          unsigned int arq_ctrl_write                 : MH_DEBUG_REG49_ARQ_CTRL_WRITE_SIZE;
          unsigned int tlbmiss_ctrl_rts               : MH_DEBUG_REG49_TLBMISS_CTRL_RTS_SIZE;
          unsigned int ctrl_tlbmiss_re_q              : MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_SIZE;
          unsigned int inflt_limit_q                  : MH_DEBUG_REG49_INFLT_LIMIT_q_SIZE;
          unsigned int inflt_limit_cnt_q              : MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_SIZE;
          unsigned int arc_ctrl_re_q                  : MH_DEBUG_REG49_ARC_CTRL_RE_q_SIZE;
          unsigned int rarc_ctrl_re_q                 : MH_DEBUG_REG49_RARC_CTRL_RE_q_SIZE;
          unsigned int rvalid_q                       : MH_DEBUG_REG49_RVALID_q_SIZE;
          unsigned int rready_q                       : MH_DEBUG_REG49_RREADY_q_SIZE;
          unsigned int rlast_q                        : MH_DEBUG_REG49_RLAST_q_SIZE;
          unsigned int bvalid_q                       : MH_DEBUG_REG49_BVALID_q_SIZE;
          unsigned int bready_q                       : MH_DEBUG_REG49_BREADY_q_SIZE;
          unsigned int                                : 12;
     } mh_debug_reg49_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg49_t {
          unsigned int                                : 12;
          unsigned int bready_q                       : MH_DEBUG_REG49_BREADY_q_SIZE;
          unsigned int bvalid_q                       : MH_DEBUG_REG49_BVALID_q_SIZE;
          unsigned int rlast_q                        : MH_DEBUG_REG49_RLAST_q_SIZE;
          unsigned int rready_q                       : MH_DEBUG_REG49_RREADY_q_SIZE;
          unsigned int rvalid_q                       : MH_DEBUG_REG49_RVALID_q_SIZE;
          unsigned int rarc_ctrl_re_q                 : MH_DEBUG_REG49_RARC_CTRL_RE_q_SIZE;
          unsigned int arc_ctrl_re_q                  : MH_DEBUG_REG49_ARC_CTRL_RE_q_SIZE;
          unsigned int inflt_limit_cnt_q              : MH_DEBUG_REG49_INFLT_LIMIT_CNT_q_SIZE;
          unsigned int inflt_limit_q                  : MH_DEBUG_REG49_INFLT_LIMIT_q_SIZE;
          unsigned int ctrl_tlbmiss_re_q              : MH_DEBUG_REG49_CTRL_TLBMISS_RE_q_SIZE;
          unsigned int tlbmiss_ctrl_rts               : MH_DEBUG_REG49_TLBMISS_CTRL_RTS_SIZE;
          unsigned int arq_ctrl_write                 : MH_DEBUG_REG49_ARQ_CTRL_WRITE_SIZE;
          unsigned int arq_ctrl_empty                 : MH_DEBUG_REG49_ARQ_CTRL_EMPTY_SIZE;
          unsigned int ctrl_rarc_empty                : MH_DEBUG_REG49_CTRL_RARC_EMPTY_SIZE;
          unsigned int ctrl_arc_empty                 : MH_DEBUG_REG49_CTRL_ARC_EMPTY_SIZE;
     } mh_debug_reg49_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg49_t f;
} mh_debug_reg49_u;


/*
 * MH_DEBUG_REG50 struct
 */

#define MH_DEBUG_REG50_MH_CP_grb_send_SIZE 1
#define MH_DEBUG_REG50_MH_VGT_grb_send_SIZE 1
#define MH_DEBUG_REG50_MH_TC_mcsend_SIZE 1
#define MH_DEBUG_REG50_MH_TLBMISS_SEND_SIZE 1
#define MH_DEBUG_REG50_TLBMISS_VALID_SIZE 1
#define MH_DEBUG_REG50_RDC_VALID_SIZE  1
#define MH_DEBUG_REG50_RDC_RID_SIZE    3
#define MH_DEBUG_REG50_RDC_RLAST_SIZE  1
#define MH_DEBUG_REG50_RDC_RRESP_SIZE  2
#define MH_DEBUG_REG50_TLBMISS_CTRL_RTS_SIZE 1
#define MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_SIZE 1
#define MH_DEBUG_REG50_MMU_ID_REQUEST_q_SIZE 1
#define MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_SIZE 6
#define MH_DEBUG_REG50_MMU_ID_RESPONSE_SIZE 1
#define MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_SIZE 6
#define MH_DEBUG_REG50_CNT_HOLD_q1_SIZE 1
#define MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SIZE 3

#define MH_DEBUG_REG50_MH_CP_grb_send_SHIFT 0
#define MH_DEBUG_REG50_MH_VGT_grb_send_SHIFT 1
#define MH_DEBUG_REG50_MH_TC_mcsend_SHIFT 2
#define MH_DEBUG_REG50_MH_TLBMISS_SEND_SHIFT 3
#define MH_DEBUG_REG50_TLBMISS_VALID_SHIFT 4
#define MH_DEBUG_REG50_RDC_VALID_SHIFT 5
#define MH_DEBUG_REG50_RDC_RID_SHIFT   6
#define MH_DEBUG_REG50_RDC_RLAST_SHIFT 9
#define MH_DEBUG_REG50_RDC_RRESP_SHIFT 10
#define MH_DEBUG_REG50_TLBMISS_CTRL_RTS_SHIFT 12
#define MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_SHIFT 13
#define MH_DEBUG_REG50_MMU_ID_REQUEST_q_SHIFT 14
#define MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_SHIFT 15
#define MH_DEBUG_REG50_MMU_ID_RESPONSE_SHIFT 21
#define MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_SHIFT 22
#define MH_DEBUG_REG50_CNT_HOLD_q1_SHIFT 28
#define MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT 29

#define MH_DEBUG_REG50_MH_CP_grb_send_MASK 0x00000001
#define MH_DEBUG_REG50_MH_VGT_grb_send_MASK 0x00000002
#define MH_DEBUG_REG50_MH_TC_mcsend_MASK 0x00000004
#define MH_DEBUG_REG50_MH_TLBMISS_SEND_MASK 0x00000008
#define MH_DEBUG_REG50_TLBMISS_VALID_MASK 0x00000010
#define MH_DEBUG_REG50_RDC_VALID_MASK  0x00000020
#define MH_DEBUG_REG50_RDC_RID_MASK    0x000001c0
#define MH_DEBUG_REG50_RDC_RLAST_MASK  0x00000200
#define MH_DEBUG_REG50_RDC_RRESP_MASK  0x00000c00
#define MH_DEBUG_REG50_TLBMISS_CTRL_RTS_MASK 0x00001000
#define MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_MASK 0x00002000
#define MH_DEBUG_REG50_MMU_ID_REQUEST_q_MASK 0x00004000
#define MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_MASK 0x001f8000
#define MH_DEBUG_REG50_MMU_ID_RESPONSE_MASK 0x00200000
#define MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_MASK 0x0fc00000
#define MH_DEBUG_REG50_CNT_HOLD_q1_MASK 0x10000000
#define MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK 0xe0000000

#define MH_DEBUG_REG50_MASK \
     (MH_DEBUG_REG50_MH_CP_grb_send_MASK | \
      MH_DEBUG_REG50_MH_VGT_grb_send_MASK | \
      MH_DEBUG_REG50_MH_TC_mcsend_MASK | \
      MH_DEBUG_REG50_MH_TLBMISS_SEND_MASK | \
      MH_DEBUG_REG50_TLBMISS_VALID_MASK | \
      MH_DEBUG_REG50_RDC_VALID_MASK | \
      MH_DEBUG_REG50_RDC_RID_MASK | \
      MH_DEBUG_REG50_RDC_RLAST_MASK | \
      MH_DEBUG_REG50_RDC_RRESP_MASK | \
      MH_DEBUG_REG50_TLBMISS_CTRL_RTS_MASK | \
      MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_MASK | \
      MH_DEBUG_REG50_MMU_ID_REQUEST_q_MASK | \
      MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_MASK | \
      MH_DEBUG_REG50_MMU_ID_RESPONSE_MASK | \
      MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_MASK | \
      MH_DEBUG_REG50_CNT_HOLD_q1_MASK | \
      MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK)

#define MH_DEBUG_REG50(mh_cp_grb_send, mh_vgt_grb_send, mh_tc_mcsend, mh_tlbmiss_send, tlbmiss_valid, rdc_valid, rdc_rid, rdc_rlast, rdc_rresp, tlbmiss_ctrl_rts, ctrl_tlbmiss_re_q, mmu_id_request_q, outstanding_mmuid_cnt_q, mmu_id_response, tlbmiss_return_cnt_q, cnt_hold_q1, mh_clnt_axi_id_reuse_mmur_id) \
     ((mh_cp_grb_send << MH_DEBUG_REG50_MH_CP_grb_send_SHIFT) | \
      (mh_vgt_grb_send << MH_DEBUG_REG50_MH_VGT_grb_send_SHIFT) | \
      (mh_tc_mcsend << MH_DEBUG_REG50_MH_TC_mcsend_SHIFT) | \
      (mh_tlbmiss_send << MH_DEBUG_REG50_MH_TLBMISS_SEND_SHIFT) | \
      (tlbmiss_valid << MH_DEBUG_REG50_TLBMISS_VALID_SHIFT) | \
      (rdc_valid << MH_DEBUG_REG50_RDC_VALID_SHIFT) | \
      (rdc_rid << MH_DEBUG_REG50_RDC_RID_SHIFT) | \
      (rdc_rlast << MH_DEBUG_REG50_RDC_RLAST_SHIFT) | \
      (rdc_rresp << MH_DEBUG_REG50_RDC_RRESP_SHIFT) | \
      (tlbmiss_ctrl_rts << MH_DEBUG_REG50_TLBMISS_CTRL_RTS_SHIFT) | \
      (ctrl_tlbmiss_re_q << MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_SHIFT) | \
      (mmu_id_request_q << MH_DEBUG_REG50_MMU_ID_REQUEST_q_SHIFT) | \
      (outstanding_mmuid_cnt_q << MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_SHIFT) | \
      (mmu_id_response << MH_DEBUG_REG50_MMU_ID_RESPONSE_SHIFT) | \
      (tlbmiss_return_cnt_q << MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_SHIFT) | \
      (cnt_hold_q1 << MH_DEBUG_REG50_CNT_HOLD_q1_SHIFT) | \
      (mh_clnt_axi_id_reuse_mmur_id << MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT))

#define MH_DEBUG_REG50_GET_MH_CP_grb_send(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_MH_CP_grb_send_MASK) >> MH_DEBUG_REG50_MH_CP_grb_send_SHIFT)
#define MH_DEBUG_REG50_GET_MH_VGT_grb_send(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_MH_VGT_grb_send_MASK) >> MH_DEBUG_REG50_MH_VGT_grb_send_SHIFT)
#define MH_DEBUG_REG50_GET_MH_TC_mcsend(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_MH_TC_mcsend_MASK) >> MH_DEBUG_REG50_MH_TC_mcsend_SHIFT)
#define MH_DEBUG_REG50_GET_MH_TLBMISS_SEND(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_MH_TLBMISS_SEND_MASK) >> MH_DEBUG_REG50_MH_TLBMISS_SEND_SHIFT)
#define MH_DEBUG_REG50_GET_TLBMISS_VALID(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_TLBMISS_VALID_MASK) >> MH_DEBUG_REG50_TLBMISS_VALID_SHIFT)
#define MH_DEBUG_REG50_GET_RDC_VALID(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_RDC_VALID_MASK) >> MH_DEBUG_REG50_RDC_VALID_SHIFT)
#define MH_DEBUG_REG50_GET_RDC_RID(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_RDC_RID_MASK) >> MH_DEBUG_REG50_RDC_RID_SHIFT)
#define MH_DEBUG_REG50_GET_RDC_RLAST(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_RDC_RLAST_MASK) >> MH_DEBUG_REG50_RDC_RLAST_SHIFT)
#define MH_DEBUG_REG50_GET_RDC_RRESP(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_RDC_RRESP_MASK) >> MH_DEBUG_REG50_RDC_RRESP_SHIFT)
#define MH_DEBUG_REG50_GET_TLBMISS_CTRL_RTS(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_TLBMISS_CTRL_RTS_MASK) >> MH_DEBUG_REG50_TLBMISS_CTRL_RTS_SHIFT)
#define MH_DEBUG_REG50_GET_CTRL_TLBMISS_RE_q(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_MASK) >> MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_SHIFT)
#define MH_DEBUG_REG50_GET_MMU_ID_REQUEST_q(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_MMU_ID_REQUEST_q_MASK) >> MH_DEBUG_REG50_MMU_ID_REQUEST_q_SHIFT)
#define MH_DEBUG_REG50_GET_OUTSTANDING_MMUID_CNT_q(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_MASK) >> MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_SHIFT)
#define MH_DEBUG_REG50_GET_MMU_ID_RESPONSE(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_MMU_ID_RESPONSE_MASK) >> MH_DEBUG_REG50_MMU_ID_RESPONSE_SHIFT)
#define MH_DEBUG_REG50_GET_TLBMISS_RETURN_CNT_q(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_MASK) >> MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_SHIFT)
#define MH_DEBUG_REG50_GET_CNT_HOLD_q1(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_CNT_HOLD_q1_MASK) >> MH_DEBUG_REG50_CNT_HOLD_q1_SHIFT)
#define MH_DEBUG_REG50_GET_MH_CLNT_AXI_ID_REUSE_MMUr_ID(mh_debug_reg50) \
     ((mh_debug_reg50 & MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK) >> MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT)

#define MH_DEBUG_REG50_SET_MH_CP_grb_send(mh_debug_reg50_reg, mh_cp_grb_send) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_MH_CP_grb_send_MASK) | (mh_cp_grb_send << MH_DEBUG_REG50_MH_CP_grb_send_SHIFT)
#define MH_DEBUG_REG50_SET_MH_VGT_grb_send(mh_debug_reg50_reg, mh_vgt_grb_send) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_MH_VGT_grb_send_MASK) | (mh_vgt_grb_send << MH_DEBUG_REG50_MH_VGT_grb_send_SHIFT)
#define MH_DEBUG_REG50_SET_MH_TC_mcsend(mh_debug_reg50_reg, mh_tc_mcsend) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_MH_TC_mcsend_MASK) | (mh_tc_mcsend << MH_DEBUG_REG50_MH_TC_mcsend_SHIFT)
#define MH_DEBUG_REG50_SET_MH_TLBMISS_SEND(mh_debug_reg50_reg, mh_tlbmiss_send) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_MH_TLBMISS_SEND_MASK) | (mh_tlbmiss_send << MH_DEBUG_REG50_MH_TLBMISS_SEND_SHIFT)
#define MH_DEBUG_REG50_SET_TLBMISS_VALID(mh_debug_reg50_reg, tlbmiss_valid) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_TLBMISS_VALID_MASK) | (tlbmiss_valid << MH_DEBUG_REG50_TLBMISS_VALID_SHIFT)
#define MH_DEBUG_REG50_SET_RDC_VALID(mh_debug_reg50_reg, rdc_valid) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_RDC_VALID_MASK) | (rdc_valid << MH_DEBUG_REG50_RDC_VALID_SHIFT)
#define MH_DEBUG_REG50_SET_RDC_RID(mh_debug_reg50_reg, rdc_rid) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_RDC_RID_MASK) | (rdc_rid << MH_DEBUG_REG50_RDC_RID_SHIFT)
#define MH_DEBUG_REG50_SET_RDC_RLAST(mh_debug_reg50_reg, rdc_rlast) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_RDC_RLAST_MASK) | (rdc_rlast << MH_DEBUG_REG50_RDC_RLAST_SHIFT)
#define MH_DEBUG_REG50_SET_RDC_RRESP(mh_debug_reg50_reg, rdc_rresp) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_RDC_RRESP_MASK) | (rdc_rresp << MH_DEBUG_REG50_RDC_RRESP_SHIFT)
#define MH_DEBUG_REG50_SET_TLBMISS_CTRL_RTS(mh_debug_reg50_reg, tlbmiss_ctrl_rts) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_TLBMISS_CTRL_RTS_MASK) | (tlbmiss_ctrl_rts << MH_DEBUG_REG50_TLBMISS_CTRL_RTS_SHIFT)
#define MH_DEBUG_REG50_SET_CTRL_TLBMISS_RE_q(mh_debug_reg50_reg, ctrl_tlbmiss_re_q) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_MASK) | (ctrl_tlbmiss_re_q << MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_SHIFT)
#define MH_DEBUG_REG50_SET_MMU_ID_REQUEST_q(mh_debug_reg50_reg, mmu_id_request_q) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_MMU_ID_REQUEST_q_MASK) | (mmu_id_request_q << MH_DEBUG_REG50_MMU_ID_REQUEST_q_SHIFT)
#define MH_DEBUG_REG50_SET_OUTSTANDING_MMUID_CNT_q(mh_debug_reg50_reg, outstanding_mmuid_cnt_q) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_MASK) | (outstanding_mmuid_cnt_q << MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_SHIFT)
#define MH_DEBUG_REG50_SET_MMU_ID_RESPONSE(mh_debug_reg50_reg, mmu_id_response) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_MMU_ID_RESPONSE_MASK) | (mmu_id_response << MH_DEBUG_REG50_MMU_ID_RESPONSE_SHIFT)
#define MH_DEBUG_REG50_SET_TLBMISS_RETURN_CNT_q(mh_debug_reg50_reg, tlbmiss_return_cnt_q) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_MASK) | (tlbmiss_return_cnt_q << MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_SHIFT)
#define MH_DEBUG_REG50_SET_CNT_HOLD_q1(mh_debug_reg50_reg, cnt_hold_q1) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_CNT_HOLD_q1_MASK) | (cnt_hold_q1 << MH_DEBUG_REG50_CNT_HOLD_q1_SHIFT)
#define MH_DEBUG_REG50_SET_MH_CLNT_AXI_ID_REUSE_MMUr_ID(mh_debug_reg50_reg, mh_clnt_axi_id_reuse_mmur_id) \
     mh_debug_reg50_reg = (mh_debug_reg50_reg & ~MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_MASK) | (mh_clnt_axi_id_reuse_mmur_id << MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg50_t {
          unsigned int mh_cp_grb_send                 : MH_DEBUG_REG50_MH_CP_grb_send_SIZE;
          unsigned int mh_vgt_grb_send                : MH_DEBUG_REG50_MH_VGT_grb_send_SIZE;
          unsigned int mh_tc_mcsend                   : MH_DEBUG_REG50_MH_TC_mcsend_SIZE;
          unsigned int mh_tlbmiss_send                : MH_DEBUG_REG50_MH_TLBMISS_SEND_SIZE;
          unsigned int tlbmiss_valid                  : MH_DEBUG_REG50_TLBMISS_VALID_SIZE;
          unsigned int rdc_valid                      : MH_DEBUG_REG50_RDC_VALID_SIZE;
          unsigned int rdc_rid                        : MH_DEBUG_REG50_RDC_RID_SIZE;
          unsigned int rdc_rlast                      : MH_DEBUG_REG50_RDC_RLAST_SIZE;
          unsigned int rdc_rresp                      : MH_DEBUG_REG50_RDC_RRESP_SIZE;
          unsigned int tlbmiss_ctrl_rts               : MH_DEBUG_REG50_TLBMISS_CTRL_RTS_SIZE;
          unsigned int ctrl_tlbmiss_re_q              : MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_SIZE;
          unsigned int mmu_id_request_q               : MH_DEBUG_REG50_MMU_ID_REQUEST_q_SIZE;
          unsigned int outstanding_mmuid_cnt_q        : MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_SIZE;
          unsigned int mmu_id_response                : MH_DEBUG_REG50_MMU_ID_RESPONSE_SIZE;
          unsigned int tlbmiss_return_cnt_q           : MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_SIZE;
          unsigned int cnt_hold_q1                    : MH_DEBUG_REG50_CNT_HOLD_q1_SIZE;
          unsigned int mh_clnt_axi_id_reuse_mmur_id   : MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SIZE;
     } mh_debug_reg50_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg50_t {
          unsigned int mh_clnt_axi_id_reuse_mmur_id   : MH_DEBUG_REG50_MH_CLNT_AXI_ID_REUSE_MMUr_ID_SIZE;
          unsigned int cnt_hold_q1                    : MH_DEBUG_REG50_CNT_HOLD_q1_SIZE;
          unsigned int tlbmiss_return_cnt_q           : MH_DEBUG_REG50_TLBMISS_RETURN_CNT_q_SIZE;
          unsigned int mmu_id_response                : MH_DEBUG_REG50_MMU_ID_RESPONSE_SIZE;
          unsigned int outstanding_mmuid_cnt_q        : MH_DEBUG_REG50_OUTSTANDING_MMUID_CNT_q_SIZE;
          unsigned int mmu_id_request_q               : MH_DEBUG_REG50_MMU_ID_REQUEST_q_SIZE;
          unsigned int ctrl_tlbmiss_re_q              : MH_DEBUG_REG50_CTRL_TLBMISS_RE_q_SIZE;
          unsigned int tlbmiss_ctrl_rts               : MH_DEBUG_REG50_TLBMISS_CTRL_RTS_SIZE;
          unsigned int rdc_rresp                      : MH_DEBUG_REG50_RDC_RRESP_SIZE;
          unsigned int rdc_rlast                      : MH_DEBUG_REG50_RDC_RLAST_SIZE;
          unsigned int rdc_rid                        : MH_DEBUG_REG50_RDC_RID_SIZE;
          unsigned int rdc_valid                      : MH_DEBUG_REG50_RDC_VALID_SIZE;
          unsigned int tlbmiss_valid                  : MH_DEBUG_REG50_TLBMISS_VALID_SIZE;
          unsigned int mh_tlbmiss_send                : MH_DEBUG_REG50_MH_TLBMISS_SEND_SIZE;
          unsigned int mh_tc_mcsend                   : MH_DEBUG_REG50_MH_TC_mcsend_SIZE;
          unsigned int mh_vgt_grb_send                : MH_DEBUG_REG50_MH_VGT_grb_send_SIZE;
          unsigned int mh_cp_grb_send                 : MH_DEBUG_REG50_MH_CP_grb_send_SIZE;
     } mh_debug_reg50_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg50_t f;
} mh_debug_reg50_u;


/*
 * MH_DEBUG_REG51 struct
 */

#define MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_SIZE 32

#define MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_SHIFT 0

#define MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_MASK 0xffffffff

#define MH_DEBUG_REG51_MASK \
     (MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_MASK)

#define MH_DEBUG_REG51(rf_mmu_page_fault) \
     ((rf_mmu_page_fault << MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_SHIFT))

#define MH_DEBUG_REG51_GET_RF_MMU_PAGE_FAULT(mh_debug_reg51) \
     ((mh_debug_reg51 & MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_MASK) >> MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_SHIFT)

#define MH_DEBUG_REG51_SET_RF_MMU_PAGE_FAULT(mh_debug_reg51_reg, rf_mmu_page_fault) \
     mh_debug_reg51_reg = (mh_debug_reg51_reg & ~MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_MASK) | (rf_mmu_page_fault << MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg51_t {
          unsigned int rf_mmu_page_fault              : MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_SIZE;
     } mh_debug_reg51_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg51_t {
          unsigned int rf_mmu_page_fault              : MH_DEBUG_REG51_RF_MMU_PAGE_FAULT_SIZE;
     } mh_debug_reg51_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg51_t f;
} mh_debug_reg51_u;


/*
 * MH_DEBUG_REG52 struct
 */

#define MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_SIZE 2
#define MH_DEBUG_REG52_ARB_WE_SIZE     1
#define MH_DEBUG_REG52_MMU_RTR_SIZE    1
#define MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_SIZE 22
#define MH_DEBUG_REG52_ARB_ID_q_SIZE   3
#define MH_DEBUG_REG52_ARB_WRITE_q_SIZE 1
#define MH_DEBUG_REG52_client_behavior_q_SIZE 2

#define MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_SHIFT 0
#define MH_DEBUG_REG52_ARB_WE_SHIFT    2
#define MH_DEBUG_REG52_MMU_RTR_SHIFT   3
#define MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_SHIFT 4
#define MH_DEBUG_REG52_ARB_ID_q_SHIFT  26
#define MH_DEBUG_REG52_ARB_WRITE_q_SHIFT 29
#define MH_DEBUG_REG52_client_behavior_q_SHIFT 30

#define MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_MASK 0x00000003
#define MH_DEBUG_REG52_ARB_WE_MASK     0x00000004
#define MH_DEBUG_REG52_MMU_RTR_MASK    0x00000008
#define MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_MASK 0x03fffff0
#define MH_DEBUG_REG52_ARB_ID_q_MASK   0x1c000000
#define MH_DEBUG_REG52_ARB_WRITE_q_MASK 0x20000000
#define MH_DEBUG_REG52_client_behavior_q_MASK 0xc0000000

#define MH_DEBUG_REG52_MASK \
     (MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_MASK | \
      MH_DEBUG_REG52_ARB_WE_MASK | \
      MH_DEBUG_REG52_MMU_RTR_MASK | \
      MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_MASK | \
      MH_DEBUG_REG52_ARB_ID_q_MASK | \
      MH_DEBUG_REG52_ARB_WRITE_q_MASK | \
      MH_DEBUG_REG52_client_behavior_q_MASK)

#define MH_DEBUG_REG52(rf_mmu_config_q_1_to_0, arb_we, mmu_rtr, rf_mmu_config_q_25_to_4, arb_id_q, arb_write_q, client_behavior_q) \
     ((rf_mmu_config_q_1_to_0 << MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_SHIFT) | \
      (arb_we << MH_DEBUG_REG52_ARB_WE_SHIFT) | \
      (mmu_rtr << MH_DEBUG_REG52_MMU_RTR_SHIFT) | \
      (rf_mmu_config_q_25_to_4 << MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_SHIFT) | \
      (arb_id_q << MH_DEBUG_REG52_ARB_ID_q_SHIFT) | \
      (arb_write_q << MH_DEBUG_REG52_ARB_WRITE_q_SHIFT) | \
      (client_behavior_q << MH_DEBUG_REG52_client_behavior_q_SHIFT))

#define MH_DEBUG_REG52_GET_RF_MMU_CONFIG_q_1_to_0(mh_debug_reg52) \
     ((mh_debug_reg52 & MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_MASK) >> MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_SHIFT)
#define MH_DEBUG_REG52_GET_ARB_WE(mh_debug_reg52) \
     ((mh_debug_reg52 & MH_DEBUG_REG52_ARB_WE_MASK) >> MH_DEBUG_REG52_ARB_WE_SHIFT)
#define MH_DEBUG_REG52_GET_MMU_RTR(mh_debug_reg52) \
     ((mh_debug_reg52 & MH_DEBUG_REG52_MMU_RTR_MASK) >> MH_DEBUG_REG52_MMU_RTR_SHIFT)
#define MH_DEBUG_REG52_GET_RF_MMU_CONFIG_q_25_to_4(mh_debug_reg52) \
     ((mh_debug_reg52 & MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_MASK) >> MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_SHIFT)
#define MH_DEBUG_REG52_GET_ARB_ID_q(mh_debug_reg52) \
     ((mh_debug_reg52 & MH_DEBUG_REG52_ARB_ID_q_MASK) >> MH_DEBUG_REG52_ARB_ID_q_SHIFT)
#define MH_DEBUG_REG52_GET_ARB_WRITE_q(mh_debug_reg52) \
     ((mh_debug_reg52 & MH_DEBUG_REG52_ARB_WRITE_q_MASK) >> MH_DEBUG_REG52_ARB_WRITE_q_SHIFT)
#define MH_DEBUG_REG52_GET_client_behavior_q(mh_debug_reg52) \
     ((mh_debug_reg52 & MH_DEBUG_REG52_client_behavior_q_MASK) >> MH_DEBUG_REG52_client_behavior_q_SHIFT)

#define MH_DEBUG_REG52_SET_RF_MMU_CONFIG_q_1_to_0(mh_debug_reg52_reg, rf_mmu_config_q_1_to_0) \
     mh_debug_reg52_reg = (mh_debug_reg52_reg & ~MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_MASK) | (rf_mmu_config_q_1_to_0 << MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_SHIFT)
#define MH_DEBUG_REG52_SET_ARB_WE(mh_debug_reg52_reg, arb_we) \
     mh_debug_reg52_reg = (mh_debug_reg52_reg & ~MH_DEBUG_REG52_ARB_WE_MASK) | (arb_we << MH_DEBUG_REG52_ARB_WE_SHIFT)
#define MH_DEBUG_REG52_SET_MMU_RTR(mh_debug_reg52_reg, mmu_rtr) \
     mh_debug_reg52_reg = (mh_debug_reg52_reg & ~MH_DEBUG_REG52_MMU_RTR_MASK) | (mmu_rtr << MH_DEBUG_REG52_MMU_RTR_SHIFT)
#define MH_DEBUG_REG52_SET_RF_MMU_CONFIG_q_25_to_4(mh_debug_reg52_reg, rf_mmu_config_q_25_to_4) \
     mh_debug_reg52_reg = (mh_debug_reg52_reg & ~MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_MASK) | (rf_mmu_config_q_25_to_4 << MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_SHIFT)
#define MH_DEBUG_REG52_SET_ARB_ID_q(mh_debug_reg52_reg, arb_id_q) \
     mh_debug_reg52_reg = (mh_debug_reg52_reg & ~MH_DEBUG_REG52_ARB_ID_q_MASK) | (arb_id_q << MH_DEBUG_REG52_ARB_ID_q_SHIFT)
#define MH_DEBUG_REG52_SET_ARB_WRITE_q(mh_debug_reg52_reg, arb_write_q) \
     mh_debug_reg52_reg = (mh_debug_reg52_reg & ~MH_DEBUG_REG52_ARB_WRITE_q_MASK) | (arb_write_q << MH_DEBUG_REG52_ARB_WRITE_q_SHIFT)
#define MH_DEBUG_REG52_SET_client_behavior_q(mh_debug_reg52_reg, client_behavior_q) \
     mh_debug_reg52_reg = (mh_debug_reg52_reg & ~MH_DEBUG_REG52_client_behavior_q_MASK) | (client_behavior_q << MH_DEBUG_REG52_client_behavior_q_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg52_t {
          unsigned int rf_mmu_config_q_1_to_0         : MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_SIZE;
          unsigned int arb_we                         : MH_DEBUG_REG52_ARB_WE_SIZE;
          unsigned int mmu_rtr                        : MH_DEBUG_REG52_MMU_RTR_SIZE;
          unsigned int rf_mmu_config_q_25_to_4        : MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_SIZE;
          unsigned int arb_id_q                       : MH_DEBUG_REG52_ARB_ID_q_SIZE;
          unsigned int arb_write_q                    : MH_DEBUG_REG52_ARB_WRITE_q_SIZE;
          unsigned int client_behavior_q              : MH_DEBUG_REG52_client_behavior_q_SIZE;
     } mh_debug_reg52_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg52_t {
          unsigned int client_behavior_q              : MH_DEBUG_REG52_client_behavior_q_SIZE;
          unsigned int arb_write_q                    : MH_DEBUG_REG52_ARB_WRITE_q_SIZE;
          unsigned int arb_id_q                       : MH_DEBUG_REG52_ARB_ID_q_SIZE;
          unsigned int rf_mmu_config_q_25_to_4        : MH_DEBUG_REG52_RF_MMU_CONFIG_q_25_to_4_SIZE;
          unsigned int mmu_rtr                        : MH_DEBUG_REG52_MMU_RTR_SIZE;
          unsigned int arb_we                         : MH_DEBUG_REG52_ARB_WE_SIZE;
          unsigned int rf_mmu_config_q_1_to_0         : MH_DEBUG_REG52_RF_MMU_CONFIG_q_1_to_0_SIZE;
     } mh_debug_reg52_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg52_t f;
} mh_debug_reg52_u;


/*
 * MH_DEBUG_REG53 struct
 */

#define MH_DEBUG_REG53_stage1_valid_SIZE 1
#define MH_DEBUG_REG53_IGNORE_TAG_MISS_q_SIZE 1
#define MH_DEBUG_REG53_pa_in_mpu_range_SIZE 1
#define MH_DEBUG_REG53_tag_match_q_SIZE 1
#define MH_DEBUG_REG53_tag_miss_q_SIZE 1
#define MH_DEBUG_REG53_va_in_range_q_SIZE 1
#define MH_DEBUG_REG53_MMU_MISS_SIZE   1
#define MH_DEBUG_REG53_MMU_READ_MISS_SIZE 1
#define MH_DEBUG_REG53_MMU_WRITE_MISS_SIZE 1
#define MH_DEBUG_REG53_MMU_HIT_SIZE    1
#define MH_DEBUG_REG53_MMU_READ_HIT_SIZE 1
#define MH_DEBUG_REG53_MMU_WRITE_HIT_SIZE 1
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_SIZE 1
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_SIZE 1
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_SIZE 1
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_SIZE 1
#define MH_DEBUG_REG53_REQ_VA_OFFSET_q_SIZE 16

#define MH_DEBUG_REG53_stage1_valid_SHIFT 0
#define MH_DEBUG_REG53_IGNORE_TAG_MISS_q_SHIFT 1
#define MH_DEBUG_REG53_pa_in_mpu_range_SHIFT 2
#define MH_DEBUG_REG53_tag_match_q_SHIFT 3
#define MH_DEBUG_REG53_tag_miss_q_SHIFT 4
#define MH_DEBUG_REG53_va_in_range_q_SHIFT 5
#define MH_DEBUG_REG53_MMU_MISS_SHIFT  6
#define MH_DEBUG_REG53_MMU_READ_MISS_SHIFT 7
#define MH_DEBUG_REG53_MMU_WRITE_MISS_SHIFT 8
#define MH_DEBUG_REG53_MMU_HIT_SHIFT   9
#define MH_DEBUG_REG53_MMU_READ_HIT_SHIFT 10
#define MH_DEBUG_REG53_MMU_WRITE_HIT_SHIFT 11
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_SHIFT 12
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_SHIFT 13
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_SHIFT 14
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_SHIFT 15
#define MH_DEBUG_REG53_REQ_VA_OFFSET_q_SHIFT 16

#define MH_DEBUG_REG53_stage1_valid_MASK 0x00000001
#define MH_DEBUG_REG53_IGNORE_TAG_MISS_q_MASK 0x00000002
#define MH_DEBUG_REG53_pa_in_mpu_range_MASK 0x00000004
#define MH_DEBUG_REG53_tag_match_q_MASK 0x00000008
#define MH_DEBUG_REG53_tag_miss_q_MASK 0x00000010
#define MH_DEBUG_REG53_va_in_range_q_MASK 0x00000020
#define MH_DEBUG_REG53_MMU_MISS_MASK   0x00000040
#define MH_DEBUG_REG53_MMU_READ_MISS_MASK 0x00000080
#define MH_DEBUG_REG53_MMU_WRITE_MISS_MASK 0x00000100
#define MH_DEBUG_REG53_MMU_HIT_MASK    0x00000200
#define MH_DEBUG_REG53_MMU_READ_HIT_MASK 0x00000400
#define MH_DEBUG_REG53_MMU_WRITE_HIT_MASK 0x00000800
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_MASK 0x00001000
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_MASK 0x00002000
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_MASK 0x00004000
#define MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_MASK 0x00008000
#define MH_DEBUG_REG53_REQ_VA_OFFSET_q_MASK 0xffff0000

#define MH_DEBUG_REG53_MASK \
     (MH_DEBUG_REG53_stage1_valid_MASK | \
      MH_DEBUG_REG53_IGNORE_TAG_MISS_q_MASK | \
      MH_DEBUG_REG53_pa_in_mpu_range_MASK | \
      MH_DEBUG_REG53_tag_match_q_MASK | \
      MH_DEBUG_REG53_tag_miss_q_MASK | \
      MH_DEBUG_REG53_va_in_range_q_MASK | \
      MH_DEBUG_REG53_MMU_MISS_MASK | \
      MH_DEBUG_REG53_MMU_READ_MISS_MASK | \
      MH_DEBUG_REG53_MMU_WRITE_MISS_MASK | \
      MH_DEBUG_REG53_MMU_HIT_MASK | \
      MH_DEBUG_REG53_MMU_READ_HIT_MASK | \
      MH_DEBUG_REG53_MMU_WRITE_HIT_MASK | \
      MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_MASK | \
      MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_MASK | \
      MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_MASK | \
      MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_MASK | \
      MH_DEBUG_REG53_REQ_VA_OFFSET_q_MASK)

#define MH_DEBUG_REG53(stage1_valid, ignore_tag_miss_q, pa_in_mpu_range, tag_match_q, tag_miss_q, va_in_range_q, mmu_miss, mmu_read_miss, mmu_write_miss, mmu_hit, mmu_read_hit, mmu_write_hit, mmu_split_mode_tc_miss, mmu_split_mode_tc_hit, mmu_split_mode_nontc_miss, mmu_split_mode_nontc_hit, req_va_offset_q) \
     ((stage1_valid << MH_DEBUG_REG53_stage1_valid_SHIFT) | \
      (ignore_tag_miss_q << MH_DEBUG_REG53_IGNORE_TAG_MISS_q_SHIFT) | \
      (pa_in_mpu_range << MH_DEBUG_REG53_pa_in_mpu_range_SHIFT) | \
      (tag_match_q << MH_DEBUG_REG53_tag_match_q_SHIFT) | \
      (tag_miss_q << MH_DEBUG_REG53_tag_miss_q_SHIFT) | \
      (va_in_range_q << MH_DEBUG_REG53_va_in_range_q_SHIFT) | \
      (mmu_miss << MH_DEBUG_REG53_MMU_MISS_SHIFT) | \
      (mmu_read_miss << MH_DEBUG_REG53_MMU_READ_MISS_SHIFT) | \
      (mmu_write_miss << MH_DEBUG_REG53_MMU_WRITE_MISS_SHIFT) | \
      (mmu_hit << MH_DEBUG_REG53_MMU_HIT_SHIFT) | \
      (mmu_read_hit << MH_DEBUG_REG53_MMU_READ_HIT_SHIFT) | \
      (mmu_write_hit << MH_DEBUG_REG53_MMU_WRITE_HIT_SHIFT) | \
      (mmu_split_mode_tc_miss << MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_SHIFT) | \
      (mmu_split_mode_tc_hit << MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_SHIFT) | \
      (mmu_split_mode_nontc_miss << MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_SHIFT) | \
      (mmu_split_mode_nontc_hit << MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_SHIFT) | \
      (req_va_offset_q << MH_DEBUG_REG53_REQ_VA_OFFSET_q_SHIFT))

#define MH_DEBUG_REG53_GET_stage1_valid(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_stage1_valid_MASK) >> MH_DEBUG_REG53_stage1_valid_SHIFT)
#define MH_DEBUG_REG53_GET_IGNORE_TAG_MISS_q(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_IGNORE_TAG_MISS_q_MASK) >> MH_DEBUG_REG53_IGNORE_TAG_MISS_q_SHIFT)
#define MH_DEBUG_REG53_GET_pa_in_mpu_range(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_pa_in_mpu_range_MASK) >> MH_DEBUG_REG53_pa_in_mpu_range_SHIFT)
#define MH_DEBUG_REG53_GET_tag_match_q(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_tag_match_q_MASK) >> MH_DEBUG_REG53_tag_match_q_SHIFT)
#define MH_DEBUG_REG53_GET_tag_miss_q(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_tag_miss_q_MASK) >> MH_DEBUG_REG53_tag_miss_q_SHIFT)
#define MH_DEBUG_REG53_GET_va_in_range_q(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_va_in_range_q_MASK) >> MH_DEBUG_REG53_va_in_range_q_SHIFT)
#define MH_DEBUG_REG53_GET_MMU_MISS(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_MMU_MISS_MASK) >> MH_DEBUG_REG53_MMU_MISS_SHIFT)
#define MH_DEBUG_REG53_GET_MMU_READ_MISS(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_MMU_READ_MISS_MASK) >> MH_DEBUG_REG53_MMU_READ_MISS_SHIFT)
#define MH_DEBUG_REG53_GET_MMU_WRITE_MISS(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_MMU_WRITE_MISS_MASK) >> MH_DEBUG_REG53_MMU_WRITE_MISS_SHIFT)
#define MH_DEBUG_REG53_GET_MMU_HIT(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_MMU_HIT_MASK) >> MH_DEBUG_REG53_MMU_HIT_SHIFT)
#define MH_DEBUG_REG53_GET_MMU_READ_HIT(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_MMU_READ_HIT_MASK) >> MH_DEBUG_REG53_MMU_READ_HIT_SHIFT)
#define MH_DEBUG_REG53_GET_MMU_WRITE_HIT(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_MMU_WRITE_HIT_MASK) >> MH_DEBUG_REG53_MMU_WRITE_HIT_SHIFT)
#define MH_DEBUG_REG53_GET_MMU_SPLIT_MODE_TC_MISS(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_MASK) >> MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_SHIFT)
#define MH_DEBUG_REG53_GET_MMU_SPLIT_MODE_TC_HIT(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_MASK) >> MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_SHIFT)
#define MH_DEBUG_REG53_GET_MMU_SPLIT_MODE_nonTC_MISS(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_MASK) >> MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_SHIFT)
#define MH_DEBUG_REG53_GET_MMU_SPLIT_MODE_nonTC_HIT(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_MASK) >> MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_SHIFT)
#define MH_DEBUG_REG53_GET_REQ_VA_OFFSET_q(mh_debug_reg53) \
     ((mh_debug_reg53 & MH_DEBUG_REG53_REQ_VA_OFFSET_q_MASK) >> MH_DEBUG_REG53_REQ_VA_OFFSET_q_SHIFT)

#define MH_DEBUG_REG53_SET_stage1_valid(mh_debug_reg53_reg, stage1_valid) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_stage1_valid_MASK) | (stage1_valid << MH_DEBUG_REG53_stage1_valid_SHIFT)
#define MH_DEBUG_REG53_SET_IGNORE_TAG_MISS_q(mh_debug_reg53_reg, ignore_tag_miss_q) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_IGNORE_TAG_MISS_q_MASK) | (ignore_tag_miss_q << MH_DEBUG_REG53_IGNORE_TAG_MISS_q_SHIFT)
#define MH_DEBUG_REG53_SET_pa_in_mpu_range(mh_debug_reg53_reg, pa_in_mpu_range) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_pa_in_mpu_range_MASK) | (pa_in_mpu_range << MH_DEBUG_REG53_pa_in_mpu_range_SHIFT)
#define MH_DEBUG_REG53_SET_tag_match_q(mh_debug_reg53_reg, tag_match_q) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_tag_match_q_MASK) | (tag_match_q << MH_DEBUG_REG53_tag_match_q_SHIFT)
#define MH_DEBUG_REG53_SET_tag_miss_q(mh_debug_reg53_reg, tag_miss_q) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_tag_miss_q_MASK) | (tag_miss_q << MH_DEBUG_REG53_tag_miss_q_SHIFT)
#define MH_DEBUG_REG53_SET_va_in_range_q(mh_debug_reg53_reg, va_in_range_q) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_va_in_range_q_MASK) | (va_in_range_q << MH_DEBUG_REG53_va_in_range_q_SHIFT)
#define MH_DEBUG_REG53_SET_MMU_MISS(mh_debug_reg53_reg, mmu_miss) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_MMU_MISS_MASK) | (mmu_miss << MH_DEBUG_REG53_MMU_MISS_SHIFT)
#define MH_DEBUG_REG53_SET_MMU_READ_MISS(mh_debug_reg53_reg, mmu_read_miss) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_MMU_READ_MISS_MASK) | (mmu_read_miss << MH_DEBUG_REG53_MMU_READ_MISS_SHIFT)
#define MH_DEBUG_REG53_SET_MMU_WRITE_MISS(mh_debug_reg53_reg, mmu_write_miss) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_MMU_WRITE_MISS_MASK) | (mmu_write_miss << MH_DEBUG_REG53_MMU_WRITE_MISS_SHIFT)
#define MH_DEBUG_REG53_SET_MMU_HIT(mh_debug_reg53_reg, mmu_hit) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_MMU_HIT_MASK) | (mmu_hit << MH_DEBUG_REG53_MMU_HIT_SHIFT)
#define MH_DEBUG_REG53_SET_MMU_READ_HIT(mh_debug_reg53_reg, mmu_read_hit) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_MMU_READ_HIT_MASK) | (mmu_read_hit << MH_DEBUG_REG53_MMU_READ_HIT_SHIFT)
#define MH_DEBUG_REG53_SET_MMU_WRITE_HIT(mh_debug_reg53_reg, mmu_write_hit) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_MMU_WRITE_HIT_MASK) | (mmu_write_hit << MH_DEBUG_REG53_MMU_WRITE_HIT_SHIFT)
#define MH_DEBUG_REG53_SET_MMU_SPLIT_MODE_TC_MISS(mh_debug_reg53_reg, mmu_split_mode_tc_miss) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_MASK) | (mmu_split_mode_tc_miss << MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_SHIFT)
#define MH_DEBUG_REG53_SET_MMU_SPLIT_MODE_TC_HIT(mh_debug_reg53_reg, mmu_split_mode_tc_hit) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_MASK) | (mmu_split_mode_tc_hit << MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_SHIFT)
#define MH_DEBUG_REG53_SET_MMU_SPLIT_MODE_nonTC_MISS(mh_debug_reg53_reg, mmu_split_mode_nontc_miss) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_MASK) | (mmu_split_mode_nontc_miss << MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_SHIFT)
#define MH_DEBUG_REG53_SET_MMU_SPLIT_MODE_nonTC_HIT(mh_debug_reg53_reg, mmu_split_mode_nontc_hit) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_MASK) | (mmu_split_mode_nontc_hit << MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_SHIFT)
#define MH_DEBUG_REG53_SET_REQ_VA_OFFSET_q(mh_debug_reg53_reg, req_va_offset_q) \
     mh_debug_reg53_reg = (mh_debug_reg53_reg & ~MH_DEBUG_REG53_REQ_VA_OFFSET_q_MASK) | (req_va_offset_q << MH_DEBUG_REG53_REQ_VA_OFFSET_q_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg53_t {
          unsigned int stage1_valid                   : MH_DEBUG_REG53_stage1_valid_SIZE;
          unsigned int ignore_tag_miss_q              : MH_DEBUG_REG53_IGNORE_TAG_MISS_q_SIZE;
          unsigned int pa_in_mpu_range                : MH_DEBUG_REG53_pa_in_mpu_range_SIZE;
          unsigned int tag_match_q                    : MH_DEBUG_REG53_tag_match_q_SIZE;
          unsigned int tag_miss_q                     : MH_DEBUG_REG53_tag_miss_q_SIZE;
          unsigned int va_in_range_q                  : MH_DEBUG_REG53_va_in_range_q_SIZE;
          unsigned int mmu_miss                       : MH_DEBUG_REG53_MMU_MISS_SIZE;
          unsigned int mmu_read_miss                  : MH_DEBUG_REG53_MMU_READ_MISS_SIZE;
          unsigned int mmu_write_miss                 : MH_DEBUG_REG53_MMU_WRITE_MISS_SIZE;
          unsigned int mmu_hit                        : MH_DEBUG_REG53_MMU_HIT_SIZE;
          unsigned int mmu_read_hit                   : MH_DEBUG_REG53_MMU_READ_HIT_SIZE;
          unsigned int mmu_write_hit                  : MH_DEBUG_REG53_MMU_WRITE_HIT_SIZE;
          unsigned int mmu_split_mode_tc_miss         : MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_SIZE;
          unsigned int mmu_split_mode_tc_hit          : MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_SIZE;
          unsigned int mmu_split_mode_nontc_miss      : MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_SIZE;
          unsigned int mmu_split_mode_nontc_hit       : MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_SIZE;
          unsigned int req_va_offset_q                : MH_DEBUG_REG53_REQ_VA_OFFSET_q_SIZE;
     } mh_debug_reg53_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg53_t {
          unsigned int req_va_offset_q                : MH_DEBUG_REG53_REQ_VA_OFFSET_q_SIZE;
          unsigned int mmu_split_mode_nontc_hit       : MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_HIT_SIZE;
          unsigned int mmu_split_mode_nontc_miss      : MH_DEBUG_REG53_MMU_SPLIT_MODE_nonTC_MISS_SIZE;
          unsigned int mmu_split_mode_tc_hit          : MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_HIT_SIZE;
          unsigned int mmu_split_mode_tc_miss         : MH_DEBUG_REG53_MMU_SPLIT_MODE_TC_MISS_SIZE;
          unsigned int mmu_write_hit                  : MH_DEBUG_REG53_MMU_WRITE_HIT_SIZE;
          unsigned int mmu_read_hit                   : MH_DEBUG_REG53_MMU_READ_HIT_SIZE;
          unsigned int mmu_hit                        : MH_DEBUG_REG53_MMU_HIT_SIZE;
          unsigned int mmu_write_miss                 : MH_DEBUG_REG53_MMU_WRITE_MISS_SIZE;
          unsigned int mmu_read_miss                  : MH_DEBUG_REG53_MMU_READ_MISS_SIZE;
          unsigned int mmu_miss                       : MH_DEBUG_REG53_MMU_MISS_SIZE;
          unsigned int va_in_range_q                  : MH_DEBUG_REG53_va_in_range_q_SIZE;
          unsigned int tag_miss_q                     : MH_DEBUG_REG53_tag_miss_q_SIZE;
          unsigned int tag_match_q                    : MH_DEBUG_REG53_tag_match_q_SIZE;
          unsigned int pa_in_mpu_range                : MH_DEBUG_REG53_pa_in_mpu_range_SIZE;
          unsigned int ignore_tag_miss_q              : MH_DEBUG_REG53_IGNORE_TAG_MISS_q_SIZE;
          unsigned int stage1_valid                   : MH_DEBUG_REG53_stage1_valid_SIZE;
     } mh_debug_reg53_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg53_t f;
} mh_debug_reg53_u;


/*
 * MH_DEBUG_REG54 struct
 */

#define MH_DEBUG_REG54_ARQ_RTR_SIZE    1
#define MH_DEBUG_REG54_MMU_WE_SIZE     1
#define MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_SIZE 1
#define MH_DEBUG_REG54_TLBMISS_CTRL_RTS_SIZE 1
#define MH_DEBUG_REG54_MH_TLBMISS_SEND_SIZE 1
#define MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_SIZE 1
#define MH_DEBUG_REG54_pa_in_mpu_range_SIZE 1
#define MH_DEBUG_REG54_stage1_valid_SIZE 1
#define MH_DEBUG_REG54_stage2_valid_SIZE 1
#define MH_DEBUG_REG54_client_behavior_q_SIZE 2
#define MH_DEBUG_REG54_IGNORE_TAG_MISS_q_SIZE 1
#define MH_DEBUG_REG54_tag_match_q_SIZE 1
#define MH_DEBUG_REG54_tag_miss_q_SIZE 1
#define MH_DEBUG_REG54_va_in_range_q_SIZE 1
#define MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_SIZE 1
#define MH_DEBUG_REG54_TAG_valid_q_SIZE 16

#define MH_DEBUG_REG54_ARQ_RTR_SHIFT   0
#define MH_DEBUG_REG54_MMU_WE_SHIFT    1
#define MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_SHIFT 2
#define MH_DEBUG_REG54_TLBMISS_CTRL_RTS_SHIFT 3
#define MH_DEBUG_REG54_MH_TLBMISS_SEND_SHIFT 4
#define MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_SHIFT 5
#define MH_DEBUG_REG54_pa_in_mpu_range_SHIFT 6
#define MH_DEBUG_REG54_stage1_valid_SHIFT 7
#define MH_DEBUG_REG54_stage2_valid_SHIFT 8
#define MH_DEBUG_REG54_client_behavior_q_SHIFT 9
#define MH_DEBUG_REG54_IGNORE_TAG_MISS_q_SHIFT 11
#define MH_DEBUG_REG54_tag_match_q_SHIFT 12
#define MH_DEBUG_REG54_tag_miss_q_SHIFT 13
#define MH_DEBUG_REG54_va_in_range_q_SHIFT 14
#define MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_SHIFT 15
#define MH_DEBUG_REG54_TAG_valid_q_SHIFT 16

#define MH_DEBUG_REG54_ARQ_RTR_MASK    0x00000001
#define MH_DEBUG_REG54_MMU_WE_MASK     0x00000002
#define MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_MASK 0x00000004
#define MH_DEBUG_REG54_TLBMISS_CTRL_RTS_MASK 0x00000008
#define MH_DEBUG_REG54_MH_TLBMISS_SEND_MASK 0x00000010
#define MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_MASK 0x00000020
#define MH_DEBUG_REG54_pa_in_mpu_range_MASK 0x00000040
#define MH_DEBUG_REG54_stage1_valid_MASK 0x00000080
#define MH_DEBUG_REG54_stage2_valid_MASK 0x00000100
#define MH_DEBUG_REG54_client_behavior_q_MASK 0x00000600
#define MH_DEBUG_REG54_IGNORE_TAG_MISS_q_MASK 0x00000800
#define MH_DEBUG_REG54_tag_match_q_MASK 0x00001000
#define MH_DEBUG_REG54_tag_miss_q_MASK 0x00002000
#define MH_DEBUG_REG54_va_in_range_q_MASK 0x00004000
#define MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_MASK 0x00008000
#define MH_DEBUG_REG54_TAG_valid_q_MASK 0xffff0000

#define MH_DEBUG_REG54_MASK \
     (MH_DEBUG_REG54_ARQ_RTR_MASK | \
      MH_DEBUG_REG54_MMU_WE_MASK | \
      MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_MASK | \
      MH_DEBUG_REG54_TLBMISS_CTRL_RTS_MASK | \
      MH_DEBUG_REG54_MH_TLBMISS_SEND_MASK | \
      MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_MASK | \
      MH_DEBUG_REG54_pa_in_mpu_range_MASK | \
      MH_DEBUG_REG54_stage1_valid_MASK | \
      MH_DEBUG_REG54_stage2_valid_MASK | \
      MH_DEBUG_REG54_client_behavior_q_MASK | \
      MH_DEBUG_REG54_IGNORE_TAG_MISS_q_MASK | \
      MH_DEBUG_REG54_tag_match_q_MASK | \
      MH_DEBUG_REG54_tag_miss_q_MASK | \
      MH_DEBUG_REG54_va_in_range_q_MASK | \
      MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_MASK | \
      MH_DEBUG_REG54_TAG_valid_q_MASK)

#define MH_DEBUG_REG54(arq_rtr, mmu_we, ctrl_tlbmiss_re_q, tlbmiss_ctrl_rts, mh_tlbmiss_send, mmu_stall_awaiting_tlb_miss_fetch, pa_in_mpu_range, stage1_valid, stage2_valid, client_behavior_q, ignore_tag_miss_q, tag_match_q, tag_miss_q, va_in_range_q, pte_fetch_complete_q, tag_valid_q) \
     ((arq_rtr << MH_DEBUG_REG54_ARQ_RTR_SHIFT) | \
      (mmu_we << MH_DEBUG_REG54_MMU_WE_SHIFT) | \
      (ctrl_tlbmiss_re_q << MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_SHIFT) | \
      (tlbmiss_ctrl_rts << MH_DEBUG_REG54_TLBMISS_CTRL_RTS_SHIFT) | \
      (mh_tlbmiss_send << MH_DEBUG_REG54_MH_TLBMISS_SEND_SHIFT) | \
      (mmu_stall_awaiting_tlb_miss_fetch << MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_SHIFT) | \
      (pa_in_mpu_range << MH_DEBUG_REG54_pa_in_mpu_range_SHIFT) | \
      (stage1_valid << MH_DEBUG_REG54_stage1_valid_SHIFT) | \
      (stage2_valid << MH_DEBUG_REG54_stage2_valid_SHIFT) | \
      (client_behavior_q << MH_DEBUG_REG54_client_behavior_q_SHIFT) | \
      (ignore_tag_miss_q << MH_DEBUG_REG54_IGNORE_TAG_MISS_q_SHIFT) | \
      (tag_match_q << MH_DEBUG_REG54_tag_match_q_SHIFT) | \
      (tag_miss_q << MH_DEBUG_REG54_tag_miss_q_SHIFT) | \
      (va_in_range_q << MH_DEBUG_REG54_va_in_range_q_SHIFT) | \
      (pte_fetch_complete_q << MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_SHIFT) | \
      (tag_valid_q << MH_DEBUG_REG54_TAG_valid_q_SHIFT))

#define MH_DEBUG_REG54_GET_ARQ_RTR(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_ARQ_RTR_MASK) >> MH_DEBUG_REG54_ARQ_RTR_SHIFT)
#define MH_DEBUG_REG54_GET_MMU_WE(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_MMU_WE_MASK) >> MH_DEBUG_REG54_MMU_WE_SHIFT)
#define MH_DEBUG_REG54_GET_CTRL_TLBMISS_RE_q(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_MASK) >> MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_SHIFT)
#define MH_DEBUG_REG54_GET_TLBMISS_CTRL_RTS(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_TLBMISS_CTRL_RTS_MASK) >> MH_DEBUG_REG54_TLBMISS_CTRL_RTS_SHIFT)
#define MH_DEBUG_REG54_GET_MH_TLBMISS_SEND(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_MH_TLBMISS_SEND_MASK) >> MH_DEBUG_REG54_MH_TLBMISS_SEND_SHIFT)
#define MH_DEBUG_REG54_GET_MMU_STALL_AWAITING_TLB_MISS_FETCH(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_MASK) >> MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_SHIFT)
#define MH_DEBUG_REG54_GET_pa_in_mpu_range(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_pa_in_mpu_range_MASK) >> MH_DEBUG_REG54_pa_in_mpu_range_SHIFT)
#define MH_DEBUG_REG54_GET_stage1_valid(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_stage1_valid_MASK) >> MH_DEBUG_REG54_stage1_valid_SHIFT)
#define MH_DEBUG_REG54_GET_stage2_valid(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_stage2_valid_MASK) >> MH_DEBUG_REG54_stage2_valid_SHIFT)
#define MH_DEBUG_REG54_GET_client_behavior_q(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_client_behavior_q_MASK) >> MH_DEBUG_REG54_client_behavior_q_SHIFT)
#define MH_DEBUG_REG54_GET_IGNORE_TAG_MISS_q(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_IGNORE_TAG_MISS_q_MASK) >> MH_DEBUG_REG54_IGNORE_TAG_MISS_q_SHIFT)
#define MH_DEBUG_REG54_GET_tag_match_q(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_tag_match_q_MASK) >> MH_DEBUG_REG54_tag_match_q_SHIFT)
#define MH_DEBUG_REG54_GET_tag_miss_q(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_tag_miss_q_MASK) >> MH_DEBUG_REG54_tag_miss_q_SHIFT)
#define MH_DEBUG_REG54_GET_va_in_range_q(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_va_in_range_q_MASK) >> MH_DEBUG_REG54_va_in_range_q_SHIFT)
#define MH_DEBUG_REG54_GET_PTE_FETCH_COMPLETE_q(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_MASK) >> MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_SHIFT)
#define MH_DEBUG_REG54_GET_TAG_valid_q(mh_debug_reg54) \
     ((mh_debug_reg54 & MH_DEBUG_REG54_TAG_valid_q_MASK) >> MH_DEBUG_REG54_TAG_valid_q_SHIFT)

#define MH_DEBUG_REG54_SET_ARQ_RTR(mh_debug_reg54_reg, arq_rtr) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_ARQ_RTR_MASK) | (arq_rtr << MH_DEBUG_REG54_ARQ_RTR_SHIFT)
#define MH_DEBUG_REG54_SET_MMU_WE(mh_debug_reg54_reg, mmu_we) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_MMU_WE_MASK) | (mmu_we << MH_DEBUG_REG54_MMU_WE_SHIFT)
#define MH_DEBUG_REG54_SET_CTRL_TLBMISS_RE_q(mh_debug_reg54_reg, ctrl_tlbmiss_re_q) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_MASK) | (ctrl_tlbmiss_re_q << MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_SHIFT)
#define MH_DEBUG_REG54_SET_TLBMISS_CTRL_RTS(mh_debug_reg54_reg, tlbmiss_ctrl_rts) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_TLBMISS_CTRL_RTS_MASK) | (tlbmiss_ctrl_rts << MH_DEBUG_REG54_TLBMISS_CTRL_RTS_SHIFT)
#define MH_DEBUG_REG54_SET_MH_TLBMISS_SEND(mh_debug_reg54_reg, mh_tlbmiss_send) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_MH_TLBMISS_SEND_MASK) | (mh_tlbmiss_send << MH_DEBUG_REG54_MH_TLBMISS_SEND_SHIFT)
#define MH_DEBUG_REG54_SET_MMU_STALL_AWAITING_TLB_MISS_FETCH(mh_debug_reg54_reg, mmu_stall_awaiting_tlb_miss_fetch) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_MASK) | (mmu_stall_awaiting_tlb_miss_fetch << MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_SHIFT)
#define MH_DEBUG_REG54_SET_pa_in_mpu_range(mh_debug_reg54_reg, pa_in_mpu_range) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_pa_in_mpu_range_MASK) | (pa_in_mpu_range << MH_DEBUG_REG54_pa_in_mpu_range_SHIFT)
#define MH_DEBUG_REG54_SET_stage1_valid(mh_debug_reg54_reg, stage1_valid) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_stage1_valid_MASK) | (stage1_valid << MH_DEBUG_REG54_stage1_valid_SHIFT)
#define MH_DEBUG_REG54_SET_stage2_valid(mh_debug_reg54_reg, stage2_valid) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_stage2_valid_MASK) | (stage2_valid << MH_DEBUG_REG54_stage2_valid_SHIFT)
#define MH_DEBUG_REG54_SET_client_behavior_q(mh_debug_reg54_reg, client_behavior_q) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_client_behavior_q_MASK) | (client_behavior_q << MH_DEBUG_REG54_client_behavior_q_SHIFT)
#define MH_DEBUG_REG54_SET_IGNORE_TAG_MISS_q(mh_debug_reg54_reg, ignore_tag_miss_q) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_IGNORE_TAG_MISS_q_MASK) | (ignore_tag_miss_q << MH_DEBUG_REG54_IGNORE_TAG_MISS_q_SHIFT)
#define MH_DEBUG_REG54_SET_tag_match_q(mh_debug_reg54_reg, tag_match_q) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_tag_match_q_MASK) | (tag_match_q << MH_DEBUG_REG54_tag_match_q_SHIFT)
#define MH_DEBUG_REG54_SET_tag_miss_q(mh_debug_reg54_reg, tag_miss_q) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_tag_miss_q_MASK) | (tag_miss_q << MH_DEBUG_REG54_tag_miss_q_SHIFT)
#define MH_DEBUG_REG54_SET_va_in_range_q(mh_debug_reg54_reg, va_in_range_q) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_va_in_range_q_MASK) | (va_in_range_q << MH_DEBUG_REG54_va_in_range_q_SHIFT)
#define MH_DEBUG_REG54_SET_PTE_FETCH_COMPLETE_q(mh_debug_reg54_reg, pte_fetch_complete_q) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_MASK) | (pte_fetch_complete_q << MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_SHIFT)
#define MH_DEBUG_REG54_SET_TAG_valid_q(mh_debug_reg54_reg, tag_valid_q) \
     mh_debug_reg54_reg = (mh_debug_reg54_reg & ~MH_DEBUG_REG54_TAG_valid_q_MASK) | (tag_valid_q << MH_DEBUG_REG54_TAG_valid_q_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg54_t {
          unsigned int arq_rtr                        : MH_DEBUG_REG54_ARQ_RTR_SIZE;
          unsigned int mmu_we                         : MH_DEBUG_REG54_MMU_WE_SIZE;
          unsigned int ctrl_tlbmiss_re_q              : MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_SIZE;
          unsigned int tlbmiss_ctrl_rts               : MH_DEBUG_REG54_TLBMISS_CTRL_RTS_SIZE;
          unsigned int mh_tlbmiss_send                : MH_DEBUG_REG54_MH_TLBMISS_SEND_SIZE;
          unsigned int mmu_stall_awaiting_tlb_miss_fetch : MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_SIZE;
          unsigned int pa_in_mpu_range                : MH_DEBUG_REG54_pa_in_mpu_range_SIZE;
          unsigned int stage1_valid                   : MH_DEBUG_REG54_stage1_valid_SIZE;
          unsigned int stage2_valid                   : MH_DEBUG_REG54_stage2_valid_SIZE;
          unsigned int client_behavior_q              : MH_DEBUG_REG54_client_behavior_q_SIZE;
          unsigned int ignore_tag_miss_q              : MH_DEBUG_REG54_IGNORE_TAG_MISS_q_SIZE;
          unsigned int tag_match_q                    : MH_DEBUG_REG54_tag_match_q_SIZE;
          unsigned int tag_miss_q                     : MH_DEBUG_REG54_tag_miss_q_SIZE;
          unsigned int va_in_range_q                  : MH_DEBUG_REG54_va_in_range_q_SIZE;
          unsigned int pte_fetch_complete_q           : MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_SIZE;
          unsigned int tag_valid_q                    : MH_DEBUG_REG54_TAG_valid_q_SIZE;
     } mh_debug_reg54_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg54_t {
          unsigned int tag_valid_q                    : MH_DEBUG_REG54_TAG_valid_q_SIZE;
          unsigned int pte_fetch_complete_q           : MH_DEBUG_REG54_PTE_FETCH_COMPLETE_q_SIZE;
          unsigned int va_in_range_q                  : MH_DEBUG_REG54_va_in_range_q_SIZE;
          unsigned int tag_miss_q                     : MH_DEBUG_REG54_tag_miss_q_SIZE;
          unsigned int tag_match_q                    : MH_DEBUG_REG54_tag_match_q_SIZE;
          unsigned int ignore_tag_miss_q              : MH_DEBUG_REG54_IGNORE_TAG_MISS_q_SIZE;
          unsigned int client_behavior_q              : MH_DEBUG_REG54_client_behavior_q_SIZE;
          unsigned int stage2_valid                   : MH_DEBUG_REG54_stage2_valid_SIZE;
          unsigned int stage1_valid                   : MH_DEBUG_REG54_stage1_valid_SIZE;
          unsigned int pa_in_mpu_range                : MH_DEBUG_REG54_pa_in_mpu_range_SIZE;
          unsigned int mmu_stall_awaiting_tlb_miss_fetch : MH_DEBUG_REG54_MMU_STALL_AWAITING_TLB_MISS_FETCH_SIZE;
          unsigned int mh_tlbmiss_send                : MH_DEBUG_REG54_MH_TLBMISS_SEND_SIZE;
          unsigned int tlbmiss_ctrl_rts               : MH_DEBUG_REG54_TLBMISS_CTRL_RTS_SIZE;
          unsigned int ctrl_tlbmiss_re_q              : MH_DEBUG_REG54_CTRL_TLBMISS_RE_q_SIZE;
          unsigned int mmu_we                         : MH_DEBUG_REG54_MMU_WE_SIZE;
          unsigned int arq_rtr                        : MH_DEBUG_REG54_ARQ_RTR_SIZE;
     } mh_debug_reg54_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg54_t f;
} mh_debug_reg54_u;


/*
 * MH_DEBUG_REG55 struct
 */

#define MH_DEBUG_REG55_TAG0_VA_SIZE    13
#define MH_DEBUG_REG55_TAG_valid_q_0_SIZE 1
#define MH_DEBUG_REG55_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG55_TAG1_VA_SIZE    13
#define MH_DEBUG_REG55_TAG_valid_q_1_SIZE 1

#define MH_DEBUG_REG55_TAG0_VA_SHIFT   0
#define MH_DEBUG_REG55_TAG_valid_q_0_SHIFT 13
#define MH_DEBUG_REG55_ALWAYS_ZERO_SHIFT 14
#define MH_DEBUG_REG55_TAG1_VA_SHIFT   16
#define MH_DEBUG_REG55_TAG_valid_q_1_SHIFT 29

#define MH_DEBUG_REG55_TAG0_VA_MASK    0x00001fff
#define MH_DEBUG_REG55_TAG_valid_q_0_MASK 0x00002000
#define MH_DEBUG_REG55_ALWAYS_ZERO_MASK 0x0000c000
#define MH_DEBUG_REG55_TAG1_VA_MASK    0x1fff0000
#define MH_DEBUG_REG55_TAG_valid_q_1_MASK 0x20000000

#define MH_DEBUG_REG55_MASK \
     (MH_DEBUG_REG55_TAG0_VA_MASK | \
      MH_DEBUG_REG55_TAG_valid_q_0_MASK | \
      MH_DEBUG_REG55_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG55_TAG1_VA_MASK | \
      MH_DEBUG_REG55_TAG_valid_q_1_MASK)

#define MH_DEBUG_REG55(tag0_va, tag_valid_q_0, always_zero, tag1_va, tag_valid_q_1) \
     ((tag0_va << MH_DEBUG_REG55_TAG0_VA_SHIFT) | \
      (tag_valid_q_0 << MH_DEBUG_REG55_TAG_valid_q_0_SHIFT) | \
      (always_zero << MH_DEBUG_REG55_ALWAYS_ZERO_SHIFT) | \
      (tag1_va << MH_DEBUG_REG55_TAG1_VA_SHIFT) | \
      (tag_valid_q_1 << MH_DEBUG_REG55_TAG_valid_q_1_SHIFT))

#define MH_DEBUG_REG55_GET_TAG0_VA(mh_debug_reg55) \
     ((mh_debug_reg55 & MH_DEBUG_REG55_TAG0_VA_MASK) >> MH_DEBUG_REG55_TAG0_VA_SHIFT)
#define MH_DEBUG_REG55_GET_TAG_valid_q_0(mh_debug_reg55) \
     ((mh_debug_reg55 & MH_DEBUG_REG55_TAG_valid_q_0_MASK) >> MH_DEBUG_REG55_TAG_valid_q_0_SHIFT)
#define MH_DEBUG_REG55_GET_ALWAYS_ZERO(mh_debug_reg55) \
     ((mh_debug_reg55 & MH_DEBUG_REG55_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG55_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG55_GET_TAG1_VA(mh_debug_reg55) \
     ((mh_debug_reg55 & MH_DEBUG_REG55_TAG1_VA_MASK) >> MH_DEBUG_REG55_TAG1_VA_SHIFT)
#define MH_DEBUG_REG55_GET_TAG_valid_q_1(mh_debug_reg55) \
     ((mh_debug_reg55 & MH_DEBUG_REG55_TAG_valid_q_1_MASK) >> MH_DEBUG_REG55_TAG_valid_q_1_SHIFT)

#define MH_DEBUG_REG55_SET_TAG0_VA(mh_debug_reg55_reg, tag0_va) \
     mh_debug_reg55_reg = (mh_debug_reg55_reg & ~MH_DEBUG_REG55_TAG0_VA_MASK) | (tag0_va << MH_DEBUG_REG55_TAG0_VA_SHIFT)
#define MH_DEBUG_REG55_SET_TAG_valid_q_0(mh_debug_reg55_reg, tag_valid_q_0) \
     mh_debug_reg55_reg = (mh_debug_reg55_reg & ~MH_DEBUG_REG55_TAG_valid_q_0_MASK) | (tag_valid_q_0 << MH_DEBUG_REG55_TAG_valid_q_0_SHIFT)
#define MH_DEBUG_REG55_SET_ALWAYS_ZERO(mh_debug_reg55_reg, always_zero) \
     mh_debug_reg55_reg = (mh_debug_reg55_reg & ~MH_DEBUG_REG55_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG55_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG55_SET_TAG1_VA(mh_debug_reg55_reg, tag1_va) \
     mh_debug_reg55_reg = (mh_debug_reg55_reg & ~MH_DEBUG_REG55_TAG1_VA_MASK) | (tag1_va << MH_DEBUG_REG55_TAG1_VA_SHIFT)
#define MH_DEBUG_REG55_SET_TAG_valid_q_1(mh_debug_reg55_reg, tag_valid_q_1) \
     mh_debug_reg55_reg = (mh_debug_reg55_reg & ~MH_DEBUG_REG55_TAG_valid_q_1_MASK) | (tag_valid_q_1 << MH_DEBUG_REG55_TAG_valid_q_1_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg55_t {
          unsigned int tag0_va                        : MH_DEBUG_REG55_TAG0_VA_SIZE;
          unsigned int tag_valid_q_0                  : MH_DEBUG_REG55_TAG_valid_q_0_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG55_ALWAYS_ZERO_SIZE;
          unsigned int tag1_va                        : MH_DEBUG_REG55_TAG1_VA_SIZE;
          unsigned int tag_valid_q_1                  : MH_DEBUG_REG55_TAG_valid_q_1_SIZE;
          unsigned int                                : 2;
     } mh_debug_reg55_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg55_t {
          unsigned int                                : 2;
          unsigned int tag_valid_q_1                  : MH_DEBUG_REG55_TAG_valid_q_1_SIZE;
          unsigned int tag1_va                        : MH_DEBUG_REG55_TAG1_VA_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG55_ALWAYS_ZERO_SIZE;
          unsigned int tag_valid_q_0                  : MH_DEBUG_REG55_TAG_valid_q_0_SIZE;
          unsigned int tag0_va                        : MH_DEBUG_REG55_TAG0_VA_SIZE;
     } mh_debug_reg55_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg55_t f;
} mh_debug_reg55_u;


/*
 * MH_DEBUG_REG56 struct
 */

#define MH_DEBUG_REG56_TAG2_VA_SIZE    13
#define MH_DEBUG_REG56_TAG_valid_q_2_SIZE 1
#define MH_DEBUG_REG56_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG56_TAG3_VA_SIZE    13
#define MH_DEBUG_REG56_TAG_valid_q_3_SIZE 1

#define MH_DEBUG_REG56_TAG2_VA_SHIFT   0
#define MH_DEBUG_REG56_TAG_valid_q_2_SHIFT 13
#define MH_DEBUG_REG56_ALWAYS_ZERO_SHIFT 14
#define MH_DEBUG_REG56_TAG3_VA_SHIFT   16
#define MH_DEBUG_REG56_TAG_valid_q_3_SHIFT 29

#define MH_DEBUG_REG56_TAG2_VA_MASK    0x00001fff
#define MH_DEBUG_REG56_TAG_valid_q_2_MASK 0x00002000
#define MH_DEBUG_REG56_ALWAYS_ZERO_MASK 0x0000c000
#define MH_DEBUG_REG56_TAG3_VA_MASK    0x1fff0000
#define MH_DEBUG_REG56_TAG_valid_q_3_MASK 0x20000000

#define MH_DEBUG_REG56_MASK \
     (MH_DEBUG_REG56_TAG2_VA_MASK | \
      MH_DEBUG_REG56_TAG_valid_q_2_MASK | \
      MH_DEBUG_REG56_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG56_TAG3_VA_MASK | \
      MH_DEBUG_REG56_TAG_valid_q_3_MASK)

#define MH_DEBUG_REG56(tag2_va, tag_valid_q_2, always_zero, tag3_va, tag_valid_q_3) \
     ((tag2_va << MH_DEBUG_REG56_TAG2_VA_SHIFT) | \
      (tag_valid_q_2 << MH_DEBUG_REG56_TAG_valid_q_2_SHIFT) | \
      (always_zero << MH_DEBUG_REG56_ALWAYS_ZERO_SHIFT) | \
      (tag3_va << MH_DEBUG_REG56_TAG3_VA_SHIFT) | \
      (tag_valid_q_3 << MH_DEBUG_REG56_TAG_valid_q_3_SHIFT))

#define MH_DEBUG_REG56_GET_TAG2_VA(mh_debug_reg56) \
     ((mh_debug_reg56 & MH_DEBUG_REG56_TAG2_VA_MASK) >> MH_DEBUG_REG56_TAG2_VA_SHIFT)
#define MH_DEBUG_REG56_GET_TAG_valid_q_2(mh_debug_reg56) \
     ((mh_debug_reg56 & MH_DEBUG_REG56_TAG_valid_q_2_MASK) >> MH_DEBUG_REG56_TAG_valid_q_2_SHIFT)
#define MH_DEBUG_REG56_GET_ALWAYS_ZERO(mh_debug_reg56) \
     ((mh_debug_reg56 & MH_DEBUG_REG56_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG56_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG56_GET_TAG3_VA(mh_debug_reg56) \
     ((mh_debug_reg56 & MH_DEBUG_REG56_TAG3_VA_MASK) >> MH_DEBUG_REG56_TAG3_VA_SHIFT)
#define MH_DEBUG_REG56_GET_TAG_valid_q_3(mh_debug_reg56) \
     ((mh_debug_reg56 & MH_DEBUG_REG56_TAG_valid_q_3_MASK) >> MH_DEBUG_REG56_TAG_valid_q_3_SHIFT)

#define MH_DEBUG_REG56_SET_TAG2_VA(mh_debug_reg56_reg, tag2_va) \
     mh_debug_reg56_reg = (mh_debug_reg56_reg & ~MH_DEBUG_REG56_TAG2_VA_MASK) | (tag2_va << MH_DEBUG_REG56_TAG2_VA_SHIFT)
#define MH_DEBUG_REG56_SET_TAG_valid_q_2(mh_debug_reg56_reg, tag_valid_q_2) \
     mh_debug_reg56_reg = (mh_debug_reg56_reg & ~MH_DEBUG_REG56_TAG_valid_q_2_MASK) | (tag_valid_q_2 << MH_DEBUG_REG56_TAG_valid_q_2_SHIFT)
#define MH_DEBUG_REG56_SET_ALWAYS_ZERO(mh_debug_reg56_reg, always_zero) \
     mh_debug_reg56_reg = (mh_debug_reg56_reg & ~MH_DEBUG_REG56_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG56_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG56_SET_TAG3_VA(mh_debug_reg56_reg, tag3_va) \
     mh_debug_reg56_reg = (mh_debug_reg56_reg & ~MH_DEBUG_REG56_TAG3_VA_MASK) | (tag3_va << MH_DEBUG_REG56_TAG3_VA_SHIFT)
#define MH_DEBUG_REG56_SET_TAG_valid_q_3(mh_debug_reg56_reg, tag_valid_q_3) \
     mh_debug_reg56_reg = (mh_debug_reg56_reg & ~MH_DEBUG_REG56_TAG_valid_q_3_MASK) | (tag_valid_q_3 << MH_DEBUG_REG56_TAG_valid_q_3_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg56_t {
          unsigned int tag2_va                        : MH_DEBUG_REG56_TAG2_VA_SIZE;
          unsigned int tag_valid_q_2                  : MH_DEBUG_REG56_TAG_valid_q_2_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG56_ALWAYS_ZERO_SIZE;
          unsigned int tag3_va                        : MH_DEBUG_REG56_TAG3_VA_SIZE;
          unsigned int tag_valid_q_3                  : MH_DEBUG_REG56_TAG_valid_q_3_SIZE;
          unsigned int                                : 2;
     } mh_debug_reg56_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg56_t {
          unsigned int                                : 2;
          unsigned int tag_valid_q_3                  : MH_DEBUG_REG56_TAG_valid_q_3_SIZE;
          unsigned int tag3_va                        : MH_DEBUG_REG56_TAG3_VA_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG56_ALWAYS_ZERO_SIZE;
          unsigned int tag_valid_q_2                  : MH_DEBUG_REG56_TAG_valid_q_2_SIZE;
          unsigned int tag2_va                        : MH_DEBUG_REG56_TAG2_VA_SIZE;
     } mh_debug_reg56_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg56_t f;
} mh_debug_reg56_u;


/*
 * MH_DEBUG_REG57 struct
 */

#define MH_DEBUG_REG57_TAG4_VA_SIZE    13
#define MH_DEBUG_REG57_TAG_valid_q_4_SIZE 1
#define MH_DEBUG_REG57_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG57_TAG5_VA_SIZE    13
#define MH_DEBUG_REG57_TAG_valid_q_5_SIZE 1

#define MH_DEBUG_REG57_TAG4_VA_SHIFT   0
#define MH_DEBUG_REG57_TAG_valid_q_4_SHIFT 13
#define MH_DEBUG_REG57_ALWAYS_ZERO_SHIFT 14
#define MH_DEBUG_REG57_TAG5_VA_SHIFT   16
#define MH_DEBUG_REG57_TAG_valid_q_5_SHIFT 29

#define MH_DEBUG_REG57_TAG4_VA_MASK    0x00001fff
#define MH_DEBUG_REG57_TAG_valid_q_4_MASK 0x00002000
#define MH_DEBUG_REG57_ALWAYS_ZERO_MASK 0x0000c000
#define MH_DEBUG_REG57_TAG5_VA_MASK    0x1fff0000
#define MH_DEBUG_REG57_TAG_valid_q_5_MASK 0x20000000

#define MH_DEBUG_REG57_MASK \
     (MH_DEBUG_REG57_TAG4_VA_MASK | \
      MH_DEBUG_REG57_TAG_valid_q_4_MASK | \
      MH_DEBUG_REG57_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG57_TAG5_VA_MASK | \
      MH_DEBUG_REG57_TAG_valid_q_5_MASK)

#define MH_DEBUG_REG57(tag4_va, tag_valid_q_4, always_zero, tag5_va, tag_valid_q_5) \
     ((tag4_va << MH_DEBUG_REG57_TAG4_VA_SHIFT) | \
      (tag_valid_q_4 << MH_DEBUG_REG57_TAG_valid_q_4_SHIFT) | \
      (always_zero << MH_DEBUG_REG57_ALWAYS_ZERO_SHIFT) | \
      (tag5_va << MH_DEBUG_REG57_TAG5_VA_SHIFT) | \
      (tag_valid_q_5 << MH_DEBUG_REG57_TAG_valid_q_5_SHIFT))

#define MH_DEBUG_REG57_GET_TAG4_VA(mh_debug_reg57) \
     ((mh_debug_reg57 & MH_DEBUG_REG57_TAG4_VA_MASK) >> MH_DEBUG_REG57_TAG4_VA_SHIFT)
#define MH_DEBUG_REG57_GET_TAG_valid_q_4(mh_debug_reg57) \
     ((mh_debug_reg57 & MH_DEBUG_REG57_TAG_valid_q_4_MASK) >> MH_DEBUG_REG57_TAG_valid_q_4_SHIFT)
#define MH_DEBUG_REG57_GET_ALWAYS_ZERO(mh_debug_reg57) \
     ((mh_debug_reg57 & MH_DEBUG_REG57_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG57_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG57_GET_TAG5_VA(mh_debug_reg57) \
     ((mh_debug_reg57 & MH_DEBUG_REG57_TAG5_VA_MASK) >> MH_DEBUG_REG57_TAG5_VA_SHIFT)
#define MH_DEBUG_REG57_GET_TAG_valid_q_5(mh_debug_reg57) \
     ((mh_debug_reg57 & MH_DEBUG_REG57_TAG_valid_q_5_MASK) >> MH_DEBUG_REG57_TAG_valid_q_5_SHIFT)

#define MH_DEBUG_REG57_SET_TAG4_VA(mh_debug_reg57_reg, tag4_va) \
     mh_debug_reg57_reg = (mh_debug_reg57_reg & ~MH_DEBUG_REG57_TAG4_VA_MASK) | (tag4_va << MH_DEBUG_REG57_TAG4_VA_SHIFT)
#define MH_DEBUG_REG57_SET_TAG_valid_q_4(mh_debug_reg57_reg, tag_valid_q_4) \
     mh_debug_reg57_reg = (mh_debug_reg57_reg & ~MH_DEBUG_REG57_TAG_valid_q_4_MASK) | (tag_valid_q_4 << MH_DEBUG_REG57_TAG_valid_q_4_SHIFT)
#define MH_DEBUG_REG57_SET_ALWAYS_ZERO(mh_debug_reg57_reg, always_zero) \
     mh_debug_reg57_reg = (mh_debug_reg57_reg & ~MH_DEBUG_REG57_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG57_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG57_SET_TAG5_VA(mh_debug_reg57_reg, tag5_va) \
     mh_debug_reg57_reg = (mh_debug_reg57_reg & ~MH_DEBUG_REG57_TAG5_VA_MASK) | (tag5_va << MH_DEBUG_REG57_TAG5_VA_SHIFT)
#define MH_DEBUG_REG57_SET_TAG_valid_q_5(mh_debug_reg57_reg, tag_valid_q_5) \
     mh_debug_reg57_reg = (mh_debug_reg57_reg & ~MH_DEBUG_REG57_TAG_valid_q_5_MASK) | (tag_valid_q_5 << MH_DEBUG_REG57_TAG_valid_q_5_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg57_t {
          unsigned int tag4_va                        : MH_DEBUG_REG57_TAG4_VA_SIZE;
          unsigned int tag_valid_q_4                  : MH_DEBUG_REG57_TAG_valid_q_4_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG57_ALWAYS_ZERO_SIZE;
          unsigned int tag5_va                        : MH_DEBUG_REG57_TAG5_VA_SIZE;
          unsigned int tag_valid_q_5                  : MH_DEBUG_REG57_TAG_valid_q_5_SIZE;
          unsigned int                                : 2;
     } mh_debug_reg57_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg57_t {
          unsigned int                                : 2;
          unsigned int tag_valid_q_5                  : MH_DEBUG_REG57_TAG_valid_q_5_SIZE;
          unsigned int tag5_va                        : MH_DEBUG_REG57_TAG5_VA_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG57_ALWAYS_ZERO_SIZE;
          unsigned int tag_valid_q_4                  : MH_DEBUG_REG57_TAG_valid_q_4_SIZE;
          unsigned int tag4_va                        : MH_DEBUG_REG57_TAG4_VA_SIZE;
     } mh_debug_reg57_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg57_t f;
} mh_debug_reg57_u;


/*
 * MH_DEBUG_REG58 struct
 */

#define MH_DEBUG_REG58_TAG6_VA_SIZE    13
#define MH_DEBUG_REG58_TAG_valid_q_6_SIZE 1
#define MH_DEBUG_REG58_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG58_TAG7_VA_SIZE    13
#define MH_DEBUG_REG58_TAG_valid_q_7_SIZE 1

#define MH_DEBUG_REG58_TAG6_VA_SHIFT   0
#define MH_DEBUG_REG58_TAG_valid_q_6_SHIFT 13
#define MH_DEBUG_REG58_ALWAYS_ZERO_SHIFT 14
#define MH_DEBUG_REG58_TAG7_VA_SHIFT   16
#define MH_DEBUG_REG58_TAG_valid_q_7_SHIFT 29

#define MH_DEBUG_REG58_TAG6_VA_MASK    0x00001fff
#define MH_DEBUG_REG58_TAG_valid_q_6_MASK 0x00002000
#define MH_DEBUG_REG58_ALWAYS_ZERO_MASK 0x0000c000
#define MH_DEBUG_REG58_TAG7_VA_MASK    0x1fff0000
#define MH_DEBUG_REG58_TAG_valid_q_7_MASK 0x20000000

#define MH_DEBUG_REG58_MASK \
     (MH_DEBUG_REG58_TAG6_VA_MASK | \
      MH_DEBUG_REG58_TAG_valid_q_6_MASK | \
      MH_DEBUG_REG58_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG58_TAG7_VA_MASK | \
      MH_DEBUG_REG58_TAG_valid_q_7_MASK)

#define MH_DEBUG_REG58(tag6_va, tag_valid_q_6, always_zero, tag7_va, tag_valid_q_7) \
     ((tag6_va << MH_DEBUG_REG58_TAG6_VA_SHIFT) | \
      (tag_valid_q_6 << MH_DEBUG_REG58_TAG_valid_q_6_SHIFT) | \
      (always_zero << MH_DEBUG_REG58_ALWAYS_ZERO_SHIFT) | \
      (tag7_va << MH_DEBUG_REG58_TAG7_VA_SHIFT) | \
      (tag_valid_q_7 << MH_DEBUG_REG58_TAG_valid_q_7_SHIFT))

#define MH_DEBUG_REG58_GET_TAG6_VA(mh_debug_reg58) \
     ((mh_debug_reg58 & MH_DEBUG_REG58_TAG6_VA_MASK) >> MH_DEBUG_REG58_TAG6_VA_SHIFT)
#define MH_DEBUG_REG58_GET_TAG_valid_q_6(mh_debug_reg58) \
     ((mh_debug_reg58 & MH_DEBUG_REG58_TAG_valid_q_6_MASK) >> MH_DEBUG_REG58_TAG_valid_q_6_SHIFT)
#define MH_DEBUG_REG58_GET_ALWAYS_ZERO(mh_debug_reg58) \
     ((mh_debug_reg58 & MH_DEBUG_REG58_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG58_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG58_GET_TAG7_VA(mh_debug_reg58) \
     ((mh_debug_reg58 & MH_DEBUG_REG58_TAG7_VA_MASK) >> MH_DEBUG_REG58_TAG7_VA_SHIFT)
#define MH_DEBUG_REG58_GET_TAG_valid_q_7(mh_debug_reg58) \
     ((mh_debug_reg58 & MH_DEBUG_REG58_TAG_valid_q_7_MASK) >> MH_DEBUG_REG58_TAG_valid_q_7_SHIFT)

#define MH_DEBUG_REG58_SET_TAG6_VA(mh_debug_reg58_reg, tag6_va) \
     mh_debug_reg58_reg = (mh_debug_reg58_reg & ~MH_DEBUG_REG58_TAG6_VA_MASK) | (tag6_va << MH_DEBUG_REG58_TAG6_VA_SHIFT)
#define MH_DEBUG_REG58_SET_TAG_valid_q_6(mh_debug_reg58_reg, tag_valid_q_6) \
     mh_debug_reg58_reg = (mh_debug_reg58_reg & ~MH_DEBUG_REG58_TAG_valid_q_6_MASK) | (tag_valid_q_6 << MH_DEBUG_REG58_TAG_valid_q_6_SHIFT)
#define MH_DEBUG_REG58_SET_ALWAYS_ZERO(mh_debug_reg58_reg, always_zero) \
     mh_debug_reg58_reg = (mh_debug_reg58_reg & ~MH_DEBUG_REG58_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG58_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG58_SET_TAG7_VA(mh_debug_reg58_reg, tag7_va) \
     mh_debug_reg58_reg = (mh_debug_reg58_reg & ~MH_DEBUG_REG58_TAG7_VA_MASK) | (tag7_va << MH_DEBUG_REG58_TAG7_VA_SHIFT)
#define MH_DEBUG_REG58_SET_TAG_valid_q_7(mh_debug_reg58_reg, tag_valid_q_7) \
     mh_debug_reg58_reg = (mh_debug_reg58_reg & ~MH_DEBUG_REG58_TAG_valid_q_7_MASK) | (tag_valid_q_7 << MH_DEBUG_REG58_TAG_valid_q_7_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg58_t {
          unsigned int tag6_va                        : MH_DEBUG_REG58_TAG6_VA_SIZE;
          unsigned int tag_valid_q_6                  : MH_DEBUG_REG58_TAG_valid_q_6_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG58_ALWAYS_ZERO_SIZE;
          unsigned int tag7_va                        : MH_DEBUG_REG58_TAG7_VA_SIZE;
          unsigned int tag_valid_q_7                  : MH_DEBUG_REG58_TAG_valid_q_7_SIZE;
          unsigned int                                : 2;
     } mh_debug_reg58_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg58_t {
          unsigned int                                : 2;
          unsigned int tag_valid_q_7                  : MH_DEBUG_REG58_TAG_valid_q_7_SIZE;
          unsigned int tag7_va                        : MH_DEBUG_REG58_TAG7_VA_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG58_ALWAYS_ZERO_SIZE;
          unsigned int tag_valid_q_6                  : MH_DEBUG_REG58_TAG_valid_q_6_SIZE;
          unsigned int tag6_va                        : MH_DEBUG_REG58_TAG6_VA_SIZE;
     } mh_debug_reg58_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg58_t f;
} mh_debug_reg58_u;


/*
 * MH_DEBUG_REG59 struct
 */

#define MH_DEBUG_REG59_TAG8_VA_SIZE    13
#define MH_DEBUG_REG59_TAG_valid_q_8_SIZE 1
#define MH_DEBUG_REG59_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG59_TAG9_VA_SIZE    13
#define MH_DEBUG_REG59_TAG_valid_q_9_SIZE 1

#define MH_DEBUG_REG59_TAG8_VA_SHIFT   0
#define MH_DEBUG_REG59_TAG_valid_q_8_SHIFT 13
#define MH_DEBUG_REG59_ALWAYS_ZERO_SHIFT 14
#define MH_DEBUG_REG59_TAG9_VA_SHIFT   16
#define MH_DEBUG_REG59_TAG_valid_q_9_SHIFT 29

#define MH_DEBUG_REG59_TAG8_VA_MASK    0x00001fff
#define MH_DEBUG_REG59_TAG_valid_q_8_MASK 0x00002000
#define MH_DEBUG_REG59_ALWAYS_ZERO_MASK 0x0000c000
#define MH_DEBUG_REG59_TAG9_VA_MASK    0x1fff0000
#define MH_DEBUG_REG59_TAG_valid_q_9_MASK 0x20000000

#define MH_DEBUG_REG59_MASK \
     (MH_DEBUG_REG59_TAG8_VA_MASK | \
      MH_DEBUG_REG59_TAG_valid_q_8_MASK | \
      MH_DEBUG_REG59_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG59_TAG9_VA_MASK | \
      MH_DEBUG_REG59_TAG_valid_q_9_MASK)

#define MH_DEBUG_REG59(tag8_va, tag_valid_q_8, always_zero, tag9_va, tag_valid_q_9) \
     ((tag8_va << MH_DEBUG_REG59_TAG8_VA_SHIFT) | \
      (tag_valid_q_8 << MH_DEBUG_REG59_TAG_valid_q_8_SHIFT) | \
      (always_zero << MH_DEBUG_REG59_ALWAYS_ZERO_SHIFT) | \
      (tag9_va << MH_DEBUG_REG59_TAG9_VA_SHIFT) | \
      (tag_valid_q_9 << MH_DEBUG_REG59_TAG_valid_q_9_SHIFT))

#define MH_DEBUG_REG59_GET_TAG8_VA(mh_debug_reg59) \
     ((mh_debug_reg59 & MH_DEBUG_REG59_TAG8_VA_MASK) >> MH_DEBUG_REG59_TAG8_VA_SHIFT)
#define MH_DEBUG_REG59_GET_TAG_valid_q_8(mh_debug_reg59) \
     ((mh_debug_reg59 & MH_DEBUG_REG59_TAG_valid_q_8_MASK) >> MH_DEBUG_REG59_TAG_valid_q_8_SHIFT)
#define MH_DEBUG_REG59_GET_ALWAYS_ZERO(mh_debug_reg59) \
     ((mh_debug_reg59 & MH_DEBUG_REG59_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG59_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG59_GET_TAG9_VA(mh_debug_reg59) \
     ((mh_debug_reg59 & MH_DEBUG_REG59_TAG9_VA_MASK) >> MH_DEBUG_REG59_TAG9_VA_SHIFT)
#define MH_DEBUG_REG59_GET_TAG_valid_q_9(mh_debug_reg59) \
     ((mh_debug_reg59 & MH_DEBUG_REG59_TAG_valid_q_9_MASK) >> MH_DEBUG_REG59_TAG_valid_q_9_SHIFT)

#define MH_DEBUG_REG59_SET_TAG8_VA(mh_debug_reg59_reg, tag8_va) \
     mh_debug_reg59_reg = (mh_debug_reg59_reg & ~MH_DEBUG_REG59_TAG8_VA_MASK) | (tag8_va << MH_DEBUG_REG59_TAG8_VA_SHIFT)
#define MH_DEBUG_REG59_SET_TAG_valid_q_8(mh_debug_reg59_reg, tag_valid_q_8) \
     mh_debug_reg59_reg = (mh_debug_reg59_reg & ~MH_DEBUG_REG59_TAG_valid_q_8_MASK) | (tag_valid_q_8 << MH_DEBUG_REG59_TAG_valid_q_8_SHIFT)
#define MH_DEBUG_REG59_SET_ALWAYS_ZERO(mh_debug_reg59_reg, always_zero) \
     mh_debug_reg59_reg = (mh_debug_reg59_reg & ~MH_DEBUG_REG59_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG59_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG59_SET_TAG9_VA(mh_debug_reg59_reg, tag9_va) \
     mh_debug_reg59_reg = (mh_debug_reg59_reg & ~MH_DEBUG_REG59_TAG9_VA_MASK) | (tag9_va << MH_DEBUG_REG59_TAG9_VA_SHIFT)
#define MH_DEBUG_REG59_SET_TAG_valid_q_9(mh_debug_reg59_reg, tag_valid_q_9) \
     mh_debug_reg59_reg = (mh_debug_reg59_reg & ~MH_DEBUG_REG59_TAG_valid_q_9_MASK) | (tag_valid_q_9 << MH_DEBUG_REG59_TAG_valid_q_9_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg59_t {
          unsigned int tag8_va                        : MH_DEBUG_REG59_TAG8_VA_SIZE;
          unsigned int tag_valid_q_8                  : MH_DEBUG_REG59_TAG_valid_q_8_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG59_ALWAYS_ZERO_SIZE;
          unsigned int tag9_va                        : MH_DEBUG_REG59_TAG9_VA_SIZE;
          unsigned int tag_valid_q_9                  : MH_DEBUG_REG59_TAG_valid_q_9_SIZE;
          unsigned int                                : 2;
     } mh_debug_reg59_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg59_t {
          unsigned int                                : 2;
          unsigned int tag_valid_q_9                  : MH_DEBUG_REG59_TAG_valid_q_9_SIZE;
          unsigned int tag9_va                        : MH_DEBUG_REG59_TAG9_VA_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG59_ALWAYS_ZERO_SIZE;
          unsigned int tag_valid_q_8                  : MH_DEBUG_REG59_TAG_valid_q_8_SIZE;
          unsigned int tag8_va                        : MH_DEBUG_REG59_TAG8_VA_SIZE;
     } mh_debug_reg59_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg59_t f;
} mh_debug_reg59_u;


/*
 * MH_DEBUG_REG60 struct
 */

#define MH_DEBUG_REG60_TAG10_VA_SIZE   13
#define MH_DEBUG_REG60_TAG_valid_q_10_SIZE 1
#define MH_DEBUG_REG60_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG60_TAG11_VA_SIZE   13
#define MH_DEBUG_REG60_TAG_valid_q_11_SIZE 1

#define MH_DEBUG_REG60_TAG10_VA_SHIFT  0
#define MH_DEBUG_REG60_TAG_valid_q_10_SHIFT 13
#define MH_DEBUG_REG60_ALWAYS_ZERO_SHIFT 14
#define MH_DEBUG_REG60_TAG11_VA_SHIFT  16
#define MH_DEBUG_REG60_TAG_valid_q_11_SHIFT 29

#define MH_DEBUG_REG60_TAG10_VA_MASK   0x00001fff
#define MH_DEBUG_REG60_TAG_valid_q_10_MASK 0x00002000
#define MH_DEBUG_REG60_ALWAYS_ZERO_MASK 0x0000c000
#define MH_DEBUG_REG60_TAG11_VA_MASK   0x1fff0000
#define MH_DEBUG_REG60_TAG_valid_q_11_MASK 0x20000000

#define MH_DEBUG_REG60_MASK \
     (MH_DEBUG_REG60_TAG10_VA_MASK | \
      MH_DEBUG_REG60_TAG_valid_q_10_MASK | \
      MH_DEBUG_REG60_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG60_TAG11_VA_MASK | \
      MH_DEBUG_REG60_TAG_valid_q_11_MASK)

#define MH_DEBUG_REG60(tag10_va, tag_valid_q_10, always_zero, tag11_va, tag_valid_q_11) \
     ((tag10_va << MH_DEBUG_REG60_TAG10_VA_SHIFT) | \
      (tag_valid_q_10 << MH_DEBUG_REG60_TAG_valid_q_10_SHIFT) | \
      (always_zero << MH_DEBUG_REG60_ALWAYS_ZERO_SHIFT) | \
      (tag11_va << MH_DEBUG_REG60_TAG11_VA_SHIFT) | \
      (tag_valid_q_11 << MH_DEBUG_REG60_TAG_valid_q_11_SHIFT))

#define MH_DEBUG_REG60_GET_TAG10_VA(mh_debug_reg60) \
     ((mh_debug_reg60 & MH_DEBUG_REG60_TAG10_VA_MASK) >> MH_DEBUG_REG60_TAG10_VA_SHIFT)
#define MH_DEBUG_REG60_GET_TAG_valid_q_10(mh_debug_reg60) \
     ((mh_debug_reg60 & MH_DEBUG_REG60_TAG_valid_q_10_MASK) >> MH_DEBUG_REG60_TAG_valid_q_10_SHIFT)
#define MH_DEBUG_REG60_GET_ALWAYS_ZERO(mh_debug_reg60) \
     ((mh_debug_reg60 & MH_DEBUG_REG60_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG60_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG60_GET_TAG11_VA(mh_debug_reg60) \
     ((mh_debug_reg60 & MH_DEBUG_REG60_TAG11_VA_MASK) >> MH_DEBUG_REG60_TAG11_VA_SHIFT)
#define MH_DEBUG_REG60_GET_TAG_valid_q_11(mh_debug_reg60) \
     ((mh_debug_reg60 & MH_DEBUG_REG60_TAG_valid_q_11_MASK) >> MH_DEBUG_REG60_TAG_valid_q_11_SHIFT)

#define MH_DEBUG_REG60_SET_TAG10_VA(mh_debug_reg60_reg, tag10_va) \
     mh_debug_reg60_reg = (mh_debug_reg60_reg & ~MH_DEBUG_REG60_TAG10_VA_MASK) | (tag10_va << MH_DEBUG_REG60_TAG10_VA_SHIFT)
#define MH_DEBUG_REG60_SET_TAG_valid_q_10(mh_debug_reg60_reg, tag_valid_q_10) \
     mh_debug_reg60_reg = (mh_debug_reg60_reg & ~MH_DEBUG_REG60_TAG_valid_q_10_MASK) | (tag_valid_q_10 << MH_DEBUG_REG60_TAG_valid_q_10_SHIFT)
#define MH_DEBUG_REG60_SET_ALWAYS_ZERO(mh_debug_reg60_reg, always_zero) \
     mh_debug_reg60_reg = (mh_debug_reg60_reg & ~MH_DEBUG_REG60_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG60_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG60_SET_TAG11_VA(mh_debug_reg60_reg, tag11_va) \
     mh_debug_reg60_reg = (mh_debug_reg60_reg & ~MH_DEBUG_REG60_TAG11_VA_MASK) | (tag11_va << MH_DEBUG_REG60_TAG11_VA_SHIFT)
#define MH_DEBUG_REG60_SET_TAG_valid_q_11(mh_debug_reg60_reg, tag_valid_q_11) \
     mh_debug_reg60_reg = (mh_debug_reg60_reg & ~MH_DEBUG_REG60_TAG_valid_q_11_MASK) | (tag_valid_q_11 << MH_DEBUG_REG60_TAG_valid_q_11_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg60_t {
          unsigned int tag10_va                       : MH_DEBUG_REG60_TAG10_VA_SIZE;
          unsigned int tag_valid_q_10                 : MH_DEBUG_REG60_TAG_valid_q_10_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG60_ALWAYS_ZERO_SIZE;
          unsigned int tag11_va                       : MH_DEBUG_REG60_TAG11_VA_SIZE;
          unsigned int tag_valid_q_11                 : MH_DEBUG_REG60_TAG_valid_q_11_SIZE;
          unsigned int                                : 2;
     } mh_debug_reg60_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg60_t {
          unsigned int                                : 2;
          unsigned int tag_valid_q_11                 : MH_DEBUG_REG60_TAG_valid_q_11_SIZE;
          unsigned int tag11_va                       : MH_DEBUG_REG60_TAG11_VA_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG60_ALWAYS_ZERO_SIZE;
          unsigned int tag_valid_q_10                 : MH_DEBUG_REG60_TAG_valid_q_10_SIZE;
          unsigned int tag10_va                       : MH_DEBUG_REG60_TAG10_VA_SIZE;
     } mh_debug_reg60_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg60_t f;
} mh_debug_reg60_u;


/*
 * MH_DEBUG_REG61 struct
 */

#define MH_DEBUG_REG61_TAG12_VA_SIZE   13
#define MH_DEBUG_REG61_TAG_valid_q_12_SIZE 1
#define MH_DEBUG_REG61_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG61_TAG13_VA_SIZE   13
#define MH_DEBUG_REG61_TAG_valid_q_13_SIZE 1

#define MH_DEBUG_REG61_TAG12_VA_SHIFT  0
#define MH_DEBUG_REG61_TAG_valid_q_12_SHIFT 13
#define MH_DEBUG_REG61_ALWAYS_ZERO_SHIFT 14
#define MH_DEBUG_REG61_TAG13_VA_SHIFT  16
#define MH_DEBUG_REG61_TAG_valid_q_13_SHIFT 29

#define MH_DEBUG_REG61_TAG12_VA_MASK   0x00001fff
#define MH_DEBUG_REG61_TAG_valid_q_12_MASK 0x00002000
#define MH_DEBUG_REG61_ALWAYS_ZERO_MASK 0x0000c000
#define MH_DEBUG_REG61_TAG13_VA_MASK   0x1fff0000
#define MH_DEBUG_REG61_TAG_valid_q_13_MASK 0x20000000

#define MH_DEBUG_REG61_MASK \
     (MH_DEBUG_REG61_TAG12_VA_MASK | \
      MH_DEBUG_REG61_TAG_valid_q_12_MASK | \
      MH_DEBUG_REG61_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG61_TAG13_VA_MASK | \
      MH_DEBUG_REG61_TAG_valid_q_13_MASK)

#define MH_DEBUG_REG61(tag12_va, tag_valid_q_12, always_zero, tag13_va, tag_valid_q_13) \
     ((tag12_va << MH_DEBUG_REG61_TAG12_VA_SHIFT) | \
      (tag_valid_q_12 << MH_DEBUG_REG61_TAG_valid_q_12_SHIFT) | \
      (always_zero << MH_DEBUG_REG61_ALWAYS_ZERO_SHIFT) | \
      (tag13_va << MH_DEBUG_REG61_TAG13_VA_SHIFT) | \
      (tag_valid_q_13 << MH_DEBUG_REG61_TAG_valid_q_13_SHIFT))

#define MH_DEBUG_REG61_GET_TAG12_VA(mh_debug_reg61) \
     ((mh_debug_reg61 & MH_DEBUG_REG61_TAG12_VA_MASK) >> MH_DEBUG_REG61_TAG12_VA_SHIFT)
#define MH_DEBUG_REG61_GET_TAG_valid_q_12(mh_debug_reg61) \
     ((mh_debug_reg61 & MH_DEBUG_REG61_TAG_valid_q_12_MASK) >> MH_DEBUG_REG61_TAG_valid_q_12_SHIFT)
#define MH_DEBUG_REG61_GET_ALWAYS_ZERO(mh_debug_reg61) \
     ((mh_debug_reg61 & MH_DEBUG_REG61_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG61_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG61_GET_TAG13_VA(mh_debug_reg61) \
     ((mh_debug_reg61 & MH_DEBUG_REG61_TAG13_VA_MASK) >> MH_DEBUG_REG61_TAG13_VA_SHIFT)
#define MH_DEBUG_REG61_GET_TAG_valid_q_13(mh_debug_reg61) \
     ((mh_debug_reg61 & MH_DEBUG_REG61_TAG_valid_q_13_MASK) >> MH_DEBUG_REG61_TAG_valid_q_13_SHIFT)

#define MH_DEBUG_REG61_SET_TAG12_VA(mh_debug_reg61_reg, tag12_va) \
     mh_debug_reg61_reg = (mh_debug_reg61_reg & ~MH_DEBUG_REG61_TAG12_VA_MASK) | (tag12_va << MH_DEBUG_REG61_TAG12_VA_SHIFT)
#define MH_DEBUG_REG61_SET_TAG_valid_q_12(mh_debug_reg61_reg, tag_valid_q_12) \
     mh_debug_reg61_reg = (mh_debug_reg61_reg & ~MH_DEBUG_REG61_TAG_valid_q_12_MASK) | (tag_valid_q_12 << MH_DEBUG_REG61_TAG_valid_q_12_SHIFT)
#define MH_DEBUG_REG61_SET_ALWAYS_ZERO(mh_debug_reg61_reg, always_zero) \
     mh_debug_reg61_reg = (mh_debug_reg61_reg & ~MH_DEBUG_REG61_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG61_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG61_SET_TAG13_VA(mh_debug_reg61_reg, tag13_va) \
     mh_debug_reg61_reg = (mh_debug_reg61_reg & ~MH_DEBUG_REG61_TAG13_VA_MASK) | (tag13_va << MH_DEBUG_REG61_TAG13_VA_SHIFT)
#define MH_DEBUG_REG61_SET_TAG_valid_q_13(mh_debug_reg61_reg, tag_valid_q_13) \
     mh_debug_reg61_reg = (mh_debug_reg61_reg & ~MH_DEBUG_REG61_TAG_valid_q_13_MASK) | (tag_valid_q_13 << MH_DEBUG_REG61_TAG_valid_q_13_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg61_t {
          unsigned int tag12_va                       : MH_DEBUG_REG61_TAG12_VA_SIZE;
          unsigned int tag_valid_q_12                 : MH_DEBUG_REG61_TAG_valid_q_12_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG61_ALWAYS_ZERO_SIZE;
          unsigned int tag13_va                       : MH_DEBUG_REG61_TAG13_VA_SIZE;
          unsigned int tag_valid_q_13                 : MH_DEBUG_REG61_TAG_valid_q_13_SIZE;
          unsigned int                                : 2;
     } mh_debug_reg61_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg61_t {
          unsigned int                                : 2;
          unsigned int tag_valid_q_13                 : MH_DEBUG_REG61_TAG_valid_q_13_SIZE;
          unsigned int tag13_va                       : MH_DEBUG_REG61_TAG13_VA_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG61_ALWAYS_ZERO_SIZE;
          unsigned int tag_valid_q_12                 : MH_DEBUG_REG61_TAG_valid_q_12_SIZE;
          unsigned int tag12_va                       : MH_DEBUG_REG61_TAG12_VA_SIZE;
     } mh_debug_reg61_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg61_t f;
} mh_debug_reg61_u;


/*
 * MH_DEBUG_REG62 struct
 */

#define MH_DEBUG_REG62_TAG14_VA_SIZE   13
#define MH_DEBUG_REG62_TAG_valid_q_14_SIZE 1
#define MH_DEBUG_REG62_ALWAYS_ZERO_SIZE 2
#define MH_DEBUG_REG62_TAG15_VA_SIZE   13
#define MH_DEBUG_REG62_TAG_valid_q_15_SIZE 1

#define MH_DEBUG_REG62_TAG14_VA_SHIFT  0
#define MH_DEBUG_REG62_TAG_valid_q_14_SHIFT 13
#define MH_DEBUG_REG62_ALWAYS_ZERO_SHIFT 14
#define MH_DEBUG_REG62_TAG15_VA_SHIFT  16
#define MH_DEBUG_REG62_TAG_valid_q_15_SHIFT 29

#define MH_DEBUG_REG62_TAG14_VA_MASK   0x00001fff
#define MH_DEBUG_REG62_TAG_valid_q_14_MASK 0x00002000
#define MH_DEBUG_REG62_ALWAYS_ZERO_MASK 0x0000c000
#define MH_DEBUG_REG62_TAG15_VA_MASK   0x1fff0000
#define MH_DEBUG_REG62_TAG_valid_q_15_MASK 0x20000000

#define MH_DEBUG_REG62_MASK \
     (MH_DEBUG_REG62_TAG14_VA_MASK | \
      MH_DEBUG_REG62_TAG_valid_q_14_MASK | \
      MH_DEBUG_REG62_ALWAYS_ZERO_MASK | \
      MH_DEBUG_REG62_TAG15_VA_MASK | \
      MH_DEBUG_REG62_TAG_valid_q_15_MASK)

#define MH_DEBUG_REG62(tag14_va, tag_valid_q_14, always_zero, tag15_va, tag_valid_q_15) \
     ((tag14_va << MH_DEBUG_REG62_TAG14_VA_SHIFT) | \
      (tag_valid_q_14 << MH_DEBUG_REG62_TAG_valid_q_14_SHIFT) | \
      (always_zero << MH_DEBUG_REG62_ALWAYS_ZERO_SHIFT) | \
      (tag15_va << MH_DEBUG_REG62_TAG15_VA_SHIFT) | \
      (tag_valid_q_15 << MH_DEBUG_REG62_TAG_valid_q_15_SHIFT))

#define MH_DEBUG_REG62_GET_TAG14_VA(mh_debug_reg62) \
     ((mh_debug_reg62 & MH_DEBUG_REG62_TAG14_VA_MASK) >> MH_DEBUG_REG62_TAG14_VA_SHIFT)
#define MH_DEBUG_REG62_GET_TAG_valid_q_14(mh_debug_reg62) \
     ((mh_debug_reg62 & MH_DEBUG_REG62_TAG_valid_q_14_MASK) >> MH_DEBUG_REG62_TAG_valid_q_14_SHIFT)
#define MH_DEBUG_REG62_GET_ALWAYS_ZERO(mh_debug_reg62) \
     ((mh_debug_reg62 & MH_DEBUG_REG62_ALWAYS_ZERO_MASK) >> MH_DEBUG_REG62_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG62_GET_TAG15_VA(mh_debug_reg62) \
     ((mh_debug_reg62 & MH_DEBUG_REG62_TAG15_VA_MASK) >> MH_DEBUG_REG62_TAG15_VA_SHIFT)
#define MH_DEBUG_REG62_GET_TAG_valid_q_15(mh_debug_reg62) \
     ((mh_debug_reg62 & MH_DEBUG_REG62_TAG_valid_q_15_MASK) >> MH_DEBUG_REG62_TAG_valid_q_15_SHIFT)

#define MH_DEBUG_REG62_SET_TAG14_VA(mh_debug_reg62_reg, tag14_va) \
     mh_debug_reg62_reg = (mh_debug_reg62_reg & ~MH_DEBUG_REG62_TAG14_VA_MASK) | (tag14_va << MH_DEBUG_REG62_TAG14_VA_SHIFT)
#define MH_DEBUG_REG62_SET_TAG_valid_q_14(mh_debug_reg62_reg, tag_valid_q_14) \
     mh_debug_reg62_reg = (mh_debug_reg62_reg & ~MH_DEBUG_REG62_TAG_valid_q_14_MASK) | (tag_valid_q_14 << MH_DEBUG_REG62_TAG_valid_q_14_SHIFT)
#define MH_DEBUG_REG62_SET_ALWAYS_ZERO(mh_debug_reg62_reg, always_zero) \
     mh_debug_reg62_reg = (mh_debug_reg62_reg & ~MH_DEBUG_REG62_ALWAYS_ZERO_MASK) | (always_zero << MH_DEBUG_REG62_ALWAYS_ZERO_SHIFT)
#define MH_DEBUG_REG62_SET_TAG15_VA(mh_debug_reg62_reg, tag15_va) \
     mh_debug_reg62_reg = (mh_debug_reg62_reg & ~MH_DEBUG_REG62_TAG15_VA_MASK) | (tag15_va << MH_DEBUG_REG62_TAG15_VA_SHIFT)
#define MH_DEBUG_REG62_SET_TAG_valid_q_15(mh_debug_reg62_reg, tag_valid_q_15) \
     mh_debug_reg62_reg = (mh_debug_reg62_reg & ~MH_DEBUG_REG62_TAG_valid_q_15_MASK) | (tag_valid_q_15 << MH_DEBUG_REG62_TAG_valid_q_15_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg62_t {
          unsigned int tag14_va                       : MH_DEBUG_REG62_TAG14_VA_SIZE;
          unsigned int tag_valid_q_14                 : MH_DEBUG_REG62_TAG_valid_q_14_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG62_ALWAYS_ZERO_SIZE;
          unsigned int tag15_va                       : MH_DEBUG_REG62_TAG15_VA_SIZE;
          unsigned int tag_valid_q_15                 : MH_DEBUG_REG62_TAG_valid_q_15_SIZE;
          unsigned int                                : 2;
     } mh_debug_reg62_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg62_t {
          unsigned int                                : 2;
          unsigned int tag_valid_q_15                 : MH_DEBUG_REG62_TAG_valid_q_15_SIZE;
          unsigned int tag15_va                       : MH_DEBUG_REG62_TAG15_VA_SIZE;
          unsigned int always_zero                    : MH_DEBUG_REG62_ALWAYS_ZERO_SIZE;
          unsigned int tag_valid_q_14                 : MH_DEBUG_REG62_TAG_valid_q_14_SIZE;
          unsigned int tag14_va                       : MH_DEBUG_REG62_TAG14_VA_SIZE;
     } mh_debug_reg62_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg62_t f;
} mh_debug_reg62_u;


/*
 * MH_DEBUG_REG63 struct
 */

#define MH_DEBUG_REG63_MH_DBG_DEFAULT_SIZE 32

#define MH_DEBUG_REG63_MH_DBG_DEFAULT_SHIFT 0

#define MH_DEBUG_REG63_MH_DBG_DEFAULT_MASK 0xffffffff

#define MH_DEBUG_REG63_MASK \
     (MH_DEBUG_REG63_MH_DBG_DEFAULT_MASK)

#define MH_DEBUG_REG63(mh_dbg_default) \
     ((mh_dbg_default << MH_DEBUG_REG63_MH_DBG_DEFAULT_SHIFT))

#define MH_DEBUG_REG63_GET_MH_DBG_DEFAULT(mh_debug_reg63) \
     ((mh_debug_reg63 & MH_DEBUG_REG63_MH_DBG_DEFAULT_MASK) >> MH_DEBUG_REG63_MH_DBG_DEFAULT_SHIFT)

#define MH_DEBUG_REG63_SET_MH_DBG_DEFAULT(mh_debug_reg63_reg, mh_dbg_default) \
     mh_debug_reg63_reg = (mh_debug_reg63_reg & ~MH_DEBUG_REG63_MH_DBG_DEFAULT_MASK) | (mh_dbg_default << MH_DEBUG_REG63_MH_DBG_DEFAULT_SHIFT)

#ifndef BIGENDIAN_OS

     typedef struct _mh_debug_reg63_t {
          unsigned int mh_dbg_default                 : MH_DEBUG_REG63_MH_DBG_DEFAULT_SIZE;
     } mh_debug_reg63_t;

#else   // !BIGENDIAN_OS

     typedef struct _mh_debug_reg63_t {
          unsigned int mh_dbg_default                 : MH_DEBUG_REG63_MH_DBG_DEFAULT_SIZE;
     } mh_debug_reg63_t;

#endif

typedef union {
     unsigned int val : 32;
     mh_debug_reg63_t f;
} mh_debug_reg63_u;


/*
 * MH_MMU_CONFIG struct
 */

#define MH_MMU_CONFIG_MMU_ENABLE_SIZE  1
#define MH_MMU_CONFIG_SPLIT_MODE_ENABLE_SIZE 1
#define MH_MMU_CONFIG_RESERVED1_SIZE   2
#define MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR_SIZE 2
#define MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR_SIZE 2
#define MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR_SIZE 2
#define MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR_SIZE 2
#define MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR_SIZE 2
#define MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR_SIZE 2
#define MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR_SIZE 2
#define MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR_SIZE 2
#define MH_MMU_CONFIG_VGT_R1_CLNT_BEHAVIOR_SIZE 2
#define MH_MMU_CONFIG_TC_R_CLNT_BEHAVIOR_SIZE 2
#define MH_MMU_CONFIG_PA_W_CLNT_BEHAVIOR_SIZE 2

#define MH_MMU_CONFIG_MMU_ENABLE_SHIFT 0
#define MH_MMU_CONFIG_SPLIT_MODE_ENABLE_SHIFT 1
#define MH_MMU_CONFIG_RESERVED1_SHIFT  2
#define MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR_SHIFT 4
#define MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR_SHIFT 6
#define MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR_SHIFT 8
#define MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR_SHIFT 10
#define MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR_SHIFT 12
#define MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR_SHIFT 14
#define MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR_SHIFT 16
#define MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR_SHIFT 18
#define MH_MMU_CONFIG_VGT_R1_CLNT_BEHAVIOR_SHIFT 20
#define MH_MMU_CONFIG_TC_R_CLNT_BEHAVIOR_SHIFT 22
#define MH_MMU_CONFIG_PA_W_CLNT_BEHAVIOR_SHIFT 24

#define MH_MMU_CONFIG_MMU_ENABLE_MASK  0x00000001
#define MH_MMU_CONFIG_SPLIT_MODE_ENABLE_MASK 0x00000002
#define MH_MMU_CONFIG_RESERVED1_MASK   0x0000000c
#define MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR_MASK 0x00000030
#define MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR_MASK 0x000000c0
#define MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR_MASK 0x00000300
#define MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR_MASK 0x00000c00
#define MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR_MASK 0x00003000
#define MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR_MASK 0x0000c000
#define MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR_MASK 0x00030000
#define MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR_MASK 0x000c0000
#define MH_MMU_CONFIG_VGT_R1_CLNT_BEHAVIOR_MASK 0x00300000
#define MH_MMU_CONFIG_TC_R_CLNT_BEHAVIOR_MASK 0x00c00000
#define MH_MMU_CONFIG_PA_W_CLNT_BEHAVIOR_MASK 0x03000000

#define MH_MMU_CONFIG_MASK \
     (MH_MMU_CONFIG_MMU_ENABLE_MASK | \
      MH_MMU_CONFIG_SPLIT_MODE_ENABLE_MASK | \
      MH_MMU_CONFIG_RESERVED1_MASK | \
      MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR_MASK | \
      MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR_MASK | \
      MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR_MASK | \
      MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR_MASK | \
      MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR_MASK | \
      MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR_MASK | \
      MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR_MASK | \
      MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR_MASK | \
      MH_MMU_CONFIG_VGT_R1_CLNT_BEHAVIOR_MASK | \
      MH_MMU_CONFIG_TC_R_CLNT_BEHAVIOR_MASK | \
      MH_MMU_CONFIG_PA_W_CLNT_BEHAVIOR_MASK)

#define MH_MMU_CONFIG(mmu_enable, split_mode_enable, reserved1, rb_w_clnt_behavior, cp_w_clnt_behavior, cp_r0_clnt_behavior, cp_r1_clnt_behavior, cp_r2_clnt_behavior, cp_r3_clnt_behavior, cp_r4_clnt_behavior, vgt_r0_clnt_behavior, vgt_r1_clnt_behavior, tc_r_clnt_behavior, pa_w_clnt_behavior) \
     ((mmu_enable << MH_MMU_CONFIG_MMU_ENABLE_SHIFT) | \
      (split_mode_enable << MH_MMU_CONFIG_SPLIT_MODE_ENABLE_SHIFT) | \
      (reserved1 << MH_MMU_CONFIG_RESERVED1_SHIFT) | \
      (rb_w_clnt_behavior << MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR_SHIFT) | \
      (cp_w_clnt_behavior << MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR_SHIFT) | \
      (cp_r0_clnt_behavior << MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR_SHIFT) | \
      (cp_r1_clnt_behavior << MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR_SHIFT) | \
      (cp_r2_clnt_behavior << MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR_SHIFT) | \
      (cp_r3_clnt_behavior << MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR_SHIFT) | \
      (cp_r4_clnt_behavior << MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR_SHIFT) | \
      (vgt_r0_clnt_behavior << MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR_SHIFT) | \
      (vgt_r1_clnt_behavior << MH_MMU_CONFIG_VGT_R1_CLNT_BEHAVIOR_SHIFT) | \
      (tc_r_clnt_behavior << MH_MMU_CONFIG_TC_R_CLNT_BEHAVIOR_SHIFT) | \
      (pa_w_clnt_behavior << MH_MMU_CONFIG_PA_W_CLNT_BEHAVIOR_SHIFT))

#define MH_MMU_CONFIG_GET_MMU_ENABLE(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_MMU_ENABLE_MASK) >> MH_MMU_CONFIG_MMU_ENABLE_SHIFT)
#define MH_MMU_CONFIG_GET_SPLIT_MODE_ENABLE(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_SPLIT_MODE_ENABLE_MASK) >> MH_MMU_CONFIG_SPLIT_MODE_ENABLE_SHIFT)
#define MH_MMU_CONFIG_GET_RESERVED1(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_RESERVED1_MASK) >> MH_MMU_CONFIG_RESERVED1_SHIFT)
#define MH_MMU_CONFIG_GET_RB_W_CLNT_BEHAVIOR(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR_MASK) >> MH_MMU_CONFIG_RB_W_CLNT_BEHAVIOR_SHIFT)
#define MH_MMU_CONFIG_GET_CP_W_CLNT_BEHAVIOR(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR_MASK) >> MH_MMU_CONFIG_CP_W_CLNT_BEHAVIOR_SHIFT)
#define MH_MMU_CONFIG_GET_CP_R0_CLNT_BEHAVIOR(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR_MASK) >> MH_MMU_CONFIG_CP_R0_CLNT_BEHAVIOR_SHIFT)
#define MH_MMU_CONFIG_GET_CP_R1_CLNT_BEHAVIOR(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR_MASK) >> MH_MMU_CONFIG_CP_R1_CLNT_BEHAVIOR_SHIFT)
#define MH_MMU_CONFIG_GET_CP_R2_CLNT_BEHAVIOR(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR_MASK) >> MH_MMU_CONFIG_CP_R2_CLNT_BEHAVIOR_SHIFT)
#define MH_MMU_CONFIG_GET_CP_R3_CLNT_BEHAVIOR(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR_MASK) >> MH_MMU_CONFIG_CP_R3_CLNT_BEHAVIOR_SHIFT)
#define MH_MMU_CONFIG_GET_CP_R4_CLNT_BEHAVIOR(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR_MASK) >> MH_MMU_CONFIG_CP_R4_CLNT_BEHAVIOR_SHIFT)
#define MH_MMU_CONFIG_GET_VGT_R0_CLNT_BEHAVIOR(mh_mmu_config) \
     ((mh_mmu_config & MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR_MASK) >> MH_MMU_CONFIG_VGT_R0_CLNT_BEHAVIOR_SHIFT)
#define MH_MMU_CO