/*
 * Copyright 2008 Freescale Semiconductor, Inc. All Rights Reserved.  */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  */

/*!
 * @file sdma_script_code.h
 * @brief This file contains functions of SDMA scripts code initialization
 *
 * The file was generated automatically. Based on sdma scripts library.
 *
 * @ingroup SDMA
 */
/*******************************************************************************

			SDMA RELEASE LABEL: 	"SS15_MARLEY"

*******************************************************************************/

#ifndef __SDMA_SCRIPT_CODE_H__
#define __SDMA_SCRIPT_CODE_H__

/*!
* SDMA ROM scripts start addresses and sizes
*/

#define start_ADDR	0
#define start_SIZE	20

#define core_ADDR	80
#define core_SIZE	232

#define common_ADDR	312
#define common_SIZE	330

#define ap_2_ap_ADDR	642
#define ap_2_ap_SIZE	41

#define app_2_mcu_ADDR	683
#define app_2_mcu_SIZE	64

#define mcu_2_app_ADDR	747
#define mcu_2_app_SIZE	70

#define uart_2_mcu_ADDR	817
#define uart_2_mcu_SIZE	75

#define shp_2_mcu_ADDR	892
#define shp_2_mcu_SIZE	69

#define mcu_2_shp_ADDR	961
#define mcu_2_shp_SIZE	72

#define uartsh_2_mcu_ADDR	1033
#define uartsh_2_mcu_SIZE	69

#define mcu_2_ata_ADDR	1102
#define mcu_2_ata_SIZE	81

#define ata_2_mcu_ADDR	1183
#define ata_2_mcu_SIZE	96

#define burstDMA__2__burstDMA_routine_ADDR	1279
#define burstDMA__2__burstDMA_routine_SIZE	227

#define test_ADDR	1506
#define test_SIZE	63

#define signature_ADDR	1023
#define signature_SIZE	1

/*!
* SDMA RAM scripts start addresses and sizes
*/

#define dptc_dvfs_ADDR	6144
#define dptc_dvfs_SIZE	270

#define ext_mem__ipu_ram_ADDR	6414
#define ext_mem__ipu_ram_SIZE	123

#define mcu_2_mshc_ADDR	6537
#define mcu_2_mshc_SIZE	54

#define mcu_2_spdif_marley_ADDR	6591
#define mcu_2_spdif_marley_SIZE	161

#define mshc_2_mcu_ADDR	6752
#define mshc_2_mcu_SIZE	54

/*!
* SDMA RAM image start address and size
*/

#define RAM_CODE_START_ADDR		6144
#define RAM_CODE_SIZE			662

/*!
* Buffer that holds the SDMA RAM image
*/
__attribute__ ((__aligned__(4)))
#ifndef CONFIG_XIP_KERNEL
const
#endif
static const short sdma_code[] = {
	0xc13c, 0x7d70, 0x0800, 0x0970, 0x0111, 0x5111, 0x5ac1, 0x5bc9,
	0x028e, 0xc14e, 0x068a, 0x7c66, 0x5dd9, 0x5ce1, 0x0bff, 0x0311,
	0x1bff, 0x03bc, 0x5bd1, 0x1a5c, 0x6ac3, 0x63c8, 0x0363, 0x7c05,
	0x036f, 0x7d27, 0x0374, 0x7c76, 0x9874, 0xd907, 0x3c06, 0x4c00,
	0x7df7, 0x028f, 0x1a04, 0x6a20, 0x620b, 0x6f20, 0x301f, 0x00aa,
	0x0462, 0x7c04, 0x4a00, 0x7d0b, 0x2001, 0x9837, 0x048a, 0x620b,
	0x2201, 0x1c01, 0x1801, 0x02dc, 0x7d02, 0x301f, 0x00aa, 0x048f,
	0x1c04, 0x6c04, 0x0488, 0x3c1f, 0x6c2b, 0x0045, 0x028e, 0x1a5c,
	0x9818, 0x058f, 0x1d0c, 0x6d20, 0x650b, 0x007d, 0x7c01, 0x1d08,
	0x007c, 0x7c01, 0x1d04, 0x6d20, 0x650b, 0x0488, 0x3c1f, 0x0417,
	0x0417, 0x0417, 0x0417, 0x059c, 0x6d20, 0x028e, 0x1a34, 0x6ad7,
	0x0488, 0x0804, 0x7802, 0x650b, 0x6dc8, 0x008c, 0x1a28, 0x6ad7,
	0x63c8, 0x034c, 0x6bc8, 0x54d1, 0x4c00, 0x7d06, 0x0065, 0x7c02,
	0x0101, 0x0025, 0x0400, 0x9814, 0x52c1, 0x53c9, 0x54e1, 0x0453,
	0xc159, 0x7d95, 0x0200, 0x9800, 0x55d9, 0x6d04, 0x54d1, 0x058a,
	0x2508, 0x6dc7, 0x0373, 0x7c03, 0x65c8, 0x6d0b, 0x2408, 0x0372,
	0x7c04, 0x65c8, 0x6d0b, 0x2408, 0x9889, 0x6cce, 0x65c8, 0x6d0a,
	0x2404, 0x6d28, 0x6504, 0x5dd9, 0x5cd1, 0x6ad7, 0x6ae3, 0x63c8,
	0x0334, 0x6bc8, 0x0370, 0x7cad, 0x0c60, 0x0411, 0x04bb, 0x4c00,
	0x7da8, 0x0410, 0x1c30, 0x0410, 0x04bb, 0x046d, 0x7d0a, 0x047d,
	0x7c03, 0x047c, 0x7c01, 0x9841, 0x003b, 0x003a, 0x0039, 0x0058,
	0x98b8, 0x047d, 0x7d03, 0x047c, 0x7d01, 0x9841, 0x005b, 0xd8fc,
	0x1d18, 0x6d20, 0x650b, 0x0510, 0x003a, 0x0039, 0x0038, 0x00ad,
	0xd907, 0x0c30, 0x0410, 0x04bb, 0x003c, 0x003d, 0x00ac, 0xd8fc,
	0x007b, 0x7c04, 0x003d, 0x003c, 0x1d0c, 0x98d9, 0x048f, 0x1c14,
	0x6c20, 0x640b, 0x4401, 0x7d04, 0x005d, 0x005c, 0x1d0c, 0x98d9,
	0x0310, 0x3b30, 0x4b30, 0x7d01, 0x1b10, 0x0310, 0x003d, 0x003c,
	0x00ab, 0x6ad7, 0x63c8, 0x6d20, 0x650b, 0x0560, 0x7d03, 0x005e,
	0xd8f0, 0x9841, 0x003e, 0x0c80, 0x0410, 0x0394, 0xd8f0, 0x640b,
	0x037f, 0x7d02, 0x1a14, 0x98ed, 0x1a0c, 0x6ad7, 0x6cc8, 0x9841,
	0x0c7f, 0x0410, 0x03b4, 0x04b8, 0x03ac, 0x640b, 0x6bc8, 0x028e,
	0x1a04, 0x6ad7, 0x6cc8, 0x0006, 0x058f, 0x1d08, 0x6d20, 0x650b,
	0x007d, 0x7c01, 0x1d38, 0x007c, 0x7c01, 0x1d1c, 0x0006, 0x048b,
	0x042c, 0x0454, 0x042b, 0x6ad7, 0x6cc8, 0x0006, 0x0e70, 0x0611,
	0x5616, 0xc13c, 0x7d2a, 0x5ade, 0x008e, 0xc14e, 0x7c26, 0x5be0,
	0x5ef0, 0x5ce8, 0x0688, 0x08ff, 0x0011, 0x28ff, 0x00bc, 0x53f6,
	0x05df, 0x7d0b, 0x6dc5, 0x03df, 0x7d03, 0x6bd5, 0xd95d, 0x9939,
	0x6b05, 0xc55f, 0x7e27, 0x7f29, 0x9939, 0x6d01, 0x03df, 0x7d05,
	0x6bd5, 0xc589, 0x7e18, 0x7f1a, 0x9939, 0x6b05, 0xc4ff, 0x7e07,
	0x7f06, 0x52de, 0x53e6, 0xc159, 0x7dd7, 0x0200, 0x9911, 0x0007,
	0x6004, 0x680c, 0x53f6, 0x028e, 0x00a3, 0xc256, 0x048b, 0x0498,
	0x0454, 0x068a, 0x9939, 0x0207, 0x680c, 0x6ddf, 0x0107, 0x68ff,
	0x60d0, 0x9942, 0x0207, 0x68ff, 0x6d28, 0x0107, 0x6004, 0x680c,
	0x9942, 0x0007, 0x68ff, 0x60d0, 0x9942, 0x0288, 0x03a5, 0x3b03,
	0x3d03, 0x4d00, 0x7d0a, 0x0804, 0x00a5, 0x00da, 0x7d1a, 0x02a0,
	0x7b01, 0x65d8, 0x7eee, 0x65ff, 0x7eec, 0x0804, 0x02d0, 0x7d11,
	0x4b00, 0x7c0f, 0x008a, 0x3003, 0x6dcf, 0x6bdf, 0x0015, 0x0015,
	0x7b02, 0x65d8, 0x0000, 0x7edd, 0x63ff, 0x7edb, 0x3a03, 0x6dcd,
	0x6bdd, 0x008a, 0x7b02, 0x65d8, 0x0000, 0x7ed3, 0x65ff, 0x7ed1,
	0x0006, 0xc1d9, 0x0b70, 0x0311, 0x5313, 0x58d3, 0x008b, 0x5efb,
	0xc13c, 0x7d2b, 0x5ac0, 0x5bc8, 0xc14e, 0x7c27, 0x6d01, 0x0388,
	0x0dff, 0x0511, 0x1dff, 0x05bc, 0x4d00, 0x7d1a, 0x0e70, 0x0611,
	0x522e, 0x02b9, 0x4a00, 0x7c07, 0x52fe, 0x50d3, 0x02b8, 0x4a00,
	0x7c02, 0x0400, 0x999e, 0x56fb, 0x620b, 0x7e06, 0x5a06, 0x7f06,
	0x0000, 0x2504, 0x7d05, 0x999e, 0x0007, 0x680c, 0x0007, 0x0454,
	0x008b, 0x52c0, 0x53c8, 0xc159, 0x7dd6, 0x0200, 0x9990, 0xc1d9,
	0xc1e3, 0x0800, 0x005f, 0x00ac, 0x58e3, 0x0478, 0x7d5c, 0x0479,
	0x7d01, 0x0515, 0x0515, 0xda38, 0xda57, 0x0479, 0x7d26, 0x54e3,
	0x047f, 0x7d12, 0x50eb, 0x56fb, 0x0015, 0x52db, 0x7806, 0x5402,
	0x5c06, 0x1a01, 0x5402, 0x5c26, 0x1a01, 0x54e3, 0x043f, 0x5ce3,
	0x4d00, 0x7d4e, 0x0479, 0x7d14, 0x047f, 0x7d01, 0xda57, 0x52f3,
	0x6a21, 0x56db, 0x7803, 0x620b, 0x5a06, 0x1e01, 0x7f34, 0x7e33,
	0x6200, 0x5af3, 0x047f, 0x7dde, 0x9a20, 0x54e3, 0x047f, 0x7cda,
	0x54e3, 0x047f, 0x7d01, 0xda57, 0x54eb, 0x0fff, 0x0711, 0x1fff,
	0x56db, 0x52f3, 0x6a21, 0x630b, 0x028b, 0x03bf, 0xda32, 0x5b06,
	0x2401, 0x4c00, 0x7d0b, 0x1e01, 0x038a, 0x03b7, 0x0312, 0x0312,
	0xda32, 0x5b06, 0x1e01, 0x2401, 0x4c00, 0x7ced, 0x0b70, 0x0311,
	0x5313, 0x7f09, 0x7e08, 0x6200, 0x5af3, 0x54e3, 0x047f, 0x7db2,
	0x57db, 0xc1fa, 0x99cd, 0x0007, 0x680c, 0x54e3, 0x0478, 0x7c02,
	0x0800, 0x9a2e, 0x0479, 0x7d01, 0x0517, 0x0517, 0x5deb, 0xc213,
	0xc20a, 0x99c1, 0x0808, 0x7801, 0x0317, 0x0006, 0x020a, 0x0006,
	0x070a, 0xda36, 0x1a05, 0x0215, 0x5adb, 0x0708, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x080c,
	0x00d5, 0x7d01, 0x008d, 0x05a0, 0x4800, 0x7dd2, 0x58eb, 0x0006,
	0xc1d9, 0x0b70, 0x0311, 0x5313, 0x58d3, 0x008b, 0x5efb, 0xc13c,
	0x7d2b, 0x5ac0, 0x5bc8, 0xc14e, 0x7c27, 0x0388, 0x6d05, 0x0dff,
	0x0511, 0x1dff, 0x05bc, 0x4d00, 0x7d1a, 0x0e70, 0x0611, 0x522e,
	0x02b9, 0x4a00, 0x7c07, 0x52fe, 0x50d3, 0x02b8, 0x4a00, 0x7c02,
	0x0400, 0x9a75, 0x56fb, 0x5206, 0x7e08, 0x6a0b, 0x6a28, 0x7f04,
	0x0000, 0x2504, 0x7d04, 0x9a75, 0x680c, 0x0007, 0x0454, 0x008b,
	0x52c0, 0x53c8, 0xc159, 0x7dd6, 0x0200, 0x9a67
};
#endif
