/*
 * STMP IR Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 */

#ifndef __ARCH_ARM___IR_H
#define __ARCH_ARM___IR_H  1

#define REGS_IR_BASE (STMP3XXX_REGS_BASE + 0x78000)
#define REGS_IR_PHYS (0x80078000)
#define REGS_IR_SIZE 0x00002000

#define HW_IR_CTRL	(0x00000000)
#define HW_IR_CTRL_SET	(0x00000004)
#define HW_IR_CTRL_CLR	(0x00000008)
#define HW_IR_CTRL_TOG	(0x0000000c)
#define HW_IR_CTRL_ADDR  \
		(REGS_IR_BASE + HW_IR_CTRL)
#define HW_IR_CTRL_SET_ADDR \
		(REGS_IR_BASE + HW_IR_CTRL_SET)
#define HW_IR_CTRL_CLR_ADDR \
		(REGS_IR_BASE + HW_IR_CTRL_CLR)
#define HW_IR_CTRL_TOG_ADDR \
		(REGS_IR_BASE + HW_IR_CTRL_TOG)

#define BM_IR_CTRL_SFTRST	0x80000000
#define BV_IR_CTRL_SFTRST__RUN   0x0
#define BV_IR_CTRL_SFTRST__RESET 0x1
#define BM_IR_CTRL_CLKGATE	0x40000000
#define BP_IR_CTRL_RSVD2	27
#define BM_IR_CTRL_RSVD2	0x38000000
#define BF_IR_CTRL_RSVD2(v)  \
		(((v) << 27) & BM_IR_CTRL_RSVD2)
#define BP_IR_CTRL_MTA	24
#define BM_IR_CTRL_MTA	0x07000000
#define BF_IR_CTRL_MTA(v)  \
		(((v) << 24) & BM_IR_CTRL_MTA)
#define BV_IR_CTRL_MTA__MTA_10MS  0x0
#define BV_IR_CTRL_MTA__MTA_5MS   0x1
#define BV_IR_CTRL_MTA__MTA_1MS   0x2
#define BV_IR_CTRL_MTA__MTA_500US 0x3
#define BV_IR_CTRL_MTA__MTA_100US 0x4
#define BV_IR_CTRL_MTA__MTA_50US  0x5
#define BV_IR_CTRL_MTA__MTA_10US  0x6
#define BV_IR_CTRL_MTA__MTA_0     0x7
#define BP_IR_CTRL_MODE	22
#define BM_IR_CTRL_MODE	0x00C00000
#define BF_IR_CTRL_MODE(v)  \
		(((v) << 22) & BM_IR_CTRL_MODE)
#define BV_IR_CTRL_MODE__SIR  0x0
#define BV_IR_CTRL_MODE__MIR  0x1
#define BV_IR_CTRL_MODE__FIR  0x2
#define BV_IR_CTRL_MODE__VFIR 0x3
#define BP_IR_CTRL_SPEED	19
#define BM_IR_CTRL_SPEED	0x00380000
#define BF_IR_CTRL_SPEED(v)  \
		(((v) << 19) & BM_IR_CTRL_SPEED)
#define BV_IR_CTRL_SPEED__SPD000 0x0
#define BV_IR_CTRL_SPEED__SPD001 0x1
#define BV_IR_CTRL_SPEED__SPD010 0x2
#define BV_IR_CTRL_SPEED__SPD011 0x3
#define BV_IR_CTRL_SPEED__SPD100 0x4
#define BV_IR_CTRL_SPEED__SPD101 0x5
#define BP_IR_CTRL_RSVD1	14
#define BM_IR_CTRL_RSVD1	0x0007C000
#define BF_IR_CTRL_RSVD1(v)  \
		(((v) << 14) & BM_IR_CTRL_RSVD1)
#define BP_IR_CTRL_TC_TIME_DIV	8
#define BM_IR_CTRL_TC_TIME_DIV	0x00003F00
#define BF_IR_CTRL_TC_TIME_DIV(v)  \
		(((v) << 8) & BM_IR_CTRL_TC_TIME_DIV)
#define BM_IR_CTRL_TC_TYPE	0x00000080
#define BP_IR_CTRL_SIR_GAP	4
#define BM_IR_CTRL_SIR_GAP	0x00000070
#define BF_IR_CTRL_SIR_GAP(v)  \
		(((v) << 4) & BM_IR_CTRL_SIR_GAP)
#define BV_IR_CTRL_SIR_GAP__GAP_10K 0x0
#define BV_IR_CTRL_SIR_GAP__GAP_5K  0x1
#define BV_IR_CTRL_SIR_GAP__GAP_1K  0x2
#define BV_IR_CTRL_SIR_GAP__GAP_500 0x3
#define BV_IR_CTRL_SIR_GAP__GAP_100 0x4
#define BV_IR_CTRL_SIR_GAP__GAP_50  0x5
#define BV_IR_CTRL_SIR_GAP__GAP_10  0x6
#define BV_IR_CTRL_SIR_GAP__GAP_0   0x7
#define BM_IR_CTRL_SIPEN	0x00000008
#define BM_IR_CTRL_TCEN	0x00000004
#define BM_IR_CTRL_TXEN	0x00000002
#define BM_IR_CTRL_RXEN	0x00000001

#define HW_IR_TXDMA	(0x00000010)
#define HW_IR_TXDMA_SET	(0x00000014)
#define HW_IR_TXDMA_CLR	(0x00000018)
#define HW_IR_TXDMA_TOG	(0x0000001c)
#define HW_IR_TXDMA_ADDR  \
		(REGS_IR_BASE + HW_IR_TXDMA)
#define HW_IR_TXDMA_SET_ADDR \
		(REGS_IR_BASE + HW_IR_TXDMA_SET)
#define HW_IR_TXDMA_CLR_ADDR \
		(REGS_IR_BASE + HW_IR_TXDMA_CLR)
#define HW_IR_TXDMA_TOG_ADDR \
		(REGS_IR_BASE + HW_IR_TXDMA_TOG)

#define BM_IR_TXDMA_RUN	0x80000000
#define BM_IR_TXDMA_RSVD2	0x40000000
#define BM_IR_TXDMA_EMPTY	0x20000000
#define BM_IR_TXDMA_INT	0x10000000
#define BM_IR_TXDMA_CHANGE	0x08000000
#define BP_IR_TXDMA_NEW_MTA	24
#define BM_IR_TXDMA_NEW_MTA	0x07000000
#define BF_IR_TXDMA_NEW_MTA(v)  \
		(((v) << 24) & BM_IR_TXDMA_NEW_MTA)
#define BP_IR_TXDMA_NEW_MODE	22
#define BM_IR_TXDMA_NEW_MODE	0x00C00000
#define BF_IR_TXDMA_NEW_MODE(v)  \
		(((v) << 22) & BM_IR_TXDMA_NEW_MODE)
#define BP_IR_TXDMA_NEW_SPEED	19
#define BM_IR_TXDMA_NEW_SPEED	0x00380000
#define BF_IR_TXDMA_NEW_SPEED(v)  \
		(((v) << 19) & BM_IR_TXDMA_NEW_SPEED)
#define BM_IR_TXDMA_BOF_TYPE	0x00040000
#define BP_IR_TXDMA_XBOFS	12
#define BM_IR_TXDMA_XBOFS	0x0003F000
#define BF_IR_TXDMA_XBOFS(v)  \
		(((v) << 12) & BM_IR_TXDMA_XBOFS)
#define BP_IR_TXDMA_XFER_COUNT	0
#define BM_IR_TXDMA_XFER_COUNT	0x00000FFF
#define BF_IR_TXDMA_XFER_COUNT(v)  \
		(((v) << 0) & BM_IR_TXDMA_XFER_COUNT)

#define HW_IR_RXDMA	(0x00000020)
#define HW_IR_RXDMA_SET	(0x00000024)
#define HW_IR_RXDMA_CLR	(0x00000028)
#define HW_IR_RXDMA_TOG	(0x0000002c)
#define HW_IR_RXDMA_ADDR  \
		(REGS_IR_BASE + HW_IR_RXDMA)
#define HW_IR_RXDMA_SET_ADDR \
		(REGS_IR_BASE + HW_IR_RXDMA_SET)
#define HW_IR_RXDMA_CLR_ADDR \
		(REGS_IR_BASE + HW_IR_RXDMA_CLR)
#define HW_IR_RXDMA_TOG_ADDR \
		(REGS_IR_BASE + HW_IR_RXDMA_TOG)

#define BM_IR_RXDMA_RUN	0x80000000
#define BP_IR_RXDMA_RSVD	10
#define BM_IR_RXDMA_RSVD	0x7FFFFC00
#define BF_IR_RXDMA_RSVD(v)  \
		(((v) << 10) & BM_IR_RXDMA_RSVD)
#define BP_IR_RXDMA_XFER_COUNT	0
#define BM_IR_RXDMA_XFER_COUNT	0x000003FF
#define BF_IR_RXDMA_XFER_COUNT(v)  \
		(((v) << 0) & BM_IR_RXDMA_XFER_COUNT)

#define HW_IR_DBGCTRL	(0x00000030)
#define HW_IR_DBGCTRL_SET	(0x00000034)
#define HW_IR_DBGCTRL_CLR	(0x00000038)
#define HW_IR_DBGCTRL_TOG	(0x0000003c)
#define HW_IR_DBGCTRL_ADDR  \
		(REGS_IR_BASE + HW_IR_DBGCTRL)
#define HW_IR_DBGCTRL_SET_ADDR \
		(REGS_IR_BASE + HW_IR_DBGCTRL_SET)
#define HW_IR_DBGCTRL_CLR_ADDR \
		(REGS_IR_BASE + HW_IR_DBGCTRL_CLR)
#define HW_IR_DBGCTRL_TOG_ADDR \
		(REGS_IR_BASE + HW_IR_DBGCTRL_TOG)

#define BP_IR_DBGCTRL_RSVD2	13
#define BM_IR_DBGCTRL_RSVD2	0xFFFFE000
#define BF_IR_DBGCTRL_RSVD2(v) \
		(((v) << 13) & BM_IR_DBGCTRL_RSVD2)
#define BM_IR_DBGCTRL_VFIRSWZ	0x00001000
#define BV_IR_DBGCTRL_VFIRSWZ__NORMAL 0
#define BV_IR_DBGCTRL_VFIRSWZ__SWAP   1
#define BM_IR_DBGCTRL_RXFRMOFF	0x00000800
#define BM_IR_DBGCTRL_RXCRCOFF	0x00000400
#define BM_IR_DBGCTRL_RXINVERT	0x00000200
#define BM_IR_DBGCTRL_TXFRMOFF	0x00000100
#define BM_IR_DBGCTRL_TXCRCOFF	0x00000080
#define BM_IR_DBGCTRL_TXINVERT	0x00000040
#define BM_IR_DBGCTRL_INTLOOPBACK	0x00000020
#define BM_IR_DBGCTRL_DUPLEX	0x00000010
#define BM_IR_DBGCTRL_MIO_RX	0x00000008
#define BM_IR_DBGCTRL_MIO_TX	0x00000004
#define BM_IR_DBGCTRL_MIO_SCLK	0x00000002
#define BM_IR_DBGCTRL_MIO_EN	0x00000001

#define HW_IR_INTR	(0x00000040)
#define HW_IR_INTR_SET	(0x00000044)
#define HW_IR_INTR_CLR	(0x00000048)
#define HW_IR_INTR_TOG	(0x0000004c)
#define HW_IR_INTR_ADDR  \
		(REGS_IR_BASE + HW_IR_INTR)
#define HW_IR_INTR_SET_ADDR \
		(REGS_IR_BASE + HW_IR_INTR_SET)
#define HW_IR_INTR_CLR_ADDR \
		(REGS_IR_BASE + HW_IR_INTR_CLR)
#define HW_IR_INTR_TOG_ADDR \
		(REGS_IR_BASE + HW_IR_INTR_TOG)

#define BP_IR_INTR_RSVD2	23
#define BM_IR_INTR_RSVD2	0xFF800000
#define BF_IR_INTR_RSVD2(v) \
		(((v) << 23) & BM_IR_INTR_RSVD2)
#define BM_IR_INTR_RXABORT_IRQ_EN	0x00400000
#define BV_IR_INTR_RXABORT_IRQ_EN__DISABLED 0x0
#define BV_IR_INTR_RXABORT_IRQ_EN__ENABLED  0x1
#define BM_IR_INTR_SPEED_IRQ_EN	0x00200000
#define BV_IR_INTR_SPEED_IRQ_EN__DISABLED 0x0
#define BV_IR_INTR_SPEED_IRQ_EN__ENABLED  0x1
#define BM_IR_INTR_RXOF_IRQ_EN	0x00100000
#define BV_IR_INTR_RXOF_IRQ_EN__DISABLED 0x0
#define BV_IR_INTR_RXOF_IRQ_EN__ENABLED  0x1
#define BM_IR_INTR_TXUF_IRQ_EN	0x00080000
#define BV_IR_INTR_TXUF_IRQ_EN__DISABLED 0x0
#define BV_IR_INTR_TXUF_IRQ_EN__ENABLED  0x1
#define BM_IR_INTR_TC_IRQ_EN	0x00040000
#define BV_IR_INTR_TC_IRQ_EN__DISABLED 0x0
#define BV_IR_INTR_TC_IRQ_EN__ENABLED  0x1
#define BM_IR_INTR_RX_IRQ_EN	0x00020000
#define BV_IR_INTR_RX_IRQ_EN__DISABLED 0x0
#define BV_IR_INTR_RX_IRQ_EN__ENABLED  0x1
#define BM_IR_INTR_TX_IRQ_EN	0x00010000
#define BV_IR_INTR_TX_IRQ_EN__DISABLED 0x0
#define BV_IR_INTR_TX_IRQ_EN__ENABLED  0x1
#define BP_IR_INTR_RSVD1	7
#define BM_IR_INTR_RSVD1	0x0000FF80
#define BF_IR_INTR_RSVD1(v)  \
		(((v) << 7) & BM_IR_INTR_RSVD1)
#define BM_IR_INTR_RXABORT_IRQ	0x00000040
#define BV_IR_INTR_RXABORT_IRQ__NO_REQUEST 0x0
#define BV_IR_INTR_RXABORT_IRQ__REQUEST    0x1
#define BM_IR_INTR_SPEED_IRQ	0x00000020
#define BV_IR_INTR_SPEED_IRQ__NO_REQUEST 0x0
#define BV_IR_INTR_SPEED_IRQ__REQUEST    0x1
#define BM_IR_INTR_RXOF_IRQ	0x00000010
#define BV_IR_INTR_RXOF_IRQ__NO_REQUEST 0x0
#define BV_IR_INTR_RXOF_IRQ__REQUEST    0x1
#define BM_IR_INTR_TXUF_IRQ	0x00000008
#define BV_IR_INTR_TXUF_IRQ__NO_REQUEST 0x0
#define BV_IR_INTR_TXUF_IRQ__REQUEST    0x1
#define BM_IR_INTR_TC_IRQ	0x00000004
#define BV_IR_INTR_TC_IRQ__NO_REQUEST 0x0
#define BV_IR_INTR_TC_IRQ__REQUEST    0x1
#define BM_IR_INTR_RX_IRQ	0x00000002
#define BV_IR_INTR_RX_IRQ__NO_REQUEST 0x0
#define BV_IR_INTR_RX_IRQ__REQUEST    0x1
#define BM_IR_INTR_TX_IRQ	0x00000001
#define BV_IR_INTR_TX_IRQ__NO_REQUEST 0x0
#define BV_IR_INTR_TX_IRQ__REQUEST    0x1

#define HW_IR_DATA	(0x00000050)
#define HW_IR_DATA_ADDR \
		(REGS_IR_BASE + HW_IR_DATA)

#define BP_IR_DATA_DATA	0
#define BM_IR_DATA_DATA	0xFFFFFFFF
#define BF_IR_DATA_DATA(v)	(v)

#define HW_IR_STAT	(0x00000060)
#define HW_IR_STAT_ADDR \
		(REGS_IR_BASE + HW_IR_STAT)

#define BM_IR_STAT_PRESENT	0x80000000
#define BV_IR_STAT_PRESENT__UNAVAILABLE 0x0
#define BV_IR_STAT_PRESENT__AVAILABLE   0x1
#define BP_IR_STAT_MODE_ALLOWED	29
#define BM_IR_STAT_MODE_ALLOWED	0x60000000
#define BF_IR_STAT_MODE_ALLOWED(v)  \
		(((v) << 29) & BM_IR_STAT_MODE_ALLOWED)
#define BV_IR_STAT_MODE_ALLOWED__VFIR 0x0
#define BV_IR_STAT_MODE_ALLOWED__FIR  0x1
#define BV_IR_STAT_MODE_ALLOWED__MIR  0x2
#define BV_IR_STAT_MODE_ALLOWED__SIR  0x3
#define BM_IR_STAT_ANY_IRQ	0x10000000
#define BV_IR_STAT_ANY_IRQ__NO_REQUEST 0x0
#define BV_IR_STAT_ANY_IRQ__REQUEST    0x1
#define BP_IR_STAT_RSVD2	23
#define BM_IR_STAT_RSVD2	0x0F800000
#define BF_IR_STAT_RSVD2(v)  \
		(((v) << 23) & BM_IR_STAT_RSVD2)
#define BM_IR_STAT_RXABORT_SUMMARY	0x00400000
#define BV_IR_STAT_RXABORT_SUMMARY__NO_REQUEST 0x0
#define BV_IR_STAT_RXABORT_SUMMARY__REQUEST    0x1
#define BM_IR_STAT_SPEED_SUMMARY	0x00200000
#define BV_IR_STAT_SPEED_SUMMARY__NO_REQUEST 0x0
#define BV_IR_STAT_SPEED_SUMMARY__REQUEST    0x1
#define BM_IR_STAT_RXOF_SUMMARY	0x00100000
#define BV_IR_STAT_RXOF_SUMMARY__NO_REQUEST 0x0
#define BV_IR_STAT_RXOF_SUMMARY__REQUEST    0x1
#define BM_IR_STAT_TXUF_SUMMARY	0x00080000
#define BV_IR_STAT_TXUF_SUMMARY__NO_REQUEST 0x0
#define BV_IR_STAT_TXUF_SUMMARY__REQUEST    0x1
#define BM_IR_STAT_TC_SUMMARY	0x00040000
#define BV_IR_STAT_TC_SUMMARY__NO_REQUEST 0x0
#define BV_IR_STAT_TC_SUMMARY__REQUEST    0x1
#define BM_IR_STAT_RX_SUMMARY	0x00020000
#define BV_IR_STAT_RX_SUMMARY__NO_REQUEST 0x0
#define BV_IR_STAT_RX_SUMMARY__REQUEST    0x1
#define BM_IR_STAT_TX_SUMMARY	0x00010000
#define BV_IR_STAT_TX_SUMMARY__NO_REQUEST 0x0
#define BV_IR_STAT_TX_SUMMARY__REQUEST    0x1
#define BP_IR_STAT_RSVD1	3
#define BM_IR_STAT_RSVD1	0x0000FFF8
#define BF_IR_STAT_RSVD1(v)  \
		(((v) << 3) & BM_IR_STAT_RSVD1)
#define BM_IR_STAT_MEDIA_BUSY	0x00000004
#define BM_IR_STAT_RX_ACTIVE	0x00000002
#define BM_IR_STAT_TX_ACTIVE	0x00000001

#define HW_IR_TCCTRL	(0x00000070)
#define HW_IR_TCCTRL_SET	(0x00000074)
#define HW_IR_TCCTRL_CLR	(0x00000078)
#define HW_IR_TCCTRL_TOG	(0x0000007c)
#define HW_IR_TCCTRL_ADDR  \
		(REGS_IR_BASE + HW_IR_TCCTRL)
#define HW_IR_TCCTRL_SET_ADDR \
		(REGS_IR_BASE + HW_IR_TCCTRL_SET)
#define HW_IR_TCCTRL_CLR_ADDR \
		(REGS_IR_BASE + HW_IR_TCCTRL_CLR)
#define HW_IR_TCCTRL_TOG_ADDR \
		(REGS_IR_BASE + HW_IR_TCCTRL_TOG)

#define BM_IR_TCCTRL_INIT	0x80000000
#define BM_IR_TCCTRL_GO	0x40000000
#define BM_IR_TCCTRL_BUSY	0x20000000
#define BP_IR_TCCTRL_RSVD	25
#define BM_IR_TCCTRL_RSVD	0x1E000000
#define BF_IR_TCCTRL_RSVD(v)  \
		(((v) << 25) & BM_IR_TCCTRL_RSVD)
#define BM_IR_TCCTRL_TEMIC	0x01000000
#define BV_IR_TCCTRL_TEMIC__LOW  0x0
#define BV_IR_TCCTRL_TEMIC__HIGH 0x1
#define BP_IR_TCCTRL_EXT_DATA	16
#define BM_IR_TCCTRL_EXT_DATA	0x00FF0000
#define BF_IR_TCCTRL_EXT_DATA(v)  \
		(((v) << 16) & BM_IR_TCCTRL_EXT_DATA)
#define BP_IR_TCCTRL_DATA	8
#define BM_IR_TCCTRL_DATA	0x0000FF00
#define BF_IR_TCCTRL_DATA(v)  \
		(((v) << 8) & BM_IR_TCCTRL_DATA)
#define BP_IR_TCCTRL_ADDR	5
#define BM_IR_TCCTRL_ADDR	0x000000E0
#define BF_IR_TCCTRL_ADDR(v)  \
		(((v) << 5) & BM_IR_TCCTRL_ADDR)
#define BP_IR_TCCTRL_INDX	1
#define BM_IR_TCCTRL_INDX	0x0000001E
#define BF_IR_TCCTRL_INDX(v)  \
		(((v) << 1) & BM_IR_TCCTRL_INDX)
#define BM_IR_TCCTRL_C	0x00000001

#define HW_IR_SI_READ	(0x00000080)
#define HW_IR_SI_READ_ADDR \
		(REGS_IR_BASE + HW_IR_SI_READ)

#define BP_IR_SI_READ_RSVD1	9
#define BM_IR_SI_READ_RSVD1	0xFFFFFE00
#define BF_IR_SI_READ_RSVD1(v) \
		(((v) << 9) & BM_IR_SI_READ_RSVD1)
#define BM_IR_SI_READ_ABORT	0x00000100
#define BP_IR_SI_READ_DATA	0
#define BM_IR_SI_READ_DATA	0x000000FF
#define BF_IR_SI_READ_DATA(v)  \
		(((v) << 0) & BM_IR_SI_READ_DATA)

#define HW_IR_DEBUG	(0x00000090)
#define HW_IR_DEBUG_ADDR \
		(REGS_IR_BASE + HW_IR_DEBUG)

#define BP_IR_DEBUG_RSVD1	6
#define BM_IR_DEBUG_RSVD1	0xFFFFFFC0
#define BF_IR_DEBUG_RSVD1(v) \
		(((v) << 6) & BM_IR_DEBUG_RSVD1)
#define BM_IR_DEBUG_TXDMAKICK	0x00000020
#define BM_IR_DEBUG_RXDMAKICK	0x00000010
#define BM_IR_DEBUG_TXDMAEND	0x00000008
#define BM_IR_DEBUG_RXDMAEND	0x00000004
#define BM_IR_DEBUG_TXDMAREQ	0x00000002
#define BM_IR_DEBUG_RXDMAREQ	0x00000001

#define HW_IR_VERSION	(0x000000a0)
#define HW_IR_VERSION_ADDR \
		(REGS_IR_BASE + HW_IR_VERSION)

#define BP_IR_VERSION_MAJOR	24
#define BM_IR_VERSION_MAJOR	0xFF000000
#define BF_IR_VERSION_MAJOR(v) \
		(((v) << 24) & BM_IR_VERSION_MAJOR)
#define BP_IR_VERSION_MINOR	16
#define BM_IR_VERSION_MINOR	0x00FF0000
#define BF_IR_VERSION_MINOR(v)  \
		(((v) << 16) & BM_IR_VERSION_MINOR)
#define BP_IR_VERSION_STEP	0
#define BM_IR_VERSION_STEP	0x0000FFFF
#define BF_IR_VERSION_STEP(v)  \
		(((v) << 0) & BM_IR_VERSION_STEP)
#endif /* __ARCH_ARM___IR_H */
